SUBROUTINE SULWN

!**** *SULWN*   - INITIALIZE COMMON YOELW

!     PURPOSE.
!     --------
!           INITIALIZE YOELW, THE COMMON THAT CONTAINS COEFFICIENTS
!           NEEDED TO RUN THE LONGWAVE RADIATION ROUTINES

!**   INTERFACE.
!     ----------
!        *CALL* *SULWN

!        EXPLICIT ARGUMENTS
!        --------------------
!        NONE

!        IMPLICIT ARGUMENTS
!        --------------------
!        COMMON YOELW

!     METHOD.
!     -------
!        SEE DOCUMENTATION

!     EXTERNALS.
!     ----------

!     REFERENCE.
!     ----------
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION

!     AUTHOR.
!     -------
!        JEAN-JACQUES MORCRETTE  *ECMWF*

!     MODIFICATIONS.
!     --------------
!        ORIGINAL : 88-12-15
!        J.-J. Morcrette ECMWF 951215: Pseudo-Voigt Line Profiles
!        97-04-25 J.J. Morcrette Revised Continuum coefficients
!        97-10-30 J.J. Morcrette cy18
!        M.Hamrud      01-Oct-2003 CY28 Cleaning

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOELW    , ONLY : MXIXT    ,NSIL     ,NIPD     ,NIPD2    ,&
 & NTR      ,NTRA     ,NUA      ,NG1      ,NG1P1    ,&
 & ALWT     ,BLWT     ,PDGA     ,PDGB     ,RPTYPE   ,&
 & RETYPE   ,RO1H     ,RO2H     ,RO3T     ,RPIALF0  ,&
 & RT1      ,TINTP    ,TREF     ,TSTAND   ,TSTP     ,&
 & WG1      ,XP       ,RVGCO2   ,RVGH2O   ,RVGO3  

IMPLICIT NONE

!     ------------------------------------------------------------------ 

!*       1.    FILL BLOCK DATA
!              ---------------

!-- REFERENCE TEMPERATURE FOR THE TRANSMISSIVITIES

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SULWN',0,ZHOOK_HANDLE)
TINTP = (/ 187.5_JPRB, 200._JPRB, 212.5_JPRB, 225._JPRB, 237.5_JPRB,  &
 & 250._JPRB,&
 & 262.5_JPRB, 275._JPRB, 287.5_JPRB, 300._JPRB, 312.5_JPRB /)  

!-- COEFFICIENTS OF THE POLYNOMIALS GIVING THE PLANCK FUNCTIONS

XP( :, 1) = (/&
 & 0.46430621E+02_JPRB, 0.12928299E+03_JPRB, 0.20732648E+03_JPRB,&
 & 0.31398411E+03_JPRB, 0.18373177E+03_JPRB,-0.11412303E+03_JPRB/)  
XP( :, 2) = (/&
 & 0.73604774E+02_JPRB, 0.27887914E+03_JPRB, 0.27076947E+03_JPRB,&
 & -.57322111E+02_JPRB,-0.64742459E+02_JPRB, 0.87238280E+02_JPRB/)  
XP( :, 3) = (/&
 & 0.37050866E+02_JPRB, 0.20498759E+03_JPRB, 0.37558029E+03_JPRB,&
 & 0.17401171E+03_JPRB,-0.13350302E+03_JPRB,-0.37651795E+02_JPRB/)  
XP( :, 4) = (/&
 & 0.14930141E+02_JPRB, 0.89161160E+02_JPRB, 0.17793062E+03_JPRB,&
 & 0.93433860E+02_JPRB,-0.70646020E+02_JPRB,-0.26373150E+02_JPRB/)  
XP( :, 5) = (/&
 & 0.40386780E+02_JPRB, 0.10855270E+03_JPRB, 0.50755010E+02_JPRB,&
 & -0.31496190E+02_JPRB, 0.12791300E+00_JPRB, 0.18017770E+01_JPRB/)  
XP( :, 6) = (/&
 & 0.90811926E+01_JPRB, 0.75073923E+02_JPRB, 0.24654438E+03_JPRB,&
 & 0.39332612E+03_JPRB, 0.29385281E+03_JPRB, 0.89107921E+02_JPRB/)  

!-----------------------------------------------------------------------
!  PADE APPROXIMANTS FOR THE TRANSMISSIVITIES

!--- WATER VAPOUR FROM ZHONG & HAIGH  (revision3 96-11-15)

!- H2O  0-350 cm-1

!----- INTERVAL = 1 ----- T =    187.50

PDGA( 1, 1,:) = (/&
 & 0.25000224E-02_JPRB, 0.18701843E-02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 1, 1,:) = (/&
 & 0.25000224E-02_JPRB, 0.61593968E-01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 1, 2,:) = (/&
 & 0.34131105E-02_JPRB, 0.55153039E-03_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 1, 2,:) = (/&
 & 0.34131105E-02_JPRB, 0.73127832E-01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 1 ----- T =    200.00

PDGA( 2, 1,:) = (/&
 & 0.26344616E-02_JPRB, 0.16894582E-02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 2, 1,:) = (/&
 & 0.26344616E-02_JPRB, 0.63633167E-01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 2, 2,:) = (/&
 & 0.36120928E-02_JPRB, 0.44720171E-03_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 2, 2,:) = (/&
 & 0.36120928E-02_JPRB, 0.75062171E-01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 1 ----- T =    212.50

PDGA( 3, 1,:) = (/&
 & 0.27743234E-02_JPRB, 0.15245487E-02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 3, 1,:) = (/&
 & 0.27743234E-02_JPRB, 0.65651733E-01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 3, 2,:) = (/&
 & 0.38453121E-02_JPRB, 0.42382776E-03_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 3, 2,:) = (/&
 & 0.38453121E-02_JPRB, 0.77088315E-01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 1 ----- T =    225.00

PDGA( 4, 1,:) = (/&
 & 0.29265376E-02_JPRB, 0.13719090E-02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 4, 1,:) = (/&
 & 0.29265376E-02_JPRB, 0.67739270E-01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 4, 2,:) = (/&
 & 0.41211460E-02_JPRB, 0.42401401E-03_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 4, 2,:) = (/&
 & 0.41211460E-02_JPRB, 0.79241307E-01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 1 ----- T =    237.50

PDGA( 5, 1,:) = (/&
 & 0.30979053E-02_JPRB, 0.12223308E-02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 5, 1,:) = (/&
 & 0.30979053E-02_JPRB, 0.69968340E-01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 5, 2,:) = (/&
 & 0.43966504E-02_JPRB, 0.67198946E-03_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 5, 2,:) = (/&
 & 0.43966504E-02_JPRB, 0.80947310E-01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 1 ----- T =    250.00

PDGA( 6, 1,:) = (/&
 & 0.32813184E-02_JPRB, 0.11573810E-02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 6, 1,:) = (/&
 & 0.32813184E-02_JPRB, 0.72183750E-01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 6, 2,:) = (/&
 & 0.46792452E-02_JPRB, 0.99691013E-03_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 6, 2,:) = (/&
 & 0.46792452E-02_JPRB, 0.82404099E-01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 1 ----- T =    262.50

PDGA( 7, 1,:) = (/&
 & 0.34869261E-02_JPRB, 0.11110812E-02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 7, 1,:) = (/&
 & 0.34869261E-02_JPRB, 0.74507149E-01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 7, 2,:) = (/&
 & 0.49313571E-02_JPRB, 0.15144806E-02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 7, 2,:) = (/&
 & 0.49313571E-02_JPRB, 0.83301687E-01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 1 ----- T =    275.00

PDGA( 8, 1,:) = (/&
 & 0.37169013E-02_JPRB, 0.10586459E-02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 8, 1,:) = (/&
 & 0.37169013E-02_JPRB, 0.76930655E-01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 8, 2,:) = (/&
 & 0.51606177E-02_JPRB, 0.20799953E-02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 8, 2,:) = (/&
 & 0.51606177E-02_JPRB, 0.83904484E-01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 1 ----- T =    287.50

PDGA( 9, 1,:) = (/&
 & 0.39482491E-02_JPRB, 0.11280761E-02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 9, 1,:) = (/&
 & 0.39482491E-02_JPRB, 0.79096624E-01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 9, 2,:) = (/&
 & 0.53608496E-02_JPRB, 0.26755638E-02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 9, 2,:) = (/&
 & 0.53608496E-02_JPRB, 0.84271466E-01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 1 ----- T =    300.00

PDGA(10, 1,:) = (/&
 & 0.41849825E-02_JPRB, 0.12500965E-02_JPRB, 0.00000000E+00_JPRB/)  
PDGB(10, 1,:) = (/&
 & 0.41849825E-02_JPRB, 0.81087000E-01_JPRB, 0.10000000E+01_JPRB/)  
PDGA(10, 2,:) = (/&
 & 0.55372909E-02_JPRB, 0.32512851E-02_JPRB, 0.00000000E+00_JPRB/)  
PDGB(10, 2,:) = (/&
 & 0.55372909E-02_JPRB, 0.84546756E-01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 1 ----- T =    312.50

PDGA(11, 1,:) = (/&
 & 0.44204714E-02_JPRB, 0.14195697E-02_JPRB, 0.00000000E+00_JPRB/)  
PDGB(11, 1,:) = (/&
 & 0.44204714E-02_JPRB, 0.82840020E-01_JPRB, 0.10000000E+01_JPRB/)  
PDGA(11, 2,:) = (/&
 & 0.56935299E-02_JPRB, 0.38054592E-02_JPRB, 0.00000000E+00_JPRB/)  
PDGB(11, 2,:) = (/&
 & 0.56935299E-02_JPRB, 0.84847060E-01_JPRB, 0.10000000E+01_JPRB/)  

!- H2O  500-800 cm-1

!----- INTERVAL = 2 ----- T =    187.50

PDGA( 1, 3,:) = (/&
 & 0.15053751E+01_JPRB, 0.45361026E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 1, 3,:) = (/&
 & 0.15053751E+01_JPRB, 0.15789584E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 1, 4,:) = (/&
 & 0.18920793E+01_JPRB, 0.53457554E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 1, 4,:) = (/&
 & 0.18920793E+01_JPRB, 0.18418304E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =    200.00

PDGA( 2, 3,:) = (/&
 & 0.15977537E+01_JPRB, 0.48084314E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 2, 3,:) = (/&
 & 0.15977537E+01_JPRB, 0.16476468E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 2, 4,:) = (/&
 & 0.20435568E+01_JPRB, 0.55893717E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 2, 4,:) = (/&
 & 0.20435568E+01_JPRB, 0.19386656E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =    212.50

PDGA( 3, 3,:) = (/&
 & 0.16913237E+01_JPRB, 0.50454053E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 3, 3,:) = (/&
 & 0.16913237E+01_JPRB, 0.17144170E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 3, 4,:) = (/&
 & 0.21978186E+01_JPRB, 0.57905459E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 3, 4,:) = (/&
 & 0.21978186E+01_JPRB, 0.20334044E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =    225.00

PDGA( 4, 3,:) = (/&
 & 0.17856476E+01_JPRB, 0.52514194E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 4, 3,:) = (/&
 & 0.17856476E+01_JPRB, 0.17792823E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 4, 4,:) = (/&
 & 0.23533355E+01_JPRB, 0.59558005E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 4, 4,:) = (/&
 & 0.23533355E+01_JPRB, 0.21256517E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =    237.50

PDGA( 5, 3,:) = (/&
 & 0.18802811E+01_JPRB, 0.54304459E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 5, 3,:) = (/&
 & 0.18802811E+01_JPRB, 0.18422412E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 5, 4,:) = (/&
 & 0.25086500E+01_JPRB, 0.60908958E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 5, 4,:) = (/&
 & 0.25086500E+01_JPRB, 0.22150389E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =    250.00

PDGA( 6, 3,:) = (/&
 & 0.19747954E+01_JPRB, 0.55860186E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 6, 3,:) = (/&
 & 0.19747954E+01_JPRB, 0.19032856E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 6, 4,:) = (/&
 & 0.26624407E+01_JPRB, 0.62008317E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 6, 4,:) = (/&
 & 0.26624407E+01_JPRB, 0.23012482E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =    262.50

PDGA( 7, 3,:) = (/&
 & 0.20687911E+01_JPRB, 0.57212480E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 7, 3,:) = (/&
 & 0.20687911E+01_JPRB, 0.19624068E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 7, 4,:) = (/&
 & 0.28135635E+01_JPRB, 0.62898892E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 7, 4,:) = (/&
 & 0.28135635E+01_JPRB, 0.23840281E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =    275.00

PDGA( 8, 3,:) = (/&
 & 0.21619083E+01_JPRB, 0.58388519E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 8, 3,:) = (/&
 & 0.21619083E+01_JPRB, 0.20195993E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 8, 4,:) = (/&
 & 0.29610693E+01_JPRB, 0.63616954E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 8, 4,:) = (/&
 & 0.29610693E+01_JPRB, 0.24631984E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =    287.50

PDGA( 9, 3,:) = (/&
 & 0.22538305E+01_JPRB, 0.59411934E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 9, 3,:) = (/&
 & 0.22538305E+01_JPRB, 0.20748638E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 9, 4,:) = (/&
 & 0.31042087E+01_JPRB, 0.64192944E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 9, 4,:) = (/&
 & 0.31042087E+01_JPRB, 0.25386513E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =    300.00

PDGA(10, 3,:) = (/&
 & 0.23442867E+01_JPRB, 0.60303198E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB(10, 3,:) = (/&
 & 0.23442867E+01_JPRB, 0.21282086E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA(10, 4,:) = (/&
 & 0.32424163E+01_JPRB, 0.64652280E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB(10, 4,:) = (/&
 & 0.32424163E+01_JPRB, 0.26103424E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =    312.50

PDGA(11, 3,:) = (/&
 & 0.24330507E+01_JPRB, 0.61080006E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB(11, 3,:) = (/&
 & 0.24330507E+01_JPRB, 0.21796505E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA(11, 4,:) = (/&
 & 0.33752974E+01_JPRB, 0.65016031E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB(11, 4,:) = (/&
 & 0.33752974E+01_JPRB, 0.26782849E+01_JPRB, 0.10000000E+01_JPRB/)  

!- WATER VAPOR - INT. 3 -- 800-970 + 1110-1250 CM-1 

!----- INTERVAL = 3 ----- T =    187.50

PDGA( 1, 7,:) = (/&
 & 0.14334746E+02_JPRB, 0.11649992E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 1, 7,:) = (/&
 & 0.14334746E+02_JPRB, 0.12059903E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 1, 8,:) = (/&
 & 0.11596027E+02_JPRB, 0.11051587E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 1, 8,:) = (/&
 & 0.11596027E+02_JPRB, 0.11390898E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 3 ----- T =    200.00

PDGA( 2, 7,:) = (/&
 & 0.12924521E+02_JPRB, 0.11365906E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 2, 7,:) = (/&
 & 0.12924521E+02_JPRB, 0.11739611E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 2, 8,:) = (/&
 & 0.10445365E+02_JPRB, 0.10682810E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 2, 8,:) = (/&
 & 0.10445365E+02_JPRB, 0.10993927E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 3 ----- T =    212.50

PDGA( 3, 7,:) = (/&
 & 0.11774060E+02_JPRB, 0.11080218E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 3, 7,:) = (/&
 & 0.11774060E+02_JPRB, 0.11424740E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 3, 8,:) = (/&
 & 0.95571840E+01_JPRB, 0.10328058E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 3, 8,:) = (/&
 & 0.95571840E+01_JPRB, 0.10618404E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 3 ----- T =    225.00

PDGA( 4, 7,:) = (/&
 & 0.10839967E+02_JPRB, 0.10800025E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 4, 7,:) = (/&
 & 0.10839967E+02_JPRB, 0.11121318E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 4, 8,:) = (/&
 & 0.88719975E+01_JPRB, 0.99930444E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 4, 8,:) = (/&
 & 0.88719975E+01_JPRB, 0.10268470E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 3 ----- T =    237.50

PDGA( 5, 7,:) = (/&
 & 0.10082160E+02_JPRB, 0.10529965E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 5, 7,:) = (/&
 & 0.10082160E+02_JPRB, 0.10832955E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 5, 8,:) = (/&
 & 0.83425443E+01_JPRB, 0.96805504E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 5, 8,:) = (/&
 & 0.83425443E+01_JPRB, 0.99456138E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 3 ----- T =    250.00

PDGA( 6, 7,:) = (/&
 & 0.94663507E+01_JPRB, 0.10272823E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 6, 7,:) = (/&
 & 0.94663507E+01_JPRB, 0.10561525E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 6, 8,:) = (/&
 & 0.79324712E+01_JPRB, 0.93914198E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 6, 8,:) = (/&
 & 0.79324712E+01_JPRB, 0.96496576E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 3 ----- T =    262.50

PDGA( 7, 7,:) = (/&
 & 0.89643981E+01_JPRB, 0.10030051E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 7, 7,:) = (/&
 & 0.89643981E+01_JPRB, 0.10307714E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 7, 8,:) = (/&
 & 0.76141974E+01_JPRB, 0.91252916E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 7, 8,:) = (/&
 & 0.76141974E+01_JPRB, 0.93794463E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 3 ----- T =    275.00

PDGA( 8, 7,:) = (/&
 & 0.85537123E+01_JPRB, 0.98021793E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 8, 7,:) = (/&
 & 0.85537123E+01_JPRB, 0.10071426E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 8, 8,:) = (/&
 & 0.73668729E+01_JPRB, 0.88811055E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 8, 8,:) = (/&
 & 0.73668729E+01_JPRB, 0.91333042E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 3 ----- T =    287.50

PDGA( 9, 7,:) = (/&
 & 0.82163567E+01_JPRB, 0.95891296E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 9, 7,:) = (/&
 & 0.82163567E+01_JPRB, 0.98520772E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 9, 8,:) = (/&
 & 0.71747025E+01_JPRB, 0.86574340E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 9, 8,:) = (/&
 & 0.71747025E+01_JPRB, 0.89093260E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 3 ----- T =    300.00

PDGA(10, 7,:) = (/&
 & 0.79381525E+01_JPRB, 0.93904375E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB(10, 7,:) = (/&
 & 0.79381525E+01_JPRB, 0.96487960E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA(10, 8,:) = (/&
 & 0.70256573E+01_JPRB, 0.84526940E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB(10, 8,:) = (/&
 & 0.70256573E+01_JPRB, 0.87055560E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 3 ----- T =    312.50

PDGA(11, 7,:) = (/&
 & 0.77078849E+01_JPRB, 0.92054098E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB(11, 7,:) = (/&
 & 0.77078849E+01_JPRB, 0.94605633E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA(11, 8,:) = (/&
 & 0.69105145E+01_JPRB, 0.82652769E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB(11, 8,:) = (/&
 & 0.69105145E+01_JPRB, 0.85200926E+01_JPRB, 0.10000000E+01_JPRB/)  

!-- WATER VAPOR --- 970 -1110 CM-1

!----- INTERVAL = 4 ----- T =    187.500

PDGA( 1, 9,:) = (/&
 & 0.94868790E+02_JPRB, 0.17437229E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 1, 9,:) = (/&
 & 0.94868790E+02_JPRB, 0.18796329E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 1,10,:) = (/&
 & 0.95419113E+02_JPRB, 0.17234291E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 1,10,:) = (/&
 & 0.95419113E+02_JPRB, 0.18632164E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =    200.000

PDGA( 2, 9,:) = (/&
 & 0.95143959E+02_JPRB, 0.17335575E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 2, 9,:) = (/&
 & 0.95143959E+02_JPRB, 0.18714111E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 2,10,:) = (/&
 & 0.95675995E+02_JPRB, 0.17129913E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 2,10,:) = (/&
 & 0.95675995E+02_JPRB, 0.18547161E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =    212.500

PDGA( 3, 9,:) = (/&
 & 0.95363609E+02_JPRB, 0.17245064E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 3, 9,:) = (/&
 & 0.95363609E+02_JPRB, 0.18640270E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 3,10,:) = (/&
 & 0.95911537E+02_JPRB, 0.17036016E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 3,10,:) = (/&
 & 0.95911537E+02_JPRB, 0.18470697E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =    225.000

PDGA( 4, 9,:) = (/&
 & 0.95551239E+02_JPRB, 0.17163479E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 4, 9,:) = (/&
 & 0.95551239E+02_JPRB, 0.18573282E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 4,10,:) = (/&
 & 0.96128136E+02_JPRB, 0.16952074E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 4,10,:) = (/&
 & 0.96128136E+02_JPRB, 0.18402708E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =    237.500

PDGA( 5, 9,:) = (/&
 & 0.95763680E+02_JPRB, 0.17089018E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 5, 9,:) = (/&
 & 0.95763680E+02_JPRB, 0.18513403E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 5,10,:) = (/&
 & 0.96294296E+02_JPRB, 0.16877150E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 5,10,:) = (/&
 & 0.96294296E+02_JPRB, 0.18341324E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =    250.000

PDGA( 6, 9,:) = (/&
 & 0.95913246E+02_JPRB, 0.17022213E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 6, 9,:) = (/&
 & 0.95913246E+02_JPRB, 0.18458538E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 6,10,:) = (/&
 & 0.96462036E+02_JPRB, 0.16808561E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 6,10,:) = (/&
 & 0.96462036E+02_JPRB, 0.18285398E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =    262.500

PDGA( 7, 9,:) = (/&
 & 0.96069473E+02_JPRB, 0.16961018E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 7, 9,:) = (/&
 & 0.96069473E+02_JPRB, 0.18408932E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 7,10,:) = (/&
 & 0.96610298E+02_JPRB, 0.16746571E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 7,10,:) = (/&
 & 0.96610298E+02_JPRB, 0.18234850E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =    275.000

PDGA( 8, 9,:) = (/&
 & 0.96201309E+02_JPRB, 0.16905493E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 8, 9,:) = (/&
 & 0.96201309E+02_JPRB, 0.18363655E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 8,10,:) = (/&
 & 0.96754684E+02_JPRB, 0.16690109E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 8,10,:) = (/&
 & 0.96754684E+02_JPRB, 0.18189079E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =    287.500

PDGA( 9, 9,:) = (/&
 & 0.96342339E+02_JPRB, 0.16853893E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 9, 9,:) = (/&
 & 0.96342339E+02_JPRB, 0.18321957E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 9,10,:) = (/&
 & 0.96883301E+02_JPRB, 0.16638573E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 9,10,:) = (/&
 & 0.96883301E+02_JPRB, 0.18147303E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =    300.000

PDGA(10, 9,:) = (/&
 & 0.96457764E+02_JPRB, 0.16806755E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB(10, 9,:) = (/&
 & 0.96457764E+02_JPRB, 0.18283590E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA(10,10,:) = (/&
 & 0.96989792E+02_JPRB, 0.16591677E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB(10,10,:) = (/&
 & 0.96989792E+02_JPRB, 0.18108814E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =    312.500

PDGA(11, 9,:) = (/&
 & 0.96549957E+02_JPRB, 0.16763689E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB(11, 9,:) = (/&
 & 0.96549957E+02_JPRB, 0.18248074E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA(11,10,:) = (/&
 & 0.97097275E+02_JPRB, 0.16548479E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB(11,10,:) = (/&
 & 0.97097275E+02_JPRB, 0.18073788E+02_JPRB, 0.10000000E+01_JPRB/)  

!-- WATER VAPOR -- INT.5 --  350- 500 CM-1 

!----- INTERVAL = 5 ----- T =    187.500

PDGA( 1, 5,:) = (/&
 & 0.13134047E+00_JPRB,-0.23649048E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 1, 5,:) = (/&
 & 0.13134047E+00_JPRB, 0.54008597E+00_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 1, 6,:) = (/&
 & 0.14049581E+00_JPRB,-0.26231026E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 1, 6,:) = (/&
 & 0.14049581E+00_JPRB, 0.54143775E+00_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 5 ----- T =    200.000

PDGA( 2, 5,:) = (/&
 & 0.13330981E+00_JPRB,-0.24178915E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 2, 5,:) = (/&
 & 0.13330981E+00_JPRB, 0.54094988E+00_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 2, 6,:) = (/&
 & 0.14229582E+00_JPRB,-0.26725627E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 2, 6,:) = (/&
 & 0.14229582E+00_JPRB, 0.54189402E+00_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 5 ----- T =    212.500

PDGA( 3, 5,:) = (/&
 & 0.13504511E+00_JPRB,-0.24650861E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 3, 5,:) = (/&
 & 0.13504511E+00_JPRB, 0.54169583E+00_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 3, 6,:) = (/&
 & 0.14384151E+00_JPRB,-0.27153090E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 3, 6,:) = (/&
 & 0.14384151E+00_JPRB, 0.54222512E+00_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 5 ----- T =    225.000

PDGA( 4, 5,:) = (/&
 & 0.13651314E+00_JPRB,-0.25044570E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 4, 5,:) = (/&
 & 0.13651314E+00_JPRB, 0.54191625E+00_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 4, 6,:) = (/&
 & 0.14517485E+00_JPRB,-0.27523417E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 4, 6,:) = (/&
 & 0.14517485E+00_JPRB, 0.54246801E+00_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 5 ----- T =    237.500

PDGA( 5, 5,:) = (/&
 & 0.13790466E+00_JPRB,-0.25431205E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 5, 5,:) = (/&
 & 0.13790466E+00_JPRB, 0.54262739E+00_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 5, 6,:) = (/&
 & 0.14633319E+00_JPRB,-0.27845515E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 5, 6,:) = (/&
 & 0.14633319E+00_JPRB, 0.54265642E+00_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 5 ----- T =    250.000

PDGA( 6, 5,:) = (/&
 & 0.13909847E+00_JPRB,-0.25759069E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 6, 5,:) = (/&
 & 0.13909847E+00_JPRB, 0.54293746E+00_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 6, 6,:) = (/&
 & 0.14734478E+00_JPRB,-0.28128289E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 6, 6,:) = (/&
 & 0.14734478E+00_JPRB, 0.54279846E+00_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 5 ----- T =    262.500

PDGA( 7, 5,:) = (/&
 & 0.14014673E+00_JPRB,-0.26045626E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 7, 5,:) = (/&
 & 0.14014673E+00_JPRB, 0.54306209E+00_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 7, 6,:) = (/&
 & 0.14823231E+00_JPRB,-0.28376250E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 7, 6,:) = (/&
 & 0.14823231E+00_JPRB, 0.54290944E+00_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 5 ----- T =    275.000

PDGA( 8, 5,:) = (/&
 & 0.14110570E+00_JPRB,-0.26310772E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 8, 5,:) = (/&
 & 0.14110570E+00_JPRB, 0.54324186E+00_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 8, 6,:) = (/&
 & 0.14901793E+00_JPRB,-0.28597040E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 8, 6,:) = (/&
 & 0.14901793E+00_JPRB, 0.54300690E+00_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 5 ----- T =    287.500

PDGA( 9, 5,:) = (/&
 & 0.14198618E+00_JPRB,-0.26556855E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 9, 5,:) = (/&
 & 0.14198618E+00_JPRB, 0.54346353E+00_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 9, 6,:) = (/&
 & 0.14971229E+00_JPRB,-0.28792191E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 9, 6,:) = (/&
 & 0.14971229E+00_JPRB, 0.54307669E+00_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 5 ----- T =    300.000

PDGA(10, 5,:) = (/&
 & 0.14277160E+00_JPRB,-0.26774861E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB(10, 5,:) = (/&
 & 0.14277160E+00_JPRB, 0.54357564E+00_JPRB, 0.10000000E+01_JPRB/)  
PDGA(10, 6,:) = (/&
 & 0.15033126E+00_JPRB,-0.28966904E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB(10, 6,:) = (/&
 & 0.15033126E+00_JPRB, 0.54313493E+00_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 5 ----- T =    312.500

PDGA(11, 5,:) = (/&
 & 0.14349319E+00_JPRB,-0.26976623E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB(11, 5,:) = (/&
 & 0.14349319E+00_JPRB, 0.54369903E+00_JPRB, 0.10000000E+01_JPRB/)  
PDGA(11, 6,:) = (/&
 & 0.15088280E+00_JPRB,-0.29121898E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB(11, 6,:) = (/&
 & 0.15088280E+00_JPRB, 0.54318237E+00_JPRB, 0.10000000E+01_JPRB/)  

!- WATER VAPOR - WINGS OF VIBRATION-ROTATION BAND - 1250-1450+1880-2820 -

!----- INTERVAL = 6 ----- T =    187.50

PDGA( 1,11,:) = (/&
 & 0.59891051E+00_JPRB, 0.12874948E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 1,11,:) = (/&
 & 0.59891051E+00_JPRB, 0.15230591E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 1,12,:) = (/&
 & 0.55131795E+00_JPRB, 0.32252772E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 1,12,:) = (/&
 & 0.55131795E+00_JPRB, 0.14332603E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 6 ----- T =    200.00

PDGA( 2,11,:) = (/&
 & 0.59891051E+00_JPRB, 0.12874948E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 2,11,:) = (/&
 & 0.59891051E+00_JPRB, 0.15230591E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 2,12,:) = (/&
 & 0.55131795E+00_JPRB, 0.32252772E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 2,12,:) = (/&
 & 0.55131795E+00_JPRB, 0.14332603E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 6 ----- T =    212.50

PDGA( 3,11,:) = (/&
 & 0.59891051E+00_JPRB, 0.12874948E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 3,11,:) = (/&
 & 0.59891051E+00_JPRB, 0.15230591E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 3,12,:) = (/&
 & 0.44063067E+00_JPRB, 0.91024989E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 3,12,:) = (/&
 & 0.44063067E+00_JPRB, 0.12039660E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 6 ----- T =    225.00

PDGA( 4,11,:) = (/&
 & 0.51061614E+00_JPRB, 0.59883548E-01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 4,11,:) = (/&
 & 0.51061614E+00_JPRB, 0.13461757E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 4,12,:) = (/&
 & 0.30439727E+00_JPRB, 0.15980470E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 4,12,:) = (/&
 & 0.30439727E+00_JPRB, 0.91241774E+00_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 6 ----- T =    237.50

PDGA( 5,11,:) = (/&
 & 0.40673842E+00_JPRB, 0.11398935E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 5,11,:) = (/&
 & 0.40673842E+00_JPRB, 0.11289965E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 5,12,:) = (/&
 & 0.15005620E+00_JPRB, 0.23446409E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 5,12,:) = (/&
 & 0.15005620E+00_JPRB, 0.58547602E+00_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 6 ----- T =    250.00

PDGA( 6,11,:) = (/&
 & 0.28375203E+00_JPRB, 0.17444874E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 6,11,:) = (/&
 & 0.28375203E+00_JPRB, 0.86693115E+00_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 6,12,:) = (/&
 & 0.51658133E-01_JPRB, 0.29464628E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 6,12,:) = (/&
 & 0.51658133E-01_JPRB, 0.40170363E+00_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 6 ----- T =    262.50

PDGA( 7,11,:) = (/&
 & 0.15136005E+00_JPRB, 0.23761536E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 7,11,:) = (/&
 & 0.15136005E+00_JPRB, 0.58911683E+00_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 7,12,:) = (/&
 & 0.18932679E-01_JPRB, 0.33516250E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 7,12,:) = (/&
 & 0.18932679E-01_JPRB, 0.36796152E+00_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 6 ----- T =    275.00

PDGA( 8,11,:) = (/&
 & 0.61752765E-01_JPRB, 0.28965454E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 8,11,:) = (/&
 & 0.61752765E-01_JPRB, 0.41975793E+00_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 8,12,:) = (/&
 & 0.79619427E-02_JPRB, 0.36873141E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 8,12,:) = (/&
 & 0.79619427E-02_JPRB, 0.37964009E+00_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 6 ----- T =    287.50

PDGA( 9,11,:) = (/&
 & 0.26192233E-01_JPRB, 0.32568668E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 9,11,:) = (/&
 & 0.26192233E-01_JPRB, 0.37385106E+00_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 9,12,:) = (/&
 & 0.40764469E-02_JPRB, 0.40137572E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 9,12,:) = (/&
 & 0.40764469E-02_JPRB, 0.40608889E+00_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 6 ----- T =    300.00

PDGA(10,11,:) = (/&
 & 0.12168738E-01_JPRB, 0.35455148E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB(10,11,:) = (/&
 & 0.12168738E-01_JPRB, 0.37329084E+00_JPRB, 0.10000000E+01_JPRB/)  
PDGA(10,12,:) = (/&
 & 0.23914061E-02_JPRB, 0.43615987E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB(10,12,:) = (/&
 & 0.23914061E-02_JPRB, 0.43919208E+00_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 6 ----- T =    312.50

PDGA(11,11,:) = (/&
 & 0.64195381E-02_JPRB, 0.38088067E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB(11,11,:) = (/&
 & 0.64195381E-02_JPRB, 0.38906156E+00_JPRB, 0.10000000E+01_JPRB/)  
PDGA(11,12,:) = (/&
 & 0.23914061E-02_JPRB, 0.43615987E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB(11,12,:) = (/&
 & 0.23914061E-02_JPRB, 0.43919208E+00_JPRB, 0.10000000E+01_JPRB/)  

!=======================================================================

!-- CARBON DIOXIDE       
!   ==============

!-- CO2 -- INT.2 -- 500-800 CM-1 --- FROM ABS225 ------------

!-- FIU = 0.8 + DMAX1(0.35,(7-IU)*0.9)  , X/T,  9

!----- INTERVAL = 2 ----- T =  187.5

!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
PDGA( 1,13,:) = (/&
 & 0.87668459E-01_JPRB, 0.13845511E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 1,13,:) = (/&
 & 0.87668459E-01_JPRB, 0.23203798E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 1,14,:) = (/&
 & 0.74878820E-01_JPRB, 0.11718758E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 1,14,:) = (/&
 & 0.74878820E-01_JPRB, 0.20206726E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =  200.0

!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
PDGA( 2,13,:) = (/&
 & 0.83754276E-01_JPRB, 0.13187042E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 2,13,:) = (/&
 & 0.83754276E-01_JPRB, 0.22288925E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 2,14,:) = (/&
 & 0.71650966E-01_JPRB, 0.11216131E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 2,14,:) = (/&
 & 0.71650966E-01_JPRB, 0.19441824E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =  212.5

!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
PDGA( 3,13,:) = (/&
 & 0.80460283E-01_JPRB, 0.12644396E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 3,13,:) = (/&
 & 0.80460283E-01_JPRB, 0.21515593E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 3,14,:) = (/&
 & 0.68979615E-01_JPRB, 0.10809473E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 3,14,:) = (/&
 & 0.68979615E-01_JPRB, 0.18807257E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =  225.0

!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
PDGA( 4,13,:) = (/&
 & 0.77659686E-01_JPRB, 0.12191543E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 4,13,:) = (/&
 & 0.77659686E-01_JPRB, 0.20855896E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 4,14,:) = (/&
 & 0.66745345E-01_JPRB, 0.10476396E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 4,14,:) = (/&
 & 0.66745345E-01_JPRB, 0.18275618E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =  237.5

!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
PDGA( 5,13,:) = (/&
 & 0.75257056E-01_JPRB, 0.11809511E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 5,13,:) = (/&
 & 0.75257056E-01_JPRB, 0.20288489E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 5,14,:) = (/&
 & 0.64857571E-01_JPRB, 0.10200373E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 5,14,:) = (/&
 & 0.64857571E-01_JPRB, 0.17825910E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =  250.0

!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
PDGA( 6,13,:) = (/&
 & 0.73179175E-01_JPRB, 0.11484154E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 6,13,:) = (/&
 & 0.73179175E-01_JPRB, 0.19796791E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 6,14,:) = (/&
 & 0.63248495E-01_JPRB, 0.99692726E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 6,14,:) = (/&
 & 0.63248495E-01_JPRB, 0.17442308E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =  262.5

!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
PDGA( 7,13,:) = (/&
 & 0.71369063E-01_JPRB, 0.11204723E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 7,13,:) = (/&
 & 0.71369063E-01_JPRB, 0.19367778E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 7,14,:) = (/&
 & 0.61866970E-01_JPRB, 0.97740923E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 7,14,:) = (/&
 & 0.61866970E-01_JPRB, 0.17112809E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =  275.0

!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
PDGA( 8,13,:) = (/&
 & 0.69781812E-01_JPRB, 0.10962918E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 8,13,:) = (/&
 & 0.69781812E-01_JPRB, 0.18991112E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 8,14,:) = (/&
 & 0.60673632E-01_JPRB, 0.96080188E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 8,14,:) = (/&
 & 0.60673632E-01_JPRB, 0.16828137E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =  287.5

!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
PDGA( 9,13,:) = (/&
 & 0.68381606E-01_JPRB, 0.10752229E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 9,13,:) = (/&
 & 0.68381606E-01_JPRB, 0.18658501E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 9,14,:) = (/&
 & 0.59637277E-01_JPRB, 0.94657562E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 9,14,:) = (/&
 & 0.59637277E-01_JPRB, 0.16580908E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =  300.0

!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
PDGA(10,13,:) = (/&
 & 0.67139539E-01_JPRB, 0.10567474E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB(10,13,:) = (/&
 & 0.67139539E-01_JPRB, 0.18363226E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA(10,14,:) = (/&
 & 0.58732178E-01_JPRB, 0.93430511E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB(10,14,:) = (/&
 & 0.58732178E-01_JPRB, 0.16365014E+01_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 2 ----- T =  312.5

!-- INDICES FOR PADE APPROXIMATION   1 30 38 45
PDGA(11,13,:) = (/&
 & 0.66032012E-01_JPRB, 0.10404465E+01_JPRB, 0.00000000E+00_JPRB/)  
PDGB(11,13,:) = (/&
 & 0.66032012E-01_JPRB, 0.18099779E+01_JPRB, 0.10000000E+01_JPRB/)  
PDGA(11,14,:) = (/&
 & 0.57936092E-01_JPRB, 0.92363528E+00_JPRB, 0.00000000E+00_JPRB/)  
PDGB(11,14,:) = (/&
 & 0.57936092E-01_JPRB, 0.16175164E+01_JPRB, 0.10000000E+01_JPRB/)  

!-- CARBON DIOXIDE LINES IN THE WINDOW REGION (800-1250 CM-1)

!----- INTERVAL = 4 ----- T =  187.5

!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
PDGA( 1,15,:) = (/&
 & 0.13230067E+02_JPRB, 0.22042132E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 1,15,:) = (/&
 & 0.13230067E+02_JPRB, 0.22051750E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 1,16,:) = (/&
 & 0.13183816E+02_JPRB, 0.22169501E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 1,16,:) = (/&
 & 0.13183816E+02_JPRB, 0.22178972E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =  200.0

!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
PDGA( 2,15,:) = (/&
 & 0.13213564E+02_JPRB, 0.22107298E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 2,15,:) = (/&
 & 0.13213564E+02_JPRB, 0.22116850E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 2,16,:) = (/&
 & 0.13189991E+02_JPRB, 0.22270075E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 2,16,:) = (/&
 & 0.13189991E+02_JPRB, 0.22279484E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =  212.5

!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
PDGA( 3,15,:) = (/&
 & 0.13209140E+02_JPRB, 0.22180915E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 3,15,:) = (/&
 & 0.13209140E+02_JPRB, 0.22190410E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 3,16,:) = (/&
 & 0.13209485E+02_JPRB, 0.22379193E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 3,16,:) = (/&
 & 0.13209485E+02_JPRB, 0.22388551E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =  225.0

!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
PDGA( 4,15,:) = (/&
 & 0.13213894E+02_JPRB, 0.22259478E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 4,15,:) = (/&
 & 0.13213894E+02_JPRB, 0.22268925E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 4,16,:) = (/&
 & 0.13238789E+02_JPRB, 0.22492992E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 4,16,:) = (/&
 & 0.13238789E+02_JPRB, 0.22502309E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =  237.5

!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
PDGA( 5,15,:) = (/&
 & 0.13225963E+02_JPRB, 0.22341039E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 5,15,:) = (/&
 & 0.13225963E+02_JPRB, 0.22350445E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 5,16,:) = (/&
 & 0.13275017E+02_JPRB, 0.22608508E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 5,16,:) = (/&
 & 0.13275017E+02_JPRB, 0.22617792E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =  250.0

!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
PDGA( 6,15,:) = (/&
 & 0.13243806E+02_JPRB, 0.22424247E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 6,15,:) = (/&
 & 0.13243806E+02_JPRB, 0.22433617E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 6,16,:) = (/&
 & 0.13316096E+02_JPRB, 0.22723843E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 6,16,:) = (/&
 & 0.13316096E+02_JPRB, 0.22733099E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =  262.5

!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
PDGA( 7,15,:) = (/&
 & 0.13266104E+02_JPRB, 0.22508089E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 7,15,:) = (/&
 & 0.13266104E+02_JPRB, 0.22517429E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 7,16,:) = (/&
 & 0.13360555E+02_JPRB, 0.22837837E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 7,16,:) = (/&
 & 0.13360555E+02_JPRB, 0.22847071E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =  275.0

!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
PDGA( 8,15,:) = (/&
 & 0.13291782E+02_JPRB, 0.22591771E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 8,15,:) = (/&
 & 0.13291782E+02_JPRB, 0.22601086E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 8,16,:) = (/&
 & 0.13407324E+02_JPRB, 0.22949751E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 8,16,:) = (/&
 & 0.13407324E+02_JPRB, 0.22958967E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =  287.5

!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
PDGA( 9,15,:) = (/&
 & 0.13319961E+02_JPRB, 0.22674661E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 9,15,:) = (/&
 & 0.13319961E+02_JPRB, 0.22683956E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA( 9,16,:) = (/&
 & 0.13455544E+02_JPRB, 0.23059032E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB( 9,16,:) = (/&
 & 0.13455544E+02_JPRB, 0.23068234E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =  300.0

!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
PDGA(10,15,:) = (/&
 & 0.13349927E+02_JPRB, 0.22756246E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB(10,15,:) = (/&
 & 0.13349927E+02_JPRB, 0.22765522E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA(10,16,:) = (/&
 & 0.13504450E+02_JPRB, 0.23165146E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB(10,16,:) = (/&
 & 0.13504450E+02_JPRB, 0.23174336E+02_JPRB, 0.10000000E+01_JPRB/)  

!----- INTERVAL = 4 ----- T =  312.5

!-- INDICES FOR PADE APPROXIMATION     1   15   29   45
PDGA(11,15,:) = (/&
 & 0.13381108E+02_JPRB, 0.22836093E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB(11,15,:) = (/&
 & 0.13381108E+02_JPRB, 0.22845354E+02_JPRB, 0.10000000E+01_JPRB/)  
PDGA(11,16,:) = (/&
 & 0.13553282E+02_JPRB, 0.23267456E+02_JPRB, 0.00000000E+00_JPRB/)  
PDGB(11,16,:) = (/&
 & 0.13553282E+02_JPRB, 0.23276638E+02_JPRB, 0.10000000E+01_JPRB/)  

!     ------------------------------------------------------------------

!-----  (CONTINUUM ABSORPTION)

!-----  (CONTINUUM ABSORPTION: e-type COMPONENT)

RETYPE(1:4)= (/  12._JPRB,   5.5_JPRB,   4.25_JPRB,  45._JPRB /)

!-----  (CONTINUUM ABSORPTION: p-type COMPONENT)

RPTYPE(1:4)= (/ 0.22_JPRB, 0.012_JPRB, 0.0071_JPRB, 3.96_JPRB /)

!     ------------------------------------------------------------------

!-- COEFFICIENTS OF THE POLYNOMIALS GIVING THE TEMPERATURE DEPENDENCE OF
!     THE ABSORPTION

!--------H2O

!    revised in Zhong 961108
ALWT(1,:)= (/&
 & 2.34995778846E-03_JPRB, -2.76713384294E-04_JPRB,  1.16480338097E-06_JPRB/)  
BLWT(1,:)= (/&
 & -1.58165952771E-05_JPRB, -2.39167473702E-05_JPRB,  1.80148335147E-07_JPRB/)  
ALWT(2,:)= (/&
 & 2.52595953359E-02_JPRB, -6.72079319635E-04_JPRB,  5.74103783815E-06_JPRB/)  
BLWT(2,:)= (/&
 & -8.26196996910E-05_JPRB, -1.05514645370E-05_JPRB,  7.02984234993E-08_JPRB/)  
ALWT(3,:)= (/&
 & 3.55525229363E-02_JPRB, -7.94992134865E-04_JPRB,  6.64848193374E-06_JPRB/)  
BLWT(3,:)= (/&
 & -9.71124908025E-05_JPRB, -2.95218285256E-06_JPRB,  2.23374952695E-08_JPRB/)  
ALWT(4,:)= (/&
 & 5.47044522259E-02_JPRB, -1.19105877667E-03_JPRB,  9.74676865100E-06_JPRB/)  
BLWT(4,:)= (/&
 & -2.10153035427E-04_JPRB, -6.93815560155E-06_JPRB,  5.50381928956E-08_JPRB/)  
ALWT(5,:)= (/&
 & 1.88063066950E-02_JPRB, -1.11250846983E-04_JPRB,  1.66977895508E-06_JPRB/)  
BLWT(5,:)= (/&
 & -5.72683436311E-05_JPRB, -2.48448308453E-05_JPRB,  1.88450887138E-07_JPRB/)  
ALWT(6,:)= (/&
 & 1.29526952131E-02_JPRB, -3.81424455035E-04_JPRB,  3.07118138204E-06_JPRB/)  
BLWT(6,:)= (/&
 & -4.20789327775E-05_JPRB, -1.25055291318E-05_JPRB,  8.58839668934E-08_JPRB/)  

!-------CO2

ALWT(7,:)= (/0.250073E-03_JPRB,0.455875E-03_JPRB,0.109242E-03_JPRB /)
BLWT(7,:)= (/0.199846E-05_JPRB,-.216313E-05_JPRB,0.175991E-06_JPRB /)
ALWT(8,:)= (/0.307423E-01_JPRB,0.110879E-02_JPRB,-.322172E-03_JPRB /)
BLWT(8,:)= (/-0.108482E-03_JPRB,0.258096E-05_JPRB,-.814575E-06_JPRB /)

!     ------------------------------------------------------------------ 

!*       2.    SET VALUES.
!              -----------

!-number of spectral intervals
NSIL  = 6
!-number of intervals with Pade approximants transmission functions
NIPD  = 8
NIPD2 = 2*NIPD
!-number of reference temperatures      
NTR   = 11
!-number of absorber amounts
NUA   = 24
!-number of transmission functions      
NTRA  = 15
!-number of Gauss angles      
NG1   = 2
NG1P1 = NG1+1

!-- REFERENCE TEMPERATURES FOR THE PLANCK FUNCTIONS ----- TSTAND
!          TEMPERATURE DEPENDENCE OF THE ABSORPTION ----- TREF
TSTAND = 250.0_JPRB
TREF   = 250.0_JPRB

!-- ROOTS AND WEIGHTS FOR THE 2-POINT GAUSSIAN QUADRATURE
RT1 = (/ -0.577350269_JPRB, +0.577350269_JPRB /)
WG1 = (/  1.0_JPRB        ,  1.0_JPRB         /)

!-- TEMPERATURE STEP AND MAXIMUM INDEX FOR THE TRANSMISSIVITIES
TSTP  = 12.5_JPRB
MXIXT = 10

!--  COEFFICIENTS FOR OZONE ABSORPTION

RO1H = 2230._JPRB
RO2H =  100._JPRB
RPIALF0 = 2._JPRB
RO3T(1) = -.326E-03_JPRB
RO3T(2) = -.102E-05_JPRB
RO3T(3) = 0.137E-02_JPRB
RO3T(4) = -.535E-05_JPRB

!--  COEFFICIENTS FOR THE PSEUDO-VOIGT LINE PROFILE (PA)

RVGCO2= 60._JPRB
RVGH2O= 30._JPRB
RVGO3 =400._JPRB

!     ------------------------------------------------------------------ 

IF (LHOOK) CALL DR_HOOK('SULWN',1,ZHOOK_HANDLE)
END SUBROUTINE SULWN
