#!/bin/bash

listecas="24B 00WC 05WC 00SC 03SC  05SC  24SC  24F 15B "

SIM=$1

for cas in $listecas ; do

if [ -d $SIM/$cas ] ; then

zi=`grep $cas description | awk ' { print $9 } '`
zmoit=`echo $zi | awk ' { print $1 / 2. } '`
echo $cas $zi $zmoit

cd $SIM/$cas
echo Traitement du cas $SIM/$cas

lev=`ncdump -h histhf.nc  | head | grep presnivs | awk ' { print $3 } '`

for var in a temp vent B C zmax_th s_pblh pblh f w a ; do

case $var in
   f|w|a) level="z=$zmoit" ;;
   pblh) level="z=0.4" ;;
   *) level="k=$lev"
esac


cat << eod >| tmp.jnl
use histhf.nc
let rg=9.81
let m2=(vitu*vitu+vitv*vitv)/geop/geop*rg*rg
let n2=rg/theta*(theta-theta[k=$lev])/geop*rg
define axis/z=-0.5:20.:0.1 axm
let pblh = ZAXREPLACE( geop/9.81,n2/m2,z[gz=axm])

define axis/z=0:3000:100 axz
let a=ZAXREPLACE( a_th,geop[l=1]/9.81,z[gz=axz])
let w=ZAXREPLACE( w_th,geop[l=1]/9.81,z[gz=axz])
let f=ZAXREPLACE( f_th,geop[l=1]/9.81,z[gz=axz])


let vent=(vitu*vitu+vitv*vitv)^0.5
list/$level $var
quit
eod

ferret < tmp.jnl | grep ' \/ ' | awk ' { print $2 , $5 } ' | sed -e 's/:/ /g' | awk ' { print $1 + $2/60. + $3/3600. , $4 } ' > ${var}_s.x
done
cd ../..

else
echo Pas de repertoire $SIM/$cas
cd ..
fi

done
