#!/bin/bash


cas=`basename \`pwd\`` ; phys=`cd .. ; basename \`pwd\``

# Traitement special pour le lancement en serie de SCM dans HighTune
if [ ${cas:0:3} = SCM ] ; then cas=`cd .. ; basename \`pwd\`` ; phys=`cd ../.. ; basename \`pwd\`` ; fi


if [ "${cas:0:7}" = "ayotte_" ] ; then
      year=2006
      month=JUL
      day0=10
      day1=10
      time0=09:00:00
      time1=19:00:00
      day0z=10
      day1z=10
      time0z=08:00:00
      time1z=19:00:00
      uvmin=-2
      uvmax=12
      nebmax=0.3
      zmax=2000
      lcible=6
hlimt=300:315
hlimu=0:16
hlimv=0:10
fi

case $cas in
	ihop)
      year=2006
      month=JUL
      day0=10
      day1=10
      time0=09:00:00
      time1=19:00:00
      day0z=10
      day1z=10
      time0z=08:00:00
      time1z=19:00:00
      uvmin=-2
      uvmax=12
      nebmax=0.3
      zmax=3000
      lcible=10
hlimt=296:312
hlimqv=0:12
hlimu=-20:20
hlimv=-20:20
      ;;
esac

day0my=$day0-$month-$year
day1my=$day1-$month-$year
day0myz=$day0z-$month-$year
day1myz=$day1z-$month-$year

ferret -gif <<eod
use hourly_std.nc
use LES.nc
set v left
plot/line=1/vs/hlim=$hlimt/vlim=0:$zmax theta[l=1],zf[l=1]
plot/line=7/vs/o theta[l=$lcible],zf[l=1]
plot/line=2/vs/o/d=1 theta[l=1],zf[l=1]
plot/line=8/vs/o/d=1 theta[l=$lcible],zf[l=1]
set v right
plot/line=1/vs/hlim=$hlimqv/vlim=0:$zmax 1000*qv[l=1],zf[l=1]
plot/line=7/vs/o 1000*qv[l=$lcible],zf[l=1]
plot/line=2/vs/o/d=1 1000*qv[l=1],zf[l=1]
plot/line=8/vs/o/d=1 1000*qv[l=$lcible],zf[l=1]
frame/file=tmp1.gif
quit
eod

ferret -gif <<eod
use hourly_std.nc
use LES.nc
set v left
plot/line=1/vs/hlim=$hlimu/vlim=0:$zmax u[l=1],zf[l=1]
plot/line=7/vs/o u[l=$lcible],zf[l=1]
plot/line=2/vs/o/d=1 u[l=1],zf[l=1]
plot/line=8/vs/o/d=1 u[l=$lcible],zf[l=1]
set v right
plot/line=1/vs/hlim=$hlimv/vlim=0:$zmax v[l=1],zf[l=1]
plot/line=7/vs/o v[l=$lcible],zf[l=1]
plot/line=2/vs/o/d=1 v[l=1],zf[l=1]
plot/line=8/vs/o/d=1 v[l=$lcible],zf[l=1]
frame/file=tmp2.gif
quit
eod

for i in 1 2 ; do
convert tmp$i.gif tmp$i.pdf
done
pdfjam --nup 2x1 tmp1.pdf tmp2.pdf --outfile  tmp12.pdf --landscape
#evince tmp12.pdf

