#!/bin/bash


cas=`basename \`pwd\`` ; phys=`cd .. ; basename \`pwd\``

# Traitement special pour le lancement en serie de SCM dans HighTune
if [ ${cas:0:3} = SCM ] ; then cas=`cd .. ; basename \`pwd\`` ; phys=`cd ../.. ; basename \`pwd\`` ; fi

date0=""
zmax=4
tminmax=295:320
case $cas in
   arm_cu|arm_cu_old)
      year=1997
      month=JUN
      day0=21
      day1=22
      time0=12:00:00
      time1=03:00:00
      day0z=21
      day1z=21
      time0z=13:00:00
      time1z=22:00:00
      uvmin=-2
      uvmax=12
      nebmax=0.3
      zmax=3.
      ;;
   bomex|bomex_old)
      year=2001
      month=SEP
      day0=27
      day1=27
      time0=01:00:00
      time1=11:00:00
      day0z=27
      day1z=27
      time0z=01:00:00
      time1z=11:00:00
      uvmin=-10
      uvmax=2
      d0=2001-09-27
      nebmax=0.12
      ;;
   sandufast|sanduref|sanduslow)
      year=2006
      day0=15
      day1=18
      month=JUL
      time0=18:00:00
      time1=06:00:00
      day0z=15
      day1z=17
      time0z=19:00:00
      time1z=06:00:00
      uvmin=-6
      uvmax=4
      nebmax=1.2
      zmax=2.5
      tminmax=280:320
      ;;
   fire)
      year=1987
      day0=14
      day1=17
      month=JUL
      time0=00:00:00
      time1=00:00:00
      day0z=14
      day1z=15
      time0z=15:00:00
      time1z=06:00:00
      uvmin=-5
      uvmax=8
      nebmax=1.2
      zmax=1.8
      tminmax=280:320
      ;;
   rico|rico_old)
      year=2004
      month=DEC
      day0=27
      day1=30
      time0=01:00:00
      time1=00:00:00
      day0z=27
      day1z=27
      time0z=02:00:00
      time1z=22:00:00
      uvmin=-10
      uvmax=2
      d0=2004-12-27
      nebmax=0.18
      ;;

    *)
       echo cas non prevu
       exit
esac


if [ ! -f LES.nc ] ; then ln -s ../../../CAS/$cas/LES.nc . ; fi
ncatted  -a "calendar",time,o,c,"standard" -O hourly_std.nc
if [ "$d0" != "" ] ; then
 ncatted  -a "units",time,o,c,"seconds since $d0 00:00:00" -O hourly_std.nc
fi

if [ "`ncdump -h hourly_std.nc | grep -i rneblsvol`" = "" ] ; then rneblsvol=rneb ; else rneblsvol=rneblsvol ; fi



DASH="DASH=(0.3,0.1,0.3,0.1)"
day0my=$day0-$month-$year
day1my=$day1-$month-$year
day0myz=$day0z-$month-$year
day1myz=$day1z-$month-$year
cat <<eod>| tmp2.jnl
use hourly_std
use LES.nc
let xx=if ( ${rneblsvol}[k=@max,l=@max] gt 0. ) then 1. else 0.
let rnebvol=xx*${rneblsvol}+(1.-xx)*rneb
set v ul
plot/vlim=0:$nebmax/title="CLD %" rneb[d=2,k=@max],rnebvol[d=1,k=@max],rneb[d=1,k=@max]
set v ll
plot/title="Precip (mm/day)" rrt[k=1]*86400,rain[d=1]*86400
reg/t="$day1myz $time1z"
! --------- profiles verticaux -----------------
set v ur
plot/vs/line=13/vlim=0:$zmax/title="Nebul, $phys, $cas, LES"/hlim=0:$nebmax rneb[l=@ave],zf[l=1]/1000
plot/vs/line=14/vlim=0:$zmax/d=1/o/title="LMDZ" rnebvol[l=@ave],zf[l=1]/1000
plot/vs/line=15/vlim=0:$zmax/d=1/o/title="LMDZ" rneb[l=@ave],zf[l=1]/1000
plot/vs/line=1/vlim=0:$zmax/$DASH/d=2/o/title="QC(LES)" 1000*qc[l=@ave],zf[l=1]/1000
plot/vs/line=2/vlim=0:$zmax/$DASH/d=1/o/title="QC(LMDZ)" 1000*ql[l=@ave],zf[l=1]/1000
set v lr
plot/vs/line=13/vlim=0:$zmax/title="U LES (m/s)"/hlim=$uvmin:$uvmax u[l=@ave],zf[l=1]/1000
plot/vs/line=14/vlim=0:$zmax/o/d=1/title="U LMDZ" u[l=@ave],zf[l=1]/1000
plot/vs/line=1/$DASH/vlim=0:$zmax/o/title="V LES" v[l=@ave],zf[l=1]/1000
plot/vs/line=2/$DASH/vlim=0:$zmax/d=1/o/title="V LMDZ" v[l=@ave],zf[l=1]/1000
quit
eod


cat <<eod>| tmp1.jnl
use hourly_std
use LES.nc
let xx=if ( ${rneblsvol}[k=@max,l=@max] gt 0. ) then 1. else 0.
let rnebvol=xx*${rneblsvol}+(1.-xx)*rneb
set v ll
! -------- evolution t-z nebul --------------------
define axis/z=0:$zmax:0.05 axm
let scm=100*ZAXREPLACE(rnebvol,zf[l=1]/1000.,z[gz=axm])
let les=100*ZAXREPLACE(rneb,zf[l=1]/1000,z[gz=axm])
fill/d=1/lev=(1)(2)(2,30,2)(Inf)/title="$phys"/hlim="$day0my $time0":"$day1my $time1"  scm
!
!====================================================
! Ajout des droites verticales indiquant les profiles
!====================================================
let tt=t[gt=scm,d=1]
LET datelabelpos=TT[T="$day0myz $time0z"@ITP]
PLOT/VS/NOLAB/LINE=2/OVER {\`datelabelpos\`,\`datelabelpos\`},{0,$zmax}
LET datelabelposb=TT[T="$day1myz $time1z"@ITP]
PLOT/VS/NOLAB/LINE=14/OVER {\`datelabelposb\`,\`datelabelposb\`},{0,$zmax}
!
!
contour/o/d=1/lev=(0.00001) scm
set v ul
fill/d=2/k=1:100/lev=(1)(2)(2,30,2)(Inf)/title="Nebul (%), LES , $cas"/hlim="$day0my $time0":"$day1my $time1" les
contour/o/lev=(0.00001) les

!====================================================
! Ajout des droites verticales indiquant les profiles
!====================================================
let tt=t[gt=les,d=2]
LET datelabelpos=TT[T="$day0myz $time0z"@ITP]
PLOT/VS/NOLAB/LINE=1/OVER {\`datelabelpos\`,\`datelabelpos\`},{0,$zmax}
LET datelabelposb=TT[T="$day1myz $time1z"@ITP]
PLOT/VS/NOLAB/LINE=13/OVER {\`datelabelposb\`,\`datelabelposb\`},{0,$zmax}
!
! -------- Profiles verticaux ---------------------
set v ur
let vles=theta
let vscm=theta
plot/d=2/vs/line=1/$DASH/vlim=0:$zmax/hlim=$tminmax/title="Theta (K), LES, ini"  vles[t="$day0myz $time0z"],zf[l=1]/1000
plot/d=2/vs/o/line=13/title="LES" vles[t="$day1myz $time1z"],zf[l=1]/1000
plot/d=1/vs/line=2/$DASH/o/title="LMDZ, ini" vscm[t="$day0myz $time0z"],zf[l=1]/1000
plot/d=1/vs/line=14/o/title="LMDZ" vscm[t="$day1myz $time1z"],zf[l=1]/1000
set v lr
let vles=1000*qv
let vscm=1000*qv
plot/d=2/vs/line=1/$DASH/vlim=0:$zmax/hlim=0:18/title="Spec. humid (g/kg), LES, ini" vles[t="$day0myz $time0z"],zf[l=1]/1000
plot/d=2/vs/o/line=13/title="LES" vles[t="$day1myz $time1z"],zf[l=1]/1000
plot/d=1/vs/line=2/$DASH/o/title="LMDZ, ini" vscm[t="$day0myz $time0z"],zf[l=1]/1000
plot/d=1/vs/line=14/o/title="LMDZ" vscm[t="$day1myz $time1z"],zf[l=1]/1000
quit
eod

for i in 1 2 ; do
ferret -batch tmp.ps -nojnl -script tmp$i.jnl
ps2epsi tmp.ps
epstopdf tmp.epsi 
\mv -f tmp.pdf tmp$i.pdf
done

pdfjam --nup 2x1 tmp1.pdf tmp2.pdf --outfile  tmp12.pdf --landscape

if [ -f autre_diag.sh ] ; then
./autre_diag.sh
fi

\rm -f tmp*ps*

# evince tmp12.pdf
