function toga_profiles(args)
*
* two or three arguments:
*  - "output label" "variable"
*  - "input label" "output label" "variable"
*
say 'args =' args
expin='_'subwrd(args,1)
exp=subwrd(args,2)
var=subwrd(args,3)
if (var = '')
expin=''
exp=subwrd(args,1)
var=subwrd(args,2)
endif


'reinit'

# Nom fichier histhr:
'sdfopen histhr'expin'.nc'

# Nom fichier TOGA COARE data:
'open diags/ifa_toga_coare_v21_dime.ctl'

if (var = 'temp') 
varmod='temp(x=1,y=1)'
varobs='temp(x=1,y=1)'
multmod='1'
multobs='1'
addmod='-273.15'
addobs='0'
iso='-70 -60 -50 -40 -30 -20 -10 0 10 20 '
isomean='-90 35'
pmin='10000'
endif

if (var = 'rh') 
varmod='rhum(x=1,y=1)'
varobs='rh(x=1,y=1)'
multmod='1'
multobs='0.01'
addmod='0'
addobs='0'
iso='.1 .2 .3 .4 .5 .6 .7 .8 .9 1'
isomean='0.4 0.9'
pmin='30000'
endif

if (var = 'q') 
varmod='ovap(x=1,y=1)'
varobs='q(x=1,y=1)'
multmod='1000'
multobs='1'
addmod='0'
addobs='0'
*iso='.1 .2 .3 .4 .5 .6 .7 .8 .9 1'
*isomean='0.4 0.9'
pmin='30000'
endif

if (var = 'Q1') 
**varmod='dtcon(x=1,y=1)+dteva(x=1,y=1)+dtlsc(x=1,y=1)+dtwak(x=1,y=1)+dtthe(x=1,y=1)'
varmod='dtcon+dteva+dtlsc+dtwak+dtthe+dtvdf'
varobs='q1(x=1,y=1)'
multmod='86400'
multobs='1.'
addmod='0'
addobs='0'
iso='-20 -15 -10 -5 0 5 10 15 20 25 30 35 40 '
isomean='-10. 20.'
pmin='30000'
endif

if (var = 'Q2') 
**varmod='dtcon(x=1,y=1)+dteva(x=1,y=1)+dtlsc(x=1,y=1)+dtwak(x=1,y=1)+dtthe(x=1,y=1)'
varmod='dqcon+dqeva+dqlsc+dqwak+dqthe+dqvdf'
varobs='q2(x=1,y=1)'
multmod='(-86400*2500)'
multobs='1.'
addmod='0'
addobs='0'
iso='-20 -15 -10 -5 0 5 10 15 20 25 30 35 40 '
isomean='-10. 20.'
pmin='30000'
endif

*-- periode a plotter:
*time1='06z01nov92'
*time2='06z27feb93'
*time1='01dec92'
*time2='15jan93'
'q file 1'
size=sublin(result,5)
tsize=subwrd(size,12)
*say tsize
'set t 1 'tsize
'q dim'
tline=sublin(result,5)
time1=subwrd(tline,6)
if (subwrd(tline,3)="fixed")
  time2=time1
else
  time2=subwrd(tline,8)
endif
*say time1 time2

fichout='./'var'_'exp'_obs'

*---------------------------------------

'set lev 100000 'pmin
'set gxout shaded'

'set time 'time1' 'time2
'set dfile 1'
**'define mod='varmod'(x=1,y=1)*'multmod'+'addmod
'define mod=('varmod')*'multmod'+'addmod
'set dfile 2'
**'define obs='varobs'(x=1,y=1)*'multobs'+'addobs
'define obs='varobs'*'multobs'+'addobs

'set t 1'
'set dfile 1'
'define moymod=ave(mod,time='time1',time='time2')'
'set dfile 2'
'define moyobs=ave(obs,time='time1',time='time2')'

******** PLOT MODEL:

'set vpage 0.5 3 4.5 8.42 '
'set grads off'
'set t 1'
'set ccolor 2'
'set vrange 'isomean
'd moymod'
'draw title model mean'

* obs superposees:
'set ccolor 1'
'set cthick 5'
'set dfile 2'
'd moyobs'
'draw ylab pressure (Pa)'


'set vpage 1.5 11 4.0 8.5 '
'set time 'time1' 'time2
'set grads off'
'set dfile 1'
'set ylab off'
'set clevs 'iso
'd mod'
'draw title TOGA-COARE 'exp': 'varmod

*********** PLOT OBS:

'set ylab on'
'set vpage 0.5 3 0.5 4.42 '
'set grads off'
'set t 1'
'set dfile 2'
'set ccolor 1'
'set cthick 5'
'set vrange 'isomean
'd moyobs'
'draw title obs mean'
'draw ylab pressure (Pa)'

'set vpage 1.5 11 0. 4.5 '
'set time 'time1' 'time2
'set grads off'
'set dfile 2'
'set ylab off'
'set clevs 'iso
'd obs'
'draw title TOGA-COARE OBSERVATIONS: 'varobs
'cbar'

* Save graphics in .eps :
'enable print pr'
'print'
'disable print'
'!gxps -c -i pr -o 'fichout'.ps'
'!convert 'fichout'.ps 'fichout'.eps'
'!rm -f pr 'fichout'.ps'
say 'OUT: 'fichout'.eps'

'quit'

