#!/bin/bash

rm -f foo
rm -f faa
rm -f fee
rm -f fuu.jnl
rm -f diag_dice_bucket.pdf
# Specify the path to the RESU directory
ici=`pwd`
cd ../../RESU
datapathpre=`pwd`
cd $ici
datapathsuf="/dice_bucket/hourly.nc"

listedef="NPv6.0.7 NPv6.0.9 NPv6.0.10.2"

for DEF in $listedef ; do
  defdir=$DEF"L79"
  inputfile=$datapathpre/$defdir$datapathsuf
  echo use {$inputfile} >> foo
done
sed 's/{/"/g' foo > faa
sed 's/}/"/g' faa > fee
cat fee base.jnl > fuu.jnl

ferret <<eod> out_ferret 2>&1
  go fuu.jnl
  quit
eod

convert tsol.gif tsol.pdf
convert t2m.gif t2m.pdf
convert temp.gif temp.pdf
convert solldown.gif solldown.pdf

pdfjam-slides6up --pagenumbering true --frame false *.pdf -o diag_dice_bucket.pdf
rm -f foo
rm -f faa
rm -f fee
rm -f fuu.jnl
rm -f ferret.jnl*
rm -f out_ferret
rm -f *gif*
