#!/bin/bash

ref=TEST/NOCONVL79/cindynamo/hourly.nc
new=TEST/NOCONVL79/DYNAMO/NEW/hourly.nc
out=GIF
mkdir -p $out
if [ ! -f $ref -o ! -f $new ] ; then echo $ref or $new missing ; exit ; fi

################################################################################
# Variabes f(z,z)
################################################################################
for varz in `ncdump -h $ref | grep float | grep presnivs | grep time | cut -d\( -f1 | awk '  { print $2 } '` ; do

case ${varz:0:2} in
	"dt"|"du"|"dv") fact='86400*' ;;
	"dq") fact="1000*86400*" ;;
	*) fact=1
esac

cat <<eod> tmp.jnl
use "$ref"
use "$new"
set v upper
fill ${fact}*${varz}[d=1]
set v lower
fill ${fact}*${varz}[d=2]
frame/file="$out/${varz}.gif"
quit
eod

ferret -gif -script tmp.jnl -nojnl
done


################################################################################
# Variabes temporelles f(t)
################################################################################
for vart in `ncdump -h $ref | grep float | grep '(time_counter, lat' | cut -d\( -f1 | awk '  { print $2 } '` ; do

cat <<eod> tmp.jnl
use "$ref"
use "$new"
plot ${vart}[d=1],${vart}[d=2]
frame/file="$out/${vart}.gif"
quit
eod

ferret -gif -script tmp.jnl -nojnl

done
