#!/bin/bash
#
####################################################################
############ FIRST PART TO FILL IN BY USER #########################
####################################################################
# list of cases.
# For old cases, just write case name e.g. rico
# For new cases, write CASE/SUBCASE e.g. ARMCU/REF
listecas="ARMCU/REF RICO/SHORT SANDU/REF"
####################################################################
# Select cases to be considered
# Available cases in ./CAS
# dry                     : ayotte
# cumulus continent       : arm_cu
# marine cumulus          : rico rico2  bomex bomex2
# strato cumulus          : fire sandufast sanduref sanduslow
# ocean. deep convection  : toga twpice
# cont.  deep convection  : amma
# radiative/conv. eq.     : eq_rd_cv
# other                   : hapex92_init dice_bucket gabls4
####################################################################

####################################################################
#listedef=NPv6.3
listedef=6A
####################################################################
# Select list of physics configuration
# Available physics in INPUT/PHYS
####################################################################

flag_output_commun="1"

LLM=79
       # default values for various cases are defined bellow
day_step=""

####################################################################
# usage to run with old/rrtm/ecrad rad code : ./run.sh -rad rrtm/rad
####################################################################
rad="rrtm"

####################################################################
# which physics folder?
phys="lmd"

####################################################################
# usage to run cosp: ./run.sh -cosp 1/2 for cosp or cosp2
# Attention, cosp2 needs a recent version of gfortran
####################################################################
cosp=0
opt_cosp=""

####################################################################
# compilation options
####################################################################
ok_compile=true
ok_inlandsis=false
ok_full_compile=true
ok_debug=true
####################################################################
# run diagnostics and post-treatment (0 or 1)
i_diag=0

####################################################################
# do you want to update the CAS from the DEPHY github repo (0 or 1)
update_cases=false

####################################################################
# add $WDIR to repo names
# $EXEC : EXEC$WDIR => run in $local/$EXEC/$config/$case 
# $OUTPUT : OUTPUT$WDIR => store output in $local/$OUTPUT/$config/$case 
# and pass WDIR along to 1Ddiag.sh
WDIR= # default to empty string

####################################################################
############## DO NOT TOUCH BELOW IF NO EXPERT #####################
####################################################################
# is pdfjam availabl on the computer

if command -v pdfjam &> /dev/null
then
okpdfjam=1
else
okpdfjam=0
fi

####################################################################
#          Fonctions             # 
#
help_needed ()
{
    cat <<EOI
#
#  Usage : `basename $0` [-r] 
#
#  -r : run only (no compilation)
#
EOI
  exit $1
}
#
shell_name=`basename $0`


  while [ $# -gt 0 ]
  do
     case "$1" in
        -h | -help | -\? | \? | -u )
             help_needed 0
             shift
             ;;
        -day_step)
             day_step=$2
             shift ; shift
             ;;
        -r)
             ok_compile=false
             shift
             ;;
       "-rad") rad=$2 
             case $rad in
                "oldrad"|"rrtm"|"ecrad") rad=$2 ; shift ; shift ;;
                *) echo Only old rrtm ecrad for rad option ; exit
             esac ;; 
       "-cosp") cosp=$2 ; shift ; shift ;;
       "-wdir") WDIR=$2 ; shift ; shift ;;
         *)
             shift
       esac
  done
##################################

local=`pwd`
UTILS=$local/UTILS
DIAGDIR=$local/DIAGS
OUTPUT=OUTPUT$WDIR
EXEC=EXEC$WDIR

listedir="DOC OLDCASES INPUT"
for dir in $listedir ; do

if [ ! -d "$local/$dir" ] ; then
echo $dir does not exist, download it from LMDZ pub repository
wget --no-check-certificate -nv "http://lmdz.lmd.jussieu.fr/pub/1D/MATERIAL/${dir}.tar.gz"
if [ $? != 0 ] ; then echo  wget of $dir not ended normally, exit ; exit 1 ; fi
tar -xvf ${dir}.tar.gz
rm -f ${dir}.tar.gz
fi

done

dir=CAS
if  [ ! -d "$local/$dir" ] ; then
   if [ "$update_cases"=="true" ] ; then
	./update_CAS.sh
   else
        echo $dir does not exist, download it from LMDZ pub repository
        wget --no-check-certificate -nv "http://lmdz.lmd.jussieu.fr/pub/1D/MATERIAL/${dir}.tar.gz"
        if [ $? != 0 ] ; then echo  wget of $dir not ended normally, exit ; exit 1 ; fi
        tar -xvf ${dir}.tar.gz
        rm -f ${dir}.tar.gz
   fi
fi



if [ "$phys" == "lmd" ] ; then
   phys_=""
else
   phys_=${phys}_
fi

if [ "$cosp" = 1 ] ; then 
   opt_cosp="-cosp true"
elif [ "$cosp" = 2 ] ; then
   opt_cosp="-cosp2 true"
fi

opt_inlandsis=
if [ "$ok_inlandsis" == "true" ] ; then
   opt_inlandsis="-inlandsis true"
fi

opt_full=
if [ "$ok_full_compile" == "true" ] ; then
   opt_full="-full"
fi

opt_debug=
if [ "$ok_debug" == "true" ] ; then
   opt_debug="-debug"
fi


# sauvegarde d'anciennes simulations
# NV replace EXEC with var $EXEC = EXEC$WDIR
mkdir -p $local/$EXEC/SAVE$$
mv ${DIAGDIR}/OUTPUT-DIAGS/*.pdf ${DIAGDIR}/OUTPUT-DIAGS/SAVE$$ # Naj : ???

listepdf=""
listediag=""
listeconfig=""

for DEF in $listedef ; do

if [ "$LLM" = "" ] ; then
   case $DEF in
      SP|NPv3.1|NPv3.2) L=39 ;;
      NPv4.12) L=59 ;;
      H2002) L=130 ;;
      *) L=79
   esac
else
   L=$LLM
fi



########################################################################
# Compilation 
########################################################################
if [ "$ok_compile" == "true" ]; then

  echo =========== Compilation de la version L$L =========================
  opt_compile="$opt_debug $opt_cosp $opt_inlandsis"

  if [ $rad = rrtm -a $L -ge 100 ] ; then 
        echo 'RRTM not working for L >= 100; Use -rad oldrad or ecrad'
        exit 1
  fi
  cd $local/bin 
  echo ./compile -L $L -p $phys -rad $rad -opt "$opt_compile" "$opt_full"
  ./compile -L $L -p $phys  -rad $rad -opt "$opt_compile" "$opt_full" 
  if [ $? != 0 ] ; then exit 1 ; fi

fi

########################################################################




if [ "$day_step" = "" ] ; then dtsuf="" ; else dtsuf=dt$day_step ; fi


config=${DEF}L${L}$phys_$dtsuf
OUT=$local/$OUTPUT/$config
list_pdf=" "  # contient la liste des fichiers pdf a concatener dans all.pdf




for cas in $listecas ; do

   
# creation du repertoire d'execution 
   EXECDIR=$local/$EXEC/$config/$cas
   mkdir -p $EXECDIR
   cd $EXECDIR
   echo $EXECDIR

  
# creation du repertoire des sorties lmdz

   OUTDIR=$local/$OUTPUT/$config/$cas
       mkdir -p $OUTDIR   
     
# creation du repertoire des sorties au format dephy
   if [ "`echo $cas | grep '/'`" = "" ] ; then
       std=0 #; pointpoint=..
   else
       std=1 #; pointpoint=../..
       STDDIR=$OUTDIR
       #mkdir -p $STDDIR
   fi
   

# Fichiers d'entree du CAS
   
    if [ -d ${local}/OLDCASES/${cas} ];then
      dircas=$local/OLDCASES/$cas
    else
      dircas=$local/CAS/$cas 
    fi

    ln -sf $dircas/* .
    \rm *.d[ae]*



# Fichiers par defaut
   cp $local/INPUT/DEF/*.def .

   if [ "$cosp" != 0 ] ; then
# copier les fichiers namelist input et output our COSP
     cp $local/INPUT/DEF/cosp_input_nl.txt .
     cp $local/INPUT/DEF/cosp_output_nl.txt .

# Activer la cles ok_cosp pour tourner avec COSP
     sed -e 's@ok_cosp=n@ok_cosp=y@' config.def > tmp
     \mv -f tmp config.def
     sed -e 's@ok_hfCOSP=n@ok_hfCOSP=y@' config.def > tmp
     \mv -f tmp config.def
   fi
  
# Fichier physiq.def
   cp $local/INPUT/PHYS/physiq.def_$DEF physiq.def
   if [ $rad = oldrad ] ; then
      sed -i'' -e 's/iflag_rrtm=.*$/iflag_rrtm=0/' -e 's/NSW=.*$/NSW=2/' physiq.def
   fi

# Cas Ecrad :
    if [ $rad = ecrad ] ; then
     cp $local/../modipsl/modeles/LMDZ/DefLists/namelist_ecrad .
     cp -r $local/../modipsl/modeles/LMDZ/libf/phylmd/ecrad/data .
     sed -e 's@iflag_rrtm=1@iflag_rrtm=2@' physiq.def > tmp
     \mv tmp physiq.def
    fi

# Fichier contenant la grille verticale
   LDEF=$L ; VERT_DIR=$local/INPUT/VERT/L$L
   if [ ! -d $local/INPUT/VERT/L$LDEF ] ; then LDEF=DEFAULT ; fi
   cp -f $local/INPUT/VERT/L$LDEF/* . ; ln -sf L$LDEF.def vert.def

# Fichiers contenant la description du cas
   cp $dircas/*.d[ae]* . # on donne la priorite aux .def et .data du cas
   if [ "$day_step" != "" ] ; then \mv -f gcm1d.def ttt
       sed -e 's/day_step=.*.$/day_step='$day_step'/' ttt >| gcm1d.def ; fi
   case $cas in
      arm_cu_old) llm=40
           cd $local/bin ; ./compile -L 40 -p $phys -rad $rad -opt "$opt_compile" ; cd $OUTDIR ;;
      *)               llm=$L
   esac
# Si on veut sortir un fichier output au format commun DEPHY
   cp $UTILS/lmdz2std.sh .
   cp $UTILS/lmdz2std_CF.sh .
#   case $cosp in
#     1) cosp_suf=cosp_ ;;
#     2) cosp_suf=cosp2_ ;;
#     *) cosp_suf=""
#   esac
   bin=$local/bin
   suffixe=_${phys_}${rad}_${cosp_suf}L$llm
   cat <<...eod>| compile.sh
   main=lmdz1d
   if [ \$# != 0 ] ; then main=\$1 ; fi
   cd $bin
   ./compile -L $llm -p $phys -rad $rad -cosp $cosp -opt "$opt_compile" -main \$main
   cd -
   ln -sf $bin/\${main}${suffixe}.e .
   ln -sf \${main}${suffixe}.e \${main}.e
...eod

   if [ $std = 1 ] ; then $UTILS/cas2def.sh ; fi

   chmod +x compile.sh
   ./compile.sh
   ls -l $exec
############################################################################
   echo " =============  CAS $cas .def issus de $DEF  ================"
############################################################################
   if [ $cas == "ayotte" ]||[ $cas = idealq ]||[ $cas = eq_rd_cv_1p1eq2 ]  ; then
      ./lance.sh 
   else
      ./lmdz1d${suffixe}.e > listing 2>&1 
      grep 'is cool' listing
      grep 'is cool' listing > resul
   if [ -f listing.gz ] ; then rm -f listing.gz ; fi
      
      gzip listing
      

# fichiers de sortie en format standard
   if [ "$flag_output_commun" = "1" ] ; then
         ./lmdz2std.sh
         if [ $std = 1 ] ; then
            ncatted  -a "calendar",time,o,c,"standard" hourly_std.nc -O $STDDIR/$config.nc ; fi
	 ./lmdz2std_CF.sh
   fi

# copie des fichiers de sortie dans OUTDIR
      cp $EXECDIR/hourly.nc $OUTDIR/.
      cp $EXECDIR/histhf.nc $OUTDIR/.    
      cp $EXECDIR/hourly_std.nc $OUTDIR/.
      cp $EXECDIR/hourly_std_CF.nc $OUTDIR/. 


############################################################################
   echo " =============  RUN THE DIAGNOSTICS  ================"
############################################################################

   if [ $i_diag == 1 ] ; then
   cd $DIAGDIR
   ./1Ddiag.sh $config $cas $llm $dtsuf $WDIR
     
   list_pdf="${list_pdf} ${OUTDIR}/neb.pdf "
   fi  # i_diag

   fi  #  end if cas == "ayotte"
   done  #cas 
   
  
   if [ $i_diag == 1 ] ; then
   cd $OUT
   nfig=`echo $listecas | sed -e 's/ayotte//' | wc -w`
   pp=`echo $nfig | awk ' {  print int(($1-1)^0.5) +1 } '`
   if [ $(( $(( pp - 1 )) * $pp )) -ge $nfig ] ; then (( py = $pp - 1 )) ; else py=$pp ; fi
   echo $pp $py

   out=neb$DEF$phys_.pdf

   if [ "$okpdfjam" = 1 ] ; then
   pdfjam --nup ${pp}x${py} --frame true --landscape ${list_pdf} -o $OUT/$out
   else
   pdftk $liste_pdf cat output  $OUT/$out  
   fi


   listepdf="$listepdf $OUT/$out"
   listeconfig="$listeconfig $config"
   fi # i_diag
   
done # model config

cd $local


#########################################################
# Regroupement des resultats par cas
#########################################################

if [ $i_diag == 1 ] ; then

if [ "$okpdfjam" = 1 ] ; then
pdfjam $listepdf --landscape -o $local/$OUTPUT/all.pdf
else
pdftk $listepdf cat output $local/$OUTPUT/all.pdf
fi


for cas in $listecas ; do
    listepdf=""

    ls -d $local/$OUTPUT/*/$cas
    
    if [ "`ls -d $local/$OUTPUT/*/$cas`" != "" ] ; then
       echo ON TRAITE LE CAS $cas
       for s in $listeconfig ; do
         case $cas in
            arm_cu2) pdf=$local/$OUTPUT/$s/$cas/tout.pdf ; lp= ;;
            *) pdf=$local/$OUTPUT/$s/$cas/tmp12.pdf ; lp="--landscape"
         esac
         echo pdf $pdf
         if [ -f $pdf ] ; then
            listepdf="$listepdf $pdf"
         fi
	 echo 'listepdf'
         echo $listepdf
       done

       if [ "$listepdf" != "" ] ; then
             if [ "$okpdfjam" = 1 ] ; then
             pdfjam $listepdf --outfile $local/$OUTPUT/`echo $cas | sed -e 's/\///'`.pdf $lp 
             else
             pdftk $listepdf cat output $local/$OUTPUT/`echo $cas | sed -e 's/\///'`.pdf $lp 
             fi
       fi
    fi
done

fi # i_diag







