mkdir -p TMP
cd TMP
listesims="H2002 CTRL4 EPS1 EPS05 EDDZ0 EDDZ05 AFACT1 AFACT03 THM1 SP "
var=temp

for var in temp vent C B s_pblh pblh zmax_th a w f  ; do
# for var in pblh ; do

if [ "$var" = "temp" ] ; then
   legx=0.2 ; legy=0.8
   ymin=302 ; ymax=310
elif [ "$var" = "vent" ] ; then
   legx=0.8 ; legy=0.5
   ymin=5 ; ymax=12
elif [ "$var" = "C" ] ; then
   legx=0.2 ; legy=0.8
   ymin=0 ; ymax=0.5
elif [ "$var" = "B" ] ; then
   legx=0.2 ; legy=0.5
   ymin=8 ; ymax=15
elif [ "$var" = "pblh" ] ; then
   legx=0.2 ; legy=0.8
   ymin=800 ; ymax=1600
elif [ "$var" = "zmax_th" ] ; then
   legx=0.2 ; legy=0.8
   ymin=900 ; ymax=1600
elif [ "$var" = "s_pblh" ] ; then
   legx=0.2 ; legy=0.5
   ymin=500 ; ymax=1500
elif [ "$var" = "a" ] ; then
   legx=0.8 ; legy=0.8
   ymin=0. ; ymax=0.4
elif [ "$var" = "f" ] ; then
   legx=0.8 ; legy=0.8
   ymin=0. ; ymax=1.
elif [ "$var" = "w" ] ; then
   legx=0.8 ; legy=0.8
   ymin=0. ; ymax=5
fi

cat <<eod>| tmp.param
legend $legx, $legy
world 0, $ymin, 6, $ymax
xaxis label "Temps (heures)"
yaxis label "$var"
s0 linewidth 12
s1 linewidth 12
s2 linewidth 4
s3 linewidth 4
s4 linewidth 4
s5 linewidth 4
s6 linewidth 4
s7 linewidth 4
s8 linewidth 4
s9 linewidth 4
s10 linewidth 4
s11 linewidth 4
s12 linewidth 4
eod
cas=24SC
for sim in $listesims ; do
ln -sf ../$sim/$cas/${var}_s.x $sim
done
xmgrace -legend load $listesims -param tmp.param -hardcopy -hdevice EPS -printfile tmp.eps
epstopdf tmp.eps -o=$var.pdf

done

pdfjam --nup 2x2 temp.pdf vent.pdf C.pdf B.pdf --landscape --outfile surf.pdf
# pdfjam --nup 2x2 pblh.pdf f.pdf a.pdf w.pdf --landscape --outfile therm.pdf
pdfjam --nup 2x2 pblh.pdf f.pdf C.pdf w.pdf --landscape --outfile therm.pdf
evince surf.pdf 
convert -density 144 surf.pdf surf.png
convert -density 144 therm.pdf therm.png
