#!/bin/csh

pwd

set min=$1
set max=$2
set zmax=$3
set hmax=`echo $4 | awk ' { print $1 * 0.4 + 0.1 } '`
set post=$5
shift
shift
shift
shift
shift


# Caclul de l'espacement des tickmarks en x
set dref=`echo $min $max | awk ' { print $2 - $1 } '`
set dix=`echo $dref | awk ' { dix = 10 ^ int ( log ( $1 * 1000. ) / log ( 10. ) ) ; print dix / 1000 } '`
set ii=`echo $dref $dix | awk ' { print int ( $1 / $2 ) } '`
if ( $ii <= 2 ) then
set ftk=0.5
else if ( $ii <= 4 ) then
set ftk=1
else if ( $ii <= 8 ) then
set ftk=2
else
set ftk=5
endif

set tickminx=`echo $dix $ftk | awk ' { print $1 * $2 / 2. } '` 
set tickmajx=`echo $dix $ftk | awk ' { print $1 * $2 } '`

echo '$min $max $dref $dix $ftk $tickmajx'
echo $min $max $dref $dix $ftk $tickmajx


# Caclul de l'espacement des tickmarks en y
set dix=`echo $zmax | awk ' { dix = 10 ^ int ( log ( $1 * 1000. ) / log ( 10. ) ) ; print dix / 1000 } '`
set ii=`echo $zmax $dix | awk ' { print int ( $1 / $2 ) } '`
if ( $ii <= 2 ) then
set ftk=0.5
else if ( $ii <= 4 ) then
set ftk=1
else if ( $ii <= 8 ) then
set ftk=2
else
set ftk=5
endif

set tickminy=`echo $dix $ftk | awk ' { print $1 * $2 / 2. } '` 
set tickmajy=`echo $dix $ftk | awk ' { print $1 * $2 } '`

echo '$min $max $zmax $dix $ftk $tickmajy'
echo $min $max $zmax $dix $ftk $tickmajy

cat << eod > ! tt.xmgr
# ACE/gr parameter file
#
version 40102
page layout free
ps linewidth begin 1
ps linewidth increment 2
hardcopy device 1
page 5
page inout 5
link page off
default linestyle 1
default linewidth 1
default color 1
default char size 1.000000
default font 4
default font source 0
default symbol size 1.000000
timestamp off
timestamp 0.03, 0.03
timestamp linewidth 1
timestamp color 1
timestamp rot 0
timestamp font 4
timestamp char size 1.000000
timestamp def "Tue Jan  2 17:18:16 2001"
with g0
g0 on
g0 label off
g0 hidden false
g0 type xy
g0 autoscale type AUTO
g0 fixedpoint off
g0 fixedpoint type 0
g0 fixedpoint xy 0.000000, 0.000000
g0 fixedpoint format general general
g0 fixedpoint prec 6, 6
    world xmin $min
    world xmax $max
    world ymin 0
    world ymax $zmax
    stack world 0, 0, 0, 0 tick 0, 0, 0, 0
    view xmin 0.100000
    view xmax $hmax
    view ymin 0.100000
    view ymax 0.500000
    title ""
    title font 4
    title size 1.500000
    title color 1
    title linewidth 1
    subtitle ""
    subtitle font 4
    subtitle size 1.000000
    subtitle color 1
    subtitle linewidth 1
    s0 symbol 0
    s0 symbol size 1.000000
    s0 symbol fill 0
    s0 symbol color 1
    s0 symbol linewidth 6
    s0 symbol linestyle 1
    s0 symbol center false
    s0 symbol char 0
    s0 skip 0
    s0 linestyle 1
    s0 linewidth 6
    s0 color 1
    s0 fill 0
    s0 fill with color
    s0 fill color 1
    s0 fill pattern 1
    s0 errorbar type BOTH
    s0 errorbar length 1.000000
    s0 errorbar linewidth 1
    s0 errorbar linestyle 1
    s0 errorbar riser on
    s0 errorbar riser linewidth 1
    s0 errorbar riser linestyle 1
    s0 xyz 0.000000, 0.000000
    s0 comment "um"
    s1 symbol 0
    s1 symbol size 1.000000
    s1 symbol fill 0
    s1 symbol color 7
    s1 symbol linewidth 1
    s1 symbol linestyle 1
    s1 symbol center false
    s1 symbol char 0
    s1 skip 0
    s1 linestyle 1
    s1 linewidth 2
    s1 color 2
    s1 fill 0
    s1 fill with color
    s1 fill color 1
    s1 fill pattern 0
    s1 errorbar type BOTH
    s1 errorbar length 1.000000
    s1 errorbar linewidth 1
    s1 errorbar linestyle 1
    s1 errorbar riser on
    s1 errorbar riser linewidth 1
    s1 errorbar riser linestyle 1
    s1 xyz 0.000000, 0.000000
    s1 comment "u0"
    s2 symbol 0
    s2 symbol size 1.000000
    s2 symbol fill 0
    s2 symbol color 2
    s2 symbol linewidth 2
    s2 symbol linestyle 2
    s2 symbol center false
    s2 symbol char 0
    s2 skip 0
    s2 linestyle 3
    s2 linewidth 1
    s2 color 1
    s2 fill 0
    s2 fill with color
    s2 fill color 1
    s2 fill pattern 0
    s2 errorbar type BOTH
    s2 errorbar length 1.000000
    s2 errorbar linewidth 1
    s2 errorbar linestyle 1
    s2 errorbar riser on
    s2 errorbar riser linewidth 1
    s2 errorbar riser linestyle 1
    s2 xyz 0.000000, 0.000000
    s2 comment "vm"
    xaxis  tick on
    xaxis  tick major $tickmajx
    xaxis  tick minor $tickminx
    xaxis  tick offsetx 0.000000
    xaxis  tick offsety 0.000000
    xaxis  label ""
    xaxis  label layout para
    xaxis  label place auto
    xaxis  label char size 1.000000
    xaxis  label font 4
    xaxis  label color 1
    xaxis  label linewidth 1
    xaxis  ticklabel on
    xaxis  ticklabel type auto
    xaxis  ticklabel prec 5
    xaxis  ticklabel format general
    xaxis  ticklabel append ""
    xaxis  ticklabel prepend ""
    xaxis  ticklabel layout horizontal
    xaxis  ticklabel place on ticks
    xaxis  ticklabel skip 0
    xaxis  ticklabel stagger 0
    xaxis  ticklabel op bottom
    xaxis  ticklabel sign normal
    xaxis  ticklabel start type auto
    xaxis  ticklabel start 0.000000
    xaxis  ticklabel stop type auto
    xaxis  ticklabel stop 0.000000
    xaxis  ticklabel char size 1.000000
    xaxis  ticklabel font 4
    xaxis  ticklabel color 1
    xaxis  ticklabel linewidth 1
    xaxis  tick major on
    xaxis  tick minor on
    xaxis  tick default 6
    xaxis  tick in
    xaxis  tick major color 1
    xaxis  tick major linewidth 1
    xaxis  tick major linestyle 1
    xaxis  tick minor color 1
    xaxis  tick minor linewidth 1
    xaxis  tick minor linestyle 1
    xaxis  tick log off
    xaxis  tick size 1.000000
    xaxis  tick minor size 0.500000
    xaxis  bar off
    xaxis  bar color 1
    xaxis  bar linestyle 1
    xaxis  bar linewidth 1
    xaxis  tick major grid off
    xaxis  tick minor grid off
    xaxis  tick op both
    xaxis  tick type auto
    xaxis  tick spec 0
    yaxis  tick on
    yaxis  tick major $tickmajy
    yaxis  tick minor $tickminy
    yaxis  tick offsetx 0.000000
    yaxis  tick offsety 0.000000
    yaxis  label ""
    yaxis  label layout para
    yaxis  label place auto
    yaxis  label char size 1.000000
    yaxis  label font 4
    yaxis  label color 1
    yaxis  label linewidth 1
    yaxis  ticklabel on
    yaxis  ticklabel type auto
    yaxis  ticklabel prec 5
    yaxis  ticklabel format general
    yaxis  ticklabel append ""
    yaxis  ticklabel prepend ""
    yaxis  ticklabel layout horizontal
    yaxis  ticklabel place on ticks
    yaxis  ticklabel skip 0
    yaxis  ticklabel stagger 0
    yaxis  ticklabel op left
    yaxis  ticklabel sign normal
    yaxis  ticklabel start type auto
    yaxis  ticklabel start 0.000000
    yaxis  ticklabel stop type auto
    yaxis  ticklabel stop 0.000000
    yaxis  ticklabel char size 1.000000
    yaxis  ticklabel font 4
    yaxis  ticklabel color 1
    yaxis  ticklabel linewidth 1
    yaxis  tick major on
    yaxis  tick minor on
    yaxis  tick default 6
    yaxis  tick in
    yaxis  tick major color 1
    yaxis  tick major linewidth 1
    yaxis  tick major linestyle 1
    yaxis  tick minor color 1
    yaxis  tick minor linewidth 1
    yaxis  tick minor linestyle 1
    yaxis  tick log off
    yaxis  tick size 1.000000
    yaxis  tick minor size 0.500000
    yaxis  bar off
    yaxis  bar color 1
    yaxis  bar linestyle 1
    yaxis  bar linewidth 1
    yaxis  tick major grid off
    yaxis  tick minor grid off
    yaxis  tick op both
    yaxis  tick type auto
    yaxis  tick spec 0
    zeroxaxis  tick on
    zeroxaxis  tick major 5
    zeroxaxis  tick minor 2.5
    zeroxaxis  tick offsetx 0.000000
    zeroxaxis  tick offsety 0.000000
    zeroxaxis  label ""
    zeroxaxis  label layout para
    zeroxaxis  label place auto
    zeroxaxis  label char size 1.000000
    zeroxaxis  label font 4
    zeroxaxis  label color 1
    zeroxaxis  label linewidth 1
    zeroxaxis  ticklabel off
    zeroxaxis  ticklabel type auto
    zeroxaxis  ticklabel prec 5
    zeroxaxis  ticklabel format general
    zeroxaxis  ticklabel append ""
    zeroxaxis  ticklabel prepend ""
    zeroxaxis  ticklabel layout horizontal
    zeroxaxis  ticklabel place on ticks
    zeroxaxis  ticklabel skip 0
    zeroxaxis  ticklabel stagger 0
    zeroxaxis  ticklabel op bottom
    zeroxaxis  ticklabel sign normal
    zeroxaxis  ticklabel start type auto
    zeroxaxis  ticklabel start 0.000000
    zeroxaxis  ticklabel stop type auto
    zeroxaxis  ticklabel stop 0.000000
    zeroxaxis  ticklabel char size 1.000000
    zeroxaxis  ticklabel font 4
    zeroxaxis  ticklabel color 1
    zeroxaxis  ticklabel linewidth 1
    zeroxaxis  tick major off
    zeroxaxis  tick minor on
    zeroxaxis  tick default 6
    zeroxaxis  tick in
    zeroxaxis  tick major color 1
    zeroxaxis  tick major linewidth 1
    zeroxaxis  tick major linestyle 1
    zeroxaxis  tick minor color 1
    zeroxaxis  tick minor linewidth 1
    zeroxaxis  tick minor linestyle 1
    zeroxaxis  tick log off
    zeroxaxis  tick size 1.000000
    zeroxaxis  tick minor size 0.500000
    zeroxaxis  bar off
    zeroxaxis  bar color 1
    zeroxaxis  bar linestyle 1
    zeroxaxis  bar linewidth 1
    zeroxaxis  tick major grid off
    zeroxaxis  tick minor grid off
    zeroxaxis  tick op both
    zeroxaxis  tick type auto
    zeroxaxis  tick spec 0
    zeroyaxis  tick on
    zeroyaxis  tick major 500
    zeroyaxis  tick minor 250
    zeroyaxis  tick offsetx 0.000000
    zeroyaxis  tick offsety 0.000000
    zeroyaxis  label ""
    zeroyaxis  label layout para
    zeroyaxis  label place auto
    zeroyaxis  label char size 1.000000
    zeroyaxis  label font 4
    zeroyaxis  label color 1
    zeroyaxis  label linewidth 1
    zeroyaxis  ticklabel off
    zeroyaxis  ticklabel type auto
    zeroyaxis  ticklabel prec 5
    zeroyaxis  ticklabel format general
    zeroyaxis  ticklabel append ""
    zeroyaxis  ticklabel prepend ""
    zeroyaxis  ticklabel layout horizontal
    zeroyaxis  ticklabel place on ticks
    zeroyaxis  ticklabel skip 0
    zeroyaxis  ticklabel stagger 0
    zeroyaxis  ticklabel op left
    zeroyaxis  ticklabel sign normal
    zeroyaxis  ticklabel start type auto
    zeroyaxis  ticklabel start 0.000000
    zeroyaxis  ticklabel stop type auto
    zeroyaxis  ticklabel stop 0.000000
    zeroyaxis  ticklabel char size 1.000000
    zeroyaxis  ticklabel font 4
    zeroyaxis  ticklabel color 1
    zeroyaxis  ticklabel linewidth 1
    zeroyaxis  tick major off
    zeroyaxis  tick minor on
    zeroyaxis  tick default 6
    zeroyaxis  tick in
    zeroyaxis  tick major color 1
    zeroyaxis  tick major linewidth 1
    zeroyaxis  tick major linestyle 1
    zeroyaxis  tick minor color 1
    zeroyaxis  tick minor linewidth 1
    zeroyaxis  tick minor linestyle 1
    zeroyaxis  tick log off
    zeroyaxis  tick size 1.000000
    zeroyaxis  tick minor size 0.500000
    zeroyaxis  bar off
    zeroyaxis  bar color 1
    zeroyaxis  bar linestyle 1
    zeroyaxis  bar linewidth 1
    zeroyaxis  tick major grid off
    zeroyaxis  tick minor grid off
    zeroyaxis  tick op both
    zeroyaxis  tick type auto
    zeroyaxis  tick spec 0
    legend off
    legend loctype view
    legend layout 0
    legend vgap 2
    legend hgap 1
    legend length 4
    legend box off
    legend box fill off
    legend box fill with color
    legend box fill color 0
    legend box fill pattern 1
    legend box color 1
    legend box linewidth 1
    legend box linestyle 1
    legend x1 0.8
    legend y1 0.8
    legend font 4
    legend char size 1.000000
    legend linestyle 1
    legend linewidth 1
    legend color 1
    frame on
    frame type 0
    frame linestyle 1
    frame linewidth 1
    frame color 1
    frame fill off
    frame background color 0
eod

echo xmgrace -param tt.xmgr -hardcopy -hdevice EPS -printfile $post.eps $*
xmgrace -hardcopy -hdevice EPS -printfile $post.eps $* -param tt.xmgr 

