#!/bin/bash

sub=`basename \`pwd\`` ; main=`cd .. ; basename \`pwd\`` ; phys=`cd ../.. ; basename \`pwd\``
echo $sub $main $phys
cas=$main/$sub

cas=`basename \`pwd\`` ; phys=`cd .. ; basename \`pwd\``

cat <<eod>| tmp.jnl
DEFINE VIEWPORT/XLIM=0.,1/YLIM=0,.4 V1
   DEFINE VIEWPORT/XLIM=0.,1/YLIM=.3,1 V2
   use histhf
   set view V2
   reg/z=100000:1000/t="01-OCT-2011 00:00:00":"15-DEC-2011 00:00:00"
   shade/lev=(0.5)(1,5,1)(5,30,5)(40,100,10)/title="$cas $phys" rneb*100
   contour/o geop/9.8
   set view V1
   let pr=86400*(pluc+plul)
   plot/title="Precip (mm/day)"/line=7 pr
   plot/o/title="PLUL" 86400*plul
   plot/o/title="PLUC"/line=3 86400*pluc
   frame/file=neb.gif
   quit
eod
ferret -gif -script tmp.jnl
convert neb.gif tmp12.pdf
