#!/bin/bash


cat <<eod>| def.list
NPv2.B NPv2 iflag_ratqs=2
NPv2.3 NPv2 ratqshaut=0.25
NPv2.4 NPv2 f_cdrag_oce=1.
NPv2.5 NPv2 wdens=1.e-12
NPv2.6 NPv2 elcrit=0.0001
NPv2F.12A NPv2F.12 alp_offset=-0.5
NPv2F.12B NPv2F.12 alp_offset=-1
NPv2F.12C NPv2F.12 alp_offset=-0.5,f_drag_oce=0.8
eod

liste="NPv2F.12B NPv2F.12C "


for sim in $liste ; do


# Recuperation des fichiers .def 
################################

REF=`grep '^'$sim def.list | awk ' { print $2 } '`

echo $REF

mkdir -p $sim
for file in run.def lmdz1d.def gcm.def config.def ; do
cp $REF/$file  $sim/
done

#2# Modification de physiq.def et des fichiers *data de la convection
#--------------------------------------------------------------------
for def in `grep '^'$sim def.list | awk ' { print $3 } ' | sed -e 's/,/ /g'` ; do
param=`echo $def | awk -F= ' { print $1 } '`
value=`echo $def | awk -F= ' { print $2 } '`

orig=${REF}/
cible=${sim}/

sed -e 's/'$param'=.*.$/'$param=$value'/' ${orig}physiq.def >| ${cible}physiq.def

for file in wake ep conv ; do
if [ -f ${orig}${file}_param.data ] ; then
sed -e 's:^.*.'"$param:$value $param:" ${orig}${file}_param.data >| ${cible}${file}_param.data
fi
done

done

cd $sim

ln -s ../d_toga .
ln -s ../lmdz1d.e .
ln -s ../diags .

echo EXECUTION $sim
../xqt.x
../diags.x $sim

cd ..

done
