#!/bin/bash

#########################################################################
# Verification de a convergence du modele par rapport aux versions
# precedentes
# + 1+1=2
#########################################################################


if [ -f start.nc ] ; then
  im=`ncdump -h start.nc  | grep rlonu | head -1 | awk ' { print $3 -1 } '`
  jm=`ncdump -h start.nc  | grep rlatv | head -1 | awk ' { print $3 } '`
  lm=`ncdump -h start.nc  | grep sigs | head -1 | awk ' { print $3 } '`
  resolution=${im}x${jm}x${lm}
  echo Test en resolution $resolution
else
   echo Ce script doit s executer sur un repertoire contenant un etat initial start.nc ; exit
fi

if [ ! -f gcm.install ] ; then
   if [ ! -f gcm.e ] ; then
      echo pas de modele preexistant ; exit
   fi
   mv gcm.e gcm.install
fi
parallel=none

# Tests automatiques
resu="$resubench/$BENCH"
ref="$latest/$BENCH"

# Tests individuels
ref=`pwd`/INSTALL
resu=`pwd`/RESU
mkdir -p $resu
mkdir -p $ref

std=1

if [ `whoami` = lmdz ] ; then
   get="ln -sf /u/lmdz/WWW/Distrib"
else
   get="wget http://www.lmd.jussieu.fr/~lmdz/Distrib"
fi


#===============================================================
# Option pour le debug du script check_version lui meme qui consiste a ne
# pars reexecuter l'installation et les simulations mais a simplement
# refaire les diff sur des simulations existantes.
diagonly=0
while (($# > 0))
  do
  case $1 in
      "-h") cat <<fin
check_version.sh [-h] version [version_ref]
version is the name of the version of LMDZ to be checked modipsl.version.tar.gz
version_ref is the version to be compared with.
Default "latest".
enfo
fin
          exit;;

      "-gcm") gcm="$2" ; shift ; shift ;;
      "-ref") ref="$2" ; shift ; shift ;;
      "-resu") resu="$2" ; shift ; shift ;;
      *)
          version="$1" ; shift ; if [ "$#" = 1 ] ; then version_ref=$1 ; shift ; fi ;;
   esac
done


#===============================================================
# Installation eventuelle du modele
#===============================================================

#########################################################################
   echo Verification de la convergence avec la version precedente
#########################################################################
# Faite soit sur les restart.nc soit sur une exctraction de ps.nc
# A une epoque, ne marchait paps avec les restart a cause des traceurs.
# Le 2014/01/30, ne marchait plus avec ps.nc car les axes de lattiudes
# s'étaient inversés pour une raison inconnue.
# 2016/06/21 : on utilise deux versions de la physique pour le test.

# Aide a l'interpretation de resultats problematiques
#    Les resultats de la simu ancienne physique sont directement 
#      dans BENC*
#    Les resultats de la nouvelle physique sont dans SIM1 utilise
#      pour 1+1=2
#    Les resultats de la simulation debug sont dans SIMD

   if [ $std = 1 ] ; then
   \cp -f physiq.def_L39_AR40.0 physiq.def
   \cp -f traceur.def_noice traceur.def

   if [ ! -f $ref/restart.nc ] ; then
      \rm sechiba_out_2.nc sechiba_history.nc sechiba_rest_out.nc
      echo Execution de la simulation de reference ancienne physique
      ./gcm.install > $ref/list0
      mv restar*.nc histda* $ref
   fi

   \rm sechiba_out_2.nc sechiba_history.nc sechiba_rest_out.nc
   mkdir -p $resu
   echo Execution de la simulation test ancienne physique
   ./compilegcm.sh
   ./gcm.e > $resu/list0
   if [ -f restartphy.nc ] ; then
      ncks -M -m -h -v ps -O restart.nc $resu/ps.nc
      cp restart.nc $resu/restart.nc
      cmp -s $resu/restart.nc $ref/restart.nc
      if [ $? = 0 ] ; then converge=S ; else converge=s ; fi
   else
      converge=-
   fi
   echo CONVERGE $converge
   fi

#########################################################################
   echo Verification de 1+1=2
#########################################################################
# 2016/06/21 : 1+1=2 est fait sur la nouvelle physique
# Permet de tester aussi la convergence numérique

   suf=NPv5.5

   cp -f traceur.def_ice traceur.def
   cp -f config.def_oraer config.def
   if [ -f physiq.def_$suf ] ; then \cp -f physiq.def_$suf physiq.def ; fi
   if [ $diagonly = 0 ] ; then 
       if [ ! -f unpun.sh ] ; then $get/unpun.sh ; fi
       chmod +x unpun.sh ; ./unpun.sh -parallel $parallel
   fi
   cmp -s SIM2/ps_end.nc SIM1+1/ps_end.nc
   if [ $? = 0 ] ; then
       unpun=OK
   else
       unpun=-
   fi

   if [ ! -f $ref/restart$suf.nc ] ; then
      cp -r SIM1 SIM1ref
      cd SIM1ref
      \rm sechiba_out_2.nc sechiba_history.nc sechiba_rest_out.nc
      echo Execution de la simulation de reference nouvelle physique
      ../gcm.install > $ref/list1
      mv restart.nc $ref/restart$suf.nc
      cd ..
   fi

# 2016/06/21 : comparaison des versions nouvelles physique (dans SIM1)
   if [ -f SIM1/restartphy.nc ] ; then
      ncks -M -m -h -v ps -O SIM1/restart.nc $resu/ps$suf.nc
      cp SIM1/restart.nc $resu/restart$suf.nc
      \rm sechiba_out_2.nc sechiba_history.nc sechiba_rest_out.nc
      cmp -s $resu/restart$suf.nc $ref/restart$suf.nc
      if [ $? = 0 ] ; then convergeNP=N ; else convergeNP=n ; fi
   else
      convergeNP=-
   fi

#########################################################################
   echo Verification en mode debug + parallele
#########################################################################
   if [ -f compilegcm.sh ] ; then
      \mv -f gcm.e $resu/gcm.prod
      ./compilegcm.sh -debug
      cp -r SIM1 SIMD
      \rm sechiba_out_2.nc sechiba_history.nc sechiba_rest_out.nc
      cd SIMD ; ../gcm.e > listing 2>&1 ; cd ../
      if [ -f SIMD/restartphy.nc ] ; then
         cmp -s SIMD/restart.nc SIM1/restart.nc
         if [ $? = 0 ] ; then convergeD=D ; else convergeD=d ; fi
      else
         convergeD=-
      fi
   fi

#########################################################################
   echo Verification de initialisation
#########################################################################
   rm -rf ../INIT
   mkdir ../INIT
   cp *def ../INIT
   cd ../INIT
   pwd
   if [ ! -f initialisation.sh ] ; then $get/initialisation.sh ; fi
   sed -e 's/grid_resolution=48x36x39/grid_resolution='$resolution'/' initialisation.sh > ini.sh
   chmod +x ini.sh ; ./ini.sh
   if [ -f limit.nc ] ; then
      var=Tsoil01srf01
      mkdir -p $resubench/START$resolution
      ncks -M -m -h -v $var startphy.nc -O  $resubench/START$resolution/$var.nc
      cp startphy.nc $resubench/START$resolution/
#!     cmp -s  $resubench/START$resolution/$var.nc  $latest/START$resolution/$var.nc
      cmp -s  $resubench/START$resolution/startphy.nc  $latest/START$resolution/startphy.nc
      if [ $? = 0 -o ! -d $latest/START$resolution ] ; then
          init=OK
      else
          init=noc
      fi
   else
      init=-
   fi
   bench=OK


svnrel=`svn info LMDZ5 | grep 'Changed Rev' | head -1 | awk ' { print $4 } '`
#FH 20160822
if [ "$svnrel" = "" ] ; then
  svnrel=`svn info LMDZ5 | grep vision | head -1 | awk ' { print $2 } '`
fi

ccc=$converge$convergeNP$convergeD
if [ "$ccc" = "SND" ] ; then ccc="OK " ;  fi

cat <<eod
echo Fin
      Test local LMD network, gfortran, 48x36x19
      ==========================================

	Bench	Conv.	1+1=2	Init
	run	Nnum.
		/prev.
eod

echo '	'$bench'	'$ccc '	'$unpun'	'$init

# mv /tmp/LMDZ$version /tmp/lmdz$$.$version
exit
rm -fr $MODEL
