#!/bin/bash

#####################################################################
# This script is managing the call to setup.sh
# F. Hourdin, hourdin@lmd.jussieu.fr
#####################################################################

#-----------------------------------------------------------
# Version of the tar file on http://www.lmd.jussieu.fr/~lmdz/pub/src
# Can be updated to a more recent svn version with svn=
version=20200128.trunk
#svn="-r 3590"
svn=""

#-----------------------------------------------------------
# Grid number of points IMxJMxLM
resol=144x142x79

#-----------------------------------------------------------
# avec instalation de LMDZ : -install
install=""
install=-install

#-----------------------------------------------------------
# Initial state and Boundary conditions
# -------------------------------------
# init=   1: to create a new start in INT
#         0: to read start files in INIT
#       SIM: to read start files from previous simulation SIM
# limit.nc and aerosols forcing are put in ./LIMIT
init=1

#-----------------------------------------------------------
# Initia/final month for simulation
# if $init=1, the INIT file will be calles start.200001.nc
# But the data correspond in fact to another day.
mthini=200001
mthend=200501

#-----------------------------------------------------------
# Length of elementary simulations yr (year) or mo (month)
freq=yr

#-----------------------------------------------------------
# Activation of Cosp simulator
cosp="-cosp"
cosp=""

#-----------------------------------------------------------
# climato=1 : Climatological SSTs with 360-day calendar 
#        =0 : interannual SSTs with true calendar
climato=1

#-----------------------------------------------------------
# Using XIOS for IOs
xios="-xios"
xios=""

#-----------------------------------------------------------
# Nudging: Can be activated only with climato=0 and freq=mo
nudging="-nudging"
nudging=""

#-----------------------------------------------------------
# Changing orchidee revision (for experts) : available : 5004, 3013
orchidee_rev="5004"
if [ "$orchidee_rev" != "" ] ; then for f in script_SIMU setup.sh ; do sed -i -e 's/orchidee_rev=.*.$/orchidee_rev='$orchidee_rev'/' $f ; done ; fi

#-----------------------------------------------------------
# Running a series of simulation.
# -------------------------------
# By default, the series is done on various versions of phyisiq.def 
# to be chosen among DEF/PHYS/physiq.def_*
physics="NPv6.1"

for phys in $physics ; do
   sed -e 's/ifl_pbltree=1/ifl_pbltree=0/' DEF/PHYS/physiq.def_$phys >| DEF/physiq.def
   # name of simulation. Equal to $phys by default
   name=$phys
   ./setup.sh -d $resol -f $freq -v $version -name $name $svn $install -init $init $cosp $xios -mthini $mthini -mthend $mthend $nudging -climato $climato
   if [ $init = 1 ] ; then init=0 ; fi # init=1 is possible only for the first simulation
done
