!
! $Header$
!
SUBROUTINE massdair( p, masse )
  !
  ! *********************************************************************
  !   ....  Calcule la masse d'air  dans chaque maille   ....
  ! *********************************************************************
  !
  !    Auteurs : P. Le Van , Fr. Hourdin  .
  !   ..........
  !
  !  ..    p                      est  un argum. d'entree pour le s-pg ...
  !  ..  masse                    est un  argum.de sortie pour le s-pg ...
  !
  !  ....  p est defini aux interfaces des llm couches   .....
  !
  USE comgeom_mod_h
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h
IMPLICIT NONE
  !


  !
  !  .....   arguments  ....
  !
  REAL :: p(ip1jmp1,llmp1), masse(ip1jmp1,llm)

  !   ....  Variables locales  .....

  INTEGER :: l,ij
  REAL :: massemoyn, massemoys

  REAL :: SSUM
  !
  !
  !   Methode pour calculer massebx et masseby .
  !   ----------------------------------------
  !
  !    A chaque point scalaire P (i,j) est affecte 4 coefficients d'aires
  !   alpha1(i,j)  calcule  au point ( i+1/4,j-1/4 )
  !   alpha2(i,j)  calcule  au point ( i+1/4,j+1/4 )
  !   alpha3(i,j)  calcule  au point ( i-1/4,j+1/4 )
  !   alpha4(i,j)  calcule  au point ( i-1/4,j-1/4 )
  !
  !    Avec  alpha1(i,j) = aire(i+1/4,j-1/4)/ aire(i,j)
  !
  !    N.B .  Pour plus de details, voir s-pg  ...  iniconst ...
  !
  !
  !
  !   alpha4 .         . alpha1    . alpha4
  !    (i,j)             (i,j)       (i+1,j)
  !
  !         P .        U .          . P
  !       (i,j)       (i,j)         (i+1,j)
  !
  !   alpha3 .         . alpha2    .alpha3
  !    (i,j)              (i,j)     (i+1,j)
  !
  !         V .        Z .          . V
  !       (i,j)
  !
  !   alpha4 .         . alpha1    .alpha4
  !   (i,j+1)            (i,j+1)   (i+1,j+1)
  !
  !         P .        U .          . P
  !      (i,j+1)                    (i+1,j+1)
  !
  !
  !
  !                   On  a :
  !
  !    massebx(i,j) = masse(i  ,j) * ( alpha1(i  ,j) + alpha2(i,j))   +
  !               masse(i+1,j) * ( alpha3(i+1,j) + alpha4(i+1,j) )
  ! localise  au point  ... U (i,j) ...
  !
  !    masseby(i,j) = masse(i,j  ) * ( alpha2(i,j  ) + alpha3(i,j  )  +
  !               masse(i,j+1) * ( alpha1(i,j+1) + alpha4(i,j+1)
  ! localise  au point  ... V (i,j) ...
  !
  !
  !=======================================================================

  DO    l = 1 , llm
  !
    DO    ij     = 1, ip1jmp1
     masse(ij,l) = airesurg(ij) * ( p(ij,l) - p(ij,l+1) )
    ENDDO
  !
    DO   ij = 1, ip1jmp1,iip1
     masse(ij+ iim,l) = masse(ij,l)
    ENDDO
  !
  !   DO    ij     = 1,  iim
  !    masse(   ij   ,l) = masse(   ij   ,l) * aire(  ij    )
  !    masse(ij+ip1jm,l) = masse(ij+ip1jm,l) * aire(ij+ip1jm)
  !   ENDDO
  !    massemoyn         = SSUM(iim,masse(   1   ,l),1)/ apoln
  !    massemoys         = SSUM(iim,masse(ip1jm+1,l),1)/ apols
  !   DO    ij     = 1, iip1
  !    masse(   ij   ,l )    = massemoyn
  !    masse(ij+ip1jm,l )    = massemoys
  !   ENDDO

  END DO
  !
  RETURN
END SUBROUTINE massdair
