MODULE lmdz_is_nan

CONTAINS

#ifdef CPP_USE_IEEE_IS_NAN  

  ELEMENTAL FUNCTION is_nan(x)
  USE, INTRINSIC :: ieee_arithmetic, ONLY : IEEE_IS_NAN
  IMPLICIT NONE
    REAL, INTENT(IN)    :: x  
    LOGICAL :: is_nan

    is_nan=IEEE_IS_NAN(x)

  END FUNCTION is_nan

#else
  ELEMENTAL FUNCTION is_nan(x)
  IMPLICIT NONE
    REAL, INTENT(IN)    :: x  
    LOGICAL :: is_nan

    is_nan=isnan(x)  
  END FUNCTION is_nan
#endif

END MODULE lmdz_is_nan