SUBROUTINE RRTM_KGB9

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 9:  1180-1390 cm-1 (low - H2O,CH4; high - CH4)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.
!     G.Mozdzynski March 2011 read constants from files
!     ABozzo 201306 updated to rrtmg v4.85
!     T. Wilhelmsson and K. Yessad (Oct 2013) Geometry and setup refactoring.
!      F. Vana  05-Mar-2015  Support for single precision
!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK, JPHOOK
USE YOMLUN    ,ONLY : NULRAD
USE MPL_MODULE,ONLY : MPL_BROADCAST
USE YOMTAG    ,ONLY : MTAGRAD
USE YOMMP0    , ONLY : NPROC, MYPROC

USE YOERRTO9 , ONLY : KAO     ,KBO     ,SELFREFO   ,FORREFO, FRACREFAO  ,&
 & FRACREFBO, KAO_MN2O, KBO_MN2O, KAO_D, KBO_D


!     ------------------------------------------------------------------

IMPLICIT NONE
REAL(KIND=JPHOOK) :: ZHOOK_HANDLE


#include "abor1.intfb.h"

IF (LHOOK) CALL DR_HOOK('RRTM_KGB9',0,ZHOOK_HANDLE)

IF( MYPROC==1 )THEN
  READ(NULRAD,ERR=1001) KAO_D,KBO_D
  KAO = REAL(KAO_D,JPRB)
  KBO = REAL(KBO_D,JPRB)
ENDIF
IF( NPROC>1 )THEN
  CALL MPL_BROADCAST (KAO,MTAGRAD,1,CDSTRING='RRTM_KGB9:')
  CALL MPL_BROADCAST (KBO,MTAGRAD,1,CDSTRING='RRTM_KGB9:')
ENDIF

! Planck fractions mapping level : P=212.7250 mb, T = 223.06 K
      FRACREFAO(:, 1) = (/ &
     &  1.8129E-01_JPRB,1.6119E-01_JPRB,1.3308E-01_JPRB,1.2342E-01_JPRB,1.1259E-01_JPRB,9.7580E-02_JPRB, &
     &  7.9176E-02_JPRB,5.8541E-02_JPRB,3.9084E-02_JPRB,4.2419E-03_JPRB,3.4314E-03_JPRB,2.6935E-03_JPRB, &
     &  1.9404E-03_JPRB,1.2218E-03_JPRB,4.5263E-04_JPRB,6.0909E-05_JPRB/)
      FRACREFAO(:, 2) = (/ &
     &  1.9665E-01_JPRB,1.5640E-01_JPRB,1.3101E-01_JPRB,1.2153E-01_JPRB,1.1037E-01_JPRB,9.6043E-02_JPRB, &
     &  7.7856E-02_JPRB,5.7547E-02_JPRB,3.8670E-02_JPRB,4.1955E-03_JPRB,3.4104E-03_JPRB,2.6781E-03_JPRB, &
     &  1.9245E-03_JPRB,1.2093E-03_JPRB,4.4113E-04_JPRB,6.0913E-05_JPRB/)
      FRACREFAO(:, 3) = (/ &
     &  2.0273E-01_JPRB,1.5506E-01_JPRB,1.3044E-01_JPRB,1.2043E-01_JPRB,1.0952E-01_JPRB,9.5384E-02_JPRB, &
     &  7.7157E-02_JPRB,5.7176E-02_JPRB,3.8379E-02_JPRB,4.1584E-03_JPRB,3.3836E-03_JPRB,2.6412E-03_JPRB, &
     &  1.8865E-03_JPRB,1.1791E-03_JPRB,4.2094E-04_JPRB,4.7410E-05_JPRB/)
      FRACREFAO(:, 4) = (/ &
     &  2.0272E-01_JPRB,1.5963E-01_JPRB,1.2913E-01_JPRB,1.2060E-01_JPRB,1.0820E-01_JPRB,9.4685E-02_JPRB, &
     &  7.6544E-02_JPRB,5.6851E-02_JPRB,3.8155E-02_JPRB,4.0913E-03_JPRB,3.3442E-03_JPRB,2.6054E-03_JPRB, &
     &  1.8875E-03_JPRB,1.1263E-03_JPRB,3.7743E-04_JPRB,4.7410E-05_JPRB/)
      FRACREFAO(:, 5) = (/ &
     &  2.0280E-01_JPRB,1.6353E-01_JPRB,1.2910E-01_JPRB,1.1968E-01_JPRB,1.0725E-01_JPRB,9.4112E-02_JPRB, &
     &  7.5828E-02_JPRB,5.6526E-02_JPRB,3.7972E-02_JPRB,4.0205E-03_JPRB,3.3063E-03_JPRB,2.5681E-03_JPRB, &
     &  1.8386E-03_JPRB,1.0757E-03_JPRB,3.5301E-04_JPRB,4.7410E-05_JPRB/)
      FRACREFAO(:, 6) = (/ &
     &  2.0294E-01_JPRB,1.6840E-01_JPRB,1.2852E-01_JPRB,1.1813E-01_JPRB,1.0724E-01_JPRB,9.2946E-02_JPRB, &
     &  7.5029E-02_JPRB,5.6158E-02_JPRB,3.7744E-02_JPRB,3.9632E-03_JPRB,3.2434E-03_JPRB,2.5275E-03_JPRB, &
     &  1.7558E-03_JPRB,1.0080E-03_JPRB,3.5301E-04_JPRB,4.7410E-05_JPRB/)
      FRACREFAO(:, 7) = (/ &
     &  2.0313E-01_JPRB,1.7390E-01_JPRB,1.2864E-01_JPRB,1.1689E-01_JPRB,1.0601E-01_JPRB,9.1791E-02_JPRB, &
     &  7.4224E-02_JPRB,5.5500E-02_JPRB,3.7374E-02_JPRB,3.9214E-03_JPRB,3.1984E-03_JPRB,2.4162E-03_JPRB, &
     &  1.6394E-03_JPRB,9.7275E-04_JPRB,3.5299E-04_JPRB,4.7410E-05_JPRB/)
      FRACREFAO(:, 8) = (/ &
     &  2.0332E-01_JPRB,1.7800E-01_JPRB,1.3286E-01_JPRB,1.1555E-01_JPRB,1.0407E-01_JPRB,9.0475E-02_JPRB, &
     &  7.2452E-02_JPRB,5.4566E-02_JPRB,3.6677E-02_JPRB,3.7889E-03_JPRB,3.0351E-03_JPRB,2.2587E-03_JPRB, &
     &  1.5764E-03_JPRB,9.7270E-04_JPRB,3.5300E-04_JPRB,4.7410E-05_JPRB/)
      FRACREFAO(:, 9) = (/ &
     &  1.9624E-01_JPRB,1.6519E-01_JPRB,1.3663E-01_JPRB,1.1535E-01_JPRB,1.0719E-01_JPRB,9.4156E-02_JPRB, &
     &  7.6745E-02_JPRB,5.6987E-02_JPRB,3.8135E-02_JPRB,4.1626E-03_JPRB,3.4243E-03_JPRB,2.7116E-03_JPRB, &
     &  1.7095E-03_JPRB,9.7271E-04_JPRB,3.5299E-04_JPRB,4.7410E-05_JPRB/)

! Planck fraction mapping level : p=3.20e-2 mb, t = 197.92 k
      FRACREFBO(:) = (/ &
     &  2.0914E-01_JPRB,1.5077E-01_JPRB,1.2878E-01_JPRB,1.1856E-01_JPRB,1.0695E-01_JPRB,9.3048E-02_JPRB, &
     &  7.7645E-02_JPRB,6.0785E-02_JPRB,4.0642E-02_JPRB,4.0499E-03_JPRB,3.3931E-03_JPRB,2.6363E-03_JPRB, &
     &  1.9151E-03_JPRB,1.1963E-03_JPRB,4.3471E-04_JPRB,5.1421E-05_JPRB/)


!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 11, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.



!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.


!     The array KAO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level below 100~ mb.   The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.  The second index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
!     runs over the g-channel (1 to 16).

      KAO_MN2O( 1, :, 1) = (/ &
     & 5.41078E-02_JPRB, 5.59051E-02_JPRB, 5.77620E-02_JPRB, 5.96805E-02_JPRB, 6.16628E-02_JPRB, &
     & 6.37110E-02_JPRB, 6.58272E-02_JPRB, 6.80137E-02_JPRB, 7.02728E-02_JPRB, 7.26069E-02_JPRB, &
     & 7.50185E-02_JPRB, 7.75103E-02_JPRB, 8.00848E-02_JPRB, 8.27449E-02_JPRB, 8.54933E-02_JPRB, &
     & 8.83330E-02_JPRB, 9.12670E-02_JPRB, 9.42984E-02_JPRB, 9.74306E-02_JPRB/)
      KAO_MN2O( 2, :, 1) = (/ &
     & 1.19602E-01_JPRB, 1.22963E-01_JPRB, 1.26417E-01_JPRB, 1.29969E-01_JPRB, 1.33621E-01_JPRB, &
     & 1.37375E-01_JPRB, 1.41235E-01_JPRB, 1.45203E-01_JPRB, 1.49283E-01_JPRB, 1.53477E-01_JPRB, &
     & 1.57789E-01_JPRB, 1.62223E-01_JPRB, 1.66780E-01_JPRB, 1.71466E-01_JPRB, 1.76284E-01_JPRB, &
     & 1.81237E-01_JPRB, 1.86329E-01_JPRB, 1.91564E-01_JPRB, 1.96946E-01_JPRB/)
      KAO_MN2O( 3, :, 1) = (/ &
     & 1.49614E-01_JPRB, 1.53427E-01_JPRB, 1.57337E-01_JPRB, 1.61346E-01_JPRB, 1.65457E-01_JPRB, &
     & 1.69674E-01_JPRB, 1.73997E-01_JPRB, 1.78431E-01_JPRB, 1.82978E-01_JPRB, 1.87641E-01_JPRB, &
     & 1.92422E-01_JPRB, 1.97325E-01_JPRB, 2.02354E-01_JPRB, 2.07510E-01_JPRB, 2.12798E-01_JPRB, &
     & 2.18221E-01_JPRB, 2.23781E-01_JPRB, 2.29484E-01_JPRB, 2.35331E-01_JPRB/)
      KAO_MN2O( 4, :, 1) = (/ &
     & 1.80029E-01_JPRB, 1.84202E-01_JPRB, 1.88472E-01_JPRB, 1.92841E-01_JPRB, 1.97311E-01_JPRB, &
     & 2.01884E-01_JPRB, 2.06564E-01_JPRB, 2.11352E-01_JPRB, 2.16252E-01_JPRB, 2.21264E-01_JPRB, &
     & 2.26393E-01_JPRB, 2.31641E-01_JPRB, 2.37010E-01_JPRB, 2.42504E-01_JPRB, 2.48126E-01_JPRB, &
     & 2.53877E-01_JPRB, 2.59762E-01_JPRB, 2.65783E-01_JPRB, 2.71944E-01_JPRB/)
      KAO_MN2O( 5, :, 1) = (/ &
     & 2.08279E-01_JPRB, 2.13029E-01_JPRB, 2.17888E-01_JPRB, 2.22858E-01_JPRB, 2.27941E-01_JPRB, &
     & 2.33140E-01_JPRB, 2.38458E-01_JPRB, 2.43897E-01_JPRB, 2.49460E-01_JPRB, 2.55150E-01_JPRB, &
     & 2.60969E-01_JPRB, 2.66922E-01_JPRB, 2.73010E-01_JPRB, 2.79237E-01_JPRB, 2.85606E-01_JPRB, &
     & 2.92120E-01_JPRB, 2.98783E-01_JPRB, 3.05598E-01_JPRB, 3.12568E-01_JPRB/)
      KAO_MN2O( 6, :, 1) = (/ &
     & 2.17336E-01_JPRB, 2.22571E-01_JPRB, 2.27931E-01_JPRB, 2.33421E-01_JPRB, 2.39043E-01_JPRB, &
     & 2.44801E-01_JPRB, 2.50697E-01_JPRB, 2.56735E-01_JPRB, 2.62918E-01_JPRB, 2.69251E-01_JPRB, &
     & 2.75735E-01_JPRB, 2.82377E-01_JPRB, 2.89178E-01_JPRB, 2.96142E-01_JPRB, 3.03275E-01_JPRB, &
     & 3.10579E-01_JPRB, 3.18060E-01_JPRB, 3.25720E-01_JPRB, 3.33565E-01_JPRB/)
      KAO_MN2O( 7, :, 1) = (/ &
     & 2.23903E-01_JPRB, 2.29349E-01_JPRB, 2.34926E-01_JPRB, 2.40640E-01_JPRB, 2.46493E-01_JPRB, &
     & 2.52488E-01_JPRB, 2.58628E-01_JPRB, 2.64918E-01_JPRB, 2.71361E-01_JPRB, 2.77961E-01_JPRB, &
     & 2.84721E-01_JPRB, 2.91646E-01_JPRB, 2.98739E-01_JPRB, 3.06005E-01_JPRB, 3.13447E-01_JPRB, &
     & 3.21070E-01_JPRB, 3.28879E-01_JPRB, 3.36877E-01_JPRB, 3.45071E-01_JPRB/)
      KAO_MN2O( 8, :, 1) = (/ &
     & 2.23400E-01_JPRB, 2.28843E-01_JPRB, 2.34418E-01_JPRB, 2.40130E-01_JPRB, 2.45980E-01_JPRB, &
     & 2.51973E-01_JPRB, 2.58112E-01_JPRB, 2.64401E-01_JPRB, 2.70843E-01_JPRB, 2.77442E-01_JPRB, &
     & 2.84202E-01_JPRB, 2.91126E-01_JPRB, 2.98219E-01_JPRB, 3.05485E-01_JPRB, 3.12928E-01_JPRB, &
     & 3.20552E-01_JPRB, 3.28362E-01_JPRB, 3.36362E-01_JPRB, 3.44557E-01_JPRB/)
      KAO_MN2O( 9, :, 1) = (/ &
     & 1.89279E-01_JPRB, 1.94423E-01_JPRB, 1.99707E-01_JPRB, 2.05135E-01_JPRB, 2.10710E-01_JPRB, &
     & 2.16437E-01_JPRB, 2.22319E-01_JPRB, 2.28361E-01_JPRB, 2.34568E-01_JPRB, 2.40943E-01_JPRB, &
     & 2.47492E-01_JPRB, 2.54218E-01_JPRB, 2.61127E-01_JPRB, 2.68224E-01_JPRB, 2.75514E-01_JPRB, &
     & 2.83002E-01_JPRB, 2.90694E-01_JPRB, 2.98594E-01_JPRB, 3.06709E-01_JPRB/)
      KAO_MN2O( 1, :, 2) = (/ &
     & 9.46669E-02_JPRB, 9.77137E-02_JPRB, 1.00858E-01_JPRB, 1.04104E-01_JPRB, 1.07455E-01_JPRB, &
     & 1.10913E-01_JPRB, 1.14483E-01_JPRB, 1.18167E-01_JPRB, 1.21971E-01_JPRB, 1.25896E-01_JPRB, &
     & 1.29948E-01_JPRB, 1.34130E-01_JPRB, 1.38447E-01_JPRB, 1.42903E-01_JPRB, 1.47502E-01_JPRB, &
     & 1.52249E-01_JPRB, 1.57149E-01_JPRB, 1.62207E-01_JPRB, 1.67427E-01_JPRB/)
      KAO_MN2O( 2, :, 2) = (/ &
     & 5.11901E-01_JPRB, 5.24950E-01_JPRB, 5.38331E-01_JPRB, 5.52053E-01_JPRB, 5.66125E-01_JPRB, &
     & 5.80556E-01_JPRB, 5.95354E-01_JPRB, 6.10530E-01_JPRB, 6.26093E-01_JPRB, 6.42052E-01_JPRB, &
     & 6.58418E-01_JPRB, 6.75202E-01_JPRB, 6.92413E-01_JPRB, 7.10062E-01_JPRB, 7.28162E-01_JPRB, &
     & 7.46723E-01_JPRB, 7.65758E-01_JPRB, 7.85277E-01_JPRB, 8.05294E-01_JPRB/)
      KAO_MN2O( 3, :, 2) = (/ &
     & 8.32946E-01_JPRB, 8.45780E-01_JPRB, 8.58813E-01_JPRB, 8.72046E-01_JPRB, 8.85482E-01_JPRB, &
     & 8.99126E-01_JPRB, 9.12980E-01_JPRB, 9.27048E-01_JPRB, 9.41332E-01_JPRB, 9.55837E-01_JPRB, &
     & 9.70565E-01_JPRB, 9.85520E-01_JPRB, 1.00070E+00_JPRB, 1.01612E+00_JPRB, 1.03178E+00_JPRB, &
     & 1.04768E+00_JPRB, 1.06382E+00_JPRB, 1.08021E+00_JPRB, 1.09686E+00_JPRB/)
      KAO_MN2O( 4, :, 2) = (/ &
     & 1.04032E+00_JPRB, 1.05475E+00_JPRB, 1.06937E+00_JPRB, 1.08419E+00_JPRB, 1.09922E+00_JPRB, &
     & 1.11446E+00_JPRB, 1.12991E+00_JPRB, 1.14557E+00_JPRB, 1.16145E+00_JPRB, 1.17755E+00_JPRB, &
     & 1.19387E+00_JPRB, 1.21042E+00_JPRB, 1.22720E+00_JPRB, 1.24421E+00_JPRB, 1.26146E+00_JPRB, &
     & 1.27895E+00_JPRB, 1.29668E+00_JPRB, 1.31465E+00_JPRB, 1.33287E+00_JPRB/)
      KAO_MN2O( 5, :, 2) = (/ &
     & 1.22685E+00_JPRB, 1.24267E+00_JPRB, 1.25870E+00_JPRB, 1.27493E+00_JPRB, 1.29137E+00_JPRB, &
     & 1.30803E+00_JPRB, 1.32490E+00_JPRB, 1.34199E+00_JPRB, 1.35930E+00_JPRB, 1.37683E+00_JPRB, &
     & 1.39459E+00_JPRB, 1.41257E+00_JPRB, 1.43079E+00_JPRB, 1.44925E+00_JPRB, 1.46794E+00_JPRB, &
     & 1.48687E+00_JPRB, 1.50605E+00_JPRB, 1.52547E+00_JPRB, 1.54515E+00_JPRB/)
      KAO_MN2O( 6, :, 2) = (/ &
     & 1.53781E+00_JPRB, 1.55206E+00_JPRB, 1.56645E+00_JPRB, 1.58097E+00_JPRB, 1.59563E+00_JPRB, &
     & 1.61042E+00_JPRB, 1.62535E+00_JPRB, 1.64042E+00_JPRB, 1.65562E+00_JPRB, 1.67097E+00_JPRB, &
     & 1.68646E+00_JPRB, 1.70210E+00_JPRB, 1.71788E+00_JPRB, 1.73380E+00_JPRB, 1.74987E+00_JPRB, &
     & 1.76610E+00_JPRB, 1.78247E+00_JPRB, 1.79899E+00_JPRB, 1.81567E+00_JPRB/)
      KAO_MN2O( 7, :, 2) = (/ &
     & 1.90476E+00_JPRB, 1.91858E+00_JPRB, 1.93251E+00_JPRB, 1.94653E+00_JPRB, 1.96065E+00_JPRB, &
     & 1.97488E+00_JPRB, 1.98921E+00_JPRB, 2.00365E+00_JPRB, 2.01819E+00_JPRB, 2.03283E+00_JPRB, &
     & 2.04758E+00_JPRB, 2.06244E+00_JPRB, 2.07741E+00_JPRB, 2.09248E+00_JPRB, 2.10767E+00_JPRB, &
     & 2.12296E+00_JPRB, 2.13837E+00_JPRB, 2.15388E+00_JPRB, 2.16951E+00_JPRB/)
      KAO_MN2O( 8, :, 2) = (/ &
     & 2.38211E+00_JPRB, 2.39819E+00_JPRB, 2.41438E+00_JPRB, 2.43068E+00_JPRB, 2.44709E+00_JPRB, &
     & 2.46361E+00_JPRB, 2.48024E+00_JPRB, 2.49699E+00_JPRB, 2.51384E+00_JPRB, 2.53082E+00_JPRB, &
     & 2.54790E+00_JPRB, 2.56510E+00_JPRB, 2.58242E+00_JPRB, 2.59985E+00_JPRB, 2.61741E+00_JPRB, &
     & 2.63508E+00_JPRB, 2.65287E+00_JPRB, 2.67078E+00_JPRB, 2.68881E+00_JPRB/)
      KAO_MN2O( 9, :, 2) = (/ &
     & 1.26464E+00_JPRB, 1.28107E+00_JPRB, 1.29772E+00_JPRB, 1.31458E+00_JPRB, 1.33166E+00_JPRB, &
     & 1.34896E+00_JPRB, 1.36649E+00_JPRB, 1.38424E+00_JPRB, 1.40223E+00_JPRB, 1.42044E+00_JPRB, &
     & 1.43890E+00_JPRB, 1.45759E+00_JPRB, 1.47653E+00_JPRB, 1.49572E+00_JPRB, 1.51515E+00_JPRB, &
     & 1.53483E+00_JPRB, 1.55478E+00_JPRB, 1.57498E+00_JPRB, 1.59544E+00_JPRB/)
      KAO_MN2O( 1, :, 3) = (/ &
     & 1.50082E-01_JPRB, 1.59095E-01_JPRB, 1.68650E-01_JPRB, 1.78779E-01_JPRB, 1.89516E-01_JPRB, &
     & 2.00898E-01_JPRB, 2.12963E-01_JPRB, 2.25753E-01_JPRB, 2.39311E-01_JPRB, 2.53683E-01_JPRB, &
     & 2.68919E-01_JPRB, 2.85069E-01_JPRB, 3.02190E-01_JPRB, 3.20339E-01_JPRB, 3.39577E-01_JPRB, &
     & 3.59971E-01_JPRB, 3.81590E-01_JPRB, 4.04507E-01_JPRB, 4.28801E-01_JPRB/)
      KAO_MN2O( 2, :, 3) = (/ &
     & 3.09551E+00_JPRB, 3.09780E+00_JPRB, 3.10008E+00_JPRB, 3.10237E+00_JPRB, 3.10466E+00_JPRB, &
     & 3.10695E+00_JPRB, 3.10925E+00_JPRB, 3.11154E+00_JPRB, 3.11384E+00_JPRB, 3.11614E+00_JPRB, &
     & 3.11844E+00_JPRB, 3.12074E+00_JPRB, 3.12305E+00_JPRB, 3.12535E+00_JPRB, 3.12766E+00_JPRB, &
     & 3.12997E+00_JPRB, 3.13228E+00_JPRB, 3.13459E+00_JPRB, 3.13691E+00_JPRB/)
      KAO_MN2O( 3, :, 3) = (/ &
     & 4.42661E+00_JPRB, 4.40858E+00_JPRB, 4.39062E+00_JPRB, 4.37274E+00_JPRB, 4.35493E+00_JPRB, &
     & 4.33719E+00_JPRB, 4.31953E+00_JPRB, 4.30193E+00_JPRB, 4.28441E+00_JPRB, 4.26696E+00_JPRB, &
     & 4.24958E+00_JPRB, 4.23227E+00_JPRB, 4.21503E+00_JPRB, 4.19787E+00_JPRB, 4.18077E+00_JPRB, &
     & 4.16374E+00_JPRB, 4.14678E+00_JPRB, 4.12989E+00_JPRB, 4.11307E+00_JPRB/)
      KAO_MN2O( 4, :, 3) = (/ &
     & 5.77864E+00_JPRB, 5.74085E+00_JPRB, 5.70331E+00_JPRB, 5.66602E+00_JPRB, 5.62897E+00_JPRB, &
     & 5.59216E+00_JPRB, 5.55559E+00_JPRB, 5.51926E+00_JPRB, 5.48317E+00_JPRB, 5.44731E+00_JPRB, &
     & 5.41169E+00_JPRB, 5.37631E+00_JPRB, 5.34115E+00_JPRB, 5.30622E+00_JPRB, 5.27152E+00_JPRB, &
     & 5.23705E+00_JPRB, 5.20281E+00_JPRB, 5.16879E+00_JPRB, 5.13499E+00_JPRB/)
      KAO_MN2O( 5, :, 3) = (/ &
     & 7.17294E+00_JPRB, 7.10890E+00_JPRB, 7.04542E+00_JPRB, 6.98251E+00_JPRB, 6.92017E+00_JPRB, &
     & 6.85838E+00_JPRB, 6.79714E+00_JPRB, 6.73645E+00_JPRB, 6.67630E+00_JPRB, 6.61669E+00_JPRB, &
     & 6.55761E+00_JPRB, 6.49905E+00_JPRB, 6.44102E+00_JPRB, 6.38351E+00_JPRB, 6.32651E+00_JPRB, &
     & 6.27003E+00_JPRB, 6.21404E+00_JPRB, 6.15856E+00_JPRB, 6.10357E+00_JPRB/)
      KAO_MN2O( 6, :, 3) = (/ &
     & 9.05082E+00_JPRB, 8.96132E+00_JPRB, 8.87271E+00_JPRB, 8.78498E+00_JPRB, 8.69811E+00_JPRB, &
     & 8.61210E+00_JPRB, 8.52694E+00_JPRB, 8.44262E+00_JPRB, 8.35914E+00_JPRB, 8.27648E+00_JPRB, &
     & 8.19464E+00_JPRB, 8.11361E+00_JPRB, 8.03338E+00_JPRB, 7.95394E+00_JPRB, 7.87529E+00_JPRB, &
     & 7.79742E+00_JPRB, 7.72032E+00_JPRB, 7.64398E+00_JPRB, 7.56839E+00_JPRB/)
      KAO_MN2O( 7, :, 3) = (/ &
     & 1.18749E+01_JPRB, 1.17648E+01_JPRB, 1.16556E+01_JPRB, 1.15475E+01_JPRB, 1.14403E+01_JPRB, &
     & 1.13342E+01_JPRB, 1.12290E+01_JPRB, 1.11248E+01_JPRB, 1.10216E+01_JPRB, 1.09194E+01_JPRB, &
     & 1.08180E+01_JPRB, 1.07177E+01_JPRB, 1.06182E+01_JPRB, 1.05197E+01_JPRB, 1.04221E+01_JPRB, &
     & 1.03254E+01_JPRB, 1.02296E+01_JPRB, 1.01347E+01_JPRB, 1.00407E+01_JPRB/)
      KAO_MN2O( 8, :, 3) = (/ &
     & 1.41428E+01_JPRB, 1.40323E+01_JPRB, 1.39227E+01_JPRB, 1.38139E+01_JPRB, 1.37060E+01_JPRB, &
     & 1.35989E+01_JPRB, 1.34927E+01_JPRB, 1.33873E+01_JPRB, 1.32827E+01_JPRB, 1.31790E+01_JPRB, &
     & 1.30760E+01_JPRB, 1.29738E+01_JPRB, 1.28725E+01_JPRB, 1.27719E+01_JPRB, 1.26722E+01_JPRB, &
     & 1.25732E+01_JPRB, 1.24750E+01_JPRB, 1.23775E+01_JPRB, 1.22808E+01_JPRB/)
      KAO_MN2O( 9, :, 3) = (/ &
     & 7.34993E+00_JPRB, 7.29335E+00_JPRB, 7.23720E+00_JPRB, 7.18149E+00_JPRB, 7.12620E+00_JPRB, &
     & 7.07134E+00_JPRB, 7.01690E+00_JPRB, 6.96288E+00_JPRB, 6.90928E+00_JPRB, 6.85609E+00_JPRB, &
     & 6.80331E+00_JPRB, 6.75094E+00_JPRB, 6.69897E+00_JPRB, 6.64739E+00_JPRB, 6.59622E+00_JPRB, &
     & 6.54544E+00_JPRB, 6.49505E+00_JPRB, 6.44505E+00_JPRB, 6.39543E+00_JPRB/)
      KAO_MN2O( 1, :, 4) = (/ &
     & 6.11248E-01_JPRB, 6.37225E-01_JPRB, 6.64306E-01_JPRB, 6.92538E-01_JPRB, 7.21970E-01_JPRB, &
     & 7.52653E-01_JPRB, 7.84639E-01_JPRB, 8.17985E-01_JPRB, 8.52749E-01_JPRB, 8.88989E-01_JPRB, &
     & 9.26770E-01_JPRB, 9.66157E-01_JPRB, 1.00722E+00_JPRB, 1.05002E+00_JPRB, 1.09465E+00_JPRB, &
     & 1.14117E+00_JPRB, 1.18967E+00_JPRB, 1.24022E+00_JPRB, 1.29293E+00_JPRB/)
      KAO_MN2O( 2, :, 4) = (/ &
     & 5.07253E+00_JPRB, 5.05299E+00_JPRB, 5.03353E+00_JPRB, 5.01414E+00_JPRB, 4.99483E+00_JPRB, &
     & 4.97559E+00_JPRB, 4.95642E+00_JPRB, 4.93733E+00_JPRB, 4.91831E+00_JPRB, 4.89937E+00_JPRB, &
     & 4.88050E+00_JPRB, 4.86170E+00_JPRB, 4.84297E+00_JPRB, 4.82432E+00_JPRB, 4.80573E+00_JPRB, &
     & 4.78722E+00_JPRB, 4.76878E+00_JPRB, 4.75042E+00_JPRB, 4.73212E+00_JPRB/)
      KAO_MN2O( 3, :, 4) = (/ &
     & 7.45829E+00_JPRB, 7.42266E+00_JPRB, 7.38719E+00_JPRB, 7.35190E+00_JPRB, 7.31677E+00_JPRB, &
     & 7.28181E+00_JPRB, 7.24702E+00_JPRB, 7.21240E+00_JPRB, 7.17794E+00_JPRB, 7.14364E+00_JPRB, &
     & 7.10951E+00_JPRB, 7.07554E+00_JPRB, 7.04173E+00_JPRB, 7.00809E+00_JPRB, 6.97461E+00_JPRB, &
     & 6.94128E+00_JPRB, 6.90812E+00_JPRB, 6.87511E+00_JPRB, 6.84226E+00_JPRB/)
      KAO_MN2O( 4, :, 4) = (/ &
     & 9.58893E+00_JPRB, 9.54796E+00_JPRB, 9.50716E+00_JPRB, 9.46654E+00_JPRB, 9.42609E+00_JPRB, &
     & 9.38581E+00_JPRB, 9.34571E+00_JPRB, 9.30578E+00_JPRB, 9.26602E+00_JPRB, 9.22642E+00_JPRB, &
     & 9.18700E+00_JPRB, 9.14775E+00_JPRB, 9.10866E+00_JPRB, 9.06974E+00_JPRB, 9.03099E+00_JPRB, &
     & 8.99240E+00_JPRB, 8.95398E+00_JPRB, 8.91572E+00_JPRB, 8.87762E+00_JPRB/)
      KAO_MN2O( 5, :, 4) = (/ &
     & 1.16344E+01_JPRB, 1.16012E+01_JPRB, 1.15681E+01_JPRB, 1.15351E+01_JPRB, 1.15022E+01_JPRB, &
     & 1.14694E+01_JPRB, 1.14366E+01_JPRB, 1.14040E+01_JPRB, 1.13715E+01_JPRB, 1.13390E+01_JPRB, &
     & 1.13067E+01_JPRB, 1.12744E+01_JPRB, 1.12422E+01_JPRB, 1.12102E+01_JPRB, 1.11782E+01_JPRB, &
     & 1.11463E+01_JPRB, 1.11145E+01_JPRB, 1.10828E+01_JPRB, 1.10511E+01_JPRB/)
      KAO_MN2O( 6, :, 4) = (/ &
     & 1.12460E+01_JPRB, 1.12402E+01_JPRB, 1.12344E+01_JPRB, 1.12286E+01_JPRB, 1.12228E+01_JPRB, &
     & 1.12170E+01_JPRB, 1.12112E+01_JPRB, 1.12055E+01_JPRB, 1.11997E+01_JPRB, 1.11939E+01_JPRB, &
     & 1.11882E+01_JPRB, 1.11824E+01_JPRB, 1.11766E+01_JPRB, 1.11709E+01_JPRB, 1.11651E+01_JPRB, &
     & 1.11594E+01_JPRB, 1.11536E+01_JPRB, 1.11479E+01_JPRB, 1.11421E+01_JPRB/)
      KAO_MN2O( 7, :, 4) = (/ &
     & 8.89265E+00_JPRB, 8.91419E+00_JPRB, 8.93578E+00_JPRB, 8.95743E+00_JPRB, 8.97913E+00_JPRB, &
     & 9.00088E+00_JPRB, 9.02268E+00_JPRB, 9.04454E+00_JPRB, 9.06645E+00_JPRB, 9.08841E+00_JPRB, &
     & 9.11043E+00_JPRB, 9.13250E+00_JPRB, 9.15462E+00_JPRB, 9.17680E+00_JPRB, 9.19903E+00_JPRB, &
     & 9.22131E+00_JPRB, 9.24365E+00_JPRB, 9.26604E+00_JPRB, 9.28849E+00_JPRB/)
      KAO_MN2O( 8, :, 4) = (/ &
     & 6.83933E+00_JPRB, 6.86688E+00_JPRB, 6.89453E+00_JPRB, 6.92230E+00_JPRB, 6.95018E+00_JPRB, &
     & 6.97817E+00_JPRB, 7.00627E+00_JPRB, 7.03449E+00_JPRB, 7.06282E+00_JPRB, 7.09126E+00_JPRB, &
     & 7.11982E+00_JPRB, 7.14850E+00_JPRB, 7.17729E+00_JPRB, 7.20619E+00_JPRB, 7.23521E+00_JPRB, &
     & 7.26435E+00_JPRB, 7.29361E+00_JPRB, 7.32298E+00_JPRB, 7.35248E+00_JPRB/)
      KAO_MN2O( 9, :, 4) = (/ &
     & 1.10637E+01_JPRB, 1.10232E+01_JPRB, 1.09829E+01_JPRB, 1.09427E+01_JPRB, 1.09026E+01_JPRB, &
     & 1.08627E+01_JPRB, 1.08230E+01_JPRB, 1.07833E+01_JPRB, 1.07439E+01_JPRB, 1.07046E+01_JPRB, &
     & 1.06654E+01_JPRB, 1.06263E+01_JPRB, 1.05875E+01_JPRB, 1.05487E+01_JPRB, 1.05101E+01_JPRB, &
     & 1.04716E+01_JPRB, 1.04333E+01_JPRB, 1.03951E+01_JPRB, 1.03571E+01_JPRB/)
      KAO_MN2O( 1, :, 5) = (/ &
     & 2.53460E+00_JPRB, 2.56050E+00_JPRB, 2.58667E+00_JPRB, 2.61310E+00_JPRB, 2.63980E+00_JPRB, &
     & 2.66678E+00_JPRB, 2.69403E+00_JPRB, 2.72156E+00_JPRB, 2.74937E+00_JPRB, 2.77746E+00_JPRB, &
     & 2.80585E+00_JPRB, 2.83452E+00_JPRB, 2.86348E+00_JPRB, 2.89275E+00_JPRB, 2.92231E+00_JPRB, &
     & 2.95217E+00_JPRB, 2.98234E+00_JPRB, 3.01281E+00_JPRB, 3.04360E+00_JPRB/)
      KAO_MN2O( 2, :, 5) = (/ &
     & 7.45650E+00_JPRB, 7.44283E+00_JPRB, 7.42919E+00_JPRB, 7.41557E+00_JPRB, 7.40198E+00_JPRB, &
     & 7.38841E+00_JPRB, 7.37487E+00_JPRB, 7.36135E+00_JPRB, 7.34786E+00_JPRB, 7.33439E+00_JPRB, &
     & 7.32095E+00_JPRB, 7.30753E+00_JPRB, 7.29413E+00_JPRB, 7.28076E+00_JPRB, 7.26742E+00_JPRB, &
     & 7.25410E+00_JPRB, 7.24080E+00_JPRB, 7.22753E+00_JPRB, 7.21428E+00_JPRB/)
      KAO_MN2O( 3, :, 5) = (/ &
     & 1.06311E+01_JPRB, 1.06110E+01_JPRB, 1.05909E+01_JPRB, 1.05709E+01_JPRB, 1.05509E+01_JPRB, &
     & 1.05310E+01_JPRB, 1.05111E+01_JPRB, 1.04912E+01_JPRB, 1.04713E+01_JPRB, 1.04516E+01_JPRB, &
     & 1.04318E+01_JPRB, 1.04121E+01_JPRB, 1.03924E+01_JPRB, 1.03727E+01_JPRB, 1.03531E+01_JPRB, &
     & 1.03336E+01_JPRB, 1.03140E+01_JPRB, 1.02945E+01_JPRB, 1.02751E+01_JPRB/)
      KAO_MN2O( 4, :, 5) = (/ &
     & 1.03924E+01_JPRB, 1.03895E+01_JPRB, 1.03867E+01_JPRB, 1.03838E+01_JPRB, 1.03809E+01_JPRB, &
     & 1.03780E+01_JPRB, 1.03751E+01_JPRB, 1.03722E+01_JPRB, 1.03693E+01_JPRB, 1.03665E+01_JPRB, &
     & 1.03636E+01_JPRB, 1.03607E+01_JPRB, 1.03578E+01_JPRB, 1.03549E+01_JPRB, 1.03521E+01_JPRB, &
     & 1.03492E+01_JPRB, 1.03463E+01_JPRB, 1.03434E+01_JPRB, 1.03406E+01_JPRB/)
      KAO_MN2O( 5, :, 5) = (/ &
     & 7.82277E+00_JPRB, 7.83872E+00_JPRB, 7.85471E+00_JPRB, 7.87073E+00_JPRB, 7.88678E+00_JPRB, &
     & 7.90287E+00_JPRB, 7.91899E+00_JPRB, 7.93514E+00_JPRB, 7.95132E+00_JPRB, 7.96754E+00_JPRB, &
     & 7.98379E+00_JPRB, 8.00008E+00_JPRB, 8.01639E+00_JPRB, 8.03274E+00_JPRB, 8.04913E+00_JPRB, &
     & 8.06555E+00_JPRB, 8.08200E+00_JPRB, 8.09848E+00_JPRB, 8.11500E+00_JPRB/)
      KAO_MN2O( 6, :, 5) = (/ &
     & 6.05225E+00_JPRB, 6.06883E+00_JPRB, 6.08545E+00_JPRB, 6.10212E+00_JPRB, 6.11883E+00_JPRB, &
     & 6.13559E+00_JPRB, 6.15240E+00_JPRB, 6.16925E+00_JPRB, 6.18615E+00_JPRB, 6.20309E+00_JPRB, &
     & 6.22008E+00_JPRB, 6.23712E+00_JPRB, 6.25420E+00_JPRB, 6.27133E+00_JPRB, 6.28851E+00_JPRB, &
     & 6.30574E+00_JPRB, 6.32301E+00_JPRB, 6.34033E+00_JPRB, 6.35769E+00_JPRB/)
      KAO_MN2O( 7, :, 5) = (/ &
     & 5.24135E+00_JPRB, 5.25696E+00_JPRB, 5.27261E+00_JPRB, 5.28831E+00_JPRB, 5.30405E+00_JPRB, &
     & 5.31984E+00_JPRB, 5.33568E+00_JPRB, 5.35157E+00_JPRB, 5.36750E+00_JPRB, 5.38348E+00_JPRB, &
     & 5.39951E+00_JPRB, 5.41558E+00_JPRB, 5.43171E+00_JPRB, 5.44788E+00_JPRB, 5.46410E+00_JPRB, &
     & 5.48037E+00_JPRB, 5.49668E+00_JPRB, 5.51305E+00_JPRB, 5.52946E+00_JPRB/)
      KAO_MN2O( 8, :, 5) = (/ &
     & 4.40240E+00_JPRB, 4.40915E+00_JPRB, 4.41591E+00_JPRB, 4.42268E+00_JPRB, 4.42946E+00_JPRB, &
     & 4.43625E+00_JPRB, 4.44305E+00_JPRB, 4.44986E+00_JPRB, 4.45668E+00_JPRB, 4.46351E+00_JPRB, &
     & 4.47035E+00_JPRB, 4.47720E+00_JPRB, 4.48407E+00_JPRB, 4.49094E+00_JPRB, 4.49782E+00_JPRB, &
     & 4.50472E+00_JPRB, 4.51162E+00_JPRB, 4.51854E+00_JPRB, 4.52547E+00_JPRB/)
      KAO_MN2O( 9, :, 5) = (/ &
     & 8.56554E+00_JPRB, 8.59185E+00_JPRB, 8.61824E+00_JPRB, 8.64470E+00_JPRB, 8.67125E+00_JPRB, &
     & 8.69788E+00_JPRB, 8.72460E+00_JPRB, 8.75139E+00_JPRB, 8.77827E+00_JPRB, 8.80523E+00_JPRB, &
     & 8.83227E+00_JPRB, 8.85939E+00_JPRB, 8.88660E+00_JPRB, 8.91389E+00_JPRB, 8.94127E+00_JPRB, &
     & 8.96873E+00_JPRB, 8.99627E+00_JPRB, 9.02390E+00_JPRB, 9.05161E+00_JPRB/)
      KAO_MN2O( 1, :, 6) = (/ &
     & 5.78695E+00_JPRB, 5.78939E+00_JPRB, 5.79182E+00_JPRB, 5.79426E+00_JPRB, 5.79670E+00_JPRB, &
     & 5.79914E+00_JPRB, 5.80158E+00_JPRB, 5.80403E+00_JPRB, 5.80647E+00_JPRB, 5.80892E+00_JPRB, &
     & 5.81136E+00_JPRB, 5.81381E+00_JPRB, 5.81626E+00_JPRB, 5.81870E+00_JPRB, 5.82115E+00_JPRB, &
     & 5.82361E+00_JPRB, 5.82606E+00_JPRB, 5.82851E+00_JPRB, 5.83096E+00_JPRB/)
      KAO_MN2O( 2, :, 6) = (/ &
     & 1.22893E+01_JPRB, 1.22556E+01_JPRB, 1.22221E+01_JPRB, 1.21886E+01_JPRB, 1.21552E+01_JPRB, &
     & 1.21220E+01_JPRB, 1.20888E+01_JPRB, 1.20557E+01_JPRB, 1.20227E+01_JPRB, 1.19898E+01_JPRB, &
     & 1.19569E+01_JPRB, 1.19242E+01_JPRB, 1.18915E+01_JPRB, 1.18590E+01_JPRB, 1.18265E+01_JPRB, &
     & 1.17941E+01_JPRB, 1.17618E+01_JPRB, 1.17296E+01_JPRB, 1.16975E+01_JPRB/)
      KAO_MN2O( 3, :, 6) = (/ &
     & 7.93118E+00_JPRB, 7.94590E+00_JPRB, 7.96065E+00_JPRB, 7.97542E+00_JPRB, 7.99022E+00_JPRB, &
     & 8.00505E+00_JPRB, 8.01990E+00_JPRB, 8.03478E+00_JPRB, 8.04970E+00_JPRB, 8.06463E+00_JPRB, &
     & 8.07960E+00_JPRB, 8.09459E+00_JPRB, 8.10961E+00_JPRB, 8.12466E+00_JPRB, 8.13974E+00_JPRB, &
     & 8.15485E+00_JPRB, 8.16998E+00_JPRB, 8.18514E+00_JPRB, 8.20033E+00_JPRB/)
      KAO_MN2O( 4, :, 6) = (/ &
     & 4.08899E+00_JPRB, 4.11435E+00_JPRB, 4.13988E+00_JPRB, 4.16556E+00_JPRB, 4.19140E+00_JPRB, &
     & 4.21740E+00_JPRB, 4.24357E+00_JPRB, 4.26989E+00_JPRB, 4.29638E+00_JPRB, 4.32304E+00_JPRB, &
     & 4.34985E+00_JPRB, 4.37684E+00_JPRB, 4.40399E+00_JPRB, 4.43131E+00_JPRB, 4.45880E+00_JPRB, &
     & 4.48646E+00_JPRB, 4.51430E+00_JPRB, 4.54230E+00_JPRB, 4.57048E+00_JPRB/)
      KAO_MN2O( 5, :, 6) = (/ &
     & 2.61358E+00_JPRB, 2.64029E+00_JPRB, 2.66728E+00_JPRB, 2.69454E+00_JPRB, 2.72209E+00_JPRB, &
     & 2.74991E+00_JPRB, 2.77802E+00_JPRB, 2.80641E+00_JPRB, 2.83510E+00_JPRB, 2.86408E+00_JPRB, &
     & 2.89335E+00_JPRB, 2.92293E+00_JPRB, 2.95280E+00_JPRB, 2.98299E+00_JPRB, 3.01348E+00_JPRB, &
     & 3.04428E+00_JPRB, 3.07540E+00_JPRB, 3.10683E+00_JPRB, 3.13859E+00_JPRB/)
      KAO_MN2O( 6, :, 6) = (/ &
     & 2.40720E+00_JPRB, 2.43430E+00_JPRB, 2.46169E+00_JPRB, 2.48940E+00_JPRB, 2.51741E+00_JPRB, &
     & 2.54575E+00_JPRB, 2.57440E+00_JPRB, 2.60337E+00_JPRB, 2.63267E+00_JPRB, 2.66230E+00_JPRB, &
     & 2.69226E+00_JPRB, 2.72256E+00_JPRB, 2.75320E+00_JPRB, 2.78419E+00_JPRB, 2.81552E+00_JPRB, &
     & 2.84721E+00_JPRB, 2.87925E+00_JPRB, 2.91166E+00_JPRB, 2.94443E+00_JPRB/)
      KAO_MN2O( 7, :, 6) = (/ &
     & 1.99607E+00_JPRB, 2.01725E+00_JPRB, 2.03865E+00_JPRB, 2.06028E+00_JPRB, 2.08214E+00_JPRB, &
     & 2.10423E+00_JPRB, 2.12655E+00_JPRB, 2.14912E+00_JPRB, 2.17192E+00_JPRB, 2.19496E+00_JPRB, &
     & 2.21825E+00_JPRB, 2.24179E+00_JPRB, 2.26557E+00_JPRB, 2.28961E+00_JPRB, 2.31390E+00_JPRB, &
     & 2.33845E+00_JPRB, 2.36326E+00_JPRB, 2.38834E+00_JPRB, 2.41368E+00_JPRB/)
      KAO_MN2O( 8, :, 6) = (/ &
     & 1.94150E+00_JPRB, 1.96398E+00_JPRB, 1.98671E+00_JPRB, 2.00971E+00_JPRB, 2.03298E+00_JPRB, &
     & 2.05651E+00_JPRB, 2.08032E+00_JPRB, 2.10440E+00_JPRB, 2.12876E+00_JPRB, 2.15341E+00_JPRB, &
     & 2.17834E+00_JPRB, 2.20355E+00_JPRB, 2.22906E+00_JPRB, 2.25487E+00_JPRB, 2.28097E+00_JPRB, &
     & 2.30738E+00_JPRB, 2.33409E+00_JPRB, 2.36111E+00_JPRB, 2.38844E+00_JPRB/)
      KAO_MN2O( 9, :, 6) = (/ &
     & 2.47259E+00_JPRB, 2.48950E+00_JPRB, 2.50653E+00_JPRB, 2.52367E+00_JPRB, 2.54093E+00_JPRB, &
     & 2.55831E+00_JPRB, 2.57581E+00_JPRB, 2.59343E+00_JPRB, 2.61117E+00_JPRB, 2.62903E+00_JPRB, &
     & 2.64701E+00_JPRB, 2.66511E+00_JPRB, 2.68334E+00_JPRB, 2.70169E+00_JPRB, 2.72017E+00_JPRB, &
     & 2.73878E+00_JPRB, 2.75751E+00_JPRB, 2.77637E+00_JPRB, 2.79536E+00_JPRB/)
      KAO_MN2O( 1, :, 7) = (/ &
     & 1.23417E+01_JPRB, 1.22618E+01_JPRB, 1.21823E+01_JPRB, 1.21034E+01_JPRB, 1.20250E+01_JPRB, &
     & 1.19471E+01_JPRB, 1.18697E+01_JPRB, 1.17928E+01_JPRB, 1.17164E+01_JPRB, 1.16405E+01_JPRB, &
     & 1.15651E+01_JPRB, 1.14901E+01_JPRB, 1.14157E+01_JPRB, 1.13417E+01_JPRB, 1.12683E+01_JPRB, &
     & 1.11952E+01_JPRB, 1.11227E+01_JPRB, 1.10507E+01_JPRB, 1.09791E+01_JPRB/)
      KAO_MN2O( 2, :, 7) = (/ &
     & 9.30957E+00_JPRB, 9.32775E+00_JPRB, 9.34597E+00_JPRB, 9.36421E+00_JPRB, 9.38250E+00_JPRB, &
     & 9.40082E+00_JPRB, 9.41918E+00_JPRB, 9.43757E+00_JPRB, 9.45600E+00_JPRB, 9.47446E+00_JPRB, &
     & 9.49296E+00_JPRB, 9.51150E+00_JPRB, 9.53007E+00_JPRB, 9.54868E+00_JPRB, 9.56732E+00_JPRB, &
     & 9.58601E+00_JPRB, 9.60472E+00_JPRB, 9.62348E+00_JPRB, 9.64227E+00_JPRB/)
      KAO_MN2O( 3, :, 7) = (/ &
     & 4.15867E+00_JPRB, 4.19254E+00_JPRB, 4.22668E+00_JPRB, 4.26110E+00_JPRB, 4.29581E+00_JPRB, &
     & 4.33079E+00_JPRB, 4.36606E+00_JPRB, 4.40162E+00_JPRB, 4.43747E+00_JPRB, 4.47360E+00_JPRB, &
     & 4.51004E+00_JPRB, 4.54677E+00_JPRB, 4.58380E+00_JPRB, 4.62113E+00_JPRB, 4.65876E+00_JPRB, &
     & 4.69670E+00_JPRB, 4.73495E+00_JPRB, 4.77351E+00_JPRB, 4.81239E+00_JPRB/)
      KAO_MN2O( 4, :, 7) = (/ &
     & 3.55634E+00_JPRB, 3.59382E+00_JPRB, 3.63169E+00_JPRB, 3.66996E+00_JPRB, 3.70863E+00_JPRB, &
     & 3.74771E+00_JPRB, 3.78720E+00_JPRB, 3.82711E+00_JPRB, 3.86744E+00_JPRB, 3.90820E+00_JPRB, &
     & 3.94938E+00_JPRB, 3.99100E+00_JPRB, 4.03305E+00_JPRB, 4.07555E+00_JPRB, 4.11850E+00_JPRB, &
     & 4.16190E+00_JPRB, 4.20576E+00_JPRB, 4.25008E+00_JPRB, 4.29486E+00_JPRB/)
      KAO_MN2O( 5, :, 7) = (/ &
     & 3.09468E+00_JPRB, 3.12655E+00_JPRB, 3.15876E+00_JPRB, 3.19129E+00_JPRB, 3.22416E+00_JPRB, &
     & 3.25737E+00_JPRB, 3.29092E+00_JPRB, 3.32482E+00_JPRB, 3.35907E+00_JPRB, 3.39366E+00_JPRB, &
     & 3.42862E+00_JPRB, 3.46393E+00_JPRB, 3.49961E+00_JPRB, 3.53566E+00_JPRB, 3.57208E+00_JPRB, &
     & 3.60887E+00_JPRB, 3.64604E+00_JPRB, 3.68360E+00_JPRB, 3.72154E+00_JPRB/)
      KAO_MN2O( 6, :, 7) = (/ &
     & 2.75473E+00_JPRB, 2.78356E+00_JPRB, 2.81268E+00_JPRB, 2.84211E+00_JPRB, 2.87185E+00_JPRB, &
     & 2.90190E+00_JPRB, 2.93227E+00_JPRB, 2.96295E+00_JPRB, 2.99395E+00_JPRB, 3.02528E+00_JPRB, &
     & 3.05694E+00_JPRB, 3.08892E+00_JPRB, 3.12125E+00_JPRB, 3.15391E+00_JPRB, 3.18691E+00_JPRB, &
     & 3.22025E+00_JPRB, 3.25395E+00_JPRB, 3.28800E+00_JPRB, 3.32240E+00_JPRB/)
      KAO_MN2O( 7, :, 7) = (/ &
     & 2.68587E+00_JPRB, 2.71431E+00_JPRB, 2.74306E+00_JPRB, 2.77211E+00_JPRB, 2.80146E+00_JPRB, &
     & 2.83113E+00_JPRB, 2.86111E+00_JPRB, 2.89141E+00_JPRB, 2.92203E+00_JPRB, 2.95298E+00_JPRB, &
     & 2.98425E+00_JPRB, 3.01585E+00_JPRB, 3.04779E+00_JPRB, 3.08006E+00_JPRB, 3.11268E+00_JPRB, &
     & 3.14564E+00_JPRB, 3.17896E+00_JPRB, 3.21262E+00_JPRB, 3.24664E+00_JPRB/)
      KAO_MN2O( 8, :, 7) = (/ &
     & 2.54778E+00_JPRB, 2.57461E+00_JPRB, 2.60173E+00_JPRB, 2.62914E+00_JPRB, 2.65683E+00_JPRB, &
     & 2.68482E+00_JPRB, 2.71310E+00_JPRB, 2.74168E+00_JPRB, 2.77056E+00_JPRB, 2.79974E+00_JPRB, &
     & 2.82923E+00_JPRB, 2.85903E+00_JPRB, 2.88915E+00_JPRB, 2.91958E+00_JPRB, 2.95033E+00_JPRB, &
     & 2.98141E+00_JPRB, 3.01282E+00_JPRB, 3.04455E+00_JPRB, 3.07662E+00_JPRB/)
      KAO_MN2O( 9, :, 7) = (/ &
     & 2.78137E+00_JPRB, 2.80957E+00_JPRB, 2.83805E+00_JPRB, 2.86682E+00_JPRB, 2.89589E+00_JPRB, &
     & 2.92525E+00_JPRB, 2.95491E+00_JPRB, 2.98486E+00_JPRB, 3.01512E+00_JPRB, 3.04569E+00_JPRB, &
     & 3.07657E+00_JPRB, 3.10776E+00_JPRB, 3.13927E+00_JPRB, 3.17110E+00_JPRB, 3.20324E+00_JPRB, &
     & 3.23572E+00_JPRB, 3.26852E+00_JPRB, 3.30166E+00_JPRB, 3.33513E+00_JPRB/)
      KAO_MN2O( 1, :, 8) = (/ &
     & 2.28384E+01_JPRB, 2.27450E+01_JPRB, 2.26519E+01_JPRB, 2.25593E+01_JPRB, 2.24670E+01_JPRB, &
     & 2.23751E+01_JPRB, 2.22835E+01_JPRB, 2.21924E+01_JPRB, 2.21016E+01_JPRB, 2.20112E+01_JPRB, &
     & 2.19211E+01_JPRB, 2.18314E+01_JPRB, 2.17421E+01_JPRB, 2.16532E+01_JPRB, 2.15646E+01_JPRB, &
     & 2.14764E+01_JPRB, 2.13885E+01_JPRB, 2.13010E+01_JPRB, 2.12139E+01_JPRB/)
      KAO_MN2O( 2, :, 8) = (/ &
     & 4.48608E+00_JPRB, 4.52259E+00_JPRB, 4.55939E+00_JPRB, 4.59649E+00_JPRB, 4.63389E+00_JPRB, &
     & 4.67160E+00_JPRB, 4.70961E+00_JPRB, 4.74793E+00_JPRB, 4.78656E+00_JPRB, 4.82551E+00_JPRB, &
     & 4.86478E+00_JPRB, 4.90436E+00_JPRB, 4.94427E+00_JPRB, 4.98450E+00_JPRB, 5.02506E+00_JPRB, &
     & 5.06595E+00_JPRB, 5.10717E+00_JPRB, 5.14873E+00_JPRB, 5.19062E+00_JPRB/)
      KAO_MN2O( 3, :, 8) = (/ &
     & 3.69928E+00_JPRB, 3.72584E+00_JPRB, 3.75259E+00_JPRB, 3.77953E+00_JPRB, 3.80666E+00_JPRB, &
     & 3.83399E+00_JPRB, 3.86152E+00_JPRB, 3.88924E+00_JPRB, 3.91717E+00_JPRB, 3.94529E+00_JPRB, &
     & 3.97361E+00_JPRB, 4.00214E+00_JPRB, 4.03088E+00_JPRB, 4.05982E+00_JPRB, 4.08896E+00_JPRB, &
     & 4.11832E+00_JPRB, 4.14789E+00_JPRB, 4.17767E+00_JPRB, 4.20766E+00_JPRB/)
      KAO_MN2O( 4, :, 8) = (/ &
     & 3.17856E+00_JPRB, 3.19596E+00_JPRB, 3.21345E+00_JPRB, 3.23104E+00_JPRB, 3.24872E+00_JPRB, &
     & 3.26650E+00_JPRB, 3.28437E+00_JPRB, 3.30235E+00_JPRB, 3.32042E+00_JPRB, 3.33859E+00_JPRB, &
     & 3.35686E+00_JPRB, 3.37523E+00_JPRB, 3.39370E+00_JPRB, 3.41227E+00_JPRB, 3.43095E+00_JPRB, &
     & 3.44972E+00_JPRB, 3.46860E+00_JPRB, 3.48758E+00_JPRB, 3.50667E+00_JPRB/)
      KAO_MN2O( 5, :, 8) = (/ &
     & 3.16549E+00_JPRB, 3.18288E+00_JPRB, 3.20037E+00_JPRB, 3.21795E+00_JPRB, 3.23563E+00_JPRB, &
     & 3.25340E+00_JPRB, 3.27128E+00_JPRB, 3.28925E+00_JPRB, 3.30732E+00_JPRB, 3.32549E+00_JPRB, &
     & 3.34376E+00_JPRB, 3.36213E+00_JPRB, 3.38060E+00_JPRB, 3.39917E+00_JPRB, 3.41785E+00_JPRB, &
     & 3.43662E+00_JPRB, 3.45551E+00_JPRB, 3.47449E+00_JPRB, 3.49358E+00_JPRB/)
      KAO_MN2O( 6, :, 8) = (/ &
     & 3.16612E+00_JPRB, 3.18355E+00_JPRB, 3.20108E+00_JPRB, 3.21870E+00_JPRB, 3.23643E+00_JPRB, &
     & 3.25425E+00_JPRB, 3.27217E+00_JPRB, 3.29018E+00_JPRB, 3.30830E+00_JPRB, 3.32652E+00_JPRB, &
     & 3.34483E+00_JPRB, 3.36325E+00_JPRB, 3.38177E+00_JPRB, 3.40039E+00_JPRB, 3.41911E+00_JPRB, &
     & 3.43794E+00_JPRB, 3.45687E+00_JPRB, 3.47591E+00_JPRB, 3.49505E+00_JPRB/)
      KAO_MN2O( 7, :, 8) = (/ &
     & 3.19644E+00_JPRB, 3.21419E+00_JPRB, 3.23203E+00_JPRB, 3.24996E+00_JPRB, 3.26800E+00_JPRB, &
     & 3.28614E+00_JPRB, 3.30438E+00_JPRB, 3.32272E+00_JPRB, 3.34116E+00_JPRB, 3.35970E+00_JPRB, &
     & 3.37835E+00_JPRB, 3.39710E+00_JPRB, 3.41596E+00_JPRB, 3.43492E+00_JPRB, 3.45398E+00_JPRB, &
     & 3.47315E+00_JPRB, 3.49243E+00_JPRB, 3.51181E+00_JPRB, 3.53130E+00_JPRB/)
      KAO_MN2O( 8, :, 8) = (/ &
     & 3.35759E+00_JPRB, 3.37775E+00_JPRB, 3.39804E+00_JPRB, 3.41845E+00_JPRB, 3.43899E+00_JPRB, &
     & 3.45964E+00_JPRB, 3.48042E+00_JPRB, 3.50133E+00_JPRB, 3.52236E+00_JPRB, 3.54351E+00_JPRB, &
     & 3.56480E+00_JPRB, 3.58621E+00_JPRB, 3.60775E+00_JPRB, 3.62942E+00_JPRB, 3.65122E+00_JPRB, &
     & 3.67315E+00_JPRB, 3.69521E+00_JPRB, 3.71741E+00_JPRB, 3.73974E+00_JPRB/)
      KAO_MN2O( 9, :, 8) = (/ &
     & 3.17378E+00_JPRB, 3.19135E+00_JPRB, 3.20901E+00_JPRB, 3.22677E+00_JPRB, 3.24462E+00_JPRB, &
     & 3.26258E+00_JPRB, 3.28063E+00_JPRB, 3.29879E+00_JPRB, 3.31704E+00_JPRB, 3.33540E+00_JPRB, &
     & 3.35386E+00_JPRB, 3.37242E+00_JPRB, 3.39108E+00_JPRB, 3.40984E+00_JPRB, 3.42871E+00_JPRB, &
     & 3.44769E+00_JPRB, 3.46677E+00_JPRB, 3.48595E+00_JPRB, 3.50524E+00_JPRB/)
      KAO_MN2O( 1, :, 9) = (/ &
     & 2.09106E+01_JPRB, 2.08779E+01_JPRB, 2.08452E+01_JPRB, 2.08126E+01_JPRB, 2.07800E+01_JPRB, &
     & 2.07475E+01_JPRB, 2.07150E+01_JPRB, 2.06826E+01_JPRB, 2.06502E+01_JPRB, 2.06179E+01_JPRB, &
     & 2.05856E+01_JPRB, 2.05534E+01_JPRB, 2.05213E+01_JPRB, 2.04891E+01_JPRB, 2.04571E+01_JPRB, &
     & 2.04251E+01_JPRB, 2.03931E+01_JPRB, 2.03612E+01_JPRB, 2.03293E+01_JPRB/)
      KAO_MN2O( 2, :, 9) = (/ &
     & 2.60494E+00_JPRB, 2.62757E+00_JPRB, 2.65040E+00_JPRB, 2.67343E+00_JPRB, 2.69665E+00_JPRB, &
     & 2.72008E+00_JPRB, 2.74372E+00_JPRB, 2.76756E+00_JPRB, 2.79160E+00_JPRB, 2.81586E+00_JPRB, &
     & 2.84032E+00_JPRB, 2.86500E+00_JPRB, 2.88989E+00_JPRB, 2.91500E+00_JPRB, 2.94033E+00_JPRB, &
     & 2.96588E+00_JPRB, 2.99164E+00_JPRB, 3.01764E+00_JPRB, 3.04386E+00_JPRB/)
      KAO_MN2O( 3, :, 9) = (/ &
     & 2.42238E+00_JPRB, 2.44514E+00_JPRB, 2.46811E+00_JPRB, 2.49130E+00_JPRB, 2.51471E+00_JPRB, &
     & 2.53834E+00_JPRB, 2.56219E+00_JPRB, 2.58626E+00_JPRB, 2.61056E+00_JPRB, 2.63509E+00_JPRB, &
     & 2.65985E+00_JPRB, 2.68484E+00_JPRB, 2.71007E+00_JPRB, 2.73554E+00_JPRB, 2.76124E+00_JPRB, &
     & 2.78718E+00_JPRB, 2.81337E+00_JPRB, 2.83981E+00_JPRB, 2.86649E+00_JPRB/)
      KAO_MN2O( 4, :, 9) = (/ &
     & 2.33681E+00_JPRB, 2.35961E+00_JPRB, 2.38263E+00_JPRB, 2.40588E+00_JPRB, 2.42935E+00_JPRB, &
     & 2.45305E+00_JPRB, 2.47699E+00_JPRB, 2.50115E+00_JPRB, 2.52556E+00_JPRB, 2.55020E+00_JPRB, &
     & 2.57508E+00_JPRB, 2.60021E+00_JPRB, 2.62558E+00_JPRB, 2.65119E+00_JPRB, 2.67706E+00_JPRB, &
     & 2.70318E+00_JPRB, 2.72955E+00_JPRB, 2.75619E+00_JPRB, 2.78308E+00_JPRB/)
      KAO_MN2O( 5, :, 9) = (/ &
     & 2.26420E+00_JPRB, 2.28696E+00_JPRB, 2.30996E+00_JPRB, 2.33319E+00_JPRB, 2.35665E+00_JPRB, &
     & 2.38035E+00_JPRB, 2.40429E+00_JPRB, 2.42846E+00_JPRB, 2.45288E+00_JPRB, 2.47755E+00_JPRB, &
     & 2.50246E+00_JPRB, 2.52763E+00_JPRB, 2.55304E+00_JPRB, 2.57871E+00_JPRB, 2.60465E+00_JPRB, &
     & 2.63084E+00_JPRB, 2.65729E+00_JPRB, 2.68401E+00_JPRB, 2.71100E+00_JPRB/)
      KAO_MN2O( 6, :, 9) = (/ &
     & 2.19628E+00_JPRB, 2.21902E+00_JPRB, 2.24199E+00_JPRB, 2.26520E+00_JPRB, 2.28865E+00_JPRB, &
     & 2.31234E+00_JPRB, 2.33628E+00_JPRB, 2.36047E+00_JPRB, 2.38491E+00_JPRB, 2.40959E+00_JPRB, &
     & 2.43454E+00_JPRB, 2.45974E+00_JPRB, 2.48521E+00_JPRB, 2.51094E+00_JPRB, 2.53693E+00_JPRB, &
     & 2.56319E+00_JPRB, 2.58973E+00_JPRB, 2.61654E+00_JPRB, 2.64363E+00_JPRB/)
      KAO_MN2O( 7, :, 9) = (/ &
     & 2.07829E+00_JPRB, 2.10090E+00_JPRB, 2.12375E+00_JPRB, 2.14685E+00_JPRB, 2.17021E+00_JPRB, &
     & 2.19381E+00_JPRB, 2.21767E+00_JPRB, 2.24180E+00_JPRB, 2.26618E+00_JPRB, 2.29083E+00_JPRB, &
     & 2.31575E+00_JPRB, 2.34094E+00_JPRB, 2.36640E+00_JPRB, 2.39214E+00_JPRB, 2.41816E+00_JPRB, &
     & 2.44446E+00_JPRB, 2.47105E+00_JPRB, 2.49793E+00_JPRB, 2.52510E+00_JPRB/)
      KAO_MN2O( 8, :, 9) = (/ &
     & 1.68230E+00_JPRB, 1.70305E+00_JPRB, 1.72404E+00_JPRB, 1.74530E+00_JPRB, 1.76681E+00_JPRB, &
     & 1.78860E+00_JPRB, 1.81065E+00_JPRB, 1.83297E+00_JPRB, 1.85557E+00_JPRB, 1.87845E+00_JPRB, &
     & 1.90161E+00_JPRB, 1.92505E+00_JPRB, 1.94878E+00_JPRB, 1.97281E+00_JPRB, 1.99713E+00_JPRB, &
     & 2.02176E+00_JPRB, 2.04668E+00_JPRB, 2.07191E+00_JPRB, 2.09746E+00_JPRB/)
      KAO_MN2O( 9, :, 9) = (/ &
     & 2.23224E+00_JPRB, 2.25486E+00_JPRB, 2.27771E+00_JPRB, 2.30079E+00_JPRB, 2.32411E+00_JPRB, &
     & 2.34766E+00_JPRB, 2.37145E+00_JPRB, 2.39548E+00_JPRB, 2.41975E+00_JPRB, 2.44427E+00_JPRB, &
     & 2.46904E+00_JPRB, 2.49406E+00_JPRB, 2.51933E+00_JPRB, 2.54486E+00_JPRB, 2.57065E+00_JPRB, &
     & 2.59670E+00_JPRB, 2.62301E+00_JPRB, 2.64959E+00_JPRB, 2.67644E+00_JPRB/)
      KAO_MN2O( 1, :,10) = (/ &
     & 1.30711E+01_JPRB, 1.31853E+01_JPRB, 1.33004E+01_JPRB, 1.34166E+01_JPRB, 1.35339E+01_JPRB, &
     & 1.36521E+01_JPRB, 1.37714E+01_JPRB, 1.38917E+01_JPRB, 1.40130E+01_JPRB, 1.41355E+01_JPRB, &
     & 1.42590E+01_JPRB, 1.43835E+01_JPRB, 1.45092E+01_JPRB, 1.46360E+01_JPRB, 1.47638E+01_JPRB, &
     & 1.48928E+01_JPRB, 1.50229E+01_JPRB, 1.51542E+01_JPRB, 1.52866E+01_JPRB/)
      KAO_MN2O( 2, :,10) = (/ &
     & 2.71206E-01_JPRB, 2.90148E-01_JPRB, 3.10413E-01_JPRB, 3.32093E-01_JPRB, 3.55287E-01_JPRB, &
     & 3.80102E-01_JPRB, 4.06649E-01_JPRB, 4.35051E-01_JPRB, 4.65436E-01_JPRB, 4.97943E-01_JPRB, &
     & 5.32721E-01_JPRB, 5.69928E-01_JPRB, 6.09733E-01_JPRB, 6.52319E-01_JPRB, 6.97879E-01_JPRB, &
     & 7.46621E-01_JPRB, 7.98767E-01_JPRB, 8.54555E-01_JPRB, 9.14239E-01_JPRB/)
      KAO_MN2O( 3, :,10) = (/ &
     & 2.65609E-01_JPRB, 2.84236E-01_JPRB, 3.04170E-01_JPRB, 3.25501E-01_JPRB, 3.48329E-01_JPRB, &
     & 3.72758E-01_JPRB, 3.98900E-01_JPRB, 4.26875E-01_JPRB, 4.56812E-01_JPRB, 4.88849E-01_JPRB, &
     & 5.23132E-01_JPRB, 5.59820E-01_JPRB, 5.99080E-01_JPRB, 6.41095E-01_JPRB, 6.86055E-01_JPRB, &
     & 7.34169E-01_JPRB, 7.85657E-01_JPRB, 8.40756E-01_JPRB, 8.99718E-01_JPRB/)
      KAO_MN2O( 4, :,10) = (/ &
     & 2.55277E-01_JPRB, 2.73370E-01_JPRB, 2.92745E-01_JPRB, 3.13494E-01_JPRB, 3.35714E-01_JPRB, &
     & 3.59508E-01_JPRB, 3.84989E-01_JPRB, 4.12275E-01_JPRB, 4.41496E-01_JPRB, 4.72788E-01_JPRB, &
     & 5.06298E-01_JPRB, 5.42183E-01_JPRB, 5.80611E-01_JPRB, 6.21763E-01_JPRB, 6.65831E-01_JPRB, &
     & 7.13023E-01_JPRB, 7.63560E-01_JPRB, 8.17678E-01_JPRB, 8.75633E-01_JPRB/)
      KAO_MN2O( 5, :,10) = (/ &
     & 2.41481E-01_JPRB, 2.58840E-01_JPRB, 2.77446E-01_JPRB, 2.97390E-01_JPRB, 3.18768E-01_JPRB, &
     & 3.41682E-01_JPRB, 3.66244E-01_JPRB, 3.92571E-01_JPRB, 4.20791E-01_JPRB, 4.51039E-01_JPRB, &
     & 4.83461E-01_JPRB, 5.18215E-01_JPRB, 5.55466E-01_JPRB, 5.95396E-01_JPRB, 6.38195E-01_JPRB, &
     & 6.84071E-01_JPRB, 7.33245E-01_JPRB, 7.85954E-01_JPRB, 8.42452E-01_JPRB/)
      KAO_MN2O( 6, :,10) = (/ &
     & 2.37173E-01_JPRB, 2.54360E-01_JPRB, 2.72792E-01_JPRB, 2.92559E-01_JPRB, 3.13759E-01_JPRB, &
     & 3.36495E-01_JPRB, 3.60878E-01_JPRB, 3.87029E-01_JPRB, 4.15074E-01_JPRB, 4.45152E-01_JPRB, &
     & 4.77409E-01_JPRB, 5.12004E-01_JPRB, 5.49105E-01_JPRB, 5.88895E-01_JPRB, 6.31569E-01_JPRB, &
     & 6.77334E-01_JPRB, 7.26416E-01_JPRB, 7.79055E-01_JPRB, 8.35508E-01_JPRB/)
      KAO_MN2O( 7, :,10) = (/ &
     & 2.27414E-01_JPRB, 2.44231E-01_JPRB, 2.62292E-01_JPRB, 2.81689E-01_JPRB, 3.02520E-01_JPRB, &
     & 3.24891E-01_JPRB, 3.48917E-01_JPRB, 3.74720E-01_JPRB, 4.02430E-01_JPRB, 4.32190E-01_JPRB, &
     & 4.64151E-01_JPRB, 4.98475E-01_JPRB, 5.35337E-01_JPRB, 5.74926E-01_JPRB, 6.17442E-01_JPRB, &
     & 6.63102E-01_JPRB, 7.12138E-01_JPRB, 7.64801E-01_JPRB, 8.21358E-01_JPRB/)
      KAO_MN2O( 8, :,10) = (/ &
     & 1.77234E-01_JPRB, 1.92029E-01_JPRB, 2.08060E-01_JPRB, 2.25429E-01_JPRB, 2.44248E-01_JPRB, &
     & 2.64638E-01_JPRB, 2.86730E-01_JPRB, 3.10667E-01_JPRB, 3.36601E-01_JPRB, 3.64701E-01_JPRB, &
     & 3.95147E-01_JPRB, 4.28134E-01_JPRB, 4.63875E-01_JPRB, 5.02600E-01_JPRB, 5.44557E-01_JPRB, &
     & 5.90017E-01_JPRB, 6.39272E-01_JPRB, 6.92639E-01_JPRB, 7.50461E-01_JPRB/)
      KAO_MN2O( 9, :,10) = (/ &
     & 2.41727E-01_JPRB, 2.59094E-01_JPRB, 2.77710E-01_JPRB, 2.97662E-01_JPRB, 3.19049E-01_JPRB, &
     & 3.41972E-01_JPRB, 3.66541E-01_JPRB, 3.92877E-01_JPRB, 4.21104E-01_JPRB, 4.51359E-01_JPRB, &
     & 4.83788E-01_JPRB, 5.18547E-01_JPRB, 5.55804E-01_JPRB, 5.95737E-01_JPRB, 6.38539E-01_JPRB, &
     & 6.84417E-01_JPRB, 7.33590E-01_JPRB, 7.86297E-01_JPRB, 8.42790E-01_JPRB/)
      KAO_MN2O( 1, :,11) = (/ &
     & 6.65287E+00_JPRB, 6.69137E+00_JPRB, 6.73008E+00_JPRB, 6.76903E+00_JPRB, 6.80820E+00_JPRB, &
     & 6.84759E+00_JPRB, 6.88721E+00_JPRB, 6.92707E+00_JPRB, 6.96715E+00_JPRB, 7.00746E+00_JPRB, &
     & 7.04801E+00_JPRB, 7.08879E+00_JPRB, 7.12981E+00_JPRB, 7.17107E+00_JPRB, 7.21256E+00_JPRB, &
     & 7.25430E+00_JPRB, 7.29628E+00_JPRB, 7.33850E+00_JPRB, 7.38096E+00_JPRB/)
      KAO_MN2O( 2, :,11) = (/ &
     & 2.06252E-01_JPRB, 2.27731E-01_JPRB, 2.51447E-01_JPRB, 2.77633E-01_JPRB, 3.06546E-01_JPRB, &
     & 3.38470E-01_JPRB, 3.73719E-01_JPRB, 4.12638E-01_JPRB, 4.55611E-01_JPRB, 5.03058E-01_JPRB, &
     & 5.55447E-01_JPRB, 6.13292E-01_JPRB, 6.77160E-01_JPRB, 7.47680E-01_JPRB, 8.25544E-01_JPRB, &
     & 9.11517E-01_JPRB, 1.00644E+00_JPRB, 1.11125E+00_JPRB, 1.22698E+00_JPRB/)
      KAO_MN2O( 3, :,11) = (/ &
     & 2.05840E-01_JPRB, 2.27279E-01_JPRB, 2.50952E-01_JPRB, 2.77090E-01_JPRB, 3.05950E-01_JPRB, &
     & 3.37816E-01_JPRB, 3.73002E-01_JPRB, 4.11852E-01_JPRB, 4.54748E-01_JPRB, 5.02113E-01_JPRB, &
     & 5.54411E-01_JPRB, 6.12155E-01_JPRB, 6.75915E-01_JPRB, 7.46315E-01_JPRB, 8.24047E-01_JPRB, &
     & 9.09876E-01_JPRB, 1.00465E+00_JPRB, 1.10928E+00_JPRB, 1.22482E+00_JPRB/)
      KAO_MN2O( 4, :,11) = (/ &
     & 2.04702E-01_JPRB, 2.26031E-01_JPRB, 2.49582E-01_JPRB, 2.75587E-01_JPRB, 3.04301E-01_JPRB, &
     & 3.36008E-01_JPRB, 3.71018E-01_JPRB, 4.09675E-01_JPRB, 4.52361E-01_JPRB, 4.99495E-01_JPRB, &
     & 5.51539E-01_JPRB, 6.09007E-01_JPRB, 6.72461E-01_JPRB, 7.42528E-01_JPRB, 8.19895E-01_JPRB, &
     & 9.05323E-01_JPRB, 9.99653E-01_JPRB, 1.10381E+00_JPRB, 1.21882E+00_JPRB/)
      KAO_MN2O( 5, :,11) = (/ &
     & 2.03481E-01_JPRB, 2.24689E-01_JPRB, 2.48108E-01_JPRB, 2.73967E-01_JPRB, 3.02522E-01_JPRB, &
     & 3.34053E-01_JPRB, 3.68871E-01_JPRB, 4.07317E-01_JPRB, 4.49771E-01_JPRB, 4.96649E-01_JPRB, &
     & 5.48414E-01_JPRB, 6.05574E-01_JPRB, 6.68691E-01_JPRB, 7.38387E-01_JPRB, 8.15347E-01_JPRB, &
     & 9.00329E-01_JPRB, 9.94168E-01_JPRB, 1.09779E+00_JPRB, 1.21221E+00_JPRB/)
      KAO_MN2O( 6, :,11) = (/ &
     & 2.01513E-01_JPRB, 2.22529E-01_JPRB, 2.45738E-01_JPRB, 2.71367E-01_JPRB, 2.99670E-01_JPRB, &
     & 3.30924E-01_JPRB, 3.65437E-01_JPRB, 4.03550E-01_JPRB, 4.45639E-01_JPRB, 4.92117E-01_JPRB, &
     & 5.43442E-01_JPRB, 6.00120E-01_JPRB, 6.62710E-01_JPRB, 7.31827E-01_JPRB, 8.08153E-01_JPRB, &
     & 8.92439E-01_JPRB, 9.85516E-01_JPRB, 1.08830E+00_JPRB, 1.20180E+00_JPRB/)
      KAO_MN2O( 7, :,11) = (/ &
     & 1.97136E-01_JPRB, 2.17723E-01_JPRB, 2.40459E-01_JPRB, 2.65570E-01_JPRB, 2.93304E-01_JPRB, &
     & 3.23933E-01_JPRB, 3.57762E-01_JPRB, 3.95122E-01_JPRB, 4.36385E-01_JPRB, 4.81956E-01_JPRB, &
     & 5.32287E-01_JPRB, 5.87873E-01_JPRB, 6.49264E-01_JPRB, 7.17067E-01_JPRB, 7.91950E-01_JPRB, &
     & 8.74653E-01_JPRB, 9.65992E-01_JPRB, 1.06687E+00_JPRB, 1.17828E+00_JPRB/)
      KAO_MN2O( 8, :,11) = (/ &
     & 1.79518E-01_JPRB, 1.98371E-01_JPRB, 2.19204E-01_JPRB, 2.42224E-01_JPRB, 2.67662E-01_JPRB, &
     & 2.95772E-01_JPRB, 3.26833E-01_JPRB, 3.61157E-01_JPRB, 3.99085E-01_JPRB, 4.40996E-01_JPRB, &
     & 4.87309E-01_JPRB, 5.38486E-01_JPRB, 5.95037E-01_JPRB, 6.57526E-01_JPRB, 7.26579E-01_JPRB, &
     & 8.02883E-01_JPRB, 8.87201E-01_JPRB, 9.80373E-01_JPRB, 1.08333E+00_JPRB/)
      KAO_MN2O( 9, :,11) = (/ &
     & 2.03481E-01_JPRB, 2.24689E-01_JPRB, 2.48108E-01_JPRB, 2.73967E-01_JPRB, 3.02522E-01_JPRB, &
     & 3.34053E-01_JPRB, 3.68871E-01_JPRB, 4.07317E-01_JPRB, 4.49771E-01_JPRB, 4.96649E-01_JPRB, &
     & 5.48414E-01_JPRB, 6.05574E-01_JPRB, 6.68691E-01_JPRB, 7.38387E-01_JPRB, 8.15347E-01_JPRB, &
     & 9.00329E-01_JPRB, 9.94168E-01_JPRB, 1.09779E+00_JPRB, 1.21221E+00_JPRB/)
      KAO_MN2O( 1, :,12) = (/ &
     & 5.89636E+00_JPRB, 5.95081E+00_JPRB, 6.00576E+00_JPRB, 6.06121E+00_JPRB, 6.11718E+00_JPRB, &
     & 6.17366E+00_JPRB, 6.23067E+00_JPRB, 6.28820E+00_JPRB, 6.34627E+00_JPRB, 6.40487E+00_JPRB, &
     & 6.46401E+00_JPRB, 6.52369E+00_JPRB, 6.58393E+00_JPRB, 6.64472E+00_JPRB, 6.70608E+00_JPRB, &
     & 6.76800E+00_JPRB, 6.83050E+00_JPRB, 6.89357E+00_JPRB, 6.95722E+00_JPRB/)
      KAO_MN2O( 2, :,12) = (/ &
     & 7.18699E-05_JPRB, 9.48140E-05_JPRB, 1.25083E-04_JPRB, 1.65015E-04_JPRB, 2.17695E-04_JPRB, &
     & 2.87193E-04_JPRB, 3.78877E-04_JPRB, 4.99831E-04_JPRB, 6.59400E-04_JPRB, 8.69909E-04_JPRB, &
     & 1.14762E-03_JPRB, 1.51400E-03_JPRB, 1.99733E-03_JPRB, 2.63497E-03_JPRB, 3.47616E-03_JPRB, &
     & 4.58591E-03_JPRB, 6.04993E-03_JPRB, 7.98133E-03_JPRB, 1.05293E-02_JPRB/)
      KAO_MN2O( 3, :,12) = (/ &
     & 7.20868E-05_JPRB, 9.50993E-05_JPRB, 1.25458E-04_JPRB, 1.65508E-04_JPRB, 2.18344E-04_JPRB, &
     & 2.88046E-04_JPRB, 3.80000E-04_JPRB, 5.01307E-04_JPRB, 6.61341E-04_JPRB, 8.72462E-04_JPRB, &
     & 1.15098E-03_JPRB, 1.51841E-03_JPRB, 2.00313E-03_JPRB, 2.64260E-03_JPRB, 3.48620E-03_JPRB, &
     & 4.59911E-03_JPRB, 6.06729E-03_JPRB, 8.00416E-03_JPRB, 1.05593E-02_JPRB/)
      KAO_MN2O( 4, :,12) = (/ &
     & 7.21734E-05_JPRB, 9.52161E-05_JPRB, 1.25616E-04_JPRB, 1.65721E-04_JPRB, 2.18630E-04_JPRB, &
     & 2.88432E-04_JPRB, 3.80519E-04_JPRB, 5.02007E-04_JPRB, 6.62282E-04_JPRB, 8.73727E-04_JPRB, &
     & 1.15268E-03_JPRB, 1.52070E-03_JPRB, 2.00621E-03_JPRB, 2.64673E-03_JPRB, 3.49174E-03_JPRB, &
     & 4.60655E-03_JPRB, 6.07727E-03_JPRB, 8.01755E-03_JPRB, 1.05773E-02_JPRB/)
      KAO_MN2O( 5, :,12) = (/ &
     & 7.22599E-05_JPRB, 9.53329E-05_JPRB, 1.25773E-04_JPRB, 1.65933E-04_JPRB, 2.18916E-04_JPRB, &
     & 2.88818E-04_JPRB, 3.81038E-04_JPRB, 5.02706E-04_JPRB, 6.63223E-04_JPRB, 8.74992E-04_JPRB, &
     & 1.15438E-03_JPRB, 1.52298E-03_JPRB, 2.00928E-03_JPRB, 2.65085E-03_JPRB, 3.49728E-03_JPRB, &
     & 4.61398E-03_JPRB, 6.08725E-03_JPRB, 8.03094E-03_JPRB, 1.05952E-02_JPRB/)
      KAO_MN2O( 6, :,12) = (/ &
     & 7.29962E-05_JPRB, 9.63091E-05_JPRB, 1.27067E-04_JPRB, 1.67649E-04_JPRB, 2.21191E-04_JPRB, &
     & 2.91833E-04_JPRB, 3.85036E-04_JPRB, 5.08005E-04_JPRB, 6.70247E-04_JPRB, 8.84304E-04_JPRB, &
     & 1.16672E-03_JPRB, 1.53934E-03_JPRB, 2.03096E-03_JPRB, 2.67959E-03_JPRB, 3.53537E-03_JPRB, &
     & 4.66447E-03_JPRB, 6.15417E-03_JPRB, 8.11962E-03_JPRB, 1.07128E-02_JPRB/)
      KAO_MN2O( 7, :,12) = (/ &
     & 7.47398E-05_JPRB, 9.86139E-05_JPRB, 1.30114E-04_JPRB, 1.71677E-04_JPRB, 2.26516E-04_JPRB, &
     & 2.98872E-04_JPRB, 3.94340E-04_JPRB, 5.20305E-04_JPRB, 6.86506E-04_JPRB, 9.05797E-04_JPRB, &
     & 1.19514E-03_JPRB, 1.57690E-03_JPRB, 2.08061E-03_JPRB, 2.74522E-03_JPRB, 3.62213E-03_JPRB, &
     & 4.77915E-03_JPRB, 6.30576E-03_JPRB, 8.32001E-03_JPRB, 1.09777E-02_JPRB/)
      KAO_MN2O( 8, :,12) = (/ &
     & 7.57487E-05_JPRB, 9.99802E-05_JPRB, 1.31963E-04_JPRB, 1.74177E-04_JPRB, 2.29896E-04_JPRB, &
     & 3.03438E-04_JPRB, 4.00506E-04_JPRB, 5.28625E-04_JPRB, 6.97729E-04_JPRB, 9.20927E-04_JPRB, &
     & 1.21553E-03_JPRB, 1.60437E-03_JPRB, 2.11759E-03_JPRB, 2.79499E-03_JPRB, 3.68909E-03_JPRB, &
     & 4.86921E-03_JPRB, 6.42684E-03_JPRB, 8.48274E-03_JPRB, 1.11963E-02_JPRB/)
      KAO_MN2O( 9, :,12) = (/ &
     & 7.22467E-05_JPRB, 9.53177E-05_JPRB, 1.25756E-04_JPRB, 1.65915E-04_JPRB, 2.18898E-04_JPRB, &
     & 2.88800E-04_JPRB, 3.81024E-04_JPRB, 5.02700E-04_JPRB, 6.63231E-04_JPRB, 8.75024E-04_JPRB, &
     & 1.15445E-03_JPRB, 1.52311E-03_JPRB, 2.00950E-03_JPRB, 2.65121E-03_JPRB, 3.49784E-03_JPRB, &
     & 4.61483E-03_JPRB, 6.08852E-03_JPRB, 8.03280E-03_JPRB, 1.05980E-02_JPRB/)
      KAO_MN2O( 1, :,13) = (/ &
     & 1.14265E+01_JPRB, 1.16380E+01_JPRB, 1.18534E+01_JPRB, 1.20728E+01_JPRB, 1.22962E+01_JPRB, &
     & 1.25238E+01_JPRB, 1.27556E+01_JPRB, 1.29917E+01_JPRB, 1.32322E+01_JPRB, 1.34771E+01_JPRB, &
     & 1.37265E+01_JPRB, 1.39806E+01_JPRB, 1.42394E+01_JPRB, 1.45029E+01_JPRB, 1.47714E+01_JPRB, &
     & 1.50448E+01_JPRB, 1.53232E+01_JPRB, 1.56068E+01_JPRB, 1.58957E+01_JPRB/)
      KAO_MN2O( 2, :,13) = (/ &
     & 7.97796E-05_JPRB, 1.05659E-04_JPRB, 1.39932E-04_JPRB, 1.85324E-04_JPRB, 2.45439E-04_JPRB, &
     & 3.25054E-04_JPRB, 4.30496E-04_JPRB, 5.70140E-04_JPRB, 7.55082E-04_JPRB, 1.00002E-03_JPRB, &
     & 1.32440E-03_JPRB, 1.75401E-03_JPRB, 2.32298E-03_JPRB, 3.07651E-03_JPRB, 4.07447E-03_JPRB, &
     & 5.39614E-03_JPRB, 7.14655E-03_JPRB, 9.46475E-03_JPRB, 1.25349E-02_JPRB/)
      KAO_MN2O( 3, :,13) = (/ &
     & 7.95035E-05_JPRB, 1.05293E-04_JPRB, 1.39449E-04_JPRB, 1.84684E-04_JPRB, 2.44592E-04_JPRB, &
     & 3.23934E-04_JPRB, 4.29013E-04_JPRB, 5.68178E-04_JPRB, 7.52486E-04_JPRB, 9.96580E-04_JPRB, &
     & 1.31985E-03_JPRB, 1.74800E-03_JPRB, 2.31502E-03_JPRB, 3.06597E-03_JPRB, 4.06052E-03_JPRB, &
     & 5.37770E-03_JPRB, 7.12214E-03_JPRB, 9.43244E-03_JPRB, 1.24922E-02_JPRB/)
      KAO_MN2O( 4, :,13) = (/ &
     & 7.92339E-05_JPRB, 1.04938E-04_JPRB, 1.38980E-04_JPRB, 1.84065E-04_JPRB, 2.43776E-04_JPRB, &
     & 3.22857E-04_JPRB, 4.27593E-04_JPRB, 5.66305E-04_JPRB, 7.50016E-04_JPRB, 9.93322E-04_JPRB, &
     & 1.31556E-03_JPRB, 1.74233E-03_JPRB, 2.30754E-03_JPRB, 3.05612E-03_JPRB, 4.04752E-03_JPRB, &
     & 5.36055E-03_JPRB, 7.09953E-03_JPRB, 9.40262E-03_JPRB, 1.24528E-02_JPRB/)
      KAO_MN2O( 5, :,13) = (/ &
     & 7.90000E-05_JPRB, 1.04627E-04_JPRB, 1.38566E-04_JPRB, 1.83516E-04_JPRB, 2.43046E-04_JPRB, &
     & 3.21887E-04_JPRB, 4.26303E-04_JPRB, 5.64591E-04_JPRB, 7.47738E-04_JPRB, 9.90295E-04_JPRB, &
     & 1.31154E-03_JPRB, 1.73698E-03_JPRB, 2.30044E-03_JPRB, 3.04667E-03_JPRB, 4.03498E-03_JPRB, &
     & 5.34388E-03_JPRB, 7.07737E-03_JPRB, 9.37318E-03_JPRB, 1.24137E-02_JPRB/)
      KAO_MN2O( 6, :,13) = (/ &
     & 7.76004E-05_JPRB, 1.02776E-04_JPRB, 1.36118E-04_JPRB, 1.80278E-04_JPRB, 2.38764E-04_JPRB, &
     & 3.16224E-04_JPRB, 4.18814E-04_JPRB, 5.54686E-04_JPRB, 7.34638E-04_JPRB, 9.72970E-04_JPRB, &
     & 1.28862E-03_JPRB, 1.70668E-03_JPRB, 2.26036E-03_JPRB, 2.99367E-03_JPRB, 3.96488E-03_JPRB, &
     & 5.25118E-03_JPRB, 6.95477E-03_JPRB, 9.21105E-03_JPRB, 1.21993E-02_JPRB/)
      KAO_MN2O( 7, :,13) = (/ &
     & 7.52813E-05_JPRB, 9.97094E-05_JPRB, 1.32064E-04_JPRB, 1.74918E-04_JPRB, 2.31677E-04_JPRB, &
     & 3.06854E-04_JPRB, 4.06426E-04_JPRB, 5.38308E-04_JPRB, 7.12984E-04_JPRB, 9.44341E-04_JPRB, &
     & 1.25077E-03_JPRB, 1.65664E-03_JPRB, 2.19420E-03_JPRB, 2.90620E-03_JPRB, 3.84923E-03_JPRB, &
     & 5.09828E-03_JPRB, 6.75263E-03_JPRB, 8.94379E-03_JPRB, 1.18460E-02_JPRB/)
      KAO_MN2O( 8, :,13) = (/ &
     & 6.87436E-05_JPRB, 9.10605E-05_JPRB, 1.20622E-04_JPRB, 1.59781E-04_JPRB, 2.11653E-04_JPRB, &
     & 2.80364E-04_JPRB, 3.71381E-04_JPRB, 4.91946E-04_JPRB, 6.51651E-04_JPRB, 8.63203E-04_JPRB, &
     & 1.14343E-03_JPRB, 1.51464E-03_JPRB, 2.00635E-03_JPRB, 2.65769E-03_JPRB, 3.52048E-03_JPRB, &
     & 4.66337E-03_JPRB, 6.17729E-03_JPRB, 8.18269E-03_JPRB, 1.08391E-02_JPRB/)
      KAO_MN2O( 9, :,13) = (/ &
     & 7.90357E-05_JPRB, 1.04671E-04_JPRB, 1.38622E-04_JPRB, 1.83585E-04_JPRB, 2.43132E-04_JPRB, &
     & 3.21994E-04_JPRB, 4.26434E-04_JPRB, 5.64750E-04_JPRB, 7.47931E-04_JPRB, 9.90526E-04_JPRB, &
     & 1.31181E-03_JPRB, 1.73730E-03_JPRB, 2.30081E-03_JPRB, 3.04709E-03_JPRB, 4.03543E-03_JPRB, &
     & 5.34435E-03_JPRB, 7.07782E-03_JPRB, 9.37355E-03_JPRB, 1.24139E-02_JPRB/)
      KAO_MN2O( 1, :,14) = (/ &
     & 1.61373E+01_JPRB, 1.64784E+01_JPRB, 1.68266E+01_JPRB, 1.71822E+01_JPRB, 1.75454E+01_JPRB, &
     & 1.79162E+01_JPRB, 1.82948E+01_JPRB, 1.86814E+01_JPRB, 1.90762E+01_JPRB, 1.94794E+01_JPRB, &
     & 1.98911E+01_JPRB, 2.03114E+01_JPRB, 2.07407E+01_JPRB, 2.11790E+01_JPRB, 2.16266E+01_JPRB, &
     & 2.20836E+01_JPRB, 2.25504E+01_JPRB, 2.30269E+01_JPRB, 2.35136E+01_JPRB/)
      KAO_MN2O( 2, :,14) = (/ &
     & 6.92866E-10_JPRB, 9.24655E-10_JPRB, 1.23398E-09_JPRB, 1.64680E-09_JPRB, 2.19771E-09_JPRB, &
     & 2.93292E-09_JPRB, 3.91409E-09_JPRB, 5.22349E-09_JPRB, 6.97093E-09_JPRB, 9.30295E-09_JPRB, &
     & 1.24151E-08_JPRB, 1.65684E-08_JPRB, 2.21111E-08_JPRB, 2.95081E-08_JPRB, 3.93796E-08_JPRB, &
     & 5.25535E-08_JPRB, 7.01346E-08_JPRB, 9.35970E-08_JPRB, 1.24908E-07_JPRB/)
      KAO_MN2O( 3, :,14) = (/ &
     & 6.94564E-10_JPRB, 9.26928E-10_JPRB, 1.23703E-09_JPRB, 1.65088E-09_JPRB, 2.20317E-09_JPRB, &
     & 2.94024E-09_JPRB, 3.92389E-09_JPRB, 5.23661E-09_JPRB, 6.98851E-09_JPRB, 9.32650E-09_JPRB, &
     & 1.24467E-08_JPRB, 1.66107E-08_JPRB, 2.21677E-08_JPRB, 2.95839E-08_JPRB, 3.94811E-08_JPRB, &
     & 5.26894E-08_JPRB, 7.03165E-08_JPRB, 9.38407E-08_JPRB, 1.25235E-07_JPRB/)
      KAO_MN2O( 4, :,14) = (/ &
     & 6.98644E-10_JPRB, 9.32310E-10_JPRB, 1.24413E-09_JPRB, 1.66023E-09_JPRB, 2.21551E-09_JPRB, &
     & 2.95649E-09_JPRB, 3.94531E-09_JPRB, 5.26484E-09_JPRB, 7.02570E-09_JPRB, 9.37548E-09_JPRB, &
     & 1.25112E-08_JPRB, 1.66956E-08_JPRB, 2.22795E-08_JPRB, 2.97311E-08_JPRB, 3.96748E-08_JPRB, &
     & 5.29443E-08_JPRB, 7.06518E-08_JPRB, 9.42817E-08_JPRB, 1.25815E-07_JPRB/)
      KAO_MN2O( 5, :,14) = (/ &
     & 7.03261E-10_JPRB, 9.38472E-10_JPRB, 1.25235E-09_JPRB, 1.67121E-09_JPRB, 2.23016E-09_JPRB, &
     & 2.97605E-09_JPRB, 3.97141E-09_JPRB, 5.29968E-09_JPRB, 7.07220E-09_JPRB, 9.43754E-09_JPRB, &
     & 1.25940E-08_JPRB, 1.68062E-08_JPRB, 2.24271E-08_JPRB, 2.99280E-08_JPRB, 3.99376E-08_JPRB, &
     & 5.32951E-08_JPRB, 7.11200E-08_JPRB, 9.49066E-08_JPRB, 1.26649E-07_JPRB/)
      KAO_MN2O( 6, :,14) = (/ &
     & 7.12478E-10_JPRB, 9.50674E-10_JPRB, 1.26850E-09_JPRB, 1.69259E-09_JPRB, 2.25845E-09_JPRB, &
     & 3.01350E-09_JPRB, 4.02096E-09_JPRB, 5.36525E-09_JPRB, 7.15896E-09_JPRB, 9.55233E-09_JPRB, &
     & 1.27459E-08_JPRB, 1.70071E-08_JPRB, 2.26928E-08_JPRB, 3.02795E-08_JPRB, 4.04025E-08_JPRB, &
     & 5.39099E-08_JPRB, 7.19330E-08_JPRB, 9.59815E-08_JPRB, 1.28070E-07_JPRB/)
      KAO_MN2O( 7, :,14) = (/ &
     & 7.28994E-10_JPRB, 9.72644E-10_JPRB, 1.29773E-09_JPRB, 1.73147E-09_JPRB, 2.31017E-09_JPRB, &
     & 3.08230E-09_JPRB, 4.11249E-09_JPRB, 5.48700E-09_JPRB, 7.32092E-09_JPRB, 9.76777E-09_JPRB, &
     & 1.30324E-08_JPRB, 1.73883E-08_JPRB, 2.31999E-08_JPRB, 3.09540E-08_JPRB, 4.12996E-08_JPRB, &
     & 5.51032E-08_JPRB, 7.35203E-08_JPRB, 9.80928E-08_JPRB, 1.30878E-07_JPRB/)
      KAO_MN2O( 8, :,14) = (/ &
     & 7.87604E-10_JPRB, 1.05043E-09_JPRB, 1.40097E-09_JPRB, 1.86848E-09_JPRB, 2.49201E-09_JPRB, &
     & 3.32360E-09_JPRB, 4.43271E-09_JPRB, 5.91194E-09_JPRB, 7.88479E-09_JPRB, 1.05160E-08_JPRB, &
     & 1.40253E-08_JPRB, 1.87056E-08_JPRB, 2.49478E-08_JPRB, 3.32730E-08_JPRB, 4.43764E-08_JPRB, &
     & 5.91851E-08_JPRB, 7.89356E-08_JPRB, 1.05277E-07_JPRB, 1.40408E-07_JPRB/)
      KAO_MN2O( 9, :,14) = (/ &
     & 7.03261E-10_JPRB, 9.38472E-10_JPRB, 1.25235E-09_JPRB, 1.67121E-09_JPRB, 2.23016E-09_JPRB, &
     & 2.97605E-09_JPRB, 3.97141E-09_JPRB, 5.29968E-09_JPRB, 7.07220E-09_JPRB, 9.43754E-09_JPRB, &
     & 1.25940E-08_JPRB, 1.68062E-08_JPRB, 2.24271E-08_JPRB, 2.99280E-08_JPRB, 3.99376E-08_JPRB, &
     & 5.32951E-08_JPRB, 7.11200E-08_JPRB, 9.49066E-08_JPRB, 1.26649E-07_JPRB/)
      KAO_MN2O( 1, :,15) = (/ &
     & 2.14029E+01_JPRB, 2.16782E+01_JPRB, 2.19571E+01_JPRB, 2.22396E+01_JPRB, 2.25257E+01_JPRB, &
     & 2.28155E+01_JPRB, 2.31090E+01_JPRB, 2.34063E+01_JPRB, 2.37074E+01_JPRB, 2.40124E+01_JPRB, &
     & 2.43213E+01_JPRB, 2.46342E+01_JPRB, 2.49511E+01_JPRB, 2.52721E+01_JPRB, 2.55972E+01_JPRB, &
     & 2.59265E+01_JPRB, 2.62600E+01_JPRB, 2.65979E+01_JPRB, 2.69400E+01_JPRB/)
      KAO_MN2O( 2, :,15) = (/ &
     & 5.68659E-10_JPRB, 7.55629E-10_JPRB, 1.00407E-09_JPRB, 1.33421E-09_JPRB, 1.77288E-09_JPRB, &
     & 2.35579E-09_JPRB, 3.13036E-09_JPRB, 4.15960E-09_JPRB, 5.52724E-09_JPRB, 7.34455E-09_JPRB, &
     & 9.75939E-09_JPRB, 1.29682E-08_JPRB, 1.72320E-08_JPRB, 2.28978E-08_JPRB, 3.04264E-08_JPRB, &
     & 4.04304E-08_JPRB, 5.37236E-08_JPRB, 7.13875E-08_JPRB, 9.48591E-08_JPRB/)
      KAO_MN2O( 3, :,15) = (/ &
     & 5.59573E-10_JPRB, 7.43558E-10_JPRB, 9.88035E-10_JPRB, 1.31290E-09_JPRB, 1.74457E-09_JPRB, &
     & 2.31817E-09_JPRB, 3.08037E-09_JPRB, 4.09318E-09_JPRB, 5.43900E-09_JPRB, 7.22730E-09_JPRB, &
     & 9.60360E-09_JPRB, 1.27612E-08_JPRB, 1.69570E-08_JPRB, 2.25324E-08_JPRB, 2.99409E-08_JPRB, &
     & 3.97853E-08_JPRB, 5.28665E-08_JPRB, 7.02486E-08_JPRB, 9.33459E-08_JPRB/)
      KAO_MN2O( 4, :,15) = (/ &
     & 5.50488E-10_JPRB, 7.31486E-10_JPRB, 9.71996E-10_JPRB, 1.29158E-09_JPRB, 1.71625E-09_JPRB, &
     & 2.28055E-09_JPRB, 3.03039E-09_JPRB, 4.02676E-09_JPRB, 5.35075E-09_JPRB, 7.11005E-09_JPRB, &
     & 9.44781E-09_JPRB, 1.25542E-08_JPRB, 1.66820E-08_JPRB, 2.21670E-08_JPRB, 2.94554E-08_JPRB, &
     & 3.91402E-08_JPRB, 5.20093E-08_JPRB, 6.91098E-08_JPRB, 9.18327E-08_JPRB/)
      KAO_MN2O( 5, :,15) = (/ &
     & 5.34010E-10_JPRB, 7.09574E-10_JPRB, 9.42858E-10_JPRB, 1.25284E-09_JPRB, 1.66473E-09_JPRB, &
     & 2.21203E-09_JPRB, 2.93927E-09_JPRB, 3.90560E-09_JPRB, 5.18963E-09_JPRB, 6.89580E-09_JPRB, &
     & 9.16290E-09_JPRB, 1.21754E-08_JPRB, 1.61782E-08_JPRB, 2.14970E-08_JPRB, 2.85645E-08_JPRB, &
     & 3.79555E-08_JPRB, 5.04340E-08_JPRB, 6.70149E-08_JPRB, 8.90470E-08_JPRB/)
      KAO_MN2O( 6, :,15) = (/ &
     & 5.08144E-10_JPRB, 6.75221E-10_JPRB, 8.97231E-10_JPRB, 1.19224E-09_JPRB, 1.58424E-09_JPRB, &
     & 2.10513E-09_JPRB, 2.79729E-09_JPRB, 3.71703E-09_JPRB, 4.93919E-09_JPRB, 6.56317E-09_JPRB, &
     & 8.72112E-09_JPRB, 1.15886E-08_JPRB, 1.53989E-08_JPRB, 2.04620E-08_JPRB, 2.71898E-08_JPRB, &
     & 3.61297E-08_JPRB, 4.80091E-08_JPRB, 6.37943E-08_JPRB, 8.47696E-08_JPRB/)
      KAO_MN2O( 7, :,15) = (/ &
     & 4.56716E-10_JPRB, 6.06884E-10_JPRB, 8.06427E-10_JPRB, 1.07158E-09_JPRB, 1.42391E-09_JPRB, &
     & 1.89210E-09_JPRB, 2.51422E-09_JPRB, 3.34089E-09_JPRB, 4.43938E-09_JPRB, 5.89904E-09_JPRB, &
     & 7.83864E-09_JPRB, 1.04160E-08_JPRB, 1.38408E-08_JPRB, 1.83916E-08_JPRB, 2.44387E-08_JPRB, &
     & 3.24742E-08_JPRB, 4.31517E-08_JPRB, 5.73399E-08_JPRB, 7.61932E-08_JPRB/)
      KAO_MN2O( 8, :,15) = (/ &
     & 2.78366E-10_JPRB, 3.69881E-10_JPRB, 4.91482E-10_JPRB, 6.53061E-10_JPRB, 8.67760E-10_JPRB, &
     & 1.15304E-09_JPRB, 1.53211E-09_JPRB, 2.03581E-09_JPRB, 2.70510E-09_JPRB, 3.59441E-09_JPRB, &
     & 4.77611E-09_JPRB, 6.34629E-09_JPRB, 8.43268E-09_JPRB, 1.12050E-08_JPRB, 1.48887E-08_JPRB, &
     & 1.97835E-08_JPRB, 2.62875E-08_JPRB, 3.49296E-08_JPRB, 4.64130E-08_JPRB/)
      KAO_MN2O( 9, :,15) = (/ &
     & 5.34010E-10_JPRB, 7.09574E-10_JPRB, 9.42858E-10_JPRB, 1.25284E-09_JPRB, 1.66473E-09_JPRB, &
     & 2.21203E-09_JPRB, 2.93927E-09_JPRB, 3.90560E-09_JPRB, 5.18963E-09_JPRB, 6.89580E-09_JPRB, &
     & 9.16290E-09_JPRB, 1.21754E-08_JPRB, 1.61782E-08_JPRB, 2.14970E-08_JPRB, 2.85645E-08_JPRB, &
     & 3.79555E-08_JPRB, 5.04340E-08_JPRB, 6.70149E-08_JPRB, 8.90470E-08_JPRB/)
      KAO_MN2O( 1, :,16) = (/ &
     & 2.90784E+01_JPRB, 2.93787E+01_JPRB, 2.96820E+01_JPRB, 2.99885E+01_JPRB, 3.02982E+01_JPRB, &
     & 3.06110E+01_JPRB, 3.09271E+01_JPRB, 3.12464E+01_JPRB, 3.15690E+01_JPRB, 3.18950E+01_JPRB, &
     & 3.22243E+01_JPRB, 3.25571E+01_JPRB, 3.28932E+01_JPRB, 3.32329E+01_JPRB, 3.35760E+01_JPRB, &
     & 3.39227E+01_JPRB, 3.42730E+01_JPRB, 3.46269E+01_JPRB, 3.49844E+01_JPRB/)
      KAO_MN2O( 2, :,16) = (/ &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB/)
      KAO_MN2O( 3, :,16) = (/ &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB/)
      KAO_MN2O( 4, :,16) = (/ &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB/)
      KAO_MN2O( 5, :,16) = (/ &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB/)
      KAO_MN2O( 6, :,16) = (/ &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB/)
      KAO_MN2O( 7, :,16) = (/ &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB/)
      KAO_MN2O( 8, :,16) = (/ &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB/)
      KAO_MN2O( 9, :,16) = (/ &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, &
     & 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB, 0.00000E+00_JPRB/)

!     The array KBO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level above 100~ mb.   The first index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
!     runs over the g-channel (1 to 16).

      KBO_MN2O(:, 1) = (/ &
     & 8.42688E-03_JPRB, 8.96787E-03_JPRB, 9.54358E-03_JPRB, 1.01563E-02_JPRB, 1.08083E-02_JPRB, &
     & 1.15021E-02_JPRB, 1.22405E-02_JPRB, 1.30263E-02_JPRB, 1.38626E-02_JPRB, 1.47525E-02_JPRB, &
     & 1.56996E-02_JPRB, 1.67075E-02_JPRB, 1.77800E-02_JPRB, 1.89215E-02_JPRB, 2.01362E-02_JPRB, &
     & 2.14289E-02_JPRB, 2.28045E-02_JPRB, 2.42685E-02_JPRB, 2.58265E-02_JPRB/)
      KBO_MN2O(:, 2) = (/ &
     & 2.24976E-02_JPRB, 2.38935E-02_JPRB, 2.53762E-02_JPRB, 2.69508E-02_JPRB, 2.86231E-02_JPRB, &
     & 3.03991E-02_JPRB, 3.22854E-02_JPRB, 3.42887E-02_JPRB, 3.64163E-02_JPRB, 3.86760E-02_JPRB, &
     & 4.10759E-02_JPRB, 4.36246E-02_JPRB, 4.63315E-02_JPRB, 4.92064E-02_JPRB, 5.22597E-02_JPRB, &
     & 5.55024E-02_JPRB, 5.89464E-02_JPRB, 6.26040E-02_JPRB, 6.64886E-02_JPRB/)
      KBO_MN2O(:, 3) = (/ &
     & 5.93542E-02_JPRB, 6.37312E-02_JPRB, 6.84310E-02_JPRB, 7.34774E-02_JPRB, 7.88960E-02_JPRB, &
     & 8.47141E-02_JPRB, 9.09613E-02_JPRB, 9.76692E-02_JPRB, 1.04872E-01_JPRB, 1.12605E-01_JPRB, &
     & 1.20910E-01_JPRB, 1.29826E-01_JPRB, 1.39400E-01_JPRB, 1.49680E-01_JPRB, 1.60718E-01_JPRB, &
     & 1.72570E-01_JPRB, 1.85296E-01_JPRB, 1.98961E-01_JPRB, 2.13633E-01_JPRB/)
      KBO_MN2O(:, 4) = (/ &
     & 1.98022E-01_JPRB, 2.05895E-01_JPRB, 2.14082E-01_JPRB, 2.22594E-01_JPRB, 2.31445E-01_JPRB, &
     & 2.40647E-01_JPRB, 2.50216E-01_JPRB, 2.60164E-01_JPRB, 2.70509E-01_JPRB, 2.81265E-01_JPRB, &
     & 2.92448E-01_JPRB, 3.04076E-01_JPRB, 3.16167E-01_JPRB, 3.28738E-01_JPRB, 3.41809E-01_JPRB, &
     & 3.55400E-01_JPRB, 3.69531E-01_JPRB, 3.84224E-01_JPRB, 3.99501E-01_JPRB/)
      KBO_MN2O(:, 5) = (/ &
     & 6.41413E-01_JPRB, 6.46239E-01_JPRB, 6.51101E-01_JPRB, 6.56000E-01_JPRB, 6.60936E-01_JPRB, &
     & 6.65910E-01_JPRB, 6.70920E-01_JPRB, 6.75968E-01_JPRB, 6.81054E-01_JPRB, 6.86179E-01_JPRB, &
     & 6.91342E-01_JPRB, 6.96544E-01_JPRB, 7.01785E-01_JPRB, 7.07065E-01_JPRB, 7.12385E-01_JPRB, &
     & 7.17746E-01_JPRB, 7.23146E-01_JPRB, 7.28587E-01_JPRB, 7.34070E-01_JPRB/)
      KBO_MN2O(:, 6) = (/ &
     & 1.47906E+00_JPRB, 1.48768E+00_JPRB, 1.49635E+00_JPRB, 1.50507E+00_JPRB, 1.51384E+00_JPRB, &
     & 1.52267E+00_JPRB, 1.53154E+00_JPRB, 1.54047E+00_JPRB, 1.54944E+00_JPRB, 1.55847E+00_JPRB, &
     & 1.56755E+00_JPRB, 1.57669E+00_JPRB, 1.58588E+00_JPRB, 1.59512E+00_JPRB, 1.60442E+00_JPRB, &
     & 1.61377E+00_JPRB, 1.62317E+00_JPRB, 1.63263E+00_JPRB, 1.64215E+00_JPRB/)
      KBO_MN2O(:, 7) = (/ &
     & 3.53152E+00_JPRB, 3.55492E+00_JPRB, 3.57848E+00_JPRB, 3.60219E+00_JPRB, 3.62606E+00_JPRB, &
     & 3.65008E+00_JPRB, 3.67427E+00_JPRB, 3.69862E+00_JPRB, 3.72313E+00_JPRB, 3.74780E+00_JPRB, &
     & 3.77263E+00_JPRB, 3.79763E+00_JPRB, 3.82279E+00_JPRB, 3.84812E+00_JPRB, 3.87362E+00_JPRB, &
     & 3.89929E+00_JPRB, 3.92513E+00_JPRB, 3.95114E+00_JPRB, 3.97732E+00_JPRB/)
      KBO_MN2O(:, 8) = (/ &
     & 9.06783E+00_JPRB, 9.04597E+00_JPRB, 9.02415E+00_JPRB, 9.00239E+00_JPRB, 8.98069E+00_JPRB, &
     & 8.95903E+00_JPRB, 8.93743E+00_JPRB, 8.91588E+00_JPRB, 8.89438E+00_JPRB, 8.87293E+00_JPRB, &
     & 8.85154E+00_JPRB, 8.83020E+00_JPRB, 8.80890E+00_JPRB, 8.78766E+00_JPRB, 8.76647E+00_JPRB, &
     & 8.74533E+00_JPRB, 8.72425E+00_JPRB, 8.70321E+00_JPRB, 8.68223E+00_JPRB/)
      KBO_MN2O(:, 9) = (/ &
     & 3.88220E+01_JPRB, 3.85805E+01_JPRB, 3.83405E+01_JPRB, 3.81019E+01_JPRB, 3.78649E+01_JPRB, &
     & 3.76293E+01_JPRB, 3.73952E+01_JPRB, 3.71625E+01_JPRB, 3.69313E+01_JPRB, 3.67016E+01_JPRB, &
     & 3.64732E+01_JPRB, 3.62463E+01_JPRB, 3.60208E+01_JPRB, 3.57967E+01_JPRB, 3.55740E+01_JPRB, &
     & 3.53527E+01_JPRB, 3.51327E+01_JPRB, 3.49142E+01_JPRB, 3.46970E+01_JPRB/)
      KBO_MN2O(:, 10) = (/ &
     & 1.14211E+02_JPRB, 1.13955E+02_JPRB, 1.13700E+02_JPRB, 1.13445E+02_JPRB, 1.13191E+02_JPRB, &
     & 1.12938E+02_JPRB, 1.12685E+02_JPRB, 1.12433E+02_JPRB, 1.12181E+02_JPRB, 1.11930E+02_JPRB, &
     & 1.11679E+02_JPRB, 1.11429E+02_JPRB, 1.11180E+02_JPRB, 1.10931E+02_JPRB, 1.10682E+02_JPRB, &
     & 1.10434E+02_JPRB, 1.10187E+02_JPRB, 1.09940E+02_JPRB, 1.09694E+02_JPRB/)
      KBO_MN2O(:, 11) = (/ &
     & 1.60513E+02_JPRB, 1.60857E+02_JPRB, 1.61201E+02_JPRB, 1.61547E+02_JPRB, 1.61893E+02_JPRB, &
     & 1.62240E+02_JPRB, 1.62587E+02_JPRB, 1.62936E+02_JPRB, 1.63285E+02_JPRB, 1.63635E+02_JPRB, &
     & 1.63985E+02_JPRB, 1.64337E+02_JPRB, 1.64689E+02_JPRB, 1.65041E+02_JPRB, 1.65395E+02_JPRB, &
     & 1.65749E+02_JPRB, 1.66105E+02_JPRB, 1.66460E+02_JPRB, 1.66817E+02_JPRB/)
      KBO_MN2O(:, 12) = (/ &
     & 1.71473E+02_JPRB, 1.72766E+02_JPRB, 1.74068E+02_JPRB, 1.75381E+02_JPRB, 1.76703E+02_JPRB, &
     & 1.78035E+02_JPRB, 1.79377E+02_JPRB, 1.80729E+02_JPRB, 1.82091E+02_JPRB, 1.83464E+02_JPRB, &
     & 1.84847E+02_JPRB, 1.86240E+02_JPRB, 1.87644E+02_JPRB, 1.89059E+02_JPRB, 1.90484E+02_JPRB, &
     & 1.91920E+02_JPRB, 1.93367E+02_JPRB, 1.94824E+02_JPRB, 1.96293E+02_JPRB/)
      KBO_MN2O(:, 13) = (/ &
     & 2.71287E+01_JPRB, 2.75538E+01_JPRB, 2.79856E+01_JPRB, 2.84241E+01_JPRB, 2.88695E+01_JPRB, &
     & 2.93219E+01_JPRB, 2.97814E+01_JPRB, 3.02480E+01_JPRB, 3.07220E+01_JPRB, 3.12035E+01_JPRB, &
     & 3.16924E+01_JPRB, 3.21890E+01_JPRB, 3.26934E+01_JPRB, 3.32058E+01_JPRB, 3.37261E+01_JPRB, &
     & 3.42546E+01_JPRB, 3.47914E+01_JPRB, 3.53365E+01_JPRB, 3.58903E+01_JPRB/)
      KBO_MN2O(:, 14) = (/ &
     & 1.70389E+01_JPRB, 1.70899E+01_JPRB, 1.71411E+01_JPRB, 1.71924E+01_JPRB, 1.72439E+01_JPRB, &
     & 1.72955E+01_JPRB, 1.73473E+01_JPRB, 1.73992E+01_JPRB, 1.74513E+01_JPRB, 1.75035E+01_JPRB, &
     & 1.75559E+01_JPRB, 1.76085E+01_JPRB, 1.76612E+01_JPRB, 1.77141E+01_JPRB, 1.77671E+01_JPRB, &
     & 1.78203E+01_JPRB, 1.78736E+01_JPRB, 1.79271E+01_JPRB, 1.79808E+01_JPRB/)
      KBO_MN2O(:, 15) = (/ &
     & 2.49725E+00_JPRB, 2.66861E+00_JPRB, 2.85174E+00_JPRB, 3.04743E+00_JPRB, 3.25655E+00_JPRB, &
     & 3.48003E+00_JPRB, 3.71883E+00_JPRB, 3.97403E+00_JPRB, 4.24673E+00_JPRB, 4.53815E+00_JPRB, &
     & 4.84957E+00_JPRB, 5.18236E+00_JPRB, 5.53798E+00_JPRB, 5.91801E+00_JPRB, 6.32412E+00_JPRB, &
     & 6.75809E+00_JPRB, 7.22185E+00_JPRB, 7.71742E+00_JPRB, 8.24701E+00_JPRB/)
      KBO_MN2O(:, 16) = (/ &
     & 1.82935E-03_JPRB, 2.58912E-03_JPRB, 3.66444E-03_JPRB, 5.18637E-03_JPRB, 7.34039E-03_JPRB, &
     & 1.03890E-02_JPRB, 1.47038E-02_JPRB, 2.08106E-02_JPRB, 2.94538E-02_JPRB, 4.16865E-02_JPRB, &
     & 5.89999E-02_JPRB, 8.35040E-02_JPRB, 1.18185E-01_JPRB, 1.67270E-01_JPRB, 2.36741E-01_JPRB, &
     & 3.35065E-01_JPRB, 4.74225E-01_JPRB, 6.71180E-01_JPRB, 9.49936E-01_JPRB/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      FORREFO(1,:) = (/ &
     &7.5352E-06_JPRB,2.9812E-05_JPRB,1.4497E-04_JPRB,4.4006E-04_JPRB,1.0492E-03_JPRB,1.9676E-03_JPRB, &
     &1.9989E-03_JPRB,1.9099E-03_JPRB,2.2121E-03_JPRB,2.4491E-03_JPRB,2.9573E-03_JPRB,2.6344E-03_JPRB, &
     &3.0629E-03_JPRB,3.3547E-03_JPRB,5.0643E-03_JPRB,5.0642E-03_JPRB/)
      FORREFO(2,:) = (/ &
     &6.6070E-06_JPRB,4.8618E-05_JPRB,3.1112E-04_JPRB,8.4235E-04_JPRB,1.4179E-03_JPRB,1.4315E-03_JPRB, &
     &1.4685E-03_JPRB,1.6554E-03_JPRB,2.1171E-03_JPRB,2.3545E-03_JPRB,2.5165E-03_JPRB,2.7680E-03_JPRB, &
     &2.6985E-03_JPRB,3.5345E-03_JPRB,4.2924E-03_JPRB,5.0712E-03_JPRB/)
      FORREFO(3,:) = (/ &
     &6.5962E-06_JPRB,7.2595E-04_JPRB,1.3429E-03_JPRB,1.1675E-03_JPRB,9.8384E-04_JPRB,8.8787E-04_JPRB, &
     &8.7557E-04_JPRB,8.0589E-04_JPRB,7.7024E-04_JPRB,8.7518E-04_JPRB,9.5213E-04_JPRB,9.0849E-04_JPRB, &
     &1.2596E-03_JPRB,2.5106E-03_JPRB,3.9471E-03_JPRB,5.0742E-03_JPRB/)
      FORREFO(4,:) = (/ &
     &3.6217E-04_JPRB,1.0709E-03_JPRB,1.0628E-03_JPRB,8.5640E-04_JPRB,8.9332E-04_JPRB,8.3372E-04_JPRB, &
     &7.8539E-04_JPRB,8.2828E-04_JPRB,8.3329E-04_JPRB,8.5118E-04_JPRB,8.2878E-04_JPRB,6.8570E-04_JPRB, &
     &6.3815E-04_JPRB,8.0648E-04_JPRB,2.3236E-03_JPRB,4.0321E-03_JPRB/)


!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

     SELFREFO(:, 1) = (/ &
     & 2.83453E-02_JPRB, 2.51439E-02_JPRB, 2.23040E-02_JPRB, 1.97849E-02_JPRB, 1.75503E-02_JPRB, &
     & 1.55681E-02_JPRB, 1.38097E-02_JPRB, 1.22500E-02_JPRB, 1.08664E-02_JPRB, 9.63912E-03_JPRB/)
      SELFREFO(:, 2) = (/ &
     & 3.05185E-02_JPRB, 2.72374E-02_JPRB, 2.43090E-02_JPRB, 2.16955E-02_JPRB, 1.93629E-02_JPRB, &
     & 1.72811E-02_JPRB, 1.54232E-02_JPRB, 1.37650E-02_JPRB, 1.22851E-02_JPRB, 1.09643E-02_JPRB/)
      SELFREFO(:, 3) = (/ &
     & 4.23833E-02_JPRB, 3.76250E-02_JPRB, 3.34010E-02_JPRB, 2.96512E-02_JPRB, 2.63223E-02_JPRB, &
     & 2.33672E-02_JPRB, 2.07439E-02_JPRB, 1.84150E-02_JPRB, 1.63476E-02_JPRB, 1.45123E-02_JPRB/)
      SELFREFO(:, 4) = (/ &
     & 5.76481E-02_JPRB, 5.13686E-02_JPRB, 4.57730E-02_JPRB, 4.07870E-02_JPRB, 3.63441E-02_JPRB, &
     & 3.23851E-02_JPRB, 2.88574E-02_JPRB, 2.57140E-02_JPRB, 2.29130E-02_JPRB, 2.04171E-02_JPRB/)
      SELFREFO(:, 5) = (/ &
     & 6.92255E-02_JPRB, 6.33521E-02_JPRB, 5.79770E-02_JPRB, 5.30580E-02_JPRB, 4.85563E-02_JPRB, &
     & 4.44365E-02_JPRB, 4.06663E-02_JPRB, 3.72160E-02_JPRB, 3.40584E-02_JPRB, 3.11687E-02_JPRB/)
      SELFREFO(:, 6) = (/ &
     & 6.07694E-02_JPRB, 5.94182E-02_JPRB, 5.80970E-02_JPRB, 5.68052E-02_JPRB, 5.55422E-02_JPRB, &
     & 5.43072E-02_JPRB, 5.30997E-02_JPRB, 5.19190E-02_JPRB, 5.07646E-02_JPRB, 4.96358E-02_JPRB/)
      SELFREFO(:, 7) = (/ &
     & 6.23749E-02_JPRB, 6.07744E-02_JPRB, 5.92150E-02_JPRB, 5.76956E-02_JPRB, 5.62152E-02_JPRB, &
     & 5.47728E-02_JPRB, 5.33674E-02_JPRB, 5.19980E-02_JPRB, 5.06638E-02_JPRB, 4.93638E-02_JPRB/)
      SELFREFO(:, 8) = (/ &
     & 6.90744E-02_JPRB, 6.61811E-02_JPRB, 6.34090E-02_JPRB, 6.07530E-02_JPRB, 5.82083E-02_JPRB, &
     & 5.57702E-02_JPRB, 5.34342E-02_JPRB, 5.11960E-02_JPRB, 4.90516E-02_JPRB, 4.69970E-02_JPRB/)
      SELFREFO(:, 9) = (/ &
     & 8.08992E-02_JPRB, 7.68876E-02_JPRB, 7.30750E-02_JPRB, 6.94514E-02_JPRB, 6.60075E-02_JPRB, &
     & 6.27344E-02_JPRB, 5.96236E-02_JPRB, 5.66670E-02_JPRB, 5.38570E-02_JPRB, 5.11864E-02_JPRB/)
      SELFREFO(:,10) = (/ &
     & 8.70197E-02_JPRB, 8.27485E-02_JPRB, 7.86870E-02_JPRB, 7.48248E-02_JPRB, 7.11522E-02_JPRB, &
     & 6.76599E-02_JPRB, 6.43389E-02_JPRB, 6.11810E-02_JPRB, 5.81781E-02_JPRB, 5.53225E-02_JPRB/)
      SELFREFO(:,11) = (/ &
     & 8.84776E-02_JPRB, 8.54262E-02_JPRB, 8.24800E-02_JPRB, 7.96354E-02_JPRB, 7.68890E-02_JPRB, &
     & 7.42373E-02_JPRB, 7.16770E-02_JPRB, 6.92050E-02_JPRB, 6.68183E-02_JPRB, 6.45139E-02_JPRB/)
      SELFREFO(:,12) = (/ &
     & 9.82552E-02_JPRB, 9.25696E-02_JPRB, 8.72130E-02_JPRB, 8.21664E-02_JPRB, 7.74118E-02_JPRB, &
     & 7.29323E-02_JPRB, 6.87121E-02_JPRB, 6.47360E-02_JPRB, 6.09900E-02_JPRB, 5.74608E-02_JPRB/)
      SELFREFO(:,13) = (/ &
     & 9.32447E-02_JPRB, 8.96818E-02_JPRB, 8.62550E-02_JPRB, 8.29592E-02_JPRB, 7.97893E-02_JPRB, &
     & 7.67405E-02_JPRB, 7.38082E-02_JPRB, 7.09880E-02_JPRB, 6.82755E-02_JPRB, 6.56667E-02_JPRB/)
      SELFREFO(:,14) = (/ &
     & 1.15363E-01_JPRB, 1.08593E-01_JPRB, 1.02220E-01_JPRB, 9.62210E-02_JPRB, 9.05741E-02_JPRB, &
     & 8.52585E-02_JPRB, 8.02549E-02_JPRB, 7.55450E-02_JPRB, 7.11115E-02_JPRB, 6.69382E-02_JPRB/)
      SELFREFO(:,15) = (/ &
     & 1.23179E-01_JPRB, 1.19247E-01_JPRB, 1.15440E-01_JPRB, 1.11755E-01_JPRB, 1.08187E-01_JPRB, &
     & 1.04734E-01_JPRB, 1.01391E-01_JPRB, 9.81540E-02_JPRB, 9.50207E-02_JPRB, 9.19875E-02_JPRB/)
      SELFREFO(:,16) = (/ &
     & 1.44104E-01_JPRB, 1.36412E-01_JPRB, 1.29130E-01_JPRB, 1.22237E-01_JPRB, 1.15712E-01_JPRB, &
     & 1.09535E-01_JPRB, 1.03688E-01_JPRB, 9.81530E-02_JPRB, 9.29135E-02_JPRB, 8.79537E-02_JPRB/)

IF (LHOOK) CALL DR_HOOK('RRTM_KGB9',1,ZHOOK_HANDLE)
RETURN

1001 CONTINUE
CALL ABOR1("RRTM_KGB9:ERROR READING FILE RADRRTM")

END SUBROUTINE RRTM_KGB9
