SUBROUTINE SRTM_CMBGB25

!     BAND 25:  16000-22650 cm-1 (low - H2O; high - nothing)
!-----------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPIM , JPRB
USE YOMHOOK   ,ONLY : LHOOK, DR_HOOK

USE YOESRTWN , ONLY : NGC, NGS, NGN, RWGT
USE YOESRTA25, ONLY : KA, SFLUXREF, ABSO3A, ABSO3B, RAYL, &
                    & KAC, SFLUXREFC, ABSO3AC, ABSO3BC, RAYLC

IMPLICIT NONE

! Local variables
INTEGER(KIND=JPIM) :: JT, JP, IGC, IPR, IPRSM
REAL(KIND=JPRB)    :: ZSUMK, ZSUMF1, ZSUMF2, ZSUMF3, ZSUMF4

REAL(KIND=JPRB) :: ZHOOK_HANDLE
!     ------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('SRTM_CMBGB25',0,ZHOOK_HANDLE)

DO JT = 1,5
  DO JP = 1,13
    IPRSM = 0
    DO IGC = 1,NGC(10)
      ZSUMK = 0.
      DO IPR = 1, NGN(NGS(9)+IGC)
        IPRSM = IPRSM + 1
        ZSUMK = ZSUMK + KA(JT,JP,IPRSM)*RWGT(IPRSM+144)
      ENDDO
      KAC(JT,JP,IGC) = ZSUMK
    ENDDO
  ENDDO
ENDDO

IPRSM = 0
DO IGC = 1,NGC(10)
  ZSUMF1 = 0.
  ZSUMF2 = 0.
  ZSUMF3 = 0.
  ZSUMF4 = 0.
  DO IPR = 1, NGN(NGS(9)+IGC)
    IPRSM = IPRSM + 1
    ZSUMF1 = ZSUMF1 + SFLUXREF(IPRSM)
    ZSUMF2 = ZSUMF2 + ABSO3A(IPRSM)*RWGT(IPRSM+144)
    ZSUMF3 = ZSUMF3 + ABSO3B(IPRSM)*RWGT(IPRSM+144)
    ZSUMF4 = ZSUMF4 + RAYL(IPRSM)*RWGT(IPRSM+144)
  ENDDO
  SFLUXREFC(IGC) = ZSUMF1
  ABSO3AC(IGC) = ZSUMF2
  ABSO3BC(IGC) = ZSUMF3
  RAYLC(IGC) = ZSUMF4
ENDDO

!     -----------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('SRTM_CMBGB25',1,ZHOOK_HANDLE)
END SUBROUTINE SRTM_CMBGB25

