MODULE YOESRTCOP

USE PARKIND1  ,ONLY : JPRB

IMPLICIT NONE

SAVE

!     ------------------------------------------------------------------
!*    ** *YOESRTCOP* - CLOUD OPTICAL PROPERTIES FOR SRTM 
!     ------------------------------------------------------------------

!-- CLOUD OPTICAL PROPERTIES

!-- coefficients and parameters related to SRTM_SW 14 sp.int.

REAL(KIND=JPRB) :: RSYFWA(14)
REAL(KIND=JPRB) :: RSYFWB(14)
REAL(KIND=JPRB) :: RSYFWC(14)
REAL(KIND=JPRB) :: RSYFWD(14)
REAL(KIND=JPRB) :: RSYFWE(14)
REAL(KIND=JPRB) :: RSYFWF(14)

REAL(KIND=JPRB) :: RSECIA(14)
REAL(KIND=JPRB) :: RSECIB(14)
REAL(KIND=JPRB) :: RSECIC(14)
REAL(KIND=JPRB) :: RSECID(14)
REAL(KIND=JPRB) :: RSECIE(14)
REAL(KIND=JPRB) :: RSECIF(14)

REAL(KIND=JPRB) :: RSASWA(14)
REAL(KIND=JPRB) :: RSASWB(14)
REAL(KIND=JPRB) :: RSASWC(14)
REAL(KIND=JPRB) :: RSASWD(14)
REAL(KIND=JPRB) :: RSASWE(14)
REAL(KIND=JPRB) :: RSASWF(14)

REAL(KIND=JPRB) :: RSFUA0(14)
REAL(KIND=JPRB) :: RSFUA1(14)
REAL(KIND=JPRB) :: RSFUB0(14)
REAL(KIND=JPRB) :: RSFUB1(14)
REAL(KIND=JPRB) :: RSFUB2(14)
REAL(KIND=JPRB) :: RSFUB3(14)
REAL(KIND=JPRB) :: RSFUC0(14)
REAL(KIND=JPRB) :: RSFUC1(14)
REAL(KIND=JPRB) :: RSFUC2(14)
REAL(KIND=JPRB) :: RSFUC3(14)

REAL(KIND=JPRB) :: RSFLA0(14)
REAL(KIND=JPRB) :: RSFLA1(14)
REAL(KIND=JPRB) :: RSFLB0(14)
REAL(KIND=JPRB) :: RSFLB1(14)
REAL(KIND=JPRB) :: RSFLB2(14)
REAL(KIND=JPRB) :: RSFLB3(14)
REAL(KIND=JPRB) :: RSFLC0(14)
REAL(KIND=JPRB) :: RSFLC1(14)
REAL(KIND=JPRB) :: RSFLC2(14)
REAL(KIND=JPRB) :: RSFLC3(14)
REAL(KIND=JPRB) :: RSFLD0(14)
REAL(KIND=JPRB) :: RSFLD1(14)
REAL(KIND=JPRB) :: RSFLD2(14)
REAL(KIND=JPRB) :: RSFLD3(14)

REAL(KIND=JPRB) :: RSSSIE(14)
REAL(KIND=JPRB) :: RSSSIF(14)
REAL(KIND=JPRB) :: RSSSIH(14)
REAL(KIND=JPRB) :: RSSSIK(14)
REAL(KIND=JPRB) :: RSSSIA(14)
REAL(KIND=JPRB) :: RSSSIG(14)

!        * E.C.M.W.F. PHYSICS PACKAGE *

!     J.-J. MORCRETTE       E.C.M.W.F.      03-03-07

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : ---------------------------------------------------
!*    FOUQUART (1987) WATER CLOUD OPTICAL PROPERTIES

! RSYFWA :  REAL   : C1 IN OPTICAL THICKNESS FORMULA
! RSYFWB :  REAL   : C2 IN OPTICAL THICKNESS FORMULA
! RSYFWC :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RSYFWD :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RSYFWE :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RSYFWF :  REAL   : ASSYMETRY FACTOR

!*    SLINGO (1989) WATER CLOUD OPTICAL PROPERTIES

! RSASWA :  REAL   : C1 IN OPTICAL THICKNESS FORMULA
! RSASWB :  REAL   : C2 IN OPTICAL THICKNESS FORMULA
! RSASWC :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RSASWD :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RSASWE :  REAL   : SINGLE SCATTERING ALBEDO PARAMETER
! RSASWF :  REAL   : ASSYMETRY FACTOR

!*    ICE CLOUD OPTICAL PROPERTIES DERIVED FROM EBERT-CURRY (1992)

! RSECIA :  REAL   : C1 IN OPTICAL THICKNESS FORMULA
! RSECIB :  REAL   : C2 IN OPTICAL THICKNESS FORMULA
! RSECIC :  REAL   : 1-C3  IN SINGLE SCATTERING ALBEDO FORMULA
! RSECID :  REAL   : C4 IN SINGLE SCATTERING ALBEDO FORMULA
! RSECIE :  REAL   : C5 IN ASSYMETRY FACTOR FORMULA
! RSECIF :  REAL   : C6 IN ASSYMETRY FACTOR FORMULA
! RSECIG :  REAL   : C7 IN MASS ABSORPTION COEFFICIENT FORMULA
! RSECIH :  REAL   : C8 IN MASS ABSORPTION COEFFICIENT FORMULA

!*    ICE CLOUD OPTICAL PROPERTIES DERIVED FROM SUN-SHINE (1995)

! RSSSIE :  REAL   : E IN SINGLE SCATTERING ALBEDO FORMULA
! RSSSIF :  REAL   : F IN SINGLE SCATTERING ALBEDO FORMULA
! RSSSIH :  REAL   : H IN ASSYMETRY FACTOR FORMULA
! RSSSIK :  REAL   : K IN ASSYMETRY FACTOR FORMULA
! RSSSIA :  REAL   : ALPHA IN SSA CORRECTION FACTOR FORMULA
! RSSSIG :  REAL   : GAMMA IN ASSYMETRY CORRECTION FACTOR FORMULA

!*    ICE CLOUD OPTICAL PROPERTIES DERIVED FROM FU-LIOU (1993)

! RSFLA  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW EXTINCTION COEFF.
! RSFLB  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW SINGLE SCATT.ALB.
! RSFLC  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW ASSYMETRY FACTOR
! RSFLD  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW ASSYMETRY FACTOR

!*    ICE CLOUD OPTICAL PROPERTIES DERIVED FROM FU (1996) & FU ET AL. (1998)

! RSFUA  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW EXTINCTION COEFF.
! RSFUB  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW SINGLE SCATT.ALB.
! RSFUC  :  REAL   : COEFFICIENTS IN EXPRESSION FOR SW ASSYMETRY FACTOR

!     -----------------------------------------------------------------
!$OMP THREADPRIVATE(rsaswa,rsaswb,rsaswc,rsaswd,rsaswe,rsaswf,rsecia,rsecib)
!$OMP THREADPRIVATE(rsecic,rsecid,rsecie,rsecif,rsfla0,rsfla1,rsflb0,rsflb1)
!$OMP THREADPRIVATE(rsflb2,rsflb3,rsflc0,rsflc1,rsflc2,rsflc3,rsfld0,rsfld1)
!$OMP THREADPRIVATE(rsfld2,rsfld3,rsfua0,rsfua1,rsfub0,rsfub1,rsfub2,rsfub3)
!$OMP THREADPRIVATE(rsfuc0,rsfuc1,rsfuc2,rsfuc3,rsssia,rsssie,rsssif,rsssig)
!$OMP THREADPRIVATE(rsssih,rsssik,rsyfwa,rsyfwb,rsyfwc,rsyfwd,rsyfwe,rsyfwf)
END MODULE YOESRTCOP

