MODULE lmdz_surf_wind_ini
IMPLICIT NONE 
save

  ! ============================================================================
  ! Declaration de variables
  ! -------------------------------------------------------------------------

   integer, protected :: lunout
   integer, protected :: iflag_surf_wind=0
   real, protected :: surf_wind_ktwake=0.5
   real, protected :: surf_wind_kttherm=2.
   real, protected :: surf_wind_kztherm=1.

   !$OMP THREADPRIVATE(lunout, iflag_surf_wind, surf_wind_ktwake, surf_wind_kttherm, surf_wind_kztherm)

!!   !$OMP THREADPRIVATE(lunout,iflag_surf_wind)
!!   !$OMP THREADPRIVATE(lunout,surf_wind_ktwake)
!!   !$OMP THREADPRIVATE(lunout,surf_wind_kttherm)
!!   !$OMP THREADPRIVATE(lunout,surf_wind_kztherm)

CONTAINS

  ! =========================================================================
  SUBROUTINE surf_wind_ini(klon,lunout_i)
  ! =========================================================================

  ! **************************************************************
  ! *
  ! WAKE                                                        *
  ! retour a un Pupper fixe                                *
  ! *
  ! written by   :  GRANDPEIX Jean-Yves   09/03/2000            *
  ! modified by :   ROEHRIG Romain        01/29/2007            *
  ! **************************************************************

  ! -------------------------------------------------------------------------
  ! Initialisations
  ! -------------------------------------------------------------------------


  USE ioipsl_getin_p_mod, ONLY : getin_p
  integer, intent(in) :: klon,lunout_i

  lunout=lunout_i
  CALL getin_p('iflag_surf_wind',iflag_surf_wind)
  CALL getin_p('surf_wind_ktwake',surf_wind_ktwake)
  CALL getin_p('surf_wind_kttherm',surf_wind_kttherm)
  CALL getin_p('surf_wind_kztherm',surf_wind_kztherm)

  write(lunout,*) 'Initialisation wind10m'
  write(lunout,*) 'lmdz_surf_wind_ini, iflag_surf_wind=',iflag_surf_wind
  write(lunout,*) 'lmdz_surf_wind_ini, surf_wind_ktwake=',surf_wind_ktwake
  write(lunout,*) 'lmdz_surf_wind_ini, surf_wind_kttherm=',surf_wind_kttherm
  write(lunout,*) 'lmdz_surf_wind_ini, surf_wind_kztherm=',surf_wind_kztherm

 RETURN

END SUBROUTINE surf_wind_ini



END MODULE lmdz_surf_wind_ini
