MODULE lmdz_cloud_optics_prop_ini
  IMPLICIT NONE

  SAVE

  INTEGER, PROTECTED :: prt_level, lunout
  INTEGER, PROTECTED :: flag_aerosol
  INTEGER, PROTECTED :: iflag_t_glace=0
  INTEGER, PROTECTED :: iflag_rei
  INTEGER, PROTECTED :: novlp, iflag_ice_thermo
  LOGICAL, PROTECTED :: ok_cdnc
  LOGICAL, PROTECTED :: ok_icefra_lscp, ok_new_lscp
  REAL, PROTECTED :: bl95_b0, bl95_b1 ! Parameter in B&L 95-Formula
  REAL, ALLOCATABLE :: latitude_deg(:)
  !$OMP THREADPRIVATE(latitude_deg)
  REAL, PROTECTED :: cdnc_max=-1.
  REAL, PROTECTED :: cdnc_max_m3=-1.
  REAL, PROTECTED :: cdnc_min=-1.
  REAL, PROTECTED :: cdnc_min_m3=-1.
  REAL, PROTECTED :: rpi, rg, rd
  REAL, PROTECTED :: rad_chau1, rad_chau2, rad_froid
  REAL, PROTECTED :: rei_max, rei_min
  REAL, PROTECTED :: rei_coef, rei_min_temp
  REAL, PROTECTED :: zepsec
  REAL, PARAMETER :: thres_tau=0.3, thres_neb=0.001
  REAL, PARAMETER :: prmhc=440.*100. ! Pressure between medium and high level cloud in Pa
  REAL, PARAMETER :: prlmc=680.*100. ! Pressure between low and medium level cloud in Pa
  REAL, PARAMETER :: coef_froi=0.09, coef_chau =0.13
  REAL, PARAMETER :: seuil_neb=0.001
! if iflag_t_glace=0, old values are used for liquid/ice partitionning:
  REAL, PARAMETER :: t_glace_min_old = 258.
  REAL, PARAMETER :: t_glace_max_old = 273.13
  REAL, PARAMETER :: k_ice0=0.005 ! units=m2/g
  REAL, PARAMETER :: df=1.66 ! diffusivity factor
!$OMP THREADPRIVATE(prt_level, lunout, flag_aerosol, iflag_t_glace)
!$OMP THREADPRIVATE(iflag_rei, novlp, iflag_ice_thermo)  
!$OMP THREADPRIVATE(ok_cdnc, ok_icefra_lscp, ok_new_lscp)
!$OMP THREADPRIVATE(bl95_b0, bl95_b1, cdnc_max, cdnc_max_m3)
!$OMP THREADPRIVATE(cdnc_min, cdnc_min_m3, rpi, rg, rd)
!$OMP THREADPRIVATE(rad_chau1, rad_chau2, rad_froid, rei_max, rei_min)
!$OMP THREADPRIVATE(rei_coef, rei_min_temp)
!$OMP THREADPRIVATE(zepsec) 

  
CONTAINS

  SUBROUTINE cloud_optics_prop_ini(klon, prt_level_in, lunout_in, flag_aerosol_in, &
       & ok_cdnc_in, bl95_b0_in, &
       & bl95_b1_in, latitude_deg_in, rpi_in, rg_in, rd_in, zepsec_in, novlp_in, &
       & iflag_ice_thermo_in, ok_new_lscp_in)

    USE ioipsl_getin_p_mod, ONLY : getin_p

    IMPLICIT NONE
    INTEGER, INTENT(IN) :: klon
    INTEGER, INTENT(IN) :: prt_level_in, lunout_in
    INTEGER, INTENT(IN) :: flag_aerosol_in
    INTEGER, INTENT(IN) :: novlp_in, iflag_ice_thermo_in
    LOGICAL, INTENT(IN) :: ok_cdnc_in, ok_new_lscp_in
    REAL, INTENT(IN) :: bl95_b0_in, bl95_b1_in
    REAL, INTENT(IN) :: latitude_deg_in(klon)
    REAL, INTENT(IN) :: rpi_in, rg_in, rd_in
    REAL, INTENT(IN) :: zepsec_in

    ALLOCATE(latitude_deg(klon))

    prt_level = prt_level_in
    lunout = lunout_in
    flag_aerosol = flag_aerosol_in
    ok_cdnc = ok_cdnc_in
    bl95_b0 = bl95_b0_in
    bl95_b1 = bl95_b1_in
    latitude_deg(:) = latitude_deg_in(:)
    rpi = rpi_in
    rg = rg_in
    rd = rd_in
    zepsec = zepsec_in
    novlp = novlp_in
    iflag_ice_thermo = iflag_ice_thermo_in
    ok_new_lscp = ok_new_lscp_in
    
    call getin_p('cdnc_min',cdnc_min)
    cdnc_min_m3=cdnc_min*1.E6
    IF (cdnc_min_m3<0.) cdnc_min_m3=20.E6 ! astuce pour retrocompatibilite
    write(lunout,*)'cdnc_min=', cdnc_min_m3/1.E6
    call getin_p('cdnc_max',cdnc_max)
    cdnc_max_m3=cdnc_max*1.E6
    IF (cdnc_max_m3<0.) cdnc_max_m3=1000.E6 ! astuce pour retrocompatibilite
    write(lunout,*)'cdnc_max=', cdnc_max_m3/1.E6
    CALL getin_p('iflag_t_glace',iflag_t_glace)      
    write(lunout,*)'iflag_t_glace= ',iflag_t_glace
    CALL getin_p('rad_chau1',rad_chau1)
    CALL getin_p('rad_chau2',rad_chau2)
    CALL getin_p('rad_froid ',rad_froid)
    CALL getin_p('ok_icefra_lscp', ok_icefra_lscp)
    iflag_rei = 0
    CALL getin_p('iflag_rei',iflag_rei)
    rei_min = 3.5
    CALL getin_p('rei_min',rei_min)
    rei_max = 61.29
    CALL getin_p('rei_max',rei_max)
    rei_coef = 2.4
    CALL getin_p('rei_coef',rei_coef)
    rei_min_temp = 175.
    CALL getin_p('rei_min_temp',rei_min_temp)

   
  END SUBROUTINE cloud_optics_prop_ini

END MODULE lmdz_cloud_optics_prop_ini
