MODULE compar1d_mod_h
  IMPLICIT NONE; PRIVATE
  PUBLIC  nat_surf, tsurf, beta_surf, rugos, rugosh, &
          xqsol, qsurf, psurf, zsurf, albedo, time, time_ini, xlat, xlon, airefi, &
          wtsurf, wqsurf, restart_runoff, xagesno, qsolinp, zpicinp, &
          forcing_type, tend_u, tend_v, tend_w, tend_t, tend_q, tend_rayo, &
          nudge_u, nudge_v, nudge_w, nudge_t, nudge_q, &
          iflag_nudge, snowmass, &
          restart, ok_old_disvert, &
          nb_ter_srf, alpha_soil_ter_srf, period_ter_srf, frac_ter_srf, &
          rugos_ter_srf, ratio_z0m_z0h_ter_srf, albedo_ter_srf, beta_ter_srf, &
          inertie_ter_srf, hcond_ter_srf, tsurf_ter_srf, tsoil_ter_srf, &
          tsoil_depths, nb_tsoil_depths, &
          tadv, tadvv, tadvh, qadv, qadvv, qadvh, thadv, thadvv, thadvh, &
          trad, forc_omega, forc_u, forc_v, forc_w, forc_geo, forc_ustar, &
          nudging_u, nudging_v, nudging_t, nudging_qv, nudging_w, &
          p_nudging_u, p_nudging_v, p_nudging_t, p_nudging_qv, p_nudging_w

  INTEGER :: forcing_type
  INTEGER :: tend_u, tend_v, tend_w, tend_t, tend_q, tend_rayo
  REAL :: nudge_u, nudge_v, nudge_w, nudge_t, nudge_q
  INTEGER :: iflag_nudge
  REAL :: nat_surf
  REAL :: tsurf
  REAL :: beta_surf
  REAL :: rugos
  REAL :: rugosh
  REAL :: xqsol(1:2)
  REAL :: qsurf
  REAL :: psurf
  REAL :: zsurf
  REAL :: albedo
  REAL :: snowmass

  REAL :: time
  REAL :: time_ini
  REAL :: xlat
  REAL :: xlon
  REAL :: airefi
  REAL :: wtsurf
  REAL :: wqsurf
  REAL :: restart_runoff
  REAL :: xagesno
  REAL :: qsolinp
  REAL :: zpicinp

  LOGICAL :: restart
  LOGICAL :: ok_old_disvert

  INTEGER :: nb_ter_srf
  REAL :: alpha_soil_ter_srf
  REAL :: period_ter_srf
  REAL, DIMENSION(5) :: frac_ter_srf
  REAL, DIMENSION(5) :: rugos_ter_srf
  REAL, DIMENSION(5) :: ratio_z0m_z0h_ter_srf
  REAL, DIMENSION(5) :: albedo_ter_srf
  REAL, DIMENSION(5) :: beta_ter_srf
  REAL, DIMENSION(5) :: inertie_ter_srf
  REAL, DIMENSION(5) :: hcond_ter_srf
  REAL, DIMENSION(5) :: tsurf_ter_srf
  REAL, DIMENSION(5*5) :: tsoil_ter_srf
  REAL, DIMENSION(5*5) :: tsoil_depths
  INTEGER :: nb_tsoil_depths

  ! Pour les forcages communs: ces entiers valent 0 ou 1
  ! tadv= advection tempe, tadvv= adv tempe verticale, tadvh= adv tempe horizontale
  ! idem pour l advection en theta
  ! qadv= advection q, qadvv= adv q verticale, qadvh= adv q horizontale
  ! trad= 0 (rayonnement actif) ou 1 (prescrit par tend_rad) ou adv (prescir et contenu dans les tadv)
  ! forcages en omega, w, vent geostrophique ou ustar
  ! Parametres de nudging en u,v,t,q valent 0 ou 1 ou le temps de nudging

  INTEGER :: tadv, tadvv, tadvh, qadv, qadvv, qadvh, thadv, thadvv, thadvh, trad
  INTEGER :: forc_omega, forc_u, forc_v, forc_w, forc_geo, forc_ustar
  REAL :: nudging_u, nudging_v, nudging_w, nudging_t, nudging_qv
  REAL :: p_nudging_u, p_nudging_v, p_nudging_w, p_nudging_t, p_nudging_qv


  !$OMP THREADPRIVATE(nat_surf, tsurf, beta_surf, rugos, rugosh, &
  !$OMP      xqsol, qsurf, psurf, zsurf, albedo, time, time_ini, xlat, xlon, airefi, &
  !$OMP      wtsurf, wqsurf, restart_runoff, xagesno, qsolinp, zpicinp, &
  !$OMP      forcing_type, tend_u, tend_v, tend_w, tend_t, tend_q, tend_rayo, &
  !$OMP      nudge_u, nudge_v, nudge_w, nudge_t, nudge_q, &
  !$OMP      iflag_nudge, snowmass, &
  !$OMP      restart, ok_old_disvert, &
  !$OMP      nb_ter_srf, frac_ter_srf, rugos_ter_srf, albedo_ter_srf,         &
  !$OMP      beta_ter_srf, inertie_ter_srf, alpha_soil_ter_srf,               &
  !$OMP      period_ter_srf, hcond_ter_srf, ratio_z0m_z0h_ter_srf,            &
  !$OMP      tsurf_ter_srf, tsoil_ter_srf, tsoil_depths, nb_tsoil_depths,     &
  !$OMP      tadv, tadvv, tadvh, qadv, qadvv, qadvh, thadv, thadvv, thadvh, &
  !$OMP      trad, forc_omega, forc_u, forc_v, forc_w, forc_geo, forc_ustar, &
  !$OMP      nudging_u, nudging_v, nudging_t, nudging_qv, nudging_w, &
  !$OMP      p_nudging_u, p_nudging_v, p_nudging_t, p_nudging_qv, p_nudging_w)

END MODULE compar1d_mod_h
