!******************************************************************************
SUBROUTINE RRTM_TAUMOL14 (KLEV,P_TAU,&
 & P_TAUAERL,P_FAC00,P_FAC01,P_FAC10,P_FAC11,K_JP,K_JT,K_JT1,&
 & P_COLCO2,K_LAYTROP,P_SELFFAC,P_SELFFRAC,K_INDSELF,PFRAC)  

!     BAND 14:  2250-2380 cm-1 (low - CO2; high - CO2)

! Modifications
!        M.Hamrud      01-Oct-2003 CY28 Cleaning

!     D Salmond 1999-07-14 speed-up

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE PARRRTM  , ONLY : JPLAY  ,JPBAND ,JPGPT  ,NGS13
USE YOERRTWN , ONLY :      NSPA   ,NSPB
USE YOERRTA14, ONLY : ABSA   ,ABSB   ,FRACREFA, FRACREFB,SELFREF

IMPLICIT NONE

!  Output
INTEGER(KIND=JPIM),INTENT(IN)    :: KLEV 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: P_TAU(JPGPT,JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_TAUAERL(JPLAY,JPBAND) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC00(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC01(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC10(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC11(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JP(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT1(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLCO2(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_LAYTROP 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFAC(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFRAC(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_INDSELF(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PFRAC(JPGPT,JPLAY) 
!- from AER
!- from INTFAC      
!- from INTIND
!- from PROFDATA             
!- from SELF             
!- from SP             
INTEGER(KIND=JPIM) :: IG, IND0, IND1, INDS, I_LAY
REAL(KIND=JPRB) :: ZHOOK_HANDLE

!  Input
!#include "yoeratm.h"

!      REAL TAUAER(JPLAY)
!      EQUIVALENCE (TAUAERL(1,14),TAUAER)

!     Compute the optical depth by interpolating in ln(pressure) and 
!     temperature.  Below LAYTROP, the water vapor self-continuum 
!     is interpolated (in temperature) separately.  

IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL14',0,ZHOOK_HANDLE)
DO I_LAY = 1, K_LAYTROP
  IND0 = ((K_JP(I_LAY)-1)*5+(K_JT(I_LAY)-1))*NSPA(14) + 1
  IND1 = (K_JP(I_LAY)*5+(K_JT1(I_LAY)-1))*NSPA(14) + 1
  INDS = K_INDSELF(I_LAY)
!-- DS_990714  
!         DO IG = 1, NG14
  IG=1
  P_TAU (NGS13+IG,I_LAY) = P_COLCO2(I_LAY) *&
   & (P_FAC00(I_LAY) * ABSA(IND0  ,IG) +&
   & P_FAC10(I_LAY) * ABSA(IND0+1,IG) +&
   & P_FAC01(I_LAY) * ABSA(IND1  ,IG) +&
   & P_FAC11(I_LAY) * ABSA(IND1+1,IG) +&
   & P_SELFFAC(I_LAY) * (SELFREF(INDS,IG) + &
   & P_SELFFRAC(I_LAY) *&
   & (SELFREF(INDS+1,IG) - SELFREF(INDS,IG))))&
   & + P_TAUAERL(I_LAY,14)  
  PFRAC(NGS13+IG,I_LAY) = FRACREFA(IG)
  IG=2
  P_TAU (NGS13+IG,I_LAY) = P_COLCO2(I_LAY) *&
   & (P_FAC00(I_LAY) * ABSA(IND0  ,IG) +&
   & P_FAC10(I_LAY) * ABSA(IND0+1,IG) +&
   & P_FAC01(I_LAY) * ABSA(IND1  ,IG) +&
   & P_FAC11(I_LAY) * ABSA(IND1+1,IG) +&
   & P_SELFFAC(I_LAY) * (SELFREF(INDS,IG) +&
   & P_SELFFRAC(I_LAY) *&
   & (SELFREF(INDS+1,IG) - SELFREF(INDS,IG))))&
   & + P_TAUAERL(I_LAY,14)  
  PFRAC(NGS13+IG,I_LAY) = FRACREFA(IG)
!         END DO
!-- DS_990714  
ENDDO

DO I_LAY = K_LAYTROP+1, KLEV
  IND0 = ((K_JP(I_LAY)-13)*5+(K_JT(I_LAY)-1))*NSPB(14) + 1
  IND1 = ((K_JP(I_LAY)-12)*5+(K_JT1(I_LAY)-1))*NSPB(14) + 1
!-- DS_990714  
!         DO IG = 1, NG14
  IG=1
  P_TAU (NGS13+IG,I_LAY) = P_COLCO2(I_LAY) *&
   & (P_FAC00(I_LAY) * ABSB(IND0  ,IG) +&
   & P_FAC10(I_LAY) * ABSB(IND0+1,IG) +&
   & P_FAC01(I_LAY) * ABSB(IND1  ,IG) +&
   & P_FAC11(I_LAY) * ABSB(IND1+1,IG)) &
   & + P_TAUAERL(I_LAY,14)  
  PFRAC(NGS13+IG,I_LAY) = FRACREFB(IG)
  IG=2
  P_TAU (NGS13+IG,I_LAY) = P_COLCO2(I_LAY) *&
   & (P_FAC00(I_LAY) * ABSB(IND0  ,IG) +&
   & P_FAC10(I_LAY) * ABSB(IND0+1,IG) +&
   & P_FAC01(I_LAY) * ABSB(IND1  ,IG) +&
   & P_FAC11(I_LAY) * ABSB(IND1+1,IG)) &
   & + P_TAUAERL(I_LAY,14)  
  PFRAC(NGS13+IG,I_LAY) = FRACREFB(IG)
!         END DO
!-- DS_990714  
ENDDO

IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL14',1,ZHOOK_HANDLE)
END SUBROUTINE RRTM_TAUMOL14
