!
! $Id: iniconst.f90 5285 2024-10-28 13:33:29Z abarral $
!
SUBROUTINE iniconst

  USE iniprint_mod_h
  USE control_mod
  use IOIPSL

  USE comconst_mod, ONLY: im, imp1, jm, jmp1, lllm, lllmm1, lllmp1, &
                          unsim, pi, r, kappa, cpp, dtvr, dtphys
  USE comvert_mod, ONLY: disvert_type, pressure_exner

  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h
IMPLICIT NONE
  !
  !      P. Le Van
  !
  !   Declarations:
  !   -------------
  !



  character(len=*),parameter :: modname="iniconst"
  character(len=80) :: abort_message
  !
  !
  !
  !-----------------------------------------------------------------------
  !   dimension des boucles:
  !   ----------------------

  im      = iim
  jm      = jjm
  lllm    = llm
  imp1    = iim 
  jmp1    = jjm + 1
  lllmm1  = llm - 1
  lllmp1  = llm + 1

  !-----------------------------------------------------------------------

  dtphys  = iphysiq * dtvr
  unsim   = 1./iim
  pi      = 2.*ASIN( 1. )

  !-----------------------------------------------------------------------
  !

  r       = cpp * kappa

  write(lunout,*) trim(modname),': R  CP  Kappa ',r,cpp,kappa
  !
  !-----------------------------------------------------------------------

  ! vertical discretization: default behavior depends on planet_type flag
  if (planet_type=="earth") then
     disvert_type=1
  else
     disvert_type=2
  endif
  ! but user can also specify using one or the other in run.def:
  call getin('disvert_type',disvert_type)
  write(lunout,*) trim(modname),': disvert_type=',disvert_type

  pressure_exner = disvert_type == 1 ! default value
  call getin('pressure_exner', pressure_exner)

  if (disvert_type==1) then
     ! standard case for Earth (automatic generation of levels)
     call disvert()
  else if (disvert_type==2) then
     ! standard case for planets (levels generated using z2sig.def file)
     call disvert_noterre
  else
     write(abort_message,*) "Wrong value for disvert_type: ", disvert_type
     call abort_gcm(modname,abort_message,0)
  endif

END SUBROUTINE iniconst
