!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif
!pgi$r opt=0 
SUBROUTINE RRTM_KGB11

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 11:  1480-1800 cm-1 (low - H2O; high - H2O)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOERRTO11, ONLY : KAO     ,KBO     ,SELFREFO    ,FRACREFAO ,FRACREFBO

!     ------------------------------------------------------------------

IMPLICIT NONE
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('RRTM_KGB11',0,ZHOOK_HANDLE)

CALL PART1
CALL PART2
CALL PART3
CALL PART4
CALL PART5
CALL PART6
CALL PART7

IF (LHOOK) CALL DR_HOOK('RRTM_KGB11',1,ZHOOK_HANDLE)

!     -----------------------------------------------------------------

CONTAINS


SUBROUTINE PART1

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB11:PART1',0,ZHOOK_HANDLE)


FRACREFAO( :) = (/&
 !     From P = 473 mb.
 & 0.14152819_JPRB,0.13811260_JPRB,0.14312185_JPRB,0.13705885_JPRB,&
 & 0.11944738_JPRB,0.10570189_JPRB,0.08866373_JPRB,0.06565409_JPRB,&
 & 0.04428961_JPRB,0.00481540_JPRB,0.00387058_JPRB,0.00329187_JPRB,&
 & 0.00238294_JPRB,0.00150971_JPRB,0.00049287_JPRB,0.00005980_JPRB/)  

FRACREFBO( :) = (/&
 !     From P = 1.17 mb.
 & 0.10874039_JPRB,0.15164889_JPRB,0.15149839_JPRB,0.14515044_JPRB,&
 & 0.12486220_JPRB,0.10725017_JPRB,0.08715712_JPRB,0.06463144_JPRB,&
 & 0.04332319_JPRB,0.00441193_JPRB,0.00393819_JPRB,0.00305960_JPRB,&
 & 0.00224221_JPRB,0.00145100_JPRB,0.00055586_JPRB,0.00007934_JPRB/)  

!     ------------------------------------------------------------------

!     The array KA contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the corresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
!     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
!     index, JP, runs from 1 to 13 and refers to the corresponding 
!     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
!     The third index, IG, goes from 1 to 16, and tells us which 
!     g-interval the absorption coefficients are for.

KAO( :, 1, 1) = (/&
 & 8.3522E-02_JPRB,8.1897E-02_JPRB,8.0229E-02_JPRB,7.8579E-02_JPRB,7.6970E-02_JPRB/)  
KAO( :, 2, 1) = (/&
 & 6.8945E-02_JPRB,6.7573E-02_JPRB,6.6206E-02_JPRB,6.4835E-02_JPRB,6.3486E-02_JPRB/)  
KAO( :, 3, 1) = (/&
 & 5.7102E-02_JPRB,5.5943E-02_JPRB,5.4810E-02_JPRB,5.3668E-02_JPRB,5.2541E-02_JPRB/)  
KAO( :, 4, 1) = (/&
 & 4.7668E-02_JPRB,4.6657E-02_JPRB,4.5724E-02_JPRB,4.4753E-02_JPRB,4.3808E-02_JPRB/)  
KAO( :, 5, 1) = (/&
 & 4.0002E-02_JPRB,3.9124E-02_JPRB,3.8315E-02_JPRB,3.7502E-02_JPRB,3.6705E-02_JPRB/)  
KAO( :, 6, 1) = (/&
 & 3.3776E-02_JPRB,3.3000E-02_JPRB,3.2282E-02_JPRB,3.1596E-02_JPRB,3.0909E-02_JPRB/)  
KAO( :, 7, 1) = (/&
 & 2.8835E-02_JPRB,2.8128E-02_JPRB,2.7478E-02_JPRB,2.6862E-02_JPRB,2.6273E-02_JPRB/)  
KAO( :, 8, 1) = (/&
 & 2.5465E-02_JPRB,2.4809E-02_JPRB,2.4170E-02_JPRB,2.3568E-02_JPRB,2.3010E-02_JPRB/)  
KAO( :, 9, 1) = (/&
 & 2.7031E-02_JPRB,2.6297E-02_JPRB,2.5569E-02_JPRB,2.4878E-02_JPRB,2.4216E-02_JPRB/)  
KAO( :,10, 1) = (/&
 & 2.6955E-02_JPRB,2.7533E-02_JPRB,2.7941E-02_JPRB,2.8269E-02_JPRB,2.8556E-02_JPRB/)  
KAO( :,11, 1) = (/&
 & 2.3333E-02_JPRB,2.4026E-02_JPRB,2.4613E-02_JPRB,2.5142E-02_JPRB,2.5601E-02_JPRB/)  
KAO( :,12, 1) = (/&
 & 1.9793E-02_JPRB,2.0434E-02_JPRB,2.0982E-02_JPRB,2.1484E-02_JPRB,2.1945E-02_JPRB/)  
KAO( :,13, 1) = (/&
 & 1.6447E-02_JPRB,1.6981E-02_JPRB,1.7444E-02_JPRB,1.7868E-02_JPRB,1.8252E-02_JPRB/)  
KAO( :, 1, 2) = (/&
 & 1.8412E-01_JPRB,1.7858E-01_JPRB,1.7358E-01_JPRB,1.6916E-01_JPRB,1.6516E-01_JPRB/)  
KAO( :, 2, 2) = (/&
 & 1.5257E-01_JPRB,1.4806E-01_JPRB,1.4389E-01_JPRB,1.4020E-01_JPRB,1.3683E-01_JPRB/)  
KAO( :, 3, 2) = (/&
 & 1.2692E-01_JPRB,1.2322E-01_JPRB,1.1970E-01_JPRB,1.1654E-01_JPRB,1.1362E-01_JPRB/)  
KAO( :, 4, 2) = (/&
 & 1.0642E-01_JPRB,1.0336E-01_JPRB,1.0039E-01_JPRB,9.7683E-02_JPRB,9.5128E-02_JPRB/)  
KAO( :, 5, 2) = (/&
 & 8.9523E-02_JPRB,8.6972E-02_JPRB,8.4476E-02_JPRB,8.2142E-02_JPRB,7.9952E-02_JPRB/)  
KAO( :, 6, 2) = (/&
 & 7.5430E-02_JPRB,7.3336E-02_JPRB,7.1244E-02_JPRB,6.9235E-02_JPRB,6.7354E-02_JPRB/)  
KAO( :, 7, 2) = (/&
 & 6.3775E-02_JPRB,6.2031E-02_JPRB,6.0281E-02_JPRB,5.8573E-02_JPRB,5.6925E-02_JPRB/)  
KAO( :, 8, 2) = (/&
 & 5.4827E-02_JPRB,5.3223E-02_JPRB,5.1676E-02_JPRB,5.0200E-02_JPRB,4.8747E-02_JPRB/)  
KAO( :, 9, 2) = (/&
 & 5.4030E-02_JPRB,5.1628E-02_JPRB,4.9558E-02_JPRB,4.7732E-02_JPRB,4.6090E-02_JPRB/)  
KAO( :,10, 2) = (/&
 & 8.3445E-02_JPRB,7.9695E-02_JPRB,7.5528E-02_JPRB,7.1349E-02_JPRB,6.7427E-02_JPRB/)  
KAO( :,11, 2) = (/&
 & 8.4499E-02_JPRB,8.2002E-02_JPRB,7.9684E-02_JPRB,7.7445E-02_JPRB,7.4716E-02_JPRB/)  
KAO( :,12, 2) = (/&
 & 7.7856E-02_JPRB,7.5679E-02_JPRB,7.3803E-02_JPRB,7.2014E-02_JPRB,7.0273E-02_JPRB/)  
KAO( :,13, 2) = (/&
 & 6.5859E-02_JPRB,6.3974E-02_JPRB,6.2346E-02_JPRB,6.0810E-02_JPRB,5.9317E-02_JPRB/)  
KAO( :, 1, 3) = (/&
 & 2.9197E-01_JPRB,2.8442E-01_JPRB,2.7750E-01_JPRB,2.7131E-01_JPRB,2.6568E-01_JPRB/)  
KAO( :, 2, 3) = (/&
 & 2.4244E-01_JPRB,2.3605E-01_JPRB,2.3044E-01_JPRB,2.2538E-01_JPRB,2.2082E-01_JPRB/)  
KAO( :, 3, 3) = (/&
 & 2.0181E-01_JPRB,1.9632E-01_JPRB,1.9163E-01_JPRB,1.8739E-01_JPRB,1.8374E-01_JPRB/)  
KAO( :, 4, 3) = (/&
 & 1.6959E-01_JPRB,1.6475E-01_JPRB,1.6065E-01_JPRB,1.5699E-01_JPRB,1.5395E-01_JPRB/)  
KAO( :, 5, 3) = (/&
 & 1.4314E-01_JPRB,1.3886E-01_JPRB,1.3520E-01_JPRB,1.3204E-01_JPRB,1.2940E-01_JPRB/)  
KAO( :, 6, 3) = (/&
 & 1.2136E-01_JPRB,1.1746E-01_JPRB,1.1417E-01_JPRB,1.1138E-01_JPRB,1.0905E-01_JPRB/)  
KAO( :, 7, 3) = (/&
 & 1.0338E-01_JPRB,9.9815E-02_JPRB,9.6778E-02_JPRB,9.4240E-02_JPRB,9.2133E-02_JPRB/)  
KAO( :, 8, 3) = (/&
 & 8.9213E-02_JPRB,8.5864E-02_JPRB,8.2965E-02_JPRB,8.0544E-02_JPRB,7.8544E-02_JPRB/)  
KAO( :, 9, 3) = (/&
 & 8.5385E-02_JPRB,8.1609E-02_JPRB,7.8239E-02_JPRB,7.5298E-02_JPRB,7.2804E-02_JPRB/)  
KAO( :,10, 3) = (/&
 & 1.2007E-01_JPRB,1.1056E-01_JPRB,1.0332E-01_JPRB,9.7549E-02_JPRB,9.2699E-02_JPRB/)  
KAO( :,11, 3) = (/&
 & 1.4027E-01_JPRB,1.2871E-01_JPRB,1.1832E-01_JPRB,1.0920E-01_JPRB,1.0190E-01_JPRB/)  
KAO( :,12, 3) = (/&
 & 1.3635E-01_JPRB,1.2627E-01_JPRB,1.1647E-01_JPRB,1.0761E-01_JPRB,9.9760E-02_JPRB/)  
KAO( :,13, 3) = (/&
 & 1.1578E-01_JPRB,1.0716E-01_JPRB,9.8794E-02_JPRB,9.1233E-02_JPRB,8.4550E-02_JPRB/)  
KAO( :, 1, 4) = (/&
 & 4.8086E-01_JPRB,4.7132E-01_JPRB,4.6205E-01_JPRB,4.5354E-01_JPRB,4.4595E-01_JPRB/)  
KAO( :, 2, 4) = (/&
 & 4.0074E-01_JPRB,3.9253E-01_JPRB,3.8477E-01_JPRB,3.7758E-01_JPRB,3.7132E-01_JPRB/)  
KAO( :, 3, 4) = (/&
 & 3.3455E-01_JPRB,3.2760E-01_JPRB,3.2088E-01_JPRB,3.1483E-01_JPRB,3.0965E-01_JPRB/)  
KAO( :, 4, 4) = (/&
 & 2.8170E-01_JPRB,2.7587E-01_JPRB,2.7011E-01_JPRB,2.6499E-01_JPRB,2.6048E-01_JPRB/)  
KAO( :, 5, 4) = (/&
 & 2.3795E-01_JPRB,2.3301E-01_JPRB,2.2814E-01_JPRB,2.2368E-01_JPRB,2.1976E-01_JPRB/)  
KAO( :, 6, 4) = (/&
 & 2.0113E-01_JPRB,1.9701E-01_JPRB,1.9292E-01_JPRB,1.8907E-01_JPRB,1.8557E-01_JPRB/)  
KAO( :, 7, 4) = (/&
 & 1.7006E-01_JPRB,1.6661E-01_JPRB,1.6317E-01_JPRB,1.5986E-01_JPRB,1.5679E-01_JPRB/)  
KAO( :, 8, 4) = (/&
 & 1.4477E-01_JPRB,1.4172E-01_JPRB,1.3877E-01_JPRB,1.3586E-01_JPRB,1.3312E-01_JPRB/)  
KAO( :, 9, 4) = (/&
 & 1.3199E-01_JPRB,1.2821E-01_JPRB,1.2474E-01_JPRB,1.2152E-01_JPRB,1.1855E-01_JPRB/)  
KAO( :,10, 4) = (/&
 & 1.6601E-01_JPRB,1.5603E-01_JPRB,1.4717E-01_JPRB,1.3948E-01_JPRB,1.3292E-01_JPRB/)  
KAO( :,11, 4) = (/&
 & 1.7889E-01_JPRB,1.6649E-01_JPRB,1.5552E-01_JPRB,1.4618E-01_JPRB,1.3804E-01_JPRB/)  
KAO( :,12, 4) = (/&
 & 1.7280E-01_JPRB,1.5923E-01_JPRB,1.4821E-01_JPRB,1.3870E-01_JPRB,1.3058E-01_JPRB/)  
KAO( :,13, 4) = (/&
 & 1.4697E-01_JPRB,1.3536E-01_JPRB,1.2589E-01_JPRB,1.1779E-01_JPRB,1.1082E-01_JPRB/)  
KAO( :, 1, 5) = (/&
 & 8.2847E-01_JPRB,8.1706E-01_JPRB,8.0603E-01_JPRB,7.9489E-01_JPRB,7.8340E-01_JPRB/)  
KAO( :, 2, 5) = (/&
 & 6.9594E-01_JPRB,6.8698E-01_JPRB,6.7809E-01_JPRB,6.6891E-01_JPRB,6.5974E-01_JPRB/)  
KAO( :, 3, 5) = (/&
 & 5.8279E-01_JPRB,5.7548E-01_JPRB,5.6796E-01_JPRB,5.6025E-01_JPRB,5.5235E-01_JPRB/)  
KAO( :, 4, 5) = (/&
 & 4.9038E-01_JPRB,4.8412E-01_JPRB,4.7772E-01_JPRB,4.7110E-01_JPRB,4.6460E-01_JPRB/)  
KAO( :, 5, 5) = (/&
 & 4.1378E-01_JPRB,4.0847E-01_JPRB,4.0311E-01_JPRB,3.9759E-01_JPRB,3.9230E-01_JPRB/)  
KAO( :, 6, 5) = (/&
 & 3.4972E-01_JPRB,3.4519E-01_JPRB,3.4085E-01_JPRB,3.3630E-01_JPRB,3.3209E-01_JPRB/)  
KAO( :, 7, 5) = (/&
 & 2.9568E-01_JPRB,2.9179E-01_JPRB,2.8827E-01_JPRB,2.8454E-01_JPRB,2.8107E-01_JPRB/)  
KAO( :, 8, 5) = (/&
 & 2.5092E-01_JPRB,2.4746E-01_JPRB,2.4424E-01_JPRB,2.4103E-01_JPRB,2.3811E-01_JPRB/)  
KAO( :, 9, 5) = (/&
 & 2.2123E-01_JPRB,2.1714E-01_JPRB,2.1336E-01_JPRB,2.0980E-01_JPRB,2.0674E-01_JPRB/)  
KAO( :,10, 5) = (/&
 & 2.3952E-01_JPRB,2.2844E-01_JPRB,2.1930E-01_JPRB,2.1169E-01_JPRB,2.0553E-01_JPRB/)  
KAO( :,11, 5) = (/&
 & 2.4873E-01_JPRB,2.3190E-01_JPRB,2.1857E-01_JPRB,2.0774E-01_JPRB,1.9916E-01_JPRB/)  
KAO( :,12, 5) = (/&
 & 2.3605E-01_JPRB,2.1832E-01_JPRB,2.0375E-01_JPRB,1.9219E-01_JPRB,1.8288E-01_JPRB/)  
KAO( :,13, 5) = (/&
 & 2.0036E-01_JPRB,1.8536E-01_JPRB,1.7319E-01_JPRB,1.6345E-01_JPRB,1.5566E-01_JPRB/)  
KAO( :, 1, 6) = (/&
 & 1.6289E+00_JPRB,1.6053E+00_JPRB,1.5817E+00_JPRB,1.5589E+00_JPRB,1.5373E+00_JPRB/)  
KAO( :, 2, 6) = (/&
 & 1.3936E+00_JPRB,1.3733E+00_JPRB,1.3535E+00_JPRB,1.3341E+00_JPRB,1.3148E+00_JPRB/)  
KAO( :, 3, 6) = (/&
 & 1.1841E+00_JPRB,1.1673E+00_JPRB,1.1508E+00_JPRB,1.1346E+00_JPRB,1.1181E+00_JPRB/)  
KAO( :, 4, 6) = (/&
 & 1.0080E+00_JPRB,9.9445E-01_JPRB,9.8106E-01_JPRB,9.6749E-01_JPRB,9.5407E-01_JPRB/)  
KAO( :, 5, 6) = (/&
 & 8.5742E-01_JPRB,8.4664E-01_JPRB,8.3551E-01_JPRB,8.2440E-01_JPRB,8.1340E-01_JPRB/)  
KAO( :, 6, 6) = (/&
 & 7.2750E-01_JPRB,7.1904E-01_JPRB,7.0964E-01_JPRB,7.0043E-01_JPRB,6.9094E-01_JPRB/)  
KAO( :, 7, 6) = (/&
 & 6.1594E-01_JPRB,6.0900E-01_JPRB,6.0116E-01_JPRB,5.9327E-01_JPRB,5.8510E-01_JPRB/)  
KAO( :, 8, 6) = (/&
 & 5.2157E-01_JPRB,5.1588E-01_JPRB,5.0935E-01_JPRB,5.0256E-01_JPRB,4.9566E-01_JPRB/)  
KAO( :, 9, 6) = (/&
 & 4.4895E-01_JPRB,4.4354E-01_JPRB,4.3759E-01_JPRB,4.3150E-01_JPRB,4.2532E-01_JPRB/)  
KAO( :,10, 6) = (/&
 & 4.2442E-01_JPRB,4.1504E-01_JPRB,4.0636E-01_JPRB,3.9814E-01_JPRB,3.9006E-01_JPRB/)  
KAO( :,11, 6) = (/&
 & 3.9535E-01_JPRB,3.8239E-01_JPRB,3.7132E-01_JPRB,3.6140E-01_JPRB,3.5225E-01_JPRB/)  
KAO( :,12, 6) = (/&
 & 3.5520E-01_JPRB,3.4132E-01_JPRB,3.2979E-01_JPRB,3.1961E-01_JPRB,3.1084E-01_JPRB/)  
KAO( :,13, 6) = (/&
 & 3.0031E-01_JPRB,2.8876E-01_JPRB,2.7891E-01_JPRB,2.7050E-01_JPRB,2.6328E-01_JPRB/)  
KAO( :, 1, 7) = (/&
 & 3.4694E+00_JPRB,3.4297E+00_JPRB,3.3904E+00_JPRB,3.3487E+00_JPRB,3.3017E+00_JPRB/)  
KAO( :, 2, 7) = (/&
 & 3.0726E+00_JPRB,3.0336E+00_JPRB,2.9923E+00_JPRB,2.9489E+00_JPRB,2.9055E+00_JPRB/)  
KAO( :, 3, 7) = (/&
 & 2.6840E+00_JPRB,2.6467E+00_JPRB,2.6074E+00_JPRB,2.5687E+00_JPRB,2.5313E+00_JPRB/)  
KAO( :, 4, 7) = (/&
 & 2.3349E+00_JPRB,2.3013E+00_JPRB,2.2673E+00_JPRB,2.2337E+00_JPRB,2.2014E+00_JPRB/)  
KAO( :, 5, 7) = (/&
 & 2.0215E+00_JPRB,1.9929E+00_JPRB,1.9642E+00_JPRB,1.9357E+00_JPRB,1.9075E+00_JPRB/)  
KAO( :, 6, 7) = (/&
 & 1.7423E+00_JPRB,1.7184E+00_JPRB,1.6935E+00_JPRB,1.6697E+00_JPRB,1.6459E+00_JPRB/)  
KAO( :, 7, 7) = (/&
 & 1.4935E+00_JPRB,1.4730E+00_JPRB,1.4523E+00_JPRB,1.4325E+00_JPRB,1.4131E+00_JPRB/)  
KAO( :, 8, 7) = (/&
 & 1.2741E+00_JPRB,1.2566E+00_JPRB,1.2398E+00_JPRB,1.2241E+00_JPRB,1.2075E+00_JPRB/)  
KAO( :, 9, 7) = (/&
 & 1.0910E+00_JPRB,1.0756E+00_JPRB,1.0611E+00_JPRB,1.0471E+00_JPRB,1.0328E+00_JPRB/)  
KAO( :,10, 7) = (/&
 & 9.6869E-01_JPRB,9.5109E-01_JPRB,9.3551E-01_JPRB,9.2022E-01_JPRB,9.0558E-01_JPRB/)  
KAO( :,11, 7) = (/&
 & 8.5022E-01_JPRB,8.3262E-01_JPRB,8.1646E-01_JPRB,8.0094E-01_JPRB,7.8632E-01_JPRB/)  
KAO( :,12, 7) = (/&
 & 7.3620E-01_JPRB,7.1934E-01_JPRB,7.0369E-01_JPRB,6.8927E-01_JPRB,6.7565E-01_JPRB/)  
KAO( :,13, 7) = (/&
 & 6.2075E-01_JPRB,6.0642E-01_JPRB,5.9315E-01_JPRB,5.8082E-01_JPRB,5.6896E-01_JPRB/)  
KAO( :, 1, 8) = (/&
 & 7.9943E+00_JPRB,7.8622E+00_JPRB,7.7337E+00_JPRB,7.6053E+00_JPRB,7.4825E+00_JPRB/)  
KAO( :, 2, 8) = (/&
 & 7.5299E+00_JPRB,7.3990E+00_JPRB,7.2772E+00_JPRB,7.1539E+00_JPRB,7.0340E+00_JPRB/)  
KAO( :, 3, 8) = (/&
 & 6.9582E+00_JPRB,6.8392E+00_JPRB,6.7240E+00_JPRB,6.6095E+00_JPRB,6.4993E+00_JPRB/)  
KAO( :, 4, 8) = (/&
 & 6.3616E+00_JPRB,6.2560E+00_JPRB,6.1487E+00_JPRB,6.0437E+00_JPRB,5.9411E+00_JPRB/)  
KAO( :, 5, 8) = (/&
 & 5.7571E+00_JPRB,5.6594E+00_JPRB,5.5598E+00_JPRB,5.4641E+00_JPRB,5.3662E+00_JPRB/)  
KAO( :, 6, 8) = (/&
 & 5.1527E+00_JPRB,5.0625E+00_JPRB,4.9739E+00_JPRB,4.8820E+00_JPRB,4.7886E+00_JPRB/)  
KAO( :, 7, 8) = (/&
 & 4.5602E+00_JPRB,4.4806E+00_JPRB,4.3973E+00_JPRB,4.3111E+00_JPRB,4.2273E+00_JPRB/)  
KAO( :, 8, 8) = (/&
 & 3.9984E+00_JPRB,3.9261E+00_JPRB,3.8484E+00_JPRB,3.7714E+00_JPRB,3.6990E+00_JPRB/)  
KAO( :, 9, 8) = (/&
 & 3.4828E+00_JPRB,3.4160E+00_JPRB,3.3474E+00_JPRB,3.2815E+00_JPRB,3.2194E+00_JPRB/)  
KAO( :,10, 8) = (/&
 & 3.0434E+00_JPRB,2.9801E+00_JPRB,2.9179E+00_JPRB,2.8592E+00_JPRB,2.8030E+00_JPRB/)  
KAO( :,11, 8) = (/&
 & 2.6134E+00_JPRB,2.5563E+00_JPRB,2.5021E+00_JPRB,2.4506E+00_JPRB,2.4022E+00_JPRB/)  
KAO( :,12, 8) = (/&
 & 2.2242E+00_JPRB,2.1754E+00_JPRB,2.1288E+00_JPRB,2.0857E+00_JPRB,2.0457E+00_JPRB/)  
KAO( :,13, 8) = (/&
 & 1.8749E+00_JPRB,1.8340E+00_JPRB,1.7958E+00_JPRB,1.7607E+00_JPRB,1.7271E+00_JPRB/)  
KAO( :, 1, 9) = (/&
 & 1.8807E+01_JPRB,1.8545E+01_JPRB,1.8312E+01_JPRB,1.8089E+01_JPRB,1.7885E+01_JPRB/)  
KAO( :, 2, 9) = (/&
 & 1.9472E+01_JPRB,1.9225E+01_JPRB,1.8970E+01_JPRB,1.8737E+01_JPRB,1.8518E+01_JPRB/)  
KAO( :, 3, 9) = (/&
 & 1.9976E+01_JPRB,1.9718E+01_JPRB,1.9452E+01_JPRB,1.9190E+01_JPRB,1.8937E+01_JPRB/)  
KAO( :, 4, 9) = (/&
 & 2.0179E+01_JPRB,1.9901E+01_JPRB,1.9617E+01_JPRB,1.9339E+01_JPRB,1.9071E+01_JPRB/)  
KAO( :, 5, 9) = (/&
 & 2.0073E+01_JPRB,1.9777E+01_JPRB,1.9491E+01_JPRB,1.9213E+01_JPRB,1.8936E+01_JPRB/)  
KAO( :, 6, 9) = (/&
 & 1.9652E+01_JPRB,1.9360E+01_JPRB,1.9080E+01_JPRB,1.8806E+01_JPRB,1.8526E+01_JPRB/)  
KAO( :, 7, 9) = (/&
 & 1.8940E+01_JPRB,1.8655E+01_JPRB,1.8384E+01_JPRB,1.8113E+01_JPRB,1.7820E+01_JPRB/)  
KAO( :, 8, 9) = (/&
 & 1.7954E+01_JPRB,1.7679E+01_JPRB,1.7419E+01_JPRB,1.7144E+01_JPRB,1.6856E+01_JPRB/)  
KAO( :, 9, 9) = (/&
 & 1.6744E+01_JPRB,1.6495E+01_JPRB,1.6235E+01_JPRB,1.5966E+01_JPRB,1.5690E+01_JPRB/)  
KAO( :,10, 9) = (/&
 & 1.5389E+01_JPRB,1.5156E+01_JPRB,1.4910E+01_JPRB,1.4661E+01_JPRB,1.4409E+01_JPRB/)  
KAO( :,11, 9) = (/&
 & 1.3852E+01_JPRB,1.3629E+01_JPRB,1.3408E+01_JPRB,1.3185E+01_JPRB,1.2963E+01_JPRB/)  
KAO( :,12, 9) = (/&
 & 1.2299E+01_JPRB,1.2107E+01_JPRB,1.1912E+01_JPRB,1.1717E+01_JPRB,1.1509E+01_JPRB/)  
KAO( :,13, 9) = (/&
 & 1.0790E+01_JPRB,1.0623E+01_JPRB,1.0457E+01_JPRB,1.0277E+01_JPRB,1.0096E+01_JPRB/)  
KAO( :, 1,10) = (/&
 & 3.4330E+01_JPRB,3.3765E+01_JPRB,3.3237E+01_JPRB,3.2695E+01_JPRB,3.2149E+01_JPRB/)  
KAO( :, 2,10) = (/&
 & 3.6844E+01_JPRB,3.6202E+01_JPRB,3.5649E+01_JPRB,3.5225E+01_JPRB,3.4890E+01_JPRB/)  
KAO( :, 3,10) = (/&
 & 3.9801E+01_JPRB,3.9093E+01_JPRB,3.8604E+01_JPRB,3.8270E+01_JPRB,3.7931E+01_JPRB/)  
KAO( :, 4,10) = (/&
 & 4.2629E+01_JPRB,4.2009E+01_JPRB,4.1641E+01_JPRB,4.1207E+01_JPRB,4.0730E+01_JPRB/)  
KAO( :, 5,10) = (/&
 & 4.5222E+01_JPRB,4.4631E+01_JPRB,4.4212E+01_JPRB,4.3567E+01_JPRB,4.2975E+01_JPRB/)  
KAO( :, 6,10) = (/&
 & 4.7625E+01_JPRB,4.7023E+01_JPRB,4.6428E+01_JPRB,4.5641E+01_JPRB,4.5059E+01_JPRB/)  
KAO( :, 7,10) = (/&
 & 4.9512E+01_JPRB,4.8922E+01_JPRB,4.8261E+01_JPRB,4.7488E+01_JPRB,4.7086E+01_JPRB/)  
KAO( :, 8,10) = (/&
 & 5.0685E+01_JPRB,5.0115E+01_JPRB,4.9437E+01_JPRB,4.8806E+01_JPRB,4.8343E+01_JPRB/)  
KAO( :, 9,10) = (/&
 & 5.1127E+01_JPRB,5.0594E+01_JPRB,4.9931E+01_JPRB,4.9312E+01_JPRB,4.8711E+01_JPRB/)  
KAO( :,10,10) = (/&
 & 5.0693E+01_JPRB,5.0048E+01_JPRB,4.9328E+01_JPRB,4.8631E+01_JPRB,4.7896E+01_JPRB/)  
KAO( :,11,10) = (/&
 & 4.8604E+01_JPRB,4.7864E+01_JPRB,4.7094E+01_JPRB,4.6287E+01_JPRB,4.5518E+01_JPRB/)  
KAO( :,12,10) = (/&
 & 4.5443E+01_JPRB,4.4681E+01_JPRB,4.3926E+01_JPRB,4.3210E+01_JPRB,4.2649E+01_JPRB/)  
KAO( :,13,10) = (/&
 & 4.1744E+01_JPRB,4.1045E+01_JPRB,4.0400E+01_JPRB,3.9894E+01_JPRB,3.9431E+01_JPRB/)  
KAO( :, 1,11) = (/&
 & 4.2365E+01_JPRB,4.2019E+01_JPRB,4.1430E+01_JPRB,4.0878E+01_JPRB,4.0399E+01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB11:PART1',1,ZHOOK_HANDLE)
END SUBROUTINE PART1


SUBROUTINE PART2

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB11:PART2',0,ZHOOK_HANDLE)


KAO( :, 2,11) = (/&
 & 4.7142E+01_JPRB,4.6442E+01_JPRB,4.5764E+01_JPRB,4.5114E+01_JPRB,4.4407E+01_JPRB/)  
KAO( :, 3,11) = (/&
 & 5.1205E+01_JPRB,5.0483E+01_JPRB,4.9649E+01_JPRB,4.8898E+01_JPRB,4.8108E+01_JPRB/)  
KAO( :, 4,11) = (/&
 & 5.5163E+01_JPRB,5.4376E+01_JPRB,5.3481E+01_JPRB,5.2648E+01_JPRB,5.2016E+01_JPRB/)  
KAO( :, 5,11) = (/&
 & 5.9396E+01_JPRB,5.8482E+01_JPRB,5.7563E+01_JPRB,5.6780E+01_JPRB,5.6221E+01_JPRB/)  
KAO( :, 6,11) = (/&
 & 6.3331E+01_JPRB,6.2412E+01_JPRB,6.1450E+01_JPRB,6.0859E+01_JPRB,6.0233E+01_JPRB/)  
KAO( :, 7,11) = (/&
 & 6.6545E+01_JPRB,6.5768E+01_JPRB,6.5025E+01_JPRB,6.4467E+01_JPRB,6.3676E+01_JPRB/)  
KAO( :, 8,11) = (/&
 & 6.9498E+01_JPRB,6.8933E+01_JPRB,6.8310E+01_JPRB,6.7609E+01_JPRB,6.6704E+01_JPRB/)  
KAO( :, 9,11) = (/&
 & 7.1921E+01_JPRB,7.1404E+01_JPRB,7.0826E+01_JPRB,7.0092E+01_JPRB,6.9245E+01_JPRB/)  
KAO( :,10,11) = (/&
 & 7.3427E+01_JPRB,7.3002E+01_JPRB,7.2375E+01_JPRB,7.1636E+01_JPRB,7.0858E+01_JPRB/)  
KAO( :,11,11) = (/&
 & 7.3760E+01_JPRB,7.3287E+01_JPRB,7.2603E+01_JPRB,7.1801E+01_JPRB,7.0946E+01_JPRB/)  
KAO( :,12,11) = (/&
 & 7.2915E+01_JPRB,7.2168E+01_JPRB,7.1245E+01_JPRB,7.0254E+01_JPRB,6.9156E+01_JPRB/)  
KAO( :,13,11) = (/&
 & 7.0157E+01_JPRB,6.9120E+01_JPRB,6.8062E+01_JPRB,6.6888E+01_JPRB,6.5831E+01_JPRB/)  
KAO( :, 1,12) = (/&
 & 5.0027E+01_JPRB,4.9611E+01_JPRB,4.9300E+01_JPRB,4.8951E+01_JPRB,4.8362E+01_JPRB/)  
KAO( :, 2,12) = (/&
 & 5.7937E+01_JPRB,5.7505E+01_JPRB,5.7159E+01_JPRB,5.6651E+01_JPRB,5.5993E+01_JPRB/)  
KAO( :, 3,12) = (/&
 & 6.6111E+01_JPRB,6.5700E+01_JPRB,6.5251E+01_JPRB,6.4576E+01_JPRB,6.3894E+01_JPRB/)  
KAO( :, 4,12) = (/&
 & 7.3585E+01_JPRB,7.2903E+01_JPRB,7.2232E+01_JPRB,7.1435E+01_JPRB,7.0602E+01_JPRB/)  
KAO( :, 5,12) = (/&
 & 7.9953E+01_JPRB,7.9031E+01_JPRB,7.8235E+01_JPRB,7.7242E+01_JPRB,7.6289E+01_JPRB/)  
KAO( :, 6,12) = (/&
 & 8.6205E+01_JPRB,8.5051E+01_JPRB,8.4155E+01_JPRB,8.3091E+01_JPRB,8.2068E+01_JPRB/)  
KAO( :, 7,12) = (/&
 & 9.2997E+01_JPRB,9.1567E+01_JPRB,9.0372E+01_JPRB,8.9220E+01_JPRB,8.8255E+01_JPRB/)  
KAO( :, 8,12) = (/&
 & 9.9753E+01_JPRB,9.8062E+01_JPRB,9.6706E+01_JPRB,9.5557E+01_JPRB,9.4592E+01_JPRB/)  
KAO( :, 9,12) = (/&
 & 1.0585E+02_JPRB,1.0395E+02_JPRB,1.0257E+02_JPRB,1.0128E+02_JPRB,1.0041E+02_JPRB/)  
KAO( :,10,12) = (/&
 & 1.1079E+02_JPRB,1.0894E+02_JPRB,1.0770E+02_JPRB,1.0659E+02_JPRB,1.0559E+02_JPRB/)  
KAO( :,11,12) = (/&
 & 1.1382E+02_JPRB,1.1273E+02_JPRB,1.1179E+02_JPRB,1.1077E+02_JPRB,1.0960E+02_JPRB/)  
KAO( :,12,12) = (/&
 & 1.1615E+02_JPRB,1.1562E+02_JPRB,1.1476E+02_JPRB,1.1362E+02_JPRB,1.1239E+02_JPRB/)  
KAO( :,13,12) = (/&
 & 1.1766E+02_JPRB,1.1707E+02_JPRB,1.1606E+02_JPRB,1.1493E+02_JPRB,1.1363E+02_JPRB/)  
KAO( :, 1,13) = (/&
 & 5.9338E+01_JPRB,5.8766E+01_JPRB,5.8140E+01_JPRB,5.7609E+01_JPRB,5.7193E+01_JPRB/)  
KAO( :, 2,13) = (/&
 & 6.9799E+01_JPRB,6.9254E+01_JPRB,6.8563E+01_JPRB,6.7850E+01_JPRB,6.7241E+01_JPRB/)  
KAO( :, 3,13) = (/&
 & 8.2129E+01_JPRB,8.1337E+01_JPRB,8.0301E+01_JPRB,7.9572E+01_JPRB,7.8927E+01_JPRB/)  
KAO( :, 4,13) = (/&
 & 9.5236E+01_JPRB,9.4396E+01_JPRB,9.3373E+01_JPRB,9.2365E+01_JPRB,9.1463E+01_JPRB/)  
KAO( :, 5,13) = (/&
 & 1.0931E+02_JPRB,1.0828E+02_JPRB,1.0716E+02_JPRB,1.0592E+02_JPRB,1.0469E+02_JPRB/)  
KAO( :, 6,13) = (/&
 & 1.2326E+02_JPRB,1.2219E+02_JPRB,1.2081E+02_JPRB,1.1929E+02_JPRB,1.1786E+02_JPRB/)  
KAO( :, 7,13) = (/&
 & 1.3701E+02_JPRB,1.3559E+02_JPRB,1.3388E+02_JPRB,1.3200E+02_JPRB,1.3026E+02_JPRB/)  
KAO( :, 8,13) = (/&
 & 1.5000E+02_JPRB,1.4809E+02_JPRB,1.4591E+02_JPRB,1.4371E+02_JPRB,1.4177E+02_JPRB/)  
KAO( :, 9,13) = (/&
 & 1.6256E+02_JPRB,1.6031E+02_JPRB,1.5793E+02_JPRB,1.5565E+02_JPRB,1.5331E+02_JPRB/)  
KAO( :,10,13) = (/&
 & 1.7522E+02_JPRB,1.7277E+02_JPRB,1.7005E+02_JPRB,1.6730E+02_JPRB,1.6477E+02_JPRB/)  
KAO( :,11,13) = (/&
 & 1.8704E+02_JPRB,1.8360E+02_JPRB,1.8020E+02_JPRB,1.7766E+02_JPRB,1.7538E+02_JPRB/)  
KAO( :,12,13) = (/&
 & 1.9721E+02_JPRB,1.9323E+02_JPRB,1.9024E+02_JPRB,1.8798E+02_JPRB,1.8579E+02_JPRB/)  
KAO( :,13,13) = (/&
 & 2.0522E+02_JPRB,2.0182E+02_JPRB,1.9928E+02_JPRB,1.9689E+02_JPRB,1.9487E+02_JPRB/)  
KAO( :, 1,14) = (/&
 & 6.7502E+01_JPRB,6.6524E+01_JPRB,6.6072E+01_JPRB,6.5802E+01_JPRB,6.5743E+01_JPRB/)  
KAO( :, 2,14) = (/&
 & 8.2170E+01_JPRB,8.1149E+01_JPRB,8.0359E+01_JPRB,7.9744E+01_JPRB,7.9317E+01_JPRB/)  
KAO( :, 3,14) = (/&
 & 1.0017E+02_JPRB,9.8960E+01_JPRB,9.7919E+01_JPRB,9.6962E+01_JPRB,9.5952E+01_JPRB/)  
KAO( :, 4,14) = (/&
 & 1.2011E+02_JPRB,1.1875E+02_JPRB,1.1746E+02_JPRB,1.1624E+02_JPRB,1.1505E+02_JPRB/)  
KAO( :, 5,14) = (/&
 & 1.4236E+02_JPRB,1.4034E+02_JPRB,1.3884E+02_JPRB,1.3761E+02_JPRB,1.3626E+02_JPRB/)  
KAO( :, 6,14) = (/&
 & 1.6712E+02_JPRB,1.6463E+02_JPRB,1.6306E+02_JPRB,1.6156E+02_JPRB,1.5998E+02_JPRB/)  
KAO( :, 7,14) = (/&
 & 1.9406E+02_JPRB,1.9176E+02_JPRB,1.8985E+02_JPRB,1.8810E+02_JPRB,1.8617E+02_JPRB/)  
KAO( :, 8,14) = (/&
 & 2.2382E+02_JPRB,2.2149E+02_JPRB,2.1954E+02_JPRB,2.1758E+02_JPRB,2.1540E+02_JPRB/)  
KAO( :, 9,14) = (/&
 & 2.5634E+02_JPRB,2.5414E+02_JPRB,2.5166E+02_JPRB,2.4940E+02_JPRB,2.4661E+02_JPRB/)  
KAO( :,10,14) = (/&
 & 2.8999E+02_JPRB,2.8771E+02_JPRB,2.8448E+02_JPRB,2.8216E+02_JPRB,2.7875E+02_JPRB/)  
KAO( :,11,14) = (/&
 & 3.2226E+02_JPRB,3.1916E+02_JPRB,3.1653E+02_JPRB,3.1272E+02_JPRB,3.0896E+02_JPRB/)  
KAO( :,12,14) = (/&
 & 3.5464E+02_JPRB,3.5123E+02_JPRB,3.4726E+02_JPRB,3.4270E+02_JPRB,3.3845E+02_JPRB/)  
KAO( :,13,14) = (/&
 & 3.8725E+02_JPRB,3.8309E+02_JPRB,3.7834E+02_JPRB,3.7304E+02_JPRB,3.6820E+02_JPRB/)  
KAO( :, 1,15) = (/&
 & 7.8084E+01_JPRB,7.7914E+01_JPRB,7.8402E+01_JPRB,7.8217E+01_JPRB,7.8646E+01_JPRB/)  
KAO( :, 2,15) = (/&
 & 9.4779E+01_JPRB,9.4641E+01_JPRB,9.4900E+01_JPRB,9.5560E+01_JPRB,9.6118E+01_JPRB/)  
KAO( :, 3,15) = (/&
 & 1.1669E+02_JPRB,1.1613E+02_JPRB,1.1582E+02_JPRB,1.1604E+02_JPRB,1.1741E+02_JPRB/)  
KAO( :, 4,15) = (/&
 & 1.4166E+02_JPRB,1.4067E+02_JPRB,1.3938E+02_JPRB,1.3929E+02_JPRB,1.4030E+02_JPRB/)  
KAO( :, 5,15) = (/&
 & 1.7200E+02_JPRB,1.6974E+02_JPRB,1.6765E+02_JPRB,1.6701E+02_JPRB,1.6674E+02_JPRB/)  
KAO( :, 6,15) = (/&
 & 2.0913E+02_JPRB,2.0570E+02_JPRB,2.0221E+02_JPRB,2.0039E+02_JPRB,1.9903E+02_JPRB/)  
KAO( :, 7,15) = (/&
 & 2.5392E+02_JPRB,2.4919E+02_JPRB,2.4443E+02_JPRB,2.4058E+02_JPRB,2.3803E+02_JPRB/)  
KAO( :, 8,15) = (/&
 & 3.0711E+02_JPRB,3.0120E+02_JPRB,2.9497E+02_JPRB,2.8940E+02_JPRB,2.8562E+02_JPRB/)  
KAO( :, 9,15) = (/&
 & 3.7033E+02_JPRB,3.6170E+02_JPRB,3.5403E+02_JPRB,3.4775E+02_JPRB,3.4171E+02_JPRB/)  
KAO( :,10,15) = (/&
 & 4.4192E+02_JPRB,4.3106E+02_JPRB,4.2140E+02_JPRB,4.1427E+02_JPRB,4.0680E+02_JPRB/)  
KAO( :,11,15) = (/&
 & 5.1756E+02_JPRB,5.0440E+02_JPRB,4.9429E+02_JPRB,4.8599E+02_JPRB,4.7734E+02_JPRB/)  
KAO( :,12,15) = (/&
 & 6.0261E+02_JPRB,5.8732E+02_JPRB,5.7721E+02_JPRB,5.6784E+02_JPRB,5.5802E+02_JPRB/)  
KAO( :,13,15) = (/&
 & 6.9467E+02_JPRB,6.8189E+02_JPRB,6.7026E+02_JPRB,6.5869E+02_JPRB,6.4922E+02_JPRB/)  
KAO( :, 1,16) = (/&
 & 8.4011E+01_JPRB,8.3820E+01_JPRB,8.3802E+01_JPRB,8.4342E+01_JPRB,8.4737E+01_JPRB/)  
KAO( :, 2,16) = (/&
 & 1.0457E+02_JPRB,1.0437E+02_JPRB,1.0452E+02_JPRB,1.0492E+02_JPRB,1.0505E+02_JPRB/)  
KAO( :, 3,16) = (/&
 & 1.3081E+02_JPRB,1.3074E+02_JPRB,1.3067E+02_JPRB,1.3085E+02_JPRB,1.3130E+02_JPRB/)  
KAO( :, 4,16) = (/&
 & 1.6036E+02_JPRB,1.6101E+02_JPRB,1.6092E+02_JPRB,1.6141E+02_JPRB,1.6148E+02_JPRB/)  
KAO( :, 5,16) = (/&
 & 1.9521E+02_JPRB,1.9614E+02_JPRB,1.9659E+02_JPRB,1.9718E+02_JPRB,1.9784E+02_JPRB/)  
KAO( :, 6,16) = (/&
 & 2.3599E+02_JPRB,2.3769E+02_JPRB,2.3905E+02_JPRB,2.3984E+02_JPRB,2.4105E+02_JPRB/)  
KAO( :, 7,16) = (/&
 & 2.8624E+02_JPRB,2.8792E+02_JPRB,2.8925E+02_JPRB,2.9040E+02_JPRB,2.9197E+02_JPRB/)  
KAO( :, 8,16) = (/&
 & 3.4928E+02_JPRB,3.4848E+02_JPRB,3.4810E+02_JPRB,3.5059E+02_JPRB,3.5311E+02_JPRB/)  
KAO( :, 9,16) = (/&
 & 4.2722E+02_JPRB,4.2296E+02_JPRB,4.2078E+02_JPRB,4.2340E+02_JPRB,4.2506E+02_JPRB/)  
KAO( :,10,16) = (/&
 & 5.2290E+02_JPRB,5.1431E+02_JPRB,5.1021E+02_JPRB,5.0875E+02_JPRB,5.0973E+02_JPRB/)  
KAO( :,11,16) = (/&
 & 6.3361E+02_JPRB,6.2265E+02_JPRB,6.1495E+02_JPRB,6.1325E+02_JPRB,6.1231E+02_JPRB/)  
KAO( :,12,16) = (/&
 & 7.6899E+02_JPRB,7.5167E+02_JPRB,7.4101E+02_JPRB,7.3718E+02_JPRB,7.3364E+02_JPRB/)  
KAO( :,13,16) = (/&
 & 9.2904E+02_JPRB,9.0879E+02_JPRB,8.9032E+02_JPRB,8.8110E+02_JPRB,8.7634E+02_JPRB/)  

!     The array KB contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KBO( :,13, 1) = (/&
 & 1.6448E-02_JPRB,1.6981E-02_JPRB,1.7447E-02_JPRB,1.7868E-02_JPRB,1.8252E-02_JPRB/)  
KBO( :,14, 1) = (/&
 & 1.3791E-02_JPRB,1.4222E-02_JPRB,1.4610E-02_JPRB,1.4952E-02_JPRB,1.5267E-02_JPRB/)  
KBO( :,15, 1) = (/&
 & 1.1520E-02_JPRB,1.1865E-02_JPRB,1.2171E-02_JPRB,1.2437E-02_JPRB,1.2693E-02_JPRB/)  
KBO( :,16, 1) = (/&
 & 9.5363E-03_JPRB,9.8097E-03_JPRB,1.0040E-02_JPRB,1.0251E-02_JPRB,1.0450E-02_JPRB/)  
KBO( :,17, 1) = (/&
 & 7.8780E-03_JPRB,8.0826E-03_JPRB,8.2596E-03_JPRB,8.4216E-03_JPRB,8.5653E-03_JPRB/)  
KBO( :,18, 1) = (/&
 & 6.4817E-03_JPRB,6.6351E-03_JPRB,6.7691E-03_JPRB,6.8780E-03_JPRB,6.9825E-03_JPRB/)  
KBO( :,19, 1) = (/&
 & 5.3453E-03_JPRB,5.4640E-03_JPRB,5.5554E-03_JPRB,5.6332E-03_JPRB,5.7111E-03_JPRB/)  
KBO( :,20, 1) = (/&
 & 4.4040E-03_JPRB,4.4936E-03_JPRB,4.5584E-03_JPRB,4.6182E-03_JPRB,4.6772E-03_JPRB/)  
KBO( :,21, 1) = (/&
 & 3.6258E-03_JPRB,3.6901E-03_JPRB,3.7391E-03_JPRB,3.7854E-03_JPRB,3.8304E-03_JPRB/)  
KBO( :,22, 1) = (/&
 & 2.9839E-03_JPRB,3.0283E-03_JPRB,3.0657E-03_JPRB,3.1009E-03_JPRB,3.1358E-03_JPRB/)  
KBO( :,23, 1) = (/&
 & 2.4521E-03_JPRB,2.4841E-03_JPRB,2.5126E-03_JPRB,2.5397E-03_JPRB,2.5675E-03_JPRB/)  
KBO( :,24, 1) = (/&
 & 2.0171E-03_JPRB,2.0411E-03_JPRB,2.0630E-03_JPRB,2.0844E-03_JPRB,2.1071E-03_JPRB/)  
KBO( :,25, 1) = (/&
 & 1.6582E-03_JPRB,1.6765E-03_JPRB,1.6934E-03_JPRB,1.7108E-03_JPRB,1.7288E-03_JPRB/)  
KBO( :,26, 1) = (/&
 & 1.3630E-03_JPRB,1.3770E-03_JPRB,1.3905E-03_JPRB,1.4049E-03_JPRB,1.4189E-03_JPRB/)  
KBO( :,27, 1) = (/&
 & 1.1189E-03_JPRB,1.1298E-03_JPRB,1.1410E-03_JPRB,1.1528E-03_JPRB,1.1640E-03_JPRB/)  
KBO( :,28, 1) = (/&
 & 9.1766E-04_JPRB,9.2656E-04_JPRB,9.3588E-04_JPRB,9.4542E-04_JPRB,9.5464E-04_JPRB/)  
KBO( :,29, 1) = (/&
 & 7.5009E-04_JPRB,7.5750E-04_JPRB,7.6532E-04_JPRB,7.7307E-04_JPRB,7.8058E-04_JPRB/)  
KBO( :,30, 1) = (/&
 & 6.1229E-04_JPRB,6.1848E-04_JPRB,6.2499E-04_JPRB,6.3126E-04_JPRB,6.3737E-04_JPRB/)  
KBO( :,31, 1) = (/&
 & 4.9822E-04_JPRB,5.0337E-04_JPRB,5.0876E-04_JPRB,5.1376E-04_JPRB,5.1867E-04_JPRB/)  
KBO( :,32, 1) = (/&
 & 4.0576E-04_JPRB,4.1007E-04_JPRB,4.1447E-04_JPRB,4.1853E-04_JPRB,4.2247E-04_JPRB/)  
KBO( :,33, 1) = (/&
 & 3.3066E-04_JPRB,3.3431E-04_JPRB,3.3786E-04_JPRB,3.4118E-04_JPRB,3.4427E-04_JPRB/)  
KBO( :,34, 1) = (/&
 & 2.7031E-04_JPRB,2.7336E-04_JPRB,2.7627E-04_JPRB,2.7896E-04_JPRB,2.8137E-04_JPRB/)  
KBO( :,35, 1) = (/&
 & 2.2093E-04_JPRB,2.2344E-04_JPRB,2.2584E-04_JPRB,2.2800E-04_JPRB,2.2992E-04_JPRB/)  
KBO( :,36, 1) = (/&
 & 1.8050E-04_JPRB,1.8257E-04_JPRB,1.8457E-04_JPRB,1.8634E-04_JPRB,1.8790E-04_JPRB/)  
KBO( :,37, 1) = (/&
 & 1.4754E-04_JPRB,1.4928E-04_JPRB,1.5098E-04_JPRB,1.5247E-04_JPRB,1.5379E-04_JPRB/)  
KBO( :,38, 1) = (/&
 & 1.2055E-04_JPRB,1.2202E-04_JPRB,1.2346E-04_JPRB,1.2473E-04_JPRB,1.2584E-04_JPRB/)  
KBO( :,39, 1) = (/&
 & 9.8439E-05_JPRB,9.9693E-05_JPRB,1.0089E-04_JPRB,1.0198E-04_JPRB,1.0292E-04_JPRB/)  
KBO( :,40, 1) = (/&
 & 8.0526E-05_JPRB,8.1618E-05_JPRB,8.2621E-05_JPRB,8.3584E-05_JPRB,8.4404E-05_JPRB/)  
KBO( :,41, 1) = (/&
 & 6.5872E-05_JPRB,6.6811E-05_JPRB,6.7670E-05_JPRB,6.8504E-05_JPRB,6.9227E-05_JPRB/)  
KBO( :,42, 1) = (/&
 & 5.3861E-05_JPRB,5.4663E-05_JPRB,5.5407E-05_JPRB,5.6110E-05_JPRB,5.6761E-05_JPRB/)  
KBO( :,43, 1) = (/&
 & 4.4048E-05_JPRB,4.4743E-05_JPRB,4.5396E-05_JPRB,4.6004E-05_JPRB,4.6586E-05_JPRB/)  
KBO( :,44, 1) = (/&
 & 3.6000E-05_JPRB,3.6620E-05_JPRB,3.7187E-05_JPRB,3.7726E-05_JPRB,3.8228E-05_JPRB/)  
KBO( :,45, 1) = (/&
 & 2.9370E-05_JPRB,2.9944E-05_JPRB,3.0441E-05_JPRB,3.0913E-05_JPRB,3.1356E-05_JPRB/)  
KBO( :,46, 1) = (/&
 & 2.3891E-05_JPRB,2.4458E-05_JPRB,2.4903E-05_JPRB,2.5314E-05_JPRB,2.5708E-05_JPRB/)  
KBO( :,47, 1) = (/&
 & 1.9404E-05_JPRB,1.9925E-05_JPRB,2.0357E-05_JPRB,2.0722E-05_JPRB,2.1066E-05_JPRB/)  
KBO( :,48, 1) = (/&
 & 1.5725E-05_JPRB,1.6197E-05_JPRB,1.6603E-05_JPRB,1.6945E-05_JPRB,1.7248E-05_JPRB/)  
KBO( :,49, 1) = (/&
 & 1.2722E-05_JPRB,1.3139E-05_JPRB,1.3505E-05_JPRB,1.3828E-05_JPRB,1.4106E-05_JPRB/)  
KBO( :,50, 1) = (/&
 & 1.0301E-05_JPRB,1.0665E-05_JPRB,1.0996E-05_JPRB,1.1280E-05_JPRB,1.1543E-05_JPRB/)  
KBO( :,51, 1) = (/&
 & 8.3385E-06_JPRB,8.6603E-06_JPRB,8.9500E-06_JPRB,9.2043E-06_JPRB,9.4349E-06_JPRB/)  
KBO( :,52, 1) = (/&
 & 6.7457E-06_JPRB,7.0201E-06_JPRB,7.2750E-06_JPRB,7.5028E-06_JPRB,7.7047E-06_JPRB/)  
KBO( :,53, 1) = (/&
 & 5.4538E-06_JPRB,5.6816E-06_JPRB,5.9061E-06_JPRB,6.1054E-06_JPRB,6.2862E-06_JPRB/)  
KBO( :,54, 1) = (/&
 & 4.4285E-06_JPRB,4.6181E-06_JPRB,4.8085E-06_JPRB,4.9862E-06_JPRB,5.1448E-06_JPRB/)  
KBO( :,55, 1) = (/&
 & 3.6038E-06_JPRB,3.7624E-06_JPRB,3.9229E-06_JPRB,4.0804E-06_JPRB,4.2193E-06_JPRB/)  
KBO( :,56, 1) = (/&
 & 2.9326E-06_JPRB,3.0656E-06_JPRB,3.2010E-06_JPRB,3.3368E-06_JPRB,3.4604E-06_JPRB/)  
KBO( :,57, 1) = (/&
 & 2.3859E-06_JPRB,2.4983E-06_JPRB,2.6127E-06_JPRB,2.7280E-06_JPRB,2.8384E-06_JPRB/)  
KBO( :,58, 1) = (/&
 & 1.9434E-06_JPRB,2.0390E-06_JPRB,2.1360E-06_JPRB,2.2340E-06_JPRB,2.3298E-06_JPRB/)  
KBO( :,59, 1) = (/&
 & 1.6040E-06_JPRB,1.6859E-06_JPRB,1.7694E-06_JPRB,1.8537E-06_JPRB,1.9359E-06_JPRB/)  
KBO( :,13, 2) = (/&
 & 6.5857E-02_JPRB,6.3975E-02_JPRB,6.2348E-02_JPRB,6.0811E-02_JPRB,5.9318E-02_JPRB/)  
KBO( :,14, 2) = (/&
 & 5.5335E-02_JPRB,5.3693E-02_JPRB,5.2240E-02_JPRB,5.0877E-02_JPRB,4.9563E-02_JPRB/)  
KBO( :,15, 2) = (/&
 & 4.5552E-02_JPRB,4.4145E-02_JPRB,4.2866E-02_JPRB,4.1679E-02_JPRB,4.0479E-02_JPRB/)  
KBO( :,16, 2) = (/&
 & 3.6852E-02_JPRB,3.5658E-02_JPRB,3.4584E-02_JPRB,3.3581E-02_JPRB,3.2436E-02_JPRB/)  
KBO( :,17, 2) = (/&
 & 2.9622E-02_JPRB,2.8635E-02_JPRB,2.7748E-02_JPRB,2.6847E-02_JPRB,2.5789E-02_JPRB/)  
KBO( :,18, 2) = (/&
 & 2.3577E-02_JPRB,2.2776E-02_JPRB,2.2036E-02_JPRB,2.1181E-02_JPRB,2.0244E-02_JPRB/)  
KBO( :,19, 2) = (/&
 & 1.8914E-02_JPRB,1.8260E-02_JPRB,1.7601E-02_JPRB,1.6830E-02_JPRB,1.6029E-02_JPRB/)  
KBO( :,20, 2) = (/&
 & 1.5260E-02_JPRB,1.4727E-02_JPRB,1.4133E-02_JPRB,1.3470E-02_JPRB,1.2804E-02_JPRB/)  
KBO( :,21, 2) = (/&
 & 1.2334E-02_JPRB,1.1886E-02_JPRB,1.1364E-02_JPRB,1.0806E-02_JPRB,1.0260E-02_JPRB/)  
KBO( :,22, 2) = (/&
 & 9.9375E-03_JPRB,9.5457E-03_JPRB,9.0943E-03_JPRB,8.6315E-03_JPRB,8.1875E-03_JPRB/)  
KBO( :,23, 2) = (/&
 & 8.0034E-03_JPRB,7.6569E-03_JPRB,7.2757E-03_JPRB,6.8952E-03_JPRB,6.5351E-03_JPRB/)  
KBO( :,24, 2) = (/&
 & 6.4644E-03_JPRB,6.1649E-03_JPRB,5.8474E-03_JPRB,5.5363E-03_JPRB,5.2447E-03_JPRB/)  
KBO( :,25, 2) = (/&
 & 5.2170E-03_JPRB,4.9615E-03_JPRB,4.6990E-03_JPRB,4.4463E-03_JPRB,4.2118E-03_JPRB/)  
KBO( :,26, 2) = (/&
 & 4.2078E-03_JPRB,3.9936E-03_JPRB,3.7782E-03_JPRB,3.5736E-03_JPRB,3.3867E-03_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB11:PART2',1,ZHOOK_HANDLE)
END SUBROUTINE PART2


SUBROUTINE PART3

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB11:PART3',0,ZHOOK_HANDLE)


KBO( :,27, 2) = (/&
 & 3.3923E-03_JPRB,3.2149E-03_JPRB,3.0399E-03_JPRB,2.8755E-03_JPRB,2.7265E-03_JPRB/)  
KBO( :,28, 2) = (/&
 & 2.7345E-03_JPRB,2.5888E-03_JPRB,2.4474E-03_JPRB,2.3159E-03_JPRB,2.1973E-03_JPRB/)  
KBO( :,29, 2) = (/&
 & 2.1927E-03_JPRB,2.0742E-03_JPRB,1.9609E-03_JPRB,1.8566E-03_JPRB,1.7629E-03_JPRB/)  
KBO( :,30, 2) = (/&
 & 1.7534E-03_JPRB,1.6577E-03_JPRB,1.5672E-03_JPRB,1.4849E-03_JPRB,1.4111E-03_JPRB/)  
KBO( :,31, 2) = (/&
 & 1.3923E-03_JPRB,1.3158E-03_JPRB,1.2442E-03_JPRB,1.1799E-03_JPRB,1.1222E-03_JPRB/)  
KBO( :,32, 2) = (/&
 & 1.1073E-03_JPRB,1.0463E-03_JPRB,9.9006E-04_JPRB,9.3956E-04_JPRB,8.9454E-04_JPRB/)  
KBO( :,33, 2) = (/&
 & 8.8168E-04_JPRB,8.3321E-04_JPRB,7.8903E-04_JPRB,7.4943E-04_JPRB,7.1437E-04_JPRB/)  
KBO( :,34, 2) = (/&
 & 7.0843E-04_JPRB,6.6985E-04_JPRB,6.3483E-04_JPRB,6.0356E-04_JPRB,5.7597E-04_JPRB/)  
KBO( :,35, 2) = (/&
 & 5.7335E-04_JPRB,5.4243E-04_JPRB,5.1437E-04_JPRB,4.8935E-04_JPRB,4.6731E-04_JPRB/)  
KBO( :,36, 2) = (/&
 & 4.6786E-04_JPRB,4.4279E-04_JPRB,4.2001E-04_JPRB,3.9969E-04_JPRB,3.8175E-04_JPRB/)  
KBO( :,37, 2) = (/&
 & 3.8722E-04_JPRB,3.6652E-04_JPRB,3.4765E-04_JPRB,3.3074E-04_JPRB,3.1577E-04_JPRB/)  
KBO( :,38, 2) = (/&
 & 3.2064E-04_JPRB,3.0358E-04_JPRB,2.8795E-04_JPRB,2.7387E-04_JPRB,2.6137E-04_JPRB/)  
KBO( :,39, 2) = (/&
 & 2.6542E-04_JPRB,2.5139E-04_JPRB,2.3846E-04_JPRB,2.2675E-04_JPRB,2.1632E-04_JPRB/)  
KBO( :,40, 2) = (/&
 & 2.2243E-04_JPRB,2.1077E-04_JPRB,1.9994E-04_JPRB,1.9003E-04_JPRB,1.8117E-04_JPRB/)  
KBO( :,41, 2) = (/&
 & 1.8662E-04_JPRB,1.7701E-04_JPRB,1.6793E-04_JPRB,1.5956E-04_JPRB,1.5202E-04_JPRB/)  
KBO( :,42, 2) = (/&
 & 1.5648E-04_JPRB,1.4863E-04_JPRB,1.4106E-04_JPRB,1.3402E-04_JPRB,1.2761E-04_JPRB/)  
KBO( :,43, 2) = (/&
 & 1.3212E-04_JPRB,1.2582E-04_JPRB,1.1952E-04_JPRB,1.1357E-04_JPRB,1.0810E-04_JPRB/)  
KBO( :,44, 2) = (/&
 & 1.1174E-04_JPRB,1.0680E-04_JPRB,1.0165E-04_JPRB,9.6663E-05_JPRB,9.2016E-05_JPRB/)  
KBO( :,45, 2) = (/&
 & 9.4238E-05_JPRB,9.0536E-05_JPRB,8.6432E-05_JPRB,8.2292E-05_JPRB,7.8367E-05_JPRB/)  
KBO( :,46, 2) = (/&
 & 7.9325E-05_JPRB,7.6718E-05_JPRB,7.3544E-05_JPRB,7.0182E-05_JPRB,6.6892E-05_JPRB/)  
KBO( :,47, 2) = (/&
 & 6.6879E-05_JPRB,6.4961E-05_JPRB,6.2686E-05_JPRB,6.0033E-05_JPRB,5.7320E-05_JPRB/)  
KBO( :,48, 2) = (/&
 & 5.6419E-05_JPRB,5.4793E-05_JPRB,5.3249E-05_JPRB,5.1268E-05_JPRB,4.9104E-05_JPRB/)  
KBO( :,49, 2) = (/&
 & 4.7582E-05_JPRB,4.6223E-05_JPRB,4.5008E-05_JPRB,4.3677E-05_JPRB,4.2007E-05_JPRB/)  
KBO( :,50, 2) = (/&
 & 4.0134E-05_JPRB,3.9021E-05_JPRB,3.7999E-05_JPRB,3.7054E-05_JPRB,3.5858E-05_JPRB/)  
KBO( :,51, 2) = (/&
 & 3.3881E-05_JPRB,3.2950E-05_JPRB,3.2114E-05_JPRB,3.1337E-05_JPRB,3.0540E-05_JPRB/)  
KBO( :,52, 2) = (/&
 & 2.8622E-05_JPRB,2.7826E-05_JPRB,2.7144E-05_JPRB,2.6512E-05_JPRB,2.5904E-05_JPRB/)  
KBO( :,53, 2) = (/&
 & 2.4202E-05_JPRB,2.3517E-05_JPRB,2.2936E-05_JPRB,2.2437E-05_JPRB,2.1946E-05_JPRB/)  
KBO( :,54, 2) = (/&
 & 2.0552E-05_JPRB,1.9947E-05_JPRB,1.9446E-05_JPRB,1.9029E-05_JPRB,1.8643E-05_JPRB/)  
KBO( :,55, 2) = (/&
 & 1.7521E-05_JPRB,1.6983E-05_JPRB,1.6547E-05_JPRB,1.6182E-05_JPRB,1.5869E-05_JPRB/)  
KBO( :,56, 2) = (/&
 & 1.4964E-05_JPRB,1.4501E-05_JPRB,1.4113E-05_JPRB,1.3797E-05_JPRB,1.3531E-05_JPRB/)  
KBO( :,57, 2) = (/&
 & 1.2786E-05_JPRB,1.2428E-05_JPRB,1.2073E-05_JPRB,1.1795E-05_JPRB,1.1567E-05_JPRB/)  
KBO( :,58, 2) = (/&
 & 1.0926E-05_JPRB,1.0676E-05_JPRB,1.0370E-05_JPRB,1.0111E-05_JPRB,9.9144E-06_JPRB/)  
KBO( :,59, 2) = (/&
 & 9.3343E-06_JPRB,9.1398E-06_JPRB,8.8844E-06_JPRB,8.6525E-06_JPRB,8.4760E-06_JPRB/)  
KBO( :,13, 3) = (/&
 & 1.1578E-01_JPRB,1.0716E-01_JPRB,9.8800E-02_JPRB,9.1233E-02_JPRB,8.4552E-02_JPRB/)  
KBO( :,14, 3) = (/&
 & 9.6358E-02_JPRB,8.8872E-02_JPRB,8.1796E-02_JPRB,7.5462E-02_JPRB,6.9923E-02_JPRB/)  
KBO( :,15, 3) = (/&
 & 7.7679E-02_JPRB,7.1362E-02_JPRB,6.5590E-02_JPRB,6.0478E-02_JPRB,5.6079E-02_JPRB/)  
KBO( :,16, 3) = (/&
 & 6.1300E-02_JPRB,5.6180E-02_JPRB,5.1590E-02_JPRB,4.7554E-02_JPRB,4.4239E-02_JPRB/)  
KBO( :,17, 3) = (/&
 & 4.8045E-02_JPRB,4.3962E-02_JPRB,4.0343E-02_JPRB,3.7246E-02_JPRB,3.4805E-02_JPRB/)  
KBO( :,18, 3) = (/&
 & 3.7178E-02_JPRB,3.3974E-02_JPRB,3.1173E-02_JPRB,2.8927E-02_JPRB,2.7155E-02_JPRB/)  
KBO( :,19, 3) = (/&
 & 2.9119E-02_JPRB,2.6589E-02_JPRB,2.4456E-02_JPRB,2.2801E-02_JPRB,2.1476E-02_JPRB/)  
KBO( :,20, 3) = (/&
 & 2.3060E-02_JPRB,2.1055E-02_JPRB,1.9446E-02_JPRB,1.8194E-02_JPRB,1.7172E-02_JPRB/)  
KBO( :,21, 3) = (/&
 & 1.8331E-02_JPRB,1.6763E-02_JPRB,1.5542E-02_JPRB,1.4585E-02_JPRB,1.3783E-02_JPRB/)  
KBO( :,22, 3) = (/&
 & 1.4479E-02_JPRB,1.3291E-02_JPRB,1.2379E-02_JPRB,1.1652E-02_JPRB,1.1027E-02_JPRB/)  
KBO( :,23, 3) = (/&
 & 1.1453E-02_JPRB,1.0564E-02_JPRB,9.8785E-03_JPRB,9.3186E-03_JPRB,8.8332E-03_JPRB/)  
KBO( :,24, 3) = (/&
 & 9.1256E-03_JPRB,8.4545E-03_JPRB,7.9319E-03_JPRB,7.4939E-03_JPRB,7.1141E-03_JPRB/)  
KBO( :,25, 3) = (/&
 & 7.2833E-03_JPRB,6.7767E-03_JPRB,6.3758E-03_JPRB,6.0322E-03_JPRB,5.7344E-03_JPRB/)  
KBO( :,26, 3) = (/&
 & 5.8255E-03_JPRB,5.4418E-03_JPRB,5.1312E-03_JPRB,4.8611E-03_JPRB,4.6284E-03_JPRB/)  
KBO( :,27, 3) = (/&
 & 4.6693E-03_JPRB,4.3763E-03_JPRB,4.1328E-03_JPRB,3.9209E-03_JPRB,3.7392E-03_JPRB/)  
KBO( :,28, 3) = (/&
 & 3.7489E-03_JPRB,3.5232E-03_JPRB,3.3314E-03_JPRB,3.1652E-03_JPRB,3.0230E-03_JPRB/)  
KBO( :,29, 3) = (/&
 & 2.9982E-03_JPRB,2.8244E-03_JPRB,2.6743E-03_JPRB,2.5451E-03_JPRB,2.4345E-03_JPRB/)  
KBO( :,30, 3) = (/&
 & 2.3941E-03_JPRB,2.2596E-03_JPRB,2.1432E-03_JPRB,2.0432E-03_JPRB,1.9574E-03_JPRB/)  
KBO( :,31, 3) = (/&
 & 1.9015E-03_JPRB,1.7982E-03_JPRB,1.7086E-03_JPRB,1.6320E-03_JPRB,1.5660E-03_JPRB/)  
KBO( :,32, 3) = (/&
 & 1.5140E-03_JPRB,1.4341E-03_JPRB,1.3651E-03_JPRB,1.3063E-03_JPRB,1.2555E-03_JPRB/)  
KBO( :,33, 3) = (/&
 & 1.2075E-03_JPRB,1.1458E-03_JPRB,1.0928E-03_JPRB,1.0474E-03_JPRB,1.0084E-03_JPRB/)  
KBO( :,34, 3) = (/&
 & 9.7167E-04_JPRB,9.2329E-04_JPRB,8.8190E-04_JPRB,8.4640E-04_JPRB,8.1606E-04_JPRB/)  
KBO( :,35, 3) = (/&
 & 7.8747E-04_JPRB,7.4887E-04_JPRB,7.1595E-04_JPRB,6.8779E-04_JPRB,6.6369E-04_JPRB/)  
KBO( :,36, 3) = (/&
 & 6.4309E-04_JPRB,6.1175E-04_JPRB,5.8503E-04_JPRB,5.6224E-04_JPRB,5.4265E-04_JPRB/)  
KBO( :,37, 3) = (/&
 & 5.3206E-04_JPRB,5.0587E-04_JPRB,4.8341E-04_JPRB,4.6439E-04_JPRB,4.4794E-04_JPRB/)  
KBO( :,38, 3) = (/&
 & 4.4053E-04_JPRB,4.1858E-04_JPRB,3.9969E-04_JPRB,3.8376E-04_JPRB,3.6993E-04_JPRB/)  
KBO( :,39, 3) = (/&
 & 3.6472E-04_JPRB,3.4631E-04_JPRB,3.3044E-04_JPRB,3.1709E-04_JPRB,3.0547E-04_JPRB/)  
KBO( :,40, 3) = (/&
 & 3.0560E-04_JPRB,2.8982E-04_JPRB,2.7615E-04_JPRB,2.6461E-04_JPRB,2.5462E-04_JPRB/)  
KBO( :,41, 3) = (/&
 & 2.5670E-04_JPRB,2.4305E-04_JPRB,2.3127E-04_JPRB,2.2125E-04_JPRB,2.1263E-04_JPRB/)  
KBO( :,42, 3) = (/&
 & 2.1586E-04_JPRB,2.0401E-04_JPRB,1.9383E-04_JPRB,1.8512E-04_JPRB,1.7766E-04_JPRB/)  
KBO( :,43, 3) = (/&
 & 1.8349E-04_JPRB,1.7278E-04_JPRB,1.6384E-04_JPRB,1.5615E-04_JPRB,1.4957E-04_JPRB/)  
KBO( :,44, 3) = (/&
 & 1.5716E-04_JPRB,1.4719E-04_JPRB,1.3923E-04_JPRB,1.3237E-04_JPRB,1.2650E-04_JPRB/)  
KBO( :,45, 3) = (/&
 & 1.3523E-04_JPRB,1.2581E-04_JPRB,1.1854E-04_JPRB,1.1244E-04_JPRB,1.0719E-04_JPRB/)  
KBO( :,46, 3) = (/&
 & 1.1723E-04_JPRB,1.0821E-04_JPRB,1.0137E-04_JPRB,9.5892E-05_JPRB,9.1160E-05_JPRB/)  
KBO( :,47, 3) = (/&
 & 1.0246E-04_JPRB,9.4070E-05_JPRB,8.7415E-05_JPRB,8.2283E-05_JPRB,7.8012E-05_JPRB/)  
KBO( :,48, 3) = (/&
 & 8.9698E-05_JPRB,8.2247E-05_JPRB,7.5847E-05_JPRB,7.0891E-05_JPRB,6.6960E-05_JPRB/)  
KBO( :,49, 3) = (/&
 & 7.8632E-05_JPRB,7.2058E-05_JPRB,6.6260E-05_JPRB,6.1415E-05_JPRB,5.7680E-05_JPRB/)  
KBO( :,50, 3) = (/&
 & 6.8816E-05_JPRB,6.3112E-05_JPRB,5.7964E-05_JPRB,5.3476E-05_JPRB,4.9851E-05_JPRB/)  
KBO( :,51, 3) = (/&
 & 6.0093E-05_JPRB,5.5311E-05_JPRB,5.0781E-05_JPRB,4.6782E-05_JPRB,4.3320E-05_JPRB/)  
KBO( :,52, 3) = (/&
 & 5.2290E-05_JPRB,4.8493E-05_JPRB,4.4587E-05_JPRB,4.1036E-05_JPRB,3.7908E-05_JPRB/)  
KBO( :,53, 3) = (/&
 & 4.5363E-05_JPRB,4.2435E-05_JPRB,3.9221E-05_JPRB,3.6100E-05_JPRB,3.3314E-05_JPRB/)  
KBO( :,54, 3) = (/&
 & 3.9232E-05_JPRB,3.6987E-05_JPRB,3.4457E-05_JPRB,3.1794E-05_JPRB,2.9324E-05_JPRB/)  
KBO( :,55, 3) = (/&
 & 3.3909E-05_JPRB,3.2196E-05_JPRB,3.0223E-05_JPRB,2.8046E-05_JPRB,2.5889E-05_JPRB/)  
KBO( :,56, 3) = (/&
 & 2.9375E-05_JPRB,2.7990E-05_JPRB,2.6480E-05_JPRB,2.4756E-05_JPRB,2.2937E-05_JPRB/)  
KBO( :,57, 3) = (/&
 & 2.5600E-05_JPRB,2.4324E-05_JPRB,2.3181E-05_JPRB,2.1853E-05_JPRB,2.0369E-05_JPRB/)  
KBO( :,58, 3) = (/&
 & 2.2451E-05_JPRB,2.1215E-05_JPRB,2.0255E-05_JPRB,1.9251E-05_JPRB,1.8079E-05_JPRB/)  
KBO( :,59, 3) = (/&
 & 1.9440E-05_JPRB,1.8313E-05_JPRB,1.7459E-05_JPRB,1.6654E-05_JPRB,1.5711E-05_JPRB/)  
KBO( :,13, 4) = (/&
 & 1.4696E-01_JPRB,1.3536E-01_JPRB,1.2591E-01_JPRB,1.1779E-01_JPRB,1.1082E-01_JPRB/)  
KBO( :,14, 4) = (/&
 & 1.2236E-01_JPRB,1.1293E-01_JPRB,1.0507E-01_JPRB,9.8308E-02_JPRB,9.2452E-02_JPRB/)  
KBO( :,15, 4) = (/&
 & 9.8855E-02_JPRB,9.1490E-02_JPRB,8.5185E-02_JPRB,7.9782E-02_JPRB,7.5090E-02_JPRB/)  
KBO( :,16, 4) = (/&
 & 7.8479E-02_JPRB,7.2784E-02_JPRB,6.7904E-02_JPRB,6.3672E-02_JPRB,6.0007E-02_JPRB/)  
KBO( :,17, 4) = (/&
 & 6.2026E-02_JPRB,5.7636E-02_JPRB,5.3869E-02_JPRB,5.0578E-02_JPRB,4.7744E-02_JPRB/)  
KBO( :,18, 4) = (/&
 & 4.8533E-02_JPRB,4.5221E-02_JPRB,4.2336E-02_JPRB,3.9824E-02_JPRB,3.7663E-02_JPRB/)  
KBO( :,19, 4) = (/&
 & 3.8437E-02_JPRB,3.5877E-02_JPRB,3.3631E-02_JPRB,3.1685E-02_JPRB,3.0017E-02_JPRB/)  
KBO( :,20, 4) = (/&
 & 3.0742E-02_JPRB,2.8726E-02_JPRB,2.6959E-02_JPRB,2.5432E-02_JPRB,2.4138E-02_JPRB/)  
KBO( :,21, 4) = (/&
 & 2.4672E-02_JPRB,2.3073E-02_JPRB,2.1679E-02_JPRB,2.0477E-02_JPRB,1.9477E-02_JPRB/)  
KBO( :,22, 4) = (/&
 & 1.9706E-02_JPRB,1.8455E-02_JPRB,1.7366E-02_JPRB,1.6436E-02_JPRB,1.5677E-02_JPRB/)  
KBO( :,23, 4) = (/&
 & 1.5753E-02_JPRB,1.4774E-02_JPRB,1.3923E-02_JPRB,1.3212E-02_JPRB,1.2632E-02_JPRB/)  
KBO( :,24, 4) = (/&
 & 1.2655E-02_JPRB,1.1885E-02_JPRB,1.1219E-02_JPRB,1.0672E-02_JPRB,1.0225E-02_JPRB/)  
KBO( :,25, 4) = (/&
 & 1.0171E-02_JPRB,9.5654E-03_JPRB,9.0480E-03_JPRB,8.6282E-03_JPRB,8.2836E-03_JPRB/)  
KBO( :,26, 4) = (/&
 & 8.1813E-03_JPRB,7.7056E-03_JPRB,7.3062E-03_JPRB,6.9847E-03_JPRB,6.7168E-03_JPRB/)  
KBO( :,27, 4) = (/&
 & 6.5848E-03_JPRB,6.2128E-03_JPRB,5.9057E-03_JPRB,5.6577E-03_JPRB,5.4495E-03_JPRB/)  
KBO( :,28, 4) = (/&
 & 5.3033E-03_JPRB,5.0131E-03_JPRB,4.7776E-03_JPRB,4.5851E-03_JPRB,4.4243E-03_JPRB/)  
KBO( :,29, 4) = (/&
 & 4.2539E-03_JPRB,4.0307E-03_JPRB,3.8512E-03_JPRB,3.7034E-03_JPRB,3.5804E-03_JPRB/)  
KBO( :,30, 4) = (/&
 & 3.4070E-03_JPRB,3.2374E-03_JPRB,3.1007E-03_JPRB,2.9878E-03_JPRB,2.8943E-03_JPRB/)  
KBO( :,31, 4) = (/&
 & 2.7164E-03_JPRB,2.5892E-03_JPRB,2.4867E-03_JPRB,2.4014E-03_JPRB,2.3318E-03_JPRB/)  
KBO( :,32, 4) = (/&
 & 2.1714E-03_JPRB,2.0763E-03_JPRB,1.9989E-03_JPRB,1.9347E-03_JPRB,1.8824E-03_JPRB/)  
KBO( :,33, 4) = (/&
 & 1.7396E-03_JPRB,1.6683E-03_JPRB,1.6097E-03_JPRB,1.5614E-03_JPRB,1.5217E-03_JPRB/)  
KBO( :,34, 4) = (/&
 & 1.4048E-03_JPRB,1.3500E-03_JPRB,1.3048E-03_JPRB,1.2676E-03_JPRB,1.2371E-03_JPRB/)  
KBO( :,35, 4) = (/&
 & 1.1411E-03_JPRB,1.0980E-03_JPRB,1.0625E-03_JPRB,1.0331E-03_JPRB,1.0094E-03_JPRB/)  
KBO( :,36, 4) = (/&
 & 9.3251E-04_JPRB,8.9778E-04_JPRB,8.6918E-04_JPRB,8.4547E-04_JPRB,8.2657E-04_JPRB/)  
KBO( :,37, 4) = (/&
 & 7.7030E-04_JPRB,7.4111E-04_JPRB,7.1717E-04_JPRB,6.9726E-04_JPRB,6.8147E-04_JPRB/)  
KBO( :,38, 4) = (/&
 & 6.3669E-04_JPRB,6.1205E-04_JPRB,5.9195E-04_JPRB,5.7523E-04_JPRB,5.6199E-04_JPRB/)  
KBO( :,39, 4) = (/&
 & 5.2623E-04_JPRB,5.0538E-04_JPRB,4.8849E-04_JPRB,4.7446E-04_JPRB,4.6332E-04_JPRB/)  
KBO( :,40, 4) = (/&
 & 4.3959E-04_JPRB,4.2119E-04_JPRB,4.0652E-04_JPRB,3.9437E-04_JPRB,3.8468E-04_JPRB/)  
KBO( :,41, 4) = (/&
 & 3.6806E-04_JPRB,3.5172E-04_JPRB,3.3885E-04_JPRB,3.2829E-04_JPRB,3.1983E-04_JPRB/)  
KBO( :,42, 4) = (/&
 & 3.0846E-04_JPRB,2.9396E-04_JPRB,2.8262E-04_JPRB,2.7343E-04_JPRB,2.6601E-04_JPRB/)  
KBO( :,43, 4) = (/&
 & 2.6070E-04_JPRB,2.4764E-04_JPRB,2.3730E-04_JPRB,2.2909E-04_JPRB,2.2243E-04_JPRB/)  
KBO( :,44, 4) = (/&
 & 2.2145E-04_JPRB,2.0973E-04_JPRB,2.0015E-04_JPRB,1.9268E-04_JPRB,1.8663E-04_JPRB/)  
KBO( :,45, 4) = (/&
 & 1.8844E-04_JPRB,1.7798E-04_JPRB,1.6924E-04_JPRB,1.6233E-04_JPRB,1.5683E-04_JPRB/)  
KBO( :,46, 4) = (/&
 & 1.6102E-04_JPRB,1.5165E-04_JPRB,1.4374E-04_JPRB,1.3727E-04_JPRB,1.3220E-04_JPRB/)  
KBO( :,47, 4) = (/&
 & 1.3849E-04_JPRB,1.3004E-04_JPRB,1.2284E-04_JPRB,1.1682E-04_JPRB,1.1200E-04_JPRB/)  
KBO( :,48, 4) = (/&
 & 1.1939E-04_JPRB,1.1184E-04_JPRB,1.0528E-04_JPRB,9.9774E-05_JPRB,9.5200E-05_JPRB/)  
KBO( :,49, 4) = (/&
 & 1.0325E-04_JPRB,9.6448E-05_JPRB,9.0509E-05_JPRB,8.5480E-05_JPRB,8.1243E-05_JPRB/)  
KBO( :,50, 4) = (/&
 & 8.9502E-05_JPRB,8.3289E-05_JPRB,7.8000E-05_JPRB,7.3411E-05_JPRB,6.9545E-05_JPRB/)  
KBO( :,51, 4) = (/&
 & 7.7885E-05_JPRB,7.2170E-05_JPRB,6.7387E-05_JPRB,6.3245E-05_JPRB,5.9716E-05_JPRB/)  
KBO( :,52, 4) = (/&
 & 6.8289E-05_JPRB,6.2790E-05_JPRB,5.8412E-05_JPRB,5.4691E-05_JPRB,5.1470E-05_JPRB/)  
KBO( :,53, 4) = (/&
 & 6.0379E-05_JPRB,5.4962E-05_JPRB,5.0864E-05_JPRB,4.7466E-05_JPRB,4.4555E-05_JPRB/)  
KBO( :,54, 4) = (/&
 & 5.3778E-05_JPRB,4.8463E-05_JPRB,4.4464E-05_JPRB,4.1340E-05_JPRB,3.8702E-05_JPRB/)  
KBO( :,55, 4) = (/&
 & 4.8218E-05_JPRB,4.3063E-05_JPRB,3.9148E-05_JPRB,3.6179E-05_JPRB,3.3764E-05_JPRB/)  
KBO( :,56, 4) = (/&
 & 4.3470E-05_JPRB,3.8635E-05_JPRB,3.4783E-05_JPRB,3.1873E-05_JPRB,2.9614E-05_JPRB/)  
KBO( :,57, 4) = (/&
 & 3.9310E-05_JPRB,3.4974E-05_JPRB,3.1231E-05_JPRB,2.8344E-05_JPRB,2.6153E-05_JPRB/)  
KBO( :,58, 4) = (/&
 & 3.5464E-05_JPRB,3.1728E-05_JPRB,2.8260E-05_JPRB,2.5410E-05_JPRB,2.3248E-05_JPRB/)  
KBO( :,59, 4) = (/&
 & 3.1043E-05_JPRB,2.7897E-05_JPRB,2.4869E-05_JPRB,2.2274E-05_JPRB,2.0279E-05_JPRB/)  
KBO( :,13, 5) = (/&
 & 2.0037E-01_JPRB,1.8536E-01_JPRB,1.7319E-01_JPRB,1.6345E-01_JPRB,1.5565E-01_JPRB/)  
KBO( :,14, 5) = (/&
 & 1.6811E-01_JPRB,1.5583E-01_JPRB,1.4603E-01_JPRB,1.3819E-01_JPRB,1.3191E-01_JPRB/)  
KBO( :,15, 5) = (/&
 & 1.3720E-01_JPRB,1.2762E-01_JPRB,1.2008E-01_JPRB,1.1403E-01_JPRB,1.0921E-01_JPRB/)  
KBO( :,16, 5) = (/&
 & 1.0988E-01_JPRB,1.0274E-01_JPRB,9.7095E-02_JPRB,9.2609E-02_JPRB,8.9031E-02_JPRB/)  
KBO( :,17, 5) = (/&
 & 8.7687E-02_JPRB,8.2411E-02_JPRB,7.8231E-02_JPRB,7.4955E-02_JPRB,7.2265E-02_JPRB/)  
KBO( :,18, 5) = (/&
 & 6.9546E-02_JPRB,6.5690E-02_JPRB,6.2692E-02_JPRB,6.0308E-02_JPRB,5.8300E-02_JPRB/)  
KBO( :,19, 5) = (/&
 & 5.5764E-02_JPRB,5.2922E-02_JPRB,5.0726E-02_JPRB,4.8917E-02_JPRB,4.7401E-02_JPRB/)  
KBO( :,20, 5) = (/&
 & 4.5060E-02_JPRB,4.2954E-02_JPRB,4.1283E-02_JPRB,3.9887E-02_JPRB,3.8724E-02_JPRB/)  
KBO( :,21, 5) = (/&
 & 3.6528E-02_JPRB,3.4947E-02_JPRB,3.3647E-02_JPRB,3.2572E-02_JPRB,3.1670E-02_JPRB/)  
KBO( :,22, 5) = (/&
 & 2.9537E-02_JPRB,2.8342E-02_JPRB,2.7350E-02_JPRB,2.6530E-02_JPRB,2.5834E-02_JPRB/)  
KBO( :,23, 5) = (/&
 & 2.3912E-02_JPRB,2.2997E-02_JPRB,2.2244E-02_JPRB,2.1612E-02_JPRB,2.1080E-02_JPRB/)  
KBO( :,24, 5) = (/&
 & 1.9429E-02_JPRB,1.8726E-02_JPRB,1.8145E-02_JPRB,1.7658E-02_JPRB,1.7246E-02_JPRB/)  
KBO( :,25, 5) = (/&
 & 1.5792E-02_JPRB,1.5254E-02_JPRB,1.4806E-02_JPRB,1.4430E-02_JPRB,1.4113E-02_JPRB/)  
KBO( :,26, 5) = (/&
 & 1.2845E-02_JPRB,1.2431E-02_JPRB,1.2086E-02_JPRB,1.1796E-02_JPRB,1.1555E-02_JPRB/)  
KBO( :,27, 5) = (/&
 & 1.0446E-02_JPRB,1.0127E-02_JPRB,9.8617E-03_JPRB,9.6396E-03_JPRB,9.4551E-03_JPRB/)  
KBO( :,28, 5) = (/&
 & 8.4938E-03_JPRB,8.2489E-03_JPRB,8.0449E-03_JPRB,7.8756E-03_JPRB,7.7339E-03_JPRB/)  
KBO( :,29, 5) = (/&
 & 6.8810E-03_JPRB,6.6955E-03_JPRB,6.5403E-03_JPRB,6.4124E-03_JPRB,6.3046E-03_JPRB/)  
KBO( :,30, 5) = (/&
 & 5.5679E-03_JPRB,5.4274E-03_JPRB,5.3105E-03_JPRB,5.2139E-03_JPRB,5.1338E-03_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB11:PART3',1,ZHOOK_HANDLE)
END SUBROUTINE PART3


SUBROUTINE PART4

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB11:PART4',0,ZHOOK_HANDLE)


KBO( :,31, 5) = (/&
 & 4.4884E-03_JPRB,4.3834E-03_JPRB,4.2967E-03_JPRB,4.2249E-03_JPRB,4.1673E-03_JPRB/)  
KBO( :,32, 5) = (/&
 & 3.6233E-03_JPRB,3.5452E-03_JPRB,3.4808E-03_JPRB,3.4277E-03_JPRB,3.3868E-03_JPRB/)  
KBO( :,33, 5) = (/&
 & 2.9282E-03_JPRB,2.8695E-03_JPRB,2.8214E-03_JPRB,2.7830E-03_JPRB,2.7552E-03_JPRB/)  
KBO( :,34, 5) = (/&
 & 2.3787E-03_JPRB,2.3339E-03_JPRB,2.2982E-03_JPRB,2.2711E-03_JPRB,2.2512E-03_JPRB/)  
KBO( :,35, 5) = (/&
 & 1.9384E-03_JPRB,1.9039E-03_JPRB,1.8770E-03_JPRB,1.8573E-03_JPRB,1.8425E-03_JPRB/)  
KBO( :,36, 5) = (/&
 & 1.5850E-03_JPRB,1.5579E-03_JPRB,1.5371E-03_JPRB,1.5221E-03_JPRB,1.5109E-03_JPRB/)  
KBO( :,37, 5) = (/&
 & 1.3051E-03_JPRB,1.2827E-03_JPRB,1.2657E-03_JPRB,1.2537E-03_JPRB,1.2449E-03_JPRB/)  
KBO( :,38, 5) = (/&
 & 1.0746E-03_JPRB,1.0560E-03_JPRB,1.0422E-03_JPRB,1.0325E-03_JPRB,1.0256E-03_JPRB/)  
KBO( :,39, 5) = (/&
 & 8.8434E-04_JPRB,8.6898E-04_JPRB,8.5778E-04_JPRB,8.4994E-04_JPRB,8.4447E-04_JPRB/)  
KBO( :,40, 5) = (/&
 & 7.3292E-04_JPRB,7.1976E-04_JPRB,7.1015E-04_JPRB,7.0344E-04_JPRB,6.9883E-04_JPRB/)  
KBO( :,41, 5) = (/&
 & 6.0814E-04_JPRB,5.9676E-04_JPRB,5.8842E-04_JPRB,5.8265E-04_JPRB,5.7869E-04_JPRB/)  
KBO( :,42, 5) = (/&
 & 5.0473E-04_JPRB,4.9486E-04_JPRB,4.8758E-04_JPRB,4.8259E-04_JPRB,4.7917E-04_JPRB/)  
KBO( :,43, 5) = (/&
 & 4.2073E-04_JPRB,4.1190E-04_JPRB,4.0535E-04_JPRB,4.0084E-04_JPRB,3.9773E-04_JPRB/)  
KBO( :,44, 5) = (/&
 & 3.5172E-04_JPRB,3.4367E-04_JPRB,3.3767E-04_JPRB,3.3350E-04_JPRB,3.3063E-04_JPRB/)  
KBO( :,45, 5) = (/&
 & 2.9444E-04_JPRB,2.8703E-04_JPRB,2.8150E-04_JPRB,2.7764E-04_JPRB,2.7498E-04_JPRB/)  
KBO( :,46, 5) = (/&
 & 2.4727E-04_JPRB,2.4031E-04_JPRB,2.3512E-04_JPRB,2.3150E-04_JPRB,2.2899E-04_JPRB/)  
KBO( :,47, 5) = (/&
 & 2.0882E-04_JPRB,2.0207E-04_JPRB,1.9709E-04_JPRB,1.9359E-04_JPRB,1.9119E-04_JPRB/)  
KBO( :,48, 5) = (/&
 & 1.7704E-04_JPRB,1.7038E-04_JPRB,1.6557E-04_JPRB,1.6214E-04_JPRB,1.5982E-04_JPRB/)  
KBO( :,49, 5) = (/&
 & 1.5080E-04_JPRB,1.4420E-04_JPRB,1.3945E-04_JPRB,1.3608E-04_JPRB,1.3379E-04_JPRB/)  
KBO( :,50, 5) = (/&
 & 1.2911E-04_JPRB,1.2261E-04_JPRB,1.1789E-04_JPRB,1.1456E-04_JPRB,1.1230E-04_JPRB/)  
KBO( :,51, 5) = (/&
 & 1.1123E-04_JPRB,1.0476E-04_JPRB,1.0009E-04_JPRB,9.6777E-05_JPRB,9.4528E-05_JPRB/)  
KBO( :,52, 5) = (/&
 & 9.6410E-05_JPRB,9.0064E-05_JPRB,8.5407E-05_JPRB,8.2070E-05_JPRB,7.9798E-05_JPRB/)  
KBO( :,53, 5) = (/&
 & 8.4067E-05_JPRB,7.7964E-05_JPRB,7.3302E-05_JPRB,6.9956E-05_JPRB,6.7619E-05_JPRB/)  
KBO( :,54, 5) = (/&
 & 7.3546E-05_JPRB,6.7856E-05_JPRB,6.3334E-05_JPRB,5.9970E-05_JPRB,5.7596E-05_JPRB/)  
KBO( :,55, 5) = (/&
 & 6.4676E-05_JPRB,5.9391E-05_JPRB,5.5074E-05_JPRB,5.1740E-05_JPRB,4.9340E-05_JPRB/)  
KBO( :,56, 5) = (/&
 & 5.7222E-05_JPRB,5.2288E-05_JPRB,4.8229E-05_JPRB,4.4985E-05_JPRB,4.2543E-05_JPRB/)  
KBO( :,57, 5) = (/&
 & 5.0943E-05_JPRB,4.6360E-05_JPRB,4.2538E-05_JPRB,3.9423E-05_JPRB,3.6983E-05_JPRB/)  
KBO( :,58, 5) = (/&
 & 4.5636E-05_JPRB,4.1296E-05_JPRB,3.7718E-05_JPRB,3.4778E-05_JPRB,3.2393E-05_JPRB/)  
KBO( :,59, 5) = (/&
 & 3.9918E-05_JPRB,3.5967E-05_JPRB,3.2789E-05_JPRB,3.0147E-05_JPRB,2.7981E-05_JPRB/)  
KBO( :,13, 6) = (/&
 & 3.0031E-01_JPRB,2.8877E-01_JPRB,2.7889E-01_JPRB,2.7050E-01_JPRB,2.6327E-01_JPRB/)  
KBO( :,14, 6) = (/&
 & 2.5567E-01_JPRB,2.4634E-01_JPRB,2.3843E-01_JPRB,2.3160E-01_JPRB,2.2574E-01_JPRB/)  
KBO( :,15, 6) = (/&
 & 2.1660E-01_JPRB,2.0921E-01_JPRB,2.0286E-01_JPRB,1.9734E-01_JPRB,1.9258E-01_JPRB/)  
KBO( :,16, 6) = (/&
 & 1.7950E-01_JPRB,1.7370E-01_JPRB,1.6867E-01_JPRB,1.6432E-01_JPRB,1.6061E-01_JPRB/)  
KBO( :,17, 6) = (/&
 & 1.4767E-01_JPRB,1.4318E-01_JPRB,1.3929E-01_JPRB,1.3594E-01_JPRB,1.3314E-01_JPRB/)  
KBO( :,18, 6) = (/&
 & 1.2067E-01_JPRB,1.1726E-01_JPRB,1.1432E-01_JPRB,1.1181E-01_JPRB,1.0970E-01_JPRB/)  
KBO( :,19, 6) = (/&
 & 9.9158E-02_JPRB,9.6553E-02_JPRB,9.4280E-02_JPRB,9.2392E-02_JPRB,9.0731E-02_JPRB/)  
KBO( :,20, 6) = (/&
 & 8.1605E-02_JPRB,7.9577E-02_JPRB,7.7850E-02_JPRB,7.6412E-02_JPRB,7.5067E-02_JPRB/)  
KBO( :,21, 6) = (/&
 & 6.7154E-02_JPRB,6.5582E-02_JPRB,6.4294E-02_JPRB,6.3166E-02_JPRB,6.2094E-02_JPRB/)  
KBO( :,22, 6) = (/&
 & 5.5082E-02_JPRB,5.3919E-02_JPRB,5.2957E-02_JPRB,5.2061E-02_JPRB,5.1235E-02_JPRB/)  
KBO( :,23, 6) = (/&
 & 4.5194E-02_JPRB,4.4345E-02_JPRB,4.3595E-02_JPRB,4.2898E-02_JPRB,4.2263E-02_JPRB/)  
KBO( :,24, 6) = (/&
 & 3.7185E-02_JPRB,3.6539E-02_JPRB,3.5952E-02_JPRB,3.5414E-02_JPRB,3.4913E-02_JPRB/)  
KBO( :,25, 6) = (/&
 & 3.0590E-02_JPRB,3.0087E-02_JPRB,2.9634E-02_JPRB,2.9216E-02_JPRB,2.8826E-02_JPRB/)  
KBO( :,26, 6) = (/&
 & 2.5152E-02_JPRB,2.4764E-02_JPRB,2.4418E-02_JPRB,2.4095E-02_JPRB,2.3796E-02_JPRB/)  
KBO( :,27, 6) = (/&
 & 2.0643E-02_JPRB,2.0349E-02_JPRB,2.0083E-02_JPRB,1.9833E-02_JPRB,1.9610E-02_JPRB/)  
KBO( :,28, 6) = (/&
 & 1.6922E-02_JPRB,1.6700E-02_JPRB,1.6497E-02_JPRB,1.6309E-02_JPRB,1.6143E-02_JPRB/)  
KBO( :,29, 6) = (/&
 & 1.3806E-02_JPRB,1.3641E-02_JPRB,1.3490E-02_JPRB,1.3350E-02_JPRB,1.3233E-02_JPRB/)  
KBO( :,30, 6) = (/&
 & 1.1246E-02_JPRB,1.1125E-02_JPRB,1.1013E-02_JPRB,1.0912E-02_JPRB,1.0833E-02_JPRB/)  
KBO( :,31, 6) = (/&
 & 9.1223E-03_JPRB,9.0371E-03_JPRB,8.9562E-03_JPRB,8.8890E-03_JPRB,8.8381E-03_JPRB/)  
KBO( :,32, 6) = (/&
 & 7.4088E-03_JPRB,7.3486E-03_JPRB,7.2922E-03_JPRB,7.2503E-03_JPRB,7.2208E-03_JPRB/)  
KBO( :,33, 6) = (/&
 & 6.0213E-03_JPRB,5.9797E-03_JPRB,5.9439E-03_JPRB,5.9193E-03_JPRB,5.9059E-03_JPRB/)  
KBO( :,34, 6) = (/&
 & 4.9171E-03_JPRB,4.8889E-03_JPRB,4.8670E-03_JPRB,4.8546E-03_JPRB,4.8528E-03_JPRB/)  
KBO( :,35, 6) = (/&
 & 4.0228E-03_JPRB,4.0047E-03_JPRB,3.9922E-03_JPRB,3.9878E-03_JPRB,3.9938E-03_JPRB/)  
KBO( :,36, 6) = (/&
 & 3.2970E-03_JPRB,3.2861E-03_JPRB,3.2797E-03_JPRB,3.2811E-03_JPRB,3.2916E-03_JPRB/)  
KBO( :,37, 6) = (/&
 & 2.7162E-03_JPRB,2.7102E-03_JPRB,2.7075E-03_JPRB,2.7117E-03_JPRB,2.7239E-03_JPRB/)  
KBO( :,38, 6) = (/&
 & 2.2373E-03_JPRB,2.2347E-03_JPRB,2.2349E-03_JPRB,2.2411E-03_JPRB,2.2537E-03_JPRB/)  
KBO( :,39, 6) = (/&
 & 1.8417E-03_JPRB,1.8418E-03_JPRB,1.8441E-03_JPRB,1.8517E-03_JPRB,1.8647E-03_JPRB/)  
KBO( :,40, 6) = (/&
 & 1.5238E-03_JPRB,1.5254E-03_JPRB,1.5285E-03_JPRB,1.5359E-03_JPRB,1.5481E-03_JPRB/)  
KBO( :,41, 6) = (/&
 & 1.2613E-03_JPRB,1.2638E-03_JPRB,1.2673E-03_JPRB,1.2744E-03_JPRB,1.2856E-03_JPRB/)  
KBO( :,42, 6) = (/&
 & 1.0436E-03_JPRB,1.0466E-03_JPRB,1.0504E-03_JPRB,1.0571E-03_JPRB,1.0674E-03_JPRB/)  
KBO( :,43, 6) = (/&
 & 8.6452E-04_JPRB,8.6761E-04_JPRB,8.7142E-04_JPRB,8.7743E-04_JPRB,8.8666E-04_JPRB/)  
KBO( :,44, 6) = (/&
 & 7.1654E-04_JPRB,7.1945E-04_JPRB,7.2309E-04_JPRB,7.2846E-04_JPRB,7.3657E-04_JPRB/)  
KBO( :,45, 6) = (/&
 & 5.9379E-04_JPRB,5.9641E-04_JPRB,5.9986E-04_JPRB,6.0460E-04_JPRB,6.1175E-04_JPRB/)  
KBO( :,46, 6) = (/&
 & 4.9225E-04_JPRB,4.9449E-04_JPRB,4.9768E-04_JPRB,5.0182E-04_JPRB,5.0799E-04_JPRB/)  
KBO( :,47, 6) = (/&
 & 4.0862E-04_JPRB,4.1037E-04_JPRB,4.1308E-04_JPRB,4.1665E-04_JPRB,4.2178E-04_JPRB/)  
KBO( :,48, 6) = (/&
 & 3.3951E-04_JPRB,3.4066E-04_JPRB,3.4289E-04_JPRB,3.4596E-04_JPRB,3.5019E-04_JPRB/)  
KBO( :,49, 6) = (/&
 & 2.8241E-04_JPRB,2.8294E-04_JPRB,2.8471E-04_JPRB,2.8728E-04_JPRB,2.9076E-04_JPRB/)  
KBO( :,50, 6) = (/&
 & 2.3555E-04_JPRB,2.3552E-04_JPRB,2.3680E-04_JPRB,2.3892E-04_JPRB,2.4178E-04_JPRB/)  
KBO( :,51, 6) = (/&
 & 1.9697E-04_JPRB,1.9644E-04_JPRB,1.9724E-04_JPRB,1.9893E-04_JPRB,2.0124E-04_JPRB/)  
KBO( :,52, 6) = (/&
 & 1.6513E-04_JPRB,1.6415E-04_JPRB,1.6450E-04_JPRB,1.6575E-04_JPRB,1.6760E-04_JPRB/)  
KBO( :,53, 6) = (/&
 & 1.3891E-04_JPRB,1.3752E-04_JPRB,1.3740E-04_JPRB,1.3821E-04_JPRB,1.3969E-04_JPRB/)  
KBO( :,54, 6) = (/&
 & 1.1751E-04_JPRB,1.1571E-04_JPRB,1.1518E-04_JPRB,1.1561E-04_JPRB,1.1672E-04_JPRB/)  
KBO( :,55, 6) = (/&
 & 9.9984E-05_JPRB,9.7805E-05_JPRB,9.6898E-05_JPRB,9.6976E-05_JPRB,9.7759E-05_JPRB/)  
KBO( :,56, 6) = (/&
 & 8.5702E-05_JPRB,8.3105E-05_JPRB,8.1841E-05_JPRB,8.1573E-05_JPRB,8.2039E-05_JPRB/)  
KBO( :,57, 6) = (/&
 & 7.4232E-05_JPRB,7.1097E-05_JPRB,6.9487E-05_JPRB,6.8880E-05_JPRB,6.9030E-05_JPRB/)  
KBO( :,58, 6) = (/&
 & 6.4989E-05_JPRB,6.1340E-05_JPRB,5.9365E-05_JPRB,5.8430E-05_JPRB,5.8292E-05_JPRB/)  
KBO( :,59, 6) = (/&
 & 5.6238E-05_JPRB,5.2637E-05_JPRB,5.0574E-05_JPRB,4.9552E-05_JPRB,4.9287E-05_JPRB/)  
KBO( :,13, 7) = (/&
 & 6.2076E-01_JPRB,6.0643E-01_JPRB,5.9318E-01_JPRB,5.8083E-01_JPRB,5.6896E-01_JPRB/)  
KBO( :,14, 7) = (/&
 & 5.2361E-01_JPRB,5.1159E-01_JPRB,5.0059E-01_JPRB,4.9028E-01_JPRB,4.8050E-01_JPRB/)  
KBO( :,15, 7) = (/&
 & 4.4985E-01_JPRB,4.3986E-01_JPRB,4.3102E-01_JPRB,4.2237E-01_JPRB,4.1436E-01_JPRB/)  
KBO( :,16, 7) = (/&
 & 3.8706E-01_JPRB,3.7895E-01_JPRB,3.7119E-01_JPRB,3.6386E-01_JPRB,3.5724E-01_JPRB/)  
KBO( :,17, 7) = (/&
 & 3.2955E-01_JPRB,3.2266E-01_JPRB,3.1591E-01_JPRB,3.0973E-01_JPRB,3.0418E-01_JPRB/)  
KBO( :,18, 7) = (/&
 & 2.7679E-01_JPRB,2.7082E-01_JPRB,2.6513E-01_JPRB,2.5995E-01_JPRB,2.5545E-01_JPRB/)  
KBO( :,19, 7) = (/&
 & 2.3226E-01_JPRB,2.2714E-01_JPRB,2.2242E-01_JPRB,2.1825E-01_JPRB,2.1464E-01_JPRB/)  
KBO( :,20, 7) = (/&
 & 1.9394E-01_JPRB,1.8975E-01_JPRB,1.8600E-01_JPRB,1.8267E-01_JPRB,1.7989E-01_JPRB/)  
KBO( :,21, 7) = (/&
 & 1.6150E-01_JPRB,1.5816E-01_JPRB,1.5519E-01_JPRB,1.5258E-01_JPRB,1.5046E-01_JPRB/)  
KBO( :,22, 7) = (/&
 & 1.3388E-01_JPRB,1.3131E-01_JPRB,1.2899E-01_JPRB,1.2704E-01_JPRB,1.2536E-01_JPRB/)  
KBO( :,23, 7) = (/&
 & 1.1091E-01_JPRB,1.0891E-01_JPRB,1.0717E-01_JPRB,1.0571E-01_JPRB,1.0434E-01_JPRB/)  
KBO( :,24, 7) = (/&
 & 9.2054E-02_JPRB,9.0515E-02_JPRB,8.9212E-02_JPRB,8.8060E-02_JPRB,8.6983E-02_JPRB/)  
KBO( :,25, 7) = (/&
 & 7.6343E-02_JPRB,7.5207E-02_JPRB,7.4226E-02_JPRB,7.3309E-02_JPRB,7.2502E-02_JPRB/)  
KBO( :,26, 7) = (/&
 & 6.3290E-02_JPRB,6.2474E-02_JPRB,6.1708E-02_JPRB,6.1011E-02_JPRB,6.0412E-02_JPRB/)  
KBO( :,27, 7) = (/&
 & 5.2357E-02_JPRB,5.1753E-02_JPRB,5.1172E-02_JPRB,5.0665E-02_JPRB,5.0225E-02_JPRB/)  
KBO( :,28, 7) = (/&
 & 4.3244E-02_JPRB,4.2787E-02_JPRB,4.2361E-02_JPRB,4.2002E-02_JPRB,4.1698E-02_JPRB/)  
KBO( :,29, 7) = (/&
 & 3.5503E-02_JPRB,3.5181E-02_JPRB,3.4891E-02_JPRB,3.4654E-02_JPRB,3.4461E-02_JPRB/)  
KBO( :,30, 7) = (/&
 & 2.9099E-02_JPRB,2.8880E-02_JPRB,2.8695E-02_JPRB,2.8556E-02_JPRB,2.8451E-02_JPRB/)  
KBO( :,31, 7) = (/&
 & 2.3756E-02_JPRB,2.3624E-02_JPRB,2.3525E-02_JPRB,2.3461E-02_JPRB,2.3423E-02_JPRB/)  
KBO( :,32, 7) = (/&
 & 1.9426E-02_JPRB,1.9356E-02_JPRB,1.9321E-02_JPRB,1.9314E-02_JPRB,1.9320E-02_JPRB/)  
KBO( :,33, 7) = (/&
 & 1.5905E-02_JPRB,1.5887E-02_JPRB,1.5897E-02_JPRB,1.5926E-02_JPRB,1.5970E-02_JPRB/)  
KBO( :,34, 7) = (/&
 & 1.3090E-02_JPRB,1.3109E-02_JPRB,1.3146E-02_JPRB,1.3197E-02_JPRB,1.3269E-02_JPRB/)  
KBO( :,35, 7) = (/&
 & 1.0797E-02_JPRB,1.0836E-02_JPRB,1.0888E-02_JPRB,1.0958E-02_JPRB,1.1045E-02_JPRB/)  
KBO( :,36, 7) = (/&
 & 8.9196E-03_JPRB,8.9674E-03_JPRB,9.0310E-03_JPRB,9.1096E-03_JPRB,9.2030E-03_JPRB/)  
KBO( :,37, 7) = (/&
 & 7.4032E-03_JPRB,7.4569E-03_JPRB,7.5263E-03_JPRB,7.6089E-03_JPRB,7.7061E-03_JPRB/)  
KBO( :,38, 7) = (/&
 & 6.1455E-03_JPRB,6.2033E-03_JPRB,6.2752E-03_JPRB,6.3592E-03_JPRB,6.4581E-03_JPRB/)  
KBO( :,39, 7) = (/&
 & 5.1018E-03_JPRB,5.1610E-03_JPRB,5.2331E-03_JPRB,5.3164E-03_JPRB,5.4128E-03_JPRB/)  
KBO( :,40, 7) = (/&
 & 4.2521E-03_JPRB,4.3105E-03_JPRB,4.3809E-03_JPRB,4.4621E-03_JPRB,4.5540E-03_JPRB/)  
KBO( :,41, 7) = (/&
 & 3.5452E-03_JPRB,3.6013E-03_JPRB,3.6690E-03_JPRB,3.7462E-03_JPRB,3.8330E-03_JPRB/)  
KBO( :,42, 7) = (/&
 & 2.9546E-03_JPRB,3.0079E-03_JPRB,3.0718E-03_JPRB,3.1441E-03_JPRB,3.2249E-03_JPRB/)  
KBO( :,43, 7) = (/&
 & 2.4623E-03_JPRB,2.5120E-03_JPRB,2.5713E-03_JPRB,2.6380E-03_JPRB,2.7122E-03_JPRB/)  
KBO( :,44, 7) = (/&
 & 2.0503E-03_JPRB,2.0962E-03_JPRB,2.1506E-03_JPRB,2.2118E-03_JPRB,2.2791E-03_JPRB/)  
KBO( :,45, 7) = (/&
 & 1.7056E-03_JPRB,1.7475E-03_JPRB,1.7968E-03_JPRB,1.8522E-03_JPRB,1.9127E-03_JPRB/)  
KBO( :,46, 7) = (/&
 & 1.4169E-03_JPRB,1.4548E-03_JPRB,1.4988E-03_JPRB,1.5483E-03_JPRB,1.6024E-03_JPRB/)  
KBO( :,47, 7) = (/&
 & 1.1753E-03_JPRB,1.2090E-03_JPRB,1.2477E-03_JPRB,1.2915E-03_JPRB,1.3391E-03_JPRB/)  
KBO( :,48, 7) = (/&
 & 9.7359E-04_JPRB,1.0036E-03_JPRB,1.0372E-03_JPRB,1.0757E-03_JPRB,1.1176E-03_JPRB/)  
KBO( :,49, 7) = (/&
 & 8.0541E-04_JPRB,8.3180E-04_JPRB,8.6089E-04_JPRB,8.9457E-04_JPRB,9.3110E-04_JPRB/)  
KBO( :,50, 7) = (/&
 & 6.6674E-04_JPRB,6.8981E-04_JPRB,7.1508E-04_JPRB,7.4417E-04_JPRB,7.7606E-04_JPRB/)  
KBO( :,51, 7) = (/&
 & 5.5204E-04_JPRB,5.7200E-04_JPRB,5.9387E-04_JPRB,6.1888E-04_JPRB,6.4663E-04_JPRB/)  
KBO( :,52, 7) = (/&
 & 4.5687E-04_JPRB,4.7390E-04_JPRB,4.9275E-04_JPRB,5.1420E-04_JPRB,5.3821E-04_JPRB/)  
KBO( :,53, 7) = (/&
 & 3.7797E-04_JPRB,3.9233E-04_JPRB,4.0850E-04_JPRB,4.2681E-04_JPRB,4.4742E-04_JPRB/)  
KBO( :,54, 7) = (/&
 & 3.1354E-04_JPRB,3.2560E-04_JPRB,3.3944E-04_JPRB,3.5505E-04_JPRB,3.7284E-04_JPRB/)  
KBO( :,55, 7) = (/&
 & 2.6060E-04_JPRB,2.7065E-04_JPRB,2.8242E-04_JPRB,2.9574E-04_JPRB,3.1104E-04_JPRB/)  
KBO( :,56, 7) = (/&
 & 2.1677E-04_JPRB,2.2507E-04_JPRB,2.3503E-04_JPRB,2.4632E-04_JPRB,2.5934E-04_JPRB/)  
KBO( :,57, 7) = (/&
 & 1.8057E-04_JPRB,1.8733E-04_JPRB,1.9567E-04_JPRB,2.0522E-04_JPRB,2.1627E-04_JPRB/)  
KBO( :,58, 7) = (/&
 & 1.5084E-04_JPRB,1.5628E-04_JPRB,1.6318E-04_JPRB,1.7119E-04_JPRB,1.8056E-04_JPRB/)  
KBO( :,59, 7) = (/&
 & 1.2696E-04_JPRB,1.3148E-04_JPRB,1.3737E-04_JPRB,1.4430E-04_JPRB,1.5250E-04_JPRB/)  
KBO( :,13, 8) = (/&
 & 1.8749E+00_JPRB,1.8339E+00_JPRB,1.7958E+00_JPRB,1.7607E+00_JPRB,1.7271E+00_JPRB/)  
KBO( :,14, 8) = (/&
 & 1.5743E+00_JPRB,1.5413E+00_JPRB,1.5105E+00_JPRB,1.4812E+00_JPRB,1.4530E+00_JPRB/)  
KBO( :,15, 8) = (/&
 & 1.3213E+00_JPRB,1.2948E+00_JPRB,1.2694E+00_JPRB,1.2449E+00_JPRB,1.2211E+00_JPRB/)  
KBO( :,16, 8) = (/&
 & 1.1162E+00_JPRB,1.0945E+00_JPRB,1.0731E+00_JPRB,1.0524E+00_JPRB,1.0321E+00_JPRB/)  
KBO( :,17, 8) = (/&
 & 9.5687E-01_JPRB,9.3833E-01_JPRB,9.2020E-01_JPRB,9.0235E-01_JPRB,8.8485E-01_JPRB/)  
KBO( :,18, 8) = (/&
 & 8.2749E-01_JPRB,8.1191E-01_JPRB,7.9641E-01_JPRB,7.8105E-01_JPRB,7.6632E-01_JPRB/)  
KBO( :,19, 8) = (/&
 & 7.1804E-01_JPRB,7.0461E-01_JPRB,6.9106E-01_JPRB,6.7763E-01_JPRB,6.6520E-01_JPRB/)  
KBO( :,20, 8) = (/&
 & 6.1468E-01_JPRB,6.0286E-01_JPRB,5.9089E-01_JPRB,5.7959E-01_JPRB,5.6959E-01_JPRB/)  
KBO( :,21, 8) = (/&
 & 5.2096E-01_JPRB,5.1044E-01_JPRB,5.0026E-01_JPRB,4.9101E-01_JPRB,4.8331E-01_JPRB/)  
KBO( :,22, 8) = (/&
 & 4.3720E-01_JPRB,4.2829E-01_JPRB,4.2010E-01_JPRB,4.1308E-01_JPRB,4.0742E-01_JPRB/)  
KBO( :,23, 8) = (/&
 & 3.6550E-01_JPRB,3.5834E-01_JPRB,3.5202E-01_JPRB,3.4689E-01_JPRB,3.4279E-01_JPRB/)  
KBO( :,24, 8) = (/&
 & 3.0558E-01_JPRB,2.9995E-01_JPRB,2.9531E-01_JPRB,2.9161E-01_JPRB,2.8882E-01_JPRB/)  
KBO( :,25, 8) = (/&
 & 2.5505E-01_JPRB,2.5086E-01_JPRB,2.4760E-01_JPRB,2.4506E-01_JPRB,2.4335E-01_JPRB/)  
KBO( :,26, 8) = (/&
 & 2.1270E-01_JPRB,2.0980E-01_JPRB,2.0754E-01_JPRB,2.0600E-01_JPRB,2.0500E-01_JPRB/)  
KBO( :,27, 8) = (/&
 & 1.7708E-01_JPRB,1.7513E-01_JPRB,1.7373E-01_JPRB,1.7293E-01_JPRB,1.7242E-01_JPRB/)  
KBO( :,28, 8) = (/&
 & 1.4736E-01_JPRB,1.4615E-01_JPRB,1.4547E-01_JPRB,1.4511E-01_JPRB,1.4503E-01_JPRB/)  
KBO( :,29, 8) = (/&
 & 1.2217E-01_JPRB,1.2161E-01_JPRB,1.2142E-01_JPRB,1.2147E-01_JPRB,1.2176E-01_JPRB/)  
KBO( :,30, 8) = (/&
 & 1.0135E-01_JPRB,1.0129E-01_JPRB,1.0143E-01_JPRB,1.0181E-01_JPRB,1.0237E-01_JPRB/)  
KBO( :,31, 8) = (/&
 & 8.4026E-02_JPRB,8.4283E-02_JPRB,8.4701E-02_JPRB,8.5319E-02_JPRB,8.6090E-02_JPRB/)  
KBO( :,32, 8) = (/&
 & 6.9968E-02_JPRB,7.0421E-02_JPRB,7.1041E-02_JPRB,7.1799E-02_JPRB,7.2670E-02_JPRB/)  
KBO( :,33, 8) = (/&
 & 5.8463E-02_JPRB,5.9059E-02_JPRB,5.9804E-02_JPRB,6.0644E-02_JPRB,6.1569E-02_JPRB/)  
KBO( :,34, 8) = (/&
 & 4.9124E-02_JPRB,4.9817E-02_JPRB,5.0609E-02_JPRB,5.1484E-02_JPRB,5.2418E-02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB11:PART4',1,ZHOOK_HANDLE)
END SUBROUTINE PART4


SUBROUTINE PART5

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB11:PART5',0,ZHOOK_HANDLE)


KBO( :,35, 8) = (/&
 & 4.1343E-02_JPRB,4.2075E-02_JPRB,4.2881E-02_JPRB,4.3757E-02_JPRB,4.4680E-02_JPRB/)  
KBO( :,36, 8) = (/&
 & 3.4807E-02_JPRB,3.5542E-02_JPRB,3.6329E-02_JPRB,3.7186E-02_JPRB,3.8085E-02_JPRB/)  
KBO( :,37, 8) = (/&
 & 2.9387E-02_JPRB,3.0107E-02_JPRB,3.0877E-02_JPRB,3.1701E-02_JPRB,3.2565E-02_JPRB/)  
KBO( :,38, 8) = (/&
 & 2.4810E-02_JPRB,2.5504E-02_JPRB,2.6245E-02_JPRB,2.7036E-02_JPRB,2.7858E-02_JPRB/)  
KBO( :,39, 8) = (/&
 & 2.0945E-02_JPRB,2.1603E-02_JPRB,2.2309E-02_JPRB,2.3055E-02_JPRB,2.3834E-02_JPRB/)  
KBO( :,40, 8) = (/&
 & 1.7727E-02_JPRB,1.8351E-02_JPRB,1.9022E-02_JPRB,1.9730E-02_JPRB,2.0475E-02_JPRB/)  
KBO( :,41, 8) = (/&
 & 1.5006E-02_JPRB,1.5596E-02_JPRB,1.6231E-02_JPRB,1.6901E-02_JPRB,1.7608E-02_JPRB/)  
KBO( :,42, 8) = (/&
 & 1.2699E-02_JPRB,1.3252E-02_JPRB,1.3848E-02_JPRB,1.4479E-02_JPRB,1.5149E-02_JPRB/)  
KBO( :,43, 8) = (/&
 & 1.0731E-02_JPRB,1.1247E-02_JPRB,1.1804E-02_JPRB,1.2397E-02_JPRB,1.3032E-02_JPRB/)  
KBO( :,44, 8) = (/&
 & 9.0535E-03_JPRB,9.5318E-03_JPRB,1.0051E-02_JPRB,1.0609E-02_JPRB,1.1207E-02_JPRB/)  
KBO( :,45, 8) = (/&
 & 7.6285E-03_JPRB,8.0697E-03_JPRB,8.5520E-03_JPRB,9.0723E-03_JPRB,9.6338E-03_JPRB/)  
KBO( :,46, 8) = (/&
 & 6.4125E-03_JPRB,6.8146E-03_JPRB,7.2602E-03_JPRB,7.7440E-03_JPRB,8.2655E-03_JPRB/)  
KBO( :,47, 8) = (/&
 & 5.3712E-03_JPRB,5.7353E-03_JPRB,6.1421E-03_JPRB,6.5868E-03_JPRB,7.0707E-03_JPRB/)  
KBO( :,48, 8) = (/&
 & 4.4885E-03_JPRB,4.8157E-03_JPRB,5.1854E-03_JPRB,5.5906E-03_JPRB,6.0354E-03_JPRB/)  
KBO( :,49, 8) = (/&
 & 3.7410E-03_JPRB,4.0329E-03_JPRB,4.3660E-03_JPRB,4.7329E-03_JPRB,5.1395E-03_JPRB/)  
KBO( :,50, 8) = (/&
 & 3.1195E-03_JPRB,3.3801E-03_JPRB,3.6785E-03_JPRB,4.0128E-03_JPRB,4.3847E-03_JPRB/)  
KBO( :,51, 8) = (/&
 & 2.5986E-03_JPRB,2.8303E-03_JPRB,3.0979E-03_JPRB,3.4004E-03_JPRB,3.7414E-03_JPRB/)  
KBO( :,52, 8) = (/&
 & 2.1586E-03_JPRB,2.3637E-03_JPRB,2.6022E-03_JPRB,2.8753E-03_JPRB,3.1853E-03_JPRB/)  
KBO( :,53, 8) = (/&
 & 1.7874E-03_JPRB,1.9676E-03_JPRB,2.1789E-03_JPRB,2.4235E-03_JPRB,2.7038E-03_JPRB/)  
KBO( :,54, 8) = (/&
 & 1.4850E-03_JPRB,1.6436E-03_JPRB,1.8314E-03_JPRB,2.0513E-03_JPRB,2.3056E-03_JPRB/)  
KBO( :,55, 8) = (/&
 & 1.2350E-03_JPRB,1.3746E-03_JPRB,1.5414E-03_JPRB,1.7391E-03_JPRB,1.9699E-03_JPRB/)  
KBO( :,56, 8) = (/&
 & 1.0255E-03_JPRB,1.1469E-03_JPRB,1.2945E-03_JPRB,1.4714E-03_JPRB,1.6800E-03_JPRB/)  
KBO( :,57, 8) = (/&
 & 8.4971E-04_JPRB,9.5464E-04_JPRB,1.0846E-03_JPRB,1.2416E-03_JPRB,1.4294E-03_JPRB/)  
KBO( :,58, 8) = (/&
 & 7.0441E-04_JPRB,7.9508E-04_JPRB,9.0916E-04_JPRB,1.0487E-03_JPRB,1.2170E-03_JPRB/)  
KBO( :,59, 8) = (/&
 & 5.9755E-04_JPRB,6.7949E-04_JPRB,7.8382E-04_JPRB,9.1237E-04_JPRB,1.0695E-03_JPRB/)  
KBO( :,13, 9) = (/&
 & 1.0788E+01_JPRB,1.0623E+01_JPRB,1.0458E+01_JPRB,1.0276E+01_JPRB,1.0096E+01_JPRB/)  
KBO( :,14, 9) = (/&
 & 9.3612E+00_JPRB,9.2219E+00_JPRB,9.0719E+00_JPRB,8.9125E+00_JPRB,8.7475E+00_JPRB/)  
KBO( :,15, 9) = (/&
 & 8.0594E+00_JPRB,7.9366E+00_JPRB,7.7985E+00_JPRB,7.6538E+00_JPRB,7.5121E+00_JPRB/)  
KBO( :,16, 9) = (/&
 & 6.8883E+00_JPRB,6.7721E+00_JPRB,6.6502E+00_JPRB,6.5309E+00_JPRB,6.4164E+00_JPRB/)  
KBO( :,17, 9) = (/&
 & 5.8447E+00_JPRB,5.7441E+00_JPRB,5.6460E+00_JPRB,5.5501E+00_JPRB,5.4594E+00_JPRB/)  
KBO( :,18, 9) = (/&
 & 4.9433E+00_JPRB,4.8620E+00_JPRB,4.7817E+00_JPRB,4.7042E+00_JPRB,4.6310E+00_JPRB/)  
KBO( :,19, 9) = (/&
 & 4.1982E+00_JPRB,4.1312E+00_JPRB,4.0653E+00_JPRB,4.0039E+00_JPRB,3.9459E+00_JPRB/)  
KBO( :,20, 9) = (/&
 & 3.5838E+00_JPRB,3.5285E+00_JPRB,3.4759E+00_JPRB,3.4263E+00_JPRB,3.3770E+00_JPRB/)  
KBO( :,21, 9) = (/&
 & 3.0778E+00_JPRB,3.0331E+00_JPRB,2.9909E+00_JPRB,2.9486E+00_JPRB,2.9057E+00_JPRB/)  
KBO( :,22, 9) = (/&
 & 2.6565E+00_JPRB,2.6204E+00_JPRB,2.5833E+00_JPRB,2.5458E+00_JPRB,2.5109E+00_JPRB/)  
KBO( :,23, 9) = (/&
 & 2.3092E+00_JPRB,2.2775E+00_JPRB,2.2448E+00_JPRB,2.2133E+00_JPRB,2.1844E+00_JPRB/)  
KBO( :,24, 9) = (/&
 & 2.0249E+00_JPRB,1.9974E+00_JPRB,1.9695E+00_JPRB,1.9433E+00_JPRB,1.9191E+00_JPRB/)  
KBO( :,25, 9) = (/&
 & 1.7740E+00_JPRB,1.7527E+00_JPRB,1.7317E+00_JPRB,1.7118E+00_JPRB,1.6945E+00_JPRB/)  
KBO( :,26, 9) = (/&
 & 1.5476E+00_JPRB,1.5328E+00_JPRB,1.5186E+00_JPRB,1.5057E+00_JPRB,1.4963E+00_JPRB/)  
KBO( :,27, 9) = (/&
 & 1.3401E+00_JPRB,1.3314E+00_JPRB,1.3233E+00_JPRB,1.3171E+00_JPRB,1.3143E+00_JPRB/)  
KBO( :,28, 9) = (/&
 & 1.1557E+00_JPRB,1.1517E+00_JPRB,1.1490E+00_JPRB,1.1490E+00_JPRB,1.1516E+00_JPRB/)  
KBO( :,29, 9) = (/&
 & 9.8748E-01_JPRB,9.8745E-01_JPRB,9.8953E-01_JPRB,9.9392E-01_JPRB,1.0010E+00_JPRB/)  
KBO( :,30, 9) = (/&
 & 8.4260E-01_JPRB,8.4608E-01_JPRB,8.5152E-01_JPRB,8.5914E-01_JPRB,8.6963E-01_JPRB/)  
KBO( :,31, 9) = (/&
 & 7.1579E-01_JPRB,7.2173E-01_JPRB,7.2917E-01_JPRB,7.3933E-01_JPRB,7.5097E-01_JPRB/)  
KBO( :,32, 9) = (/&
 & 6.1011E-01_JPRB,6.1766E-01_JPRB,6.2713E-01_JPRB,6.3845E-01_JPRB,6.5062E-01_JPRB/)  
KBO( :,33, 9) = (/&
 & 5.2120E-01_JPRB,5.3013E-01_JPRB,5.4091E-01_JPRB,5.5249E-01_JPRB,5.6506E-01_JPRB/)  
KBO( :,34, 9) = (/&
 & 4.4937E-01_JPRB,4.5962E-01_JPRB,4.7092E-01_JPRB,4.8296E-01_JPRB,4.9617E-01_JPRB/)  
KBO( :,35, 9) = (/&
 & 3.8853E-01_JPRB,3.9924E-01_JPRB,4.1075E-01_JPRB,4.2296E-01_JPRB,4.3648E-01_JPRB/)  
KBO( :,36, 9) = (/&
 & 3.3659E-01_JPRB,3.4736E-01_JPRB,3.5887E-01_JPRB,3.7122E-01_JPRB,3.8466E-01_JPRB/)  
KBO( :,37, 9) = (/&
 & 2.9273E-01_JPRB,3.0346E-01_JPRB,3.1486E-01_JPRB,3.2720E-01_JPRB,3.4049E-01_JPRB/)  
KBO( :,38, 9) = (/&
 & 2.5454E-01_JPRB,2.6503E-01_JPRB,2.7620E-01_JPRB,2.8834E-01_JPRB,3.0122E-01_JPRB/)  
KBO( :,39, 9) = (/&
 & 2.2111E-01_JPRB,2.3117E-01_JPRB,2.4193E-01_JPRB,2.5368E-01_JPRB,2.6599E-01_JPRB/)  
KBO( :,40, 9) = (/&
 & 1.9377E-01_JPRB,2.0358E-01_JPRB,2.1415E-01_JPRB,2.2567E-01_JPRB,2.3776E-01_JPRB/)  
KBO( :,41, 9) = (/&
 & 1.7005E-01_JPRB,1.7960E-01_JPRB,1.8995E-01_JPRB,2.0120E-01_JPRB,2.1299E-01_JPRB/)  
KBO( :,42, 9) = (/&
 & 1.4922E-01_JPRB,1.5844E-01_JPRB,1.6847E-01_JPRB,1.7937E-01_JPRB,1.9081E-01_JPRB/)  
KBO( :,43, 9) = (/&
 & 1.3075E-01_JPRB,1.3959E-01_JPRB,1.4924E-01_JPRB,1.5974E-01_JPRB,1.7085E-01_JPRB/)  
KBO( :,44, 9) = (/&
 & 1.1438E-01_JPRB,1.2283E-01_JPRB,1.3202E-01_JPRB,1.4209E-01_JPRB,1.5286E-01_JPRB/)  
KBO( :,45, 9) = (/&
 & 9.9902E-02_JPRB,1.0790E-01_JPRB,1.1661E-01_JPRB,1.2618E-01_JPRB,1.3651E-01_JPRB/)  
KBO( :,46, 9) = (/&
 & 8.7103E-02_JPRB,9.4627E-02_JPRB,1.0284E-01_JPRB,1.1186E-01_JPRB,1.2171E-01_JPRB/)  
KBO( :,47, 9) = (/&
 & 7.5878E-02_JPRB,8.2893E-02_JPRB,9.0643E-02_JPRB,9.9147E-02_JPRB,1.0851E-01_JPRB/)  
KBO( :,48, 9) = (/&
 & 6.5893E-02_JPRB,7.2362E-02_JPRB,7.9630E-02_JPRB,8.7572E-02_JPRB,9.6345E-02_JPRB/)  
KBO( :,49, 9) = (/&
 & 5.6945E-02_JPRB,6.2864E-02_JPRB,6.9577E-02_JPRB,7.6900E-02_JPRB,8.5016E-02_JPRB/)  
KBO( :,50, 9) = (/&
 & 4.9637E-02_JPRB,5.5145E-02_JPRB,6.1441E-02_JPRB,6.8345E-02_JPRB,7.5988E-02_JPRB/)  
KBO( :,51, 9) = (/&
 & 4.3422E-02_JPRB,4.8608E-02_JPRB,5.4551E-02_JPRB,6.1122E-02_JPRB,6.8380E-02_JPRB/)  
KBO( :,52, 9) = (/&
 & 3.7823E-02_JPRB,4.2708E-02_JPRB,4.8270E-02_JPRB,5.4493E-02_JPRB,6.1367E-02_JPRB/)  
KBO( :,53, 9) = (/&
 & 3.2716E-02_JPRB,3.7294E-02_JPRB,4.2470E-02_JPRB,4.8310E-02_JPRB,5.4754E-02_JPRB/)  
KBO( :,54, 9) = (/&
 & 2.8879E-02_JPRB,3.3341E-02_JPRB,3.8351E-02_JPRB,4.4083E-02_JPRB,5.0425E-02_JPRB/)  
KBO( :,55, 9) = (/&
 & 2.5791E-02_JPRB,3.0208E-02_JPRB,3.5200E-02_JPRB,4.0945E-02_JPRB,4.7385E-02_JPRB/)  
KBO( :,56, 9) = (/&
 & 2.2986E-02_JPRB,2.7363E-02_JPRB,3.2337E-02_JPRB,3.8064E-02_JPRB,4.4613E-02_JPRB/)  
KBO( :,57, 9) = (/&
 & 2.0449E-02_JPRB,2.4769E-02_JPRB,2.9701E-02_JPRB,3.5425E-02_JPRB,4.2056E-02_JPRB/)  
KBO( :,58, 9) = (/&
 & 1.8265E-02_JPRB,2.2536E-02_JPRB,2.7482E-02_JPRB,3.3264E-02_JPRB,4.0010E-02_JPRB/)  
KBO( :,59, 9) = (/&
 & 1.7419E-02_JPRB,2.1942E-02_JPRB,2.7259E-02_JPRB,3.3550E-02_JPRB,4.0933E-02_JPRB/)  
KBO( :,13,10) = (/&
 & 4.1739E+01_JPRB,4.1046E+01_JPRB,4.0406E+01_JPRB,3.9903E+01_JPRB,3.9432E+01_JPRB/)  
KBO( :,14,10) = (/&
 & 3.7780E+01_JPRB,3.7208E+01_JPRB,3.6738E+01_JPRB,3.6356E+01_JPRB,3.5932E+01_JPRB/)  
KBO( :,15,10) = (/&
 & 3.3722E+01_JPRB,3.3320E+01_JPRB,3.3014E+01_JPRB,3.2683E+01_JPRB,3.2296E+01_JPRB/)  
KBO( :,16,10) = (/&
 & 2.9809E+01_JPRB,2.9590E+01_JPRB,2.9319E+01_JPRB,2.8947E+01_JPRB,2.8490E+01_JPRB/)  
KBO( :,17,10) = (/&
 & 2.6216E+01_JPRB,2.5994E+01_JPRB,2.5636E+01_JPRB,2.5227E+01_JPRB,2.4815E+01_JPRB/)  
KBO( :,18,10) = (/&
 & 2.2808E+01_JPRB,2.2491E+01_JPRB,2.2154E+01_JPRB,2.1818E+01_JPRB,2.1508E+01_JPRB/)  
KBO( :,19,10) = (/&
 & 1.9565E+01_JPRB,1.9296E+01_JPRB,1.9038E+01_JPRB,1.8774E+01_JPRB,1.8537E+01_JPRB/)  
KBO( :,20,10) = (/&
 & 1.6665E+01_JPRB,1.6469E+01_JPRB,1.6266E+01_JPRB,1.6063E+01_JPRB,1.5906E+01_JPRB/)  
KBO( :,21,10) = (/&
 & 1.4150E+01_JPRB,1.3996E+01_JPRB,1.3834E+01_JPRB,1.3710E+01_JPRB,1.3628E+01_JPRB/)  
KBO( :,22,10) = (/&
 & 1.1976E+01_JPRB,1.1855E+01_JPRB,1.1765E+01_JPRB,1.1705E+01_JPRB,1.1637E+01_JPRB/)  
KBO( :,23,10) = (/&
 & 1.0127E+01_JPRB,1.0053E+01_JPRB,1.0018E+01_JPRB,9.9752E+00_JPRB,9.9226E+00_JPRB/)  
KBO( :,24,10) = (/&
 & 8.6146E+00_JPRB,8.5826E+00_JPRB,8.5522E+00_JPRB,8.5043E+00_JPRB,8.4734E+00_JPRB/)  
KBO( :,25,10) = (/&
 & 7.4968E+00_JPRB,7.4470E+00_JPRB,7.3837E+00_JPRB,7.3316E+00_JPRB,7.2993E+00_JPRB/)  
KBO( :,26,10) = (/&
 & 6.6803E+00_JPRB,6.6009E+00_JPRB,6.5219E+00_JPRB,6.4615E+00_JPRB,6.4001E+00_JPRB/)  
KBO( :,27,10) = (/&
 & 5.9868E+00_JPRB,5.9080E+00_JPRB,5.8394E+00_JPRB,5.7646E+00_JPRB,5.6979E+00_JPRB/)  
KBO( :,28,10) = (/&
 & 5.3464E+00_JPRB,5.2910E+00_JPRB,5.2326E+00_JPRB,5.1670E+00_JPRB,5.1173E+00_JPRB/)  
KBO( :,29,10) = (/&
 & 4.6977E+00_JPRB,4.6608E+00_JPRB,4.6112E+00_JPRB,4.5661E+00_JPRB,4.5356E+00_JPRB/)  
KBO( :,30,10) = (/&
 & 4.1012E+00_JPRB,4.0712E+00_JPRB,4.0379E+00_JPRB,4.0156E+00_JPRB,3.9964E+00_JPRB/)  
KBO( :,31,10) = (/&
 & 3.5181E+00_JPRB,3.4969E+00_JPRB,3.4850E+00_JPRB,3.4732E+00_JPRB,3.4789E+00_JPRB/)  
KBO( :,32,10) = (/&
 & 3.0189E+00_JPRB,3.0109E+00_JPRB,3.0086E+00_JPRB,3.0140E+00_JPRB,3.0440E+00_JPRB/)  
KBO( :,33,10) = (/&
 & 2.5886E+00_JPRB,2.5926E+00_JPRB,2.5982E+00_JPRB,2.6243E+00_JPRB,2.6716E+00_JPRB/)  
KBO( :,34,10) = (/&
 & 2.2587E+00_JPRB,2.2647E+00_JPRB,2.2836E+00_JPRB,2.3246E+00_JPRB,2.3804E+00_JPRB/)  
KBO( :,35,10) = (/&
 & 1.9773E+00_JPRB,1.9897E+00_JPRB,2.0203E+00_JPRB,2.0679E+00_JPRB,2.1301E+00_JPRB/)  
KBO( :,36,10) = (/&
 & 1.7395E+00_JPRB,1.7595E+00_JPRB,1.7974E+00_JPRB,1.8469E+00_JPRB,1.9158E+00_JPRB/)  
KBO( :,37,10) = (/&
 & 1.5472E+00_JPRB,1.5730E+00_JPRB,1.6139E+00_JPRB,1.6628E+00_JPRB,1.7327E+00_JPRB/)  
KBO( :,38,10) = (/&
 & 1.3714E+00_JPRB,1.4025E+00_JPRB,1.4462E+00_JPRB,1.4974E+00_JPRB,1.5691E+00_JPRB/)  
KBO( :,39,10) = (/&
 & 1.2087E+00_JPRB,1.2443E+00_JPRB,1.2905E+00_JPRB,1.3459E+00_JPRB,1.4223E+00_JPRB/)  
KBO( :,40,10) = (/&
 & 1.0876E+00_JPRB,1.1253E+00_JPRB,1.1721E+00_JPRB,1.2268E+00_JPRB,1.3018E+00_JPRB/)  
KBO( :,41,10) = (/&
 & 9.8026E-01_JPRB,1.0194E+00_JPRB,1.0667E+00_JPRB,1.1210E+00_JPRB,1.1950E+00_JPRB/)  
KBO( :,42,10) = (/&
 & 8.8231E-01_JPRB,9.2156E-01_JPRB,9.6932E-01_JPRB,1.0233E+00_JPRB,1.0965E+00_JPRB/)  
KBO( :,43,10) = (/&
 & 7.9349E-01_JPRB,8.3234E-01_JPRB,8.7952E-01_JPRB,9.3292E-01_JPRB,1.0030E+00_JPRB/)  
KBO( :,44,10) = (/&
 & 7.1136E-01_JPRB,7.4926E-01_JPRB,7.9572E-01_JPRB,8.4791E-01_JPRB,9.1488E-01_JPRB/)  
KBO( :,45,10) = (/&
 & 6.3430E-01_JPRB,6.7145E-01_JPRB,7.1626E-01_JPRB,7.6714E-01_JPRB,8.3123E-01_JPRB/)  
KBO( :,46,10) = (/&
 & 5.6439E-01_JPRB,6.0014E-01_JPRB,6.4281E-01_JPRB,6.9208E-01_JPRB,7.5262E-01_JPRB/)  
KBO( :,47,10) = (/&
 & 5.0247E-01_JPRB,5.3776E-01_JPRB,5.7789E-01_JPRB,6.2500E-01_JPRB,6.8134E-01_JPRB/)  
KBO( :,48,10) = (/&
 & 4.4383E-01_JPRB,4.7811E-01_JPRB,5.1539E-01_JPRB,5.6031E-01_JPRB,6.1366E-01_JPRB/)  
KBO( :,49,10) = (/&
 & 3.8764E-01_JPRB,4.2029E-01_JPRB,4.5444E-01_JPRB,4.9673E-01_JPRB,5.4849E-01_JPRB/)  
KBO( :,50,10) = (/&
 & 3.4416E-01_JPRB,3.7626E-01_JPRB,4.0876E-01_JPRB,4.4843E-01_JPRB,4.9768E-01_JPRB/)  
KBO( :,51,10) = (/&
 & 3.0832E-01_JPRB,3.4001E-01_JPRB,3.7156E-01_JPRB,4.0857E-01_JPRB,4.5514E-01_JPRB/)  
KBO( :,52,10) = (/&
 & 2.7467E-01_JPRB,3.0526E-01_JPRB,3.3577E-01_JPRB,3.7029E-01_JPRB,4.1417E-01_JPRB/)  
KBO( :,53,10) = (/&
 & 2.4290E-01_JPRB,2.7158E-01_JPRB,3.0075E-01_JPRB,3.3282E-01_JPRB,3.7486E-01_JPRB/)  
KBO( :,54,10) = (/&
 & 2.2403E-01_JPRB,2.5308E-01_JPRB,2.8293E-01_JPRB,3.1404E-01_JPRB,3.5280E-01_JPRB/)  
KBO( :,55,10) = (/&
 & 2.1196E-01_JPRB,2.4297E-01_JPRB,2.7480E-01_JPRB,3.0677E-01_JPRB,3.4328E-01_JPRB/)  
KBO( :,56,10) = (/&
 & 2.0061E-01_JPRB,2.3363E-01_JPRB,2.6759E-01_JPRB,3.0162E-01_JPRB,3.3751E-01_JPRB/)  
KBO( :,57,10) = (/&
 & 1.8972E-01_JPRB,2.2491E-01_JPRB,2.6131E-01_JPRB,2.9791E-01_JPRB,3.3473E-01_JPRB/)  
KBO( :,58,10) = (/&
 & 1.8070E-01_JPRB,2.1925E-01_JPRB,2.5864E-01_JPRB,2.9863E-01_JPRB,3.3832E-01_JPRB/)  
KBO( :,59,10) = (/&
 & 1.9009E-01_JPRB,2.3640E-01_JPRB,2.8437E-01_JPRB,3.3376E-01_JPRB,3.8278E-01_JPRB/)  
KBO( :,13,11) = (/&
 & 7.0149E+01_JPRB,6.9123E+01_JPRB,6.8075E+01_JPRB,6.6895E+01_JPRB,6.5820E+01_JPRB/)  
KBO( :,14,11) = (/&
 & 6.5578E+01_JPRB,6.4536E+01_JPRB,6.3472E+01_JPRB,6.2454E+01_JPRB,6.1689E+01_JPRB/)  
KBO( :,15,11) = (/&
 & 6.0260E+01_JPRB,5.9271E+01_JPRB,5.8388E+01_JPRB,5.7747E+01_JPRB,5.7148E+01_JPRB/)  
KBO( :,16,11) = (/&
 & 5.4585E+01_JPRB,5.3841E+01_JPRB,5.3248E+01_JPRB,5.2830E+01_JPRB,5.2312E+01_JPRB/)  
KBO( :,17,11) = (/&
 & 4.8861E+01_JPRB,4.8416E+01_JPRB,4.8107E+01_JPRB,4.7718E+01_JPRB,4.7237E+01_JPRB/)  
KBO( :,18,11) = (/&
 & 4.3383E+01_JPRB,4.3211E+01_JPRB,4.2923E+01_JPRB,4.2513E+01_JPRB,4.2012E+01_JPRB/)  
KBO( :,19,11) = (/&
 & 3.8334E+01_JPRB,3.8170E+01_JPRB,3.7821E+01_JPRB,3.7371E+01_JPRB,3.6895E+01_JPRB/)  
KBO( :,20,11) = (/&
 & 3.3555E+01_JPRB,3.3295E+01_JPRB,3.2935E+01_JPRB,3.2565E+01_JPRB,3.2201E+01_JPRB/)  
KBO( :,21,11) = (/&
 & 2.9039E+01_JPRB,2.8767E+01_JPRB,2.8509E+01_JPRB,2.8236E+01_JPRB,2.8026E+01_JPRB/)  
KBO( :,22,11) = (/&
 & 2.4902E+01_JPRB,2.4733E+01_JPRB,2.4566E+01_JPRB,2.4421E+01_JPRB,2.4354E+01_JPRB/)  
KBO( :,23,11) = (/&
 & 2.1296E+01_JPRB,2.1205E+01_JPRB,2.1131E+01_JPRB,2.1097E+01_JPRB,2.1132E+01_JPRB/)  
KBO( :,24,11) = (/&
 & 1.8198E+01_JPRB,1.8158E+01_JPRB,1.8158E+01_JPRB,1.8237E+01_JPRB,1.8336E+01_JPRB/)  
KBO( :,25,11) = (/&
 & 1.5544E+01_JPRB,1.5571E+01_JPRB,1.5662E+01_JPRB,1.5796E+01_JPRB,1.5933E+01_JPRB/)  
KBO( :,26,11) = (/&
 & 1.3326E+01_JPRB,1.3410E+01_JPRB,1.3550E+01_JPRB,1.3704E+01_JPRB,1.3869E+01_JPRB/)  
KBO( :,27,11) = (/&
 & 1.1535E+01_JPRB,1.1648E+01_JPRB,1.1786E+01_JPRB,1.1944E+01_JPRB,1.2119E+01_JPRB/)  
KBO( :,28,11) = (/&
 & 1.0126E+01_JPRB,1.0223E+01_JPRB,1.0334E+01_JPRB,1.0469E+01_JPRB,1.0651E+01_JPRB/)  
KBO( :,29,11) = (/&
 & 8.9101E+00_JPRB,8.9853E+00_JPRB,9.0819E+00_JPRB,9.2309E+00_JPRB,9.4172E+00_JPRB/)  
KBO( :,30,11) = (/&
 & 7.8287E+00_JPRB,7.9021E+00_JPRB,8.0148E+00_JPRB,8.1712E+00_JPRB,8.3714E+00_JPRB/)  
KBO( :,31,11) = (/&
 & 6.8306E+00_JPRB,6.9335E+00_JPRB,7.0726E+00_JPRB,7.2494E+00_JPRB,7.4774E+00_JPRB/)  
KBO( :,32,11) = (/&
 & 5.9792E+00_JPRB,6.1135E+00_JPRB,6.2718E+00_JPRB,6.4804E+00_JPRB,6.7529E+00_JPRB/)  
KBO( :,33,11) = (/&
 & 5.2618E+00_JPRB,5.4133E+00_JPRB,5.6076E+00_JPRB,5.8571E+00_JPRB,6.1763E+00_JPRB/)  
KBO( :,34,11) = (/&
 & 4.6698E+00_JPRB,4.8453E+00_JPRB,5.0695E+00_JPRB,5.3575E+00_JPRB,5.7160E+00_JPRB/)  
KBO( :,35,11) = (/&
 & 4.1584E+00_JPRB,4.3575E+00_JPRB,4.6070E+00_JPRB,4.9274E+00_JPRB,5.3225E+00_JPRB/)  
KBO( :,36,11) = (/&
 & 3.7186E+00_JPRB,3.9296E+00_JPRB,4.1978E+00_JPRB,4.5407E+00_JPRB,4.9651E+00_JPRB/)  
KBO( :,37,11) = (/&
 & 3.3279E+00_JPRB,3.5372E+00_JPRB,3.8098E+00_JPRB,4.1628E+00_JPRB,4.5979E+00_JPRB/)  
KBO( :,38,11) = (/&
 & 2.9878E+00_JPRB,3.1966E+00_JPRB,3.4726E+00_JPRB,3.8328E+00_JPRB,4.2770E+00_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB11:PART5',1,ZHOOK_HANDLE)
END SUBROUTINE PART5


SUBROUTINE PART6

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB11:PART6',0,ZHOOK_HANDLE)


KBO( :,39,11) = (/&
 & 2.6914E+00_JPRB,2.9029E+00_JPRB,3.1837E+00_JPRB,3.5477E+00_JPRB,4.0016E+00_JPRB/)  
KBO( :,40,11) = (/&
 & 2.4319E+00_JPRB,2.6362E+00_JPRB,2.9062E+00_JPRB,3.2638E+00_JPRB,3.7133E+00_JPRB/)  
KBO( :,41,11) = (/&
 & 2.2031E+00_JPRB,2.4012E+00_JPRB,2.6621E+00_JPRB,3.0107E+00_JPRB,3.4498E+00_JPRB/)  
KBO( :,42,11) = (/&
 & 2.0013E+00_JPRB,2.1930E+00_JPRB,2.4477E+00_JPRB,2.7865E+00_JPRB,3.2158E+00_JPRB/)  
KBO( :,43,11) = (/&
 & 1.8155E+00_JPRB,1.9974E+00_JPRB,2.2421E+00_JPRB,2.5673E+00_JPRB,2.9810E+00_JPRB/)  
KBO( :,44,11) = (/&
 & 1.6439E+00_JPRB,1.8173E+00_JPRB,2.0498E+00_JPRB,2.3631E+00_JPRB,2.7568E+00_JPRB/)  
KBO( :,45,11) = (/&
 & 1.4842E+00_JPRB,1.6535E+00_JPRB,1.8762E+00_JPRB,2.1775E+00_JPRB,2.5541E+00_JPRB/)  
KBO( :,46,11) = (/&
 & 1.3346E+00_JPRB,1.5007E+00_JPRB,1.7141E+00_JPRB,2.0007E+00_JPRB,2.3614E+00_JPRB/)  
KBO( :,47,11) = (/&
 & 1.1958E+00_JPRB,1.3538E+00_JPRB,1.5588E+00_JPRB,1.8260E+00_JPRB,2.1685E+00_JPRB/)  
KBO( :,48,11) = (/&
 & 1.0640E+00_JPRB,1.2166E+00_JPRB,1.4134E+00_JPRB,1.6668E+00_JPRB,1.9895E+00_JPRB/)  
KBO( :,49,11) = (/&
 & 9.3797E-01_JPRB,1.0854E+00_JPRB,1.2775E+00_JPRB,1.5201E+00_JPRB,1.8241E+00_JPRB/)  
KBO( :,50,11) = (/&
 & 8.3668E-01_JPRB,9.7538E-01_JPRB,1.1607E+00_JPRB,1.3932E+00_JPRB,1.6808E+00_JPRB/)  
KBO( :,51,11) = (/&
 & 7.5008E-01_JPRB,8.7912E-01_JPRB,1.0560E+00_JPRB,1.2775E+00_JPRB,1.5512E+00_JPRB/)  
KBO( :,52,11) = (/&
 & 6.6890E-01_JPRB,7.8952E-01_JPRB,9.5710E-01_JPRB,1.1702E+00_JPRB,1.4314E+00_JPRB/)  
KBO( :,53,11) = (/&
 & 5.9133E-01_JPRB,7.0597E-01_JPRB,8.6435E-01_JPRB,1.0696E+00_JPRB,1.3200E+00_JPRB/)  
KBO( :,54,11) = (/&
 & 5.4247E-01_JPRB,6.4706E-01_JPRB,7.9188E-01_JPRB,9.8503E-01_JPRB,1.2232E+00_JPRB/)  
KBO( :,55,11) = (/&
 & 5.1549E-01_JPRB,6.0734E-01_JPRB,7.3731E-01_JPRB,9.1442E-01_JPRB,1.1379E+00_JPRB/)  
KBO( :,56,11) = (/&
 & 4.9471E-01_JPRB,5.7941E-01_JPRB,6.9440E-01_JPRB,8.5446E-01_JPRB,1.0607E+00_JPRB/)  
KBO( :,57,11) = (/&
 & 4.7679E-01_JPRB,5.6152E-01_JPRB,6.6311E-01_JPRB,8.0517E-01_JPRB,9.9285E-01_JPRB/)  
KBO( :,58,11) = (/&
 & 4.6722E-01_JPRB,5.5574E-01_JPRB,6.5140E-01_JPRB,7.7485E-01_JPRB,9.4214E-01_JPRB/)  
KBO( :,59,11) = (/&
 & 5.1746E-01_JPRB,6.2446E-01_JPRB,7.3396E-01_JPRB,8.4651E-01_JPRB,9.8677E-01_JPRB/)  
KBO( :,13,12) = (/&
 & 1.1763E+02_JPRB,1.1704E+02_JPRB,1.1603E+02_JPRB,1.1496E+02_JPRB,1.1364E+02_JPRB/)  
KBO( :,14,12) = (/&
 & 1.1720E+02_JPRB,1.1632E+02_JPRB,1.1514E+02_JPRB,1.1375E+02_JPRB,1.1226E+02_JPRB/)  
KBO( :,15,12) = (/&
 & 1.1432E+02_JPRB,1.1304E+02_JPRB,1.1152E+02_JPRB,1.1000E+02_JPRB,1.0842E+02_JPRB/)  
KBO( :,16,12) = (/&
 & 1.0854E+02_JPRB,1.0712E+02_JPRB,1.0555E+02_JPRB,1.0402E+02_JPRB,1.0281E+02_JPRB/)  
KBO( :,17,12) = (/&
 & 1.0094E+02_JPRB,9.9554E+01_JPRB,9.8139E+01_JPRB,9.7144E+01_JPRB,9.6378E+01_JPRB/)  
KBO( :,18,12) = (/&
 & 9.2454E+01_JPRB,9.1307E+01_JPRB,9.0476E+01_JPRB,8.9927E+01_JPRB,8.9509E+01_JPRB/)  
KBO( :,19,12) = (/&
 & 8.3732E+01_JPRB,8.3060E+01_JPRB,8.2781E+01_JPRB,8.2603E+01_JPRB,8.2376E+01_JPRB/)  
KBO( :,20,12) = (/&
 & 7.5210E+01_JPRB,7.5083E+01_JPRB,7.5219E+01_JPRB,7.5148E+01_JPRB,7.5022E+01_JPRB/)  
KBO( :,21,12) = (/&
 & 6.7221E+01_JPRB,6.7502E+01_JPRB,6.7667E+01_JPRB,6.7706E+01_JPRB,6.7670E+01_JPRB/)  
KBO( :,22,12) = (/&
 & 5.9857E+01_JPRB,6.0211E+01_JPRB,6.0464E+01_JPRB,6.0528E+01_JPRB,6.0584E+01_JPRB/)  
KBO( :,23,12) = (/&
 & 5.3034E+01_JPRB,5.3411E+01_JPRB,5.3657E+01_JPRB,5.3849E+01_JPRB,5.4089E+01_JPRB/)  
KBO( :,24,12) = (/&
 & 4.6747E+01_JPRB,4.7114E+01_JPRB,4.7455E+01_JPRB,4.7832E+01_JPRB,4.8289E+01_JPRB/)  
KBO( :,25,12) = (/&
 & 4.1034E+01_JPRB,4.1487E+01_JPRB,4.1992E+01_JPRB,4.2559E+01_JPRB,4.3281E+01_JPRB/)  
KBO( :,26,12) = (/&
 & 3.5986E+01_JPRB,3.6596E+01_JPRB,3.7280E+01_JPRB,3.8073E+01_JPRB,3.9028E+01_JPRB/)  
KBO( :,27,12) = (/&
 & 3.1660E+01_JPRB,3.2405E+01_JPRB,3.3245E+01_JPRB,3.4269E+01_JPRB,3.5471E+01_JPRB/)  
KBO( :,28,12) = (/&
 & 2.7947E+01_JPRB,2.8848E+01_JPRB,2.9895E+01_JPRB,3.1146E+01_JPRB,3.2530E+01_JPRB/)  
KBO( :,29,12) = (/&
 & 2.4835E+01_JPRB,2.5907E+01_JPRB,2.7165E+01_JPRB,2.8573E+01_JPRB,3.0101E+01_JPRB/)  
KBO( :,30,12) = (/&
 & 2.2283E+01_JPRB,2.3505E+01_JPRB,2.4915E+01_JPRB,2.6460E+01_JPRB,2.8145E+01_JPRB/)  
KBO( :,31,12) = (/&
 & 2.0220E+01_JPRB,2.1547E+01_JPRB,2.3078E+01_JPRB,2.4775E+01_JPRB,2.6630E+01_JPRB/)  
KBO( :,32,12) = (/&
 & 1.8546E+01_JPRB,1.9996E+01_JPRB,2.1643E+01_JPRB,2.3497E+01_JPRB,2.5478E+01_JPRB/)  
KBO( :,33,12) = (/&
 & 1.7230E+01_JPRB,1.8797E+01_JPRB,2.0565E+01_JPRB,2.2562E+01_JPRB,2.4685E+01_JPRB/)  
KBO( :,34,12) = (/&
 & 1.6179E+01_JPRB,1.7864E+01_JPRB,1.9755E+01_JPRB,2.1868E+01_JPRB,2.4108E+01_JPRB/)  
KBO( :,35,12) = (/&
 & 1.5234E+01_JPRB,1.7011E+01_JPRB,1.9013E+01_JPRB,2.1222E+01_JPRB,2.3546E+01_JPRB/)  
KBO( :,36,12) = (/&
 & 1.4312E+01_JPRB,1.6162E+01_JPRB,1.8243E+01_JPRB,2.0518E+01_JPRB,2.2905E+01_JPRB/)  
KBO( :,37,12) = (/&
 & 1.3297E+01_JPRB,1.5184E+01_JPRB,1.7295E+01_JPRB,1.9599E+01_JPRB,2.2032E+01_JPRB/)  
KBO( :,38,12) = (/&
 & 1.2404E+01_JPRB,1.4319E+01_JPRB,1.6454E+01_JPRB,1.8773E+01_JPRB,2.1247E+01_JPRB/)  
KBO( :,39,12) = (/&
 & 1.1631E+01_JPRB,1.3561E+01_JPRB,1.5713E+01_JPRB,1.8045E+01_JPRB,2.0533E+01_JPRB/)  
KBO( :,40,12) = (/&
 & 1.0776E+01_JPRB,1.2683E+01_JPRB,1.4823E+01_JPRB,1.7145E+01_JPRB,1.9624E+01_JPRB/)  
KBO( :,41,12) = (/&
 & 9.9846E+00_JPRB,1.1854E+01_JPRB,1.3973E+01_JPRB,1.6278E+01_JPRB,1.8741E+01_JPRB/)  
KBO( :,42,12) = (/&
 & 9.2669E+00_JPRB,1.1094E+01_JPRB,1.3178E+01_JPRB,1.5464E+01_JPRB,1.7906E+01_JPRB/)  
KBO( :,43,12) = (/&
 & 8.5220E+00_JPRB,1.0286E+01_JPRB,1.2314E+01_JPRB,1.4565E+01_JPRB,1.6968E+01_JPRB/)  
KBO( :,44,12) = (/&
 & 7.8007E+00_JPRB,9.4905E+00_JPRB,1.1450E+01_JPRB,1.3650E+01_JPRB,1.6009E+01_JPRB/)  
KBO( :,45,12) = (/&
 & 7.1409E+00_JPRB,8.7509E+00_JPRB,1.0635E+01_JPRB,1.2772E+01_JPRB,1.5090E+01_JPRB/)  
KBO( :,46,12) = (/&
 & 6.4944E+00_JPRB,8.0237E+00_JPRB,9.8250E+00_JPRB,1.1888E+01_JPRB,1.4153E+01_JPRB/)  
KBO( :,47,12) = (/&
 & 5.8398E+00_JPRB,7.2873E+00_JPRB,8.9871E+00_JPRB,1.0958E+01_JPRB,1.3150E+01_JPRB/)  
KBO( :,48,12) = (/&
 & 5.2382E+00_JPRB,6.6014E+00_JPRB,8.2063E+00_JPRB,1.0074E+01_JPRB,1.2187E+01_JPRB/)  
KBO( :,49,12) = (/&
 & 4.6806E+00_JPRB,5.9636E+00_JPRB,7.4774E+00_JPRB,9.2397E+00_JPRB,1.1262E+01_JPRB/)  
KBO( :,50,12) = (/&
 & 4.1950E+00_JPRB,5.4065E+00_JPRB,6.8409E+00_JPRB,8.5038E+00_JPRB,1.0433E+01_JPRB/)  
KBO( :,51,12) = (/&
 & 3.7601E+00_JPRB,4.9006E+00_JPRB,6.2541E+00_JPRB,7.8347E+00_JPRB,9.6656E+00_JPRB/)  
KBO( :,52,12) = (/&
 & 3.3634E+00_JPRB,4.4254E+00_JPRB,5.7055E+00_JPRB,7.2078E+00_JPRB,8.9393E+00_JPRB/)  
KBO( :,53,12) = (/&
 & 2.9998E+00_JPRB,3.9820E+00_JPRB,5.1884E+00_JPRB,6.6101E+00_JPRB,8.2541E+00_JPRB/)  
KBO( :,54,12) = (/&
 & 2.6868E+00_JPRB,3.6047E+00_JPRB,4.7437E+00_JPRB,6.0916E+00_JPRB,7.6592E+00_JPRB/)  
KBO( :,55,12) = (/&
 & 2.4117E+00_JPRB,3.2705E+00_JPRB,4.3398E+00_JPRB,5.6205E+00_JPRB,7.1187E+00_JPRB/)  
KBO( :,56,12) = (/&
 & 2.1660E+00_JPRB,2.9605E+00_JPRB,3.9604E+00_JPRB,5.1726E+00_JPRB,6.6011E+00_JPRB/)  
KBO( :,57,12) = (/&
 & 1.9495E+00_JPRB,2.6745E+00_JPRB,3.6080E+00_JPRB,4.7499E+00_JPRB,6.1107E+00_JPRB/)  
KBO( :,58,12) = (/&
 & 1.7779E+00_JPRB,2.4322E+00_JPRB,3.2974E+00_JPRB,4.3714E+00_JPRB,5.6684E+00_JPRB/)  
KBO( :,59,12) = (/&
 & 1.8044E+00_JPRB,2.3958E+00_JPRB,3.1943E+00_JPRB,4.2235E+00_JPRB,5.4952E+00_JPRB/)  
KBO( :,13,13) = (/&
 & 2.0512E+02_JPRB,2.0180E+02_JPRB,1.9927E+02_JPRB,1.9697E+02_JPRB,1.9484E+02_JPRB/)  
KBO( :,14,13) = (/&
 & 2.1130E+02_JPRB,2.0859E+02_JPRB,2.0670E+02_JPRB,2.0479E+02_JPRB,2.0269E+02_JPRB/)  
KBO( :,15,13) = (/&
 & 2.1567E+02_JPRB,2.1436E+02_JPRB,2.1270E+02_JPRB,2.1071E+02_JPRB,2.0862E+02_JPRB/)  
KBO( :,16,13) = (/&
 & 2.1924E+02_JPRB,2.1808E+02_JPRB,2.1632E+02_JPRB,2.1429E+02_JPRB,2.1205E+02_JPRB/)  
KBO( :,17,13) = (/&
 & 2.1990E+02_JPRB,2.1849E+02_JPRB,2.1654E+02_JPRB,2.1444E+02_JPRB,2.1217E+02_JPRB/)  
KBO( :,18,13) = (/&
 & 2.1655E+02_JPRB,2.1510E+02_JPRB,2.1314E+02_JPRB,2.1102E+02_JPRB,2.0899E+02_JPRB/)  
KBO( :,19,13) = (/&
 & 2.0961E+02_JPRB,2.0798E+02_JPRB,2.0612E+02_JPRB,2.0453E+02_JPRB,2.0306E+02_JPRB/)  
KBO( :,20,13) = (/&
 & 1.9928E+02_JPRB,1.9792E+02_JPRB,1.9688E+02_JPRB,1.9606E+02_JPRB,1.9544E+02_JPRB/)  
KBO( :,21,13) = (/&
 & 1.8688E+02_JPRB,1.8632E+02_JPRB,1.8628E+02_JPRB,1.8637E+02_JPRB,1.8670E+02_JPRB/)  
KBO( :,22,13) = (/&
 & 1.7350E+02_JPRB,1.7419E+02_JPRB,1.7515E+02_JPRB,1.7641E+02_JPRB,1.7783E+02_JPRB/)  
KBO( :,23,13) = (/&
 & 1.6055E+02_JPRB,1.6233E+02_JPRB,1.6459E+02_JPRB,1.6688E+02_JPRB,1.6939E+02_JPRB/)  
KBO( :,24,13) = (/&
 & 1.4859E+02_JPRB,1.5153E+02_JPRB,1.5476E+02_JPRB,1.5830E+02_JPRB,1.6165E+02_JPRB/)  
KBO( :,25,13) = (/&
 & 1.3793E+02_JPRB,1.4190E+02_JPRB,1.4615E+02_JPRB,1.5046E+02_JPRB,1.5447E+02_JPRB/)  
KBO( :,26,13) = (/&
 & 1.2881E+02_JPRB,1.3370E+02_JPRB,1.3871E+02_JPRB,1.4366E+02_JPRB,1.4837E+02_JPRB/)  
KBO( :,27,13) = (/&
 & 1.2091E+02_JPRB,1.2669E+02_JPRB,1.3236E+02_JPRB,1.3790E+02_JPRB,1.4323E+02_JPRB/)  
KBO( :,28,13) = (/&
 & 1.1443E+02_JPRB,1.2084E+02_JPRB,1.2716E+02_JPRB,1.3332E+02_JPRB,1.3925E+02_JPRB/)  
KBO( :,29,13) = (/&
 & 1.0924E+02_JPRB,1.1623E+02_JPRB,1.2318E+02_JPRB,1.2992E+02_JPRB,1.3643E+02_JPRB/)  
KBO( :,30,13) = (/&
 & 1.0522E+02_JPRB,1.1286E+02_JPRB,1.2038E+02_JPRB,1.2758E+02_JPRB,1.3457E+02_JPRB/)  
KBO( :,31,13) = (/&
 & 1.0235E+02_JPRB,1.1060E+02_JPRB,1.1856E+02_JPRB,1.2616E+02_JPRB,1.3349E+02_JPRB/)  
KBO( :,32,13) = (/&
 & 1.0060E+02_JPRB,1.0929E+02_JPRB,1.1766E+02_JPRB,1.2555E+02_JPRB,1.3305E+02_JPRB/)  
KBO( :,33,13) = (/&
 & 9.9754E+01_JPRB,1.0883E+02_JPRB,1.1748E+02_JPRB,1.2555E+02_JPRB,1.3314E+02_JPRB/)  
KBO( :,34,13) = (/&
 & 9.9339E+01_JPRB,1.0865E+02_JPRB,1.1753E+02_JPRB,1.2571E+02_JPRB,1.3339E+02_JPRB/)  
KBO( :,35,13) = (/&
 & 9.8596E+01_JPRB,1.0810E+02_JPRB,1.1714E+02_JPRB,1.2546E+02_JPRB,1.3323E+02_JPRB/)  
KBO( :,36,13) = (/&
 & 9.7185E+01_JPRB,1.0690E+02_JPRB,1.1612E+02_JPRB,1.2461E+02_JPRB,1.3247E+02_JPRB/)  
KBO( :,37,13) = (/&
 & 9.4552E+01_JPRB,1.0450E+02_JPRB,1.1396E+02_JPRB,1.2268E+02_JPRB,1.3072E+02_JPRB/)  
KBO( :,38,13) = (/&
 & 9.2021E+01_JPRB,1.0218E+02_JPRB,1.1183E+02_JPRB,1.2080E+02_JPRB,1.2896E+02_JPRB/)  
KBO( :,39,13) = (/&
 & 8.9655E+01_JPRB,1.0001E+02_JPRB,1.0984E+02_JPRB,1.1901E+02_JPRB,1.2733E+02_JPRB/)  
KBO( :,40,13) = (/&
 & 8.6395E+01_JPRB,9.6898E+01_JPRB,1.0693E+02_JPRB,1.1637E+02_JPRB,1.2493E+02_JPRB/)  
KBO( :,41,13) = (/&
 & 8.3008E+01_JPRB,9.3700E+01_JPRB,1.0393E+02_JPRB,1.1362E+02_JPRB,1.2243E+02_JPRB/)  
KBO( :,42,13) = (/&
 & 7.9672E+01_JPRB,9.0529E+01_JPRB,1.0096E+02_JPRB,1.1088E+02_JPRB,1.1992E+02_JPRB/)  
KBO( :,43,13) = (/&
 & 7.5762E+01_JPRB,8.6769E+01_JPRB,9.7419E+01_JPRB,1.0755E+02_JPRB,1.1689E+02_JPRB/)  
KBO( :,44,13) = (/&
 & 7.1629E+01_JPRB,8.2730E+01_JPRB,9.3566E+01_JPRB,1.0394E+02_JPRB,1.1358E+02_JPRB/)  
KBO( :,45,13) = (/&
 & 6.7556E+01_JPRB,7.8701E+01_JPRB,8.9702E+01_JPRB,1.0031E+02_JPRB,1.1019E+02_JPRB/)  
KBO( :,46,13) = (/&
 & 6.3293E+01_JPRB,7.4433E+01_JPRB,8.5570E+01_JPRB,9.6371E+01_JPRB,1.0651E+02_JPRB/)  
KBO( :,47,13) = (/&
 & 5.8590E+01_JPRB,6.9723E+01_JPRB,8.0924E+01_JPRB,9.1933E+01_JPRB,1.0234E+02_JPRB/)  
KBO( :,48,13) = (/&
 & 5.3939E+01_JPRB,6.5035E+01_JPRB,7.6260E+01_JPRB,8.7442E+01_JPRB,9.8085E+01_JPRB/)  
KBO( :,49,13) = (/&
 & 4.9372E+01_JPRB,6.0382E+01_JPRB,7.1607E+01_JPRB,8.2898E+01_JPRB,9.3743E+01_JPRB/)  
KBO( :,50,13) = (/&
 & 4.5182E+01_JPRB,5.6046E+01_JPRB,6.7282E+01_JPRB,7.8580E+01_JPRB,8.9608E+01_JPRB/)  
KBO( :,51,13) = (/&
 & 4.1225E+01_JPRB,5.1903E+01_JPRB,6.3083E+01_JPRB,7.4337E+01_JPRB,8.5550E+01_JPRB/)  
KBO( :,52,13) = (/&
 & 3.7400E+01_JPRB,4.7849E+01_JPRB,5.8911E+01_JPRB,7.0135E+01_JPRB,8.1453E+01_JPRB/)  
KBO( :,53,13) = (/&
 & 3.3724E+01_JPRB,4.3867E+01_JPRB,5.4766E+01_JPRB,6.5951E+01_JPRB,7.7304E+01_JPRB/)  
KBO( :,54,13) = (/&
 & 3.0521E+01_JPRB,4.0307E+01_JPRB,5.1017E+01_JPRB,6.2127E+01_JPRB,7.3480E+01_JPRB/)  
KBO( :,55,13) = (/&
 & 2.7567E+01_JPRB,3.6992E+01_JPRB,4.7489E+01_JPRB,5.8488E+01_JPRB,6.9808E+01_JPRB/)  
KBO( :,56,13) = (/&
 & 2.4765E+01_JPRB,3.3801E+01_JPRB,4.4027E+01_JPRB,5.4887E+01_JPRB,6.6150E+01_JPRB/)  
KBO( :,57,13) = (/&
 & 2.2126E+01_JPRB,3.0733E+01_JPRB,4.0624E+01_JPRB,5.1332E+01_JPRB,6.2512E+01_JPRB/)  
KBO( :,58,13) = (/&
 & 1.9779E+01_JPRB,2.7951E+01_JPRB,3.7480E+01_JPRB,4.7995E+01_JPRB,5.9073E+01_JPRB/)  
KBO( :,59,13) = (/&
 & 1.8871E+01_JPRB,2.6859E+01_JPRB,3.6240E+01_JPRB,4.6659E+01_JPRB,5.7692E+01_JPRB/)  
KBO( :,13,14) = (/&
 & 3.8707E+02_JPRB,3.8322E+02_JPRB,3.7871E+02_JPRB,3.7328E+02_JPRB,3.6786E+02_JPRB/)  
KBO( :,14,14) = (/&
 & 4.1884E+02_JPRB,4.1330E+02_JPRB,4.0744E+02_JPRB,4.0116E+02_JPRB,3.9496E+02_JPRB/)  
KBO( :,15,14) = (/&
 & 4.4801E+02_JPRB,4.4018E+02_JPRB,4.3297E+02_JPRB,4.2678E+02_JPRB,4.2069E+02_JPRB/)  
KBO( :,16,14) = (/&
 & 4.7264E+02_JPRB,4.6443E+02_JPRB,4.5766E+02_JPRB,4.5139E+02_JPRB,4.4521E+02_JPRB/)  
KBO( :,17,14) = (/&
 & 4.9540E+02_JPRB,4.8838E+02_JPRB,4.8129E+02_JPRB,4.7490E+02_JPRB,4.6866E+02_JPRB/)  
KBO( :,18,14) = (/&
 & 5.1671E+02_JPRB,5.0996E+02_JPRB,5.0313E+02_JPRB,4.9709E+02_JPRB,4.9175E+02_JPRB/)  
KBO( :,19,14) = (/&
 & 5.3506E+02_JPRB,5.2890E+02_JPRB,5.2336E+02_JPRB,5.1765E+02_JPRB,5.1228E+02_JPRB/)  
KBO( :,20,14) = (/&
 & 5.5004E+02_JPRB,5.4514E+02_JPRB,5.3989E+02_JPRB,5.3465E+02_JPRB,5.2969E+02_JPRB/)  
KBO( :,21,14) = (/&
 & 5.6147E+02_JPRB,5.5729E+02_JPRB,5.5301E+02_JPRB,5.4855E+02_JPRB,5.4414E+02_JPRB/)  
KBO( :,22,14) = (/&
 & 5.6866E+02_JPRB,5.6616E+02_JPRB,5.6274E+02_JPRB,5.5924E+02_JPRB,5.5570E+02_JPRB/)  
KBO( :,23,14) = (/&
 & 5.7274E+02_JPRB,5.7195E+02_JPRB,5.7007E+02_JPRB,5.6757E+02_JPRB,5.6416E+02_JPRB/)  
KBO( :,24,14) = (/&
 & 5.7471E+02_JPRB,5.7582E+02_JPRB,5.7502E+02_JPRB,5.7329E+02_JPRB,5.7041E+02_JPRB/)  
KBO( :,25,14) = (/&
 & 5.7535E+02_JPRB,5.7804E+02_JPRB,5.7836E+02_JPRB,5.7753E+02_JPRB,5.7582E+02_JPRB/)  
KBO( :,26,14) = (/&
 & 5.7542E+02_JPRB,5.7938E+02_JPRB,5.8066E+02_JPRB,5.8114E+02_JPRB,5.8000E+02_JPRB/)  
KBO( :,27,14) = (/&
 & 5.7537E+02_JPRB,5.8032E+02_JPRB,5.8293E+02_JPRB,5.8414E+02_JPRB,5.8351E+02_JPRB/)  
KBO( :,28,14) = (/&
 & 5.7542E+02_JPRB,5.8169E+02_JPRB,5.8508E+02_JPRB,5.8663E+02_JPRB,5.8623E+02_JPRB/)  
KBO( :,29,14) = (/&
 & 5.7592E+02_JPRB,5.8334E+02_JPRB,5.8700E+02_JPRB,5.8877E+02_JPRB,5.8850E+02_JPRB/)  
KBO( :,30,14) = (/&
 & 5.7705E+02_JPRB,5.8477E+02_JPRB,5.8859E+02_JPRB,5.9059E+02_JPRB,5.9045E+02_JPRB/)  
KBO( :,31,14) = (/&
 & 5.7869E+02_JPRB,5.8639E+02_JPRB,5.9018E+02_JPRB,5.9225E+02_JPRB,5.9219E+02_JPRB/)  
KBO( :,32,14) = (/&
 & 5.8067E+02_JPRB,5.8815E+02_JPRB,5.9179E+02_JPRB,5.9363E+02_JPRB,5.9369E+02_JPRB/)  
KBO( :,33,14) = (/&
 & 5.8279E+02_JPRB,5.8990E+02_JPRB,5.9323E+02_JPRB,5.9481E+02_JPRB,5.9486E+02_JPRB/)  
KBO( :,34,14) = (/&
 & 5.8464E+02_JPRB,5.9150E+02_JPRB,5.9440E+02_JPRB,5.9589E+02_JPRB,5.9578E+02_JPRB/)  
KBO( :,35,14) = (/&
 & 5.8569E+02_JPRB,5.9251E+02_JPRB,5.9535E+02_JPRB,5.9677E+02_JPRB,5.9665E+02_JPRB/)  
KBO( :,36,14) = (/&
 & 5.8587E+02_JPRB,5.9292E+02_JPRB,5.9596E+02_JPRB,5.9747E+02_JPRB,5.9747E+02_JPRB/)  
KBO( :,37,14) = (/&
 & 5.8477E+02_JPRB,5.9243E+02_JPRB,5.9596E+02_JPRB,5.9792E+02_JPRB,5.9828E+02_JPRB/)  
KBO( :,38,14) = (/&
 & 5.8340E+02_JPRB,5.9173E+02_JPRB,5.9590E+02_JPRB,5.9820E+02_JPRB,5.9879E+02_JPRB/)  
KBO( :,39,14) = (/&
 & 5.8197E+02_JPRB,5.9091E+02_JPRB,5.9561E+02_JPRB,5.9833E+02_JPRB,5.9927E+02_JPRB/)  
KBO( :,40,14) = (/&
 & 5.7939E+02_JPRB,5.8916E+02_JPRB,5.9475E+02_JPRB,5.9816E+02_JPRB,5.9962E+02_JPRB/)  
KBO( :,41,14) = (/&
 & 5.7608E+02_JPRB,5.8699E+02_JPRB,5.9359E+02_JPRB,5.9774E+02_JPRB,5.9982E+02_JPRB/)  
KBO( :,42,14) = (/&
 & 5.7232E+02_JPRB,5.8456E+02_JPRB,5.9223E+02_JPRB,5.9718E+02_JPRB,5.9987E+02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB11:PART6',1,ZHOOK_HANDLE)
END SUBROUTINE PART6


SUBROUTINE PART7

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB11:PART7',0,ZHOOK_HANDLE)


KBO( :,43,14) = (/&
 & 5.6728E+02_JPRB,5.8121E+02_JPRB,5.9028E+02_JPRB,5.9616E+02_JPRB,5.9954E+02_JPRB/)  
KBO( :,44,14) = (/&
 & 5.6123E+02_JPRB,5.7709E+02_JPRB,5.8763E+02_JPRB,5.9468E+02_JPRB,5.9887E+02_JPRB/)  
KBO( :,45,14) = (/&
 & 5.5447E+02_JPRB,5.7231E+02_JPRB,5.8444E+02_JPRB,5.9277E+02_JPRB,5.9784E+02_JPRB/)  
KBO( :,46,14) = (/&
 & 5.4640E+02_JPRB,5.6618E+02_JPRB,5.8043E+02_JPRB,5.9039E+02_JPRB,5.9653E+02_JPRB/)  
KBO( :,47,14) = (/&
 & 5.3656E+02_JPRB,5.5868E+02_JPRB,5.7521E+02_JPRB,5.8706E+02_JPRB,5.9448E+02_JPRB/)  
KBO( :,48,14) = (/&
 & 5.2560E+02_JPRB,5.5033E+02_JPRB,5.6904E+02_JPRB,5.8292E+02_JPRB,5.9200E+02_JPRB/)  
KBO( :,49,14) = (/&
 & 5.1361E+02_JPRB,5.4088E+02_JPRB,5.6193E+02_JPRB,5.7800E+02_JPRB,5.8895E+02_JPRB/)  
KBO( :,50,14) = (/&
 & 5.0091E+02_JPRB,5.3110E+02_JPRB,5.5541E+02_JPRB,5.7270E+02_JPRB,5.8551E+02_JPRB/)  
KBO( :,51,14) = (/&
 & 4.8751E+02_JPRB,5.2063E+02_JPRB,5.4741E+02_JPRB,5.6726E+02_JPRB,5.8153E+02_JPRB/)  
KBO( :,52,14) = (/&
 & 4.7297E+02_JPRB,5.0923E+02_JPRB,5.3861E+02_JPRB,5.6059E+02_JPRB,5.7676E+02_JPRB/)  
KBO( :,53,14) = (/&
 & 4.5743E+02_JPRB,4.9674E+02_JPRB,5.2890E+02_JPRB,5.5315E+02_JPRB,5.7135E+02_JPRB/)  
KBO( :,54,14) = (/&
 & 4.4140E+02_JPRB,4.8429E+02_JPRB,5.1910E+02_JPRB,5.4570E+02_JPRB,5.6577E+02_JPRB/)  
KBO( :,55,14) = (/&
 & 4.2564E+02_JPRB,4.7143E+02_JPRB,5.0881E+02_JPRB,5.3786E+02_JPRB,5.5980E+02_JPRB/)  
KBO( :,56,14) = (/&
 & 4.0890E+02_JPRB,4.5764E+02_JPRB,4.9778E+02_JPRB,5.2941E+02_JPRB,5.5381E+02_JPRB/)  
KBO( :,57,14) = (/&
 & 3.9121E+02_JPRB,4.4300E+02_JPRB,4.8601E+02_JPRB,5.2017E+02_JPRB,5.4671E+02_JPRB/)  
KBO( :,58,14) = (/&
 & 3.7355E+02_JPRB,4.2830E+02_JPRB,4.7408E+02_JPRB,5.1067E+02_JPRB,5.3936E+02_JPRB/)  
KBO( :,59,14) = (/&
 & 3.6625E+02_JPRB,4.2210E+02_JPRB,4.6902E+02_JPRB,5.0665E+02_JPRB,5.3625E+02_JPRB/)  
KBO( :,13,15) = (/&
 & 6.9472E+02_JPRB,6.8190E+02_JPRB,6.7012E+02_JPRB,6.5938E+02_JPRB,6.4861E+02_JPRB/)  
KBO( :,14,15) = (/&
 & 7.9617E+02_JPRB,7.8432E+02_JPRB,7.7183E+02_JPRB,7.5985E+02_JPRB,7.4779E+02_JPRB/)  
KBO( :,15,15) = (/&
 & 9.0905E+02_JPRB,8.9621E+02_JPRB,8.8202E+02_JPRB,8.6871E+02_JPRB,8.5523E+02_JPRB/)  
KBO( :,16,15) = (/&
 & 1.0296E+03_JPRB,1.0152E+03_JPRB,9.9738E+02_JPRB,9.8243E+02_JPRB,9.6638E+02_JPRB/)  
KBO( :,17,15) = (/&
 & 1.1531E+03_JPRB,1.1349E+03_JPRB,1.1154E+03_JPRB,1.0980E+03_JPRB,1.0783E+03_JPRB/)  
KBO( :,18,15) = (/&
 & 1.2776E+03_JPRB,1.2567E+03_JPRB,1.2351E+03_JPRB,1.2117E+03_JPRB,1.1888E+03_JPRB/)  
KBO( :,19,15) = (/&
 & 1.4027E+03_JPRB,1.3760E+03_JPRB,1.3510E+03_JPRB,1.3233E+03_JPRB,1.2971E+03_JPRB/)  
KBO( :,20,15) = (/&
 & 1.5265E+03_JPRB,1.4940E+03_JPRB,1.4647E+03_JPRB,1.4325E+03_JPRB,1.4019E+03_JPRB/)  
KBO( :,21,15) = (/&
 & 1.6464E+03_JPRB,1.6088E+03_JPRB,1.5749E+03_JPRB,1.5375E+03_JPRB,1.5006E+03_JPRB/)  
KBO( :,22,15) = (/&
 & 1.7545E+03_JPRB,1.7140E+03_JPRB,1.6756E+03_JPRB,1.6321E+03_JPRB,1.5896E+03_JPRB/)  
KBO( :,23,15) = (/&
 & 1.8570E+03_JPRB,1.8142E+03_JPRB,1.7654E+03_JPRB,1.7168E+03_JPRB,1.6706E+03_JPRB/)  
KBO( :,24,15) = (/&
 & 1.9478E+03_JPRB,1.8990E+03_JPRB,1.8442E+03_JPRB,1.7915E+03_JPRB,1.7417E+03_JPRB/)  
KBO( :,25,15) = (/&
 & 2.0258E+03_JPRB,1.9727E+03_JPRB,1.9128E+03_JPRB,1.8556E+03_JPRB,1.8012E+03_JPRB/)  
KBO( :,26,15) = (/&
 & 2.0908E+03_JPRB,2.0335E+03_JPRB,1.9696E+03_JPRB,1.9080E+03_JPRB,1.8501E+03_JPRB/)  
KBO( :,27,15) = (/&
 & 2.1446E+03_JPRB,2.0838E+03_JPRB,2.0154E+03_JPRB,1.9506E+03_JPRB,1.8894E+03_JPRB/)  
KBO( :,28,15) = (/&
 & 2.1876E+03_JPRB,2.1227E+03_JPRB,2.0508E+03_JPRB,1.9839E+03_JPRB,1.9200E+03_JPRB/)  
KBO( :,29,15) = (/&
 & 2.2206E+03_JPRB,2.1519E+03_JPRB,2.0777E+03_JPRB,2.0084E+03_JPRB,1.9419E+03_JPRB/)  
KBO( :,30,15) = (/&
 & 2.2449E+03_JPRB,2.1734E+03_JPRB,2.0968E+03_JPRB,2.0255E+03_JPRB,1.9570E+03_JPRB/)  
KBO( :,31,15) = (/&
 & 2.2605E+03_JPRB,2.1872E+03_JPRB,2.1090E+03_JPRB,2.0359E+03_JPRB,1.9658E+03_JPRB/)  
KBO( :,32,15) = (/&
 & 2.2689E+03_JPRB,2.1943E+03_JPRB,2.1149E+03_JPRB,2.0406E+03_JPRB,1.9691E+03_JPRB/)  
KBO( :,33,15) = (/&
 & 2.2716E+03_JPRB,2.1958E+03_JPRB,2.1158E+03_JPRB,2.0406E+03_JPRB,1.9683E+03_JPRB/)  
KBO( :,34,15) = (/&
 & 2.2726E+03_JPRB,2.1959E+03_JPRB,2.1153E+03_JPRB,2.0395E+03_JPRB,1.9664E+03_JPRB/)  
KBO( :,35,15) = (/&
 & 2.2780E+03_JPRB,2.2004E+03_JPRB,2.1189E+03_JPRB,2.0426E+03_JPRB,1.9688E+03_JPRB/)  
KBO( :,36,15) = (/&
 & 2.2896E+03_JPRB,2.2110E+03_JPRB,2.1289E+03_JPRB,2.0514E+03_JPRB,1.9767E+03_JPRB/)  
KBO( :,37,15) = (/&
 & 2.3120E+03_JPRB,2.2323E+03_JPRB,2.1486E+03_JPRB,2.0699E+03_JPRB,1.9941E+03_JPRB/)  
KBO( :,38,15) = (/&
 & 2.3338E+03_JPRB,2.2528E+03_JPRB,2.1676E+03_JPRB,2.0877E+03_JPRB,2.0113E+03_JPRB/)  
KBO( :,39,15) = (/&
 & 2.3539E+03_JPRB,2.2719E+03_JPRB,2.1856E+03_JPRB,2.1045E+03_JPRB,2.0272E+03_JPRB/)  
KBO( :,40,15) = (/&
 & 2.3870E+03_JPRB,2.2992E+03_JPRB,2.2111E+03_JPRB,2.1286E+03_JPRB,2.0498E+03_JPRB/)  
KBO( :,41,15) = (/&
 & 2.4163E+03_JPRB,2.3270E+03_JPRB,2.2370E+03_JPRB,2.1533E+03_JPRB,2.0730E+03_JPRB/)  
KBO( :,42,15) = (/&
 & 2.4453E+03_JPRB,2.3543E+03_JPRB,2.2627E+03_JPRB,2.1777E+03_JPRB,2.0960E+03_JPRB/)  
KBO( :,43,15) = (/&
 & 2.4791E+03_JPRB,2.3868E+03_JPRB,2.2928E+03_JPRB,2.2066E+03_JPRB,2.1231E+03_JPRB/)  
KBO( :,44,15) = (/&
 & 2.5148E+03_JPRB,2.4212E+03_JPRB,2.3254E+03_JPRB,2.2375E+03_JPRB,2.1527E+03_JPRB/)  
KBO( :,45,15) = (/&
 & 2.5507E+03_JPRB,2.4560E+03_JPRB,2.3582E+03_JPRB,2.2685E+03_JPRB,2.1823E+03_JPRB/)  
KBO( :,46,15) = (/&
 & 2.5882E+03_JPRB,2.4891E+03_JPRB,2.3936E+03_JPRB,2.3018E+03_JPRB,2.2138E+03_JPRB/)  
KBO( :,47,15) = (/&
 & 2.6293E+03_JPRB,2.5303E+03_JPRB,2.4336E+03_JPRB,2.3391E+03_JPRB,2.2494E+03_JPRB/)  
KBO( :,48,15) = (/&
 & 2.6705E+03_JPRB,2.5712E+03_JPRB,2.4742E+03_JPRB,2.3769E+03_JPRB,2.2856E+03_JPRB/)  
KBO( :,49,15) = (/&
 & 2.7114E+03_JPRB,2.6125E+03_JPRB,2.5152E+03_JPRB,2.4156E+03_JPRB,2.3224E+03_JPRB/)  
KBO( :,50,15) = (/&
 & 2.7491E+03_JPRB,2.6508E+03_JPRB,2.5540E+03_JPRB,2.4523E+03_JPRB,2.3573E+03_JPRB/)  
KBO( :,51,15) = (/&
 & 2.7853E+03_JPRB,2.6877E+03_JPRB,2.5908E+03_JPRB,2.4896E+03_JPRB,2.3917E+03_JPRB/)  
KBO( :,52,15) = (/&
 & 2.8208E+03_JPRB,2.7242E+03_JPRB,2.6274E+03_JPRB,2.5261E+03_JPRB,2.4271E+03_JPRB/)  
KBO( :,53,15) = (/&
 & 2.8545E+03_JPRB,2.7603E+03_JPRB,2.6642E+03_JPRB,2.5626E+03_JPRB,2.4630E+03_JPRB/)  
KBO( :,54,15) = (/&
 & 2.8809E+03_JPRB,2.7931E+03_JPRB,2.6980E+03_JPRB,2.5960E+03_JPRB,2.4960E+03_JPRB/)  
KBO( :,55,15) = (/&
 & 2.9090E+03_JPRB,2.8236E+03_JPRB,2.7303E+03_JPRB,2.6276E+03_JPRB,2.5279E+03_JPRB/)  
KBO( :,56,15) = (/&
 & 2.9353E+03_JPRB,2.8536E+03_JPRB,2.7620E+03_JPRB,2.6592E+03_JPRB,2.5632E+03_JPRB/)  
KBO( :,57,15) = (/&
 & 2.9603E+03_JPRB,2.8821E+03_JPRB,2.7934E+03_JPRB,2.6910E+03_JPRB,2.5953E+03_JPRB/)  
KBO( :,58,15) = (/&
 & 2.9819E+03_JPRB,2.9080E+03_JPRB,2.8223E+03_JPRB,2.7212E+03_JPRB,2.6255E+03_JPRB/)  
KBO( :,59,15) = (/&
 & 2.9898E+03_JPRB,2.9181E+03_JPRB,2.8340E+03_JPRB,2.7333E+03_JPRB,2.6376E+03_JPRB/)  
KBO( :,13,16) = (/&
 & 9.2927E+02_JPRB,9.0834E+02_JPRB,8.8939E+02_JPRB,8.8213E+02_JPRB,8.7527E+02_JPRB/)  
KBO( :,14,16) = (/&
 & 1.1173E+03_JPRB,1.0898E+03_JPRB,1.0649E+03_JPRB,1.0517E+03_JPRB,1.0398E+03_JPRB/)  
KBO( :,15,16) = (/&
 & 1.3390E+03_JPRB,1.3003E+03_JPRB,1.2694E+03_JPRB,1.2485E+03_JPRB,1.2287E+03_JPRB/)  
KBO( :,16,16) = (/&
 & 1.5922E+03_JPRB,1.5426E+03_JPRB,1.5018E+03_JPRB,1.4720E+03_JPRB,1.4416E+03_JPRB/)  
KBO( :,17,16) = (/&
 & 1.8814E+03_JPRB,1.8176E+03_JPRB,1.7654E+03_JPRB,1.7224E+03_JPRB,1.6795E+03_JPRB/)  
KBO( :,18,16) = (/&
 & 2.2031E+03_JPRB,2.1229E+03_JPRB,2.0590E+03_JPRB,1.9971E+03_JPRB,1.9384E+03_JPRB/)  
KBO( :,19,16) = (/&
 & 2.5548E+03_JPRB,2.4553E+03_JPRB,2.3724E+03_JPRB,2.2895E+03_JPRB,2.2135E+03_JPRB/)  
KBO( :,20,16) = (/&
 & 2.9295E+03_JPRB,2.8050E+03_JPRB,2.6977E+03_JPRB,2.5929E+03_JPRB,2.4952E+03_JPRB/)  
KBO( :,21,16) = (/&
 & 3.3178E+03_JPRB,3.1609E+03_JPRB,3.0264E+03_JPRB,2.8971E+03_JPRB,2.7751E+03_JPRB/)  
KBO( :,22,16) = (/&
 & 3.6887E+03_JPRB,3.5013E+03_JPRB,3.3414E+03_JPRB,3.1845E+03_JPRB,3.0382E+03_JPRB/)  
KBO( :,23,16) = (/&
 & 4.0451E+03_JPRB,3.8382E+03_JPRB,3.6372E+03_JPRB,3.4533E+03_JPRB,3.2810E+03_JPRB/)  
KBO( :,24,16) = (/&
 & 4.3758E+03_JPRB,4.1366E+03_JPRB,3.9051E+03_JPRB,3.6946E+03_JPRB,3.4976E+03_JPRB/)  
KBO( :,25,16) = (/&
 & 4.6718E+03_JPRB,4.3974E+03_JPRB,4.1374E+03_JPRB,3.9025E+03_JPRB,3.6844E+03_JPRB/)  
KBO( :,26,16) = (/&
 & 4.9191E+03_JPRB,4.6159E+03_JPRB,4.3305E+03_JPRB,4.0724E+03_JPRB,3.8356E+03_JPRB/)  
KBO( :,27,16) = (/&
 & 5.1211E+03_JPRB,4.7932E+03_JPRB,4.4865E+03_JPRB,4.2071E+03_JPRB,3.9560E+03_JPRB/)  
KBO( :,28,16) = (/&
 & 5.2790E+03_JPRB,4.9305E+03_JPRB,4.6056E+03_JPRB,4.3100E+03_JPRB,4.0465E+03_JPRB/)  
KBO( :,29,16) = (/&
 & 5.3926E+03_JPRB,5.0282E+03_JPRB,4.6893E+03_JPRB,4.3812E+03_JPRB,4.1090E+03_JPRB/)  
KBO( :,30,16) = (/&
 & 5.4669E+03_JPRB,5.0909E+03_JPRB,4.7431E+03_JPRB,4.4273E+03_JPRB,4.1484E+03_JPRB/)  
KBO( :,31,16) = (/&
 & 5.5059E+03_JPRB,5.1237E+03_JPRB,4.7693E+03_JPRB,4.4498E+03_JPRB,4.1668E+03_JPRB/)  
KBO( :,32,16) = (/&
 & 5.5159E+03_JPRB,5.1307E+03_JPRB,4.7740E+03_JPRB,4.4530E+03_JPRB,4.1682E+03_JPRB/)  
KBO( :,33,16) = (/&
 & 5.5016E+03_JPRB,5.1180E+03_JPRB,4.7604E+03_JPRB,4.4403E+03_JPRB,4.1565E+03_JPRB/)  
KBO( :,34,16) = (/&
 & 5.4845E+03_JPRB,5.1021E+03_JPRB,4.7448E+03_JPRB,4.4256E+03_JPRB,4.1432E+03_JPRB/)  
KBO( :,35,16) = (/&
 & 5.4942E+03_JPRB,5.1092E+03_JPRB,4.7499E+03_JPRB,4.4299E+03_JPRB,4.1471E+03_JPRB/)  
KBO( :,36,16) = (/&
 & 5.5382E+03_JPRB,5.1472E+03_JPRB,4.7829E+03_JPRB,4.4591E+03_JPRB,4.1726E+03_JPRB/)  
KBO( :,37,16) = (/&
 & 5.6404E+03_JPRB,5.2373E+03_JPRB,4.8618E+03_JPRB,4.5288E+03_JPRB,4.2337E+03_JPRB/)  
KBO( :,38,16) = (/&
 & 5.7408E+03_JPRB,5.3251E+03_JPRB,4.9400E+03_JPRB,4.5977E+03_JPRB,4.2959E+03_JPRB/)  
KBO( :,39,16) = (/&
 & 5.8371E+03_JPRB,5.4104E+03_JPRB,5.0144E+03_JPRB,4.6631E+03_JPRB,4.3540E+03_JPRB/)  
KBO( :,40,16) = (/&
 & 5.9951E+03_JPRB,5.5360E+03_JPRB,5.1266E+03_JPRB,4.7607E+03_JPRB,4.4409E+03_JPRB/)  
KBO( :,41,16) = (/&
 & 6.1460E+03_JPRB,5.6683E+03_JPRB,5.2438E+03_JPRB,4.8629E+03_JPRB,4.5331E+03_JPRB/)  
KBO( :,42,16) = (/&
 & 6.2988E+03_JPRB,5.8023E+03_JPRB,5.3625E+03_JPRB,4.9665E+03_JPRB,4.6258E+03_JPRB/)  
KBO( :,43,16) = (/&
 & 6.4883E+03_JPRB,5.9649E+03_JPRB,5.5067E+03_JPRB,5.0922E+03_JPRB,4.7383E+03_JPRB/)  
KBO( :,44,16) = (/&
 & 6.6999E+03_JPRB,6.1469E+03_JPRB,5.6668E+03_JPRB,5.2323E+03_JPRB,4.8626E+03_JPRB/)  
KBO( :,45,16) = (/&
 & 6.9195E+03_JPRB,6.3372E+03_JPRB,5.8320E+03_JPRB,5.3771E+03_JPRB,4.9912E+03_JPRB/)  
KBO( :,46,16) = (/&
 & 7.1659E+03_JPRB,6.5469E+03_JPRB,6.0143E+03_JPRB,5.5360E+03_JPRB,5.1328E+03_JPRB/)  
KBO( :,47,16) = (/&
 & 7.4570E+03_JPRB,6.7935E+03_JPRB,6.2257E+03_JPRB,5.7237E+03_JPRB,5.2972E+03_JPRB/)  
KBO( :,48,16) = (/&
 & 7.7630E+03_JPRB,7.0556E+03_JPRB,6.4469E+03_JPRB,5.9204E+03_JPRB,5.4684E+03_JPRB/)  
KBO( :,49,16) = (/&
 & 8.0892E+03_JPRB,7.3332E+03_JPRB,6.6834E+03_JPRB,6.1280E+03_JPRB,5.6471E+03_JPRB/)  
KBO( :,50,16) = (/&
 & 8.4185E+03_JPRB,7.6100E+03_JPRB,6.9229E+03_JPRB,6.3324E+03_JPRB,5.8236E+03_JPRB/)  
KBO( :,51,16) = (/&
 & 8.7578E+03_JPRB,7.8949E+03_JPRB,7.1667E+03_JPRB,6.5320E+03_JPRB,6.0026E+03_JPRB/)  
KBO( :,52,16) = (/&
 & 9.1141E+03_JPRB,8.1976E+03_JPRB,7.4241E+03_JPRB,6.7492E+03_JPRB,6.1897E+03_JPRB/)  
KBO( :,53,16) = (/&
 & 9.4976E+03_JPRB,8.5191E+03_JPRB,7.6952E+03_JPRB,6.9807E+03_JPRB,6.3873E+03_JPRB/)  
KBO( :,54,16) = (/&
 & 9.8568E+03_JPRB,8.8303E+03_JPRB,7.9588E+03_JPRB,7.2035E+03_JPRB,6.5794E+03_JPRB/)  
KBO( :,55,16) = (/&
 & 1.0230E+04_JPRB,9.1463E+03_JPRB,8.2248E+03_JPRB,7.4320E+03_JPRB,6.7726E+03_JPRB/)  
KBO( :,56,16) = (/&
 & 1.0624E+04_JPRB,9.4808E+03_JPRB,8.5054E+03_JPRB,7.6701E+03_JPRB,6.9720E+03_JPRB/)  
KBO( :,57,16) = (/&
 & 1.1039E+04_JPRB,9.8338E+03_JPRB,8.8017E+03_JPRB,7.9194E+03_JPRB,7.1847E+03_JPRB/)  
KBO( :,58,16) = (/&
 & 1.1458E+04_JPRB,1.0189E+04_JPRB,9.0957E+03_JPRB,8.1671E+03_JPRB,7.3970E+03_JPRB/)  
KBO( :,59,16) = (/&
 & 1.1633E+04_JPRB,1.0336E+04_JPRB,9.2185E+03_JPRB,8.2700E+03_JPRB,7.4844E+03_JPRB/)  

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREFO( :, 1) = (/&
 & 5.95900E-01_JPRB, 5.48533E-01_JPRB, 5.04931E-01_JPRB, 4.64796E-01_JPRB, 4.27850E-01_JPRB,&
 & 3.93841E-01_JPRB, 3.62536E-01_JPRB, 3.33719E-01_JPRB, 3.07192E-01_JPRB, 2.82774E-01_JPRB/)  
SELFREFO( :, 2) = (/&
 & 7.47113E-01_JPRB, 6.83084E-01_JPRB, 6.24541E-01_JPRB, 5.71016E-01_JPRB, 5.22079E-01_JPRB,&
 & 4.77335E-01_JPRB, 4.36426E-01_JPRB, 3.99023E-01_JPRB, 3.64826E-01_JPRB, 3.33559E-01_JPRB/)  
SELFREFO( :, 3) = (/&
 & 7.85964E-01_JPRB, 7.20327E-01_JPRB, 6.60171E-01_JPRB, 6.05039E-01_JPRB, 5.54511E-01_JPRB,&
 & 5.08203E-01_JPRB, 4.65762E-01_JPRB, 4.26866E-01_JPRB, 3.91218E-01_JPRB, 3.58546E-01_JPRB/)  
SELFREFO( :, 4) = (/&
 & 8.12851E-01_JPRB, 7.45432E-01_JPRB, 6.83605E-01_JPRB, 6.26905E-01_JPRB, 5.74908E-01_JPRB,&
 & 5.27225E-01_JPRB, 4.83496E-01_JPRB, 4.43394E-01_JPRB, 4.06618E-01_JPRB, 3.72892E-01_JPRB/)  
SELFREFO( :, 5) = (/&
 & 8.13391E-01_JPRB, 7.46128E-01_JPRB, 6.84427E-01_JPRB, 6.27828E-01_JPRB, 5.75909E-01_JPRB,&
 & 5.28284E-01_JPRB, 4.84598E-01_JPRB, 4.44524E-01_JPRB, 4.07764E-01_JPRB, 3.74044E-01_JPRB/)  
SELFREFO( :, 6) = (/&
 & 8.11843E-01_JPRB, 7.44722E-01_JPRB, 6.83151E-01_JPRB, 6.26670E-01_JPRB, 5.74858E-01_JPRB,&
 & 5.27331E-01_JPRB, 4.83733E-01_JPRB, 4.43739E-01_JPRB, 4.07052E-01_JPRB, 3.73398E-01_JPRB/)  
SELFREFO( :, 7) = (/&
 & 8.13885E-01_JPRB, 7.48643E-01_JPRB, 6.88631E-01_JPRB, 6.33429E-01_JPRB, 5.82652E-01_JPRB,&
 & 5.35946E-01_JPRB, 4.92984E-01_JPRB, 4.53465E-01_JPRB, 4.17115E-01_JPRB, 3.83678E-01_JPRB/)  
SELFREFO( :, 8) = (/&
 & 8.24139E-01_JPRB, 7.57334E-01_JPRB, 6.95944E-01_JPRB, 6.39531E-01_JPRB, 5.87690E-01_JPRB,&
 & 5.40052E-01_JPRB, 4.96275E-01_JPRB, 4.56047E-01_JPRB, 4.19079E-01_JPRB, 3.85109E-01_JPRB/)  
SELFREFO( :, 9) = (/&
 & 8.30928E-01_JPRB, 7.64239E-01_JPRB, 7.02903E-01_JPRB, 6.46490E-01_JPRB, 5.94604E-01_JPRB,&
 & 5.46882E-01_JPRB, 5.02990E-01_JPRB, 4.62622E-01_JPRB, 4.25493E-01_JPRB, 3.91344E-01_JPRB/)  
SELFREFO( :,10) = (/&
 & 8.66448E-01_JPRB, 7.91238E-01_JPRB, 7.22557E-01_JPRB, 6.59838E-01_JPRB, 6.02563E-01_JPRB,&
 & 5.50259E-01_JPRB, 5.02495E-01_JPRB, 4.58878E-01_JPRB, 4.19046E-01_JPRB, 3.82672E-01_JPRB/)  
SELFREFO( :,11) = (/&
 & 8.51827E-01_JPRB, 7.79605E-01_JPRB, 7.13506E-01_JPRB, 6.53012E-01_JPRB, 5.97647E-01_JPRB,&
 & 5.46975E-01_JPRB, 5.00600E-01_JPRB, 4.58157E-01_JPRB, 4.19312E-01_JPRB, 3.83761E-01_JPRB/)  
SELFREFO( :,12) = (/&
 & 8.39267E-01_JPRB, 7.72292E-01_JPRB, 7.10661E-01_JPRB, 6.53949E-01_JPRB, 6.01762E-01_JPRB,&
 & 5.53740E-01_JPRB, 5.09550E-01_JPRB, 4.68887E-01_JPRB, 4.31469E-01_JPRB, 3.97036E-01_JPRB/)  
SELFREFO( :,13) = (/&
 & 8.36265E-01_JPRB, 7.69768E-01_JPRB, 7.08558E-01_JPRB, 6.52215E-01_JPRB, 6.00353E-01_JPRB,&
 & 5.52615E-01_JPRB, 5.08672E-01_JPRB, 4.68224E-01_JPRB, 4.30992E-01_JPRB, 3.96721E-01_JPRB/)  
SELFREFO( :,14) = (/&
 & 8.73722E-01_JPRB, 8.03395E-01_JPRB, 7.38728E-01_JPRB, 6.79267E-01_JPRB, 6.24592E-01_JPRB,&
 & 5.74318E-01_JPRB, 5.28090E-01_JPRB, 4.85583E-01_JPRB, 4.46498E-01_JPRB, 4.10559E-01_JPRB/)  
SELFREFO( :,15) = (/&
 & 9.08371E-01_JPRB, 8.34388E-01_JPRB, 7.66431E-01_JPRB, 7.04009E-01_JPRB, 6.46670E-01_JPRB,&
 & 5.94002E-01_JPRB, 5.45623E-01_JPRB, 5.01184E-01_JPRB, 4.60365E-01_JPRB, 4.22870E-01_JPRB/)  
SELFREFO( :,16) = (/&
 & 9.88709E-01_JPRB, 8.99303E-01_JPRB, 8.17981E-01_JPRB, 7.44014E-01_JPRB, 6.76735E-01_JPRB,&
 & 6.15540E-01_JPRB, 5.59878E-01_JPRB, 5.09250E-01_JPRB, 4.63200E-01_JPRB, 4.21315E-01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB11:PART7',1,ZHOOK_HANDLE)
END SUBROUTINE PART7


END SUBROUTINE RRTM_KGB11
