! $Id: strataer_nuc_mod.F90 3930 2021-06-11 19:39:09Z oboucher $
MODULE strataer_nuc_mod
! This module contains information about strato microphysic model nucleation parameters
  
  IMPLICIT NONE
  
CONTAINS
  
  ! Init all nucleation params
  SUBROUTINE strataer_nuc_init()
    
    USE ioipsl_getin_p_mod, ONLY : getin_p
    USE print_control_mod, ONLY : lunout
    USE mod_phys_lmdz_para, ONLY : is_master
    USE strataer_local_var_mod, ONLY: ALPH2SO4,flag_nuc_rate_box,nuclat_min,nuclat_max, &
         nucpres_min,nucpres_max
    
    !Config Key  = flag_nuc_rate_box
    !Config Desc = define or not a box for nucleation rate
    ! - F = global nucleation
    ! - T = 2D-box for nucleation need nuclat_min, nuclat_max, nucpres_min and
    ! nucpres_max
    !       to define its bounds.
    !Config Def  = F
    !Config Help = Used in physiq.F
    !
    CALL getin_p('flag_nuc_rate_box',flag_nuc_rate_box)
    CALL getin_p('nuclat_min',nuclat_min)
    CALL getin_p('nuclat_max',nuclat_max)
    CALL getin_p('nucpres_min',nucpres_min)
    CALL getin_p('nucpres_max',nucpres_max)
    
    ! Read argument H2SO4 accommodation  coefficient [condensation/evaporation]
    CALL getin_p('alph2so4',ALPH2SO4)
    
    !============= Print params =============
    IF (is_master) THEN
       WRITE(lunout,*) 'IN STRATAER_NUC : ALPH2SO4 = ',alph2so4
       WRITE(lunout,*) 'IN STRATAER_NUC : flag_nuc_rate_box = ',flag_nuc_rate_box
       IF (flag_nuc_rate_box) THEN
          WRITE(lunout,*) 'IN STRATAER_NUC : nuclat_min = ',nuclat_min,', nuclat_max = ',nuclat_max
          WRITE(lunout,*) 'IN STRATAER_NUC : nucpres_min = ',nucpres_min,', nucpres_max = ',nucpres_max
       ENDIF
    ENDIF ! if master
    
  END SUBROUTINE strataer_nuc_init
  
  ! Init aerosol tracers and large scale scavinging
  SUBROUTINE tracstrataer_init(aerosol,lessivage)
    
    USE infotrac_phy, ONLY: nbtr, nbtr_sulgas, id_H2SO4_strat
    USE ioipsl, ONLY : getin
    USE print_control_mod, ONLY : lunout
    
    ! Output variables
    LOGICAL,DIMENSION(nbtr), INTENT(INOUT) :: aerosol
    LOGICAL,INTENT(INOUT)                  :: lessivage
    INTEGER :: it
    
    ! Initialization
    lessivage  =.TRUE.
    aerosol(:) = .FALSE.
    
    DO it= 1, nbtr_sulgas
       aerosol(it)=.FALSE.
       IF (it==id_H2SO4_strat) aerosol(it)=.TRUE.
    ENDDO
    DO it= nbtr_sulgas+1, nbtr
       aerosol(it)=.TRUE.
    ENDDO
    
    !!jyg(20130206) : le choix d activation du lessivage est fait dans phytrac avec iflag_lscav
!    CALL getin('lessivage',lessivage)
    WRITE(lunout,*) 'IN TRACSTRATAER_INIT lessivage: ',lessivage
    
  END SUBROUTINE tracstrataer_init
  
END MODULE strataer_nuc_mod
