!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif 
SUBROUTINE SRTM_KGB25

!     Originally by J.Delamere, Atmospheric & Environmental Research.
!     Revision: 2.4
!     BAND 25: 16000-22650 cm-1 (low - H2O; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOESRTA25, ONLY : KA, SFLUXREF, RAYL, ABSO3A, ABSO3B &
 & , LAYREFFR  

!     ------------------------------------------------------------------

IMPLICIT NONE

! KURUCZ
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB25',0,ZHOOK_HANDLE)
SFLUXREF = (/ &
 & 42.6858_JPRB , 45.7720_JPRB, 44.9872_JPRB, 45.9662_JPRB    , &
 & 46.5458_JPRB , 41.6926_JPRB, 32.2893_JPRB, 24.0928_JPRB    , &
 & 16.7686_JPRB , 1.86048_JPRB, 1.54057_JPRB, 1.23503_JPRB    , &
 & 0.915085_JPRB,0.590099_JPRB,0.218622_JPRB, 3.21287E-02_JPRB /)  

!     Rayleigh extinction coefficient at v = 2925 cm-1.
RAYL = (/ &
 & 9.81132E-07_JPRB,8.25605E-07_JPRB,6.71302E-07_JPRB,5.53556E-07_JPRB,  &
 & 3.97383E-07_JPRB,3.68206E-07_JPRB,4.42379E-07_JPRB,4.57799E-07_JPRB, &
 & 4.22683E-07_JPRB,3.87113E-07_JPRB,3.79810E-07_JPRB,3.63192E-07_JPRB, &
 & 3.51921E-07_JPRB,3.34231E-07_JPRB,3.34294E-07_JPRB,3.32673E-07_JPRB /)  
     
ABSO3A = (/ &
 & 2.32664E-02_JPRB,5.76154E-02_JPRB,0.125389_JPRB,0.250158_JPRB, &
 & 0.378756_JPRB   ,0.402196_JPRB   ,0.352026_JPRB,0.352036_JPRB, &
 & 0.386253_JPRB   ,0.414598_JPRB   ,0.420079_JPRB,0.435471_JPRB, &
 & 0.445487_JPRB   ,0.459549_JPRB   ,0.452920_JPRB,0.456838_JPRB /)  

ABSO3B = (/      &
 & 1.76917E-02_JPRB,4.64185E-02_JPRB,1.03640E-01_JPRB,0.189469_JPRB, &
 & 0.303858_JPRB   ,0.400248_JPRB   ,0.447357_JPRB   ,0.470009_JPRB, &
 & 0.498673_JPRB   ,0.515696_JPRB   ,0.517053_JPRB   ,0.517930_JPRB, &
 & 0.518345_JPRB   ,0.524952_JPRB   ,0.508244_JPRB   ,0.468981_JPRB /)  

LAYREFFR = 2

!     ------------------------------------------------------------------

!     The array KA contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KA(:, 1, 1) = (/ &
 & 0.16461E-08_JPRB,0.16782E-08_JPRB,0.19339E-08_JPRB,0.17100E-08_JPRB,0.17045E-08_JPRB /)  
KA(:, 2, 1) = (/ &
 & 0.28759E-08_JPRB,0.29469E-08_JPRB,0.33789E-08_JPRB,0.34357E-08_JPRB,0.28833E-08_JPRB /)  
KA(:, 3, 1) = (/ &
 & 0.55148E-08_JPRB,0.54808E-08_JPRB,0.54190E-08_JPRB,0.68260E-08_JPRB,0.51972E-08_JPRB /)  
KA(:, 4, 1) = (/ &
 & 0.95336E-08_JPRB,0.94552E-08_JPRB,0.93001E-08_JPRB,0.90961E-08_JPRB,0.14451E-07_JPRB /)  
KA(:, 5, 1) = (/ &
 & 0.14930E-07_JPRB,0.14736E-07_JPRB,0.14432E-07_JPRB,0.14074E-07_JPRB,0.24102E-07_JPRB /)  
KA(:, 6, 1) = (/ &
 & 0.22770E-07_JPRB,0.22301E-07_JPRB,0.21778E-07_JPRB,0.21194E-07_JPRB,0.20569E-07_JPRB /)  
KA(:, 7, 1) = (/ &
 & 0.34699E-07_JPRB,0.33951E-07_JPRB,0.33124E-07_JPRB,0.32144E-07_JPRB,0.31220E-07_JPRB /)  
KA(:, 8, 1) = (/ &
 & 0.62339E-07_JPRB,0.60405E-07_JPRB,0.59548E-07_JPRB,0.58214E-07_JPRB,0.56977E-07_JPRB /)  
KA(:, 9, 1) = (/ &
 & 0.17411E-06_JPRB,0.17654E-06_JPRB,0.18315E-06_JPRB,0.18100E-06_JPRB,0.17839E-06_JPRB /)  
KA(:,10, 1) = (/ &
 & 0.23526E-06_JPRB,0.22729E-06_JPRB,0.21947E-06_JPRB,0.21188E-06_JPRB,0.20454E-06_JPRB /)  
KA(:,11, 1) = (/ &
 & 0.23535E-06_JPRB,0.22737E-06_JPRB,0.21956E-06_JPRB,0.21196E-06_JPRB,0.20461E-06_JPRB /)  
KA(:,12, 1) = (/ &
 & 0.23539E-06_JPRB,0.22740E-06_JPRB,0.21959E-06_JPRB,0.21199E-06_JPRB,0.20465E-06_JPRB /)  
KA(:,13, 1) = (/ &
 & 0.23543E-06_JPRB,0.22744E-06_JPRB,0.21962E-06_JPRB,0.21202E-06_JPRB,0.20467E-06_JPRB /)  
KA(:, 1, 2) = (/ &
 & 0.62912E-08_JPRB,0.61559E-08_JPRB,0.84640E-08_JPRB,0.59240E-08_JPRB,0.58217E-08_JPRB /)  
KA(:, 2, 2) = (/ &
 & 0.83749E-08_JPRB,0.80756E-08_JPRB,0.11623E-07_JPRB,0.11272E-07_JPRB,0.73636E-08_JPRB /)  
KA(:, 3, 2) = (/ &
 & 0.13304E-07_JPRB,0.12795E-07_JPRB,0.12343E-07_JPRB,0.21235E-07_JPRB,0.11577E-07_JPRB /)  
KA(:, 4, 2) = (/ &
 & 0.20704E-07_JPRB,0.19736E-07_JPRB,0.18900E-07_JPRB,0.18228E-07_JPRB,0.31601E-07_JPRB /)  
KA(:, 5, 2) = (/ &
 & 0.31149E-07_JPRB,0.29669E-07_JPRB,0.28318E-07_JPRB,0.27101E-07_JPRB,0.49649E-07_JPRB /)  
KA(:, 6, 2) = (/ &
 & 0.45713E-07_JPRB,0.43519E-07_JPRB,0.41488E-07_JPRB,0.39918E-07_JPRB,0.38291E-07_JPRB /)  
KA(:, 7, 2) = (/ &
 & 0.77265E-07_JPRB,0.73848E-07_JPRB,0.70437E-07_JPRB,0.67945E-07_JPRB,0.66127E-07_JPRB /)  
KA(:, 8, 2) = (/ &
 & 0.15754E-06_JPRB,0.15664E-06_JPRB,0.15378E-06_JPRB,0.15027E-06_JPRB,0.14633E-06_JPRB /)  
KA(:, 9, 2) = (/ &
 & 0.16439E-06_JPRB,0.14678E-06_JPRB,0.12610E-06_JPRB,0.11532E-06_JPRB,0.10591E-06_JPRB /)  
KA(:,10, 2) = (/ &
 & 0.14366E-06_JPRB,0.13506E-06_JPRB,0.12583E-06_JPRB,0.11774E-06_JPRB,0.11011E-06_JPRB /)  
KA(:,11, 2) = (/ &
 & 0.14521E-06_JPRB,0.13766E-06_JPRB,0.13072E-06_JPRB,0.12218E-06_JPRB,0.11400E-06_JPRB /)  
KA(:,12, 2) = (/ &
 & 0.14524E-06_JPRB,0.13769E-06_JPRB,0.13074E-06_JPRB,0.12241E-06_JPRB,0.11552E-06_JPRB /)  
KA(:,13, 2) = (/ &
 & 0.14525E-06_JPRB,0.13770E-06_JPRB,0.13075E-06_JPRB,0.12252E-06_JPRB,0.11553E-06_JPRB /)  
KA(:, 1, 3) = (/ &
 & 0.14060E-07_JPRB,0.13587E-07_JPRB,0.24644E-07_JPRB,0.12716E-07_JPRB,0.12367E-07_JPRB /)  
KA(:, 2, 3) = (/ &
 & 0.17055E-07_JPRB,0.16577E-07_JPRB,0.32443E-07_JPRB,0.31273E-07_JPRB,0.15381E-07_JPRB /)  
KA(:, 3, 3) = (/ &
 & 0.25414E-07_JPRB,0.24672E-07_JPRB,0.23874E-07_JPRB,0.47281E-07_JPRB,0.22346E-07_JPRB /)  
KA(:, 4, 3) = (/ &
 & 0.39536E-07_JPRB,0.38124E-07_JPRB,0.36836E-07_JPRB,0.35587E-07_JPRB,0.72260E-07_JPRB /)  
KA(:, 5, 3) = (/ &
 & 0.59488E-07_JPRB,0.57630E-07_JPRB,0.55623E-07_JPRB,0.53878E-07_JPRB,0.11230E-06_JPRB /)  
KA(:, 6, 3) = (/ &
 & 0.99996E-07_JPRB,0.96206E-07_JPRB,0.93184E-07_JPRB,0.90812E-07_JPRB,0.89206E-07_JPRB /)  
KA(:, 7, 3) = (/ &
 & 0.17678E-06_JPRB,0.17554E-06_JPRB,0.17358E-06_JPRB,0.17091E-06_JPRB,0.16830E-06_JPRB /)  
KA(:, 8, 3) = (/ &
 & 0.18672E-06_JPRB,0.17850E-06_JPRB,0.16967E-06_JPRB,0.16275E-06_JPRB,0.15875E-06_JPRB /)  
KA(:, 9, 3) = (/ &
 & 0.13558E-06_JPRB,0.13493E-06_JPRB,0.13633E-06_JPRB,0.13799E-06_JPRB,0.13932E-06_JPRB /)  
KA(:,10, 3) = (/ &
 & 0.18883E-06_JPRB,0.20452E-06_JPRB,0.22206E-06_JPRB,0.24347E-06_JPRB,0.26091E-06_JPRB /)  
KA(:,11, 3) = (/ &
 & 0.21296E-06_JPRB,0.23580E-06_JPRB,0.26439E-06_JPRB,0.30148E-06_JPRB,0.34942E-06_JPRB /)  
KA(:,12, 3) = (/ &
 & 0.22072E-06_JPRB,0.25535E-06_JPRB,0.28661E-06_JPRB,0.34814E-06_JPRB,0.39337E-06_JPRB /)  
KA(:,13, 3) = (/ &
 & 0.22515E-06_JPRB,0.26161E-06_JPRB,0.30833E-06_JPRB,0.36527E-06_JPRB,0.40123E-06_JPRB /)  
KA(:, 1, 4) = (/ &
 & 0.32735E-07_JPRB,0.31345E-07_JPRB,0.58846E-07_JPRB,0.28258E-07_JPRB,0.27022E-07_JPRB /)  
KA(:, 2, 4) = (/ &
 & 0.37754E-07_JPRB,0.36873E-07_JPRB,0.82776E-07_JPRB,0.80947E-07_JPRB,0.35190E-07_JPRB /)  
KA(:, 3, 4) = (/ &
 & 0.76368E-07_JPRB,0.75292E-07_JPRB,0.74075E-07_JPRB,0.10820E-06_JPRB,0.73183E-07_JPRB /)  
KA(:, 4, 4) = (/ &
 & 0.16392E-06_JPRB,0.16130E-06_JPRB,0.15926E-06_JPRB,0.15700E-06_JPRB,0.22041E-06_JPRB /)  
KA(:, 5, 4) = (/ &
 & 0.29704E-06_JPRB,0.28924E-06_JPRB,0.28301E-06_JPRB,0.27633E-06_JPRB,0.42284E-06_JPRB /)  
KA(:, 6, 4) = (/ &
 & 0.48466E-06_JPRB,0.47240E-06_JPRB,0.46143E-06_JPRB,0.45012E-06_JPRB,0.43867E-06_JPRB /)  
KA(:, 7, 4) = (/ &
 & 0.71637E-06_JPRB,0.69847E-06_JPRB,0.67384E-06_JPRB,0.65368E-06_JPRB,0.63375E-06_JPRB /)  
KA(:, 8, 4) = (/ &
 & 0.11904E-05_JPRB,0.11714E-05_JPRB,0.11524E-05_JPRB,0.11354E-05_JPRB,0.11172E-05_JPRB /)  
KA(:, 9, 4) = (/ &
 & 0.21976E-05_JPRB,0.21606E-05_JPRB,0.21332E-05_JPRB,0.20944E-05_JPRB,0.20536E-05_JPRB /)  
KA(:,10, 4) = (/ &
 & 0.21713E-05_JPRB,0.21144E-05_JPRB,0.20553E-05_JPRB,0.19901E-05_JPRB,0.19286E-05_JPRB /)  
KA(:,11, 4) = (/ &
 & 0.21443E-05_JPRB,0.20785E-05_JPRB,0.20048E-05_JPRB,0.19232E-05_JPRB,0.18295E-05_JPRB /)  
KA(:,12, 4) = (/ &
 & 0.21363E-05_JPRB,0.20578E-05_JPRB,0.19811E-05_JPRB,0.18729E-05_JPRB,0.17807E-05_JPRB /)  
KA(:,13, 4) = (/ &
 & 0.21319E-05_JPRB,0.20513E-05_JPRB,0.19580E-05_JPRB,0.18546E-05_JPRB,0.17725E-05_JPRB /)  
KA(:, 1, 5) = (/ &
 & 0.36050E-07_JPRB,0.36125E-07_JPRB,0.46253E-07_JPRB,0.37280E-07_JPRB,0.37359E-07_JPRB /)  
KA(:, 2, 5) = (/ &
 & 0.65102E-07_JPRB,0.64266E-07_JPRB,0.68896E-07_JPRB,0.65925E-07_JPRB,0.61190E-07_JPRB /)  
KA(:, 3, 5) = (/ &
 & 0.12173E-06_JPRB,0.11889E-06_JPRB,0.11625E-06_JPRB,0.17574E-06_JPRB,0.10921E-06_JPRB /)  
KA(:, 4, 5) = (/ &
 & 0.20555E-06_JPRB,0.19853E-06_JPRB,0.19068E-06_JPRB,0.18313E-06_JPRB,0.30241E-06_JPRB /)  
KA(:, 5, 5) = (/ &
 & 0.30900E-06_JPRB,0.29996E-06_JPRB,0.28857E-06_JPRB,0.27772E-06_JPRB,0.51631E-06_JPRB /)  
KA(:, 6, 5) = (/ &
 & 0.43774E-06_JPRB,0.42465E-06_JPRB,0.40920E-06_JPRB,0.39315E-06_JPRB,0.37901E-06_JPRB /)  
KA(:, 7, 5) = (/ &
 & 0.63869E-06_JPRB,0.61654E-06_JPRB,0.60324E-06_JPRB,0.58966E-06_JPRB,0.57948E-06_JPRB /)  
KA(:, 8, 5) = (/ &
 & 0.98362E-06_JPRB,0.96271E-06_JPRB,0.94180E-06_JPRB,0.92206E-06_JPRB,0.91105E-06_JPRB /)  
KA(:, 9, 5) = (/ &
 & 0.12061E-05_JPRB,0.11895E-05_JPRB,0.11564E-05_JPRB,0.11296E-05_JPRB,0.11110E-05_JPRB /)  
KA(:,10, 5) = (/ &
 & 0.12958E-05_JPRB,0.12694E-05_JPRB,0.12425E-05_JPRB,0.12153E-05_JPRB,0.11880E-05_JPRB /)  
KA(:,11, 5) = (/ &
 & 0.12962E-05_JPRB,0.12698E-05_JPRB,0.12429E-05_JPRB,0.12156E-05_JPRB,0.11883E-05_JPRB /)  
KA(:,12, 5) = (/ &
 & 0.12964E-05_JPRB,0.12701E-05_JPRB,0.12431E-05_JPRB,0.12158E-05_JPRB,0.11885E-05_JPRB /)  
KA(:,13, 5) = (/ &
 & 0.12966E-05_JPRB,0.12702E-05_JPRB,0.12433E-05_JPRB,0.12160E-05_JPRB,0.11886E-05_JPRB /)  
KA(:, 1, 6) = (/ &
 & 0.73925E-07_JPRB,0.70231E-07_JPRB,0.21454E-06_JPRB,0.63477E-07_JPRB,0.60912E-07_JPRB /)  
KA(:, 2, 6) = (/ &
 & 0.67794E-07_JPRB,0.65807E-07_JPRB,0.13854E-06_JPRB,0.13061E-06_JPRB,0.59361E-07_JPRB /)  
KA(:, 3, 6) = (/ &
 & 0.98353E-07_JPRB,0.95275E-07_JPRB,0.92426E-07_JPRB,0.15768E-06_JPRB,0.87986E-07_JPRB /)  
KA(:, 4, 6) = (/ &
 & 0.15855E-06_JPRB,0.15394E-06_JPRB,0.14948E-06_JPRB,0.14655E-06_JPRB,0.23172E-06_JPRB /)  
KA(:, 5, 6) = (/ &
 & 0.27764E-06_JPRB,0.26941E-06_JPRB,0.26299E-06_JPRB,0.25975E-06_JPRB,0.40526E-06_JPRB /)  
KA(:, 6, 6) = (/ &
 & 0.45469E-06_JPRB,0.44417E-06_JPRB,0.43276E-06_JPRB,0.42440E-06_JPRB,0.41489E-06_JPRB /)  
KA(:, 7, 6) = (/ &
 & 0.71540E-06_JPRB,0.71291E-06_JPRB,0.70656E-06_JPRB,0.69823E-06_JPRB,0.68342E-06_JPRB /)  
KA(:, 8, 6) = (/ &
 & 0.79651E-06_JPRB,0.79807E-06_JPRB,0.80621E-06_JPRB,0.80941E-06_JPRB,0.79835E-06_JPRB /)  
KA(:, 9, 6) = (/ &
 & 0.18716E-06_JPRB,0.16713E-06_JPRB,0.14725E-06_JPRB,0.13728E-06_JPRB,0.11763E-06_JPRB /)  
KA(:,10, 6) = (/ &
 & 0.92638E-07_JPRB,0.86207E-07_JPRB,0.80877E-07_JPRB,0.70432E-07_JPRB,0.64517E-07_JPRB /)  
KA(:,11, 6) = (/ &
 & 0.13396E-06_JPRB,0.12820E-06_JPRB,0.12387E-06_JPRB,0.10427E-06_JPRB,0.94091E-07_JPRB /)  
KA(:,12, 6) = (/ &
 & 0.14877E-06_JPRB,0.14827E-06_JPRB,0.14350E-06_JPRB,0.12154E-06_JPRB,0.10552E-06_JPRB /)  
KA(:,13, 6) = (/ &
 & 0.15437E-06_JPRB,0.15323E-06_JPRB,0.14992E-06_JPRB,0.12715E-06_JPRB,0.10933E-06_JPRB /)  
KA(:, 1, 7) = (/ &
 & 0.72717E-06_JPRB,0.70656E-06_JPRB,0.13933E-05_JPRB,0.66449E-06_JPRB,0.64269E-06_JPRB /)  
KA(:, 2, 7) = (/ &
 & 0.52595E-06_JPRB,0.50791E-06_JPRB,0.11171E-05_JPRB,0.10538E-05_JPRB,0.45644E-06_JPRB /)  
KA(:, 3, 7) = (/ &
 & 0.29919E-06_JPRB,0.29227E-06_JPRB,0.28284E-06_JPRB,0.65215E-06_JPRB,0.26347E-06_JPRB /)  
KA(:, 4, 7) = (/ &
 & 0.27961E-06_JPRB,0.27579E-06_JPRB,0.27068E-06_JPRB,0.26343E-06_JPRB,0.41265E-06_JPRB /)  
KA(:, 5, 7) = (/ &
 & 0.37031E-06_JPRB,0.36318E-06_JPRB,0.35475E-06_JPRB,0.34488E-06_JPRB,0.53740E-06_JPRB /)  
KA(:, 6, 7) = (/ &
 & 0.53195E-06_JPRB,0.52692E-06_JPRB,0.52224E-06_JPRB,0.51934E-06_JPRB,0.51146E-06_JPRB /)  
KA(:, 7, 7) = (/ &
 & 0.83043E-06_JPRB,0.84552E-06_JPRB,0.84833E-06_JPRB,0.82800E-06_JPRB,0.80930E-06_JPRB /)  
KA(:, 8, 7) = (/ &
 & 0.14910E-05_JPRB,0.15179E-05_JPRB,0.15248E-05_JPRB,0.15091E-05_JPRB,0.14853E-05_JPRB /)  
KA(:, 9, 7) = (/ &
 & 0.37340E-05_JPRB,0.37823E-05_JPRB,0.38311E-05_JPRB,0.38453E-05_JPRB,0.38567E-05_JPRB /)  
KA(:,10, 7) = (/ &
 & 0.86791E-05_JPRB,0.89697E-05_JPRB,0.92118E-05_JPRB,0.93991E-05_JPRB,0.95564E-05_JPRB /)  
KA(:,11, 7) = (/ &
 & 0.11878E-04_JPRB,0.12201E-04_JPRB,0.12588E-04_JPRB,0.12897E-04_JPRB,0.13151E-04_JPRB /)  
KA(:,12, 7) = (/ &
 & 0.13192E-04_JPRB,0.13732E-04_JPRB,0.14137E-04_JPRB,0.14465E-04_JPRB,0.14643E-04_JPRB /)  
KA(:,13, 7) = (/ &
 & 0.13716E-04_JPRB,0.14229E-04_JPRB,0.14617E-04_JPRB,0.14944E-04_JPRB,0.15182E-04_JPRB /)  
KA(:, 1, 8) = (/ &
 & 0.39538E-05_JPRB,0.38949E-05_JPRB,0.56188E-05_JPRB,0.37475E-05_JPRB,0.36648E-05_JPRB /)  
KA(:, 2, 8) = (/ &
 & 0.34231E-05_JPRB,0.33633E-05_JPRB,0.51877E-05_JPRB,0.50048E-05_JPRB,0.31425E-05_JPRB /)  
KA(:, 3, 8) = (/ &
 & 0.28073E-05_JPRB,0.27497E-05_JPRB,0.26875E-05_JPRB,0.44405E-05_JPRB,0.25492E-05_JPRB /)  
KA(:, 4, 8) = (/ &
 & 0.19229E-05_JPRB,0.18818E-05_JPRB,0.18382E-05_JPRB,0.17896E-05_JPRB,0.33073E-05_JPRB /)  
KA(:, 5, 8) = (/ &
 & 0.11453E-05_JPRB,0.11293E-05_JPRB,0.11095E-05_JPRB,0.10866E-05_JPRB,0.19344E-05_JPRB /)  
KA(:, 6, 8) = (/ &
 & 0.14565E-05_JPRB,0.14517E-05_JPRB,0.14369E-05_JPRB,0.14141E-05_JPRB,0.13944E-05_JPRB /)  
KA(:, 7, 8) = (/ &
 & 0.23228E-05_JPRB,0.22753E-05_JPRB,0.22395E-05_JPRB,0.22124E-05_JPRB,0.21731E-05_JPRB /)  
KA(:, 8, 8) = (/ &
 & 0.34877E-05_JPRB,0.34362E-05_JPRB,0.33796E-05_JPRB,0.33389E-05_JPRB,0.32924E-05_JPRB /)  
KA(:, 9, 8) = (/ &
 & 0.63448E-05_JPRB,0.63701E-05_JPRB,0.63619E-05_JPRB,0.62632E-05_JPRB,0.61645E-05_JPRB /)  
KA(:,10, 8) = (/ &
 & 0.12155E-04_JPRB,0.11880E-04_JPRB,0.11762E-04_JPRB,0.11759E-04_JPRB,0.11651E-04_JPRB /)  
KA(:,11, 8) = (/ &
 & 0.14093E-04_JPRB,0.13835E-04_JPRB,0.13547E-04_JPRB,0.13205E-04_JPRB,0.12690E-04_JPRB /)  
KA(:,12, 8) = (/ &
 & 0.14428E-04_JPRB,0.14056E-04_JPRB,0.13932E-04_JPRB,0.13396E-04_JPRB,0.12885E-04_JPRB /)  
KA(:,13, 8) = (/ &
 & 0.15229E-04_JPRB,0.14534E-04_JPRB,0.13849E-04_JPRB,0.13292E-04_JPRB,0.12704E-04_JPRB /)  
KA(:, 1, 9) = (/ &
 & 0.19250E-04_JPRB,0.19148E-04_JPRB,0.21702E-04_JPRB,0.18906E-04_JPRB,0.18761E-04_JPRB /)  
KA(:, 2, 9) = (/ &
 & 0.18132E-04_JPRB,0.18040E-04_JPRB,0.20884E-04_JPRB,0.20523E-04_JPRB,0.17656E-04_JPRB /)  
KA(:, 3, 9) = (/ &
 & 0.16928E-04_JPRB,0.16843E-04_JPRB,0.16742E-04_JPRB,0.19715E-04_JPRB,0.16470E-04_JPRB /)  
KA(:, 4, 9) = (/ &
 & 0.15526E-04_JPRB,0.15463E-04_JPRB,0.15377E-04_JPRB,0.15268E-04_JPRB,0.18367E-04_JPRB /)  
KA(:, 5, 9) = (/ &
 & 0.13545E-04_JPRB,0.13511E-04_JPRB,0.13455E-04_JPRB,0.13362E-04_JPRB,0.16722E-04_JPRB /)  
KA(:, 6, 9) = (/ &
 & 0.97183E-05_JPRB,0.97218E-05_JPRB,0.97084E-05_JPRB,0.96717E-05_JPRB,0.96030E-05_JPRB /)  
KA(:, 7, 9) = (/ &
 & 0.50307E-05_JPRB,0.50984E-05_JPRB,0.51628E-05_JPRB,0.52093E-05_JPRB,0.52354E-05_JPRB /)  
KA(:, 8, 9) = (/ &
 & 0.45837E-05_JPRB,0.45939E-05_JPRB,0.45938E-05_JPRB,0.45639E-05_JPRB,0.45109E-05_JPRB /)  
KA(:, 9, 9) = (/ &
 & 0.12254E-04_JPRB,0.12319E-04_JPRB,0.12397E-04_JPRB,0.12584E-04_JPRB,0.12620E-04_JPRB /)  
KA(:,10, 9) = (/ &
 & 0.21545E-04_JPRB,0.21836E-04_JPRB,0.21718E-04_JPRB,0.21511E-04_JPRB,0.21211E-04_JPRB /)  
KA(:,11, 9) = (/ &
 & 0.20079E-04_JPRB,0.19539E-04_JPRB,0.18859E-04_JPRB,0.18393E-04_JPRB,0.18181E-04_JPRB /)  
KA(:,12, 9) = (/ &
 & 0.17115E-04_JPRB,0.16357E-04_JPRB,0.15410E-04_JPRB,0.15220E-04_JPRB,0.15207E-04_JPRB /)  
KA(:,13, 9) = (/ &
 & 0.14935E-04_JPRB,0.14679E-04_JPRB,0.14593E-04_JPRB,0.14448E-04_JPRB,0.14436E-04_JPRB /)  
KA(:, 1,10) = (/ &
 & 0.53569E-04_JPRB,0.53042E-04_JPRB,0.55454E-04_JPRB,0.52098E-04_JPRB,0.51678E-04_JPRB /)  
KA(:, 2,10) = (/ &
 & 0.52196E-04_JPRB,0.51739E-04_JPRB,0.54777E-04_JPRB,0.54075E-04_JPRB,0.50624E-04_JPRB /)  
KA(:, 3,10) = (/ &
 & 0.50339E-04_JPRB,0.50046E-04_JPRB,0.49769E-04_JPRB,0.53168E-04_JPRB,0.49370E-04_JPRB /)  
KA(:, 4,10) = (/ &
 & 0.48505E-04_JPRB,0.48316E-04_JPRB,0.48143E-04_JPRB,0.47993E-04_JPRB,0.51621E-04_JPRB /)  
KA(:, 5,10) = (/ &
 & 0.46313E-04_JPRB,0.46267E-04_JPRB,0.46119E-04_JPRB,0.46064E-04_JPRB,0.50279E-04_JPRB /)  
KA(:, 6,10) = (/ &
 & 0.42662E-04_JPRB,0.42818E-04_JPRB,0.42935E-04_JPRB,0.43007E-04_JPRB,0.43099E-04_JPRB /)  
KA(:, 7,10) = (/ &
 & 0.35762E-04_JPRB,0.36149E-04_JPRB,0.36450E-04_JPRB,0.36639E-04_JPRB,0.36887E-04_JPRB /)  
KA(:, 8,10) = (/ &
 & 0.13516E-05_JPRB,0.18607E-05_JPRB,0.23061E-05_JPRB,0.27339E-05_JPRB,0.36516E-05_JPRB /)  
KA(:, 9,10) = (/ &
 & 0.36432E-05_JPRB,0.40739E-05_JPRB,0.43830E-05_JPRB,0.41136E-05_JPRB,0.43128E-05_JPRB /)  
KA(:,10,10) = (/ &
 & 0.62049E-05_JPRB,0.69116E-05_JPRB,0.73244E-05_JPRB,0.65087E-05_JPRB,0.78951E-05_JPRB /)  
KA(:,11,10) = (/ &
 & 0.32156E-05_JPRB,0.38834E-05_JPRB,0.41231E-05_JPRB,0.43386E-05_JPRB,0.43405E-05_JPRB /)  
KA(:,12,10) = (/ &
 & 0.22152E-05_JPRB,0.26754E-05_JPRB,0.31971E-05_JPRB,0.34911E-05_JPRB,0.37935E-05_JPRB /)  
KA(:,13,10) = (/ &
 & 0.19792E-05_JPRB,0.26543E-05_JPRB,0.31511E-05_JPRB,0.34597E-05_JPRB,0.40624E-05_JPRB /)  
KA(:, 1,11) = (/ &
 & 0.75384E-04_JPRB,0.75103E-04_JPRB,0.77406E-04_JPRB,0.74222E-04_JPRB,0.73734E-04_JPRB /)  
KA(:, 2,11) = (/ &
 & 0.75458E-04_JPRB,0.75244E-04_JPRB,0.77778E-04_JPRB,0.77018E-04_JPRB,0.73942E-04_JPRB /)  
KA(:, 3,11) = (/ &
 & 0.75023E-04_JPRB,0.74844E-04_JPRB,0.74477E-04_JPRB,0.77271E-04_JPRB,0.73633E-04_JPRB /)  
KA(:, 4,11) = (/ &
 & 0.73633E-04_JPRB,0.73539E-04_JPRB,0.73257E-04_JPRB,0.72934E-04_JPRB,0.76232E-04_JPRB /)  
KA(:, 5,11) = (/ &
 & 0.71348E-04_JPRB,0.71322E-04_JPRB,0.71227E-04_JPRB,0.71069E-04_JPRB,0.75258E-04_JPRB /)  
KA(:, 6,11) = (/ &
 & 0.67784E-04_JPRB,0.67873E-04_JPRB,0.67974E-04_JPRB,0.67924E-04_JPRB,0.67903E-04_JPRB /)  
KA(:, 7,11) = (/ &
 & 0.61855E-04_JPRB,0.61922E-04_JPRB,0.61973E-04_JPRB,0.62206E-04_JPRB,0.62496E-04_JPRB /)  
KA(:, 8,11) = (/ &
 & 0.36622E-04_JPRB,0.37413E-04_JPRB,0.38740E-04_JPRB,0.40550E-04_JPRB,0.41833E-04_JPRB /)  
KA(:, 9,11) = (/ &
 & 0.28544E-05_JPRB,0.28831E-05_JPRB,0.31445E-05_JPRB,0.32900E-05_JPRB,0.27967E-05_JPRB /)  
KA(:,10,11) = (/ &
 & 0.53755E-05_JPRB,0.42123E-05_JPRB,0.51154E-05_JPRB,0.63481E-05_JPRB,0.54219E-05_JPRB /)  
KA(:,11,11) = (/ &
 & 0.12605E-05_JPRB,0.14078E-05_JPRB,0.19167E-05_JPRB,0.23729E-05_JPRB,0.30161E-05_JPRB /)  
KA(:,12,11) = (/ &
 & 0.11370E-05_JPRB,0.91524E-06_JPRB,0.11150E-05_JPRB,0.14746E-05_JPRB,0.20128E-05_JPRB /)  
KA(:,13,11) = (/ &
 & 0.10511E-05_JPRB,0.10014E-05_JPRB,0.11405E-05_JPRB,0.13852E-05_JPRB,0.15576E-05_JPRB /)  
KA(:, 1,12) = (/ &
 & 0.11184E-03_JPRB,0.11117E-03_JPRB,0.11327E-03_JPRB,0.10989E-03_JPRB,0.10910E-03_JPRB /)  
KA(:, 2,12) = (/ &
 & 0.11379E-03_JPRB,0.11322E-03_JPRB,0.11555E-03_JPRB,0.11462E-03_JPRB,0.11135E-03_JPRB /)  
KA(:, 3,12) = (/ &
 & 0.11508E-03_JPRB,0.11459E-03_JPRB,0.11421E-03_JPRB,0.11671E-03_JPRB,0.11339E-03_JPRB /)  
KA(:, 4,12) = (/ &
 & 0.11596E-03_JPRB,0.11563E-03_JPRB,0.11538E-03_JPRB,0.11511E-03_JPRB,0.11770E-03_JPRB /)  
KA(:, 5,12) = (/ &
 & 0.11597E-03_JPRB,0.11581E-03_JPRB,0.11569E-03_JPRB,0.11553E-03_JPRB,0.11890E-03_JPRB /)  
KA(:, 6,12) = (/ &
 & 0.11443E-03_JPRB,0.11445E-03_JPRB,0.11443E-03_JPRB,0.11443E-03_JPRB,0.11438E-03_JPRB /)  
KA(:, 7,12) = (/ &
 & 0.10852E-03_JPRB,0.10888E-03_JPRB,0.10912E-03_JPRB,0.10934E-03_JPRB,0.10942E-03_JPRB /)  
KA(:, 8,12) = (/ &
 & 0.93194E-04_JPRB,0.94766E-04_JPRB,0.95355E-04_JPRB,0.95090E-04_JPRB,0.94926E-04_JPRB /)  
KA(:, 9,12) = (/ &
 & 0.11836E-05_JPRB,0.16115E-05_JPRB,0.12883E-05_JPRB,0.14202E-05_JPRB,0.16541E-05_JPRB /)  
KA(:,10,12) = (/ &
 & 0.18748E-05_JPRB,0.34401E-05_JPRB,0.39984E-05_JPRB,0.44576E-05_JPRB,0.33683E-05_JPRB /)  
KA(:,11,12) = (/ &
 & 0.29890E-06_JPRB,0.48741E-06_JPRB,0.66276E-06_JPRB,0.99698E-06_JPRB,0.19230E-05_JPRB /)  
KA(:,12,12) = (/ &
 & 0.15034E-06_JPRB,0.39966E-06_JPRB,0.56523E-06_JPRB,0.70494E-06_JPRB,0.10046E-05_JPRB /)  
KA(:,13,12) = (/ &
 & 0.15016E-06_JPRB,0.25751E-06_JPRB,0.48928E-06_JPRB,0.63534E-06_JPRB,0.93575E-06_JPRB /)  
KA(:, 1,13) = (/ &
 & 0.17305E-03_JPRB,0.17234E-03_JPRB,0.17389E-03_JPRB,0.17055E-03_JPRB,0.16974E-03_JPRB /)  
KA(:, 2,13) = (/ &
 & 0.18170E-03_JPRB,0.18075E-03_JPRB,0.18265E-03_JPRB,0.18138E-03_JPRB,0.17772E-03_JPRB /)  
KA(:, 3,13) = (/ &
 & 0.18990E-03_JPRB,0.18892E-03_JPRB,0.18776E-03_JPRB,0.18950E-03_JPRB,0.18494E-03_JPRB /)  
KA(:, 4,13) = (/ &
 & 0.19649E-03_JPRB,0.19552E-03_JPRB,0.19424E-03_JPRB,0.19281E-03_JPRB,0.19464E-03_JPRB /)  
KA(:, 5,13) = (/ &
 & 0.20197E-03_JPRB,0.20109E-03_JPRB,0.19993E-03_JPRB,0.19856E-03_JPRB,0.20092E-03_JPRB /)  
KA(:, 6,13) = (/ &
 & 0.20595E-03_JPRB,0.20549E-03_JPRB,0.20452E-03_JPRB,0.20331E-03_JPRB,0.20199E-03_JPRB /)  
KA(:, 7,13) = (/ &
 & 0.20703E-03_JPRB,0.20710E-03_JPRB,0.20649E-03_JPRB,0.20552E-03_JPRB,0.20428E-03_JPRB /)  
KA(:, 8,13) = (/ &
 & 0.19874E-03_JPRB,0.19767E-03_JPRB,0.19696E-03_JPRB,0.19655E-03_JPRB,0.19591E-03_JPRB /)  
KA(:, 9,13) = (/ &
 & 0.20434E-04_JPRB,0.23398E-04_JPRB,0.27400E-04_JPRB,0.32409E-04_JPRB,0.38451E-04_JPRB /)  
KA(:,10,13) = (/ &
 & 0.18617E-05_JPRB,0.99513E-06_JPRB,0.10554E-05_JPRB,0.16516E-05_JPRB,0.37792E-05_JPRB /)  
KA(:,11,13) = (/ &
 & 0.12517E-06_JPRB,0.29518E-06_JPRB,0.77058E-06_JPRB,0.11660E-05_JPRB,0.15349E-05_JPRB /)  
KA(:,12,13) = (/ &
 & 0.12734E-06_JPRB,0.36524E-06_JPRB,0.66699E-06_JPRB,0.10362E-05_JPRB,0.14158E-05_JPRB /)  
KA(:,13,13) = (/ &
 & 0.12431E-06_JPRB,0.39389E-06_JPRB,0.67331E-06_JPRB,0.10292E-05_JPRB,0.14448E-05_JPRB /)  
KA(:, 1,14) = (/ &
 & 0.29365E-03_JPRB,0.29046E-03_JPRB,0.29008E-03_JPRB,0.28509E-03_JPRB,0.28286E-03_JPRB /)  
KA(:, 2,14) = (/ &
 & 0.31990E-03_JPRB,0.31668E-03_JPRB,0.31617E-03_JPRB,0.31332E-03_JPRB,0.30885E-03_JPRB /)  
KA(:, 3,14) = (/ &
 & 0.34787E-03_JPRB,0.34432E-03_JPRB,0.34112E-03_JPRB,0.34052E-03_JPRB,0.33589E-03_JPRB /)  
KA(:, 4,14) = (/ &
 & 0.37401E-03_JPRB,0.37027E-03_JPRB,0.36696E-03_JPRB,0.36394E-03_JPRB,0.36355E-03_JPRB /)  
KA(:, 5,14) = (/ &
 & 0.39840E-03_JPRB,0.39446E-03_JPRB,0.39082E-03_JPRB,0.38763E-03_JPRB,0.38760E-03_JPRB /)  
KA(:, 6,14) = (/ &
 & 0.42165E-03_JPRB,0.41729E-03_JPRB,0.41335E-03_JPRB,0.41006E-03_JPRB,0.40721E-03_JPRB /)  
KA(:, 7,14) = (/ &
 & 0.44257E-03_JPRB,0.43782E-03_JPRB,0.43364E-03_JPRB,0.43014E-03_JPRB,0.42736E-03_JPRB /)  
KA(:, 8,14) = (/ &
 & 0.45299E-03_JPRB,0.44953E-03_JPRB,0.44586E-03_JPRB,0.44260E-03_JPRB,0.44006E-03_JPRB /)  
KA(:, 9,14) = (/ &
 & 0.40190E-03_JPRB,0.39751E-03_JPRB,0.39238E-03_JPRB,0.38812E-03_JPRB,0.38612E-03_JPRB /)  
KA(:,10,14) = (/ &
 & 0.64278E-05_JPRB,0.18248E-05_JPRB,0.16996E-05_JPRB,0.31086E-06_JPRB,0.16836E-06_JPRB /)  
KA(:,11,14) = (/ &
 & 0.14350E-05_JPRB,0.94778E-06_JPRB,0.41349E-06_JPRB,0.20817E-06_JPRB,0.20238E-06_JPRB /)  
KA(:,12,14) = (/ &
 & 0.16805E-05_JPRB,0.15323E-05_JPRB,0.62348E-06_JPRB,0.99743E-07_JPRB,0.12977E-06_JPRB /)  
KA(:,13,14) = (/ &
 & 0.16858E-05_JPRB,0.17103E-05_JPRB,0.80574E-06_JPRB,0.15825E-06_JPRB,0.15032E-06_JPRB /)  
KA(:, 1,15) = (/ &
 & 0.52181E-03_JPRB,0.51578E-03_JPRB,0.51251E-03_JPRB,0.50356E-03_JPRB,0.49731E-03_JPRB /)  
KA(:, 2,15) = (/ &
 & 0.59491E-03_JPRB,0.58822E-03_JPRB,0.58413E-03_JPRB,0.57646E-03_JPRB,0.56692E-03_JPRB /)  
KA(:, 3,15) = (/ &
 & 0.67653E-03_JPRB,0.66881E-03_JPRB,0.66126E-03_JPRB,0.65540E-03_JPRB,0.64461E-03_JPRB /)  
KA(:, 4,15) = (/ &
 & 0.76388E-03_JPRB,0.75456E-03_JPRB,0.74556E-03_JPRB,0.73649E-03_JPRB,0.72840E-03_JPRB /)  
KA(:, 5,15) = (/ &
 & 0.85507E-03_JPRB,0.84417E-03_JPRB,0.83378E-03_JPRB,0.82338E-03_JPRB,0.81349E-03_JPRB /)  
KA(:, 6,15) = (/ &
 & 0.95034E-03_JPRB,0.93798E-03_JPRB,0.92553E-03_JPRB,0.91287E-03_JPRB,0.89957E-03_JPRB /)  
KA(:, 7,15) = (/ &
 & 0.10496E-02_JPRB,0.10352E-02_JPRB,0.10206E-02_JPRB,0.10054E-02_JPRB,0.98958E-03_JPRB /)  
KA(:, 8,15) = (/ &
 & 0.11507E-02_JPRB,0.11337E-02_JPRB,0.11169E-02_JPRB,0.10991E-02_JPRB,0.10806E-02_JPRB /)  
KA(:, 9,15) = (/ &
 & 0.12408E-02_JPRB,0.12207E-02_JPRB,0.11996E-02_JPRB,0.11773E-02_JPRB,0.11531E-02_JPRB /)  
KA(:,10,15) = (/ &
 & 0.12042E-03_JPRB,0.11501E-03_JPRB,0.11424E-03_JPRB,0.11450E-03_JPRB,0.13219E-03_JPRB /)  
KA(:,11,15) = (/ &
 & 0.68914E-06_JPRB,0.83960E-06_JPRB,0.74591E-06_JPRB,0.18660E-05_JPRB,0.32503E-05_JPRB /)  
KA(:,12,15) = (/ &
 & 0.35963E-07_JPRB,0.46256E-06_JPRB,0.56223E-06_JPRB,0.98816E-06_JPRB,0.92366E-06_JPRB /)  
KA(:,13,15) = (/ &
 & 0.36605E-07_JPRB,0.56591E-06_JPRB,0.84008E-06_JPRB,0.86042E-06_JPRB,0.68452E-06_JPRB /)  
KA(:, 1,16) = (/ &
 & 0.76517E-03_JPRB,0.75944E-03_JPRB,0.76010E-03_JPRB,0.76100E-03_JPRB,0.76498E-03_JPRB /)  
KA(:, 2,16) = (/ &
 & 0.92375E-03_JPRB,0.91357E-03_JPRB,0.90997E-03_JPRB,0.90997E-03_JPRB,0.90993E-03_JPRB /)  
KA(:, 3,16) = (/ &
 & 0.11142E-02_JPRB,0.10974E-02_JPRB,0.10835E-02_JPRB,0.10789E-02_JPRB,0.10748E-02_JPRB /)  
KA(:, 4,16) = (/ &
 & 0.13278E-02_JPRB,0.13025E-02_JPRB,0.12802E-02_JPRB,0.12631E-02_JPRB,0.12539E-02_JPRB /)  
KA(:, 5,16) = (/ &
 & 0.15712E-02_JPRB,0.15343E-02_JPRB,0.15017E-02_JPRB,0.14713E-02_JPRB,0.14497E-02_JPRB /)  
KA(:, 6,16) = (/ &
 & 0.18525E-02_JPRB,0.17982E-02_JPRB,0.17525E-02_JPRB,0.17101E-02_JPRB,0.16714E-02_JPRB /)  
KA(:, 7,16) = (/ &
 & 0.21731E-02_JPRB,0.20986E-02_JPRB,0.20340E-02_JPRB,0.19757E-02_JPRB,0.19210E-02_JPRB /)  
KA(:, 8,16) = (/ &
 & 0.25325E-02_JPRB,0.24346E-02_JPRB,0.23473E-02_JPRB,0.22687E-02_JPRB,0.21950E-02_JPRB /)  
KA(:, 9,16) = (/ &
 & 0.29269E-02_JPRB,0.28006E-02_JPRB,0.26863E-02_JPRB,0.25805E-02_JPRB,0.24878E-02_JPRB /)  
KA(:,10,16) = (/ &
 & 0.29442E-02_JPRB,0.27008E-02_JPRB,0.23913E-02_JPRB,0.21437E-02_JPRB,0.18865E-02_JPRB /)  
KA(:,11,16) = (/ &
 & 0.23220E-05_JPRB,0.22310E-04_JPRB,0.48349E-04_JPRB,0.67183E-04_JPRB,0.88908E-04_JPRB /)  
KA(:,12,16) = (/ &
 & 0.22857E-05_JPRB,0.11848E-04_JPRB,0.42066E-04_JPRB,0.67613E-04_JPRB,0.86033E-04_JPRB /)  
KA(:,13,16) = (/ &
 & 0.22823E-05_JPRB,0.69105E-05_JPRB,0.36212E-04_JPRB,0.66247E-04_JPRB,0.85488E-04_JPRB /)  
  
!     -----------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('SRTM_KGB25',1,ZHOOK_HANDLE)
END SUBROUTINE SRTM_KGB25

