!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif 
SUBROUTINE SRTM_KGB29

!     Originally by J.Delamere, Atmospheric & Environmental Research.
!     Revision: 2.4
!     BAND 29:   820-2600 cm-1 (low - H2O; high - CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOESRTA29, ONLY : KA, KB, SELFREF, FORREF, SFLUXREF, RAYL &
 & , ABSH2O, ABSCO2, LAYREFFR  

!     ------------------------------------------------------------------

IMPLICIT NONE

! KURUCZ
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB29',0,ZHOOK_HANDLE)
SFLUXREF = (/ &
 & 1.32880_JPRB    , 2.14018_JPRB    , 1.97612_JPRB    , 1.79000_JPRB    , &
 & 1.51242_JPRB    , 1.22977_JPRB    , 1.06052_JPRB    , 0.800996_JPRB   , &
 & 0.748053_JPRB   , 8.64369E-02_JPRB, 7.10675E-02_JPRB, 5.62425E-02_JPRB, &
 & 4.46988E-02_JPRB, 3.07441E-02_JPRB, 1.16728E-02_JPRB, 1.65573E-03_JPRB /)  

ABSCO2 = (/ &
 & 2.90073E-06_JPRB, 2.12382E-05_JPRB, 1.03032E-04_JPRB, 1.86481E-04_JPRB, &
 & 4.31997E-04_JPRB, 6.08238E-04_JPRB, 2.17603E-03_JPRB, 4.64479E-02_JPRB, &
 & 2.96956_JPRB    , 14.9569_JPRB    , 28.4831_JPRB    , 61.3998_JPRB    , &
 & 164.129_JPRB    , 832.282_JPRB    , 4995.02_JPRB    , 12678.1_JPRB     /)  
     
ABSH2O = (/ &
 & 2.99508E-04_JPRB, 3.95012E-03_JPRB, 1.49316E-02_JPRB, 3.24384E-02_JPRB, &
 & 6.92879E-02_JPRB, 0.123523_JPRB   , 0.360985_JPRB   , 1.86434_JPRB    , &
 & 10.38157_JPRB   , 0.214129_JPRB   , 0.213914_JPRB   , 0.212781_JPRB   , &
 & 0.215562_JPRB   , 0.218087_JPRB   , 0.220918_JPRB   , 0.218546_JPRB    /)  
     
!     Rayleigh extinction coefficient at v = 2200 cm-1.
RAYL = 9.30E-11_JPRB

LAYREFFR = 49

!     ------------------------------------------------------------------

!     The array KA contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KA(:, 1, 1) = (/ &
 & 0.11565E-03_JPRB,0.10123E-03_JPRB,0.90804E-04_JPRB,0.82282E-04_JPRB,0.71083E-04_JPRB /)  
KA(:, 2, 1) = (/ &
 & 0.96434E-04_JPRB,0.82830E-04_JPRB,0.72366E-04_JPRB,0.61803E-04_JPRB,0.52497E-04_JPRB /)  
KA(:, 3, 1) = (/ &
 & 0.64539E-04_JPRB,0.56659E-04_JPRB,0.46605E-04_JPRB,0.39815E-04_JPRB,0.37118E-04_JPRB /)  
KA(:, 4, 1) = (/ &
 & 0.34417E-04_JPRB,0.27113E-04_JPRB,0.25362E-04_JPRB,0.30345E-04_JPRB,0.36275E-04_JPRB /)  
KA(:, 5, 1) = (/ &
 & 0.12260E-04_JPRB,0.15856E-04_JPRB,0.20834E-04_JPRB,0.27363E-04_JPRB,0.36114E-04_JPRB /)  
KA(:, 6, 1) = (/ &
 & 0.10221E-04_JPRB,0.14598E-04_JPRB,0.19695E-04_JPRB,0.25976E-04_JPRB,0.33702E-04_JPRB /)  
KA(:, 7, 1) = (/ &
 & 0.97563E-05_JPRB,0.13809E-04_JPRB,0.20231E-04_JPRB,0.27238E-04_JPRB,0.36110E-04_JPRB /)  
KA(:, 8, 1) = (/ &
 & 0.14062E-04_JPRB,0.19587E-04_JPRB,0.27069E-04_JPRB,0.36937E-04_JPRB,0.49415E-04_JPRB /)  
KA(:, 9, 1) = (/ &
 & 0.36371E-04_JPRB,0.48122E-04_JPRB,0.61586E-04_JPRB,0.77647E-04_JPRB,0.99897E-04_JPRB /)  
KA(:,10, 1) = (/ &
 & 0.99203E-04_JPRB,0.12842E-03_JPRB,0.16588E-03_JPRB,0.20834E-03_JPRB,0.26000E-03_JPRB /)  
KA(:,11, 1) = (/ &
 & 0.13233E-03_JPRB,0.17318E-03_JPRB,0.22059E-03_JPRB,0.28904E-03_JPRB,0.36062E-03_JPRB /)  
KA(:,12, 1) = (/ &
 & 0.13379E-03_JPRB,0.17484E-03_JPRB,0.23687E-03_JPRB,0.30286E-03_JPRB,0.37504E-03_JPRB /)  
KA(:,13, 1) = (/ &
 & 0.11740E-03_JPRB,0.15667E-03_JPRB,0.20962E-03_JPRB,0.26768E-03_JPRB,0.33485E-03_JPRB /)  
KA(:, 1, 2) = (/ &
 & 0.10246E-03_JPRB,0.10450E-03_JPRB,0.97383E-04_JPRB,0.96398E-04_JPRB,0.10549E-03_JPRB /)  
KA(:, 2, 2) = (/ &
 & 0.10589E-03_JPRB,0.10240E-03_JPRB,0.95801E-04_JPRB,0.98509E-04_JPRB,0.11993E-03_JPRB /)  
KA(:, 3, 2) = (/ &
 & 0.94054E-04_JPRB,0.87009E-04_JPRB,0.10941E-03_JPRB,0.13486E-03_JPRB,0.15918E-03_JPRB /)  
KA(:, 4, 2) = (/ &
 & 0.11883E-03_JPRB,0.14236E-03_JPRB,0.16636E-03_JPRB,0.18235E-03_JPRB,0.19785E-03_JPRB /)  
KA(:, 5, 2) = (/ &
 & 0.17800E-03_JPRB,0.19347E-03_JPRB,0.20977E-03_JPRB,0.22730E-03_JPRB,0.25111E-03_JPRB /)  
KA(:, 6, 2) = (/ &
 & 0.22243E-03_JPRB,0.24157E-03_JPRB,0.26567E-03_JPRB,0.28549E-03_JPRB,0.30723E-03_JPRB /)  
KA(:, 7, 2) = (/ &
 & 0.29248E-03_JPRB,0.32242E-03_JPRB,0.34635E-03_JPRB,0.37915E-03_JPRB,0.40803E-03_JPRB /)  
KA(:, 8, 2) = (/ &
 & 0.43386E-03_JPRB,0.48611E-03_JPRB,0.52681E-03_JPRB,0.56812E-03_JPRB,0.60642E-03_JPRB /)  
KA(:, 9, 2) = (/ &
 & 0.89109E-03_JPRB,0.10345E-02_JPRB,0.11794E-02_JPRB,0.13045E-02_JPRB,0.14303E-02_JPRB /)  
KA(:,10, 2) = (/ &
 & 0.21538E-02_JPRB,0.24459E-02_JPRB,0.27329E-02_JPRB,0.30932E-02_JPRB,0.35253E-02_JPRB /)  
KA(:,11, 2) = (/ &
 & 0.29272E-02_JPRB,0.32676E-02_JPRB,0.36353E-02_JPRB,0.40062E-02_JPRB,0.45441E-02_JPRB /)  
KA(:,12, 2) = (/ &
 & 0.30762E-02_JPRB,0.34365E-02_JPRB,0.38146E-02_JPRB,0.41556E-02_JPRB,0.47164E-02_JPRB /)  
KA(:,13, 2) = (/ &
 & 0.27808E-02_JPRB,0.31114E-02_JPRB,0.34383E-02_JPRB,0.37954E-02_JPRB,0.42576E-02_JPRB /)  
KA(:, 1, 3) = (/ &
 & 0.24042E-03_JPRB,0.32719E-03_JPRB,0.44370E-03_JPRB,0.56836E-03_JPRB,0.70357E-03_JPRB /)  
KA(:, 2, 3) = (/ &
 & 0.23303E-03_JPRB,0.31901E-03_JPRB,0.41926E-03_JPRB,0.52400E-03_JPRB,0.62365E-03_JPRB /)  
KA(:, 3, 3) = (/ &
 & 0.35050E-03_JPRB,0.42158E-03_JPRB,0.47490E-03_JPRB,0.53390E-03_JPRB,0.60411E-03_JPRB /)  
KA(:, 4, 3) = (/ &
 & 0.49954E-03_JPRB,0.53067E-03_JPRB,0.56338E-03_JPRB,0.60859E-03_JPRB,0.66569E-03_JPRB /)  
KA(:, 5, 3) = (/ &
 & 0.66908E-03_JPRB,0.69727E-03_JPRB,0.72898E-03_JPRB,0.76756E-03_JPRB,0.80358E-03_JPRB /)  
KA(:, 6, 3) = (/ &
 & 0.88634E-03_JPRB,0.92853E-03_JPRB,0.96856E-03_JPRB,0.10101E-02_JPRB,0.10556E-02_JPRB /)  
KA(:, 7, 3) = (/ &
 & 0.11659E-02_JPRB,0.12355E-02_JPRB,0.13238E-02_JPRB,0.13889E-02_JPRB,0.14491E-02_JPRB /)  
KA(:, 8, 3) = (/ &
 & 0.17485E-02_JPRB,0.18223E-02_JPRB,0.19411E-02_JPRB,0.20705E-02_JPRB,0.22025E-02_JPRB /)  
KA(:, 9, 3) = (/ &
 & 0.42442E-02_JPRB,0.43561E-02_JPRB,0.45061E-02_JPRB,0.47505E-02_JPRB,0.50358E-02_JPRB /)  
KA(:,10, 3) = (/ &
 & 0.10940E-01_JPRB,0.11499E-01_JPRB,0.11906E-01_JPRB,0.12570E-01_JPRB,0.12803E-01_JPRB /)  
KA(:,11, 3) = (/ &
 & 0.14287E-01_JPRB,0.15010E-01_JPRB,0.15581E-01_JPRB,0.16054E-01_JPRB,0.16609E-01_JPRB /)  
KA(:,12, 3) = (/ &
 & 0.14856E-01_JPRB,0.15546E-01_JPRB,0.16074E-01_JPRB,0.16478E-01_JPRB,0.17057E-01_JPRB /)  
KA(:,13, 3) = (/ &
 & 0.13257E-01_JPRB,0.13834E-01_JPRB,0.14155E-01_JPRB,0.14723E-01_JPRB,0.15095E-01_JPRB /)  
KA(:, 1, 4) = (/ &
 & 0.24391E-02_JPRB,0.28720E-02_JPRB,0.33497E-02_JPRB,0.38926E-02_JPRB,0.45054E-02_JPRB /)  
KA(:, 2, 4) = (/ &
 & 0.22506E-02_JPRB,0.26004E-02_JPRB,0.30002E-02_JPRB,0.34490E-02_JPRB,0.39579E-02_JPRB /)  
KA(:, 3, 4) = (/ &
 & 0.22153E-02_JPRB,0.25711E-02_JPRB,0.29320E-02_JPRB,0.33330E-02_JPRB,0.37728E-02_JPRB /)  
KA(:, 4, 4) = (/ &
 & 0.22483E-02_JPRB,0.25445E-02_JPRB,0.28745E-02_JPRB,0.32484E-02_JPRB,0.36554E-02_JPRB /)  
KA(:, 5, 4) = (/ &
 & 0.23388E-02_JPRB,0.25985E-02_JPRB,0.28914E-02_JPRB,0.32377E-02_JPRB,0.36113E-02_JPRB /)  
KA(:, 6, 4) = (/ &
 & 0.24669E-02_JPRB,0.26579E-02_JPRB,0.28834E-02_JPRB,0.31538E-02_JPRB,0.34593E-02_JPRB /)  
KA(:, 7, 4) = (/ &
 & 0.32536E-02_JPRB,0.33413E-02_JPRB,0.34375E-02_JPRB,0.35905E-02_JPRB,0.38010E-02_JPRB /)  
KA(:, 8, 4) = (/ &
 & 0.51228E-02_JPRB,0.51967E-02_JPRB,0.52820E-02_JPRB,0.53446E-02_JPRB,0.53797E-02_JPRB /)  
KA(:, 9, 4) = (/ &
 & 0.13029E-01_JPRB,0.13065E-01_JPRB,0.12891E-01_JPRB,0.12848E-01_JPRB,0.12777E-01_JPRB /)  
KA(:,10, 4) = (/ &
 & 0.29911E-01_JPRB,0.30117E-01_JPRB,0.28340E-01_JPRB,0.27321E-01_JPRB,0.27485E-01_JPRB /)  
KA(:,11, 4) = (/ &
 & 0.36663E-01_JPRB,0.36877E-01_JPRB,0.34688E-01_JPRB,0.33004E-01_JPRB,0.32437E-01_JPRB /)  
KA(:,12, 4) = (/ &
 & 0.37282E-01_JPRB,0.37775E-01_JPRB,0.34910E-01_JPRB,0.33463E-01_JPRB,0.33074E-01_JPRB /)  
KA(:,13, 4) = (/ &
 & 0.33412E-01_JPRB,0.32961E-01_JPRB,0.30323E-01_JPRB,0.29437E-01_JPRB,0.29572E-01_JPRB /)  
KA(:, 1, 5) = (/ &
 & 0.20792E-01_JPRB,0.22727E-01_JPRB,0.25207E-01_JPRB,0.27650E-01_JPRB,0.29866E-01_JPRB /)  
KA(:, 2, 5) = (/ &
 & 0.17515E-01_JPRB,0.19421E-01_JPRB,0.21509E-01_JPRB,0.23389E-01_JPRB,0.25418E-01_JPRB /)  
KA(:, 3, 5) = (/ &
 & 0.14912E-01_JPRB,0.16535E-01_JPRB,0.18159E-01_JPRB,0.19873E-01_JPRB,0.21718E-01_JPRB /)  
KA(:, 4, 5) = (/ &
 & 0.13498E-01_JPRB,0.14786E-01_JPRB,0.16253E-01_JPRB,0.17812E-01_JPRB,0.19494E-01_JPRB /)  
KA(:, 5, 5) = (/ &
 & 0.12840E-01_JPRB,0.13983E-01_JPRB,0.15257E-01_JPRB,0.16617E-01_JPRB,0.18015E-01_JPRB /)  
KA(:, 6, 5) = (/ &
 & 0.12557E-01_JPRB,0.13714E-01_JPRB,0.14939E-01_JPRB,0.16145E-01_JPRB,0.17356E-01_JPRB /)  
KA(:, 7, 5) = (/ &
 & 0.11839E-01_JPRB,0.12951E-01_JPRB,0.14090E-01_JPRB,0.15237E-01_JPRB,0.16396E-01_JPRB /)  
KA(:, 8, 5) = (/ &
 & 0.13190E-01_JPRB,0.13998E-01_JPRB,0.14783E-01_JPRB,0.15641E-01_JPRB,0.16632E-01_JPRB /)  
KA(:, 9, 5) = (/ &
 & 0.24479E-01_JPRB,0.24660E-01_JPRB,0.25206E-01_JPRB,0.25571E-01_JPRB,0.26098E-01_JPRB /)  
KA(:,10, 5) = (/ &
 & 0.62373E-01_JPRB,0.60241E-01_JPRB,0.61372E-01_JPRB,0.61530E-01_JPRB,0.60978E-01_JPRB /)  
KA(:,11, 5) = (/ &
 & 0.76394E-01_JPRB,0.73727E-01_JPRB,0.74701E-01_JPRB,0.75649E-01_JPRB,0.75608E-01_JPRB /)  
KA(:,12, 5) = (/ &
 & 0.76656E-01_JPRB,0.73608E-01_JPRB,0.75610E-01_JPRB,0.76362E-01_JPRB,0.76033E-01_JPRB /)  
KA(:,13, 5) = (/ &
 & 0.66025E-01_JPRB,0.64890E-01_JPRB,0.66873E-01_JPRB,0.66992E-01_JPRB,0.66685E-01_JPRB /)  
KA(:, 1, 6) = (/ &
 & 0.99799E-01_JPRB,0.10479E+00_JPRB,0.10918E+00_JPRB,0.11347E+00_JPRB,0.11767E+00_JPRB /)  
KA(:, 2, 6) = (/ &
 & 0.87946E-01_JPRB,0.91820E-01_JPRB,0.95208E-01_JPRB,0.99071E-01_JPRB,0.10286E+00_JPRB /)  
KA(:, 3, 6) = (/ &
 & 0.76753E-01_JPRB,0.80377E-01_JPRB,0.84204E-01_JPRB,0.87924E-01_JPRB,0.91370E-01_JPRB /)  
KA(:, 4, 6) = (/ &
 & 0.67002E-01_JPRB,0.70630E-01_JPRB,0.73736E-01_JPRB,0.76764E-01_JPRB,0.79671E-01_JPRB /)  
KA(:, 5, 6) = (/ &
 & 0.58933E-01_JPRB,0.61857E-01_JPRB,0.64756E-01_JPRB,0.67323E-01_JPRB,0.69871E-01_JPRB /)  
KA(:, 6, 6) = (/ &
 & 0.53143E-01_JPRB,0.55386E-01_JPRB,0.57507E-01_JPRB,0.59715E-01_JPRB,0.62263E-01_JPRB /)  
KA(:, 7, 6) = (/ &
 & 0.50856E-01_JPRB,0.52603E-01_JPRB,0.54414E-01_JPRB,0.56230E-01_JPRB,0.58483E-01_JPRB /)  
KA(:, 8, 6) = (/ &
 & 0.50528E-01_JPRB,0.52598E-01_JPRB,0.54634E-01_JPRB,0.56710E-01_JPRB,0.58872E-01_JPRB /)  
KA(:, 9, 6) = (/ &
 & 0.64616E-01_JPRB,0.65915E-01_JPRB,0.67210E-01_JPRB,0.68742E-01_JPRB,0.70092E-01_JPRB /)  
KA(:,10, 6) = (/ &
 & 0.11509E+00_JPRB,0.11448E+00_JPRB,0.11368E+00_JPRB,0.11348E+00_JPRB,0.11401E+00_JPRB /)  
KA(:,11, 6) = (/ &
 & 0.14266E+00_JPRB,0.13997E+00_JPRB,0.13810E+00_JPRB,0.13688E+00_JPRB,0.13622E+00_JPRB /)  
KA(:,12, 6) = (/ &
 & 0.14464E+00_JPRB,0.14198E+00_JPRB,0.13915E+00_JPRB,0.13789E+00_JPRB,0.13781E+00_JPRB /)  
KA(:,13, 6) = (/ &
 & 0.12550E+00_JPRB,0.12328E+00_JPRB,0.12173E+00_JPRB,0.12127E+00_JPRB,0.12078E+00_JPRB /)  
KA(:, 1, 7) = (/ &
 & 0.30825E+00_JPRB,0.31119E+00_JPRB,0.31335E+00_JPRB,0.31641E+00_JPRB,0.32024E+00_JPRB /)  
KA(:, 2, 7) = (/ &
 & 0.28100E+00_JPRB,0.28660E+00_JPRB,0.29192E+00_JPRB,0.29680E+00_JPRB,0.30014E+00_JPRB /)  
KA(:, 3, 7) = (/ &
 & 0.26374E+00_JPRB,0.27129E+00_JPRB,0.27887E+00_JPRB,0.28626E+00_JPRB,0.29478E+00_JPRB /)  
KA(:, 4, 7) = (/ &
 & 0.24539E+00_JPRB,0.25325E+00_JPRB,0.26070E+00_JPRB,0.26955E+00_JPRB,0.27794E+00_JPRB /)  
KA(:, 5, 7) = (/ &
 & 0.21737E+00_JPRB,0.22642E+00_JPRB,0.23531E+00_JPRB,0.24408E+00_JPRB,0.25322E+00_JPRB /)  
KA(:, 6, 7) = (/ &
 & 0.19066E+00_JPRB,0.19913E+00_JPRB,0.20834E+00_JPRB,0.21782E+00_JPRB,0.22698E+00_JPRB /)  
KA(:, 7, 7) = (/ &
 & 0.17386E+00_JPRB,0.18325E+00_JPRB,0.19211E+00_JPRB,0.20024E+00_JPRB,0.20881E+00_JPRB /)  
KA(:, 8, 7) = (/ &
 & 0.17625E+00_JPRB,0.18236E+00_JPRB,0.18905E+00_JPRB,0.19574E+00_JPRB,0.20193E+00_JPRB /)  
KA(:, 9, 7) = (/ &
 & 0.21820E+00_JPRB,0.22416E+00_JPRB,0.22986E+00_JPRB,0.23737E+00_JPRB,0.24518E+00_JPRB /)  
KA(:,10, 7) = (/ &
 & 0.33529E+00_JPRB,0.34302E+00_JPRB,0.35397E+00_JPRB,0.36397E+00_JPRB,0.37339E+00_JPRB /)  
KA(:,11, 7) = (/ &
 & 0.38474E+00_JPRB,0.39863E+00_JPRB,0.41168E+00_JPRB,0.42115E+00_JPRB,0.42917E+00_JPRB /)  
KA(:,12, 7) = (/ &
 & 0.38499E+00_JPRB,0.39580E+00_JPRB,0.40497E+00_JPRB,0.41279E+00_JPRB,0.42045E+00_JPRB /)  
KA(:,13, 7) = (/ &
 & 0.34291E+00_JPRB,0.35180E+00_JPRB,0.35970E+00_JPRB,0.36697E+00_JPRB,0.37460E+00_JPRB /)  
KA(:, 1, 8) = (/ &
 & 0.87131E+00_JPRB,0.87876E+00_JPRB,0.88509E+00_JPRB,0.89061E+00_JPRB,0.89432E+00_JPRB /)  
KA(:, 2, 8) = (/ &
 & 0.78963E+00_JPRB,0.79236E+00_JPRB,0.79978E+00_JPRB,0.80959E+00_JPRB,0.82163E+00_JPRB /)  
KA(:, 3, 8) = (/ &
 & 0.82479E+00_JPRB,0.82842E+00_JPRB,0.83069E+00_JPRB,0.83679E+00_JPRB,0.84334E+00_JPRB /)  
KA(:, 4, 8) = (/ &
 & 0.90877E+00_JPRB,0.91962E+00_JPRB,0.92466E+00_JPRB,0.93139E+00_JPRB,0.93904E+00_JPRB /)  
KA(:, 5, 8) = (/ &
 & 0.97131E+00_JPRB,0.99301E+00_JPRB,0.10095E+01_JPRB,0.10270E+01_JPRB,0.10371E+01_JPRB /)  
KA(:, 6, 8) = (/ &
 & 0.96984E+00_JPRB,0.10040E+01_JPRB,0.10393E+01_JPRB,0.10670E+01_JPRB,0.10990E+01_JPRB /)  
KA(:, 7, 8) = (/ &
 & 0.95686E+00_JPRB,0.10029E+01_JPRB,0.10449E+01_JPRB,0.10923E+01_JPRB,0.11334E+01_JPRB /)  
KA(:, 8, 8) = (/ &
 & 0.97227E+00_JPRB,0.10380E+01_JPRB,0.11014E+01_JPRB,0.11624E+01_JPRB,0.12218E+01_JPRB /)  
KA(:, 9, 8) = (/ &
 & 0.12290E+01_JPRB,0.13071E+01_JPRB,0.14005E+01_JPRB,0.15005E+01_JPRB,0.15980E+01_JPRB /)  
KA(:,10, 8) = (/ &
 & 0.17996E+01_JPRB,0.19304E+01_JPRB,0.20752E+01_JPRB,0.22219E+01_JPRB,0.23814E+01_JPRB /)  
KA(:,11, 8) = (/ &
 & 0.19289E+01_JPRB,0.20656E+01_JPRB,0.22166E+01_JPRB,0.23715E+01_JPRB,0.25386E+01_JPRB /)  
KA(:,12, 8) = (/ &
 & 0.18429E+01_JPRB,0.19765E+01_JPRB,0.21175E+01_JPRB,0.22722E+01_JPRB,0.24239E+01_JPRB /)  
KA(:,13, 8) = (/ &
 & 0.16420E+01_JPRB,0.17464E+01_JPRB,0.18635E+01_JPRB,0.19773E+01_JPRB,0.21012E+01_JPRB /)  
KA(:, 1, 9) = (/ &
 & 0.39892E+01_JPRB,0.40153E+01_JPRB,0.40324E+01_JPRB,0.40465E+01_JPRB,0.40524E+01_JPRB /)  
KA(:, 2, 9) = (/ &
 & 0.38871E+01_JPRB,0.39035E+01_JPRB,0.39123E+01_JPRB,0.39056E+01_JPRB,0.38966E+01_JPRB /)  
KA(:, 3, 9) = (/ &
 & 0.37883E+01_JPRB,0.37950E+01_JPRB,0.38080E+01_JPRB,0.37991E+01_JPRB,0.37826E+01_JPRB /)  
KA(:, 4, 9) = (/ &
 & 0.37778E+01_JPRB,0.37663E+01_JPRB,0.37745E+01_JPRB,0.37709E+01_JPRB,0.37556E+01_JPRB /)  
KA(:, 5, 9) = (/ &
 & 0.38757E+01_JPRB,0.38404E+01_JPRB,0.38539E+01_JPRB,0.39228E+01_JPRB,0.39777E+01_JPRB /)  
KA(:, 6, 9) = (/ &
 & 0.40990E+01_JPRB,0.41407E+01_JPRB,0.41745E+01_JPRB,0.42258E+01_JPRB,0.42574E+01_JPRB /)  
KA(:, 7, 9) = (/ &
 & 0.46288E+01_JPRB,0.46726E+01_JPRB,0.47096E+01_JPRB,0.47165E+01_JPRB,0.47374E+01_JPRB /)  
KA(:, 8, 9) = (/ &
 & 0.58432E+01_JPRB,0.58474E+01_JPRB,0.58608E+01_JPRB,0.58935E+01_JPRB,0.59261E+01_JPRB /)  
KA(:, 9, 9) = (/ &
 & 0.88685E+01_JPRB,0.88567E+01_JPRB,0.88137E+01_JPRB,0.87653E+01_JPRB,0.87262E+01_JPRB /)  
KA(:,10, 9) = (/ &
 & 0.10455E+02_JPRB,0.10242E+02_JPRB,0.10004E+02_JPRB,0.97643E+01_JPRB,0.95067E+01_JPRB /)  
KA(:,11, 9) = (/ &
 & 0.10240E+02_JPRB,0.99968E+01_JPRB,0.97347E+01_JPRB,0.94750E+01_JPRB,0.92006E+01_JPRB /)  
KA(:,12, 9) = (/ &
 & 0.10401E+02_JPRB,0.10165E+02_JPRB,0.99240E+01_JPRB,0.96656E+01_JPRB,0.94112E+01_JPRB /)  
KA(:,13, 9) = (/ &
 & 0.10764E+02_JPRB,0.10580E+02_JPRB,0.10381E+02_JPRB,0.10188E+02_JPRB,0.99802E+01_JPRB /)  
KA(:, 1,10) = (/ &
 & 0.10712E+02_JPRB,0.10575E+02_JPRB,0.10581E+02_JPRB,0.10556E+02_JPRB,0.10575E+02_JPRB /)  
KA(:, 2,10) = (/ &
 & 0.11144E+02_JPRB,0.11109E+02_JPRB,0.11034E+02_JPRB,0.11107E+02_JPRB,0.11138E+02_JPRB /)  
KA(:, 3,10) = (/ &
 & 0.12257E+02_JPRB,0.12112E+02_JPRB,0.11992E+02_JPRB,0.11951E+02_JPRB,0.12031E+02_JPRB /)  
KA(:, 4,10) = (/ &
 & 0.13040E+02_JPRB,0.13085E+02_JPRB,0.12882E+02_JPRB,0.12756E+02_JPRB,0.12737E+02_JPRB /)  
KA(:, 5,10) = (/ &
 & 0.13809E+02_JPRB,0.13771E+02_JPRB,0.13452E+02_JPRB,0.12567E+02_JPRB,0.12086E+02_JPRB /)  
KA(:, 6,10) = (/ &
 & 0.14608E+02_JPRB,0.13942E+02_JPRB,0.13365E+02_JPRB,0.13494E+02_JPRB,0.13762E+02_JPRB /)  
KA(:, 7,10) = (/ &
 & 0.14665E+02_JPRB,0.14685E+02_JPRB,0.15121E+02_JPRB,0.15602E+02_JPRB,0.15768E+02_JPRB /)  
KA(:, 8,10) = (/ &
 & 0.15612E+02_JPRB,0.16507E+02_JPRB,0.16644E+02_JPRB,0.16706E+02_JPRB,0.16696E+02_JPRB /)  
KA(:, 9,10) = (/ &
 & 0.15405E+02_JPRB,0.15874E+02_JPRB,0.16716E+02_JPRB,0.17957E+02_JPRB,0.17859E+02_JPRB /)  
KA(:,10,10) = (/ &
 & 0.19406E+00_JPRB,0.17932E+00_JPRB,0.16660E+00_JPRB,0.15558E+00_JPRB,0.14589E+00_JPRB /)  
KA(:,11,10) = (/ &
 & 0.27650E+00_JPRB,0.25556E+00_JPRB,0.23727E+00_JPRB,0.22182E+00_JPRB,0.20805E+00_JPRB /)  
KA(:,12,10) = (/ &
 & 0.29298E+00_JPRB,0.27044E+00_JPRB,0.25162E+00_JPRB,0.23497E+00_JPRB,0.22076E+00_JPRB /)  
KA(:,13,10) = (/ &
 & 0.24883E+00_JPRB,0.22985E+00_JPRB,0.21413E+00_JPRB,0.20012E+00_JPRB,0.18795E+00_JPRB /)  
KA(:, 1,11) = (/ &
 & 0.13650E+02_JPRB,0.13767E+02_JPRB,0.13771E+02_JPRB,0.13650E+02_JPRB,0.13663E+02_JPRB /)  
KA(:, 2,11) = (/ &
 & 0.15146E+02_JPRB,0.15253E+02_JPRB,0.15272E+02_JPRB,0.15152E+02_JPRB,0.15138E+02_JPRB /)  
KA(:, 3,11) = (/ &
 & 0.16834E+02_JPRB,0.17107E+02_JPRB,0.17158E+02_JPRB,0.17187E+02_JPRB,0.17057E+02_JPRB /)  
KA(:, 4,11) = (/ &
 & 0.19191E+02_JPRB,0.19144E+02_JPRB,0.19155E+02_JPRB,0.19247E+02_JPRB,0.19292E+02_JPRB /)  
KA(:, 5,11) = (/ &
 & 0.20953E+02_JPRB,0.21248E+02_JPRB,0.21186E+02_JPRB,0.21027E+02_JPRB,0.20703E+02_JPRB /)  
KA(:, 6,11) = (/ &
 & 0.22592E+02_JPRB,0.22192E+02_JPRB,0.22056E+02_JPRB,0.20972E+02_JPRB,0.19910E+02_JPRB /)  
KA(:, 7,11) = (/ &
 & 0.24652E+02_JPRB,0.23679E+02_JPRB,0.22339E+02_JPRB,0.21302E+02_JPRB,0.21697E+02_JPRB /)  
KA(:, 8,11) = (/ &
 & 0.22508E+02_JPRB,0.20438E+02_JPRB,0.20163E+02_JPRB,0.20628E+02_JPRB,0.20954E+02_JPRB /)  
KA(:, 9,11) = (/ &
 & 0.10264E+02_JPRB,0.85820E+01_JPRB,0.65270E+01_JPRB,0.38883E+01_JPRB,0.27974E+01_JPRB /)  
KA(:,10,11) = (/ &
 & 0.19324E+00_JPRB,0.17913E+00_JPRB,0.16619E+00_JPRB,0.15516E+00_JPRB,0.14524E+00_JPRB /)  
KA(:,11,11) = (/ &
 & 0.27573E+00_JPRB,0.25425E+00_JPRB,0.23627E+00_JPRB,0.22036E+00_JPRB,0.20639E+00_JPRB /)  
KA(:,12,11) = (/ &
 & 0.29224E+00_JPRB,0.26998E+00_JPRB,0.25055E+00_JPRB,0.23380E+00_JPRB,0.21908E+00_JPRB /)  
KA(:,13,11) = (/ &
 & 0.24964E+00_JPRB,0.23056E+00_JPRB,0.21391E+00_JPRB,0.19980E+00_JPRB,0.18698E+00_JPRB /)  
KA(:, 1,12) = (/ &
 & 0.17721E+02_JPRB,0.17805E+02_JPRB,0.17752E+02_JPRB,0.17857E+02_JPRB,0.17872E+02_JPRB /)  
KA(:, 2,12) = (/ &
 & 0.20222E+02_JPRB,0.20161E+02_JPRB,0.20267E+02_JPRB,0.20335E+02_JPRB,0.20254E+02_JPRB /)  
KA(:, 3,12) = (/ &
 & 0.23717E+02_JPRB,0.23414E+02_JPRB,0.23571E+02_JPRB,0.23552E+02_JPRB,0.23687E+02_JPRB /)  
KA(:, 4,12) = (/ &
 & 0.26876E+02_JPRB,0.26972E+02_JPRB,0.27155E+02_JPRB,0.26947E+02_JPRB,0.27025E+02_JPRB /)  
KA(:, 5,12) = (/ &
 & 0.30213E+02_JPRB,0.29978E+02_JPRB,0.30226E+02_JPRB,0.30477E+02_JPRB,0.30329E+02_JPRB /)  
KA(:, 6,12) = (/ &
 & 0.33660E+02_JPRB,0.33482E+02_JPRB,0.33159E+02_JPRB,0.32959E+02_JPRB,0.32299E+02_JPRB /)  
KA(:, 7,12) = (/ &
 & 0.35893E+02_JPRB,0.35649E+02_JPRB,0.35067E+02_JPRB,0.34565E+02_JPRB,0.32437E+02_JPRB /)  
KA(:, 8,12) = (/ &
 & 0.33426E+02_JPRB,0.33323E+02_JPRB,0.31984E+02_JPRB,0.29587E+02_JPRB,0.27505E+02_JPRB /)  
KA(:, 9,12) = (/ &
 & 0.46633E-01_JPRB,0.43205E-01_JPRB,0.40562E-01_JPRB,0.38133E-01_JPRB,0.35900E-01_JPRB /)  
KA(:,10,12) = (/ &
 & 0.19421E+00_JPRB,0.18024E+00_JPRB,0.16872E+00_JPRB,0.15815E+00_JPRB,0.14837E+00_JPRB /)  
KA(:,11,12) = (/ &
 & 0.27315E+00_JPRB,0.25480E+00_JPRB,0.23771E+00_JPRB,0.22191E+00_JPRB,0.20780E+00_JPRB /)  
KA(:,12,12) = (/ &
 & 0.29027E+00_JPRB,0.26969E+00_JPRB,0.25017E+00_JPRB,0.23314E+00_JPRB,0.21774E+00_JPRB /)  
KA(:,13,12) = (/ &
 & 0.24833E+00_JPRB,0.22943E+00_JPRB,0.21278E+00_JPRB,0.19800E+00_JPRB,0.18543E+00_JPRB /)  
KA(:, 1,13) = (/ &
 & 0.29672E+02_JPRB,0.29291E+02_JPRB,0.29191E+02_JPRB,0.29170E+02_JPRB,0.29116E+02_JPRB /)  
KA(:, 2,13) = (/ &
 & 0.24713E+02_JPRB,0.24965E+02_JPRB,0.25039E+02_JPRB,0.25355E+02_JPRB,0.25650E+02_JPRB /)  
KA(:, 3,13) = (/ &
 & 0.30510E+02_JPRB,0.31166E+02_JPRB,0.30663E+02_JPRB,0.31021E+02_JPRB,0.30901E+02_JPRB /)  
KA(:, 4,13) = (/ &
 & 0.38695E+02_JPRB,0.38922E+02_JPRB,0.38741E+02_JPRB,0.39204E+02_JPRB,0.38826E+02_JPRB /)  
KA(:, 5,13) = (/ &
 & 0.45118E+02_JPRB,0.44337E+02_JPRB,0.43664E+02_JPRB,0.43267E+02_JPRB,0.43524E+02_JPRB /)  
KA(:, 6,13) = (/ &
 & 0.34652E+02_JPRB,0.35182E+02_JPRB,0.35339E+02_JPRB,0.35340E+02_JPRB,0.35899E+02_JPRB /)  
KA(:, 7,13) = (/ &
 & 0.18801E+02_JPRB,0.18598E+02_JPRB,0.18855E+02_JPRB,0.18819E+02_JPRB,0.19052E+02_JPRB /)  
KA(:, 8,13) = (/ &
 & 0.12297E-01_JPRB,0.11425E-01_JPRB,0.10670E-01_JPRB,0.99994E-02_JPRB,0.94139E-02_JPRB /)  
KA(:, 9,13) = (/ &
 & 0.46821E-01_JPRB,0.43361E-01_JPRB,0.40368E-01_JPRB,0.37752E-01_JPRB,0.35493E-01_JPRB /)  
KA(:,10,13) = (/ &
 & 0.19817E+00_JPRB,0.18303E+00_JPRB,0.17002E+00_JPRB,0.15883E+00_JPRB,0.14933E+00_JPRB /)  
KA(:,11,13) = (/ &
 & 0.28145E+00_JPRB,0.25995E+00_JPRB,0.24181E+00_JPRB,0.22660E+00_JPRB,0.21326E+00_JPRB /)  
KA(:,12,13) = (/ &
 & 0.29510E+00_JPRB,0.27294E+00_JPRB,0.25519E+00_JPRB,0.23947E+00_JPRB,0.22551E+00_JPRB /)  
KA(:,13,13) = (/ &
 & 0.24830E+00_JPRB,0.23074E+00_JPRB,0.21556E+00_JPRB,0.20226E+00_JPRB,0.19029E+00_JPRB /)  
KA(:, 1,14) = (/ &
 & 0.47168E+02_JPRB,0.46890E+02_JPRB,0.46612E+02_JPRB,0.46353E+02_JPRB,0.46088E+02_JPRB /)  
KA(:, 2,14) = (/ &
 & 0.47771E+02_JPRB,0.46980E+02_JPRB,0.46445E+02_JPRB,0.45828E+02_JPRB,0.45437E+02_JPRB /)  
KA(:, 3,14) = (/ &
 & 0.42946E+02_JPRB,0.42652E+02_JPRB,0.43791E+02_JPRB,0.43237E+02_JPRB,0.44104E+02_JPRB /)  
KA(:, 4,14) = (/ &
 & 0.30957E+02_JPRB,0.30098E+02_JPRB,0.30055E+02_JPRB,0.29555E+02_JPRB,0.29902E+02_JPRB /)  
KA(:, 5,14) = (/ &
 & 0.28397E+01_JPRB,0.38572E+01_JPRB,0.42906E+01_JPRB,0.47091E+01_JPRB,0.48135E+01_JPRB /)  
KA(:, 6,14) = (/ &
 & 0.36978E-02_JPRB,0.34591E-02_JPRB,0.32524E-02_JPRB,0.30649E-02_JPRB,0.29018E-02_JPRB /)  
KA(:, 7,14) = (/ &
 & 0.61733E-02_JPRB,0.57589E-02_JPRB,0.53925E-02_JPRB,0.50742E-02_JPRB,0.47835E-02_JPRB /)  
KA(:, 8,14) = (/ &
 & 0.12390E-01_JPRB,0.11526E-01_JPRB,0.10766E-01_JPRB,0.10096E-01_JPRB,0.95010E-02_JPRB /)  
KA(:, 9,14) = (/ &
 & 0.47105E-01_JPRB,0.43648E-01_JPRB,0.40665E-01_JPRB,0.38054E-01_JPRB,0.35722E-01_JPRB /)  
KA(:,10,14) = (/ &
 & 0.19915E+00_JPRB,0.18412E+00_JPRB,0.17099E+00_JPRB,0.15957E+00_JPRB,0.14948E+00_JPRB /)  
KA(:,11,14) = (/ &
 & 0.28280E+00_JPRB,0.26124E+00_JPRB,0.24266E+00_JPRB,0.22645E+00_JPRB,0.21214E+00_JPRB /)  
KA(:,12,14) = (/ &
 & 0.29891E+00_JPRB,0.27613E+00_JPRB,0.25648E+00_JPRB,0.23927E+00_JPRB,0.22423E+00_JPRB /)  
KA(:,13,14) = (/ &
 & 0.25421E+00_JPRB,0.23484E+00_JPRB,0.21809E+00_JPRB,0.20347E+00_JPRB,0.19057E+00_JPRB /)  
KA(:, 1,15) = (/ &
 & 0.64994E+02_JPRB,0.64283E+02_JPRB,0.63755E+02_JPRB,0.63407E+02_JPRB,0.63287E+02_JPRB /)  
KA(:, 2,15) = (/ &
 & 0.78266E+02_JPRB,0.77364E+02_JPRB,0.76722E+02_JPRB,0.76285E+02_JPRB,0.75992E+02_JPRB /)  
KA(:, 3,15) = (/ &
 & 0.41710E+02_JPRB,0.38379E+02_JPRB,0.35076E+02_JPRB,0.35418E+02_JPRB,0.33306E+02_JPRB /)  
KA(:, 4,15) = (/ &
 & 0.14170E-02_JPRB,0.13401E-02_JPRB,0.12716E-02_JPRB,0.12073E-02_JPRB,0.11535E-02_JPRB /)  
KA(:, 5,15) = (/ &
 & 0.23659E-02_JPRB,0.22261E-02_JPRB,0.21042E-02_JPRB,0.19950E-02_JPRB,0.18970E-02_JPRB /)  
KA(:, 6,15) = (/ &
 & 0.37432E-02_JPRB,0.35105E-02_JPRB,0.33006E-02_JPRB,0.31222E-02_JPRB,0.29521E-02_JPRB /)  
KA(:, 7,15) = (/ &
 & 0.62408E-02_JPRB,0.58258E-02_JPRB,0.54782E-02_JPRB,0.51594E-02_JPRB,0.48767E-02_JPRB /)  
KA(:, 8,15) = (/ &
 & 0.12522E-01_JPRB,0.11652E-01_JPRB,0.10922E-01_JPRB,0.10265E-01_JPRB,0.96672E-02_JPRB /)  
KA(:, 9,15) = (/ &
 & 0.47545E-01_JPRB,0.44152E-01_JPRB,0.41251E-01_JPRB,0.38666E-01_JPRB,0.36358E-01_JPRB /)  
KA(:,10,15) = (/ &
 & 0.20097E+00_JPRB,0.18592E+00_JPRB,0.17341E+00_JPRB,0.16203E+00_JPRB,0.15235E+00_JPRB /)  
KA(:,11,15) = (/ &
 & 0.28499E+00_JPRB,0.26428E+00_JPRB,0.24585E+00_JPRB,0.22980E+00_JPRB,0.21575E+00_JPRB /)  
KA(:,12,15) = (/ &
 & 0.30172E+00_JPRB,0.27929E+00_JPRB,0.25980E+00_JPRB,0.24306E+00_JPRB,0.22789E+00_JPRB /)  
KA(:,13,15) = (/ &
 & 0.25655E+00_JPRB,0.23731E+00_JPRB,0.22092E+00_JPRB,0.20639E+00_JPRB,0.19367E+00_JPRB /)  
KA(:, 1,16) = (/ &
 & 0.80810E+02_JPRB,0.81099E+02_JPRB,0.81190E+02_JPRB,0.81107E+02_JPRB,0.80989E+02_JPRB /)  
KA(:, 2,16) = (/ &
 & 0.99319E+02_JPRB,0.99708E+02_JPRB,0.99822E+02_JPRB,0.99871E+02_JPRB,0.99993E+02_JPRB /)  
KA(:, 3,16) = (/ &
 & 0.46927E+02_JPRB,0.54316E+02_JPRB,0.57355E+02_JPRB,0.53715E+02_JPRB,0.52802E+02_JPRB /)  
KA(:, 4,16) = (/ &
 & 0.12802E-02_JPRB,0.12027E-02_JPRB,0.11386E-02_JPRB,0.10866E-02_JPRB,0.10525E-02_JPRB /)  
KA(:, 5,16) = (/ &
 & 0.21675E-02_JPRB,0.20715E-02_JPRB,0.19422E-02_JPRB,0.18402E-02_JPRB,0.17681E-02_JPRB /)  
KA(:, 6,16) = (/ &
 & 0.34707E-02_JPRB,0.32796E-02_JPRB,0.30986E-02_JPRB,0.29246E-02_JPRB,0.28034E-02_JPRB /)  
KA(:, 7,16) = (/ &
 & 0.58659E-02_JPRB,0.55310E-02_JPRB,0.51820E-02_JPRB,0.48829E-02_JPRB,0.46784E-02_JPRB /)  
KA(:, 8,16) = (/ &
 & 0.11875E-01_JPRB,0.11183E-01_JPRB,0.10438E-01_JPRB,0.98038E-02_JPRB,0.93665E-02_JPRB /)  
KA(:, 9,16) = (/ &
 & 0.45519E-01_JPRB,0.42850E-01_JPRB,0.39715E-01_JPRB,0.37447E-01_JPRB,0.35369E-01_JPRB /)  
KA(:,10,16) = (/ &
 & 0.19392E+00_JPRB,0.18108E+00_JPRB,0.16817E+00_JPRB,0.15883E+00_JPRB,0.14864E+00_JPRB /)  
KA(:,11,16) = (/ &
 & 0.27830E+00_JPRB,0.25715E+00_JPRB,0.24100E+00_JPRB,0.22595E+00_JPRB,0.21321E+00_JPRB /)  
KA(:,12,16) = (/ &
 & 0.29533E+00_JPRB,0.27422E+00_JPRB,0.25636E+00_JPRB,0.23936E+00_JPRB,0.22658E+00_JPRB /)  
KA(:,13,16) = (/ &
 & 0.25310E+00_JPRB,0.23535E+00_JPRB,0.21855E+00_JPRB,0.20552E+00_JPRB,0.19293E+00_JPRB /)  
  
!     -----------------------------------------------------------------
!     The array KB contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KB(:,13, 1) = (/ &
 & 0.18379E-05_JPRB,0.23296E-05_JPRB,0.29007E-05_JPRB,0.35902E-05_JPRB,0.43437E-05_JPRB /)  
KB(:,14, 1) = (/ &
 & 0.15919E-05_JPRB,0.19832E-05_JPRB,0.24720E-05_JPRB,0.30683E-05_JPRB,0.37253E-05_JPRB /)  
KB(:,15, 1) = (/ &
 & 0.13850E-05_JPRB,0.17115E-05_JPRB,0.21225E-05_JPRB,0.26292E-05_JPRB,0.31945E-05_JPRB /)  
KB(:,16, 1) = (/ &
 & 0.11896E-05_JPRB,0.14680E-05_JPRB,0.18142E-05_JPRB,0.22537E-05_JPRB,0.27284E-05_JPRB /)  
KB(:,17, 1) = (/ &
 & 0.10228E-05_JPRB,0.12597E-05_JPRB,0.15532E-05_JPRB,0.19272E-05_JPRB,0.23163E-05_JPRB /)  
KB(:,18, 1) = (/ &
 & 0.88243E-06_JPRB,0.10835E-05_JPRB,0.13316E-05_JPRB,0.16603E-05_JPRB,0.19808E-05_JPRB /)  
KB(:,19, 1) = (/ &
 & 0.75677E-06_JPRB,0.92925E-06_JPRB,0.11401E-05_JPRB,0.14107E-05_JPRB,0.16901E-05_JPRB /)  
KB(:,20, 1) = (/ &
 & 0.64614E-06_JPRB,0.79361E-06_JPRB,0.97353E-06_JPRB,0.11964E-05_JPRB,0.14414E-05_JPRB /)  
KB(:,21, 1) = (/ &
 & 0.55323E-06_JPRB,0.67580E-06_JPRB,0.82647E-06_JPRB,0.10137E-05_JPRB,0.12318E-05_JPRB /)  
KB(:,22, 1) = (/ &
 & 0.47719E-06_JPRB,0.58149E-06_JPRB,0.71060E-06_JPRB,0.87005E-06_JPRB,0.10605E-05_JPRB /)  
KB(:,23, 1) = (/ &
 & 0.41128E-06_JPRB,0.50080E-06_JPRB,0.61104E-06_JPRB,0.75347E-06_JPRB,0.91200E-06_JPRB /)  
KB(:,24, 1) = (/ &
 & 0.35306E-06_JPRB,0.42860E-06_JPRB,0.52320E-06_JPRB,0.65156E-06_JPRB,0.78122E-06_JPRB /)  
KB(:,25, 1) = (/ &
 & 0.30363E-06_JPRB,0.36731E-06_JPRB,0.44673E-06_JPRB,0.56097E-06_JPRB,0.66791E-06_JPRB /)  
KB(:,26, 1) = (/ &
 & 0.26073E-06_JPRB,0.31537E-06_JPRB,0.38738E-06_JPRB,0.48210E-06_JPRB,0.57382E-06_JPRB /)  
KB(:,27, 1) = (/ &
 & 0.22303E-06_JPRB,0.26986E-06_JPRB,0.33628E-06_JPRB,0.41161E-06_JPRB,0.48722E-06_JPRB /)  
KB(:,28, 1) = (/ &
 & 0.18954E-06_JPRB,0.22952E-06_JPRB,0.28797E-06_JPRB,0.35166E-06_JPRB,0.41440E-06_JPRB /)  
KB(:,29, 1) = (/ &
 & 0.16106E-06_JPRB,0.19430E-06_JPRB,0.24661E-06_JPRB,0.29815E-06_JPRB,0.35151E-06_JPRB /)  
KB(:,30, 1) = (/ &
 & 0.13630E-06_JPRB,0.16528E-06_JPRB,0.20922E-06_JPRB,0.25193E-06_JPRB,0.29913E-06_JPRB /)  
KB(:,31, 1) = (/ &
 & 0.11504E-06_JPRB,0.14276E-06_JPRB,0.17807E-06_JPRB,0.21482E-06_JPRB,0.25451E-06_JPRB /)  
KB(:,32, 1) = (/ &
 & 0.96980E-07_JPRB,0.12215E-06_JPRB,0.15159E-06_JPRB,0.18179E-06_JPRB,0.21515E-06_JPRB /)  
KB(:,33, 1) = (/ &
 & 0.81598E-07_JPRB,0.10315E-06_JPRB,0.12730E-06_JPRB,0.15190E-06_JPRB,0.18093E-06_JPRB /)  
KB(:,34, 1) = (/ &
 & 0.67700E-07_JPRB,0.85970E-07_JPRB,0.10559E-06_JPRB,0.12608E-06_JPRB,0.15006E-06_JPRB /)  
KB(:,35, 1) = (/ &
 & 0.55177E-07_JPRB,0.69519E-07_JPRB,0.85967E-07_JPRB,0.10223E-06_JPRB,0.12147E-06_JPRB /)  
KB(:,36, 1) = (/ &
 & 0.43924E-07_JPRB,0.54395E-07_JPRB,0.67998E-07_JPRB,0.81142E-07_JPRB,0.95717E-07_JPRB /)  
KB(:,37, 1) = (/ &
 & 0.34469E-07_JPRB,0.41036E-07_JPRB,0.52575E-07_JPRB,0.63117E-07_JPRB,0.74301E-07_JPRB /)  
KB(:,38, 1) = (/ &
 & 0.26777E-07_JPRB,0.31734E-07_JPRB,0.40555E-07_JPRB,0.49032E-07_JPRB,0.57653E-07_JPRB /)  
KB(:,39, 1) = (/ &
 & 0.20670E-07_JPRB,0.24721E-07_JPRB,0.30685E-07_JPRB,0.37873E-07_JPRB,0.44555E-07_JPRB /)  
KB(:,40, 1) = (/ &
 & 0.15860E-07_JPRB,0.19032E-07_JPRB,0.22612E-07_JPRB,0.28845E-07_JPRB,0.34246E-07_JPRB /)  
KB(:,41, 1) = (/ &
 & 0.12129E-07_JPRB,0.14603E-07_JPRB,0.17357E-07_JPRB,0.21851E-07_JPRB,0.26346E-07_JPRB /)  
KB(:,42, 1) = (/ &
 & 0.92319E-08_JPRB,0.11199E-07_JPRB,0.13365E-07_JPRB,0.16174E-07_JPRB,0.20019E-07_JPRB /)  
KB(:,43, 1) = (/ &
 & 0.69289E-08_JPRB,0.84537E-08_JPRB,0.10159E-07_JPRB,0.11992E-07_JPRB,0.14940E-07_JPRB /)  
KB(:,44, 1) = (/ &
 & 0.51546E-08_JPRB,0.63380E-08_JPRB,0.76593E-08_JPRB,0.90562E-08_JPRB,0.10716E-07_JPRB /)  
KB(:,45, 1) = (/ &
 & 0.38335E-08_JPRB,0.47085E-08_JPRB,0.57219E-08_JPRB,0.68148E-08_JPRB,0.79518E-08_JPRB /)  
KB(:,46, 1) = (/ &
 & 0.28583E-08_JPRB,0.34724E-08_JPRB,0.42447E-08_JPRB,0.50888E-08_JPRB,0.59494E-08_JPRB /)  
KB(:,47, 1) = (/ &
 & 0.20945E-08_JPRB,0.25418E-08_JPRB,0.31058E-08_JPRB,0.37494E-08_JPRB,0.44274E-08_JPRB /)  
KB(:,48, 1) = (/ &
 & 0.15164E-08_JPRB,0.18560E-08_JPRB,0.22628E-08_JPRB,0.27371E-08_JPRB,0.32773E-08_JPRB /)  
KB(:,49, 1) = (/ &
 & 0.10916E-08_JPRB,0.13465E-08_JPRB,0.16387E-08_JPRB,0.19740E-08_JPRB,0.23865E-08_JPRB /)  
KB(:,50, 1) = (/ &
 & 0.78324E-09_JPRB,0.98361E-09_JPRB,0.11977E-08_JPRB,0.14517E-08_JPRB,0.17457E-08_JPRB /)  
KB(:,51, 1) = (/ &
 & 0.57263E-09_JPRB,0.71786E-09_JPRB,0.87689E-09_JPRB,0.10705E-08_JPRB,0.12881E-08_JPRB /)  
KB(:,52, 1) = (/ &
 & 0.41574E-09_JPRB,0.51264E-09_JPRB,0.64152E-09_JPRB,0.78315E-09_JPRB,0.94705E-09_JPRB /)  
KB(:,53, 1) = (/ &
 & 0.29940E-09_JPRB,0.36836E-09_JPRB,0.45886E-09_JPRB,0.56405E-09_JPRB,0.69166E-09_JPRB /)  
KB(:,54, 1) = (/ &
 & 0.22617E-09_JPRB,0.27395E-09_JPRB,0.33754E-09_JPRB,0.42095E-09_JPRB,0.51544E-09_JPRB /)  
KB(:,55, 1) = (/ &
 & 0.17483E-09_JPRB,0.20845E-09_JPRB,0.25546E-09_JPRB,0.31817E-09_JPRB,0.39119E-09_JPRB /)  
KB(:,56, 1) = (/ &
 & 0.13496E-09_JPRB,0.15930E-09_JPRB,0.19380E-09_JPRB,0.23861E-09_JPRB,0.29770E-09_JPRB /)  
KB(:,57, 1) = (/ &
 & 0.10406E-09_JPRB,0.12247E-09_JPRB,0.14749E-09_JPRB,0.18078E-09_JPRB,0.22597E-09_JPRB /)  
KB(:,58, 1) = (/ &
 & 0.81345E-10_JPRB,0.94816E-10_JPRB,0.11329E-09_JPRB,0.13832E-09_JPRB,0.17161E-09_JPRB /)  
KB(:,59, 1) = (/ &
 & 0.67159E-10_JPRB,0.78312E-10_JPRB,0.94745E-10_JPRB,0.11544E-09_JPRB,0.14442E-09_JPRB /)  
KB(:,13, 2) = (/ &
 & 0.16654E-04_JPRB,0.18728E-04_JPRB,0.21238E-04_JPRB,0.24491E-04_JPRB,0.29038E-04_JPRB /)  
KB(:,14, 2) = (/ &
 & 0.15636E-04_JPRB,0.17574E-04_JPRB,0.19918E-04_JPRB,0.23671E-04_JPRB,0.27237E-04_JPRB /)  
KB(:,15, 2) = (/ &
 & 0.14853E-04_JPRB,0.16629E-04_JPRB,0.19700E-04_JPRB,0.22604E-04_JPRB,0.25586E-04_JPRB /)  
KB(:,16, 2) = (/ &
 & 0.13519E-04_JPRB,0.15923E-04_JPRB,0.18289E-04_JPRB,0.20530E-04_JPRB,0.22799E-04_JPRB /)  
KB(:,17, 2) = (/ &
 & 0.12411E-04_JPRB,0.14439E-04_JPRB,0.16431E-04_JPRB,0.18235E-04_JPRB,0.20109E-04_JPRB /)  
KB(:,18, 2) = (/ &
 & 0.11267E-04_JPRB,0.12880E-04_JPRB,0.14429E-04_JPRB,0.16005E-04_JPRB,0.17538E-04_JPRB /)  
KB(:,19, 2) = (/ &
 & 0.10025E-04_JPRB,0.11332E-04_JPRB,0.12550E-04_JPRB,0.13853E-04_JPRB,0.15103E-04_JPRB /)  
KB(:,20, 2) = (/ &
 & 0.86342E-05_JPRB,0.97455E-05_JPRB,0.10778E-04_JPRB,0.11898E-04_JPRB,0.12789E-04_JPRB /)  
KB(:,21, 2) = (/ &
 & 0.74004E-05_JPRB,0.83107E-05_JPRB,0.91633E-05_JPRB,0.10071E-04_JPRB,0.10674E-04_JPRB /)  
KB(:,22, 2) = (/ &
 & 0.63700E-05_JPRB,0.70549E-05_JPRB,0.78271E-05_JPRB,0.85170E-05_JPRB,0.90022E-05_JPRB /)  
KB(:,23, 2) = (/ &
 & 0.54404E-05_JPRB,0.60156E-05_JPRB,0.66393E-05_JPRB,0.71320E-05_JPRB,0.75007E-05_JPRB /)  
KB(:,24, 2) = (/ &
 & 0.45997E-05_JPRB,0.50718E-05_JPRB,0.55713E-05_JPRB,0.59455E-05_JPRB,0.62118E-05_JPRB /)  
KB(:,25, 2) = (/ &
 & 0.38745E-05_JPRB,0.42617E-05_JPRB,0.46479E-05_JPRB,0.49297E-05_JPRB,0.51638E-05_JPRB /)  
KB(:,26, 2) = (/ &
 & 0.32488E-05_JPRB,0.35592E-05_JPRB,0.38685E-05_JPRB,0.40759E-05_JPRB,0.43092E-05_JPRB /)  
KB(:,27, 2) = (/ &
 & 0.26995E-05_JPRB,0.29601E-05_JPRB,0.32065E-05_JPRB,0.33666E-05_JPRB,0.35609E-05_JPRB /)  
KB(:,28, 2) = (/ &
 & 0.22359E-05_JPRB,0.24429E-05_JPRB,0.26408E-05_JPRB,0.27752E-05_JPRB,0.29293E-05_JPRB /)  
KB(:,29, 2) = (/ &
 & 0.18487E-05_JPRB,0.20089E-05_JPRB,0.21668E-05_JPRB,0.22793E-05_JPRB,0.24029E-05_JPRB /)  
KB(:,30, 2) = (/ &
 & 0.15291E-05_JPRB,0.16589E-05_JPRB,0.17733E-05_JPRB,0.18706E-05_JPRB,0.19584E-05_JPRB /)  
KB(:,31, 2) = (/ &
 & 0.12554E-05_JPRB,0.13589E-05_JPRB,0.14436E-05_JPRB,0.15195E-05_JPRB,0.15928E-05_JPRB /)  
KB(:,32, 2) = (/ &
 & 0.10248E-05_JPRB,0.11046E-05_JPRB,0.11716E-05_JPRB,0.12288E-05_JPRB,0.12916E-05_JPRB /)  
KB(:,33, 2) = (/ &
 & 0.83272E-06_JPRB,0.89120E-06_JPRB,0.95036E-06_JPRB,0.99040E-06_JPRB,0.10409E-05_JPRB /)  
KB(:,34, 2) = (/ &
 & 0.67518E-06_JPRB,0.72097E-06_JPRB,0.76854E-06_JPRB,0.80246E-06_JPRB,0.83912E-06_JPRB /)  
KB(:,35, 2) = (/ &
 & 0.53577E-06_JPRB,0.57870E-06_JPRB,0.61715E-06_JPRB,0.64987E-06_JPRB,0.67220E-06_JPRB /)  
KB(:,36, 2) = (/ &
 & 0.42402E-06_JPRB,0.45825E-06_JPRB,0.49307E-06_JPRB,0.52005E-06_JPRB,0.54029E-06_JPRB /)  
KB(:,37, 2) = (/ &
 & 0.33419E-06_JPRB,0.36213E-06_JPRB,0.38911E-06_JPRB,0.41359E-06_JPRB,0.43177E-06_JPRB /)  
KB(:,38, 2) = (/ &
 & 0.26240E-06_JPRB,0.28355E-06_JPRB,0.30530E-06_JPRB,0.32881E-06_JPRB,0.34617E-06_JPRB /)  
KB(:,39, 2) = (/ &
 & 0.20468E-06_JPRB,0.22245E-06_JPRB,0.23980E-06_JPRB,0.25776E-06_JPRB,0.27424E-06_JPRB /)  
KB(:,40, 2) = (/ &
 & 0.16070E-06_JPRB,0.17478E-06_JPRB,0.18856E-06_JPRB,0.20230E-06_JPRB,0.21801E-06_JPRB /)  
KB(:,41, 2) = (/ &
 & 0.12583E-06_JPRB,0.13680E-06_JPRB,0.14851E-06_JPRB,0.15917E-06_JPRB,0.17184E-06_JPRB /)  
KB(:,42, 2) = (/ &
 & 0.98494E-07_JPRB,0.10639E-06_JPRB,0.11634E-06_JPRB,0.12500E-06_JPRB,0.13490E-06_JPRB /)  
KB(:,43, 2) = (/ &
 & 0.75196E-07_JPRB,0.82809E-07_JPRB,0.90095E-07_JPRB,0.97952E-07_JPRB,0.10509E-06_JPRB /)  
KB(:,44, 2) = (/ &
 & 0.57305E-07_JPRB,0.63787E-07_JPRB,0.69227E-07_JPRB,0.75635E-07_JPRB,0.81687E-07_JPRB /)  
KB(:,45, 2) = (/ &
 & 0.42965E-07_JPRB,0.48245E-07_JPRB,0.53346E-07_JPRB,0.58061E-07_JPRB,0.63120E-07_JPRB /)  
KB(:,46, 2) = (/ &
 & 0.31048E-07_JPRB,0.36457E-07_JPRB,0.40514E-07_JPRB,0.44557E-07_JPRB,0.48550E-07_JPRB /)  
KB(:,47, 2) = (/ &
 & 0.23094E-07_JPRB,0.26356E-07_JPRB,0.30443E-07_JPRB,0.33954E-07_JPRB,0.36789E-07_JPRB /)  
KB(:,48, 2) = (/ &
 & 0.16858E-07_JPRB,0.19402E-07_JPRB,0.22449E-07_JPRB,0.25401E-07_JPRB,0.28254E-07_JPRB /)  
KB(:,49, 2) = (/ &
 & 0.11413E-07_JPRB,0.14055E-07_JPRB,0.16046E-07_JPRB,0.18927E-07_JPRB,0.21080E-07_JPRB /)  
KB(:,50, 2) = (/ &
 & 0.78650E-08_JPRB,0.99879E-08_JPRB,0.11846E-07_JPRB,0.13654E-07_JPRB,0.15871E-07_JPRB /)  
KB(:,51, 2) = (/ &
 & 0.55417E-08_JPRB,0.68977E-08_JPRB,0.87006E-08_JPRB,0.10108E-07_JPRB,0.11829E-07_JPRB /)  
KB(:,52, 2) = (/ &
 & 0.39143E-08_JPRB,0.48025E-08_JPRB,0.60180E-08_JPRB,0.73762E-08_JPRB,0.85851E-08_JPRB /)  
KB(:,53, 2) = (/ &
 & 0.27637E-08_JPRB,0.33397E-08_JPRB,0.41996E-08_JPRB,0.52787E-08_JPRB,0.62923E-08_JPRB /)  
KB(:,54, 2) = (/ &
 & 0.19691E-08_JPRB,0.24529E-08_JPRB,0.30071E-08_JPRB,0.38041E-08_JPRB,0.46981E-08_JPRB /)  
KB(:,55, 2) = (/ &
 & 0.13034E-08_JPRB,0.18257E-08_JPRB,0.22359E-08_JPRB,0.28210E-08_JPRB,0.35386E-08_JPRB /)  
KB(:,56, 2) = (/ &
 & 0.10026E-08_JPRB,0.13422E-08_JPRB,0.16687E-08_JPRB,0.20793E-08_JPRB,0.26054E-08_JPRB /)  
KB(:,57, 2) = (/ &
 & 0.77730E-09_JPRB,0.91190E-09_JPRB,0.12468E-08_JPRB,0.15302E-08_JPRB,0.19418E-08_JPRB /)  
KB(:,58, 2) = (/ &
 & 0.60359E-09_JPRB,0.67848E-09_JPRB,0.92414E-09_JPRB,0.11511E-08_JPRB,0.14401E-08_JPRB /)  
KB(:,59, 2) = (/ &
 & 0.50441E-09_JPRB,0.56797E-09_JPRB,0.77369E-09_JPRB,0.95612E-09_JPRB,0.11957E-08_JPRB /)  
KB(:,13, 3) = (/ &
 & 0.98124E-04_JPRB,0.10149E-03_JPRB,0.10303E-03_JPRB,0.10669E-03_JPRB,0.10870E-03_JPRB /)  
KB(:,14, 3) = (/ &
 & 0.88110E-04_JPRB,0.89730E-04_JPRB,0.90679E-04_JPRB,0.91892E-04_JPRB,0.91413E-04_JPRB /)  
KB(:,15, 3) = (/ &
 & 0.78555E-04_JPRB,0.78633E-04_JPRB,0.79145E-04_JPRB,0.77689E-04_JPRB,0.77791E-04_JPRB /)  
KB(:,16, 3) = (/ &
 & 0.67245E-04_JPRB,0.67743E-04_JPRB,0.66690E-04_JPRB,0.65765E-04_JPRB,0.65950E-04_JPRB /)  
KB(:,17, 3) = (/ &
 & 0.57553E-04_JPRB,0.57490E-04_JPRB,0.56012E-04_JPRB,0.55634E-04_JPRB,0.56016E-04_JPRB /)  
KB(:,18, 3) = (/ &
 & 0.49729E-04_JPRB,0.48302E-04_JPRB,0.47418E-04_JPRB,0.47262E-04_JPRB,0.47732E-04_JPRB /)  
KB(:,19, 3) = (/ &
 & 0.42101E-04_JPRB,0.40906E-04_JPRB,0.40541E-04_JPRB,0.40229E-04_JPRB,0.40671E-04_JPRB /)  
KB(:,20, 3) = (/ &
 & 0.35046E-04_JPRB,0.34193E-04_JPRB,0.34032E-04_JPRB,0.33881E-04_JPRB,0.34691E-04_JPRB /)  
KB(:,21, 3) = (/ &
 & 0.29192E-04_JPRB,0.28813E-04_JPRB,0.28525E-04_JPRB,0.28485E-04_JPRB,0.29764E-04_JPRB /)  
KB(:,22, 3) = (/ &
 & 0.24212E-04_JPRB,0.23970E-04_JPRB,0.23804E-04_JPRB,0.23947E-04_JPRB,0.24310E-04_JPRB /)  
KB(:,23, 3) = (/ &
 & 0.20167E-04_JPRB,0.19961E-04_JPRB,0.19837E-04_JPRB,0.20528E-04_JPRB,0.19887E-04_JPRB /)  
KB(:,24, 3) = (/ &
 & 0.16817E-04_JPRB,0.16624E-04_JPRB,0.16525E-04_JPRB,0.17263E-04_JPRB,0.16481E-04_JPRB /)  
KB(:,25, 3) = (/ &
 & 0.13896E-04_JPRB,0.13806E-04_JPRB,0.13810E-04_JPRB,0.14348E-04_JPRB,0.13634E-04_JPRB /)  
KB(:,26, 3) = (/ &
 & 0.11515E-04_JPRB,0.11474E-04_JPRB,0.11553E-04_JPRB,0.11705E-04_JPRB,0.11167E-04_JPRB /)  
KB(:,27, 3) = (/ &
 & 0.95004E-05_JPRB,0.94543E-05_JPRB,0.95650E-05_JPRB,0.95316E-05_JPRB,0.91651E-05_JPRB /)  
KB(:,28, 3) = (/ &
 & 0.78135E-05_JPRB,0.77862E-05_JPRB,0.78715E-05_JPRB,0.77825E-05_JPRB,0.74877E-05_JPRB /)  
KB(:,29, 3) = (/ &
 & 0.63615E-05_JPRB,0.63601E-05_JPRB,0.64198E-05_JPRB,0.63507E-05_JPRB,0.61200E-05_JPRB /)  
KB(:,30, 3) = (/ &
 & 0.51738E-05_JPRB,0.51781E-05_JPRB,0.52250E-05_JPRB,0.51709E-05_JPRB,0.50243E-05_JPRB /)  
KB(:,31, 3) = (/ &
 & 0.41825E-05_JPRB,0.42240E-05_JPRB,0.42510E-05_JPRB,0.42241E-05_JPRB,0.41058E-05_JPRB /)  
KB(:,32, 3) = (/ &
 & 0.34024E-05_JPRB,0.34302E-05_JPRB,0.34514E-05_JPRB,0.34436E-05_JPRB,0.33474E-05_JPRB /)  
KB(:,33, 3) = (/ &
 & 0.27510E-05_JPRB,0.27828E-05_JPRB,0.28059E-05_JPRB,0.28125E-05_JPRB,0.27394E-05_JPRB /)  
KB(:,34, 3) = (/ &
 & 0.22195E-05_JPRB,0.22517E-05_JPRB,0.22743E-05_JPRB,0.22728E-05_JPRB,0.22254E-05_JPRB /)  
KB(:,35, 3) = (/ &
 & 0.18029E-05_JPRB,0.18238E-05_JPRB,0.18432E-05_JPRB,0.18461E-05_JPRB,0.18241E-05_JPRB /)  
KB(:,36, 3) = (/ &
 & 0.14477E-05_JPRB,0.14734E-05_JPRB,0.14936E-05_JPRB,0.15116E-05_JPRB,0.14874E-05_JPRB /)  
KB(:,37, 3) = (/ &
 & 0.11637E-05_JPRB,0.11929E-05_JPRB,0.12098E-05_JPRB,0.12265E-05_JPRB,0.12076E-05_JPRB /)  
KB(:,38, 3) = (/ &
 & 0.93292E-06_JPRB,0.96246E-06_JPRB,0.98169E-06_JPRB,0.99435E-06_JPRB,0.98749E-06_JPRB /)  
KB(:,39, 3) = (/ &
 & 0.74927E-06_JPRB,0.76742E-06_JPRB,0.79020E-06_JPRB,0.80604E-06_JPRB,0.81415E-06_JPRB /)  
KB(:,40, 3) = (/ &
 & 0.60479E-06_JPRB,0.61743E-06_JPRB,0.63973E-06_JPRB,0.65295E-06_JPRB,0.66261E-06_JPRB /)  
KB(:,41, 3) = (/ &
 & 0.48450E-06_JPRB,0.49742E-06_JPRB,0.51366E-06_JPRB,0.52876E-06_JPRB,0.53813E-06_JPRB /)  
KB(:,42, 3) = (/ &
 & 0.38298E-06_JPRB,0.40088E-06_JPRB,0.41192E-06_JPRB,0.42651E-06_JPRB,0.43595E-06_JPRB /)  
KB(:,43, 3) = (/ &
 & 0.30310E-06_JPRB,0.31905E-06_JPRB,0.32907E-06_JPRB,0.34154E-06_JPRB,0.35007E-06_JPRB /)  
KB(:,44, 3) = (/ &
 & 0.23745E-06_JPRB,0.25035E-06_JPRB,0.26224E-06_JPRB,0.27145E-06_JPRB,0.28146E-06_JPRB /)  
KB(:,45, 3) = (/ &
 & 0.18653E-06_JPRB,0.19510E-06_JPRB,0.20644E-06_JPRB,0.21510E-06_JPRB,0.22354E-06_JPRB /)  
KB(:,46, 3) = (/ &
 & 0.14759E-06_JPRB,0.15322E-06_JPRB,0.16145E-06_JPRB,0.17034E-06_JPRB,0.17744E-06_JPRB /)  
KB(:,47, 3) = (/ &
 & 0.11410E-06_JPRB,0.12007E-06_JPRB,0.12507E-06_JPRB,0.13237E-06_JPRB,0.13995E-06_JPRB /)  
KB(:,48, 3) = (/ &
 & 0.88327E-07_JPRB,0.93967E-07_JPRB,0.97683E-07_JPRB,0.10257E-06_JPRB,0.10921E-06_JPRB /)  
KB(:,49, 3) = (/ &
 & 0.66715E-07_JPRB,0.72172E-07_JPRB,0.76442E-07_JPRB,0.79214E-07_JPRB,0.84006E-07_JPRB /)  
KB(:,50, 3) = (/ &
 & 0.51458E-07_JPRB,0.55761E-07_JPRB,0.59239E-07_JPRB,0.62292E-07_JPRB,0.64470E-07_JPRB /)  
KB(:,51, 3) = (/ &
 & 0.39957E-07_JPRB,0.42400E-07_JPRB,0.45870E-07_JPRB,0.48592E-07_JPRB,0.50287E-07_JPRB /)  
KB(:,52, 3) = (/ &
 & 0.31150E-07_JPRB,0.32725E-07_JPRB,0.35598E-07_JPRB,0.37633E-07_JPRB,0.39607E-07_JPRB /)  
KB(:,53, 3) = (/ &
 & 0.23783E-07_JPRB,0.25415E-07_JPRB,0.26634E-07_JPRB,0.28885E-07_JPRB,0.30620E-07_JPRB /)  
KB(:,54, 3) = (/ &
 & 0.18531E-07_JPRB,0.19938E-07_JPRB,0.20988E-07_JPRB,0.22678E-07_JPRB,0.23867E-07_JPRB /)  
KB(:,55, 3) = (/ &
 & 0.14810E-07_JPRB,0.15772E-07_JPRB,0.16651E-07_JPRB,0.17727E-07_JPRB,0.18861E-07_JPRB /)  
KB(:,56, 3) = (/ &
 & 0.11652E-07_JPRB,0.12557E-07_JPRB,0.13319E-07_JPRB,0.13930E-07_JPRB,0.15077E-07_JPRB /)  
KB(:,57, 3) = (/ &
 & 0.91523E-08_JPRB,0.99835E-08_JPRB,0.10603E-07_JPRB,0.11081E-07_JPRB,0.11999E-07_JPRB /)  
KB(:,58, 3) = (/ &
 & 0.72383E-08_JPRB,0.79060E-08_JPRB,0.84489E-08_JPRB,0.88615E-08_JPRB,0.94456E-08_JPRB /)  
KB(:,59, 3) = (/ &
 & 0.60315E-08_JPRB,0.65931E-08_JPRB,0.71001E-08_JPRB,0.74012E-08_JPRB,0.78761E-08_JPRB /)  
KB(:,13, 4) = (/ &
 & 0.21882E-03_JPRB,0.20968E-03_JPRB,0.18648E-03_JPRB,0.17505E-03_JPRB,0.17320E-03_JPRB /)  
KB(:,14, 4) = (/ &
 & 0.19140E-03_JPRB,0.17026E-03_JPRB,0.15903E-03_JPRB,0.15552E-03_JPRB,0.16009E-03_JPRB /)  
KB(:,15, 4) = (/ &
 & 0.16003E-03_JPRB,0.14531E-03_JPRB,0.14007E-03_JPRB,0.14511E-03_JPRB,0.14619E-03_JPRB /)  
KB(:,16, 4) = (/ &
 & 0.13387E-03_JPRB,0.12423E-03_JPRB,0.12444E-03_JPRB,0.12743E-03_JPRB,0.12749E-03_JPRB /)  
KB(:,17, 4) = (/ &
 & 0.11266E-03_JPRB,0.10780E-03_JPRB,0.11110E-03_JPRB,0.11051E-03_JPRB,0.11075E-03_JPRB /)  
KB(:,18, 4) = (/ &
 & 0.96156E-04_JPRB,0.95617E-04_JPRB,0.96775E-04_JPRB,0.96220E-04_JPRB,0.96078E-04_JPRB /)  
KB(:,19, 4) = (/ &
 & 0.82712E-04_JPRB,0.82946E-04_JPRB,0.83265E-04_JPRB,0.82827E-04_JPRB,0.82044E-04_JPRB /)  
KB(:,20, 4) = (/ &
 & 0.71080E-04_JPRB,0.71167E-04_JPRB,0.71040E-04_JPRB,0.70443E-04_JPRB,0.69069E-04_JPRB /)  
KB(:,21, 4) = (/ &
 & 0.60110E-04_JPRB,0.60836E-04_JPRB,0.59994E-04_JPRB,0.58992E-04_JPRB,0.57237E-04_JPRB /)  
KB(:,22, 4) = (/ &
 & 0.50688E-04_JPRB,0.51296E-04_JPRB,0.50271E-04_JPRB,0.48889E-04_JPRB,0.48471E-04_JPRB /)  
KB(:,23, 4) = (/ &
 & 0.42706E-04_JPRB,0.42628E-04_JPRB,0.41764E-04_JPRB,0.39999E-04_JPRB,0.40893E-04_JPRB /)  
KB(:,24, 4) = (/ &
 & 0.35803E-04_JPRB,0.35316E-04_JPRB,0.34535E-04_JPRB,0.33229E-04_JPRB,0.34127E-04_JPRB /)  
KB(:,25, 4) = (/ &
 & 0.29906E-04_JPRB,0.29201E-04_JPRB,0.28336E-04_JPRB,0.27455E-04_JPRB,0.28044E-04_JPRB /)  
KB(:,26, 4) = (/ &
 & 0.24659E-04_JPRB,0.23926E-04_JPRB,0.23159E-04_JPRB,0.22827E-04_JPRB,0.23266E-04_JPRB /)  
KB(:,27, 4) = (/ &
 & 0.20221E-04_JPRB,0.19578E-04_JPRB,0.18838E-04_JPRB,0.18853E-04_JPRB,0.19067E-04_JPRB /)  
KB(:,28, 4) = (/ &
 & 0.16345E-04_JPRB,0.15913E-04_JPRB,0.15327E-04_JPRB,0.15412E-04_JPRB,0.15560E-04_JPRB /)  
KB(:,29, 4) = (/ &
 & 0.13195E-04_JPRB,0.12870E-04_JPRB,0.12430E-04_JPRB,0.12518E-04_JPRB,0.12639E-04_JPRB /)  
KB(:,30, 4) = (/ &
 & 0.10622E-04_JPRB,0.10384E-04_JPRB,0.10068E-04_JPRB,0.10151E-04_JPRB,0.10256E-04_JPRB /)  
KB(:,31, 4) = (/ &
 & 0.85785E-05_JPRB,0.83523E-05_JPRB,0.81227E-05_JPRB,0.81998E-05_JPRB,0.83313E-05_JPRB /)  
KB(:,32, 4) = (/ &
 & 0.69114E-05_JPRB,0.67093E-05_JPRB,0.65758E-05_JPRB,0.66222E-05_JPRB,0.67679E-05_JPRB /)  
KB(:,33, 4) = (/ &
 & 0.55456E-05_JPRB,0.54342E-05_JPRB,0.53229E-05_JPRB,0.53610E-05_JPRB,0.54819E-05_JPRB /)  
KB(:,34, 4) = (/ &
 & 0.44461E-05_JPRB,0.43891E-05_JPRB,0.43112E-05_JPRB,0.43632E-05_JPRB,0.44560E-05_JPRB /)  
KB(:,35, 4) = (/ &
 & 0.35725E-05_JPRB,0.35192E-05_JPRB,0.34703E-05_JPRB,0.35075E-05_JPRB,0.35919E-05_JPRB /)  
KB(:,36, 4) = (/ &
 & 0.28842E-05_JPRB,0.28362E-05_JPRB,0.28143E-05_JPRB,0.28097E-05_JPRB,0.29057E-05_JPRB /)  
KB(:,37, 4) = (/ &
 & 0.23374E-05_JPRB,0.22987E-05_JPRB,0.22934E-05_JPRB,0.22812E-05_JPRB,0.23451E-05_JPRB /)  
KB(:,38, 4) = (/ &
 & 0.18966E-05_JPRB,0.18679E-05_JPRB,0.18613E-05_JPRB,0.18437E-05_JPRB,0.18894E-05_JPRB /)  
KB(:,39, 4) = (/ &
 & 0.15300E-05_JPRB,0.15180E-05_JPRB,0.15096E-05_JPRB,0.14915E-05_JPRB,0.15107E-05_JPRB /)  
KB(:,40, 4) = (/ &
 & 0.12426E-05_JPRB,0.12357E-05_JPRB,0.12171E-05_JPRB,0.12170E-05_JPRB,0.12227E-05_JPRB /)  
KB(:,41, 4) = (/ &
 & 0.10102E-05_JPRB,0.10077E-05_JPRB,0.98593E-06_JPRB,0.98478E-06_JPRB,0.99213E-06_JPRB /)  
KB(:,42, 4) = (/ &
 & 0.82201E-06_JPRB,0.81050E-06_JPRB,0.80313E-06_JPRB,0.80181E-06_JPRB,0.80361E-06_JPRB /)  
KB(:,43, 4) = (/ &
 & 0.67318E-06_JPRB,0.65347E-06_JPRB,0.65478E-06_JPRB,0.64360E-06_JPRB,0.64722E-06_JPRB /)  
KB(:,44, 4) = (/ &
 & 0.55598E-06_JPRB,0.53355E-06_JPRB,0.52778E-06_JPRB,0.52097E-06_JPRB,0.51997E-06_JPRB /)  
KB(:,45, 4) = (/ &
 & 0.46157E-06_JPRB,0.43457E-06_JPRB,0.42412E-06_JPRB,0.42137E-06_JPRB,0.41750E-06_JPRB /)  
KB(:,46, 4) = (/ &
 & 0.39156E-06_JPRB,0.35690E-06_JPRB,0.34498E-06_JPRB,0.33995E-06_JPRB,0.33614E-06_JPRB /)  
KB(:,47, 4) = (/ &
 & 0.33392E-06_JPRB,0.29746E-06_JPRB,0.28074E-06_JPRB,0.27344E-06_JPRB,0.27079E-06_JPRB /)  
KB(:,48, 4) = (/ &
 & 0.27066E-06_JPRB,0.25369E-06_JPRB,0.23115E-06_JPRB,0.22213E-06_JPRB,0.21766E-06_JPRB /)  
KB(:,49, 4) = (/ &
 & 0.22198E-06_JPRB,0.21395E-06_JPRB,0.19274E-06_JPRB,0.18040E-06_JPRB,0.17542E-06_JPRB /)  
KB(:,50, 4) = (/ &
 & 0.18070E-06_JPRB,0.17367E-06_JPRB,0.16473E-06_JPRB,0.14916E-06_JPRB,0.14306E-06_JPRB /)  
KB(:,51, 4) = (/ &
 & 0.14595E-06_JPRB,0.14287E-06_JPRB,0.13847E-06_JPRB,0.12418E-06_JPRB,0.11697E-06_JPRB /)  
KB(:,52, 4) = (/ &
 & 0.11819E-06_JPRB,0.11588E-06_JPRB,0.11225E-06_JPRB,0.10604E-06_JPRB,0.96269E-07_JPRB /)  
KB(:,53, 4) = (/ &
 & 0.95028E-07_JPRB,0.93094E-07_JPRB,0.91303E-07_JPRB,0.88900E-07_JPRB,0.80262E-07_JPRB /)  
KB(:,54, 4) = (/ &
 & 0.77005E-07_JPRB,0.76238E-07_JPRB,0.74228E-07_JPRB,0.72526E-07_JPRB,0.67965E-07_JPRB /)  
KB(:,55, 4) = (/ &
 & 0.62979E-07_JPRB,0.62692E-07_JPRB,0.60930E-07_JPRB,0.59579E-07_JPRB,0.57700E-07_JPRB /)  
KB(:,56, 4) = (/ &
 & 0.51571E-07_JPRB,0.51196E-07_JPRB,0.50031E-07_JPRB,0.48916E-07_JPRB,0.48127E-07_JPRB /)  
KB(:,57, 4) = (/ &
 & 0.42602E-07_JPRB,0.41678E-07_JPRB,0.41006E-07_JPRB,0.39709E-07_JPRB,0.39283E-07_JPRB /)  
KB(:,58, 4) = (/ &
 & 0.35155E-07_JPRB,0.34052E-07_JPRB,0.33561E-07_JPRB,0.32395E-07_JPRB,0.32057E-07_JPRB /)  
KB(:,59, 4) = (/ &
 & 0.29318E-07_JPRB,0.28516E-07_JPRB,0.28097E-07_JPRB,0.26888E-07_JPRB,0.26840E-07_JPRB /)  
KB(:,13, 5) = (/ &
 & 0.43718E-03_JPRB,0.42279E-03_JPRB,0.43200E-03_JPRB,0.42910E-03_JPRB,0.42775E-03_JPRB /)  
KB(:,14, 5) = (/ &
 & 0.37902E-03_JPRB,0.38090E-03_JPRB,0.38058E-03_JPRB,0.37637E-03_JPRB,0.36798E-03_JPRB /)  
KB(:,15, 5) = (/ &
 & 0.33222E-03_JPRB,0.33597E-03_JPRB,0.33205E-03_JPRB,0.32000E-03_JPRB,0.31310E-03_JPRB /)  
KB(:,16, 5) = (/ &
 & 0.28736E-03_JPRB,0.28700E-03_JPRB,0.27853E-03_JPRB,0.26891E-03_JPRB,0.26391E-03_JPRB /)  
KB(:,17, 5) = (/ &
 & 0.24534E-03_JPRB,0.24098E-03_JPRB,0.23072E-03_JPRB,0.22519E-03_JPRB,0.22013E-03_JPRB /)  
KB(:,18, 5) = (/ &
 & 0.20645E-03_JPRB,0.20019E-03_JPRB,0.19266E-03_JPRB,0.18716E-03_JPRB,0.18139E-03_JPRB /)  
KB(:,19, 5) = (/ &
 & 0.17271E-03_JPRB,0.16642E-03_JPRB,0.16064E-03_JPRB,0.15556E-03_JPRB,0.14951E-03_JPRB /)  
KB(:,20, 5) = (/ &
 & 0.14266E-03_JPRB,0.13766E-03_JPRB,0.13239E-03_JPRB,0.12767E-03_JPRB,0.12305E-03_JPRB /)  
KB(:,21, 5) = (/ &
 & 0.11797E-03_JPRB,0.11256E-03_JPRB,0.10880E-03_JPRB,0.10424E-03_JPRB,0.10062E-03_JPRB /)  
KB(:,22, 5) = (/ &
 & 0.97085E-04_JPRB,0.92101E-04_JPRB,0.88420E-04_JPRB,0.85535E-04_JPRB,0.82201E-04_JPRB /)  
KB(:,23, 5) = (/ &
 & 0.79380E-04_JPRB,0.75312E-04_JPRB,0.72177E-04_JPRB,0.69710E-04_JPRB,0.66966E-04_JPRB /)  
KB(:,24, 5) = (/ &
 & 0.64591E-04_JPRB,0.61520E-04_JPRB,0.58891E-04_JPRB,0.56626E-04_JPRB,0.54603E-04_JPRB /)  
KB(:,25, 5) = (/ &
 & 0.52423E-04_JPRB,0.49934E-04_JPRB,0.48122E-04_JPRB,0.46331E-04_JPRB,0.44875E-04_JPRB /)  
KB(:,26, 5) = (/ &
 & 0.42528E-04_JPRB,0.40739E-04_JPRB,0.39218E-04_JPRB,0.37806E-04_JPRB,0.36631E-04_JPRB /)  
KB(:,27, 5) = (/ &
 & 0.34453E-04_JPRB,0.33104E-04_JPRB,0.32009E-04_JPRB,0.30764E-04_JPRB,0.30000E-04_JPRB /)  
KB(:,28, 5) = (/ &
 & 0.28076E-04_JPRB,0.26948E-04_JPRB,0.26097E-04_JPRB,0.25065E-04_JPRB,0.24596E-04_JPRB /)  
KB(:,29, 5) = (/ &
 & 0.22814E-04_JPRB,0.21902E-04_JPRB,0.21222E-04_JPRB,0.20350E-04_JPRB,0.20152E-04_JPRB /)  
KB(:,30, 5) = (/ &
 & 0.18551E-04_JPRB,0.17731E-04_JPRB,0.17162E-04_JPRB,0.16614E-04_JPRB,0.16461E-04_JPRB /)  
KB(:,31, 5) = (/ &
 & 0.15020E-04_JPRB,0.14383E-04_JPRB,0.13922E-04_JPRB,0.13548E-04_JPRB,0.13388E-04_JPRB /)  
KB(:,32, 5) = (/ &
 & 0.12091E-04_JPRB,0.11653E-04_JPRB,0.11308E-04_JPRB,0.11033E-04_JPRB,0.10954E-04_JPRB /)  
KB(:,33, 5) = (/ &
 & 0.97901E-05_JPRB,0.93570E-05_JPRB,0.91428E-05_JPRB,0.89594E-05_JPRB,0.89614E-05_JPRB /)  
KB(:,34, 5) = (/ &
 & 0.79439E-05_JPRB,0.76095E-05_JPRB,0.74365E-05_JPRB,0.73099E-05_JPRB,0.73269E-05_JPRB /)  
KB(:,35, 5) = (/ &
 & 0.64505E-05_JPRB,0.62326E-05_JPRB,0.60921E-05_JPRB,0.59939E-05_JPRB,0.59799E-05_JPRB /)  
KB(:,36, 5) = (/ &
 & 0.52745E-05_JPRB,0.51017E-05_JPRB,0.49658E-05_JPRB,0.48988E-05_JPRB,0.48773E-05_JPRB /)  
KB(:,37, 5) = (/ &
 & 0.43522E-05_JPRB,0.42053E-05_JPRB,0.40681E-05_JPRB,0.40176E-05_JPRB,0.40058E-05_JPRB /)  
KB(:,38, 5) = (/ &
 & 0.35676E-05_JPRB,0.34559E-05_JPRB,0.33446E-05_JPRB,0.33017E-05_JPRB,0.32771E-05_JPRB /)  
KB(:,39, 5) = (/ &
 & 0.29238E-05_JPRB,0.28445E-05_JPRB,0.27512E-05_JPRB,0.27095E-05_JPRB,0.26825E-05_JPRB /)  
KB(:,40, 5) = (/ &
 & 0.23985E-05_JPRB,0.23437E-05_JPRB,0.22756E-05_JPRB,0.22251E-05_JPRB,0.22009E-05_JPRB /)  
KB(:,41, 5) = (/ &
 & 0.19763E-05_JPRB,0.19311E-05_JPRB,0.18886E-05_JPRB,0.18370E-05_JPRB,0.18072E-05_JPRB /)  
KB(:,42, 5) = (/ &
 & 0.16256E-05_JPRB,0.15918E-05_JPRB,0.15558E-05_JPRB,0.15108E-05_JPRB,0.14861E-05_JPRB /)  
KB(:,43, 5) = (/ &
 & 0.13290E-05_JPRB,0.13116E-05_JPRB,0.12833E-05_JPRB,0.12550E-05_JPRB,0.12262E-05_JPRB /)  
KB(:,44, 5) = (/ &
 & 0.10777E-05_JPRB,0.10760E-05_JPRB,0.10566E-05_JPRB,0.10365E-05_JPRB,0.10136E-05_JPRB /)  
KB(:,45, 5) = (/ &
 & 0.86690E-06_JPRB,0.87981E-06_JPRB,0.87044E-06_JPRB,0.85428E-06_JPRB,0.83627E-06_JPRB /)  
KB(:,46, 5) = (/ &
 & 0.68706E-06_JPRB,0.71088E-06_JPRB,0.70939E-06_JPRB,0.70110E-06_JPRB,0.69032E-06_JPRB /)  
KB(:,47, 5) = (/ &
 & 0.54665E-06_JPRB,0.56934E-06_JPRB,0.58033E-06_JPRB,0.57830E-06_JPRB,0.57105E-06_JPRB /)  
KB(:,48, 5) = (/ &
 & 0.44874E-06_JPRB,0.44653E-06_JPRB,0.46650E-06_JPRB,0.47090E-06_JPRB,0.46732E-06_JPRB /)  
KB(:,49, 5) = (/ &
 & 0.36869E-06_JPRB,0.35456E-06_JPRB,0.36842E-06_JPRB,0.37978E-06_JPRB,0.38217E-06_JPRB /)  
KB(:,50, 5) = (/ &
 & 0.30489E-06_JPRB,0.29229E-06_JPRB,0.29104E-06_JPRB,0.30430E-06_JPRB,0.31068E-06_JPRB /)  
KB(:,51, 5) = (/ &
 & 0.25290E-06_JPRB,0.24012E-06_JPRB,0.23271E-06_JPRB,0.24366E-06_JPRB,0.25149E-06_JPRB /)  
KB(:,52, 5) = (/ &
 & 0.21148E-06_JPRB,0.19715E-06_JPRB,0.19121E-06_JPRB,0.19177E-06_JPRB,0.20148E-06_JPRB /)  
KB(:,53, 5) = (/ &
 & 0.17334E-06_JPRB,0.16335E-06_JPRB,0.15574E-06_JPRB,0.15266E-06_JPRB,0.15921E-06_JPRB /)  
KB(:,54, 5) = (/ &
 & 0.14189E-06_JPRB,0.13650E-06_JPRB,0.12781E-06_JPRB,0.12535E-06_JPRB,0.12749E-06_JPRB /)  
KB(:,55, 5) = (/ &
 & 0.11763E-06_JPRB,0.11398E-06_JPRB,0.10627E-06_JPRB,0.10373E-06_JPRB,0.10268E-06_JPRB /)  
KB(:,56, 5) = (/ &
 & 0.98316E-07_JPRB,0.94892E-07_JPRB,0.88799E-07_JPRB,0.85036E-07_JPRB,0.83393E-07_JPRB /)  
KB(:,57, 5) = (/ &
 & 0.83049E-07_JPRB,0.78499E-07_JPRB,0.74140E-07_JPRB,0.70137E-07_JPRB,0.68774E-07_JPRB /)  
KB(:,58, 5) = (/ &
 & 0.71768E-07_JPRB,0.64682E-07_JPRB,0.62012E-07_JPRB,0.58149E-07_JPRB,0.57037E-07_JPRB /)  
KB(:,59, 5) = (/ &
 & 0.60166E-07_JPRB,0.54824E-07_JPRB,0.52042E-07_JPRB,0.49198E-07_JPRB,0.47862E-07_JPRB /)  
KB(:,13, 6) = (/ &
 & 0.71254E-03_JPRB,0.65708E-03_JPRB,0.60824E-03_JPRB,0.57965E-03_JPRB,0.55389E-03_JPRB /)  
KB(:,14, 6) = (/ &
 & 0.58852E-03_JPRB,0.54811E-03_JPRB,0.51125E-03_JPRB,0.48557E-03_JPRB,0.47730E-03_JPRB /)  
KB(:,15, 6) = (/ &
 & 0.50599E-03_JPRB,0.46869E-03_JPRB,0.44362E-03_JPRB,0.43503E-03_JPRB,0.43705E-03_JPRB /)  
KB(:,16, 6) = (/ &
 & 0.43493E-03_JPRB,0.40996E-03_JPRB,0.39680E-03_JPRB,0.39623E-03_JPRB,0.40784E-03_JPRB /)  
KB(:,17, 6) = (/ &
 & 0.38028E-03_JPRB,0.36175E-03_JPRB,0.35696E-03_JPRB,0.36547E-03_JPRB,0.38127E-03_JPRB /)  
KB(:,18, 6) = (/ &
 & 0.33113E-03_JPRB,0.32205E-03_JPRB,0.32458E-03_JPRB,0.33502E-03_JPRB,0.35577E-03_JPRB /)  
KB(:,19, 6) = (/ &
 & 0.28886E-03_JPRB,0.29134E-03_JPRB,0.29799E-03_JPRB,0.31134E-03_JPRB,0.33676E-03_JPRB /)  
KB(:,20, 6) = (/ &
 & 0.25113E-03_JPRB,0.25555E-03_JPRB,0.26535E-03_JPRB,0.28470E-03_JPRB,0.30677E-03_JPRB /)  
KB(:,21, 6) = (/ &
 & 0.21640E-03_JPRB,0.22152E-03_JPRB,0.23323E-03_JPRB,0.25467E-03_JPRB,0.27764E-03_JPRB /)  
KB(:,22, 6) = (/ &
 & 0.18601E-03_JPRB,0.19217E-03_JPRB,0.20696E-03_JPRB,0.22593E-03_JPRB,0.24729E-03_JPRB /)  
KB(:,23, 6) = (/ &
 & 0.15978E-03_JPRB,0.16833E-03_JPRB,0.18229E-03_JPRB,0.19994E-03_JPRB,0.21913E-03_JPRB /)  
KB(:,24, 6) = (/ &
 & 0.13748E-03_JPRB,0.14696E-03_JPRB,0.16025E-03_JPRB,0.17620E-03_JPRB,0.19459E-03_JPRB /)  
KB(:,25, 6) = (/ &
 & 0.11841E-03_JPRB,0.12828E-03_JPRB,0.13998E-03_JPRB,0.15487E-03_JPRB,0.17174E-03_JPRB /)  
KB(:,26, 6) = (/ &
 & 0.10209E-03_JPRB,0.11175E-03_JPRB,0.12193E-03_JPRB,0.13590E-03_JPRB,0.15125E-03_JPRB /)  
KB(:,27, 6) = (/ &
 & 0.87003E-04_JPRB,0.95681E-04_JPRB,0.10499E-03_JPRB,0.11744E-03_JPRB,0.13086E-03_JPRB /)  
KB(:,28, 6) = (/ &
 & 0.73110E-04_JPRB,0.80653E-04_JPRB,0.89103E-04_JPRB,0.99988E-04_JPRB,0.11120E-03_JPRB /)  
KB(:,29, 6) = (/ &
 & 0.60620E-04_JPRB,0.66736E-04_JPRB,0.74222E-04_JPRB,0.82863E-04_JPRB,0.92471E-04_JPRB /)  
KB(:,30, 6) = (/ &
 & 0.49831E-04_JPRB,0.54602E-04_JPRB,0.61288E-04_JPRB,0.68281E-04_JPRB,0.75599E-04_JPRB /)  
KB(:,31, 6) = (/ &
 & 0.40315E-04_JPRB,0.44435E-04_JPRB,0.49703E-04_JPRB,0.55140E-04_JPRB,0.60140E-04_JPRB /)  
KB(:,32, 6) = (/ &
 & 0.32490E-04_JPRB,0.36020E-04_JPRB,0.39894E-04_JPRB,0.44068E-04_JPRB,0.48080E-04_JPRB /)  
KB(:,33, 6) = (/ &
 & 0.26085E-04_JPRB,0.29063E-04_JPRB,0.32003E-04_JPRB,0.35074E-04_JPRB,0.38662E-04_JPRB /)  
KB(:,34, 6) = (/ &
 & 0.21201E-04_JPRB,0.23256E-04_JPRB,0.25636E-04_JPRB,0.28140E-04_JPRB,0.31273E-04_JPRB /)  
KB(:,35, 6) = (/ &
 & 0.17022E-04_JPRB,0.18534E-04_JPRB,0.20322E-04_JPRB,0.22464E-04_JPRB,0.25109E-04_JPRB /)  
KB(:,36, 6) = (/ &
 & 0.13427E-04_JPRB,0.14606E-04_JPRB,0.16055E-04_JPRB,0.17783E-04_JPRB,0.19877E-04_JPRB /)  
KB(:,37, 6) = (/ &
 & 0.10630E-04_JPRB,0.11559E-04_JPRB,0.12731E-04_JPRB,0.14118E-04_JPRB,0.15831E-04_JPRB /)  
KB(:,38, 6) = (/ &
 & 0.84365E-05_JPRB,0.91300E-05_JPRB,0.10077E-04_JPRB,0.11171E-04_JPRB,0.12568E-04_JPRB /)  
KB(:,39, 6) = (/ &
 & 0.66762E-05_JPRB,0.71770E-05_JPRB,0.79359E-05_JPRB,0.88044E-05_JPRB,0.99043E-05_JPRB /)  
KB(:,40, 6) = (/ &
 & 0.53561E-05_JPRB,0.57216E-05_JPRB,0.63210E-05_JPRB,0.70080E-05_JPRB,0.79213E-05_JPRB /)  
KB(:,41, 6) = (/ &
 & 0.42954E-05_JPRB,0.45692E-05_JPRB,0.50356E-05_JPRB,0.56102E-05_JPRB,0.63394E-05_JPRB /)  
KB(:,42, 6) = (/ &
 & 0.34409E-05_JPRB,0.36788E-05_JPRB,0.40124E-05_JPRB,0.44898E-05_JPRB,0.50645E-05_JPRB /)  
KB(:,43, 6) = (/ &
 & 0.27453E-05_JPRB,0.29361E-05_JPRB,0.31651E-05_JPRB,0.35498E-05_JPRB,0.40058E-05_JPRB /)  
KB(:,44, 6) = (/ &
 & 0.21863E-05_JPRB,0.23320E-05_JPRB,0.24965E-05_JPRB,0.27915E-05_JPRB,0.31593E-05_JPRB /)  
KB(:,45, 6) = (/ &
 & 0.17409E-05_JPRB,0.18472E-05_JPRB,0.19801E-05_JPRB,0.21812E-05_JPRB,0.24741E-05_JPRB /)  
KB(:,46, 6) = (/ &
 & 0.13903E-05_JPRB,0.14639E-05_JPRB,0.15660E-05_JPRB,0.17042E-05_JPRB,0.19243E-05_JPRB /)  
KB(:,47, 6) = (/ &
 & 0.11229E-05_JPRB,0.11661E-05_JPRB,0.12377E-05_JPRB,0.13335E-05_JPRB,0.14898E-05_JPRB /)  
KB(:,48, 6) = (/ &
 & 0.90528E-06_JPRB,0.92962E-06_JPRB,0.97799E-06_JPRB,0.10483E-05_JPRB,0.11575E-05_JPRB /)  
KB(:,49, 6) = (/ &
 & 0.72877E-06_JPRB,0.74278E-06_JPRB,0.77380E-06_JPRB,0.82564E-06_JPRB,0.89736E-06_JPRB /)  
KB(:,50, 6) = (/ &
 & 0.59358E-06_JPRB,0.59955E-06_JPRB,0.62170E-06_JPRB,0.65720E-06_JPRB,0.70771E-06_JPRB /)  
KB(:,51, 6) = (/ &
 & 0.48783E-06_JPRB,0.48769E-06_JPRB,0.50300E-06_JPRB,0.52655E-06_JPRB,0.56377E-06_JPRB /)  
KB(:,52, 6) = (/ &
 & 0.39834E-06_JPRB,0.39922E-06_JPRB,0.40604E-06_JPRB,0.42316E-06_JPRB,0.45057E-06_JPRB /)  
KB(:,53, 6) = (/ &
 & 0.33019E-06_JPRB,0.32505E-06_JPRB,0.33011E-06_JPRB,0.33917E-06_JPRB,0.35858E-06_JPRB /)  
KB(:,54, 6) = (/ &
 & 0.27829E-06_JPRB,0.26763E-06_JPRB,0.27219E-06_JPRB,0.27714E-06_JPRB,0.29159E-06_JPRB /)  
KB(:,55, 6) = (/ &
 & 0.23259E-06_JPRB,0.22250E-06_JPRB,0.22510E-06_JPRB,0.22855E-06_JPRB,0.23937E-06_JPRB /)  
KB(:,56, 6) = (/ &
 & 0.19401E-06_JPRB,0.18605E-06_JPRB,0.18566E-06_JPRB,0.18937E-06_JPRB,0.19605E-06_JPRB /)  
KB(:,57, 6) = (/ &
 & 0.15908E-06_JPRB,0.15649E-06_JPRB,0.15396E-06_JPRB,0.15754E-06_JPRB,0.16039E-06_JPRB /)  
KB(:,58, 6) = (/ &
 & 0.12892E-06_JPRB,0.13132E-06_JPRB,0.12793E-06_JPRB,0.13093E-06_JPRB,0.13273E-06_JPRB /)  
KB(:,59, 6) = (/ &
 & 0.11177E-06_JPRB,0.11165E-06_JPRB,0.10875E-06_JPRB,0.11132E-06_JPRB,0.11431E-06_JPRB /)  
KB(:,13, 7) = (/ &
 & 0.19357E-02_JPRB,0.20341E-02_JPRB,0.21760E-02_JPRB,0.22982E-02_JPRB,0.24550E-02_JPRB /)  
KB(:,14, 7) = (/ &
 & 0.20343E-02_JPRB,0.21709E-02_JPRB,0.23192E-02_JPRB,0.24854E-02_JPRB,0.27026E-02_JPRB /)  
KB(:,15, 7) = (/ &
 & 0.21108E-02_JPRB,0.23009E-02_JPRB,0.25488E-02_JPRB,0.28048E-02_JPRB,0.30159E-02_JPRB /)  
KB(:,16, 7) = (/ &
 & 0.21016E-02_JPRB,0.23581E-02_JPRB,0.25958E-02_JPRB,0.28093E-02_JPRB,0.29839E-02_JPRB /)  
KB(:,17, 7) = (/ &
 & 0.21350E-02_JPRB,0.23722E-02_JPRB,0.25718E-02_JPRB,0.27703E-02_JPRB,0.30036E-02_JPRB /)  
KB(:,18, 7) = (/ &
 & 0.21493E-02_JPRB,0.23550E-02_JPRB,0.25593E-02_JPRB,0.27827E-02_JPRB,0.29722E-02_JPRB /)  
KB(:,19, 7) = (/ &
 & 0.21677E-02_JPRB,0.23602E-02_JPRB,0.25446E-02_JPRB,0.27267E-02_JPRB,0.29542E-02_JPRB /)  
KB(:,20, 7) = (/ &
 & 0.21009E-02_JPRB,0.22669E-02_JPRB,0.24261E-02_JPRB,0.26095E-02_JPRB,0.28436E-02_JPRB /)  
KB(:,21, 7) = (/ &
 & 0.19811E-02_JPRB,0.21249E-02_JPRB,0.22790E-02_JPRB,0.24716E-02_JPRB,0.26844E-02_JPRB /)  
KB(:,22, 7) = (/ &
 & 0.18393E-02_JPRB,0.19585E-02_JPRB,0.21127E-02_JPRB,0.22962E-02_JPRB,0.25211E-02_JPRB /)  
KB(:,23, 7) = (/ &
 & 0.16905E-02_JPRB,0.18032E-02_JPRB,0.19594E-02_JPRB,0.21280E-02_JPRB,0.23466E-02_JPRB /)  
KB(:,24, 7) = (/ &
 & 0.15327E-02_JPRB,0.16542E-02_JPRB,0.18047E-02_JPRB,0.19642E-02_JPRB,0.21591E-02_JPRB /)  
KB(:,25, 7) = (/ &
 & 0.13831E-02_JPRB,0.14932E-02_JPRB,0.16391E-02_JPRB,0.17921E-02_JPRB,0.19606E-02_JPRB /)  
KB(:,26, 7) = (/ &
 & 0.12298E-02_JPRB,0.13325E-02_JPRB,0.14676E-02_JPRB,0.16086E-02_JPRB,0.17628E-02_JPRB /)  
KB(:,27, 7) = (/ &
 & 0.10692E-02_JPRB,0.11652E-02_JPRB,0.12858E-02_JPRB,0.14124E-02_JPRB,0.15514E-02_JPRB /)  
KB(:,28, 7) = (/ &
 & 0.91706E-03_JPRB,0.10034E-02_JPRB,0.11100E-02_JPRB,0.12231E-02_JPRB,0.13481E-02_JPRB /)  
KB(:,29, 7) = (/ &
 & 0.76824E-03_JPRB,0.84492E-03_JPRB,0.93654E-03_JPRB,0.10377E-02_JPRB,0.11448E-02_JPRB /)  
KB(:,30, 7) = (/ &
 & 0.63841E-03_JPRB,0.70573E-03_JPRB,0.78553E-03_JPRB,0.87197E-03_JPRB,0.96607E-03_JPRB /)  
KB(:,31, 7) = (/ &
 & 0.51979E-03_JPRB,0.58056E-03_JPRB,0.64728E-03_JPRB,0.71891E-03_JPRB,0.80875E-03_JPRB /)  
KB(:,32, 7) = (/ &
 & 0.42659E-03_JPRB,0.47686E-03_JPRB,0.53347E-03_JPRB,0.60016E-03_JPRB,0.67592E-03_JPRB /)  
KB(:,33, 7) = (/ &
 & 0.34820E-03_JPRB,0.39030E-03_JPRB,0.44004E-03_JPRB,0.49875E-03_JPRB,0.56492E-03_JPRB /)  
KB(:,34, 7) = (/ &
 & 0.28753E-03_JPRB,0.32477E-03_JPRB,0.36831E-03_JPRB,0.41989E-03_JPRB,0.47708E-03_JPRB /)  
KB(:,35, 7) = (/ &
 & 0.23568E-03_JPRB,0.26716E-03_JPRB,0.30618E-03_JPRB,0.35062E-03_JPRB,0.39934E-03_JPRB /)  
KB(:,36, 7) = (/ &
 & 0.19116E-03_JPRB,0.21863E-03_JPRB,0.25180E-03_JPRB,0.28983E-03_JPRB,0.33082E-03_JPRB /)  
KB(:,37, 7) = (/ &
 & 0.15437E-03_JPRB,0.17829E-03_JPRB,0.20646E-03_JPRB,0.23900E-03_JPRB,0.27320E-03_JPRB /)  
KB(:,38, 7) = (/ &
 & 0.12397E-03_JPRB,0.14462E-03_JPRB,0.16847E-03_JPRB,0.19621E-03_JPRB,0.22528E-03_JPRB /)  
KB(:,39, 7) = (/ &
 & 0.98930E-04_JPRB,0.11647E-03_JPRB,0.13711E-03_JPRB,0.16057E-03_JPRB,0.18549E-03_JPRB /)  
KB(:,40, 7) = (/ &
 & 0.79845E-04_JPRB,0.94437E-04_JPRB,0.11202E-03_JPRB,0.13217E-03_JPRB,0.15346E-03_JPRB /)  
KB(:,41, 7) = (/ &
 & 0.64260E-04_JPRB,0.76439E-04_JPRB,0.91253E-04_JPRB,0.10837E-03_JPRB,0.12691E-03_JPRB /)  
KB(:,42, 7) = (/ &
 & 0.51561E-04_JPRB,0.61686E-04_JPRB,0.74044E-04_JPRB,0.88504E-04_JPRB,0.10431E-03_JPRB /)  
KB(:,43, 7) = (/ &
 & 0.40906E-04_JPRB,0.49267E-04_JPRB,0.59361E-04_JPRB,0.71417E-04_JPRB,0.84751E-04_JPRB /)  
KB(:,44, 7) = (/ &
 & 0.32247E-04_JPRB,0.38955E-04_JPRB,0.47246E-04_JPRB,0.57199E-04_JPRB,0.68540E-04_JPRB /)  
KB(:,45, 7) = (/ &
 & 0.25243E-04_JPRB,0.30790E-04_JPRB,0.37490E-04_JPRB,0.45754E-04_JPRB,0.55394E-04_JPRB /)  
KB(:,46, 7) = (/ &
 & 0.19604E-04_JPRB,0.24131E-04_JPRB,0.29598E-04_JPRB,0.36431E-04_JPRB,0.44419E-04_JPRB /)  
KB(:,47, 7) = (/ &
 & 0.15116E-04_JPRB,0.18785E-04_JPRB,0.23180E-04_JPRB,0.28780E-04_JPRB,0.35381E-04_JPRB /)  
KB(:,48, 7) = (/ &
 & 0.11550E-04_JPRB,0.14451E-04_JPRB,0.18039E-04_JPRB,0.22545E-04_JPRB,0.28005E-04_JPRB /)  
KB(:,49, 7) = (/ &
 & 0.87452E-05_JPRB,0.10992E-04_JPRB,0.13863E-04_JPRB,0.17498E-04_JPRB,0.21949E-04_JPRB /)  
KB(:,50, 7) = (/ &
 & 0.66768E-05_JPRB,0.84974E-05_JPRB,0.10835E-04_JPRB,0.13777E-04_JPRB,0.17448E-04_JPRB /)  
KB(:,51, 7) = (/ &
 & 0.51359E-05_JPRB,0.66277E-05_JPRB,0.85196E-05_JPRB,0.10905E-04_JPRB,0.13933E-04_JPRB /)  
KB(:,52, 7) = (/ &
 & 0.38737E-05_JPRB,0.51001E-05_JPRB,0.66347E-05_JPRB,0.85842E-05_JPRB,0.11033E-04_JPRB /)  
KB(:,53, 7) = (/ &
 & 0.28793E-05_JPRB,0.38820E-05_JPRB,0.50987E-05_JPRB,0.66800E-05_JPRB,0.86846E-05_JPRB /)  
KB(:,54, 7) = (/ &
 & 0.22250E-05_JPRB,0.30528E-05_JPRB,0.40721E-05_JPRB,0.53813E-05_JPRB,0.70529E-05_JPRB /)  
KB(:,55, 7) = (/ &
 & 0.17548E-05_JPRB,0.24455E-05_JPRB,0.32962E-05_JPRB,0.43877E-05_JPRB,0.58071E-05_JPRB /)  
KB(:,56, 7) = (/ &
 & 0.13740E-05_JPRB,0.19413E-05_JPRB,0.26523E-05_JPRB,0.35566E-05_JPRB,0.47512E-05_JPRB /)  
KB(:,57, 7) = (/ &
 & 0.10745E-05_JPRB,0.15242E-05_JPRB,0.21190E-05_JPRB,0.28679E-05_JPRB,0.38612E-05_JPRB /)  
KB(:,58, 7) = (/ &
 & 0.84271E-06_JPRB,0.12117E-05_JPRB,0.17039E-05_JPRB,0.23246E-05_JPRB,0.31564E-05_JPRB /)  
KB(:,59, 7) = (/ &
 & 0.75625E-06_JPRB,0.11002E-05_JPRB,0.15376E-05_JPRB,0.20855E-05_JPRB,0.28548E-05_JPRB /)  
KB(:,13, 8) = (/ &
 & 0.41133E-01_JPRB,0.43585E-01_JPRB,0.46448E-01_JPRB,0.50156E-01_JPRB,0.54607E-01_JPRB /)  
KB(:,14, 8) = (/ &
 & 0.39162E-01_JPRB,0.41636E-01_JPRB,0.44649E-01_JPRB,0.48118E-01_JPRB,0.52078E-01_JPRB /)  
KB(:,15, 8) = (/ &
 & 0.37770E-01_JPRB,0.40048E-01_JPRB,0.43090E-01_JPRB,0.46524E-01_JPRB,0.50698E-01_JPRB /)  
KB(:,16, 8) = (/ &
 & 0.35235E-01_JPRB,0.37712E-01_JPRB,0.40429E-01_JPRB,0.44092E-01_JPRB,0.48470E-01_JPRB /)  
KB(:,17, 8) = (/ &
 & 0.32748E-01_JPRB,0.35232E-01_JPRB,0.38049E-01_JPRB,0.41536E-01_JPRB,0.45596E-01_JPRB /)  
KB(:,18, 8) = (/ &
 & 0.30656E-01_JPRB,0.33078E-01_JPRB,0.36084E-01_JPRB,0.39403E-01_JPRB,0.43319E-01_JPRB /)  
KB(:,19, 8) = (/ &
 & 0.28887E-01_JPRB,0.31462E-01_JPRB,0.34348E-01_JPRB,0.37660E-01_JPRB,0.41532E-01_JPRB /)  
KB(:,20, 8) = (/ &
 & 0.26521E-01_JPRB,0.29153E-01_JPRB,0.32006E-01_JPRB,0.35368E-01_JPRB,0.39083E-01_JPRB /)  
KB(:,21, 8) = (/ &
 & 0.23988E-01_JPRB,0.26537E-01_JPRB,0.29508E-01_JPRB,0.32666E-01_JPRB,0.36356E-01_JPRB /)  
KB(:,22, 8) = (/ &
 & 0.21655E-01_JPRB,0.24205E-01_JPRB,0.27193E-01_JPRB,0.30346E-01_JPRB,0.33820E-01_JPRB /)  
KB(:,23, 8) = (/ &
 & 0.19724E-01_JPRB,0.22257E-01_JPRB,0.25021E-01_JPRB,0.27997E-01_JPRB,0.31309E-01_JPRB /)  
KB(:,24, 8) = (/ &
 & 0.18094E-01_JPRB,0.20464E-01_JPRB,0.23167E-01_JPRB,0.26069E-01_JPRB,0.29357E-01_JPRB /)  
KB(:,25, 8) = (/ &
 & 0.16666E-01_JPRB,0.18896E-01_JPRB,0.21422E-01_JPRB,0.24282E-01_JPRB,0.27401E-01_JPRB /)  
KB(:,26, 8) = (/ &
 & 0.15252E-01_JPRB,0.17451E-01_JPRB,0.19828E-01_JPRB,0.22565E-01_JPRB,0.25604E-01_JPRB /)  
KB(:,27, 8) = (/ &
 & 0.13902E-01_JPRB,0.15940E-01_JPRB,0.18143E-01_JPRB,0.20720E-01_JPRB,0.23727E-01_JPRB /)  
KB(:,28, 8) = (/ &
 & 0.12642E-01_JPRB,0.14401E-01_JPRB,0.16467E-01_JPRB,0.18975E-01_JPRB,0.21740E-01_JPRB /)  
KB(:,29, 8) = (/ &
 & 0.11177E-01_JPRB,0.12765E-01_JPRB,0.14750E-01_JPRB,0.16957E-01_JPRB,0.19575E-01_JPRB /)  
KB(:,30, 8) = (/ &
 & 0.97810E-02_JPRB,0.11281E-01_JPRB,0.13066E-01_JPRB,0.15112E-01_JPRB,0.17581E-01_JPRB /)  
KB(:,31, 8) = (/ &
 & 0.84562E-02_JPRB,0.98553E-02_JPRB,0.11427E-01_JPRB,0.13312E-01_JPRB,0.15536E-01_JPRB /)  
KB(:,32, 8) = (/ &
 & 0.73434E-02_JPRB,0.85939E-02_JPRB,0.10020E-01_JPRB,0.11770E-01_JPRB,0.13758E-01_JPRB /)  
KB(:,33, 8) = (/ &
 & 0.63801E-02_JPRB,0.74957E-02_JPRB,0.87874E-02_JPRB,0.10375E-01_JPRB,0.12145E-01_JPRB /)  
KB(:,34, 8) = (/ &
 & 0.56002E-02_JPRB,0.65926E-02_JPRB,0.77964E-02_JPRB,0.92186E-02_JPRB,0.10768E-01_JPRB /)  
KB(:,35, 8) = (/ &
 & 0.48489E-02_JPRB,0.57164E-02_JPRB,0.68333E-02_JPRB,0.80886E-02_JPRB,0.94500E-02_JPRB /)  
KB(:,36, 8) = (/ &
 & 0.41428E-02_JPRB,0.49220E-02_JPRB,0.58884E-02_JPRB,0.69905E-02_JPRB,0.81862E-02_JPRB /)  
KB(:,37, 8) = (/ &
 & 0.34967E-02_JPRB,0.41841E-02_JPRB,0.50244E-02_JPRB,0.59657E-02_JPRB,0.70167E-02_JPRB /)  
KB(:,38, 8) = (/ &
 & 0.29333E-02_JPRB,0.35364E-02_JPRB,0.42644E-02_JPRB,0.50719E-02_JPRB,0.59938E-02_JPRB /)  
KB(:,39, 8) = (/ &
 & 0.24443E-02_JPRB,0.29647E-02_JPRB,0.35953E-02_JPRB,0.42898E-02_JPRB,0.50972E-02_JPRB /)  
KB(:,40, 8) = (/ &
 & 0.20439E-02_JPRB,0.25046E-02_JPRB,0.30512E-02_JPRB,0.36459E-02_JPRB,0.43466E-02_JPRB /)  
KB(:,41, 8) = (/ &
 & 0.17068E-02_JPRB,0.21107E-02_JPRB,0.25838E-02_JPRB,0.30959E-02_JPRB,0.36971E-02_JPRB /)  
KB(:,42, 8) = (/ &
 & 0.14199E-02_JPRB,0.17705E-02_JPRB,0.21755E-02_JPRB,0.26204E-02_JPRB,0.31356E-02_JPRB /)  
KB(:,43, 8) = (/ &
 & 0.11616E-02_JPRB,0.14584E-02_JPRB,0.18069E-02_JPRB,0.21876E-02_JPRB,0.26286E-02_JPRB /)  
KB(:,44, 8) = (/ &
 & 0.93807E-03_JPRB,0.11864E-02_JPRB,0.14851E-02_JPRB,0.18080E-02_JPRB,0.21849E-02_JPRB /)  
KB(:,45, 8) = (/ &
 & 0.75026E-03_JPRB,0.95460E-03_JPRB,0.12092E-02_JPRB,0.14831E-02_JPRB,0.18037E-02_JPRB /)  
KB(:,46, 8) = (/ &
 & 0.59319E-03_JPRB,0.76134E-03_JPRB,0.97292E-03_JPRB,0.12059E-02_JPRB,0.14787E-02_JPRB /)  
KB(:,47, 8) = (/ &
 & 0.46546E-03_JPRB,0.60113E-03_JPRB,0.77762E-03_JPRB,0.97379E-03_JPRB,0.12030E-02_JPRB /)  
KB(:,48, 8) = (/ &
 & 0.36131E-03_JPRB,0.46999E-03_JPRB,0.61292E-03_JPRB,0.77778E-03_JPRB,0.96667E-03_JPRB /)  
KB(:,49, 8) = (/ &
 & 0.27490E-03_JPRB,0.36153E-03_JPRB,0.47561E-03_JPRB,0.61173E-03_JPRB,0.76634E-03_JPRB /)  
KB(:,50, 8) = (/ &
 & 0.21403E-03_JPRB,0.28416E-03_JPRB,0.37592E-03_JPRB,0.48994E-03_JPRB,0.61812E-03_JPRB /)  
KB(:,51, 8) = (/ &
 & 0.16745E-03_JPRB,0.22425E-03_JPRB,0.29943E-03_JPRB,0.39474E-03_JPRB,0.50310E-03_JPRB /)  
KB(:,52, 8) = (/ &
 & 0.12927E-03_JPRB,0.17496E-03_JPRB,0.23541E-03_JPRB,0.31434E-03_JPRB,0.40442E-03_JPRB /)  
KB(:,53, 8) = (/ &
 & 0.98512E-04_JPRB,0.13503E-03_JPRB,0.18276E-03_JPRB,0.24681E-03_JPRB,0.32086E-03_JPRB /)  
KB(:,54, 8) = (/ &
 & 0.78150E-04_JPRB,0.10819E-03_JPRB,0.14843E-03_JPRB,0.20243E-03_JPRB,0.26646E-03_JPRB /)  
KB(:,55, 8) = (/ &
 & 0.63455E-04_JPRB,0.88570E-04_JPRB,0.12297E-03_JPRB,0.17015E-03_JPRB,0.22626E-03_JPRB /)  
KB(:,56, 8) = (/ &
 & 0.51095E-04_JPRB,0.72223E-04_JPRB,0.10144E-03_JPRB,0.14188E-03_JPRB,0.19132E-03_JPRB /)  
KB(:,57, 8) = (/ &
 & 0.40866E-04_JPRB,0.58631E-04_JPRB,0.83096E-04_JPRB,0.11753E-03_JPRB,0.16055E-03_JPRB /)  
KB(:,58, 8) = (/ &
 & 0.32890E-04_JPRB,0.47893E-04_JPRB,0.68644E-04_JPRB,0.98156E-04_JPRB,0.13564E-03_JPRB /)  
KB(:,59, 8) = (/ &
 & 0.29702E-04_JPRB,0.43928E-04_JPRB,0.64217E-04_JPRB,0.92621E-04_JPRB,0.12965E-03_JPRB /)  
KB(:,13, 9) = (/ &
 & 0.27690E+01_JPRB,0.28644E+01_JPRB,0.29696E+01_JPRB,0.30850E+01_JPRB,0.32162E+01_JPRB /)  
KB(:,14, 9) = (/ &
 & 0.23162E+01_JPRB,0.23973E+01_JPRB,0.24876E+01_JPRB,0.25913E+01_JPRB,0.27107E+01_JPRB /)  
KB(:,15, 9) = (/ &
 & 0.19377E+01_JPRB,0.20096E+01_JPRB,0.20909E+01_JPRB,0.21846E+01_JPRB,0.22904E+01_JPRB /)  
KB(:,16, 9) = (/ &
 & 0.16221E+01_JPRB,0.16854E+01_JPRB,0.17596E+01_JPRB,0.18440E+01_JPRB,0.19374E+01_JPRB /)  
KB(:,17, 9) = (/ &
 & 0.13581E+01_JPRB,0.14147E+01_JPRB,0.14813E+01_JPRB,0.15562E+01_JPRB,0.16364E+01_JPRB /)  
KB(:,18, 9) = (/ &
 & 0.11494E+01_JPRB,0.11995E+01_JPRB,0.12558E+01_JPRB,0.13168E+01_JPRB,0.13828E+01_JPRB /)  
KB(:,19, 9) = (/ &
 & 0.99857E+00_JPRB,0.10422E+01_JPRB,0.10890E+01_JPRB,0.11391E+01_JPRB,0.11917E+01_JPRB /)  
KB(:,20, 9) = (/ &
 & 0.86585E+00_JPRB,0.90292E+00_JPRB,0.94341E+00_JPRB,0.98616E+00_JPRB,0.10332E+01_JPRB /)  
KB(:,21, 9) = (/ &
 & 0.74752E+00_JPRB,0.77983E+00_JPRB,0.81433E+00_JPRB,0.85283E+00_JPRB,0.89462E+00_JPRB /)  
KB(:,22, 9) = (/ &
 & 0.64494E+00_JPRB,0.67286E+00_JPRB,0.70277E+00_JPRB,0.73658E+00_JPRB,0.77352E+00_JPRB /)  
KB(:,23, 9) = (/ &
 & 0.55485E+00_JPRB,0.57897E+00_JPRB,0.60654E+00_JPRB,0.63699E+00_JPRB,0.66979E+00_JPRB /)  
KB(:,24, 9) = (/ &
 & 0.47664E+00_JPRB,0.49869E+00_JPRB,0.52329E+00_JPRB,0.54973E+00_JPRB,0.57955E+00_JPRB /)  
KB(:,25, 9) = (/ &
 & 0.41114E+00_JPRB,0.42988E+00_JPRB,0.45044E+00_JPRB,0.47447E+00_JPRB,0.50163E+00_JPRB /)  
KB(:,26, 9) = (/ &
 & 0.35513E+00_JPRB,0.37142E+00_JPRB,0.38942E+00_JPRB,0.41045E+00_JPRB,0.43493E+00_JPRB /)  
KB(:,27, 9) = (/ &
 & 0.30546E+00_JPRB,0.31995E+00_JPRB,0.33673E+00_JPRB,0.35597E+00_JPRB,0.37742E+00_JPRB /)  
KB(:,28, 9) = (/ &
 & 0.26188E+00_JPRB,0.27552E+00_JPRB,0.29117E+00_JPRB,0.30879E+00_JPRB,0.32839E+00_JPRB /)  
KB(:,29, 9) = (/ &
 & 0.22377E+00_JPRB,0.23654E+00_JPRB,0.25102E+00_JPRB,0.26735E+00_JPRB,0.28587E+00_JPRB /)  
KB(:,30, 9) = (/ &
 & 0.19129E+00_JPRB,0.20332E+00_JPRB,0.21691E+00_JPRB,0.23233E+00_JPRB,0.24924E+00_JPRB /)  
KB(:,31, 9) = (/ &
 & 0.16347E+00_JPRB,0.17463E+00_JPRB,0.18745E+00_JPRB,0.20165E+00_JPRB,0.21712E+00_JPRB /)  
KB(:,32, 9) = (/ &
 & 0.14037E+00_JPRB,0.15075E+00_JPRB,0.16282E+00_JPRB,0.17567E+00_JPRB,0.18973E+00_JPRB /)  
KB(:,33, 9) = (/ &
 & 0.12095E+00_JPRB,0.13081E+00_JPRB,0.14161E+00_JPRB,0.15337E+00_JPRB,0.16632E+00_JPRB /)  
KB(:,34, 9) = (/ &
 & 0.10468E+00_JPRB,0.11371E+00_JPRB,0.12351E+00_JPRB,0.13423E+00_JPRB,0.14632E+00_JPRB /)  
KB(:,35, 9) = (/ &
 & 0.90259E-01_JPRB,0.98421E-01_JPRB,0.10717E+00_JPRB,0.11695E+00_JPRB,0.12831E+00_JPRB /)  
KB(:,36, 9) = (/ &
 & 0.77272E-01_JPRB,0.84599E-01_JPRB,0.92464E-01_JPRB,0.10140E+00_JPRB,0.11193E+00_JPRB /)  
KB(:,37, 9) = (/ &
 & 0.65606E-01_JPRB,0.72029E-01_JPRB,0.79063E-01_JPRB,0.87174E-01_JPRB,0.96643E-01_JPRB /)  
KB(:,38, 9) = (/ &
 & 0.55528E-01_JPRB,0.61268E-01_JPRB,0.67613E-01_JPRB,0.74898E-01_JPRB,0.83456E-01_JPRB /)  
KB(:,39, 9) = (/ &
 & 0.46985E-01_JPRB,0.52085E-01_JPRB,0.57765E-01_JPRB,0.64303E-01_JPRB,0.72021E-01_JPRB /)  
KB(:,40, 9) = (/ &
 & 0.39626E-01_JPRB,0.44094E-01_JPRB,0.49150E-01_JPRB,0.55005E-01_JPRB,0.61884E-01_JPRB /)  
KB(:,41, 9) = (/ &
 & 0.33376E-01_JPRB,0.37326E-01_JPRB,0.41783E-01_JPRB,0.46997E-01_JPRB,0.53158E-01_JPRB /)  
KB(:,42, 9) = (/ &
 & 0.28074E-01_JPRB,0.31535E-01_JPRB,0.35493E-01_JPRB,0.40112E-01_JPRB,0.45645E-01_JPRB /)  
KB(:,43, 9) = (/ &
 & 0.23419E-01_JPRB,0.26419E-01_JPRB,0.29889E-01_JPRB,0.33982E-01_JPRB,0.38867E-01_JPRB /)  
KB(:,44, 9) = (/ &
 & 0.19437E-01_JPRB,0.22035E-01_JPRB,0.25042E-01_JPRB,0.28622E-01_JPRB,0.32930E-01_JPRB /)  
KB(:,45, 9) = (/ &
 & 0.16083E-01_JPRB,0.18329E-01_JPRB,0.20937E-01_JPRB,0.24027E-01_JPRB,0.27786E-01_JPRB /)  
KB(:,46, 9) = (/ &
 & 0.13236E-01_JPRB,0.15146E-01_JPRB,0.17420E-01_JPRB,0.20094E-01_JPRB,0.23328E-01_JPRB /)  
KB(:,47, 9) = (/ &
 & 0.10820E-01_JPRB,0.12455E-01_JPRB,0.14377E-01_JPRB,0.16656E-01_JPRB,0.19464E-01_JPRB /)  
KB(:,48, 9) = (/ &
 & 0.88043E-02_JPRB,0.10190E-01_JPRB,0.11813E-01_JPRB,0.13745E-01_JPRB,0.16141E-01_JPRB /)  
KB(:,49, 9) = (/ &
 & 0.71234E-02_JPRB,0.82775E-02_JPRB,0.96453E-02_JPRB,0.11284E-01_JPRB,0.13310E-01_JPRB /)  
KB(:,50, 9) = (/ &
 & 0.58127E-02_JPRB,0.67802E-02_JPRB,0.79379E-02_JPRB,0.93254E-02_JPRB,0.11078E-01_JPRB /)  
KB(:,51, 9) = (/ &
 & 0.47494E-02_JPRB,0.55659E-02_JPRB,0.65602E-02_JPRB,0.77407E-02_JPRB,0.92288E-02_JPRB /)  
KB(:,52, 9) = (/ &
 & 0.38618E-02_JPRB,0.45424E-02_JPRB,0.53925E-02_JPRB,0.64011E-02_JPRB,0.76645E-02_JPRB /)  
KB(:,53, 9) = (/ &
 & 0.31264E-02_JPRB,0.36823E-02_JPRB,0.43952E-02_JPRB,0.52615E-02_JPRB,0.63311E-02_JPRB /)  
KB(:,54, 9) = (/ &
 & 0.25794E-02_JPRB,0.30481E-02_JPRB,0.36548E-02_JPRB,0.44037E-02_JPRB,0.53380E-02_JPRB /)  
KB(:,55, 9) = (/ &
 & 0.21508E-02_JPRB,0.25472E-02_JPRB,0.30665E-02_JPRB,0.37188E-02_JPRB,0.45472E-02_JPRB /)  
KB(:,56, 9) = (/ &
 & 0.17938E-02_JPRB,0.21263E-02_JPRB,0.25713E-02_JPRB,0.31411E-02_JPRB,0.38667E-02_JPRB /)  
KB(:,57, 9) = (/ &
 & 0.14949E-02_JPRB,0.17755E-02_JPRB,0.21510E-02_JPRB,0.26439E-02_JPRB,0.32830E-02_JPRB /)  
KB(:,58, 9) = (/ &
 & 0.12521E-02_JPRB,0.14938E-02_JPRB,0.18137E-02_JPRB,0.22426E-02_JPRB,0.28028E-02_JPRB /)  
KB(:,59, 9) = (/ &
 & 0.11302E-02_JPRB,0.13552E-02_JPRB,0.16582E-02_JPRB,0.20691E-02_JPRB,0.26051E-02_JPRB /)  
KB(:,13,10) = (/ &
 & 0.14370E+02_JPRB,0.14649E+02_JPRB,0.14957E+02_JPRB,0.15296E+02_JPRB,0.15663E+02_JPRB /)  
KB(:,14,10) = (/ &
 & 0.12178E+02_JPRB,0.12411E+02_JPRB,0.12682E+02_JPRB,0.12978E+02_JPRB,0.13316E+02_JPRB /)  
KB(:,15,10) = (/ &
 & 0.10211E+02_JPRB,0.10402E+02_JPRB,0.10625E+02_JPRB,0.10894E+02_JPRB,0.11239E+02_JPRB /)  
KB(:,16,10) = (/ &
 & 0.85974E+01_JPRB,0.87539E+01_JPRB,0.89410E+01_JPRB,0.91849E+01_JPRB,0.95108E+01_JPRB /)  
KB(:,17,10) = (/ &
 & 0.72440E+01_JPRB,0.73858E+01_JPRB,0.75683E+01_JPRB,0.78199E+01_JPRB,0.81516E+01_JPRB /)  
KB(:,18,10) = (/ &
 & 0.59680E+01_JPRB,0.61054E+01_JPRB,0.63108E+01_JPRB,0.66074E+01_JPRB,0.69367E+01_JPRB /)  
KB(:,19,10) = (/ &
 & 0.47759E+01_JPRB,0.49000E+01_JPRB,0.51125E+01_JPRB,0.53858E+01_JPRB,0.56972E+01_JPRB /)  
KB(:,20,10) = (/ &
 & 0.40682E+01_JPRB,0.42060E+01_JPRB,0.43988E+01_JPRB,0.46035E+01_JPRB,0.48052E+01_JPRB /)  
KB(:,21,10) = (/ &
 & 0.35226E+01_JPRB,0.36715E+01_JPRB,0.38357E+01_JPRB,0.40017E+01_JPRB,0.41636E+01_JPRB /)  
KB(:,22,10) = (/ &
 & 0.30730E+01_JPRB,0.32059E+01_JPRB,0.33607E+01_JPRB,0.35055E+01_JPRB,0.36621E+01_JPRB /)  
KB(:,23,10) = (/ &
 & 0.26688E+01_JPRB,0.27999E+01_JPRB,0.29296E+01_JPRB,0.30668E+01_JPRB,0.32115E+01_JPRB /)  
KB(:,24,10) = (/ &
 & 0.23228E+01_JPRB,0.24338E+01_JPRB,0.25510E+01_JPRB,0.26866E+01_JPRB,0.28223E+01_JPRB /)  
KB(:,25,10) = (/ &
 & 0.19964E+01_JPRB,0.21083E+01_JPRB,0.22332E+01_JPRB,0.23566E+01_JPRB,0.24845E+01_JPRB /)  
KB(:,26,10) = (/ &
 & 0.17097E+01_JPRB,0.18190E+01_JPRB,0.19420E+01_JPRB,0.20663E+01_JPRB,0.21952E+01_JPRB /)  
KB(:,27,10) = (/ &
 & 0.14729E+01_JPRB,0.15741E+01_JPRB,0.16825E+01_JPRB,0.17963E+01_JPRB,0.19295E+01_JPRB /)  
KB(:,28,10) = (/ &
 & 0.12788E+01_JPRB,0.13609E+01_JPRB,0.14562E+01_JPRB,0.15668E+01_JPRB,0.17032E+01_JPRB /)  
KB(:,29,10) = (/ &
 & 0.11113E+01_JPRB,0.11813E+01_JPRB,0.12669E+01_JPRB,0.13763E+01_JPRB,0.15012E+01_JPRB /)  
KB(:,30,10) = (/ &
 & 0.96661E+00_JPRB,0.10287E+01_JPRB,0.11081E+01_JPRB,0.12093E+01_JPRB,0.13273E+01_JPRB /)  
KB(:,31,10) = (/ &
 & 0.83795E+00_JPRB,0.89792E+00_JPRB,0.97327E+00_JPRB,0.10727E+01_JPRB,0.11828E+01_JPRB /)  
KB(:,32,10) = (/ &
 & 0.72634E+00_JPRB,0.78480E+00_JPRB,0.86071E+00_JPRB,0.95503E+00_JPRB,0.10615E+01_JPRB /)  
KB(:,33,10) = (/ &
 & 0.63134E+00_JPRB,0.68789E+00_JPRB,0.76628E+00_JPRB,0.85854E+00_JPRB,0.96370E+00_JPRB /)  
KB(:,34,10) = (/ &
 & 0.55172E+00_JPRB,0.60863E+00_JPRB,0.68672E+00_JPRB,0.77637E+00_JPRB,0.87664E+00_JPRB /)  
KB(:,35,10) = (/ &
 & 0.48039E+00_JPRB,0.53701E+00_JPRB,0.61125E+00_JPRB,0.69795E+00_JPRB,0.79084E+00_JPRB /)  
KB(:,36,10) = (/ &
 & 0.41819E+00_JPRB,0.47188E+00_JPRB,0.54096E+00_JPRB,0.62096E+00_JPRB,0.70693E+00_JPRB /)  
KB(:,37,10) = (/ &
 & 0.36050E+00_JPRB,0.40906E+00_JPRB,0.47069E+00_JPRB,0.54184E+00_JPRB,0.62144E+00_JPRB /)  
KB(:,38,10) = (/ &
 & 0.31156E+00_JPRB,0.35409E+00_JPRB,0.40958E+00_JPRB,0.47371E+00_JPRB,0.54611E+00_JPRB /)  
KB(:,39,10) = (/ &
 & 0.26782E+00_JPRB,0.30677E+00_JPRB,0.35645E+00_JPRB,0.41535E+00_JPRB,0.48073E+00_JPRB /)  
KB(:,40,10) = (/ &
 & 0.23006E+00_JPRB,0.26273E+00_JPRB,0.30670E+00_JPRB,0.35934E+00_JPRB,0.41871E+00_JPRB /)  
KB(:,41,10) = (/ &
 & 0.19681E+00_JPRB,0.22601E+00_JPRB,0.26383E+00_JPRB,0.31041E+00_JPRB,0.36443E+00_JPRB /)  
KB(:,42,10) = (/ &
 & 0.16794E+00_JPRB,0.19457E+00_JPRB,0.22757E+00_JPRB,0.26875E+00_JPRB,0.31708E+00_JPRB /)  
KB(:,43,10) = (/ &
 & 0.14222E+00_JPRB,0.16606E+00_JPRB,0.19480E+00_JPRB,0.23049E+00_JPRB,0.27422E+00_JPRB /)  
KB(:,44,10) = (/ &
 & 0.11907E+00_JPRB,0.14059E+00_JPRB,0.16567E+00_JPRB,0.19741E+00_JPRB,0.23557E+00_JPRB /)  
KB(:,45,10) = (/ &
 & 0.99508E-01_JPRB,0.11792E+00_JPRB,0.14029E+00_JPRB,0.16912E+00_JPRB,0.20294E+00_JPRB /)  
KB(:,46,10) = (/ &
 & 0.82787E-01_JPRB,0.98729E-01_JPRB,0.11783E+00_JPRB,0.14344E+00_JPRB,0.17433E+00_JPRB /)  
KB(:,47,10) = (/ &
 & 0.68205E-01_JPRB,0.81739E-01_JPRB,0.98558E-01_JPRB,0.12017E+00_JPRB,0.14798E+00_JPRB /)  
KB(:,48,10) = (/ &
 & 0.55907E-01_JPRB,0.67050E-01_JPRB,0.81465E-01_JPRB,0.10030E+00_JPRB,0.12506E+00_JPRB /)  
KB(:,49,10) = (/ &
 & 0.45682E-01_JPRB,0.54871E-01_JPRB,0.66950E-01_JPRB,0.83270E-01_JPRB,0.10500E+00_JPRB /)  
KB(:,50,10) = (/ &
 & 0.37515E-01_JPRB,0.45259E-01_JPRB,0.55584E-01_JPRB,0.69475E-01_JPRB,0.88432E-01_JPRB /)  
KB(:,51,10) = (/ &
 & 0.31052E-01_JPRB,0.37347E-01_JPRB,0.46136E-01_JPRB,0.58029E-01_JPRB,0.74379E-01_JPRB /)  
KB(:,52,10) = (/ &
 & 0.25697E-01_JPRB,0.30758E-01_JPRB,0.38027E-01_JPRB,0.48169E-01_JPRB,0.62340E-01_JPRB /)  
KB(:,53,10) = (/ &
 & 0.21053E-01_JPRB,0.25282E-01_JPRB,0.31221E-01_JPRB,0.39765E-01_JPRB,0.52061E-01_JPRB /)  
KB(:,54,10) = (/ &
 & 0.17506E-01_JPRB,0.21171E-01_JPRB,0.26181E-01_JPRB,0.33450E-01_JPRB,0.43837E-01_JPRB /)  
KB(:,55,10) = (/ &
 & 0.14733E-01_JPRB,0.17912E-01_JPRB,0.22352E-01_JPRB,0.28517E-01_JPRB,0.37310E-01_JPRB /)  
KB(:,56,10) = (/ &
 & 0.12382E-01_JPRB,0.15138E-01_JPRB,0.19031E-01_JPRB,0.24337E-01_JPRB,0.31780E-01_JPRB /)  
KB(:,57,10) = (/ &
 & 0.10363E-01_JPRB,0.12802E-01_JPRB,0.16188E-01_JPRB,0.20731E-01_JPRB,0.27252E-01_JPRB /)  
KB(:,58,10) = (/ &
 & 0.87632E-02_JPRB,0.10863E-01_JPRB,0.13823E-01_JPRB,0.17907E-01_JPRB,0.23570E-01_JPRB /)  
KB(:,59,10) = (/ &
 & 0.79477E-02_JPRB,0.99708E-02_JPRB,0.12797E-01_JPRB,0.16832E-01_JPRB,0.22384E-01_JPRB /)  
KB(:,13,11) = (/ &
 & 0.27028E+02_JPRB,0.27753E+02_JPRB,0.28483E+02_JPRB,0.29219E+02_JPRB,0.29909E+02_JPRB /)  
KB(:,14,11) = (/ &
 & 0.23419E+02_JPRB,0.24025E+02_JPRB,0.24638E+02_JPRB,0.25228E+02_JPRB,0.25789E+02_JPRB /)  
KB(:,15,11) = (/ &
 & 0.20150E+02_JPRB,0.20660E+02_JPRB,0.21151E+02_JPRB,0.21642E+02_JPRB,0.22118E+02_JPRB /)  
KB(:,16,11) = (/ &
 & 0.17107E+02_JPRB,0.17510E+02_JPRB,0.17925E+02_JPRB,0.18355E+02_JPRB,0.18823E+02_JPRB /)  
KB(:,17,11) = (/ &
 & 0.14361E+02_JPRB,0.14686E+02_JPRB,0.15035E+02_JPRB,0.15422E+02_JPRB,0.15903E+02_JPRB /)  
KB(:,18,11) = (/ &
 & 0.12138E+02_JPRB,0.12397E+02_JPRB,0.12696E+02_JPRB,0.13058E+02_JPRB,0.13553E+02_JPRB /)  
KB(:,19,11) = (/ &
 & 0.10135E+02_JPRB,0.10395E+02_JPRB,0.10708E+02_JPRB,0.11115E+02_JPRB,0.11638E+02_JPRB /)  
KB(:,20,11) = (/ &
 & 0.81786E+01_JPRB,0.84190E+01_JPRB,0.87492E+01_JPRB,0.92221E+01_JPRB,0.97673E+01_JPRB /)  
KB(:,21,11) = (/ &
 & 0.68203E+01_JPRB,0.70074E+01_JPRB,0.73249E+01_JPRB,0.77062E+01_JPRB,0.81227E+01_JPRB /)  
KB(:,22,11) = (/ &
 & 0.58880E+01_JPRB,0.61142E+01_JPRB,0.64089E+01_JPRB,0.67273E+01_JPRB,0.70540E+01_JPRB /)  
KB(:,23,11) = (/ &
 & 0.51482E+01_JPRB,0.53972E+01_JPRB,0.56613E+01_JPRB,0.59190E+01_JPRB,0.62039E+01_JPRB /)  
KB(:,24,11) = (/ &
 & 0.45460E+01_JPRB,0.47798E+01_JPRB,0.50055E+01_JPRB,0.52340E+01_JPRB,0.54793E+01_JPRB /)  
KB(:,25,11) = (/ &
 & 0.40038E+01_JPRB,0.42162E+01_JPRB,0.44356E+01_JPRB,0.46519E+01_JPRB,0.48861E+01_JPRB /)  
KB(:,26,11) = (/ &
 & 0.35330E+01_JPRB,0.37282E+01_JPRB,0.39261E+01_JPRB,0.41342E+01_JPRB,0.43614E+01_JPRB /)  
KB(:,27,11) = (/ &
 & 0.30918E+01_JPRB,0.32790E+01_JPRB,0.34783E+01_JPRB,0.36774E+01_JPRB,0.38933E+01_JPRB /)  
KB(:,28,11) = (/ &
 & 0.27019E+01_JPRB,0.28880E+01_JPRB,0.30842E+01_JPRB,0.32755E+01_JPRB,0.34826E+01_JPRB /)  
KB(:,29,11) = (/ &
 & 0.23567E+01_JPRB,0.25399E+01_JPRB,0.27237E+01_JPRB,0.29118E+01_JPRB,0.31184E+01_JPRB /)  
KB(:,30,11) = (/ &
 & 0.20673E+01_JPRB,0.22421E+01_JPRB,0.24146E+01_JPRB,0.26001E+01_JPRB,0.28136E+01_JPRB /)  
KB(:,31,11) = (/ &
 & 0.18233E+01_JPRB,0.19796E+01_JPRB,0.21491E+01_JPRB,0.23275E+01_JPRB,0.25391E+01_JPRB /)  
KB(:,32,11) = (/ &
 & 0.16164E+01_JPRB,0.17629E+01_JPRB,0.19137E+01_JPRB,0.20921E+01_JPRB,0.23020E+01_JPRB /)  
KB(:,33,11) = (/ &
 & 0.14325E+01_JPRB,0.15691E+01_JPRB,0.17171E+01_JPRB,0.18965E+01_JPRB,0.20991E+01_JPRB /)  
KB(:,34,11) = (/ &
 & 0.12711E+01_JPRB,0.14025E+01_JPRB,0.15514E+01_JPRB,0.17231E+01_JPRB,0.19204E+01_JPRB /)  
KB(:,35,11) = (/ &
 & 0.11251E+01_JPRB,0.12478E+01_JPRB,0.13948E+01_JPRB,0.15591E+01_JPRB,0.17428E+01_JPRB /)  
KB(:,36,11) = (/ &
 & 0.98734E+00_JPRB,0.11026E+01_JPRB,0.12425E+01_JPRB,0.13991E+01_JPRB,0.15730E+01_JPRB /)  
KB(:,37,11) = (/ &
 & 0.85152E+00_JPRB,0.96327E+00_JPRB,0.10911E+01_JPRB,0.12398E+01_JPRB,0.14045E+01_JPRB /)  
KB(:,38,11) = (/ &
 & 0.73399E+00_JPRB,0.83942E+00_JPRB,0.95984E+00_JPRB,0.10967E+01_JPRB,0.12526E+01_JPRB /)  
KB(:,39,11) = (/ &
 & 0.63468E+00_JPRB,0.73175E+00_JPRB,0.84488E+00_JPRB,0.97279E+00_JPRB,0.11163E+01_JPRB /)  
KB(:,40,11) = (/ &
 & 0.54166E+00_JPRB,0.63099E+00_JPRB,0.73459E+00_JPRB,0.85525E+00_JPRB,0.98986E+00_JPRB /)  
KB(:,41,11) = (/ &
 & 0.46341E+00_JPRB,0.54185E+00_JPRB,0.63786E+00_JPRB,0.75041E+00_JPRB,0.87557E+00_JPRB /)  
KB(:,42,11) = (/ &
 & 0.39710E+00_JPRB,0.46604E+00_JPRB,0.55335E+00_JPRB,0.65788E+00_JPRB,0.77518E+00_JPRB /)  
KB(:,43,11) = (/ &
 & 0.33809E+00_JPRB,0.39845E+00_JPRB,0.47656E+00_JPRB,0.56991E+00_JPRB,0.67763E+00_JPRB /)  
KB(:,44,11) = (/ &
 & 0.28738E+00_JPRB,0.33811E+00_JPRB,0.40783E+00_JPRB,0.49238E+00_JPRB,0.58805E+00_JPRB /)  
KB(:,45,11) = (/ &
 & 0.24372E+00_JPRB,0.28787E+00_JPRB,0.34858E+00_JPRB,0.42338E+00_JPRB,0.51131E+00_JPRB /)  
KB(:,46,11) = (/ &
 & 0.20655E+00_JPRB,0.24407E+00_JPRB,0.29751E+00_JPRB,0.36239E+00_JPRB,0.44206E+00_JPRB /)  
KB(:,47,11) = (/ &
 & 0.17359E+00_JPRB,0.20653E+00_JPRB,0.25158E+00_JPRB,0.30900E+00_JPRB,0.37888E+00_JPRB /)  
KB(:,48,11) = (/ &
 & 0.14508E+00_JPRB,0.17395E+00_JPRB,0.21335E+00_JPRB,0.26232E+00_JPRB,0.32328E+00_JPRB /)  
KB(:,49,11) = (/ &
 & 0.12016E+00_JPRB,0.14523E+00_JPRB,0.17928E+00_JPRB,0.22128E+00_JPRB,0.27412E+00_JPRB /)  
KB(:,50,11) = (/ &
 & 0.99920E-01_JPRB,0.12218E+00_JPRB,0.15097E+00_JPRB,0.18907E+00_JPRB,0.23575E+00_JPRB /)  
KB(:,51,11) = (/ &
 & 0.82909E-01_JPRB,0.10226E+00_JPRB,0.12737E+00_JPRB,0.16132E+00_JPRB,0.20378E+00_JPRB /)  
KB(:,52,11) = (/ &
 & 0.68577E-01_JPRB,0.85131E-01_JPRB,0.10673E+00_JPRB,0.13644E+00_JPRB,0.17453E+00_JPRB /)  
KB(:,53,11) = (/ &
 & 0.56302E-01_JPRB,0.70491E-01_JPRB,0.88684E-01_JPRB,0.11469E+00_JPRB,0.14786E+00_JPRB /)  
KB(:,54,11) = (/ &
 & 0.47171E-01_JPRB,0.59185E-01_JPRB,0.74877E-01_JPRB,0.97387E-01_JPRB,0.12762E+00_JPRB /)  
KB(:,55,11) = (/ &
 & 0.40028E-01_JPRB,0.50199E-01_JPRB,0.63960E-01_JPRB,0.83211E-01_JPRB,0.11104E+00_JPRB /)  
KB(:,56,11) = (/ &
 & 0.33854E-01_JPRB,0.42508E-01_JPRB,0.54649E-01_JPRB,0.71262E-01_JPRB,0.95596E-01_JPRB /)  
KB(:,57,11) = (/ &
 & 0.28590E-01_JPRB,0.36142E-01_JPRB,0.46409E-01_JPRB,0.61269E-01_JPRB,0.82012E-01_JPRB /)  
KB(:,58,11) = (/ &
 & 0.24352E-01_JPRB,0.30934E-01_JPRB,0.39697E-01_JPRB,0.52483E-01_JPRB,0.71167E-01_JPRB /)  
KB(:,59,11) = (/ &
 & 0.22598E-01_JPRB,0.29152E-01_JPRB,0.37468E-01_JPRB,0.48573E-01_JPRB,0.66434E-01_JPRB /)  
KB(:,13,12) = (/ &
 & 0.57172E+02_JPRB,0.59297E+02_JPRB,0.61400E+02_JPRB,0.63512E+02_JPRB,0.65627E+02_JPRB /)  
KB(:,14,12) = (/ &
 & 0.50361E+02_JPRB,0.52086E+02_JPRB,0.53828E+02_JPRB,0.55595E+02_JPRB,0.57346E+02_JPRB /)  
KB(:,15,12) = (/ &
 & 0.44078E+02_JPRB,0.45453E+02_JPRB,0.46902E+02_JPRB,0.48347E+02_JPRB,0.49789E+02_JPRB /)  
KB(:,16,12) = (/ &
 & 0.38395E+02_JPRB,0.39554E+02_JPRB,0.40754E+02_JPRB,0.41955E+02_JPRB,0.43150E+02_JPRB /)  
KB(:,17,12) = (/ &
 & 0.33363E+02_JPRB,0.34355E+02_JPRB,0.35352E+02_JPRB,0.36337E+02_JPRB,0.37312E+02_JPRB /)  
KB(:,18,12) = (/ &
 & 0.28599E+02_JPRB,0.29463E+02_JPRB,0.30307E+02_JPRB,0.31155E+02_JPRB,0.32043E+02_JPRB /)  
KB(:,19,12) = (/ &
 & 0.24284E+02_JPRB,0.24982E+02_JPRB,0.25685E+02_JPRB,0.26424E+02_JPRB,0.27289E+02_JPRB /)  
KB(:,20,12) = (/ &
 & 0.20576E+02_JPRB,0.21117E+02_JPRB,0.21693E+02_JPRB,0.22370E+02_JPRB,0.23304E+02_JPRB /)  
KB(:,21,12) = (/ &
 & 0.17126E+02_JPRB,0.17629E+02_JPRB,0.18193E+02_JPRB,0.18968E+02_JPRB,0.20012E+02_JPRB /)  
KB(:,22,12) = (/ &
 & 0.14084E+02_JPRB,0.14526E+02_JPRB,0.15112E+02_JPRB,0.15986E+02_JPRB,0.17086E+02_JPRB /)  
KB(:,23,12) = (/ &
 & 0.11727E+02_JPRB,0.12073E+02_JPRB,0.12663E+02_JPRB,0.13546E+02_JPRB,0.14594E+02_JPRB /)  
KB(:,24,12) = (/ &
 & 0.10116E+02_JPRB,0.10483E+02_JPRB,0.11087E+02_JPRB,0.11839E+02_JPRB,0.12630E+02_JPRB /)  
KB(:,25,12) = (/ &
 & 0.89362E+01_JPRB,0.93748E+01_JPRB,0.99578E+01_JPRB,0.10576E+02_JPRB,0.11263E+02_JPRB /)  
KB(:,26,12) = (/ &
 & 0.79574E+01_JPRB,0.84325E+01_JPRB,0.89960E+01_JPRB,0.95862E+01_JPRB,0.10135E+02_JPRB /)  
KB(:,27,12) = (/ &
 & 0.71290E+01_JPRB,0.76343E+01_JPRB,0.81343E+01_JPRB,0.86609E+01_JPRB,0.91441E+01_JPRB /)  
KB(:,28,12) = (/ &
 & 0.64441E+01_JPRB,0.69081E+01_JPRB,0.73340E+01_JPRB,0.77892E+01_JPRB,0.82579E+01_JPRB /)  
KB(:,29,12) = (/ &
 & 0.57859E+01_JPRB,0.61904E+01_JPRB,0.65762E+01_JPRB,0.69937E+01_JPRB,0.74255E+01_JPRB /)  
KB(:,30,12) = (/ &
 & 0.51602E+01_JPRB,0.55338E+01_JPRB,0.58953E+01_JPRB,0.62766E+01_JPRB,0.66823E+01_JPRB /)  
KB(:,31,12) = (/ &
 & 0.45943E+01_JPRB,0.49270E+01_JPRB,0.52739E+01_JPRB,0.56298E+01_JPRB,0.60118E+01_JPRB /)  
KB(:,32,12) = (/ &
 & 0.40881E+01_JPRB,0.44095E+01_JPRB,0.47450E+01_JPRB,0.50839E+01_JPRB,0.54488E+01_JPRB /)  
KB(:,33,12) = (/ &
 & 0.36534E+01_JPRB,0.39549E+01_JPRB,0.42670E+01_JPRB,0.46043E+01_JPRB,0.49743E+01_JPRB /)  
KB(:,34,12) = (/ &
 & 0.32874E+01_JPRB,0.35667E+01_JPRB,0.38571E+01_JPRB,0.41872E+01_JPRB,0.45862E+01_JPRB /)  
KB(:,35,12) = (/ &
 & 0.29379E+01_JPRB,0.31963E+01_JPRB,0.34845E+01_JPRB,0.38151E+01_JPRB,0.42290E+01_JPRB /)  
KB(:,36,12) = (/ &
 & 0.26101E+01_JPRB,0.28628E+01_JPRB,0.31405E+01_JPRB,0.34760E+01_JPRB,0.38927E+01_JPRB /)  
KB(:,37,12) = (/ &
 & 0.23047E+01_JPRB,0.25368E+01_JPRB,0.28124E+01_JPRB,0.31292E+01_JPRB,0.35310E+01_JPRB /)  
KB(:,38,12) = (/ &
 & 0.20413E+01_JPRB,0.22603E+01_JPRB,0.25129E+01_JPRB,0.28252E+01_JPRB,0.32149E+01_JPRB /)  
KB(:,39,12) = (/ &
 & 0.18040E+01_JPRB,0.20133E+01_JPRB,0.22565E+01_JPRB,0.25571E+01_JPRB,0.29423E+01_JPRB /)  
KB(:,40,12) = (/ &
 & 0.15898E+01_JPRB,0.17862E+01_JPRB,0.20189E+01_JPRB,0.22992E+01_JPRB,0.26576E+01_JPRB /)  
KB(:,41,12) = (/ &
 & 0.14002E+01_JPRB,0.15861E+01_JPRB,0.18008E+01_JPRB,0.20620E+01_JPRB,0.24028E+01_JPRB /)  
KB(:,42,12) = (/ &
 & 0.12302E+01_JPRB,0.14049E+01_JPRB,0.16015E+01_JPRB,0.18444E+01_JPRB,0.21658E+01_JPRB /)  
KB(:,43,12) = (/ &
 & 0.10668E+01_JPRB,0.12258E+01_JPRB,0.14101E+01_JPRB,0.16347E+01_JPRB,0.19297E+01_JPRB /)  
KB(:,44,12) = (/ &
 & 0.91800E+00_JPRB,0.10642E+01_JPRB,0.12324E+01_JPRB,0.14347E+01_JPRB,0.17074E+01_JPRB /)  
KB(:,45,12) = (/ &
 & 0.78687E+00_JPRB,0.91967E+00_JPRB,0.10737E+01_JPRB,0.12598E+01_JPRB,0.15049E+01_JPRB /)  
KB(:,46,12) = (/ &
 & 0.67148E+00_JPRB,0.79041E+00_JPRB,0.92761E+00_JPRB,0.10973E+01_JPRB,0.13177E+01_JPRB /)  
KB(:,47,12) = (/ &
 & 0.57045E+00_JPRB,0.67640E+00_JPRB,0.80034E+00_JPRB,0.94779E+00_JPRB,0.11432E+01_JPRB /)  
KB(:,48,12) = (/ &
 & 0.48142E+00_JPRB,0.57646E+00_JPRB,0.68676E+00_JPRB,0.82116E+00_JPRB,0.98898E+00_JPRB /)  
KB(:,49,12) = (/ &
 & 0.40194E+00_JPRB,0.48757E+00_JPRB,0.58498E+00_JPRB,0.70838E+00_JPRB,0.85881E+00_JPRB /)  
KB(:,50,12) = (/ &
 & 0.34095E+00_JPRB,0.41499E+00_JPRB,0.50425E+00_JPRB,0.61464E+00_JPRB,0.75451E+00_JPRB /)  
KB(:,51,12) = (/ &
 & 0.29038E+00_JPRB,0.35608E+00_JPRB,0.43553E+00_JPRB,0.53422E+00_JPRB,0.66315E+00_JPRB /)  
KB(:,52,12) = (/ &
 & 0.24615E+00_JPRB,0.30360E+00_JPRB,0.37359E+00_JPRB,0.46378E+00_JPRB,0.57808E+00_JPRB /)  
KB(:,53,12) = (/ &
 & 0.20660E+00_JPRB,0.25764E+00_JPRB,0.31993E+00_JPRB,0.39869E+00_JPRB,0.50232E+00_JPRB /)  
KB(:,54,12) = (/ &
 & 0.17518E+00_JPRB,0.22280E+00_JPRB,0.27852E+00_JPRB,0.34881E+00_JPRB,0.44243E+00_JPRB /)  
KB(:,55,12) = (/ &
 & 0.14906E+00_JPRB,0.19392E+00_JPRB,0.24538E+00_JPRB,0.31045E+00_JPRB,0.39204E+00_JPRB /)  
KB(:,56,12) = (/ &
 & 0.12564E+00_JPRB,0.16748E+00_JPRB,0.21535E+00_JPRB,0.27386E+00_JPRB,0.34816E+00_JPRB /)  
KB(:,57,12) = (/ &
 & 0.10489E+00_JPRB,0.14334E+00_JPRB,0.18902E+00_JPRB,0.24147E+00_JPRB,0.30976E+00_JPRB /)  
KB(:,58,12) = (/ &
 & 0.88415E-01_JPRB,0.12250E+00_JPRB,0.16566E+00_JPRB,0.21499E+00_JPRB,0.27515E+00_JPRB /)  
KB(:,59,12) = (/ &
 & 0.80710E-01_JPRB,0.11375E+00_JPRB,0.15629E+00_JPRB,0.20737E+00_JPRB,0.26838E+00_JPRB /)  
KB(:,13,13) = (/ &
 & 0.16465E+03_JPRB,0.16298E+03_JPRB,0.16413E+03_JPRB,0.16796E+03_JPRB,0.17425E+03_JPRB /)  
KB(:,14,13) = (/ &
 & 0.14134E+03_JPRB,0.14223E+03_JPRB,0.14584E+03_JPRB,0.15183E+03_JPRB,0.15823E+03_JPRB /)  
KB(:,15,13) = (/ &
 & 0.12334E+03_JPRB,0.12642E+03_JPRB,0.13170E+03_JPRB,0.13719E+03_JPRB,0.14248E+03_JPRB /)  
KB(:,16,13) = (/ &
 & 0.10903E+03_JPRB,0.11350E+03_JPRB,0.11825E+03_JPRB,0.12284E+03_JPRB,0.12720E+03_JPRB /)  
KB(:,17,13) = (/ &
 & 0.96744E+02_JPRB,0.10077E+03_JPRB,0.10473E+03_JPRB,0.10856E+03_JPRB,0.11225E+03_JPRB /)  
KB(:,18,13) = (/ &
 & 0.85368E+02_JPRB,0.88669E+02_JPRB,0.91934E+02_JPRB,0.95127E+02_JPRB,0.98216E+02_JPRB /)  
KB(:,19,13) = (/ &
 & 0.74865E+02_JPRB,0.77560E+02_JPRB,0.80263E+02_JPRB,0.82912E+02_JPRB,0.85499E+02_JPRB /)  
KB(:,20,13) = (/ &
 & 0.65304E+02_JPRB,0.67588E+02_JPRB,0.69849E+02_JPRB,0.72099E+02_JPRB,0.74316E+02_JPRB /)  
KB(:,21,13) = (/ &
 & 0.56704E+02_JPRB,0.58616E+02_JPRB,0.60541E+02_JPRB,0.62457E+02_JPRB,0.64444E+02_JPRB /)  
KB(:,22,13) = (/ &
 & 0.49099E+02_JPRB,0.50788E+02_JPRB,0.52451E+02_JPRB,0.54119E+02_JPRB,0.55970E+02_JPRB /)  
KB(:,23,13) = (/ &
 & 0.42076E+02_JPRB,0.43646E+02_JPRB,0.45230E+02_JPRB,0.46888E+02_JPRB,0.48798E+02_JPRB /)  
KB(:,24,13) = (/ &
 & 0.35457E+02_JPRB,0.36904E+02_JPRB,0.38447E+02_JPRB,0.40262E+02_JPRB,0.42565E+02_JPRB /)  
KB(:,25,13) = (/ &
 & 0.29832E+02_JPRB,0.31036E+02_JPRB,0.32508E+02_JPRB,0.34502E+02_JPRB,0.36979E+02_JPRB /)  
KB(:,26,13) = (/ &
 & 0.25205E+02_JPRB,0.26348E+02_JPRB,0.27792E+02_JPRB,0.29788E+02_JPRB,0.32459E+02_JPRB /)  
KB(:,27,13) = (/ &
 & 0.21486E+02_JPRB,0.22586E+02_JPRB,0.24162E+02_JPRB,0.26260E+02_JPRB,0.28944E+02_JPRB /)  
KB(:,28,13) = (/ &
 & 0.18712E+02_JPRB,0.19693E+02_JPRB,0.21370E+02_JPRB,0.23591E+02_JPRB,0.26158E+02_JPRB /)  
KB(:,29,13) = (/ &
 & 0.16630E+02_JPRB,0.17716E+02_JPRB,0.19369E+02_JPRB,0.21565E+02_JPRB,0.24102E+02_JPRB /)  
KB(:,30,13) = (/ &
 & 0.14923E+02_JPRB,0.16119E+02_JPRB,0.17783E+02_JPRB,0.19989E+02_JPRB,0.22379E+02_JPRB /)  
KB(:,31,13) = (/ &
 & 0.13532E+02_JPRB,0.14853E+02_JPRB,0.16576E+02_JPRB,0.18745E+02_JPRB,0.21084E+02_JPRB /)  
KB(:,32,13) = (/ &
 & 0.12453E+02_JPRB,0.13784E+02_JPRB,0.15587E+02_JPRB,0.17718E+02_JPRB,0.20022E+02_JPRB /)  
KB(:,33,13) = (/ &
 & 0.11580E+02_JPRB,0.13038E+02_JPRB,0.14851E+02_JPRB,0.16892E+02_JPRB,0.19192E+02_JPRB /)  
KB(:,34,13) = (/ &
 & 0.10820E+02_JPRB,0.12376E+02_JPRB,0.14134E+02_JPRB,0.16152E+02_JPRB,0.18402E+02_JPRB /)  
KB(:,35,13) = (/ &
 & 0.10116E+02_JPRB,0.11686E+02_JPRB,0.13402E+02_JPRB,0.15346E+02_JPRB,0.17556E+02_JPRB /)  
KB(:,36,13) = (/ &
 & 0.93933E+01_JPRB,0.10910E+02_JPRB,0.12572E+02_JPRB,0.14432E+02_JPRB,0.16536E+02_JPRB /)  
KB(:,37,13) = (/ &
 & 0.85160E+01_JPRB,0.99755E+01_JPRB,0.11554E+02_JPRB,0.13358E+02_JPRB,0.15350E+02_JPRB /)  
KB(:,38,13) = (/ &
 & 0.77505E+01_JPRB,0.91225E+01_JPRB,0.10670E+02_JPRB,0.12380E+02_JPRB,0.14273E+02_JPRB /)  
KB(:,39,13) = (/ &
 & 0.70897E+01_JPRB,0.83885E+01_JPRB,0.98694E+01_JPRB,0.11502E+02_JPRB,0.13343E+02_JPRB /)  
KB(:,40,13) = (/ &
 & 0.63295E+01_JPRB,0.75506E+01_JPRB,0.89466E+01_JPRB,0.10495E+02_JPRB,0.12287E+02_JPRB /)  
KB(:,41,13) = (/ &
 & 0.56302E+01_JPRB,0.67988E+01_JPRB,0.80957E+01_JPRB,0.96013E+01_JPRB,0.11280E+02_JPRB /)  
KB(:,42,13) = (/ &
 & 0.50234E+01_JPRB,0.61071E+01_JPRB,0.73389E+01_JPRB,0.87816E+01_JPRB,0.10380E+02_JPRB /)  
KB(:,43,13) = (/ &
 & 0.44225E+01_JPRB,0.54282E+01_JPRB,0.65963E+01_JPRB,0.79433E+01_JPRB,0.94666E+01_JPRB /)  
KB(:,44,13) = (/ &
 & 0.38558E+01_JPRB,0.47912E+01_JPRB,0.58905E+01_JPRB,0.71478E+01_JPRB,0.86145E+01_JPRB /)  
KB(:,45,13) = (/ &
 & 0.33575E+01_JPRB,0.42351E+01_JPRB,0.52475E+01_JPRB,0.64292E+01_JPRB,0.78296E+01_JPRB /)  
KB(:,46,13) = (/ &
 & 0.29053E+01_JPRB,0.37074E+01_JPRB,0.46432E+01_JPRB,0.57484E+01_JPRB,0.70674E+01_JPRB /)  
KB(:,47,13) = (/ &
 & 0.24706E+01_JPRB,0.31851E+01_JPRB,0.40524E+01_JPRB,0.50837E+01_JPRB,0.62990E+01_JPRB /)  
KB(:,48,13) = (/ &
 & 0.20907E+01_JPRB,0.27320E+01_JPRB,0.35232E+01_JPRB,0.44689E+01_JPRB,0.55998E+01_JPRB /)  
KB(:,49,13) = (/ &
 & 0.17652E+01_JPRB,0.23397E+01_JPRB,0.30525E+01_JPRB,0.39130E+01_JPRB,0.49641E+01_JPRB /)  
KB(:,50,13) = (/ &
 & 0.14980E+01_JPRB,0.19995E+01_JPRB,0.26386E+01_JPRB,0.34309E+01_JPRB,0.43930E+01_JPRB /)  
KB(:,51,13) = (/ &
 & 0.12883E+01_JPRB,0.17229E+01_JPRB,0.22808E+01_JPRB,0.30058E+01_JPRB,0.38921E+01_JPRB /)  
KB(:,52,13) = (/ &
 & 0.11032E+01_JPRB,0.14878E+01_JPRB,0.19945E+01_JPRB,0.26225E+01_JPRB,0.34327E+01_JPRB /)  
KB(:,53,13) = (/ &
 & 0.94256E+00_JPRB,0.12803E+01_JPRB,0.17436E+01_JPRB,0.23095E+01_JPRB,0.30258E+01_JPRB /)  
KB(:,54,13) = (/ &
 & 0.80847E+00_JPRB,0.11045E+01_JPRB,0.15250E+01_JPRB,0.20573E+01_JPRB,0.27048E+01_JPRB /)  
KB(:,55,13) = (/ &
 & 0.69972E+00_JPRB,0.95008E+00_JPRB,0.13215E+01_JPRB,0.18178E+01_JPRB,0.24326E+01_JPRB /)  
KB(:,56,13) = (/ &
 & 0.60659E+00_JPRB,0.81298E+00_JPRB,0.11430E+01_JPRB,0.15925E+01_JPRB,0.21783E+01_JPRB /)  
KB(:,57,13) = (/ &
 & 0.52664E+00_JPRB,0.69670E+00_JPRB,0.97998E+00_JPRB,0.13891E+01_JPRB,0.19333E+01_JPRB /)  
KB(:,58,13) = (/ &
 & 0.45985E+00_JPRB,0.60682E+00_JPRB,0.84337E+00_JPRB,0.12113E+01_JPRB,0.17188E+01_JPRB /)  
KB(:,59,13) = (/ &
 & 0.43853E+00_JPRB,0.57879E+00_JPRB,0.79018E+00_JPRB,0.11130E+01_JPRB,0.16039E+01_JPRB /)  
KB(:,13,14) = (/ &
 & 0.86016E+03_JPRB,0.84626E+03_JPRB,0.83228E+03_JPRB,0.81817E+03_JPRB,0.80450E+03_JPRB /)  
KB(:,14,14) = (/ &
 & 0.75981E+03_JPRB,0.74663E+03_JPRB,0.73345E+03_JPRB,0.72104E+03_JPRB,0.71224E+03_JPRB /)  
KB(:,15,14) = (/ &
 & 0.66201E+03_JPRB,0.64993E+03_JPRB,0.63891E+03_JPRB,0.63210E+03_JPRB,0.62978E+03_JPRB /)  
KB(:,16,14) = (/ &
 & 0.57014E+03_JPRB,0.56027E+03_JPRB,0.55466E+03_JPRB,0.55378E+03_JPRB,0.55721E+03_JPRB /)  
KB(:,17,14) = (/ &
 & 0.48861E+03_JPRB,0.48354E+03_JPRB,0.48324E+03_JPRB,0.48760E+03_JPRB,0.49602E+03_JPRB /)  
KB(:,18,14) = (/ &
 & 0.41987E+03_JPRB,0.41964E+03_JPRB,0.42411E+03_JPRB,0.43291E+03_JPRB,0.44575E+03_JPRB /)  
KB(:,19,14) = (/ &
 & 0.36303E+03_JPRB,0.36702E+03_JPRB,0.37556E+03_JPRB,0.38834E+03_JPRB,0.40471E+03_JPRB /)  
KB(:,20,14) = (/ &
 & 0.31651E+03_JPRB,0.32421E+03_JPRB,0.33627E+03_JPRB,0.35219E+03_JPRB,0.37072E+03_JPRB /)  
KB(:,21,14) = (/ &
 & 0.27867E+03_JPRB,0.28947E+03_JPRB,0.30434E+03_JPRB,0.32131E+03_JPRB,0.33823E+03_JPRB /)  
KB(:,22,14) = (/ &
 & 0.24916E+03_JPRB,0.26251E+03_JPRB,0.27768E+03_JPRB,0.29296E+03_JPRB,0.30844E+03_JPRB /)  
KB(:,23,14) = (/ &
 & 0.22571E+03_JPRB,0.23932E+03_JPRB,0.25291E+03_JPRB,0.26670E+03_JPRB,0.28069E+03_JPRB /)  
KB(:,24,14) = (/ &
 & 0.20503E+03_JPRB,0.21765E+03_JPRB,0.23029E+03_JPRB,0.24291E+03_JPRB,0.25575E+03_JPRB /)  
KB(:,25,14) = (/ &
 & 0.18574E+03_JPRB,0.19763E+03_JPRB,0.20960E+03_JPRB,0.22151E+03_JPRB,0.23356E+03_JPRB /)  
KB(:,26,14) = (/ &
 & 0.16825E+03_JPRB,0.17945E+03_JPRB,0.19085E+03_JPRB,0.20242E+03_JPRB,0.21406E+03_JPRB /)  
KB(:,27,14) = (/ &
 & 0.15254E+03_JPRB,0.16311E+03_JPRB,0.17402E+03_JPRB,0.18521E+03_JPRB,0.19696E+03_JPRB /)  
KB(:,28,14) = (/ &
 & 0.13815E+03_JPRB,0.14857E+03_JPRB,0.15913E+03_JPRB,0.17022E+03_JPRB,0.18238E+03_JPRB /)  
KB(:,29,14) = (/ &
 & 0.12560E+03_JPRB,0.13571E+03_JPRB,0.14630E+03_JPRB,0.15763E+03_JPRB,0.17019E+03_JPRB /)  
KB(:,30,14) = (/ &
 & 0.11497E+03_JPRB,0.12476E+03_JPRB,0.13550E+03_JPRB,0.14719E+03_JPRB,0.16044E+03_JPRB /)  
KB(:,31,14) = (/ &
 & 0.10602E+03_JPRB,0.11577E+03_JPRB,0.12671E+03_JPRB,0.13889E+03_JPRB,0.15289E+03_JPRB /)  
KB(:,32,14) = (/ &
 & 0.98519E+02_JPRB,0.10855E+03_JPRB,0.11978E+03_JPRB,0.13265E+03_JPRB,0.14744E+03_JPRB /)  
KB(:,33,14) = (/ &
 & 0.92517E+02_JPRB,0.10274E+03_JPRB,0.11452E+03_JPRB,0.12822E+03_JPRB,0.14389E+03_JPRB /)  
KB(:,34,14) = (/ &
 & 0.87441E+02_JPRB,0.97936E+02_JPRB,0.11044E+03_JPRB,0.12495E+03_JPRB,0.14148E+03_JPRB /)  
KB(:,35,14) = (/ &
 & 0.82499E+02_JPRB,0.93333E+02_JPRB,0.10635E+03_JPRB,0.12151E+03_JPRB,0.13874E+03_JPRB /)  
KB(:,36,14) = (/ &
 & 0.77442E+02_JPRB,0.88493E+02_JPRB,0.10184E+03_JPRB,0.11740E+03_JPRB,0.13513E+03_JPRB /)  
KB(:,37,14) = (/ &
 & 0.71771E+02_JPRB,0.82731E+02_JPRB,0.96032E+02_JPRB,0.11158E+03_JPRB,0.12941E+03_JPRB /)  
KB(:,38,14) = (/ &
 & 0.66727E+02_JPRB,0.77610E+02_JPRB,0.90795E+02_JPRB,0.10632E+03_JPRB,0.12415E+03_JPRB /)  
KB(:,39,14) = (/ &
 & 0.62339E+02_JPRB,0.73113E+02_JPRB,0.86200E+02_JPRB,0.10167E+03_JPRB,0.11942E+03_JPRB /)  
KB(:,40,14) = (/ &
 & 0.57601E+02_JPRB,0.67999E+02_JPRB,0.80724E+02_JPRB,0.95858E+02_JPRB,0.11323E+03_JPRB /)  
KB(:,41,14) = (/ &
 & 0.53285E+02_JPRB,0.63203E+02_JPRB,0.75577E+02_JPRB,0.90242E+02_JPRB,0.10726E+03_JPRB /)  
KB(:,42,14) = (/ &
 & 0.49392E+02_JPRB,0.58908E+02_JPRB,0.70834E+02_JPRB,0.85045E+02_JPRB,0.10163E+03_JPRB /)  
KB(:,43,14) = (/ &
 & 0.45446E+02_JPRB,0.54452E+02_JPRB,0.65751E+02_JPRB,0.79402E+02_JPRB,0.95397E+02_JPRB /)  
KB(:,44,14) = (/ &
 & 0.41620E+02_JPRB,0.50184E+02_JPRB,0.60777E+02_JPRB,0.73786E+02_JPRB,0.89076E+02_JPRB /)  
KB(:,45,14) = (/ &
 & 0.38059E+02_JPRB,0.46282E+02_JPRB,0.56226E+02_JPRB,0.68539E+02_JPRB,0.83136E+02_JPRB /)  
KB(:,46,14) = (/ &
 & 0.34554E+02_JPRB,0.42501E+02_JPRB,0.51829E+02_JPRB,0.63383E+02_JPRB,0.77220E+02_JPRB /)  
KB(:,47,14) = (/ &
 & 0.31009E+02_JPRB,0.38610E+02_JPRB,0.47385E+02_JPRB,0.58058E+02_JPRB,0.71080E+02_JPRB /)  
KB(:,48,14) = (/ &
 & 0.27715E+02_JPRB,0.34934E+02_JPRB,0.43319E+02_JPRB,0.53190E+02_JPRB,0.65347E+02_JPRB /)  
KB(:,49,14) = (/ &
 & 0.24658E+02_JPRB,0.31478E+02_JPRB,0.39500E+02_JPRB,0.48743E+02_JPRB,0.59997E+02_JPRB /)  
KB(:,50,14) = (/ &
 & 0.22034E+02_JPRB,0.28437E+02_JPRB,0.36093E+02_JPRB,0.44894E+02_JPRB,0.55346E+02_JPRB /)  
KB(:,51,14) = (/ &
 & 0.19684E+02_JPRB,0.25626E+02_JPRB,0.32937E+02_JPRB,0.41385E+02_JPRB,0.51154E+02_JPRB /)  
KB(:,52,14) = (/ &
 & 0.17504E+02_JPRB,0.22995E+02_JPRB,0.29925E+02_JPRB,0.38057E+02_JPRB,0.47307E+02_JPRB /)  
KB(:,53,14) = (/ &
 & 0.15552E+02_JPRB,0.20544E+02_JPRB,0.27079E+02_JPRB,0.34832E+02_JPRB,0.43722E+02_JPRB /)  
KB(:,54,14) = (/ &
 & 0.13886E+02_JPRB,0.18476E+02_JPRB,0.24607E+02_JPRB,0.31966E+02_JPRB,0.40540E+02_JPRB /)  
KB(:,55,14) = (/ &
 & 0.12396E+02_JPRB,0.16681E+02_JPRB,0.22385E+02_JPRB,0.29384E+02_JPRB,0.37592E+02_JPRB /)  
KB(:,56,14) = (/ &
 & 0.11028E+02_JPRB,0.15006E+02_JPRB,0.20297E+02_JPRB,0.26955E+02_JPRB,0.34780E+02_JPRB /)  
KB(:,57,14) = (/ &
 & 0.97493E+01_JPRB,0.13452E+02_JPRB,0.18354E+02_JPRB,0.24644E+02_JPRB,0.32099E+02_JPRB /)  
KB(:,58,14) = (/ &
 & 0.86411E+01_JPRB,0.12068E+02_JPRB,0.16627E+02_JPRB,0.22569E+02_JPRB,0.29684E+02_JPRB /)  
KB(:,59,14) = (/ &
 & 0.80894E+01_JPRB,0.11449E+02_JPRB,0.15905E+02_JPRB,0.21753E+02_JPRB,0.28728E+02_JPRB /)  
KB(:,13,15) = (/ &
 & 0.50046E+04_JPRB,0.50034E+04_JPRB,0.49950E+04_JPRB,0.49781E+04_JPRB,0.49542E+04_JPRB /)  
KB(:,14,15) = (/ &
 & 0.51812E+04_JPRB,0.51738E+04_JPRB,0.51582E+04_JPRB,0.51357E+04_JPRB,0.51054E+04_JPRB /)  
KB(:,15,15) = (/ &
 & 0.52793E+04_JPRB,0.52645E+04_JPRB,0.52450E+04_JPRB,0.52172E+04_JPRB,0.51836E+04_JPRB /)  
KB(:,16,15) = (/ &
 & 0.53001E+04_JPRB,0.52818E+04_JPRB,0.52568E+04_JPRB,0.52274E+04_JPRB,0.51924E+04_JPRB /)  
KB(:,17,15) = (/ &
 & 0.52448E+04_JPRB,0.52242E+04_JPRB,0.52004E+04_JPRB,0.51715E+04_JPRB,0.51377E+04_JPRB /)  
KB(:,18,15) = (/ &
 & 0.51200E+04_JPRB,0.51031E+04_JPRB,0.50817E+04_JPRB,0.50571E+04_JPRB,0.50308E+04_JPRB /)  
KB(:,19,15) = (/ &
 & 0.49389E+04_JPRB,0.49284E+04_JPRB,0.49153E+04_JPRB,0.49007E+04_JPRB,0.48819E+04_JPRB /)  
KB(:,20,15) = (/ &
 & 0.47181E+04_JPRB,0.47168E+04_JPRB,0.47163E+04_JPRB,0.47129E+04_JPRB,0.47111E+04_JPRB /)  
KB(:,21,15) = (/ &
 & 0.44718E+04_JPRB,0.44865E+04_JPRB,0.44990E+04_JPRB,0.45153E+04_JPRB,0.45403E+04_JPRB /)  
KB(:,22,15) = (/ &
 & 0.42192E+04_JPRB,0.42497E+04_JPRB,0.42861E+04_JPRB,0.43316E+04_JPRB,0.43809E+04_JPRB /)  
KB(:,23,15) = (/ &
 & 0.39727E+04_JPRB,0.40275E+04_JPRB,0.40936E+04_JPRB,0.41646E+04_JPRB,0.42404E+04_JPRB /)  
KB(:,24,15) = (/ &
 & 0.37507E+04_JPRB,0.38336E+04_JPRB,0.39239E+04_JPRB,0.40206E+04_JPRB,0.41209E+04_JPRB /)  
KB(:,25,15) = (/ &
 & 0.35606E+04_JPRB,0.36694E+04_JPRB,0.37826E+04_JPRB,0.39026E+04_JPRB,0.40244E+04_JPRB /)  
KB(:,26,15) = (/ &
 & 0.34043E+04_JPRB,0.35364E+04_JPRB,0.36731E+04_JPRB,0.38130E+04_JPRB,0.39519E+04_JPRB /)  
KB(:,27,15) = (/ &
 & 0.32803E+04_JPRB,0.34346E+04_JPRB,0.35912E+04_JPRB,0.37476E+04_JPRB,0.39014E+04_JPRB /)  
KB(:,28,15) = (/ &
 & 0.31876E+04_JPRB,0.33610E+04_JPRB,0.35344E+04_JPRB,0.37042E+04_JPRB,0.38699E+04_JPRB /)  
KB(:,29,15) = (/ &
 & 0.31239E+04_JPRB,0.33137E+04_JPRB,0.34995E+04_JPRB,0.36813E+04_JPRB,0.38573E+04_JPRB /)  
KB(:,30,15) = (/ &
 & 0.30850E+04_JPRB,0.32872E+04_JPRB,0.34837E+04_JPRB,0.36745E+04_JPRB,0.38591E+04_JPRB /)  
KB(:,31,15) = (/ &
 & 0.30674E+04_JPRB,0.32795E+04_JPRB,0.34848E+04_JPRB,0.36826E+04_JPRB,0.38724E+04_JPRB /)  
KB(:,32,15) = (/ &
 & 0.30683E+04_JPRB,0.32879E+04_JPRB,0.34990E+04_JPRB,0.37022E+04_JPRB,0.38953E+04_JPRB /)  
KB(:,33,15) = (/ &
 & 0.30831E+04_JPRB,0.33087E+04_JPRB,0.35243E+04_JPRB,0.37303E+04_JPRB,0.39250E+04_JPRB /)  
KB(:,34,15) = (/ &
 & 0.31017E+04_JPRB,0.33308E+04_JPRB,0.35496E+04_JPRB,0.37580E+04_JPRB,0.39527E+04_JPRB /)  
KB(:,35,15) = (/ &
 & 0.31057E+04_JPRB,0.33387E+04_JPRB,0.35601E+04_JPRB,0.37700E+04_JPRB,0.39654E+04_JPRB /)  
KB(:,36,15) = (/ &
 & 0.30895E+04_JPRB,0.33260E+04_JPRB,0.35504E+04_JPRB,0.37630E+04_JPRB,0.39606E+04_JPRB /)  
KB(:,37,15) = (/ &
 & 0.30400E+04_JPRB,0.32811E+04_JPRB,0.35096E+04_JPRB,0.37263E+04_JPRB,0.39277E+04_JPRB /)  
KB(:,38,15) = (/ &
 & 0.29913E+04_JPRB,0.32361E+04_JPRB,0.34690E+04_JPRB,0.36890E+04_JPRB,0.38942E+04_JPRB /)  
KB(:,39,15) = (/ &
 & 0.29441E+04_JPRB,0.31926E+04_JPRB,0.34294E+04_JPRB,0.36526E+04_JPRB,0.38612E+04_JPRB /)  
KB(:,40,15) = (/ &
 & 0.28722E+04_JPRB,0.31254E+04_JPRB,0.33667E+04_JPRB,0.35943E+04_JPRB,0.38073E+04_JPRB /)  
KB(:,41,15) = (/ &
 & 0.27971E+04_JPRB,0.30548E+04_JPRB,0.33004E+04_JPRB,0.35326E+04_JPRB,0.37505E+04_JPRB /)  
KB(:,42,15) = (/ &
 & 0.27226E+04_JPRB,0.29837E+04_JPRB,0.32336E+04_JPRB,0.34701E+04_JPRB,0.36925E+04_JPRB /)  
KB(:,43,15) = (/ &
 & 0.26332E+04_JPRB,0.28981E+04_JPRB,0.31525E+04_JPRB,0.33944E+04_JPRB,0.36223E+04_JPRB /)  
KB(:,44,15) = (/ &
 & 0.25372E+04_JPRB,0.28050E+04_JPRB,0.30643E+04_JPRB,0.33114E+04_JPRB,0.35441E+04_JPRB /)  
KB(:,45,15) = (/ &
 & 0.24417E+04_JPRB,0.27113E+04_JPRB,0.29748E+04_JPRB,0.32268E+04_JPRB,0.34651E+04_JPRB /)  
KB(:,46,15) = (/ &
 & 0.23395E+04_JPRB,0.26115E+04_JPRB,0.28783E+04_JPRB,0.31351E+04_JPRB,0.33792E+04_JPRB /)  
KB(:,47,15) = (/ &
 & 0.22243E+04_JPRB,0.24998E+04_JPRB,0.27694E+04_JPRB,0.30313E+04_JPRB,0.32810E+04_JPRB /)  
KB(:,48,15) = (/ &
 & 0.21083E+04_JPRB,0.23877E+04_JPRB,0.26592E+04_JPRB,0.29257E+04_JPRB,0.31803E+04_JPRB /)  
KB(:,49,15) = (/ &
 & 0.19925E+04_JPRB,0.22741E+04_JPRB,0.25488E+04_JPRB,0.28180E+04_JPRB,0.30783E+04_JPRB /)  
KB(:,50,15) = (/ &
 & 0.18841E+04_JPRB,0.21666E+04_JPRB,0.24447E+04_JPRB,0.27159E+04_JPRB,0.29806E+04_JPRB /)  
KB(:,51,15) = (/ &
 & 0.17798E+04_JPRB,0.20618E+04_JPRB,0.23428E+04_JPRB,0.26160E+04_JPRB,0.28839E+04_JPRB /)  
KB(:,52,15) = (/ &
 & 0.16762E+04_JPRB,0.19574E+04_JPRB,0.22398E+04_JPRB,0.25156E+04_JPRB,0.27862E+04_JPRB /)  
KB(:,53,15) = (/ &
 & 0.15731E+04_JPRB,0.18530E+04_JPRB,0.21358E+04_JPRB,0.24152E+04_JPRB,0.26872E+04_JPRB /)  
KB(:,54,15) = (/ &
 & 0.14802E+04_JPRB,0.17581E+04_JPRB,0.20401E+04_JPRB,0.23219E+04_JPRB,0.25956E+04_JPRB /)  
KB(:,55,15) = (/ &
 & 0.13915E+04_JPRB,0.16675E+04_JPRB,0.19488E+04_JPRB,0.22318E+04_JPRB,0.25080E+04_JPRB /)  
KB(:,56,15) = (/ &
 & 0.13039E+04_JPRB,0.15778E+04_JPRB,0.18577E+04_JPRB,0.21406E+04_JPRB,0.24200E+04_JPRB /)  
KB(:,57,15) = (/ &
 & 0.12167E+04_JPRB,0.14890E+04_JPRB,0.17672E+04_JPRB,0.20493E+04_JPRB,0.23313E+04_JPRB /)  
KB(:,58,15) = (/ &
 & 0.11349E+04_JPRB,0.14057E+04_JPRB,0.16818E+04_JPRB,0.19631E+04_JPRB,0.22464E+04_JPRB /)  
KB(:,59,15) = (/ &
 & 0.11025E+04_JPRB,0.13721E+04_JPRB,0.16476E+04_JPRB,0.19283E+04_JPRB,0.22117E+04_JPRB /)  
KB(:,13,16) = (/ &
 & 0.12492E+05_JPRB,0.12602E+05_JPRB,0.12678E+05_JPRB,0.12730E+05_JPRB,0.12749E+05_JPRB /)  
KB(:,14,16) = (/ &
 & 0.14696E+05_JPRB,0.14792E+05_JPRB,0.14862E+05_JPRB,0.14890E+05_JPRB,0.14889E+05_JPRB /)  
KB(:,15,16) = (/ &
 & 0.17153E+05_JPRB,0.17242E+05_JPRB,0.17275E+05_JPRB,0.17274E+05_JPRB,0.17231E+05_JPRB /)  
KB(:,16,16) = (/ &
 & 0.19843E+05_JPRB,0.19894E+05_JPRB,0.19898E+05_JPRB,0.19845E+05_JPRB,0.19747E+05_JPRB /)  
KB(:,17,16) = (/ &
 & 0.22727E+05_JPRB,0.22731E+05_JPRB,0.22667E+05_JPRB,0.22551E+05_JPRB,0.22386E+05_JPRB /)  
KB(:,18,16) = (/ &
 & 0.25761E+05_JPRB,0.25684E+05_JPRB,0.25544E+05_JPRB,0.25342E+05_JPRB,0.25070E+05_JPRB /)  
KB(:,19,16) = (/ &
 & 0.28878E+05_JPRB,0.28701E+05_JPRB,0.28454E+05_JPRB,0.28131E+05_JPRB,0.27759E+05_JPRB /)  
KB(:,20,16) = (/ &
 & 0.31981E+05_JPRB,0.31695E+05_JPRB,0.31314E+05_JPRB,0.30871E+05_JPRB,0.30360E+05_JPRB /)  
KB(:,21,16) = (/ &
 & 0.35017E+05_JPRB,0.34575E+05_JPRB,0.34064E+05_JPRB,0.33480E+05_JPRB,0.32821E+05_JPRB /)  
KB(:,22,16) = (/ &
 & 0.37854E+05_JPRB,0.37264E+05_JPRB,0.36589E+05_JPRB,0.35840E+05_JPRB,0.35046E+05_JPRB /)  
KB(:,23,16) = (/ &
 & 0.40473E+05_JPRB,0.39710E+05_JPRB,0.38862E+05_JPRB,0.37967E+05_JPRB,0.37023E+05_JPRB /)  
KB(:,24,16) = (/ &
 & 0.42796E+05_JPRB,0.41864E+05_JPRB,0.40869E+05_JPRB,0.39817E+05_JPRB,0.38718E+05_JPRB /)  
KB(:,25,16) = (/ &
 & 0.44813E+05_JPRB,0.43719E+05_JPRB,0.42578E+05_JPRB,0.41380E+05_JPRB,0.40143E+05_JPRB /)  
KB(:,26,16) = (/ &
 & 0.46504E+05_JPRB,0.45263E+05_JPRB,0.43973E+05_JPRB,0.42641E+05_JPRB,0.41294E+05_JPRB /)  
KB(:,27,16) = (/ &
 & 0.47893E+05_JPRB,0.46507E+05_JPRB,0.45087E+05_JPRB,0.43647E+05_JPRB,0.42197E+05_JPRB /)  
KB(:,28,16) = (/ &
 & 0.48993E+05_JPRB,0.47480E+05_JPRB,0.45952E+05_JPRB,0.44417E+05_JPRB,0.42878E+05_JPRB /)  
KB(:,29,16) = (/ &
 & 0.49823E+05_JPRB,0.48206E+05_JPRB,0.46588E+05_JPRB,0.44969E+05_JPRB,0.43353E+05_JPRB /)  
KB(:,30,16) = (/ &
 & 0.50415E+05_JPRB,0.48716E+05_JPRB,0.47025E+05_JPRB,0.45339E+05_JPRB,0.43659E+05_JPRB /)  
KB(:,31,16) = (/ &
 & 0.50811E+05_JPRB,0.49042E+05_JPRB,0.47288E+05_JPRB,0.45543E+05_JPRB,0.43813E+05_JPRB /)  
KB(:,32,16) = (/ &
 & 0.51032E+05_JPRB,0.49203E+05_JPRB,0.47400E+05_JPRB,0.45610E+05_JPRB,0.43841E+05_JPRB /)  
KB(:,33,16) = (/ &
 & 0.51107E+05_JPRB,0.49234E+05_JPRB,0.47393E+05_JPRB,0.45565E+05_JPRB,0.43775E+05_JPRB /)  
KB(:,34,16) = (/ &
 & 0.51130E+05_JPRB,0.49228E+05_JPRB,0.47350E+05_JPRB,0.45497E+05_JPRB,0.43688E+05_JPRB /)  
KB(:,35,16) = (/ &
 & 0.51256E+05_JPRB,0.49316E+05_JPRB,0.47413E+05_JPRB,0.45540E+05_JPRB,0.43711E+05_JPRB /)  
KB(:,36,16) = (/ &
 & 0.51519E+05_JPRB,0.49555E+05_JPRB,0.47626E+05_JPRB,0.45731E+05_JPRB,0.43885E+05_JPRB /)  
KB(:,37,16) = (/ &
 & 0.52034E+05_JPRB,0.50041E+05_JPRB,0.48090E+05_JPRB,0.46168E+05_JPRB,0.44302E+05_JPRB /)  
KB(:,38,16) = (/ &
 & 0.52529E+05_JPRB,0.50511E+05_JPRB,0.48535E+05_JPRB,0.46595E+05_JPRB,0.44706E+05_JPRB /)  
KB(:,39,16) = (/ &
 & 0.52985E+05_JPRB,0.50952E+05_JPRB,0.48954E+05_JPRB,0.46996E+05_JPRB,0.45085E+05_JPRB /)  
KB(:,40,16) = (/ &
 & 0.53633E+05_JPRB,0.51575E+05_JPRB,0.49556E+05_JPRB,0.47578E+05_JPRB,0.45648E+05_JPRB /)  
KB(:,41,16) = (/ &
 & 0.54289E+05_JPRB,0.52211E+05_JPRB,0.50171E+05_JPRB,0.48171E+05_JPRB,0.46220E+05_JPRB /)  
KB(:,42,16) = (/ &
 & 0.54932E+05_JPRB,0.52836E+05_JPRB,0.50778E+05_JPRB,0.48759E+05_JPRB,0.46785E+05_JPRB /)  
KB(:,43,16) = (/ &
 & 0.55673E+05_JPRB,0.53569E+05_JPRB,0.51488E+05_JPRB,0.49449E+05_JPRB,0.47456E+05_JPRB /)  
KB(:,44,16) = (/ &
 & 0.56461E+05_JPRB,0.54346E+05_JPRB,0.52247E+05_JPRB,0.50190E+05_JPRB,0.48178E+05_JPRB /)  
KB(:,45,16) = (/ &
 & 0.57241E+05_JPRB,0.55121E+05_JPRB,0.53007E+05_JPRB,0.50929E+05_JPRB,0.48897E+05_JPRB /)  
KB(:,46,16) = (/ &
 & 0.58063E+05_JPRB,0.55933E+05_JPRB,0.53806E+05_JPRB,0.51710E+05_JPRB,0.49656E+05_JPRB /)  
KB(:,47,16) = (/ &
 & 0.58978E+05_JPRB,0.56828E+05_JPRB,0.54697E+05_JPRB,0.52582E+05_JPRB,0.50505E+05_JPRB /)  
KB(:,48,16) = (/ &
 & 0.59891E+05_JPRB,0.57720E+05_JPRB,0.55586E+05_JPRB,0.53459E+05_JPRB,0.51367E+05_JPRB /)  
KB(:,49,16) = (/ &
 & 0.60795E+05_JPRB,0.58621E+05_JPRB,0.56472E+05_JPRB,0.54336E+05_JPRB,0.52224E+05_JPRB /)  
KB(:,50,16) = (/ &
 & 0.61639E+05_JPRB,0.59466E+05_JPRB,0.57298E+05_JPRB,0.55162E+05_JPRB,0.53034E+05_JPRB /)  
KB(:,51,16) = (/ &
 & 0.62447E+05_JPRB,0.60284E+05_JPRB,0.58110E+05_JPRB,0.55961E+05_JPRB,0.53824E+05_JPRB /)  
KB(:,52,16) = (/ &
 & 0.63240E+05_JPRB,0.61098E+05_JPRB,0.58916E+05_JPRB,0.56760E+05_JPRB,0.54612E+05_JPRB /)  
KB(:,53,16) = (/ &
 & 0.64030E+05_JPRB,0.61903E+05_JPRB,0.59727E+05_JPRB,0.57558E+05_JPRB,0.55411E+05_JPRB /)  
KB(:,54,16) = (/ &
 & 0.64735E+05_JPRB,0.62637E+05_JPRB,0.60471E+05_JPRB,0.58287E+05_JPRB,0.56138E+05_JPRB /)  
KB(:,55,16) = (/ &
 & 0.65407E+05_JPRB,0.63332E+05_JPRB,0.61181E+05_JPRB,0.59003E+05_JPRB,0.56834E+05_JPRB /)  
KB(:,56,16) = (/ &
 & 0.66069E+05_JPRB,0.64015E+05_JPRB,0.61881E+05_JPRB,0.59702E+05_JPRB,0.57529E+05_JPRB /)  
KB(:,57,16) = (/ &
 & 0.66725E+05_JPRB,0.64683E+05_JPRB,0.62576E+05_JPRB,0.60411E+05_JPRB,0.58225E+05_JPRB /)  
KB(:,58,16) = (/ &
 & 0.67327E+05_JPRB,0.65315E+05_JPRB,0.63232E+05_JPRB,0.61078E+05_JPRB,0.58891E+05_JPRB /)  
KB(:,59,16) = (/ &
 & 0.67577E+05_JPRB,0.65572E+05_JPRB,0.63496E+05_JPRB,0.61349E+05_JPRB,0.59161E+05_JPRB /)  

!     -----------------------------------------------------------------

FORREF(:, 1) = (/ 0.299818E-05_JPRB, 0.209282E-05_JPRB, 0.988353E-04_JPRB, 0.632178E-03_JPRB /)
FORREF(:, 2) = (/ 0.633648E-05_JPRB, 0.509214E-04_JPRB, 0.650535E-03_JPRB, 0.264019E-02_JPRB /)
FORREF(:, 3) = (/ 0.636782E-04_JPRB, 0.136577E-03_JPRB, 0.166500E-02_JPRB, 0.750821E-02_JPRB /)
FORREF(:, 4) = (/ 0.472314E-03_JPRB, 0.988296E-03_JPRB, 0.585751E-02_JPRB, 0.187352E-01_JPRB /)
FORREF(:, 5) = (/ 0.558635E-02_JPRB, 0.856489E-02_JPRB, 0.157438E-01_JPRB, 0.181471E-01_JPRB /)
FORREF(:, 6) = (/ 0.217395E-01_JPRB, 0.229156E-01_JPRB, 0.230125E-01_JPRB, 0.143821E-01_JPRB /)
FORREF(:, 7) = (/ 0.277222E-01_JPRB, 0.299252E-01_JPRB, 0.208929E-01_JPRB, 0.826748E-02_JPRB /)
FORREF(:, 8) = (/ 0.252119E-01_JPRB, 0.262911E-01_JPRB, 0.187663E-01_JPRB, 0.417110E-02_JPRB /)
FORREF(:, 9) = (/ 0.304941E-01_JPRB, 0.175545E-01_JPRB, 0.971224E-02_JPRB, 0.142023E-02_JPRB /)
FORREF(:,10) = (/ 0.327200E-01_JPRB, 0.215788E-01_JPRB, 0.346831E-02_JPRB, 0.157989E-02_JPRB /)
FORREF(:,11) = (/ 0.324955E-01_JPRB, 0.228571E-01_JPRB, 0.171749E-02_JPRB, 0.226853E-02_JPRB /)
FORREF(:,12) = (/ 0.326588E-01_JPRB, 0.198544E-01_JPRB, 0.532339E-06_JPRB, 0.279086E-02_JPRB /)
FORREF(:,13) = (/ 0.345157E-01_JPRB, 0.168679E-01_JPRB, 0.505361E-06_JPRB, 0.276647E-02_JPRB /)
FORREF(:,14) = (/ 0.448765E-01_JPRB, 0.123791E-02_JPRB, 0.488367E-06_JPRB, 0.122245E-02_JPRB /)
FORREF(:,15) = (/ 0.486925E-01_JPRB, 0.464371E-06_JPRB, 0.464241E-06_JPRB, 0.753846E-06_JPRB /)
FORREF(:,16) = (/ 0.530511E-01_JPRB, 0.376234E-06_JPRB, 0.409824E-06_JPRB, 0.470650E-06_JPRB /)

!     -----------------------------------------------------------------
!     The array SELFREF contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREF(:, 1) = (/ &
 & 0.118069E+00_JPRB, 0.713523E-01_JPRB, 0.431199E-01_JPRB, 0.260584E-01_JPRB, 0.157477E-01_JPRB, &
 & 0.951675E-02_JPRB, 0.575121E-02_JPRB, 0.347560E-02_JPRB, 0.210039E-02_JPRB, 0.126932E-02_JPRB /)  
SELFREF(:, 2) = (/ &
 & 0.137081E-01_JPRB, 0.139046E-01_JPRB, 0.141040E-01_JPRB, 0.143061E-01_JPRB, 0.145112E-01_JPRB, &
 & 0.147193E-01_JPRB, 0.149303E-01_JPRB, 0.151443E-01_JPRB, 0.153614E-01_JPRB, 0.155816E-01_JPRB /)  
SELFREF(:, 3) = (/ &
 & 0.166575E-01_JPRB, 0.164916E-01_JPRB, 0.163273E-01_JPRB, 0.161647E-01_JPRB, 0.160037E-01_JPRB, &
 & 0.158443E-01_JPRB, 0.156864E-01_JPRB, 0.155302E-01_JPRB, 0.153755E-01_JPRB, 0.152224E-01_JPRB /)  
SELFREF(:, 4) = (/ &
 & 0.597379E-01_JPRB, 0.509517E-01_JPRB, 0.434579E-01_JPRB, 0.370662E-01_JPRB, 0.316145E-01_JPRB, &
 & 0.269647E-01_JPRB, 0.229988E-01_JPRB, 0.196162E-01_JPRB, 0.167311E-01_JPRB, 0.142703E-01_JPRB /)  
SELFREF(:, 5) = (/ &
 & 0.227517E+00_JPRB, 0.198401E+00_JPRB, 0.173011E+00_JPRB, 0.150870E+00_JPRB, 0.131563E+00_JPRB, &
 & 0.114726E+00_JPRB, 0.100044E+00_JPRB, 0.872415E-01_JPRB, 0.760769E-01_JPRB, 0.663411E-01_JPRB /)  
SELFREF(:, 6) = (/ &
 & 0.453235E+00_JPRB, 0.414848E+00_JPRB, 0.379712E+00_JPRB, 0.347552E+00_JPRB, 0.318116E+00_JPRB, &
 & 0.291173E+00_JPRB, 0.266512E+00_JPRB, 0.243940E+00_JPRB, 0.223279E+00_JPRB, 0.204368E+00_JPRB /)  
SELFREF(:, 7) = (/ &
 & 0.569263E+00_JPRB, 0.516415E+00_JPRB, 0.468473E+00_JPRB, 0.424982E+00_JPRB, 0.385528E+00_JPRB, &
 & 0.349737E+00_JPRB, 0.317269E+00_JPRB, 0.287815E+00_JPRB, 0.261095E+00_JPRB, 0.236856E+00_JPRB /)  
SELFREF(:, 8) = (/ &
 & 0.490314E+00_JPRB, 0.448042E+00_JPRB, 0.409413E+00_JPRB, 0.374116E+00_JPRB, 0.341861E+00_JPRB, &
 & 0.312387E+00_JPRB, 0.285455E+00_JPRB, 0.260844E+00_JPRB, 0.238355E+00_JPRB, 0.217805E+00_JPRB /)  
SELFREF(:, 9) = (/ &
 & 0.258162E+00_JPRB, 0.265085E+00_JPRB, 0.272193E+00_JPRB, 0.279493E+00_JPRB, 0.286988E+00_JPRB, &
 & 0.294684E+00_JPRB, 0.302586E+00_JPRB, 0.310701E+00_JPRB, 0.319033E+00_JPRB, 0.327588E+00_JPRB /)  
SELFREF(:,10) = (/ &
 & 0.332019E+00_JPRB, 0.331902E+00_JPRB, 0.331784E+00_JPRB, 0.331666E+00_JPRB, 0.331549E+00_JPRB, &
 & 0.331431E+00_JPRB, 0.331314E+00_JPRB, 0.331197E+00_JPRB, 0.331079E+00_JPRB, 0.330962E+00_JPRB /)  
SELFREF(:,11) = (/ &
 & 0.357523E+00_JPRB, 0.353154E+00_JPRB, 0.348839E+00_JPRB, 0.344576E+00_JPRB, 0.340366E+00_JPRB, &
 & 0.336207E+00_JPRB, 0.332099E+00_JPRB, 0.328041E+00_JPRB, 0.324032E+00_JPRB, 0.320073E+00_JPRB /)  
SELFREF(:,12) = (/ &
 & 0.294662E+00_JPRB, 0.299043E+00_JPRB, 0.303488E+00_JPRB, 0.308000E+00_JPRB, 0.312579E+00_JPRB, &
 & 0.317226E+00_JPRB, 0.321941E+00_JPRB, 0.326727E+00_JPRB, 0.331585E+00_JPRB, 0.336514E+00_JPRB /)  
SELFREF(:,13) = (/ &
 & 0.227445E+00_JPRB, 0.241545E+00_JPRB, 0.256519E+00_JPRB, 0.272422E+00_JPRB, 0.289311E+00_JPRB, &
 & 0.307247E+00_JPRB, 0.326294E+00_JPRB, 0.346523E+00_JPRB, 0.368005E+00_JPRB, 0.390820E+00_JPRB /)  
SELFREF(:,14) = (/ &
 & 0.616203E-02_JPRB, 0.113523E-01_JPRB, 0.209144E-01_JPRB, 0.385307E-01_JPRB, 0.709852E-01_JPRB, &
 & 0.130776E+00_JPRB, 0.240929E+00_JPRB, 0.443865E+00_JPRB, 0.817733E+00_JPRB, 0.150651E+01_JPRB /)  
SELFREF(:,15) = (/ &
 & 0.279552E-03_JPRB, 0.808472E-03_JPRB, 0.233812E-02_JPRB, 0.676192E-02_JPRB, 0.195557E-01_JPRB, &
 & 0.565555E-01_JPRB, 0.163560E+00_JPRB, 0.473020E+00_JPRB, 0.136799E+01_JPRB, 0.395626E+01_JPRB /)  
SELFREF(:,16) = (/ &
 & 0.261006E-03_JPRB, 0.771043E-03_JPRB, 0.227776E-02_JPRB, 0.672879E-02_JPRB, 0.198777E-01_JPRB, &
 & 0.587212E-01_JPRB, 0.173470E+00_JPRB, 0.512452E+00_JPRB, 0.151385E+01_JPRB, 0.447209E+01_JPRB /)  
     
!     -----------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('SRTM_KGB29',1,ZHOOK_HANDLE)
END SUBROUTINE SRTM_KGB29

