MODULE YOMTDDH

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!    TABLEAUX DE CUMUL DES DIAGNOSTICS DDH

!      REAL HDCVB0 (NDHCV*(NFLEVG+1),NDHIDH)
!      REAL HDCVB1 (NDHCV*(NFLEVG+1),NDHIDH)
!      REAL HDCS0 (NDHCS,NDHIDH)
!      REAL HDCS1 (NDHCS,NDHIDH)

REAL(KIND=JPRB),ALLOCATABLE:: HDCVB0(:,:,:)
REAL(KIND=JPRB),ALLOCATABLE:: HDCVB1(:,:,:)
REAL(KIND=JPRB),ALLOCATABLE:: HDCS0(:,:,:)
REAL(KIND=JPRB),ALLOCATABLE:: HDCS1(:,:,:)

! ARRAY TO SAVE INITIAL VALUES FOR FREE STYLE VARIABLES

REAL(KIND=JPRB),ALLOCATABLE:: PDDHFSVI(:)

!    POINTEURS

!    TABLEAUX DE CUMUL DES DIAGNOSTICS DDH
!    --------------------------------------

!    DHCV. : TABLEAUX DE CUMULS DES VARIABLES/FLUX EN PROFILS VERTICAUX
!    DHCVB.: TABLEAUX DE CUMULS PAR VARIABLES/FLUX NON DECOUPES EN NIVEAUX
!    DHCS. : TABLEAUX DE CUMULS DES VARIABLES/FLUX AU SOL

!    ORGANISATION DES TABLEAUX:
!       CHAMPS ATMOSPHERIQUES
!             TABLEAUX ---0 : VARIABLES INITIALES
!             TABLEAUX ---1 : VARIABLES A NSTEP NON FILTREES
!             TABLEAUX ---0 : CUMULS JUSQU A NSTEP-1
!             TABLEAUX ---1 : CUMULS JUSQU A NSTEP
!             1 A NDHVV:                                  VARIABLES DU MODELE
!             NDHVV+1 A NDHVV+NDHAVD:                     TENDANCES DYNAMIQUES
!             NDHVV+NDHAVD+1 A NDHVV+NDHFVD:              FLUX DYNAMIQUES
!             NDHVV+NDHFVD+1 A NDHVV+NDHFVD+NDHAVP:       FLUX PHYSIQUES
!             NDHVV+NDHFVD+NDHAVP+1 A NDHCV:              TENDANCES PHYSIQUES
!       CHAMPS SOL
!             TABLEAUX ---0 : VARIABLES INITIALES
!             TABLEAUX ---1 : VARIABLES A NSTEP NON FILTREES
!             TABLEAUX ---0 : CUMULS JUSQU A NSTEP-1
!             TABLEAUX ---1 : CUMULS JUSQU A NSTEP
!             1 A NDHVS:                                  VARIABLES DU MODELE
!             NDHVS+1 A NDHVS+NDHVFS:                     FREE-STYLE VARIABLES
!             NDHVS+NDHVFS+1 A NDHVS+NDHVFS+NDHFSD:       CUMULS DYNAMIQUES
!             NDHVS+NDHVFS+NDHFSD+1 A
!                NDHVS+NDHVFS+NDHFSD+NDHFSP:              CUMULS PHYSIQUES
!             NDHVS+NDHVFS+NDHFSD+NDHFSP+1 A
!                NDHVS+NDHVFS+NDHFSD+NDHFSP+NDHFFS=NDHCS: FREE-STYLE FLUXES

!    LA VALEUR D UN CHAMP AU NIVEAU JLEV = 0 N A DE SENS QUE POUR LES
!    FLUX. POUR LES TENDANCES ET VARIABLES, CETTE VALEUR EST NULLE

!    CONTENU DES TABLEAUX
!    --------------------

!*      1. PROFILS VERTICAUX

!*      1.1 VARIABLES

!       SI LHDHKS (DEBUT A L'INDICE 1)
!  1-VPP          - MASSE D'AIR
!  2-VQV          - MASSE DE VAPEUR D'EAU QV
!  3-VUU          - QUANTITE DE MOUVEMENT ZONALE UZ
!  4-VVV          - QUANTITE DE MOUVEMENT MERIDIENNE VM
!  5-VKK          - ENERGIE CINETIQUE KENE
!  6-VCT          - ENTHALPIE CP*T
!  7-VEP          - ENERGIE POTENTIELLE PHI
!  8-VHR          - HUMIDITE RELATIVE
!  9-VQL          - MASSE D'EAU LIQUIDE (SI LHDQLN=.TRUE.)
! 10-VQN          - MASSE D'EAU NEIGEUSE (SI LHDQLN=.TRUE.)
! 9+NHDQLNVA-V01  - VARIABLE PASSIVE NUMERO 01 (SI LHDPAS=.TRUE.)
!    ...
! 9+NHDQLNVA+NHDPASVA-1-Vxx - VARIABLE PASSIVE NUMERO xx=NHDPASVA (SI LHDPAS=.TRUE.)
! 9+NHDQLNVA+NHDPASVA-VNT - NEBULOSITE TOTALE
! 10+NHDQLNVA+NHDPASVA-VOM - VITESSE VERTICALE EN COORDONNEE PRESSION
!       SI LHDMCI (DEBUT A L'INDICE NDHVHK+1)
!  1-VA1          - MOMENT ANGULAIRE A1
!  2-VA2          - MOMENT ANGULAIRE A2
!  3-VA3          - MOMENT ANGULAIRE A3
!       SI LHDENT (DEBUT A L'INDICE NDHVHK+NDHVMC+1)
!  1-VSS          - ENTROPIE: S

!*      1.2 TENDANCES DYNAMIQUES

!       SI LHDHKS (DEBUT A L'INDICE NDHVV+1)
!  1-TPPDIVFLUHOR - DIV. FLUX HORIZONTAL DE MASSE D'AIR
!  2-TQVDIVFLUHOR - DIV. FLUX HORIZONTAL DE VAPEUR D'EAU
!  3-TUUDIVFLUHOR - DIV. FLUX HORIZONTAL QTE DE MVT ZONALE (CALCUL PARTIEL)
!  4-TVVDIVFLUHOR - DIV. FLUX HORIZONTAL QTE DE MVT MERIDIENNE (PARTIEL)
!  5-TUUFFVGADPSG - QTE DE MVT AGEOSTROPHIQUE MERIDIENNE
!  6-TVVFFVGADPSG - QTE DE MVT AGEOSTROPHIQUE ZONALE
!  7-TKKDIVFLUHOR - DIV. FLUX HORIZONTAL ENERGIE CINETIQUE
!  8-TKKCONVERSI1 - TRAVAIL DES FORCES DE PRESSION
!  9-TCTDIVFLUHOR - DIV. FLUX HORIZONTAL ENTHALPIE
! 10-TCTCONVERSI2 - CONVERSION D'ENERGIE INTERNE
! 11-TCTCONVERSI3 - CONVERSION D'ENERGIE INTERNE INDUITE PAR LES PRECIPITATIONS
! 12-TEPDIVFLUHOR - DIV. FLUX HORIZONTAL ENERGIE POTENTIELLE
! 13-PPP          - MASSE D'AIR: CUMUL TEMPOREL
! 14-TQLDIVFLUHOR - DIV. FLUX HORIZONTAL DE MASSE D'EAU LIQUIDE (SI LHDQLN=.TRUE.)
! 15-TQNDIVFLUHOR - DIV. FLUX HORIZONTAL DE MASSE D'EAU NEIGEUSE (SI LHDQLN=.TRUE.)
!       SI LHDMCI (DEBUT A L'INDICE NDHVV+NDHAHKD+1)
!  1-TA1DIVFLUHOR - MOMENT ANGULAIRE A1: DIV. FLUX HORIZONTAL
!  2-TA2DIVFLUHOR - MOMENT ANGULAIRE A2: DIV. FLUX HORIZONTAL
!  3-TA3DIVFLUHOR - MOMENT ANGULAIRE A3: DIV. FLUX HORIZONTAL
!  4-TA1ADJUST    - MOMENT ANGULAIRE A1: TERME D'AJUSTEMENT
!  5-TA2ADJUST    - MOMENT ANGULAIRE A2: TERME D'AJUSTEMENT
!  6-TA3ADJUST    - MOMENT ANGULAIRE A3: TERME D'AJUSTEMENT
!  7-TA1NONAX     - MOMENT ANGULAIRE A1: MOMENT NON AXIAL
!  8-TA2NONAX     - MOMENT ANGULAIRE A2: MOMENT NON AXIAL
!       SI LHDENT (DEBUT A L'INDICE NDHVV+NDHAHKD+NDHAMCD+1)
!  1-TSSDIVFLUHOR - ENTROPIE: DIV. FLUX HORIZONTAL
!  2-TSSPRECICT   - ENTROPIE: EFFET PRECIPITATIONS SUR ENTHALPIE

!*      1.3 FLUX DYNAMIQUES

!       SI LHDHKS (DEBUT A L'INDICE NDHVV+NDHAVD+1)
!  1-FPPFLUVERTDYN- VERTICAL DE MASSE D'AIR
!  2-FQVFLUVERTDYN- VERTICAL DE VAPEUR D'EAU
!  3-FUUFLUVERTDYN- VERTICAL DE QTE DE MVT ZONALE
!  4-FVVFLUVERTDYN- VERTICAL DE QTE DE MVT MERIDIENNE
!  5-FUUFLUDUAPLUI- QTE DE MVT ZONALE TRANSPORTEE PAR PRECIPITATIONS
!  6-FVVFLUDUAPLUI- QTE DE MVT MERIDIENNE TRANSPORTEE PAR PRECIPITATIONS
!  7-FKKFLUVERTDYN- VERTICAL D'ENERGIE CINETIQUE
!  8-FKKFLUDUAPLUI- ENERGIE CINETIQUE TRANSPORTEE PAR PRECIPITATIONS
!  9-FCTFLUVERTDYN- VERTICAL D'ENTHALPIE
! 10-FEPCONVERSIFL- PSEUDO VERTICAL D'ENERGIE POTENTIELLE
! 11-FQLFLUVERTDYN- VERTICAL DE MASSE D'EAU LIQUIDE (SI LHDQLN=.TRUE.)
! 12-FQNFLUVERTDYN- VERTICAL DE MASSE D'EAU NEIGEUSE (SI LHDQLN=.TRUE.)
!       SI LHDMCI (DEBUT A L'INDICE NDHVV+NDHAVD+NDHBHKD+1)
!  1-FA1FLUVERTDYN- MOMENT ANGULAIRE A1: FLUX VERTICAL DYNAMIQUE
!  2-FA2FLUVERTDYN- MOMENT ANGULAIRE A2: FLUX VERTICAL DYNAMIQUE
!  3-FA3FLUVERTDYN- MOMENT ANGULAIRE A3: FLUX VERTICAL DYNAMIQUE
!  4-FA1GRAV      - MOMENT ANGULAIRE A1: FORCE DE GRAVITE
!  5-FA2GRAV      - MOMENT ANGULAIRE A2: FORCE DE GRAVITE
!  6-FA3GRAV      - MOMENT ANGULAIRE A3: FORCE DE GRAVITE
!  7-FA1FLUDUAPLUI- MOMENT ANGULAIRE A1: FLUX DU AUX PRECIPITATIONS (NDPSFI=1)
!  8-FA2FLUDUAPLUI- MOMENT ANGULAIRE A2: FLUX DU AUX PRECIPITATIONS (NDPSFI=1)
!  9-FA3FLUDUAPLUI- MOMENT ANGULAIRE A3: FLUX DU AUX PRECIPITATIONS (NDPSFI=1)
!       SI LHDENT (DEBUT A L'INDICE NDHVV+NDHAVD+NDHBHKD+NDHBMCD+1)
!  1-FSSFLUVERTDYN-  ENTROPIE: FLUX VERTICAL DYNAMIQUE
!  2-FSSPRECISS   -  ENTROPIE: EFFET DIRECT DES PRECIPITATIONS

!*      1.4 FLUX PHYSIQUES

!       SI LHDHKS (DEBUT A L'INDICE NDHVV+NDHFVD+1)
!  1-FPPSUMFPL    - TOTAL DE PRECIPITATION, PERTE DE MASSE D'AIR
!  2-FQVTUR       - TURBULENT DE VAPEUR D'EAU
!  3-FQVTURCONV   - TURBULENT DE VAPEUR D'EAU DU A LA CONVECTION
!  4-FQVPRECISTL  - DE PRECIPITATION STRATIFORME LIQUIDE
!  5-FQVPRECISTN  - DE PRECIPITATION STRATIFORME NEIGEUSE
!  6-FQVPRECICOL  - DE PRECIPITATION CONVECTIVE LIQUIDE
!  7-FQVPRECICON  - DE PRECIPITATION CONVECTIVE NEIGEUSE
!  8-FQVTURQNEGAT - DE VAPEUR D'EAU COMPENSANT LES VALEURS < 0
!  9-FUUTUR       - TURBULENT DE QTE DE MVT ZONALE
! 10-FVVTUR       - TURBULENT DE QTE DE MVT MERIDIENNE
! 11-FUUTURCONV   - TURBULENT DE QTE DE MVT ZONALE DU A LA CONVECTION
! 12-FVVTURCONV   - TURBULENT DE QTE DE MVT ZONALE DU A LA CONVECTION
! 13-FUUONDEGREL  - TURBULENT DE QTE DE MVT MERIDIENNE DU AUX ONDES OROGRAPHIQUES
! 14-FUUONDEGREL  - TURBULENT DE QTE DE MVT MERIDIENNE DU AUX ONDES OROGRAPHIQUES
! 15-FCTTUR       - TURBULENT SEC D'ENTHALPIE
! 16-FCTTURCONV   - TURBULENT CONVECTIF D'ENTHALPIE
! 17-FCTRAYSOL1   - DE RAYONNEMENT SOLAIRE
! 18-FCTRAYTER1   - DE RAYONNEMENT THERMIQUE
! 19-FCTPRECISTL  - D'ENTHALPIE DU AUX PRECIPITATIONS STRATIFORMES LIQUIDES
! 20-FCTPRECISTN  - D'ENTHALPIE DU AUX PRECIPITATIONS STRATIFORMES NEIGEUSES
! 21-FCTPRECICOL  - D'ENTHALPIE DU AUX PRECIPITATIONS CONVECTIVES LIQUIDES
! 22-FCTPRECICON  - D'ENTHALPIE DU AUX PRECIPITATIONS CONVECTIVES NEIGEUSES
! 23-FCTPRECCSCOL - DE CHAL. SENS. DU AUX PRECIPITATIONS CONVECTIVES LIQUIDES
! 24-FCTPRECCSCON - DE CHAL. SENS. DU AUX PRECIPITATIONS CONVECTIVES NEIGEUSES
! 25-FCTPRECCSSTL - DE CHAL. SENS. DU AUX PRECIPITATIONS STRATIFORMES LIQUIDES
! 26-FCTPRECCSSTN - DE CHAL. SENS. DU AUX PRECIPITATIONS STRATIFORMES NEIGEUSES
! 27-FQLTUR       - TURBULENT D'EAU LIQUIDE (SI LHDQLN=.TRUE.)
! 28-FQNTUR       - TURBULENT D'EAU NEIGEUSE (SI LHDQLN=.TRUE.)
! 29-FQLTURCONV   - TURBULENT D'EAU LIQUIDE DU A LA CONVECTION (SI LHDQLN=.TRUE.)
! 30-FQNTURCONV   - TURBULENT D'EAU NEIGEUSE DU A LA CONVECTION (SI LHDQLN=.TRUE.)
! 31-FQLTURQNEGAT - D'EAU LIQUIDE COMPENSANT LES VALEURS < 0 (SI LHDQLN=.TRUE.)
! 32-FQNTURQNEGAT - D'EAU NEIGEUSE COMPENSANT LES VALEURS < 0 (SI LHDQLN=.TRUE.)
! 33-FQTCONDECOL  - DE CONDENSATION CONVECTIVE LIQUIDE (SI LHDQLN=.TRUE.)
! 34-FQTCONDECON  - DE CONDENSATION CONVECTIVE NEIGEUSE (SI LHDQLN=.TRUE.)
! 35-FQTCONDESTL  - DE CONDENSATION STRATIFORME LIQUIDE (SI LHDQLN=.TRUE.)
! 36-FQTCONDESTN  - DE CONDENSATION STRATIFORME NEIGEUSE (SI LHDQLN=.TRUE.)
!       SI LHDMCI (DEBUT A L'INDICE NDHVV+NDHFVD+NDHAHKP+1)
!  1-FA1TUR       - MOMENT ANGULAIRE A1: DIFFUSION VERTICALE
!  2-FA2TUR       - MOMENT ANGULAIRE A2: DIFFUSION VERTICALE
!  3-FA3TUR       - MOMENT ANGULAIRE A3: DIFFUSION VERTICALE
!  4-FA1TURCONV   - MOMENT ANGULAIRE A1: PROCESSUS CONVECTIFS TURBULENTS
!  5-FA2TURCONV   - MOMENT ANGULAIRE A2: PROCESSUS CONVECTIFS TURBULENTS
!  6-FA3TURCONV   - MOMENT ANGULAIRE A3: PROCESSUS CONVECTIFS TURBULENTS
!  7-FA1ONDEGREL  - MOMENT ANGULAIRE A1: ONDES DE GRAVITE OROGRAPHIQUES
!  8-FA2ONDEGREL  - MOMENT ANGULAIRE A2: ONDES DE GRAVITE OROGRAPHIQUES
!  9-FA3ONDEGREL  - MOMENT ANGULAIRE A3: ONDES DE GRAVITE OROGRAPHIQUES
!       SI LHDENT (DEBUT A L'INDICE NDHVV+NDHFVD+NDHAHKP+NDHAMCP+1)

!*      1.5 TENDANCES PHYSIQUES

!       SI LHDHKS (DEBUT A L'INDICE NDHVV+NDHFVD+NDHAVP+1)
!  1-TKKDISSIPTUR - DISSIPATION DUE A LA TURBULENCE SECHE
!  2-TKKDISSIPCONV- DISSIPATION DUE A LA CONVECTION
!  3-TKKDISSIPGREL- DISSIPATION DUE AUX ONDES DE GRAVITE INDUITES PAR LE RELIEF
!  4-TQVFORMPSTL  - FORMATION DE PLUIE STRATIFORME (SI LHDADD=.TRUE.)
!  5-TCTFORMPSTL  - VARIATION D'ENTHALPIE FORMATION PLUIE STRATIFORME (SI LHDADD=.TRUE.)
!  6-TQVEVAPPSTL  - EVAPORATION PLUIE STRATIFORME (SI LHDADD=.TRUE.)
!  7-TCTEVAPPSTL  - VARIATION D'ENTHALPIE EVAPORATION PLUIE STRATIFORME (SI LHDADD=.TRUE.)
!  8-TQVFORMPSTN  - FORMATION DE NEIGE STRATIFORME (SI LHDADD=.TRUE.)
!  9-TCTFORMPSTN  - VARIATION D'ENTHALPIE FORMATION NEIGE STRATIFORME (SI LHDADD=.TRUE.)
! 10-TQVEVAPPSTN  - EVAPORATION NEIGE STRATIFORME (SI LHDADD=.TRUE.)
! 11-TCTEVAPPSTN  - VARIATION D'ENTHALPIE EVAPORATION NEIGE STRATIFORME (SI LHDADD=.TRUE.)
! 12-TQVFONTPST   - FONTE DE NEIGE EN PLUIE STRATIFORME (SI LHDADD=.TRUE.)
! 13-TCTFONTPST   - VARIATION D'ENTHALPIE FONTE DE NEIGE STRATIFORME (SI LHDADD=.TRUE.)
! 14-TQVFORMPCOL  - FORMATION DE PLUIE CONVECTIVE (SI LHDADD=.TRUE.)
! 15-TCTFORMPCOL  - VARIATION D'ENTHALPIE FORMATION PLUIE CONVECTIVE (SI LHDADD=.TRUE.)
! 16-TQVEVAPPCOL  - EVAPORATION DE PLUIE CONVECTIVE (SI LHDADD=.TRUE.)
! 17-TCTEVAPPCOL  - VARIATION D'ENTHALPIE EVAPORATION PLUIE CONVECTIVE (SI LHDADD=.TRUE.)
! 18-TQVFORMPCON  - FORMATION DE NEIGE CONVECTIVE (SI LHDADD=.TRUE.)
! 19-TCTFORMPCON  - VARIATION D'ENTHALPIE FORMATION NEIGE CONVECTIVE (SI LHDADD=.TRUE.)
! 20-TQVEVAPPCON  - EVAPORATION NEIGE CONVECTIVE (SI LHDADD=.TRUE.)
! 21-TCTEVAPPCON  - VARIATION D'ENTHALPIE EVAPORATION NEIGE CONVECTIVE (SI LHDADD=.TRUE.)
! 22-TQVFONTPCO   - FONTE DE NEIGE CONVECTIVE (SI LHDADD=.TRUE.)
! 23-TCTFONTPCO   - VARIATION D'ENTHALPIE FONTE DE NEIGE CONVECTIVE (SI LHDADD=.TRUE.)
!       SI LHDMCI (DEBUT A L'INDICE NDHVV+NDHFVD+NDHAVP+NDHBHKP+1)
!       SI LHDENT (DEBUT A L'INDICE NDHVV+NDHFVD+NDHAVP+NDHBHKP+NDHBMCP+1)
!  1-TSSDISSIPTUR - ENTROPIE: DISSIPATION DUE AUX PROCESSUS TURBULENTS SECS
!                              TURBULENT DISSIPATION OF ENERGY
!  2-TSSDISSIPCONV- ENTROPIE: DISSIPATION DUE AUX PROCESSUS TURBULENTS CONVECTIFS
!                              CONVECTIVE DISSIPATION OF ENERGY
!  3-TSSDISSIPGREL- ENTROPIE: DISSIPATION DUE AUX ONDES DE RELIEF
!                              GRAVITY WAVE DRAG DISSIP. OF ENERGY
!  4-TSSTURQVTOT  - ENTROPIE: PROCESSUS TURBULENTS SUR LA VAPEUR D'EAU
!                              DIFFUSION OF HUMIDITY
!  5-TSSRAY1      - ENTROPIE: EFFET DU RAYONNEMENT
!                              RADIATION
!  6-TSSTURCTTOT  - ENTROPIE: PROCESSUS TURBULENTS SUR L'ENTHALPIE
!                              DIFFUSION OF ENTHALPY

!*      2. VARIABLES AU SOL

!*      2.1 VARIABLES
!       SUR LES POINTS TERRE UNIQUEMENT

!       SI LHDHKS
!  1-S V          - SURFACE DE TERRE DU DOMAINE (MOYENNE PONDEREE DES PITM)
!  2-S V          - ENERGIE COUCHE SURFACE
!  3-S V          - ENERGIE COUCHE PROFONDE
!  4-S V          - HAUTEUR D'EAU COUCHE SURFACE
!  5-S V          - HAUTEUR D'EAU COUCHE PROFONDE
!  6-S V          - HAUTEUR DE NEIGE COUCHE SURFACE
!       SI LHDMCI
!       SI LHDENT

!*      2.1a FREE-STYLE VARIABLES
!       (NOTE: VALID OVER LAND AND SEA)

!       IF LHDHKS.AND.LECMWF
!  1-SVGFS        - 2-METRE TEMPERATURE
!  2-SVGFS        - 2-METRE DEWPOINT
!  3-SVGFS        - 10-METRE U-COMPONENT
!  4-SVGFS        - 10-METRE V-COMPONENT
!  5-SVGFS        - SKIN TEMPERATURE
!  6-SVGFS        - FORECAST SURFACE ROUGHNESS
!  7-SVGFS        - FORECAST SURFACE ROUGHNESS FOR HEAT
!  8-SVGFS        - FORECAST ALBEDO
!       IF LHDMCI
!       IF LHDENT

!*      2.2 TENDANCES/FLUX DYNAMIQUES
!       SUR LES POINTS TERRE UNIQUEMENT

!       SI LHDHKS
!       SI LHDMCI
!       SI LHDENT

!*      2.3 TENDANCES/FLUX PHYSIQUES
!       SUR LES POINTS TERRE UNIQUEMENT

!       IF LHDHKS
!  1-S FVRAC      - FLUX DE RAYONNEMENT SOLAIRE NET (GAIN ALGEBRIQUE POUR LA COUCHE S)
!  2-S FVRAC      - FLUX DE RAYONNEMENT THERMIQUE NET
!  3-S FVRAC      - FLUX DE CHALEUR LATENTE, EVAPORATION DE LIQUIDE
!  4-S FVRAC      - FLUX DE CHALEUR LATENTE, EVAPORATION DE NEIGE
!  5-S FVRAC      - FLUX DE CHALEUR SENSIBLE
!  6-S FVRAC      - FLUX DE CHALEUR VERS SOL PROFOND (GAIN ALGEBRIQUE POUR COUCHE P)
!  7-S FVRAC      - FLUX DE CHALEUR RESULTANT DE LA FONTE DE NEIGE (COUCHE S)
!  8-S FVRAC      - FLUX DE PRECIPITATIONS STRATIFORMES LIQUIDES (GAIN POUR LA COUCHE S)
!  9-S FVRAC      - FLUX DE PRECIPITATIONS STRATIFORMES NEIGEUSES
! 10-S FVRAC      - FLUX DE PRECIPITATIONS CONVECTIVES LIQUIDES
! 11-S FVRAC      - FLUX DE PRECIPITATIONS CONVECTIVES NEIGEUSES
! 12-S FVRAC      - FLUX D'EVAPORATION DE LIQUIDE
! 13-S FVRAC      - FLUX D'EVAPORATION DE NEIGE
! 14-S FVRAC      - FLUX D'EAU VERS LA COUCHE PROFONDE (GAIN POUR COUCHE P)
! 15-S FVRAC      - FLUX NEIGE VERS LIQUIDE (FONTE EN SURFACE, COUCHE S)
! 16-S FVRAC      - TROP-PLEIN EN SURFACE (RUISSELLEMENT, PERDU)
! 17-S FVRAC      - TROP-PLEIN EN PROFONDEUR (PERDU)
!       IF LHDMCI
!       IF LHDENT

!*      2.3a FREE-STYLE FLUXES
!       (NOTE: VALID OVER LAND AND SEA)

!       IF LHDHKS.AND.LECMWF
!  1-SFGFS        - SURFACE SOLAR RADIATION DOWNWARDS
!  2-SFGFS        - SURFACE THERMAL RADIATION DOWNWARDS
!       IF LHDMCI
!       IF LHDENT
!$OMP THREADPRIVATE(hdcs0,hdcs1,hdcvb0,hdcvb1,pddhfsvi)
END MODULE YOMTDDH
