!$gpum horizontal klon
MODULE water_int_mod
  PRIVATE

  PUBLIC water_int

  CONTAINS

SUBROUTINE water_int(klon,klev,field3d,mass,field2d)

!=============================================================
! Compute the 2D burden from 3D mixing ratios
!  OB (obolmd@lmd.jussieu.fr)
!=============================================================

IMPLICIT NONE

! Arguments
INTEGER, INTENT(IN) :: klon,klev
REAL, DIMENSION(klon,klev),INTENT(IN)  :: field3d, mass 
REAL, DIMENSION(klon),     INTENT(OUT) :: field2d

INTEGER i, k

field2d(:)=0.0
DO k=1, klev
  DO i=1, klon
    field2d(i)=field2d(i)+field3d(i,k)*mass(i,k)
  ENDDO
ENDDO

RETURN
END SUBROUTINE water_int

END MODULE water_int_mod
