!OPTIONS XOPT(NOEVAL)
SUBROUTINE SUSW15

!**** *SUSW15*   - INITIALIZE COMMON YOMSW15
!****              FROZEN VERSION (CYCLE 15) OF SUSW

!     PURPOSE.
!     --------
!           INITIALIZE YOMSW15, THE COMMON THAT CONTAINS COEFFICIENTS
!           NEEDED TO RUN THE SHORTWAVE RADIATION SUBROUTINES

!**   INTERFACE.
!     ----------
!        *CALL* *SUSW15

!        EXPLICIT ARGUMENTS :
!        --------------------
!        NONE

!        IMPLICIT ARGUMENTS :
!        --------------------
!        COMMON YOMSW15

!     METHOD.
!     -------
!        SEE DOCUMENTATION

!     EXTERNALS.
!     ----------

!     REFERENCE.
!     ----------
!        ECMWF RESEARCH DEPARTMENT DOCUMENTATION OF THE IFS

!     AUTHOR.
!     -------
!        96-11: Ph. Dandin. Meteo-France
!        ORIGINAL : 88-12-15 BY JEAN-JACQUES MORCRETTE *ECMWF*

!     MODIFICATIONS.
!     --------------
!        M.Hamrud      01-Oct-2003 CY28 Cleaning

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOMCST   , ONLY : RG
USE YOMSW15  , ONLY : APAD15   ,BPAD15   ,RRAY15   ,RSUN15   ,&
 & RPDH115  ,RPDU115  ,RPNH15   ,RPNU15   ,RSWCE15  ,&
 & RSWCP15  ,RTDH2O15 ,RTDUMG15 ,RTH2O15  ,RTUMG15  ,D15  

!      ----------------------------------------------------------------

!*       1.    SET VALUES.
!              -----------

IMPLICIT NONE
REAL(KIND=JPRB),SAVE   :: ZPDH2O=0.8_JPRB
REAL(KIND=JPRB),SAVE   :: ZPDUMG=0.75_JPRB
REAL(KIND=JPRB),SAVE   :: ZPRH2O=30000._JPRB
REAL(KIND=JPRB),SAVE   :: ZPRUMG=30000._JPRB

!$OMP THREADPRIVATE(zpdh2o,zpdumg,zprh2o,zprumg)

REAL(KIND=JPRB) :: ZH2O, ZUMG
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('SUSW15',0,ZHOOK_HANDLE)
RPDH115=ZPDH2O+1.0_JPRB
RPDU115=ZPDUMG+1.0_JPRB
ZH2O=1.0_JPRB/( 10._JPRB* RG * RPDH115 )
ZUMG=1.0_JPRB/( 10._JPRB* RG * RPDU115 )
RPNU15 = ZUMG/(ZPRUMG**ZPDUMG)
RPNH15 = ZH2O/(ZPRH2O**ZPDH2O)

RSWCP15=0.002_JPRB*RSWCE15

RTDH2O15 = 0.40_JPRB
RTDUMG15 = 0.375_JPRB
RTH2O15 = 240._JPRB
RTUMG15 = 240._JPRB
RSWCE15 = 0._JPRB
RSWCP15 = 0._JPRB

RSUN15(1) = 0.441676_JPRB
D15(1,:) = (/ 0.00_JPRB, 0.00_JPRB, 0.00_JPRB /)
!* DERIVED FROM HITRAN APRIL 1991
!       H2O:  Pref=300 hPa, Tref=240K, Pdep=0.8
!       O3 :  unchanged

APAD15(1,1:3,1:7) = RESHAPE((/&
 & 0.912418292E+05_JPRB, 0.000000000E-00_JPRB, 0.925887084E-04_JPRB,&
 & 0.723613782E+05_JPRB, 0.000000000E-00_JPRB, 0.129353723E-01_JPRB,&
 & 0.596037057E+04_JPRB, 0.000000000E-00_JPRB, 0.800821928E+00_JPRB,&
 & 0.000000000E-00_JPRB, 0.000000000E-00_JPRB, 0.242715973E+02_JPRB,&
 & 0.000000000E-00_JPRB, 0.000000000E-00_JPRB, 0.878331486E+02_JPRB,&
 & 0.000000000E-00_JPRB, 0.000000000E-00_JPRB, 0.191559725E+02_JPRB,&
 & 0.000000000E-00_JPRB, 0.000000000E-00_JPRB, 0.000000000E+00_JPRB /)&
 & ,(/3,7/))  

BPAD15(1,1:3,1:7) = RESHAPE((/&
 & 0.912418292E+05_JPRB, 0.000000000E-00_JPRB, 0.925887084E-04_JPRB,&
 & 0.724555318E+05_JPRB, 0.000000000E-00_JPRB, 0.131812683E-01_JPRB,&
 & 0.602593328E+04_JPRB, 0.000000000E-00_JPRB, 0.812706117E+00_JPRB,&
 & 0.100000000E+01_JPRB, 0.000000000E-00_JPRB, 0.249863591E+02_JPRB,&
 & 0.000000000E-00_JPRB, 0.000000000E-00_JPRB, 0.931071925E+02_JPRB,&
 & 0.000000000E-00_JPRB, 0.000000000E-00_JPRB, 0.252233437E+02_JPRB,&
 & 0.000000000E-00_JPRB, 0.000000000E-00_JPRB, 0.100000000E+01_JPRB /)&
 & ,(/3,7/))  

RRAY15(1,1:6) = (/&
 & .428937E-01_JPRB, .890743E+00_JPRB,-.288555E+01_JPRB,&
 & .522744E+01_JPRB,-.469173E+01_JPRB, .161645E+01_JPRB/)  

RSUN15(2) = 0.558324_JPRB

D15(2,1:3) = (/ 0.000000000_JPRB, 0.000000000_JPRB, 0.800000000_JPRB /)

!* INTERVAL 2:  0.68 - 4.00 MICRONS
!* DERIVED FROM HITRAN APRIL 1991
!       H2O:  Pref=300 hPa, Tref=240K, Pdep=0.80
!       UMG:  Pref=300 hPa, Tref=240K, Pdep=0.75 (CO2+O2+CH4+N2O+CO)
!       O3 :  unchanged

APAD15(2,1:3,1:7) = RESHAPE((/&
 & 0.376655383E-08_JPRB, 0.739646016E-08_JPRB, 0.410177786E+03_JPRB,&
 & 0.978576773E-04_JPRB, 0.131849595E-03_JPRB, 0.672595424E+02_JPRB,&
 & 0.387714006E+00_JPRB, 0.437772681E+00_JPRB, 0.000000000E-00_JPRB,&
 & 0.118461660E+03_JPRB, 0.151345118E+03_JPRB, 0.000000000E-00_JPRB,&
 & 0.119079797E+04_JPRB, 0.233628890E+04_JPRB, 0.000000000E-00_JPRB,&
 & 0.293353397E+03_JPRB, 0.797219934E+03_JPRB, 0.000000000E-00_JPRB,&
 & 0.000000000E+00_JPRB, 0.000000000E+00_JPRB, 0.000000000E+00_JPRB /)&
 & ,(/3,7/))  

BPAD15(2,1:3,1:7) = RESHAPE((/&
 & 0.376655383E-08_JPRB, 0.739646016E-08_JPRB, 0.410177786E+03_JPRB,&
 & 0.979023421E-04_JPRB, 0.131861712E-03_JPRB, 0.731185438E+02_JPRB,&
 & 0.388611139E+00_JPRB, 0.437949001E+00_JPRB, 0.100000000E+01_JPRB,&
 & 0.120291383E+03_JPRB, 0.151692730E+03_JPRB, 0.000000000E+00_JPRB,&
 & 0.130531005E+04_JPRB, 0.237071130E+04_JPRB, 0.000000000E+00_JPRB,&
 & 0.415049409E+03_JPRB, 0.867914360E+03_JPRB, 0.000000000E+00_JPRB,&
 & 0.100000000E+01_JPRB, 0.100000000E+01_JPRB, 0.000000000E+00_JPRB /)&
 & ,(/3,7/))  

RRAY15(2,1:6) = (/&
 & .697200E-02_JPRB, .173297E-01_JPRB,-.850903E-01_JPRB,&
 & .248261E+00_JPRB,-.302031E+00_JPRB, .129662E+00_JPRB/)  
IF (LHOOK) CALL DR_HOOK('SUSW15',1,ZHOOK_HANDLE)
END SUBROUTINE SUSW15
