!----------------------------------------------------------------------------
SUBROUTINE RRTM_TAUMOL3 (KLEV,P_TAU,&
 & P_TAUAERL,P_FAC00,P_FAC01,P_FAC10,P_FAC11,P_FORFAC,K_JP,K_JT,K_JT1,P_ONEMINUS,&
 & P_COLH2O,P_COLCO2,P_COLN2O,K_LAYTROP,P_SELFFAC,P_SELFFRAC,K_INDSELF,PFRAC)  

!     BAND 3:  500-630 cm-1 (low - H2O,CO2; high - H2O,CO2)

! Modifications
!        M.Hamrud      01-Oct-2003 CY28 Cleaning

!     D Salmond 2000-05-15 speed-up

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE PARRRTM  , ONLY : JPLAY  ,JPBAND ,JPGPT  ,NG3   ,NGS2
USE YOERRTWN , ONLY :      NSPA   ,NSPB
USE YOERRTA3 , ONLY : ABSA   ,ABSB   ,FRACREFA, FRACREFB,&
 & FORREF   ,SELFREF , ABSN2OA ,&
 & ABSN2OB  ,ETAREF ,H2OREF ,N2OREF  , CO2REF  ,&
 & STRRAT  

!  Input
!#include "yoeratm.h"

!      REAL TAUAER(JPLAY)

IMPLICIT NONE

!  Output
INTEGER(KIND=JPIM),INTENT(IN)    :: KLEV 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: P_TAU(JPGPT,JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_TAUAERL(JPLAY,JPBAND) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC00(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC01(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC10(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC11(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FORFAC(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JP(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT1(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_ONEMINUS 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLH2O(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLCO2(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLN2O(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_LAYTROP 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFAC(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFRAC(JPLAY) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_INDSELF(JPLAY) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PFRAC(JPGPT,JPLAY) 
!- from AER
!- from INTFAC      
!- from INTIND
!- from PRECISE             
!- from PROFDATA             
!- from SELF             
!- from SP             
INTEGER(KIND=JPIM) :: IJS(JPLAY)
REAL(KIND=JPRB) :: ZFS(JPLAY),Z_SPECCOMB(JPLAY)
INTEGER(KIND=JPIM) :: IND0(JPLAY),IND1(JPLAY),INDS(JPLAY)
REAL(KIND=JPRB) :: Z_N2OMULT(JPLAY)

INTEGER(KIND=JPIM) :: IG, JS, I_LAY, I_NS

REAL(KIND=JPRB) :: Z_COLREF1, Z_COLREF2, Z_CURRN2O, Z_FAC000, Z_FAC001,&
 & Z_FAC010, Z_FAC011, Z_FAC100, Z_FAC101, Z_FAC110, Z_FAC111, &
 & Z_FP, Z_FS, Z_RATIO, Z_SPECMULT, Z_SPECPARM, Z_WCOMB1, &
 & Z_WCOMB2  
REAL(KIND=JPRB) :: ZHOOK_HANDLE

!      EQUIVALENCE (TAUAERL(1,3),TAUAER)

!     Compute the optical depth by interpolating in ln(pressure), 
!     temperature, and appropriate species.  Below LAYTROP, the water
!     vapor self-continuum is interpolated (in temperature) separately.  

IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL3',0,ZHOOK_HANDLE)
DO I_LAY = 1, K_LAYTROP
  Z_SPECCOMB(I_LAY) = P_COLH2O(I_LAY) + STRRAT*P_COLCO2(I_LAY)
  Z_SPECPARM = P_COLH2O(I_LAY)/Z_SPECCOMB(I_LAY)
  Z_SPECPARM=MIN(P_ONEMINUS,Z_SPECPARM)
  Z_SPECMULT = 8._JPRB*(Z_SPECPARM)
  JS = 1 + INT(Z_SPECMULT)
  Z_FS = MOD(Z_SPECMULT,1.0_JPRB)
  IF (JS  ==  8) THEN
    IF (Z_FS  >=  0.9_JPRB) THEN
      JS = 9
      Z_FS = 10._JPRB * (Z_FS - 0.9_JPRB)
    ELSE
      Z_FS = Z_FS/0.9_JPRB
    ENDIF
  ENDIF

  I_NS = JS + INT(Z_FS + 0.5_JPRB)
  Z_FP = P_FAC01(I_LAY) + P_FAC11(I_LAY)
  IND0(I_LAY) = ((K_JP(I_LAY)-1)*5+(K_JT(I_LAY)-1))*NSPA(3) + JS
  IND1(I_LAY) = (K_JP(I_LAY)*5+(K_JT1(I_LAY)-1))*NSPA(3) + JS
  INDS(I_LAY) = K_INDSELF(I_LAY)
  Z_COLREF1 = N2OREF(K_JP(I_LAY))
  Z_COLREF2 = N2OREF(K_JP(I_LAY)+1)
  IF (I_NS  ==  10) THEN
    Z_WCOMB1 = 1.0_JPRB/H2OREF(K_JP(I_LAY))
    Z_WCOMB2 = 1.0_JPRB/H2OREF(K_JP(I_LAY)+1)
  ELSE
    Z_WCOMB1 = (1.0_JPRB-ETAREF(I_NS))/(STRRAT * CO2REF(K_JP(I_LAY)))
    Z_WCOMB2 = (1.0_JPRB-ETAREF(I_NS))/(STRRAT * CO2REF(K_JP(I_LAY)+1))
  ENDIF
  Z_RATIO = (Z_COLREF1*Z_WCOMB1)+Z_FP*((Z_COLREF2*Z_WCOMB2)-(Z_COLREF1*Z_WCOMB1))
  Z_CURRN2O = Z_SPECCOMB(I_LAY) * Z_RATIO
  Z_N2OMULT(I_LAY) = P_COLN2O(I_LAY) - Z_CURRN2O

  ZFS(I_LAY)=Z_FS
  IJS(I_LAY)=JS

ENDDO

!-- DS_000515
DO IG = 1, NG3
  DO I_LAY = 1, K_LAYTROP
!-- DS_000515

    Z_FS=ZFS(I_LAY)
    JS=IJS(I_LAY)

!---jjm
!    FAC000 = (_ONE_ - FS) * FAC00(LAY)
!    FAC010 = (_ONE_ - FS) * FAC10(LAY)
!    FAC100 = FS * FAC00(LAY)
!    FAC110 = FS * FAC10(LAY)
!    FAC001 = (_ONE_ - FS) * FAC01(LAY)
!    FAC011 = (_ONE_ - FS) * FAC11(LAY)
!    FAC101 = FS * FAC01(LAY)
!    FAC111 = FS * FAC11(LAY)
!------        

    P_TAU (NGS2+IG,I_LAY) = Z_SPECCOMB(I_LAY) *   &
     !-- DS_000515
     & ( (1. - Z_FS) *(P_FAC00(I_LAY) * ABSA(IND0(I_LAY)   ,IG) +   &
     & P_FAC10(I_LAY) * ABSA(IND0(I_LAY)+10,IG) +   &
     & P_FAC01(I_LAY) * ABSA(IND1(I_LAY)   ,IG) +   &
     & P_FAC11(I_LAY) * ABSA(IND1(I_LAY)+10,IG))+   &
     & Z_FS     *(P_FAC00(I_LAY) * ABSA(IND0(I_LAY)+ 1,IG) +   &
     & P_FAC10(I_LAY) * ABSA(IND0(I_LAY)+11,IG) +   &
     & P_FAC01(I_LAY) * ABSA(IND1(I_LAY)+ 1,IG) +   &
     & P_FAC11(I_LAY) * ABSA(IND1(I_LAY)+11,IG))) + &
     !     &(Z_FAC000 * ABSA(IND0(I_LAY)   ,IG) +&
     !     & Z_FAC100 * ABSA(IND0(I_LAY)+ 1,IG) +&
     !     & Z_FAC010 * ABSA(IND0(I_LAY)+10,IG) +&
     !     & Z_FAC110 * ABSA(IND0(I_LAY)+11,IG) +&
     !     & Z_FAC001 * ABSA(IND1(I_LAY),   IG) +&
     !     & Z_FAC101 * ABSA(IND1(I_LAY)+ 1,IG) +&
     !     & Z_FAC011 * ABSA(IND1(I_LAY)+10,IG) +&
     !     & Z_FAC111 * ABSA(IND1(I_LAY)+11,IG))+&
     !-- DS_000515
     & P_COLH2O(I_LAY) * &
     & P_SELFFAC(I_LAY) * (SELFREF(INDS(I_LAY),IG) + &
     & P_SELFFRAC(I_LAY) *&
     & (SELFREF(INDS(I_LAY)+1,IG) - SELFREF(INDS(I_LAY),IG))&
     & + P_FORFAC(I_LAY) * FORREF(IG) ) &
     & + Z_N2OMULT(I_LAY) * ABSN2OA(IG) &
     & + P_TAUAERL(I_LAY,3)  
    PFRAC(NGS2+IG,I_LAY) = FRACREFA(IG,JS) + Z_FS *&
     & (FRACREFA(IG,JS+1) - FRACREFA(IG,JS))  
  ENDDO
ENDDO

DO I_LAY = K_LAYTROP+1, KLEV
  Z_SPECCOMB(I_LAY) = P_COLH2O(I_LAY) + STRRAT*P_COLCO2(I_LAY)
  Z_SPECPARM = P_COLH2O(I_LAY)/Z_SPECCOMB(I_LAY)
  Z_SPECPARM=MIN(P_ONEMINUS,Z_SPECPARM)
  Z_SPECMULT = 4._JPRB*(Z_SPECPARM)
  JS = 1 + INT(Z_SPECMULT)
  Z_FS = MOD(Z_SPECMULT,1.0_JPRB)
  I_NS = JS + INT(Z_FS + 0.5_JPRB)
  Z_FP = P_FAC01(I_LAY) + P_FAC11(I_LAY)
  IND0(I_LAY) = ((K_JP(I_LAY)-13)*5+(K_JT(I_LAY)-1))*NSPB(3) + JS
  IND1(I_LAY) = ((K_JP(I_LAY)-12)*5+(K_JT1(I_LAY)-1))*NSPB(3) + JS
  Z_COLREF1 = N2OREF(K_JP(I_LAY))
  Z_COLREF2 = N2OREF(K_JP(I_LAY)+1)
  IF (I_NS  ==  5) THEN
    Z_WCOMB1 = 1.0_JPRB/H2OREF(K_JP(I_LAY))
    Z_WCOMB2 = 1.0_JPRB/H2OREF(K_JP(I_LAY)+1)
  ELSE
    Z_WCOMB1 = (1.0_JPRB-ETAREF(I_NS))/(STRRAT * CO2REF(K_JP(I_LAY)))
    Z_WCOMB2 = (1.0_JPRB-ETAREF(I_NS))/(STRRAT * CO2REF(K_JP(I_LAY)+1))
  ENDIF
  Z_RATIO = (Z_COLREF1*Z_WCOMB1)+Z_FP*((Z_COLREF2*Z_WCOMB2)-(Z_COLREF1*Z_WCOMB1))
  Z_CURRN2O = Z_SPECCOMB(I_LAY) * Z_RATIO
  Z_N2OMULT(I_LAY) = P_COLN2O(I_LAY) - Z_CURRN2O

  ZFS(I_LAY)=Z_FS
  IJS(I_LAY)=JS

ENDDO

DO I_LAY = K_LAYTROP+1, KLEV

  Z_FS=ZFS(I_LAY)
  JS=IJS(I_LAY)
!---jjm
!  FAC000 = (_ONE_ - FS) * FAC00(LAY)
!  FAC010 = (_ONE_ - FS) * FAC10(LAY)
!  FAC100 = FS * FAC00(LAY)
!  FAC110 = FS * FAC10(LAY)
!  FAC001 = (_ONE_ - FS) * FAC01(LAY)
!  FAC011 = (_ONE_ - FS) * FAC11(LAY)
!  FAC101 = FS * FAC01(LAY)
!  FAC111 = FS * FAC11(LAY)
!---        

  DO IG = 1, NG3
    P_TAU (NGS2+IG,I_LAY) = Z_SPECCOMB(I_LAY) *   &
     !-- DS_000515
     & ( (1. - Z_FS) *(P_FAC00(I_LAY) * ABSB(IND0(I_LAY)  ,IG) +   &
     & P_FAC10(I_LAY) * ABSB(IND0(I_LAY)+5,IG) +   &
     & P_FAC01(I_LAY) * ABSB(IND1(I_LAY)  ,IG) +    &
     & P_FAC11(I_LAY) * ABSB(IND1(I_LAY)+5,IG))+   &
     & Z_FS     *(P_FAC00(I_LAY) * ABSB(IND0(I_LAY)+1,IG) +   &
     & P_FAC10(I_LAY) * ABSB(IND0(I_LAY)+6,IG) +   &
     & P_FAC01(I_LAY) * ABSB(IND1(I_LAY)+1,IG) +   &
     & P_FAC11(I_LAY) * ABSB(IND1(I_LAY)+6,IG)))   &
     !     &(Z_FAC000 * ABSB(IND0(I_LAY)  ,IG) +&
     !     & Z_FAC100 * ABSB(IND0(I_LAY)+1,IG) +&
     !     & Z_FAC010 * ABSB(IND0(I_LAY)+5,IG) +&
     !     & Z_FAC110 * ABSB(IND0(I_LAY)+6,IG) +&
     !     & Z_FAC001 * ABSB(IND1(I_LAY)  ,IG) +&
     !     & Z_FAC101 * ABSB(IND1(I_LAY)+1,IG) +&
     !     & Z_FAC011 * ABSB(IND1(I_LAY)+5,IG) +&
     !     & Z_FAC111 * ABSB(IND1(I_LAY)+6,IG))&
     !-- DS_000515
     & + P_COLH2O(I_LAY)*P_FORFAC(I_LAY)*FORREF(IG) &
     & + Z_N2OMULT(I_LAY) * ABSN2OB(IG)&
     & + P_TAUAERL(I_LAY,3)  
    PFRAC(NGS2+IG,I_LAY) = FRACREFB(IG,JS) + Z_FS *&
     & (FRACREFB(IG,JS+1) - FRACREFB(IG,JS))  
  ENDDO
ENDDO

IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL3',1,ZHOOK_HANDLE)
END SUBROUTINE RRTM_TAUMOL3
