MODULE YOELW

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!     ------------------------------------------------------------------
!*    ** *YOELW* - COEFFICIENTS OF THE LONGWAVE RADIATION TRANSFER
!     ------------------------------------------------------------------

INTEGER(KIND=JPIM) :: MXIXT
INTEGER(KIND=JPIM) :: NSIL
INTEGER(KIND=JPIM) :: NIPD
INTEGER(KIND=JPIM) :: NIPD2
INTEGER(KIND=JPIM) :: NTR
INTEGER(KIND=JPIM) :: NTRA
INTEGER(KIND=JPIM) :: NUA
INTEGER(KIND=JPIM) :: NG1
INTEGER(KIND=JPIM) :: NG1P1
REAL(KIND=JPRB) :: ALWT(8,3)
REAL(KIND=JPRB) :: BLWT(8,3)
REAL(KIND=JPRB) :: PDGA(11,16,3)
REAL(KIND=JPRB) :: PDGB(11,16,3)
REAL(KIND=JPRB) :: RPTYPE(4)
REAL(KIND=JPRB) :: RETYPE(4)
REAL(KIND=JPRB) :: RNTNU(4)
REAL(KIND=JPRB) :: RO1H
REAL(KIND=JPRB) :: RO2H
REAL(KIND=JPRB) :: RO3T(4)
REAL(KIND=JPRB) :: RPIALF0
REAL(KIND=JPRB) :: RT1(2)
REAL(KIND=JPRB) :: TINTP(11)
REAL(KIND=JPRB) :: TREF
REAL(KIND=JPRB) :: TSTAND
REAL(KIND=JPRB) :: TSTP
REAL(KIND=JPRB) :: WG1(2)
REAL(KIND=JPRB) :: XP(6,6)
REAL(KIND=JPRB) :: RVGCO2
REAL(KIND=JPRB) :: RVGH2O
REAL(KIND=JPRB) :: RVGO3

!        * E.C.M.W.F. PHYSICS PACKAGE *

!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : ---------------------------------------------------
!  MXIXT :  INTEGER  MAXIMUM TEMPERATURE INDEX FOR TRANSMISSIVITIES
!  NSIL  :  INTEGER  NUMBER OF SPECTRAL INTERVALS
!  NIPD  :  INTEGER  NUMBER OF BANDS DESCRIBED BY PADE APPROXIMANTS
!  NIPD2 :  INTEGER  NIPD*2
!  NTR   :  INTEGER  NUMBER OF REFERENCE TEMPERATURES
!  NTRA  :  INTEGER  NUMBER OF TRANSMISSION FUNCTIONS
!  NUA   :  INTEGER  NUMBER OF ABSORBER AMOUNTS
!  NG1   :  INTEGER  ORDER OF THE GAUSSIAN QUADRATURE
!  NG1P1 :  INTEGER  NG1+1
!  ALWT  :  REAL     A-TYPE COEFF. FOR TEMPERATURE DEPENDENCE
!  BLWT  :  REAL     B-TYPE COEFF. FOR TEMPERATURE DEPENDENCE
!  RNTNU :  REAL     ABSORPTION COEFFICIENT E-TYPE
!  PDGA  :  REAL     PADE APPROXIMANTS - NUMERATOR
!  PDGB  :  REAL     PADE APPROXIMANTS - DENOMINATOR
!  RPTYPE:  REAL     P-TYPE COEFFICIENTS
!  RETYPE:  REAL     E-TYPE COEFFICIENTS
!  RO1H  :  REAL     K/DELTA 1ST OZONE SUB-INTERVAL
!  RO2H  :  REAL     K/DELTA 2ND OZONE SUB-INTERVAL
!  RO3T  :  REAL     TEMPERATURE DEPENDENCE COEFFICIENTS FOR OZONE
!  RPIALF0: REAL     PI*ALFA0/DELTA OZONE SUB-INTERVALS
!  RT1   :  REAL     ROOTS FOR GAUSSIAN QUADRATURE
!  TINTP :  REAL     TEMPERATURE INTERVALS FOR TRANSMISSIVITIES
!  TREF  :  REAL     REFERENCE TEMPERATURE IN PLANCK FUNCTION POLYNOMIAL
!  TSTAND:  REAL     REFERENCE TEMPERATURE FOR TEMPERATURE DEPENDENCE
!  TSTP  :  REAL     TEMEPERATURE STEP BETWEEN TRANSMISSIVITIES
!  WG1   :  REAL     WEIGHTS FOR GAUSSIAN QUADRATURE
!  XP    :  REAL     POLYNOMIAL COEFFICIENTS OF PLANCK FUNCTION
!  RVGCO2:  REAL     RESIDUAL PRESSURE FOR CO2 VOIGT LINE HALF-WIDTH
!  RVGH2O:  REAL     RESIDUAL PRESSURE FOR H2O VOIGT LINE HALF-WIDTH
!  RVGO3 :  REAL     RESIDUAL PRESSURE FOR O3  VOIGT LINE HALF-WIDTH
!     ------------------------------------------------------------------


!$OMP THREADPRIVATE(alwt,blwt,mxixt,ng1,ng1p1,nipd,nipd2,nsil,ntr,ntra,nua)
!$OMP THREADPRIVATE(pdga,pdgb,retype,rntnu,ro1h,ro2h,ro3t,rpialf0,rptype,rt1)
!$OMP THREADPRIVATE(rvgco2,rvgh2o,rvgo3,tintp,tref,tstand,tstp,wg1,xp)
END MODULE YOELW
