SUBROUTINE bcscav_spl(pdtime,flxr,flxs,alpha_r,alpha_s,x,dx)

  USE dimphy
  USE yomcst_mod_h
  USE yoecumf_mod_h
  USE chem_mod_h
IMPLICIT NONE
  !=====================================================================
  ! Objet : below-cloud scavenging of tracers
  ! Date : september 1999
  ! Auteur: O. Boucher (LOA)
  !=====================================================================

  !
  REAL :: pdtime, alpha_r, alpha_s, R_r, R_s
  PARAMETER (R_r=0.001)          !--mean raindrop radius (m)
  PARAMETER (R_s=0.001)          !--mean snow crystal radius (m)
  REAL :: flxr(klon,klev)         ! liquid precipitation rate (kg/m2/s)
  REAL :: flxs(klon,klev)         ! solid  precipitation rate (kg/m2/s)
  REAL :: flxr_aux(klon,klev+1)
  REAL :: flxs_aux(klon,klev+1)
  REAL :: x(klon,klev)              ! q de traceur
  REAL :: dx(klon,klev)             ! tendance de traceur
  !
  !--variables locales
  INTEGER :: i, k
  REAL :: pr, ps, ice, water
  !
  !------------------------------------------
  !
  ! NHL
  ! Auxiliary variables defined to deal with the fact that precipitation
  ! fluxes are defined on klev levels only.
  ! NHL
  !
  flxr_aux(:,klev+1)=0.0
  flxs_aux(:,klev+1)=0.0
  flxr_aux(:,1:klev)=flxr(:,:)
  flxs_aux(:,1:klev)=flxs(:,:)
  !
  DO k=1, klev
  DO i=1, klon
   pr=0.5*(flxr_aux(i,k)+flxr_aux(i,k+1))
   ps=0.5*(flxs_aux(i,k)+flxs_aux(i,k+1))
   water=pr*alpha_r/R_r/rho_water
   ice=ps*alpha_s/R_s/rho_ice
   dx(i,k)=-3./4.*x(i,k)*pdtime*(water+ice)
  !tmp       dx(i,k)=-3./4.*x(i,k)*pdtime*
  !tmp     .         (pr*alpha_r/R_r/rho_water+ps*alpha_s/R_s/rho_ice)
  ENDDO
  ENDDO
  !
  RETURN
END SUBROUTINE bcscav_spl
