MODULE YOPHNC

IMPLICIT NONE

SAVE

! -------- SWITCHES FOR T-DT TRAJECTORY AND PHYSICS  -------------

! LETRAJP  : TRUE IF STORAGE OF TRAJECTORY AT T-DT
! LETRAJPT : TRUE IF STORAGE OF TRAJECTORY OF PHYS.TENDENCIES
!            FOR ADJOINT

! LERADI2   : TRUE IF RADIATION SCHEME ACTIVATED IN TL AND AD
! LERADS2   : TRUE IF RADIATION AT THE SURFACE ACTIVATED IN TL AND AD
! LERADSW2  : TRUE IF SHORTWAVE RADIATION SCHEME ACTIVATED IN TL AND AD
! LERADN2   : TRUE IF LINEARIZED SW+LW RAD.SCHEMES ACTIVATED IN TL AND AD
! LERADFL2  : TRUE IF FULL LINERAIZED LW = a dF + da F IN TL AND AD
! LEDCLD2   : TRUE IF DIAGNOSTIC CLOUDS ACTIVATED IN TL AND AD
! LENCLD2   : TRUE IF SIMPLE CLOUD SCHEME FOR LINEARIZED MODEL ACTIVATED
! LEVAPLS2  : TRUE IF EVAPORATION OF LARGE SCALE CONDENSATION IN TL/AD
! LEVDIF2   : TRUE IF VERTICAL DIFFUSION ACTIVATED IN TL AND AD
! LEGWDG2   : TRUE IF S.S. OROGRAPHY SCHEME ACTIVATED IN TL AND AD
! LECUMF2   : TRUE IF MASS-FLUX CONVECTION ACTIVATED IN TL AND AD
! LECUBM2   : TRUE IF BETTS-MILLER CONVECTION ACTIVATED IN TL AND AD
! LECOND2   : TRUE IF CONDENSATION SCHEME ACTIVATED IN TL AND AD
! LEQNGT2   : TRUE IF Q<0 REMOVAL SCHEME ACTIVATED IN TL AND AD
! LESURF2   : TRUE IF LAND SURFACE  SCHEME ACTIVATED IN TL AND AD
! LEKPERT   : TRUE IF PERTURBATION OF EXCHANGE COEEFICIENTS
! LTRACLNPH : TRUE IF TRACERS TO BE USED IN LINEARIZED PHYSICS

LOGICAL :: LETRAJP
LOGICAL :: LETRAJPT
LOGICAL :: LERADI2
LOGICAL :: LERADS2
LOGICAL :: LERADSW2
LOGICAL :: LERADN2
LOGICAL :: LERADFL2
LOGICAL :: LEDCLD2
LOGICAL :: LENCLD2
LOGICAL :: LEVAPLS2
LOGICAL :: LEVDIF2
LOGICAL :: LEGWDG2
LOGICAL :: LECUMF2
LOGICAL :: LECUBM2
LOGICAL :: LECOND2
LOGICAL :: LEQNGT2
LOGICAL :: LESURF2
LOGICAL :: LEKPERT
LOGICAL :: LTRACLNPH

!     ------------------------------------------------------------------
!$OMP THREADPRIVATE(lecond2,lecubm2,lecumf2,ledcld2,legwdg2,lekpert,lencld2,leqngt2,leradfl2,leradi2)
!$OMP THREADPRIVATE(leradn2,lerads2,leradsw2,lesurf2,letrajp,letrajpt,levapls2,levdif2,ltraclnph)
END MODULE YOPHNC
