!$gpum horizontal klon ngrid
module lmdz_call_blowing_snow

contains

subroutine call_blowing_snow_sublim_sedim(ngrid,nlay,dtime,ustar,temp,q,qbs,pplay,paprs, &
                                  dtemp_bs,dq_bs,dqbs_bs,bsfl,precip_bs)

use lmdz_blowing_snow_sublim_sedim, only : blowing_snow_sublim_sedim
implicit none

!INPUT
!=====

integer, intent(in)                     :: ngrid,nlay
real, intent(in)                        :: dtime
real, intent(in), dimension(ngrid)      :: ustar
real, intent(in), dimension(ngrid,nlay) :: temp
real, intent(in), dimension(ngrid,nlay) :: q
real, intent(in), dimension(ngrid,nlay) :: qbs
real, intent(in), dimension(ngrid,nlay) :: pplay
real, intent(in), dimension(ngrid,nlay+1) :: paprs


! OUTPUT
!========


real, intent(out), dimension(ngrid,nlay) :: dtemp_bs
real, intent(out), dimension(ngrid,nlay) :: dq_bs
real, intent(out), dimension(ngrid,nlay) :: dqbs_bs
real, intent(out), dimension(ngrid,nlay+1) :: bsfl
real, intent(out), dimension(ngrid)      :: precip_bs

      


call blowing_snow_sublim_sedim(ngrid,nlay,dtime,ustar,temp,q,qbs,pplay,paprs, &
                                  dtemp_bs,dq_bs,dqbs_bs,bsfl,precip_bs)





end subroutine call_blowing_snow_sublim_sedim

end module lmdz_call_blowing_snow
