MODULE yamada_ini_mod

! AFAIRE : frif defini deux fois.
! peut on passer une fonction du module au code.

implicit none

  LOGICAL :: new_yamada4
  INTEGER :: yamada4_num
  !$OMP THREADPRIVATE(new_yamada4,yamada4_num)
  LOGICAL :: hboville=.TRUE.
  REAL :: viscom,viscoh,pbl_lmixmin_alpha
  !$OMP THREADPRIVATE( hboville,viscom,viscoh,pbl_lmixmin_alpha)
  real :: ric, yun,ydeux,lmixmin,b1,kap,kapb
  !$OMP THREADPRIVATE(ric, yun,ydeux,lmixmin,b1,kap,kapb)
  integer :: iflag_vdif_q2
  !$OMP THREADPRIVATE(iflag_vdif_q2)

  real, dimension(:), allocatable, save :: l0
  !$OMP THREADPRIVATE(l0)
  integer :: lunout,prt_level
  !$OMP THREADPRIVATE(lunout,prt_level)


CONTAINS

SUBROUTINE yamada_ini(klon,lunout_in,prt_level_in)

   USE ioipsl_getin_p_mod, ONLY : getin_p

! local
  integer, intent(in) :: klon,lunout_in,prt_level_in
  real :: ric0
  real frif,falpha,fsm,ri

  lunout=lunout_in
  prt_level=prt_level_in

  b1=16.6
  kap=0.4
  kapb=0.4

    ALLOCATE (l0(klon))

   new_yamada4=.false.
   CALL getin_p('new_yamada4',new_yamada4)

   iflag_vdif_q2=1
   CALL getin_p('iflag_vdif_q2',iflag_vdif_q2)


    IF (new_yamada4) THEN
! Corrections et reglages issus du travail de these d'Etienne Vignon.
       ric=0.143 ! qui donne des valeurs proches des seuils proposes
                 ! dans YAMADA 1983 : sm=0.0845 (0.085 dans Y83)
                 !                    sm=1.1213 (1.12  dans Y83)

       CALL getin_p('yamada4_ric',ric)
       ric0=0.19489      ! ric=0.195 originalement, mais produisait sm<0
       ric=min(ric,ric0) ! Au dela de ric0, sm devient n??gatif
       yun=1.
       ydeux=2.
       hboville=.FALSE.
       viscom=1.46E-5
       viscoh=2.06E-5
       !lmixmin=1.0E-3
       lmixmin=0.
       yamada4_num=5
    ELSE
       ric=0.195
       yun=2.
       ydeux=1.
       hboville=.TRUE.
       viscom=0.
       viscoh=0.
       lmixmin=1.
       yamada4_num=0
    ENDIF


!    WRITE(lunout,*)'YAMADA4 RIc, RIfc, Sm_min, Alpha_min',ric,rifc,seuilsm,seuilalpha
    CALL getin_p('lmixmin',lmixmin)
    CALL getin_p('yamada4_hboville',hboville)
    CALL getin_p('yamada4_num',yamada4_num)
    pbl_lmixmin_alpha=0.0
    CALL getin_p('pbl_lmixmin_alpha',pbl_lmixmin_alpha)


   
 RETURN

END SUBROUTINE yamada_ini

END MODULE yamada_ini_mod
