SUBROUTINE SURRTFTR

!     Adapted from Eli J. Mlawer, Atmospheric & Environmental Research.
!     by JJMorcrette, ECMWF
!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOERRTFTR, ONLY : NGC      ,NGS      ,NGN      ,NGB       ,NGM     , WT

!     ------------------------------------------------------------------

IMPLICIT NONE
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SURRTFTR',0,ZHOOK_HANDLE)
NGC( :) = (/8, 14, 16, 14, 16, 8, 12, 8, 12, 6, 8, 8, 4, 2, 2, 2 /)

NGS( :) = (/&
 & 8,  22,  38,  52,  68,  76,  88,  96, &
 & 108, 114, 122, 130, 134, 136, 138, 140/)  
NGM( :) = (/&
 & 1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,             &! Band 1
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,13,14,14,      &! Band 2
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,      &! Band 3
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,14,14,      &! Band 4
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,      &! Band 5
 & 1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,             &! Band 6
 & 1,1,2,2,3,4,5,6,7,8,9,10,11,11,12,12,        &! Band 7
 & 1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,             &! Band 8
 & 1,2,3,4,5,6,7,8,9,9,10,10,11,11,12,12,       &! Band 9
 & 1,1,2,2,3,3,4,4,5,5,5,5,6,6,6,6,             &! Band 10
 & 1,2,3,3,4,4,5,5,6,6,7,7,7,8,8,8,             &! Band 11
 & 1,2,3,4,5,5,6,6,7,7,7,7,8,8,8,8,             &! Band 12
 & 1,1,1,2,2,2,3,3,3,3,4,4,4,4,4,4,             &! Band 13
 & 1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,             &! Band 14
 & 1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,             &! Band 15
 & 1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2/)             ! Band 16  

NGN( :) = (/&
 & 2,2,2,2,2,2,2,2,                             &! Band 1
 & 1,1,1,1,1,1,1,1,1,1,1,1,2,2,                 &! Band 2
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 3
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,3,                 &! Band 4
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 5
 & 2,2,2,2,2,2,2,2,                             &! Band 6
 & 2,2,1,1,1,1,1,1,1,1,2,2,                     &! Band 7
 & 2,2,2,2,2,2,2,2,                             &! Band 8
 & 1,1,1,1,1,1,1,1,2,2,2,2,                     &! Band 9
 & 2,2,2,2,4,4,                                 &! Band 10
 & 1,1,2,2,2,2,3,3,                             &! Band 11
 & 1,1,1,1,2,2,4,4,                             &! Band 12
 & 3,3,4,6,                                     &! Band 13
 & 8,8,                                         &! Band 14
 & 8,8,                                         &! Band 15
 & 8,8/)                                         ! Band 16  

NGB( :) = (/&
 & 1,1,1,1,1,1,1,1,                            &! Band 1
 & 2,2,2,2,2,2,2,2,2,2,2,2,2,2,                &! Band 2
 & 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,            &! Band 3
 & 4,4,4,4,4,4,4,4,4,4,4,4,4,4,                &! Band 4
 & 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,            &! Band 5
 & 6,6,6,6,6,6,6,6,                            &! Band 6
 & 7,7,7,7,7,7,7,7,7,7,7,7,                    &! Band 7
 & 8,8,8,8,8,8,8,8,                            &! Band 8
 & 9,9,9,9,9,9,9,9,9,9,9,9,                    &! Band 9
 & 10,10,10,10,10,10,                           &! Band 10
 & 11,11,11,11,11,11,11,11,                     &! Band 11
 & 12,12,12,12,12,12,12,12,                     &! Band 12
 & 13,13,13,13,                                 &! Band 13
 & 14,14,                                       &! Band 14
 & 15,15,                                       &! Band 15
 & 16,16/)                                     ! Band 16  

WT( :) = (/&
 & 0.1527534276_JPRB,0.1491729617_JPRB,0.1420961469_JPRB,0.1316886544_JPRB,&
 & 0.1181945205_JPRB,0.1019300893_JPRB,0.0832767040_JPRB,0.0626720116_JPRB,&
 & 0.0424925_JPRB   ,0.0046269894_JPRB,0.0038279891_JPRB,0.0030260086_JPRB,&
 & 0.0022199750_JPRB,0.0014140010_JPRB,0.000533_JPRB    ,0.000075_JPRB    /)  

!     -----------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('SURRTFTR',1,ZHOOK_HANDLE)
END SUBROUTINE SURRTFTR
