SUBROUTINE SURRTFTR

!     Adapted from Eli J. Mlawer, Atmospheric & Environmental Research.
!     by JJMorcrette, ECMWF
!
!     JJMorcrette 20110613 flexible number of g-points
!     ABozzo 201306 updated to rrtmg v4.85
!
!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPIM ,   JPRB
USE YOMHOOK   ,ONLY : LHOOK, DR_HOOK, JPHOOK

!USE PARRRTM   ,ONLY : JPBAND  ,JPG
USE YOERRTFTR ,ONLY : NGC     ,NGS      ,NGN      ,NGB       ,NGM     , WT
!USE YOERAD    ,ONLY : NREDGLW
USE YOERRTM   ,ONLY : JPGPT
!USE YOERRTM   ,ONLY : JPGPT, &
!                    & NG1 , NG2 , NG3 , NG4 , NG5 , NG6 , NG7 , NG8 ,&
!                    & NG9 , NG10, NG11, NG12, NG13, NG14, NG15, NG16,&
!                    & NGS1, NGS2, NGS3, NGS4, NGS5, NGS6, NGS7, NGS8,&
!                    & NGS9, NGS10,NGS11,NGS12,NGS13,NGS14,NGS15,NGS16
!
!     ------------------------------------------------------------------

IMPLICIT NONE

!INTEGER(KIND=JPIM) :: KGC(16), KGS(16), KGM(256), KGN(JPGPT), KGB(JPGPT)
!!INTEGER(KIND=JPIM) :: KGC(JPG), KGS(JPG), KGM(JPG*JPBAND), KGN(JPGPT), KGB(JPGPT)

INTEGER(KIND=JPIM) :: IGC70(16) , IGC140(16) , IGC256(16)
INTEGER(KIND=JPIM) :: IGS70(16) , IGS140(16) , IGS256(16)

INTEGER(KIND=JPIM) :: IGM70(256), IGM140(256), IGM256(256)

INTEGER(KIND=JPIM) :: IGN70(70) , IGN140(140), IGN256(256)
INTEGER(KIND=JPIM) :: IGB70(70) , IGB140(140), IGB256(256)

REAL(KIND=JPHOOK) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SURRTFTR',0,ZHOOK_HANDLE)

!-------------------------------------------------------------------------------
!-- configuration for EPS with 70 g-points

IGC70( :) = (/4,  7,  8,  7,  8, 4,  6, 4,  6, 3, 4, 4, 2, 1, 1, 1 /)

IGS70(:) = (/  4, 11,  19,  26,  34,  38,  44,  48, &
            & 54, 57,  61,  65,  67,  68,  69,  70 /)
   
IGM70(:) = (/&
 & 1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,             &! Band 1
 & 1,1,2,2,3,3,4,4,5,5,6,6,7,7,7,7,             &! Band 2
 & 1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,             &! Band 3
 & 1,1,2,2,3,3,4,4,5,5,6,6,7,7,7,7,             &! Band 4
 & 1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,             &! Band 5
 & 1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,             &! Band 6
 & 1,1,1,1,2,2,3,3,4,4,5,5,6,6,6,6,             &! Band 7
 & 1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,             &! Band 8
 & 1,1,2,2,3,3,4,4,5,5,5,5,6,6,6,6,             &! Band 9
 & 1,1,1,1,2,2,2,2,3,3,3,3,3,3,3,3,             &! Band 10
 & 1,1,2,2,2,2,3,3,3,3,4,4,4,4,4,4,             &! Band 11
 & 1,1,2,2,3,3,3,3,4,4,4,4,4,4,4,4,             &! Band 12
 & 1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,             &! Band 13
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 14
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 15
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1/)             ! Band 16  

IGN70(:) = (/&
 & 4,4,4,4,                                     &! Band 1
 & 2,2,2,2,2,2,4,                               &! Band 2
 & 2,2,2,2,2,2,2,2,                             &! Band 3
 & 2,2,2,2,2,2,4,                               &! Band 4
 & 2,2,2,2,2,2,2,2,                             &! Band 5
 & 4,4,4,4,                                     &! Band 6
 & 4,2,2,2,2,4,                                 &! Band 7
 & 4,4,4,4,                                     &! Band 8
 & 2,2,2,2,4,4,                                 &! Band 9
 & 4,4,8,                                       &! Band 10
 & 2,4,4,6,                                     &! Band 11
 & 2,2,4,8,                                     &! Band 12
 & 6,10,                                        &! Band 13
 & 16,                                          &! Band 14
 & 16,                                          &! Band 15
 & 16/)                                          ! Band 16  

IGB70(:) = (/&
 & 1,1,1,1,                                      &! Band 1
 & 2,2,2,2,2,2,2,                                &! Band 2
 & 3,3,3,3,3,3,3,3,                              &! Band 3
 & 4,4,4,4,4,4,4,                                &! Band 4
 & 5,5,5,5,5,5,5,5,                              &! Band 5
 & 6,6,6,6,                                      &! Band 6
 & 7,7,7,7,7,7,                                  &! Band 7
 & 8,8,8,8,                                      &! Band 8
 & 9,9,9,9,9,9,                                  &! Band 9
 & 10,10,10,                                     &! Band 10
 & 11,11,11,11,                                  &! Band 11
 & 12,12,12,12,                                  &! Band 12
 & 13,13,                                        &! Band 13
 & 14,                                           &! Band 14
 & 15,                                           &! Band 15
 & 16/)                                           ! Band 16  


!------------------------------------------------------------------------------
!-- configuration with 140 g-points

IGC140(:) = (/10, 12, 16, 14, 16, 8, 12, 8, 12, 6, 8, 8, 4, 2, 2, 2 /)

IGS140(:) = (/  10,  22,  38,  52,  68,  76,  88,  96, &
            & 108, 114, 122, 130, 134, 136, 138, 140 /)  

IGM140(:) = (/&
 & 1,2,3,3,4,4,5,5,6,6,7,7,8,8,9,10,            &! Band 1
 & 1,2,3,4,5,6,7,8,9,9,10,10,11,11,12,12,       &! Band 2
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,      &! Band 3
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,14,14,      &! Band 4
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,      &! Band 5
 & 1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,             &! Band 6
 & 1,1,2,2,3,4,5,6,7,8,9,10,11,11,12,12,        &! Band 7
 & 1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,             &! Band 8
 & 1,2,3,4,5,6,7,8,9,9,10,10,11,11,12,12,       &! Band 9
 & 1,1,2,2,3,3,4,4,5,5,5,5,6,6,6,6,             &! Band 10
 & 1,2,3,3,4,4,5,5,6,6,7,7,7,8,8,8,             &! Band 11
 & 1,2,3,4,5,5,6,6,7,7,7,7,8,8,8,8,             &! Band 12
 & 1,1,1,2,2,2,3,3,3,3,4,4,4,4,4,4,             &! Band 13
 & 1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,             &! Band 14
 & 1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,             &! Band 15
 & 1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2/)             ! Band 16  

IGN140(:) = (/&
 & 1,1,2,2,2,2,2,2,1,1,                         &! Band 1
 & 1,1,1,1,1,1,1,1,2,2,2,2,                     &! Band 2
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 3
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,3,                 &! Band 4
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 5
 & 2,2,2,2,2,2,2,2,                             &! Band 6
 & 2,2,1,1,1,1,1,1,1,1,2,2,                     &! Band 7
 & 2,2,2,2,2,2,2,2,                             &! Band 8
 & 1,1,1,1,1,1,1,1,2,2,2,2,                     &! Band 9
 & 2,2,2,2,4,4,                                 &! Band 10
 & 1,1,2,2,2,2,3,3,                             &! Band 11
 & 1,1,1,1,2,2,4,4,                             &! Band 12
 & 3,3,4,6,                                     &! Band 13
 & 8,8,                                         &! Band 14
 & 8,8,                                         &! Band 15
 & 4,12/)                                         ! Band 16  

IGB140( :) = (/&
 & 1,1,1,1,1,1,1,1,1,1,                         &! Band 1
 & 2,2,2,2,2,2,2,2,2,2,2,2,                     &! Band 2
 & 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,             &! Band 3
 & 4,4,4,4,4,4,4,4,4,4,4,4,4,4,                 &! Band 4
 & 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,             &! Band 5
 & 6,6,6,6,6,6,6,6,                             &! Band 6
 & 7,7,7,7,7,7,7,7,7,7,7,7,                     &! Band 7
 & 8,8,8,8,8,8,8,8,                             &! Band 8
 & 9,9,9,9,9,9,9,9,9,9,9,9,                     &! Band 9
 & 10,10,10,10,10,10,                           &! Band 10
 & 11,11,11,11,11,11,11,11,                     &! Band 11
 & 12,12,12,12,12,12,12,12,                     &! Band 12
 & 13,13,13,13,                                 &! Band 13
 & 14,14,                                       &! Band 14
 & 15,15,                                       &! Band 15
 & 16,16/)                                       ! Band 16  



!------------------------------------------------------------------------------
!-- configuration with 256 g-points

IGC256(:) = (/16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16 /)

IGS256(:) = (/ 16,  32,  48,  64,  80,  96, 112, 128, &
            & 144, 160, 176, 192, 208, 224, 240, 256 /)  

IGM256(:) = (/&
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,      &! Band 1
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,13,14,14,      &! Band 2
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,      &! Band 3
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,      &! Band 4
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,      &! Band 5
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,      &! Band 6
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,      &! Band 7
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,13,14,14,      &! Band 8
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,      &! Band 9
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,      &! Band 10
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,      &! Band 11
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,      &! Band 12
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,      &! Band 13
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,      &! Band 14
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,      &! Band 15
 & 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16 /)     ! Band 16

IGN256(:) = (/&
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 1
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 2
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 3
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 4
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 5
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 6
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 7
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 8
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 9
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 10
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 11
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 12
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 13
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 14
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 15
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 /)            ! Band 16

IGB256( :) = (/&
 & 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,             &! Band 1
 & 2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,             &! Band 2
 & 3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,             &! Band 3
 & 4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,             &! Band 4
 & 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,             &! Band 5
 & 6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,             &! Band 6
 & 7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,             &! Band 7
 & 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,             &! Band 8
 & 9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,             &! Band 9
 & 10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10, &! Band 10
 & 11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11, &! Band 11
 & 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12, &! Band 12
 & 13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13, &! Band 13
 & 14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14, &! Band 14
 & 15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15, &! Band 15
 & 16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16/) ! Band 16  

!-------------------------------------------------------------------------------
!
WT( :) = (/&
 & 0.1527534276_JPRB,0.1491729617_JPRB,0.1420961469_JPRB,0.1316886544_JPRB,&
 & 0.1181945205_JPRB,0.1019300893_JPRB,0.0832767040_JPRB,0.0626720116_JPRB,&
 & 0.0424925_JPRB   ,0.0046269894_JPRB,0.0038279891_JPRB,0.0030260086_JPRB,&
 & 0.0022199750_JPRB,0.0014140010_JPRB,0.000533_JPRB    ,0.000075_JPRB    /)  

!-------------------------------------------------------------------------------

IF (JPGPT == 70) THEN

!-- 16
  NGC(:)=IGC70(:)
  NGS(:)=IGS70(:)

!-- 16*16=256
  NGM(:)=IGM70(:)

  NGN(1:70)=IGN70(1:70)
  NGB(1:70)=IGB70(1:70)

ELSEIF (JPGPT == 140) THEN
!- 16
  NGC(:)=IGC140(:)
  NGS(:)=IGS140(:)

!- 16*16=256
  NGM(:)=IGM140(:)

  NGN(1:140)=IGN140(1:140)
  NGB(1:140)=IGB140(1:140)

ELSEIF (JPGPT == 256) THEN
!- 16
  NGC(:)=IGC256(:)
  NGS(:)=IGS256(:)

!- 16*16=256
  NGM(:)=IGM256(:)

  NGN(1:256)=IGN256(1:256)
  NGB(1:256)=IGB256(1:256)

ENDIF
   
!     -----------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('SURRTFTR',1,ZHOOK_HANDLE)
END SUBROUTINE SURRTFTR
