SUBROUTINE SRTM_CMBGB29

!     BAND 29:  820-2600 cm-1 (low - H2O; high - CO2)
!-----------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPIM , JPRB
USE YOMHOOK   ,ONLY : LHOOK, DR_HOOK

USE YOESRTWN , ONLY : NGC, NGS, NGN, RWGT
USE YOESRTA29, ONLY : KA, KB, SELFREF, FORREF, SFLUXREF, &
                    & ABSH2O, ABSCO2, &
                    & KAC, KBC, SELFREFC, FORREFC, SFLUXREFC, &
                    & ABSH2OC, ABSCO2C

IMPLICIT NONE

! Local variables
INTEGER(KIND=JPIM) :: JT, JP, IGC, IPR, IPRSM
REAL(KIND=JPRB)    :: ZSUMK, ZSUMF1, ZSUMF2, ZSUMF3

REAL(KIND=JPRB) :: ZHOOK_HANDLE
!     ------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('SRTM_CMBGB29',0,ZHOOK_HANDLE)

DO JT = 1,5
  DO JP = 1,13
    IPRSM = 0
    DO IGC = 1,NGC(14)
      ZSUMK = 0.
      DO IPR = 1, NGN(NGS(13)+IGC)
        IPRSM = IPRSM + 1
        ZSUMK = ZSUMK + KA(JT,JP,IPRSM)*RWGT(IPRSM+208)
      ENDDO
      KAC(JT,JP,IGC) = ZSUMK
    ENDDO
  ENDDO

  DO JP = 13,59
    IPRSM = 0
    DO IGC = 1,NGC(14)
      ZSUMK = 0.
      DO IPR = 1, NGN(NGS(13)+IGC)
        IPRSM = IPRSM + 1
        ZSUMK = ZSUMK + KB(JT,JP,IPRSM)*RWGT(IPRSM+208)
      ENDDO
      KBC(JT,JP,IGC) = ZSUMK
    ENDDO
  ENDDO
ENDDO

DO JT = 1,10
  IPRSM = 0
  DO IGC = 1,NGC(14)
    ZSUMK = 0.
    DO IPR = 1, NGN(NGS(13)+IGC)
      IPRSM = IPRSM + 1
      ZSUMK = ZSUMK + SELFREF(JT,IPRSM)*RWGT(IPRSM+208)
    ENDDO
    SELFREFC(JT,IGC) = ZSUMK
  ENDDO
ENDDO

DO JT = 1,4
  IPRSM = 0
  DO IGC = 1,NGC(14)
    ZSUMK = 0.
    DO IPR = 1, NGN(NGS(13)+IGC)
      IPRSM = IPRSM + 1
      ZSUMK = ZSUMK + FORREF(JT,IPRSM)*RWGT(IPRSM+208)
    ENDDO
    FORREFC(JT,IGC) = ZSUMK
  ENDDO
ENDDO

IPRSM = 0
DO IGC = 1,NGC(14)
  ZSUMF1 = 0.
  ZSUMF2 = 0.
  ZSUMF3 = 0.
  DO IPR = 1, NGN(NGS(13)+IGC)
    IPRSM = IPRSM + 1
    ZSUMF1 = ZSUMF1 + SFLUXREF(IPRSM)
    ZSUMF2 = ZSUMF2 + ABSCO2(IPRSM)*RWGT(IPRSM+208)
    ZSUMF3 = ZSUMF3 + ABSH2O(IPRSM)*RWGT(IPRSM+208)
  ENDDO
  SFLUXREFC(IGC) = ZSUMF1
  ABSCO2C(IGC) = ZSUMF2
  ABSH2OC(IGC) = ZSUMF3
ENDDO

!     -----------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('SRTM_CMBGB29',1,ZHOOK_HANDLE)
END SUBROUTINE SRTM_CMBGB29

