!
! $Header$
!
SUBROUTINE laplacien_gam ( klevel, cuvsga, cvusga, unsaigam , &
        unsapolnga, unsapolsga, teta, divgra )

  !  P. Le Van
  !
  !   ************************************************************
  !
  !  ....   calcul de  (div( grad ))   de   teta  .....
  !   ************************************************************
  !    klevel et teta  sont des arguments  d'entree pour le s-prog
  !  divgra     est  un argument  de sortie pour le s-prog
  !
  USE comgeom_mod_h
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h
IMPLICIT NONE
  !



  !
  !    ............     variables  en arguments    ..........
  !
  INTEGER :: klevel
  REAL :: teta( ip1jmp1,klevel ), divgra( ip1jmp1,klevel )
  REAL :: cuvsga(ip1jm) , cvusga( ip1jmp1 ),unsaigam(ip1jmp1), &
        unsapolnga, unsapolsga
  !
  !    ...........    variables  locales    .................
  !
  REAL :: ghy(ip1jm,llm), ghx(ip1jmp1,llm)
  !    ......................................................

  !
  !
  !   ...  cvuscugam  = ( cvu/ cu ) ** (- gamdissip )
  !   ...  cuvscvgam  = ( cuv/ cv ) ** (- gamdissip )  calcules dans inigeom  ..
  !   ...  unsairegam =  1. /  aire ** (- gamdissip )
  !

  CALL SCOPY ( ip1jmp1 * klevel, teta, 1, divgra, 1 )
  !
  CALL   grad ( klevel, divgra, ghx, ghy )
  !
  CALL  diverg_gam ( klevel, cuvsga, cvusga,  unsaigam  , &
        unsapolnga, unsapolsga, ghx , ghy , divgra )

  !


  RETURN
END SUBROUTINE laplacien_gam
