!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif 
!pgi$r opt=0
SUBROUTINE SRTM_KGB28

!     Originally by J.Delamere, Atmospheric & Environmental Research.
!     Revision: 2.4
!     BAND 28: 38000-50000 cm-1 (low - O3,O2; high - O3,O2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOESRTA28, ONLY : KA, KB, SFLUXREF, RAYL, STRRAT &
 & , LAYREFFR  

!     ------------------------------------------------------------------

IMPLICIT NONE

! KURUCZ
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28',0,ZHOOK_HANDLE)

CALL PART1
CALL PART2
CALL PART3
CALL PART4
CALL PART5
CALL PART6
CALL PART7
CALL PART8
CALL PART9
CALL PART10
CALL PART11
CALL PART12
CALL PART13
CALL PART14
CALL PART15
CALL PART16
CALL PART17
CALL PART18
CALL PART19
CALL PART20
CALL PART21
CALL PART22
CALL PART23
CALL PART24
CALL PART25
CALL PART26
CALL PART27
CALL PART28
CALL PART29
CALL PART30
CALL PART31
CALL PART32
CALL PART33
CALL PART34
CALL PART35
CALL PART36
CALL PART37

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28',1,ZHOOK_HANDLE)

!     -----------------------------------------------------------------

CONTAINS


SUBROUTINE PART1

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART1',0,ZHOOK_HANDLE)


SFLUXREF(:,1) = (/ &
 & 1.06156_JPRB    , 0.599910_JPRB   , 0.422462_JPRB   , 0.400077_JPRB   , &
 & 0.282221_JPRB   , 0.187893_JPRB   , 6.77357E-02_JPRB, 3.04572E-02_JPRB, &
 & 2.00442E-02_JPRB, 2.30786E-03_JPRB, 2.08824E-03_JPRB, 1.42604E-03_JPRB, &
 & 9.67384E-04_JPRB, 6.35362E-04_JPRB, 1.47727E-04_JPRB, 6.87639E-06_JPRB /)  
SFLUXREF(:,2) = (/ &
 & 1.07598_JPRB    , 0.585099_JPRB   , 0.422852_JPRB   , 0.400077_JPRB   , &
 & 0.282221_JPRB   , 0.187893_JPRB   , 6.69686E-02_JPRB, 3.09070E-02_JPRB, &
 & 2.02400E-02_JPRB, 2.47760E-03_JPRB, 1.89411E-03_JPRB, 1.41122E-03_JPRB, &
 & 1.12449E-03_JPRB, 5.73505E-04_JPRB, 2.04160E-04_JPRB, 1.58371E-05_JPRB /)  
SFLUXREF(:,3) = (/ &
 & 0.461647_JPRB   , 0.406113_JPRB   , 0.332506_JPRB   , 0.307508_JPRB   , &
 & 0.211167_JPRB   , 0.235457_JPRB   , 0.495886_JPRB   , 0.363921_JPRB   , &
 & 0.192700_JPRB   , 2.04678E-02_JPRB, 1.55407E-02_JPRB, 1.03882E-02_JPRB, &
 & 1.10778E-02_JPRB, 1.00504E-02_JPRB, 4.93497E-03_JPRB, 5.73410E-04_JPRB /)  
SFLUXREF(:,4) = (/ &
 & 0.132669_JPRB   , 0.175058_JPRB   , 0.359263_JPRB   , 0.388142_JPRB   , &
 & 0.350359_JPRB   , 0.475892_JPRB   , 0.489593_JPRB   , 0.408437_JPRB   , &
 & 0.221049_JPRB   , 1.94514E-02_JPRB, 1.54848E-02_JPRB, 1.44999E-02_JPRB, &
 & 1.44568E-02_JPRB, 1.00527E-02_JPRB, 4.95897E-03_JPRB, 5.73327E-04_JPRB /)  
SFLUXREF(:,5) = (/ &
 & 7.54800E-02_JPRB, 0.232246_JPRB   , 0.359263_JPRB   , 0.388142_JPRB   , &
 & 0.350359_JPRB   , 0.426317_JPRB   , 0.493485_JPRB   , 0.432016_JPRB   , &
 & 0.239203_JPRB   , 1.74951E-02_JPRB, 1.74477E-02_JPRB, 1.83566E-02_JPRB, &
 & 1.44818E-02_JPRB, 1.01048E-02_JPRB, 4.97487E-03_JPRB, 5.66831E-04_JPRB /)  

!     Rayleigh extinction coefficient at v = ????? cm-1.
RAYL = 2.02E-05_JPRB

STRRAT = 6.67029E-07_JPRB

LAYREFFR = 58

!     ------------------------------------------------------------------

!     The array KA contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KA(:, 1, 1, 1) = (/ &
 & 0.46447E+02_JPRB,0.18001E+03_JPRB,0.31338E+03_JPRB,0.44652E+03_JPRB,0.54636E+03_JPRB, &
 & 0.54173E+03_JPRB,0.45707E+03_JPRB,0.27363E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 2, 1, 1) = (/ &
 & 0.45270E+02_JPRB,0.17886E+03_JPRB,0.31225E+03_JPRB,0.44541E+03_JPRB,0.54177E+03_JPRB, &
 & 0.53436E+03_JPRB,0.44932E+03_JPRB,0.26748E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 3, 1, 1) = (/ &
 & 0.44214E+02_JPRB,0.17776E+03_JPRB,0.31115E+03_JPRB,0.44427E+03_JPRB,0.53733E+03_JPRB, &
 & 0.52756E+03_JPRB,0.44224E+03_JPRB,0.26195E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 4, 1, 1) = (/ &
 & 0.43259E+02_JPRB,0.17673E+03_JPRB,0.31005E+03_JPRB,0.44305E+03_JPRB,0.53298E+03_JPRB, &
 & 0.52129E+03_JPRB,0.43574E+03_JPRB,0.25696E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 5, 1, 1) = (/ &
 & 0.42393E+02_JPRB,0.17575E+03_JPRB,0.30896E+03_JPRB,0.44173E+03_JPRB,0.52883E+03_JPRB, &
 & 0.51548E+03_JPRB,0.42976E+03_JPRB,0.25242E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 1, 2, 1) = (/ &
 & 0.42908E+02_JPRB,0.17695E+03_JPRB,0.31077E+03_JPRB,0.44434E+03_JPRB,0.53161E+03_JPRB, &
 & 0.51895E+03_JPRB,0.43332E+03_JPRB,0.25512E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 2, 2, 1) = (/ &
 & 0.41899E+02_JPRB,0.17596E+03_JPRB,0.30980E+03_JPRB,0.44336E+03_JPRB,0.52686E+03_JPRB, &
 & 0.51213E+03_JPRB,0.42632E+03_JPRB,0.24984E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 3, 2, 1) = (/ &
 & 0.40995E+02_JPRB,0.17502E+03_JPRB,0.30884E+03_JPRB,0.44232E+03_JPRB,0.52230E+03_JPRB, &
 & 0.50592E+03_JPRB,0.41995E+03_JPRB,0.24511E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 4, 2, 1) = (/ &
 & 0.40181E+02_JPRB,0.17412E+03_JPRB,0.30788E+03_JPRB,0.44119E+03_JPRB,0.51785E+03_JPRB, &
 & 0.50025E+03_JPRB,0.41414E+03_JPRB,0.24085E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 5, 2, 1) = (/ &
 & 0.39443E+02_JPRB,0.17326E+03_JPRB,0.30691E+03_JPRB,0.43992E+03_JPRB,0.51364E+03_JPRB, &
 & 0.49503E+03_JPRB,0.40882E+03_JPRB,0.23699E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 1, 3, 1) = (/ &
 & 0.40126E+02_JPRB,0.17457E+03_JPRB,0.30876E+03_JPRB,0.44248E+03_JPRB,0.51755E+03_JPRB, &
 & 0.49986E+03_JPRB,0.41375E+03_JPRB,0.24056E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 2, 3, 1) = (/ &
 & 0.39240E+02_JPRB,0.17370E+03_JPRB,0.30792E+03_JPRB,0.44146E+03_JPRB,0.51254E+03_JPRB, &
 & 0.49358E+03_JPRB,0.40735E+03_JPRB,0.23593E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 3, 3, 1) = (/ &
 & 0.38450E+02_JPRB,0.17288E+03_JPRB,0.30708E+03_JPRB,0.44031E+03_JPRB,0.50793E+03_JPRB, &
 & 0.48786E+03_JPRB,0.40155E+03_JPRB,0.23179E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 4, 3, 1) = (/ &
 & 0.37740E+02_JPRB,0.17210E+03_JPRB,0.30624E+03_JPRB,0.43908E+03_JPRB,0.50368E+03_JPRB, &
 & 0.48264E+03_JPRB,0.39629E+03_JPRB,0.22808E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 5, 3, 1) = (/ &
 & 0.37099E+02_JPRB,0.17134E+03_JPRB,0.30539E+03_JPRB,0.43781E+03_JPRB,0.49975E+03_JPRB, &
 & 0.47787E+03_JPRB,0.39149E+03_JPRB,0.22473E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 1, 4, 1) = (/ &
 & 0.37818E+02_JPRB,0.17258E+03_JPRB,0.30708E+03_JPRB,0.43967E+03_JPRB,0.50412E+03_JPRB, &
 & 0.48321E+03_JPRB,0.39687E+03_JPRB,0.22848E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 2, 4, 1) = (/ &
 & 0.37034E+02_JPRB,0.17183E+03_JPRB,0.30636E+03_JPRB,0.43833E+03_JPRB,0.49935E+03_JPRB, &
 & 0.47738E+03_JPRB,0.39100E+03_JPRB,0.22439E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 3, 4, 1) = (/ &
 & 0.36338E+02_JPRB,0.17111E+03_JPRB,0.30564E+03_JPRB,0.43700E+03_JPRB,0.49496E+03_JPRB, &
 & 0.47212E+03_JPRB,0.38572E+03_JPRB,0.22075E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 4, 4, 1) = (/ &
 & 0.35716E+02_JPRB,0.17043E+03_JPRB,0.30491E+03_JPRB,0.43569E+03_JPRB,0.49094E+03_JPRB, &
 & 0.46732E+03_JPRB,0.38094E+03_JPRB,0.21749E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 5, 4, 1) = (/ &
 & 0.35156E+02_JPRB,0.16977E+03_JPRB,0.30416E+03_JPRB,0.43437E+03_JPRB,0.48726E+03_JPRB, &
 & 0.46294E+03_JPRB,0.37660E+03_JPRB,0.21456E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 1, 5, 1) = (/ &
 & 0.35857E+02_JPRB,0.17089E+03_JPRB,0.30563E+03_JPRB,0.43619E+03_JPRB,0.49186E+03_JPRB, &
 & 0.46841E+03_JPRB,0.38202E+03_JPRB,0.21822E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 2, 5, 1) = (/ &
 & 0.35163E+02_JPRB,0.17023E+03_JPRB,0.30502E+03_JPRB,0.43478E+03_JPRB,0.48731E+03_JPRB, &
 & 0.46300E+03_JPRB,0.37666E+03_JPRB,0.21460E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 3, 5, 1) = (/ &
 & 0.34550E+02_JPRB,0.16961E+03_JPRB,0.30441E+03_JPRB,0.43332E+03_JPRB,0.48321E+03_JPRB, &
 & 0.45813E+03_JPRB,0.37186E+03_JPRB,0.21139E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 4, 5, 1) = (/ &
 & 0.34004E+02_JPRB,0.16902E+03_JPRB,0.30378E+03_JPRB,0.43194E+03_JPRB,0.47950E+03_JPRB, &
 & 0.45375E+03_JPRB,0.36755E+03_JPRB,0.20853E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 5, 5, 1) = (/ &
 & 0.33514E+02_JPRB,0.16844E+03_JPRB,0.30312E+03_JPRB,0.43058E+03_JPRB,0.47611E+03_JPRB, &
 & 0.44977E+03_JPRB,0.36365E+03_JPRB,0.20597E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 1, 6, 1) = (/ &
 & 0.34212E+02_JPRB,0.16946E+03_JPRB,0.30440E+03_JPRB,0.43247E+03_JPRB,0.48092E+03_JPRB, &
 & 0.45542E+03_JPRB,0.36920E+03_JPRB,0.20962E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 2, 6, 1) = (/ &
 & 0.33595E+02_JPRB,0.16889E+03_JPRB,0.30389E+03_JPRB,0.43093E+03_JPRB,0.47667E+03_JPRB, &
 & 0.45043E+03_JPRB,0.36430E+03_JPRB,0.20639E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 3, 6, 1) = (/ &
 & 0.33052E+02_JPRB,0.16835E+03_JPRB,0.30337E+03_JPRB,0.42946E+03_JPRB,0.47287E+03_JPRB, &
 & 0.44599E+03_JPRB,0.35993E+03_JPRB,0.20355E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 4, 6, 1) = (/ &
 & 0.32571E+02_JPRB,0.16784E+03_JPRB,0.30283E+03_JPRB,0.42807E+03_JPRB,0.46947E+03_JPRB, &
 & 0.44201E+03_JPRB,0.35602E+03_JPRB,0.20103E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 5, 6, 1) = (/ &
 & 0.32141E+02_JPRB,0.16733E+03_JPRB,0.30227E+03_JPRB,0.42674E+03_JPRB,0.46640E+03_JPRB, &
 & 0.43842E+03_JPRB,0.35250E+03_JPRB,0.19879E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 1, 7, 1) = (/ &
 & 0.32812E+02_JPRB,0.16823E+03_JPRB,0.30334E+03_JPRB,0.42859E+03_JPRB,0.47118E+03_JPRB, &
 & 0.44401E+03_JPRB,0.35799E+03_JPRB,0.20230E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 2, 7, 1) = (/ &
 & 0.32263E+02_JPRB,0.16774E+03_JPRB,0.30291E+03_JPRB,0.42708E+03_JPRB,0.46727E+03_JPRB, &
 & 0.43944E+03_JPRB,0.35350E+03_JPRB,0.19942E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 3, 7, 1) = (/ &
 & 0.31782E+02_JPRB,0.16728E+03_JPRB,0.30248E+03_JPRB,0.42558E+03_JPRB,0.46381E+03_JPRB, &
 & 0.43539E+03_JPRB,0.34954E+03_JPRB,0.19691E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 4, 7, 1) = (/ &
 & 0.31357E+02_JPRB,0.16683E+03_JPRB,0.30203E+03_JPRB,0.42413E+03_JPRB,0.46069E+03_JPRB, &
 & 0.43177E+03_JPRB,0.34599E+03_JPRB,0.19468E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 5, 7, 1) = (/ &
 & 0.30980E+02_JPRB,0.16640E+03_JPRB,0.30154E+03_JPRB,0.42276E+03_JPRB,0.45787E+03_JPRB, &
 & 0.42852E+03_JPRB,0.34280E+03_JPRB,0.19271E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 1, 8, 1) = (/ &
 & 0.31614E+02_JPRB,0.16716E+03_JPRB,0.30239E+03_JPRB,0.42473E+03_JPRB,0.46259E+03_JPRB, &
 & 0.43397E+03_JPRB,0.34814E+03_JPRB,0.19603E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 2, 8, 1) = (/ &
 & 0.31125E+02_JPRB,0.16674E+03_JPRB,0.30206E+03_JPRB,0.42311E+03_JPRB,0.45896E+03_JPRB, &
 & 0.42978E+03_JPRB,0.34403E+03_JPRB,0.19347E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 3, 8, 1) = (/ &
 & 0.30699E+02_JPRB,0.16635E+03_JPRB,0.30170E+03_JPRB,0.42163E+03_JPRB,0.45573E+03_JPRB, &
 & 0.42608E+03_JPRB,0.34039E+03_JPRB,0.19124E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 4, 8, 1) = (/ &
 & 0.30325E+02_JPRB,0.16597E+03_JPRB,0.30133E+03_JPRB,0.42027E+03_JPRB,0.45286E+03_JPRB, &
 & 0.42281E+03_JPRB,0.33716E+03_JPRB,0.18928E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 5, 8, 1) = (/ &
 & 0.29993E+02_JPRB,0.16559E+03_JPRB,0.30092E+03_JPRB,0.41901E+03_JPRB,0.45030E+03_JPRB, &
 & 0.41988E+03_JPRB,0.33427E+03_JPRB,0.18755E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 1, 9, 1) = (/ &
 & 0.30594E+02_JPRB,0.16624E+03_JPRB,0.30156E+03_JPRB,0.42087E+03_JPRB,0.45493E+03_JPRB, &
 & 0.42517E+03_JPRB,0.33949E+03_JPRB,0.19069E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 2, 9, 1) = (/ &
 & 0.30158E+02_JPRB,0.16589E+03_JPRB,0.30131E+03_JPRB,0.41937E+03_JPRB,0.45157E+03_JPRB, &
 & 0.42134E+03_JPRB,0.33570E+03_JPRB,0.18841E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 3, 9, 1) = (/ &
 & 0.29780E+02_JPRB,0.16556E+03_JPRB,0.30103E+03_JPRB,0.41800E+03_JPRB,0.44864E+03_JPRB, &
 & 0.41799E+03_JPRB,0.33239E+03_JPRB,0.18643E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 4, 9, 1) = (/ &
 & 0.29450E+02_JPRB,0.16523E+03_JPRB,0.30072E+03_JPRB,0.41674E+03_JPRB,0.44606E+03_JPRB, &
 & 0.41504E+03_JPRB,0.32946E+03_JPRB,0.18471E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 5, 9, 1) = (/ &
 & 0.29159E+02_JPRB,0.16491E+03_JPRB,0.30039E+03_JPRB,0.41557E+03_JPRB,0.44377E+03_JPRB, &
 & 0.41242E+03_JPRB,0.32686E+03_JPRB,0.18318E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 1,10, 1) = (/ &
 & 0.29691E+02_JPRB,0.16541E+03_JPRB,0.30081E+03_JPRB,0.41722E+03_JPRB,0.44795E+03_JPRB, &
 & 0.41720E+03_JPRB,0.33160E+03_JPRB,0.18597E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 2,10, 1) = (/ &
 & 0.29307E+02_JPRB,0.16512E+03_JPRB,0.30063E+03_JPRB,0.41581E+03_JPRB,0.44493E+03_JPRB, &
 & 0.41375E+03_JPRB,0.32818E+03_JPRB,0.18396E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 3,10, 1) = (/ &
 & 0.28975E+02_JPRB,0.16485E+03_JPRB,0.30042E+03_JPRB,0.41454E+03_JPRB,0.44231E+03_JPRB, &
 & 0.41076E+03_JPRB,0.32520E+03_JPRB,0.18222E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 4,10, 1) = (/ &
 & 0.28687E+02_JPRB,0.16458E+03_JPRB,0.30018E+03_JPRB,0.41340E+03_JPRB,0.44002E+03_JPRB, &
 & 0.40814E+03_JPRB,0.32259E+03_JPRB,0.18071E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 5,10, 1) = (/ &
 & 0.28434E+02_JPRB,0.16431E+03_JPRB,0.29989E+03_JPRB,0.41235E+03_JPRB,0.43799E+03_JPRB, &
 & 0.40583E+03_JPRB,0.32028E+03_JPRB,0.17939E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 1,11, 1) = (/ &
 & 0.28760E+02_JPRB,0.16459E+03_JPRB,0.30010E+03_JPRB,0.41321E+03_JPRB,0.44060E+03_JPRB, &
 & 0.40880E+03_JPRB,0.32325E+03_JPRB,0.18109E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 2,11, 1) = (/ &
 & 0.28444E+02_JPRB,0.16436E+03_JPRB,0.29997E+03_JPRB,0.41200E+03_JPRB,0.43807E+03_JPRB, &
 & 0.40592E+03_JPRB,0.32038E+03_JPRB,0.17944E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 3,11, 1) = (/ &
 & 0.28173E+02_JPRB,0.16414E+03_JPRB,0.29981E+03_JPRB,0.41092E+03_JPRB,0.43587E+03_JPRB, &
 & 0.40342E+03_JPRB,0.31788E+03_JPRB,0.17802E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 4,11, 1) = (/ &
 & 0.27937E+02_JPRB,0.16392E+03_JPRB,0.29960E+03_JPRB,0.40994E+03_JPRB,0.43395E+03_JPRB, &
 & 0.40124E+03_JPRB,0.31570E+03_JPRB,0.17679E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 5,11, 1) = (/ &
 & 0.27730E+02_JPRB,0.16369E+03_JPRB,0.29936E+03_JPRB,0.40905E+03_JPRB,0.43224E+03_JPRB, &
 & 0.39931E+03_JPRB,0.31377E+03_JPRB,0.17571E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 1,12, 1) = (/ &
 & 0.27995E+02_JPRB,0.16391E+03_JPRB,0.29951E+03_JPRB,0.40970E+03_JPRB,0.43443E+03_JPRB, &
 & 0.40178E+03_JPRB,0.31624E+03_JPRB,0.17709E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 2,12, 1) = (/ &
 & 0.27737E+02_JPRB,0.16374E+03_JPRB,0.29943E+03_JPRB,0.40869E+03_JPRB,0.43230E+03_JPRB, &
 & 0.39938E+03_JPRB,0.31384E+03_JPRB,0.17574E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 3,12, 1) = (/ &
 & 0.27515E+02_JPRB,0.16356E+03_JPRB,0.29930E+03_JPRB,0.40779E+03_JPRB,0.43046E+03_JPRB, &
 & 0.39730E+03_JPRB,0.31176E+03_JPRB,0.17458E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 4,12, 1) = (/ &
 & 0.27322E+02_JPRB,0.16338E+03_JPRB,0.29913E+03_JPRB,0.40697E+03_JPRB,0.42883E+03_JPRB, &
 & 0.39548E+03_JPRB,0.30994E+03_JPRB,0.17357E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 5,12, 1) = (/ &
 & 0.27152E+02_JPRB,0.16318E+03_JPRB,0.29892E+03_JPRB,0.40622E+03_JPRB,0.42740E+03_JPRB, &
 & 0.39387E+03_JPRB,0.30834E+03_JPRB,0.17268E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 1,13, 1) = (/ &
 & 0.27369E+02_JPRB,0.16336E+03_JPRB,0.29903E+03_JPRB,0.40671E+03_JPRB,0.42924E+03_JPRB, &
 & 0.39593E+03_JPRB,0.31039E+03_JPRB,0.17382E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 2,13, 1) = (/ &
 & 0.27158E+02_JPRB,0.16323E+03_JPRB,0.29898E+03_JPRB,0.40587E+03_JPRB,0.42745E+03_JPRB, &
 & 0.39393E+03_JPRB,0.30840E+03_JPRB,0.17271E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 3,13, 1) = (/ &
 & 0.26976E+02_JPRB,0.16309E+03_JPRB,0.29889E+03_JPRB,0.40513E+03_JPRB,0.42590E+03_JPRB, &
 & 0.39221E+03_JPRB,0.30667E+03_JPRB,0.17176E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 4,13, 1) = (/ &
 & 0.26818E+02_JPRB,0.16293E+03_JPRB,0.29875E+03_JPRB,0.40445E+03_JPRB,0.42455E+03_JPRB, &
 & 0.39070E+03_JPRB,0.30516E+03_JPRB,0.17093E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 5,13, 1) = (/ &
 & 0.26679E+02_JPRB,0.16276E+03_JPRB,0.29855E+03_JPRB,0.40381E+03_JPRB,0.42335E+03_JPRB, &
 & 0.38937E+03_JPRB,0.30384E+03_JPRB,0.17021E+03_JPRB,0.35000E+02_JPRB /)  
KA(:, 1, 1, 2) = (/ &
 & 0.17271E+03_JPRB,0.27646E+03_JPRB,0.38039E+03_JPRB,0.48420E+03_JPRB,0.56932E+03_JPRB, &
 & 0.57534E+03_JPRB,0.47873E+03_JPRB,0.28147E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 2, 1, 2) = (/ &
 & 0.16834E+03_JPRB,0.27246E+03_JPRB,0.37678E+03_JPRB,0.48091E+03_JPRB,0.56471E+03_JPRB, &
 & 0.56734E+03_JPRB,0.47005E+03_JPRB,0.27593E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 3, 1, 2) = (/ &
 & 0.16441E+03_JPRB,0.26883E+03_JPRB,0.37341E+03_JPRB,0.47777E+03_JPRB,0.56037E+03_JPRB, &
 & 0.56003E+03_JPRB,0.46210E+03_JPRB,0.27096E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 4, 1, 2) = (/ &
 & 0.16086E+03_JPRB,0.26548E+03_JPRB,0.37025E+03_JPRB,0.47479E+03_JPRB,0.55629E+03_JPRB, &
 & 0.55327E+03_JPRB,0.45481E+03_JPRB,0.26647E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 5, 1, 2) = (/ &
 & 0.15764E+03_JPRB,0.26237E+03_JPRB,0.36725E+03_JPRB,0.47195E+03_JPRB,0.55235E+03_JPRB, &
 & 0.54701E+03_JPRB,0.44810E+03_JPRB,0.26239E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 1, 2, 2) = (/ &
 & 0.15955E+03_JPRB,0.26500E+03_JPRB,0.37067E+03_JPRB,0.47595E+03_JPRB,0.55480E+03_JPRB, &
 & 0.55074E+03_JPRB,0.45210E+03_JPRB,0.26482E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 2, 2, 2) = (/ &
 & 0.15580E+03_JPRB,0.26157E+03_JPRB,0.36756E+03_JPRB,0.47303E+03_JPRB,0.55028E+03_JPRB, &
 & 0.54339E+03_JPRB,0.44423E+03_JPRB,0.26007E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 3, 2, 2) = (/ &
 & 0.15244E+03_JPRB,0.25844E+03_JPRB,0.36465E+03_JPRB,0.47023E+03_JPRB,0.54619E+03_JPRB, &
 & 0.53664E+03_JPRB,0.43708E+03_JPRB,0.25581E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 4, 2, 2) = (/ &
 & 0.14941E+03_JPRB,0.25556E+03_JPRB,0.36191E+03_JPRB,0.46753E+03_JPRB,0.54253E+03_JPRB, &
 & 0.53041E+03_JPRB,0.43052E+03_JPRB,0.25198E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 5, 2, 2) = (/ &
 & 0.14667E+03_JPRB,0.25289E+03_JPRB,0.35930E+03_JPRB,0.46494E+03_JPRB,0.53908E+03_JPRB, &
 & 0.52470E+03_JPRB,0.42448E+03_JPRB,0.24851E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 1, 3, 2) = (/ &
 & 0.14921E+03_JPRB,0.25601E+03_JPRB,0.36308E+03_JPRB,0.46872E+03_JPRB,0.54234E+03_JPRB, &
 & 0.52999E+03_JPRB,0.43007E+03_JPRB,0.25172E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 2, 3, 2) = (/ &
 & 0.14591E+03_JPRB,0.25301E+03_JPRB,0.36036E+03_JPRB,0.46599E+03_JPRB,0.53834E+03_JPRB, &
 & 0.52313E+03_JPRB,0.42280E+03_JPRB,0.24755E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 3, 3, 2) = (/ &
 & 0.14297E+03_JPRB,0.25028E+03_JPRB,0.35782E+03_JPRB,0.46350E+03_JPRB,0.53459E+03_JPRB, &
 & 0.51696E+03_JPRB,0.41619E+03_JPRB,0.24383E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 4, 3, 2) = (/ &
 & 0.14033E+03_JPRB,0.24777E+03_JPRB,0.35542E+03_JPRB,0.46116E+03_JPRB,0.53100E+03_JPRB, &
 & 0.51122E+03_JPRB,0.41016E+03_JPRB,0.24049E+03_JPRB,0.71840E+02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART1',1,ZHOOK_HANDLE)
END SUBROUTINE PART1


SUBROUTINE PART2

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART2',0,ZHOOK_HANDLE)


KA(:, 5, 3, 2) = (/ &
 & 0.13795E+03_JPRB,0.24544E+03_JPRB,0.35313E+03_JPRB,0.45882E+03_JPRB,0.52751E+03_JPRB, &
 & 0.50591E+03_JPRB,0.40463E+03_JPRB,0.23747E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 1, 4, 2) = (/ &
 & 0.14062E+03_JPRB,0.24856E+03_JPRB,0.35678E+03_JPRB,0.46260E+03_JPRB,0.53137E+03_JPRB, &
 & 0.51186E+03_JPRB,0.41082E+03_JPRB,0.24086E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 2, 4, 2) = (/ &
 & 0.13771E+03_JPRB,0.24592E+03_JPRB,0.35440E+03_JPRB,0.46020E+03_JPRB,0.52732E+03_JPRB, &
 & 0.50537E+03_JPRB,0.40407E+03_JPRB,0.23717E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 3, 4, 2) = (/ &
 & 0.13512E+03_JPRB,0.24353E+03_JPRB,0.35219E+03_JPRB,0.45796E+03_JPRB,0.52348E+03_JPRB, &
 & 0.49954E+03_JPRB,0.39798E+03_JPRB,0.23389E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 4, 4, 2) = (/ &
 & 0.13281E+03_JPRB,0.24133E+03_JPRB,0.35008E+03_JPRB,0.45583E+03_JPRB,0.51985E+03_JPRB, &
 & 0.49431E+03_JPRB,0.39246E+03_JPRB,0.23096E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 5, 4, 2) = (/ &
 & 0.13073E+03_JPRB,0.23928E+03_JPRB,0.34807E+03_JPRB,0.45378E+03_JPRB,0.51643E+03_JPRB, &
 & 0.48957E+03_JPRB,0.38745E+03_JPRB,0.22833E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 1, 5, 2) = (/ &
 & 0.13333E+03_JPRB,0.24222E+03_JPRB,0.35141E+03_JPRB,0.45702E+03_JPRB,0.52057E+03_JPRB, &
 & 0.49550E+03_JPRB,0.39372E+03_JPRB,0.23163E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 2, 5, 2) = (/ &
 & 0.13075E+03_JPRB,0.23990E+03_JPRB,0.34934E+03_JPRB,0.45476E+03_JPRB,0.51651E+03_JPRB, &
 & 0.48963E+03_JPRB,0.38752E+03_JPRB,0.22836E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 3, 5, 2) = (/ &
 & 0.12847E+03_JPRB,0.23780E+03_JPRB,0.34741E+03_JPRB,0.45266E+03_JPRB,0.51271E+03_JPRB, &
 & 0.48438E+03_JPRB,0.38196E+03_JPRB,0.22548E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 4, 5, 2) = (/ &
 & 0.12644E+03_JPRB,0.23588E+03_JPRB,0.34557E+03_JPRB,0.45066E+03_JPRB,0.50911E+03_JPRB, &
 & 0.47962E+03_JPRB,0.37696E+03_JPRB,0.22291E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 5, 5, 2) = (/ &
 & 0.12462E+03_JPRB,0.23409E+03_JPRB,0.34381E+03_JPRB,0.44874E+03_JPRB,0.50570E+03_JPRB, &
 & 0.47526E+03_JPRB,0.37245E+03_JPRB,0.22060E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 1, 6, 2) = (/ &
 & 0.12722E+03_JPRB,0.23690E+03_JPRB,0.34688E+03_JPRB,0.45177E+03_JPRB,0.51032E+03_JPRB, &
 & 0.48144E+03_JPRB,0.37887E+03_JPRB,0.22389E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 2, 6, 2) = (/ &
 & 0.12492E+03_JPRB,0.23485E+03_JPRB,0.34508E+03_JPRB,0.44967E+03_JPRB,0.50620E+03_JPRB, &
 & 0.47598E+03_JPRB,0.37319E+03_JPRB,0.22098E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 3, 6, 2) = (/ &
 & 0.12290E+03_JPRB,0.23301E+03_JPRB,0.34340E+03_JPRB,0.44769E+03_JPRB,0.50242E+03_JPRB, &
 & 0.47108E+03_JPRB,0.36815E+03_JPRB,0.21843E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 4, 6, 2) = (/ &
 & 0.12111E+03_JPRB,0.23132E+03_JPRB,0.34180E+03_JPRB,0.44582E+03_JPRB,0.49894E+03_JPRB, &
 & 0.46668E+03_JPRB,0.36363E+03_JPRB,0.21616E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 5, 6, 2) = (/ &
 & 0.11952E+03_JPRB,0.22976E+03_JPRB,0.34026E+03_JPRB,0.44407E+03_JPRB,0.49574E+03_JPRB, &
 & 0.46270E+03_JPRB,0.35956E+03_JPRB,0.21414E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 1, 7, 2) = (/ &
 & 0.12201E+03_JPRB,0.23235E+03_JPRB,0.34300E+03_JPRB,0.44700E+03_JPRB,0.50054E+03_JPRB, &
 & 0.46889E+03_JPRB,0.36590E+03_JPRB,0.21730E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 2, 7, 2) = (/ &
 & 0.11997E+03_JPRB,0.23055E+03_JPRB,0.34145E+03_JPRB,0.44492E+03_JPRB,0.49657E+03_JPRB, &
 & 0.46383E+03_JPRB,0.36071E+03_JPRB,0.21471E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 3, 7, 2) = (/ &
 & 0.11818E+03_JPRB,0.22894E+03_JPRB,0.33999E+03_JPRB,0.44309E+03_JPRB,0.49292E+03_JPRB, &
 & 0.45934E+03_JPRB,0.35613E+03_JPRB,0.21245E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 4, 7, 2) = (/ &
 & 0.11660E+03_JPRB,0.22746E+03_JPRB,0.33859E+03_JPRB,0.44146E+03_JPRB,0.48959E+03_JPRB, &
 & 0.45533E+03_JPRB,0.35208E+03_JPRB,0.21045E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 5, 7, 2) = (/ &
 & 0.11520E+03_JPRB,0.22609E+03_JPRB,0.33724E+03_JPRB,0.43996E+03_JPRB,0.48657E+03_JPRB, &
 & 0.45175E+03_JPRB,0.34847E+03_JPRB,0.20867E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 1, 8, 2) = (/ &
 & 0.11756E+03_JPRB,0.22844E+03_JPRB,0.33965E+03_JPRB,0.44261E+03_JPRB,0.49147E+03_JPRB, &
 & 0.45776E+03_JPRB,0.35454E+03_JPRB,0.21166E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 2, 8, 2) = (/ &
 & 0.11574E+03_JPRB,0.22687E+03_JPRB,0.33830E+03_JPRB,0.44082E+03_JPRB,0.48767E+03_JPRB, &
 & 0.45313E+03_JPRB,0.34986E+03_JPRB,0.20936E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 3, 8, 2) = (/ &
 & 0.11415E+03_JPRB,0.22546E+03_JPRB,0.33704E+03_JPRB,0.43915E+03_JPRB,0.48429E+03_JPRB, &
 & 0.44908E+03_JPRB,0.34579E+03_JPRB,0.20735E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 4, 8, 2) = (/ &
 & 0.11276E+03_JPRB,0.22417E+03_JPRB,0.33584E+03_JPRB,0.43758E+03_JPRB,0.48126E+03_JPRB, &
 & 0.44549E+03_JPRB,0.34220E+03_JPRB,0.20559E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 5, 8, 2) = (/ &
 & 0.11153E+03_JPRB,0.22298E+03_JPRB,0.33466E+03_JPRB,0.43617E+03_JPRB,0.47855E+03_JPRB, &
 & 0.44228E+03_JPRB,0.33902E+03_JPRB,0.20403E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 1, 9, 2) = (/ &
 & 0.11376E+03_JPRB,0.22510E+03_JPRB,0.33674E+03_JPRB,0.43882E+03_JPRB,0.48336E+03_JPRB, &
 & 0.44807E+03_JPRB,0.34479E+03_JPRB,0.20686E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 2, 9, 2) = (/ &
 & 0.11214E+03_JPRB,0.22372E+03_JPRB,0.33559E+03_JPRB,0.43706E+03_JPRB,0.47989E+03_JPRB, &
 & 0.44388E+03_JPRB,0.34060E+03_JPRB,0.20480E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 3, 9, 2) = (/ &
 & 0.11074E+03_JPRB,0.22250E+03_JPRB,0.33451E+03_JPRB,0.43547E+03_JPRB,0.47679E+03_JPRB, &
 & 0.44020E+03_JPRB,0.33697E+03_JPRB,0.20303E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 4, 9, 2) = (/ &
 & 0.10951E+03_JPRB,0.22138E+03_JPRB,0.33348E+03_JPRB,0.43404E+03_JPRB,0.47404E+03_JPRB, &
 & 0.43694E+03_JPRB,0.33379E+03_JPRB,0.20147E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 5, 9, 2) = (/ &
 & 0.10843E+03_JPRB,0.22034E+03_JPRB,0.33246E+03_JPRB,0.43277E+03_JPRB,0.47159E+03_JPRB, &
 & 0.43405E+03_JPRB,0.33096E+03_JPRB,0.20010E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 1,10, 2) = (/ &
 & 0.11041E+03_JPRB,0.22214E+03_JPRB,0.33414E+03_JPRB,0.43517E+03_JPRB,0.47604E+03_JPRB, &
 & 0.43932E+03_JPRB,0.33611E+03_JPRB,0.20261E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 2,10, 2) = (/ &
 & 0.10898E+03_JPRB,0.22095E+03_JPRB,0.33317E+03_JPRB,0.43358E+03_JPRB,0.47283E+03_JPRB, &
 & 0.43552E+03_JPRB,0.33239E+03_JPRB,0.20080E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 3,10, 2) = (/ &
 & 0.10774E+03_JPRB,0.21989E+03_JPRB,0.33226E+03_JPRB,0.43213E+03_JPRB,0.47002E+03_JPRB, &
 & 0.43222E+03_JPRB,0.32917E+03_JPRB,0.19924E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 4,10, 2) = (/ &
 & 0.10667E+03_JPRB,0.21893E+03_JPRB,0.33139E+03_JPRB,0.43083E+03_JPRB,0.46753E+03_JPRB, &
 & 0.42932E+03_JPRB,0.32634E+03_JPRB,0.19788E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 5,10, 2) = (/ &
 & 0.10573E+03_JPRB,0.21803E+03_JPRB,0.33053E+03_JPRB,0.42965E+03_JPRB,0.46532E+03_JPRB, &
 & 0.42677E+03_JPRB,0.32386E+03_JPRB,0.19669E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 1,11, 2) = (/ &
 & 0.10694E+03_JPRB,0.21911E+03_JPRB,0.33152E+03_JPRB,0.43127E+03_JPRB,0.46816E+03_JPRB, &
 & 0.43005E+03_JPRB,0.32706E+03_JPRB,0.19822E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 2,11, 2) = (/ &
 & 0.10577E+03_JPRB,0.21815E+03_JPRB,0.33074E+03_JPRB,0.42984E+03_JPRB,0.46541E+03_JPRB, &
 & 0.42687E+03_JPRB,0.32396E+03_JPRB,0.19674E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 3,11, 2) = (/ &
 & 0.10476E+03_JPRB,0.21728E+03_JPRB,0.33000E+03_JPRB,0.42855E+03_JPRB,0.46301E+03_JPRB, &
 & 0.42411E+03_JPRB,0.32130E+03_JPRB,0.19546E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 4,11, 2) = (/ &
 & 0.10388E+03_JPRB,0.21649E+03_JPRB,0.32928E+03_JPRB,0.42741E+03_JPRB,0.46089E+03_JPRB, &
 & 0.42169E+03_JPRB,0.31897E+03_JPRB,0.19435E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 5,11, 2) = (/ &
 & 0.10311E+03_JPRB,0.21575E+03_JPRB,0.32855E+03_JPRB,0.42639E+03_JPRB,0.45902E+03_JPRB, &
 & 0.41954E+03_JPRB,0.31692E+03_JPRB,0.19338E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 1,12, 2) = (/ &
 & 0.10410E+03_JPRB,0.21663E+03_JPRB,0.32937E+03_JPRB,0.42778E+03_JPRB,0.46141E+03_JPRB, &
 & 0.42229E+03_JPRB,0.31955E+03_JPRB,0.19463E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 2,12, 2) = (/ &
 & 0.10314E+03_JPRB,0.21585E+03_JPRB,0.32875E+03_JPRB,0.42654E+03_JPRB,0.45909E+03_JPRB, &
 & 0.41961E+03_JPRB,0.31700E+03_JPRB,0.19341E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 3,12, 2) = (/ &
 & 0.10231E+03_JPRB,0.21515E+03_JPRB,0.32815E+03_JPRB,0.42544E+03_JPRB,0.45707E+03_JPRB, &
 & 0.41729E+03_JPRB,0.31480E+03_JPRB,0.19236E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 4,12, 2) = (/ &
 & 0.10159E+03_JPRB,0.21449E+03_JPRB,0.32754E+03_JPRB,0.42445E+03_JPRB,0.45532E+03_JPRB, &
 & 0.41526E+03_JPRB,0.31288E+03_JPRB,0.19145E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 5,12, 2) = (/ &
 & 0.10096E+03_JPRB,0.21387E+03_JPRB,0.32692E+03_JPRB,0.42356E+03_JPRB,0.45377E+03_JPRB, &
 & 0.41347E+03_JPRB,0.31119E+03_JPRB,0.19066E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 1,13, 2) = (/ &
 & 0.10177E+03_JPRB,0.21460E+03_JPRB,0.32761E+03_JPRB,0.42475E+03_JPRB,0.45575E+03_JPRB, &
 & 0.41576E+03_JPRB,0.31335E+03_JPRB,0.19168E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 2,13, 2) = (/ &
 & 0.10099E+03_JPRB,0.21397E+03_JPRB,0.32712E+03_JPRB,0.42368E+03_JPRB,0.45383E+03_JPRB, &
 & 0.41353E+03_JPRB,0.31125E+03_JPRB,0.19068E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 3,13, 2) = (/ &
 & 0.10031E+03_JPRB,0.21340E+03_JPRB,0.32663E+03_JPRB,0.42272E+03_JPRB,0.45216E+03_JPRB, &
 & 0.41160E+03_JPRB,0.30943E+03_JPRB,0.18983E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 4,13, 2) = (/ &
 & 0.99720E+02_JPRB,0.21286E+03_JPRB,0.32612E+03_JPRB,0.42187E+03_JPRB,0.45071E+03_JPRB, &
 & 0.40991E+03_JPRB,0.30785E+03_JPRB,0.18908E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 5,13, 2) = (/ &
 & 0.99204E+02_JPRB,0.21233E+03_JPRB,0.32558E+03_JPRB,0.42112E+03_JPRB,0.44942E+03_JPRB, &
 & 0.40842E+03_JPRB,0.30646E+03_JPRB,0.18843E+03_JPRB,0.71840E+02_JPRB /)  
KA(:, 1, 1, 3) = (/ &
 & 0.44909E+03_JPRB,0.47445E+03_JPRB,0.49981E+03_JPRB,0.52556E+03_JPRB,0.59352E+03_JPRB, &
 & 0.63011E+03_JPRB,0.50440E+03_JPRB,0.31793E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 2, 1, 3) = (/ &
 & 0.43771E+03_JPRB,0.46449E+03_JPRB,0.49128E+03_JPRB,0.51852E+03_JPRB,0.58982E+03_JPRB, &
 & 0.62155E+03_JPRB,0.49364E+03_JPRB,0.31383E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 3, 1, 3) = (/ &
 & 0.42749E+03_JPRB,0.45555E+03_JPRB,0.48362E+03_JPRB,0.51220E+03_JPRB,0.58623E+03_JPRB, &
 & 0.61324E+03_JPRB,0.48379E+03_JPRB,0.31014E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 4, 1, 3) = (/ &
 & 0.41826E+03_JPRB,0.44748E+03_JPRB,0.47670E+03_JPRB,0.50650E+03_JPRB,0.58281E+03_JPRB, &
 & 0.60555E+03_JPRB,0.47483E+03_JPRB,0.30681E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 5, 1, 3) = (/ &
 & 0.40989E+03_JPRB,0.44015E+03_JPRB,0.47042E+03_JPRB,0.50132E+03_JPRB,0.57944E+03_JPRB, &
 & 0.59846E+03_JPRB,0.46657E+03_JPRB,0.30379E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 1, 2, 3) = (/ &
 & 0.41487E+03_JPRB,0.44451E+03_JPRB,0.47415E+03_JPRB,0.50447E+03_JPRB,0.58410E+03_JPRB, &
 & 0.60269E+03_JPRB,0.47150E+03_JPRB,0.30559E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 2, 2, 3) = (/ &
 & 0.40511E+03_JPRB,0.43597E+03_JPRB,0.46683E+03_JPRB,0.49854E+03_JPRB,0.58056E+03_JPRB, &
 & 0.59434E+03_JPRB,0.46181E+03_JPRB,0.30207E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 3, 2, 3) = (/ &
 & 0.39637E+03_JPRB,0.42832E+03_JPRB,0.46028E+03_JPRB,0.49326E+03_JPRB,0.57701E+03_JPRB, &
 & 0.58648E+03_JPRB,0.45298E+03_JPRB,0.29892E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 4, 2, 3) = (/ &
 & 0.38850E+03_JPRB,0.42143E+03_JPRB,0.45437E+03_JPRB,0.48855E+03_JPRB,0.57350E+03_JPRB, &
 & 0.57914E+03_JPRB,0.44500E+03_JPRB,0.29608E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 5, 2, 3) = (/ &
 & 0.38136E+03_JPRB,0.41519E+03_JPRB,0.44902E+03_JPRB,0.48433E+03_JPRB,0.57004E+03_JPRB, &
 & 0.57245E+03_JPRB,0.43774E+03_JPRB,0.29351E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 1, 3, 3) = (/ &
 & 0.38797E+03_JPRB,0.42097E+03_JPRB,0.45397E+03_JPRB,0.48897E+03_JPRB,0.57508E+03_JPRB, &
 & 0.57865E+03_JPRB,0.44446E+03_JPRB,0.29589E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 2, 3, 3) = (/ &
 & 0.37940E+03_JPRB,0.41348E+03_JPRB,0.44755E+03_JPRB,0.48416E+03_JPRB,0.57138E+03_JPRB, &
 & 0.57059E+03_JPRB,0.43573E+03_JPRB,0.29280E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 3, 3, 3) = (/ &
 & 0.37176E+03_JPRB,0.40679E+03_JPRB,0.44182E+03_JPRB,0.47985E+03_JPRB,0.56781E+03_JPRB, &
 & 0.56324E+03_JPRB,0.42791E+03_JPRB,0.29005E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 4, 3, 3) = (/ &
 & 0.36490E+03_JPRB,0.40078E+03_JPRB,0.43667E+03_JPRB,0.47599E+03_JPRB,0.56436E+03_JPRB, &
 & 0.55656E+03_JPRB,0.42088E+03_JPRB,0.28757E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 5, 3, 3) = (/ &
 & 0.35870E+03_JPRB,0.39536E+03_JPRB,0.43202E+03_JPRB,0.47253E+03_JPRB,0.56109E+03_JPRB, &
 & 0.55041E+03_JPRB,0.41448E+03_JPRB,0.28534E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 1, 4, 3) = (/ &
 & 0.36565E+03_JPRB,0.40144E+03_JPRB,0.43723E+03_JPRB,0.47759E+03_JPRB,0.56581E+03_JPRB, &
 & 0.55729E+03_JPRB,0.42164E+03_JPRB,0.28784E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 2, 4, 3) = (/ &
 & 0.35808E+03_JPRB,0.39482E+03_JPRB,0.43155E+03_JPRB,0.47386E+03_JPRB,0.56215E+03_JPRB, &
 & 0.54978E+03_JPRB,0.41381E+03_JPRB,0.28511E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 3, 4, 3) = (/ &
 & 0.35135E+03_JPRB,0.38893E+03_JPRB,0.42651E+03_JPRB,0.47052E+03_JPRB,0.55875E+03_JPRB, &
 & 0.54295E+03_JPRB,0.40683E+03_JPRB,0.28269E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 4, 4, 3) = (/ &
 & 0.34533E+03_JPRB,0.38366E+03_JPRB,0.42199E+03_JPRB,0.46746E+03_JPRB,0.55555E+03_JPRB, &
 & 0.53669E+03_JPRB,0.40055E+03_JPRB,0.28052E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 5, 4, 3) = (/ &
 & 0.33991E+03_JPRB,0.37892E+03_JPRB,0.41793E+03_JPRB,0.46467E+03_JPRB,0.55244E+03_JPRB, &
 & 0.53093E+03_JPRB,0.39488E+03_JPRB,0.27856E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 1, 5, 3) = (/ &
 & 0.34669E+03_JPRB,0.38485E+03_JPRB,0.42301E+03_JPRB,0.46943E+03_JPRB,0.55667E+03_JPRB, &
 & 0.53812E+03_JPRB,0.40197E+03_JPRB,0.28101E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 2, 5, 3) = (/ &
 & 0.33999E+03_JPRB,0.37899E+03_JPRB,0.41799E+03_JPRB,0.46662E+03_JPRB,0.55311E+03_JPRB, &
 & 0.53101E+03_JPRB,0.39496E+03_JPRB,0.27859E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 3, 5, 3) = (/ &
 & 0.33406E+03_JPRB,0.37380E+03_JPRB,0.41354E+03_JPRB,0.46416E+03_JPRB,0.54976E+03_JPRB, &
 & 0.52459E+03_JPRB,0.38873E+03_JPRB,0.27645E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 4, 5, 3) = (/ &
 & 0.32878E+03_JPRB,0.36918E+03_JPRB,0.40958E+03_JPRB,0.46185E+03_JPRB,0.54671E+03_JPRB, &
 & 0.51881E+03_JPRB,0.38326E+03_JPRB,0.27455E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 5, 5, 3) = (/ &
 & 0.32404E+03_JPRB,0.36503E+03_JPRB,0.40603E+03_JPRB,0.45969E+03_JPRB,0.54395E+03_JPRB, &
 & 0.51356E+03_JPRB,0.37844E+03_JPRB,0.27284E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 1, 6, 3) = (/ &
 & 0.33079E+03_JPRB,0.37094E+03_JPRB,0.41109E+03_JPRB,0.46395E+03_JPRB,0.54790E+03_JPRB, &
 & 0.52101E+03_JPRB,0.38534E+03_JPRB,0.27527E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 2, 6, 3) = (/ &
 & 0.32482E+03_JPRB,0.36572E+03_JPRB,0.40662E+03_JPRB,0.46188E+03_JPRB,0.54448E+03_JPRB, &
 & 0.51443E+03_JPRB,0.37923E+03_JPRB,0.27312E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 3, 6, 3) = (/ &
 & 0.31958E+03_JPRB,0.36113E+03_JPRB,0.40268E+03_JPRB,0.45998E+03_JPRB,0.54143E+03_JPRB, &
 & 0.50857E+03_JPRB,0.37397E+03_JPRB,0.27123E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 4, 6, 3) = (/ &
 & 0.31492E+03_JPRB,0.35705E+03_JPRB,0.39919E+03_JPRB,0.45816E+03_JPRB,0.53866E+03_JPRB, &
 & 0.50335E+03_JPRB,0.36939E+03_JPRB,0.26955E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 5, 6, 3) = (/ &
 & 0.31076E+03_JPRB,0.35342E+03_JPRB,0.39607E+03_JPRB,0.45638E+03_JPRB,0.53611E+03_JPRB, &
 & 0.49868E+03_JPRB,0.36537E+03_JPRB,0.26805E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 1, 7, 3) = (/ &
 & 0.31725E+03_JPRB,0.35910E+03_JPRB,0.40094E+03_JPRB,0.45992E+03_JPRB,0.53978E+03_JPRB, &
 & 0.50597E+03_JPRB,0.37168E+03_JPRB,0.27039E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 2, 7, 3) = (/ &
 & 0.31194E+03_JPRB,0.35445E+03_JPRB,0.39695E+03_JPRB,0.45835E+03_JPRB,0.53664E+03_JPRB, &
 & 0.50000E+03_JPRB,0.36650E+03_JPRB,0.26848E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 3, 7, 3) = (/ &
 & 0.30729E+03_JPRB,0.35038E+03_JPRB,0.39347E+03_JPRB,0.45686E+03_JPRB,0.53383E+03_JPRB, &
 & 0.49465E+03_JPRB,0.36205E+03_JPRB,0.26680E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 4, 7, 3) = (/ &
 & 0.30318E+03_JPRB,0.34679E+03_JPRB,0.39040E+03_JPRB,0.45536E+03_JPRB,0.53125E+03_JPRB, &
 & 0.48979E+03_JPRB,0.35818E+03_JPRB,0.26532E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 5, 7, 3) = (/ &
 & 0.29953E+03_JPRB,0.34359E+03_JPRB,0.38767E+03_JPRB,0.45383E+03_JPRB,0.52882E+03_JPRB, &
 & 0.48543E+03_JPRB,0.35479E+03_JPRB,0.26401E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 1, 8, 3) = (/ &
 & 0.30567E+03_JPRB,0.34896E+03_JPRB,0.39226E+03_JPRB,0.45673E+03_JPRB,0.53243E+03_JPRB, &
 & 0.49274E+03_JPRB,0.36052E+03_JPRB,0.26622E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 2, 8, 3) = (/ &
 & 0.30094E+03_JPRB,0.34482E+03_JPRB,0.38872E+03_JPRB,0.45541E+03_JPRB,0.52945E+03_JPRB, &
 & 0.48711E+03_JPRB,0.35609E+03_JPRB,0.26451E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 3, 8, 3) = (/ &
 & 0.29682E+03_JPRB,0.34122E+03_JPRB,0.38564E+03_JPRB,0.45413E+03_JPRB,0.52674E+03_JPRB, &
 & 0.48217E+03_JPRB,0.35231E+03_JPRB,0.26303E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 4, 8, 3) = (/ &
 & 0.29320E+03_JPRB,0.33805E+03_JPRB,0.38294E+03_JPRB,0.45285E+03_JPRB,0.52426E+03_JPRB, &
 & 0.47779E+03_JPRB,0.34904E+03_JPRB,0.26172E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 5, 8, 3) = (/ &
 & 0.29000E+03_JPRB,0.33525E+03_JPRB,0.38055E+03_JPRB,0.45152E+03_JPRB,0.52191E+03_JPRB, &
 & 0.47388E+03_JPRB,0.34618E+03_JPRB,0.26057E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 1, 9, 3) = (/ &
 & 0.29581E+03_JPRB,0.34033E+03_JPRB,0.38489E+03_JPRB,0.45387E+03_JPRB,0.52555E+03_JPRB, &
 & 0.48095E+03_JPRB,0.35139E+03_JPRB,0.26266E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 2, 9, 3) = (/ &
 & 0.29159E+03_JPRB,0.33664E+03_JPRB,0.38173E+03_JPRB,0.45277E+03_JPRB,0.52268E+03_JPRB, &
 & 0.47582E+03_JPRB,0.34759E+03_JPRB,0.26114E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 3, 9, 3) = (/ &
 & 0.28794E+03_JPRB,0.33344E+03_JPRB,0.37901E+03_JPRB,0.45167E+03_JPRB,0.52008E+03_JPRB, &
 & 0.47135E+03_JPRB,0.34436E+03_JPRB,0.25982E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 4, 9, 3) = (/ &
 & 0.28475E+03_JPRB,0.33065E+03_JPRB,0.37663E+03_JPRB,0.45055E+03_JPRB,0.51765E+03_JPRB, &
 & 0.46738E+03_JPRB,0.34157E+03_JPRB,0.25867E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 5, 9, 3) = (/ &
 & 0.28193E+03_JPRB,0.32819E+03_JPRB,0.37453E+03_JPRB,0.44937E+03_JPRB,0.51538E+03_JPRB, &
 & 0.46382E+03_JPRB,0.33916E+03_JPRB,0.25766E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 1,10, 3) = (/ &
 & 0.28708E+03_JPRB,0.33269E+03_JPRB,0.37836E+03_JPRB,0.45121E+03_JPRB,0.51885E+03_JPRB, &
 & 0.47029E+03_JPRB,0.34361E+03_JPRB,0.25951E+03_JPRB,0.17829E+03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART2',1,ZHOOK_HANDLE)
END SUBROUTINE PART2


SUBROUTINE PART3

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART3',0,ZHOOK_HANDLE)


KA(:, 2,10, 3) = (/ &
 & 0.28336E+03_JPRB,0.32944E+03_JPRB,0.37559E+03_JPRB,0.45027E+03_JPRB,0.51611E+03_JPRB, &
 & 0.46563E+03_JPRB,0.34037E+03_JPRB,0.25817E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 3,10, 3) = (/ &
 & 0.28016E+03_JPRB,0.32664E+03_JPRB,0.37320E+03_JPRB,0.44932E+03_JPRB,0.51361E+03_JPRB, &
 & 0.46153E+03_JPRB,0.33765E+03_JPRB,0.25702E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 4,10, 3) = (/ &
 & 0.27737E+03_JPRB,0.32420E+03_JPRB,0.37112E+03_JPRB,0.44835E+03_JPRB,0.51133E+03_JPRB, &
 & 0.45793E+03_JPRB,0.33532E+03_JPRB,0.25601E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 5,10, 3) = (/ &
 & 0.27492E+03_JPRB,0.32206E+03_JPRB,0.36930E+03_JPRB,0.44735E+03_JPRB,0.50922E+03_JPRB, &
 & 0.45473E+03_JPRB,0.33330E+03_JPRB,0.25513E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 1,11, 3) = (/ &
 & 0.27807E+03_JPRB,0.32481E+03_JPRB,0.37164E+03_JPRB,0.44842E+03_JPRB,0.51141E+03_JPRB, &
 & 0.45884E+03_JPRB,0.33590E+03_JPRB,0.25627E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 2,11, 3) = (/ &
 & 0.27502E+03_JPRB,0.32214E+03_JPRB,0.36937E+03_JPRB,0.44764E+03_JPRB,0.50894E+03_JPRB, &
 & 0.45486E+03_JPRB,0.33338E+03_JPRB,0.25517E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 3,11, 3) = (/ &
 & 0.27240E+03_JPRB,0.31985E+03_JPRB,0.36742E+03_JPRB,0.44685E+03_JPRB,0.50671E+03_JPRB, &
 & 0.45139E+03_JPRB,0.33123E+03_JPRB,0.25422E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 4,11, 3) = (/ &
 & 0.27012E+03_JPRB,0.31785E+03_JPRB,0.36572E+03_JPRB,0.44602E+03_JPRB,0.50464E+03_JPRB, &
 & 0.44836E+03_JPRB,0.32939E+03_JPRB,0.25340E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 5,11, 3) = (/ &
 & 0.26811E+03_JPRB,0.31610E+03_JPRB,0.36422E+03_JPRB,0.44514E+03_JPRB,0.50273E+03_JPRB, &
 & 0.44569E+03_JPRB,0.32779E+03_JPRB,0.25268E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 1,12, 3) = (/ &
 & 0.27068E+03_JPRB,0.31834E+03_JPRB,0.36613E+03_JPRB,0.44605E+03_JPRB,0.50476E+03_JPRB, &
 & 0.44911E+03_JPRB,0.32983E+03_JPRB,0.25360E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 2,12, 3) = (/ &
 & 0.26818E+03_JPRB,0.31616E+03_JPRB,0.36428E+03_JPRB,0.44539E+03_JPRB,0.50255E+03_JPRB, &
 & 0.44579E+03_JPRB,0.32784E+03_JPRB,0.25270E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 3,12, 3) = (/ &
 & 0.26603E+03_JPRB,0.31428E+03_JPRB,0.36268E+03_JPRB,0.44471E+03_JPRB,0.50054E+03_JPRB, &
 & 0.44293E+03_JPRB,0.32614E+03_JPRB,0.25193E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 4,12, 3) = (/ &
 & 0.26417E+03_JPRB,0.31264E+03_JPRB,0.36129E+03_JPRB,0.44399E+03_JPRB,0.49874E+03_JPRB, &
 & 0.44043E+03_JPRB,0.32468E+03_JPRB,0.25125E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 5,12, 3) = (/ &
 & 0.26252E+03_JPRB,0.31121E+03_JPRB,0.36005E+03_JPRB,0.44322E+03_JPRB,0.49710E+03_JPRB, &
 & 0.43824E+03_JPRB,0.32341E+03_JPRB,0.25066E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 1,13, 3) = (/ &
 & 0.26463E+03_JPRB,0.31305E+03_JPRB,0.36163E+03_JPRB,0.44400E+03_JPRB,0.49889E+03_JPRB, &
 & 0.44105E+03_JPRB,0.32504E+03_JPRB,0.25142E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 2,13, 3) = (/ &
 & 0.26258E+03_JPRB,0.31126E+03_JPRB,0.36010E+03_JPRB,0.44348E+03_JPRB,0.49698E+03_JPRB, &
 & 0.43831E+03_JPRB,0.32345E+03_JPRB,0.25068E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 3,13, 3) = (/ &
 & 0.26082E+03_JPRB,0.30972E+03_JPRB,0.35880E+03_JPRB,0.44291E+03_JPRB,0.49519E+03_JPRB, &
 & 0.43595E+03_JPRB,0.32210E+03_JPRB,0.25005E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 4,13, 3) = (/ &
 & 0.25929E+03_JPRB,0.30838E+03_JPRB,0.35766E+03_JPRB,0.44229E+03_JPRB,0.49360E+03_JPRB, &
 & 0.43388E+03_JPRB,0.32093E+03_JPRB,0.24950E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 5,13, 3) = (/ &
 & 0.25795E+03_JPRB,0.30721E+03_JPRB,0.35666E+03_JPRB,0.44160E+03_JPRB,0.49217E+03_JPRB, &
 & 0.43204E+03_JPRB,0.31991E+03_JPRB,0.24901E+03_JPRB,0.17829E+03_JPRB /)  
KA(:, 1, 1, 4) = (/ &
 & 0.86913E+03_JPRB,0.80389E+03_JPRB,0.73864E+03_JPRB,0.67339E+03_JPRB,0.62239E+03_JPRB, &
 & 0.67741E+03_JPRB,0.51596E+03_JPRB,0.43641E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 2, 1, 4) = (/ &
 & 0.84711E+03_JPRB,0.78462E+03_JPRB,0.72212E+03_JPRB,0.65963E+03_JPRB,0.61530E+03_JPRB, &
 & 0.66963E+03_JPRB,0.50564E+03_JPRB,0.43387E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 3, 1, 4) = (/ &
 & 0.82734E+03_JPRB,0.76731E+03_JPRB,0.70729E+03_JPRB,0.64727E+03_JPRB,0.60932E+03_JPRB, &
 & 0.66251E+03_JPRB,0.49688E+03_JPRB,0.43160E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 4, 1, 4) = (/ &
 & 0.80948E+03_JPRB,0.75169E+03_JPRB,0.69390E+03_JPRB,0.63611E+03_JPRB,0.60420E+03_JPRB, &
 & 0.65531E+03_JPRB,0.48930E+03_JPRB,0.42954E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 5, 1, 4) = (/ &
 & 0.79327E+03_JPRB,0.73751E+03_JPRB,0.68174E+03_JPRB,0.62598E+03_JPRB,0.59980E+03_JPRB, &
 & 0.64776E+03_JPRB,0.48275E+03_JPRB,0.42767E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 1, 2, 4) = (/ &
 & 0.80291E+03_JPRB,0.74594E+03_JPRB,0.68897E+03_JPRB,0.63200E+03_JPRB,0.60547E+03_JPRB, &
 & 0.65273E+03_JPRB,0.48660E+03_JPRB,0.42878E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 2, 2, 4) = (/ &
 & 0.78403E+03_JPRB,0.72942E+03_JPRB,0.67481E+03_JPRB,0.62020E+03_JPRB,0.60133E+03_JPRB, &
 & 0.64384E+03_JPRB,0.47915E+03_JPRB,0.42661E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 3, 2, 4) = (/ &
 & 0.76711E+03_JPRB,0.71462E+03_JPRB,0.66212E+03_JPRB,0.60962E+03_JPRB,0.59788E+03_JPRB, &
 & 0.63506E+03_JPRB,0.47284E+03_JPRB,0.42466E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 4, 2, 4) = (/ &
 & 0.75187E+03_JPRB,0.70128E+03_JPRB,0.65069E+03_JPRB,0.60010E+03_JPRB,0.59472E+03_JPRB, &
 & 0.62679E+03_JPRB,0.46742E+03_JPRB,0.42291E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 5, 2, 4) = (/ &
 & 0.73807E+03_JPRB,0.68920E+03_JPRB,0.64034E+03_JPRB,0.59147E+03_JPRB,0.59165E+03_JPRB, &
 & 0.61864E+03_JPRB,0.46272E+03_JPRB,0.42132E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 1, 3, 4) = (/ &
 & 0.75084E+03_JPRB,0.70038E+03_JPRB,0.64992E+03_JPRB,0.59946E+03_JPRB,0.59732E+03_JPRB, &
 & 0.62621E+03_JPRB,0.46707E+03_JPRB,0.42279E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 2, 3, 4) = (/ &
 & 0.73427E+03_JPRB,0.68588E+03_JPRB,0.63749E+03_JPRB,0.58910E+03_JPRB,0.59435E+03_JPRB, &
 & 0.61627E+03_JPRB,0.46147E+03_JPRB,0.42088E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 3, 3, 4) = (/ &
 & 0.71948E+03_JPRB,0.67294E+03_JPRB,0.62640E+03_JPRB,0.57986E+03_JPRB,0.59145E+03_JPRB, &
 & 0.60690E+03_JPRB,0.45675E+03_JPRB,0.41918E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 4, 3, 4) = (/ &
 & 0.70620E+03_JPRB,0.66132E+03_JPRB,0.61644E+03_JPRB,0.57156E+03_JPRB,0.58863E+03_JPRB, &
 & 0.59842E+03_JPRB,0.45269E+03_JPRB,0.41765E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 5, 3, 4) = (/ &
 & 0.69421E+03_JPRB,0.65083E+03_JPRB,0.60744E+03_JPRB,0.56406E+03_JPRB,0.58580E+03_JPRB, &
 & 0.59032E+03_JPRB,0.44923E+03_JPRB,0.41627E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 1, 4, 4) = (/ &
 & 0.70765E+03_JPRB,0.66259E+03_JPRB,0.61753E+03_JPRB,0.57246E+03_JPRB,0.59114E+03_JPRB, &
 & 0.59936E+03_JPRB,0.45313E+03_JPRB,0.41781E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 2, 4, 4) = (/ &
 & 0.69300E+03_JPRB,0.64977E+03_JPRB,0.60654E+03_JPRB,0.56330E+03_JPRB,0.58834E+03_JPRB, &
 & 0.58949E+03_JPRB,0.44892E+03_JPRB,0.41613E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 3, 4, 4) = (/ &
 & 0.67997E+03_JPRB,0.63837E+03_JPRB,0.59677E+03_JPRB,0.55516E+03_JPRB,0.58563E+03_JPRB, &
 & 0.58057E+03_JPRB,0.44538E+03_JPRB,0.41463E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 4, 4, 4) = (/ &
 & 0.66833E+03_JPRB,0.62818E+03_JPRB,0.58803E+03_JPRB,0.54788E+03_JPRB,0.58292E+03_JPRB, &
 & 0.57257E+03_JPRB,0.44238E+03_JPRB,0.41329E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 5, 4, 4) = (/ &
 & 0.65784E+03_JPRB,0.61901E+03_JPRB,0.58017E+03_JPRB,0.54133E+03_JPRB,0.58031E+03_JPRB, &
 & 0.56522E+03_JPRB,0.43982E+03_JPRB,0.41208E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 1, 5, 4) = (/ &
 & 0.67096E+03_JPRB,0.63048E+03_JPRB,0.59001E+03_JPRB,0.54953E+03_JPRB,0.58521E+03_JPRB, &
 & 0.57438E+03_JPRB,0.44304E+03_JPRB,0.41359E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 2, 5, 4) = (/ &
 & 0.65799E+03_JPRB,0.61913E+03_JPRB,0.58028E+03_JPRB,0.54142E+03_JPRB,0.58256E+03_JPRB, &
 & 0.56532E+03_JPRB,0.43984E+03_JPRB,0.41210E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 3, 5, 4) = (/ &
 & 0.64651E+03_JPRB,0.60909E+03_JPRB,0.57167E+03_JPRB,0.53427E+03_JPRB,0.57997E+03_JPRB, &
 & 0.55705E+03_JPRB,0.43718E+03_JPRB,0.41077E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 4, 5, 4) = (/ &
 & 0.63629E+03_JPRB,0.60015E+03_JPRB,0.56401E+03_JPRB,0.52793E+03_JPRB,0.57742E+03_JPRB, &
 & 0.54959E+03_JPRB,0.43482E+03_JPRB,0.40960E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 5, 5, 4) = (/ &
 & 0.62713E+03_JPRB,0.59213E+03_JPRB,0.55713E+03_JPRB,0.52227E+03_JPRB,0.57480E+03_JPRB, &
 & 0.54282E+03_JPRB,0.43271E+03_JPRB,0.40854E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 1, 6, 4) = (/ &
 & 0.64019E+03_JPRB,0.60356E+03_JPRB,0.56693E+03_JPRB,0.53034E+03_JPRB,0.57955E+03_JPRB, &
 & 0.55244E+03_JPRB,0.43572E+03_JPRB,0.41005E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 2, 6, 4) = (/ &
 & 0.62864E+03_JPRB,0.59346E+03_JPRB,0.55827E+03_JPRB,0.52321E+03_JPRB,0.57700E+03_JPRB, &
 & 0.54395E+03_JPRB,0.43306E+03_JPRB,0.40872E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 3, 6, 4) = (/ &
 & 0.61849E+03_JPRB,0.58457E+03_JPRB,0.55065E+03_JPRB,0.51703E+03_JPRB,0.57439E+03_JPRB, &
 & 0.53634E+03_JPRB,0.43072E+03_JPRB,0.40755E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 4, 6, 4) = (/ &
 & 0.60948E+03_JPRB,0.57669E+03_JPRB,0.54390E+03_JPRB,0.51158E+03_JPRB,0.57170E+03_JPRB, &
 & 0.52946E+03_JPRB,0.42865E+03_JPRB,0.40651E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 5, 6, 4) = (/ &
 & 0.60143E+03_JPRB,0.56965E+03_JPRB,0.53786E+03_JPRB,0.50675E+03_JPRB,0.56897E+03_JPRB, &
 & 0.52321E+03_JPRB,0.42679E+03_JPRB,0.40558E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 1, 7, 4) = (/ &
 & 0.61399E+03_JPRB,0.58064E+03_JPRB,0.54728E+03_JPRB,0.51440E+03_JPRB,0.57380E+03_JPRB, &
 & 0.53292E+03_JPRB,0.42969E+03_JPRB,0.40703E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 2, 7, 4) = (/ &
 & 0.60371E+03_JPRB,0.57164E+03_JPRB,0.53957E+03_JPRB,0.50828E+03_JPRB,0.57103E+03_JPRB, &
 & 0.52498E+03_JPRB,0.42732E+03_JPRB,0.40585E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 3, 7, 4) = (/ &
 & 0.59471E+03_JPRB,0.56376E+03_JPRB,0.53282E+03_JPRB,0.50302E+03_JPRB,0.56836E+03_JPRB, &
 & 0.51802E+03_JPRB,0.42525E+03_JPRB,0.40481E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 4, 7, 4) = (/ &
 & 0.58676E+03_JPRB,0.55681E+03_JPRB,0.52686E+03_JPRB,0.49842E+03_JPRB,0.56580E+03_JPRB, &
 & 0.51197E+03_JPRB,0.42342E+03_JPRB,0.40389E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 5, 7, 4) = (/ &
 & 0.57970E+03_JPRB,0.55063E+03_JPRB,0.52156E+03_JPRB,0.49437E+03_JPRB,0.56333E+03_JPRB, &
 & 0.50656E+03_JPRB,0.42179E+03_JPRB,0.40308E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 1, 8, 4) = (/ &
 & 0.59158E+03_JPRB,0.56102E+03_JPRB,0.53047E+03_JPRB,0.50136E+03_JPRB,0.56762E+03_JPRB, &
 & 0.51564E+03_JPRB,0.42452E+03_JPRB,0.40445E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 2, 8, 4) = (/ &
 & 0.58242E+03_JPRB,0.55301E+03_JPRB,0.52360E+03_JPRB,0.49623E+03_JPRB,0.56499E+03_JPRB, &
 & 0.50866E+03_JPRB,0.42242E+03_JPRB,0.40339E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 3, 8, 4) = (/ &
 & 0.57445E+03_JPRB,0.54604E+03_JPRB,0.51762E+03_JPRB,0.49188E+03_JPRB,0.56245E+03_JPRB, &
 & 0.50238E+03_JPRB,0.42058E+03_JPRB,0.40248E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 4, 8, 4) = (/ &
 & 0.56745E+03_JPRB,0.53991E+03_JPRB,0.51237E+03_JPRB,0.48811E+03_JPRB,0.55998E+03_JPRB, &
 & 0.49675E+03_JPRB,0.41897E+03_JPRB,0.40167E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 5, 8, 4) = (/ &
 & 0.56125E+03_JPRB,0.53448E+03_JPRB,0.50772E+03_JPRB,0.48477E+03_JPRB,0.55757E+03_JPRB, &
 & 0.49178E+03_JPRB,0.41754E+03_JPRB,0.40096E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 1, 9, 4) = (/ &
 & 0.57249E+03_JPRB,0.54432E+03_JPRB,0.51615E+03_JPRB,0.49103E+03_JPRB,0.56159E+03_JPRB, &
 & 0.50080E+03_JPRB,0.42013E+03_JPRB,0.40225E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 2, 9, 4) = (/ &
 & 0.56432E+03_JPRB,0.53718E+03_JPRB,0.51003E+03_JPRB,0.48678E+03_JPRB,0.55899E+03_JPRB, &
 & 0.49424E+03_JPRB,0.41825E+03_JPRB,0.40131E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 3, 9, 4) = (/ &
 & 0.55726E+03_JPRB,0.53099E+03_JPRB,0.50473E+03_JPRB,0.48321E+03_JPRB,0.55650E+03_JPRB, &
 & 0.48858E+03_JPRB,0.41662E+03_JPRB,0.40050E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 4, 9, 4) = (/ &
 & 0.55108E+03_JPRB,0.52559E+03_JPRB,0.50010E+03_JPRB,0.48011E+03_JPRB,0.55416E+03_JPRB, &
 & 0.48367E+03_JPRB,0.41520E+03_JPRB,0.39978E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 5, 9, 4) = (/ &
 & 0.54564E+03_JPRB,0.52083E+03_JPRB,0.49601E+03_JPRB,0.47737E+03_JPRB,0.55194E+03_JPRB, &
 & 0.47938E+03_JPRB,0.41394E+03_JPRB,0.39916E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 1,10, 4) = (/ &
 & 0.55559E+03_JPRB,0.52954E+03_JPRB,0.50348E+03_JPRB,0.48256E+03_JPRB,0.55544E+03_JPRB, &
 & 0.48725E+03_JPRB,0.41624E+03_JPRB,0.40030E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 2,10, 4) = (/ &
 & 0.54839E+03_JPRB,0.52324E+03_JPRB,0.49808E+03_JPRB,0.47910E+03_JPRB,0.55295E+03_JPRB, &
 & 0.48155E+03_JPRB,0.41458E+03_JPRB,0.39948E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 3,10, 4) = (/ &
 & 0.54220E+03_JPRB,0.51781E+03_JPRB,0.49343E+03_JPRB,0.47621E+03_JPRB,0.55067E+03_JPRB, &
 & 0.47667E+03_JPRB,0.41315E+03_JPRB,0.39876E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 4,10, 4) = (/ &
 & 0.53680E+03_JPRB,0.51310E+03_JPRB,0.48939E+03_JPRB,0.47371E+03_JPRB,0.54855E+03_JPRB, &
 & 0.47238E+03_JPRB,0.41191E+03_JPRB,0.39814E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 5,10, 4) = (/ &
 & 0.53207E+03_JPRB,0.50895E+03_JPRB,0.48584E+03_JPRB,0.47148E+03_JPRB,0.54655E+03_JPRB, &
 & 0.46857E+03_JPRB,0.41082E+03_JPRB,0.39760E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 1,11, 4) = (/ &
 & 0.53816E+03_JPRB,0.51428E+03_JPRB,0.49041E+03_JPRB,0.47455E+03_JPRB,0.54857E+03_JPRB, &
 & 0.47346E+03_JPRB,0.41222E+03_JPRB,0.39830E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 2,11, 4) = (/ &
 & 0.53226E+03_JPRB,0.50912E+03_JPRB,0.48598E+03_JPRB,0.47200E+03_JPRB,0.54640E+03_JPRB, &
 & 0.46874E+03_JPRB,0.41086E+03_JPRB,0.39762E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 3,11, 4) = (/ &
 & 0.52718E+03_JPRB,0.50468E+03_JPRB,0.48217E+03_JPRB,0.46982E+03_JPRB,0.54436E+03_JPRB, &
 & 0.46486E+03_JPRB,0.40969E+03_JPRB,0.39703E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 4,11, 4) = (/ &
 & 0.52277E+03_JPRB,0.50081E+03_JPRB,0.47886E+03_JPRB,0.46790E+03_JPRB,0.54248E+03_JPRB, &
 & 0.46109E+03_JPRB,0.40868E+03_JPRB,0.39652E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 5,11, 4) = (/ &
 & 0.51889E+03_JPRB,0.49742E+03_JPRB,0.47595E+03_JPRB,0.46618E+03_JPRB,0.54076E+03_JPRB, &
 & 0.45793E+03_JPRB,0.40778E+03_JPRB,0.39608E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 1,12, 4) = (/ &
 & 0.52385E+03_JPRB,0.50177E+03_JPRB,0.47968E+03_JPRB,0.46863E+03_JPRB,0.54244E+03_JPRB, &
 & 0.46202E+03_JPRB,0.40893E+03_JPRB,0.39665E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 2,12, 4) = (/ &
 & 0.51902E+03_JPRB,0.49754E+03_JPRB,0.47606E+03_JPRB,0.46673E+03_JPRB,0.54050E+03_JPRB, &
 & 0.45805E+03_JPRB,0.40782E+03_JPRB,0.39609E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 3,12, 4) = (/ &
 & 0.51487E+03_JPRB,0.49390E+03_JPRB,0.47294E+03_JPRB,0.46509E+03_JPRB,0.53868E+03_JPRB, &
 & 0.45465E+03_JPRB,0.40686E+03_JPRB,0.39561E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 4,12, 4) = (/ &
 & 0.51125E+03_JPRB,0.49074E+03_JPRB,0.47022E+03_JPRB,0.46362E+03_JPRB,0.53703E+03_JPRB, &
 & 0.45171E+03_JPRB,0.40602E+03_JPRB,0.39520E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 5,12, 4) = (/ &
 & 0.50807E+03_JPRB,0.48796E+03_JPRB,0.46784E+03_JPRB,0.46227E+03_JPRB,0.53558E+03_JPRB, &
 & 0.44916E+03_JPRB,0.40529E+03_JPRB,0.39483E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 1,13, 4) = (/ &
 & 0.51214E+03_JPRB,0.49152E+03_JPRB,0.47089E+03_JPRB,0.46425E+03_JPRB,0.53698E+03_JPRB, &
 & 0.45243E+03_JPRB,0.40623E+03_JPRB,0.39530E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 2,13, 4) = (/ &
 & 0.50819E+03_JPRB,0.48806E+03_JPRB,0.46793E+03_JPRB,0.46281E+03_JPRB,0.53522E+03_JPRB, &
 & 0.44925E+03_JPRB,0.40532E+03_JPRB,0.39485E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 3,13, 4) = (/ &
 & 0.50478E+03_JPRB,0.48508E+03_JPRB,0.46537E+03_JPRB,0.46157E+03_JPRB,0.53378E+03_JPRB, &
 & 0.44654E+03_JPRB,0.40453E+03_JPRB,0.39445E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 4,13, 4) = (/ &
 & 0.50182E+03_JPRB,0.48249E+03_JPRB,0.46315E+03_JPRB,0.46044E+03_JPRB,0.53251E+03_JPRB, &
 & 0.44422E+03_JPRB,0.40385E+03_JPRB,0.39411E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 5,13, 4) = (/ &
 & 0.49922E+03_JPRB,0.48021E+03_JPRB,0.46120E+03_JPRB,0.45936E+03_JPRB,0.53137E+03_JPRB, &
 & 0.44221E+03_JPRB,0.40325E+03_JPRB,0.39381E+03_JPRB,0.38437E+03_JPRB /)  
KA(:, 1, 1, 5) = (/ &
 & 0.13243E+04_JPRB,0.11799E+04_JPRB,0.10354E+04_JPRB,0.89093E+03_JPRB,0.74647E+03_JPRB, &
 & 0.71044E+03_JPRB,0.61021E+03_JPRB,0.64069E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 2, 1, 5) = (/ &
 & 0.12908E+04_JPRB,0.11505E+04_JPRB,0.10102E+04_JPRB,0.86996E+03_JPRB,0.72969E+03_JPRB, &
 & 0.70292E+03_JPRB,0.60750E+03_JPRB,0.63934E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 3, 1, 5) = (/ &
 & 0.12606E+04_JPRB,0.11241E+04_JPRB,0.98763E+03_JPRB,0.85113E+03_JPRB,0.71463E+03_JPRB, &
 & 0.69451E+03_JPRB,0.60507E+03_JPRB,0.63812E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 4, 1, 5) = (/ &
 & 0.12334E+04_JPRB,0.11003E+04_JPRB,0.96722E+03_JPRB,0.83412E+03_JPRB,0.70102E+03_JPRB, &
 & 0.68564E+03_JPRB,0.60287E+03_JPRB,0.63703E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 5, 1, 5) = (/ &
 & 0.12087E+04_JPRB,0.10787E+04_JPRB,0.94870E+03_JPRB,0.81869E+03_JPRB,0.68867E+03_JPRB, &
 & 0.67724E+03_JPRB,0.60088E+03_JPRB,0.63603E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 1, 2, 5) = (/ &
 & 0.12234E+04_JPRB,0.10916E+04_JPRB,0.95972E+03_JPRB,0.82787E+03_JPRB,0.69602E+03_JPRB, &
 & 0.68345E+03_JPRB,0.60207E+03_JPRB,0.63662E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 2, 2, 5) = (/ &
 & 0.11946E+04_JPRB,0.10664E+04_JPRB,0.93814E+03_JPRB,0.80988E+03_JPRB,0.68163E+03_JPRB, &
 & 0.67225E+03_JPRB,0.59975E+03_JPRB,0.63546E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 3, 2, 5) = (/ &
 & 0.11689E+04_JPRB,0.10438E+04_JPRB,0.91881E+03_JPRB,0.79377E+03_JPRB,0.66882E+03_JPRB, &
 & 0.66165E+03_JPRB,0.59767E+03_JPRB,0.63442E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 4, 2, 5) = (/ &
 & 0.11456E+04_JPRB,0.10235E+04_JPRB,0.90139E+03_JPRB,0.77926E+03_JPRB,0.65759E+03_JPRB, &
 & 0.65058E+03_JPRB,0.59579E+03_JPRB,0.63348E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 5, 2, 5) = (/ &
 & 0.11246E+04_JPRB,0.10051E+04_JPRB,0.88561E+03_JPRB,0.76611E+03_JPRB,0.64778E+03_JPRB, &
 & 0.64016E+03_JPRB,0.59410E+03_JPRB,0.63264E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 1, 3, 5) = (/ &
 & 0.11441E+04_JPRB,0.10221E+04_JPRB,0.90021E+03_JPRB,0.77828E+03_JPRB,0.65728E+03_JPRB, &
 & 0.64981E+03_JPRB,0.59567E+03_JPRB,0.63342E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 2, 3, 5) = (/ &
 & 0.11188E+04_JPRB,0.10001E+04_JPRB,0.88128E+03_JPRB,0.76250E+03_JPRB,0.64582E+03_JPRB, &
 & 0.63739E+03_JPRB,0.59363E+03_JPRB,0.63240E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 3, 3, 5) = (/ &
 & 0.10963E+04_JPRB,0.98033E+03_JPRB,0.86437E+03_JPRB,0.74841E+03_JPRB,0.63611E+03_JPRB, &
 & 0.62581E+03_JPRB,0.59181E+03_JPRB,0.63149E+03_JPRB,0.67118E+03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART3',1,ZHOOK_HANDLE)
END SUBROUTINE PART3


SUBROUTINE PART4

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART4',0,ZHOOK_HANDLE)


KA(:, 4, 3, 5) = (/ &
 & 0.10761E+04_JPRB,0.96263E+03_JPRB,0.84920E+03_JPRB,0.73577E+03_JPRB,0.62780E+03_JPRB, &
 & 0.61513E+03_JPRB,0.59018E+03_JPRB,0.63068E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 5, 3, 5) = (/ &
 & 0.10578E+04_JPRB,0.94664E+03_JPRB,0.83549E+03_JPRB,0.72435E+03_JPRB,0.62066E+03_JPRB, &
 & 0.60588E+03_JPRB,0.58871E+03_JPRB,0.62994E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 1, 4, 5) = (/ &
 & 0.10783E+04_JPRB,0.96456E+03_JPRB,0.85086E+03_JPRB,0.73715E+03_JPRB,0.62971E+03_JPRB, &
 & 0.61628E+03_JPRB,0.59036E+03_JPRB,0.63077E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 2, 4, 5) = (/ &
 & 0.10559E+04_JPRB,0.94502E+03_JPRB,0.83411E+03_JPRB,0.72319E+03_JPRB,0.62145E+03_JPRB, &
 & 0.60490E+03_JPRB,0.58856E+03_JPRB,0.62987E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 3, 4, 5) = (/ &
 & 0.10361E+04_JPRB,0.92766E+03_JPRB,0.81923E+03_JPRB,0.71079E+03_JPRB,0.61457E+03_JPRB, &
 & 0.59452E+03_JPRB,0.58696E+03_JPRB,0.62907E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 4, 4, 5) = (/ &
 & 0.10183E+04_JPRB,0.91213E+03_JPRB,0.80591E+03_JPRB,0.69970E+03_JPRB,0.60876E+03_JPRB, &
 & 0.58559E+03_JPRB,0.58552E+03_JPRB,0.62835E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 5, 4, 5) = (/ &
 & 0.10024E+04_JPRB,0.89816E+03_JPRB,0.79394E+03_JPRB,0.68972E+03_JPRB,0.60374E+03_JPRB, &
 & 0.57800E+03_JPRB,0.58424E+03_JPRB,0.62771E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 1, 5, 5) = (/ &
 & 0.10224E+04_JPRB,0.91564E+03_JPRB,0.80892E+03_JPRB,0.70221E+03_JPRB,0.61144E+03_JPRB, &
 & 0.58757E+03_JPRB,0.58585E+03_JPRB,0.62851E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 2, 5, 5) = (/ &
 & 0.10026E+04_JPRB,0.89835E+03_JPRB,0.79410E+03_JPRB,0.68985E+03_JPRB,0.60588E+03_JPRB, &
 & 0.57810E+03_JPRB,0.58425E+03_JPRB,0.62772E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 3, 5, 5) = (/ &
 & 0.98511E+03_JPRB,0.88305E+03_JPRB,0.78099E+03_JPRB,0.67893E+03_JPRB,0.60138E+03_JPRB, &
 & 0.57034E+03_JPRB,0.58284E+03_JPRB,0.62701E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 4, 5, 5) = (/ &
 & 0.96954E+03_JPRB,0.86942E+03_JPRB,0.76931E+03_JPRB,0.66919E+03_JPRB,0.59759E+03_JPRB, &
 & 0.56378E+03_JPRB,0.58159E+03_JPRB,0.62638E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 5, 5, 5) = (/ &
 & 0.95557E+03_JPRB,0.85720E+03_JPRB,0.75883E+03_JPRB,0.66046E+03_JPRB,0.59436E+03_JPRB, &
 & 0.55823E+03_JPRB,0.58046E+03_JPRB,0.62582E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 1, 6, 5) = (/ &
 & 0.97547E+03_JPRB,0.87461E+03_JPRB,0.77376E+03_JPRB,0.67290E+03_JPRB,0.60045E+03_JPRB, &
 & 0.56624E+03_JPRB,0.58207E+03_JPRB,0.62662E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 2, 6, 5) = (/ &
 & 0.95788E+03_JPRB,0.85922E+03_JPRB,0.76057E+03_JPRB,0.66191E+03_JPRB,0.59710E+03_JPRB, &
 & 0.55912E+03_JPRB,0.58065E+03_JPRB,0.62591E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 3, 6, 5) = (/ &
 & 0.94241E+03_JPRB,0.84568E+03_JPRB,0.74896E+03_JPRB,0.65223E+03_JPRB,0.59434E+03_JPRB, &
 & 0.55328E+03_JPRB,0.57940E+03_JPRB,0.62529E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 4, 6, 5) = (/ &
 & 0.92868E+03_JPRB,0.83367E+03_JPRB,0.73866E+03_JPRB,0.64365E+03_JPRB,0.59182E+03_JPRB, &
 & 0.54839E+03_JPRB,0.57829E+03_JPRB,0.62473E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 5, 6, 5) = (/ &
 & 0.91642E+03_JPRB,0.82295E+03_JPRB,0.72947E+03_JPRB,0.63599E+03_JPRB,0.58948E+03_JPRB, &
 & 0.54428E+03_JPRB,0.57730E+03_JPRB,0.62424E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 1, 7, 5) = (/ &
 & 0.93556E+03_JPRB,0.83969E+03_JPRB,0.74382E+03_JPRB,0.64795E+03_JPRB,0.59420E+03_JPRB, &
 & 0.55081E+03_JPRB,0.57885E+03_JPRB,0.62501E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 2, 7, 5) = (/ &
 & 0.91989E+03_JPRB,0.82598E+03_JPRB,0.73207E+03_JPRB,0.63816E+03_JPRB,0.59179E+03_JPRB, &
 & 0.54542E+03_JPRB,0.57758E+03_JPRB,0.62438E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 3, 7, 5) = (/ &
 & 0.90618E+03_JPRB,0.81398E+03_JPRB,0.72179E+03_JPRB,0.62959E+03_JPRB,0.58955E+03_JPRB, &
 & 0.54102E+03_JPRB,0.57648E+03_JPRB,0.62383E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 4, 7, 5) = (/ &
 & 0.89407E+03_JPRB,0.80339E+03_JPRB,0.71271E+03_JPRB,0.62202E+03_JPRB,0.58737E+03_JPRB, &
 & 0.53729E+03_JPRB,0.57550E+03_JPRB,0.62334E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 5, 7, 5) = (/ &
 & 0.88331E+03_JPRB,0.79397E+03_JPRB,0.70463E+03_JPRB,0.61530E+03_JPRB,0.58524E+03_JPRB, &
 & 0.53413E+03_JPRB,0.57463E+03_JPRB,0.62290E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 1, 8, 5) = (/ &
 & 0.90140E+03_JPRB,0.80981E+03_JPRB,0.71821E+03_JPRB,0.62661E+03_JPRB,0.58941E+03_JPRB, &
 & 0.53953E+03_JPRB,0.57609E+03_JPRB,0.62363E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 2, 8, 5) = (/ &
 & 0.88745E+03_JPRB,0.79760E+03_JPRB,0.70774E+03_JPRB,0.61789E+03_JPRB,0.58727E+03_JPRB, &
 & 0.53533E+03_JPRB,0.57497E+03_JPRB,0.62307E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 3, 8, 5) = (/ &
 & 0.87531E+03_JPRB,0.78697E+03_JPRB,0.69863E+03_JPRB,0.61030E+03_JPRB,0.58522E+03_JPRB, &
 & 0.53203E+03_JPRB,0.57399E+03_JPRB,0.62258E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 4, 8, 5) = (/ &
 & 0.86464E+03_JPRB,0.77763E+03_JPRB,0.69063E+03_JPRB,0.60363E+03_JPRB,0.58317E+03_JPRB, &
 & 0.52938E+03_JPRB,0.57313E+03_JPRB,0.62215E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 5, 8, 5) = (/ &
 & 0.85519E+03_JPRB,0.76937E+03_JPRB,0.68354E+03_JPRB,0.59772E+03_JPRB,0.58120E+03_JPRB, &
 & 0.52712E+03_JPRB,0.57236E+03_JPRB,0.62177E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 1, 9, 5) = (/ &
 & 0.87232E+03_JPRB,0.78435E+03_JPRB,0.69639E+03_JPRB,0.60843E+03_JPRB,0.58508E+03_JPRB, &
 & 0.53128E+03_JPRB,0.57375E+03_JPRB,0.62246E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 2, 9, 5) = (/ &
 & 0.85988E+03_JPRB,0.77347E+03_JPRB,0.68706E+03_JPRB,0.60065E+03_JPRB,0.58302E+03_JPRB, &
 & 0.52823E+03_JPRB,0.57274E+03_JPRB,0.62196E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 3, 9, 5) = (/ &
 & 0.84911E+03_JPRB,0.76405E+03_JPRB,0.67898E+03_JPRB,0.59392E+03_JPRB,0.58102E+03_JPRB, &
 & 0.52572E+03_JPRB,0.57187E+03_JPRB,0.62153E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 4, 9, 5) = (/ &
 & 0.83970E+03_JPRB,0.75581E+03_JPRB,0.67193E+03_JPRB,0.58804E+03_JPRB,0.57906E+03_JPRB, &
 & 0.52364E+03_JPRB,0.57111E+03_JPRB,0.62115E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 5, 9, 5) = (/ &
 & 0.83140E+03_JPRB,0.74855E+03_JPRB,0.66571E+03_JPRB,0.58286E+03_JPRB,0.57713E+03_JPRB, &
 & 0.52190E+03_JPRB,0.57045E+03_JPRB,0.62081E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 1,10, 5) = (/ &
 & 0.84657E+03_JPRB,0.76183E+03_JPRB,0.67708E+03_JPRB,0.59234E+03_JPRB,0.58061E+03_JPRB, &
 & 0.52515E+03_JPRB,0.57167E+03_JPRB,0.62142E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 2,10, 5) = (/ &
 & 0.83560E+03_JPRB,0.75223E+03_JPRB,0.66886E+03_JPRB,0.58548E+03_JPRB,0.57865E+03_JPRB, &
 & 0.52276E+03_JPRB,0.57078E+03_JPRB,0.62098E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 3,10, 5) = (/ &
 & 0.82616E+03_JPRB,0.74397E+03_JPRB,0.66177E+03_JPRB,0.57958E+03_JPRB,0.57663E+03_JPRB, &
 & 0.52085E+03_JPRB,0.57002E+03_JPRB,0.62060E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 4,10, 5) = (/ &
 & 0.81794E+03_JPRB,0.73678E+03_JPRB,0.65561E+03_JPRB,0.57444E+03_JPRB,0.57466E+03_JPRB, &
 & 0.51933E+03_JPRB,0.56936E+03_JPRB,0.62027E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 5,10, 5) = (/ &
 & 0.81073E+03_JPRB,0.73047E+03_JPRB,0.65020E+03_JPRB,0.56994E+03_JPRB,0.57276E+03_JPRB, &
 & 0.51811E+03_JPRB,0.56878E+03_JPRB,0.61998E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 1,11, 5) = (/ &
 & 0.82001E+03_JPRB,0.73859E+03_JPRB,0.65716E+03_JPRB,0.57574E+03_JPRB,0.57531E+03_JPRB, &
 & 0.51970E+03_JPRB,0.56953E+03_JPRB,0.62035E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 2,11, 5) = (/ &
 & 0.81102E+03_JPRB,0.73072E+03_JPRB,0.65042E+03_JPRB,0.57012E+03_JPRB,0.57326E+03_JPRB, &
 & 0.51814E+03_JPRB,0.56880E+03_JPRB,0.61999E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 3,11, 5) = (/ &
 & 0.80328E+03_JPRB,0.72395E+03_JPRB,0.64462E+03_JPRB,0.56528E+03_JPRB,0.57135E+03_JPRB, &
 & 0.51670E+03_JPRB,0.56818E+03_JPRB,0.61968E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 4,11, 5) = (/ &
 & 0.79655E+03_JPRB,0.71806E+03_JPRB,0.63957E+03_JPRB,0.56108E+03_JPRB,0.56956E+03_JPRB, &
 & 0.51595E+03_JPRB,0.56763E+03_JPRB,0.61941E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 5,11, 5) = (/ &
 & 0.79064E+03_JPRB,0.71289E+03_JPRB,0.63514E+03_JPRB,0.55738E+03_JPRB,0.56781E+03_JPRB, &
 & 0.51517E+03_JPRB,0.56716E+03_JPRB,0.61917E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 1,12, 5) = (/ &
 & 0.79821E+03_JPRB,0.71951E+03_JPRB,0.64081E+03_JPRB,0.56211E+03_JPRB,0.57002E+03_JPRB, &
 & 0.51613E+03_JPRB,0.56777E+03_JPRB,0.61947E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 2,12, 5) = (/ &
 & 0.79085E+03_JPRB,0.71307E+03_JPRB,0.63529E+03_JPRB,0.55751E+03_JPRB,0.56813E+03_JPRB, &
 & 0.51519E+03_JPRB,0.56717E+03_JPRB,0.61918E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 3,12, 5) = (/ &
 & 0.78452E+03_JPRB,0.70753E+03_JPRB,0.63054E+03_JPRB,0.55355E+03_JPRB,0.56648E+03_JPRB, &
 & 0.51441E+03_JPRB,0.56666E+03_JPRB,0.61892E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 4,12, 5) = (/ &
 & 0.77901E+03_JPRB,0.70271E+03_JPRB,0.62641E+03_JPRB,0.55011E+03_JPRB,0.56489E+03_JPRB, &
 & 0.51374E+03_JPRB,0.56622E+03_JPRB,0.61870E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 5,12, 5) = (/ &
 & 0.77417E+03_JPRB,0.69847E+03_JPRB,0.62278E+03_JPRB,0.54708E+03_JPRB,0.56325E+03_JPRB, &
 & 0.51315E+03_JPRB,0.56583E+03_JPRB,0.61850E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 1,13, 5) = (/ &
 & 0.78036E+03_JPRB,0.70389E+03_JPRB,0.62743E+03_JPRB,0.55096E+03_JPRB,0.56495E+03_JPRB, &
 & 0.51390E+03_JPRB,0.56633E+03_JPRB,0.61875E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 2,13, 5) = (/ &
 & 0.77434E+03_JPRB,0.69862E+03_JPRB,0.62291E+03_JPRB,0.54719E+03_JPRB,0.56343E+03_JPRB, &
 & 0.51318E+03_JPRB,0.56584E+03_JPRB,0.61851E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 3,13, 5) = (/ &
 & 0.76915E+03_JPRB,0.69408E+03_JPRB,0.61902E+03_JPRB,0.54395E+03_JPRB,0.56189E+03_JPRB, &
 & 0.51255E+03_JPRB,0.56542E+03_JPRB,0.61830E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 4,13, 5) = (/ &
 & 0.76464E+03_JPRB,0.69014E+03_JPRB,0.61563E+03_JPRB,0.54113E+03_JPRB,0.56027E+03_JPRB, &
 & 0.51200E+03_JPRB,0.56506E+03_JPRB,0.61812E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 5,13, 5) = (/ &
 & 0.76068E+03_JPRB,0.68667E+03_JPRB,0.61266E+03_JPRB,0.53865E+03_JPRB,0.55865E+03_JPRB, &
 & 0.51152E+03_JPRB,0.56474E+03_JPRB,0.61796E+03_JPRB,0.67118E+03_JPRB /)  
KA(:, 1, 1, 6) = (/ &
 & 0.16832E+04_JPRB,0.14832E+04_JPRB,0.12833E+04_JPRB,0.10834E+04_JPRB,0.88343E+03_JPRB, &
 & 0.73047E+03_JPRB,0.75923E+03_JPRB,0.85568E+03_JPRB,0.94989E+03_JPRB /)  
KA(:, 2, 1, 6) = (/ &
 & 0.16405E+04_JPRB,0.14459E+04_JPRB,0.12513E+04_JPRB,0.10567E+04_JPRB,0.86211E+03_JPRB, &
 & 0.72257E+03_JPRB,0.75791E+03_JPRB,0.85457E+03_JPRB,0.94915E+03_JPRB /)  
KA(:, 3, 1, 6) = (/ &
 & 0.16022E+04_JPRB,0.14124E+04_JPRB,0.12226E+04_JPRB,0.10328E+04_JPRB,0.84296E+03_JPRB, &
 & 0.71182E+03_JPRB,0.75643E+03_JPRB,0.85315E+03_JPRB,0.94805E+03_JPRB /)  
KA(:, 4, 1, 6) = (/ &
 & 0.15677E+04_JPRB,0.13822E+04_JPRB,0.11967E+04_JPRB,0.10112E+04_JPRB,0.82566E+03_JPRB, &
 & 0.70003E+03_JPRB,0.75475E+03_JPRB,0.85145E+03_JPRB,0.94659E+03_JPRB /)  
KA(:, 5, 1, 6) = (/ &
 & 0.15363E+04_JPRB,0.13547E+04_JPRB,0.11731E+04_JPRB,0.99155E+03_JPRB,0.80997E+03_JPRB, &
 & 0.68802E+03_JPRB,0.75277E+03_JPRB,0.84941E+03_JPRB,0.94478E+03_JPRB /)  
KA(:, 1, 2, 6) = (/ &
 & 0.15549E+04_JPRB,0.13710E+04_JPRB,0.11871E+04_JPRB,0.10032E+04_JPRB,0.81930E+03_JPRB, &
 & 0.69644E+03_JPRB,0.75599E+03_JPRB,0.85402E+03_JPRB,0.95009E+03_JPRB /)  
KA(:, 2, 2, 6) = (/ &
 & 0.15184E+04_JPRB,0.13390E+04_JPRB,0.11597E+04_JPRB,0.98036E+03_JPRB,0.80102E+03_JPRB, &
 & 0.68214E+03_JPRB,0.75486E+03_JPRB,0.85308E+03_JPRB,0.94950E+03_JPRB /)  
KA(:, 3, 2, 6) = (/ &
 & 0.14856E+04_JPRB,0.13104E+04_JPRB,0.11351E+04_JPRB,0.95988E+03_JPRB,0.78464E+03_JPRB, &
 & 0.67032E+03_JPRB,0.75359E+03_JPRB,0.85186E+03_JPRB,0.94855E+03_JPRB /)  
KA(:, 4, 2, 6) = (/ &
 & 0.14561E+04_JPRB,0.12845E+04_JPRB,0.11130E+04_JPRB,0.94143E+03_JPRB,0.76988E+03_JPRB, &
 & 0.66240E+03_JPRB,0.75215E+03_JPRB,0.85037E+03_JPRB,0.94724E+03_JPRB /)  
KA(:, 5, 2, 6) = (/ &
 & 0.14294E+04_JPRB,0.12611E+04_JPRB,0.10929E+04_JPRB,0.92472E+03_JPRB,0.75651E+03_JPRB, &
 & 0.65660E+03_JPRB,0.75042E+03_JPRB,0.84857E+03_JPRB,0.94557E+03_JPRB /)  
KA(:, 1, 3, 6) = (/ &
 & 0.14541E+04_JPRB,0.12828E+04_JPRB,0.11115E+04_JPRB,0.94019E+03_JPRB,0.76889E+03_JPRB, &
 & 0.66226E+03_JPRB,0.75340E+03_JPRB,0.85268E+03_JPRB,0.95029E+03_JPRB /)  
KA(:, 2, 3, 6) = (/ &
 & 0.14220E+04_JPRB,0.12547E+04_JPRB,0.10874E+04_JPRB,0.92013E+03_JPRB,0.75284E+03_JPRB, &
 & 0.65611E+03_JPRB,0.75249E+03_JPRB,0.85200E+03_JPRB,0.94990E+03_JPRB /)  
KA(:, 3, 3, 6) = (/ &
 & 0.13934E+04_JPRB,0.12297E+04_JPRB,0.10659E+04_JPRB,0.90223E+03_JPRB,0.73852E+03_JPRB, &
 & 0.65222E+03_JPRB,0.75143E+03_JPRB,0.85101E+03_JPRB,0.94916E+03_JPRB /)  
KA(:, 4, 3, 6) = (/ &
 & 0.13676E+04_JPRB,0.12071E+04_JPRB,0.10467E+04_JPRB,0.88615E+03_JPRB,0.72566E+03_JPRB, &
 & 0.64945E+03_JPRB,0.75024E+03_JPRB,0.84977E+03_JPRB,0.94807E+03_JPRB /)  
KA(:, 5, 3, 6) = (/ &
 & 0.13444E+04_JPRB,0.11868E+04_JPRB,0.10292E+04_JPRB,0.87164E+03_JPRB,0.71405E+03_JPRB, &
 & 0.64733E+03_JPRB,0.74880E+03_JPRB,0.84822E+03_JPRB,0.94662E+03_JPRB /)  
KA(:, 1, 4, 6) = (/ &
 & 0.13705E+04_JPRB,0.12096E+04_JPRB,0.10488E+04_JPRB,0.88791E+03_JPRB,0.72707E+03_JPRB, &
 & 0.64976E+03_JPRB,0.75119E+03_JPRB,0.85151E+03_JPRB,0.95037E+03_JPRB /)  
KA(:, 2, 4, 6) = (/ &
 & 0.13421E+04_JPRB,0.11848E+04_JPRB,0.10275E+04_JPRB,0.87017E+03_JPRB,0.71287E+03_JPRB, &
 & 0.64785E+03_JPRB,0.75047E+03_JPRB,0.85104E+03_JPRB,0.95019E+03_JPRB /)  
KA(:, 3, 4, 6) = (/ &
 & 0.13169E+04_JPRB,0.11627E+04_JPRB,0.10086E+04_JPRB,0.85441E+03_JPRB,0.70026E+03_JPRB, &
 & 0.64696E+03_JPRB,0.74964E+03_JPRB,0.85031E+03_JPRB,0.94968E+03_JPRB /)  
KA(:, 4, 4, 6) = (/ &
 & 0.12943E+04_JPRB,0.11430E+04_JPRB,0.99164E+03_JPRB,0.84031E+03_JPRB,0.68898E+03_JPRB, &
 & 0.64601E+03_JPRB,0.74865E+03_JPRB,0.84930E+03_JPRB,0.94882E+03_JPRB /)  
KA(:, 5, 4, 6) = (/ &
 & 0.12740E+04_JPRB,0.11252E+04_JPRB,0.97642E+03_JPRB,0.82763E+03_JPRB,0.67884E+03_JPRB, &
 & 0.64496E+03_JPRB,0.74747E+03_JPRB,0.84802E+03_JPRB,0.94760E+03_JPRB /)  
KA(:, 1, 5, 6) = (/ &
 & 0.12994E+04_JPRB,0.11474E+04_JPRB,0.99546E+03_JPRB,0.84350E+03_JPRB,0.69153E+03_JPRB, &
 & 0.64599E+03_JPRB,0.74922E+03_JPRB,0.85040E+03_JPRB,0.95032E+03_JPRB /)  
KA(:, 2, 5, 6) = (/ &
 & 0.12743E+04_JPRB,0.11254E+04_JPRB,0.97662E+03_JPRB,0.82780E+03_JPRB,0.67897E+03_JPRB, &
 & 0.64529E+03_JPRB,0.74869E+03_JPRB,0.85015E+03_JPRB,0.95034E+03_JPRB /)  
KA(:, 3, 5, 6) = (/ &
 & 0.12521E+04_JPRB,0.11060E+04_JPRB,0.95996E+03_JPRB,0.81391E+03_JPRB,0.66786E+03_JPRB, &
 & 0.64458E+03_JPRB,0.74805E+03_JPRB,0.84965E+03_JPRB,0.95004E+03_JPRB /)  
KA(:, 4, 5, 6) = (/ &
 & 0.12323E+04_JPRB,0.10887E+04_JPRB,0.94511E+03_JPRB,0.80154E+03_JPRB,0.65797E+03_JPRB, &
 & 0.64380E+03_JPRB,0.74727E+03_JPRB,0.84886E+03_JPRB,0.94940E+03_JPRB /)  
KA(:, 5, 5, 6) = (/ &
 & 0.12145E+04_JPRB,0.10732E+04_JPRB,0.93180E+03_JPRB,0.79045E+03_JPRB,0.64909E+03_JPRB, &
 & 0.64294E+03_JPRB,0.74629E+03_JPRB,0.84781E+03_JPRB,0.94841E+03_JPRB /)  
KA(:, 1, 6, 6) = (/ &
 & 0.12398E+04_JPRB,0.10953E+04_JPRB,0.95077E+03_JPRB,0.80625E+03_JPRB,0.66174E+03_JPRB, &
 & 0.64362E+03_JPRB,0.74747E+03_JPRB,0.84935E+03_JPRB,0.95014E+03_JPRB /)  
KA(:, 2, 6, 6) = (/ &
 & 0.12174E+04_JPRB,0.10757E+04_JPRB,0.93400E+03_JPRB,0.79228E+03_JPRB,0.65056E+03_JPRB, &
 & 0.64308E+03_JPRB,0.74712E+03_JPRB,0.84932E+03_JPRB,0.95036E+03_JPRB /)  
KA(:, 3, 6, 6) = (/ &
 & 0.11978E+04_JPRB,0.10585E+04_JPRB,0.91925E+03_JPRB,0.77999E+03_JPRB,0.64087E+03_JPRB, &
 & 0.64253E+03_JPRB,0.74666E+03_JPRB,0.84902E+03_JPRB,0.95027E+03_JPRB /)  
KA(:, 4, 6, 6) = (/ &
 & 0.11803E+04_JPRB,0.10432E+04_JPRB,0.90616E+03_JPRB,0.76908E+03_JPRB,0.63262E+03_JPRB, &
 & 0.64192E+03_JPRB,0.74606E+03_JPRB,0.84847E+03_JPRB,0.94985E+03_JPRB /)  
KA(:, 5, 6, 6) = (/ &
 & 0.11647E+04_JPRB,0.10296E+04_JPRB,0.89448E+03_JPRB,0.75935E+03_JPRB,0.62549E+03_JPRB, &
 & 0.64122E+03_JPRB,0.74529E+03_JPRB,0.84763E+03_JPRB,0.94909E+03_JPRB /)  
KA(:, 1, 7, 6) = (/ &
 & 0.11891E+04_JPRB,0.10509E+04_JPRB,0.91272E+03_JPRB,0.77455E+03_JPRB,0.63693E+03_JPRB, &
 & 0.64154E+03_JPRB,0.74584E+03_JPRB,0.84830E+03_JPRB,0.94975E+03_JPRB /)  
KA(:, 2, 7, 6) = (/ &
 & 0.11692E+04_JPRB,0.10335E+04_JPRB,0.89779E+03_JPRB,0.76210E+03_JPRB,0.62795E+03_JPRB, &
 & 0.64115E+03_JPRB,0.74575E+03_JPRB,0.84848E+03_JPRB,0.95025E+03_JPRB /)  
KA(:, 3, 7, 6) = (/ &
 & 0.11517E+04_JPRB,0.10182E+04_JPRB,0.88471E+03_JPRB,0.75121E+03_JPRB,0.62051E+03_JPRB, &
 & 0.64074E+03_JPRB,0.74542E+03_JPRB,0.84840E+03_JPRB,0.95037E+03_JPRB /)  
KA(:, 4, 7, 6) = (/ &
 & 0.11363E+04_JPRB,0.10048E+04_JPRB,0.87317E+03_JPRB,0.74159E+03_JPRB,0.61432E+03_JPRB, &
 & 0.64028E+03_JPRB,0.74499E+03_JPRB,0.84806E+03_JPRB,0.95015E+03_JPRB /)  
KA(:, 5, 7, 6) = (/ &
 & 0.11227E+04_JPRB,0.99279E+03_JPRB,0.86291E+03_JPRB,0.73304E+03_JPRB,0.60908E+03_JPRB, &
 & 0.63974E+03_JPRB,0.74440E+03_JPRB,0.84744E+03_JPRB,0.94961E+03_JPRB /)  
KA(:, 1, 8, 6) = (/ &
 & 0.11457E+04_JPRB,0.10129E+04_JPRB,0.88017E+03_JPRB,0.74742E+03_JPRB,0.61848E+03_JPRB, &
 & 0.63968E+03_JPRB,0.74433E+03_JPRB,0.84725E+03_JPRB,0.94927E+03_JPRB /)  
KA(:, 2, 8, 6) = (/ &
 & 0.11279E+04_JPRB,0.99740E+03_JPRB,0.86687E+03_JPRB,0.73633E+03_JPRB,0.61183E+03_JPRB, &
 & 0.63944E+03_JPRB,0.74439E+03_JPRB,0.84765E+03_JPRB,0.94999E+03_JPRB /)  
KA(:, 3, 8, 6) = (/ &
 & 0.11125E+04_JPRB,0.98389E+03_JPRB,0.85529E+03_JPRB,0.72668E+03_JPRB,0.60652E+03_JPRB, &
 & 0.63917E+03_JPRB,0.74428E+03_JPRB,0.84777E+03_JPRB,0.95034E+03_JPRB /)  
KA(:, 4, 8, 6) = (/ &
 & 0.10989E+04_JPRB,0.97202E+03_JPRB,0.84512E+03_JPRB,0.71821E+03_JPRB,0.60224E+03_JPRB, &
 & 0.63885E+03_JPRB,0.74401E+03_JPRB,0.84763E+03_JPRB,0.95032E+03_JPRB /)  
KA(:, 5, 8, 6) = (/ &
 & 0.10869E+04_JPRB,0.96152E+03_JPRB,0.83611E+03_JPRB,0.71070E+03_JPRB,0.59867E+03_JPRB, &
 & 0.63844E+03_JPRB,0.74359E+03_JPRB,0.84721E+03_JPRB,0.94997E+03_JPRB /)  
KA(:, 1, 9, 6) = (/ &
 & 0.11087E+04_JPRB,0.98057E+03_JPRB,0.85244E+03_JPRB,0.72431E+03_JPRB,0.60583E+03_JPRB, &
 & 0.63802E+03_JPRB,0.74290E+03_JPRB,0.84619E+03_JPRB,0.94868E+03_JPRB /)  
KA(:, 2, 9, 6) = (/ &
 & 0.10929E+04_JPRB,0.96673E+03_JPRB,0.84058E+03_JPRB,0.71443E+03_JPRB,0.60128E+03_JPRB, &
 & 0.63792E+03_JPRB,0.74318E+03_JPRB,0.84681E+03_JPRB,0.94962E+03_JPRB /)  
KA(:, 3, 9, 6) = (/ &
 & 0.10792E+04_JPRB,0.95475E+03_JPRB,0.83031E+03_JPRB,0.70587E+03_JPRB,0.59784E+03_JPRB, &
 & 0.63778E+03_JPRB,0.74323E+03_JPRB,0.84713E+03_JPRB,0.95019E+03_JPRB /)  
KA(:, 4, 9, 6) = (/ &
 & 0.10672E+04_JPRB,0.94429E+03_JPRB,0.82134E+03_JPRB,0.69840E+03_JPRB,0.59517E+03_JPRB, &
 & 0.63759E+03_JPRB,0.74313E+03_JPRB,0.84718E+03_JPRB,0.95037E+03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART4',1,ZHOOK_HANDLE)
END SUBROUTINE PART4


SUBROUTINE PART5

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART5',0,ZHOOK_HANDLE)


KA(:, 5, 9, 6) = (/ &
 & 0.10567E+04_JPRB,0.93506E+03_JPRB,0.81344E+03_JPRB,0.69181E+03_JPRB,0.59278E+03_JPRB, &
 & 0.63730E+03_JPRB,0.74285E+03_JPRB,0.84695E+03_JPRB,0.95021E+03_JPRB /)  
KA(:, 1,10, 6) = (/ &
 & 0.10760E+04_JPRB,0.95193E+03_JPRB,0.82790E+03_JPRB,0.70386E+03_JPRB,0.59768E+03_JPRB, &
 & 0.63651E+03_JPRB,0.74157E+03_JPRB,0.84519E+03_JPRB,0.94809E+03_JPRB /)  
KA(:, 2,10, 6) = (/ &
 & 0.10620E+04_JPRB,0.93974E+03_JPRB,0.81744E+03_JPRB,0.69515E+03_JPRB,0.59477E+03_JPRB, &
 & 0.63656E+03_JPRB,0.74203E+03_JPRB,0.84600E+03_JPRB,0.94921E+03_JPRB /)  
KA(:, 3,10, 6) = (/ &
 & 0.10500E+04_JPRB,0.92923E+03_JPRB,0.80844E+03_JPRB,0.68764E+03_JPRB,0.59242E+03_JPRB, &
 & 0.63654E+03_JPRB,0.74226E+03_JPRB,0.84650E+03_JPRB,0.94996E+03_JPRB /)  
KA(:, 4,10, 6) = (/ &
 & 0.10396E+04_JPRB,0.92010E+03_JPRB,0.80061E+03_JPRB,0.68112E+03_JPRB,0.59042E+03_JPRB, &
 & 0.63645E+03_JPRB,0.74230E+03_JPRB,0.84672E+03_JPRB,0.95033E+03_JPRB /)  
KA(:, 5,10, 6) = (/ &
 & 0.10304E+04_JPRB,0.91207E+03_JPRB,0.79373E+03_JPRB,0.67539E+03_JPRB,0.58849E+03_JPRB, &
 & 0.63628E+03_JPRB,0.74216E+03_JPRB,0.84665E+03_JPRB,0.95033E+03_JPRB /)  
KA(:, 1,11, 6) = (/ &
 & 0.10422E+04_JPRB,0.92239E+03_JPRB,0.80258E+03_JPRB,0.68276E+03_JPRB,0.59118E+03_JPRB, &
 & 0.63525E+03_JPRB,0.74065E+03_JPRB,0.84470E+03_JPRB,0.94808E+03_JPRB /)  
KA(:, 2,11, 6) = (/ &
 & 0.10308E+04_JPRB,0.91240E+03_JPRB,0.79401E+03_JPRB,0.67562E+03_JPRB,0.58920E+03_JPRB, &
 & 0.63540E+03_JPRB,0.74118E+03_JPRB,0.84554E+03_JPRB,0.94920E+03_JPRB /)  
KA(:, 3,11, 6) = (/ &
 & 0.10210E+04_JPRB,0.90379E+03_JPRB,0.78663E+03_JPRB,0.66947E+03_JPRB,0.58737E+03_JPRB, &
 & 0.63545E+03_JPRB,0.74147E+03_JPRB,0.84609E+03_JPRB,0.94995E+03_JPRB /)  
KA(:, 4,11, 6) = (/ &
 & 0.10124E+04_JPRB,0.89631E+03_JPRB,0.78022E+03_JPRB,0.66413E+03_JPRB,0.58569E+03_JPRB, &
 & 0.63543E+03_JPRB,0.74156E+03_JPRB,0.84634E+03_JPRB,0.95033E+03_JPRB /)  
KA(:, 5,11, 6) = (/ &
 & 0.10049E+04_JPRB,0.88974E+03_JPRB,0.77458E+03_JPRB,0.65943E+03_JPRB,0.58398E+03_JPRB, &
 & 0.63532E+03_JPRB,0.74146E+03_JPRB,0.84628E+03_JPRB,0.95033E+03_JPRB /)  
KA(:, 1,12, 6) = (/ &
 & 0.10145E+04_JPRB,0.89815E+03_JPRB,0.78180E+03_JPRB,0.66544E+03_JPRB,0.58616E+03_JPRB, &
 & 0.63421E+03_JPRB,0.73990E+03_JPRB,0.84430E+03_JPRB,0.94808E+03_JPRB /)  
KA(:, 2,12, 6) = (/ &
 & 0.10052E+04_JPRB,0.88997E+03_JPRB,0.77478E+03_JPRB,0.65960E+03_JPRB,0.58451E+03_JPRB, &
 & 0.63444E+03_JPRB,0.74048E+03_JPRB,0.84518E+03_JPRB,0.94921E+03_JPRB /)  
KA(:, 3,12, 6) = (/ &
 & 0.99710E+03_JPRB,0.88292E+03_JPRB,0.76874E+03_JPRB,0.65457E+03_JPRB,0.58265E+03_JPRB, &
 & 0.63457E+03_JPRB,0.74082E+03_JPRB,0.84574E+03_JPRB,0.94995E+03_JPRB /)  
KA(:, 4,12, 6) = (/ &
 & 0.99010E+03_JPRB,0.87679E+03_JPRB,0.76349E+03_JPRB,0.65019E+03_JPRB,0.58054E+03_JPRB, &
 & 0.63460E+03_JPRB,0.74095E+03_JPRB,0.84600E+03_JPRB,0.95033E+03_JPRB /)  
KA(:, 5,12, 6) = (/ &
 & 0.98395E+03_JPRB,0.87141E+03_JPRB,0.75888E+03_JPRB,0.64634E+03_JPRB,0.57844E+03_JPRB, &
 & 0.63453E+03_JPRB,0.74089E+03_JPRB,0.84598E+03_JPRB,0.95033E+03_JPRB /)  
KA(:, 1,13, 6) = (/ &
 & 0.99182E+03_JPRB,0.87830E+03_JPRB,0.76478E+03_JPRB,0.65127E+03_JPRB,0.58122E+03_JPRB, &
 & 0.63336E+03_JPRB,0.73928E+03_JPRB,0.84397E+03_JPRB,0.94808E+03_JPRB /)  
KA(:, 2,13, 6) = (/ &
 & 0.98416E+03_JPRB,0.87160E+03_JPRB,0.75904E+03_JPRB,0.64648E+03_JPRB,0.57888E+03_JPRB, &
 & 0.63366E+03_JPRB,0.73991E+03_JPRB,0.84487E+03_JPRB,0.94921E+03_JPRB /)  
KA(:, 3,13, 6) = (/ &
 & 0.97757E+03_JPRB,0.86583E+03_JPRB,0.75410E+03_JPRB,0.64236E+03_JPRB,0.57650E+03_JPRB, &
 & 0.63384E+03_JPRB,0.74029E+03_JPRB,0.84546E+03_JPRB,0.94996E+03_JPRB /)  
KA(:, 4,13, 6) = (/ &
 & 0.97184E+03_JPRB,0.86082E+03_JPRB,0.74980E+03_JPRB,0.63878E+03_JPRB,0.57428E+03_JPRB, &
 & 0.63391E+03_JPRB,0.74045E+03_JPRB,0.84574E+03_JPRB,0.95033E+03_JPRB /)  
KA(:, 5,13, 6) = (/ &
 & 0.96680E+03_JPRB,0.85641E+03_JPRB,0.74602E+03_JPRB,0.63563E+03_JPRB,0.57218E+03_JPRB, &
 & 0.63388E+03_JPRB,0.74043E+03_JPRB,0.84574E+03_JPRB,0.95033E+03_JPRB /)  
KA(:, 1, 1, 7) = (/ &
 & 0.18845E+04_JPRB,0.16548E+04_JPRB,0.14251E+04_JPRB,0.11953E+04_JPRB,0.96557E+03_JPRB, &
 & 0.74301E+03_JPRB,0.82697E+03_JPRB,0.94964E+03_JPRB,0.10740E+04_JPRB /)  
KA(:, 2, 1, 7) = (/ &
 & 0.18367E+04_JPRB,0.16130E+04_JPRB,0.13892E+04_JPRB,0.11655E+04_JPRB,0.94169E+03_JPRB, &
 & 0.73101E+03_JPRB,0.82533E+03_JPRB,0.94833E+03_JPRB,0.10730E+04_JPRB /)  
KA(:, 3, 1, 7) = (/ &
 & 0.17938E+04_JPRB,0.15755E+04_JPRB,0.13571E+04_JPRB,0.11387E+04_JPRB,0.92025E+03_JPRB, &
 & 0.71894E+03_JPRB,0.82353E+03_JPRB,0.94679E+03_JPRB,0.10715E+04_JPRB /)  
KA(:, 4, 1, 7) = (/ &
 & 0.17551E+04_JPRB,0.15416E+04_JPRB,0.13280E+04_JPRB,0.11145E+04_JPRB,0.90089E+03_JPRB, &
 & 0.70691E+03_JPRB,0.82149E+03_JPRB,0.94487E+03_JPRB,0.10696E+04_JPRB /)  
KA(:, 5, 1, 7) = (/ &
 & 0.17200E+04_JPRB,0.15108E+04_JPRB,0.13017E+04_JPRB,0.10925E+04_JPRB,0.88332E+03_JPRB, &
 & 0.69946E+03_JPRB,0.81920E+03_JPRB,0.94260E+03_JPRB,0.10672E+04_JPRB /)  
KA(:, 1, 2, 7) = (/ &
 & 0.17409E+04_JPRB,0.15291E+04_JPRB,0.13174E+04_JPRB,0.11056E+04_JPRB,0.89377E+03_JPRB, &
 & 0.70556E+03_JPRB,0.82545E+03_JPRB,0.94918E+03_JPRB,0.10743E+04_JPRB /)  
KA(:, 2, 2, 7) = (/ &
 & 0.16999E+04_JPRB,0.14933E+04_JPRB,0.12867E+04_JPRB,0.10800E+04_JPRB,0.87329E+03_JPRB, &
 & 0.70177E+03_JPRB,0.82404E+03_JPRB,0.94806E+03_JPRB,0.10734E+04_JPRB /)  
KA(:, 3, 2, 7) = (/ &
 & 0.16632E+04_JPRB,0.14612E+04_JPRB,0.12591E+04_JPRB,0.10571E+04_JPRB,0.85495E+03_JPRB, &
 & 0.69985E+03_JPRB,0.82245E+03_JPRB,0.94668E+03_JPRB,0.10721E+04_JPRB /)  
KA(:, 4, 2, 7) = (/ &
 & 0.16302E+04_JPRB,0.14323E+04_JPRB,0.12344E+04_JPRB,0.10364E+04_JPRB,0.83842E+03_JPRB, &
 & 0.69778E+03_JPRB,0.82061E+03_JPRB,0.94495E+03_JPRB,0.10705E+04_JPRB /)  
KA(:, 5, 2, 7) = (/ &
 & 0.16003E+04_JPRB,0.14061E+04_JPRB,0.12119E+04_JPRB,0.10177E+04_JPRB,0.82345E+03_JPRB, &
 & 0.69549E+03_JPRB,0.81853E+03_JPRB,0.94286E+03_JPRB,0.10683E+04_JPRB /)  
KA(:, 1, 3, 7) = (/ &
 & 0.16280E+04_JPRB,0.14303E+04_JPRB,0.12327E+04_JPRB,0.10350E+04_JPRB,0.83731E+03_JPRB, &
 & 0.70164E+03_JPRB,0.82440E+03_JPRB,0.94900E+03_JPRB,0.10748E+04_JPRB /)  
KA(:, 2, 3, 7) = (/ &
 & 0.15920E+04_JPRB,0.13989E+04_JPRB,0.12057E+04_JPRB,0.10126E+04_JPRB,0.81934E+03_JPRB, &
 & 0.70016E+03_JPRB,0.82323E+03_JPRB,0.94804E+03_JPRB,0.10740E+04_JPRB /)  
KA(:, 3, 3, 7) = (/ &
 & 0.15600E+04_JPRB,0.13708E+04_JPRB,0.11817E+04_JPRB,0.99252E+03_JPRB,0.80330E+03_JPRB, &
 & 0.69850E+03_JPRB,0.82187E+03_JPRB,0.94688E+03_JPRB,0.10730E+04_JPRB /)  
KA(:, 4, 3, 7) = (/ &
 & 0.15312E+04_JPRB,0.13457E+04_JPRB,0.11601E+04_JPRB,0.97452E+03_JPRB,0.78890E+03_JPRB, &
 & 0.69669E+03_JPRB,0.82029E+03_JPRB,0.94542E+03_JPRB,0.10716E+04_JPRB /)  
KA(:, 5, 3, 7) = (/ &
 & 0.15052E+04_JPRB,0.13229E+04_JPRB,0.11406E+04_JPRB,0.95827E+03_JPRB,0.77590E+03_JPRB, &
 & 0.69468E+03_JPRB,0.81844E+03_JPRB,0.94358E+03_JPRB,0.10697E+04_JPRB /)  
KA(:, 1, 4, 7) = (/ &
 & 0.15343E+04_JPRB,0.13484E+04_JPRB,0.11625E+04_JPRB,0.97650E+03_JPRB,0.79047E+03_JPRB, &
 & 0.70005E+03_JPRB,0.82352E+03_JPRB,0.94883E+03_JPRB,0.10751E+04_JPRB /)  
KA(:, 2, 4, 7) = (/ &
 & 0.15026E+04_JPRB,0.13206E+04_JPRB,0.11386E+04_JPRB,0.95663E+03_JPRB,0.77458E+03_JPRB, &
 & 0.69884E+03_JPRB,0.82260E+03_JPRB,0.94808E+03_JPRB,0.10745E+04_JPRB /)  
KA(:, 3, 4, 7) = (/ &
 & 0.14743E+04_JPRB,0.12959E+04_JPRB,0.11175E+04_JPRB,0.93898E+03_JPRB,0.76046E+03_JPRB, &
 & 0.69743E+03_JPRB,0.82145E+03_JPRB,0.94711E+03_JPRB,0.10737E+04_JPRB /)  
KA(:, 4, 4, 7) = (/ &
 & 0.14491E+04_JPRB,0.12738E+04_JPRB,0.10985E+04_JPRB,0.92319E+03_JPRB,0.74783E+03_JPRB, &
 & 0.69586E+03_JPRB,0.82010E+03_JPRB,0.94588E+03_JPRB,0.10725E+04_JPRB /)  
KA(:, 5, 4, 7) = (/ &
 & 0.14263E+04_JPRB,0.12539E+04_JPRB,0.10815E+04_JPRB,0.90900E+03_JPRB,0.73646E+03_JPRB, &
 & 0.69412E+03_JPRB,0.81852E+03_JPRB,0.94430E+03_JPRB,0.10710E+04_JPRB /)  
KA(:, 1, 5, 7) = (/ &
 & 0.14548E+04_JPRB,0.12788E+04_JPRB,0.11028E+04_JPRB,0.92676E+03_JPRB,0.75068E+03_JPRB, &
 & 0.69862E+03_JPRB,0.82271E+03_JPRB,0.94860E+03_JPRB,0.10753E+04_JPRB /)  
KA(:, 2, 5, 7) = (/ &
 & 0.14266E+04_JPRB,0.12542E+04_JPRB,0.10817E+04_JPRB,0.90918E+03_JPRB,0.73662E+03_JPRB, &
 & 0.69765E+03_JPRB,0.82202E+03_JPRB,0.94804E+03_JPRB,0.10749E+04_JPRB /)  
KA(:, 3, 5, 7) = (/ &
 & 0.14018E+04_JPRB,0.12324E+04_JPRB,0.10630E+04_JPRB,0.89363E+03_JPRB,0.72418E+03_JPRB, &
 & 0.69649E+03_JPRB,0.82110E+03_JPRB,0.94729E+03_JPRB,0.10743E+04_JPRB /)  
KA(:, 4, 5, 7) = (/ &
 & 0.13796E+04_JPRB,0.12130E+04_JPRB,0.10464E+04_JPRB,0.87978E+03_JPRB,0.71309E+03_JPRB, &
 & 0.69515E+03_JPRB,0.81992E+03_JPRB,0.94623E+03_JPRB,0.10733E+04_JPRB /)  
KA(:, 5, 5, 7) = (/ &
 & 0.13597E+04_JPRB,0.11956E+04_JPRB,0.10315E+04_JPRB,0.86737E+03_JPRB,0.70315E+03_JPRB, &
 & 0.69363E+03_JPRB,0.81858E+03_JPRB,0.94492E+03_JPRB,0.10720E+04_JPRB /)  
KA(:, 1, 6, 7) = (/ &
 & 0.13881E+04_JPRB,0.12204E+04_JPRB,0.10528E+04_JPRB,0.88506E+03_JPRB,0.71732E+03_JPRB, &
 & 0.69732E+03_JPRB,0.82195E+03_JPRB,0.94833E+03_JPRB,0.10753E+04_JPRB /)  
KA(:, 2, 6, 7) = (/ &
 & 0.13630E+04_JPRB,0.11985E+04_JPRB,0.10340E+04_JPRB,0.86942E+03_JPRB,0.70480E+03_JPRB, &
 & 0.69661E+03_JPRB,0.82150E+03_JPRB,0.94796E+03_JPRB,0.10752E+04_JPRB /)  
KA(:, 3, 6, 7) = (/ &
 & 0.13410E+04_JPRB,0.11792E+04_JPRB,0.10175E+04_JPRB,0.85565E+03_JPRB,0.69378E+03_JPRB, &
 & 0.69568E+03_JPRB,0.82079E+03_JPRB,0.94739E+03_JPRB,0.10747E+04_JPRB /)  
KA(:, 4, 6, 7) = (/ &
 & 0.13215E+04_JPRB,0.11622E+04_JPRB,0.10028E+04_JPRB,0.84344E+03_JPRB,0.68401E+03_JPRB, &
 & 0.69456E+03_JPRB,0.81984E+03_JPRB,0.94655E+03_JPRB,0.10740E+04_JPRB /)  
KA(:, 5, 6, 7) = (/ &
 & 0.13040E+04_JPRB,0.11469E+04_JPRB,0.98973E+03_JPRB,0.83254E+03_JPRB,0.67529E+03_JPRB, &
 & 0.69326E+03_JPRB,0.81868E+03_JPRB,0.94544E+03_JPRB,0.10729E+04_JPRB /)  
KA(:, 1, 7, 7) = (/ &
 & 0.13313E+04_JPRB,0.11707E+04_JPRB,0.10101E+04_JPRB,0.84956E+03_JPRB,0.68891E+03_JPRB, &
 & 0.69611E+03_JPRB,0.82122E+03_JPRB,0.94800E+03_JPRB,0.10754E+04_JPRB /)  
KA(:, 2, 7, 7) = (/ &
 & 0.13090E+04_JPRB,0.11512E+04_JPRB,0.99343E+03_JPRB,0.83562E+03_JPRB,0.67776E+03_JPRB, &
 & 0.69564E+03_JPRB,0.82091E+03_JPRB,0.94785E+03_JPRB,0.10753E+04_JPRB /)  
KA(:, 3, 7, 7) = (/ &
 & 0.12894E+04_JPRB,0.11341E+04_JPRB,0.97879E+03_JPRB,0.82342E+03_JPRB,0.66800E+03_JPRB, &
 & 0.69494E+03_JPRB,0.82048E+03_JPRB,0.94742E+03_JPRB,0.10750E+04_JPRB /)  
KA(:, 4, 7, 7) = (/ &
 & 0.12722E+04_JPRB,0.11191E+04_JPRB,0.96587E+03_JPRB,0.81266E+03_JPRB,0.65938E+03_JPRB, &
 & 0.69403E+03_JPRB,0.81973E+03_JPRB,0.94677E+03_JPRB,0.10745E+04_JPRB /)  
KA(:, 5, 7, 7) = (/ &
 & 0.12569E+04_JPRB,0.11057E+04_JPRB,0.95438E+03_JPRB,0.80308E+03_JPRB,0.65172E+03_JPRB, &
 & 0.69293E+03_JPRB,0.81874E+03_JPRB,0.94587E+03_JPRB,0.10736E+04_JPRB /)  
KA(:, 1, 8, 7) = (/ &
 & 0.12827E+04_JPRB,0.11282E+04_JPRB,0.97371E+03_JPRB,0.81918E+03_JPRB,0.66460E+03_JPRB, &
 & 0.69497E+03_JPRB,0.82050E+03_JPRB,0.94762E+03_JPRB,0.10753E+04_JPRB /)  
KA(:, 2, 8, 7) = (/ &
 & 0.12628E+04_JPRB,0.11108E+04_JPRB,0.95881E+03_JPRB,0.80678E+03_JPRB,0.65467E+03_JPRB, &
 & 0.69473E+03_JPRB,0.82044E+03_JPRB,0.94765E+03_JPRB,0.10754E+04_JPRB /)  
KA(:, 3, 8, 7) = (/ &
 & 0.12455E+04_JPRB,0.10957E+04_JPRB,0.94585E+03_JPRB,0.79597E+03_JPRB,0.64602E+03_JPRB, &
 & 0.69425E+03_JPRB,0.82014E+03_JPRB,0.94746E+03_JPRB,0.10752E+04_JPRB /)  
KA(:, 4, 8, 7) = (/ &
 & 0.12303E+04_JPRB,0.10824E+04_JPRB,0.93446E+03_JPRB,0.78648E+03_JPRB,0.63843E+03_JPRB, &
 & 0.69354E+03_JPRB,0.81959E+03_JPRB,0.94691E+03_JPRB,0.10748E+04_JPRB /)  
KA(:, 5, 8, 7) = (/ &
 & 0.12169E+04_JPRB,0.10706E+04_JPRB,0.92437E+03_JPRB,0.77807E+03_JPRB,0.63171E+03_JPRB, &
 & 0.69262E+03_JPRB,0.81878E+03_JPRB,0.94618E+03_JPRB,0.10741E+04_JPRB /)  
KA(:, 1, 9, 7) = (/ &
 & 0.12413E+04_JPRB,0.10920E+04_JPRB,0.94266E+03_JPRB,0.79331E+03_JPRB,0.64390E+03_JPRB, &
 & 0.69387E+03_JPRB,0.81977E+03_JPRB,0.94713E+03_JPRB,0.10750E+04_JPRB /)  
KA(:, 2, 9, 7) = (/ &
 & 0.12236E+04_JPRB,0.10765E+04_JPRB,0.92938E+03_JPRB,0.78225E+03_JPRB,0.63504E+03_JPRB, &
 & 0.69385E+03_JPRB,0.81989E+03_JPRB,0.94741E+03_JPRB,0.10753E+04_JPRB /)  
KA(:, 3, 9, 7) = (/ &
 & 0.12082E+04_JPRB,0.10631E+04_JPRB,0.91789E+03_JPRB,0.77267E+03_JPRB,0.62738E+03_JPRB, &
 & 0.69359E+03_JPRB,0.81979E+03_JPRB,0.94732E+03_JPRB,0.10754E+04_JPRB /)  
KA(:, 4, 9, 7) = (/ &
 & 0.11949E+04_JPRB,0.10514E+04_JPRB,0.90785E+03_JPRB,0.76430E+03_JPRB,0.62068E+03_JPRB, &
 & 0.69307E+03_JPRB,0.81942E+03_JPRB,0.94698E+03_JPRB,0.10751E+04_JPRB /)  
KA(:, 5, 9, 7) = (/ &
 & 0.11831E+04_JPRB,0.10410E+04_JPRB,0.89899E+03_JPRB,0.75692E+03_JPRB,0.61500E+03_JPRB, &
 & 0.69235E+03_JPRB,0.81879E+03_JPRB,0.94641E+03_JPRB,0.10746E+04_JPRB /)  
KA(:, 1,10, 7) = (/ &
 & 0.12046E+04_JPRB,0.10599E+04_JPRB,0.91518E+03_JPRB,0.77041E+03_JPRB,0.62557E+03_JPRB, &
 & 0.69285E+03_JPRB,0.81909E+03_JPRB,0.94663E+03_JPRB,0.10746E+04_JPRB /)  
KA(:, 2,10, 7) = (/ &
 & 0.11890E+04_JPRB,0.10463E+04_JPRB,0.90347E+03_JPRB,0.76066E+03_JPRB,0.61799E+03_JPRB, &
 & 0.69301E+03_JPRB,0.81937E+03_JPRB,0.94709E+03_JPRB,0.10752E+04_JPRB /)  
KA(:, 3,10, 7) = (/ &
 & 0.11756E+04_JPRB,0.10345E+04_JPRB,0.89339E+03_JPRB,0.75225E+03_JPRB,0.61189E+03_JPRB, &
 & 0.69293E+03_JPRB,0.81942E+03_JPRB,0.94719E+03_JPRB,0.10754E+04_JPRB /)  
KA(:, 4,10, 7) = (/ &
 & 0.11639E+04_JPRB,0.10243E+04_JPRB,0.88463E+03_JPRB,0.74495E+03_JPRB,0.60683E+03_JPRB, &
 & 0.69260E+03_JPRB,0.81922E+03_JPRB,0.94698E+03_JPRB,0.10753E+04_JPRB /)  
KA(:, 5,10, 7) = (/ &
 & 0.11536E+04_JPRB,0.10153E+04_JPRB,0.87693E+03_JPRB,0.73853E+03_JPRB,0.60268E+03_JPRB, &
 & 0.69203E+03_JPRB,0.81871E+03_JPRB,0.94653E+03_JPRB,0.10749E+04_JPRB /)  
KA(:, 1,11, 7) = (/ &
 & 0.11668E+04_JPRB,0.10268E+04_JPRB,0.88684E+03_JPRB,0.74678E+03_JPRB,0.60837E+03_JPRB, &
 & 0.69208E+03_JPRB,0.81864E+03_JPRB,0.94642E+03_JPRB,0.10746E+04_JPRB /)  
KA(:, 2,11, 7) = (/ &
 & 0.11540E+04_JPRB,0.10157E+04_JPRB,0.87724E+03_JPRB,0.73879E+03_JPRB,0.60335E+03_JPRB, &
 & 0.69229E+03_JPRB,0.81896E+03_JPRB,0.94691E+03_JPRB,0.10752E+04_JPRB /)  
KA(:, 3,11, 7) = (/ &
 & 0.11430E+04_JPRB,0.10060E+04_JPRB,0.86898E+03_JPRB,0.73191E+03_JPRB,0.59939E+03_JPRB, &
 & 0.69226E+03_JPRB,0.81904E+03_JPRB,0.94700E+03_JPRB,0.10754E+04_JPRB /)  
KA(:, 4,11, 7) = (/ &
 & 0.11335E+04_JPRB,0.99764E+03_JPRB,0.86180E+03_JPRB,0.72592E+03_JPRB,0.59585E+03_JPRB, &
 & 0.69198E+03_JPRB,0.81884E+03_JPRB,0.94679E+03_JPRB,0.10753E+04_JPRB /)  
KA(:, 5,11, 7) = (/ &
 & 0.11251E+04_JPRB,0.99028E+03_JPRB,0.85549E+03_JPRB,0.72067E+03_JPRB,0.59286E+03_JPRB, &
 & 0.69146E+03_JPRB,0.81839E+03_JPRB,0.94639E+03_JPRB,0.10749E+04_JPRB /)  
KA(:, 1,12, 7) = (/ &
 & 0.11358E+04_JPRB,0.99970E+03_JPRB,0.86357E+03_JPRB,0.72739E+03_JPRB,0.59707E+03_JPRB, &
 & 0.69145E+03_JPRB,0.81829E+03_JPRB,0.94626E+03_JPRB,0.10746E+04_JPRB /)  
KA(:, 2,12, 7) = (/ &
 & 0.11253E+04_JPRB,0.99054E+03_JPRB,0.85571E+03_JPRB,0.72085E+03_JPRB,0.59339E+03_JPRB, &
 & 0.69172E+03_JPRB,0.81863E+03_JPRB,0.94675E+03_JPRB,0.10752E+04_JPRB /)  
KA(:, 3,12, 7) = (/ &
 & 0.11163E+04_JPRB,0.98265E+03_JPRB,0.84895E+03_JPRB,0.71521E+03_JPRB,0.59030E+03_JPRB, &
 & 0.69172E+03_JPRB,0.81873E+03_JPRB,0.94686E+03_JPRB,0.10754E+04_JPRB /)  
KA(:, 4,12, 7) = (/ &
 & 0.11085E+04_JPRB,0.97579E+03_JPRB,0.84307E+03_JPRB,0.71031E+03_JPRB,0.58782E+03_JPRB, &
 & 0.69148E+03_JPRB,0.81855E+03_JPRB,0.94672E+03_JPRB,0.10753E+04_JPRB /)  
KA(:, 5,12, 7) = (/ &
 & 0.11016E+04_JPRB,0.96977E+03_JPRB,0.83790E+03_JPRB,0.70601E+03_JPRB,0.58538E+03_JPRB, &
 & 0.69099E+03_JPRB,0.81812E+03_JPRB,0.94628E+03_JPRB,0.10749E+04_JPRB /)  
KA(:, 1,13, 7) = (/ &
 & 0.11104E+04_JPRB,0.97748E+03_JPRB,0.84452E+03_JPRB,0.71152E+03_JPRB,0.58852E+03_JPRB, &
 & 0.69093E+03_JPRB,0.81799E+03_JPRB,0.94612E+03_JPRB,0.10746E+04_JPRB /)  
KA(:, 2,13, 7) = (/ &
 & 0.11018E+04_JPRB,0.96998E+03_JPRB,0.83809E+03_JPRB,0.70616E+03_JPRB,0.58570E+03_JPRB, &
 & 0.69123E+03_JPRB,0.81841E+03_JPRB,0.94664E+03_JPRB,0.10752E+04_JPRB /)  
KA(:, 3,13, 7) = (/ &
 & 0.10945E+04_JPRB,0.96352E+03_JPRB,0.83255E+03_JPRB,0.70155E+03_JPRB,0.58307E+03_JPRB, &
 & 0.69128E+03_JPRB,0.81849E+03_JPRB,0.94675E+03_JPRB,0.10754E+04_JPRB /)  
KA(:, 4,13, 7) = (/ &
 & 0.10880E+04_JPRB,0.95790E+03_JPRB,0.82774E+03_JPRB,0.69753E+03_JPRB,0.58045E+03_JPRB, &
 & 0.69107E+03_JPRB,0.81832E+03_JPRB,0.94657E+03_JPRB,0.10753E+04_JPRB /)  
KA(:, 5,13, 7) = (/ &
 & 0.10824E+04_JPRB,0.95297E+03_JPRB,0.82351E+03_JPRB,0.69401E+03_JPRB,0.57806E+03_JPRB, &
 & 0.69061E+03_JPRB,0.81788E+03_JPRB,0.94614E+03_JPRB,0.10749E+04_JPRB /)  
KA(:, 1, 1, 8) = (/ &
 & 0.19433E+04_JPRB,0.17047E+04_JPRB,0.14661E+04_JPRB,0.12275E+04_JPRB,0.98902E+03_JPRB, &
 & 0.75120E+03_JPRB,0.85754E+03_JPRB,0.98845E+03_JPRB,0.11206E+04_JPRB /)  
KA(:, 2, 1, 8) = (/ &
 & 0.18941E+04_JPRB,0.16616E+04_JPRB,0.14292E+04_JPRB,0.11968E+04_JPRB,0.96439E+03_JPRB, &
 & 0.73548E+03_JPRB,0.85594E+03_JPRB,0.98707E+03_JPRB,0.11193E+04_JPRB /)  
KA(:, 3, 1, 8) = (/ &
 & 0.18499E+04_JPRB,0.16229E+04_JPRB,0.13960E+04_JPRB,0.11691E+04_JPRB,0.94229E+03_JPRB, &
 & 0.72448E+03_JPRB,0.85413E+03_JPRB,0.98549E+03_JPRB,0.11177E+04_JPRB /)  
KA(:, 4, 1, 8) = (/ &
 & 0.18099E+04_JPRB,0.15880E+04_JPRB,0.13661E+04_JPRB,0.11442E+04_JPRB,0.92233E+03_JPRB, &
 & 0.72225E+03_JPRB,0.85214E+03_JPRB,0.98373E+03_JPRB,0.11158E+04_JPRB /)  
KA(:, 5, 1, 8) = (/ &
 & 0.17737E+04_JPRB,0.15563E+04_JPRB,0.13389E+04_JPRB,0.11215E+04_JPRB,0.90421E+03_JPRB, &
 & 0.72001E+03_JPRB,0.85005E+03_JPRB,0.98175E+03_JPRB,0.11138E+04_JPRB /)  
KA(:, 1, 2, 8) = (/ &
 & 0.17953E+04_JPRB,0.15751E+04_JPRB,0.13551E+04_JPRB,0.11350E+04_JPRB,0.91499E+03_JPRB, &
 & 0.72569E+03_JPRB,0.85649E+03_JPRB,0.98821E+03_JPRB,0.11210E+04_JPRB /)  
KA(:, 2, 2, 8) = (/ &
 & 0.17530E+04_JPRB,0.15382E+04_JPRB,0.13234E+04_JPRB,0.11086E+04_JPRB,0.89388E+03_JPRB, &
 & 0.72424E+03_JPRB,0.85509E+03_JPRB,0.98698E+03_JPRB,0.11198E+04_JPRB /)  
KA(:, 3, 2, 8) = (/ &
 & 0.17152E+04_JPRB,0.15051E+04_JPRB,0.12950E+04_JPRB,0.10850E+04_JPRB,0.87497E+03_JPRB, &
 & 0.72267E+03_JPRB,0.85348E+03_JPRB,0.98553E+03_JPRB,0.11184E+04_JPRB /)  
KA(:, 4, 2, 8) = (/ &
 & 0.16811E+04_JPRB,0.14753E+04_JPRB,0.12695E+04_JPRB,0.10637E+04_JPRB,0.85793E+03_JPRB, &
 & 0.72084E+03_JPRB,0.85163E+03_JPRB,0.98389E+03_JPRB,0.11166E+04_JPRB /)  
KA(:, 5, 2, 8) = (/ &
 & 0.16502E+04_JPRB,0.14483E+04_JPRB,0.12463E+04_JPRB,0.10444E+04_JPRB,0.84250E+03_JPRB, &
 & 0.71877E+03_JPRB,0.84969E+03_JPRB,0.98204E+03_JPRB,0.11147E+04_JPRB /)  
KA(:, 1, 3, 8) = (/ &
 & 0.16788E+04_JPRB,0.14733E+04_JPRB,0.12678E+04_JPRB,0.10623E+04_JPRB,0.85679E+03_JPRB, &
 & 0.72434E+03_JPRB,0.85588E+03_JPRB,0.98822E+03_JPRB,0.11216E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART5',1,ZHOOK_HANDLE)
END SUBROUTINE PART5


SUBROUTINE PART6

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART6',0,ZHOOK_HANDLE)


KA(:, 2, 3, 8) = (/ &
 & 0.16418E+04_JPRB,0.14409E+04_JPRB,0.12400E+04_JPRB,0.10391E+04_JPRB,0.83827E+03_JPRB, &
 & 0.72306E+03_JPRB,0.85466E+03_JPRB,0.98716E+03_JPRB,0.11206E+04_JPRB /)  
KA(:, 3, 3, 8) = (/ &
 & 0.16087E+04_JPRB,0.14119E+04_JPRB,0.12152E+04_JPRB,0.10184E+04_JPRB,0.82172E+03_JPRB, &
 & 0.72165E+03_JPRB,0.85327E+03_JPRB,0.98590E+03_JPRB,0.11193E+04_JPRB /)  
KA(:, 4, 3, 8) = (/ &
 & 0.15790E+04_JPRB,0.13859E+04_JPRB,0.11929E+04_JPRB,0.99988E+03_JPRB,0.80688E+03_JPRB, &
 & 0.72007E+03_JPRB,0.85161E+03_JPRB,0.98438E+03_JPRB,0.11177E+04_JPRB /)  
KA(:, 5, 3, 8) = (/ &
 & 0.15522E+04_JPRB,0.13625E+04_JPRB,0.11728E+04_JPRB,0.98311E+03_JPRB,0.79349E+03_JPRB, &
 & 0.71824E+03_JPRB,0.84982E+03_JPRB,0.98270E+03_JPRB,0.11159E+04_JPRB /)  
KA(:, 1, 4, 8) = (/ &
 & 0.15823E+04_JPRB,0.13888E+04_JPRB,0.11953E+04_JPRB,0.10019E+04_JPRB,0.80851E+03_JPRB, &
 & 0.72326E+03_JPRB,0.85540E+03_JPRB,0.98823E+03_JPRB,0.11221E+04_JPRB /)  
KA(:, 2, 4, 8) = (/ &
 & 0.15495E+04_JPRB,0.13601E+04_JPRB,0.11708E+04_JPRB,0.98142E+03_JPRB,0.79213E+03_JPRB, &
 & 0.72214E+03_JPRB,0.85436E+03_JPRB,0.98737E+03_JPRB,0.11213E+04_JPRB /)  
KA(:, 3, 4, 8) = (/ &
 & 0.15204E+04_JPRB,0.13346E+04_JPRB,0.11489E+04_JPRB,0.96322E+03_JPRB,0.77758E+03_JPRB, &
 & 0.72091E+03_JPRB,0.85317E+03_JPRB,0.98628E+03_JPRB,0.11202E+04_JPRB /)  
KA(:, 4, 4, 8) = (/ &
 & 0.14943E+04_JPRB,0.13118E+04_JPRB,0.11294E+04_JPRB,0.94694E+03_JPRB,0.76455E+03_JPRB, &
 & 0.71952E+03_JPRB,0.85175E+03_JPRB,0.98496E+03_JPRB,0.11188E+04_JPRB /)  
KA(:, 5, 4, 8) = (/ &
 & 0.14709E+04_JPRB,0.12913E+04_JPRB,0.11118E+04_JPRB,0.93229E+03_JPRB,0.75284E+03_JPRB, &
 & 0.71792E+03_JPRB,0.85010E+03_JPRB,0.98342E+03_JPRB,0.11171E+04_JPRB /)  
KA(:, 1, 5, 8) = (/ &
 & 0.15002E+04_JPRB,0.13170E+04_JPRB,0.11338E+04_JPRB,0.95063E+03_JPRB,0.76749E+03_JPRB, &
 & 0.72234E+03_JPRB,0.85495E+03_JPRB,0.98821E+03_JPRB,0.11224E+04_JPRB /)  
KA(:, 2, 5, 8) = (/ &
 & 0.14712E+04_JPRB,0.12916E+04_JPRB,0.11120E+04_JPRB,0.93250E+03_JPRB,0.75300E+03_JPRB, &
 & 0.72139E+03_JPRB,0.85409E+03_JPRB,0.98753E+03_JPRB,0.11218E+04_JPRB /)  
KA(:, 3, 5, 8) = (/ &
 & 0.14456E+04_JPRB,0.12692E+04_JPRB,0.10928E+04_JPRB,0.91647E+03_JPRB,0.74017E+03_JPRB, &
 & 0.72031E+03_JPRB,0.85307E+03_JPRB,0.98657E+03_JPRB,0.11209E+04_JPRB /)  
KA(:, 4, 5, 8) = (/ &
 & 0.14227E+04_JPRB,0.12492E+04_JPRB,0.10757E+04_JPRB,0.90219E+03_JPRB,0.72875E+03_JPRB, &
 & 0.71909E+03_JPRB,0.85186E+03_JPRB,0.98546E+03_JPRB,0.11197E+04_JPRB /)  
KA(:, 5, 5, 8) = (/ &
 & 0.14022E+04_JPRB,0.12312E+04_JPRB,0.10603E+04_JPRB,0.88937E+03_JPRB,0.71851E+03_JPRB, &
 & 0.71769E+03_JPRB,0.85037E+03_JPRB,0.98406E+03_JPRB,0.11182E+04_JPRB /)  
KA(:, 1, 6, 8) = (/ &
 & 0.14314E+04_JPRB,0.12568E+04_JPRB,0.10822E+04_JPRB,0.90763E+03_JPRB,0.73310E+03_JPRB, &
 & 0.72155E+03_JPRB,0.85452E+03_JPRB,0.98813E+03_JPRB,0.11226E+04_JPRB /)  
KA(:, 2, 6, 8) = (/ &
 & 0.14056E+04_JPRB,0.12342E+04_JPRB,0.10628E+04_JPRB,0.89150E+03_JPRB,0.72020E+03_JPRB, &
 & 0.72077E+03_JPRB,0.85386E+03_JPRB,0.98765E+03_JPRB,0.11222E+04_JPRB /)  
KA(:, 3, 6, 8) = (/ &
 & 0.13829E+04_JPRB,0.12143E+04_JPRB,0.10458E+04_JPRB,0.87730E+03_JPRB,0.70887E+03_JPRB, &
 & 0.71986E+03_JPRB,0.85300E+03_JPRB,0.98688E+03_JPRB,0.11215E+04_JPRB /)  
KA(:, 4, 6, 8) = (/ &
 & 0.13627E+04_JPRB,0.11967E+04_JPRB,0.10307E+04_JPRB,0.86473E+03_JPRB,0.69880E+03_JPRB, &
 & 0.71879E+03_JPRB,0.85197E+03_JPRB,0.98590E+03_JPRB,0.11205E+04_JPRB /)  
KA(:, 5, 6, 8) = (/ &
 & 0.13448E+04_JPRB,0.11810E+04_JPRB,0.10172E+04_JPRB,0.85348E+03_JPRB,0.68979E+03_JPRB, &
 & 0.71757E+03_JPRB,0.85073E+03_JPRB,0.98469E+03_JPRB,0.11192E+04_JPRB /)  
KA(:, 1, 7, 8) = (/ &
 & 0.13728E+04_JPRB,0.12055E+04_JPRB,0.10383E+04_JPRB,0.87102E+03_JPRB,0.70382E+03_JPRB, &
 & 0.72081E+03_JPRB,0.85410E+03_JPRB,0.98799E+03_JPRB,0.11227E+04_JPRB /)  
KA(:, 2, 7, 8) = (/ &
 & 0.13499E+04_JPRB,0.11854E+04_JPRB,0.10210E+04_JPRB,0.85666E+03_JPRB,0.69233E+03_JPRB, &
 & 0.72022E+03_JPRB,0.85362E+03_JPRB,0.98768E+03_JPRB,0.11225E+04_JPRB /)  
KA(:, 3, 7, 8) = (/ &
 & 0.13297E+04_JPRB,0.11678E+04_JPRB,0.10059E+04_JPRB,0.84408E+03_JPRB,0.68228E+03_JPRB, &
 & 0.71945E+03_JPRB,0.85293E+03_JPRB,0.98711E+03_JPRB,0.11220E+04_JPRB /)  
KA(:, 4, 7, 8) = (/ &
 & 0.13120E+04_JPRB,0.11523E+04_JPRB,0.99261E+03_JPRB,0.83298E+03_JPRB,0.67339E+03_JPRB, &
 & 0.71854E+03_JPRB,0.85205E+03_JPRB,0.98632E+03_JPRB,0.11212E+04_JPRB /)  
KA(:, 5, 7, 8) = (/ &
 & 0.12962E+04_JPRB,0.11384E+04_JPRB,0.98077E+03_JPRB,0.82312E+03_JPRB,0.66550E+03_JPRB, &
 & 0.71746E+03_JPRB,0.85098E+03_JPRB,0.98523E+03_JPRB,0.11200E+04_JPRB /)  
KA(:, 1, 8, 8) = (/ &
 & 0.13227E+04_JPRB,0.11617E+04_JPRB,0.10007E+04_JPRB,0.83971E+03_JPRB,0.67877E+03_JPRB, &
 & 0.72007E+03_JPRB,0.85366E+03_JPRB,0.98779E+03_JPRB,0.11227E+04_JPRB /)  
KA(:, 2, 8, 8) = (/ &
 & 0.13022E+04_JPRB,0.11438E+04_JPRB,0.98533E+03_JPRB,0.82690E+03_JPRB,0.66854E+03_JPRB, &
 & 0.71969E+03_JPRB,0.85334E+03_JPRB,0.98763E+03_JPRB,0.11227E+04_JPRB /)  
KA(:, 3, 8, 8) = (/ &
 & 0.12844E+04_JPRB,0.11282E+04_JPRB,0.97196E+03_JPRB,0.81577E+03_JPRB,0.65963E+03_JPRB, &
 & 0.71908E+03_JPRB,0.85283E+03_JPRB,0.98717E+03_JPRB,0.11223E+04_JPRB /)  
KA(:, 4, 8, 8) = (/ &
 & 0.12688E+04_JPRB,0.11145E+04_JPRB,0.96023E+03_JPRB,0.80599E+03_JPRB,0.65182E+03_JPRB, &
 & 0.71830E+03_JPRB,0.85210E+03_JPRB,0.98659E+03_JPRB,0.11217E+04_JPRB /)  
KA(:, 5, 8, 8) = (/ &
 & 0.12549E+04_JPRB,0.11024E+04_JPRB,0.94982E+03_JPRB,0.79733E+03_JPRB,0.64488E+03_JPRB, &
 & 0.71736E+03_JPRB,0.85118E+03_JPRB,0.98569E+03_JPRB,0.11208E+04_JPRB /)  
KA(:, 1, 9, 8) = (/ &
 & 0.12800E+04_JPRB,0.11244E+04_JPRB,0.96868E+03_JPRB,0.81302E+03_JPRB,0.65744E+03_JPRB, &
 & 0.71936E+03_JPRB,0.85323E+03_JPRB,0.98761E+03_JPRB,0.11226E+04_JPRB /)  
KA(:, 2, 9, 8) = (/ &
 & 0.12618E+04_JPRB,0.11084E+04_JPRB,0.95498E+03_JPRB,0.80161E+03_JPRB,0.64832E+03_JPRB, &
 & 0.71916E+03_JPRB,0.85306E+03_JPRB,0.98751E+03_JPRB,0.11227E+04_JPRB /)  
KA(:, 3, 9, 8) = (/ &
 & 0.12460E+04_JPRB,0.10945E+04_JPRB,0.94313E+03_JPRB,0.79175E+03_JPRB,0.64042E+03_JPRB, &
 & 0.71874E+03_JPRB,0.85269E+03_JPRB,0.98731E+03_JPRB,0.11226E+04_JPRB /)  
KA(:, 4, 9, 8) = (/ &
 & 0.12322E+04_JPRB,0.10825E+04_JPRB,0.93277E+03_JPRB,0.78311E+03_JPRB,0.63351E+03_JPRB, &
 & 0.71809E+03_JPRB,0.85213E+03_JPRB,0.98681E+03_JPRB,0.11221E+04_JPRB /)  
KA(:, 5, 9, 8) = (/ &
 & 0.12200E+04_JPRB,0.10718E+04_JPRB,0.92365E+03_JPRB,0.77552E+03_JPRB,0.62743E+03_JPRB, &
 & 0.71728E+03_JPRB,0.85134E+03_JPRB,0.98607E+03_JPRB,0.11214E+04_JPRB /)  
KA(:, 1,10, 8) = (/ &
 & 0.12423E+04_JPRB,0.10913E+04_JPRB,0.94034E+03_JPRB,0.78942E+03_JPRB,0.63856E+03_JPRB, &
 & 0.71867E+03_JPRB,0.85279E+03_JPRB,0.98738E+03_JPRB,0.11225E+04_JPRB /)  
KA(:, 2,10, 8) = (/ &
 & 0.12262E+04_JPRB,0.10772E+04_JPRB,0.92827E+03_JPRB,0.77936E+03_JPRB,0.63052E+03_JPRB, &
 & 0.71863E+03_JPRB,0.85274E+03_JPRB,0.98738E+03_JPRB,0.11227E+04_JPRB /)  
KA(:, 3,10, 8) = (/ &
 & 0.12123E+04_JPRB,0.10651E+04_JPRB,0.91788E+03_JPRB,0.77071E+03_JPRB,0.62359E+03_JPRB, &
 & 0.71835E+03_JPRB,0.85251E+03_JPRB,0.98725E+03_JPRB,0.11227E+04_JPRB /)  
KA(:, 4,10, 8) = (/ &
 & 0.12002E+04_JPRB,0.10545E+04_JPRB,0.90884E+03_JPRB,0.76317E+03_JPRB,0.61756E+03_JPRB, &
 & 0.71785E+03_JPRB,0.85203E+03_JPRB,0.98691E+03_JPRB,0.11224E+04_JPRB /)  
KA(:, 5,10, 8) = (/ &
 & 0.11897E+04_JPRB,0.10453E+04_JPRB,0.90090E+03_JPRB,0.75655E+03_JPRB,0.61227E+03_JPRB, &
 & 0.71716E+03_JPRB,0.85141E+03_JPRB,0.98631E+03_JPRB,0.11218E+04_JPRB /)  
KA(:, 1,11, 8) = (/ &
 & 0.12033E+04_JPRB,0.10572E+04_JPRB,0.91110E+03_JPRB,0.76506E+03_JPRB,0.61908E+03_JPRB, &
 & 0.71809E+03_JPRB,0.85242E+03_JPRB,0.98721E+03_JPRB,0.11225E+04_JPRB /)  
KA(:, 2,11, 8) = (/ &
 & 0.11901E+04_JPRB,0.10456E+04_JPRB,0.90123E+03_JPRB,0.75682E+03_JPRB,0.61248E+03_JPRB, &
 & 0.71809E+03_JPRB,0.85240E+03_JPRB,0.98723E+03_JPRB,0.11226E+04_JPRB /)  
KA(:, 3,11, 8) = (/ &
 & 0.11788E+04_JPRB,0.10357E+04_JPRB,0.89271E+03_JPRB,0.74972E+03_JPRB,0.60692E+03_JPRB, &
 & 0.71785E+03_JPRB,0.85217E+03_JPRB,0.98712E+03_JPRB,0.11227E+04_JPRB /)  
KA(:, 4,11, 8) = (/ &
 & 0.11689E+04_JPRB,0.10271E+04_JPRB,0.88529E+03_JPRB,0.74355E+03_JPRB,0.60253E+03_JPRB, &
 & 0.71738E+03_JPRB,0.85177E+03_JPRB,0.98681E+03_JPRB,0.11224E+04_JPRB /)  
KA(:, 5,11, 8) = (/ &
 & 0.11602E+04_JPRB,0.10195E+04_JPRB,0.87880E+03_JPRB,0.73813E+03_JPRB,0.59855E+03_JPRB, &
 & 0.71672E+03_JPRB,0.85114E+03_JPRB,0.98618E+03_JPRB,0.11218E+04_JPRB /)  
KA(:, 1,12, 8) = (/ &
 & 0.11713E+04_JPRB,0.10292E+04_JPRB,0.88712E+03_JPRB,0.74507E+03_JPRB,0.60379E+03_JPRB, &
 & 0.71766E+03_JPRB,0.85212E+03_JPRB,0.98706E+03_JPRB,0.11225E+04_JPRB /)  
KA(:, 2,12, 8) = (/ &
 & 0.11605E+04_JPRB,0.10197E+04_JPRB,0.87902E+03_JPRB,0.73833E+03_JPRB,0.59891E+03_JPRB, &
 & 0.71764E+03_JPRB,0.85212E+03_JPRB,0.98710E+03_JPRB,0.11227E+04_JPRB /)  
KA(:, 3,12, 8) = (/ &
 & 0.11512E+04_JPRB,0.10116E+04_JPRB,0.87205E+03_JPRB,0.73251E+03_JPRB,0.59502E+03_JPRB, &
 & 0.71744E+03_JPRB,0.85192E+03_JPRB,0.98700E+03_JPRB,0.11227E+04_JPRB /)  
KA(:, 4,12, 8) = (/ &
 & 0.11431E+04_JPRB,0.10045E+04_JPRB,0.86598E+03_JPRB,0.72746E+03_JPRB,0.59151E+03_JPRB, &
 & 0.71699E+03_JPRB,0.85153E+03_JPRB,0.98663E+03_JPRB,0.11224E+04_JPRB /)  
KA(:, 5,12, 8) = (/ &
 & 0.11360E+04_JPRB,0.99832E+03_JPRB,0.86067E+03_JPRB,0.72302E+03_JPRB,0.58868E+03_JPRB, &
 & 0.71636E+03_JPRB,0.85092E+03_JPRB,0.98606E+03_JPRB,0.11218E+04_JPRB /)  
KA(:, 1,13, 8) = (/ &
 & 0.11451E+04_JPRB,0.10063E+04_JPRB,0.86748E+03_JPRB,0.72871E+03_JPRB,0.59258E+03_JPRB, &
 & 0.71726E+03_JPRB,0.85187E+03_JPRB,0.98696E+03_JPRB,0.11225E+04_JPRB /)  
KA(:, 2,13, 8) = (/ &
 & 0.11363E+04_JPRB,0.99855E+03_JPRB,0.86085E+03_JPRB,0.72320E+03_JPRB,0.58896E+03_JPRB, &
 & 0.71729E+03_JPRB,0.85183E+03_JPRB,0.98699E+03_JPRB,0.11227E+04_JPRB /)  
KA(:, 3,13, 8) = (/ &
 & 0.11287E+04_JPRB,0.99189E+03_JPRB,0.85515E+03_JPRB,0.71842E+03_JPRB,0.58585E+03_JPRB, &
 & 0.71710E+03_JPRB,0.85169E+03_JPRB,0.98691E+03_JPRB,0.11227E+04_JPRB /)  
KA(:, 4,13, 8) = (/ &
 & 0.11220E+04_JPRB,0.98609E+03_JPRB,0.85017E+03_JPRB,0.71429E+03_JPRB,0.58380E+03_JPRB, &
 & 0.71668E+03_JPRB,0.85133E+03_JPRB,0.98660E+03_JPRB,0.11224E+04_JPRB /)  
KA(:, 5,13, 8) = (/ &
 & 0.11162E+04_JPRB,0.98101E+03_JPRB,0.84582E+03_JPRB,0.71065E+03_JPRB,0.58234E+03_JPRB, &
 & 0.71606E+03_JPRB,0.85074E+03_JPRB,0.98601E+03_JPRB,0.11218E+04_JPRB /)  
KA(:, 1, 1, 9) = (/ &
 & 0.19571E+04_JPRB,0.17167E+04_JPRB,0.14761E+04_JPRB,0.12357E+04_JPRB,0.99528E+03_JPRB, &
 & 0.75488E+03_JPRB,0.87315E+03_JPRB,0.10086E+04_JPRB,0.11441E+04_JPRB /)  
KA(:, 2, 1, 9) = (/ &
 & 0.19076E+04_JPRB,0.16733E+04_JPRB,0.14390E+04_JPRB,0.12047E+04_JPRB,0.97044E+03_JPRB, &
 & 0.73841E+03_JPRB,0.87146E+03_JPRB,0.10070E+04_JPRB,0.11425E+04_JPRB /)  
KA(:, 3, 1, 9) = (/ &
 & 0.18630E+04_JPRB,0.16343E+04_JPRB,0.14056E+04_JPRB,0.11769E+04_JPRB,0.94822E+03_JPRB, &
 & 0.73460E+03_JPRB,0.86967E+03_JPRB,0.10052E+04_JPRB,0.11407E+04_JPRB /)  
KA(:, 4, 1, 9) = (/ &
 & 0.18229E+04_JPRB,0.15991E+04_JPRB,0.13754E+04_JPRB,0.11517E+04_JPRB,0.92811E+03_JPRB, &
 & 0.73269E+03_JPRB,0.86788E+03_JPRB,0.10033E+04_JPRB,0.11387E+04_JPRB /)  
KA(:, 5, 1, 9) = (/ &
 & 0.17864E+04_JPRB,0.15672E+04_JPRB,0.13481E+04_JPRB,0.11289E+04_JPRB,0.90984E+03_JPRB, &
 & 0.73091E+03_JPRB,0.86616E+03_JPRB,0.10016E+04_JPRB,0.11368E+04_JPRB /)  
KA(:, 1, 2, 9) = (/ &
 & 0.18080E+04_JPRB,0.15862E+04_JPRB,0.13643E+04_JPRB,0.11425E+04_JPRB,0.92072E+03_JPRB, &
 & 0.73694E+03_JPRB,0.87246E+03_JPRB,0.10086E+04_JPRB,0.11448E+04_JPRB /)  
KA(:, 2, 2, 9) = (/ &
 & 0.17655E+04_JPRB,0.15491E+04_JPRB,0.13324E+04_JPRB,0.11159E+04_JPRB,0.89943E+03_JPRB, &
 & 0.73525E+03_JPRB,0.87092E+03_JPRB,0.10070E+04_JPRB,0.11432E+04_JPRB /)  
KA(:, 3, 2, 9) = (/ &
 & 0.17274E+04_JPRB,0.15157E+04_JPRB,0.13039E+04_JPRB,0.10921E+04_JPRB,0.88039E+03_JPRB, &
 & 0.73343E+03_JPRB,0.86922E+03_JPRB,0.10053E+04_JPRB,0.11415E+04_JPRB /)  
KA(:, 4, 2, 9) = (/ &
 & 0.16931E+04_JPRB,0.14856E+04_JPRB,0.12781E+04_JPRB,0.10706E+04_JPRB,0.86326E+03_JPRB, &
 & 0.73166E+03_JPRB,0.86752E+03_JPRB,0.10036E+04_JPRB,0.11395E+04_JPRB /)  
KA(:, 5, 2, 9) = (/ &
 & 0.16621E+04_JPRB,0.14584E+04_JPRB,0.12549E+04_JPRB,0.10512E+04_JPRB,0.84768E+03_JPRB, &
 & 0.73000E+03_JPRB,0.86583E+03_JPRB,0.10018E+04_JPRB,0.11376E+04_JPRB /)  
KA(:, 1, 3, 9) = (/ &
 & 0.16908E+04_JPRB,0.14837E+04_JPRB,0.12764E+04_JPRB,0.10692E+04_JPRB,0.86209E+03_JPRB, &
 & 0.73591E+03_JPRB,0.87213E+03_JPRB,0.10088E+04_JPRB,0.11456E+04_JPRB /)  
KA(:, 2, 3, 9) = (/ &
 & 0.16535E+04_JPRB,0.14509E+04_JPRB,0.12484E+04_JPRB,0.10459E+04_JPRB,0.84339E+03_JPRB, &
 & 0.73450E+03_JPRB,0.87080E+03_JPRB,0.10075E+04_JPRB,0.11442E+04_JPRB /)  
KA(:, 3, 3, 9) = (/ &
 & 0.16202E+04_JPRB,0.14218E+04_JPRB,0.12234E+04_JPRB,0.10251E+04_JPRB,0.82680E+03_JPRB, &
 & 0.73291E+03_JPRB,0.86926E+03_JPRB,0.10059E+04_JPRB,0.11426E+04_JPRB /)  
KA(:, 4, 3, 9) = (/ &
 & 0.15902E+04_JPRB,0.13956E+04_JPRB,0.12011E+04_JPRB,0.10064E+04_JPRB,0.81183E+03_JPRB, &
 & 0.73120E+03_JPRB,0.86761E+03_JPRB,0.10042E+04_JPRB,0.11407E+04_JPRB /)  
KA(:, 5, 3, 9) = (/ &
 & 0.15632E+04_JPRB,0.13720E+04_JPRB,0.11808E+04_JPRB,0.98952E+03_JPRB,0.79832E+03_JPRB, &
 & 0.72957E+03_JPRB,0.86594E+03_JPRB,0.10024E+04_JPRB,0.11387E+04_JPRB /)  
KA(:, 1, 4, 9) = (/ &
 & 0.15935E+04_JPRB,0.13985E+04_JPRB,0.12035E+04_JPRB,0.10084E+04_JPRB,0.81344E+03_JPRB, &
 & 0.73513E+03_JPRB,0.87195E+03_JPRB,0.10092E+04_JPRB,0.11463E+04_JPRB /)  
KA(:, 2, 4, 9) = (/ &
 & 0.15605E+04_JPRB,0.13697E+04_JPRB,0.11787E+04_JPRB,0.98782E+03_JPRB,0.79694E+03_JPRB, &
 & 0.73394E+03_JPRB,0.87080E+03_JPRB,0.10079E+04_JPRB,0.11451E+04_JPRB /)  
KA(:, 3, 4, 9) = (/ &
 & 0.15313E+04_JPRB,0.13439E+04_JPRB,0.11567E+04_JPRB,0.96950E+03_JPRB,0.78229E+03_JPRB, &
 & 0.73257E+03_JPRB,0.86942E+03_JPRB,0.10065E+04_JPRB,0.11436E+04_JPRB /)  
KA(:, 4, 4, 9) = (/ &
 & 0.15050E+04_JPRB,0.13210E+04_JPRB,0.11371E+04_JPRB,0.95308E+03_JPRB,0.76922E+03_JPRB, &
 & 0.73104E+03_JPRB,0.86787E+03_JPRB,0.10049E+04_JPRB,0.11419E+04_JPRB /)  
KA(:, 5, 4, 9) = (/ &
 & 0.14814E+04_JPRB,0.13003E+04_JPRB,0.11193E+04_JPRB,0.93833E+03_JPRB,0.75745E+03_JPRB, &
 & 0.72946E+03_JPRB,0.86622E+03_JPRB,0.10032E+04_JPRB,0.11400E+04_JPRB /)  
KA(:, 1, 5, 9) = (/ &
 & 0.15109E+04_JPRB,0.13262E+04_JPRB,0.11415E+04_JPRB,0.95685E+03_JPRB,0.77217E+03_JPRB, &
 & 0.73443E+03_JPRB,0.87177E+03_JPRB,0.10094E+04_JPRB,0.11470E+04_JPRB /)  
KA(:, 2, 5, 9) = (/ &
 & 0.14817E+04_JPRB,0.13007E+04_JPRB,0.11196E+04_JPRB,0.93852E+03_JPRB,0.75755E+03_JPRB, &
 & 0.73343E+03_JPRB,0.87078E+03_JPRB,0.10083E+04_JPRB,0.11459E+04_JPRB /)  
KA(:, 3, 5, 9) = (/ &
 & 0.14559E+04_JPRB,0.12780E+04_JPRB,0.11003E+04_JPRB,0.92240E+03_JPRB,0.74463E+03_JPRB, &
 & 0.73229E+03_JPRB,0.86958E+03_JPRB,0.10071E+04_JPRB,0.11446E+04_JPRB /)  
KA(:, 4, 5, 9) = (/ &
 & 0.14329E+04_JPRB,0.12579E+04_JPRB,0.10829E+04_JPRB,0.90802E+03_JPRB,0.73310E+03_JPRB, &
 & 0.73095E+03_JPRB,0.86817E+03_JPRB,0.10056E+04_JPRB,0.11430E+04_JPRB /)  
KA(:, 5, 5, 9) = (/ &
 & 0.14122E+04_JPRB,0.12398E+04_JPRB,0.10675E+04_JPRB,0.89511E+03_JPRB,0.72281E+03_JPRB, &
 & 0.72946E+03_JPRB,0.86664E+03_JPRB,0.10039E+04_JPRB,0.11412E+04_JPRB /)  
KA(:, 1, 6, 9) = (/ &
 & 0.14417E+04_JPRB,0.12655E+04_JPRB,0.10896E+04_JPRB,0.91348E+03_JPRB,0.73747E+03_JPRB, &
 & 0.73386E+03_JPRB,0.87165E+03_JPRB,0.10096E+04_JPRB,0.11475E+04_JPRB /)  
KA(:, 2, 6, 9) = (/ &
 & 0.14156E+04_JPRB,0.12429E+04_JPRB,0.10700E+04_JPRB,0.89725E+03_JPRB,0.72457E+03_JPRB, &
 & 0.73304E+03_JPRB,0.87078E+03_JPRB,0.10087E+04_JPRB,0.11466E+04_JPRB /)  
KA(:, 3, 6, 9) = (/ &
 & 0.13928E+04_JPRB,0.12228E+04_JPRB,0.10529E+04_JPRB,0.88300E+03_JPRB,0.71308E+03_JPRB, &
 & 0.73207E+03_JPRB,0.86977E+03_JPRB,0.10076E+04_JPRB,0.11455E+04_JPRB /)  
KA(:, 4, 6, 9) = (/ &
 & 0.13725E+04_JPRB,0.12051E+04_JPRB,0.10377E+04_JPRB,0.87029E+03_JPRB,0.70290E+03_JPRB, &
 & 0.73093E+03_JPRB,0.86853E+03_JPRB,0.10063E+04_JPRB,0.11441E+04_JPRB /)  
KA(:, 5, 6, 9) = (/ &
 & 0.13544E+04_JPRB,0.11892E+04_JPRB,0.10241E+04_JPRB,0.85897E+03_JPRB,0.69390E+03_JPRB, &
 & 0.72961E+03_JPRB,0.86706E+03_JPRB,0.10048E+04_JPRB,0.11424E+04_JPRB /)  
KA(:, 1, 7, 9) = (/ &
 & 0.13826E+04_JPRB,0.12140E+04_JPRB,0.10453E+04_JPRB,0.87664E+03_JPRB,0.70803E+03_JPRB, &
 & 0.73339E+03_JPRB,0.87155E+03_JPRB,0.10098E+04_JPRB,0.11480E+04_JPRB /)  
KA(:, 2, 7, 9) = (/ &
 & 0.13594E+04_JPRB,0.11937E+04_JPRB,0.10279E+04_JPRB,0.86216E+03_JPRB,0.69645E+03_JPRB, &
 & 0.73269E+03_JPRB,0.87079E+03_JPRB,0.10090E+04_JPRB,0.11472E+04_JPRB /)  
KA(:, 3, 7, 9) = (/ &
 & 0.13392E+04_JPRB,0.11759E+04_JPRB,0.10127E+04_JPRB,0.84953E+03_JPRB,0.68632E+03_JPRB, &
 & 0.73188E+03_JPRB,0.86990E+03_JPRB,0.10081E+04_JPRB,0.11462E+04_JPRB /)  
KA(:, 4, 7, 9) = (/ &
 & 0.13213E+04_JPRB,0.11603E+04_JPRB,0.99928E+03_JPRB,0.83829E+03_JPRB,0.67737E+03_JPRB, &
 & 0.73090E+03_JPRB,0.86884E+03_JPRB,0.10069E+04_JPRB,0.11450E+04_JPRB /)  
KA(:, 5, 7, 9) = (/ &
 & 0.13054E+04_JPRB,0.11464E+04_JPRB,0.98739E+03_JPRB,0.82837E+03_JPRB,0.66946E+03_JPRB, &
 & 0.72975E+03_JPRB,0.86756E+03_JPRB,0.10055E+04_JPRB,0.11435E+04_JPRB /)  
KA(:, 1, 8, 9) = (/ &
 & 0.13322E+04_JPRB,0.11698E+04_JPRB,0.10074E+04_JPRB,0.84511E+03_JPRB,0.68280E+03_JPRB, &
 & 0.73302E+03_JPRB,0.87145E+03_JPRB,0.10099E+04_JPRB,0.11483E+04_JPRB /)  
KA(:, 2, 8, 9) = (/ &
 & 0.13116E+04_JPRB,0.11517E+04_JPRB,0.99199E+03_JPRB,0.83221E+03_JPRB,0.67250E+03_JPRB, &
 & 0.73244E+03_JPRB,0.87079E+03_JPRB,0.10093E+04_JPRB,0.11477E+04_JPRB /)  
KA(:, 3, 8, 9) = (/ &
 & 0.12937E+04_JPRB,0.11360E+04_JPRB,0.97848E+03_JPRB,0.82097E+03_JPRB,0.66349E+03_JPRB, &
 & 0.73170E+03_JPRB,0.87002E+03_JPRB,0.10085E+04_JPRB,0.11469E+04_JPRB /)  
KA(:, 4, 8, 9) = (/ &
 & 0.12778E+04_JPRB,0.11223E+04_JPRB,0.96666E+03_JPRB,0.81113E+03_JPRB,0.65562E+03_JPRB, &
 & 0.73087E+03_JPRB,0.86909E+03_JPRB,0.10075E+04_JPRB,0.11458E+04_JPRB /)  
KA(:, 5, 8, 9) = (/ &
 & 0.12639E+04_JPRB,0.11101E+04_JPRB,0.95620E+03_JPRB,0.80244E+03_JPRB,0.64865E+03_JPRB, &
 & 0.72985E+03_JPRB,0.86796E+03_JPRB,0.10062E+04_JPRB,0.11444E+04_JPRB /)  
KA(:, 1, 9, 9) = (/ &
 & 0.12892E+04_JPRB,0.11322E+04_JPRB,0.97520E+03_JPRB,0.81821E+03_JPRB,0.66134E+03_JPRB, &
 & 0.73274E+03_JPRB,0.87135E+03_JPRB,0.10099E+04_JPRB,0.11485E+04_JPRB /)  
KA(:, 2, 9, 9) = (/ &
 & 0.12708E+04_JPRB,0.11161E+04_JPRB,0.96140E+03_JPRB,0.80674E+03_JPRB,0.65213E+03_JPRB, &
 & 0.73213E+03_JPRB,0.87079E+03_JPRB,0.10095E+04_JPRB,0.11481E+04_JPRB /)  
KA(:, 3, 9, 9) = (/ &
 & 0.12548E+04_JPRB,0.11022E+04_JPRB,0.94949E+03_JPRB,0.79681E+03_JPRB,0.64421E+03_JPRB, &
 & 0.73152E+03_JPRB,0.87011E+03_JPRB,0.10088E+04_JPRB,0.11474E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART6',1,ZHOOK_HANDLE)
END SUBROUTINE PART6


SUBROUTINE PART7

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART7',0,ZHOOK_HANDLE)


KA(:, 4, 9, 9) = (/ &
 & 0.12410E+04_JPRB,0.10900E+04_JPRB,0.93905E+03_JPRB,0.78808E+03_JPRB,0.63726E+03_JPRB, &
 & 0.73083E+03_JPRB,0.86928E+03_JPRB,0.10079E+04_JPRB,0.11464E+04_JPRB /)  
KA(:, 5, 9, 9) = (/ &
 & 0.12287E+04_JPRB,0.10793E+04_JPRB,0.92981E+03_JPRB,0.78042E+03_JPRB,0.63106E+03_JPRB, &
 & 0.72995E+03_JPRB,0.86831E+03_JPRB,0.10068E+04_JPRB,0.11452E+04_JPRB /)  
KA(:, 1,10, 9) = (/ &
 & 0.12511E+04_JPRB,0.10989E+04_JPRB,0.94665E+03_JPRB,0.79449E+03_JPRB,0.64227E+03_JPRB, &
 & 0.73248E+03_JPRB,0.87121E+03_JPRB,0.10099E+04_JPRB,0.11487E+04_JPRB /)  
KA(:, 2,10, 9) = (/ &
 & 0.12350E+04_JPRB,0.10848E+04_JPRB,0.93449E+03_JPRB,0.78435E+03_JPRB,0.63416E+03_JPRB, &
 & 0.73188E+03_JPRB,0.87073E+03_JPRB,0.10095E+04_JPRB,0.11483E+04_JPRB /)  
KA(:, 3,10, 9) = (/ &
 & 0.12209E+04_JPRB,0.10725E+04_JPRB,0.92407E+03_JPRB,0.77565E+03_JPRB,0.62724E+03_JPRB, &
 & 0.73132E+03_JPRB,0.87012E+03_JPRB,0.10091E+04_JPRB,0.11477E+04_JPRB /)  
KA(:, 4,10, 9) = (/ &
 & 0.12088E+04_JPRB,0.10618E+04_JPRB,0.91493E+03_JPRB,0.76801E+03_JPRB,0.62113E+03_JPRB, &
 & 0.73072E+03_JPRB,0.86943E+03_JPRB,0.10082E+04_JPRB,0.11469E+04_JPRB /)  
KA(:, 5,10, 9) = (/ &
 & 0.11981E+04_JPRB,0.10526E+04_JPRB,0.90691E+03_JPRB,0.76134E+03_JPRB,0.61583E+03_JPRB, &
 & 0.72997E+03_JPRB,0.86853E+03_JPRB,0.10072E+04_JPRB,0.11458E+04_JPRB /)  
KA(:, 1,11, 9) = (/ &
 & 0.12119E+04_JPRB,0.10646E+04_JPRB,0.91723E+03_JPRB,0.76995E+03_JPRB,0.62265E+03_JPRB, &
 & 0.73201E+03_JPRB,0.87093E+03_JPRB,0.10098E+04_JPRB,0.11487E+04_JPRB /)  
KA(:, 2,11, 9) = (/ &
 & 0.11986E+04_JPRB,0.10529E+04_JPRB,0.90727E+03_JPRB,0.76161E+03_JPRB,0.61603E+03_JPRB, &
 & 0.73147E+03_JPRB,0.87046E+03_JPRB,0.10094E+04_JPRB,0.11483E+04_JPRB /)  
KA(:, 3,11, 9) = (/ &
 & 0.11871E+04_JPRB,0.10429E+04_JPRB,0.89865E+03_JPRB,0.75449E+03_JPRB,0.61031E+03_JPRB, &
 & 0.73094E+03_JPRB,0.86988E+03_JPRB,0.10088E+04_JPRB,0.11477E+04_JPRB /)  
KA(:, 4,11, 9) = (/ &
 & 0.11772E+04_JPRB,0.10342E+04_JPRB,0.89122E+03_JPRB,0.74824E+03_JPRB,0.60537E+03_JPRB, &
 & 0.73035E+03_JPRB,0.86918E+03_JPRB,0.10081E+04_JPRB,0.11469E+04_JPRB /)  
KA(:, 5,11, 9) = (/ &
 & 0.11684E+04_JPRB,0.10265E+04_JPRB,0.88467E+03_JPRB,0.74278E+03_JPRB,0.60127E+03_JPRB, &
 & 0.72963E+03_JPRB,0.86831E+03_JPRB,0.10071E+04_JPRB,0.11458E+04_JPRB /)  
KA(:, 1,12, 9) = (/ &
 & 0.11796E+04_JPRB,0.10363E+04_JPRB,0.89308E+03_JPRB,0.74980E+03_JPRB,0.60664E+03_JPRB, &
 & 0.73158E+03_JPRB,0.87066E+03_JPRB,0.10097E+04_JPRB,0.11487E+04_JPRB /)  
KA(:, 2,12, 9) = (/ &
 & 0.11688E+04_JPRB,0.10268E+04_JPRB,0.88492E+03_JPRB,0.74297E+03_JPRB,0.60173E+03_JPRB, &
 & 0.73111E+03_JPRB,0.87023E+03_JPRB,0.10093E+04_JPRB,0.11483E+04_JPRB /)  
KA(:, 3,12, 9) = (/ &
 & 0.11594E+04_JPRB,0.10186E+04_JPRB,0.87787E+03_JPRB,0.73715E+03_JPRB,0.59711E+03_JPRB, &
 & 0.73061E+03_JPRB,0.86968E+03_JPRB,0.10088E+04_JPRB,0.11478E+04_JPRB /)  
KA(:, 4,12, 9) = (/ &
 & 0.11512E+04_JPRB,0.10115E+04_JPRB,0.87180E+03_JPRB,0.73203E+03_JPRB,0.59373E+03_JPRB, &
 & 0.73004E+03_JPRB,0.86900E+03_JPRB,0.10080E+04_JPRB,0.11469E+04_JPRB /)  
KA(:, 5,12, 9) = (/ &
 & 0.11441E+04_JPRB,0.10053E+04_JPRB,0.86640E+03_JPRB,0.72756E+03_JPRB,0.59149E+03_JPRB, &
 & 0.72934E+03_JPRB,0.86813E+03_JPRB,0.10070E+04_JPRB,0.11458E+04_JPRB /)  
KA(:, 1,13, 9) = (/ &
 & 0.11533E+04_JPRB,0.10132E+04_JPRB,0.87330E+03_JPRB,0.73334E+03_JPRB,0.59476E+03_JPRB, &
 & 0.73130E+03_JPRB,0.87046E+03_JPRB,0.10096E+04_JPRB,0.11487E+04_JPRB /)  
KA(:, 2,13, 9) = (/ &
 & 0.11444E+04_JPRB,0.10055E+04_JPRB,0.86659E+03_JPRB,0.72770E+03_JPRB,0.59240E+03_JPRB, &
 & 0.73084E+03_JPRB,0.87005E+03_JPRB,0.10092E+04_JPRB,0.11483E+04_JPRB /)  
KA(:, 3,13, 9) = (/ &
 & 0.11367E+04_JPRB,0.99882E+03_JPRB,0.86084E+03_JPRB,0.72297E+03_JPRB,0.59186E+03_JPRB, &
 & 0.73036E+03_JPRB,0.86950E+03_JPRB,0.10087E+04_JPRB,0.11478E+04_JPRB /)  
KA(:, 4,13, 9) = (/ &
 & 0.11300E+04_JPRB,0.99294E+03_JPRB,0.85585E+03_JPRB,0.71880E+03_JPRB,0.59143E+03_JPRB, &
 & 0.72979E+03_JPRB,0.86883E+03_JPRB,0.10079E+04_JPRB,0.11469E+04_JPRB /)  
KA(:, 5,13, 9) = (/ &
 & 0.11242E+04_JPRB,0.98788E+03_JPRB,0.85146E+03_JPRB,0.71512E+03_JPRB,0.59082E+03_JPRB, &
 & 0.72910E+03_JPRB,0.86797E+03_JPRB,0.10069E+04_JPRB,0.11459E+04_JPRB /)  
KA(:, 1, 1,10) = (/ &
 & 0.19609E+04_JPRB,0.17196E+04_JPRB,0.14787E+04_JPRB,0.12373E+04_JPRB,0.99636E+03_JPRB, &
 & 0.75577E+03_JPRB,0.88158E+03_JPRB,0.10175E+04_JPRB,0.11538E+04_JPRB /)  
KA(:, 2, 1,10) = (/ &
 & 0.19102E+04_JPRB,0.16765E+04_JPRB,0.14403E+04_JPRB,0.12063E+04_JPRB,0.97232E+03_JPRB, &
 & 0.74406E+03_JPRB,0.87986E+03_JPRB,0.10152E+04_JPRB,0.11513E+04_JPRB /)  
KA(:, 3, 1,10) = (/ &
 & 0.18658E+04_JPRB,0.16364E+04_JPRB,0.14075E+04_JPRB,0.11783E+04_JPRB,0.94916E+03_JPRB, &
 & 0.74249E+03_JPRB,0.87815E+03_JPRB,0.10135E+04_JPRB,0.11491E+04_JPRB /)  
KA(:, 4, 1,10) = (/ &
 & 0.18250E+04_JPRB,0.16014E+04_JPRB,0.13778E+04_JPRB,0.11533E+04_JPRB,0.92945E+03_JPRB, &
 & 0.74050E+03_JPRB,0.87640E+03_JPRB,0.10114E+04_JPRB,0.11477E+04_JPRB /)  
KA(:, 5, 1,10) = (/ &
 & 0.17888E+04_JPRB,0.15692E+04_JPRB,0.13504E+04_JPRB,0.11313E+04_JPRB,0.91134E+03_JPRB, &
 & 0.73837E+03_JPRB,0.87432E+03_JPRB,0.10096E+04_JPRB,0.11467E+04_JPRB /)  
KA(:, 1, 2,10) = (/ &
 & 0.18108E+04_JPRB,0.15879E+04_JPRB,0.13673E+04_JPRB,0.11437E+04_JPRB,0.92213E+03_JPRB, &
 & 0.74428E+03_JPRB,0.88077E+03_JPRB,0.10175E+04_JPRB,0.11547E+04_JPRB /)  
KA(:, 2, 2,10) = (/ &
 & 0.17684E+04_JPRB,0.15508E+04_JPRB,0.13352E+04_JPRB,0.11178E+04_JPRB,0.90099E+03_JPRB, &
 & 0.74265E+03_JPRB,0.87920E+03_JPRB,0.10158E+04_JPRB,0.11521E+04_JPRB /)  
KA(:, 3, 2,10) = (/ &
 & 0.17293E+04_JPRB,0.15183E+04_JPRB,0.13063E+04_JPRB,0.10931E+04_JPRB,0.88199E+03_JPRB, &
 & 0.74117E+03_JPRB,0.87755E+03_JPRB,0.10136E+04_JPRB,0.11500E+04_JPRB /)  
KA(:, 4, 2,10) = (/ &
 & 0.16960E+04_JPRB,0.14887E+04_JPRB,0.12799E+04_JPRB,0.10727E+04_JPRB,0.86433E+03_JPRB, &
 & 0.73957E+03_JPRB,0.87577E+03_JPRB,0.10116E+04_JPRB,0.11482E+04_JPRB /)  
KA(:, 5, 2,10) = (/ &
 & 0.16637E+04_JPRB,0.14607E+04_JPRB,0.12562E+04_JPRB,0.10527E+04_JPRB,0.84877E+03_JPRB, &
 & 0.73748E+03_JPRB,0.87409E+03_JPRB,0.10096E+04_JPRB,0.11470E+04_JPRB /)  
KA(:, 1, 3,10) = (/ &
 & 0.16939E+04_JPRB,0.14847E+04_JPRB,0.12786E+04_JPRB,0.10705E+04_JPRB,0.86372E+03_JPRB, &
 & 0.74343E+03_JPRB,0.88064E+03_JPRB,0.10178E+04_JPRB,0.11559E+04_JPRB /)  
KA(:, 2, 3,10) = (/ &
 & 0.16557E+04_JPRB,0.14542E+04_JPRB,0.12503E+04_JPRB,0.10478E+04_JPRB,0.84533E+03_JPRB, &
 & 0.74182E+03_JPRB,0.87906E+03_JPRB,0.10163E+04_JPRB,0.11537E+04_JPRB /)  
KA(:, 3, 3,10) = (/ &
 & 0.16218E+04_JPRB,0.14239E+04_JPRB,0.12249E+04_JPRB,0.10266E+04_JPRB,0.82819E+03_JPRB, &
 & 0.74031E+03_JPRB,0.87730E+03_JPRB,0.10137E+04_JPRB,0.11513E+04_JPRB /)  
KA(:, 4, 3,10) = (/ &
 & 0.15929E+04_JPRB,0.13992E+04_JPRB,0.12027E+04_JPRB,0.10077E+04_JPRB,0.81299E+03_JPRB, &
 & 0.73896E+03_JPRB,0.87590E+03_JPRB,0.10123E+04_JPRB,0.11493E+04_JPRB /)  
KA(:, 5, 3,10) = (/ &
 & 0.15654E+04_JPRB,0.13740E+04_JPRB,0.11824E+04_JPRB,0.99136E+03_JPRB,0.79933E+03_JPRB, &
 & 0.73740E+03_JPRB,0.87406E+03_JPRB,0.10104E+04_JPRB,0.11477E+04_JPRB /)  
KA(:, 1, 4,10) = (/ &
 & 0.15959E+04_JPRB,0.14010E+04_JPRB,0.12054E+04_JPRB,0.10100E+04_JPRB,0.81522E+03_JPRB, &
 & 0.74271E+03_JPRB,0.88040E+03_JPRB,0.10180E+04_JPRB,0.11570E+04_JPRB /)  
KA(:, 2, 4,10) = (/ &
 & 0.15637E+04_JPRB,0.13710E+04_JPRB,0.11804E+04_JPRB,0.98920E+03_JPRB,0.79803E+03_JPRB, &
 & 0.74139E+03_JPRB,0.87903E+03_JPRB,0.10168E+04_JPRB,0.11552E+04_JPRB /)  
KA(:, 3, 4,10) = (/ &
 & 0.15330E+04_JPRB,0.13459E+04_JPRB,0.11594E+04_JPRB,0.97120E+03_JPRB,0.78314E+03_JPRB, &
 & 0.74000E+03_JPRB,0.87753E+03_JPRB,0.10151E+04_JPRB,0.11528E+04_JPRB /)  
KA(:, 4, 4,10) = (/ &
 & 0.15077E+04_JPRB,0.13229E+04_JPRB,0.11386E+04_JPRB,0.95486E+03_JPRB,0.77029E+03_JPRB, &
 & 0.73854E+03_JPRB,0.87600E+03_JPRB,0.10131E+04_JPRB,0.11506E+04_JPRB /)  
KA(:, 5, 4,10) = (/ &
 & 0.14835E+04_JPRB,0.13025E+04_JPRB,0.11209E+04_JPRB,0.94000E+03_JPRB,0.75786E+03_JPRB, &
 & 0.73717E+03_JPRB,0.87438E+03_JPRB,0.10111E+04_JPRB,0.11486E+04_JPRB /)  
KA(:, 1, 5,10) = (/ &
 & 0.15126E+04_JPRB,0.13285E+04_JPRB,0.11431E+04_JPRB,0.95745E+03_JPRB,0.77284E+03_JPRB, &
 & 0.74220E+03_JPRB,0.88024E+03_JPRB,0.10187E+04_JPRB,0.11578E+04_JPRB /)  
KA(:, 2, 5,10) = (/ &
 & 0.14829E+04_JPRB,0.13024E+04_JPRB,0.11209E+04_JPRB,0.94020E+03_JPRB,0.75863E+03_JPRB, &
 & 0.74099E+03_JPRB,0.87909E+03_JPRB,0.10174E+04_JPRB,0.11564E+04_JPRB /)  
KA(:, 3, 5,10) = (/ &
 & 0.14582E+04_JPRB,0.12806E+04_JPRB,0.11014E+04_JPRB,0.92377E+03_JPRB,0.74596E+03_JPRB, &
 & 0.73960E+03_JPRB,0.87772E+03_JPRB,0.10159E+04_JPRB,0.11544E+04_JPRB /)  
KA(:, 4, 5,10) = (/ &
 & 0.14345E+04_JPRB,0.12594E+04_JPRB,0.10847E+04_JPRB,0.90887E+03_JPRB,0.73410E+03_JPRB, &
 & 0.73828E+03_JPRB,0.87622E+03_JPRB,0.10139E+04_JPRB,0.11518E+04_JPRB /)  
KA(:, 5, 5,10) = (/ &
 & 0.14140E+04_JPRB,0.12418E+04_JPRB,0.10683E+04_JPRB,0.89661E+03_JPRB,0.72364E+03_JPRB, &
 & 0.73696E+03_JPRB,0.87469E+03_JPRB,0.10119E+04_JPRB,0.11501E+04_JPRB /)  
KA(:, 1, 6,10) = (/ &
 & 0.14435E+04_JPRB,0.12676E+04_JPRB,0.10914E+04_JPRB,0.91493E+03_JPRB,0.73889E+03_JPRB, &
 & 0.74179E+03_JPRB,0.88024E+03_JPRB,0.10190E+04_JPRB,0.11586E+04_JPRB /)  
KA(:, 2, 6,10) = (/ &
 & 0.14184E+04_JPRB,0.12443E+04_JPRB,0.10722E+04_JPRB,0.89834E+03_JPRB,0.72535E+03_JPRB, &
 & 0.74069E+03_JPRB,0.87922E+03_JPRB,0.10178E+04_JPRB,0.11574E+04_JPRB /)  
KA(:, 3, 6,10) = (/ &
 & 0.13949E+04_JPRB,0.12245E+04_JPRB,0.10548E+04_JPRB,0.88411E+03_JPRB,0.71441E+03_JPRB, &
 & 0.73951E+03_JPRB,0.87792E+03_JPRB,0.10164E+04_JPRB,0.11554E+04_JPRB /)  
KA(:, 4, 6,10) = (/ &
 & 0.13745E+04_JPRB,0.12070E+04_JPRB,0.10388E+04_JPRB,0.87157E+03_JPRB,0.70381E+03_JPRB, &
 & 0.73817E+03_JPRB,0.87654E+03_JPRB,0.10150E+04_JPRB,0.11533E+04_JPRB /)  
KA(:, 5, 6,10) = (/ &
 & 0.13558E+04_JPRB,0.11909E+04_JPRB,0.10253E+04_JPRB,0.86039E+03_JPRB,0.69505E+03_JPRB, &
 & 0.73669E+03_JPRB,0.87508E+03_JPRB,0.10128E+04_JPRB,0.11510E+04_JPRB /)  
KA(:, 1, 7,10) = (/ &
 & 0.13849E+04_JPRB,0.12154E+04_JPRB,0.10465E+04_JPRB,0.87809E+03_JPRB,0.70922E+03_JPRB, &
 & 0.74150E+03_JPRB,0.88017E+03_JPRB,0.10197E+04_JPRB,0.11599E+04_JPRB /)  
KA(:, 2, 7,10) = (/ &
 & 0.13622E+04_JPRB,0.11954E+04_JPRB,0.10296E+04_JPRB,0.86328E+03_JPRB,0.69750E+03_JPRB, &
 & 0.74031E+03_JPRB,0.87926E+03_JPRB,0.10184E+04_JPRB,0.11581E+04_JPRB /)  
KA(:, 3, 7,10) = (/ &
 & 0.13407E+04_JPRB,0.11775E+04_JPRB,0.10144E+04_JPRB,0.85098E+03_JPRB,0.68710E+03_JPRB, &
 & 0.73933E+03_JPRB,0.87824E+03_JPRB,0.10171E+04_JPRB,0.11568E+04_JPRB /)  
KA(:, 4, 7,10) = (/ &
 & 0.13234E+04_JPRB,0.11620E+04_JPRB,0.10006E+04_JPRB,0.83940E+03_JPRB,0.67808E+03_JPRB, &
 & 0.73818E+03_JPRB,0.87693E+03_JPRB,0.10157E+04_JPRB,0.11549E+04_JPRB /)  
KA(:, 5, 7,10) = (/ &
 & 0.13077E+04_JPRB,0.11481E+04_JPRB,0.98850E+03_JPRB,0.82952E+03_JPRB,0.66976E+03_JPRB, &
 & 0.73685E+03_JPRB,0.87533E+03_JPRB,0.10140E+04_JPRB,0.11525E+04_JPRB /)  
KA(:, 1, 8,10) = (/ &
 & 0.13336E+04_JPRB,0.11711E+04_JPRB,0.10088E+04_JPRB,0.84626E+03_JPRB,0.68382E+03_JPRB, &
 & 0.74131E+03_JPRB,0.88025E+03_JPRB,0.10205E+04_JPRB,0.11609E+04_JPRB /)  
KA(:, 2, 8,10) = (/ &
 & 0.13133E+04_JPRB,0.11535E+04_JPRB,0.99382E+03_JPRB,0.83328E+03_JPRB,0.67355E+03_JPRB, &
 & 0.73954E+03_JPRB,0.87931E+03_JPRB,0.10187E+04_JPRB,0.11591E+04_JPRB /)  
KA(:, 3, 8,10) = (/ &
 & 0.12952E+04_JPRB,0.11377E+04_JPRB,0.97980E+03_JPRB,0.82257E+03_JPRB,0.66450E+03_JPRB, &
 & 0.73910E+03_JPRB,0.87831E+03_JPRB,0.10177E+04_JPRB,0.11576E+04_JPRB /)  
KA(:, 4, 8,10) = (/ &
 & 0.12798E+04_JPRB,0.11238E+04_JPRB,0.96848E+03_JPRB,0.81189E+03_JPRB,0.65672E+03_JPRB, &
 & 0.73820E+03_JPRB,0.87729E+03_JPRB,0.10162E+04_JPRB,0.11560E+04_JPRB /)  
KA(:, 5, 8,10) = (/ &
 & 0.12652E+04_JPRB,0.11115E+04_JPRB,0.95739E+03_JPRB,0.80373E+03_JPRB,0.64938E+03_JPRB, &
 & 0.73712E+03_JPRB,0.87584E+03_JPRB,0.10149E+04_JPRB,0.11541E+04_JPRB /)  
KA(:, 1, 9,10) = (/ &
 & 0.12921E+04_JPRB,0.11338E+04_JPRB,0.97649E+03_JPRB,0.81965E+03_JPRB,0.66193E+03_JPRB, &
 & 0.74117E+03_JPRB,0.88056E+03_JPRB,0.10212E+04_JPRB,0.11621E+04_JPRB /)  
KA(:, 2, 9,10) = (/ &
 & 0.12725E+04_JPRB,0.11175E+04_JPRB,0.96294E+03_JPRB,0.80792E+03_JPRB,0.65314E+03_JPRB, &
 & 0.74018E+03_JPRB,0.87944E+03_JPRB,0.10196E+04_JPRB,0.11602E+04_JPRB /)  
KA(:, 3, 9,10) = (/ &
 & 0.12569E+04_JPRB,0.11032E+04_JPRB,0.95038E+03_JPRB,0.79825E+03_JPRB,0.64471E+03_JPRB, &
 & 0.73910E+03_JPRB,0.87852E+03_JPRB,0.10181E+04_JPRB,0.11585E+04_JPRB /)  
KA(:, 4, 9,10) = (/ &
 & 0.12428E+04_JPRB,0.10914E+04_JPRB,0.94028E+03_JPRB,0.78940E+03_JPRB,0.63769E+03_JPRB, &
 & 0.73816E+03_JPRB,0.87758E+03_JPRB,0.10170E+04_JPRB,0.11569E+04_JPRB /)  
KA(:, 5, 9,10) = (/ &
 & 0.12310E+04_JPRB,0.10815E+04_JPRB,0.93149E+03_JPRB,0.78151E+03_JPRB,0.63218E+03_JPRB, &
 & 0.73726E+03_JPRB,0.87637E+03_JPRB,0.10156E+04_JPRB,0.11553E+04_JPRB /)  
KA(:, 1,10,10) = (/ &
 & 0.12531E+04_JPRB,0.11009E+04_JPRB,0.94808E+03_JPRB,0.79569E+03_JPRB,0.64353E+03_JPRB, &
 & 0.74092E+03_JPRB,0.88101E+03_JPRB,0.10222E+04_JPRB,0.11631E+04_JPRB /)  
KA(:, 2,10,10) = (/ &
 & 0.12357E+04_JPRB,0.10861E+04_JPRB,0.93599E+03_JPRB,0.78490E+03_JPRB,0.63564E+03_JPRB, &
 & 0.74008E+03_JPRB,0.87961E+03_JPRB,0.10203E+04_JPRB,0.11613E+04_JPRB /)  
KA(:, 3,10,10) = (/ &
 & 0.12227E+04_JPRB,0.10738E+04_JPRB,0.92501E+03_JPRB,0.77680E+03_JPRB,0.62842E+03_JPRB, &
 & 0.73914E+03_JPRB,0.87860E+03_JPRB,0.10179E+04_JPRB,0.11592E+04_JPRB /)  
KA(:, 4,10,10) = (/ &
 & 0.12109E+04_JPRB,0.10632E+04_JPRB,0.91605E+03_JPRB,0.76920E+03_JPRB,0.62177E+03_JPRB, &
 & 0.73819E+03_JPRB,0.87758E+03_JPRB,0.10174E+04_JPRB,0.11577E+04_JPRB /)  
KA(:, 5,10,10) = (/ &
 & 0.11998E+04_JPRB,0.10537E+04_JPRB,0.90813E+03_JPRB,0.76232E+03_JPRB,0.61616E+03_JPRB, &
 & 0.73732E+03_JPRB,0.87676E+03_JPRB,0.10162E+04_JPRB,0.11563E+04_JPRB /)  
KA(:, 1,11,10) = (/ &
 & 0.12137E+04_JPRB,0.10654E+04_JPRB,0.91884E+03_JPRB,0.77105E+03_JPRB,0.62358E+03_JPRB, &
 & 0.74042E+03_JPRB,0.88057E+03_JPRB,0.10221E+04_JPRB,0.11630E+04_JPRB /)  
KA(:, 2,11,10) = (/ &
 & 0.11999E+04_JPRB,0.10545E+04_JPRB,0.90854E+03_JPRB,0.76253E+03_JPRB,0.61715E+03_JPRB, &
 & 0.73961E+03_JPRB,0.87932E+03_JPRB,0.10201E+04_JPRB,0.11611E+04_JPRB /)  
KA(:, 3,11,10) = (/ &
 & 0.11890E+04_JPRB,0.10445E+04_JPRB,0.90019E+03_JPRB,0.75537E+03_JPRB,0.61109E+03_JPRB, &
 & 0.73864E+03_JPRB,0.87832E+03_JPRB,0.10186E+04_JPRB,0.11592E+04_JPRB /)  
KA(:, 4,11,10) = (/ &
 & 0.11789E+04_JPRB,0.10359E+04_JPRB,0.89280E+03_JPRB,0.74928E+03_JPRB,0.60622E+03_JPRB, &
 & 0.73779E+03_JPRB,0.87747E+03_JPRB,0.10172E+04_JPRB,0.11577E+04_JPRB /)  
KA(:, 5,11,10) = (/ &
 & 0.11709E+04_JPRB,0.10287E+04_JPRB,0.88607E+03_JPRB,0.74401E+03_JPRB,0.60247E+03_JPRB, &
 & 0.73688E+03_JPRB,0.87644E+03_JPRB,0.10160E+04_JPRB,0.11563E+04_JPRB /)  
KA(:, 1,12,10) = (/ &
 & 0.11820E+04_JPRB,0.10383E+04_JPRB,0.89456E+03_JPRB,0.75081E+03_JPRB,0.60714E+03_JPRB, &
 & 0.74001E+03_JPRB,0.88049E+03_JPRB,0.10220E+04_JPRB,0.11631E+04_JPRB /)  
KA(:, 2,12,10) = (/ &
 & 0.11713E+04_JPRB,0.10290E+04_JPRB,0.88623E+03_JPRB,0.74407E+03_JPRB,0.60058E+03_JPRB, &
 & 0.73921E+03_JPRB,0.87901E+03_JPRB,0.10201E+04_JPRB,0.11611E+04_JPRB /)  
KA(:, 3,12,10) = (/ &
 & 0.11605E+04_JPRB,0.10200E+04_JPRB,0.87951E+03_JPRB,0.73788E+03_JPRB,0.59769E+03_JPRB, &
 & 0.73835E+03_JPRB,0.87808E+03_JPRB,0.10182E+04_JPRB,0.11591E+04_JPRB /)  
KA(:, 4,12,10) = (/ &
 & 0.11533E+04_JPRB,0.10132E+04_JPRB,0.87284E+03_JPRB,0.73305E+03_JPRB,0.59795E+03_JPRB, &
 & 0.73753E+03_JPRB,0.87718E+03_JPRB,0.10171E+04_JPRB,0.11577E+04_JPRB /)  
KA(:, 5,12,10) = (/ &
 & 0.11467E+04_JPRB,0.10071E+04_JPRB,0.86739E+03_JPRB,0.72890E+03_JPRB,0.59711E+03_JPRB, &
 & 0.73664E+03_JPRB,0.87623E+03_JPRB,0.10159E+04_JPRB,0.11563E+04_JPRB /)  
KA(:, 1,13,10) = (/ &
 & 0.11553E+04_JPRB,0.10149E+04_JPRB,0.87419E+03_JPRB,0.73470E+03_JPRB,0.59975E+03_JPRB, &
 & 0.73968E+03_JPRB,0.88029E+03_JPRB,0.10219E+04_JPRB,0.11630E+04_JPRB /)  
KA(:, 2,13,10) = (/ &
 & 0.11455E+04_JPRB,0.10072E+04_JPRB,0.86782E+03_JPRB,0.72873E+03_JPRB,0.59921E+03_JPRB, &
 & 0.73889E+03_JPRB,0.87889E+03_JPRB,0.10200E+04_JPRB,0.11611E+04_JPRB /)  
KA(:, 3,13,10) = (/ &
 & 0.11380E+04_JPRB,0.10000E+04_JPRB,0.86190E+03_JPRB,0.72452E+03_JPRB,0.59831E+03_JPRB, &
 & 0.73799E+03_JPRB,0.87789E+03_JPRB,0.10182E+04_JPRB,0.11592E+04_JPRB /)  
KA(:, 4,13,10) = (/ &
 & 0.11318E+04_JPRB,0.99472E+03_JPRB,0.85697E+03_JPRB,0.71950E+03_JPRB,0.59744E+03_JPRB, &
 & 0.73726E+03_JPRB,0.87708E+03_JPRB,0.10170E+04_JPRB,0.11577E+04_JPRB /)  
KA(:, 5,13,10) = (/ &
 & 0.11253E+04_JPRB,0.98825E+03_JPRB,0.85273E+03_JPRB,0.71635E+03_JPRB,0.59683E+03_JPRB, &
 & 0.73639E+03_JPRB,0.87606E+03_JPRB,0.10160E+04_JPRB,0.11562E+04_JPRB /)  
KA(:, 1, 1,11) = (/ &
 & 0.19598E+04_JPRB,0.17186E+04_JPRB,0.14777E+04_JPRB,0.12380E+04_JPRB,0.99729E+03_JPRB, &
 & 0.75567E+03_JPRB,0.88469E+03_JPRB,0.10202E+04_JPRB,0.11560E+04_JPRB /)  
KA(:, 2, 1,11) = (/ &
 & 0.19102E+04_JPRB,0.16743E+04_JPRB,0.14414E+04_JPRB,0.12066E+04_JPRB,0.97117E+03_JPRB, &
 & 0.74679E+03_JPRB,0.88252E+03_JPRB,0.10178E+04_JPRB,0.11544E+04_JPRB /)  
KA(:, 3, 1,11) = (/ &
 & 0.18656E+04_JPRB,0.16383E+04_JPRB,0.14073E+04_JPRB,0.11791E+04_JPRB,0.94951E+03_JPRB, &
 & 0.74505E+03_JPRB,0.88029E+03_JPRB,0.10159E+04_JPRB,0.11530E+04_JPRB /)  
KA(:, 4, 1,11) = (/ &
 & 0.18261E+04_JPRB,0.16025E+04_JPRB,0.13782E+04_JPRB,0.11540E+04_JPRB,0.92917E+03_JPRB, &
 & 0.74299E+03_JPRB,0.87816E+03_JPRB,0.10141E+04_JPRB,0.11522E+04_JPRB /)  
KA(:, 5, 1,11) = (/ &
 & 0.17888E+04_JPRB,0.15710E+04_JPRB,0.13500E+04_JPRB,0.11298E+04_JPRB,0.91140E+03_JPRB, &
 & 0.74109E+03_JPRB,0.87588E+03_JPRB,0.10122E+04_JPRB,0.11510E+04_JPRB /)  
KA(:, 1, 2,11) = (/ &
 & 0.18117E+04_JPRB,0.15887E+04_JPRB,0.13651E+04_JPRB,0.11459E+04_JPRB,0.92177E+03_JPRB, &
 & 0.74731E+03_JPRB,0.88412E+03_JPRB,0.10203E+04_JPRB,0.11568E+04_JPRB /)  
KA(:, 2, 2,11) = (/ &
 & 0.17673E+04_JPRB,0.15512E+04_JPRB,0.13335E+04_JPRB,0.11174E+04_JPRB,0.90028E+03_JPRB, &
 & 0.74546E+03_JPRB,0.88203E+03_JPRB,0.10179E+04_JPRB,0.11551E+04_JPRB /)  
KA(:, 3, 2,11) = (/ &
 & 0.17317E+04_JPRB,0.15193E+04_JPRB,0.13050E+04_JPRB,0.10955E+04_JPRB,0.88112E+03_JPRB, &
 & 0.74378E+03_JPRB,0.87978E+03_JPRB,0.10161E+04_JPRB,0.11535E+04_JPRB /)  
KA(:, 4, 2,11) = (/ &
 & 0.16956E+04_JPRB,0.14873E+04_JPRB,0.12805E+04_JPRB,0.10729E+04_JPRB,0.86470E+03_JPRB, &
 & 0.74189E+03_JPRB,0.87768E+03_JPRB,0.10142E+04_JPRB,0.11524E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART7',1,ZHOOK_HANDLE)
END SUBROUTINE PART7


SUBROUTINE PART8

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART8',0,ZHOOK_HANDLE)


KA(:, 5, 2,11) = (/ &
 & 0.16657E+04_JPRB,0.14596E+04_JPRB,0.12568E+04_JPRB,0.10531E+04_JPRB,0.84904E+03_JPRB, &
 & 0.73979E+03_JPRB,0.87528E+03_JPRB,0.10122E+04_JPRB,0.11511E+04_JPRB /)  
KA(:, 1, 3,11) = (/ &
 & 0.16927E+04_JPRB,0.14859E+04_JPRB,0.12782E+04_JPRB,0.10724E+04_JPRB,0.86335E+03_JPRB, &
 & 0.74646E+03_JPRB,0.88392E+03_JPRB,0.10211E+04_JPRB,0.11579E+04_JPRB /)  
KA(:, 2, 3,11) = (/ &
 & 0.16581E+04_JPRB,0.14524E+04_JPRB,0.12540E+04_JPRB,0.10466E+04_JPRB,0.84448E+03_JPRB, &
 & 0.74471E+03_JPRB,0.88205E+03_JPRB,0.10189E+04_JPRB,0.11562E+04_JPRB /)  
KA(:, 3, 3,11) = (/ &
 & 0.16261E+04_JPRB,0.14229E+04_JPRB,0.12269E+04_JPRB,0.10264E+04_JPRB,0.82790E+03_JPRB, &
 & 0.74305E+03_JPRB,0.87988E+03_JPRB,0.10167E+04_JPRB,0.11544E+04_JPRB /)  
KA(:, 4, 3,11) = (/ &
 & 0.15929E+04_JPRB,0.13986E+04_JPRB,0.12038E+04_JPRB,0.10084E+04_JPRB,0.81266E+03_JPRB, &
 & 0.74160E+03_JPRB,0.87767E+03_JPRB,0.10148E+04_JPRB,0.11530E+04_JPRB /)  
KA(:, 5, 3,11) = (/ &
 & 0.15661E+04_JPRB,0.13746E+04_JPRB,0.11837E+04_JPRB,0.99103E+03_JPRB,0.79967E+03_JPRB, &
 & 0.73929E+03_JPRB,0.87586E+03_JPRB,0.10132E+04_JPRB,0.11521E+04_JPRB /)  
KA(:, 1, 4,11) = (/ &
 & 0.15973E+04_JPRB,0.14004E+04_JPRB,0.12065E+04_JPRB,0.10106E+04_JPRB,0.81385E+03_JPRB, &
 & 0.74599E+03_JPRB,0.88404E+03_JPRB,0.10218E+04_JPRB,0.11590E+04_JPRB /)  
KA(:, 2, 4,11) = (/ &
 & 0.15637E+04_JPRB,0.13722E+04_JPRB,0.11812E+04_JPRB,0.98900E+03_JPRB,0.79856E+03_JPRB, &
 & 0.74428E+03_JPRB,0.88217E+03_JPRB,0.10197E+04_JPRB,0.11572E+04_JPRB /)  
KA(:, 3, 4,11) = (/ &
 & 0.15340E+04_JPRB,0.13469E+04_JPRB,0.11576E+04_JPRB,0.97012E+03_JPRB,0.78412E+03_JPRB, &
 & 0.74257E+03_JPRB,0.88022E+03_JPRB,0.10176E+04_JPRB,0.11556E+04_JPRB /)  
KA(:, 4, 4,11) = (/ &
 & 0.15085E+04_JPRB,0.13226E+04_JPRB,0.11393E+04_JPRB,0.95486E+03_JPRB,0.76980E+03_JPRB, &
 & 0.74114E+03_JPRB,0.87815E+03_JPRB,0.10155E+04_JPRB,0.11538E+04_JPRB /)  
KA(:, 5, 4,11) = (/ &
 & 0.14836E+04_JPRB,0.13020E+04_JPRB,0.11212E+04_JPRB,0.93957E+03_JPRB,0.75824E+03_JPRB, &
 & 0.73939E+03_JPRB,0.87630E+03_JPRB,0.10138E+04_JPRB,0.11526E+04_JPRB /)  
KA(:, 1, 5,11) = (/ &
 & 0.15143E+04_JPRB,0.13286E+04_JPRB,0.11431E+04_JPRB,0.95847E+03_JPRB,0.77403E+03_JPRB, &
 & 0.74572E+03_JPRB,0.88418E+03_JPRB,0.10223E+04_JPRB,0.11603E+04_JPRB /)  
KA(:, 2, 5,11) = (/ &
 & 0.14842E+04_JPRB,0.13025E+04_JPRB,0.11230E+04_JPRB,0.94028E+03_JPRB,0.75881E+03_JPRB, &
 & 0.74405E+03_JPRB,0.88254E+03_JPRB,0.10205E+04_JPRB,0.11584E+04_JPRB /)  
KA(:, 3, 5,11) = (/ &
 & 0.14577E+04_JPRB,0.12799E+04_JPRB,0.11020E+04_JPRB,0.92340E+03_JPRB,0.74531E+03_JPRB, &
 & 0.74244E+03_JPRB,0.88060E+03_JPRB,0.10185E+04_JPRB,0.11566E+04_JPRB /)  
KA(:, 4, 5,11) = (/ &
 & 0.14365E+04_JPRB,0.12603E+04_JPRB,0.10859E+04_JPRB,0.90939E+03_JPRB,0.73467E+03_JPRB, &
 & 0.74090E+03_JPRB,0.87865E+03_JPRB,0.10164E+04_JPRB,0.11549E+04_JPRB /)  
KA(:, 5, 5,11) = (/ &
 & 0.14147E+04_JPRB,0.12422E+04_JPRB,0.10695E+04_JPRB,0.89657E+03_JPRB,0.72409E+03_JPRB, &
 & 0.73938E+03_JPRB,0.87659E+03_JPRB,0.10145E+04_JPRB,0.11530E+04_JPRB /)  
KA(:, 1, 6,11) = (/ &
 & 0.14426E+04_JPRB,0.12686E+04_JPRB,0.10911E+04_JPRB,0.91528E+03_JPRB,0.73914E+03_JPRB, &
 & 0.74563E+03_JPRB,0.88436E+03_JPRB,0.10228E+04_JPRB,0.11615E+04_JPRB /)  
KA(:, 2, 6,11) = (/ &
 & 0.14171E+04_JPRB,0.12457E+04_JPRB,0.10728E+04_JPRB,0.89861E+03_JPRB,0.72517E+03_JPRB, &
 & 0.74402E+03_JPRB,0.88280E+03_JPRB,0.10215E+04_JPRB,0.11596E+04_JPRB /)  
KA(:, 3, 6,11) = (/ &
 & 0.13943E+04_JPRB,0.12252E+04_JPRB,0.10539E+04_JPRB,0.88362E+03_JPRB,0.71333E+03_JPRB, &
 & 0.74243E+03_JPRB,0.88117E+03_JPRB,0.10194E+04_JPRB,0.11577E+04_JPRB /)  
KA(:, 4, 6,11) = (/ &
 & 0.13749E+04_JPRB,0.12056E+04_JPRB,0.10405E+04_JPRB,0.87188E+03_JPRB,0.70449E+03_JPRB, &
 & 0.74089E+03_JPRB,0.87923E+03_JPRB,0.10173E+04_JPRB,0.11560E+04_JPRB /)  
KA(:, 5, 6,11) = (/ &
 & 0.13580E+04_JPRB,0.11907E+04_JPRB,0.10258E+04_JPRB,0.85998E+03_JPRB,0.69473E+03_JPRB, &
 & 0.73937E+03_JPRB,0.87727E+03_JPRB,0.10154E+04_JPRB,0.11543E+04_JPRB /)  
KA(:, 1, 7,11) = (/ &
 & 0.13844E+04_JPRB,0.12166E+04_JPRB,0.10469E+04_JPRB,0.87815E+03_JPRB,0.70873E+03_JPRB, &
 & 0.74560E+03_JPRB,0.88449E+03_JPRB,0.10233E+04_JPRB,0.11626E+04_JPRB /)  
KA(:, 2, 7,11) = (/ &
 & 0.13610E+04_JPRB,0.11962E+04_JPRB,0.10291E+04_JPRB,0.86318E+03_JPRB,0.69730E+03_JPRB, &
 & 0.74409E+03_JPRB,0.88322E+03_JPRB,0.10221E+04_JPRB,0.11608E+04_JPRB /)  
KA(:, 3, 7,11) = (/ &
 & 0.13413E+04_JPRB,0.11786E+04_JPRB,0.10145E+04_JPRB,0.85031E+03_JPRB,0.68760E+03_JPRB, &
 & 0.74253E+03_JPRB,0.88154E+03_JPRB,0.10203E+04_JPRB,0.11589E+04_JPRB /)  
KA(:, 4, 7,11) = (/ &
 & 0.13235E+04_JPRB,0.11630E+04_JPRB,0.10007E+04_JPRB,0.84004E+03_JPRB,0.67864E+03_JPRB, &
 & 0.74101E+03_JPRB,0.87982E+03_JPRB,0.10185E+04_JPRB,0.11572E+04_JPRB /)  
KA(:, 5, 7,11) = (/ &
 & 0.13063E+04_JPRB,0.11482E+04_JPRB,0.98932E+03_JPRB,0.82998E+03_JPRB,0.67037E+03_JPRB, &
 & 0.73955E+03_JPRB,0.87796E+03_JPRB,0.10167E+04_JPRB,0.11554E+04_JPRB /)  
KA(:, 1, 8,11) = (/ &
 & 0.13361E+04_JPRB,0.11714E+04_JPRB,0.10092E+04_JPRB,0.84627E+03_JPRB,0.68340E+03_JPRB, &
 & 0.74540E+03_JPRB,0.88457E+03_JPRB,0.10236E+04_JPRB,0.11638E+04_JPRB /)  
KA(:, 2, 8,11) = (/ &
 & 0.13143E+04_JPRB,0.11537E+04_JPRB,0.99295E+03_JPRB,0.83355E+03_JPRB,0.67330E+03_JPRB, &
 & 0.74420E+03_JPRB,0.88339E+03_JPRB,0.10225E+04_JPRB,0.11619E+04_JPRB /)  
KA(:, 3, 8,11) = (/ &
 & 0.12952E+04_JPRB,0.11377E+04_JPRB,0.98075E+03_JPRB,0.82213E+03_JPRB,0.66496E+03_JPRB, &
 & 0.74271E+03_JPRB,0.88199E+03_JPRB,0.10211E+04_JPRB,0.11601E+04_JPRB /)  
KA(:, 4, 8,11) = (/ &
 & 0.12808E+04_JPRB,0.11242E+04_JPRB,0.96858E+03_JPRB,0.81350E+03_JPRB,0.65663E+03_JPRB, &
 & 0.74121E+03_JPRB,0.88037E+03_JPRB,0.10192E+04_JPRB,0.11582E+04_JPRB /)  
KA(:, 5, 8,11) = (/ &
 & 0.12664E+04_JPRB,0.11113E+04_JPRB,0.95757E+03_JPRB,0.80317E+03_JPRB,0.64978E+03_JPRB, &
 & 0.73975E+03_JPRB,0.87862E+03_JPRB,0.10173E+04_JPRB,0.11564E+04_JPRB /)  
KA(:, 1, 9,11) = (/ &
 & 0.12911E+04_JPRB,0.11331E+04_JPRB,0.97754E+03_JPRB,0.81972E+03_JPRB,0.66210E+03_JPRB, &
 & 0.74501E+03_JPRB,0.88462E+03_JPRB,0.10244E+04_JPRB,0.11652E+04_JPRB /)  
KA(:, 2, 9,11) = (/ &
 & 0.12743E+04_JPRB,0.11193E+04_JPRB,0.96288E+03_JPRB,0.80865E+03_JPRB,0.65325E+03_JPRB, &
 & 0.74437E+03_JPRB,0.88360E+03_JPRB,0.10230E+04_JPRB,0.11629E+04_JPRB /)  
KA(:, 3, 9,11) = (/ &
 & 0.12573E+04_JPRB,0.11051E+04_JPRB,0.95155E+03_JPRB,0.79729E+03_JPRB,0.64451E+03_JPRB, &
 & 0.74294E+03_JPRB,0.88237E+03_JPRB,0.10218E+04_JPRB,0.11610E+04_JPRB /)  
KA(:, 4, 9,11) = (/ &
 & 0.12441E+04_JPRB,0.10920E+04_JPRB,0.94089E+03_JPRB,0.78911E+03_JPRB,0.63797E+03_JPRB, &
 & 0.74148E+03_JPRB,0.88091E+03_JPRB,0.10202E+04_JPRB,0.11593E+04_JPRB /)  
KA(:, 5, 9,11) = (/ &
 & 0.12297E+04_JPRB,0.10813E+04_JPRB,0.93127E+03_JPRB,0.78127E+03_JPRB,0.63265E+03_JPRB, &
 & 0.74003E+03_JPRB,0.87926E+03_JPRB,0.10184E+04_JPRB,0.11573E+04_JPRB /)  
KA(:, 1,10,11) = (/ &
 & 0.12530E+04_JPRB,0.11001E+04_JPRB,0.94821E+03_JPRB,0.79486E+03_JPRB,0.64277E+03_JPRB, &
 & 0.74454E+03_JPRB,0.88447E+03_JPRB,0.10249E+04_JPRB,0.11664E+04_JPRB /)  
KA(:, 2,10,11) = (/ &
 & 0.12387E+04_JPRB,0.10865E+04_JPRB,0.93685E+03_JPRB,0.78643E+03_JPRB,0.63425E+03_JPRB, &
 & 0.74423E+03_JPRB,0.88371E+03_JPRB,0.10234E+04_JPRB,0.11637E+04_JPRB /)  
KA(:, 3,10,11) = (/ &
 & 0.12243E+04_JPRB,0.10744E+04_JPRB,0.92585E+03_JPRB,0.77676E+03_JPRB,0.62740E+03_JPRB, &
 & 0.74307E+03_JPRB,0.88260E+03_JPRB,0.10221E+04_JPRB,0.11620E+04_JPRB /)  
KA(:, 4,10,11) = (/ &
 & 0.12107E+04_JPRB,0.10640E+04_JPRB,0.91623E+03_JPRB,0.76957E+03_JPRB,0.62235E+03_JPRB, &
 & 0.74168E+03_JPRB,0.88129E+03_JPRB,0.10208E+04_JPRB,0.11602E+04_JPRB /)  
KA(:, 5,10,11) = (/ &
 & 0.12010E+04_JPRB,0.10536E+04_JPRB,0.90891E+03_JPRB,0.76248E+03_JPRB,0.61761E+03_JPRB, &
 & 0.74025E+03_JPRB,0.87965E+03_JPRB,0.10191E+04_JPRB,0.11583E+04_JPRB /)  
KA(:, 1,11,11) = (/ &
 & 0.12140E+04_JPRB,0.10672E+04_JPRB,0.91852E+03_JPRB,0.77048E+03_JPRB,0.62320E+03_JPRB, &
 & 0.74401E+03_JPRB,0.88413E+03_JPRB,0.10249E+04_JPRB,0.11664E+04_JPRB /)  
KA(:, 2,11,11) = (/ &
 & 0.12007E+04_JPRB,0.10549E+04_JPRB,0.90904E+03_JPRB,0.76333E+03_JPRB,0.61635E+03_JPRB, &
 & 0.74367E+03_JPRB,0.88337E+03_JPRB,0.10233E+04_JPRB,0.11639E+04_JPRB /)  
KA(:, 3,11,11) = (/ &
 & 0.11891E+04_JPRB,0.10458E+04_JPRB,0.90055E+03_JPRB,0.75543E+03_JPRB,0.61123E+03_JPRB, &
 & 0.74262E+03_JPRB,0.88229E+03_JPRB,0.10219E+04_JPRB,0.11620E+04_JPRB /)  
KA(:, 4,11,11) = (/ &
 & 0.11794E+04_JPRB,0.10371E+04_JPRB,0.89190E+03_JPRB,0.74912E+03_JPRB,0.60572E+03_JPRB, &
 & 0.74128E+03_JPRB,0.88110E+03_JPRB,0.10207E+04_JPRB,0.11602E+04_JPRB /)  
KA(:, 5,11,11) = (/ &
 & 0.11697E+04_JPRB,0.10285E+04_JPRB,0.88631E+03_JPRB,0.74374E+03_JPRB,0.60062E+03_JPRB, &
 & 0.73987E+03_JPRB,0.87958E+03_JPRB,0.10191E+04_JPRB,0.11583E+04_JPRB /)  
KA(:, 1,12,11) = (/ &
 & 0.11829E+04_JPRB,0.10373E+04_JPRB,0.89433E+03_JPRB,0.75107E+03_JPRB,0.60775E+03_JPRB, &
 & 0.74357E+03_JPRB,0.88385E+03_JPRB,0.10247E+04_JPRB,0.11664E+04_JPRB /)  
KA(:, 2,12,11) = (/ &
 & 0.11707E+04_JPRB,0.10276E+04_JPRB,0.88712E+03_JPRB,0.74426E+03_JPRB,0.60163E+03_JPRB, &
 & 0.74327E+03_JPRB,0.88309E+03_JPRB,0.10231E+04_JPRB,0.11639E+04_JPRB /)  
KA(:, 3,12,11) = (/ &
 & 0.11629E+04_JPRB,0.10211E+04_JPRB,0.88018E+03_JPRB,0.73831E+03_JPRB,0.60184E+03_JPRB, &
 & 0.74224E+03_JPRB,0.88203E+03_JPRB,0.10219E+04_JPRB,0.11620E+04_JPRB /)  
KA(:, 4,12,11) = (/ &
 & 0.11538E+04_JPRB,0.10126E+04_JPRB,0.87253E+03_JPRB,0.73377E+03_JPRB,0.60080E+03_JPRB, &
 & 0.74101E+03_JPRB,0.88067E+03_JPRB,0.10205E+04_JPRB,0.11602E+04_JPRB /)  
KA(:, 5,12,11) = (/ &
 & 0.11449E+04_JPRB,0.10062E+04_JPRB,0.86764E+03_JPRB,0.72842E+03_JPRB,0.59975E+03_JPRB, &
 & 0.73955E+03_JPRB,0.87926E+03_JPRB,0.10190E+04_JPRB,0.11583E+04_JPRB /)  
KA(:, 1,13,11) = (/ &
 & 0.11561E+04_JPRB,0.10152E+04_JPRB,0.87509E+03_JPRB,0.73383E+03_JPRB,0.60253E+03_JPRB, &
 & 0.74321E+03_JPRB,0.88362E+03_JPRB,0.10246E+04_JPRB,0.11664E+04_JPRB /)  
KA(:, 2,13,11) = (/ &
 & 0.11468E+04_JPRB,0.10069E+04_JPRB,0.86783E+03_JPRB,0.72921E+03_JPRB,0.60211E+03_JPRB, &
 & 0.74294E+03_JPRB,0.88286E+03_JPRB,0.10230E+04_JPRB,0.11639E+04_JPRB /)  
KA(:, 3,13,11) = (/ &
 & 0.11390E+04_JPRB,0.10001E+04_JPRB,0.86301E+03_JPRB,0.72323E+03_JPRB,0.60140E+03_JPRB, &
 & 0.74194E+03_JPRB,0.88181E+03_JPRB,0.10218E+04_JPRB,0.11621E+04_JPRB /)  
KA(:, 4,13,11) = (/ &
 & 0.11313E+04_JPRB,0.99361E+03_JPRB,0.85706E+03_JPRB,0.72032E+03_JPRB,0.60042E+03_JPRB, &
 & 0.74065E+03_JPRB,0.88048E+03_JPRB,0.10204E+04_JPRB,0.11602E+04_JPRB /)  
KA(:, 5,13,11) = (/ &
 & 0.11266E+04_JPRB,0.99042E+03_JPRB,0.85257E+03_JPRB,0.71548E+03_JPRB,0.59931E+03_JPRB, &
 & 0.73930E+03_JPRB,0.87908E+03_JPRB,0.10187E+04_JPRB,0.11583E+04_JPRB /)  
KA(:, 1, 1,12) = (/ &
 & 0.19596E+04_JPRB,0.17200E+04_JPRB,0.14802E+04_JPRB,0.12370E+04_JPRB,0.99641E+03_JPRB, &
 & 0.75556E+03_JPRB,0.88658E+03_JPRB,0.10236E+04_JPRB,0.11622E+04_JPRB /)  
KA(:, 2, 1,12) = (/ &
 & 0.19107E+04_JPRB,0.16797E+04_JPRB,0.14463E+04_JPRB,0.12083E+04_JPRB,0.97440E+03_JPRB, &
 & 0.74935E+03_JPRB,0.88455E+03_JPRB,0.10223E+04_JPRB,0.11611E+04_JPRB /)  
KA(:, 3, 1,12) = (/ &
 & 0.18687E+04_JPRB,0.16368E+04_JPRB,0.14091E+04_JPRB,0.11809E+04_JPRB,0.95100E+03_JPRB, &
 & 0.74626E+03_JPRB,0.88278E+03_JPRB,0.10214E+04_JPRB,0.11600E+04_JPRB /)  
KA(:, 4, 1,12) = (/ &
 & 0.18274E+04_JPRB,0.15998E+04_JPRB,0.13805E+04_JPRB,0.11544E+04_JPRB,0.92955E+03_JPRB, &
 & 0.74432E+03_JPRB,0.88029E+03_JPRB,0.10193E+04_JPRB,0.11572E+04_JPRB /)  
KA(:, 5, 1,12) = (/ &
 & 0.17908E+04_JPRB,0.15685E+04_JPRB,0.13492E+04_JPRB,0.11303E+04_JPRB,0.91228E+03_JPRB, &
 & 0.74183E+03_JPRB,0.87814E+03_JPRB,0.10165E+04_JPRB,0.11551E+04_JPRB /)  
KA(:, 1, 2,12) = (/ &
 & 0.18091E+04_JPRB,0.15890E+04_JPRB,0.13701E+04_JPRB,0.11447E+04_JPRB,0.92240E+03_JPRB, &
 & 0.75031E+03_JPRB,0.88580E+03_JPRB,0.10236E+04_JPRB,0.11628E+04_JPRB /)  
KA(:, 2, 2,12) = (/ &
 & 0.17702E+04_JPRB,0.15507E+04_JPRB,0.13346E+04_JPRB,0.11179E+04_JPRB,0.90072E+03_JPRB, &
 & 0.74790E+03_JPRB,0.88384E+03_JPRB,0.10222E+04_JPRB,0.11616E+04_JPRB /)  
KA(:, 3, 2,12) = (/ &
 & 0.17282E+04_JPRB,0.15159E+04_JPRB,0.13066E+04_JPRB,0.10967E+04_JPRB,0.88274E+03_JPRB, &
 & 0.74530E+03_JPRB,0.88241E+03_JPRB,0.10213E+04_JPRB,0.11606E+04_JPRB /)  
KA(:, 4, 2,12) = (/ &
 & 0.16964E+04_JPRB,0.14887E+04_JPRB,0.12816E+04_JPRB,0.10711E+04_JPRB,0.86387E+03_JPRB, &
 & 0.74308E+03_JPRB,0.88064E+03_JPRB,0.10199E+04_JPRB,0.11593E+04_JPRB /)  
KA(:, 5, 2,12) = (/ &
 & 0.16664E+04_JPRB,0.14634E+04_JPRB,0.12570E+04_JPRB,0.10541E+04_JPRB,0.84878E+03_JPRB, &
 & 0.74105E+03_JPRB,0.87802E+03_JPRB,0.10170E+04_JPRB,0.11559E+04_JPRB /)  
KA(:, 1, 3,12) = (/ &
 & 0.16969E+04_JPRB,0.14893E+04_JPRB,0.12806E+04_JPRB,0.10686E+04_JPRB,0.86200E+03_JPRB, &
 & 0.74953E+03_JPRB,0.88586E+03_JPRB,0.10239E+04_JPRB,0.11637E+04_JPRB /)  
KA(:, 2, 3,12) = (/ &
 & 0.16530E+04_JPRB,0.14535E+04_JPRB,0.12505E+04_JPRB,0.10502E+04_JPRB,0.84485E+03_JPRB, &
 & 0.74734E+03_JPRB,0.88380E+03_JPRB,0.10224E+04_JPRB,0.11623E+04_JPRB /)  
KA(:, 3, 3,12) = (/ &
 & 0.16258E+04_JPRB,0.14316E+04_JPRB,0.12308E+04_JPRB,0.10274E+04_JPRB,0.82737E+03_JPRB, &
 & 0.74498E+03_JPRB,0.88220E+03_JPRB,0.10214E+04_JPRB,0.11612E+04_JPRB /)  
KA(:, 4, 3,12) = (/ &
 & 0.15947E+04_JPRB,0.13987E+04_JPRB,0.12036E+04_JPRB,0.10100E+04_JPRB,0.81398E+03_JPRB, &
 & 0.74250E+03_JPRB,0.88073E+03_JPRB,0.10203E+04_JPRB,0.11601E+04_JPRB /)  
KA(:, 5, 3,12) = (/ &
 & 0.15659E+04_JPRB,0.13745E+04_JPRB,0.11827E+04_JPRB,0.99357E+03_JPRB,0.79945E+03_JPRB, &
 & 0.74072E+03_JPRB,0.87844E+03_JPRB,0.10192E+04_JPRB,0.11574E+04_JPRB /)  
KA(:, 1, 4,12) = (/ &
 & 0.15993E+04_JPRB,0.14029E+04_JPRB,0.12034E+04_JPRB,0.10105E+04_JPRB,0.81494E+03_JPRB, &
 & 0.74898E+03_JPRB,0.88604E+03_JPRB,0.10246E+04_JPRB,0.11648E+04_JPRB /)  
KA(:, 2, 4,12) = (/ &
 & 0.15603E+04_JPRB,0.13717E+04_JPRB,0.11803E+04_JPRB,0.99158E+03_JPRB,0.79797E+03_JPRB, &
 & 0.74702E+03_JPRB,0.88413E+03_JPRB,0.10230E+04_JPRB,0.11631E+04_JPRB /)  
KA(:, 3, 4,12) = (/ &
 & 0.15363E+04_JPRB,0.13460E+04_JPRB,0.11581E+04_JPRB,0.97158E+03_JPRB,0.78286E+03_JPRB, &
 & 0.74488E+03_JPRB,0.88249E+03_JPRB,0.10215E+04_JPRB,0.11618E+04_JPRB /)  
KA(:, 4, 4,12) = (/ &
 & 0.15069E+04_JPRB,0.13248E+04_JPRB,0.11397E+04_JPRB,0.95515E+03_JPRB,0.77185E+03_JPRB, &
 & 0.74259E+03_JPRB,0.88086E+03_JPRB,0.10207E+04_JPRB,0.11608E+04_JPRB /)  
KA(:, 5, 4,12) = (/ &
 & 0.14842E+04_JPRB,0.13030E+04_JPRB,0.11201E+04_JPRB,0.94205E+03_JPRB,0.75928E+03_JPRB, &
 & 0.74072E+03_JPRB,0.87912E+03_JPRB,0.10193E+04_JPRB,0.11593E+04_JPRB /)  
KA(:, 1, 5,12) = (/ &
 & 0.15161E+04_JPRB,0.13293E+04_JPRB,0.11434E+04_JPRB,0.96071E+03_JPRB,0.77366E+03_JPRB, &
 & 0.74856E+03_JPRB,0.88634E+03_JPRB,0.10256E+04_JPRB,0.11660E+04_JPRB /)  
KA(:, 2, 5,12) = (/ &
 & 0.14862E+04_JPRB,0.13039E+04_JPRB,0.11202E+04_JPRB,0.93927E+03_JPRB,0.75808E+03_JPRB, &
 & 0.74678E+03_JPRB,0.88432E+03_JPRB,0.10237E+04_JPRB,0.11641E+04_JPRB /)  
KA(:, 3, 5,12) = (/ &
 & 0.14569E+04_JPRB,0.12812E+04_JPRB,0.11040E+04_JPRB,0.92477E+03_JPRB,0.74608E+03_JPRB, &
 & 0.74483E+03_JPRB,0.88267E+03_JPRB,0.10221E+04_JPRB,0.11626E+04_JPRB /)  
KA(:, 4, 5,12) = (/ &
 & 0.14370E+04_JPRB,0.12601E+04_JPRB,0.10866E+04_JPRB,0.91322E+03_JPRB,0.73546E+03_JPRB, &
 & 0.74282E+03_JPRB,0.88106E+03_JPRB,0.10210E+04_JPRB,0.11614E+04_JPRB /)  
KA(:, 5, 5,12) = (/ &
 & 0.14157E+04_JPRB,0.12432E+04_JPRB,0.10692E+04_JPRB,0.89766E+03_JPRB,0.72371E+03_JPRB, &
 & 0.74075E+03_JPRB,0.87977E+03_JPRB,0.10201E+04_JPRB,0.11604E+04_JPRB /)  
KA(:, 1, 6,12) = (/ &
 & 0.14446E+04_JPRB,0.12668E+04_JPRB,0.10902E+04_JPRB,0.91458E+03_JPRB,0.73853E+03_JPRB, &
 & 0.74800E+03_JPRB,0.88683E+03_JPRB,0.10267E+04_JPRB,0.11674E+04_JPRB /)  
KA(:, 2, 6,12) = (/ &
 & 0.14180E+04_JPRB,0.12442E+04_JPRB,0.10729E+04_JPRB,0.90054E+03_JPRB,0.72712E+03_JPRB, &
 & 0.74664E+03_JPRB,0.88490E+03_JPRB,0.10243E+04_JPRB,0.11653E+04_JPRB /)  
KA(:, 3, 6,12) = (/ &
 & 0.13970E+04_JPRB,0.12338E+04_JPRB,0.10562E+04_JPRB,0.88644E+03_JPRB,0.71466E+03_JPRB, &
 & 0.74490E+03_JPRB,0.88299E+03_JPRB,0.10228E+04_JPRB,0.11635E+04_JPRB /)  
KA(:, 4, 6,12) = (/ &
 & 0.13772E+04_JPRB,0.12092E+04_JPRB,0.10403E+04_JPRB,0.87191E+03_JPRB,0.70566E+03_JPRB, &
 & 0.74297E+03_JPRB,0.88145E+03_JPRB,0.10214E+04_JPRB,0.11622E+04_JPRB /)  
KA(:, 5, 6,12) = (/ &
 & 0.13536E+04_JPRB,0.11933E+04_JPRB,0.10279E+04_JPRB,0.85985E+03_JPRB,0.69532E+03_JPRB, &
 & 0.74091E+03_JPRB,0.88002E+03_JPRB,0.10207E+04_JPRB,0.11611E+04_JPRB /)  
KA(:, 1, 7,12) = (/ &
 & 0.13872E+04_JPRB,0.12173E+04_JPRB,0.10473E+04_JPRB,0.87779E+03_JPRB,0.70929E+03_JPRB, &
 & 0.74753E+03_JPRB,0.88739E+03_JPRB,0.10279E+04_JPRB,0.11686E+04_JPRB /)  
KA(:, 2, 7,12) = (/ &
 & 0.13614E+04_JPRB,0.11960E+04_JPRB,0.10302E+04_JPRB,0.86342E+03_JPRB,0.69779E+03_JPRB, &
 & 0.74649E+03_JPRB,0.88535E+03_JPRB,0.10254E+04_JPRB,0.11666E+04_JPRB /)  
KA(:, 3, 7,12) = (/ &
 & 0.13423E+04_JPRB,0.11779E+04_JPRB,0.10152E+04_JPRB,0.85120E+03_JPRB,0.68669E+03_JPRB, &
 & 0.74500E+03_JPRB,0.88364E+03_JPRB,0.10236E+04_JPRB,0.11646E+04_JPRB /)  
KA(:, 4, 7,12) = (/ &
 & 0.13222E+04_JPRB,0.11614E+04_JPRB,0.10027E+04_JPRB,0.84138E+03_JPRB,0.67980E+03_JPRB, &
 & 0.74324E+03_JPRB,0.88194E+03_JPRB,0.10219E+04_JPRB,0.11628E+04_JPRB /)  
KA(:, 5, 7,12) = (/ &
 & 0.13077E+04_JPRB,0.11487E+04_JPRB,0.98870E+03_JPRB,0.82923E+03_JPRB,0.67117E+03_JPRB, &
 & 0.74131E+03_JPRB,0.88052E+03_JPRB,0.10200E+04_JPRB,0.11617E+04_JPRB /)  
KA(:, 1, 8,12) = (/ &
 & 0.13318E+04_JPRB,0.11751E+04_JPRB,0.10116E+04_JPRB,0.84760E+03_JPRB,0.68552E+03_JPRB, &
 & 0.74755E+03_JPRB,0.88764E+03_JPRB,0.10284E+04_JPRB,0.11697E+04_JPRB /)  
KA(:, 2, 8,12) = (/ &
 & 0.13123E+04_JPRB,0.11533E+04_JPRB,0.99316E+03_JPRB,0.83364E+03_JPRB,0.67452E+03_JPRB, &
 & 0.74634E+03_JPRB,0.88623E+03_JPRB,0.10267E+04_JPRB,0.11679E+04_JPRB /)  
KA(:, 3, 8,12) = (/ &
 & 0.12963E+04_JPRB,0.11395E+04_JPRB,0.98036E+03_JPRB,0.82206E+03_JPRB,0.66378E+03_JPRB, &
 & 0.74528E+03_JPRB,0.88422E+03_JPRB,0.10245E+04_JPRB,0.11657E+04_JPRB /)  
KA(:, 4, 8,12) = (/ &
 & 0.12799E+04_JPRB,0.11235E+04_JPRB,0.96838E+03_JPRB,0.81175E+03_JPRB,0.65688E+03_JPRB, &
 & 0.74350E+03_JPRB,0.88249E+03_JPRB,0.10227E+04_JPRB,0.11639E+04_JPRB /)  
KA(:, 5, 8,12) = (/ &
 & 0.12649E+04_JPRB,0.11128E+04_JPRB,0.95762E+03_JPRB,0.80323E+03_JPRB,0.64917E+03_JPRB, &
 & 0.74172E+03_JPRB,0.88089E+03_JPRB,0.10213E+04_JPRB,0.11624E+04_JPRB /)  
KA(:, 1, 9,12) = (/ &
 & 0.12892E+04_JPRB,0.11353E+04_JPRB,0.97529E+03_JPRB,0.81997E+03_JPRB,0.66439E+03_JPRB, &
 & 0.74689E+03_JPRB,0.88774E+03_JPRB,0.10288E+04_JPRB,0.11703E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART8',1,ZHOOK_HANDLE)
END SUBROUTINE PART8


SUBROUTINE PART9

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART9',0,ZHOOK_HANDLE)


KA(:, 2, 9,12) = (/ &
 & 0.12710E+04_JPRB,0.11179E+04_JPRB,0.96230E+03_JPRB,0.80757E+03_JPRB,0.65174E+03_JPRB, &
 & 0.74606E+03_JPRB,0.88671E+03_JPRB,0.10277E+04_JPRB,0.11691E+04_JPRB /)  
KA(:, 3, 9,12) = (/ &
 & 0.12556E+04_JPRB,0.11026E+04_JPRB,0.95506E+03_JPRB,0.79904E+03_JPRB,0.64512E+03_JPRB, &
 & 0.74525E+03_JPRB,0.88489E+03_JPRB,0.10254E+04_JPRB,0.11669E+04_JPRB /)  
KA(:, 4, 9,12) = (/ &
 & 0.12434E+04_JPRB,0.10930E+04_JPRB,0.94625E+03_JPRB,0.79326E+03_JPRB,0.63956E+03_JPRB, &
 & 0.74375E+03_JPRB,0.88308E+03_JPRB,0.10236E+04_JPRB,0.11649E+04_JPRB /)  
KA(:, 5, 9,12) = (/ &
 & 0.12362E+04_JPRB,0.10807E+04_JPRB,0.93519E+03_JPRB,0.78318E+03_JPRB,0.63176E+03_JPRB, &
 & 0.74222E+03_JPRB,0.88144E+03_JPRB,0.10218E+04_JPRB,0.11632E+04_JPRB /)  
KA(:, 1,10,12) = (/ &
 & 0.12560E+04_JPRB,0.11008E+04_JPRB,0.94819E+03_JPRB,0.79713E+03_JPRB,0.64289E+03_JPRB, &
 & 0.74662E+03_JPRB,0.88790E+03_JPRB,0.10293E+04_JPRB,0.11710E+04_JPRB /)  
KA(:, 2,10,12) = (/ &
 & 0.12370E+04_JPRB,0.10868E+04_JPRB,0.93614E+03_JPRB,0.78750E+03_JPRB,0.63591E+03_JPRB, &
 & 0.74589E+03_JPRB,0.88689E+03_JPRB,0.10281E+04_JPRB,0.11697E+04_JPRB /)  
KA(:, 3,10,12) = (/ &
 & 0.12228E+04_JPRB,0.10745E+04_JPRB,0.92565E+03_JPRB,0.77586E+03_JPRB,0.63013E+03_JPRB, &
 & 0.74525E+03_JPRB,0.88546E+03_JPRB,0.10265E+04_JPRB,0.11680E+04_JPRB /)  
KA(:, 4,10,12) = (/ &
 & 0.12130E+04_JPRB,0.10629E+04_JPRB,0.91805E+03_JPRB,0.77218E+03_JPRB,0.62214E+03_JPRB, &
 & 0.74398E+03_JPRB,0.88360E+03_JPRB,0.10243E+04_JPRB,0.11659E+04_JPRB /)  
KA(:, 5,10,12) = (/ &
 & 0.11990E+04_JPRB,0.10561E+04_JPRB,0.90990E+03_JPRB,0.76234E+03_JPRB,0.61782E+03_JPRB, &
 & 0.74238E+03_JPRB,0.88192E+03_JPRB,0.10225E+04_JPRB,0.11640E+04_JPRB /)  
KA(:, 1,11,12) = (/ &
 & 0.12160E+04_JPRB,0.10660E+04_JPRB,0.91756E+03_JPRB,0.77092E+03_JPRB,0.62410E+03_JPRB, &
 & 0.74614E+03_JPRB,0.88758E+03_JPRB,0.10288E+04_JPRB,0.11712E+04_JPRB /)  
KA(:, 2,11,12) = (/ &
 & 0.12001E+04_JPRB,0.10573E+04_JPRB,0.90897E+03_JPRB,0.76187E+03_JPRB,0.61778E+03_JPRB, &
 & 0.74563E+03_JPRB,0.88659E+03_JPRB,0.10280E+04_JPRB,0.11697E+04_JPRB /)  
KA(:, 3,11,12) = (/ &
 & 0.11883E+04_JPRB,0.10436E+04_JPRB,0.89901E+03_JPRB,0.75711E+03_JPRB,0.61087E+03_JPRB, &
 & 0.74468E+03_JPRB,0.88519E+03_JPRB,0.10264E+04_JPRB,0.11680E+04_JPRB /)  
KA(:, 4,11,12) = (/ &
 & 0.11791E+04_JPRB,0.10338E+04_JPRB,0.89462E+03_JPRB,0.74974E+03_JPRB,0.60740E+03_JPRB, &
 & 0.74372E+03_JPRB,0.88322E+03_JPRB,0.10242E+04_JPRB,0.11659E+04_JPRB /)  
KA(:, 5,11,12) = (/ &
 & 0.11736E+04_JPRB,0.10284E+04_JPRB,0.88610E+03_JPRB,0.74386E+03_JPRB,0.60256E+03_JPRB, &
 & 0.74204E+03_JPRB,0.88156E+03_JPRB,0.10223E+04_JPRB,0.11640E+04_JPRB /)  
KA(:, 1,12,12) = (/ &
 & 0.11783E+04_JPRB,0.10408E+04_JPRB,0.89462E+03_JPRB,0.75034E+03_JPRB,0.60838E+03_JPRB, &
 & 0.74575E+03_JPRB,0.88732E+03_JPRB,0.10288E+04_JPRB,0.11710E+04_JPRB /)  
KA(:, 2,12,12) = (/ &
 & 0.11693E+04_JPRB,0.10333E+04_JPRB,0.88486E+03_JPRB,0.74467E+03_JPRB,0.60420E+03_JPRB, &
 & 0.74514E+03_JPRB,0.88635E+03_JPRB,0.10279E+04_JPRB,0.11697E+04_JPRB /)  
KA(:, 3,12,12) = (/ &
 & 0.11597E+04_JPRB,0.10197E+04_JPRB,0.87845E+03_JPRB,0.73901E+03_JPRB,0.60371E+03_JPRB, &
 & 0.74440E+03_JPRB,0.88495E+03_JPRB,0.10263E+04_JPRB,0.11680E+04_JPRB /)  
KA(:, 4,12,12) = (/ &
 & 0.11554E+04_JPRB,0.10154E+04_JPRB,0.87390E+03_JPRB,0.73209E+03_JPRB,0.60310E+03_JPRB, &
 & 0.74343E+03_JPRB,0.88312E+03_JPRB,0.10241E+04_JPRB,0.11659E+04_JPRB /)  
KA(:, 5,12,12) = (/ &
 & 0.11463E+04_JPRB,0.10081E+04_JPRB,0.86768E+03_JPRB,0.73113E+03_JPRB,0.60226E+03_JPRB, &
 & 0.74178E+03_JPRB,0.88148E+03_JPRB,0.10222E+04_JPRB,0.11640E+04_JPRB /)  
KA(:, 1,13,12) = (/ &
 & 0.11576E+04_JPRB,0.10172E+04_JPRB,0.87697E+03_JPRB,0.73496E+03_JPRB,0.60442E+03_JPRB, &
 & 0.74542E+03_JPRB,0.88710E+03_JPRB,0.10287E+04_JPRB,0.11710E+04_JPRB /)  
KA(:, 2,13,12) = (/ &
 & 0.11489E+04_JPRB,0.10121E+04_JPRB,0.86787E+03_JPRB,0.73038E+03_JPRB,0.60369E+03_JPRB, &
 & 0.74483E+03_JPRB,0.88615E+03_JPRB,0.10278E+04_JPRB,0.11697E+04_JPRB /)  
KA(:, 3,13,12) = (/ &
 & 0.11408E+04_JPRB,0.10003E+04_JPRB,0.86069E+03_JPRB,0.72468E+03_JPRB,0.60332E+03_JPRB, &
 & 0.74398E+03_JPRB,0.88477E+03_JPRB,0.10262E+04_JPRB,0.11679E+04_JPRB /)  
KA(:, 4,13,12) = (/ &
 & 0.11353E+04_JPRB,0.99812E+03_JPRB,0.85805E+03_JPRB,0.72010E+03_JPRB,0.60276E+03_JPRB, &
 & 0.74301E+03_JPRB,0.88294E+03_JPRB,0.10240E+04_JPRB,0.11659E+04_JPRB /)  
KA(:, 5,13,12) = (/ &
 & 0.11276E+04_JPRB,0.99093E+03_JPRB,0.85424E+03_JPRB,0.71851E+03_JPRB,0.60186E+03_JPRB, &
 & 0.74137E+03_JPRB,0.88131E+03_JPRB,0.10223E+04_JPRB,0.11640E+04_JPRB /)  
KA(:, 1, 1,13) = (/ &
 & 0.19698E+04_JPRB,0.17183E+04_JPRB,0.14812E+04_JPRB,0.12476E+04_JPRB,0.10057E+04_JPRB, &
 & 0.76142E+03_JPRB,0.89076E+03_JPRB,0.10305E+04_JPRB,0.11701E+04_JPRB /)  
KA(:, 2, 1,13) = (/ &
 & 0.19138E+04_JPRB,0.16790E+04_JPRB,0.14471E+04_JPRB,0.12079E+04_JPRB,0.97024E+03_JPRB, &
 & 0.74958E+03_JPRB,0.88854E+03_JPRB,0.10281E+04_JPRB,0.11676E+04_JPRB /)  
KA(:, 3, 1,13) = (/ &
 & 0.18656E+04_JPRB,0.16362E+04_JPRB,0.14072E+04_JPRB,0.11764E+04_JPRB,0.95368E+03_JPRB, &
 & 0.74756E+03_JPRB,0.88578E+03_JPRB,0.10247E+04_JPRB,0.11642E+04_JPRB /)  
KA(:, 4, 1,13) = (/ &
 & 0.18274E+04_JPRB,0.16076E+04_JPRB,0.13744E+04_JPRB,0.11522E+04_JPRB,0.93101E+03_JPRB, &
 & 0.74489E+03_JPRB,0.88368E+03_JPRB,0.10224E+04_JPRB,0.11624E+04_JPRB /)  
KA(:, 5, 1,13) = (/ &
 & 0.18123E+04_JPRB,0.15711E+04_JPRB,0.13539E+04_JPRB,0.11391E+04_JPRB,0.91271E+03_JPRB, &
 & 0.74309E+03_JPRB,0.88194E+03_JPRB,0.10210E+04_JPRB,0.11601E+04_JPRB /)  
KA(:, 1, 2,13) = (/ &
 & 0.18136E+04_JPRB,0.16074E+04_JPRB,0.13682E+04_JPRB,0.11455E+04_JPRB,0.92152E+03_JPRB, &
 & 0.75090E+03_JPRB,0.89044E+03_JPRB,0.10309E+04_JPRB,0.11711E+04_JPRB /)  
KA(:, 2, 2,13) = (/ &
 & 0.17663E+04_JPRB,0.15639E+04_JPRB,0.13412E+04_JPRB,0.11338E+04_JPRB,0.90565E+03_JPRB, &
 & 0.74892E+03_JPRB,0.88842E+03_JPRB,0.10286E+04_JPRB,0.11690E+04_JPRB /)  
KA(:, 3, 2,13) = (/ &
 & 0.17473E+04_JPRB,0.15168E+04_JPRB,0.13179E+04_JPRB,0.10933E+04_JPRB,0.88564E+03_JPRB, &
 & 0.74657E+03_JPRB,0.88587E+03_JPRB,0.10277E+04_JPRB,0.11659E+04_JPRB /)  
KA(:, 4, 2,13) = (/ &
 & 0.16935E+04_JPRB,0.14940E+04_JPRB,0.12866E+04_JPRB,0.10771E+04_JPRB,0.86513E+03_JPRB, &
 & 0.74388E+03_JPRB,0.88292E+03_JPRB,0.10226E+04_JPRB,0.11621E+04_JPRB /)  
KA(:, 5, 2,13) = (/ &
 & 0.16796E+04_JPRB,0.14587E+04_JPRB,0.12610E+04_JPRB,0.10625E+04_JPRB,0.85051E+03_JPRB, &
 & 0.74222E+03_JPRB,0.88187E+03_JPRB,0.10215E+04_JPRB,0.11614E+04_JPRB /)  
KA(:, 1, 3,13) = (/ &
 & 0.16915E+04_JPRB,0.14853E+04_JPRB,0.12759E+04_JPRB,0.10742E+04_JPRB,0.87078E+03_JPRB, &
 & 0.75040E+03_JPRB,0.89056E+03_JPRB,0.10314E+04_JPRB,0.11723E+04_JPRB /)  
KA(:, 2, 3,13) = (/ &
 & 0.16685E+04_JPRB,0.14695E+04_JPRB,0.12569E+04_JPRB,0.10522E+04_JPRB,0.84369E+03_JPRB, &
 & 0.74849E+03_JPRB,0.88875E+03_JPRB,0.10295E+04_JPRB,0.11702E+04_JPRB /)  
KA(:, 3, 3,13) = (/ &
 & 0.16315E+04_JPRB,0.14234E+04_JPRB,0.12207E+04_JPRB,0.10278E+04_JPRB,0.83542E+03_JPRB, &
 & 0.74665E+03_JPRB,0.88665E+03_JPRB,0.10272E+04_JPRB,0.11677E+04_JPRB /)  
KA(:, 4, 3,13) = (/ &
 & 0.15936E+04_JPRB,0.13973E+04_JPRB,0.11983E+04_JPRB,0.10068E+04_JPRB,0.81253E+03_JPRB, &
 & 0.74392E+03_JPRB,0.88383E+03_JPRB,0.10241E+04_JPRB,0.11643E+04_JPRB /)  
KA(:, 5, 3,13) = (/ &
 & 0.15704E+04_JPRB,0.13749E+04_JPRB,0.11794E+04_JPRB,0.99081E+03_JPRB,0.79887E+03_JPRB, &
 & 0.74214E+03_JPRB,0.88216E+03_JPRB,0.10204E+04_JPRB,0.11625E+04_JPRB /)  
KA(:, 1, 4,13) = (/ &
 & 0.16005E+04_JPRB,0.14146E+04_JPRB,0.12141E+04_JPRB,0.10096E+04_JPRB,0.81830E+03_JPRB, &
 & 0.74981E+03_JPRB,0.89073E+03_JPRB,0.10323E+04_JPRB,0.11736E+04_JPRB /)  
KA(:, 2, 4,13) = (/ &
 & 0.15697E+04_JPRB,0.13709E+04_JPRB,0.11792E+04_JPRB,0.98706E+03_JPRB,0.80274E+03_JPRB, &
 & 0.74843E+03_JPRB,0.88917E+03_JPRB,0.10304E+04_JPRB,0.11716E+04_JPRB /)  
KA(:, 3, 4,13) = (/ &
 & 0.15342E+04_JPRB,0.13528E+04_JPRB,0.11633E+04_JPRB,0.97494E+03_JPRB,0.78298E+03_JPRB, &
 & 0.74655E+03_JPRB,0.88714E+03_JPRB,0.10283E+04_JPRB,0.11694E+04_JPRB /)  
KA(:, 4, 4,13) = (/ &
 & 0.15079E+04_JPRB,0.13273E+04_JPRB,0.11368E+04_JPRB,0.95326E+03_JPRB,0.76898E+03_JPRB, &
 & 0.74477E+03_JPRB,0.88522E+03_JPRB,0.10258E+04_JPRB,0.11666E+04_JPRB /)  
KA(:, 5, 4,13) = (/ &
 & 0.14904E+04_JPRB,0.13050E+04_JPRB,0.11274E+04_JPRB,0.94133E+03_JPRB,0.75918E+03_JPRB, &
 & 0.74185E+03_JPRB,0.88236E+03_JPRB,0.10229E+04_JPRB,0.11634E+04_JPRB /)  
KA(:, 1, 5,13) = (/ &
 & 0.15223E+04_JPRB,0.13292E+04_JPRB,0.11458E+04_JPRB,0.96632E+03_JPRB,0.77253E+03_JPRB, &
 & 0.74931E+03_JPRB,0.89080E+03_JPRB,0.10327E+04_JPRB,0.11744E+04_JPRB /)  
KA(:, 2, 5,13) = (/ &
 & 0.14887E+04_JPRB,0.13100E+04_JPRB,0.11308E+04_JPRB,0.95564E+03_JPRB,0.76318E+03_JPRB, &
 & 0.74814E+03_JPRB,0.88953E+03_JPRB,0.10311E+04_JPRB,0.11728E+04_JPRB /)  
KA(:, 3, 5,13) = (/ &
 & 0.14666E+04_JPRB,0.12805E+04_JPRB,0.10990E+04_JPRB,0.92585E+03_JPRB,0.74527E+03_JPRB, &
 & 0.74662E+03_JPRB,0.88788E+03_JPRB,0.10293E+04_JPRB,0.11708E+04_JPRB /)  
KA(:, 4, 5,13) = (/ &
 & 0.14380E+04_JPRB,0.12615E+04_JPRB,0.10805E+04_JPRB,0.91192E+03_JPRB,0.73306E+03_JPRB, &
 & 0.74471E+03_JPRB,0.88594E+03_JPRB,0.10272E+04_JPRB,0.11684E+04_JPRB /)  
KA(:, 5, 5,13) = (/ &
 & 0.14117E+04_JPRB,0.12389E+04_JPRB,0.10707E+04_JPRB,0.89863E+03_JPRB,0.72872E+03_JPRB, &
 & 0.74254E+03_JPRB,0.88356E+03_JPRB,0.10243E+04_JPRB,0.11652E+04_JPRB /)  
KA(:, 1, 6,13) = (/ &
 & 0.14428E+04_JPRB,0.12661E+04_JPRB,0.10990E+04_JPRB,0.91605E+03_JPRB,0.74645E+03_JPRB, &
 & 0.74914E+03_JPRB,0.89068E+03_JPRB,0.10327E+04_JPRB,0.11747E+04_JPRB /)  
KA(:, 2, 6,13) = (/ &
 & 0.14277E+04_JPRB,0.12454E+04_JPRB,0.10670E+04_JPRB,0.90364E+03_JPRB,0.72758E+03_JPRB, &
 & 0.74802E+03_JPRB,0.88983E+03_JPRB,0.10318E+04_JPRB,0.11738E+04_JPRB /)  
KA(:, 3, 6,13) = (/ &
 & 0.14072E+04_JPRB,0.12244E+04_JPRB,0.10539E+04_JPRB,0.88576E+03_JPRB,0.71342E+03_JPRB, &
 & 0.74674E+03_JPRB,0.88844E+03_JPRB,0.10303E+04_JPRB,0.11723E+04_JPRB /)  
KA(:, 4, 6,13) = (/ &
 & 0.13764E+04_JPRB,0.12101E+04_JPRB,0.10371E+04_JPRB,0.87173E+03_JPRB,0.70565E+03_JPRB, &
 & 0.74519E+03_JPRB,0.88672E+03_JPRB,0.10284E+04_JPRB,0.11700E+04_JPRB /)  
KA(:, 5, 6,13) = (/ &
 & 0.13559E+04_JPRB,0.11928E+04_JPRB,0.10275E+04_JPRB,0.87202E+03_JPRB,0.69916E+03_JPRB, &
 & 0.74337E+03_JPRB,0.88468E+03_JPRB,0.10257E+04_JPRB,0.11677E+04_JPRB /)  
KA(:, 1, 7,13) = (/ &
 & 0.13816E+04_JPRB,0.12181E+04_JPRB,0.10498E+04_JPRB,0.87727E+03_JPRB,0.70862E+03_JPRB, &
 & 0.74879E+03_JPRB,0.89032E+03_JPRB,0.10324E+04_JPRB,0.11748E+04_JPRB /)  
KA(:, 2, 7,13) = (/ &
 & 0.13746E+04_JPRB,0.12007E+04_JPRB,0.10368E+04_JPRB,0.86700E+03_JPRB,0.69742E+03_JPRB, &
 & 0.74791E+03_JPRB,0.88998E+03_JPRB,0.10322E+04_JPRB,0.11745E+04_JPRB /)  
KA(:, 3, 7,13) = (/ &
 & 0.13471E+04_JPRB,0.11822E+04_JPRB,0.10118E+04_JPRB,0.85187E+03_JPRB,0.69076E+03_JPRB, &
 & 0.74684E+03_JPRB,0.88891E+03_JPRB,0.10311E+04_JPRB,0.11732E+04_JPRB /)  
KA(:, 4, 7,13) = (/ &
 & 0.13306E+04_JPRB,0.11625E+04_JPRB,0.10055E+04_JPRB,0.83687E+03_JPRB,0.67946E+03_JPRB, &
 & 0.74564E+03_JPRB,0.88741E+03_JPRB,0.10294E+04_JPRB,0.11714E+04_JPRB /)  
KA(:, 5, 7,13) = (/ &
 & 0.13072E+04_JPRB,0.11462E+04_JPRB,0.98997E+03_JPRB,0.82975E+03_JPRB,0.67148E+03_JPRB, &
 & 0.74390E+03_JPRB,0.88544E+03_JPRB,0.10275E+04_JPRB,0.11691E+04_JPRB /)  
KA(:, 1, 8,13) = (/ &
 & 0.13342E+04_JPRB,0.11738E+04_JPRB,0.10072E+04_JPRB,0.84777E+03_JPRB,0.68336E+03_JPRB, &
 & 0.74810E+03_JPRB,0.89032E+03_JPRB,0.10328E+04_JPRB,0.11753E+04_JPRB /)  
KA(:, 2, 8,13) = (/ &
 & 0.13170E+04_JPRB,0.11565E+04_JPRB,0.99551E+03_JPRB,0.83812E+03_JPRB,0.67873E+03_JPRB, &
 & 0.74767E+03_JPRB,0.88984E+03_JPRB,0.10325E+04_JPRB,0.11747E+04_JPRB /)  
KA(:, 3, 8,13) = (/ &
 & 0.12961E+04_JPRB,0.11348E+04_JPRB,0.98531E+03_JPRB,0.82142E+03_JPRB,0.66767E+03_JPRB, &
 & 0.74660E+03_JPRB,0.88923E+03_JPRB,0.10317E+04_JPRB,0.11741E+04_JPRB /)  
KA(:, 4, 8,13) = (/ &
 & 0.12863E+04_JPRB,0.11324E+04_JPRB,0.96704E+03_JPRB,0.81553E+03_JPRB,0.65703E+03_JPRB, &
 & 0.74590E+03_JPRB,0.88815E+03_JPRB,0.10305E+04_JPRB,0.11725E+04_JPRB /)  
KA(:, 5, 8,13) = (/ &
 & 0.12689E+04_JPRB,0.11113E+04_JPRB,0.96142E+03_JPRB,0.81188E+03_JPRB,0.65150E+03_JPRB, &
 & 0.74435E+03_JPRB,0.88637E+03_JPRB,0.10284E+04_JPRB,0.11705E+04_JPRB /)  
KA(:, 1, 9,13) = (/ &
 & 0.12929E+04_JPRB,0.11420E+04_JPRB,0.97941E+03_JPRB,0.82358E+03_JPRB,0.66259E+03_JPRB, &
 & 0.74862E+03_JPRB,0.89046E+03_JPRB,0.10332E+04_JPRB,0.11761E+04_JPRB /)  
KA(:, 2, 9,13) = (/ &
 & 0.12739E+04_JPRB,0.11222E+04_JPRB,0.96918E+03_JPRB,0.81141E+03_JPRB,0.65436E+03_JPRB, &
 & 0.74747E+03_JPRB,0.88962E+03_JPRB,0.10323E+04_JPRB,0.11749E+04_JPRB /)  
KA(:, 3, 9,13) = (/ &
 & 0.12674E+04_JPRB,0.11070E+04_JPRB,0.94554E+03_JPRB,0.79811E+03_JPRB,0.64989E+03_JPRB, &
 & 0.74671E+03_JPRB,0.88937E+03_JPRB,0.10320E+04_JPRB,0.11746E+04_JPRB /)  
KA(:, 4, 9,13) = (/ &
 & 0.12536E+04_JPRB,0.10974E+04_JPRB,0.93180E+03_JPRB,0.78881E+03_JPRB,0.64048E+03_JPRB, &
 & 0.74596E+03_JPRB,0.88846E+03_JPRB,0.10310E+04_JPRB,0.11735E+04_JPRB /)  
KA(:, 5, 9,13) = (/ &
 & 0.12304E+04_JPRB,0.10931E+04_JPRB,0.92897E+03_JPRB,0.78158E+03_JPRB,0.63657E+03_JPRB, &
 & 0.74461E+03_JPRB,0.88706E+03_JPRB,0.10294E+04_JPRB,0.11717E+04_JPRB /)  
KA(:, 1,10,13) = (/ &
 & 0.12516E+04_JPRB,0.11039E+04_JPRB,0.96641E+03_JPRB,0.80204E+03_JPRB,0.64728E+03_JPRB, &
 & 0.74871E+03_JPRB,0.89043E+03_JPRB,0.10331E+04_JPRB,0.11761E+04_JPRB /)  
KA(:, 2,10,13) = (/ &
 & 0.12445E+04_JPRB,0.10951E+04_JPRB,0.94205E+03_JPRB,0.78296E+03_JPRB,0.63684E+03_JPRB, &
 & 0.74738E+03_JPRB,0.88974E+03_JPRB,0.10326E+04_JPRB,0.11754E+04_JPRB /)  
KA(:, 3,10,13) = (/ &
 & 0.12212E+04_JPRB,0.10830E+04_JPRB,0.92907E+03_JPRB,0.78344E+03_JPRB,0.62583E+03_JPRB, &
 & 0.74649E+03_JPRB,0.88924E+03_JPRB,0.10320E+04_JPRB,0.11747E+04_JPRB /)  
KA(:, 4,10,13) = (/ &
 & 0.12116E+04_JPRB,0.10675E+04_JPRB,0.91424E+03_JPRB,0.76668E+03_JPRB,0.62374E+03_JPRB, &
 & 0.74589E+03_JPRB,0.88889E+03_JPRB,0.10314E+04_JPRB,0.11741E+04_JPRB /)  
KA(:, 5,10,13) = (/ &
 & 0.12052E+04_JPRB,0.10532E+04_JPRB,0.90488E+03_JPRB,0.76246E+03_JPRB,0.61399E+03_JPRB, &
 & 0.74500E+03_JPRB,0.88754E+03_JPRB,0.10301E+04_JPRB,0.11727E+04_JPRB /)  
KA(:, 1,11,13) = (/ &
 & 0.12119E+04_JPRB,0.10670E+04_JPRB,0.92549E+03_JPRB,0.77292E+03_JPRB,0.62469E+03_JPRB, &
 & 0.74822E+03_JPRB,0.89015E+03_JPRB,0.10331E+04_JPRB,0.11759E+04_JPRB /)  
KA(:, 2,11,13) = (/ &
 & 0.12040E+04_JPRB,0.10529E+04_JPRB,0.90947E+03_JPRB,0.76631E+03_JPRB,0.61756E+03_JPRB, &
 & 0.74680E+03_JPRB,0.88950E+03_JPRB,0.10325E+04_JPRB,0.11754E+04_JPRB /)  
KA(:, 3,11,13) = (/ &
 & 0.11932E+04_JPRB,0.10470E+04_JPRB,0.90374E+03_JPRB,0.75316E+03_JPRB,0.61137E+03_JPRB, &
 & 0.74625E+03_JPRB,0.88901E+03_JPRB,0.10319E+04_JPRB,0.11747E+04_JPRB /)  
KA(:, 4,11,13) = (/ &
 & 0.11901E+04_JPRB,0.10395E+04_JPRB,0.89205E+03_JPRB,0.75483E+03_JPRB,0.60707E+03_JPRB, &
 & 0.74529E+03_JPRB,0.88868E+03_JPRB,0.10313E+04_JPRB,0.11742E+04_JPRB /)  
KA(:, 5,11,13) = (/ &
 & 0.11740E+04_JPRB,0.10262E+04_JPRB,0.88782E+03_JPRB,0.74555E+03_JPRB,0.60321E+03_JPRB, &
 & 0.74456E+03_JPRB,0.88735E+03_JPRB,0.10302E+04_JPRB,0.11727E+04_JPRB /)  
KA(:, 1,12,13) = (/ &
 & 0.11952E+04_JPRB,0.10387E+04_JPRB,0.90464E+03_JPRB,0.75031E+03_JPRB,0.60579E+03_JPRB, &
 & 0.74809E+03_JPRB,0.88993E+03_JPRB,0.10330E+04_JPRB,0.11761E+04_JPRB /)  
KA(:, 2,12,13) = (/ &
 & 0.11767E+04_JPRB,0.10280E+04_JPRB,0.89305E+03_JPRB,0.74295E+03_JPRB,0.60520E+03_JPRB, &
 & 0.74658E+03_JPRB,0.88930E+03_JPRB,0.10324E+04_JPRB,0.11754E+04_JPRB /)  
KA(:, 3,12,13) = (/ &
 & 0.11638E+04_JPRB,0.10252E+04_JPRB,0.88200E+03_JPRB,0.74209E+03_JPRB,0.60448E+03_JPRB, &
 & 0.74580E+03_JPRB,0.88883E+03_JPRB,0.10318E+04_JPRB,0.11747E+04_JPRB /)  
KA(:, 4,12,13) = (/ &
 & 0.11608E+04_JPRB,0.10182E+04_JPRB,0.87717E+03_JPRB,0.73339E+03_JPRB,0.60384E+03_JPRB, &
 & 0.74474E+03_JPRB,0.88834E+03_JPRB,0.10314E+04_JPRB,0.11742E+04_JPRB /)  
KA(:, 5,12,13) = (/ &
 & 0.11455E+04_JPRB,0.10085E+04_JPRB,0.86868E+03_JPRB,0.72782E+03_JPRB,0.60261E+03_JPRB, &
 & 0.74417E+03_JPRB,0.88752E+03_JPRB,0.10299E+04_JPRB,0.11727E+04_JPRB /)  
KA(:, 1,13,13) = (/ &
 & 0.11538E+04_JPRB,0.10104E+04_JPRB,0.87836E+03_JPRB,0.74181E+03_JPRB,0.60545E+03_JPRB, &
 & 0.74747E+03_JPRB,0.88975E+03_JPRB,0.10329E+04_JPRB,0.11763E+04_JPRB /)  
KA(:, 2,13,13) = (/ &
 & 0.11412E+04_JPRB,0.10013E+04_JPRB,0.88484E+03_JPRB,0.73153E+03_JPRB,0.60489E+03_JPRB, &
 & 0.74629E+03_JPRB,0.88914E+03_JPRB,0.10323E+04_JPRB,0.11754E+04_JPRB /)  
KA(:, 3,13,13) = (/ &
 & 0.11370E+04_JPRB,0.10022E+04_JPRB,0.86246E+03_JPRB,0.73215E+03_JPRB,0.60419E+03_JPRB, &
 & 0.74569E+03_JPRB,0.88867E+03_JPRB,0.10317E+04_JPRB,0.11747E+04_JPRB /)  
KA(:, 4,13,13) = (/ &
 & 0.11288E+04_JPRB,0.99109E+03_JPRB,0.86549E+03_JPRB,0.72280E+03_JPRB,0.60356E+03_JPRB, &
 & 0.74480E+03_JPRB,0.88820E+03_JPRB,0.10312E+04_JPRB,0.11742E+04_JPRB /)  
KA(:, 5,13,13) = (/ &
 & 0.11445E+04_JPRB,0.99099E+03_JPRB,0.85129E+03_JPRB,0.71952E+03_JPRB,0.60234E+03_JPRB, &
 & 0.74410E+03_JPRB,0.88705E+03_JPRB,0.10299E+04_JPRB,0.11727E+04_JPRB /)  
KA(:, 1, 1,14) = (/ &
 & 0.20185E+04_JPRB,0.18044E+04_JPRB,0.14758E+04_JPRB,0.13047E+04_JPRB,0.10029E+04_JPRB, &
 & 0.77460E+03_JPRB,0.89226E+03_JPRB,0.10322E+04_JPRB,0.11721E+04_JPRB /)  
KA(:, 2, 1,14) = (/ &
 & 0.19173E+04_JPRB,0.17154E+04_JPRB,0.14467E+04_JPRB,0.12101E+04_JPRB,0.99594E+03_JPRB, &
 & 0.75026E+03_JPRB,0.88974E+03_JPRB,0.10295E+04_JPRB,0.11713E+04_JPRB /)  
KA(:, 3, 1,14) = (/ &
 & 0.19468E+04_JPRB,0.16851E+04_JPRB,0.14136E+04_JPRB,0.12474E+04_JPRB,0.94959E+03_JPRB, &
 & 0.74773E+03_JPRB,0.88696E+03_JPRB,0.10271E+04_JPRB,0.11663E+04_JPRB /)  
KA(:, 4, 1,14) = (/ &
 & 0.18423E+04_JPRB,0.16214E+04_JPRB,0.13991E+04_JPRB,0.11633E+04_JPRB,0.94698E+03_JPRB, &
 & 0.74507E+03_JPRB,0.88457E+03_JPRB,0.10239E+04_JPRB,0.11632E+04_JPRB /)  
KA(:, 5, 1,14) = (/ &
 & 0.17538E+04_JPRB,0.16376E+04_JPRB,0.13645E+04_JPRB,0.11303E+04_JPRB,0.98877E+03_JPRB, &
 & 0.74430E+03_JPRB,0.88372E+03_JPRB,0.10232E+04_JPRB,0.11626E+04_JPRB /)  
KA(:, 1, 2,14) = (/ &
 & 0.18551E+04_JPRB,0.16163E+04_JPRB,0.13640E+04_JPRB,0.12440E+04_JPRB,0.97095E+03_JPRB, &
 & 0.75153E+03_JPRB,0.89202E+03_JPRB,0.10323E+04_JPRB,0.11731E+04_JPRB /)  
KA(:, 2, 2,14) = (/ &
 & 0.18136E+04_JPRB,0.16209E+04_JPRB,0.13887E+04_JPRB,0.11127E+04_JPRB,0.90845E+03_JPRB, &
 & 0.74936E+03_JPRB,0.88974E+03_JPRB,0.10301E+04_JPRB,0.11702E+04_JPRB /)  
KA(:, 3, 2,14) = (/ &
 & 0.17918E+04_JPRB,0.15931E+04_JPRB,0.13282E+04_JPRB,0.11266E+04_JPRB,0.93052E+03_JPRB, &
 & 0.74732E+03_JPRB,0.88725E+03_JPRB,0.10243E+04_JPRB,0.11672E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART9',1,ZHOOK_HANDLE)
END SUBROUTINE PART9


SUBROUTINE PART10

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART10',0,ZHOOK_HANDLE)


KA(:, 4, 2,14) = (/ &
 & 0.17507E+04_JPRB,0.14791E+04_JPRB,0.12865E+04_JPRB,0.10818E+04_JPRB,0.87901E+03_JPRB, &
 & 0.74478E+03_JPRB,0.88467E+03_JPRB,0.10246E+04_JPRB,0.11645E+04_JPRB /)  
KA(:, 5, 2,14) = (/ &
 & 0.16872E+04_JPRB,0.14818E+04_JPRB,0.12871E+04_JPRB,0.10513E+04_JPRB,0.88744E+03_JPRB, &
 & 0.74325E+03_JPRB,0.88337E+03_JPRB,0.10230E+04_JPRB,0.11625E+04_JPRB /)  
KA(:, 1, 3,14) = (/ &
 & 0.16919E+04_JPRB,0.15533E+04_JPRB,0.13337E+04_JPRB,0.10831E+04_JPRB,0.86308E+03_JPRB, &
 & 0.75085E+03_JPRB,0.89217E+03_JPRB,0.10333E+04_JPRB,0.11744E+04_JPRB /)  
KA(:, 2, 3,14) = (/ &
 & 0.17034E+04_JPRB,0.15495E+04_JPRB,0.12643E+04_JPRB,0.11407E+04_JPRB,0.84365E+03_JPRB, &
 & 0.74929E+03_JPRB,0.89025E+03_JPRB,0.10312E+04_JPRB,0.11722E+04_JPRB /)  
KA(:, 3, 3,14) = (/ &
 & 0.16844E+04_JPRB,0.14282E+04_JPRB,0.12585E+04_JPRB,0.10790E+04_JPRB,0.84114E+03_JPRB, &
 & 0.74691E+03_JPRB,0.88785E+03_JPRB,0.10286E+04_JPRB,0.11700E+04_JPRB /)  
KA(:, 4, 3,14) = (/ &
 & 0.16791E+04_JPRB,0.14180E+04_JPRB,0.12209E+04_JPRB,0.10441E+04_JPRB,0.85899E+03_JPRB, &
 & 0.74519E+03_JPRB,0.88544E+03_JPRB,0.10259E+04_JPRB,0.11667E+04_JPRB /)  
KA(:, 5, 3,14) = (/ &
 & 0.16063E+04_JPRB,0.13774E+04_JPRB,0.12181E+04_JPRB,0.10006E+04_JPRB,0.82020E+03_JPRB, &
 & 0.74245E+03_JPRB,0.88287E+03_JPRB,0.10231E+04_JPRB,0.11633E+04_JPRB /)  
KA(:, 1, 4,14) = (/ &
 & 0.15960E+04_JPRB,0.13846E+04_JPRB,0.12078E+04_JPRB,0.10284E+04_JPRB,0.81079E+03_JPRB, &
 & 0.75078E+03_JPRB,0.89233E+03_JPRB,0.10336E+04_JPRB,0.11751E+04_JPRB /)  
KA(:, 2, 4,14) = (/ &
 & 0.16237E+04_JPRB,0.13919E+04_JPRB,0.11906E+04_JPRB,0.10115E+04_JPRB,0.83009E+03_JPRB, &
 & 0.74909E+03_JPRB,0.89076E+03_JPRB,0.10322E+04_JPRB,0.11737E+04_JPRB /)  
KA(:, 3, 4,14) = (/ &
 & 0.16136E+04_JPRB,0.13698E+04_JPRB,0.12046E+04_JPRB,0.98839E+03_JPRB,0.80997E+03_JPRB, &
 & 0.74745E+03_JPRB,0.88871E+03_JPRB,0.10300E+04_JPRB,0.11712E+04_JPRB /)  
KA(:, 4, 4,14) = (/ &
 & 0.15739E+04_JPRB,0.13753E+04_JPRB,0.11394E+04_JPRB,0.97871E+03_JPRB,0.77029E+03_JPRB, &
 & 0.74770E+03_JPRB,0.88627E+03_JPRB,0.10279E+04_JPRB,0.11682E+04_JPRB /)  
KA(:, 5, 4,14) = (/ &
 & 0.14863E+04_JPRB,0.13334E+04_JPRB,0.11445E+04_JPRB,0.95775E+03_JPRB,0.78998E+03_JPRB, &
 & 0.74317E+03_JPRB,0.88387E+03_JPRB,0.10246E+04_JPRB,0.11653E+04_JPRB /)  
KA(:, 1, 5,14) = (/ &
 & 0.15101E+04_JPRB,0.14006E+04_JPRB,0.11513E+04_JPRB,0.96783E+03_JPRB,0.79581E+03_JPRB, &
 & 0.75045E+03_JPRB,0.89239E+03_JPRB,0.10340E+04_JPRB,0.11759E+04_JPRB /)  
KA(:, 2, 5,14) = (/ &
 & 0.15461E+04_JPRB,0.13003E+04_JPRB,0.11685E+04_JPRB,0.92112E+03_JPRB,0.77517E+03_JPRB, &
 & 0.74927E+03_JPRB,0.89114E+03_JPRB,0.10330E+04_JPRB,0.11749E+04_JPRB /)  
KA(:, 3, 5,14) = (/ &
 & 0.14676E+04_JPRB,0.12966E+04_JPRB,0.11042E+04_JPRB,0.93875E+03_JPRB,0.79645E+03_JPRB, &
 & 0.74772E+03_JPRB,0.88943E+03_JPRB,0.10311E+04_JPRB,0.11729E+04_JPRB /)  
KA(:, 4, 5,14) = (/ &
 & 0.14571E+04_JPRB,0.12955E+04_JPRB,0.11734E+04_JPRB,0.89731E+03_JPRB,0.76986E+03_JPRB, &
 & 0.74578E+03_JPRB,0.88723E+03_JPRB,0.10287E+04_JPRB,0.11702E+04_JPRB /)  
KA(:, 5, 5,14) = (/ &
 & 0.14311E+04_JPRB,0.13054E+04_JPRB,0.10738E+04_JPRB,0.10079E+04_JPRB,0.72704E+03_JPRB, &
 & 0.74437E+03_JPRB,0.88461E+03_JPRB,0.10260E+04_JPRB,0.11675E+04_JPRB /)  
KA(:, 1, 6,14) = (/ &
 & 0.14715E+04_JPRB,0.12798E+04_JPRB,0.11182E+04_JPRB,0.92160E+03_JPRB,0.75379E+03_JPRB, &
 & 0.75023E+03_JPRB,0.89251E+03_JPRB,0.10348E+04_JPRB,0.11771E+04_JPRB /)  
KA(:, 2, 6,14) = (/ &
 & 0.14479E+04_JPRB,0.12414E+04_JPRB,0.11222E+04_JPRB,0.91289E+03_JPRB,0.75013E+03_JPRB, &
 & 0.74921E+03_JPRB,0.89141E+03_JPRB,0.10336E+04_JPRB,0.11758E+04_JPRB /)  
KA(:, 3, 6,14) = (/ &
 & 0.14270E+04_JPRB,0.12651E+04_JPRB,0.10793E+04_JPRB,0.91215E+03_JPRB,0.74649E+03_JPRB, &
 & 0.74796E+03_JPRB,0.89005E+03_JPRB,0.10321E+04_JPRB,0.11739E+04_JPRB /)  
KA(:, 4, 6,14) = (/ &
 & 0.14058E+04_JPRB,0.12702E+04_JPRB,0.11005E+04_JPRB,0.93809E+03_JPRB,0.69854E+03_JPRB, &
 & 0.74632E+03_JPRB,0.88820E+03_JPRB,0.10301E+04_JPRB,0.11720E+04_JPRB /)  
KA(:, 5, 6,14) = (/ &
 & 0.14048E+04_JPRB,0.12100E+04_JPRB,0.10413E+04_JPRB,0.84934E+03_JPRB,0.69794E+03_JPRB, &
 & 0.74429E+03_JPRB,0.88588E+03_JPRB,0.10284E+04_JPRB,0.11701E+04_JPRB /)  
KA(:, 1, 7,14) = (/ &
 & 0.14325E+04_JPRB,0.12413E+04_JPRB,0.10595E+04_JPRB,0.88906E+03_JPRB,0.71717E+03_JPRB, &
 & 0.75037E+03_JPRB,0.89273E+03_JPRB,0.10353E+04_JPRB,0.11779E+04_JPRB /)  
KA(:, 2, 7,14) = (/ &
 & 0.13620E+04_JPRB,0.12089E+04_JPRB,0.10598E+04_JPRB,0.89550E+03_JPRB,0.73134E+03_JPRB, &
 & 0.74911E+03_JPRB,0.89161E+03_JPRB,0.10341E+04_JPRB,0.11766E+04_JPRB /)  
KA(:, 3, 7,14) = (/ &
 & 0.13346E+04_JPRB,0.12111E+04_JPRB,0.10262E+04_JPRB,0.84775E+03_JPRB,0.68161E+03_JPRB, &
 & 0.74811E+03_JPRB,0.89050E+03_JPRB,0.10329E+04_JPRB,0.11753E+04_JPRB /)  
KA(:, 4, 7,14) = (/ &
 & 0.13132E+04_JPRB,0.11998E+04_JPRB,0.99757E+03_JPRB,0.86083E+03_JPRB,0.70251E+03_JPRB, &
 & 0.74653E+03_JPRB,0.88899E+03_JPRB,0.10312E+04_JPRB,0.11735E+04_JPRB /)  
KA(:, 5, 7,14) = (/ &
 & 0.13232E+04_JPRB,0.11634E+04_JPRB,0.10230E+04_JPRB,0.84353E+03_JPRB,0.68339E+03_JPRB, &
 & 0.74500E+03_JPRB,0.88698E+03_JPRB,0.10287E+04_JPRB,0.11709E+04_JPRB /)  
KA(:, 1, 8,14) = (/ &
 & 0.13366E+04_JPRB,0.11630E+04_JPRB,0.10188E+04_JPRB,0.86405E+03_JPRB,0.71800E+03_JPRB, &
 & 0.75008E+03_JPRB,0.89285E+03_JPRB,0.10357E+04_JPRB,0.11785E+04_JPRB /)  
KA(:, 2, 8,14) = (/ &
 & 0.13647E+04_JPRB,0.11518E+04_JPRB,0.10110E+04_JPRB,0.84719E+03_JPRB,0.67819E+03_JPRB, &
 & 0.74911E+03_JPRB,0.89187E+03_JPRB,0.10343E+04_JPRB,0.11777E+04_JPRB /)  
KA(:, 3, 8,14) = (/ &
 & 0.13128E+04_JPRB,0.11472E+04_JPRB,0.99038E+03_JPRB,0.82656E+03_JPRB,0.66483E+03_JPRB, &
 & 0.74815E+03_JPRB,0.89080E+03_JPRB,0.10335E+04_JPRB,0.11761E+04_JPRB /)  
KA(:, 4, 8,14) = (/ &
 & 0.12817E+04_JPRB,0.11127E+04_JPRB,0.10092E+04_JPRB,0.82047E+03_JPRB,0.65442E+03_JPRB, &
 & 0.74685E+03_JPRB,0.88933E+03_JPRB,0.10318E+04_JPRB,0.11746E+04_JPRB /)  
KA(:, 5, 8,14) = (/ &
 & 0.13162E+04_JPRB,0.11356E+04_JPRB,0.98305E+03_JPRB,0.84668E+03_JPRB,0.66544E+03_JPRB, &
 & 0.74558E+03_JPRB,0.88790E+03_JPRB,0.10302E+04_JPRB,0.11725E+04_JPRB /)  
KA(:, 1, 9,14) = (/ &
 & 0.13174E+04_JPRB,0.11399E+04_JPRB,0.97696E+03_JPRB,0.84117E+03_JPRB,0.66145E+03_JPRB, &
 & 0.75011E+03_JPRB,0.89307E+03_JPRB,0.10362E+04_JPRB,0.11789E+04_JPRB /)  
KA(:, 2, 9,14) = (/ &
 & 0.13196E+04_JPRB,0.11310E+04_JPRB,0.99094E+03_JPRB,0.80674E+03_JPRB,0.67265E+03_JPRB, &
 & 0.74915E+03_JPRB,0.89213E+03_JPRB,0.10351E+04_JPRB,0.11781E+04_JPRB /)  
KA(:, 3, 9,14) = (/ &
 & 0.12950E+04_JPRB,0.10983E+04_JPRB,0.10229E+04_JPRB,0.86051E+03_JPRB,0.66007E+03_JPRB, &
 & 0.74819E+03_JPRB,0.89107E+03_JPRB,0.10339E+04_JPRB,0.11768E+04_JPRB /)  
KA(:, 4, 9,14) = (/ &
 & 0.12605E+04_JPRB,0.10785E+04_JPRB,0.10061E+04_JPRB,0.79531E+03_JPRB,0.63414E+03_JPRB, &
 & 0.74728E+03_JPRB,0.89004E+03_JPRB,0.10328E+04_JPRB,0.11756E+04_JPRB /)  
KA(:, 5, 9,14) = (/ &
 & 0.12553E+04_JPRB,0.10628E+04_JPRB,0.94908E+03_JPRB,0.82074E+03_JPRB,0.64983E+03_JPRB, &
 & 0.74606E+03_JPRB,0.88866E+03_JPRB,0.10313E+04_JPRB,0.11739E+04_JPRB /)  
KA(:, 1,10,14) = (/ &
 & 0.13413E+04_JPRB,0.11632E+04_JPRB,0.10048E+04_JPRB,0.80476E+03_JPRB,0.65189E+03_JPRB, &
 & 0.75022E+03_JPRB,0.89354E+03_JPRB,0.10369E+04_JPRB,0.11806E+04_JPRB /)  
KA(:, 2,10,14) = (/ &
 & 0.12838E+04_JPRB,0.11017E+04_JPRB,0.10173E+04_JPRB,0.85213E+03_JPRB,0.64367E+03_JPRB, &
 & 0.74909E+03_JPRB,0.89223E+03_JPRB,0.10354E+04_JPRB,0.11786E+04_JPRB /)  
KA(:, 3,10,14) = (/ &
 & 0.12657E+04_JPRB,0.11229E+04_JPRB,0.92134E+03_JPRB,0.80214E+03_JPRB,0.64195E+03_JPRB, &
 & 0.74870E+03_JPRB,0.89159E+03_JPRB,0.10344E+04_JPRB,0.11778E+04_JPRB /)  
KA(:, 4,10,14) = (/ &
 & 0.12310E+04_JPRB,0.10594E+04_JPRB,0.92792E+03_JPRB,0.78251E+03_JPRB,0.62401E+03_JPRB, &
 & 0.74734E+03_JPRB,0.89003E+03_JPRB,0.10332E+04_JPRB,0.11762E+04_JPRB /)  
KA(:, 5,10,14) = (/ &
 & 0.12088E+04_JPRB,0.10663E+04_JPRB,0.92275E+03_JPRB,0.77707E+03_JPRB,0.64354E+03_JPRB, &
 & 0.74634E+03_JPRB,0.88914E+03_JPRB,0.10320E+04_JPRB,0.11748E+04_JPRB /)  
KA(:, 1,11,14) = (/ &
 & 0.12205E+04_JPRB,0.10982E+04_JPRB,0.93349E+03_JPRB,0.79899E+03_JPRB,0.64961E+03_JPRB, &
 & 0.74981E+03_JPRB,0.89329E+03_JPRB,0.10368E+04_JPRB,0.11803E+04_JPRB /)  
KA(:, 2,11,14) = (/ &
 & 0.12266E+04_JPRB,0.10977E+04_JPRB,0.90836E+03_JPRB,0.76723E+03_JPRB,0.61851E+03_JPRB, &
 & 0.74871E+03_JPRB,0.89199E+03_JPRB,0.10353E+04_JPRB,0.11786E+04_JPRB /)  
KA(:, 3,11,14) = (/ &
 & 0.11876E+04_JPRB,0.10750E+04_JPRB,0.92258E+03_JPRB,0.76849E+03_JPRB,0.61349E+03_JPRB, &
 & 0.74902E+03_JPRB,0.89163E+03_JPRB,0.10343E+04_JPRB,0.11775E+04_JPRB /)  
KA(:, 4,11,14) = (/ &
 & 0.12363E+04_JPRB,0.10327E+04_JPRB,0.91965E+03_JPRB,0.74736E+03_JPRB,0.60206E+03_JPRB, &
 & 0.74703E+03_JPRB,0.88982E+03_JPRB,0.10331E+04_JPRB,0.11762E+04_JPRB /)  
KA(:, 5,11,14) = (/ &
 & 0.11827E+04_JPRB,0.10266E+04_JPRB,0.89018E+03_JPRB,0.76668E+03_JPRB,0.60360E+03_JPRB, &
 & 0.74604E+03_JPRB,0.88895E+03_JPRB,0.10316E+04_JPRB,0.11748E+04_JPRB /)  
KA(:, 1,12,14) = (/ &
 & 0.11808E+04_JPRB,0.10792E+04_JPRB,0.88334E+03_JPRB,0.76947E+03_JPRB,0.60663E+03_JPRB, &
 & 0.74904E+03_JPRB,0.89307E+03_JPRB,0.10367E+04_JPRB,0.11803E+04_JPRB /)  
KA(:, 2,12,14) = (/ &
 & 0.12120E+04_JPRB,0.10402E+04_JPRB,0.92096E+03_JPRB,0.78880E+03_JPRB,0.60609E+03_JPRB, &
 & 0.74841E+03_JPRB,0.89179E+03_JPRB,0.10352E+04_JPRB,0.11786E+04_JPRB /)  
KA(:, 3,12,14) = (/ &
 & 0.12016E+04_JPRB,0.10899E+04_JPRB,0.90018E+03_JPRB,0.73017E+03_JPRB,0.60527E+03_JPRB, &
 & 0.75028E+03_JPRB,0.89119E+03_JPRB,0.10342E+04_JPRB,0.11778E+04_JPRB /)  
KA(:, 4,12,14) = (/ &
 & 0.11901E+04_JPRB,0.10101E+04_JPRB,0.88929E+03_JPRB,0.75342E+03_JPRB,0.60426E+03_JPRB, &
 & 0.74677E+03_JPRB,0.88991E+03_JPRB,0.10327E+04_JPRB,0.11762E+04_JPRB /)  
KA(:, 5,12,14) = (/ &
 & 0.12404E+04_JPRB,0.10285E+04_JPRB,0.87283E+03_JPRB,0.77029E+03_JPRB,0.60316E+03_JPRB, &
 & 0.74579E+03_JPRB,0.88852E+03_JPRB,0.10318E+04_JPRB,0.11748E+04_JPRB /)  
KA(:, 1,13,14) = (/ &
 & 0.11819E+04_JPRB,0.10465E+04_JPRB,0.87588E+03_JPRB,0.72550E+03_JPRB,0.60649E+03_JPRB, &
 & 0.74922E+03_JPRB,0.89289E+03_JPRB,0.10366E+04_JPRB,0.11799E+04_JPRB /)  
KA(:, 2,13,14) = (/ &
 & 0.11759E+04_JPRB,0.10245E+04_JPRB,0.86816E+03_JPRB,0.77411E+03_JPRB,0.60565E+03_JPRB, &
 & 0.74816E+03_JPRB,0.89163E+03_JPRB,0.10351E+04_JPRB,0.11786E+04_JPRB /)  
KA(:, 3,13,14) = (/ &
 & 0.11354E+04_JPRB,0.10124E+04_JPRB,0.96299E+03_JPRB,0.72358E+03_JPRB,0.60486E+03_JPRB, &
 & 0.74851E+03_JPRB,0.89156E+03_JPRB,0.10341E+04_JPRB,0.11778E+04_JPRB /)  
KA(:, 4,13,14) = (/ &
 & 0.11811E+04_JPRB,0.10736E+04_JPRB,0.85638E+03_JPRB,0.74549E+03_JPRB,0.60366E+03_JPRB, &
 & 0.74655E+03_JPRB,0.88977E+03_JPRB,0.10330E+04_JPRB,0.11762E+04_JPRB /)  
KA(:, 5,13,14) = (/ &
 & 0.11332E+04_JPRB,0.99282E+03_JPRB,0.87259E+03_JPRB,0.77082E+03_JPRB,0.60280E+03_JPRB, &
 & 0.74559E+03_JPRB,0.88865E+03_JPRB,0.10317E+04_JPRB,0.11748E+04_JPRB /)  
KA(:, 1, 1,15) = (/ &
 & 0.19847E+04_JPRB,0.16615E+04_JPRB,0.16299E+04_JPRB,0.11466E+04_JPRB,0.10123E+04_JPRB, &
 & 0.72871E+03_JPRB,0.89405E+03_JPRB,0.10334E+04_JPRB,0.11734E+04_JPRB /)  
KA(:, 2, 1,15) = (/ &
 & 0.18867E+04_JPRB,0.16470E+04_JPRB,0.14051E+04_JPRB,0.12848E+04_JPRB,0.91870E+03_JPRB, &
 & 0.75104E+03_JPRB,0.89013E+03_JPRB,0.10307E+04_JPRB,0.11650E+04_JPRB /)  
KA(:, 3, 1,15) = (/ &
 & 0.17405E+04_JPRB,0.16240E+04_JPRB,0.14364E+04_JPRB,0.10773E+04_JPRB,0.10008E+04_JPRB, &
 & 0.74790E+03_JPRB,0.89023E+03_JPRB,0.10382E+04_JPRB,0.11720E+04_JPRB /)  
KA(:, 4, 1,15) = (/ &
 & 0.19099E+04_JPRB,0.16930E+04_JPRB,0.14454E+04_JPRB,0.12410E+04_JPRB,0.95925E+03_JPRB, &
 & 0.74605E+03_JPRB,0.88544E+03_JPRB,0.10248E+04_JPRB,0.11651E+04_JPRB /)  
KA(:, 5, 1,15) = (/ &
 & 0.19738E+04_JPRB,0.13892E+04_JPRB,0.14377E+04_JPRB,0.12129E+04_JPRB,0.77083E+03_JPRB, &
 & 0.74496E+03_JPRB,0.88458E+03_JPRB,0.10242E+04_JPRB,0.11638E+04_JPRB /)  
KA(:, 1, 2,15) = (/ &
 & 0.18788E+04_JPRB,0.15414E+04_JPRB,0.14391E+04_JPRB,0.94831E+03_JPRB,0.88384E+03_JPRB, &
 & 0.75320E+03_JPRB,0.89399E+03_JPRB,0.10340E+04_JPRB,0.11746E+04_JPRB /)  
KA(:, 2, 2,15) = (/ &
 & 0.16660E+04_JPRB,0.14507E+04_JPRB,0.12145E+04_JPRB,0.11753E+04_JPRB,0.91977E+03_JPRB, &
 & 0.75003E+03_JPRB,0.89113E+03_JPRB,0.10308E+04_JPRB,0.11712E+04_JPRB /)  
KA(:, 3, 2,15) = (/ &
 & 0.15746E+04_JPRB,0.14551E+04_JPRB,0.13375E+04_JPRB,0.10698E+04_JPRB,0.76931E+03_JPRB, &
 & 0.74657E+03_JPRB,0.88729E+03_JPRB,0.10267E+04_JPRB,0.11695E+04_JPRB /)  
KA(:, 4, 2,15) = (/ &
 & 0.16772E+04_JPRB,0.16415E+04_JPRB,0.13391E+04_JPRB,0.10287E+04_JPRB,0.88207E+03_JPRB, &
 & 0.74593E+03_JPRB,0.88530E+03_JPRB,0.10252E+04_JPRB,0.11661E+04_JPRB /)  
KA(:, 5, 2,15) = (/ &
 & 0.16581E+04_JPRB,0.15452E+04_JPRB,0.12479E+04_JPRB,0.10067E+04_JPRB,0.83698E+03_JPRB, &
 & 0.74419E+03_JPRB,0.88279E+03_JPRB,0.10234E+04_JPRB,0.11634E+04_JPRB /)  
KA(:, 1, 3,15) = (/ &
 & 0.17888E+04_JPRB,0.13395E+04_JPRB,0.12224E+04_JPRB,0.11479E+04_JPRB,0.91734E+03_JPRB, &
 & 0.75291E+03_JPRB,0.89358E+03_JPRB,0.10348E+04_JPRB,0.11761E+04_JPRB /)  
KA(:, 2, 3,15) = (/ &
 & 0.16146E+04_JPRB,0.11805E+04_JPRB,0.12709E+04_JPRB,0.85911E+03_JPRB,0.90210E+03_JPRB, &
 & 0.75028E+03_JPRB,0.89203E+03_JPRB,0.10324E+04_JPRB,0.11734E+04_JPRB /)  
KA(:, 3, 3,15) = (/ &
 & 0.14717E+04_JPRB,0.15353E+04_JPRB,0.12224E+04_JPRB,0.96001E+03_JPRB,0.77554E+03_JPRB, &
 & 0.74753E+03_JPRB,0.88823E+03_JPRB,0.10297E+04_JPRB,0.11678E+04_JPRB /)  
KA(:, 4, 3,15) = (/ &
 & 0.15479E+04_JPRB,0.14535E+04_JPRB,0.11756E+04_JPRB,0.99609E+03_JPRB,0.71892E+03_JPRB, &
 & 0.74634E+03_JPRB,0.88703E+03_JPRB,0.10366E+04_JPRB,0.11684E+04_JPRB /)  
KA(:, 5, 3,15) = (/ &
 & 0.15155E+04_JPRB,0.14515E+04_JPRB,0.11733E+04_JPRB,0.10638E+04_JPRB,0.80510E+03_JPRB, &
 & 0.74461E+03_JPRB,0.88580E+03_JPRB,0.10240E+04_JPRB,0.11652E+04_JPRB /)  
KA(:, 1, 4,15) = (/ &
 & 0.15848E+04_JPRB,0.14083E+04_JPRB,0.12006E+04_JPRB,0.10439E+04_JPRB,0.81336E+03_JPRB, &
 & 0.75201E+03_JPRB,0.89444E+03_JPRB,0.10363E+04_JPRB,0.11781E+04_JPRB /)  
KA(:, 2, 4,15) = (/ &
 & 0.13736E+04_JPRB,0.13760E+04_JPRB,0.12165E+04_JPRB,0.94289E+03_JPRB,0.75006E+03_JPRB, &
 & 0.75167E+03_JPRB,0.89210E+03_JPRB,0.10337E+04_JPRB,0.11753E+04_JPRB /)  
KA(:, 3, 4,15) = (/ &
 & 0.14353E+04_JPRB,0.13702E+04_JPRB,0.10217E+04_JPRB,0.10119E+04_JPRB,0.72585E+03_JPRB, &
 & 0.74883E+03_JPRB,0.88956E+03_JPRB,0.10325E+04_JPRB,0.11731E+04_JPRB /)  
KA(:, 4, 4,15) = (/ &
 & 0.14295E+04_JPRB,0.12548E+04_JPRB,0.12198E+04_JPRB,0.96945E+03_JPRB,0.84557E+03_JPRB, &
 & 0.73846E+03_JPRB,0.88641E+03_JPRB,0.10258E+04_JPRB,0.11703E+04_JPRB /)  
KA(:, 5, 4,15) = (/ &
 & 0.15742E+04_JPRB,0.13268E+04_JPRB,0.10395E+04_JPRB,0.90301E+03_JPRB,0.67604E+03_JPRB, &
 & 0.74473E+03_JPRB,0.88569E+03_JPRB,0.10266E+04_JPRB,0.11676E+04_JPRB /)  
KA(:, 1, 5,15) = (/ &
 & 0.15038E+04_JPRB,0.11787E+04_JPRB,0.11191E+04_JPRB,0.96573E+03_JPRB,0.74364E+03_JPRB, &
 & 0.75161E+03_JPRB,0.89373E+03_JPRB,0.10358E+04_JPRB,0.11780E+04_JPRB /)  
KA(:, 2, 5,15) = (/ &
 & 0.12972E+04_JPRB,0.14157E+04_JPRB,0.10073E+04_JPRB,0.10120E+04_JPRB,0.78829E+03_JPRB, &
 & 0.75051E+03_JPRB,0.89254E+03_JPRB,0.10346E+04_JPRB,0.11785E+04_JPRB /)  
KA(:, 3, 5,15) = (/ &
 & 0.15562E+04_JPRB,0.12980E+04_JPRB,0.11053E+04_JPRB,0.96784E+03_JPRB,0.68156E+03_JPRB, &
 & 0.74938E+03_JPRB,0.89063E+03_JPRB,0.10325E+04_JPRB,0.11743E+04_JPRB /)  
KA(:, 4, 5,15) = (/ &
 & 0.15203E+04_JPRB,0.12953E+04_JPRB,0.96757E+03_JPRB,0.95061E+03_JPRB,0.68480E+03_JPRB, &
 & 0.74750E+03_JPRB,0.88780E+03_JPRB,0.10293E+04_JPRB,0.11708E+04_JPRB /)  
KA(:, 5, 5,15) = (/ &
 & 0.14730E+04_JPRB,0.11456E+04_JPRB,0.11151E+04_JPRB,0.68408E+03_JPRB,0.76176E+03_JPRB, &
 & 0.75307E+03_JPRB,0.89322E+03_JPRB,0.10317E+04_JPRB,0.11682E+04_JPRB /)  
KA(:, 1, 6,15) = (/ &
 & 0.15240E+04_JPRB,0.12794E+04_JPRB,0.10826E+04_JPRB,0.93131E+03_JPRB,0.69525E+03_JPRB, &
 & 0.75122E+03_JPRB,0.89364E+03_JPRB,0.10361E+04_JPRB,0.11785E+04_JPRB /)  
KA(:, 2, 6,15) = (/ &
 & 0.13735E+04_JPRB,0.12837E+04_JPRB,0.10725E+04_JPRB,0.91616E+03_JPRB,0.69548E+03_JPRB, &
 & 0.75041E+03_JPRB,0.89279E+03_JPRB,0.10360E+04_JPRB,0.11776E+04_JPRB /)  
KA(:, 3, 6,15) = (/ &
 & 0.14287E+04_JPRB,0.11366E+04_JPRB,0.10240E+04_JPRB,0.87529E+03_JPRB,0.70795E+03_JPRB, &
 & 0.75034E+03_JPRB,0.89142E+03_JPRB,0.10337E+04_JPRB,0.11759E+04_JPRB /)  
KA(:, 4, 6,15) = (/ &
 & 0.12768E+04_JPRB,0.11078E+04_JPRB,0.98805E+03_JPRB,0.76254E+03_JPRB,0.77383E+03_JPRB, &
 & 0.74782E+03_JPRB,0.88921E+03_JPRB,0.10312E+04_JPRB,0.11732E+04_JPRB /)  
KA(:, 5, 6,15) = (/ &
 & 0.13045E+04_JPRB,0.12087E+04_JPRB,0.10585E+04_JPRB,0.89185E+03_JPRB,0.69378E+03_JPRB, &
 & 0.74461E+03_JPRB,0.88618E+03_JPRB,0.10253E+04_JPRB,0.11684E+04_JPRB /)  
KA(:, 1, 7,15) = (/ &
 & 0.13068E+04_JPRB,0.11778E+04_JPRB,0.10485E+04_JPRB,0.87245E+03_JPRB,0.70237E+03_JPRB, &
 & 0.75029E+03_JPRB,0.89358E+03_JPRB,0.10363E+04_JPRB,0.11790E+04_JPRB /)  
KA(:, 2, 7,15) = (/ &
 & 0.13988E+04_JPRB,0.11525E+04_JPRB,0.98924E+03_JPRB,0.83779E+03_JPRB,0.64617E+03_JPRB, &
 & 0.75022E+03_JPRB,0.89357E+03_JPRB,0.10355E+04_JPRB,0.11782E+04_JPRB /)  
KA(:, 3, 7,15) = (/ &
 & 0.14294E+04_JPRB,0.11695E+04_JPRB,0.10182E+04_JPRB,0.91196E+03_JPRB,0.69696E+03_JPRB, &
 & 0.74932E+03_JPRB,0.89330E+03_JPRB,0.10353E+04_JPRB,0.11780E+04_JPRB /)  
KA(:, 4, 7,15) = (/ &
 & 0.14082E+04_JPRB,0.10640E+04_JPRB,0.10540E+04_JPRB,0.79295E+03_JPRB,0.62688E+03_JPRB, &
 & 0.74789E+03_JPRB,0.89097E+03_JPRB,0.10327E+04_JPRB,0.11750E+04_JPRB /)  
KA(:, 5, 7,15) = (/ &
 & 0.13514E+04_JPRB,0.12038E+04_JPRB,0.10012E+04_JPRB,0.83544E+03_JPRB,0.67927E+03_JPRB, &
 & 0.74629E+03_JPRB,0.88843E+03_JPRB,0.10298E+04_JPRB,0.11718E+04_JPRB /)  
KA(:, 1, 8,15) = (/ &
 & 0.14761E+04_JPRB,0.12412E+04_JPRB,0.10429E+04_JPRB,0.84370E+03_JPRB,0.62388E+03_JPRB, &
 & 0.75133E+03_JPRB,0.89371E+03_JPRB,0.10367E+04_JPRB,0.11796E+04_JPRB /)  
KA(:, 2, 8,15) = (/ &
 & 0.12119E+04_JPRB,0.11409E+04_JPRB,0.10121E+04_JPRB,0.85755E+03_JPRB,0.70976E+03_JPRB, &
 & 0.74998E+03_JPRB,0.89216E+03_JPRB,0.10357E+04_JPRB,0.11786E+04_JPRB /)  
KA(:, 3, 8,15) = (/ &
 & 0.12581E+04_JPRB,0.11663E+04_JPRB,0.10198E+04_JPRB,0.88649E+03_JPRB,0.69509E+03_JPRB, &
 & 0.74932E+03_JPRB,0.89355E+03_JPRB,0.10350E+04_JPRB,0.11787E+04_JPRB /)  
KA(:, 4, 8,15) = (/ &
 & 0.12478E+04_JPRB,0.12066E+04_JPRB,0.87201E+03_JPRB,0.84155E+03_JPRB,0.70223E+03_JPRB, &
 & 0.74886E+03_JPRB,0.89098E+03_JPRB,0.10337E+04_JPRB,0.11764E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART10',1,ZHOOK_HANDLE)
END SUBROUTINE PART10


SUBROUTINE PART11

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART11',0,ZHOOK_HANDLE)


KA(:, 5, 8,15) = (/ &
 & 0.12322E+04_JPRB,0.11048E+04_JPRB,0.93070E+03_JPRB,0.68296E+03_JPRB,0.66022E+03_JPRB, &
 & 0.74776E+03_JPRB,0.88972E+03_JPRB,0.10315E+04_JPRB,0.11748E+04_JPRB /)  
KA(:, 1, 9,15) = (/ &
 & 0.13164E+04_JPRB,0.12093E+04_JPRB,0.10729E+04_JPRB,0.80022E+03_JPRB,0.68605E+03_JPRB, &
 & 0.75075E+03_JPRB,0.89396E+03_JPRB,0.10372E+04_JPRB,0.11804E+04_JPRB /)  
KA(:, 2, 9,15) = (/ &
 & 0.12738E+04_JPRB,0.11851E+04_JPRB,0.88381E+03_JPRB,0.85846E+03_JPRB,0.65813E+03_JPRB, &
 & 0.74985E+03_JPRB,0.89295E+03_JPRB,0.10369E+04_JPRB,0.11792E+04_JPRB /)  
KA(:, 3, 9,15) = (/ &
 & 0.12657E+04_JPRB,0.12031E+04_JPRB,0.79849E+03_JPRB,0.64636E+03_JPRB,0.60824E+03_JPRB, &
 & 0.74924E+03_JPRB,0.89227E+03_JPRB,0.10353E+04_JPRB,0.11783E+04_JPRB /)  
KA(:, 4, 9,15) = (/ &
 & 0.12866E+04_JPRB,0.11531E+04_JPRB,0.85958E+03_JPRB,0.76890E+03_JPRB,0.66204E+03_JPRB, &
 & 0.74965E+03_JPRB,0.89143E+03_JPRB,0.10344E+04_JPRB,0.11773E+04_JPRB /)  
KA(:, 5, 9,15) = (/ &
 & 0.11604E+04_JPRB,0.11730E+04_JPRB,0.87009E+03_JPRB,0.73148E+03_JPRB,0.58106E+03_JPRB, &
 & 0.74723E+03_JPRB,0.88998E+03_JPRB,0.10327E+04_JPRB,0.11755E+04_JPRB /)  
KA(:, 1,10,15) = (/ &
 & 0.11188E+04_JPRB,0.99215E+03_JPRB,0.73460E+03_JPRB,0.83046E+03_JPRB,0.68844E+03_JPRB, &
 & 0.75085E+03_JPRB,0.89429E+03_JPRB,0.10377E+04_JPRB,0.11803E+04_JPRB /)  
KA(:, 2,10,15) = (/ &
 & 0.12059E+04_JPRB,0.10804E+04_JPRB,0.70761E+03_JPRB,0.65712E+03_JPRB,0.66535E+03_JPRB, &
 & 0.74980E+03_JPRB,0.89311E+03_JPRB,0.10364E+04_JPRB,0.11807E+04_JPRB /)  
KA(:, 3,10,15) = (/ &
 & 0.11817E+04_JPRB,0.10195E+04_JPRB,0.95365E+03_JPRB,0.71601E+03_JPRB,0.59959E+03_JPRB, &
 & 0.74791E+03_JPRB,0.89228E+03_JPRB,0.10355E+04_JPRB,0.11778E+04_JPRB /)  
KA(:, 4,10,15) = (/ &
 & 0.11350E+04_JPRB,0.11533E+04_JPRB,0.91058E+03_JPRB,0.81845E+03_JPRB,0.64874E+03_JPRB, &
 & 0.74908E+03_JPRB,0.89233E+03_JPRB,0.10356E+04_JPRB,0.11779E+04_JPRB /)  
KA(:, 5,10,15) = (/ &
 & 0.12000E+04_JPRB,0.10896E+04_JPRB,0.93671E+03_JPRB,0.81314E+03_JPRB,0.60750E+03_JPRB, &
 & 0.74754E+03_JPRB,0.89053E+03_JPRB,0.10335E+04_JPRB,0.11765E+04_JPRB /)  
KA(:, 1,11,15) = (/ &
 & 0.12887E+04_JPRB,0.10795E+04_JPRB,0.92507E+03_JPRB,0.76020E+03_JPRB,0.61621E+03_JPRB, &
 & 0.75046E+03_JPRB,0.89404E+03_JPRB,0.10376E+04_JPRB,0.11812E+04_JPRB /)  
KA(:, 2,11,15) = (/ &
 & 0.11864E+04_JPRB,0.99352E+03_JPRB,0.96688E+03_JPRB,0.81999E+03_JPRB,0.65449E+03_JPRB, &
 & 0.74944E+03_JPRB,0.89287E+03_JPRB,0.10363E+04_JPRB,0.11797E+04_JPRB /)  
KA(:, 3,11,15) = (/ &
 & 0.11946E+04_JPRB,0.10069E+04_JPRB,0.91904E+03_JPRB,0.81170E+03_JPRB,0.65606E+03_JPRB, &
 & 0.74582E+03_JPRB,0.89066E+03_JPRB,0.10354E+04_JPRB,0.11787E+04_JPRB /)  
KA(:, 4,11,15) = (/ &
 & 0.10269E+04_JPRB,0.10463E+04_JPRB,0.82697E+03_JPRB,0.81731E+03_JPRB,0.61185E+03_JPRB, &
 & 0.74876E+03_JPRB,0.89142E+03_JPRB,0.10347E+04_JPRB,0.11779E+04_JPRB /)  
KA(:, 5,11,15) = (/ &
 & 0.11483E+04_JPRB,0.10490E+04_JPRB,0.91718E+03_JPRB,0.72295E+03_JPRB,0.60510E+03_JPRB, &
 & 0.74783E+03_JPRB,0.89173E+03_JPRB,0.10334E+04_JPRB,0.11765E+04_JPRB /)  
KA(:, 1,12,15) = (/ &
 & 0.12157E+04_JPRB,0.94948E+03_JPRB,0.89441E+03_JPRB,0.76380E+03_JPRB,0.60866E+03_JPRB, &
 & 0.75013E+03_JPRB,0.89382E+03_JPRB,0.10375E+04_JPRB,0.11812E+04_JPRB /)  
KA(:, 2,12,15) = (/ &
 & 0.10470E+04_JPRB,0.10059E+04_JPRB,0.83704E+03_JPRB,0.70161E+03_JPRB,0.60721E+03_JPRB, &
 & 0.74914E+03_JPRB,0.89267E+03_JPRB,0.10370E+04_JPRB,0.11807E+04_JPRB /)  
KA(:, 3,12,15) = (/ &
 & 0.10541E+04_JPRB,0.86865E+03_JPRB,0.86614E+03_JPRB,0.79420E+03_JPRB,0.60576E+03_JPRB, &
 & 0.74144E+03_JPRB,0.89117E+03_JPRB,0.10353E+04_JPRB,0.11778E+04_JPRB /)  
KA(:, 4,12,15) = (/ &
 & 0.11152E+04_JPRB,0.10946E+04_JPRB,0.91200E+03_JPRB,0.75719E+03_JPRB,0.60459E+03_JPRB, &
 & 0.74791E+03_JPRB,0.89124E+03_JPRB,0.10346E+04_JPRB,0.11788E+04_JPRB /)  
KA(:, 5,12,15) = (/ &
 & 0.10232E+04_JPRB,0.97767E+03_JPRB,0.95862E+03_JPRB,0.62268E+03_JPRB,0.60382E+03_JPRB, &
 & 0.74758E+03_JPRB,0.88947E+03_JPRB,0.10333E+04_JPRB,0.11765E+04_JPRB /)  
KA(:, 1,13,15) = (/ &
 & 0.11027E+04_JPRB,0.93786E+03_JPRB,0.84040E+03_JPRB,0.77686E+03_JPRB,0.60858E+03_JPRB, &
 & 0.74987E+03_JPRB,0.89364E+03_JPRB,0.10374E+04_JPRB,0.11812E+04_JPRB /)  
KA(:, 2,13,15) = (/ &
 & 0.10816E+04_JPRB,0.10747E+04_JPRB,0.88690E+03_JPRB,0.66213E+03_JPRB,0.60670E+03_JPRB, &
 & 0.74889E+03_JPRB,0.89251E+03_JPRB,0.10369E+04_JPRB,0.11797E+04_JPRB /)  
KA(:, 3,13,15) = (/ &
 & 0.11963E+04_JPRB,0.98701E+03_JPRB,0.69767E+03_JPRB,0.73646E+03_JPRB,0.60528E+03_JPRB, &
 & 0.74531E+03_JPRB,0.88962E+03_JPRB,0.10352E+04_JPRB,0.11778E+04_JPRB /)  
KA(:, 4,13,15) = (/ &
 & 0.10530E+04_JPRB,0.78530E+03_JPRB,0.91477E+03_JPRB,0.71026E+03_JPRB,0.60430E+03_JPRB, &
 & 0.74770E+03_JPRB,0.89110E+03_JPRB,0.10345E+04_JPRB,0.11779E+04_JPRB /)  
KA(:, 5,13,15) = (/ &
 & 0.11409E+04_JPRB,0.10574E+04_JPRB,0.83207E+03_JPRB,0.61034E+03_JPRB,0.60355E+03_JPRB, &
 & 0.74679E+03_JPRB,0.89073E+03_JPRB,0.10333E+04_JPRB,0.11765E+04_JPRB /)  
KA(:, 1, 1,16) = (/ &
 & 0.34848E+03_JPRB,0.49670E+03_JPRB,0.29569E+03_JPRB,0.31627E+03_JPRB,0.46514E+03_JPRB, &
 & 0.42834E+03_JPRB,0.88848E+03_JPRB,0.10335E+04_JPRB,0.11735E+04_JPRB /)  
KA(:, 2, 1,16) = (/ &
 & 0.18044E+04_JPRB,0.87518E+03_JPRB,0.11930E+04_JPRB,0.45580E+03_JPRB,0.83690E+03_JPRB, &
 & 0.74631E+03_JPRB,0.89022E+03_JPRB,0.10242E+04_JPRB,0.11632E+04_JPRB /)  
KA(:, 3, 1,16) = (/ &
 & 0.11196E+04_JPRB,0.73658E+03_JPRB,0.10480E+04_JPRB,0.53695E+03_JPRB,0.39566E+03_JPRB, &
 & 0.74377E+03_JPRB,0.86775E+03_JPRB,0.94144E+03_JPRB,0.11277E+04_JPRB /)  
KA(:, 4, 1,16) = (/ &
 & 0.72013E+03_JPRB,0.40040E+03_JPRB,0.39030E+03_JPRB,0.31401E+03_JPRB,0.31498E+03_JPRB, &
 & 0.74613E+03_JPRB,0.88553E+03_JPRB,0.10249E+04_JPRB,0.11579E+04_JPRB /)  
KA(:, 5, 1,16) = (/ &
 & 0.34789E+03_JPRB,0.14911E+04_JPRB,0.33003E+03_JPRB,0.29522E+03_JPRB,0.31385E+03_JPRB, &
 & 0.74516E+03_JPRB,0.88480E+03_JPRB,0.10244E+04_JPRB,0.11641E+04_JPRB /)  
KA(:, 1, 2,16) = (/ &
 & 0.41247E+03_JPRB,0.81197E+03_JPRB,0.68322E+03_JPRB,0.50855E+03_JPRB,0.24076E+03_JPRB, &
 & 0.74851E+03_JPRB,0.88842E+03_JPRB,0.10341E+04_JPRB,0.11748E+04_JPRB /)  
KA(:, 2, 2,16) = (/ &
 & 0.16209E+04_JPRB,0.56884E+03_JPRB,0.94156E+03_JPRB,0.29182E+03_JPRB,0.46039E+03_JPRB, &
 & 0.75011E+03_JPRB,0.88557E+03_JPRB,0.10309E+04_JPRB,0.11714E+04_JPRB /)  
KA(:, 3, 2,16) = (/ &
 & 0.11534E+04_JPRB,0.51443E+03_JPRB,0.23941E+03_JPRB,0.44358E+03_JPRB,0.58779E+03_JPRB, &
 & 0.74720E+03_JPRB,0.88237E+03_JPRB,0.10275E+04_JPRB,0.11547E+04_JPRB /)  
KA(:, 4, 2,16) = (/ &
 & 0.78193E+03_JPRB,0.30585E+03_JPRB,0.42670E+03_JPRB,0.10365E+04_JPRB,0.43225E+03_JPRB, &
 & 0.74126E+03_JPRB,0.88535E+03_JPRB,0.10253E+04_JPRB,0.11588E+04_JPRB /)  
KA(:, 5, 2,16) = (/ &
 & 0.67509E+03_JPRB,0.40574E+03_JPRB,0.57252E+03_JPRB,0.10353E+04_JPRB,0.15564E+03_JPRB, &
 & 0.73954E+03_JPRB,0.88360E+03_JPRB,0.10236E+04_JPRB,0.11636E+04_JPRB /)  
KA(:, 1, 3,16) = (/ &
 & 0.91257E+03_JPRB,0.11144E+04_JPRB,0.54685E+03_JPRB,0.19037E+03_JPRB,0.25900E+03_JPRB, &
 & 0.74823E+03_JPRB,0.89369E+03_JPRB,0.10350E+04_JPRB,0.11762E+04_JPRB /)  
KA(:, 2, 3,16) = (/ &
 & 0.67162E+03_JPRB,0.10092E+04_JPRB,0.40983E+03_JPRB,0.37826E+03_JPRB,0.42702E+03_JPRB, &
 & 0.75035E+03_JPRB,0.88647E+03_JPRB,0.10325E+04_JPRB,0.11736E+04_JPRB /)  
KA(:, 3, 3,16) = (/ &
 & 0.94657E+03_JPRB,0.26107E+03_JPRB,0.43567E+03_JPRB,0.41065E+03_JPRB,0.70838E+03_JPRB, &
 & 0.74760E+03_JPRB,0.88832E+03_JPRB,0.10233E+04_JPRB,0.11698E+04_JPRB /)  
KA(:, 4, 3,16) = (/ &
 & 0.10618E+03_JPRB,0.45040E+03_JPRB,0.10291E+04_JPRB,0.30237E+03_JPRB,0.57813E+03_JPRB, &
 & 0.73277E+03_JPRB,0.87582E+03_JPRB,0.95203E+03_JPRB,0.11472E+04_JPRB /)  
KA(:, 5, 3,16) = (/ &
 & 0.96551E+03_JPRB,0.68706E+03_JPRB,0.56500E+03_JPRB,0.14865E+03_JPRB,0.35532E+03_JPRB, &
 & 0.73527E+03_JPRB,0.86908E+03_JPRB,0.10241E+04_JPRB,0.11579E+04_JPRB /)  
KA(:, 1, 4,16) = (/ &
 & 0.13211E+04_JPRB,0.11050E+04_JPRB,0.91067E+03_JPRB,0.34788E+03_JPRB,0.76485E+03_JPRB, &
 & 0.75213E+03_JPRB,0.88892E+03_JPRB,0.10299E+04_JPRB,0.11709E+04_JPRB /)  
KA(:, 2, 4,16) = (/ &
 & 0.15543E+04_JPRB,0.92211E+03_JPRB,0.72798E+03_JPRB,0.86839E+03_JPRB,0.36802E+03_JPRB, &
 & 0.74223E+03_JPRB,0.89219E+03_JPRB,0.10338E+04_JPRB,0.11754E+04_JPRB /)  
KA(:, 3, 4,16) = (/ &
 & 0.53676E+03_JPRB,0.46363E+03_JPRB,0.10941E+04_JPRB,0.19958E+03_JPRB,0.68767E+03_JPRB, &
 & 0.74416E+03_JPRB,0.88965E+03_JPRB,0.10195E+04_JPRB,0.11658E+04_JPRB /)  
KA(:, 4, 4,16) = (/ &
 & 0.66992E+03_JPRB,0.61007E+03_JPRB,0.50612E+03_JPRB,0.34999E+03_JPRB,0.19685E+03_JPRB, &
 & 0.74139E+03_JPRB,0.88155E+03_JPRB,0.10274E+04_JPRB,0.11555E+04_JPRB /)  
KA(:, 5, 4,16) = (/ &
 & 0.55226E+03_JPRB,0.42689E+03_JPRB,0.10712E+04_JPRB,0.69959E+03_JPRB,0.69105E+03_JPRB, &
 & 0.73534E+03_JPRB,0.87452E+03_JPRB,0.10137E+04_JPRB,0.11529E+04_JPRB /)  
KA(:, 1, 5,16) = (/ &
 & 0.11854E+04_JPRB,0.90025E+03_JPRB,0.10734E+04_JPRB,0.36732E+03_JPRB,0.51551E+03_JPRB, &
 & 0.75181E+03_JPRB,0.89397E+03_JPRB,0.10361E+04_JPRB,0.11783E+04_JPRB /)  
KA(:, 2, 5,16) = (/ &
 & 0.13933E+04_JPRB,0.23882E+03_JPRB,0.71015E+03_JPRB,0.29765E+03_JPRB,0.88507E+02_JPRB, &
 & 0.75060E+03_JPRB,0.89266E+03_JPRB,0.10347E+04_JPRB,0.11637E+04_JPRB /)  
KA(:, 3, 5,16) = (/ &
 & 0.30783E+03_JPRB,0.72533E+03_JPRB,0.99782E+03_JPRB,0.22581E+03_JPRB,0.21957E+03_JPRB, &
 & 0.74471E+03_JPRB,0.89072E+03_JPRB,0.10326E+04_JPRB,0.11744E+04_JPRB /)  
KA(:, 4, 5,16) = (/ &
 & 0.12756E+03_JPRB,0.23797E+03_JPRB,0.16871E+03_JPRB,0.60625E+03_JPRB,0.35893E+03_JPRB, &
 & 0.73811E+03_JPRB,0.88789E+03_JPRB,0.10294E+04_JPRB,0.11709E+04_JPRB /)  
KA(:, 5, 5,16) = (/ &
 & 0.67577E+03_JPRB,0.67606E+03_JPRB,0.57612E+03_JPRB,0.15439E+03_JPRB,0.22922E+03_JPRB, &
 & 0.66526E+03_JPRB,0.82593E+03_JPRB,0.98621E+03_JPRB,0.11543E+04_JPRB /)  
KA(:, 1, 6,16) = (/ &
 & 0.35294E+03_JPRB,0.92951E+03_JPRB,0.39404E+03_JPRB,0.59466E+03_JPRB,0.46365E+03_JPRB, &
 & 0.75155E+03_JPRB,0.89403E+03_JPRB,0.10365E+04_JPRB,0.11790E+04_JPRB /)  
KA(:, 2, 6,16) = (/ &
 & 0.83494E+03_JPRB,0.91972E+03_JPRB,0.83351E+02_JPRB,0.26459E+03_JPRB,0.33053E+03_JPRB, &
 & 0.75056E+03_JPRB,0.89298E+03_JPRB,0.10296E+04_JPRB,0.11778E+04_JPRB /)  
KA(:, 3, 6,16) = (/ &
 & 0.77495E+02_JPRB,0.67358E+03_JPRB,0.71470E+03_JPRB,0.28985E+03_JPRB,0.12695E+03_JPRB, &
 & 0.74093E+03_JPRB,0.89153E+03_JPRB,0.10338E+04_JPRB,0.11761E+04_JPRB /)  
KA(:, 4, 6,16) = (/ &
 & 0.12524E+04_JPRB,0.52300E+03_JPRB,0.17321E+03_JPRB,0.31958E+03_JPRB,0.15643E+03_JPRB, &
 & 0.74316E+03_JPRB,0.88930E+03_JPRB,0.10313E+04_JPRB,0.11733E+04_JPRB /)  
KA(:, 5, 6,16) = (/ &
 & 0.79880E+03_JPRB,0.54259E+03_JPRB,0.31909E+03_JPRB,0.47791E+03_JPRB,0.45938E+03_JPRB, &
 & 0.74468E+03_JPRB,0.88626E+03_JPRB,0.10278E+04_JPRB,0.11499E+04_JPRB /)  
KA(:, 1, 7,16) = (/ &
 & 0.10078E+04_JPRB,0.83081E+03_JPRB,0.68047E+03_JPRB,0.68284E+03_JPRB,0.57904E+03_JPRB, &
 & 0.75128E+03_JPRB,0.89403E+03_JPRB,0.10368E+04_JPRB,0.11795E+04_JPRB /)  
KA(:, 2, 7,16) = (/ &
 & 0.67323E+03_JPRB,0.10228E+04_JPRB,0.49758E+03_JPRB,0.33578E+03_JPRB,0.38746E+03_JPRB, &
 & 0.75047E+03_JPRB,0.88822E+03_JPRB,0.10359E+04_JPRB,0.11786E+04_JPRB /)  
KA(:, 3, 7,16) = (/ &
 & 0.60358E+03_JPRB,0.41876E+03_JPRB,0.74942E+03_JPRB,0.38757E+03_JPRB,0.61092E+03_JPRB, &
 & 0.74943E+03_JPRB,0.88213E+03_JPRB,0.10289E+04_JPRB,0.11707E+04_JPRB /)  
KA(:, 4, 7,16) = (/ &
 & 0.69109E+03_JPRB,0.11040E+04_JPRB,0.46705E+03_JPRB,0.74628E+03_JPRB,0.47483E+03_JPRB, &
 & 0.74797E+03_JPRB,0.88542E+03_JPRB,0.10328E+04_JPRB,0.11752E+04_JPRB /)  
KA(:, 5, 7,16) = (/ &
 & 0.68277E+03_JPRB,0.46564E+03_JPRB,0.19228E+03_JPRB,0.48854E+03_JPRB,0.28304E+03_JPRB, &
 & 0.74163E+03_JPRB,0.88289E+03_JPRB,0.10299E+04_JPRB,0.11719E+04_JPRB /)  
KA(:, 1, 8,16) = (/ &
 & 0.26685E+03_JPRB,0.60532E+03_JPRB,0.51009E+03_JPRB,0.40907E+03_JPRB,0.39126E+03_JPRB, &
 & 0.74682E+03_JPRB,0.89396E+03_JPRB,0.10369E+04_JPRB,0.11799E+04_JPRB /)  
KA(:, 2, 8,16) = (/ &
 & 0.94869E+03_JPRB,0.11471E+04_JPRB,0.44706E+03_JPRB,0.23151E+03_JPRB,0.93532E+02_JPRB, &
 & 0.75035E+03_JPRB,0.89331E+03_JPRB,0.10363E+04_JPRB,0.11727E+04_JPRB /)  
KA(:, 3, 8,16) = (/ &
 & 0.11588E+04_JPRB,0.74588E+03_JPRB,0.28311E+03_JPRB,0.27864E+03_JPRB,0.32853E+03_JPRB, &
 & 0.74950E+03_JPRB,0.88246E+03_JPRB,0.10352E+04_JPRB,0.11716E+04_JPRB /)  
KA(:, 4, 8,16) = (/ &
 & 0.11874E+04_JPRB,0.47456E+03_JPRB,0.83368E+03_JPRB,0.31591E+03_JPRB,0.30274E+03_JPRB, &
 & 0.74421E+03_JPRB,0.89109E+03_JPRB,0.10338E+04_JPRB,0.11765E+04_JPRB /)  
KA(:, 5, 8,16) = (/ &
 & 0.45710E+03_JPRB,0.66086E+03_JPRB,0.55863E+03_JPRB,0.58037E+03_JPRB,0.20569E+03_JPRB, &
 & 0.73836E+03_JPRB,0.88417E+03_JPRB,0.10316E+04_JPRB,0.11675E+04_JPRB /)  
KA(:, 1, 9,16) = (/ &
 & 0.55233E+03_JPRB,0.18269E+03_JPRB,0.18991E+03_JPRB,0.35964E+03_JPRB,0.38998E+03_JPRB, &
 & 0.75089E+03_JPRB,0.89415E+03_JPRB,0.10374E+04_JPRB,0.11807E+04_JPRB /)  
KA(:, 2, 9,16) = (/ &
 & 0.31819E+03_JPRB,0.14904E+03_JPRB,0.79703E+03_JPRB,0.32317E+03_JPRB,0.20679E+03_JPRB, &
 & 0.75021E+03_JPRB,0.89337E+03_JPRB,0.10308E+04_JPRB,0.11797E+04_JPRB /)  
KA(:, 3, 9,16) = (/ &
 & 0.16059E+03_JPRB,0.37409E+03_JPRB,0.62337E+03_JPRB,0.62951E+03_JPRB,0.47662E+03_JPRB, &
 & 0.74953E+03_JPRB,0.89262E+03_JPRB,0.10357E+04_JPRB,0.11788E+04_JPRB /)  
KA(:, 4, 9,16) = (/ &
 & 0.15191E+03_JPRB,0.63681E+03_JPRB,0.25601E+03_JPRB,0.65772E+03_JPRB,0.38994E+03_JPRB, &
 & 0.74029E+03_JPRB,0.89158E+03_JPRB,0.10346E+04_JPRB,0.11775E+04_JPRB /)  
KA(:, 5, 9,16) = (/ &
 & 0.10392E+04_JPRB,0.33629E+03_JPRB,0.90538E+03_JPRB,0.33435E+03_JPRB,0.46694E+03_JPRB, &
 & 0.74731E+03_JPRB,0.89008E+03_JPRB,0.10329E+04_JPRB,0.11756E+04_JPRB /)  
KA(:, 1,10,16) = (/ &
 & 0.43161E+03_JPRB,0.53194E+03_JPRB,0.82168E+03_JPRB,0.11050E+03_JPRB,0.32159E+02_JPRB, &
 & 0.75101E+03_JPRB,0.89450E+03_JPRB,0.10380E+04_JPRB,0.11815E+04_JPRB /)  
KA(:, 2,10,16) = (/ &
 & 0.23362E+03_JPRB,0.50697E+03_JPRB,0.75913E+03_JPRB,0.37965E+03_JPRB,0.15877E+03_JPRB, &
 & 0.75002E+03_JPRB,0.89333E+03_JPRB,0.10366E+04_JPRB,0.11734E+04_JPRB /)  
KA(:, 3,10,16) = (/ &
 & 0.66577E+03_JPRB,0.22676E+03_JPRB,0.63752E+03_JPRB,0.50488E+03_JPRB,0.52339E+03_JPRB, &
 & 0.74947E+03_JPRB,0.88778E+03_JPRB,0.10360E+04_JPRB,0.11793E+04_JPRB /)  
KA(:, 4,10,16) = (/ &
 & 0.12040E+04_JPRB,0.37222E+03_JPRB,0.71269E+03_JPRB,0.68368E+02_JPRB,0.31445E+03_JPRB, &
 & 0.74453E+03_JPRB,0.88691E+03_JPRB,0.10293E+04_JPRB,0.11782E+04_JPRB /)  
KA(:, 5,10,16) = (/ &
 & 0.85334E+03_JPRB,0.50951E+03_JPRB,0.43397E+03_JPRB,0.11861E+03_JPRB,0.15074E+03_JPRB, &
 & 0.74764E+03_JPRB,0.89065E+03_JPRB,0.10337E+04_JPRB,0.11767E+04_JPRB /)  
KA(:, 1,11,16) = (/ &
 & 0.45853E+03_JPRB,0.29024E+03_JPRB,0.38275E+03_JPRB,0.26130E+03_JPRB,0.12124E+03_JPRB, &
 & 0.75062E+03_JPRB,0.89424E+03_JPRB,0.10379E+04_JPRB,0.11815E+04_JPRB /)  
KA(:, 2,11,16) = (/ &
 & 0.66691E+03_JPRB,0.55656E+03_JPRB,0.39879E+03_JPRB,0.16526E+03_JPRB,0.24675E+03_JPRB, &
 & 0.74965E+03_JPRB,0.89309E+03_JPRB,0.10365E+04_JPRB,0.11800E+04_JPRB /)  
KA(:, 3,11,16) = (/ &
 & 0.10239E+04_JPRB,0.60930E+03_JPRB,0.22001E+03_JPRB,0.10914E+03_JPRB,0.22748E+03_JPRB, &
 & 0.74913E+03_JPRB,0.89251E+03_JPRB,0.10359E+04_JPRB,0.11793E+04_JPRB /)  
KA(:, 4,11,16) = (/ &
 & 0.80567E+03_JPRB,0.90344E+03_JPRB,0.77356E+03_JPRB,0.12489E+03_JPRB,0.55902E+03_JPRB, &
 & 0.74421E+03_JPRB,0.89165E+03_JPRB,0.10349E+04_JPRB,0.11782E+04_JPRB /)  
KA(:, 5,11,16) = (/ &
 & 0.80619E+03_JPRB,0.87963E+03_JPRB,0.47254E+03_JPRB,0.39261E+03_JPRB,0.59752E+03_JPRB, &
 & 0.74319E+03_JPRB,0.88056E+03_JPRB,0.10336E+04_JPRB,0.11767E+04_JPRB /)  
KA(:, 1,12,16) = (/ &
 & 0.54479E+03_JPRB,0.73809E+03_JPRB,0.74534E+03_JPRB,0.30870E+03_JPRB,0.60893E+03_JPRB, &
 & 0.75030E+03_JPRB,0.89402E+03_JPRB,0.10378E+04_JPRB,0.11815E+04_JPRB /)  
KA(:, 2,12,16) = (/ &
 & 0.10600E+04_JPRB,0.76559E+03_JPRB,0.34957E+03_JPRB,0.18602E+03_JPRB,0.60736E+03_JPRB, &
 & 0.74935E+03_JPRB,0.89289E+03_JPRB,0.10307E+04_JPRB,0.11734E+04_JPRB /)  
KA(:, 3,12,16) = (/ &
 & 0.10515E+04_JPRB,0.60079E+03_JPRB,0.43472E+03_JPRB,0.33220E+03_JPRB,0.60582E+03_JPRB, &
 & 0.74885E+03_JPRB,0.89233E+03_JPRB,0.10358E+04_JPRB,0.11793E+04_JPRB /)  
KA(:, 4,12,16) = (/ &
 & 0.32670E+03_JPRB,0.23075E+03_JPRB,0.13581E+03_JPRB,0.17106E+03_JPRB,0.60474E+03_JPRB, &
 & 0.74811E+03_JPRB,0.89148E+03_JPRB,0.10348E+04_JPRB,0.11717E+04_JPRB /)  
KA(:, 5,12,16) = (/ &
 & 0.20371E+03_JPRB,0.68798E+03_JPRB,0.91592E+02_JPRB,0.60316E+03_JPRB,0.60390E+03_JPRB, &
 & 0.74294E+03_JPRB,0.89029E+03_JPRB,0.10335E+04_JPRB,0.11767E+04_JPRB /)  
KA(:, 1,13,16) = (/ &
 & 0.85988E+03_JPRB,0.94717E+03_JPRB,0.84544E+03_JPRB,0.31415E+03_JPRB,0.60500E+03_JPRB, &
 & 0.75003E+03_JPRB,0.89385E+03_JPRB,0.10377E+04_JPRB,0.11815E+04_JPRB /)  
KA(:, 2,13,16) = (/ &
 & 0.10379E+04_JPRB,0.11189E+03_JPRB,0.20733E+03_JPRB,0.17410E+03_JPRB,0.60685E+03_JPRB, &
 & 0.74910E+03_JPRB,0.89272E+03_JPRB,0.10306E+04_JPRB,0.11800E+04_JPRB /)  
KA(:, 3,13,16) = (/ &
 & 0.70206E+03_JPRB,0.77801E+03_JPRB,0.11974E+03_JPRB,0.34591E+03_JPRB,0.60534E+03_JPRB, &
 & 0.74861E+03_JPRB,0.89217E+03_JPRB,0.10357E+04_JPRB,0.11793E+04_JPRB /)  
KA(:, 4,13,16) = (/ &
 & 0.69165E+03_JPRB,0.93369E+03_JPRB,0.16190E+03_JPRB,0.16396E+03_JPRB,0.60445E+03_JPRB, &
 & 0.74789E+03_JPRB,0.89133E+03_JPRB,0.10348E+04_JPRB,0.11782E+04_JPRB /)  
KA(:, 5,13,16) = (/ &
 & 0.20016E+03_JPRB,0.25832E+03_JPRB,0.57797E+03_JPRB,0.24270E+03_JPRB,0.60363E+03_JPRB, &
 & 0.74689E+03_JPRB,0.88521E+03_JPRB,0.10334E+04_JPRB,0.11767E+04_JPRB /)  
  
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART11',1,ZHOOK_HANDLE)
END SUBROUTINE PART11


SUBROUTINE PART12

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART12',0,ZHOOK_HANDLE)


!     -----------------------------------------------------------------
!     The array KB contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KB(:, 1,13, 1) = (/ &
 & 0.27369E+02_JPRB,0.29903E+03_JPRB,0.42924E+03_JPRB,0.31039E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,13, 1) = (/ &
 & 0.27158E+02_JPRB,0.29898E+03_JPRB,0.42745E+03_JPRB,0.30840E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,13, 1) = (/ &
 & 0.26976E+02_JPRB,0.29889E+03_JPRB,0.42590E+03_JPRB,0.30668E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,13, 1) = (/ &
 & 0.26818E+02_JPRB,0.29875E+03_JPRB,0.42455E+03_JPRB,0.30517E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,13, 1) = (/ &
 & 0.26679E+02_JPRB,0.29855E+03_JPRB,0.42335E+03_JPRB,0.30384E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,14, 1) = (/ &
 & 0.26840E+02_JPRB,0.29863E+03_JPRB,0.42474E+03_JPRB,0.30538E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,14, 1) = (/ &
 & 0.26669E+02_JPRB,0.29862E+03_JPRB,0.42327E+03_JPRB,0.30375E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,14, 1) = (/ &
 & 0.26522E+02_JPRB,0.29854E+03_JPRB,0.42199E+03_JPRB,0.30234E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,14, 1) = (/ &
 & 0.26394E+02_JPRB,0.29842E+03_JPRB,0.42088E+03_JPRB,0.30111E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,14, 1) = (/ &
 & 0.26282E+02_JPRB,0.29824E+03_JPRB,0.41990E+03_JPRB,0.30002E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,15, 1) = (/ &
 & 0.26408E+02_JPRB,0.29831E+03_JPRB,0.42100E+03_JPRB,0.30124E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,15, 1) = (/ &
 & 0.26271E+02_JPRB,0.29832E+03_JPRB,0.41980E+03_JPRB,0.29991E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,15, 1) = (/ &
 & 0.26152E+02_JPRB,0.29826E+03_JPRB,0.41876E+03_JPRB,0.29877E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,15, 1) = (/ &
 & 0.26049E+02_JPRB,0.29814E+03_JPRB,0.41785E+03_JPRB,0.29776E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,15, 1) = (/ &
 & 0.25958E+02_JPRB,0.29797E+03_JPRB,0.41705E+03_JPRB,0.29688E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,16, 1) = (/ &
 & 0.26057E+02_JPRB,0.29806E+03_JPRB,0.41793E+03_JPRB,0.29784E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,16, 1) = (/ &
 & 0.25946E+02_JPRB,0.29807E+03_JPRB,0.41695E+03_JPRB,0.29676E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,16, 1) = (/ &
 & 0.25851E+02_JPRB,0.29803E+03_JPRB,0.41610E+03_JPRB,0.29583E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,16, 1) = (/ &
 & 0.25767E+02_JPRB,0.29792E+03_JPRB,0.41536E+03_JPRB,0.29502E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,16, 1) = (/ &
 & 0.25694E+02_JPRB,0.29776E+03_JPRB,0.41470E+03_JPRB,0.29430E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,17, 1) = (/ &
 & 0.25772E+02_JPRB,0.29785E+03_JPRB,0.41540E+03_JPRB,0.29506E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,17, 1) = (/ &
 & 0.25683E+02_JPRB,0.29787E+03_JPRB,0.41460E+03_JPRB,0.29419E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,17, 1) = (/ &
 & 0.25606E+02_JPRB,0.29784E+03_JPRB,0.41391E+03_JPRB,0.29343E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,17, 1) = (/ &
 & 0.25538E+02_JPRB,0.29774E+03_JPRB,0.41331E+03_JPRB,0.29277E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,17, 1) = (/ &
 & 0.25479E+02_JPRB,0.29758E+03_JPRB,0.41278E+03_JPRB,0.29219E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,18, 1) = (/ &
 & 0.25541E+02_JPRB,0.29768E+03_JPRB,0.41334E+03_JPRB,0.29280E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,18, 1) = (/ &
 & 0.25469E+02_JPRB,0.29772E+03_JPRB,0.41269E+03_JPRB,0.29209E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,18, 1) = (/ &
 & 0.25407E+02_JPRB,0.29768E+03_JPRB,0.41213E+03_JPRB,0.29147E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,18, 1) = (/ &
 & 0.25353E+02_JPRB,0.29758E+03_JPRB,0.41163E+03_JPRB,0.29094E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,18, 1) = (/ &
 & 0.25305E+02_JPRB,0.29743E+03_JPRB,0.41120E+03_JPRB,0.29046E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,19, 1) = (/ &
 & 0.25354E+02_JPRB,0.29755E+03_JPRB,0.41165E+03_JPRB,0.29095E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,19, 1) = (/ &
 & 0.25296E+02_JPRB,0.29758E+03_JPRB,0.41112E+03_JPRB,0.29037E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,19, 1) = (/ &
 & 0.25245E+02_JPRB,0.29755E+03_JPRB,0.41067E+03_JPRB,0.28988E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,19, 1) = (/ &
 & 0.25201E+02_JPRB,0.29746E+03_JPRB,0.41027E+03_JPRB,0.28944E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,19, 1) = (/ &
 & 0.25163E+02_JPRB,0.29730E+03_JPRB,0.40991E+03_JPRB,0.28905E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,20, 1) = (/ &
 & 0.25201E+02_JPRB,0.29744E+03_JPRB,0.41026E+03_JPRB,0.28943E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,20, 1) = (/ &
 & 0.25154E+02_JPRB,0.29748E+03_JPRB,0.40984E+03_JPRB,0.28897E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,20, 1) = (/ &
 & 0.25113E+02_JPRB,0.29745E+03_JPRB,0.40947E+03_JPRB,0.28856E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,20, 1) = (/ &
 & 0.25078E+02_JPRB,0.29735E+03_JPRB,0.40914E+03_JPRB,0.28821E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,20, 1) = (/ &
 & 0.25047E+02_JPRB,0.29719E+03_JPRB,0.40886E+03_JPRB,0.28790E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,21, 1) = (/ &
 & 0.25076E+02_JPRB,0.29736E+03_JPRB,0.40913E+03_JPRB,0.28819E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,21, 1) = (/ &
 & 0.25039E+02_JPRB,0.29739E+03_JPRB,0.40879E+03_JPRB,0.28782E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,21, 1) = (/ &
 & 0.25006E+02_JPRB,0.29736E+03_JPRB,0.40849E+03_JPRB,0.28749E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,21, 1) = (/ &
 & 0.24978E+02_JPRB,0.29726E+03_JPRB,0.40823E+03_JPRB,0.28722E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,21, 1) = (/ &
 & 0.24952E+02_JPRB,0.29710E+03_JPRB,0.40800E+03_JPRB,0.28695E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,22, 1) = (/ &
 & 0.24973E+02_JPRB,0.29729E+03_JPRB,0.40819E+03_JPRB,0.28717E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,22, 1) = (/ &
 & 0.24944E+02_JPRB,0.29732E+03_JPRB,0.40792E+03_JPRB,0.28687E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,22, 1) = (/ &
 & 0.24917E+02_JPRB,0.29728E+03_JPRB,0.40768E+03_JPRB,0.28661E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,22, 1) = (/ &
 & 0.24895E+02_JPRB,0.29717E+03_JPRB,0.40747E+03_JPRB,0.28638E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,22, 1) = (/ &
 & 0.24874E+02_JPRB,0.29700E+03_JPRB,0.40728E+03_JPRB,0.28618E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,23, 1) = (/ &
 & 0.24890E+02_JPRB,0.29724E+03_JPRB,0.40743E+03_JPRB,0.28634E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,23, 1) = (/ &
 & 0.24866E+02_JPRB,0.29726E+03_JPRB,0.40721E+03_JPRB,0.28610E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,23, 1) = (/ &
 & 0.24846E+02_JPRB,0.29721E+03_JPRB,0.40702E+03_JPRB,0.28589E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,23, 1) = (/ &
 & 0.24827E+02_JPRB,0.29710E+03_JPRB,0.40685E+03_JPRB,0.28571E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,23, 1) = (/ &
 & 0.24811E+02_JPRB,0.29692E+03_JPRB,0.40671E+03_JPRB,0.28554E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,24, 1) = (/ &
 & 0.24823E+02_JPRB,0.29721E+03_JPRB,0.40681E+03_JPRB,0.28566E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,24, 1) = (/ &
 & 0.24804E+02_JPRB,0.29721E+03_JPRB,0.40664E+03_JPRB,0.28547E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,24, 1) = (/ &
 & 0.24787E+02_JPRB,0.29715E+03_JPRB,0.40649E+03_JPRB,0.28530E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,24, 1) = (/ &
 & 0.24773E+02_JPRB,0.29703E+03_JPRB,0.40635E+03_JPRB,0.28516E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,24, 1) = (/ &
 & 0.24760E+02_JPRB,0.29684E+03_JPRB,0.40623E+03_JPRB,0.28503E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,25, 1) = (/ &
 & 0.24769E+02_JPRB,0.29717E+03_JPRB,0.40631E+03_JPRB,0.28511E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,25, 1) = (/ &
 & 0.24753E+02_JPRB,0.29717E+03_JPRB,0.40618E+03_JPRB,0.28496E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,25, 1) = (/ &
 & 0.24740E+02_JPRB,0.29710E+03_JPRB,0.40606E+03_JPRB,0.28483E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,25, 1) = (/ &
 & 0.24729E+02_JPRB,0.29696E+03_JPRB,0.40595E+03_JPRB,0.28472E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,25, 1) = (/ &
 & 0.24718E+02_JPRB,0.29676E+03_JPRB,0.40585E+03_JPRB,0.28462E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,26, 1) = (/ &
 & 0.24724E+02_JPRB,0.29715E+03_JPRB,0.40591E+03_JPRB,0.28467E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,26, 1) = (/ &
 & 0.24712E+02_JPRB,0.29713E+03_JPRB,0.40580E+03_JPRB,0.28456E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,26, 1) = (/ &
 & 0.24702E+02_JPRB,0.29704E+03_JPRB,0.40570E+03_JPRB,0.28445E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,26, 1) = (/ &
 & 0.24693E+02_JPRB,0.29689E+03_JPRB,0.40562E+03_JPRB,0.28435E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,26, 1) = (/ &
 & 0.24684E+02_JPRB,0.29668E+03_JPRB,0.40554E+03_JPRB,0.28427E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,27, 1) = (/ &
 & 0.24689E+02_JPRB,0.29713E+03_JPRB,0.40558E+03_JPRB,0.28431E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,27, 1) = (/ &
 & 0.24679E+02_JPRB,0.29709E+03_JPRB,0.40550E+03_JPRB,0.28422E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,27, 1) = (/ &
 & 0.24671E+02_JPRB,0.29699E+03_JPRB,0.40542E+03_JPRB,0.28423E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,27, 1) = (/ &
 & 0.24664E+02_JPRB,0.29683E+03_JPRB,0.40535E+03_JPRB,0.28405E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,27, 1) = (/ &
 & 0.24657E+02_JPRB,0.29660E+03_JPRB,0.40529E+03_JPRB,0.28399E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,28, 1) = (/ &
 & 0.24660E+02_JPRB,0.29710E+03_JPRB,0.40532E+03_JPRB,0.28404E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,28, 1) = (/ &
 & 0.24653E+02_JPRB,0.29706E+03_JPRB,0.40525E+03_JPRB,0.28395E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,28, 1) = (/ &
 & 0.24646E+02_JPRB,0.29694E+03_JPRB,0.40519E+03_JPRB,0.28389E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,28, 1) = (/ &
 & 0.24640E+02_JPRB,0.29676E+03_JPRB,0.40514E+03_JPRB,0.28383E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,28, 1) = (/ &
 & 0.24635E+02_JPRB,0.29651E+03_JPRB,0.40509E+03_JPRB,0.28376E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,29, 1) = (/ &
 & 0.24637E+02_JPRB,0.29708E+03_JPRB,0.40511E+03_JPRB,0.28380E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,29, 1) = (/ &
 & 0.24631E+02_JPRB,0.29702E+03_JPRB,0.40505E+03_JPRB,0.28374E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,29, 1) = (/ &
 & 0.24626E+02_JPRB,0.29689E+03_JPRB,0.40500E+03_JPRB,0.28368E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,29, 1) = (/ &
 & 0.24621E+02_JPRB,0.29669E+03_JPRB,0.40496E+03_JPRB,0.28364E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,29, 1) = (/ &
 & 0.24617E+02_JPRB,0.29643E+03_JPRB,0.40492E+03_JPRB,0.28359E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,30, 1) = (/ &
 & 0.24619E+02_JPRB,0.29706E+03_JPRB,0.40494E+03_JPRB,0.28360E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,30, 1) = (/ &
 & 0.24614E+02_JPRB,0.29698E+03_JPRB,0.40489E+03_JPRB,0.28355E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,30, 1) = (/ &
 & 0.24610E+02_JPRB,0.29683E+03_JPRB,0.40485E+03_JPRB,0.28351E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,30, 1) = (/ &
 & 0.24606E+02_JPRB,0.29662E+03_JPRB,0.40482E+03_JPRB,0.28347E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,30, 1) = (/ &
 & 0.24603E+02_JPRB,0.29634E+03_JPRB,0.40479E+03_JPRB,0.28344E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,31, 1) = (/ &
 & 0.24604E+02_JPRB,0.29704E+03_JPRB,0.40480E+03_JPRB,0.28345E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,31, 1) = (/ &
 & 0.24600E+02_JPRB,0.29694E+03_JPRB,0.40477E+03_JPRB,0.28341E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,31, 1) = (/ &
 & 0.24597E+02_JPRB,0.29678E+03_JPRB,0.40473E+03_JPRB,0.28338E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,31, 1) = (/ &
 & 0.24594E+02_JPRB,0.29655E+03_JPRB,0.40471E+03_JPRB,0.28336E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,31, 1) = (/ &
 & 0.24591E+02_JPRB,0.29625E+03_JPRB,0.40468E+03_JPRB,0.28332E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,32, 1) = (/ &
 & 0.24592E+02_JPRB,0.29701E+03_JPRB,0.40469E+03_JPRB,0.28333E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,32, 1) = (/ &
 & 0.24589E+02_JPRB,0.29689E+03_JPRB,0.40466E+03_JPRB,0.28330E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,32, 1) = (/ &
 & 0.24586E+02_JPRB,0.29672E+03_JPRB,0.40464E+03_JPRB,0.28328E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,32, 1) = (/ &
 & 0.24584E+02_JPRB,0.29647E+03_JPRB,0.40461E+03_JPRB,0.28324E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,32, 1) = (/ &
 & 0.24582E+02_JPRB,0.29615E+03_JPRB,0.40459E+03_JPRB,0.28325E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,33, 1) = (/ &
 & 0.24582E+02_JPRB,0.29698E+03_JPRB,0.40460E+03_JPRB,0.28323E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,33, 1) = (/ &
 & 0.24580E+02_JPRB,0.29685E+03_JPRB,0.40458E+03_JPRB,0.28321E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,33, 1) = (/ &
 & 0.24578E+02_JPRB,0.29665E+03_JPRB,0.40456E+03_JPRB,0.28318E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,33, 1) = (/ &
 & 0.24576E+02_JPRB,0.29639E+03_JPRB,0.40454E+03_JPRB,0.28317E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,33, 1) = (/ &
 & 0.24574E+02_JPRB,0.29605E+03_JPRB,0.40452E+03_JPRB,0.28315E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,34, 1) = (/ &
 & 0.24574E+02_JPRB,0.29695E+03_JPRB,0.40453E+03_JPRB,0.28315E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,34, 1) = (/ &
 & 0.24572E+02_JPRB,0.29680E+03_JPRB,0.40451E+03_JPRB,0.28313E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,34, 1) = (/ &
 & 0.24571E+02_JPRB,0.29659E+03_JPRB,0.40449E+03_JPRB,0.28312E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,34, 1) = (/ &
 & 0.24569E+02_JPRB,0.29631E+03_JPRB,0.40448E+03_JPRB,0.28310E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,34, 1) = (/ &
 & 0.24568E+02_JPRB,0.29596E+03_JPRB,0.40447E+03_JPRB,0.28308E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,35, 1) = (/ &
 & 0.24568E+02_JPRB,0.29693E+03_JPRB,0.40447E+03_JPRB,0.28309E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,35, 1) = (/ &
 & 0.24567E+02_JPRB,0.29678E+03_JPRB,0.40446E+03_JPRB,0.28308E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,35, 1) = (/ &
 & 0.24565E+02_JPRB,0.29656E+03_JPRB,0.40444E+03_JPRB,0.28306E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,35, 1) = (/ &
 & 0.24564E+02_JPRB,0.29627E+03_JPRB,0.40443E+03_JPRB,0.28305E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,35, 1) = (/ &
 & 0.24563E+02_JPRB,0.29590E+03_JPRB,0.40442E+03_JPRB,0.28304E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,36, 1) = (/ &
 & 0.24563E+02_JPRB,0.29692E+03_JPRB,0.40443E+03_JPRB,0.28305E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,36, 1) = (/ &
 & 0.24562E+02_JPRB,0.29677E+03_JPRB,0.40442E+03_JPRB,0.28304E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,36, 1) = (/ &
 & 0.24561E+02_JPRB,0.29655E+03_JPRB,0.40440E+03_JPRB,0.28301E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,36, 1) = (/ &
 & 0.24560E+02_JPRB,0.29626E+03_JPRB,0.40440E+03_JPRB,0.28302E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,36, 1) = (/ &
 & 0.24559E+02_JPRB,0.29589E+03_JPRB,0.40439E+03_JPRB,0.28301E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,37, 1) = (/ &
 & 0.24560E+02_JPRB,0.29693E+03_JPRB,0.40439E+03_JPRB,0.28301E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,37, 1) = (/ &
 & 0.24559E+02_JPRB,0.29679E+03_JPRB,0.40438E+03_JPRB,0.28299E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,37, 1) = (/ &
 & 0.24558E+02_JPRB,0.29658E+03_JPRB,0.40437E+03_JPRB,0.28299E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,37, 1) = (/ &
 & 0.24557E+02_JPRB,0.29630E+03_JPRB,0.40437E+03_JPRB,0.28297E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,37, 1) = (/ &
 & 0.24556E+02_JPRB,0.29594E+03_JPRB,0.40436E+03_JPRB,0.28297E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,38, 1) = (/ &
 & 0.24557E+02_JPRB,0.29695E+03_JPRB,0.40436E+03_JPRB,0.28297E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,38, 1) = (/ &
 & 0.24556E+02_JPRB,0.29681E+03_JPRB,0.40436E+03_JPRB,0.28296E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,38, 1) = (/ &
 & 0.24555E+02_JPRB,0.29661E+03_JPRB,0.40435E+03_JPRB,0.28297E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,38, 1) = (/ &
 & 0.24554E+02_JPRB,0.29634E+03_JPRB,0.40434E+03_JPRB,0.28296E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,38, 1) = (/ &
 & 0.24554E+02_JPRB,0.29599E+03_JPRB,0.40434E+03_JPRB,0.28294E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,39, 1) = (/ &
 & 0.24554E+02_JPRB,0.29696E+03_JPRB,0.40434E+03_JPRB,0.28295E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,39, 1) = (/ &
 & 0.24553E+02_JPRB,0.29683E+03_JPRB,0.40433E+03_JPRB,0.28294E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,39, 1) = (/ &
 & 0.24553E+02_JPRB,0.29664E+03_JPRB,0.40433E+03_JPRB,0.28293E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,39, 1) = (/ &
 & 0.24552E+02_JPRB,0.29638E+03_JPRB,0.40432E+03_JPRB,0.28292E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,39, 1) = (/ &
 & 0.24552E+02_JPRB,0.29604E+03_JPRB,0.40432E+03_JPRB,0.28292E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,40, 1) = (/ &
 & 0.24552E+02_JPRB,0.29698E+03_JPRB,0.40432E+03_JPRB,0.28292E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,40, 1) = (/ &
 & 0.24551E+02_JPRB,0.29687E+03_JPRB,0.40432E+03_JPRB,0.28293E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,40, 1) = (/ &
 & 0.24551E+02_JPRB,0.29669E+03_JPRB,0.40431E+03_JPRB,0.28292E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,40, 1) = (/ &
 & 0.24550E+02_JPRB,0.29645E+03_JPRB,0.40431E+03_JPRB,0.28291E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,40, 1) = (/ &
 & 0.24550E+02_JPRB,0.29613E+03_JPRB,0.40430E+03_JPRB,0.28291E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,41, 1) = (/ &
 & 0.24550E+02_JPRB,0.29699E+03_JPRB,0.40431E+03_JPRB,0.28290E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,41, 1) = (/ &
 & 0.24550E+02_JPRB,0.29690E+03_JPRB,0.40430E+03_JPRB,0.28291E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,41, 1) = (/ &
 & 0.24549E+02_JPRB,0.29674E+03_JPRB,0.40430E+03_JPRB,0.28289E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,41, 1) = (/ &
 & 0.24549E+02_JPRB,0.29651E+03_JPRB,0.40429E+03_JPRB,0.28290E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,41, 1) = (/ &
 & 0.24549E+02_JPRB,0.29622E+03_JPRB,0.40429E+03_JPRB,0.28289E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,42, 1) = (/ &
 & 0.24549E+02_JPRB,0.29700E+03_JPRB,0.40429E+03_JPRB,0.28289E+03_JPRB,0.35000E+02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART12',1,ZHOOK_HANDLE)
END SUBROUTINE PART12


SUBROUTINE PART13

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART13',0,ZHOOK_HANDLE)


KB(:, 2,42, 1) = (/ &
 & 0.24549E+02_JPRB,0.29693E+03_JPRB,0.40429E+03_JPRB,0.28289E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,42, 1) = (/ &
 & 0.24548E+02_JPRB,0.29679E+03_JPRB,0.40429E+03_JPRB,0.28289E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,42, 1) = (/ &
 & 0.24548E+02_JPRB,0.29658E+03_JPRB,0.40428E+03_JPRB,0.28289E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,42, 1) = (/ &
 & 0.24547E+02_JPRB,0.29630E+03_JPRB,0.40428E+03_JPRB,0.28288E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,43, 1) = (/ &
 & 0.24548E+02_JPRB,0.29701E+03_JPRB,0.40428E+03_JPRB,0.28288E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,43, 1) = (/ &
 & 0.24547E+02_JPRB,0.29696E+03_JPRB,0.40428E+03_JPRB,0.28288E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,43, 1) = (/ &
 & 0.24547E+02_JPRB,0.29684E+03_JPRB,0.40428E+03_JPRB,0.28288E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,43, 1) = (/ &
 & 0.24547E+02_JPRB,0.29665E+03_JPRB,0.40427E+03_JPRB,0.28288E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,43, 1) = (/ &
 & 0.24547E+02_JPRB,0.29639E+03_JPRB,0.40427E+03_JPRB,0.28288E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,44, 1) = (/ &
 & 0.24547E+02_JPRB,0.29702E+03_JPRB,0.40427E+03_JPRB,0.28287E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,44, 1) = (/ &
 & 0.24547E+02_JPRB,0.29698E+03_JPRB,0.40427E+03_JPRB,0.28287E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,44, 1) = (/ &
 & 0.24546E+02_JPRB,0.29688E+03_JPRB,0.40427E+03_JPRB,0.28287E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,44, 1) = (/ &
 & 0.24546E+02_JPRB,0.29672E+03_JPRB,0.40427E+03_JPRB,0.28287E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,44, 1) = (/ &
 & 0.24546E+02_JPRB,0.29649E+03_JPRB,0.40426E+03_JPRB,0.28286E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,45, 1) = (/ &
 & 0.24546E+02_JPRB,0.29701E+03_JPRB,0.40427E+03_JPRB,0.28287E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,45, 1) = (/ &
 & 0.24546E+02_JPRB,0.29700E+03_JPRB,0.40426E+03_JPRB,0.28287E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,45, 1) = (/ &
 & 0.24546E+02_JPRB,0.29692E+03_JPRB,0.40426E+03_JPRB,0.28286E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,45, 1) = (/ &
 & 0.24545E+02_JPRB,0.29678E+03_JPRB,0.40426E+03_JPRB,0.28286E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,45, 1) = (/ &
 & 0.24545E+02_JPRB,0.29657E+03_JPRB,0.40426E+03_JPRB,0.28286E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,46, 1) = (/ &
 & 0.24545E+02_JPRB,0.29699E+03_JPRB,0.40426E+03_JPRB,0.28287E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,46, 1) = (/ &
 & 0.24545E+02_JPRB,0.29701E+03_JPRB,0.40426E+03_JPRB,0.28285E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,46, 1) = (/ &
 & 0.24545E+02_JPRB,0.29696E+03_JPRB,0.40426E+03_JPRB,0.28286E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,46, 1) = (/ &
 & 0.24545E+02_JPRB,0.29684E+03_JPRB,0.40425E+03_JPRB,0.28285E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,46, 1) = (/ &
 & 0.24545E+02_JPRB,0.29665E+03_JPRB,0.40425E+03_JPRB,0.28285E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,47, 1) = (/ &
 & 0.24545E+02_JPRB,0.29696E+03_JPRB,0.40425E+03_JPRB,0.28285E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,47, 1) = (/ &
 & 0.24545E+02_JPRB,0.29701E+03_JPRB,0.40425E+03_JPRB,0.28286E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,47, 1) = (/ &
 & 0.24544E+02_JPRB,0.29699E+03_JPRB,0.40425E+03_JPRB,0.28285E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,47, 1) = (/ &
 & 0.24544E+02_JPRB,0.29690E+03_JPRB,0.40425E+03_JPRB,0.28285E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,47, 1) = (/ &
 & 0.24544E+02_JPRB,0.29674E+03_JPRB,0.40425E+03_JPRB,0.28286E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,48, 1) = (/ &
 & 0.24544E+02_JPRB,0.29691E+03_JPRB,0.40425E+03_JPRB,0.28286E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,48, 1) = (/ &
 & 0.24544E+02_JPRB,0.29700E+03_JPRB,0.40425E+03_JPRB,0.28285E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,48, 1) = (/ &
 & 0.24544E+02_JPRB,0.29701E+03_JPRB,0.40425E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,48, 1) = (/ &
 & 0.24544E+02_JPRB,0.29694E+03_JPRB,0.40425E+03_JPRB,0.28285E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,48, 1) = (/ &
 & 0.24544E+02_JPRB,0.29681E+03_JPRB,0.40425E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,49, 1) = (/ &
 & 0.24544E+02_JPRB,0.29685E+03_JPRB,0.40425E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,49, 1) = (/ &
 & 0.24544E+02_JPRB,0.29698E+03_JPRB,0.40425E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,49, 1) = (/ &
 & 0.24544E+02_JPRB,0.29701E+03_JPRB,0.40424E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,49, 1) = (/ &
 & 0.24544E+02_JPRB,0.29697E+03_JPRB,0.40424E+03_JPRB,0.28285E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,49, 1) = (/ &
 & 0.24544E+02_JPRB,0.29687E+03_JPRB,0.40424E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,50, 1) = (/ &
 & 0.24544E+02_JPRB,0.29678E+03_JPRB,0.40424E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,50, 1) = (/ &
 & 0.24544E+02_JPRB,0.29694E+03_JPRB,0.40424E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,50, 1) = (/ &
 & 0.24543E+02_JPRB,0.29701E+03_JPRB,0.40424E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,50, 1) = (/ &
 & 0.24543E+02_JPRB,0.29700E+03_JPRB,0.40424E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,50, 1) = (/ &
 & 0.24543E+02_JPRB,0.29692E+03_JPRB,0.40424E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,51, 1) = (/ &
 & 0.24543E+02_JPRB,0.29670E+03_JPRB,0.40424E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,51, 1) = (/ &
 & 0.24543E+02_JPRB,0.29689E+03_JPRB,0.40424E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,51, 1) = (/ &
 & 0.24543E+02_JPRB,0.29699E+03_JPRB,0.40424E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,51, 1) = (/ &
 & 0.24543E+02_JPRB,0.29701E+03_JPRB,0.40424E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,51, 1) = (/ &
 & 0.24543E+02_JPRB,0.29695E+03_JPRB,0.40424E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,52, 1) = (/ &
 & 0.24543E+02_JPRB,0.29660E+03_JPRB,0.40424E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,52, 1) = (/ &
 & 0.24543E+02_JPRB,0.29684E+03_JPRB,0.40424E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,52, 1) = (/ &
 & 0.24543E+02_JPRB,0.29697E+03_JPRB,0.40424E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,52, 1) = (/ &
 & 0.24543E+02_JPRB,0.29701E+03_JPRB,0.40424E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,52, 1) = (/ &
 & 0.24543E+02_JPRB,0.29698E+03_JPRB,0.40424E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,53, 1) = (/ &
 & 0.24543E+02_JPRB,0.29648E+03_JPRB,0.40424E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,53, 1) = (/ &
 & 0.24543E+02_JPRB,0.29676E+03_JPRB,0.40424E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,53, 1) = (/ &
 & 0.24543E+02_JPRB,0.29693E+03_JPRB,0.40424E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,53, 1) = (/ &
 & 0.24543E+02_JPRB,0.29701E+03_JPRB,0.40424E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,53, 1) = (/ &
 & 0.24543E+02_JPRB,0.29700E+03_JPRB,0.40424E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,54, 1) = (/ &
 & 0.24543E+02_JPRB,0.29635E+03_JPRB,0.40424E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,54, 1) = (/ &
 & 0.24543E+02_JPRB,0.29668E+03_JPRB,0.40424E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,54, 1) = (/ &
 & 0.24543E+02_JPRB,0.29688E+03_JPRB,0.40424E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,54, 1) = (/ &
 & 0.24543E+02_JPRB,0.29699E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,54, 1) = (/ &
 & 0.24543E+02_JPRB,0.29701E+03_JPRB,0.40423E+03_JPRB,0.28285E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,55, 1) = (/ &
 & 0.24543E+02_JPRB,0.29622E+03_JPRB,0.40424E+03_JPRB,0.28285E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,55, 1) = (/ &
 & 0.24543E+02_JPRB,0.29659E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,55, 1) = (/ &
 & 0.24543E+02_JPRB,0.29683E+03_JPRB,0.40423E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,55, 1) = (/ &
 & 0.24543E+02_JPRB,0.29696E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,55, 1) = (/ &
 & 0.24543E+02_JPRB,0.29701E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,56, 1) = (/ &
 & 0.24543E+02_JPRB,0.29607E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,56, 1) = (/ &
 & 0.24543E+02_JPRB,0.29649E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,56, 1) = (/ &
 & 0.24543E+02_JPRB,0.29676E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,56, 1) = (/ &
 & 0.24542E+02_JPRB,0.29693E+03_JPRB,0.40423E+03_JPRB,0.28282E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,56, 1) = (/ &
 & 0.24542E+02_JPRB,0.29700E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,57, 1) = (/ &
 & 0.24543E+02_JPRB,0.29591E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,57, 1) = (/ &
 & 0.24542E+02_JPRB,0.29637E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,57, 1) = (/ &
 & 0.24542E+02_JPRB,0.29669E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,57, 1) = (/ &
 & 0.24542E+02_JPRB,0.29689E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,57, 1) = (/ &
 & 0.24542E+02_JPRB,0.29699E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,58, 1) = (/ &
 & 0.24542E+02_JPRB,0.29574E+03_JPRB,0.40423E+03_JPRB,0.28282E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,58, 1) = (/ &
 & 0.24542E+02_JPRB,0.29624E+03_JPRB,0.40423E+03_JPRB,0.28282E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,58, 1) = (/ &
 & 0.24542E+02_JPRB,0.29660E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,58, 1) = (/ &
 & 0.24542E+02_JPRB,0.29684E+03_JPRB,0.40423E+03_JPRB,0.28284E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,58, 1) = (/ &
 & 0.24542E+02_JPRB,0.29697E+03_JPRB,0.40423E+03_JPRB,0.28282E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,59, 1) = (/ &
 & 0.24542E+02_JPRB,0.29566E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 2,59, 1) = (/ &
 & 0.24542E+02_JPRB,0.29619E+03_JPRB,0.40423E+03_JPRB,0.28282E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 3,59, 1) = (/ &
 & 0.24542E+02_JPRB,0.29657E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 4,59, 1) = (/ &
 & 0.24542E+02_JPRB,0.29682E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 5,59, 1) = (/ &
 & 0.24542E+02_JPRB,0.29696E+03_JPRB,0.40423E+03_JPRB,0.28283E+03_JPRB,0.35000E+02_JPRB /)  
KB(:, 1,13, 2) = (/ &
 & 0.10177E+03_JPRB,0.32761E+03_JPRB,0.45575E+03_JPRB,0.31335E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,13, 2) = (/ &
 & 0.10099E+03_JPRB,0.32713E+03_JPRB,0.45383E+03_JPRB,0.31125E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,13, 2) = (/ &
 & 0.10031E+03_JPRB,0.32663E+03_JPRB,0.45216E+03_JPRB,0.30943E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,13, 2) = (/ &
 & 0.99721E+02_JPRB,0.32612E+03_JPRB,0.45071E+03_JPRB,0.30785E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,13, 2) = (/ &
 & 0.99204E+02_JPRB,0.32558E+03_JPRB,0.44942E+03_JPRB,0.30646E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,14, 2) = (/ &
 & 0.99803E+02_JPRB,0.32613E+03_JPRB,0.45091E+03_JPRB,0.30807E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,14, 2) = (/ &
 & 0.99169E+02_JPRB,0.32574E+03_JPRB,0.44934E+03_JPRB,0.30636E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,14, 2) = (/ &
 & 0.98622E+02_JPRB,0.32534E+03_JPRB,0.44797E+03_JPRB,0.30489E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,14, 2) = (/ &
 & 0.98146E+02_JPRB,0.32491E+03_JPRB,0.44677E+03_JPRB,0.30362E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,14, 2) = (/ &
 & 0.97728E+02_JPRB,0.32444E+03_JPRB,0.44571E+03_JPRB,0.30248E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,15, 2) = (/ &
 & 0.98198E+02_JPRB,0.32493E+03_JPRB,0.44690E+03_JPRB,0.30375E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,15, 2) = (/ &
 & 0.97687E+02_JPRB,0.32462E+03_JPRB,0.44560E+03_JPRB,0.30237E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,15, 2) = (/ &
 & 0.97245E+02_JPRB,0.32429E+03_JPRB,0.44448E+03_JPRB,0.30119E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,15, 2) = (/ &
 & 0.96861E+02_JPRB,0.32392E+03_JPRB,0.44350E+03_JPRB,0.30014E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,15, 2) = (/ &
 & 0.96523E+02_JPRB,0.32350E+03_JPRB,0.44263E+03_JPRB,0.29923E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,16, 2) = (/ &
 & 0.96892E+02_JPRB,0.32395E+03_JPRB,0.44358E+03_JPRB,0.30023E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,16, 2) = (/ &
 & 0.96480E+02_JPRB,0.32371E+03_JPRB,0.44252E+03_JPRB,0.29912E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,16, 2) = (/ &
 & 0.96125E+02_JPRB,0.32343E+03_JPRB,0.44161E+03_JPRB,0.29817E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,16, 2) = (/ &
 & 0.95814E+02_JPRB,0.32311E+03_JPRB,0.44081E+03_JPRB,0.29733E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,16, 2) = (/ &
 & 0.95541E+02_JPRB,0.32273E+03_JPRB,0.44010E+03_JPRB,0.29661E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,17, 2) = (/ &
 & 0.95833E+02_JPRB,0.32316E+03_JPRB,0.44086E+03_JPRB,0.29737E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,17, 2) = (/ &
 & 0.95501E+02_JPRB,0.32297E+03_JPRB,0.44000E+03_JPRB,0.29648E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,17, 2) = (/ &
 & 0.95214E+02_JPRB,0.32274E+03_JPRB,0.43925E+03_JPRB,0.29569E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,17, 2) = (/ &
 & 0.94964E+02_JPRB,0.32245E+03_JPRB,0.43860E+03_JPRB,0.29502E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,17, 2) = (/ &
 & 0.94743E+02_JPRB,0.32210E+03_JPRB,0.43803E+03_JPRB,0.29442E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,18, 2) = (/ &
 & 0.94974E+02_JPRB,0.32251E+03_JPRB,0.43863E+03_JPRB,0.29504E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,18, 2) = (/ &
 & 0.94707E+02_JPRB,0.32236E+03_JPRB,0.43793E+03_JPRB,0.29432E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,18, 2) = (/ &
 & 0.94475E+02_JPRB,0.32217E+03_JPRB,0.43733E+03_JPRB,0.29369E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,18, 2) = (/ &
 & 0.94272E+02_JPRB,0.32191E+03_JPRB,0.43680E+03_JPRB,0.29315E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,18, 2) = (/ &
 & 0.94094E+02_JPRB,0.32158E+03_JPRB,0.43633E+03_JPRB,0.29267E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,19, 2) = (/ &
 & 0.94277E+02_JPRB,0.32199E+03_JPRB,0.43681E+03_JPRB,0.29316E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,19, 2) = (/ &
 & 0.94061E+02_JPRB,0.32187E+03_JPRB,0.43624E+03_JPRB,0.29258E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,19, 2) = (/ &
 & 0.93874E+02_JPRB,0.32170E+03_JPRB,0.43575E+03_JPRB,0.29207E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,19, 2) = (/ &
 & 0.93711E+02_JPRB,0.32146E+03_JPRB,0.43532E+03_JPRB,0.29164E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,19, 2) = (/ &
 & 0.93566E+02_JPRB,0.32115E+03_JPRB,0.43494E+03_JPRB,0.29125E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,20, 2) = (/ &
 & 0.93708E+02_JPRB,0.32157E+03_JPRB,0.43531E+03_JPRB,0.29163E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,20, 2) = (/ &
 & 0.93534E+02_JPRB,0.32147E+03_JPRB,0.43485E+03_JPRB,0.29117E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,20, 2) = (/ &
 & 0.93383E+02_JPRB,0.32132E+03_JPRB,0.43445E+03_JPRB,0.29076E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,20, 2) = (/ &
 & 0.93251E+02_JPRB,0.32109E+03_JPRB,0.43411E+03_JPRB,0.29041E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,20, 2) = (/ &
 & 0.93135E+02_JPRB,0.32079E+03_JPRB,0.43380E+03_JPRB,0.29010E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,21, 2) = (/ &
 & 0.93246E+02_JPRB,0.32122E+03_JPRB,0.43409E+03_JPRB,0.29040E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,21, 2) = (/ &
 & 0.93106E+02_JPRB,0.32114E+03_JPRB,0.43372E+03_JPRB,0.29003E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,21, 2) = (/ &
 & 0.92985E+02_JPRB,0.32100E+03_JPRB,0.43340E+03_JPRB,0.28970E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,21, 2) = (/ &
 & 0.92878E+02_JPRB,0.32079E+03_JPRB,0.43311E+03_JPRB,0.28941E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,21, 2) = (/ &
 & 0.92784E+02_JPRB,0.32049E+03_JPRB,0.43286E+03_JPRB,0.28917E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,22, 2) = (/ &
 & 0.92863E+02_JPRB,0.32094E+03_JPRB,0.43307E+03_JPRB,0.28938E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,22, 2) = (/ &
 & 0.92751E+02_JPRB,0.32087E+03_JPRB,0.43278E+03_JPRB,0.28908E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,22, 2) = (/ &
 & 0.92655E+02_JPRB,0.32073E+03_JPRB,0.43252E+03_JPRB,0.28882E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,22, 2) = (/ &
 & 0.92569E+02_JPRB,0.32051E+03_JPRB,0.43229E+03_JPRB,0.28860E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,22, 2) = (/ &
 & 0.92494E+02_JPRB,0.32022E+03_JPRB,0.43209E+03_JPRB,0.28840E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,23, 2) = (/ &
 & 0.92553E+02_JPRB,0.32072E+03_JPRB,0.43225E+03_JPRB,0.28855E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,23, 2) = (/ &
 & 0.92465E+02_JPRB,0.32064E+03_JPRB,0.43201E+03_JPRB,0.28832E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,23, 2) = (/ &
 & 0.92387E+02_JPRB,0.32050E+03_JPRB,0.43180E+03_JPRB,0.28811E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,23, 2) = (/ &
 & 0.92319E+02_JPRB,0.32029E+03_JPRB,0.43162E+03_JPRB,0.28793E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,23, 2) = (/ &
 & 0.92259E+02_JPRB,0.31998E+03_JPRB,0.43146E+03_JPRB,0.28778E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,24, 2) = (/ &
 & 0.92303E+02_JPRB,0.32053E+03_JPRB,0.43158E+03_JPRB,0.28789E+03_JPRB,0.71839E+02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART13',1,ZHOOK_HANDLE)
END SUBROUTINE PART13


SUBROUTINE PART14

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART14',0,ZHOOK_HANDLE)


KB(:, 2,24, 2) = (/ &
 & 0.92233E+02_JPRB,0.32046E+03_JPRB,0.43139E+03_JPRB,0.28770E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,24, 2) = (/ &
 & 0.92171E+02_JPRB,0.32031E+03_JPRB,0.43122E+03_JPRB,0.28754E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,24, 2) = (/ &
 & 0.92117E+02_JPRB,0.32009E+03_JPRB,0.43108E+03_JPRB,0.28740E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,24, 2) = (/ &
 & 0.92068E+02_JPRB,0.31978E+03_JPRB,0.43095E+03_JPRB,0.28727E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,25, 2) = (/ &
 & 0.92101E+02_JPRB,0.32038E+03_JPRB,0.43103E+03_JPRB,0.28736E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,25, 2) = (/ &
 & 0.92045E+02_JPRB,0.32030E+03_JPRB,0.43088E+03_JPRB,0.28721E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,25, 2) = (/ &
 & 0.91996E+02_JPRB,0.32015E+03_JPRB,0.43075E+03_JPRB,0.28708E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,25, 2) = (/ &
 & 0.91952E+02_JPRB,0.31991E+03_JPRB,0.43064E+03_JPRB,0.28696E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,25, 2) = (/ &
 & 0.91914E+02_JPRB,0.31959E+03_JPRB,0.43053E+03_JPRB,0.28684E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,26, 2) = (/ &
 & 0.91937E+02_JPRB,0.32025E+03_JPRB,0.43059E+03_JPRB,0.28693E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,26, 2) = (/ &
 & 0.91892E+02_JPRB,0.32016E+03_JPRB,0.43047E+03_JPRB,0.28680E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,26, 2) = (/ &
 & 0.91853E+02_JPRB,0.32000E+03_JPRB,0.43037E+03_JPRB,0.28670E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,26, 2) = (/ &
 & 0.91819E+02_JPRB,0.31975E+03_JPRB,0.43028E+03_JPRB,0.28661E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,26, 2) = (/ &
 & 0.91788E+02_JPRB,0.31942E+03_JPRB,0.43019E+03_JPRB,0.28653E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,27, 2) = (/ &
 & 0.91805E+02_JPRB,0.32015E+03_JPRB,0.43024E+03_JPRB,0.28658E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,27, 2) = (/ &
 & 0.91770E+02_JPRB,0.32005E+03_JPRB,0.43014E+03_JPRB,0.28648E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,27, 2) = (/ &
 & 0.91738E+02_JPRB,0.31986E+03_JPRB,0.43006E+03_JPRB,0.28630E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,27, 2) = (/ &
 & 0.91711E+02_JPRB,0.31960E+03_JPRB,0.42998E+03_JPRB,0.28633E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,27, 2) = (/ &
 & 0.91687E+02_JPRB,0.31925E+03_JPRB,0.42992E+03_JPRB,0.28626E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,28, 2) = (/ &
 & 0.91698E+02_JPRB,0.32005E+03_JPRB,0.42995E+03_JPRB,0.28628E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,28, 2) = (/ &
 & 0.91670E+02_JPRB,0.31994E+03_JPRB,0.42987E+03_JPRB,0.28622E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,28, 2) = (/ &
 & 0.91646E+02_JPRB,0.31974E+03_JPRB,0.42981E+03_JPRB,0.28615E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,28, 2) = (/ &
 & 0.91624E+02_JPRB,0.31946E+03_JPRB,0.42975E+03_JPRB,0.28609E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,28, 2) = (/ &
 & 0.91604E+02_JPRB,0.31910E+03_JPRB,0.42970E+03_JPRB,0.28605E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,29, 2) = (/ &
 & 0.91613E+02_JPRB,0.31997E+03_JPRB,0.42972E+03_JPRB,0.28605E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,29, 2) = (/ &
 & 0.91591E+02_JPRB,0.31984E+03_JPRB,0.42966E+03_JPRB,0.28600E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,29, 2) = (/ &
 & 0.91571E+02_JPRB,0.31963E+03_JPRB,0.42960E+03_JPRB,0.28595E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,29, 2) = (/ &
 & 0.91554E+02_JPRB,0.31933E+03_JPRB,0.42956E+03_JPRB,0.28590E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,29, 2) = (/ &
 & 0.91538E+02_JPRB,0.31895E+03_JPRB,0.42952E+03_JPRB,0.28586E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,30, 2) = (/ &
 & 0.91544E+02_JPRB,0.31990E+03_JPRB,0.42953E+03_JPRB,0.28589E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,30, 2) = (/ &
 & 0.91526E+02_JPRB,0.31975E+03_JPRB,0.42948E+03_JPRB,0.28584E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,30, 2) = (/ &
 & 0.91511E+02_JPRB,0.31952E+03_JPRB,0.42944E+03_JPRB,0.28580E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,30, 2) = (/ &
 & 0.91497E+02_JPRB,0.31920E+03_JPRB,0.42940E+03_JPRB,0.28577E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,30, 2) = (/ &
 & 0.91484E+02_JPRB,0.31880E+03_JPRB,0.42937E+03_JPRB,0.28573E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,31, 2) = (/ &
 & 0.91488E+02_JPRB,0.31983E+03_JPRB,0.42938E+03_JPRB,0.28574E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,31, 2) = (/ &
 & 0.91474E+02_JPRB,0.31966E+03_JPRB,0.42934E+03_JPRB,0.28571E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,31, 2) = (/ &
 & 0.91462E+02_JPRB,0.31941E+03_JPRB,0.42931E+03_JPRB,0.28567E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,31, 2) = (/ &
 & 0.91451E+02_JPRB,0.31908E+03_JPRB,0.42928E+03_JPRB,0.28564E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,31, 2) = (/ &
 & 0.91441E+02_JPRB,0.31866E+03_JPRB,0.42925E+03_JPRB,0.28562E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,32, 2) = (/ &
 & 0.91443E+02_JPRB,0.31976E+03_JPRB,0.42926E+03_JPRB,0.28562E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,32, 2) = (/ &
 & 0.91432E+02_JPRB,0.31958E+03_JPRB,0.42923E+03_JPRB,0.28559E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,32, 2) = (/ &
 & 0.91423E+02_JPRB,0.31930E+03_JPRB,0.42920E+03_JPRB,0.28557E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,32, 2) = (/ &
 & 0.91414E+02_JPRB,0.31895E+03_JPRB,0.42918E+03_JPRB,0.28555E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,32, 2) = (/ &
 & 0.91406E+02_JPRB,0.31851E+03_JPRB,0.42916E+03_JPRB,0.28551E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,33, 2) = (/ &
 & 0.91407E+02_JPRB,0.31970E+03_JPRB,0.42916E+03_JPRB,0.28553E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,33, 2) = (/ &
 & 0.91399E+02_JPRB,0.31949E+03_JPRB,0.42914E+03_JPRB,0.28551E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,33, 2) = (/ &
 & 0.91391E+02_JPRB,0.31920E+03_JPRB,0.42912E+03_JPRB,0.28549E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,33, 2) = (/ &
 & 0.91384E+02_JPRB,0.31882E+03_JPRB,0.42910E+03_JPRB,0.28547E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,33, 2) = (/ &
 & 0.91378E+02_JPRB,0.31837E+03_JPRB,0.42908E+03_JPRB,0.28546E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,34, 2) = (/ &
 & 0.91379E+02_JPRB,0.31964E+03_JPRB,0.42908E+03_JPRB,0.28546E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,34, 2) = (/ &
 & 0.91372E+02_JPRB,0.31941E+03_JPRB,0.42906E+03_JPRB,0.28544E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,34, 2) = (/ &
 & 0.91365E+02_JPRB,0.31910E+03_JPRB,0.42905E+03_JPRB,0.28542E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,34, 2) = (/ &
 & 0.91360E+02_JPRB,0.31871E+03_JPRB,0.42903E+03_JPRB,0.28541E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,34, 2) = (/ &
 & 0.91355E+02_JPRB,0.31824E+03_JPRB,0.42902E+03_JPRB,0.28540E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,35, 2) = (/ &
 & 0.91356E+02_JPRB,0.31960E+03_JPRB,0.42902E+03_JPRB,0.28539E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,35, 2) = (/ &
 & 0.91350E+02_JPRB,0.31936E+03_JPRB,0.42901E+03_JPRB,0.28538E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,35, 2) = (/ &
 & 0.91345E+02_JPRB,0.31904E+03_JPRB,0.42899E+03_JPRB,0.28537E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,35, 2) = (/ &
 & 0.91341E+02_JPRB,0.31863E+03_JPRB,0.42898E+03_JPRB,0.28535E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,35, 2) = (/ &
 & 0.91337E+02_JPRB,0.31816E+03_JPRB,0.42897E+03_JPRB,0.28535E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,36, 2) = (/ &
 & 0.91338E+02_JPRB,0.31958E+03_JPRB,0.42897E+03_JPRB,0.28535E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,36, 2) = (/ &
 & 0.91334E+02_JPRB,0.31934E+03_JPRB,0.42896E+03_JPRB,0.28533E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,36, 2) = (/ &
 & 0.91330E+02_JPRB,0.31902E+03_JPRB,0.42895E+03_JPRB,0.28533E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,36, 2) = (/ &
 & 0.91326E+02_JPRB,0.31862E+03_JPRB,0.42894E+03_JPRB,0.28530E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,36, 2) = (/ &
 & 0.91323E+02_JPRB,0.31814E+03_JPRB,0.42893E+03_JPRB,0.28530E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,37, 2) = (/ &
 & 0.91324E+02_JPRB,0.31959E+03_JPRB,0.42894E+03_JPRB,0.28531E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,37, 2) = (/ &
 & 0.91320E+02_JPRB,0.31937E+03_JPRB,0.42893E+03_JPRB,0.28530E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,37, 2) = (/ &
 & 0.91317E+02_JPRB,0.31906E+03_JPRB,0.42892E+03_JPRB,0.28529E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,37, 2) = (/ &
 & 0.91314E+02_JPRB,0.31866E+03_JPRB,0.42891E+03_JPRB,0.28529E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,37, 2) = (/ &
 & 0.91311E+02_JPRB,0.31819E+03_JPRB,0.42890E+03_JPRB,0.28527E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,38, 2) = (/ &
 & 0.91313E+02_JPRB,0.31961E+03_JPRB,0.42890E+03_JPRB,0.28528E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,38, 2) = (/ &
 & 0.91310E+02_JPRB,0.31939E+03_JPRB,0.42890E+03_JPRB,0.28528E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,38, 2) = (/ &
 & 0.91307E+02_JPRB,0.31910E+03_JPRB,0.42889E+03_JPRB,0.28526E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,38, 2) = (/ &
 & 0.91304E+02_JPRB,0.31871E+03_JPRB,0.42888E+03_JPRB,0.28525E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,38, 2) = (/ &
 & 0.91302E+02_JPRB,0.31826E+03_JPRB,0.42888E+03_JPRB,0.28525E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,39, 2) = (/ &
 & 0.91303E+02_JPRB,0.31962E+03_JPRB,0.42888E+03_JPRB,0.28525E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,39, 2) = (/ &
 & 0.91301E+02_JPRB,0.31942E+03_JPRB,0.42887E+03_JPRB,0.28525E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,39, 2) = (/ &
 & 0.91298E+02_JPRB,0.31914E+03_JPRB,0.42886E+03_JPRB,0.28525E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,39, 2) = (/ &
 & 0.91296E+02_JPRB,0.31877E+03_JPRB,0.42886E+03_JPRB,0.28524E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,39, 2) = (/ &
 & 0.91294E+02_JPRB,0.31832E+03_JPRB,0.42885E+03_JPRB,0.28523E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,40, 2) = (/ &
 & 0.91296E+02_JPRB,0.31965E+03_JPRB,0.42886E+03_JPRB,0.28524E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,40, 2) = (/ &
 & 0.91293E+02_JPRB,0.31947E+03_JPRB,0.42885E+03_JPRB,0.28522E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,40, 2) = (/ &
 & 0.91292E+02_JPRB,0.31921E+03_JPRB,0.42885E+03_JPRB,0.28522E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,40, 2) = (/ &
 & 0.91290E+02_JPRB,0.31886E+03_JPRB,0.42884E+03_JPRB,0.28522E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,40, 2) = (/ &
 & 0.91288E+02_JPRB,0.31843E+03_JPRB,0.42884E+03_JPRB,0.28521E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,41, 2) = (/ &
 & 0.91289E+02_JPRB,0.31968E+03_JPRB,0.42884E+03_JPRB,0.28523E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,41, 2) = (/ &
 & 0.91288E+02_JPRB,0.31952E+03_JPRB,0.42884E+03_JPRB,0.28521E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,41, 2) = (/ &
 & 0.91286E+02_JPRB,0.31928E+03_JPRB,0.42883E+03_JPRB,0.28522E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,41, 2) = (/ &
 & 0.91284E+02_JPRB,0.31895E+03_JPRB,0.42883E+03_JPRB,0.28521E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,41, 2) = (/ &
 & 0.91283E+02_JPRB,0.31854E+03_JPRB,0.42882E+03_JPRB,0.28521E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,42, 2) = (/ &
 & 0.91284E+02_JPRB,0.31970E+03_JPRB,0.42883E+03_JPRB,0.28521E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,42, 2) = (/ &
 & 0.91283E+02_JPRB,0.31957E+03_JPRB,0.42882E+03_JPRB,0.28521E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,42, 2) = (/ &
 & 0.91281E+02_JPRB,0.31934E+03_JPRB,0.42882E+03_JPRB,0.28520E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,42, 2) = (/ &
 & 0.91280E+02_JPRB,0.31904E+03_JPRB,0.42882E+03_JPRB,0.28519E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,42, 2) = (/ &
 & 0.91279E+02_JPRB,0.31865E+03_JPRB,0.42881E+03_JPRB,0.28520E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,43, 2) = (/ &
 & 0.91280E+02_JPRB,0.31972E+03_JPRB,0.42882E+03_JPRB,0.28520E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,43, 2) = (/ &
 & 0.91279E+02_JPRB,0.31961E+03_JPRB,0.42881E+03_JPRB,0.28520E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,43, 2) = (/ &
 & 0.91277E+02_JPRB,0.31942E+03_JPRB,0.42881E+03_JPRB,0.28519E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,43, 2) = (/ &
 & 0.91276E+02_JPRB,0.31914E+03_JPRB,0.42881E+03_JPRB,0.28518E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,43, 2) = (/ &
 & 0.91275E+02_JPRB,0.31878E+03_JPRB,0.42880E+03_JPRB,0.28518E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,44, 2) = (/ &
 & 0.91276E+02_JPRB,0.31974E+03_JPRB,0.42881E+03_JPRB,0.28519E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,44, 2) = (/ &
 & 0.91275E+02_JPRB,0.31966E+03_JPRB,0.42880E+03_JPRB,0.28519E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,44, 2) = (/ &
 & 0.91274E+02_JPRB,0.31949E+03_JPRB,0.42880E+03_JPRB,0.28518E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,44, 2) = (/ &
 & 0.91273E+02_JPRB,0.31924E+03_JPRB,0.42880E+03_JPRB,0.28518E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,44, 2) = (/ &
 & 0.91273E+02_JPRB,0.31890E+03_JPRB,0.42880E+03_JPRB,0.28518E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,45, 2) = (/ &
 & 0.91274E+02_JPRB,0.31974E+03_JPRB,0.42880E+03_JPRB,0.28518E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,45, 2) = (/ &
 & 0.91273E+02_JPRB,0.31969E+03_JPRB,0.42880E+03_JPRB,0.28517E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,45, 2) = (/ &
 & 0.91272E+02_JPRB,0.31955E+03_JPRB,0.42879E+03_JPRB,0.28518E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,45, 2) = (/ &
 & 0.91271E+02_JPRB,0.31933E+03_JPRB,0.42879E+03_JPRB,0.28517E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,45, 2) = (/ &
 & 0.91270E+02_JPRB,0.31903E+03_JPRB,0.42879E+03_JPRB,0.28517E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,46, 2) = (/ &
 & 0.91271E+02_JPRB,0.31974E+03_JPRB,0.42879E+03_JPRB,0.28516E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,46, 2) = (/ &
 & 0.91270E+02_JPRB,0.31972E+03_JPRB,0.42879E+03_JPRB,0.28517E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,46, 2) = (/ &
 & 0.91270E+02_JPRB,0.31961E+03_JPRB,0.42879E+03_JPRB,0.28517E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,46, 2) = (/ &
 & 0.91269E+02_JPRB,0.31942E+03_JPRB,0.42879E+03_JPRB,0.28517E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,46, 2) = (/ &
 & 0.91268E+02_JPRB,0.31914E+03_JPRB,0.42878E+03_JPRB,0.28516E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,47, 2) = (/ &
 & 0.91269E+02_JPRB,0.31973E+03_JPRB,0.42879E+03_JPRB,0.28517E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,47, 2) = (/ &
 & 0.91268E+02_JPRB,0.31974E+03_JPRB,0.42878E+03_JPRB,0.28516E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,47, 2) = (/ &
 & 0.91268E+02_JPRB,0.31966E+03_JPRB,0.42878E+03_JPRB,0.28516E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,47, 2) = (/ &
 & 0.91267E+02_JPRB,0.31951E+03_JPRB,0.42878E+03_JPRB,0.28516E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,47, 2) = (/ &
 & 0.91267E+02_JPRB,0.31926E+03_JPRB,0.42878E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,48, 2) = (/ &
 & 0.91267E+02_JPRB,0.31970E+03_JPRB,0.42878E+03_JPRB,0.28516E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,48, 2) = (/ &
 & 0.91267E+02_JPRB,0.31974E+03_JPRB,0.42878E+03_JPRB,0.28516E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,48, 2) = (/ &
 & 0.91266E+02_JPRB,0.31970E+03_JPRB,0.42878E+03_JPRB,0.28517E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,48, 2) = (/ &
 & 0.91266E+02_JPRB,0.31958E+03_JPRB,0.42878E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,48, 2) = (/ &
 & 0.91265E+02_JPRB,0.31937E+03_JPRB,0.42878E+03_JPRB,0.28516E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,49, 2) = (/ &
 & 0.91266E+02_JPRB,0.31966E+03_JPRB,0.42878E+03_JPRB,0.28516E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,49, 2) = (/ &
 & 0.91265E+02_JPRB,0.31973E+03_JPRB,0.42878E+03_JPRB,0.28516E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,49, 2) = (/ &
 & 0.91265E+02_JPRB,0.31973E+03_JPRB,0.42877E+03_JPRB,0.28516E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,49, 2) = (/ &
 & 0.91265E+02_JPRB,0.31964E+03_JPRB,0.42878E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,49, 2) = (/ &
 & 0.91264E+02_JPRB,0.31946E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,50, 2) = (/ &
 & 0.91265E+02_JPRB,0.31962E+03_JPRB,0.42877E+03_JPRB,0.28516E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,50, 2) = (/ &
 & 0.91264E+02_JPRB,0.31972E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,50, 2) = (/ &
 & 0.91264E+02_JPRB,0.31974E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,50, 2) = (/ &
 & 0.91264E+02_JPRB,0.31968E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,50, 2) = (/ &
 & 0.91263E+02_JPRB,0.31954E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,51, 2) = (/ &
 & 0.91264E+02_JPRB,0.31958E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,51, 2) = (/ &
 & 0.91263E+02_JPRB,0.31969E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,51, 2) = (/ &
 & 0.91263E+02_JPRB,0.31974E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,51, 2) = (/ &
 & 0.91263E+02_JPRB,0.31971E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,51, 2) = (/ &
 & 0.91262E+02_JPRB,0.31960E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,52, 2) = (/ &
 & 0.91263E+02_JPRB,0.31953E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,52, 2) = (/ &
 & 0.91263E+02_JPRB,0.31965E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,52, 2) = (/ &
 & 0.91262E+02_JPRB,0.31973E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,52, 2) = (/ &
 & 0.91262E+02_JPRB,0.31973E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,52, 2) = (/ &
 & 0.91262E+02_JPRB,0.31965E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,53, 2) = (/ &
 & 0.91262E+02_JPRB,0.31948E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART14',1,ZHOOK_HANDLE)
END SUBROUTINE PART14


SUBROUTINE PART15

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART15',0,ZHOOK_HANDLE)


KB(:, 2,53, 2) = (/ &
 & 0.91262E+02_JPRB,0.31961E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,53, 2) = (/ &
 & 0.91262E+02_JPRB,0.31971E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,53, 2) = (/ &
 & 0.91261E+02_JPRB,0.31974E+03_JPRB,0.42876E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,53, 2) = (/ &
 & 0.91261E+02_JPRB,0.31969E+03_JPRB,0.42876E+03_JPRB,0.28514E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,54, 2) = (/ &
 & 0.91262E+02_JPRB,0.31942E+03_JPRB,0.42877E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,54, 2) = (/ &
 & 0.91261E+02_JPRB,0.31957E+03_JPRB,0.42877E+03_JPRB,0.28514E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,54, 2) = (/ &
 & 0.91261E+02_JPRB,0.31968E+03_JPRB,0.42876E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,54, 2) = (/ &
 & 0.91261E+02_JPRB,0.31973E+03_JPRB,0.42876E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,54, 2) = (/ &
 & 0.91261E+02_JPRB,0.31971E+03_JPRB,0.42876E+03_JPRB,0.28513E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,55, 2) = (/ &
 & 0.91261E+02_JPRB,0.31937E+03_JPRB,0.42876E+03_JPRB,0.28513E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,55, 2) = (/ &
 & 0.91261E+02_JPRB,0.31953E+03_JPRB,0.42876E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,55, 2) = (/ &
 & 0.91261E+02_JPRB,0.31965E+03_JPRB,0.42876E+03_JPRB,0.28513E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,55, 2) = (/ &
 & 0.91261E+02_JPRB,0.31973E+03_JPRB,0.42876E+03_JPRB,0.28514E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,55, 2) = (/ &
 & 0.91260E+02_JPRB,0.31973E+03_JPRB,0.42876E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,56, 2) = (/ &
 & 0.91261E+02_JPRB,0.31932E+03_JPRB,0.42876E+03_JPRB,0.28514E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,56, 2) = (/ &
 & 0.91260E+02_JPRB,0.31947E+03_JPRB,0.42876E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,56, 2) = (/ &
 & 0.91260E+02_JPRB,0.31961E+03_JPRB,0.42876E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,56, 2) = (/ &
 & 0.91260E+02_JPRB,0.31971E+03_JPRB,0.42876E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,56, 2) = (/ &
 & 0.91260E+02_JPRB,0.31974E+03_JPRB,0.42876E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,57, 2) = (/ &
 & 0.91260E+02_JPRB,0.31927E+03_JPRB,0.42876E+03_JPRB,0.28514E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,57, 2) = (/ &
 & 0.91260E+02_JPRB,0.31943E+03_JPRB,0.42876E+03_JPRB,0.28514E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,57, 2) = (/ &
 & 0.91260E+02_JPRB,0.31957E+03_JPRB,0.42876E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,57, 2) = (/ &
 & 0.91260E+02_JPRB,0.31968E+03_JPRB,0.42876E+03_JPRB,0.28514E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,57, 2) = (/ &
 & 0.91260E+02_JPRB,0.31974E+03_JPRB,0.42876E+03_JPRB,0.28514E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,58, 2) = (/ &
 & 0.91260E+02_JPRB,0.31922E+03_JPRB,0.42876E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,58, 2) = (/ &
 & 0.91260E+02_JPRB,0.31938E+03_JPRB,0.42876E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,58, 2) = (/ &
 & 0.91260E+02_JPRB,0.31953E+03_JPRB,0.42876E+03_JPRB,0.28514E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,58, 2) = (/ &
 & 0.91260E+02_JPRB,0.31965E+03_JPRB,0.42876E+03_JPRB,0.28513E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,58, 2) = (/ &
 & 0.91260E+02_JPRB,0.31973E+03_JPRB,0.42876E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,59, 2) = (/ &
 & 0.91260E+02_JPRB,0.31920E+03_JPRB,0.42876E+03_JPRB,0.28514E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 2,59, 2) = (/ &
 & 0.91260E+02_JPRB,0.31936E+03_JPRB,0.42876E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 3,59, 2) = (/ &
 & 0.91259E+02_JPRB,0.31952E+03_JPRB,0.42876E+03_JPRB,0.28515E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 4,59, 2) = (/ &
 & 0.91259E+02_JPRB,0.31964E+03_JPRB,0.42876E+03_JPRB,0.28514E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 5,59, 2) = (/ &
 & 0.91259E+02_JPRB,0.31972E+03_JPRB,0.42876E+03_JPRB,0.28514E+03_JPRB,0.71839E+02_JPRB /)  
KB(:, 1,13, 3) = (/ &
 & 0.26463E+03_JPRB,0.36163E+03_JPRB,0.49889E+03_JPRB,0.32504E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,13, 3) = (/ &
 & 0.26258E+03_JPRB,0.36010E+03_JPRB,0.49695E+03_JPRB,0.32345E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,13, 3) = (/ &
 & 0.26083E+03_JPRB,0.35879E+03_JPRB,0.49519E+03_JPRB,0.32209E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,13, 3) = (/ &
 & 0.25930E+03_JPRB,0.35766E+03_JPRB,0.49360E+03_JPRB,0.32093E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,13, 3) = (/ &
 & 0.25795E+03_JPRB,0.35666E+03_JPRB,0.49217E+03_JPRB,0.31991E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,14, 3) = (/ &
 & 0.25951E+03_JPRB,0.35782E+03_JPRB,0.49358E+03_JPRB,0.32109E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,14, 3) = (/ &
 & 0.25786E+03_JPRB,0.35659E+03_JPRB,0.49191E+03_JPRB,0.31984E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,14, 3) = (/ &
 & 0.25644E+03_JPRB,0.35554E+03_JPRB,0.49043E+03_JPRB,0.31877E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,14, 3) = (/ &
 & 0.25520E+03_JPRB,0.35461E+03_JPRB,0.48912E+03_JPRB,0.31784E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,14, 3) = (/ &
 & 0.25411E+03_JPRB,0.35381E+03_JPRB,0.48795E+03_JPRB,0.31704E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,15, 3) = (/ &
 & 0.25534E+03_JPRB,0.35471E+03_JPRB,0.48908E+03_JPRB,0.31794E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,15, 3) = (/ &
 & 0.25401E+03_JPRB,0.35373E+03_JPRB,0.48771E+03_JPRB,0.31695E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,15, 3) = (/ &
 & 0.25286E+03_JPRB,0.35287E+03_JPRB,0.48651E+03_JPRB,0.31610E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,15, 3) = (/ &
 & 0.25186E+03_JPRB,0.35213E+03_JPRB,0.48543E+03_JPRB,0.31537E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,15, 3) = (/ &
 & 0.25098E+03_JPRB,0.35147E+03_JPRB,0.48447E+03_JPRB,0.31472E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,16, 3) = (/ &
 & 0.25194E+03_JPRB,0.35219E+03_JPRB,0.48538E+03_JPRB,0.31543E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,16, 3) = (/ &
 & 0.25087E+03_JPRB,0.35140E+03_JPRB,0.48427E+03_JPRB,0.31463E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,16, 3) = (/ &
 & 0.24994E+03_JPRB,0.35071E+03_JPRB,0.48328E+03_JPRB,0.31395E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,16, 3) = (/ &
 & 0.24914E+03_JPRB,0.35011E+03_JPRB,0.48239E+03_JPRB,0.31337E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,16, 3) = (/ &
 & 0.24843E+03_JPRB,0.34958E+03_JPRB,0.48159E+03_JPRB,0.31282E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,17, 3) = (/ &
 & 0.24919E+03_JPRB,0.35014E+03_JPRB,0.48236E+03_JPRB,0.31341E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,17, 3) = (/ &
 & 0.24832E+03_JPRB,0.34950E+03_JPRB,0.48145E+03_JPRB,0.31278E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,17, 3) = (/ &
 & 0.24758E+03_JPRB,0.34895E+03_JPRB,0.48063E+03_JPRB,0.31225E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,17, 3) = (/ &
 & 0.24693E+03_JPRB,0.34847E+03_JPRB,0.47989E+03_JPRB,0.31178E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,17, 3) = (/ &
 & 0.24635E+03_JPRB,0.34804E+03_JPRB,0.47924E+03_JPRB,0.31137E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,18, 3) = (/ &
 & 0.24695E+03_JPRB,0.34848E+03_JPRB,0.47988E+03_JPRB,0.31180E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,18, 3) = (/ &
 & 0.24626E+03_JPRB,0.34797E+03_JPRB,0.47913E+03_JPRB,0.31130E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,18, 3) = (/ &
 & 0.24565E+03_JPRB,0.34752E+03_JPRB,0.47845E+03_JPRB,0.31086E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,18, 3) = (/ &
 & 0.24513E+03_JPRB,0.34713E+03_JPRB,0.47784E+03_JPRB,0.31048E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,18, 3) = (/ &
 & 0.24466E+03_JPRB,0.34679E+03_JPRB,0.47731E+03_JPRB,0.31015E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,19, 3) = (/ &
 & 0.24514E+03_JPRB,0.34714E+03_JPRB,0.47784E+03_JPRB,0.31049E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,19, 3) = (/ &
 & 0.24458E+03_JPRB,0.34672E+03_JPRB,0.47721E+03_JPRB,0.31009E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,19, 3) = (/ &
 & 0.24409E+03_JPRB,0.34636E+03_JPRB,0.47665E+03_JPRB,0.30974E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,19, 3) = (/ &
 & 0.24367E+03_JPRB,0.34605E+03_JPRB,0.47616E+03_JPRB,0.30943E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,19, 3) = (/ &
 & 0.24329E+03_JPRB,0.34577E+03_JPRB,0.47573E+03_JPRB,0.30916E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,20, 3) = (/ &
 & 0.24366E+03_JPRB,0.34604E+03_JPRB,0.47615E+03_JPRB,0.30943E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,20, 3) = (/ &
 & 0.24321E+03_JPRB,0.34571E+03_JPRB,0.47563E+03_JPRB,0.30910E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,20, 3) = (/ &
 & 0.24282E+03_JPRB,0.34542E+03_JPRB,0.47518E+03_JPRB,0.30882E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,20, 3) = (/ &
 & 0.24247E+03_JPRB,0.34516E+03_JPRB,0.47478E+03_JPRB,0.30857E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,20, 3) = (/ &
 & 0.24217E+03_JPRB,0.34494E+03_JPRB,0.47443E+03_JPRB,0.30835E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,21, 3) = (/ &
 & 0.24246E+03_JPRB,0.34515E+03_JPRB,0.47476E+03_JPRB,0.30856E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,21, 3) = (/ &
 & 0.24210E+03_JPRB,0.34488E+03_JPRB,0.47434E+03_JPRB,0.30830E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,21, 3) = (/ &
 & 0.24178E+03_JPRB,0.34465E+03_JPRB,0.47397E+03_JPRB,0.30807E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,21, 3) = (/ &
 & 0.24150E+03_JPRB,0.34444E+03_JPRB,0.47364E+03_JPRB,0.30787E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,21, 3) = (/ &
 & 0.24126E+03_JPRB,0.34426E+03_JPRB,0.47341E+03_JPRB,0.30769E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,22, 3) = (/ &
 & 0.24146E+03_JPRB,0.34441E+03_JPRB,0.47360E+03_JPRB,0.30784E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,22, 3) = (/ &
 & 0.24117E+03_JPRB,0.34420E+03_JPRB,0.47327E+03_JPRB,0.30763E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,22, 3) = (/ &
 & 0.24092E+03_JPRB,0.34401E+03_JPRB,0.47296E+03_JPRB,0.30745E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,22, 3) = (/ &
 & 0.24070E+03_JPRB,0.34385E+03_JPRB,0.47270E+03_JPRB,0.30729E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,22, 3) = (/ &
 & 0.24050E+03_JPRB,0.34370E+03_JPRB,0.47246E+03_JPRB,0.30715E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,23, 3) = (/ &
 & 0.24066E+03_JPRB,0.34382E+03_JPRB,0.47265E+03_JPRB,0.30726E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,23, 3) = (/ &
 & 0.24043E+03_JPRB,0.34365E+03_JPRB,0.47237E+03_JPRB,0.30709E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,23, 3) = (/ &
 & 0.24023E+03_JPRB,0.34350E+03_JPRB,0.47213E+03_JPRB,0.30695E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,23, 3) = (/ &
 & 0.24005E+03_JPRB,0.34336E+03_JPRB,0.47191E+03_JPRB,0.30682E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,23, 3) = (/ &
 & 0.23989E+03_JPRB,0.34325E+03_JPRB,0.47173E+03_JPRB,0.30671E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,24, 3) = (/ &
 & 0.24001E+03_JPRB,0.34333E+03_JPRB,0.47187E+03_JPRB,0.30679E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,24, 3) = (/ &
 & 0.23982E+03_JPRB,0.34320E+03_JPRB,0.47164E+03_JPRB,0.30666E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,24, 3) = (/ &
 & 0.23966E+03_JPRB,0.34308E+03_JPRB,0.47145E+03_JPRB,0.30654E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,24, 3) = (/ &
 & 0.23952E+03_JPRB,0.34297E+03_JPRB,0.47128E+03_JPRB,0.30644E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,24, 3) = (/ &
 & 0.23940E+03_JPRB,0.34288E+03_JPRB,0.47113E+03_JPRB,0.30635E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,25, 3) = (/ &
 & 0.23948E+03_JPRB,0.34294E+03_JPRB,0.47124E+03_JPRB,0.30641E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,25, 3) = (/ &
 & 0.23934E+03_JPRB,0.34284E+03_JPRB,0.47105E+03_JPRB,0.30631E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,25, 3) = (/ &
 & 0.23921E+03_JPRB,0.34274E+03_JPRB,0.47089E+03_JPRB,0.30622E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,25, 3) = (/ &
 & 0.23910E+03_JPRB,0.34266E+03_JPRB,0.47075E+03_JPRB,0.30613E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,25, 3) = (/ &
 & 0.23900E+03_JPRB,0.34258E+03_JPRB,0.47063E+03_JPRB,0.30606E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,26, 3) = (/ &
 & 0.23906E+03_JPRB,0.34263E+03_JPRB,0.47070E+03_JPRB,0.30610E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,26, 3) = (/ &
 & 0.23894E+03_JPRB,0.34254E+03_JPRB,0.47056E+03_JPRB,0.30602E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,26, 3) = (/ &
 & 0.23884E+03_JPRB,0.34247E+03_JPRB,0.47044E+03_JPRB,0.30595E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,26, 3) = (/ &
 & 0.23875E+03_JPRB,0.34240E+03_JPRB,0.47033E+03_JPRB,0.30588E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,26, 3) = (/ &
 & 0.23867E+03_JPRB,0.34234E+03_JPRB,0.47023E+03_JPRB,0.30583E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,27, 3) = (/ &
 & 0.23871E+03_JPRB,0.34237E+03_JPRB,0.47028E+03_JPRB,0.30586E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,27, 3) = (/ &
 & 0.23862E+03_JPRB,0.34230E+03_JPRB,0.47017E+03_JPRB,0.30579E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,27, 3) = (/ &
 & 0.23854E+03_JPRB,0.34225E+03_JPRB,0.47007E+03_JPRB,0.30573E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,27, 3) = (/ &
 & 0.23847E+03_JPRB,0.34219E+03_JPRB,0.46998E+03_JPRB,0.30568E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,27, 3) = (/ &
 & 0.23840E+03_JPRB,0.34214E+03_JPRB,0.46990E+03_JPRB,0.30564E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,28, 3) = (/ &
 & 0.23844E+03_JPRB,0.34217E+03_JPRB,0.46994E+03_JPRB,0.30566E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,28, 3) = (/ &
 & 0.23836E+03_JPRB,0.34211E+03_JPRB,0.46985E+03_JPRB,0.30561E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,28, 3) = (/ &
 & 0.23830E+03_JPRB,0.34207E+03_JPRB,0.46977E+03_JPRB,0.30556E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,28, 3) = (/ &
 & 0.23824E+03_JPRB,0.34202E+03_JPRB,0.46970E+03_JPRB,0.30552E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,28, 3) = (/ &
 & 0.23819E+03_JPRB,0.34198E+03_JPRB,0.46964E+03_JPRB,0.30548E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,29, 3) = (/ &
 & 0.23821E+03_JPRB,0.34200E+03_JPRB,0.46966E+03_JPRB,0.30550E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,29, 3) = (/ &
 & 0.23815E+03_JPRB,0.34196E+03_JPRB,0.46959E+03_JPRB,0.30546E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,29, 3) = (/ &
 & 0.23810E+03_JPRB,0.34192E+03_JPRB,0.46953E+03_JPRB,0.30542E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,29, 3) = (/ &
 & 0.23806E+03_JPRB,0.34189E+03_JPRB,0.46948E+03_JPRB,0.30539E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,29, 3) = (/ &
 & 0.23802E+03_JPRB,0.34185E+03_JPRB,0.46942E+03_JPRB,0.30536E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,30, 3) = (/ &
 & 0.23803E+03_JPRB,0.34187E+03_JPRB,0.46944E+03_JPRB,0.30537E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,30, 3) = (/ &
 & 0.23799E+03_JPRB,0.34184E+03_JPRB,0.46939E+03_JPRB,0.30533E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,30, 3) = (/ &
 & 0.23795E+03_JPRB,0.34180E+03_JPRB,0.46934E+03_JPRB,0.30531E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,30, 3) = (/ &
 & 0.23791E+03_JPRB,0.34178E+03_JPRB,0.46929E+03_JPRB,0.30528E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,30, 3) = (/ &
 & 0.23788E+03_JPRB,0.34175E+03_JPRB,0.46925E+03_JPRB,0.30526E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,31, 3) = (/ &
 & 0.23789E+03_JPRB,0.34176E+03_JPRB,0.46926E+03_JPRB,0.30526E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,31, 3) = (/ &
 & 0.23785E+03_JPRB,0.34173E+03_JPRB,0.46922E+03_JPRB,0.30524E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,31, 3) = (/ &
 & 0.23782E+03_JPRB,0.34171E+03_JPRB,0.46918E+03_JPRB,0.30521E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,31, 3) = (/ &
 & 0.23779E+03_JPRB,0.34169E+03_JPRB,0.46914E+03_JPRB,0.30519E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,31, 3) = (/ &
 & 0.23777E+03_JPRB,0.34167E+03_JPRB,0.46911E+03_JPRB,0.30518E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,32, 3) = (/ &
 & 0.23777E+03_JPRB,0.34168E+03_JPRB,0.46912E+03_JPRB,0.30518E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,32, 3) = (/ &
 & 0.23774E+03_JPRB,0.34166E+03_JPRB,0.46908E+03_JPRB,0.30516E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,32, 3) = (/ &
 & 0.23772E+03_JPRB,0.34163E+03_JPRB,0.46905E+03_JPRB,0.30514E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,32, 3) = (/ &
 & 0.23770E+03_JPRB,0.34162E+03_JPRB,0.46902E+03_JPRB,0.30512E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,32, 3) = (/ &
 & 0.23767E+03_JPRB,0.34160E+03_JPRB,0.46900E+03_JPRB,0.30511E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,33, 3) = (/ &
 & 0.23768E+03_JPRB,0.34161E+03_JPRB,0.46900E+03_JPRB,0.30511E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,33, 3) = (/ &
 & 0.23766E+03_JPRB,0.34159E+03_JPRB,0.46897E+03_JPRB,0.30510E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,33, 3) = (/ &
 & 0.23764E+03_JPRB,0.34157E+03_JPRB,0.46895E+03_JPRB,0.30508E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,33, 3) = (/ &
 & 0.23762E+03_JPRB,0.34156E+03_JPRB,0.46893E+03_JPRB,0.30507E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,33, 3) = (/ &
 & 0.23760E+03_JPRB,0.34154E+03_JPRB,0.46891E+03_JPRB,0.30506E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,34, 3) = (/ &
 & 0.23760E+03_JPRB,0.34155E+03_JPRB,0.46891E+03_JPRB,0.30506E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,34, 3) = (/ &
 & 0.23759E+03_JPRB,0.34154E+03_JPRB,0.46889E+03_JPRB,0.30505E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,34, 3) = (/ &
 & 0.23757E+03_JPRB,0.34152E+03_JPRB,0.46887E+03_JPRB,0.30503E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,34, 3) = (/ &
 & 0.23756E+03_JPRB,0.34151E+03_JPRB,0.46885E+03_JPRB,0.30502E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,34, 3) = (/ &
 & 0.23754E+03_JPRB,0.34150E+03_JPRB,0.46883E+03_JPRB,0.30501E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,35, 3) = (/ &
 & 0.23755E+03_JPRB,0.34151E+03_JPRB,0.46884E+03_JPRB,0.30502E+03_JPRB,0.17829E+03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART15',1,ZHOOK_HANDLE)
END SUBROUTINE PART15


SUBROUTINE PART16

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART16',0,ZHOOK_HANDLE)


KB(:, 2,35, 3) = (/ &
 & 0.23753E+03_JPRB,0.34150E+03_JPRB,0.46882E+03_JPRB,0.30501E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,35, 3) = (/ &
 & 0.23752E+03_JPRB,0.34148E+03_JPRB,0.46880E+03_JPRB,0.30500E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,35, 3) = (/ &
 & 0.23751E+03_JPRB,0.34147E+03_JPRB,0.46879E+03_JPRB,0.30499E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,35, 3) = (/ &
 & 0.23750E+03_JPRB,0.34146E+03_JPRB,0.46878E+03_JPRB,0.30498E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,36, 3) = (/ &
 & 0.23750E+03_JPRB,0.34147E+03_JPRB,0.46878E+03_JPRB,0.30498E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,36, 3) = (/ &
 & 0.23749E+03_JPRB,0.34146E+03_JPRB,0.46877E+03_JPRB,0.30497E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,36, 3) = (/ &
 & 0.23748E+03_JPRB,0.34145E+03_JPRB,0.46875E+03_JPRB,0.30497E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,36, 3) = (/ &
 & 0.23747E+03_JPRB,0.34144E+03_JPRB,0.46874E+03_JPRB,0.30496E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,36, 3) = (/ &
 & 0.23746E+03_JPRB,0.34144E+03_JPRB,0.46873E+03_JPRB,0.30495E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,37, 3) = (/ &
 & 0.23746E+03_JPRB,0.34145E+03_JPRB,0.46874E+03_JPRB,0.30496E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,37, 3) = (/ &
 & 0.23745E+03_JPRB,0.34144E+03_JPRB,0.46872E+03_JPRB,0.30495E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,37, 3) = (/ &
 & 0.23744E+03_JPRB,0.34143E+03_JPRB,0.46871E+03_JPRB,0.30494E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,37, 3) = (/ &
 & 0.23744E+03_JPRB,0.34142E+03_JPRB,0.46870E+03_JPRB,0.30494E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,37, 3) = (/ &
 & 0.23743E+03_JPRB,0.34141E+03_JPRB,0.46869E+03_JPRB,0.30493E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,38, 3) = (/ &
 & 0.23743E+03_JPRB,0.34143E+03_JPRB,0.46870E+03_JPRB,0.30493E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,38, 3) = (/ &
 & 0.23742E+03_JPRB,0.34142E+03_JPRB,0.46869E+03_JPRB,0.30493E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,38, 3) = (/ &
 & 0.23742E+03_JPRB,0.34141E+03_JPRB,0.46868E+03_JPRB,0.30492E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,38, 3) = (/ &
 & 0.23741E+03_JPRB,0.34140E+03_JPRB,0.46867E+03_JPRB,0.30492E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,38, 3) = (/ &
 & 0.23740E+03_JPRB,0.34140E+03_JPRB,0.46866E+03_JPRB,0.30491E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,39, 3) = (/ &
 & 0.23741E+03_JPRB,0.34141E+03_JPRB,0.46867E+03_JPRB,0.30492E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,39, 3) = (/ &
 & 0.23740E+03_JPRB,0.34140E+03_JPRB,0.46866E+03_JPRB,0.30491E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,39, 3) = (/ &
 & 0.23739E+03_JPRB,0.34139E+03_JPRB,0.46865E+03_JPRB,0.30491E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,39, 3) = (/ &
 & 0.23739E+03_JPRB,0.34139E+03_JPRB,0.46865E+03_JPRB,0.30490E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,39, 3) = (/ &
 & 0.23738E+03_JPRB,0.34138E+03_JPRB,0.46864E+03_JPRB,0.30490E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,40, 3) = (/ &
 & 0.23739E+03_JPRB,0.34139E+03_JPRB,0.46864E+03_JPRB,0.30490E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,40, 3) = (/ &
 & 0.23738E+03_JPRB,0.34139E+03_JPRB,0.46864E+03_JPRB,0.30490E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,40, 3) = (/ &
 & 0.23738E+03_JPRB,0.34138E+03_JPRB,0.46863E+03_JPRB,0.30489E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,40, 3) = (/ &
 & 0.23737E+03_JPRB,0.34138E+03_JPRB,0.46862E+03_JPRB,0.30489E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,40, 3) = (/ &
 & 0.23737E+03_JPRB,0.34137E+03_JPRB,0.46862E+03_JPRB,0.30489E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,41, 3) = (/ &
 & 0.23737E+03_JPRB,0.34138E+03_JPRB,0.46862E+03_JPRB,0.30489E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,41, 3) = (/ &
 & 0.23737E+03_JPRB,0.34138E+03_JPRB,0.46862E+03_JPRB,0.30489E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,41, 3) = (/ &
 & 0.23736E+03_JPRB,0.34137E+03_JPRB,0.46861E+03_JPRB,0.30488E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,41, 3) = (/ &
 & 0.23736E+03_JPRB,0.34137E+03_JPRB,0.46861E+03_JPRB,0.30488E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,41, 3) = (/ &
 & 0.23736E+03_JPRB,0.34136E+03_JPRB,0.46860E+03_JPRB,0.30488E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,42, 3) = (/ &
 & 0.23736E+03_JPRB,0.34137E+03_JPRB,0.46861E+03_JPRB,0.30488E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,42, 3) = (/ &
 & 0.23735E+03_JPRB,0.34137E+03_JPRB,0.46860E+03_JPRB,0.30488E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,42, 3) = (/ &
 & 0.23735E+03_JPRB,0.34136E+03_JPRB,0.46860E+03_JPRB,0.30488E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,42, 3) = (/ &
 & 0.23735E+03_JPRB,0.34136E+03_JPRB,0.46859E+03_JPRB,0.30487E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,42, 3) = (/ &
 & 0.23734E+03_JPRB,0.34135E+03_JPRB,0.46859E+03_JPRB,0.30487E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,43, 3) = (/ &
 & 0.23735E+03_JPRB,0.34136E+03_JPRB,0.46859E+03_JPRB,0.30487E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,43, 3) = (/ &
 & 0.23734E+03_JPRB,0.34136E+03_JPRB,0.46859E+03_JPRB,0.30487E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,43, 3) = (/ &
 & 0.23734E+03_JPRB,0.34136E+03_JPRB,0.46858E+03_JPRB,0.30487E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,43, 3) = (/ &
 & 0.23734E+03_JPRB,0.34135E+03_JPRB,0.46858E+03_JPRB,0.30487E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,43, 3) = (/ &
 & 0.23734E+03_JPRB,0.34135E+03_JPRB,0.46858E+03_JPRB,0.30486E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,44, 3) = (/ &
 & 0.23734E+03_JPRB,0.34136E+03_JPRB,0.46858E+03_JPRB,0.30487E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,44, 3) = (/ &
 & 0.23734E+03_JPRB,0.34135E+03_JPRB,0.46858E+03_JPRB,0.30486E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,44, 3) = (/ &
 & 0.23733E+03_JPRB,0.34135E+03_JPRB,0.46857E+03_JPRB,0.30486E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,44, 3) = (/ &
 & 0.23733E+03_JPRB,0.34135E+03_JPRB,0.46857E+03_JPRB,0.30486E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,44, 3) = (/ &
 & 0.23733E+03_JPRB,0.34134E+03_JPRB,0.46857E+03_JPRB,0.30486E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,45, 3) = (/ &
 & 0.23733E+03_JPRB,0.34135E+03_JPRB,0.46857E+03_JPRB,0.30486E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,45, 3) = (/ &
 & 0.23733E+03_JPRB,0.34135E+03_JPRB,0.46857E+03_JPRB,0.30486E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,45, 3) = (/ &
 & 0.23733E+03_JPRB,0.34135E+03_JPRB,0.46857E+03_JPRB,0.30486E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,45, 3) = (/ &
 & 0.23732E+03_JPRB,0.34134E+03_JPRB,0.46856E+03_JPRB,0.30486E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,45, 3) = (/ &
 & 0.23732E+03_JPRB,0.34134E+03_JPRB,0.46856E+03_JPRB,0.30486E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,46, 3) = (/ &
 & 0.23732E+03_JPRB,0.34135E+03_JPRB,0.46856E+03_JPRB,0.30486E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,46, 3) = (/ &
 & 0.23732E+03_JPRB,0.34134E+03_JPRB,0.46856E+03_JPRB,0.30486E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,46, 3) = (/ &
 & 0.23732E+03_JPRB,0.34134E+03_JPRB,0.46856E+03_JPRB,0.30485E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,46, 3) = (/ &
 & 0.23732E+03_JPRB,0.34134E+03_JPRB,0.46856E+03_JPRB,0.30485E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,46, 3) = (/ &
 & 0.23732E+03_JPRB,0.34134E+03_JPRB,0.46856E+03_JPRB,0.30485E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,47, 3) = (/ &
 & 0.23732E+03_JPRB,0.34135E+03_JPRB,0.46856E+03_JPRB,0.30485E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,47, 3) = (/ &
 & 0.23732E+03_JPRB,0.34134E+03_JPRB,0.46856E+03_JPRB,0.30485E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,47, 3) = (/ &
 & 0.23732E+03_JPRB,0.34134E+03_JPRB,0.46855E+03_JPRB,0.30485E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,47, 3) = (/ &
 & 0.23731E+03_JPRB,0.34134E+03_JPRB,0.46855E+03_JPRB,0.30485E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,47, 3) = (/ &
 & 0.23731E+03_JPRB,0.34133E+03_JPRB,0.46855E+03_JPRB,0.30485E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,48, 3) = (/ &
 & 0.23731E+03_JPRB,0.34135E+03_JPRB,0.46855E+03_JPRB,0.30485E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,48, 3) = (/ &
 & 0.23731E+03_JPRB,0.34134E+03_JPRB,0.46855E+03_JPRB,0.30485E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,48, 3) = (/ &
 & 0.23731E+03_JPRB,0.34134E+03_JPRB,0.46855E+03_JPRB,0.30485E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,48, 3) = (/ &
 & 0.23731E+03_JPRB,0.34134E+03_JPRB,0.46855E+03_JPRB,0.30485E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,48, 3) = (/ &
 & 0.23731E+03_JPRB,0.34133E+03_JPRB,0.46855E+03_JPRB,0.30485E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,49, 3) = (/ &
 & 0.23731E+03_JPRB,0.34135E+03_JPRB,0.46855E+03_JPRB,0.30485E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,49, 3) = (/ &
 & 0.23731E+03_JPRB,0.34134E+03_JPRB,0.46855E+03_JPRB,0.30485E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,49, 3) = (/ &
 & 0.23731E+03_JPRB,0.34133E+03_JPRB,0.46854E+03_JPRB,0.30485E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,49, 3) = (/ &
 & 0.23731E+03_JPRB,0.34133E+03_JPRB,0.46854E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,49, 3) = (/ &
 & 0.23731E+03_JPRB,0.34133E+03_JPRB,0.46854E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,50, 3) = (/ &
 & 0.23731E+03_JPRB,0.34136E+03_JPRB,0.46854E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,50, 3) = (/ &
 & 0.23731E+03_JPRB,0.34134E+03_JPRB,0.46854E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,50, 3) = (/ &
 & 0.23731E+03_JPRB,0.34133E+03_JPRB,0.46854E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,50, 3) = (/ &
 & 0.23730E+03_JPRB,0.34133E+03_JPRB,0.46854E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,50, 3) = (/ &
 & 0.23730E+03_JPRB,0.34133E+03_JPRB,0.46854E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,51, 3) = (/ &
 & 0.23731E+03_JPRB,0.34136E+03_JPRB,0.46854E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,51, 3) = (/ &
 & 0.23730E+03_JPRB,0.34134E+03_JPRB,0.46854E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,51, 3) = (/ &
 & 0.23730E+03_JPRB,0.34133E+03_JPRB,0.46854E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,51, 3) = (/ &
 & 0.23730E+03_JPRB,0.34133E+03_JPRB,0.46854E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,51, 3) = (/ &
 & 0.23730E+03_JPRB,0.34133E+03_JPRB,0.46854E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,52, 3) = (/ &
 & 0.23730E+03_JPRB,0.34136E+03_JPRB,0.46852E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,52, 3) = (/ &
 & 0.23730E+03_JPRB,0.34135E+03_JPRB,0.46854E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,52, 3) = (/ &
 & 0.23730E+03_JPRB,0.34133E+03_JPRB,0.46854E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,52, 3) = (/ &
 & 0.23730E+03_JPRB,0.34132E+03_JPRB,0.46854E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,52, 3) = (/ &
 & 0.23730E+03_JPRB,0.34133E+03_JPRB,0.46853E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,53, 3) = (/ &
 & 0.23730E+03_JPRB,0.34137E+03_JPRB,0.46851E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,53, 3) = (/ &
 & 0.23730E+03_JPRB,0.34135E+03_JPRB,0.46853E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,53, 3) = (/ &
 & 0.23730E+03_JPRB,0.34134E+03_JPRB,0.46853E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,53, 3) = (/ &
 & 0.23730E+03_JPRB,0.34133E+03_JPRB,0.46853E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,53, 3) = (/ &
 & 0.23730E+03_JPRB,0.34133E+03_JPRB,0.46853E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,54, 3) = (/ &
 & 0.23730E+03_JPRB,0.34137E+03_JPRB,0.46849E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,54, 3) = (/ &
 & 0.23730E+03_JPRB,0.34136E+03_JPRB,0.46852E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,54, 3) = (/ &
 & 0.23730E+03_JPRB,0.34134E+03_JPRB,0.46853E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,54, 3) = (/ &
 & 0.23730E+03_JPRB,0.34133E+03_JPRB,0.46853E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,54, 3) = (/ &
 & 0.23730E+03_JPRB,0.34132E+03_JPRB,0.46853E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,55, 3) = (/ &
 & 0.23730E+03_JPRB,0.34138E+03_JPRB,0.46847E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,55, 3) = (/ &
 & 0.23730E+03_JPRB,0.34136E+03_JPRB,0.46852E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,55, 3) = (/ &
 & 0.23730E+03_JPRB,0.34134E+03_JPRB,0.46853E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,55, 3) = (/ &
 & 0.23730E+03_JPRB,0.34133E+03_JPRB,0.46853E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,55, 3) = (/ &
 & 0.23730E+03_JPRB,0.34132E+03_JPRB,0.46853E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,56, 3) = (/ &
 & 0.23730E+03_JPRB,0.34139E+03_JPRB,0.46844E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,56, 3) = (/ &
 & 0.23730E+03_JPRB,0.34137E+03_JPRB,0.46850E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,56, 3) = (/ &
 & 0.23730E+03_JPRB,0.34135E+03_JPRB,0.46853E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,56, 3) = (/ &
 & 0.23730E+03_JPRB,0.34133E+03_JPRB,0.46853E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,56, 3) = (/ &
 & 0.23730E+03_JPRB,0.34133E+03_JPRB,0.46853E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,57, 3) = (/ &
 & 0.23730E+03_JPRB,0.34140E+03_JPRB,0.46840E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,57, 3) = (/ &
 & 0.23730E+03_JPRB,0.34137E+03_JPRB,0.46849E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,57, 3) = (/ &
 & 0.23730E+03_JPRB,0.34135E+03_JPRB,0.46852E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,57, 3) = (/ &
 & 0.23730E+03_JPRB,0.34134E+03_JPRB,0.46853E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,57, 3) = (/ &
 & 0.23729E+03_JPRB,0.34132E+03_JPRB,0.46853E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,58, 3) = (/ &
 & 0.23730E+03_JPRB,0.34140E+03_JPRB,0.46837E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,58, 3) = (/ &
 & 0.23729E+03_JPRB,0.34138E+03_JPRB,0.46847E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,58, 3) = (/ &
 & 0.23729E+03_JPRB,0.34136E+03_JPRB,0.46851E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,58, 3) = (/ &
 & 0.23729E+03_JPRB,0.34134E+03_JPRB,0.46853E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,58, 3) = (/ &
 & 0.23729E+03_JPRB,0.34133E+03_JPRB,0.46853E+03_JPRB,0.30483E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,59, 3) = (/ &
 & 0.23729E+03_JPRB,0.34141E+03_JPRB,0.46835E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 2,59, 3) = (/ &
 & 0.23729E+03_JPRB,0.34138E+03_JPRB,0.46846E+03_JPRB,0.30484E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 3,59, 3) = (/ &
 & 0.23729E+03_JPRB,0.34136E+03_JPRB,0.46851E+03_JPRB,0.30483E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 4,59, 3) = (/ &
 & 0.23729E+03_JPRB,0.34134E+03_JPRB,0.46853E+03_JPRB,0.30483E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 5,59, 3) = (/ &
 & 0.23729E+03_JPRB,0.34133E+03_JPRB,0.46853E+03_JPRB,0.30483E+03_JPRB,0.17829E+03_JPRB /)  
KB(:, 1,13, 4) = (/ &
 & 0.51214E+03_JPRB,0.47089E+03_JPRB,0.53698E+03_JPRB,0.40623E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,13, 4) = (/ &
 & 0.50819E+03_JPRB,0.46793E+03_JPRB,0.53525E+03_JPRB,0.40532E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,13, 4) = (/ &
 & 0.50478E+03_JPRB,0.46537E+03_JPRB,0.53379E+03_JPRB,0.40453E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,13, 4) = (/ &
 & 0.50182E+03_JPRB,0.46315E+03_JPRB,0.53251E+03_JPRB,0.40385E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,13, 4) = (/ &
 & 0.49922E+03_JPRB,0.46120E+03_JPRB,0.53137E+03_JPRB,0.40325E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,14, 4) = (/ &
 & 0.50224E+03_JPRB,0.46346E+03_JPRB,0.53224E+03_JPRB,0.40395E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,14, 4) = (/ &
 & 0.49905E+03_JPRB,0.46107E+03_JPRB,0.53090E+03_JPRB,0.40321E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,14, 4) = (/ &
 & 0.49629E+03_JPRB,0.45901E+03_JPRB,0.52974E+03_JPRB,0.40258E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,14, 4) = (/ &
 & 0.49390E+03_JPRB,0.45721E+03_JPRB,0.52871E+03_JPRB,0.40203E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,14, 4) = (/ &
 & 0.49179E+03_JPRB,0.45563E+03_JPRB,0.52774E+03_JPRB,0.40154E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,15, 4) = (/ &
 & 0.49416E+03_JPRB,0.45741E+03_JPRB,0.52835E+03_JPRB,0.40209E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,15, 4) = (/ &
 & 0.49159E+03_JPRB,0.45548E+03_JPRB,0.52725E+03_JPRB,0.40149E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,15, 4) = (/ &
 & 0.48937E+03_JPRB,0.45381E+03_JPRB,0.52626E+03_JPRB,0.40098E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,15, 4) = (/ &
 & 0.48743E+03_JPRB,0.45236E+03_JPRB,0.52534E+03_JPRB,0.40054E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,15, 4) = (/ &
 & 0.48573E+03_JPRB,0.45108E+03_JPRB,0.52448E+03_JPRB,0.40015E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,16, 4) = (/ &
 & 0.48759E+03_JPRB,0.45248E+03_JPRB,0.52492E+03_JPRB,0.40057E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,16, 4) = (/ &
 & 0.48552E+03_JPRB,0.45092E+03_JPRB,0.52397E+03_JPRB,0.40010E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,16, 4) = (/ &
 & 0.48373E+03_JPRB,0.44958E+03_JPRB,0.52310E+03_JPRB,0.39968E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,16, 4) = (/ &
 & 0.48216E+03_JPRB,0.44841E+03_JPRB,0.52232E+03_JPRB,0.39932E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,16, 4) = (/ &
 & 0.48079E+03_JPRB,0.44738E+03_JPRB,0.52159E+03_JPRB,0.39901E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,17, 4) = (/ &
 & 0.48226E+03_JPRB,0.44848E+03_JPRB,0.52188E+03_JPRB,0.39935E+03_JPRB,0.38437E+03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART16',1,ZHOOK_HANDLE)
END SUBROUTINE PART16


SUBROUTINE PART17

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART17',0,ZHOOK_HANDLE)


KB(:, 2,17, 4) = (/ &
 & 0.48059E+03_JPRB,0.44723E+03_JPRB,0.52110E+03_JPRB,0.39896E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,17, 4) = (/ &
 & 0.47915E+03_JPRB,0.44615E+03_JPRB,0.52038E+03_JPRB,0.39863E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,17, 4) = (/ &
 & 0.47788E+03_JPRB,0.44520E+03_JPRB,0.51974E+03_JPRB,0.39834E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,17, 4) = (/ &
 & 0.47677E+03_JPRB,0.44437E+03_JPRB,0.51913E+03_JPRB,0.39808E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,18, 4) = (/ &
 & 0.47794E+03_JPRB,0.44524E+03_JPRB,0.51928E+03_JPRB,0.39835E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,18, 4) = (/ &
 & 0.47659E+03_JPRB,0.44423E+03_JPRB,0.51865E+03_JPRB,0.39804E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,18, 4) = (/ &
 & 0.47542E+03_JPRB,0.44336E+03_JPRB,0.51808E+03_JPRB,0.39777E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,18, 4) = (/ &
 & 0.47441E+03_JPRB,0.44259E+03_JPRB,0.51755E+03_JPRB,0.39754E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,18, 4) = (/ &
 & 0.47351E+03_JPRB,0.44192E+03_JPRB,0.51705E+03_JPRB,0.39733E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,19, 4) = (/ &
 & 0.47443E+03_JPRB,0.44261E+03_JPRB,0.51710E+03_JPRB,0.39754E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,19, 4) = (/ &
 & 0.47334E+03_JPRB,0.44179E+03_JPRB,0.51660E+03_JPRB,0.39729E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,19, 4) = (/ &
 & 0.47240E+03_JPRB,0.44109E+03_JPRB,0.51615E+03_JPRB,0.39708E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,19, 4) = (/ &
 & 0.47158E+03_JPRB,0.44047E+03_JPRB,0.51573E+03_JPRB,0.39689E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,19, 4) = (/ &
 & 0.47085E+03_JPRB,0.43993E+03_JPRB,0.51533E+03_JPRB,0.39672E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,20, 4) = (/ &
 & 0.47156E+03_JPRB,0.44046E+03_JPRB,0.51527E+03_JPRB,0.39688E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,20, 4) = (/ &
 & 0.47069E+03_JPRB,0.43980E+03_JPRB,0.51490E+03_JPRB,0.39668E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,20, 4) = (/ &
 & 0.46993E+03_JPRB,0.43924E+03_JPRB,0.51455E+03_JPRB,0.39651E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,20, 4) = (/ &
 & 0.46927E+03_JPRB,0.43874E+03_JPRB,0.51422E+03_JPRB,0.39635E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,20, 4) = (/ &
 & 0.46868E+03_JPRB,0.43830E+03_JPRB,0.51389E+03_JPRB,0.39622E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,21, 4) = (/ &
 & 0.46924E+03_JPRB,0.43872E+03_JPRB,0.51377E+03_JPRB,0.39635E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,21, 4) = (/ &
 & 0.46853E+03_JPRB,0.43819E+03_JPRB,0.51350E+03_JPRB,0.39619E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,21, 4) = (/ &
 & 0.46792E+03_JPRB,0.43773E+03_JPRB,0.51323E+03_JPRB,0.39604E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,21, 4) = (/ &
 & 0.46739E+03_JPRB,0.43733E+03_JPRB,0.51296E+03_JPRB,0.39592E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,21, 4) = (/ &
 & 0.46692E+03_JPRB,0.43697E+03_JPRB,0.51263E+03_JPRB,0.39581E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,22, 4) = (/ &
 & 0.46731E+03_JPRB,0.43727E+03_JPRB,0.51254E+03_JPRB,0.39590E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,22, 4) = (/ &
 & 0.46675E+03_JPRB,0.43685E+03_JPRB,0.51231E+03_JPRB,0.39577E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,22, 4) = (/ &
 & 0.46626E+03_JPRB,0.43648E+03_JPRB,0.51212E+03_JPRB,0.39566E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,22, 4) = (/ &
 & 0.46584E+03_JPRB,0.43616E+03_JPRB,0.51190E+03_JPRB,0.39556E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,22, 4) = (/ &
 & 0.46546E+03_JPRB,0.43588E+03_JPRB,0.51168E+03_JPRB,0.39548E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,23, 4) = (/ &
 & 0.46575E+03_JPRB,0.43610E+03_JPRB,0.51153E+03_JPRB,0.39554E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,23, 4) = (/ &
 & 0.46531E+03_JPRB,0.43577E+03_JPRB,0.51138E+03_JPRB,0.39544E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,23, 4) = (/ &
 & 0.46492E+03_JPRB,0.43548E+03_JPRB,0.51122E+03_JPRB,0.39535E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,23, 4) = (/ &
 & 0.46458E+03_JPRB,0.43522E+03_JPRB,0.51104E+03_JPRB,0.39527E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,23, 4) = (/ &
 & 0.46427E+03_JPRB,0.43499E+03_JPRB,0.51086E+03_JPRB,0.39520E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,24, 4) = (/ &
 & 0.46450E+03_JPRB,0.43516E+03_JPRB,0.51071E+03_JPRB,0.39525E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,24, 4) = (/ &
 & 0.46414E+03_JPRB,0.43489E+03_JPRB,0.51060E+03_JPRB,0.39517E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,24, 4) = (/ &
 & 0.46383E+03_JPRB,0.43466E+03_JPRB,0.51047E+03_JPRB,0.39510E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,24, 4) = (/ &
 & 0.46356E+03_JPRB,0.43445E+03_JPRB,0.51033E+03_JPRB,0.39504E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,24, 4) = (/ &
 & 0.46331E+03_JPRB,0.43427E+03_JPRB,0.51019E+03_JPRB,0.39498E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,25, 4) = (/ &
 & 0.46348E+03_JPRB,0.43439E+03_JPRB,0.51003E+03_JPRB,0.39502E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,25, 4) = (/ &
 & 0.46319E+03_JPRB,0.43418E+03_JPRB,0.50997E+03_JPRB,0.39496E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,25, 4) = (/ &
 & 0.46295E+03_JPRB,0.43400E+03_JPRB,0.50987E+03_JPRB,0.39490E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,25, 4) = (/ &
 & 0.46273E+03_JPRB,0.43383E+03_JPRB,0.50976E+03_JPRB,0.39485E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,25, 4) = (/ &
 & 0.46254E+03_JPRB,0.43369E+03_JPRB,0.50965E+03_JPRB,0.39480E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,26, 4) = (/ &
 & 0.46265E+03_JPRB,0.43378E+03_JPRB,0.50951E+03_JPRB,0.39483E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,26, 4) = (/ &
 & 0.46243E+03_JPRB,0.43361E+03_JPRB,0.50946E+03_JPRB,0.39478E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,26, 4) = (/ &
 & 0.46223E+03_JPRB,0.43346E+03_JPRB,0.50938E+03_JPRB,0.39473E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,26, 4) = (/ &
 & 0.46206E+03_JPRB,0.43333E+03_JPRB,0.50930E+03_JPRB,0.39469E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,26, 4) = (/ &
 & 0.46190E+03_JPRB,0.43321E+03_JPRB,0.50921E+03_JPRB,0.39466E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,27, 4) = (/ &
 & 0.46199E+03_JPRB,0.43328E+03_JPRB,0.50908E+03_JPRB,0.39468E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,27, 4) = (/ &
 & 0.46181E+03_JPRB,0.43314E+03_JPRB,0.50904E+03_JPRB,0.39464E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,27, 4) = (/ &
 & 0.46165E+03_JPRB,0.43303E+03_JPRB,0.50899E+03_JPRB,0.39460E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,27, 4) = (/ &
 & 0.46152E+03_JPRB,0.43292E+03_JPRB,0.50892E+03_JPRB,0.39457E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,27, 4) = (/ &
 & 0.46139E+03_JPRB,0.43283E+03_JPRB,0.50885E+03_JPRB,0.39454E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,28, 4) = (/ &
 & 0.46145E+03_JPRB,0.43288E+03_JPRB,0.50873E+03_JPRB,0.39455E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,28, 4) = (/ &
 & 0.46131E+03_JPRB,0.43277E+03_JPRB,0.50871E+03_JPRB,0.39452E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,28, 4) = (/ &
 & 0.46119E+03_JPRB,0.43268E+03_JPRB,0.50867E+03_JPRB,0.39449E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,28, 4) = (/ &
 & 0.46108E+03_JPRB,0.43259E+03_JPRB,0.50862E+03_JPRB,0.39447E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,28, 4) = (/ &
 & 0.46098E+03_JPRB,0.43252E+03_JPRB,0.50856E+03_JPRB,0.39445E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,29, 4) = (/ &
 & 0.46102E+03_JPRB,0.43255E+03_JPRB,0.50845E+03_JPRB,0.39445E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,29, 4) = (/ &
 & 0.46091E+03_JPRB,0.43247E+03_JPRB,0.50844E+03_JPRB,0.39443E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,29, 4) = (/ &
 & 0.46081E+03_JPRB,0.43239E+03_JPRB,0.50842E+03_JPRB,0.39441E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,29, 4) = (/ &
 & 0.46072E+03_JPRB,0.43233E+03_JPRB,0.50837E+03_JPRB,0.39439E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,29, 4) = (/ &
 & 0.46064E+03_JPRB,0.43227E+03_JPRB,0.50832E+03_JPRB,0.39437E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,30, 4) = (/ &
 & 0.46067E+03_JPRB,0.43229E+03_JPRB,0.50823E+03_JPRB,0.39437E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,30, 4) = (/ &
 & 0.46058E+03_JPRB,0.43223E+03_JPRB,0.50823E+03_JPRB,0.39435E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,30, 4) = (/ &
 & 0.46051E+03_JPRB,0.43217E+03_JPRB,0.50821E+03_JPRB,0.39434E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,30, 4) = (/ &
 & 0.46044E+03_JPRB,0.43211E+03_JPRB,0.50818E+03_JPRB,0.39432E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,30, 4) = (/ &
 & 0.46037E+03_JPRB,0.43207E+03_JPRB,0.50813E+03_JPRB,0.39431E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,31, 4) = (/ &
 & 0.46039E+03_JPRB,0.43208E+03_JPRB,0.50805E+03_JPRB,0.39431E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,31, 4) = (/ &
 & 0.46032E+03_JPRB,0.43203E+03_JPRB,0.50805E+03_JPRB,0.39429E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,31, 4) = (/ &
 & 0.46026E+03_JPRB,0.43198E+03_JPRB,0.50804E+03_JPRB,0.39428E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,31, 4) = (/ &
 & 0.46021E+03_JPRB,0.43194E+03_JPRB,0.50801E+03_JPRB,0.39427E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,31, 4) = (/ &
 & 0.46016E+03_JPRB,0.43190E+03_JPRB,0.50797E+03_JPRB,0.39426E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,32, 4) = (/ &
 & 0.46017E+03_JPRB,0.43191E+03_JPRB,0.50790E+03_JPRB,0.39426E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,32, 4) = (/ &
 & 0.46011E+03_JPRB,0.43187E+03_JPRB,0.50792E+03_JPRB,0.39425E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,32, 4) = (/ &
 & 0.46006E+03_JPRB,0.43183E+03_JPRB,0.50791E+03_JPRB,0.39423E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,32, 4) = (/ &
 & 0.46002E+03_JPRB,0.43180E+03_JPRB,0.50788E+03_JPRB,0.39422E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,32, 4) = (/ &
 & 0.45998E+03_JPRB,0.43177E+03_JPRB,0.50784E+03_JPRB,0.39421E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,33, 4) = (/ &
 & 0.45999E+03_JPRB,0.43178E+03_JPRB,0.50779E+03_JPRB,0.39422E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,33, 4) = (/ &
 & 0.45994E+03_JPRB,0.43174E+03_JPRB,0.50781E+03_JPRB,0.39421E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,33, 4) = (/ &
 & 0.45990E+03_JPRB,0.43171E+03_JPRB,0.50780E+03_JPRB,0.39420E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,33, 4) = (/ &
 & 0.45987E+03_JPRB,0.43169E+03_JPRB,0.50777E+03_JPRB,0.39419E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,33, 4) = (/ &
 & 0.45984E+03_JPRB,0.43166E+03_JPRB,0.50773E+03_JPRB,0.39418E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,34, 4) = (/ &
 & 0.45984E+03_JPRB,0.43167E+03_JPRB,0.50770E+03_JPRB,0.39418E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,34, 4) = (/ &
 & 0.45981E+03_JPRB,0.43164E+03_JPRB,0.50772E+03_JPRB,0.39418E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,34, 4) = (/ &
 & 0.45978E+03_JPRB,0.43162E+03_JPRB,0.50771E+03_JPRB,0.39417E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,34, 4) = (/ &
 & 0.45975E+03_JPRB,0.43160E+03_JPRB,0.50768E+03_JPRB,0.39416E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,34, 4) = (/ &
 & 0.45972E+03_JPRB,0.43158E+03_JPRB,0.50764E+03_JPRB,0.39416E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,35, 4) = (/ &
 & 0.45973E+03_JPRB,0.43158E+03_JPRB,0.50763E+03_JPRB,0.39416E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,35, 4) = (/ &
 & 0.45970E+03_JPRB,0.43156E+03_JPRB,0.50764E+03_JPRB,0.39415E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,35, 4) = (/ &
 & 0.45968E+03_JPRB,0.43154E+03_JPRB,0.50764E+03_JPRB,0.39414E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,35, 4) = (/ &
 & 0.45965E+03_JPRB,0.43153E+03_JPRB,0.50761E+03_JPRB,0.39414E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,35, 4) = (/ &
 & 0.45963E+03_JPRB,0.43151E+03_JPRB,0.50757E+03_JPRB,0.39413E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,36, 4) = (/ &
 & 0.45964E+03_JPRB,0.43152E+03_JPRB,0.50757E+03_JPRB,0.39414E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,36, 4) = (/ &
 & 0.45962E+03_JPRB,0.43150E+03_JPRB,0.50758E+03_JPRB,0.39413E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,36, 4) = (/ &
 & 0.45960E+03_JPRB,0.43148E+03_JPRB,0.50758E+03_JPRB,0.39413E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,36, 4) = (/ &
 & 0.45958E+03_JPRB,0.43147E+03_JPRB,0.50756E+03_JPRB,0.39412E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,36, 4) = (/ &
 & 0.45956E+03_JPRB,0.43146E+03_JPRB,0.50752E+03_JPRB,0.39412E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,37, 4) = (/ &
 & 0.45957E+03_JPRB,0.43146E+03_JPRB,0.50751E+03_JPRB,0.39412E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,37, 4) = (/ &
 & 0.45955E+03_JPRB,0.43145E+03_JPRB,0.50753E+03_JPRB,0.39412E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,37, 4) = (/ &
 & 0.45953E+03_JPRB,0.43144E+03_JPRB,0.50754E+03_JPRB,0.39411E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,37, 4) = (/ &
 & 0.45952E+03_JPRB,0.43142E+03_JPRB,0.50752E+03_JPRB,0.39411E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,37, 4) = (/ &
 & 0.45950E+03_JPRB,0.43141E+03_JPRB,0.50748E+03_JPRB,0.39411E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,38, 4) = (/ &
 & 0.45951E+03_JPRB,0.43142E+03_JPRB,0.50746E+03_JPRB,0.39411E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,38, 4) = (/ &
 & 0.45950E+03_JPRB,0.43141E+03_JPRB,0.50749E+03_JPRB,0.39410E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,38, 4) = (/ &
 & 0.45948E+03_JPRB,0.43140E+03_JPRB,0.50750E+03_JPRB,0.39410E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,38, 4) = (/ &
 & 0.45947E+03_JPRB,0.43139E+03_JPRB,0.50749E+03_JPRB,0.39410E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,38, 4) = (/ &
 & 0.45946E+03_JPRB,0.43138E+03_JPRB,0.50745E+03_JPRB,0.39409E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,39, 4) = (/ &
 & 0.45946E+03_JPRB,0.43138E+03_JPRB,0.50742E+03_JPRB,0.39410E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,39, 4) = (/ &
 & 0.45945E+03_JPRB,0.43137E+03_JPRB,0.50746E+03_JPRB,0.39409E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,39, 4) = (/ &
 & 0.45944E+03_JPRB,0.43137E+03_JPRB,0.50747E+03_JPRB,0.39409E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,39, 4) = (/ &
 & 0.45943E+03_JPRB,0.43136E+03_JPRB,0.50746E+03_JPRB,0.39409E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,39, 4) = (/ &
 & 0.45942E+03_JPRB,0.43135E+03_JPRB,0.50743E+03_JPRB,0.39409E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,40, 4) = (/ &
 & 0.45943E+03_JPRB,0.43136E+03_JPRB,0.50738E+03_JPRB,0.39409E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,40, 4) = (/ &
 & 0.45941E+03_JPRB,0.43135E+03_JPRB,0.50742E+03_JPRB,0.39408E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,40, 4) = (/ &
 & 0.45940E+03_JPRB,0.43134E+03_JPRB,0.50744E+03_JPRB,0.39408E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,40, 4) = (/ &
 & 0.45940E+03_JPRB,0.43133E+03_JPRB,0.50744E+03_JPRB,0.39408E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,40, 4) = (/ &
 & 0.45939E+03_JPRB,0.43133E+03_JPRB,0.50742E+03_JPRB,0.39408E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,41, 4) = (/ &
 & 0.45939E+03_JPRB,0.43133E+03_JPRB,0.50734E+03_JPRB,0.39408E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,41, 4) = (/ &
 & 0.45938E+03_JPRB,0.43133E+03_JPRB,0.50739E+03_JPRB,0.39408E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,41, 4) = (/ &
 & 0.45938E+03_JPRB,0.43132E+03_JPRB,0.50742E+03_JPRB,0.39408E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,41, 4) = (/ &
 & 0.45937E+03_JPRB,0.43131E+03_JPRB,0.50742E+03_JPRB,0.39407E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,41, 4) = (/ &
 & 0.45936E+03_JPRB,0.43131E+03_JPRB,0.50741E+03_JPRB,0.39407E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,42, 4) = (/ &
 & 0.45937E+03_JPRB,0.43131E+03_JPRB,0.50731E+03_JPRB,0.39407E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,42, 4) = (/ &
 & 0.45936E+03_JPRB,0.43131E+03_JPRB,0.50736E+03_JPRB,0.39407E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,42, 4) = (/ &
 & 0.45935E+03_JPRB,0.43130E+03_JPRB,0.50739E+03_JPRB,0.39407E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,42, 4) = (/ &
 & 0.45935E+03_JPRB,0.43130E+03_JPRB,0.50741E+03_JPRB,0.39407E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,42, 4) = (/ &
 & 0.45934E+03_JPRB,0.43129E+03_JPRB,0.50740E+03_JPRB,0.39407E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,43, 4) = (/ &
 & 0.45935E+03_JPRB,0.43130E+03_JPRB,0.50727E+03_JPRB,0.39407E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,43, 4) = (/ &
 & 0.45934E+03_JPRB,0.43129E+03_JPRB,0.50733E+03_JPRB,0.39407E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,43, 4) = (/ &
 & 0.45933E+03_JPRB,0.43129E+03_JPRB,0.50737E+03_JPRB,0.39407E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,43, 4) = (/ &
 & 0.45933E+03_JPRB,0.43128E+03_JPRB,0.50739E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,43, 4) = (/ &
 & 0.45932E+03_JPRB,0.43128E+03_JPRB,0.50739E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,44, 4) = (/ &
 & 0.45933E+03_JPRB,0.43128E+03_JPRB,0.50723E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,44, 4) = (/ &
 & 0.45932E+03_JPRB,0.43128E+03_JPRB,0.50730E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,44, 4) = (/ &
 & 0.45932E+03_JPRB,0.43128E+03_JPRB,0.50735E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,44, 4) = (/ &
 & 0.45931E+03_JPRB,0.43127E+03_JPRB,0.50737E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,44, 4) = (/ &
 & 0.45931E+03_JPRB,0.43127E+03_JPRB,0.50738E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,45, 4) = (/ &
 & 0.45931E+03_JPRB,0.43127E+03_JPRB,0.50718E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,45, 4) = (/ &
 & 0.45931E+03_JPRB,0.43127E+03_JPRB,0.50727E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,45, 4) = (/ &
 & 0.45930E+03_JPRB,0.43127E+03_JPRB,0.50732E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,45, 4) = (/ &
 & 0.45930E+03_JPRB,0.43126E+03_JPRB,0.50736E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,45, 4) = (/ &
 & 0.45930E+03_JPRB,0.43126E+03_JPRB,0.50737E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,46, 4) = (/ &
 & 0.45930E+03_JPRB,0.43126E+03_JPRB,0.50714E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART17',1,ZHOOK_HANDLE)
END SUBROUTINE PART17


SUBROUTINE PART18

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART18',0,ZHOOK_HANDLE)


KB(:, 2,46, 4) = (/ &
 & 0.45930E+03_JPRB,0.43126E+03_JPRB,0.50723E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,46, 4) = (/ &
 & 0.45929E+03_JPRB,0.43126E+03_JPRB,0.50730E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,46, 4) = (/ &
 & 0.45929E+03_JPRB,0.43125E+03_JPRB,0.50734E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,46, 4) = (/ &
 & 0.45929E+03_JPRB,0.43125E+03_JPRB,0.50736E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,47, 4) = (/ &
 & 0.45929E+03_JPRB,0.43126E+03_JPRB,0.50708E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,47, 4) = (/ &
 & 0.45929E+03_JPRB,0.43125E+03_JPRB,0.50719E+03_JPRB,0.39406E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,47, 4) = (/ &
 & 0.45928E+03_JPRB,0.43125E+03_JPRB,0.50727E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,47, 4) = (/ &
 & 0.45928E+03_JPRB,0.43125E+03_JPRB,0.50732E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,47, 4) = (/ &
 & 0.45928E+03_JPRB,0.43125E+03_JPRB,0.50735E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,48, 4) = (/ &
 & 0.45928E+03_JPRB,0.43125E+03_JPRB,0.50701E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,48, 4) = (/ &
 & 0.45928E+03_JPRB,0.43125E+03_JPRB,0.50714E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,48, 4) = (/ &
 & 0.45928E+03_JPRB,0.43124E+03_JPRB,0.50723E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,48, 4) = (/ &
 & 0.45927E+03_JPRB,0.43124E+03_JPRB,0.50729E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,48, 4) = (/ &
 & 0.45927E+03_JPRB,0.43124E+03_JPRB,0.50733E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,49, 4) = (/ &
 & 0.45928E+03_JPRB,0.43124E+03_JPRB,0.50694E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,49, 4) = (/ &
 & 0.45927E+03_JPRB,0.43124E+03_JPRB,0.50709E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,49, 4) = (/ &
 & 0.45927E+03_JPRB,0.43124E+03_JPRB,0.50720E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,49, 4) = (/ &
 & 0.45927E+03_JPRB,0.43124E+03_JPRB,0.50727E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,49, 4) = (/ &
 & 0.45927E+03_JPRB,0.43124E+03_JPRB,0.50732E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,50, 4) = (/ &
 & 0.45927E+03_JPRB,0.43124E+03_JPRB,0.50686E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,50, 4) = (/ &
 & 0.45927E+03_JPRB,0.43124E+03_JPRB,0.50704E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,50, 4) = (/ &
 & 0.45927E+03_JPRB,0.43124E+03_JPRB,0.50716E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,50, 4) = (/ &
 & 0.45926E+03_JPRB,0.43123E+03_JPRB,0.50724E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,50, 4) = (/ &
 & 0.45926E+03_JPRB,0.43123E+03_JPRB,0.50730E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,51, 4) = (/ &
 & 0.45926E+03_JPRB,0.43124E+03_JPRB,0.50679E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,51, 4) = (/ &
 & 0.45926E+03_JPRB,0.43123E+03_JPRB,0.50697E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,51, 4) = (/ &
 & 0.45926E+03_JPRB,0.43123E+03_JPRB,0.50711E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,51, 4) = (/ &
 & 0.45926E+03_JPRB,0.43123E+03_JPRB,0.50721E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,51, 4) = (/ &
 & 0.45926E+03_JPRB,0.43123E+03_JPRB,0.50728E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,52, 4) = (/ &
 & 0.45926E+03_JPRB,0.43123E+03_JPRB,0.50671E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,52, 4) = (/ &
 & 0.45926E+03_JPRB,0.43123E+03_JPRB,0.50691E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,52, 4) = (/ &
 & 0.45926E+03_JPRB,0.43123E+03_JPRB,0.50707E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,52, 4) = (/ &
 & 0.45926E+03_JPRB,0.43123E+03_JPRB,0.50718E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,52, 4) = (/ &
 & 0.45925E+03_JPRB,0.43123E+03_JPRB,0.50725E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,53, 4) = (/ &
 & 0.45926E+03_JPRB,0.43123E+03_JPRB,0.50663E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,53, 4) = (/ &
 & 0.45926E+03_JPRB,0.43123E+03_JPRB,0.50684E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,53, 4) = (/ &
 & 0.45925E+03_JPRB,0.43123E+03_JPRB,0.50701E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,53, 4) = (/ &
 & 0.45925E+03_JPRB,0.43123E+03_JPRB,0.50714E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,53, 4) = (/ &
 & 0.45925E+03_JPRB,0.43123E+03_JPRB,0.50722E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,54, 4) = (/ &
 & 0.45925E+03_JPRB,0.43123E+03_JPRB,0.50655E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,54, 4) = (/ &
 & 0.45925E+03_JPRB,0.43123E+03_JPRB,0.50677E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,54, 4) = (/ &
 & 0.45925E+03_JPRB,0.43123E+03_JPRB,0.50696E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,54, 4) = (/ &
 & 0.45925E+03_JPRB,0.43122E+03_JPRB,0.50710E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,54, 4) = (/ &
 & 0.45925E+03_JPRB,0.43122E+03_JPRB,0.50720E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,55, 4) = (/ &
 & 0.45925E+03_JPRB,0.43123E+03_JPRB,0.50647E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,55, 4) = (/ &
 & 0.45925E+03_JPRB,0.43122E+03_JPRB,0.50670E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,55, 4) = (/ &
 & 0.45925E+03_JPRB,0.43122E+03_JPRB,0.50690E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,55, 4) = (/ &
 & 0.45925E+03_JPRB,0.43122E+03_JPRB,0.50706E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,55, 4) = (/ &
 & 0.45925E+03_JPRB,0.43122E+03_JPRB,0.50717E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,56, 4) = (/ &
 & 0.45925E+03_JPRB,0.43122E+03_JPRB,0.50640E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,56, 4) = (/ &
 & 0.45925E+03_JPRB,0.43122E+03_JPRB,0.50663E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,56, 4) = (/ &
 & 0.45925E+03_JPRB,0.43122E+03_JPRB,0.50683E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,56, 4) = (/ &
 & 0.45925E+03_JPRB,0.43122E+03_JPRB,0.50701E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,56, 4) = (/ &
 & 0.45925E+03_JPRB,0.43122E+03_JPRB,0.50714E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,57, 4) = (/ &
 & 0.45925E+03_JPRB,0.43122E+03_JPRB,0.50632E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,57, 4) = (/ &
 & 0.45925E+03_JPRB,0.43122E+03_JPRB,0.50656E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,57, 4) = (/ &
 & 0.45925E+03_JPRB,0.43122E+03_JPRB,0.50677E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,57, 4) = (/ &
 & 0.45925E+03_JPRB,0.43122E+03_JPRB,0.50696E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,57, 4) = (/ &
 & 0.45924E+03_JPRB,0.43122E+03_JPRB,0.50710E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,58, 4) = (/ &
 & 0.45925E+03_JPRB,0.43122E+03_JPRB,0.50624E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,58, 4) = (/ &
 & 0.45925E+03_JPRB,0.43122E+03_JPRB,0.50648E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,58, 4) = (/ &
 & 0.45924E+03_JPRB,0.43122E+03_JPRB,0.50671E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,58, 4) = (/ &
 & 0.45924E+03_JPRB,0.43122E+03_JPRB,0.50690E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,58, 4) = (/ &
 & 0.45924E+03_JPRB,0.43122E+03_JPRB,0.50706E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,59, 4) = (/ &
 & 0.45924E+03_JPRB,0.43122E+03_JPRB,0.50622E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 2,59, 4) = (/ &
 & 0.45924E+03_JPRB,0.43122E+03_JPRB,0.50645E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 3,59, 4) = (/ &
 & 0.45924E+03_JPRB,0.43122E+03_JPRB,0.50668E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 4,59, 4) = (/ &
 & 0.45924E+03_JPRB,0.43122E+03_JPRB,0.50688E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 5,59, 4) = (/ &
 & 0.45924E+03_JPRB,0.43122E+03_JPRB,0.50704E+03_JPRB,0.39405E+03_JPRB,0.38437E+03_JPRB /)  
KB(:, 1,13, 5) = (/ &
 & 0.78037E+03_JPRB,0.62743E+03_JPRB,0.56495E+03_JPRB,0.56633E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,13, 5) = (/ &
 & 0.77434E+03_JPRB,0.62291E+03_JPRB,0.56343E+03_JPRB,0.56584E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,13, 5) = (/ &
 & 0.76915E+03_JPRB,0.61902E+03_JPRB,0.56189E+03_JPRB,0.56542E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,13, 5) = (/ &
 & 0.76464E+03_JPRB,0.61563E+03_JPRB,0.56027E+03_JPRB,0.56506E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,13, 5) = (/ &
 & 0.76068E+03_JPRB,0.61266E+03_JPRB,0.55865E+03_JPRB,0.56474E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,14, 5) = (/ &
 & 0.76527E+03_JPRB,0.61611E+03_JPRB,0.56011E+03_JPRB,0.56511E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,14, 5) = (/ &
 & 0.76041E+03_JPRB,0.61246E+03_JPRB,0.55859E+03_JPRB,0.56472E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,14, 5) = (/ &
 & 0.75622E+03_JPRB,0.60932E+03_JPRB,0.55696E+03_JPRB,0.56438E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,14, 5) = (/ &
 & 0.75257E+03_JPRB,0.60658E+03_JPRB,0.55539E+03_JPRB,0.56408E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,14, 5) = (/ &
 & 0.74936E+03_JPRB,0.60417E+03_JPRB,0.55391E+03_JPRB,0.56383E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,15, 5) = (/ &
 & 0.75296E+03_JPRB,0.60688E+03_JPRB,0.55521E+03_JPRB,0.56412E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,15, 5) = (/ &
 & 0.74904E+03_JPRB,0.60394E+03_JPRB,0.55372E+03_JPRB,0.56380E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,15, 5) = (/ &
 & 0.74566E+03_JPRB,0.60140E+03_JPRB,0.55235E+03_JPRB,0.56353E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,15, 5) = (/ &
 & 0.74271E+03_JPRB,0.59919E+03_JPRB,0.55103E+03_JPRB,0.56329E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,15, 5) = (/ &
 & 0.74012E+03_JPRB,0.59724E+03_JPRB,0.54977E+03_JPRB,0.56308E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,16, 5) = (/ &
 & 0.74295E+03_JPRB,0.59937E+03_JPRB,0.55079E+03_JPRB,0.56331E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,16, 5) = (/ &
 & 0.73979E+03_JPRB,0.59700E+03_JPRB,0.54953E+03_JPRB,0.56305E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,16, 5) = (/ &
 & 0.73707E+03_JPRB,0.59495E+03_JPRB,0.54828E+03_JPRB,0.56283E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,16, 5) = (/ &
 & 0.73469E+03_JPRB,0.59317E+03_JPRB,0.54708E+03_JPRB,0.56264E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,16, 5) = (/ &
 & 0.73259E+03_JPRB,0.59160E+03_JPRB,0.54600E+03_JPRB,0.56247E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,17, 5) = (/ &
 & 0.73483E+03_JPRB,0.59328E+03_JPRB,0.54695E+03_JPRB,0.56265E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,17, 5) = (/ &
 & 0.73229E+03_JPRB,0.59137E+03_JPRB,0.54572E+03_JPRB,0.56245E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,17, 5) = (/ &
 & 0.73009E+03_JPRB,0.58972E+03_JPRB,0.54462E+03_JPRB,0.56227E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,17, 5) = (/ &
 & 0.72817E+03_JPRB,0.58828E+03_JPRB,0.54366E+03_JPRB,0.56212E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,17, 5) = (/ &
 & 0.72647E+03_JPRB,0.58701E+03_JPRB,0.54281E+03_JPRB,0.56198E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,18, 5) = (/ &
 & 0.72825E+03_JPRB,0.58834E+03_JPRB,0.54354E+03_JPRB,0.56212E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,18, 5) = (/ &
 & 0.72619E+03_JPRB,0.58680E+03_JPRB,0.54253E+03_JPRB,0.56196E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,18, 5) = (/ &
 & 0.72442E+03_JPRB,0.58547E+03_JPRB,0.54166E+03_JPRB,0.56181E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,18, 5) = (/ &
 & 0.72286E+03_JPRB,0.58430E+03_JPRB,0.54091E+03_JPRB,0.56169E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,18, 5) = (/ &
 & 0.72150E+03_JPRB,0.58328E+03_JPRB,0.54024E+03_JPRB,0.56158E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,19, 5) = (/ &
 & 0.72290E+03_JPRB,0.58433E+03_JPRB,0.54075E+03_JPRB,0.56169E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,19, 5) = (/ &
 & 0.72124E+03_JPRB,0.58309E+03_JPRB,0.53996E+03_JPRB,0.56156E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,19, 5) = (/ &
 & 0.71981E+03_JPRB,0.58201E+03_JPRB,0.53928E+03_JPRB,0.56144E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,19, 5) = (/ &
 & 0.71856E+03_JPRB,0.58107E+03_JPRB,0.53868E+03_JPRB,0.56134E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,19, 5) = (/ &
 & 0.71745E+03_JPRB,0.58024E+03_JPRB,0.53816E+03_JPRB,0.56125E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,20, 5) = (/ &
 & 0.71853E+03_JPRB,0.58105E+03_JPRB,0.53849E+03_JPRB,0.56134E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,20, 5) = (/ &
 & 0.71720E+03_JPRB,0.58006E+03_JPRB,0.53788E+03_JPRB,0.56123E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,20, 5) = (/ &
 & 0.71605E+03_JPRB,0.57919E+03_JPRB,0.53734E+03_JPRB,0.56114E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,20, 5) = (/ &
 & 0.71504E+03_JPRB,0.57843E+03_JPRB,0.53687E+03_JPRB,0.56106E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,20, 5) = (/ &
 & 0.71414E+03_JPRB,0.57776E+03_JPRB,0.53643E+03_JPRB,0.56098E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,21, 5) = (/ &
 & 0.71499E+03_JPRB,0.57840E+03_JPRB,0.53667E+03_JPRB,0.56105E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,21, 5) = (/ &
 & 0.71392E+03_JPRB,0.57759E+03_JPRB,0.53620E+03_JPRB,0.56097E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,21, 5) = (/ &
 & 0.71299E+03_JPRB,0.57690E+03_JPRB,0.53578E+03_JPRB,0.56089E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,21, 5) = (/ &
 & 0.71217E+03_JPRB,0.57628E+03_JPRB,0.53541E+03_JPRB,0.56083E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,21, 5) = (/ &
 & 0.71145E+03_JPRB,0.57574E+03_JPRB,0.53506E+03_JPRB,0.56077E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,22, 5) = (/ &
 & 0.71206E+03_JPRB,0.57620E+03_JPRB,0.53519E+03_JPRB,0.56082E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,22, 5) = (/ &
 & 0.71120E+03_JPRB,0.57555E+03_JPRB,0.53482E+03_JPRB,0.56075E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,22, 5) = (/ &
 & 0.71046E+03_JPRB,0.57500E+03_JPRB,0.53450E+03_JPRB,0.56069E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,22, 5) = (/ &
 & 0.70981E+03_JPRB,0.57451E+03_JPRB,0.53420E+03_JPRB,0.56064E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,22, 5) = (/ &
 & 0.70923E+03_JPRB,0.57408E+03_JPRB,0.53390E+03_JPRB,0.56059E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,23, 5) = (/ &
 & 0.70968E+03_JPRB,0.57442E+03_JPRB,0.53396E+03_JPRB,0.56063E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,23, 5) = (/ &
 & 0.70900E+03_JPRB,0.57391E+03_JPRB,0.53367E+03_JPRB,0.56057E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,23, 5) = (/ &
 & 0.70841E+03_JPRB,0.57346E+03_JPRB,0.53341E+03_JPRB,0.56052E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,23, 5) = (/ &
 & 0.70789E+03_JPRB,0.57307E+03_JPRB,0.53316E+03_JPRB,0.56048E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,23, 5) = (/ &
 & 0.70743E+03_JPRB,0.57272E+03_JPRB,0.53290E+03_JPRB,0.56044E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,24, 5) = (/ &
 & 0.70776E+03_JPRB,0.57298E+03_JPRB,0.53293E+03_JPRB,0.56047E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,24, 5) = (/ &
 & 0.70722E+03_JPRB,0.57257E+03_JPRB,0.53269E+03_JPRB,0.56043E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,24, 5) = (/ &
 & 0.70675E+03_JPRB,0.57222E+03_JPRB,0.53248E+03_JPRB,0.56039E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,24, 5) = (/ &
 & 0.70633E+03_JPRB,0.57190E+03_JPRB,0.53228E+03_JPRB,0.56036E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,24, 5) = (/ &
 & 0.70596E+03_JPRB,0.57163E+03_JPRB,0.53207E+03_JPRB,0.56033E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,25, 5) = (/ &
 & 0.70621E+03_JPRB,0.57181E+03_JPRB,0.53206E+03_JPRB,0.56035E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,25, 5) = (/ &
 & 0.70578E+03_JPRB,0.57149E+03_JPRB,0.53188E+03_JPRB,0.56031E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,25, 5) = (/ &
 & 0.70541E+03_JPRB,0.57121E+03_JPRB,0.53172E+03_JPRB,0.56028E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,25, 5) = (/ &
 & 0.70507E+03_JPRB,0.57096E+03_JPRB,0.53156E+03_JPRB,0.56025E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,25, 5) = (/ &
 & 0.70478E+03_JPRB,0.57074E+03_JPRB,0.53138E+03_JPRB,0.56023E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,26, 5) = (/ &
 & 0.70496E+03_JPRB,0.57087E+03_JPRB,0.53135E+03_JPRB,0.56024E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,26, 5) = (/ &
 & 0.70461E+03_JPRB,0.57061E+03_JPRB,0.53122E+03_JPRB,0.56022E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,26, 5) = (/ &
 & 0.70432E+03_JPRB,0.57039E+03_JPRB,0.53110E+03_JPRB,0.56019E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,26, 5) = (/ &
 & 0.70405E+03_JPRB,0.57019E+03_JPRB,0.53097E+03_JPRB,0.56017E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,26, 5) = (/ &
 & 0.70382E+03_JPRB,0.57001E+03_JPRB,0.53082E+03_JPRB,0.56015E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,27, 5) = (/ &
 & 0.70394E+03_JPRB,0.57011E+03_JPRB,0.53077E+03_JPRB,0.56016E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,27, 5) = (/ &
 & 0.70367E+03_JPRB,0.56991E+03_JPRB,0.53069E+03_JPRB,0.56014E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,27, 5) = (/ &
 & 0.70343E+03_JPRB,0.56973E+03_JPRB,0.53060E+03_JPRB,0.56012E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,27, 5) = (/ &
 & 0.70322E+03_JPRB,0.56957E+03_JPRB,0.53049E+03_JPRB,0.56010E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,27, 5) = (/ &
 & 0.70304E+03_JPRB,0.56943E+03_JPRB,0.53036E+03_JPRB,0.56009E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,28, 5) = (/ &
 & 0.70313E+03_JPRB,0.56950E+03_JPRB,0.53032E+03_JPRB,0.56010E+03_JPRB,0.67117E+03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART18',1,ZHOOK_HANDLE)
END SUBROUTINE PART18


SUBROUTINE PART19

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART19',0,ZHOOK_HANDLE)


KB(:, 2,28, 5) = (/ &
 & 0.70291E+03_JPRB,0.56934E+03_JPRB,0.53026E+03_JPRB,0.56008E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,28, 5) = (/ &
 & 0.70272E+03_JPRB,0.56920E+03_JPRB,0.53019E+03_JPRB,0.56006E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,28, 5) = (/ &
 & 0.70256E+03_JPRB,0.56907E+03_JPRB,0.53010E+03_JPRB,0.56005E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,28, 5) = (/ &
 & 0.70241E+03_JPRB,0.56896E+03_JPRB,0.52998E+03_JPRB,0.56004E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,29, 5) = (/ &
 & 0.70247E+03_JPRB,0.56901E+03_JPRB,0.52995E+03_JPRB,0.56004E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,29, 5) = (/ &
 & 0.70230E+03_JPRB,0.56888E+03_JPRB,0.52991E+03_JPRB,0.56003E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,29, 5) = (/ &
 & 0.70215E+03_JPRB,0.56877E+03_JPRB,0.52985E+03_JPRB,0.56002E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,29, 5) = (/ &
 & 0.70202E+03_JPRB,0.56867E+03_JPRB,0.52978E+03_JPRB,0.56001E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,29, 5) = (/ &
 & 0.70190E+03_JPRB,0.56858E+03_JPRB,0.52967E+03_JPRB,0.56000E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,30, 5) = (/ &
 & 0.70194E+03_JPRB,0.56861E+03_JPRB,0.52966E+03_JPRB,0.56000E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,30, 5) = (/ &
 & 0.70181E+03_JPRB,0.56851E+03_JPRB,0.52963E+03_JPRB,0.55999E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,30, 5) = (/ &
 & 0.70169E+03_JPRB,0.56842E+03_JPRB,0.52958E+03_JPRB,0.55998E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,30, 5) = (/ &
 & 0.70158E+03_JPRB,0.56834E+03_JPRB,0.52951E+03_JPRB,0.55997E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,30, 5) = (/ &
 & 0.70149E+03_JPRB,0.56827E+03_JPRB,0.52941E+03_JPRB,0.55996E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,31, 5) = (/ &
 & 0.70151E+03_JPRB,0.56829E+03_JPRB,0.52942E+03_JPRB,0.55997E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,31, 5) = (/ &
 & 0.70141E+03_JPRB,0.56821E+03_JPRB,0.52941E+03_JPRB,0.55996E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,31, 5) = (/ &
 & 0.70131E+03_JPRB,0.56814E+03_JPRB,0.52936E+03_JPRB,0.55995E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,31, 5) = (/ &
 & 0.70123E+03_JPRB,0.56807E+03_JPRB,0.52930E+03_JPRB,0.55994E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,31, 5) = (/ &
 & 0.70115E+03_JPRB,0.56802E+03_JPRB,0.52920E+03_JPRB,0.55994E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,32, 5) = (/ &
 & 0.70117E+03_JPRB,0.56803E+03_JPRB,0.52924E+03_JPRB,0.55994E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,32, 5) = (/ &
 & 0.70109E+03_JPRB,0.56797E+03_JPRB,0.52922E+03_JPRB,0.55993E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,32, 5) = (/ &
 & 0.70101E+03_JPRB,0.56791E+03_JPRB,0.52919E+03_JPRB,0.55993E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,32, 5) = (/ &
 & 0.70094E+03_JPRB,0.56786E+03_JPRB,0.52912E+03_JPRB,0.55992E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,32, 5) = (/ &
 & 0.70088E+03_JPRB,0.56782E+03_JPRB,0.52902E+03_JPRB,0.55992E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,33, 5) = (/ &
 & 0.70090E+03_JPRB,0.56782E+03_JPRB,0.52908E+03_JPRB,0.55992E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,33, 5) = (/ &
 & 0.70083E+03_JPRB,0.56777E+03_JPRB,0.52907E+03_JPRB,0.55991E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,33, 5) = (/ &
 & 0.70077E+03_JPRB,0.56773E+03_JPRB,0.52904E+03_JPRB,0.55991E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,33, 5) = (/ &
 & 0.70072E+03_JPRB,0.56769E+03_JPRB,0.52897E+03_JPRB,0.55990E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,33, 5) = (/ &
 & 0.70067E+03_JPRB,0.56765E+03_JPRB,0.52887E+03_JPRB,0.55990E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,34, 5) = (/ &
 & 0.70068E+03_JPRB,0.56766E+03_JPRB,0.52896E+03_JPRB,0.55990E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,34, 5) = (/ &
 & 0.70062E+03_JPRB,0.56762E+03_JPRB,0.52895E+03_JPRB,0.55989E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,34, 5) = (/ &
 & 0.70057E+03_JPRB,0.56758E+03_JPRB,0.52892E+03_JPRB,0.55989E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,34, 5) = (/ &
 & 0.70053E+03_JPRB,0.56755E+03_JPRB,0.52885E+03_JPRB,0.55989E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,34, 5) = (/ &
 & 0.70049E+03_JPRB,0.56752E+03_JPRB,0.52874E+03_JPRB,0.55988E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,35, 5) = (/ &
 & 0.70050E+03_JPRB,0.56753E+03_JPRB,0.52886E+03_JPRB,0.55988E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,35, 5) = (/ &
 & 0.70046E+03_JPRB,0.56750E+03_JPRB,0.52885E+03_JPRB,0.55988E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,35, 5) = (/ &
 & 0.70042E+03_JPRB,0.56747E+03_JPRB,0.52883E+03_JPRB,0.55988E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,35, 5) = (/ &
 & 0.70039E+03_JPRB,0.56744E+03_JPRB,0.52876E+03_JPRB,0.55988E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,35, 5) = (/ &
 & 0.70035E+03_JPRB,0.56742E+03_JPRB,0.52864E+03_JPRB,0.55987E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,36, 5) = (/ &
 & 0.70037E+03_JPRB,0.56743E+03_JPRB,0.52877E+03_JPRB,0.55987E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,36, 5) = (/ &
 & 0.70033E+03_JPRB,0.56740E+03_JPRB,0.52878E+03_JPRB,0.55987E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,36, 5) = (/ &
 & 0.70030E+03_JPRB,0.56738E+03_JPRB,0.52875E+03_JPRB,0.55987E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,36, 5) = (/ &
 & 0.70027E+03_JPRB,0.56736E+03_JPRB,0.52869E+03_JPRB,0.55987E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,36, 5) = (/ &
 & 0.70025E+03_JPRB,0.56734E+03_JPRB,0.52857E+03_JPRB,0.55986E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,37, 5) = (/ &
 & 0.70026E+03_JPRB,0.56735E+03_JPRB,0.52870E+03_JPRB,0.55986E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,37, 5) = (/ &
 & 0.70023E+03_JPRB,0.56733E+03_JPRB,0.52872E+03_JPRB,0.55986E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,37, 5) = (/ &
 & 0.70020E+03_JPRB,0.56731E+03_JPRB,0.52870E+03_JPRB,0.55986E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,37, 5) = (/ &
 & 0.70018E+03_JPRB,0.56729E+03_JPRB,0.52864E+03_JPRB,0.55986E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,37, 5) = (/ &
 & 0.70016E+03_JPRB,0.56727E+03_JPRB,0.52854E+03_JPRB,0.55986E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,38, 5) = (/ &
 & 0.70017E+03_JPRB,0.56728E+03_JPRB,0.52864E+03_JPRB,0.55986E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,38, 5) = (/ &
 & 0.70015E+03_JPRB,0.56726E+03_JPRB,0.52866E+03_JPRB,0.55986E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,38, 5) = (/ &
 & 0.70012E+03_JPRB,0.56725E+03_JPRB,0.52866E+03_JPRB,0.55985E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,38, 5) = (/ &
 & 0.70010E+03_JPRB,0.56723E+03_JPRB,0.52860E+03_JPRB,0.55985E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,38, 5) = (/ &
 & 0.70009E+03_JPRB,0.56722E+03_JPRB,0.52852E+03_JPRB,0.55985E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,39, 5) = (/ &
 & 0.70010E+03_JPRB,0.56723E+03_JPRB,0.52860E+03_JPRB,0.55985E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,39, 5) = (/ &
 & 0.70008E+03_JPRB,0.56721E+03_JPRB,0.52862E+03_JPRB,0.55985E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,39, 5) = (/ &
 & 0.70006E+03_JPRB,0.56720E+03_JPRB,0.52861E+03_JPRB,0.55985E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,39, 5) = (/ &
 & 0.70004E+03_JPRB,0.56719E+03_JPRB,0.52858E+03_JPRB,0.55985E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,39, 5) = (/ &
 & 0.70003E+03_JPRB,0.56717E+03_JPRB,0.52850E+03_JPRB,0.55985E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,40, 5) = (/ &
 & 0.70004E+03_JPRB,0.56718E+03_JPRB,0.52855E+03_JPRB,0.55985E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,40, 5) = (/ &
 & 0.70002E+03_JPRB,0.56717E+03_JPRB,0.52858E+03_JPRB,0.55985E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,40, 5) = (/ &
 & 0.70001E+03_JPRB,0.56716E+03_JPRB,0.52859E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,40, 5) = (/ &
 & 0.69999E+03_JPRB,0.56715E+03_JPRB,0.52856E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,40, 5) = (/ &
 & 0.69998E+03_JPRB,0.56714E+03_JPRB,0.52849E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,41, 5) = (/ &
 & 0.69999E+03_JPRB,0.56715E+03_JPRB,0.52850E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,41, 5) = (/ &
 & 0.69998E+03_JPRB,0.56714E+03_JPRB,0.52854E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,41, 5) = (/ &
 & 0.69996E+03_JPRB,0.56713E+03_JPRB,0.52856E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,41, 5) = (/ &
 & 0.69995E+03_JPRB,0.56712E+03_JPRB,0.52854E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,41, 5) = (/ &
 & 0.69994E+03_JPRB,0.56711E+03_JPRB,0.52848E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,42, 5) = (/ &
 & 0.69995E+03_JPRB,0.56712E+03_JPRB,0.52846E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,42, 5) = (/ &
 & 0.69994E+03_JPRB,0.56711E+03_JPRB,0.52851E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,42, 5) = (/ &
 & 0.69993E+03_JPRB,0.56710E+03_JPRB,0.52853E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,42, 5) = (/ &
 & 0.69992E+03_JPRB,0.56709E+03_JPRB,0.52853E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,42, 5) = (/ &
 & 0.69991E+03_JPRB,0.56709E+03_JPRB,0.52848E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,43, 5) = (/ &
 & 0.69992E+03_JPRB,0.56709E+03_JPRB,0.52843E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,43, 5) = (/ &
 & 0.69991E+03_JPRB,0.56708E+03_JPRB,0.52848E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,43, 5) = (/ &
 & 0.69990E+03_JPRB,0.56708E+03_JPRB,0.52851E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,43, 5) = (/ &
 & 0.69989E+03_JPRB,0.56707E+03_JPRB,0.52851E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,43, 5) = (/ &
 & 0.69988E+03_JPRB,0.56707E+03_JPRB,0.52848E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,44, 5) = (/ &
 & 0.69989E+03_JPRB,0.56707E+03_JPRB,0.52838E+03_JPRB,0.55984E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,44, 5) = (/ &
 & 0.69988E+03_JPRB,0.56707E+03_JPRB,0.52844E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,44, 5) = (/ &
 & 0.69988E+03_JPRB,0.56706E+03_JPRB,0.52848E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,44, 5) = (/ &
 & 0.69987E+03_JPRB,0.56705E+03_JPRB,0.52850E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,44, 5) = (/ &
 & 0.69986E+03_JPRB,0.56705E+03_JPRB,0.52849E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,45, 5) = (/ &
 & 0.69987E+03_JPRB,0.56706E+03_JPRB,0.52834E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,45, 5) = (/ &
 & 0.69986E+03_JPRB,0.56705E+03_JPRB,0.52841E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,45, 5) = (/ &
 & 0.69986E+03_JPRB,0.56704E+03_JPRB,0.52846E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,45, 5) = (/ &
 & 0.69985E+03_JPRB,0.56704E+03_JPRB,0.52848E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,45, 5) = (/ &
 & 0.69984E+03_JPRB,0.56704E+03_JPRB,0.52848E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,46, 5) = (/ &
 & 0.69985E+03_JPRB,0.56704E+03_JPRB,0.52830E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,46, 5) = (/ &
 & 0.69984E+03_JPRB,0.56704E+03_JPRB,0.52837E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,46, 5) = (/ &
 & 0.69984E+03_JPRB,0.56703E+03_JPRB,0.52843E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,46, 5) = (/ &
 & 0.69983E+03_JPRB,0.56703E+03_JPRB,0.52847E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,46, 5) = (/ &
 & 0.69983E+03_JPRB,0.56703E+03_JPRB,0.52848E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,47, 5) = (/ &
 & 0.69984E+03_JPRB,0.56703E+03_JPRB,0.52826E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,47, 5) = (/ &
 & 0.69983E+03_JPRB,0.56703E+03_JPRB,0.52834E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,47, 5) = (/ &
 & 0.69982E+03_JPRB,0.56702E+03_JPRB,0.52840E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,47, 5) = (/ &
 & 0.69982E+03_JPRB,0.56702E+03_JPRB,0.52845E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,47, 5) = (/ &
 & 0.69982E+03_JPRB,0.56702E+03_JPRB,0.52847E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,48, 5) = (/ &
 & 0.69982E+03_JPRB,0.56702E+03_JPRB,0.52821E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,48, 5) = (/ &
 & 0.69982E+03_JPRB,0.56702E+03_JPRB,0.52830E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,48, 5) = (/ &
 & 0.69981E+03_JPRB,0.56701E+03_JPRB,0.52837E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,48, 5) = (/ &
 & 0.69981E+03_JPRB,0.56701E+03_JPRB,0.52842E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,48, 5) = (/ &
 & 0.69981E+03_JPRB,0.56701E+03_JPRB,0.52845E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,49, 5) = (/ &
 & 0.69981E+03_JPRB,0.56701E+03_JPRB,0.52817E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,49, 5) = (/ &
 & 0.69981E+03_JPRB,0.56701E+03_JPRB,0.52825E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,49, 5) = (/ &
 & 0.69980E+03_JPRB,0.56701E+03_JPRB,0.52833E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,49, 5) = (/ &
 & 0.69980E+03_JPRB,0.56700E+03_JPRB,0.52840E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,49, 5) = (/ &
 & 0.69980E+03_JPRB,0.56700E+03_JPRB,0.52844E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,50, 5) = (/ &
 & 0.69980E+03_JPRB,0.56701E+03_JPRB,0.52812E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,50, 5) = (/ &
 & 0.69980E+03_JPRB,0.56700E+03_JPRB,0.52821E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,50, 5) = (/ &
 & 0.69980E+03_JPRB,0.56700E+03_JPRB,0.52830E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,50, 5) = (/ &
 & 0.69979E+03_JPRB,0.56700E+03_JPRB,0.52837E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,50, 5) = (/ &
 & 0.69979E+03_JPRB,0.56700E+03_JPRB,0.52842E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,51, 5) = (/ &
 & 0.69979E+03_JPRB,0.56700E+03_JPRB,0.52807E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,51, 5) = (/ &
 & 0.69979E+03_JPRB,0.56700E+03_JPRB,0.52818E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,51, 5) = (/ &
 & 0.69979E+03_JPRB,0.56699E+03_JPRB,0.52827E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,51, 5) = (/ &
 & 0.69979E+03_JPRB,0.56699E+03_JPRB,0.52834E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,51, 5) = (/ &
 & 0.69978E+03_JPRB,0.56699E+03_JPRB,0.52841E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,52, 5) = (/ &
 & 0.69979E+03_JPRB,0.56699E+03_JPRB,0.52802E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,52, 5) = (/ &
 & 0.69979E+03_JPRB,0.56699E+03_JPRB,0.52814E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,52, 5) = (/ &
 & 0.69978E+03_JPRB,0.56699E+03_JPRB,0.52823E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,52, 5) = (/ &
 & 0.69978E+03_JPRB,0.56699E+03_JPRB,0.52831E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,52, 5) = (/ &
 & 0.69978E+03_JPRB,0.56699E+03_JPRB,0.52838E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,53, 5) = (/ &
 & 0.69978E+03_JPRB,0.56699E+03_JPRB,0.52798E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,53, 5) = (/ &
 & 0.69978E+03_JPRB,0.56699E+03_JPRB,0.52809E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,53, 5) = (/ &
 & 0.69978E+03_JPRB,0.56699E+03_JPRB,0.52820E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,53, 5) = (/ &
 & 0.69978E+03_JPRB,0.56699E+03_JPRB,0.52828E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,53, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52836E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,54, 5) = (/ &
 & 0.69978E+03_JPRB,0.56699E+03_JPRB,0.52794E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,54, 5) = (/ &
 & 0.69978E+03_JPRB,0.56699E+03_JPRB,0.52804E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,54, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52816E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,54, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52825E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,54, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52833E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,55, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52790E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,55, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52801E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,55, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52812E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,55, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52822E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,55, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52830E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,56, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52786E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,56, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52797E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,56, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52808E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,56, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52819E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,56, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52827E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,57, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52781E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART19',1,ZHOOK_HANDLE)
END SUBROUTINE PART19


SUBROUTINE PART20

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART20',0,ZHOOK_HANDLE)


KB(:, 2,57, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52794E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,57, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52805E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,57, 5) = (/ &
 & 0.69976E+03_JPRB,0.56698E+03_JPRB,0.52815E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,57, 5) = (/ &
 & 0.69976E+03_JPRB,0.56698E+03_JPRB,0.52825E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,58, 5) = (/ &
 & 0.69977E+03_JPRB,0.56698E+03_JPRB,0.52777E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,58, 5) = (/ &
 & 0.69976E+03_JPRB,0.56698E+03_JPRB,0.52790E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,58, 5) = (/ &
 & 0.69976E+03_JPRB,0.56698E+03_JPRB,0.52801E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,58, 5) = (/ &
 & 0.69976E+03_JPRB,0.56698E+03_JPRB,0.52812E+03_JPRB,0.55982E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,58, 5) = (/ &
 & 0.69976E+03_JPRB,0.56697E+03_JPRB,0.52822E+03_JPRB,0.55982E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,59, 5) = (/ &
 & 0.69976E+03_JPRB,0.56698E+03_JPRB,0.52775E+03_JPRB,0.55983E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 2,59, 5) = (/ &
 & 0.69976E+03_JPRB,0.56698E+03_JPRB,0.52788E+03_JPRB,0.55982E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 3,59, 5) = (/ &
 & 0.69976E+03_JPRB,0.56697E+03_JPRB,0.52801E+03_JPRB,0.55982E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 4,59, 5) = (/ &
 & 0.69976E+03_JPRB,0.56697E+03_JPRB,0.52811E+03_JPRB,0.55982E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 5,59, 5) = (/ &
 & 0.69976E+03_JPRB,0.56697E+03_JPRB,0.52821E+03_JPRB,0.55982E+03_JPRB,0.67117E+03_JPRB /)  
KB(:, 1,13, 6) = (/ &
 & 0.99182E+03_JPRB,0.76479E+03_JPRB,0.58123E+03_JPRB,0.73928E+03_JPRB,0.94808E+03_JPRB /)  
KB(:, 2,13, 6) = (/ &
 & 0.98417E+03_JPRB,0.75904E+03_JPRB,0.57888E+03_JPRB,0.73991E+03_JPRB,0.94920E+03_JPRB /)  
KB(:, 3,13, 6) = (/ &
 & 0.97757E+03_JPRB,0.75410E+03_JPRB,0.57650E+03_JPRB,0.74029E+03_JPRB,0.94995E+03_JPRB /)  
KB(:, 4,13, 6) = (/ &
 & 0.97184E+03_JPRB,0.74980E+03_JPRB,0.57428E+03_JPRB,0.74046E+03_JPRB,0.95033E+03_JPRB /)  
KB(:, 5,13, 6) = (/ &
 & 0.96680E+03_JPRB,0.74602E+03_JPRB,0.57217E+03_JPRB,0.74043E+03_JPRB,0.95033E+03_JPRB /)  
KB(:, 1,14, 6) = (/ &
 & 0.97264E+03_JPRB,0.75040E+03_JPRB,0.57482E+03_JPRB,0.73884E+03_JPRB,0.94820E+03_JPRB /)  
KB(:, 2,14, 6) = (/ &
 & 0.96646E+03_JPRB,0.74576E+03_JPRB,0.57229E+03_JPRB,0.73949E+03_JPRB,0.94928E+03_JPRB /)  
KB(:, 3,14, 6) = (/ &
 & 0.96113E+03_JPRB,0.74177E+03_JPRB,0.57016E+03_JPRB,0.73988E+03_JPRB,0.95000E+03_JPRB /)  
KB(:, 4,14, 6) = (/ &
 & 0.95649E+03_JPRB,0.73829E+03_JPRB,0.56822E+03_JPRB,0.74006E+03_JPRB,0.95035E+03_JPRB /)  
KB(:, 5,14, 6) = (/ &
 & 0.95242E+03_JPRB,0.73523E+03_JPRB,0.56635E+03_JPRB,0.74003E+03_JPRB,0.95032E+03_JPRB /)  
KB(:, 1,15, 6) = (/ &
 & 0.95700E+03_JPRB,0.73867E+03_JPRB,0.56844E+03_JPRB,0.73851E+03_JPRB,0.94832E+03_JPRB /)  
KB(:, 2,15, 6) = (/ &
 & 0.95201E+03_JPRB,0.73493E+03_JPRB,0.56632E+03_JPRB,0.73916E+03_JPRB,0.94937E+03_JPRB /)  
KB(:, 3,15, 6) = (/ &
 & 0.94772E+03_JPRB,0.73170E+03_JPRB,0.56426E+03_JPRB,0.73956E+03_JPRB,0.95005E+03_JPRB /)  
KB(:, 4,15, 6) = (/ &
 & 0.94397E+03_JPRB,0.72889E+03_JPRB,0.56242E+03_JPRB,0.73973E+03_JPRB,0.95035E+03_JPRB /)  
KB(:, 5,15, 6) = (/ &
 & 0.94067E+03_JPRB,0.72642E+03_JPRB,0.56076E+03_JPRB,0.73970E+03_JPRB,0.95029E+03_JPRB /)  
KB(:, 1,16, 6) = (/ &
 & 0.94427E+03_JPRB,0.72912E+03_JPRB,0.56257E+03_JPRB,0.73826E+03_JPRB,0.94846E+03_JPRB /)  
KB(:, 2,16, 6) = (/ &
 & 0.94026E+03_JPRB,0.72611E+03_JPRB,0.56064E+03_JPRB,0.73891E+03_JPRB,0.94946E+03_JPRB /)  
KB(:, 3,16, 6) = (/ &
 & 0.93679E+03_JPRB,0.72351E+03_JPRB,0.55906E+03_JPRB,0.73929E+03_JPRB,0.95011E+03_JPRB /)  
KB(:, 4,16, 6) = (/ &
 & 0.93377E+03_JPRB,0.72124E+03_JPRB,0.55770E+03_JPRB,0.73948E+03_JPRB,0.95036E+03_JPRB /)  
KB(:, 5,16, 6) = (/ &
 & 0.93110E+03_JPRB,0.71925E+03_JPRB,0.55641E+03_JPRB,0.73943E+03_JPRB,0.95027E+03_JPRB /)  
KB(:, 1,17, 6) = (/ &
 & 0.93395E+03_JPRB,0.72138E+03_JPRB,0.55755E+03_JPRB,0.73807E+03_JPRB,0.94857E+03_JPRB /)  
KB(:, 2,17, 6) = (/ &
 & 0.93072E+03_JPRB,0.71896E+03_JPRB,0.55622E+03_JPRB,0.73871E+03_JPRB,0.94955E+03_JPRB /)  
KB(:, 3,17, 6) = (/ &
 & 0.92792E+03_JPRB,0.71686E+03_JPRB,0.55497E+03_JPRB,0.73909E+03_JPRB,0.95015E+03_JPRB /)  
KB(:, 4,17, 6) = (/ &
 & 0.92548E+03_JPRB,0.71503E+03_JPRB,0.55372E+03_JPRB,0.73925E+03_JPRB,0.95038E+03_JPRB /)  
KB(:, 5,17, 6) = (/ &
 & 0.92333E+03_JPRB,0.71341E+03_JPRB,0.55252E+03_JPRB,0.73921E+03_JPRB,0.95024E+03_JPRB /)  
KB(:, 1,18, 6) = (/ &
 & 0.92558E+03_JPRB,0.71510E+03_JPRB,0.55360E+03_JPRB,0.73792E+03_JPRB,0.94869E+03_JPRB /)  
KB(:, 2,18, 6) = (/ &
 & 0.92297E+03_JPRB,0.71315E+03_JPRB,0.55237E+03_JPRB,0.73856E+03_JPRB,0.94963E+03_JPRB /)  
KB(:, 3,18, 6) = (/ &
 & 0.92072E+03_JPRB,0.71146E+03_JPRB,0.55114E+03_JPRB,0.73892E+03_JPRB,0.95019E+03_JPRB /)  
KB(:, 4,18, 6) = (/ &
 & 0.91874E+03_JPRB,0.70998E+03_JPRB,0.55001E+03_JPRB,0.73908E+03_JPRB,0.95037E+03_JPRB /)  
KB(:, 5,18, 6) = (/ &
 & 0.91700E+03_JPRB,0.70867E+03_JPRB,0.54903E+03_JPRB,0.73903E+03_JPRB,0.95021E+03_JPRB /)  
KB(:, 1,19, 6) = (/ &
 & 0.91879E+03_JPRB,0.71001E+03_JPRB,0.55004E+03_JPRB,0.73782E+03_JPRB,0.94880E+03_JPRB /)  
KB(:, 2,19, 6) = (/ &
 & 0.91668E+03_JPRB,0.70843E+03_JPRB,0.54889E+03_JPRB,0.73844E+03_JPRB,0.94970E+03_JPRB /)  
KB(:, 3,19, 6) = (/ &
 & 0.91486E+03_JPRB,0.70706E+03_JPRB,0.54830E+03_JPRB,0.73880E+03_JPRB,0.95023E+03_JPRB /)  
KB(:, 4,19, 6) = (/ &
 & 0.91327E+03_JPRB,0.70587E+03_JPRB,0.54705E+03_JPRB,0.73894E+03_JPRB,0.95037E+03_JPRB /)  
KB(:, 5,19, 6) = (/ &
 & 0.91186E+03_JPRB,0.70481E+03_JPRB,0.54615E+03_JPRB,0.73887E+03_JPRB,0.95019E+03_JPRB /)  
KB(:, 1,20, 6) = (/ &
 & 0.91324E+03_JPRB,0.70585E+03_JPRB,0.54718E+03_JPRB,0.73776E+03_JPRB,0.94893E+03_JPRB /)  
KB(:, 2,20, 6) = (/ &
 & 0.91155E+03_JPRB,0.70458E+03_JPRB,0.54599E+03_JPRB,0.73835E+03_JPRB,0.94979E+03_JPRB /)  
KB(:, 3,20, 6) = (/ &
 & 0.91008E+03_JPRB,0.70348E+03_JPRB,0.54519E+03_JPRB,0.73870E+03_JPRB,0.95026E+03_JPRB /)  
KB(:, 4,20, 6) = (/ &
 & 0.90879E+03_JPRB,0.70251E+03_JPRB,0.54450E+03_JPRB,0.73882E+03_JPRB,0.95036E+03_JPRB /)  
KB(:, 5,20, 6) = (/ &
 & 0.90766E+03_JPRB,0.70166E+03_JPRB,0.54390E+03_JPRB,0.73874E+03_JPRB,0.95013E+03_JPRB /)  
KB(:, 1,21, 6) = (/ &
 & 0.90874E+03_JPRB,0.70247E+03_JPRB,0.54444E+03_JPRB,0.73773E+03_JPRB,0.94905E+03_JPRB /)  
KB(:, 2,21, 6) = (/ &
 & 0.90737E+03_JPRB,0.70145E+03_JPRB,0.54370E+03_JPRB,0.73831E+03_JPRB,0.94986E+03_JPRB /)  
KB(:, 3,21, 6) = (/ &
 & 0.90619E+03_JPRB,0.70056E+03_JPRB,0.54308E+03_JPRB,0.73862E+03_JPRB,0.95029E+03_JPRB /)  
KB(:, 4,21, 6) = (/ &
 & 0.90515E+03_JPRB,0.69978E+03_JPRB,0.54255E+03_JPRB,0.73872E+03_JPRB,0.95035E+03_JPRB /)  
KB(:, 5,21, 6) = (/ &
 & 0.90424E+03_JPRB,0.69910E+03_JPRB,0.54208E+03_JPRB,0.73862E+03_JPRB,0.95008E+03_JPRB /)  
KB(:, 1,22, 6) = (/ &
 & 0.90500E+03_JPRB,0.69967E+03_JPRB,0.54240E+03_JPRB,0.73776E+03_JPRB,0.94923E+03_JPRB /)  
KB(:, 2,22, 6) = (/ &
 & 0.90392E+03_JPRB,0.69886E+03_JPRB,0.54185E+03_JPRB,0.73829E+03_JPRB,0.94997E+03_JPRB /)  
KB(:, 3,22, 6) = (/ &
 & 0.90297E+03_JPRB,0.69815E+03_JPRB,0.54138E+03_JPRB,0.73857E+03_JPRB,0.95033E+03_JPRB /)  
KB(:, 4,22, 6) = (/ &
 & 0.90215E+03_JPRB,0.69753E+03_JPRB,0.54099E+03_JPRB,0.73864E+03_JPRB,0.95033E+03_JPRB /)  
KB(:, 5,22, 6) = (/ &
 & 0.90141E+03_JPRB,0.69698E+03_JPRB,0.54066E+03_JPRB,0.73851E+03_JPRB,0.94999E+03_JPRB /)  
KB(:, 1,23, 6) = (/ &
 & 0.90199E+03_JPRB,0.69741E+03_JPRB,0.54083E+03_JPRB,0.73780E+03_JPRB,0.94940E+03_JPRB /)  
KB(:, 2,23, 6) = (/ &
 & 0.90112E+03_JPRB,0.69676E+03_JPRB,0.54044E+03_JPRB,0.73828E+03_JPRB,0.95007E+03_JPRB /)  
KB(:, 3,23, 6) = (/ &
 & 0.90037E+03_JPRB,0.69620E+03_JPRB,0.54010E+03_JPRB,0.73854E+03_JPRB,0.95036E+03_JPRB /)  
KB(:, 4,23, 6) = (/ &
 & 0.89971E+03_JPRB,0.69570E+03_JPRB,0.53983E+03_JPRB,0.73858E+03_JPRB,0.95029E+03_JPRB /)  
KB(:, 5,23, 6) = (/ &
 & 0.89912E+03_JPRB,0.69526E+03_JPRB,0.53959E+03_JPRB,0.73840E+03_JPRB,0.94989E+03_JPRB /)  
KB(:, 1,24, 6) = (/ &
 & 0.89955E+03_JPRB,0.69558E+03_JPRB,0.53965E+03_JPRB,0.73787E+03_JPRB,0.94957E+03_JPRB /)  
KB(:, 2,24, 6) = (/ &
 & 0.89886E+03_JPRB,0.69507E+03_JPRB,0.53937E+03_JPRB,0.73829E+03_JPRB,0.95016E+03_JPRB /)  
KB(:, 3,24, 6) = (/ &
 & 0.89826E+03_JPRB,0.69461E+03_JPRB,0.53914E+03_JPRB,0.73851E+03_JPRB,0.95038E+03_JPRB /)  
KB(:, 4,24, 6) = (/ &
 & 0.89773E+03_JPRB,0.69422E+03_JPRB,0.53895E+03_JPRB,0.73850E+03_JPRB,0.95023E+03_JPRB /)  
KB(:, 5,24, 6) = (/ &
 & 0.89726E+03_JPRB,0.69387E+03_JPRB,0.53876E+03_JPRB,0.73829E+03_JPRB,0.94977E+03_JPRB /)  
KB(:, 1,25, 6) = (/ &
 & 0.89758E+03_JPRB,0.69410E+03_JPRB,0.53876E+03_JPRB,0.73792E+03_JPRB,0.94973E+03_JPRB /)  
KB(:, 2,25, 6) = (/ &
 & 0.89703E+03_JPRB,0.69369E+03_JPRB,0.53857E+03_JPRB,0.73831E+03_JPRB,0.95024E+03_JPRB /)  
KB(:, 3,25, 6) = (/ &
 & 0.89655E+03_JPRB,0.69333E+03_JPRB,0.53841E+03_JPRB,0.73848E+03_JPRB,0.95037E+03_JPRB /)  
KB(:, 4,25, 6) = (/ &
 & 0.89613E+03_JPRB,0.69302E+03_JPRB,0.53826E+03_JPRB,0.73843E+03_JPRB,0.95016E+03_JPRB /)  
KB(:, 5,25, 6) = (/ &
 & 0.89576E+03_JPRB,0.69273E+03_JPRB,0.53811E+03_JPRB,0.73818E+03_JPRB,0.94963E+03_JPRB /)  
KB(:, 1,26, 6) = (/ &
 & 0.89598E+03_JPRB,0.69290E+03_JPRB,0.53808E+03_JPRB,0.73799E+03_JPRB,0.94987E+03_JPRB /)  
KB(:, 2,26, 6) = (/ &
 & 0.89555E+03_JPRB,0.69258E+03_JPRB,0.53794E+03_JPRB,0.73834E+03_JPRB,0.95030E+03_JPRB /)  
KB(:, 3,26, 6) = (/ &
 & 0.89517E+03_JPRB,0.69229E+03_JPRB,0.53782E+03_JPRB,0.73845E+03_JPRB,0.95035E+03_JPRB /)  
KB(:, 4,26, 6) = (/ &
 & 0.89483E+03_JPRB,0.69204E+03_JPRB,0.53770E+03_JPRB,0.73836E+03_JPRB,0.95007E+03_JPRB /)  
KB(:, 5,26, 6) = (/ &
 & 0.89453E+03_JPRB,0.69182E+03_JPRB,0.53759E+03_JPRB,0.73806E+03_JPRB,0.94946E+03_JPRB /)  
KB(:, 1,27, 6) = (/ &
 & 0.89469E+03_JPRB,0.69194E+03_JPRB,0.53754E+03_JPRB,0.73806E+03_JPRB,0.95001E+03_JPRB /)  
KB(:, 2,27, 6) = (/ &
 & 0.89435E+03_JPRB,0.69168E+03_JPRB,0.53744E+03_JPRB,0.73835E+03_JPRB,0.95034E+03_JPRB /)  
KB(:, 3,27, 6) = (/ &
 & 0.89405E+03_JPRB,0.69145E+03_JPRB,0.53736E+03_JPRB,0.73843E+03_JPRB,0.95031E+03_JPRB /)  
KB(:, 4,27, 6) = (/ &
 & 0.89378E+03_JPRB,0.69125E+03_JPRB,0.53727E+03_JPRB,0.73828E+03_JPRB,0.94995E+03_JPRB /)  
KB(:, 5,27, 6) = (/ &
 & 0.89354E+03_JPRB,0.69107E+03_JPRB,0.53717E+03_JPRB,0.73792E+03_JPRB,0.94926E+03_JPRB /)  
KB(:, 1,28, 6) = (/ &
 & 0.89366E+03_JPRB,0.69116E+03_JPRB,0.53711E+03_JPRB,0.73814E+03_JPRB,0.95012E+03_JPRB /)  
KB(:, 2,28, 6) = (/ &
 & 0.89338E+03_JPRB,0.69096E+03_JPRB,0.53705E+03_JPRB,0.73836E+03_JPRB,0.95037E+03_JPRB /)  
KB(:, 3,28, 6) = (/ &
 & 0.89314E+03_JPRB,0.69078E+03_JPRB,0.53699E+03_JPRB,0.73838E+03_JPRB,0.95026E+03_JPRB /)  
KB(:, 4,28, 6) = (/ &
 & 0.89293E+03_JPRB,0.69062E+03_JPRB,0.53692E+03_JPRB,0.73819E+03_JPRB,0.94982E+03_JPRB /)  
KB(:, 5,28, 6) = (/ &
 & 0.89274E+03_JPRB,0.69047E+03_JPRB,0.53684E+03_JPRB,0.73778E+03_JPRB,0.94904E+03_JPRB /)  
KB(:, 1,29, 6) = (/ &
 & 0.89282E+03_JPRB,0.69053E+03_JPRB,0.53678E+03_JPRB,0.73818E+03_JPRB,0.95022E+03_JPRB /)  
KB(:, 2,29, 6) = (/ &
 & 0.89261E+03_JPRB,0.69037E+03_JPRB,0.53674E+03_JPRB,0.73837E+03_JPRB,0.95037E+03_JPRB /)  
KB(:, 3,29, 6) = (/ &
 & 0.89241E+03_JPRB,0.69023E+03_JPRB,0.53670E+03_JPRB,0.73834E+03_JPRB,0.95018E+03_JPRB /)  
KB(:, 4,29, 6) = (/ &
 & 0.89224E+03_JPRB,0.69010E+03_JPRB,0.53663E+03_JPRB,0.73810E+03_JPRB,0.94966E+03_JPRB /)  
KB(:, 5,29, 6) = (/ &
 & 0.89209E+03_JPRB,0.68999E+03_JPRB,0.53656E+03_JPRB,0.73762E+03_JPRB,0.94880E+03_JPRB /)  
KB(:, 1,30, 6) = (/ &
 & 0.89215E+03_JPRB,0.69003E+03_JPRB,0.53652E+03_JPRB,0.73823E+03_JPRB,0.95029E+03_JPRB /)  
KB(:, 2,30, 6) = (/ &
 & 0.89198E+03_JPRB,0.68990E+03_JPRB,0.53650E+03_JPRB,0.73836E+03_JPRB,0.95035E+03_JPRB /)  
KB(:, 3,30, 6) = (/ &
 & 0.89183E+03_JPRB,0.68979E+03_JPRB,0.53646E+03_JPRB,0.73828E+03_JPRB,0.95008E+03_JPRB /)  
KB(:, 4,30, 6) = (/ &
 & 0.89169E+03_JPRB,0.68969E+03_JPRB,0.53641E+03_JPRB,0.73798E+03_JPRB,0.94948E+03_JPRB /)  
KB(:, 5,30, 6) = (/ &
 & 0.89157E+03_JPRB,0.68960E+03_JPRB,0.53634E+03_JPRB,0.73744E+03_JPRB,0.94852E+03_JPRB /)  
KB(:, 1,31, 6) = (/ &
 & 0.89161E+03_JPRB,0.68962E+03_JPRB,0.53631E+03_JPRB,0.73827E+03_JPRB,0.95034E+03_JPRB /)  
KB(:, 2,31, 6) = (/ &
 & 0.89147E+03_JPRB,0.68952E+03_JPRB,0.53629E+03_JPRB,0.73835E+03_JPRB,0.95031E+03_JPRB /)  
KB(:, 3,31, 6) = (/ &
 & 0.89135E+03_JPRB,0.68943E+03_JPRB,0.53627E+03_JPRB,0.73821E+03_JPRB,0.94996E+03_JPRB /)  
KB(:, 4,31, 6) = (/ &
 & 0.89124E+03_JPRB,0.68935E+03_JPRB,0.53622E+03_JPRB,0.73786E+03_JPRB,0.94927E+03_JPRB /)  
KB(:, 5,31, 6) = (/ &
 & 0.89115E+03_JPRB,0.68928E+03_JPRB,0.53615E+03_JPRB,0.73725E+03_JPRB,0.94822E+03_JPRB /)  
KB(:, 1,32, 6) = (/ &
 & 0.89117E+03_JPRB,0.68930E+03_JPRB,0.53614E+03_JPRB,0.73830E+03_JPRB,0.95037E+03_JPRB /)  
KB(:, 2,32, 6) = (/ &
 & 0.89106E+03_JPRB,0.68922E+03_JPRB,0.53614E+03_JPRB,0.73833E+03_JPRB,0.95025E+03_JPRB /)  
KB(:, 3,32, 6) = (/ &
 & 0.89097E+03_JPRB,0.68914E+03_JPRB,0.53611E+03_JPRB,0.73813E+03_JPRB,0.94981E+03_JPRB /)  
KB(:, 4,32, 6) = (/ &
 & 0.89088E+03_JPRB,0.68908E+03_JPRB,0.53608E+03_JPRB,0.73772E+03_JPRB,0.94903E+03_JPRB /)  
KB(:, 5,32, 6) = (/ &
 & 0.89081E+03_JPRB,0.68902E+03_JPRB,0.53600E+03_JPRB,0.73703E+03_JPRB,0.94789E+03_JPRB /)  
KB(:, 1,33, 6) = (/ &
 & 0.89082E+03_JPRB,0.68903E+03_JPRB,0.53602E+03_JPRB,0.73832E+03_JPRB,0.95037E+03_JPRB /)  
KB(:, 2,33, 6) = (/ &
 & 0.89073E+03_JPRB,0.68897E+03_JPRB,0.53601E+03_JPRB,0.73829E+03_JPRB,0.95017E+03_JPRB /)  
KB(:, 3,33, 6) = (/ &
 & 0.89066E+03_JPRB,0.68891E+03_JPRB,0.53599E+03_JPRB,0.73804E+03_JPRB,0.94964E+03_JPRB /)  
KB(:, 4,33, 6) = (/ &
 & 0.89059E+03_JPRB,0.68886E+03_JPRB,0.53595E+03_JPRB,0.73756E+03_JPRB,0.94877E+03_JPRB /)  
KB(:, 5,33, 6) = (/ &
 & 0.89053E+03_JPRB,0.68882E+03_JPRB,0.53586E+03_JPRB,0.73678E+03_JPRB,0.94753E+03_JPRB /)  
KB(:, 1,34, 6) = (/ &
 & 0.89054E+03_JPRB,0.68882E+03_JPRB,0.53592E+03_JPRB,0.73832E+03_JPRB,0.95035E+03_JPRB /)  
KB(:, 2,34, 6) = (/ &
 & 0.89047E+03_JPRB,0.68877E+03_JPRB,0.53592E+03_JPRB,0.73824E+03_JPRB,0.95008E+03_JPRB /)  
KB(:, 3,34, 6) = (/ &
 & 0.89041E+03_JPRB,0.68873E+03_JPRB,0.53589E+03_JPRB,0.73795E+03_JPRB,0.94947E+03_JPRB /)  
KB(:, 4,34, 6) = (/ &
 & 0.89036E+03_JPRB,0.68869E+03_JPRB,0.53584E+03_JPRB,0.73741E+03_JPRB,0.94852E+03_JPRB /)  
KB(:, 5,34, 6) = (/ &
 & 0.89031E+03_JPRB,0.68865E+03_JPRB,0.53575E+03_JPRB,0.73655E+03_JPRB,0.94719E+03_JPRB /)  
KB(:, 1,35, 6) = (/ &
 & 0.89032E+03_JPRB,0.68866E+03_JPRB,0.53584E+03_JPRB,0.73832E+03_JPRB,0.95034E+03_JPRB /)  
KB(:, 2,35, 6) = (/ &
 & 0.89027E+03_JPRB,0.68862E+03_JPRB,0.53584E+03_JPRB,0.73821E+03_JPRB,0.95002E+03_JPRB /)  
KB(:, 3,35, 6) = (/ &
 & 0.89022E+03_JPRB,0.68858E+03_JPRB,0.53581E+03_JPRB,0.73788E+03_JPRB,0.94937E+03_JPRB /)  
KB(:, 4,35, 6) = (/ &
 & 0.89017E+03_JPRB,0.68855E+03_JPRB,0.53576E+03_JPRB,0.73731E+03_JPRB,0.94836E+03_JPRB /)  
KB(:, 5,35, 6) = (/ &
 & 0.89013E+03_JPRB,0.68852E+03_JPRB,0.53567E+03_JPRB,0.73640E+03_JPRB,0.94700E+03_JPRB /)  
KB(:, 1,36, 6) = (/ &
 & 0.89015E+03_JPRB,0.68853E+03_JPRB,0.53577E+03_JPRB,0.73831E+03_JPRB,0.95033E+03_JPRB /)  
KB(:, 2,36, 6) = (/ &
 & 0.89010E+03_JPRB,0.68849E+03_JPRB,0.53577E+03_JPRB,0.73820E+03_JPRB,0.95001E+03_JPRB /)  
KB(:, 3,36, 6) = (/ &
 & 0.89006E+03_JPRB,0.68846E+03_JPRB,0.53575E+03_JPRB,0.73787E+03_JPRB,0.94935E+03_JPRB /)  
KB(:, 4,36, 6) = (/ &
 & 0.89003E+03_JPRB,0.68844E+03_JPRB,0.53570E+03_JPRB,0.73729E+03_JPRB,0.94834E+03_JPRB /)  
KB(:, 5,36, 6) = (/ &
 & 0.88999E+03_JPRB,0.68841E+03_JPRB,0.53561E+03_JPRB,0.73637E+03_JPRB,0.94696E+03_JPRB /)  
KB(:, 1,37, 6) = (/ &
 & 0.89001E+03_JPRB,0.68843E+03_JPRB,0.53571E+03_JPRB,0.73831E+03_JPRB,0.95036E+03_JPRB /)  
KB(:, 2,37, 6) = (/ &
 & 0.88997E+03_JPRB,0.68840E+03_JPRB,0.53572E+03_JPRB,0.73823E+03_JPRB,0.95007E+03_JPRB /)  
KB(:, 3,37, 6) = (/ &
 & 0.88994E+03_JPRB,0.68837E+03_JPRB,0.53570E+03_JPRB,0.73792E+03_JPRB,0.94946E+03_JPRB /)  
KB(:, 4,37, 6) = (/ &
 & 0.88991E+03_JPRB,0.68835E+03_JPRB,0.53566E+03_JPRB,0.73738E+03_JPRB,0.94849E+03_JPRB /)  
KB(:, 5,37, 6) = (/ &
 & 0.88988E+03_JPRB,0.68833E+03_JPRB,0.53557E+03_JPRB,0.73651E+03_JPRB,0.94716E+03_JPRB /)  
KB(:, 1,38, 6) = (/ &
 & 0.88990E+03_JPRB,0.68834E+03_JPRB,0.53566E+03_JPRB,0.73830E+03_JPRB,0.95036E+03_JPRB /)  
KB(:, 2,38, 6) = (/ &
 & 0.88987E+03_JPRB,0.68832E+03_JPRB,0.53568E+03_JPRB,0.73825E+03_JPRB,0.95013E+03_JPRB /)  
KB(:, 3,38, 6) = (/ &
 & 0.88984E+03_JPRB,0.68830E+03_JPRB,0.53566E+03_JPRB,0.73798E+03_JPRB,0.94957E+03_JPRB /)  
KB(:, 4,38, 6) = (/ &
 & 0.88982E+03_JPRB,0.68828E+03_JPRB,0.53563E+03_JPRB,0.73747E+03_JPRB,0.94865E+03_JPRB /)  
KB(:, 5,38, 6) = (/ &
 & 0.88979E+03_JPRB,0.68826E+03_JPRB,0.53555E+03_JPRB,0.73665E+03_JPRB,0.94737E+03_JPRB /)  
KB(:, 1,39, 6) = (/ &
 & 0.88981E+03_JPRB,0.68827E+03_JPRB,0.53562E+03_JPRB,0.73829E+03_JPRB,0.95037E+03_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART20',1,ZHOOK_HANDLE)
END SUBROUTINE PART20


SUBROUTINE PART21

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART21',0,ZHOOK_HANDLE)


KB(:, 2,39, 6) = (/ &
 & 0.88978E+03_JPRB,0.68825E+03_JPRB,0.53564E+03_JPRB,0.73826E+03_JPRB,0.95018E+03_JPRB /)  
KB(:, 3,39, 6) = (/ &
 & 0.88976E+03_JPRB,0.68824E+03_JPRB,0.53563E+03_JPRB,0.73803E+03_JPRB,0.94966E+03_JPRB /)  
KB(:, 4,39, 6) = (/ &
 & 0.88974E+03_JPRB,0.68822E+03_JPRB,0.53560E+03_JPRB,0.73755E+03_JPRB,0.94880E+03_JPRB /)  
KB(:, 5,39, 6) = (/ &
 & 0.88972E+03_JPRB,0.68821E+03_JPRB,0.53553E+03_JPRB,0.73679E+03_JPRB,0.94757E+03_JPRB /)  
KB(:, 1,40, 6) = (/ &
 & 0.88973E+03_JPRB,0.68822E+03_JPRB,0.53558E+03_JPRB,0.73826E+03_JPRB,0.95037E+03_JPRB /)  
KB(:, 2,40, 6) = (/ &
 & 0.88971E+03_JPRB,0.68820E+03_JPRB,0.53561E+03_JPRB,0.73829E+03_JPRB,0.95026E+03_JPRB /)  
KB(:, 3,40, 6) = (/ &
 & 0.88969E+03_JPRB,0.68819E+03_JPRB,0.53561E+03_JPRB,0.73810E+03_JPRB,0.94982E+03_JPRB /)  
KB(:, 4,40, 6) = (/ &
 & 0.88967E+03_JPRB,0.68817E+03_JPRB,0.53559E+03_JPRB,0.73769E+03_JPRB,0.94904E+03_JPRB /)  
KB(:, 5,40, 6) = (/ &
 & 0.88966E+03_JPRB,0.68816E+03_JPRB,0.53553E+03_JPRB,0.73700E+03_JPRB,0.94790E+03_JPRB /)  
KB(:, 1,41, 6) = (/ &
 & 0.88967E+03_JPRB,0.68817E+03_JPRB,0.53555E+03_JPRB,0.73822E+03_JPRB,0.95035E+03_JPRB /)  
KB(:, 2,41, 6) = (/ &
 & 0.88965E+03_JPRB,0.68816E+03_JPRB,0.53558E+03_JPRB,0.73830E+03_JPRB,0.95031E+03_JPRB /)  
KB(:, 3,41, 6) = (/ &
 & 0.88964E+03_JPRB,0.68815E+03_JPRB,0.53559E+03_JPRB,0.73817E+03_JPRB,0.94996E+03_JPRB /)  
KB(:, 4,41, 6) = (/ &
 & 0.88962E+03_JPRB,0.68813E+03_JPRB,0.53558E+03_JPRB,0.73782E+03_JPRB,0.94927E+03_JPRB /)  
KB(:, 5,41, 6) = (/ &
 & 0.88961E+03_JPRB,0.68812E+03_JPRB,0.53553E+03_JPRB,0.73722E+03_JPRB,0.94822E+03_JPRB /)  
KB(:, 1,42, 6) = (/ &
 & 0.88962E+03_JPRB,0.68813E+03_JPRB,0.53551E+03_JPRB,0.73816E+03_JPRB,0.95029E+03_JPRB /)  
KB(:, 2,42, 6) = (/ &
 & 0.88960E+03_JPRB,0.68812E+03_JPRB,0.53555E+03_JPRB,0.73830E+03_JPRB,0.95035E+03_JPRB /)  
KB(:, 3,42, 6) = (/ &
 & 0.88959E+03_JPRB,0.68811E+03_JPRB,0.53557E+03_JPRB,0.73822E+03_JPRB,0.95008E+03_JPRB /)  
KB(:, 4,42, 6) = (/ &
 & 0.88958E+03_JPRB,0.68810E+03_JPRB,0.53556E+03_JPRB,0.73793E+03_JPRB,0.94948E+03_JPRB /)  
KB(:, 5,42, 6) = (/ &
 & 0.88957E+03_JPRB,0.68809E+03_JPRB,0.53553E+03_JPRB,0.73739E+03_JPRB,0.94853E+03_JPRB /)  
KB(:, 1,43, 6) = (/ &
 & 0.88958E+03_JPRB,0.68810E+03_JPRB,0.53547E+03_JPRB,0.73807E+03_JPRB,0.95020E+03_JPRB /)  
KB(:, 2,43, 6) = (/ &
 & 0.88957E+03_JPRB,0.68809E+03_JPRB,0.53552E+03_JPRB,0.73828E+03_JPRB,0.95037E+03_JPRB /)  
KB(:, 3,43, 6) = (/ &
 & 0.88955E+03_JPRB,0.68808E+03_JPRB,0.53555E+03_JPRB,0.73826E+03_JPRB,0.95020E+03_JPRB /)  
KB(:, 4,43, 6) = (/ &
 & 0.88954E+03_JPRB,0.68808E+03_JPRB,0.53555E+03_JPRB,0.73804E+03_JPRB,0.94970E+03_JPRB /)  
KB(:, 5,43, 6) = (/ &
 & 0.88953E+03_JPRB,0.68807E+03_JPRB,0.53553E+03_JPRB,0.73758E+03_JPRB,0.94886E+03_JPRB /)  
KB(:, 1,44, 6) = (/ &
 & 0.88954E+03_JPRB,0.68808E+03_JPRB,0.53544E+03_JPRB,0.73795E+03_JPRB,0.95005E+03_JPRB /)  
KB(:, 2,44, 6) = (/ &
 & 0.88953E+03_JPRB,0.68807E+03_JPRB,0.53549E+03_JPRB,0.73823E+03_JPRB,0.95035E+03_JPRB /)  
KB(:, 3,44, 6) = (/ &
 & 0.88952E+03_JPRB,0.68806E+03_JPRB,0.53553E+03_JPRB,0.73829E+03_JPRB,0.95030E+03_JPRB /)  
KB(:, 4,44, 6) = (/ &
 & 0.88951E+03_JPRB,0.68805E+03_JPRB,0.53554E+03_JPRB,0.73815E+03_JPRB,0.94991E+03_JPRB /)  
KB(:, 5,44, 6) = (/ &
 & 0.88951E+03_JPRB,0.68805E+03_JPRB,0.53553E+03_JPRB,0.73776E+03_JPRB,0.94919E+03_JPRB /)  
KB(:, 1,45, 6) = (/ &
 & 0.88952E+03_JPRB,0.68806E+03_JPRB,0.53540E+03_JPRB,0.73782E+03_JPRB,0.94987E+03_JPRB /)  
KB(:, 2,45, 6) = (/ &
 & 0.88951E+03_JPRB,0.68805E+03_JPRB,0.53547E+03_JPRB,0.73816E+03_JPRB,0.95030E+03_JPRB /)  
KB(:, 3,45, 6) = (/ &
 & 0.88950E+03_JPRB,0.68804E+03_JPRB,0.53551E+03_JPRB,0.73830E+03_JPRB,0.95035E+03_JPRB /)  
KB(:, 4,45, 6) = (/ &
 & 0.88949E+03_JPRB,0.68804E+03_JPRB,0.53553E+03_JPRB,0.73821E+03_JPRB,0.95008E+03_JPRB /)  
KB(:, 5,45, 6) = (/ &
 & 0.88948E+03_JPRB,0.68803E+03_JPRB,0.53553E+03_JPRB,0.73792E+03_JPRB,0.94947E+03_JPRB /)  
KB(:, 1,46, 6) = (/ &
 & 0.88949E+03_JPRB,0.68804E+03_JPRB,0.53537E+03_JPRB,0.73763E+03_JPRB,0.94962E+03_JPRB /)  
KB(:, 2,46, 6) = (/ &
 & 0.88948E+03_JPRB,0.68803E+03_JPRB,0.53544E+03_JPRB,0.73806E+03_JPRB,0.95019E+03_JPRB /)  
KB(:, 3,46, 6) = (/ &
 & 0.88948E+03_JPRB,0.68803E+03_JPRB,0.53549E+03_JPRB,0.73827E+03_JPRB,0.95037E+03_JPRB /)  
KB(:, 4,46, 6) = (/ &
 & 0.88947E+03_JPRB,0.68802E+03_JPRB,0.53552E+03_JPRB,0.73827E+03_JPRB,0.95021E+03_JPRB /)  
KB(:, 5,46, 6) = (/ &
 & 0.88946E+03_JPRB,0.68802E+03_JPRB,0.53552E+03_JPRB,0.73805E+03_JPRB,0.94973E+03_JPRB /)  
KB(:, 1,47, 6) = (/ &
 & 0.88947E+03_JPRB,0.68802E+03_JPRB,0.53531E+03_JPRB,0.73737E+03_JPRB,0.94929E+03_JPRB /)  
KB(:, 2,47, 6) = (/ &
 & 0.88947E+03_JPRB,0.68802E+03_JPRB,0.53539E+03_JPRB,0.73792E+03_JPRB,0.95000E+03_JPRB /)  
KB(:, 3,47, 6) = (/ &
 & 0.88946E+03_JPRB,0.68801E+03_JPRB,0.53546E+03_JPRB,0.73821E+03_JPRB,0.95034E+03_JPRB /)  
KB(:, 4,47, 6) = (/ &
 & 0.88945E+03_JPRB,0.68801E+03_JPRB,0.53550E+03_JPRB,0.73829E+03_JPRB,0.95032E+03_JPRB /)  
KB(:, 5,47, 6) = (/ &
 & 0.88945E+03_JPRB,0.68800E+03_JPRB,0.53551E+03_JPRB,0.73816E+03_JPRB,0.94996E+03_JPRB /)  
KB(:, 1,48, 6) = (/ &
 & 0.88946E+03_JPRB,0.68801E+03_JPRB,0.53528E+03_JPRB,0.73708E+03_JPRB,0.94889E+03_JPRB /)  
KB(:, 2,48, 6) = (/ &
 & 0.88945E+03_JPRB,0.68801E+03_JPRB,0.53536E+03_JPRB,0.73773E+03_JPRB,0.94976E+03_JPRB /)  
KB(:, 3,48, 6) = (/ &
 & 0.88944E+03_JPRB,0.68800E+03_JPRB,0.53543E+03_JPRB,0.73812E+03_JPRB,0.95025E+03_JPRB /)  
KB(:, 4,48, 6) = (/ &
 & 0.88944E+03_JPRB,0.68800E+03_JPRB,0.53548E+03_JPRB,0.73829E+03_JPRB,0.95037E+03_JPRB /)  
KB(:, 5,48, 6) = (/ &
 & 0.88944E+03_JPRB,0.68800E+03_JPRB,0.53551E+03_JPRB,0.73824E+03_JPRB,0.95014E+03_JPRB /)  
KB(:, 1,49, 6) = (/ &
 & 0.88944E+03_JPRB,0.68800E+03_JPRB,0.53524E+03_JPRB,0.73674E+03_JPRB,0.94844E+03_JPRB /)  
KB(:, 2,49, 6) = (/ &
 & 0.88944E+03_JPRB,0.68800E+03_JPRB,0.53533E+03_JPRB,0.73750E+03_JPRB,0.94945E+03_JPRB /)  
KB(:, 3,49, 6) = (/ &
 & 0.88943E+03_JPRB,0.68799E+03_JPRB,0.53540E+03_JPRB,0.73799E+03_JPRB,0.95016E+03_JPRB /)  
KB(:, 4,49, 6) = (/ &
 & 0.88943E+03_JPRB,0.68799E+03_JPRB,0.53546E+03_JPRB,0.73825E+03_JPRB,0.95036E+03_JPRB /)  
KB(:, 5,49, 6) = (/ &
 & 0.88942E+03_JPRB,0.68799E+03_JPRB,0.53549E+03_JPRB,0.73828E+03_JPRB,0.95027E+03_JPRB /)  
KB(:, 1,50, 6) = (/ &
 & 0.88943E+03_JPRB,0.68799E+03_JPRB,0.53521E+03_JPRB,0.73638E+03_JPRB,0.94796E+03_JPRB /)  
KB(:, 2,50, 6) = (/ &
 & 0.88943E+03_JPRB,0.68799E+03_JPRB,0.53529E+03_JPRB,0.73724E+03_JPRB,0.94911E+03_JPRB /)  
KB(:, 3,50, 6) = (/ &
 & 0.88942E+03_JPRB,0.68798E+03_JPRB,0.53537E+03_JPRB,0.73783E+03_JPRB,0.94990E+03_JPRB /)  
KB(:, 4,50, 6) = (/ &
 & 0.88942E+03_JPRB,0.68798E+03_JPRB,0.53544E+03_JPRB,0.73817E+03_JPRB,0.95031E+03_JPRB /)  
KB(:, 5,50, 6) = (/ &
 & 0.88942E+03_JPRB,0.68798E+03_JPRB,0.53548E+03_JPRB,0.73829E+03_JPRB,0.95034E+03_JPRB /)  
KB(:, 1,51, 6) = (/ &
 & 0.88942E+03_JPRB,0.68798E+03_JPRB,0.53518E+03_JPRB,0.73600E+03_JPRB,0.94745E+03_JPRB /)  
KB(:, 2,51, 6) = (/ &
 & 0.88942E+03_JPRB,0.68798E+03_JPRB,0.53525E+03_JPRB,0.73696E+03_JPRB,0.94873E+03_JPRB /)  
KB(:, 3,51, 6) = (/ &
 & 0.88941E+03_JPRB,0.68798E+03_JPRB,0.53533E+03_JPRB,0.73765E+03_JPRB,0.94966E+03_JPRB /)  
KB(:, 4,51, 6) = (/ &
 & 0.88941E+03_JPRB,0.68798E+03_JPRB,0.53541E+03_JPRB,0.73807E+03_JPRB,0.95020E+03_JPRB /)  
KB(:, 5,51, 6) = (/ &
 & 0.88941E+03_JPRB,0.68797E+03_JPRB,0.53546E+03_JPRB,0.73827E+03_JPRB,0.95037E+03_JPRB /)  
KB(:, 1,52, 6) = (/ &
 & 0.88941E+03_JPRB,0.68798E+03_JPRB,0.53513E+03_JPRB,0.73556E+03_JPRB,0.94688E+03_JPRB /)  
KB(:, 2,52, 6) = (/ &
 & 0.88941E+03_JPRB,0.68798E+03_JPRB,0.53522E+03_JPRB,0.73664E+03_JPRB,0.94831E+03_JPRB /)  
KB(:, 3,52, 6) = (/ &
 & 0.88941E+03_JPRB,0.68797E+03_JPRB,0.53531E+03_JPRB,0.73743E+03_JPRB,0.94936E+03_JPRB /)  
KB(:, 4,52, 6) = (/ &
 & 0.88940E+03_JPRB,0.68797E+03_JPRB,0.53538E+03_JPRB,0.73795E+03_JPRB,0.95005E+03_JPRB /)  
KB(:, 5,52, 6) = (/ &
 & 0.88940E+03_JPRB,0.68797E+03_JPRB,0.53545E+03_JPRB,0.73822E+03_JPRB,0.95036E+03_JPRB /)  
KB(:, 1,53, 6) = (/ &
 & 0.88941E+03_JPRB,0.68797E+03_JPRB,0.53507E+03_JPRB,0.73509E+03_JPRB,0.94627E+03_JPRB /)  
KB(:, 2,53, 6) = (/ &
 & 0.88940E+03_JPRB,0.68797E+03_JPRB,0.53519E+03_JPRB,0.73629E+03_JPRB,0.94784E+03_JPRB /)  
KB(:, 3,53, 6) = (/ &
 & 0.88940E+03_JPRB,0.68797E+03_JPRB,0.53527E+03_JPRB,0.73717E+03_JPRB,0.94902E+03_JPRB /)  
KB(:, 4,53, 6) = (/ &
 & 0.88940E+03_JPRB,0.68797E+03_JPRB,0.53535E+03_JPRB,0.73779E+03_JPRB,0.94984E+03_JPRB /)  
KB(:, 5,53, 6) = (/ &
 & 0.88940E+03_JPRB,0.68797E+03_JPRB,0.53542E+03_JPRB,0.73815E+03_JPRB,0.95029E+03_JPRB /)  
KB(:, 1,54, 6) = (/ &
 & 0.88940E+03_JPRB,0.68797E+03_JPRB,0.53502E+03_JPRB,0.73463E+03_JPRB,0.94566E+03_JPRB /)  
KB(:, 2,54, 6) = (/ &
 & 0.88940E+03_JPRB,0.68797E+03_JPRB,0.53516E+03_JPRB,0.73592E+03_JPRB,0.94735E+03_JPRB /)  
KB(:, 3,54, 6) = (/ &
 & 0.88940E+03_JPRB,0.68796E+03_JPRB,0.53524E+03_JPRB,0.73691E+03_JPRB,0.94866E+03_JPRB /)  
KB(:, 4,54, 6) = (/ &
 & 0.88939E+03_JPRB,0.68796E+03_JPRB,0.53533E+03_JPRB,0.73761E+03_JPRB,0.94961E+03_JPRB /)  
KB(:, 5,54, 6) = (/ &
 & 0.88939E+03_JPRB,0.68796E+03_JPRB,0.53539E+03_JPRB,0.73805E+03_JPRB,0.95018E+03_JPRB /)  
KB(:, 1,55, 6) = (/ &
 & 0.88940E+03_JPRB,0.68796E+03_JPRB,0.53495E+03_JPRB,0.73415E+03_JPRB,0.94503E+03_JPRB /)  
KB(:, 2,55, 6) = (/ &
 & 0.88939E+03_JPRB,0.68796E+03_JPRB,0.53513E+03_JPRB,0.73554E+03_JPRB,0.94685E+03_JPRB /)  
KB(:, 3,55, 6) = (/ &
 & 0.88939E+03_JPRB,0.68796E+03_JPRB,0.53521E+03_JPRB,0.73662E+03_JPRB,0.94828E+03_JPRB /)  
KB(:, 4,55, 6) = (/ &
 & 0.88939E+03_JPRB,0.68796E+03_JPRB,0.53530E+03_JPRB,0.73742E+03_JPRB,0.94934E+03_JPRB /)  
KB(:, 5,55, 6) = (/ &
 & 0.88939E+03_JPRB,0.68796E+03_JPRB,0.53537E+03_JPRB,0.73794E+03_JPRB,0.95004E+03_JPRB /)  
KB(:, 1,56, 6) = (/ &
 & 0.88939E+03_JPRB,0.68796E+03_JPRB,0.53489E+03_JPRB,0.73364E+03_JPRB,0.94437E+03_JPRB /)  
KB(:, 2,56, 6) = (/ &
 & 0.88939E+03_JPRB,0.68796E+03_JPRB,0.53507E+03_JPRB,0.73512E+03_JPRB,0.94631E+03_JPRB /)  
KB(:, 3,56, 6) = (/ &
 & 0.88939E+03_JPRB,0.68796E+03_JPRB,0.53519E+03_JPRB,0.73631E+03_JPRB,0.94787E+03_JPRB /)  
KB(:, 4,56, 6) = (/ &
 & 0.88939E+03_JPRB,0.68796E+03_JPRB,0.53527E+03_JPRB,0.73719E+03_JPRB,0.94904E+03_JPRB /)  
KB(:, 5,56, 6) = (/ &
 & 0.88938E+03_JPRB,0.68796E+03_JPRB,0.53535E+03_JPRB,0.73780E+03_JPRB,0.94987E+03_JPRB /)  
KB(:, 1,57, 6) = (/ &
 & 0.88939E+03_JPRB,0.68796E+03_JPRB,0.53481E+03_JPRB,0.73310E+03_JPRB,0.94366E+03_JPRB /)  
KB(:, 2,57, 6) = (/ &
 & 0.88939E+03_JPRB,0.68796E+03_JPRB,0.53502E+03_JPRB,0.73469E+03_JPRB,0.94573E+03_JPRB /)  
KB(:, 3,57, 6) = (/ &
 & 0.88938E+03_JPRB,0.68796E+03_JPRB,0.53516E+03_JPRB,0.73597E+03_JPRB,0.94741E+03_JPRB /)  
KB(:, 4,57, 6) = (/ &
 & 0.88938E+03_JPRB,0.68796E+03_JPRB,0.53524E+03_JPRB,0.73694E+03_JPRB,0.94871E+03_JPRB /)  
KB(:, 5,57, 6) = (/ &
 & 0.88938E+03_JPRB,0.68795E+03_JPRB,0.53532E+03_JPRB,0.73764E+03_JPRB,0.94964E+03_JPRB /)  
KB(:, 1,58, 6) = (/ &
 & 0.88938E+03_JPRB,0.68796E+03_JPRB,0.53474E+03_JPRB,0.73255E+03_JPRB,0.94296E+03_JPRB /)  
KB(:, 2,58, 6) = (/ &
 & 0.88938E+03_JPRB,0.68796E+03_JPRB,0.53496E+03_JPRB,0.73423E+03_JPRB,0.94515E+03_JPRB /)  
KB(:, 3,58, 6) = (/ &
 & 0.88938E+03_JPRB,0.68795E+03_JPRB,0.53512E+03_JPRB,0.73561E+03_JPRB,0.94695E+03_JPRB /)  
KB(:, 4,58, 6) = (/ &
 & 0.88938E+03_JPRB,0.68795E+03_JPRB,0.53522E+03_JPRB,0.73667E+03_JPRB,0.94836E+03_JPRB /)  
KB(:, 5,58, 6) = (/ &
 & 0.88938E+03_JPRB,0.68795E+03_JPRB,0.53530E+03_JPRB,0.73745E+03_JPRB,0.94939E+03_JPRB /)  
KB(:, 1,59, 6) = (/ &
 & 0.88938E+03_JPRB,0.68795E+03_JPRB,0.53470E+03_JPRB,0.73233E+03_JPRB,0.94266E+03_JPRB /)  
KB(:, 2,59, 6) = (/ &
 & 0.88938E+03_JPRB,0.68795E+03_JPRB,0.53494E+03_JPRB,0.73405E+03_JPRB,0.94490E+03_JPRB /)  
KB(:, 3,59, 6) = (/ &
 & 0.88938E+03_JPRB,0.68795E+03_JPRB,0.53510E+03_JPRB,0.73546E+03_JPRB,0.94675E+03_JPRB /)  
KB(:, 4,59, 6) = (/ &
 & 0.88938E+03_JPRB,0.68795E+03_JPRB,0.53521E+03_JPRB,0.73657E+03_JPRB,0.94820E+03_JPRB /)  
KB(:, 5,59, 6) = (/ &
 & 0.88938E+03_JPRB,0.68795E+03_JPRB,0.53529E+03_JPRB,0.73737E+03_JPRB,0.94929E+03_JPRB /)  
KB(:, 1,13, 7) = (/ &
 & 0.11104E+04_JPRB,0.84453E+03_JPRB,0.58852E+03_JPRB,0.81799E+03_JPRB,0.10746E+04_JPRB /)  
KB(:, 2,13, 7) = (/ &
 & 0.11019E+04_JPRB,0.83810E+03_JPRB,0.58572E+03_JPRB,0.81836E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 3,13, 7) = (/ &
 & 0.10945E+04_JPRB,0.83257E+03_JPRB,0.58306E+03_JPRB,0.81848E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 4,13, 7) = (/ &
 & 0.10881E+04_JPRB,0.82775E+03_JPRB,0.58047E+03_JPRB,0.81831E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 5,13, 7) = (/ &
 & 0.10824E+04_JPRB,0.82352E+03_JPRB,0.57809E+03_JPRB,0.81788E+03_JPRB,0.10749E+04_JPRB /)  
KB(:, 1,14, 7) = (/ &
 & 0.10890E+04_JPRB,0.82842E+03_JPRB,0.58087E+03_JPRB,0.81780E+03_JPRB,0.10747E+04_JPRB /)  
KB(:, 2,14, 7) = (/ &
 & 0.10820E+04_JPRB,0.82323E+03_JPRB,0.57803E+03_JPRB,0.81816E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 3,14, 7) = (/ &
 & 0.10761E+04_JPRB,0.81875E+03_JPRB,0.57524E+03_JPRB,0.81827E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 4,14, 7) = (/ &
 & 0.10709E+04_JPRB,0.81486E+03_JPRB,0.57281E+03_JPRB,0.81809E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 5,14, 7) = (/ &
 & 0.10663E+04_JPRB,0.81144E+03_JPRB,0.57087E+03_JPRB,0.81766E+03_JPRB,0.10748E+04_JPRB /)  
KB(:, 1,15, 7) = (/ &
 & 0.10714E+04_JPRB,0.81529E+03_JPRB,0.57324E+03_JPRB,0.81765E+03_JPRB,0.10748E+04_JPRB /)  
KB(:, 2,15, 7) = (/ &
 & 0.10659E+04_JPRB,0.81110E+03_JPRB,0.57094E+03_JPRB,0.81800E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 3,15, 7) = (/ &
 & 0.10611E+04_JPRB,0.80749E+03_JPRB,0.56926E+03_JPRB,0.81809E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 4,15, 7) = (/ &
 & 0.10569E+04_JPRB,0.80434E+03_JPRB,0.56791E+03_JPRB,0.81790E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 5,15, 7) = (/ &
 & 0.10532E+04_JPRB,0.80157E+03_JPRB,0.56672E+03_JPRB,0.81746E+03_JPRB,0.10748E+04_JPRB /)  
KB(:, 1,16, 7) = (/ &
 & 0.10572E+04_JPRB,0.80460E+03_JPRB,0.56822E+03_JPRB,0.81755E+03_JPRB,0.10748E+04_JPRB /)  
KB(:, 2,16, 7) = (/ &
 & 0.10527E+04_JPRB,0.80122E+03_JPRB,0.56701E+03_JPRB,0.81788E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 3,16, 7) = (/ &
 & 0.10488E+04_JPRB,0.79831E+03_JPRB,0.56599E+03_JPRB,0.81796E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 4,16, 7) = (/ &
 & 0.10454E+04_JPRB,0.79577E+03_JPRB,0.56505E+03_JPRB,0.81773E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 5,16, 7) = (/ &
 & 0.10425E+04_JPRB,0.79354E+03_JPRB,0.56418E+03_JPRB,0.81728E+03_JPRB,0.10747E+04_JPRB /)  
KB(:, 1,17, 7) = (/ &
 & 0.10456E+04_JPRB,0.79593E+03_JPRB,0.56540E+03_JPRB,0.81747E+03_JPRB,0.10749E+04_JPRB /)  
KB(:, 2,17, 7) = (/ &
 & 0.10420E+04_JPRB,0.79321E+03_JPRB,0.56464E+03_JPRB,0.81778E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 3,17, 7) = (/ &
 & 0.10389E+04_JPRB,0.79086E+03_JPRB,0.56406E+03_JPRB,0.81783E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 4,17, 7) = (/ &
 & 0.10362E+04_JPRB,0.78881E+03_JPRB,0.56355E+03_JPRB,0.81761E+03_JPRB,0.10751E+04_JPRB /)  
KB(:, 5,17, 7) = (/ &
 & 0.10337E+04_JPRB,0.78701E+03_JPRB,0.56298E+03_JPRB,0.81712E+03_JPRB,0.10746E+04_JPRB /)  
KB(:, 1,18, 7) = (/ &
 & 0.10363E+04_JPRB,0.78890E+03_JPRB,0.56372E+03_JPRB,0.81741E+03_JPRB,0.10750E+04_JPRB /)  
KB(:, 2,18, 7) = (/ &
 & 0.10334E+04_JPRB,0.78671E+03_JPRB,0.56351E+03_JPRB,0.81771E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 3,18, 7) = (/ &
 & 0.10308E+04_JPRB,0.78481E+03_JPRB,0.56335E+03_JPRB,0.81775E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 4,18, 7) = (/ &
 & 0.10286E+04_JPRB,0.78316E+03_JPRB,0.56306E+03_JPRB,0.81749E+03_JPRB,0.10751E+04_JPRB /)  
KB(:, 5,18, 7) = (/ &
 & 0.10267E+04_JPRB,0.78170E+03_JPRB,0.56253E+03_JPRB,0.81698E+03_JPRB,0.10746E+04_JPRB /)  
KB(:, 1,19, 7) = (/ &
 & 0.10287E+04_JPRB,0.78319E+03_JPRB,0.56306E+03_JPRB,0.81737E+03_JPRB,0.10751E+04_JPRB /)  
KB(:, 2,19, 7) = (/ &
 & 0.10263E+04_JPRB,0.78143E+03_JPRB,0.56317E+03_JPRB,0.81766E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 3,19, 7) = (/ &
 & 0.10243E+04_JPRB,0.77990E+03_JPRB,0.56256E+03_JPRB,0.81764E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 4,19, 7) = (/ &
 & 0.10225E+04_JPRB,0.77856E+03_JPRB,0.56270E+03_JPRB,0.81737E+03_JPRB,0.10751E+04_JPRB /)  
KB(:, 5,19, 7) = (/ &
 & 0.10209E+04_JPRB,0.77738E+03_JPRB,0.56230E+03_JPRB,0.81685E+03_JPRB,0.10745E+04_JPRB /)  
KB(:, 1,20, 7) = (/ &
 & 0.10225E+04_JPRB,0.77853E+03_JPRB,0.56258E+03_JPRB,0.81735E+03_JPRB,0.10751E+04_JPRB /)  
KB(:, 2,20, 7) = (/ &
 & 0.10206E+04_JPRB,0.77711E+03_JPRB,0.56304E+03_JPRB,0.81761E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 3,20, 7) = (/ &
 & 0.10189E+04_JPRB,0.77589E+03_JPRB,0.56295E+03_JPRB,0.81757E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 4,20, 7) = (/ &
 & 0.10175E+04_JPRB,0.77480E+03_JPRB,0.56264E+03_JPRB,0.81728E+03_JPRB,0.10750E+04_JPRB /)  
KB(:, 5,20, 7) = (/ &
 & 0.10162E+04_JPRB,0.77385E+03_JPRB,0.56211E+03_JPRB,0.81672E+03_JPRB,0.10744E+04_JPRB /)  
KB(:, 1,21, 7) = (/ &
 & 0.10174E+04_JPRB,0.77475E+03_JPRB,0.56279E+03_JPRB,0.81734E+03_JPRB,0.10752E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART21',1,ZHOOK_HANDLE)
END SUBROUTINE PART21


SUBROUTINE PART22

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART22',0,ZHOOK_HANDLE)


KB(:, 2,21, 7) = (/ &
 & 0.10159E+04_JPRB,0.77361E+03_JPRB,0.56292E+03_JPRB,0.81756E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 3,21, 7) = (/ &
 & 0.10146E+04_JPRB,0.77262E+03_JPRB,0.56281E+03_JPRB,0.81751E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 4,21, 7) = (/ &
 & 0.10134E+04_JPRB,0.77175E+03_JPRB,0.56248E+03_JPRB,0.81718E+03_JPRB,0.10750E+04_JPRB /)  
KB(:, 5,21, 7) = (/ &
 & 0.10124E+04_JPRB,0.77098E+03_JPRB,0.56193E+03_JPRB,0.81661E+03_JPRB,0.10743E+04_JPRB /)  
KB(:, 1,22, 7) = (/ &
 & 0.10132E+04_JPRB,0.77163E+03_JPRB,0.56273E+03_JPRB,0.81736E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 2,22, 7) = (/ &
 & 0.10120E+04_JPRB,0.77071E+03_JPRB,0.56281E+03_JPRB,0.81753E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 3,22, 7) = (/ &
 & 0.10110E+04_JPRB,0.76992E+03_JPRB,0.56267E+03_JPRB,0.81743E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 4,22, 7) = (/ &
 & 0.10100E+04_JPRB,0.76922E+03_JPRB,0.56230E+03_JPRB,0.81706E+03_JPRB,0.10749E+04_JPRB /)  
KB(:, 5,22, 7) = (/ &
 & 0.10092E+04_JPRB,0.76860E+03_JPRB,0.56172E+03_JPRB,0.81643E+03_JPRB,0.10742E+04_JPRB /)  
KB(:, 1,23, 7) = (/ &
 & 0.10099E+04_JPRB,0.76909E+03_JPRB,0.56267E+03_JPRB,0.81738E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 2,23, 7) = (/ &
 & 0.10089E+04_JPRB,0.76836E+03_JPRB,0.56273E+03_JPRB,0.81751E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 3,23, 7) = (/ &
 & 0.10080E+04_JPRB,0.76773E+03_JPRB,0.56254E+03_JPRB,0.81734E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 4,23, 7) = (/ &
 & 0.10073E+04_JPRB,0.76717E+03_JPRB,0.56214E+03_JPRB,0.81691E+03_JPRB,0.10748E+04_JPRB /)  
KB(:, 5,23, 7) = (/ &
 & 0.10067E+04_JPRB,0.76668E+03_JPRB,0.56152E+03_JPRB,0.81625E+03_JPRB,0.10740E+04_JPRB /)  
KB(:, 1,24, 7) = (/ &
 & 0.10071E+04_JPRB,0.76704E+03_JPRB,0.56263E+03_JPRB,0.81739E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 2,24, 7) = (/ &
 & 0.10064E+04_JPRB,0.76647E+03_JPRB,0.56264E+03_JPRB,0.81747E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 3,24, 7) = (/ &
 & 0.10057E+04_JPRB,0.76596E+03_JPRB,0.56242E+03_JPRB,0.81725E+03_JPRB,0.10751E+04_JPRB /)  
KB(:, 4,24, 7) = (/ &
 & 0.10051E+04_JPRB,0.76551E+03_JPRB,0.56198E+03_JPRB,0.81678E+03_JPRB,0.10746E+04_JPRB /)  
KB(:, 5,24, 7) = (/ &
 & 0.10046E+04_JPRB,0.76512E+03_JPRB,0.56132E+03_JPRB,0.81606E+03_JPRB,0.10738E+04_JPRB /)  
KB(:, 1,25, 7) = (/ &
 & 0.10049E+04_JPRB,0.76538E+03_JPRB,0.56260E+03_JPRB,0.81741E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 2,25, 7) = (/ &
 & 0.10043E+04_JPRB,0.76492E+03_JPRB,0.56256E+03_JPRB,0.81742E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 3,25, 7) = (/ &
 & 0.10038E+04_JPRB,0.76453E+03_JPRB,0.56229E+03_JPRB,0.81717E+03_JPRB,0.10750E+04_JPRB /)  
KB(:, 4,25, 7) = (/ &
 & 0.10033E+04_JPRB,0.76417E+03_JPRB,0.56181E+03_JPRB,0.81663E+03_JPRB,0.10745E+04_JPRB /)  
KB(:, 5,25, 7) = (/ &
 & 0.10029E+04_JPRB,0.76385E+03_JPRB,0.56111E+03_JPRB,0.81585E+03_JPRB,0.10736E+04_JPRB /)  
KB(:, 1,26, 7) = (/ &
 & 0.10031E+04_JPRB,0.76404E+03_JPRB,0.56257E+03_JPRB,0.81743E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 2,26, 7) = (/ &
 & 0.10026E+04_JPRB,0.76368E+03_JPRB,0.56248E+03_JPRB,0.81736E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 3,26, 7) = (/ &
 & 0.10022E+04_JPRB,0.76336E+03_JPRB,0.56216E+03_JPRB,0.81707E+03_JPRB,0.10749E+04_JPRB /)  
KB(:, 4,26, 7) = (/ &
 & 0.10018E+04_JPRB,0.76308E+03_JPRB,0.56163E+03_JPRB,0.81645E+03_JPRB,0.10743E+04_JPRB /)  
KB(:, 5,26, 7) = (/ &
 & 0.10015E+04_JPRB,0.76282E+03_JPRB,0.56088E+03_JPRB,0.81561E+03_JPRB,0.10734E+04_JPRB /)  
KB(:, 1,27, 7) = (/ &
 & 0.10017E+04_JPRB,0.76296E+03_JPRB,0.56253E+03_JPRB,0.81743E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 2,27, 7) = (/ &
 & 0.10013E+04_JPRB,0.76268E+03_JPRB,0.56239E+03_JPRB,0.81730E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 3,27, 7) = (/ &
 & 0.10010E+04_JPRB,0.76242E+03_JPRB,0.56202E+03_JPRB,0.81696E+03_JPRB,0.10748E+04_JPRB /)  
KB(:, 4,27, 7) = (/ &
 & 0.10007E+04_JPRB,0.76220E+03_JPRB,0.56144E+03_JPRB,0.81630E+03_JPRB,0.10741E+04_JPRB /)  
KB(:, 5,27, 7) = (/ &
 & 0.10004E+04_JPRB,0.76200E+03_JPRB,0.56064E+03_JPRB,0.81536E+03_JPRB,0.10731E+04_JPRB /)  
KB(:, 1,28, 7) = (/ &
 & 0.10005E+04_JPRB,0.76209E+03_JPRB,0.56249E+03_JPRB,0.81738E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 2,28, 7) = (/ &
 & 0.10002E+04_JPRB,0.76186E+03_JPRB,0.56229E+03_JPRB,0.81724E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 3,28, 7) = (/ &
 & 0.99995E+03_JPRB,0.76166E+03_JPRB,0.56188E+03_JPRB,0.81687E+03_JPRB,0.10747E+04_JPRB /)  
KB(:, 4,28, 7) = (/ &
 & 0.99971E+03_JPRB,0.76148E+03_JPRB,0.56124E+03_JPRB,0.81607E+03_JPRB,0.10739E+04_JPRB /)  
KB(:, 5,28, 7) = (/ &
 & 0.99950E+03_JPRB,0.76132E+03_JPRB,0.56040E+03_JPRB,0.81510E+03_JPRB,0.10728E+04_JPRB /)  
KB(:, 1,29, 7) = (/ &
 & 0.99960E+03_JPRB,0.76139E+03_JPRB,0.56244E+03_JPRB,0.81739E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 2,29, 7) = (/ &
 & 0.99935E+03_JPRB,0.76121E+03_JPRB,0.56219E+03_JPRB,0.81712E+03_JPRB,0.10751E+04_JPRB /)  
KB(:, 3,29, 7) = (/ &
 & 0.99914E+03_JPRB,0.76105E+03_JPRB,0.56172E+03_JPRB,0.81663E+03_JPRB,0.10745E+04_JPRB /)  
KB(:, 4,29, 7) = (/ &
 & 0.99895E+03_JPRB,0.76091E+03_JPRB,0.56103E+03_JPRB,0.81584E+03_JPRB,0.10737E+04_JPRB /)  
KB(:, 5,29, 7) = (/ &
 & 0.99878E+03_JPRB,0.76078E+03_JPRB,0.56014E+03_JPRB,0.81482E+03_JPRB,0.10725E+04_JPRB /)  
KB(:, 1,30, 7) = (/ &
 & 0.99885E+03_JPRB,0.76083E+03_JPRB,0.56238E+03_JPRB,0.81733E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 2,30, 7) = (/ &
 & 0.99865E+03_JPRB,0.76069E+03_JPRB,0.56207E+03_JPRB,0.81703E+03_JPRB,0.10750E+04_JPRB /)  
KB(:, 3,30, 7) = (/ &
 & 0.99848E+03_JPRB,0.76055E+03_JPRB,0.56155E+03_JPRB,0.81643E+03_JPRB,0.10743E+04_JPRB /)  
KB(:, 4,30, 7) = (/ &
 & 0.99833E+03_JPRB,0.76044E+03_JPRB,0.56081E+03_JPRB,0.81561E+03_JPRB,0.10734E+04_JPRB /)  
KB(:, 5,30, 7) = (/ &
 & 0.99819E+03_JPRB,0.76034E+03_JPRB,0.55986E+03_JPRB,0.81451E+03_JPRB,0.10721E+04_JPRB /)  
KB(:, 1,31, 7) = (/ &
 & 0.99824E+03_JPRB,0.76037E+03_JPRB,0.56231E+03_JPRB,0.81727E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 2,31, 7) = (/ &
 & 0.99808E+03_JPRB,0.76026E+03_JPRB,0.56195E+03_JPRB,0.81690E+03_JPRB,0.10748E+04_JPRB /)  
KB(:, 3,31, 7) = (/ &
 & 0.99794E+03_JPRB,0.76015E+03_JPRB,0.56137E+03_JPRB,0.81625E+03_JPRB,0.10741E+04_JPRB /)  
KB(:, 4,31, 7) = (/ &
 & 0.99782E+03_JPRB,0.76006E+03_JPRB,0.56058E+03_JPRB,0.81535E+03_JPRB,0.10731E+04_JPRB /)  
KB(:, 5,31, 7) = (/ &
 & 0.99772E+03_JPRB,0.75998E+03_JPRB,0.55958E+03_JPRB,0.81419E+03_JPRB,0.10717E+04_JPRB /)  
KB(:, 1,32, 7) = (/ &
 & 0.99774E+03_JPRB,0.76000E+03_JPRB,0.56222E+03_JPRB,0.81719E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 2,32, 7) = (/ &
 & 0.99763E+03_JPRB,0.75991E+03_JPRB,0.56181E+03_JPRB,0.81675E+03_JPRB,0.10747E+04_JPRB /)  
KB(:, 3,32, 7) = (/ &
 & 0.99752E+03_JPRB,0.75984E+03_JPRB,0.56117E+03_JPRB,0.81604E+03_JPRB,0.10739E+04_JPRB /)  
KB(:, 4,32, 7) = (/ &
 & 0.99742E+03_JPRB,0.75976E+03_JPRB,0.56033E+03_JPRB,0.81507E+03_JPRB,0.10728E+04_JPRB /)  
KB(:, 5,32, 7) = (/ &
 & 0.99733E+03_JPRB,0.75970E+03_JPRB,0.55927E+03_JPRB,0.81384E+03_JPRB,0.10713E+04_JPRB /)  
KB(:, 1,33, 7) = (/ &
 & 0.99735E+03_JPRB,0.75971E+03_JPRB,0.56212E+03_JPRB,0.81709E+03_JPRB,0.10751E+04_JPRB /)  
KB(:, 2,33, 7) = (/ &
 & 0.99725E+03_JPRB,0.75964E+03_JPRB,0.56165E+03_JPRB,0.81658E+03_JPRB,0.10745E+04_JPRB /)  
KB(:, 3,33, 7) = (/ &
 & 0.99717E+03_JPRB,0.75957E+03_JPRB,0.56096E+03_JPRB,0.81581E+03_JPRB,0.10736E+04_JPRB /)  
KB(:, 4,33, 7) = (/ &
 & 0.99709E+03_JPRB,0.75952E+03_JPRB,0.56006E+03_JPRB,0.81477E+03_JPRB,0.10724E+04_JPRB /)  
KB(:, 5,33, 7) = (/ &
 & 0.99703E+03_JPRB,0.75946E+03_JPRB,0.55896E+03_JPRB,0.81347E+03_JPRB,0.10709E+04_JPRB /)  
KB(:, 1,34, 7) = (/ &
 & 0.99704E+03_JPRB,0.75947E+03_JPRB,0.56203E+03_JPRB,0.81702E+03_JPRB,0.10750E+04_JPRB /)  
KB(:, 2,34, 7) = (/ &
 & 0.99696E+03_JPRB,0.75942E+03_JPRB,0.56151E+03_JPRB,0.81642E+03_JPRB,0.10743E+04_JPRB /)  
KB(:, 3,34, 7) = (/ &
 & 0.99689E+03_JPRB,0.75937E+03_JPRB,0.56077E+03_JPRB,0.81558E+03_JPRB,0.10734E+04_JPRB /)  
KB(:, 4,34, 7) = (/ &
 & 0.99683E+03_JPRB,0.75932E+03_JPRB,0.55982E+03_JPRB,0.81449E+03_JPRB,0.10721E+04_JPRB /)  
KB(:, 5,34, 7) = (/ &
 & 0.99678E+03_JPRB,0.75928E+03_JPRB,0.55868E+03_JPRB,0.81314E+03_JPRB,0.10704E+04_JPRB /)  
KB(:, 1,35, 7) = (/ &
 & 0.99679E+03_JPRB,0.75929E+03_JPRB,0.56197E+03_JPRB,0.81693E+03_JPRB,0.10749E+04_JPRB /)  
KB(:, 2,35, 7) = (/ &
 & 0.99673E+03_JPRB,0.75925E+03_JPRB,0.56142E+03_JPRB,0.81633E+03_JPRB,0.10742E+04_JPRB /)  
KB(:, 3,35, 7) = (/ &
 & 0.99667E+03_JPRB,0.75920E+03_JPRB,0.56065E+03_JPRB,0.81545E+03_JPRB,0.10733E+04_JPRB /)  
KB(:, 4,35, 7) = (/ &
 & 0.99663E+03_JPRB,0.75916E+03_JPRB,0.55968E+03_JPRB,0.81434E+03_JPRB,0.10719E+04_JPRB /)  
KB(:, 5,35, 7) = (/ &
 & 0.99658E+03_JPRB,0.75913E+03_JPRB,0.55851E+03_JPRB,0.81294E+03_JPRB,0.10702E+04_JPRB /)  
KB(:, 1,36, 7) = (/ &
 & 0.99660E+03_JPRB,0.75914E+03_JPRB,0.56195E+03_JPRB,0.81692E+03_JPRB,0.10749E+04_JPRB /)  
KB(:, 2,36, 7) = (/ &
 & 0.99655E+03_JPRB,0.75911E+03_JPRB,0.56140E+03_JPRB,0.81631E+03_JPRB,0.10742E+04_JPRB /)  
KB(:, 3,36, 7) = (/ &
 & 0.99650E+03_JPRB,0.75907E+03_JPRB,0.56063E+03_JPRB,0.81543E+03_JPRB,0.10732E+04_JPRB /)  
KB(:, 4,36, 7) = (/ &
 & 0.99646E+03_JPRB,0.75904E+03_JPRB,0.55965E+03_JPRB,0.81430E+03_JPRB,0.10719E+04_JPRB /)  
KB(:, 5,36, 7) = (/ &
 & 0.99642E+03_JPRB,0.75901E+03_JPRB,0.55848E+03_JPRB,0.81290E+03_JPRB,0.10702E+04_JPRB /)  
KB(:, 1,37, 7) = (/ &
 & 0.99645E+03_JPRB,0.75903E+03_JPRB,0.56200E+03_JPRB,0.81697E+03_JPRB,0.10749E+04_JPRB /)  
KB(:, 2,37, 7) = (/ &
 & 0.99640E+03_JPRB,0.75900E+03_JPRB,0.56148E+03_JPRB,0.81640E+03_JPRB,0.10743E+04_JPRB /)  
KB(:, 3,37, 7) = (/ &
 & 0.99636E+03_JPRB,0.75897E+03_JPRB,0.56074E+03_JPRB,0.81556E+03_JPRB,0.10734E+04_JPRB /)  
KB(:, 4,37, 7) = (/ &
 & 0.99633E+03_JPRB,0.75894E+03_JPRB,0.55979E+03_JPRB,0.81446E+03_JPRB,0.10721E+04_JPRB /)  
KB(:, 5,37, 7) = (/ &
 & 0.99630E+03_JPRB,0.75892E+03_JPRB,0.55864E+03_JPRB,0.81313E+03_JPRB,0.10704E+04_JPRB /)  
KB(:, 1,38, 7) = (/ &
 & 0.99632E+03_JPRB,0.75894E+03_JPRB,0.56206E+03_JPRB,0.81703E+03_JPRB,0.10750E+04_JPRB /)  
KB(:, 2,38, 7) = (/ &
 & 0.99628E+03_JPRB,0.75891E+03_JPRB,0.56157E+03_JPRB,0.81650E+03_JPRB,0.10744E+04_JPRB /)  
KB(:, 3,38, 7) = (/ &
 & 0.99625E+03_JPRB,0.75889E+03_JPRB,0.56085E+03_JPRB,0.81569E+03_JPRB,0.10735E+04_JPRB /)  
KB(:, 4,38, 7) = (/ &
 & 0.99623E+03_JPRB,0.75887E+03_JPRB,0.55993E+03_JPRB,0.81464E+03_JPRB,0.10723E+04_JPRB /)  
KB(:, 5,38, 7) = (/ &
 & 0.99620E+03_JPRB,0.75885E+03_JPRB,0.55881E+03_JPRB,0.81331E+03_JPRB,0.10707E+04_JPRB /)  
KB(:, 1,39, 7) = (/ &
 & 0.99622E+03_JPRB,0.75886E+03_JPRB,0.56210E+03_JPRB,0.81708E+03_JPRB,0.10751E+04_JPRB /)  
KB(:, 2,39, 7) = (/ &
 & 0.99619E+03_JPRB,0.75884E+03_JPRB,0.56164E+03_JPRB,0.81666E+03_JPRB,0.10745E+04_JPRB /)  
KB(:, 3,39, 7) = (/ &
 & 0.99617E+03_JPRB,0.75882E+03_JPRB,0.56096E+03_JPRB,0.81582E+03_JPRB,0.10737E+04_JPRB /)  
KB(:, 4,39, 7) = (/ &
 & 0.99614E+03_JPRB,0.75880E+03_JPRB,0.56007E+03_JPRB,0.81479E+03_JPRB,0.10725E+04_JPRB /)  
KB(:, 5,39, 7) = (/ &
 & 0.99612E+03_JPRB,0.75878E+03_JPRB,0.55897E+03_JPRB,0.81351E+03_JPRB,0.10709E+04_JPRB /)  
KB(:, 1,40, 7) = (/ &
 & 0.99613E+03_JPRB,0.75880E+03_JPRB,0.56218E+03_JPRB,0.81716E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 2,40, 7) = (/ &
 & 0.99611E+03_JPRB,0.75878E+03_JPRB,0.56177E+03_JPRB,0.81672E+03_JPRB,0.10747E+04_JPRB /)  
KB(:, 3,40, 7) = (/ &
 & 0.99609E+03_JPRB,0.75876E+03_JPRB,0.56114E+03_JPRB,0.81603E+03_JPRB,0.10739E+04_JPRB /)  
KB(:, 4,40, 7) = (/ &
 & 0.99607E+03_JPRB,0.75875E+03_JPRB,0.56030E+03_JPRB,0.81506E+03_JPRB,0.10728E+04_JPRB /)  
KB(:, 5,40, 7) = (/ &
 & 0.99605E+03_JPRB,0.75874E+03_JPRB,0.55925E+03_JPRB,0.81383E+03_JPRB,0.10713E+04_JPRB /)  
KB(:, 1,41, 7) = (/ &
 & 0.99606E+03_JPRB,0.75874E+03_JPRB,0.56225E+03_JPRB,0.81724E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 2,41, 7) = (/ &
 & 0.99604E+03_JPRB,0.75873E+03_JPRB,0.56189E+03_JPRB,0.81688E+03_JPRB,0.10748E+04_JPRB /)  
KB(:, 3,41, 7) = (/ &
 & 0.99602E+03_JPRB,0.75871E+03_JPRB,0.56132E+03_JPRB,0.81623E+03_JPRB,0.10741E+04_JPRB /)  
KB(:, 4,41, 7) = (/ &
 & 0.99601E+03_JPRB,0.75870E+03_JPRB,0.56053E+03_JPRB,0.81532E+03_JPRB,0.10731E+04_JPRB /)  
KB(:, 5,41, 7) = (/ &
 & 0.99600E+03_JPRB,0.75869E+03_JPRB,0.55954E+03_JPRB,0.81416E+03_JPRB,0.10717E+04_JPRB /)  
KB(:, 1,42, 7) = (/ &
 & 0.99601E+03_JPRB,0.75870E+03_JPRB,0.56231E+03_JPRB,0.81730E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 2,42, 7) = (/ &
 & 0.99599E+03_JPRB,0.75869E+03_JPRB,0.56200E+03_JPRB,0.81698E+03_JPRB,0.10750E+04_JPRB /)  
KB(:, 3,42, 7) = (/ &
 & 0.99597E+03_JPRB,0.75868E+03_JPRB,0.56149E+03_JPRB,0.81641E+03_JPRB,0.10743E+04_JPRB /)  
KB(:, 4,42, 7) = (/ &
 & 0.99596E+03_JPRB,0.75867E+03_JPRB,0.56075E+03_JPRB,0.81559E+03_JPRB,0.10734E+04_JPRB /)  
KB(:, 5,42, 7) = (/ &
 & 0.99595E+03_JPRB,0.75866E+03_JPRB,0.55981E+03_JPRB,0.81449E+03_JPRB,0.10721E+04_JPRB /)  
KB(:, 1,43, 7) = (/ &
 & 0.99596E+03_JPRB,0.75867E+03_JPRB,0.56235E+03_JPRB,0.81734E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 2,43, 7) = (/ &
 & 0.99595E+03_JPRB,0.75866E+03_JPRB,0.56212E+03_JPRB,0.81712E+03_JPRB,0.10751E+04_JPRB /)  
KB(:, 3,43, 7) = (/ &
 & 0.99594E+03_JPRB,0.75865E+03_JPRB,0.56167E+03_JPRB,0.81662E+03_JPRB,0.10746E+04_JPRB /)  
KB(:, 4,43, 7) = (/ &
 & 0.99592E+03_JPRB,0.75864E+03_JPRB,0.56100E+03_JPRB,0.81588E+03_JPRB,0.10737E+04_JPRB /)  
KB(:, 5,43, 7) = (/ &
 & 0.99591E+03_JPRB,0.75863E+03_JPRB,0.56012E+03_JPRB,0.81487E+03_JPRB,0.10726E+04_JPRB /)  
KB(:, 1,44, 7) = (/ &
 & 0.99592E+03_JPRB,0.75864E+03_JPRB,0.56237E+03_JPRB,0.81736E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 2,44, 7) = (/ &
 & 0.99591E+03_JPRB,0.75863E+03_JPRB,0.56222E+03_JPRB,0.81722E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 3,44, 7) = (/ &
 & 0.99591E+03_JPRB,0.75862E+03_JPRB,0.56184E+03_JPRB,0.81680E+03_JPRB,0.10748E+04_JPRB /)  
KB(:, 4,44, 7) = (/ &
 & 0.99589E+03_JPRB,0.75861E+03_JPRB,0.56125E+03_JPRB,0.81614E+03_JPRB,0.10741E+04_JPRB /)  
KB(:, 5,44, 7) = (/ &
 & 0.99588E+03_JPRB,0.75861E+03_JPRB,0.56044E+03_JPRB,0.81523E+03_JPRB,0.10730E+04_JPRB /)  
KB(:, 1,45, 7) = (/ &
 & 0.99589E+03_JPRB,0.75861E+03_JPRB,0.56237E+03_JPRB,0.81733E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 2,45, 7) = (/ &
 & 0.99588E+03_JPRB,0.75861E+03_JPRB,0.56230E+03_JPRB,0.81729E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 3,45, 7) = (/ &
 & 0.99587E+03_JPRB,0.75860E+03_JPRB,0.56199E+03_JPRB,0.81699E+03_JPRB,0.10750E+04_JPRB /)  
KB(:, 4,45, 7) = (/ &
 & 0.99586E+03_JPRB,0.75859E+03_JPRB,0.56147E+03_JPRB,0.81641E+03_JPRB,0.10743E+04_JPRB /)  
KB(:, 5,45, 7) = (/ &
 & 0.99585E+03_JPRB,0.75859E+03_JPRB,0.56074E+03_JPRB,0.81557E+03_JPRB,0.10734E+04_JPRB /)  
KB(:, 1,46, 7) = (/ &
 & 0.99586E+03_JPRB,0.75859E+03_JPRB,0.56233E+03_JPRB,0.81728E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 2,46, 7) = (/ &
 & 0.99585E+03_JPRB,0.75859E+03_JPRB,0.56235E+03_JPRB,0.81734E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 3,46, 7) = (/ &
 & 0.99585E+03_JPRB,0.75858E+03_JPRB,0.56213E+03_JPRB,0.81712E+03_JPRB,0.10751E+04_JPRB /)  
KB(:, 4,46, 7) = (/ &
 & 0.99584E+03_JPRB,0.75858E+03_JPRB,0.56169E+03_JPRB,0.81663E+03_JPRB,0.10746E+04_JPRB /)  
KB(:, 5,46, 7) = (/ &
 & 0.99583E+03_JPRB,0.75858E+03_JPRB,0.56103E+03_JPRB,0.81590E+03_JPRB,0.10738E+04_JPRB /)  
KB(:, 1,47, 7) = (/ &
 & 0.99585E+03_JPRB,0.75858E+03_JPRB,0.56226E+03_JPRB,0.81718E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 2,47, 7) = (/ &
 & 0.99583E+03_JPRB,0.75857E+03_JPRB,0.56237E+03_JPRB,0.81736E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 3,47, 7) = (/ &
 & 0.99583E+03_JPRB,0.75857E+03_JPRB,0.56224E+03_JPRB,0.81723E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 4,47, 7) = (/ &
 & 0.99582E+03_JPRB,0.75856E+03_JPRB,0.56189E+03_JPRB,0.81686E+03_JPRB,0.10748E+04_JPRB /)  
KB(:, 5,47, 7) = (/ &
 & 0.99581E+03_JPRB,0.75856E+03_JPRB,0.56132E+03_JPRB,0.81626E+03_JPRB,0.10741E+04_JPRB /)  
KB(:, 1,48, 7) = (/ &
 & 0.99582E+03_JPRB,0.75856E+03_JPRB,0.56215E+03_JPRB,0.81703E+03_JPRB,0.10751E+04_JPRB /)  
KB(:, 2,48, 7) = (/ &
 & 0.99582E+03_JPRB,0.75856E+03_JPRB,0.56235E+03_JPRB,0.81732E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 3,48, 7) = (/ &
 & 0.99581E+03_JPRB,0.75855E+03_JPRB,0.56232E+03_JPRB,0.81733E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 4,48, 7) = (/ &
 & 0.99580E+03_JPRB,0.75855E+03_JPRB,0.56206E+03_JPRB,0.81704E+03_JPRB,0.10750E+04_JPRB /)  
KB(:, 5,48, 7) = (/ &
 & 0.99580E+03_JPRB,0.75855E+03_JPRB,0.56157E+03_JPRB,0.81651E+03_JPRB,0.10744E+04_JPRB /)  
KB(:, 1,49, 7) = (/ &
 & 0.99581E+03_JPRB,0.75855E+03_JPRB,0.56199E+03_JPRB,0.81684E+03_JPRB,0.10748E+04_JPRB /)  
KB(:, 2,49, 7) = (/ &
 & 0.99580E+03_JPRB,0.75855E+03_JPRB,0.56230E+03_JPRB,0.81724E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 3,49, 7) = (/ &
 & 0.99580E+03_JPRB,0.75854E+03_JPRB,0.56236E+03_JPRB,0.81736E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 4,49, 7) = (/ &
 & 0.99579E+03_JPRB,0.75854E+03_JPRB,0.56219E+03_JPRB,0.81718E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 5,49, 7) = (/ &
 & 0.99579E+03_JPRB,0.75854E+03_JPRB,0.56179E+03_JPRB,0.81678E+03_JPRB,0.10747E+04_JPRB /)  
KB(:, 1,50, 7) = (/ &
 & 0.99579E+03_JPRB,0.75854E+03_JPRB,0.56180E+03_JPRB,0.81662E+03_JPRB,0.10745E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART22',1,ZHOOK_HANDLE)
END SUBROUTINE PART22


SUBROUTINE PART23

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART23',0,ZHOOK_HANDLE)


KB(:, 2,50, 7) = (/ &
 & 0.99579E+03_JPRB,0.75854E+03_JPRB,0.56221E+03_JPRB,0.81713E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 3,50, 7) = (/ &
 & 0.99579E+03_JPRB,0.75854E+03_JPRB,0.56237E+03_JPRB,0.81735E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 4,50, 7) = (/ &
 & 0.99579E+03_JPRB,0.75854E+03_JPRB,0.56228E+03_JPRB,0.81728E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 5,50, 7) = (/ &
 & 0.99578E+03_JPRB,0.75853E+03_JPRB,0.56197E+03_JPRB,0.81695E+03_JPRB,0.10749E+04_JPRB /)  
KB(:, 1,51, 7) = (/ &
 & 0.99578E+03_JPRB,0.75853E+03_JPRB,0.56158E+03_JPRB,0.81637E+03_JPRB,0.10741E+04_JPRB /)  
KB(:, 2,51, 7) = (/ &
 & 0.99578E+03_JPRB,0.75853E+03_JPRB,0.56209E+03_JPRB,0.81697E+03_JPRB,0.10750E+04_JPRB /)  
KB(:, 3,51, 7) = (/ &
 & 0.99578E+03_JPRB,0.75853E+03_JPRB,0.56234E+03_JPRB,0.81729E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 4,51, 7) = (/ &
 & 0.99578E+03_JPRB,0.75853E+03_JPRB,0.56234E+03_JPRB,0.81734E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 5,51, 7) = (/ &
 & 0.99577E+03_JPRB,0.75852E+03_JPRB,0.56211E+03_JPRB,0.81712E+03_JPRB,0.10751E+04_JPRB /)  
KB(:, 1,52, 7) = (/ &
 & 0.99577E+03_JPRB,0.75853E+03_JPRB,0.56131E+03_JPRB,0.81608E+03_JPRB,0.10737E+04_JPRB /)  
KB(:, 2,52, 7) = (/ &
 & 0.99577E+03_JPRB,0.75852E+03_JPRB,0.56194E+03_JPRB,0.81678E+03_JPRB,0.10748E+04_JPRB /)  
KB(:, 3,52, 7) = (/ &
 & 0.99577E+03_JPRB,0.75852E+03_JPRB,0.56228E+03_JPRB,0.81721E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 4,52, 7) = (/ &
 & 0.99577E+03_JPRB,0.75852E+03_JPRB,0.56237E+03_JPRB,0.81738E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 5,52, 7) = (/ &
 & 0.99576E+03_JPRB,0.75852E+03_JPRB,0.56222E+03_JPRB,0.81722E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 1,53, 7) = (/ &
 & 0.99577E+03_JPRB,0.75852E+03_JPRB,0.56102E+03_JPRB,0.81574E+03_JPRB,0.10731E+04_JPRB /)  
KB(:, 2,53, 7) = (/ &
 & 0.99576E+03_JPRB,0.75852E+03_JPRB,0.56174E+03_JPRB,0.81656E+03_JPRB,0.10744E+04_JPRB /)  
KB(:, 3,53, 7) = (/ &
 & 0.99576E+03_JPRB,0.75852E+03_JPRB,0.56218E+03_JPRB,0.81709E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 4,53, 7) = (/ &
 & 0.99576E+03_JPRB,0.75851E+03_JPRB,0.56236E+03_JPRB,0.81734E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 5,53, 7) = (/ &
 & 0.99576E+03_JPRB,0.75852E+03_JPRB,0.56230E+03_JPRB,0.81736E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 1,54, 7) = (/ &
 & 0.99576E+03_JPRB,0.75852E+03_JPRB,0.56072E+03_JPRB,0.81536E+03_JPRB,0.10726E+04_JPRB /)  
KB(:, 2,54, 7) = (/ &
 & 0.99576E+03_JPRB,0.75851E+03_JPRB,0.56153E+03_JPRB,0.81633E+03_JPRB,0.10740E+04_JPRB /)  
KB(:, 3,54, 7) = (/ &
 & 0.99575E+03_JPRB,0.75851E+03_JPRB,0.56207E+03_JPRB,0.81694E+03_JPRB,0.10750E+04_JPRB /)  
KB(:, 4,54, 7) = (/ &
 & 0.99575E+03_JPRB,0.75851E+03_JPRB,0.56233E+03_JPRB,0.81728E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 5,54, 7) = (/ &
 & 0.99576E+03_JPRB,0.75851E+03_JPRB,0.56235E+03_JPRB,0.81734E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 1,55, 7) = (/ &
 & 0.99575E+03_JPRB,0.75851E+03_JPRB,0.56039E+03_JPRB,0.81495E+03_JPRB,0.10720E+04_JPRB /)  
KB(:, 2,55, 7) = (/ &
 & 0.99575E+03_JPRB,0.75851E+03_JPRB,0.56128E+03_JPRB,0.81606E+03_JPRB,0.10736E+04_JPRB /)  
KB(:, 3,55, 7) = (/ &
 & 0.99575E+03_JPRB,0.75851E+03_JPRB,0.56193E+03_JPRB,0.81677E+03_JPRB,0.10747E+04_JPRB /)  
KB(:, 4,55, 7) = (/ &
 & 0.99575E+03_JPRB,0.75851E+03_JPRB,0.56227E+03_JPRB,0.81720E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 5,55, 7) = (/ &
 & 0.99575E+03_JPRB,0.75851E+03_JPRB,0.56237E+03_JPRB,0.81736E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 1,56, 7) = (/ &
 & 0.99575E+03_JPRB,0.75851E+03_JPRB,0.56002E+03_JPRB,0.81448E+03_JPRB,0.10713E+04_JPRB /)  
KB(:, 2,56, 7) = (/ &
 & 0.99575E+03_JPRB,0.75851E+03_JPRB,0.56104E+03_JPRB,0.81576E+03_JPRB,0.10732E+04_JPRB /)  
KB(:, 3,56, 7) = (/ &
 & 0.99575E+03_JPRB,0.75851E+03_JPRB,0.56175E+03_JPRB,0.81659E+03_JPRB,0.10744E+04_JPRB /)  
KB(:, 4,56, 7) = (/ &
 & 0.99574E+03_JPRB,0.75850E+03_JPRB,0.56219E+03_JPRB,0.81709E+03_JPRB,0.10752E+04_JPRB /)  
KB(:, 5,56, 7) = (/ &
 & 0.99574E+03_JPRB,0.75850E+03_JPRB,0.56236E+03_JPRB,0.81734E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 1,57, 7) = (/ &
 & 0.99575E+03_JPRB,0.75851E+03_JPRB,0.55963E+03_JPRB,0.81395E+03_JPRB,0.10705E+04_JPRB /)  
KB(:, 2,57, 7) = (/ &
 & 0.99574E+03_JPRB,0.75850E+03_JPRB,0.56076E+03_JPRB,0.81540E+03_JPRB,0.10727E+04_JPRB /)  
KB(:, 3,57, 7) = (/ &
 & 0.99574E+03_JPRB,0.75850E+03_JPRB,0.56157E+03_JPRB,0.81635E+03_JPRB,0.10741E+04_JPRB /)  
KB(:, 4,57, 7) = (/ &
 & 0.99574E+03_JPRB,0.75850E+03_JPRB,0.56208E+03_JPRB,0.81696E+03_JPRB,0.10750E+04_JPRB /)  
KB(:, 5,57, 7) = (/ &
 & 0.99574E+03_JPRB,0.75850E+03_JPRB,0.56234E+03_JPRB,0.81729E+03_JPRB,0.10754E+04_JPRB /)  
KB(:, 1,58, 7) = (/ &
 & 0.99575E+03_JPRB,0.75850E+03_JPRB,0.55922E+03_JPRB,0.81340E+03_JPRB,0.10697E+04_JPRB /)  
KB(:, 2,58, 7) = (/ &
 & 0.99574E+03_JPRB,0.75850E+03_JPRB,0.56044E+03_JPRB,0.81503E+03_JPRB,0.10721E+04_JPRB /)  
KB(:, 3,58, 7) = (/ &
 & 0.99574E+03_JPRB,0.75851E+03_JPRB,0.56134E+03_JPRB,0.81611E+03_JPRB,0.10737E+04_JPRB /)  
KB(:, 4,58, 7) = (/ &
 & 0.99574E+03_JPRB,0.75851E+03_JPRB,0.56195E+03_JPRB,0.81681E+03_JPRB,0.10748E+04_JPRB /)  
KB(:, 5,58, 7) = (/ &
 & 0.99574E+03_JPRB,0.75850E+03_JPRB,0.56228E+03_JPRB,0.81722E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 1,59, 7) = (/ &
 & 0.99575E+03_JPRB,0.75850E+03_JPRB,0.55905E+03_JPRB,0.81317E+03_JPRB,0.10694E+04_JPRB /)  
KB(:, 2,59, 7) = (/ &
 & 0.99574E+03_JPRB,0.75850E+03_JPRB,0.56032E+03_JPRB,0.81485E+03_JPRB,0.10718E+04_JPRB /)  
KB(:, 3,59, 7) = (/ &
 & 0.99574E+03_JPRB,0.75850E+03_JPRB,0.56125E+03_JPRB,0.81601E+03_JPRB,0.10735E+04_JPRB /)  
KB(:, 4,59, 7) = (/ &
 & 0.99574E+03_JPRB,0.75850E+03_JPRB,0.56189E+03_JPRB,0.81673E+03_JPRB,0.10747E+04_JPRB /)  
KB(:, 5,59, 7) = (/ &
 & 0.99573E+03_JPRB,0.75850E+03_JPRB,0.56225E+03_JPRB,0.81718E+03_JPRB,0.10753E+04_JPRB /)  
KB(:, 1,13, 8) = (/ &
 & 0.11451E+04_JPRB,0.86748E+03_JPRB,0.59259E+03_JPRB,0.85187E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 2,13, 8) = (/ &
 & 0.11363E+04_JPRB,0.86085E+03_JPRB,0.58896E+03_JPRB,0.85188E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 3,13, 8) = (/ &
 & 0.11286E+04_JPRB,0.85515E+03_JPRB,0.58586E+03_JPRB,0.85170E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 4,13, 8) = (/ &
 & 0.11220E+04_JPRB,0.85016E+03_JPRB,0.58378E+03_JPRB,0.85132E+03_JPRB,0.11224E+04_JPRB /)  
KB(:, 5,13, 8) = (/ &
 & 0.11162E+04_JPRB,0.84582E+03_JPRB,0.58229E+03_JPRB,0.85074E+03_JPRB,0.11218E+04_JPRB /)  
KB(:, 1,14, 8) = (/ &
 & 0.11230E+04_JPRB,0.85087E+03_JPRB,0.58392E+03_JPRB,0.85168E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 2,14, 8) = (/ &
 & 0.11158E+04_JPRB,0.84552E+03_JPRB,0.58280E+03_JPRB,0.85169E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 3,14, 8) = (/ &
 & 0.11097E+04_JPRB,0.84090E+03_JPRB,0.58233E+03_JPRB,0.85151E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 4,14, 8) = (/ &
 & 0.11043E+04_JPRB,0.83689E+03_JPRB,0.58194E+03_JPRB,0.85113E+03_JPRB,0.11223E+04_JPRB /)  
KB(:, 5,14, 8) = (/ &
 & 0.10996E+04_JPRB,0.83336E+03_JPRB,0.58140E+03_JPRB,0.85052E+03_JPRB,0.11217E+04_JPRB /)  
KB(:, 1,15, 8) = (/ &
 & 0.11049E+04_JPRB,0.83731E+03_JPRB,0.58207E+03_JPRB,0.85153E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 2,15, 8) = (/ &
 & 0.10991E+04_JPRB,0.83301E+03_JPRB,0.58217E+03_JPRB,0.85153E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 3,15, 8) = (/ &
 & 0.10942E+04_JPRB,0.82928E+03_JPRB,0.58200E+03_JPRB,0.85134E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 4,15, 8) = (/ &
 & 0.10899E+04_JPRB,0.82605E+03_JPRB,0.58161E+03_JPRB,0.85094E+03_JPRB,0.11223E+04_JPRB /)  
KB(:, 5,15, 8) = (/ &
 & 0.10860E+04_JPRB,0.82320E+03_JPRB,0.58108E+03_JPRB,0.85034E+03_JPRB,0.11216E+04_JPRB /)  
KB(:, 1,16, 8) = (/ &
 & 0.10902E+04_JPRB,0.82630E+03_JPRB,0.58181E+03_JPRB,0.85141E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 2,16, 8) = (/ &
 & 0.10856E+04_JPRB,0.82283E+03_JPRB,0.58190E+03_JPRB,0.85139E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 3,16, 8) = (/ &
 & 0.10816E+04_JPRB,0.81983E+03_JPRB,0.58172E+03_JPRB,0.85119E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 4,16, 8) = (/ &
 & 0.10781E+04_JPRB,0.81721E+03_JPRB,0.58133E+03_JPRB,0.85078E+03_JPRB,0.11222E+04_JPRB /)  
KB(:, 5,16, 8) = (/ &
 & 0.10750E+04_JPRB,0.81491E+03_JPRB,0.58080E+03_JPRB,0.85015E+03_JPRB,0.11215E+04_JPRB /)  
KB(:, 1,17, 8) = (/ &
 & 0.10783E+04_JPRB,0.81738E+03_JPRB,0.58160E+03_JPRB,0.85131E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 2,17, 8) = (/ &
 & 0.10746E+04_JPRB,0.81457E+03_JPRB,0.58168E+03_JPRB,0.85129E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 3,17, 8) = (/ &
 & 0.10713E+04_JPRB,0.81215E+03_JPRB,0.58149E+03_JPRB,0.85108E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 4,17, 8) = (/ &
 & 0.10685E+04_JPRB,0.81004E+03_JPRB,0.58109E+03_JPRB,0.85064E+03_JPRB,0.11222E+04_JPRB /)  
KB(:, 5,17, 8) = (/ &
 & 0.10660E+04_JPRB,0.80818E+03_JPRB,0.58056E+03_JPRB,0.85000E+03_JPRB,0.11214E+04_JPRB /)  
KB(:, 1,18, 8) = (/ &
 & 0.10686E+04_JPRB,0.81013E+03_JPRB,0.58144E+03_JPRB,0.85124E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 2,18, 8) = (/ &
 & 0.10656E+04_JPRB,0.80786E+03_JPRB,0.58150E+03_JPRB,0.85119E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 3,18, 8) = (/ &
 & 0.10630E+04_JPRB,0.80591E+03_JPRB,0.58129E+03_JPRB,0.85095E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 4,18, 8) = (/ &
 & 0.10607E+04_JPRB,0.80419E+03_JPRB,0.58089E+03_JPRB,0.85052E+03_JPRB,0.11221E+04_JPRB /)  
KB(:, 5,18, 8) = (/ &
 & 0.10587E+04_JPRB,0.80269E+03_JPRB,0.58036E+03_JPRB,0.84984E+03_JPRB,0.11213E+04_JPRB /)  
KB(:, 1,19, 8) = (/ &
 & 0.10608E+04_JPRB,0.80424E+03_JPRB,0.58130E+03_JPRB,0.85117E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 2,19, 8) = (/ &
 & 0.10584E+04_JPRB,0.80242E+03_JPRB,0.58135E+03_JPRB,0.85109E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 3,19, 8) = (/ &
 & 0.10562E+04_JPRB,0.80084E+03_JPRB,0.58113E+03_JPRB,0.85087E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 4,19, 8) = (/ &
 & 0.10544E+04_JPRB,0.79946E+03_JPRB,0.58072E+03_JPRB,0.85040E+03_JPRB,0.11220E+04_JPRB /)  
KB(:, 5,19, 8) = (/ &
 & 0.10528E+04_JPRB,0.79825E+03_JPRB,0.58019E+03_JPRB,0.84971E+03_JPRB,0.11212E+04_JPRB /)  
KB(:, 1,20, 8) = (/ &
 & 0.10544E+04_JPRB,0.79943E+03_JPRB,0.58120E+03_JPRB,0.85111E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 2,20, 8) = (/ &
 & 0.10524E+04_JPRB,0.79797E+03_JPRB,0.58122E+03_JPRB,0.85103E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 3,20, 8) = (/ &
 & 0.10507E+04_JPRB,0.79669E+03_JPRB,0.58098E+03_JPRB,0.85078E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 4,20, 8) = (/ &
 & 0.10492E+04_JPRB,0.79558E+03_JPRB,0.58056E+03_JPRB,0.85028E+03_JPRB,0.11220E+04_JPRB /)  
KB(:, 5,20, 8) = (/ &
 & 0.10479E+04_JPRB,0.79460E+03_JPRB,0.58002E+03_JPRB,0.84958E+03_JPRB,0.11211E+04_JPRB /)  
KB(:, 1,21, 8) = (/ &
 & 0.10492E+04_JPRB,0.79553E+03_JPRB,0.58112E+03_JPRB,0.85107E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 2,21, 8) = (/ &
 & 0.10476E+04_JPRB,0.79436E+03_JPRB,0.58112E+03_JPRB,0.85096E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 3,21, 8) = (/ &
 & 0.10462E+04_JPRB,0.79334E+03_JPRB,0.58085E+03_JPRB,0.85069E+03_JPRB,0.11224E+04_JPRB /)  
KB(:, 4,21, 8) = (/ &
 & 0.10450E+04_JPRB,0.79243E+03_JPRB,0.58042E+03_JPRB,0.85021E+03_JPRB,0.11219E+04_JPRB /)  
KB(:, 5,21, 8) = (/ &
 & 0.10440E+04_JPRB,0.79165E+03_JPRB,0.57987E+03_JPRB,0.84945E+03_JPRB,0.11210E+04_JPRB /)  
KB(:, 1,22, 8) = (/ &
 & 0.10449E+04_JPRB,0.79230E+03_JPRB,0.58106E+03_JPRB,0.85103E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 2,22, 8) = (/ &
 & 0.10436E+04_JPRB,0.79136E+03_JPRB,0.58100E+03_JPRB,0.85090E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 3,22, 8) = (/ &
 & 0.10425E+04_JPRB,0.79054E+03_JPRB,0.58071E+03_JPRB,0.85058E+03_JPRB,0.11224E+04_JPRB /)  
KB(:, 4,22, 8) = (/ &
 & 0.10416E+04_JPRB,0.78983E+03_JPRB,0.58026E+03_JPRB,0.85002E+03_JPRB,0.11217E+04_JPRB /)  
KB(:, 5,22, 8) = (/ &
 & 0.10407E+04_JPRB,0.78921E+03_JPRB,0.57969E+03_JPRB,0.84925E+03_JPRB,0.11208E+04_JPRB /)  
KB(:, 1,23, 8) = (/ &
 & 0.10414E+04_JPRB,0.78969E+03_JPRB,0.58100E+03_JPRB,0.85099E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 2,23, 8) = (/ &
 & 0.10404E+04_JPRB,0.78894E+03_JPRB,0.58090E+03_JPRB,0.85083E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 3,23, 8) = (/ &
 & 0.10395E+04_JPRB,0.78829E+03_JPRB,0.58058E+03_JPRB,0.85047E+03_JPRB,0.11223E+04_JPRB /)  
KB(:, 4,23, 8) = (/ &
 & 0.10387E+04_JPRB,0.78772E+03_JPRB,0.58011E+03_JPRB,0.84989E+03_JPRB,0.11216E+04_JPRB /)  
KB(:, 5,23, 8) = (/ &
 & 0.10381E+04_JPRB,0.78721E+03_JPRB,0.57952E+03_JPRB,0.84905E+03_JPRB,0.11206E+04_JPRB /)  
KB(:, 1,24, 8) = (/ &
 & 0.10386E+04_JPRB,0.78759E+03_JPRB,0.58095E+03_JPRB,0.85095E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 2,24, 8) = (/ &
 & 0.10378E+04_JPRB,0.78698E+03_JPRB,0.58081E+03_JPRB,0.85075E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 3,24, 8) = (/ &
 & 0.10371E+04_JPRB,0.78646E+03_JPRB,0.58046E+03_JPRB,0.85035E+03_JPRB,0.11222E+04_JPRB /)  
KB(:, 4,24, 8) = (/ &
 & 0.10365E+04_JPRB,0.78601E+03_JPRB,0.57995E+03_JPRB,0.84971E+03_JPRB,0.11214E+04_JPRB /)  
KB(:, 5,24, 8) = (/ &
 & 0.10359E+04_JPRB,0.78561E+03_JPRB,0.57934E+03_JPRB,0.84885E+03_JPRB,0.11203E+04_JPRB /)  
KB(:, 1,25, 8) = (/ &
 & 0.10363E+04_JPRB,0.78588E+03_JPRB,0.58090E+03_JPRB,0.85090E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 2,25, 8) = (/ &
 & 0.10357E+04_JPRB,0.78541E+03_JPRB,0.58070E+03_JPRB,0.85067E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 3,25, 8) = (/ &
 & 0.10351E+04_JPRB,0.78498E+03_JPRB,0.58032E+03_JPRB,0.85020E+03_JPRB,0.11220E+04_JPRB /)  
KB(:, 4,25, 8) = (/ &
 & 0.10346E+04_JPRB,0.78461E+03_JPRB,0.57980E+03_JPRB,0.84953E+03_JPRB,0.11212E+04_JPRB /)  
KB(:, 5,25, 8) = (/ &
 & 0.10342E+04_JPRB,0.78430E+03_JPRB,0.57916E+03_JPRB,0.84863E+03_JPRB,0.11201E+04_JPRB /)  
KB(:, 1,26, 8) = (/ &
 & 0.10345E+04_JPRB,0.78450E+03_JPRB,0.58084E+03_JPRB,0.85084E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 2,26, 8) = (/ &
 & 0.10339E+04_JPRB,0.78411E+03_JPRB,0.58059E+03_JPRB,0.85057E+03_JPRB,0.11224E+04_JPRB /)  
KB(:, 3,26, 8) = (/ &
 & 0.10335E+04_JPRB,0.78378E+03_JPRB,0.58018E+03_JPRB,0.85004E+03_JPRB,0.11219E+04_JPRB /)  
KB(:, 4,26, 8) = (/ &
 & 0.10331E+04_JPRB,0.78349E+03_JPRB,0.57964E+03_JPRB,0.84934E+03_JPRB,0.11210E+04_JPRB /)  
KB(:, 5,26, 8) = (/ &
 & 0.10328E+04_JPRB,0.78323E+03_JPRB,0.57897E+03_JPRB,0.84838E+03_JPRB,0.11198E+04_JPRB /)  
KB(:, 1,27, 8) = (/ &
 & 0.10329E+04_JPRB,0.78338E+03_JPRB,0.58078E+03_JPRB,0.85078E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 2,27, 8) = (/ &
 & 0.10326E+04_JPRB,0.78307E+03_JPRB,0.58048E+03_JPRB,0.85045E+03_JPRB,0.11223E+04_JPRB /)  
KB(:, 3,27, 8) = (/ &
 & 0.10322E+04_JPRB,0.78282E+03_JPRB,0.58003E+03_JPRB,0.84982E+03_JPRB,0.11217E+04_JPRB /)  
KB(:, 4,27, 8) = (/ &
 & 0.10319E+04_JPRB,0.78258E+03_JPRB,0.57947E+03_JPRB,0.84907E+03_JPRB,0.11207E+04_JPRB /)  
KB(:, 5,27, 8) = (/ &
 & 0.10316E+04_JPRB,0.78237E+03_JPRB,0.57877E+03_JPRB,0.84811E+03_JPRB,0.11194E+04_JPRB /)  
KB(:, 1,28, 8) = (/ &
 & 0.10318E+04_JPRB,0.78248E+03_JPRB,0.58069E+03_JPRB,0.85072E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 2,28, 8) = (/ &
 & 0.10314E+04_JPRB,0.78225E+03_JPRB,0.58037E+03_JPRB,0.85030E+03_JPRB,0.11222E+04_JPRB /)  
KB(:, 3,28, 8) = (/ &
 & 0.10312E+04_JPRB,0.78205E+03_JPRB,0.57989E+03_JPRB,0.84960E+03_JPRB,0.11215E+04_JPRB /)  
KB(:, 4,28, 8) = (/ &
 & 0.10309E+04_JPRB,0.78185E+03_JPRB,0.57929E+03_JPRB,0.84888E+03_JPRB,0.11204E+04_JPRB /)  
KB(:, 5,28, 8) = (/ &
 & 0.10307E+04_JPRB,0.78168E+03_JPRB,0.57856E+03_JPRB,0.84784E+03_JPRB,0.11191E+04_JPRB /)  
KB(:, 1,29, 8) = (/ &
 & 0.10308E+04_JPRB,0.78175E+03_JPRB,0.58061E+03_JPRB,0.85062E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 2,29, 8) = (/ &
 & 0.10305E+04_JPRB,0.78157E+03_JPRB,0.58024E+03_JPRB,0.85019E+03_JPRB,0.11221E+04_JPRB /)  
KB(:, 3,29, 8) = (/ &
 & 0.10303E+04_JPRB,0.78140E+03_JPRB,0.57974E+03_JPRB,0.84950E+03_JPRB,0.11213E+04_JPRB /)  
KB(:, 4,29, 8) = (/ &
 & 0.10301E+04_JPRB,0.78126E+03_JPRB,0.57911E+03_JPRB,0.84863E+03_JPRB,0.11201E+04_JPRB /)  
KB(:, 5,29, 8) = (/ &
 & 0.10300E+04_JPRB,0.78112E+03_JPRB,0.57834E+03_JPRB,0.84752E+03_JPRB,0.11188E+04_JPRB /)  
KB(:, 1,30, 8) = (/ &
 & 0.10300E+04_JPRB,0.78117E+03_JPRB,0.58052E+03_JPRB,0.85055E+03_JPRB,0.11224E+04_JPRB /)  
KB(:, 2,30, 8) = (/ &
 & 0.10298E+04_JPRB,0.78102E+03_JPRB,0.58011E+03_JPRB,0.85001E+03_JPRB,0.11219E+04_JPRB /)  
KB(:, 3,30, 8) = (/ &
 & 0.10296E+04_JPRB,0.78089E+03_JPRB,0.57958E+03_JPRB,0.84932E+03_JPRB,0.11210E+04_JPRB /)  
KB(:, 4,30, 8) = (/ &
 & 0.10295E+04_JPRB,0.78077E+03_JPRB,0.57892E+03_JPRB,0.84838E+03_JPRB,0.11198E+04_JPRB /)  
KB(:, 5,30, 8) = (/ &
 & 0.10294E+04_JPRB,0.78066E+03_JPRB,0.57811E+03_JPRB,0.84720E+03_JPRB,0.11184E+04_JPRB /)  
KB(:, 1,31, 8) = (/ &
 & 0.10294E+04_JPRB,0.78070E+03_JPRB,0.58042E+03_JPRB,0.85041E+03_JPRB,0.11223E+04_JPRB /)  
KB(:, 2,31, 8) = (/ &
 & 0.10292E+04_JPRB,0.78058E+03_JPRB,0.57998E+03_JPRB,0.84985E+03_JPRB,0.11217E+04_JPRB /)  
KB(:, 3,31, 8) = (/ &
 & 0.10291E+04_JPRB,0.78049E+03_JPRB,0.57941E+03_JPRB,0.84908E+03_JPRB,0.11207E+04_JPRB /)  
KB(:, 4,31, 8) = (/ &
 & 0.10290E+04_JPRB,0.78039E+03_JPRB,0.57872E+03_JPRB,0.84808E+03_JPRB,0.11195E+04_JPRB /)  
KB(:, 5,31, 8) = (/ &
 & 0.10289E+04_JPRB,0.78030E+03_JPRB,0.57786E+03_JPRB,0.84686E+03_JPRB,0.11179E+04_JPRB /)  
KB(:, 1,32, 8) = (/ &
 & 0.10289E+04_JPRB,0.78033E+03_JPRB,0.58031E+03_JPRB,0.85030E+03_JPRB,0.11222E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART23',1,ZHOOK_HANDLE)
END SUBROUTINE PART23


SUBROUTINE PART24

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART24',0,ZHOOK_HANDLE)


KB(:, 2,32, 8) = (/ &
 & 0.10288E+04_JPRB,0.78024E+03_JPRB,0.57984E+03_JPRB,0.84967E+03_JPRB,0.11215E+04_JPRB /)  
KB(:, 3,32, 8) = (/ &
 & 0.10287E+04_JPRB,0.78016E+03_JPRB,0.57924E+03_JPRB,0.84884E+03_JPRB,0.11204E+04_JPRB /)  
KB(:, 4,32, 8) = (/ &
 & 0.10286E+04_JPRB,0.78009E+03_JPRB,0.57851E+03_JPRB,0.84778E+03_JPRB,0.11191E+04_JPRB /)  
KB(:, 5,32, 8) = (/ &
 & 0.10285E+04_JPRB,0.78000E+03_JPRB,0.57759E+03_JPRB,0.84651E+03_JPRB,0.11175E+04_JPRB /)  
KB(:, 1,33, 8) = (/ &
 & 0.10285E+04_JPRB,0.78003E+03_JPRB,0.58019E+03_JPRB,0.85016E+03_JPRB,0.11220E+04_JPRB /)  
KB(:, 2,33, 8) = (/ &
 & 0.10284E+04_JPRB,0.77995E+03_JPRB,0.57968E+03_JPRB,0.84947E+03_JPRB,0.11212E+04_JPRB /)  
KB(:, 3,33, 8) = (/ &
 & 0.10283E+04_JPRB,0.77988E+03_JPRB,0.57905E+03_JPRB,0.84858E+03_JPRB,0.11201E+04_JPRB /)  
KB(:, 4,33, 8) = (/ &
 & 0.10282E+04_JPRB,0.77982E+03_JPRB,0.57829E+03_JPRB,0.84747E+03_JPRB,0.11187E+04_JPRB /)  
KB(:, 5,33, 8) = (/ &
 & 0.10282E+04_JPRB,0.77978E+03_JPRB,0.57730E+03_JPRB,0.84615E+03_JPRB,0.11170E+04_JPRB /)  
KB(:, 1,34, 8) = (/ &
 & 0.10282E+04_JPRB,0.77978E+03_JPRB,0.58008E+03_JPRB,0.84998E+03_JPRB,0.11219E+04_JPRB /)  
KB(:, 2,34, 8) = (/ &
 & 0.10281E+04_JPRB,0.77972E+03_JPRB,0.57954E+03_JPRB,0.84930E+03_JPRB,0.11210E+04_JPRB /)  
KB(:, 3,34, 8) = (/ &
 & 0.10280E+04_JPRB,0.77967E+03_JPRB,0.57889E+03_JPRB,0.84836E+03_JPRB,0.11198E+04_JPRB /)  
KB(:, 4,34, 8) = (/ &
 & 0.10280E+04_JPRB,0.77962E+03_JPRB,0.57808E+03_JPRB,0.84718E+03_JPRB,0.11184E+04_JPRB /)  
KB(:, 5,34, 8) = (/ &
 & 0.10279E+04_JPRB,0.77958E+03_JPRB,0.57705E+03_JPRB,0.84582E+03_JPRB,0.11166E+04_JPRB /)  
KB(:, 1,35, 8) = (/ &
 & 0.10279E+04_JPRB,0.77958E+03_JPRB,0.58001E+03_JPRB,0.84995E+03_JPRB,0.11218E+04_JPRB /)  
KB(:, 2,35, 8) = (/ &
 & 0.10278E+04_JPRB,0.77953E+03_JPRB,0.57946E+03_JPRB,0.84916E+03_JPRB,0.11209E+04_JPRB /)  
KB(:, 3,35, 8) = (/ &
 & 0.10278E+04_JPRB,0.77951E+03_JPRB,0.57880E+03_JPRB,0.84823E+03_JPRB,0.11196E+04_JPRB /)  
KB(:, 4,35, 8) = (/ &
 & 0.10277E+04_JPRB,0.77946E+03_JPRB,0.57796E+03_JPRB,0.84701E+03_JPRB,0.11181E+04_JPRB /)  
KB(:, 5,35, 8) = (/ &
 & 0.10277E+04_JPRB,0.77943E+03_JPRB,0.57689E+03_JPRB,0.84563E+03_JPRB,0.11163E+04_JPRB /)  
KB(:, 1,36, 8) = (/ &
 & 0.10277E+04_JPRB,0.77944E+03_JPRB,0.58000E+03_JPRB,0.84992E+03_JPRB,0.11218E+04_JPRB /)  
KB(:, 2,36, 8) = (/ &
 & 0.10277E+04_JPRB,0.77940E+03_JPRB,0.57944E+03_JPRB,0.84917E+03_JPRB,0.11208E+04_JPRB /)  
KB(:, 3,36, 8) = (/ &
 & 0.10276E+04_JPRB,0.77936E+03_JPRB,0.57877E+03_JPRB,0.84819E+03_JPRB,0.11196E+04_JPRB /)  
KB(:, 4,36, 8) = (/ &
 & 0.10276E+04_JPRB,0.77933E+03_JPRB,0.57793E+03_JPRB,0.84697E+03_JPRB,0.11181E+04_JPRB /)  
KB(:, 5,36, 8) = (/ &
 & 0.10275E+04_JPRB,0.77931E+03_JPRB,0.57686E+03_JPRB,0.84561E+03_JPRB,0.11162E+04_JPRB /)  
KB(:, 1,37, 8) = (/ &
 & 0.10275E+04_JPRB,0.77932E+03_JPRB,0.58006E+03_JPRB,0.85002E+03_JPRB,0.11219E+04_JPRB /)  
KB(:, 2,37, 8) = (/ &
 & 0.10275E+04_JPRB,0.77929E+03_JPRB,0.57952E+03_JPRB,0.84927E+03_JPRB,0.11210E+04_JPRB /)  
KB(:, 3,37, 8) = (/ &
 & 0.10275E+04_JPRB,0.77926E+03_JPRB,0.57886E+03_JPRB,0.84832E+03_JPRB,0.11198E+04_JPRB /)  
KB(:, 4,37, 8) = (/ &
 & 0.10274E+04_JPRB,0.77924E+03_JPRB,0.57805E+03_JPRB,0.84715E+03_JPRB,0.11183E+04_JPRB /)  
KB(:, 5,37, 8) = (/ &
 & 0.10274E+04_JPRB,0.77921E+03_JPRB,0.57701E+03_JPRB,0.84575E+03_JPRB,0.11165E+04_JPRB /)  
KB(:, 1,38, 8) = (/ &
 & 0.10274E+04_JPRB,0.77922E+03_JPRB,0.58012E+03_JPRB,0.85009E+03_JPRB,0.11220E+04_JPRB /)  
KB(:, 2,38, 8) = (/ &
 & 0.10274E+04_JPRB,0.77920E+03_JPRB,0.57959E+03_JPRB,0.84938E+03_JPRB,0.11211E+04_JPRB /)  
KB(:, 3,38, 8) = (/ &
 & 0.10274E+04_JPRB,0.77918E+03_JPRB,0.57896E+03_JPRB,0.84848E+03_JPRB,0.11200E+04_JPRB /)  
KB(:, 4,38, 8) = (/ &
 & 0.10273E+04_JPRB,0.77915E+03_JPRB,0.57818E+03_JPRB,0.84731E+03_JPRB,0.11185E+04_JPRB /)  
KB(:, 5,38, 8) = (/ &
 & 0.10273E+04_JPRB,0.77912E+03_JPRB,0.57716E+03_JPRB,0.84599E+03_JPRB,0.11168E+04_JPRB /)  
KB(:, 1,39, 8) = (/ &
 & 0.10273E+04_JPRB,0.77914E+03_JPRB,0.58018E+03_JPRB,0.85016E+03_JPRB,0.11221E+04_JPRB /)  
KB(:, 2,39, 8) = (/ &
 & 0.10273E+04_JPRB,0.77912E+03_JPRB,0.57968E+03_JPRB,0.84939E+03_JPRB,0.11213E+04_JPRB /)  
KB(:, 3,39, 8) = (/ &
 & 0.10273E+04_JPRB,0.77911E+03_JPRB,0.57905E+03_JPRB,0.84861E+03_JPRB,0.11201E+04_JPRB /)  
KB(:, 4,39, 8) = (/ &
 & 0.10272E+04_JPRB,0.77910E+03_JPRB,0.57829E+03_JPRB,0.84750E+03_JPRB,0.11187E+04_JPRB /)  
KB(:, 5,39, 8) = (/ &
 & 0.10272E+04_JPRB,0.77907E+03_JPRB,0.57732E+03_JPRB,0.84617E+03_JPRB,0.11171E+04_JPRB /)  
KB(:, 1,40, 8) = (/ &
 & 0.10272E+04_JPRB,0.77908E+03_JPRB,0.58028E+03_JPRB,0.85029E+03_JPRB,0.11222E+04_JPRB /)  
KB(:, 2,40, 8) = (/ &
 & 0.10272E+04_JPRB,0.77906E+03_JPRB,0.57981E+03_JPRB,0.84968E+03_JPRB,0.11215E+04_JPRB /)  
KB(:, 3,40, 8) = (/ &
 & 0.10272E+04_JPRB,0.77904E+03_JPRB,0.57922E+03_JPRB,0.84885E+03_JPRB,0.11204E+04_JPRB /)  
KB(:, 4,40, 8) = (/ &
 & 0.10272E+04_JPRB,0.77904E+03_JPRB,0.57849E+03_JPRB,0.84779E+03_JPRB,0.11191E+04_JPRB /)  
KB(:, 5,40, 8) = (/ &
 & 0.10272E+04_JPRB,0.77901E+03_JPRB,0.57757E+03_JPRB,0.84651E+03_JPRB,0.11176E+04_JPRB /)  
KB(:, 1,41, 8) = (/ &
 & 0.10272E+04_JPRB,0.77903E+03_JPRB,0.58037E+03_JPRB,0.85041E+03_JPRB,0.11224E+04_JPRB /)  
KB(:, 2,41, 8) = (/ &
 & 0.10272E+04_JPRB,0.77902E+03_JPRB,0.57994E+03_JPRB,0.84983E+03_JPRB,0.11217E+04_JPRB /)  
KB(:, 3,41, 8) = (/ &
 & 0.10271E+04_JPRB,0.77900E+03_JPRB,0.57937E+03_JPRB,0.84906E+03_JPRB,0.11207E+04_JPRB /)  
KB(:, 4,41, 8) = (/ &
 & 0.10271E+04_JPRB,0.77898E+03_JPRB,0.57870E+03_JPRB,0.84808E+03_JPRB,0.11195E+04_JPRB /)  
KB(:, 5,41, 8) = (/ &
 & 0.10271E+04_JPRB,0.77898E+03_JPRB,0.57782E+03_JPRB,0.84685E+03_JPRB,0.11180E+04_JPRB /)  
KB(:, 1,42, 8) = (/ &
 & 0.10271E+04_JPRB,0.77900E+03_JPRB,0.58046E+03_JPRB,0.85051E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 2,42, 8) = (/ &
 & 0.10271E+04_JPRB,0.77898E+03_JPRB,0.58006E+03_JPRB,0.85002E+03_JPRB,0.11219E+04_JPRB /)  
KB(:, 3,42, 8) = (/ &
 & 0.10271E+04_JPRB,0.77896E+03_JPRB,0.57953E+03_JPRB,0.84930E+03_JPRB,0.11210E+04_JPRB /)  
KB(:, 4,42, 8) = (/ &
 & 0.10271E+04_JPRB,0.77895E+03_JPRB,0.57888E+03_JPRB,0.84835E+03_JPRB,0.11198E+04_JPRB /)  
KB(:, 5,42, 8) = (/ &
 & 0.10270E+04_JPRB,0.77894E+03_JPRB,0.57806E+03_JPRB,0.84718E+03_JPRB,0.11184E+04_JPRB /)  
KB(:, 1,43, 8) = (/ &
 & 0.10271E+04_JPRB,0.77895E+03_JPRB,0.58056E+03_JPRB,0.85062E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 2,43, 8) = (/ &
 & 0.10270E+04_JPRB,0.77895E+03_JPRB,0.58020E+03_JPRB,0.85017E+03_JPRB,0.11221E+04_JPRB /)  
KB(:, 3,43, 8) = (/ &
 & 0.10270E+04_JPRB,0.77892E+03_JPRB,0.57970E+03_JPRB,0.84954E+03_JPRB,0.11213E+04_JPRB /)  
KB(:, 4,43, 8) = (/ &
 & 0.10270E+04_JPRB,0.77892E+03_JPRB,0.57909E+03_JPRB,0.84866E+03_JPRB,0.11202E+04_JPRB /)  
KB(:, 5,43, 8) = (/ &
 & 0.10270E+04_JPRB,0.77891E+03_JPRB,0.57834E+03_JPRB,0.84756E+03_JPRB,0.11188E+04_JPRB /)  
KB(:, 1,44, 8) = (/ &
 & 0.10270E+04_JPRB,0.77892E+03_JPRB,0.58064E+03_JPRB,0.85071E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 2,44, 8) = (/ &
 & 0.10270E+04_JPRB,0.77891E+03_JPRB,0.58034E+03_JPRB,0.85036E+03_JPRB,0.11223E+04_JPRB /)  
KB(:, 3,44, 8) = (/ &
 & 0.10270E+04_JPRB,0.77891E+03_JPRB,0.57988E+03_JPRB,0.84979E+03_JPRB,0.11216E+04_JPRB /)  
KB(:, 4,44, 8) = (/ &
 & 0.10270E+04_JPRB,0.77890E+03_JPRB,0.57931E+03_JPRB,0.84899E+03_JPRB,0.11206E+04_JPRB /)  
KB(:, 5,44, 8) = (/ &
 & 0.10270E+04_JPRB,0.77888E+03_JPRB,0.57861E+03_JPRB,0.84797E+03_JPRB,0.11193E+04_JPRB /)  
KB(:, 1,45, 8) = (/ &
 & 0.10270E+04_JPRB,0.77889E+03_JPRB,0.58069E+03_JPRB,0.85078E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 2,45, 8) = (/ &
 & 0.10270E+04_JPRB,0.77888E+03_JPRB,0.58047E+03_JPRB,0.85051E+03_JPRB,0.11224E+04_JPRB /)  
KB(:, 3,45, 8) = (/ &
 & 0.10270E+04_JPRB,0.77888E+03_JPRB,0.58005E+03_JPRB,0.84999E+03_JPRB,0.11219E+04_JPRB /)  
KB(:, 4,45, 8) = (/ &
 & 0.10270E+04_JPRB,0.77888E+03_JPRB,0.57952E+03_JPRB,0.84927E+03_JPRB,0.11210E+04_JPRB /)  
KB(:, 5,45, 8) = (/ &
 & 0.10269E+04_JPRB,0.77886E+03_JPRB,0.57890E+03_JPRB,0.84837E+03_JPRB,0.11198E+04_JPRB /)  
KB(:, 1,46, 8) = (/ &
 & 0.10270E+04_JPRB,0.77887E+03_JPRB,0.58072E+03_JPRB,0.85082E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 2,46, 8) = (/ &
 & 0.10270E+04_JPRB,0.77886E+03_JPRB,0.58056E+03_JPRB,0.85063E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 3,46, 8) = (/ &
 & 0.10269E+04_JPRB,0.77886E+03_JPRB,0.58022E+03_JPRB,0.85021E+03_JPRB,0.11221E+04_JPRB /)  
KB(:, 4,46, 8) = (/ &
 & 0.10270E+04_JPRB,0.77885E+03_JPRB,0.57972E+03_JPRB,0.84957E+03_JPRB,0.11213E+04_JPRB /)  
KB(:, 5,46, 8) = (/ &
 & 0.10269E+04_JPRB,0.77884E+03_JPRB,0.57911E+03_JPRB,0.84871E+03_JPRB,0.11203E+04_JPRB /)  
KB(:, 1,47, 8) = (/ &
 & 0.10269E+04_JPRB,0.77885E+03_JPRB,0.58070E+03_JPRB,0.85086E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 2,47, 8) = (/ &
 & 0.10269E+04_JPRB,0.77886E+03_JPRB,0.58066E+03_JPRB,0.85073E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 3,47, 8) = (/ &
 & 0.10269E+04_JPRB,0.77885E+03_JPRB,0.58037E+03_JPRB,0.85041E+03_JPRB,0.11223E+04_JPRB /)  
KB(:, 4,47, 8) = (/ &
 & 0.10269E+04_JPRB,0.77884E+03_JPRB,0.57993E+03_JPRB,0.84985E+03_JPRB,0.11217E+04_JPRB /)  
KB(:, 5,47, 8) = (/ &
 & 0.10269E+04_JPRB,0.77883E+03_JPRB,0.57937E+03_JPRB,0.84903E+03_JPRB,0.11207E+04_JPRB /)  
KB(:, 1,48, 8) = (/ &
 & 0.10269E+04_JPRB,0.77884E+03_JPRB,0.58064E+03_JPRB,0.85086E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 2,48, 8) = (/ &
 & 0.10269E+04_JPRB,0.77883E+03_JPRB,0.58071E+03_JPRB,0.85080E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 3,48, 8) = (/ &
 & 0.10269E+04_JPRB,0.77883E+03_JPRB,0.58051E+03_JPRB,0.85055E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 4,48, 8) = (/ &
 & 0.10269E+04_JPRB,0.77883E+03_JPRB,0.58013E+03_JPRB,0.85010E+03_JPRB,0.11220E+04_JPRB /)  
KB(:, 5,48, 8) = (/ &
 & 0.10269E+04_JPRB,0.77883E+03_JPRB,0.57961E+03_JPRB,0.84941E+03_JPRB,0.11212E+04_JPRB /)  
KB(:, 1,49, 8) = (/ &
 & 0.10269E+04_JPRB,0.77884E+03_JPRB,0.58054E+03_JPRB,0.85082E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 2,49, 8) = (/ &
 & 0.10269E+04_JPRB,0.77882E+03_JPRB,0.58072E+03_JPRB,0.85085E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 3,49, 8) = (/ &
 & 0.10269E+04_JPRB,0.77883E+03_JPRB,0.58061E+03_JPRB,0.85068E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 4,49, 8) = (/ &
 & 0.10269E+04_JPRB,0.77882E+03_JPRB,0.58029E+03_JPRB,0.85032E+03_JPRB,0.11222E+04_JPRB /)  
KB(:, 5,49, 8) = (/ &
 & 0.10269E+04_JPRB,0.77881E+03_JPRB,0.57983E+03_JPRB,0.84969E+03_JPRB,0.11215E+04_JPRB /)  
KB(:, 1,50, 8) = (/ &
 & 0.10269E+04_JPRB,0.77883E+03_JPRB,0.58042E+03_JPRB,0.85074E+03_JPRB,0.11224E+04_JPRB /)  
KB(:, 2,50, 8) = (/ &
 & 0.10269E+04_JPRB,0.77881E+03_JPRB,0.58068E+03_JPRB,0.85085E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 3,50, 8) = (/ &
 & 0.10269E+04_JPRB,0.77882E+03_JPRB,0.58069E+03_JPRB,0.85077E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 4,50, 8) = (/ &
 & 0.10269E+04_JPRB,0.77880E+03_JPRB,0.58043E+03_JPRB,0.85048E+03_JPRB,0.11224E+04_JPRB /)  
KB(:, 5,50, 8) = (/ &
 & 0.10269E+04_JPRB,0.77880E+03_JPRB,0.58002E+03_JPRB,0.84997E+03_JPRB,0.11218E+04_JPRB /)  
KB(:, 1,51, 8) = (/ &
 & 0.10269E+04_JPRB,0.77881E+03_JPRB,0.58027E+03_JPRB,0.85064E+03_JPRB,0.11224E+04_JPRB /)  
KB(:, 2,51, 8) = (/ &
 & 0.10269E+04_JPRB,0.77882E+03_JPRB,0.58061E+03_JPRB,0.85085E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 3,51, 8) = (/ &
 & 0.10269E+04_JPRB,0.77880E+03_JPRB,0.58071E+03_JPRB,0.85082E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 4,51, 8) = (/ &
 & 0.10269E+04_JPRB,0.77880E+03_JPRB,0.58055E+03_JPRB,0.85061E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 5,51, 8) = (/ &
 & 0.10269E+04_JPRB,0.77881E+03_JPRB,0.58020E+03_JPRB,0.85015E+03_JPRB,0.11221E+04_JPRB /)  
KB(:, 1,52, 8) = (/ &
 & 0.10269E+04_JPRB,0.77880E+03_JPRB,0.58011E+03_JPRB,0.85051E+03_JPRB,0.11222E+04_JPRB /)  
KB(:, 2,52, 8) = (/ &
 & 0.10269E+04_JPRB,0.77880E+03_JPRB,0.58051E+03_JPRB,0.85080E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 3,52, 8) = (/ &
 & 0.10269E+04_JPRB,0.77880E+03_JPRB,0.58071E+03_JPRB,0.85085E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 4,52, 8) = (/ &
 & 0.10268E+04_JPRB,0.77879E+03_JPRB,0.58064E+03_JPRB,0.85068E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 5,52, 8) = (/ &
 & 0.10268E+04_JPRB,0.77879E+03_JPRB,0.58034E+03_JPRB,0.85037E+03_JPRB,0.11223E+04_JPRB /)  
KB(:, 1,53, 8) = (/ &
 & 0.10269E+04_JPRB,0.77880E+03_JPRB,0.57994E+03_JPRB,0.85036E+03_JPRB,0.11220E+04_JPRB /)  
KB(:, 2,53, 8) = (/ &
 & 0.10269E+04_JPRB,0.77879E+03_JPRB,0.58038E+03_JPRB,0.85072E+03_JPRB,0.11224E+04_JPRB /)  
KB(:, 3,53, 8) = (/ &
 & 0.10268E+04_JPRB,0.77879E+03_JPRB,0.58066E+03_JPRB,0.85087E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 4,53, 8) = (/ &
 & 0.10269E+04_JPRB,0.77880E+03_JPRB,0.58069E+03_JPRB,0.85078E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 5,53, 8) = (/ &
 & 0.10268E+04_JPRB,0.77878E+03_JPRB,0.58047E+03_JPRB,0.85044E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 1,54, 8) = (/ &
 & 0.10268E+04_JPRB,0.77879E+03_JPRB,0.57977E+03_JPRB,0.85022E+03_JPRB,0.11219E+04_JPRB /)  
KB(:, 2,54, 8) = (/ &
 & 0.10269E+04_JPRB,0.77879E+03_JPRB,0.58026E+03_JPRB,0.85061E+03_JPRB,0.11223E+04_JPRB /)  
KB(:, 3,54, 8) = (/ &
 & 0.10268E+04_JPRB,0.77881E+03_JPRB,0.58060E+03_JPRB,0.85084E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 4,54, 8) = (/ &
 & 0.10268E+04_JPRB,0.77879E+03_JPRB,0.58072E+03_JPRB,0.85083E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 5,54, 8) = (/ &
 & 0.10268E+04_JPRB,0.77878E+03_JPRB,0.58058E+03_JPRB,0.85063E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 1,55, 8) = (/ &
 & 0.10268E+04_JPRB,0.77879E+03_JPRB,0.57962E+03_JPRB,0.85008E+03_JPRB,0.11217E+04_JPRB /)  
KB(:, 2,55, 8) = (/ &
 & 0.10268E+04_JPRB,0.77878E+03_JPRB,0.58011E+03_JPRB,0.85050E+03_JPRB,0.11222E+04_JPRB /)  
KB(:, 3,55, 8) = (/ &
 & 0.10268E+04_JPRB,0.77879E+03_JPRB,0.58050E+03_JPRB,0.85080E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 4,55, 8) = (/ &
 & 0.10268E+04_JPRB,0.77880E+03_JPRB,0.58071E+03_JPRB,0.85085E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 5,55, 8) = (/ &
 & 0.10268E+04_JPRB,0.77878E+03_JPRB,0.58064E+03_JPRB,0.85072E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 1,56, 8) = (/ &
 & 0.10268E+04_JPRB,0.77878E+03_JPRB,0.57945E+03_JPRB,0.84993E+03_JPRB,0.11216E+04_JPRB /)  
KB(:, 2,56, 8) = (/ &
 & 0.10268E+04_JPRB,0.77877E+03_JPRB,0.57995E+03_JPRB,0.85037E+03_JPRB,0.11220E+04_JPRB /)  
KB(:, 3,56, 8) = (/ &
 & 0.10268E+04_JPRB,0.77877E+03_JPRB,0.58039E+03_JPRB,0.85071E+03_JPRB,0.11224E+04_JPRB /)  
KB(:, 4,56, 8) = (/ &
 & 0.10268E+04_JPRB,0.77878E+03_JPRB,0.58067E+03_JPRB,0.85086E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 5,56, 8) = (/ &
 & 0.10268E+04_JPRB,0.77878E+03_JPRB,0.58069E+03_JPRB,0.85078E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 1,57, 8) = (/ &
 & 0.10268E+04_JPRB,0.77879E+03_JPRB,0.57927E+03_JPRB,0.84978E+03_JPRB,0.11215E+04_JPRB /)  
KB(:, 2,57, 8) = (/ &
 & 0.10268E+04_JPRB,0.77878E+03_JPRB,0.57979E+03_JPRB,0.85024E+03_JPRB,0.11219E+04_JPRB /)  
KB(:, 3,57, 8) = (/ &
 & 0.10268E+04_JPRB,0.77878E+03_JPRB,0.58025E+03_JPRB,0.85063E+03_JPRB,0.11223E+04_JPRB /)  
KB(:, 4,57, 8) = (/ &
 & 0.10268E+04_JPRB,0.77878E+03_JPRB,0.58060E+03_JPRB,0.85084E+03_JPRB,0.11226E+04_JPRB /)  
KB(:, 5,57, 8) = (/ &
 & 0.10268E+04_JPRB,0.77878E+03_JPRB,0.58071E+03_JPRB,0.85083E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 1,58, 8) = (/ &
 & 0.10268E+04_JPRB,0.77878E+03_JPRB,0.57911E+03_JPRB,0.84962E+03_JPRB,0.11212E+04_JPRB /)  
KB(:, 2,58, 8) = (/ &
 & 0.10268E+04_JPRB,0.77878E+03_JPRB,0.57964E+03_JPRB,0.85010E+03_JPRB,0.11218E+04_JPRB /)  
KB(:, 3,58, 8) = (/ &
 & 0.10268E+04_JPRB,0.77877E+03_JPRB,0.58013E+03_JPRB,0.85053E+03_JPRB,0.11222E+04_JPRB /)  
KB(:, 4,58, 8) = (/ &
 & 0.10268E+04_JPRB,0.77877E+03_JPRB,0.58052E+03_JPRB,0.85080E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 5,58, 8) = (/ &
 & 0.10268E+04_JPRB,0.77879E+03_JPRB,0.58071E+03_JPRB,0.85085E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 1,59, 8) = (/ &
 & 0.10268E+04_JPRB,0.77878E+03_JPRB,0.57904E+03_JPRB,0.84955E+03_JPRB,0.11212E+04_JPRB /)  
KB(:, 2,59, 8) = (/ &
 & 0.10268E+04_JPRB,0.77877E+03_JPRB,0.57958E+03_JPRB,0.85006E+03_JPRB,0.11217E+04_JPRB /)  
KB(:, 3,59, 8) = (/ &
 & 0.10268E+04_JPRB,0.77877E+03_JPRB,0.58007E+03_JPRB,0.85048E+03_JPRB,0.11222E+04_JPRB /)  
KB(:, 4,59, 8) = (/ &
 & 0.10268E+04_JPRB,0.77878E+03_JPRB,0.58048E+03_JPRB,0.85078E+03_JPRB,0.11225E+04_JPRB /)  
KB(:, 5,59, 8) = (/ &
 & 0.10268E+04_JPRB,0.77877E+03_JPRB,0.58070E+03_JPRB,0.85086E+03_JPRB,0.11227E+04_JPRB /)  
KB(:, 1,13, 9) = (/ &
 & 0.11533E+04_JPRB,0.87327E+03_JPRB,0.59473E+03_JPRB,0.87046E+03_JPRB,0.11487E+04_JPRB /)  
KB(:, 2,13, 9) = (/ &
 & 0.11444E+04_JPRB,0.86660E+03_JPRB,0.59240E+03_JPRB,0.87005E+03_JPRB,0.11483E+04_JPRB /)  
KB(:, 3,13, 9) = (/ &
 & 0.11367E+04_JPRB,0.86090E+03_JPRB,0.59185E+03_JPRB,0.86950E+03_JPRB,0.11478E+04_JPRB /)  
KB(:, 4,13, 9) = (/ &
 & 0.11301E+04_JPRB,0.85587E+03_JPRB,0.59143E+03_JPRB,0.86883E+03_JPRB,0.11469E+04_JPRB /)  
KB(:, 5,13, 9) = (/ &
 & 0.11242E+04_JPRB,0.85148E+03_JPRB,0.59084E+03_JPRB,0.86797E+03_JPRB,0.11458E+04_JPRB /)  
KB(:, 1,14, 9) = (/ &
 & 0.11310E+04_JPRB,0.85656E+03_JPRB,0.59238E+03_JPRB,0.87026E+03_JPRB,0.11487E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART24',1,ZHOOK_HANDLE)
END SUBROUTINE PART24


SUBROUTINE PART25

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART25',0,ZHOOK_HANDLE)


KB(:, 2,14, 9) = (/ &
 & 0.11238E+04_JPRB,0.85118E+03_JPRB,0.59190E+03_JPRB,0.86988E+03_JPRB,0.11483E+04_JPRB /)  
KB(:, 3,14, 9) = (/ &
 & 0.11176E+04_JPRB,0.84654E+03_JPRB,0.59149E+03_JPRB,0.86931E+03_JPRB,0.11477E+04_JPRB /)  
KB(:, 4,14, 9) = (/ &
 & 0.11122E+04_JPRB,0.84248E+03_JPRB,0.59105E+03_JPRB,0.86863E+03_JPRB,0.11468E+04_JPRB /)  
KB(:, 5,14, 9) = (/ &
 & 0.11074E+04_JPRB,0.83890E+03_JPRB,0.59046E+03_JPRB,0.86777E+03_JPRB,0.11457E+04_JPRB /)  
KB(:, 1,15, 9) = (/ &
 & 0.11128E+04_JPRB,0.84292E+03_JPRB,0.59202E+03_JPRB,0.87009E+03_JPRB,0.11486E+04_JPRB /)  
KB(:, 2,15, 9) = (/ &
 & 0.11070E+04_JPRB,0.83857E+03_JPRB,0.59157E+03_JPRB,0.86969E+03_JPRB,0.11482E+04_JPRB /)  
KB(:, 3,15, 9) = (/ &
 & 0.11020E+04_JPRB,0.83480E+03_JPRB,0.59118E+03_JPRB,0.86913E+03_JPRB,0.11476E+04_JPRB /)  
KB(:, 4,15, 9) = (/ &
 & 0.10976E+04_JPRB,0.83151E+03_JPRB,0.59076E+03_JPRB,0.86843E+03_JPRB,0.11467E+04_JPRB /)  
KB(:, 5,15, 9) = (/ &
 & 0.10938E+04_JPRB,0.82865E+03_JPRB,0.59015E+03_JPRB,0.86756E+03_JPRB,0.11457E+04_JPRB /)  
KB(:, 1,16, 9) = (/ &
 & 0.10980E+04_JPRB,0.83182E+03_JPRB,0.59172E+03_JPRB,0.86994E+03_JPRB,0.11486E+04_JPRB /)  
KB(:, 2,16, 9) = (/ &
 & 0.10933E+04_JPRB,0.82831E+03_JPRB,0.59129E+03_JPRB,0.86966E+03_JPRB,0.11482E+04_JPRB /)  
KB(:, 3,16, 9) = (/ &
 & 0.10893E+04_JPRB,0.82527E+03_JPRB,0.59092E+03_JPRB,0.86898E+03_JPRB,0.11475E+04_JPRB /)  
KB(:, 4,16, 9) = (/ &
 & 0.10858E+04_JPRB,0.82261E+03_JPRB,0.59049E+03_JPRB,0.86826E+03_JPRB,0.11466E+04_JPRB /)  
KB(:, 5,16, 9) = (/ &
 & 0.10827E+04_JPRB,0.82037E+03_JPRB,0.58989E+03_JPRB,0.86738E+03_JPRB,0.11455E+04_JPRB /)  
KB(:, 1,17, 9) = (/ &
 & 0.10860E+04_JPRB,0.82280E+03_JPRB,0.59147E+03_JPRB,0.86983E+03_JPRB,0.11485E+04_JPRB /)  
KB(:, 2,17, 9) = (/ &
 & 0.10822E+04_JPRB,0.81997E+03_JPRB,0.59107E+03_JPRB,0.86941E+03_JPRB,0.11481E+04_JPRB /)  
KB(:, 3,17, 9) = (/ &
 & 0.10790E+04_JPRB,0.81753E+03_JPRB,0.59070E+03_JPRB,0.86883E+03_JPRB,0.11474E+04_JPRB /)  
KB(:, 4,17, 9) = (/ &
 & 0.10761E+04_JPRB,0.81539E+03_JPRB,0.59027E+03_JPRB,0.86811E+03_JPRB,0.11465E+04_JPRB /)  
KB(:, 5,17, 9) = (/ &
 & 0.10736E+04_JPRB,0.81353E+03_JPRB,0.58965E+03_JPRB,0.86721E+03_JPRB,0.11454E+04_JPRB /)  
KB(:, 1,18, 9) = (/ &
 & 0.10762E+04_JPRB,0.81555E+03_JPRB,0.59126E+03_JPRB,0.86969E+03_JPRB,0.11485E+04_JPRB /)  
KB(:, 2,18, 9) = (/ &
 & 0.10732E+04_JPRB,0.81322E+03_JPRB,0.59088E+03_JPRB,0.86928E+03_JPRB,0.11481E+04_JPRB /)  
KB(:, 3,18, 9) = (/ &
 & 0.10706E+04_JPRB,0.81128E+03_JPRB,0.59052E+03_JPRB,0.86870E+03_JPRB,0.11474E+04_JPRB /)  
KB(:, 4,18, 9) = (/ &
 & 0.10683E+04_JPRB,0.80956E+03_JPRB,0.59008E+03_JPRB,0.86800E+03_JPRB,0.11464E+04_JPRB /)  
KB(:, 5,18, 9) = (/ &
 & 0.10663E+04_JPRB,0.80808E+03_JPRB,0.58945E+03_JPRB,0.86705E+03_JPRB,0.11452E+04_JPRB /)  
KB(:, 1,19, 9) = (/ &
 & 0.10684E+04_JPRB,0.80963E+03_JPRB,0.59108E+03_JPRB,0.86962E+03_JPRB,0.11485E+04_JPRB /)  
KB(:, 2,19, 9) = (/ &
 & 0.10659E+04_JPRB,0.80774E+03_JPRB,0.59072E+03_JPRB,0.86917E+03_JPRB,0.11480E+04_JPRB /)  
KB(:, 3,19, 9) = (/ &
 & 0.10638E+04_JPRB,0.80613E+03_JPRB,0.59038E+03_JPRB,0.86858E+03_JPRB,0.11473E+04_JPRB /)  
KB(:, 4,19, 9) = (/ &
 & 0.10619E+04_JPRB,0.80481E+03_JPRB,0.58991E+03_JPRB,0.86784E+03_JPRB,0.11463E+04_JPRB /)  
KB(:, 5,19, 9) = (/ &
 & 0.10603E+04_JPRB,0.80353E+03_JPRB,0.58926E+03_JPRB,0.86690E+03_JPRB,0.11451E+04_JPRB /)  
KB(:, 1,20, 9) = (/ &
 & 0.10619E+04_JPRB,0.80474E+03_JPRB,0.59092E+03_JPRB,0.86952E+03_JPRB,0.11484E+04_JPRB /)  
KB(:, 2,20, 9) = (/ &
 & 0.10599E+04_JPRB,0.80326E+03_JPRB,0.59057E+03_JPRB,0.86907E+03_JPRB,0.11479E+04_JPRB /)  
KB(:, 3,20, 9) = (/ &
 & 0.10582E+04_JPRB,0.80198E+03_JPRB,0.59022E+03_JPRB,0.86845E+03_JPRB,0.11472E+04_JPRB /)  
KB(:, 4,20, 9) = (/ &
 & 0.10567E+04_JPRB,0.80089E+03_JPRB,0.58976E+03_JPRB,0.86771E+03_JPRB,0.11462E+04_JPRB /)  
KB(:, 5,20, 9) = (/ &
 & 0.10554E+04_JPRB,0.79986E+03_JPRB,0.58910E+03_JPRB,0.86674E+03_JPRB,0.11449E+04_JPRB /)  
KB(:, 1,21, 9) = (/ &
 & 0.10567E+04_JPRB,0.80080E+03_JPRB,0.59079E+03_JPRB,0.86945E+03_JPRB,0.11483E+04_JPRB /)  
KB(:, 2,21, 9) = (/ &
 & 0.10550E+04_JPRB,0.79960E+03_JPRB,0.59045E+03_JPRB,0.86897E+03_JPRB,0.11478E+04_JPRB /)  
KB(:, 3,21, 9) = (/ &
 & 0.10537E+04_JPRB,0.79858E+03_JPRB,0.59010E+03_JPRB,0.86836E+03_JPRB,0.11471E+04_JPRB /)  
KB(:, 4,21, 9) = (/ &
 & 0.10525E+04_JPRB,0.79770E+03_JPRB,0.58962E+03_JPRB,0.86752E+03_JPRB,0.11460E+04_JPRB /)  
KB(:, 5,21, 9) = (/ &
 & 0.10514E+04_JPRB,0.79685E+03_JPRB,0.58893E+03_JPRB,0.86654E+03_JPRB,0.11447E+04_JPRB /)  
KB(:, 1,22, 9) = (/ &
 & 0.10523E+04_JPRB,0.79754E+03_JPRB,0.59066E+03_JPRB,0.86933E+03_JPRB,0.11483E+04_JPRB /)  
KB(:, 2,22, 9) = (/ &
 & 0.10510E+04_JPRB,0.79661E+03_JPRB,0.59033E+03_JPRB,0.86884E+03_JPRB,0.11477E+04_JPRB /)  
KB(:, 3,22, 9) = (/ &
 & 0.10500E+04_JPRB,0.79577E+03_JPRB,0.58997E+03_JPRB,0.86819E+03_JPRB,0.11469E+04_JPRB /)  
KB(:, 4,22, 9) = (/ &
 & 0.10490E+04_JPRB,0.79506E+03_JPRB,0.58945E+03_JPRB,0.86737E+03_JPRB,0.11458E+04_JPRB /)  
KB(:, 5,22, 9) = (/ &
 & 0.10482E+04_JPRB,0.79443E+03_JPRB,0.58872E+03_JPRB,0.86635E+03_JPRB,0.11444E+04_JPRB /)  
KB(:, 1,23, 9) = (/ &
 & 0.10488E+04_JPRB,0.79491E+03_JPRB,0.59053E+03_JPRB,0.86922E+03_JPRB,0.11482E+04_JPRB /)  
KB(:, 2,23, 9) = (/ &
 & 0.10478E+04_JPRB,0.79417E+03_JPRB,0.59023E+03_JPRB,0.86872E+03_JPRB,0.11476E+04_JPRB /)  
KB(:, 3,23, 9) = (/ &
 & 0.10469E+04_JPRB,0.79351E+03_JPRB,0.58983E+03_JPRB,0.86802E+03_JPRB,0.11467E+04_JPRB /)  
KB(:, 4,23, 9) = (/ &
 & 0.10461E+04_JPRB,0.79293E+03_JPRB,0.58929E+03_JPRB,0.86717E+03_JPRB,0.11456E+04_JPRB /)  
KB(:, 5,23, 9) = (/ &
 & 0.10455E+04_JPRB,0.79241E+03_JPRB,0.58851E+03_JPRB,0.86610E+03_JPRB,0.11442E+04_JPRB /)  
KB(:, 1,24, 9) = (/ &
 & 0.10460E+04_JPRB,0.79285E+03_JPRB,0.59042E+03_JPRB,0.86910E+03_JPRB,0.11481E+04_JPRB /)  
KB(:, 2,24, 9) = (/ &
 & 0.10452E+04_JPRB,0.79220E+03_JPRB,0.59009E+03_JPRB,0.86856E+03_JPRB,0.11474E+04_JPRB /)  
KB(:, 3,24, 9) = (/ &
 & 0.10445E+04_JPRB,0.79170E+03_JPRB,0.58968E+03_JPRB,0.86785E+03_JPRB,0.11465E+04_JPRB /)  
KB(:, 4,24, 9) = (/ &
 & 0.10439E+04_JPRB,0.79123E+03_JPRB,0.58911E+03_JPRB,0.86698E+03_JPRB,0.11453E+04_JPRB /)  
KB(:, 5,24, 9) = (/ &
 & 0.10433E+04_JPRB,0.79086E+03_JPRB,0.58830E+03_JPRB,0.86584E+03_JPRB,0.11439E+04_JPRB /)  
KB(:, 1,25, 9) = (/ &
 & 0.10438E+04_JPRB,0.79109E+03_JPRB,0.59032E+03_JPRB,0.86899E+03_JPRB,0.11480E+04_JPRB /)  
KB(:, 2,25, 9) = (/ &
 & 0.10430E+04_JPRB,0.79059E+03_JPRB,0.58999E+03_JPRB,0.86841E+03_JPRB,0.11473E+04_JPRB /)  
KB(:, 3,25, 9) = (/ &
 & 0.10425E+04_JPRB,0.79018E+03_JPRB,0.58955E+03_JPRB,0.86768E+03_JPRB,0.11463E+04_JPRB /)  
KB(:, 4,25, 9) = (/ &
 & 0.10420E+04_JPRB,0.78985E+03_JPRB,0.58893E+03_JPRB,0.86674E+03_JPRB,0.11450E+04_JPRB /)  
KB(:, 5,25, 9) = (/ &
 & 0.10416E+04_JPRB,0.78947E+03_JPRB,0.58810E+03_JPRB,0.86557E+03_JPRB,0.11436E+04_JPRB /)  
KB(:, 1,26, 9) = (/ &
 & 0.10418E+04_JPRB,0.78966E+03_JPRB,0.59022E+03_JPRB,0.86886E+03_JPRB,0.11478E+04_JPRB /)  
KB(:, 2,26, 9) = (/ &
 & 0.10414E+04_JPRB,0.78932E+03_JPRB,0.58989E+03_JPRB,0.86824E+03_JPRB,0.11471E+04_JPRB /)  
KB(:, 3,26, 9) = (/ &
 & 0.10409E+04_JPRB,0.78898E+03_JPRB,0.58940E+03_JPRB,0.86743E+03_JPRB,0.11460E+04_JPRB /)  
KB(:, 4,26, 9) = (/ &
 & 0.10405E+04_JPRB,0.78870E+03_JPRB,0.58873E+03_JPRB,0.86647E+03_JPRB,0.11447E+04_JPRB /)  
KB(:, 5,26, 9) = (/ &
 & 0.10401E+04_JPRB,0.78842E+03_JPRB,0.58782E+03_JPRB,0.86527E+03_JPRB,0.11432E+04_JPRB /)  
KB(:, 1,27, 9) = (/ &
 & 0.10403E+04_JPRB,0.78855E+03_JPRB,0.59012E+03_JPRB,0.86872E+03_JPRB,0.11477E+04_JPRB /)  
KB(:, 2,27, 9) = (/ &
 & 0.10399E+04_JPRB,0.78827E+03_JPRB,0.58977E+03_JPRB,0.86806E+03_JPRB,0.11468E+04_JPRB /)  
KB(:, 3,27, 9) = (/ &
 & 0.10396E+04_JPRB,0.78799E+03_JPRB,0.58924E+03_JPRB,0.86723E+03_JPRB,0.11458E+04_JPRB /)  
KB(:, 4,27, 9) = (/ &
 & 0.10392E+04_JPRB,0.78776E+03_JPRB,0.58850E+03_JPRB,0.86619E+03_JPRB,0.11444E+04_JPRB /)  
KB(:, 5,27, 9) = (/ &
 & 0.10390E+04_JPRB,0.78757E+03_JPRB,0.58756E+03_JPRB,0.86495E+03_JPRB,0.11428E+04_JPRB /)  
KB(:, 1,28, 9) = (/ &
 & 0.10391E+04_JPRB,0.78770E+03_JPRB,0.59002E+03_JPRB,0.86856E+03_JPRB,0.11475E+04_JPRB /)  
KB(:, 2,28, 9) = (/ &
 & 0.10388E+04_JPRB,0.78747E+03_JPRB,0.58964E+03_JPRB,0.86790E+03_JPRB,0.11466E+04_JPRB /)  
KB(:, 3,28, 9) = (/ &
 & 0.10385E+04_JPRB,0.78719E+03_JPRB,0.58908E+03_JPRB,0.86701E+03_JPRB,0.11455E+04_JPRB /)  
KB(:, 4,28, 9) = (/ &
 & 0.10383E+04_JPRB,0.78704E+03_JPRB,0.58829E+03_JPRB,0.86590E+03_JPRB,0.11440E+04_JPRB /)  
KB(:, 5,28, 9) = (/ &
 & 0.10381E+04_JPRB,0.78687E+03_JPRB,0.58729E+03_JPRB,0.86461E+03_JPRB,0.11423E+04_JPRB /)  
KB(:, 1,29, 9) = (/ &
 & 0.10382E+04_JPRB,0.78694E+03_JPRB,0.58994E+03_JPRB,0.86841E+03_JPRB,0.11473E+04_JPRB /)  
KB(:, 2,29, 9) = (/ &
 & 0.10379E+04_JPRB,0.78677E+03_JPRB,0.58950E+03_JPRB,0.86767E+03_JPRB,0.11463E+04_JPRB /)  
KB(:, 3,29, 9) = (/ &
 & 0.10377E+04_JPRB,0.78658E+03_JPRB,0.58888E+03_JPRB,0.86674E+03_JPRB,0.11451E+04_JPRB /)  
KB(:, 4,29, 9) = (/ &
 & 0.10375E+04_JPRB,0.78645E+03_JPRB,0.58805E+03_JPRB,0.86559E+03_JPRB,0.11436E+04_JPRB /)  
KB(:, 5,29, 9) = (/ &
 & 0.10374E+04_JPRB,0.78628E+03_JPRB,0.58702E+03_JPRB,0.86429E+03_JPRB,0.11419E+04_JPRB /)  
KB(:, 1,30, 9) = (/ &
 & 0.10373E+04_JPRB,0.78632E+03_JPRB,0.58983E+03_JPRB,0.86822E+03_JPRB,0.11471E+04_JPRB /)  
KB(:, 2,30, 9) = (/ &
 & 0.10371E+04_JPRB,0.78619E+03_JPRB,0.58935E+03_JPRB,0.86746E+03_JPRB,0.11460E+04_JPRB /)  
KB(:, 3,30, 9) = (/ &
 & 0.10370E+04_JPRB,0.78613E+03_JPRB,0.58869E+03_JPRB,0.86647E+03_JPRB,0.11448E+04_JPRB /)  
KB(:, 4,30, 9) = (/ &
 & 0.10369E+04_JPRB,0.78594E+03_JPRB,0.58779E+03_JPRB,0.86529E+03_JPRB,0.11432E+04_JPRB /)  
KB(:, 5,30, 9) = (/ &
 & 0.10367E+04_JPRB,0.78585E+03_JPRB,0.58673E+03_JPRB,0.86393E+03_JPRB,0.11414E+04_JPRB /)  
KB(:, 1,31, 9) = (/ &
 & 0.10367E+04_JPRB,0.78588E+03_JPRB,0.58971E+03_JPRB,0.86804E+03_JPRB,0.11468E+04_JPRB /)  
KB(:, 2,31, 9) = (/ &
 & 0.10365E+04_JPRB,0.78574E+03_JPRB,0.58919E+03_JPRB,0.86720E+03_JPRB,0.11457E+04_JPRB /)  
KB(:, 3,31, 9) = (/ &
 & 0.10364E+04_JPRB,0.78562E+03_JPRB,0.58847E+03_JPRB,0.86618E+03_JPRB,0.11443E+04_JPRB /)  
KB(:, 4,31, 9) = (/ &
 & 0.10363E+04_JPRB,0.78557E+03_JPRB,0.58752E+03_JPRB,0.86495E+03_JPRB,0.11427E+04_JPRB /)  
KB(:, 5,31, 9) = (/ &
 & 0.10362E+04_JPRB,0.78546E+03_JPRB,0.58644E+03_JPRB,0.86356E+03_JPRB,0.11409E+04_JPRB /)  
KB(:, 1,32, 9) = (/ &
 & 0.10362E+04_JPRB,0.78556E+03_JPRB,0.58958E+03_JPRB,0.86784E+03_JPRB,0.11466E+04_JPRB /)  
KB(:, 2,32, 9) = (/ &
 & 0.10361E+04_JPRB,0.78539E+03_JPRB,0.58901E+03_JPRB,0.86697E+03_JPRB,0.11454E+04_JPRB /)  
KB(:, 3,32, 9) = (/ &
 & 0.10360E+04_JPRB,0.78539E+03_JPRB,0.58824E+03_JPRB,0.86587E+03_JPRB,0.11440E+04_JPRB /)  
KB(:, 4,32, 9) = (/ &
 & 0.10359E+04_JPRB,0.78525E+03_JPRB,0.58724E+03_JPRB,0.86459E+03_JPRB,0.11423E+04_JPRB /)  
KB(:, 5,32, 9) = (/ &
 & 0.10358E+04_JPRB,0.78516E+03_JPRB,0.58615E+03_JPRB,0.86318E+03_JPRB,0.11404E+04_JPRB /)  
KB(:, 1,33, 9) = (/ &
 & 0.10358E+04_JPRB,0.78520E+03_JPRB,0.58945E+03_JPRB,0.86763E+03_JPRB,0.11463E+04_JPRB /)  
KB(:, 2,33, 9) = (/ &
 & 0.10357E+04_JPRB,0.78510E+03_JPRB,0.58883E+03_JPRB,0.86670E+03_JPRB,0.11450E+04_JPRB /)  
KB(:, 3,33, 9) = (/ &
 & 0.10356E+04_JPRB,0.78504E+03_JPRB,0.58799E+03_JPRB,0.86554E+03_JPRB,0.11435E+04_JPRB /)  
KB(:, 4,33, 9) = (/ &
 & 0.10356E+04_JPRB,0.78500E+03_JPRB,0.58695E+03_JPRB,0.86422E+03_JPRB,0.11418E+04_JPRB /)  
KB(:, 5,33, 9) = (/ &
 & 0.10355E+04_JPRB,0.78493E+03_JPRB,0.58586E+03_JPRB,0.86281E+03_JPRB,0.11399E+04_JPRB /)  
KB(:, 1,34, 9) = (/ &
 & 0.10355E+04_JPRB,0.78495E+03_JPRB,0.58932E+03_JPRB,0.86743E+03_JPRB,0.11460E+04_JPRB /)  
KB(:, 2,34, 9) = (/ &
 & 0.10354E+04_JPRB,0.78487E+03_JPRB,0.58865E+03_JPRB,0.86644E+03_JPRB,0.11447E+04_JPRB /)  
KB(:, 3,34, 9) = (/ &
 & 0.10354E+04_JPRB,0.78485E+03_JPRB,0.58776E+03_JPRB,0.86524E+03_JPRB,0.11432E+04_JPRB /)  
KB(:, 4,34, 9) = (/ &
 & 0.10353E+04_JPRB,0.78479E+03_JPRB,0.58670E+03_JPRB,0.86390E+03_JPRB,0.11414E+04_JPRB /)  
KB(:, 5,34, 9) = (/ &
 & 0.10352E+04_JPRB,0.78474E+03_JPRB,0.58560E+03_JPRB,0.86249E+03_JPRB,0.11395E+04_JPRB /)  
KB(:, 1,35, 9) = (/ &
 & 0.10352E+04_JPRB,0.78478E+03_JPRB,0.58924E+03_JPRB,0.86731E+03_JPRB,0.11459E+04_JPRB /)  
KB(:, 2,35, 9) = (/ &
 & 0.10352E+04_JPRB,0.78472E+03_JPRB,0.58855E+03_JPRB,0.86632E+03_JPRB,0.11445E+04_JPRB /)  
KB(:, 3,35, 9) = (/ &
 & 0.10351E+04_JPRB,0.78465E+03_JPRB,0.58761E+03_JPRB,0.86508E+03_JPRB,0.11430E+04_JPRB /)  
KB(:, 4,35, 9) = (/ &
 & 0.10350E+04_JPRB,0.78465E+03_JPRB,0.58655E+03_JPRB,0.86369E+03_JPRB,0.11412E+04_JPRB /)  
KB(:, 5,35, 9) = (/ &
 & 0.10350E+04_JPRB,0.78456E+03_JPRB,0.58545E+03_JPRB,0.86237E+03_JPRB,0.11393E+04_JPRB /)  
KB(:, 1,36, 9) = (/ &
 & 0.10350E+04_JPRB,0.78465E+03_JPRB,0.58922E+03_JPRB,0.86729E+03_JPRB,0.11458E+04_JPRB /)  
KB(:, 2,36, 9) = (/ &
 & 0.10350E+04_JPRB,0.78456E+03_JPRB,0.58852E+03_JPRB,0.86627E+03_JPRB,0.11445E+04_JPRB /)  
KB(:, 3,36, 9) = (/ &
 & 0.10350E+04_JPRB,0.78452E+03_JPRB,0.58759E+03_JPRB,0.86505E+03_JPRB,0.11429E+04_JPRB /)  
KB(:, 4,36, 9) = (/ &
 & 0.10349E+04_JPRB,0.78450E+03_JPRB,0.58651E+03_JPRB,0.86369E+03_JPRB,0.11411E+04_JPRB /)  
KB(:, 5,36, 9) = (/ &
 & 0.10348E+04_JPRB,0.78444E+03_JPRB,0.58544E+03_JPRB,0.86227E+03_JPRB,0.11392E+04_JPRB /)  
KB(:, 1,37, 9) = (/ &
 & 0.10349E+04_JPRB,0.78446E+03_JPRB,0.58930E+03_JPRB,0.86738E+03_JPRB,0.11460E+04_JPRB /)  
KB(:, 2,37, 9) = (/ &
 & 0.10348E+04_JPRB,0.78444E+03_JPRB,0.58863E+03_JPRB,0.86642E+03_JPRB,0.11447E+04_JPRB /)  
KB(:, 3,37, 9) = (/ &
 & 0.10348E+04_JPRB,0.78441E+03_JPRB,0.58773E+03_JPRB,0.86522E+03_JPRB,0.11432E+04_JPRB /)  
KB(:, 4,37, 9) = (/ &
 & 0.10348E+04_JPRB,0.78439E+03_JPRB,0.58667E+03_JPRB,0.86387E+03_JPRB,0.11414E+04_JPRB /)  
KB(:, 5,37, 9) = (/ &
 & 0.10347E+04_JPRB,0.78436E+03_JPRB,0.58559E+03_JPRB,0.86245E+03_JPRB,0.11394E+04_JPRB /)  
KB(:, 1,38, 9) = (/ &
 & 0.10348E+04_JPRB,0.78440E+03_JPRB,0.58936E+03_JPRB,0.86753E+03_JPRB,0.11462E+04_JPRB /)  
KB(:, 2,38, 9) = (/ &
 & 0.10347E+04_JPRB,0.78434E+03_JPRB,0.58873E+03_JPRB,0.86658E+03_JPRB,0.11449E+04_JPRB /)  
KB(:, 3,38, 9) = (/ &
 & 0.10347E+04_JPRB,0.78432E+03_JPRB,0.58786E+03_JPRB,0.86537E+03_JPRB,0.11434E+04_JPRB /)  
KB(:, 4,38, 9) = (/ &
 & 0.10346E+04_JPRB,0.78431E+03_JPRB,0.58681E+03_JPRB,0.86407E+03_JPRB,0.11416E+04_JPRB /)  
KB(:, 5,38, 9) = (/ &
 & 0.10347E+04_JPRB,0.78428E+03_JPRB,0.58573E+03_JPRB,0.86265E+03_JPRB,0.11397E+04_JPRB /)  
KB(:, 1,39, 9) = (/ &
 & 0.10347E+04_JPRB,0.78431E+03_JPRB,0.58943E+03_JPRB,0.86764E+03_JPRB,0.11463E+04_JPRB /)  
KB(:, 2,39, 9) = (/ &
 & 0.10346E+04_JPRB,0.78431E+03_JPRB,0.58882E+03_JPRB,0.86672E+03_JPRB,0.11451E+04_JPRB /)  
KB(:, 3,39, 9) = (/ &
 & 0.10346E+04_JPRB,0.78424E+03_JPRB,0.58800E+03_JPRB,0.86557E+03_JPRB,0.11436E+04_JPRB /)  
KB(:, 4,39, 9) = (/ &
 & 0.10346E+04_JPRB,0.78421E+03_JPRB,0.58697E+03_JPRB,0.86426E+03_JPRB,0.11419E+04_JPRB /)  
KB(:, 5,39, 9) = (/ &
 & 0.10346E+04_JPRB,0.78429E+03_JPRB,0.58587E+03_JPRB,0.86284E+03_JPRB,0.11400E+04_JPRB /)  
KB(:, 1,40, 9) = (/ &
 & 0.10346E+04_JPRB,0.78426E+03_JPRB,0.58957E+03_JPRB,0.86785E+03_JPRB,0.11466E+04_JPRB /)  
KB(:, 2,40, 9) = (/ &
 & 0.10345E+04_JPRB,0.78427E+03_JPRB,0.58899E+03_JPRB,0.86697E+03_JPRB,0.11454E+04_JPRB /)  
KB(:, 3,40, 9) = (/ &
 & 0.10345E+04_JPRB,0.78422E+03_JPRB,0.58822E+03_JPRB,0.86585E+03_JPRB,0.11440E+04_JPRB /)  
KB(:, 4,40, 9) = (/ &
 & 0.10345E+04_JPRB,0.78421E+03_JPRB,0.58723E+03_JPRB,0.86460E+03_JPRB,0.11423E+04_JPRB /)  
KB(:, 5,40, 9) = (/ &
 & 0.10344E+04_JPRB,0.78416E+03_JPRB,0.58614E+03_JPRB,0.86319E+03_JPRB,0.11403E+04_JPRB /)  
KB(:, 1,41, 9) = (/ &
 & 0.10345E+04_JPRB,0.78421E+03_JPRB,0.58967E+03_JPRB,0.86804E+03_JPRB,0.11468E+04_JPRB /)  
KB(:, 2,41, 9) = (/ &
 & 0.10345E+04_JPRB,0.78418E+03_JPRB,0.58916E+03_JPRB,0.86720E+03_JPRB,0.11457E+04_JPRB /)  
KB(:, 3,41, 9) = (/ &
 & 0.10344E+04_JPRB,0.78415E+03_JPRB,0.58844E+03_JPRB,0.86618E+03_JPRB,0.11444E+04_JPRB /)  
KB(:, 4,41, 9) = (/ &
 & 0.10344E+04_JPRB,0.78413E+03_JPRB,0.58748E+03_JPRB,0.86492E+03_JPRB,0.11428E+04_JPRB /)  
KB(:, 5,41, 9) = (/ &
 & 0.10344E+04_JPRB,0.78411E+03_JPRB,0.58642E+03_JPRB,0.86355E+03_JPRB,0.11409E+04_JPRB /)  
KB(:, 1,42, 9) = (/ &
 & 0.10345E+04_JPRB,0.78414E+03_JPRB,0.58976E+03_JPRB,0.86830E+03_JPRB,0.11471E+04_JPRB /)  
KB(:, 2,42, 9) = (/ &
 & 0.10344E+04_JPRB,0.78417E+03_JPRB,0.58930E+03_JPRB,0.86744E+03_JPRB,0.11460E+04_JPRB /)  
KB(:, 3,42, 9) = (/ &
 & 0.10344E+04_JPRB,0.78411E+03_JPRB,0.58863E+03_JPRB,0.86645E+03_JPRB,0.11448E+04_JPRB /)  
KB(:, 4,42, 9) = (/ &
 & 0.10344E+04_JPRB,0.78409E+03_JPRB,0.58775E+03_JPRB,0.86525E+03_JPRB,0.11432E+04_JPRB /)  
KB(:, 5,42, 9) = (/ &
 & 0.10344E+04_JPRB,0.78408E+03_JPRB,0.58670E+03_JPRB,0.86391E+03_JPRB,0.11414E+04_JPRB /)  
KB(:, 1,43, 9) = (/ &
 & 0.10344E+04_JPRB,0.78410E+03_JPRB,0.58987E+03_JPRB,0.86842E+03_JPRB,0.11473E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART25',1,ZHOOK_HANDLE)
END SUBROUTINE PART25


SUBROUTINE PART26

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART26',0,ZHOOK_HANDLE)


KB(:, 2,43, 9) = (/ &
 & 0.10344E+04_JPRB,0.78408E+03_JPRB,0.58947E+03_JPRB,0.86769E+03_JPRB,0.11464E+04_JPRB /)  
KB(:, 3,43, 9) = (/ &
 & 0.10344E+04_JPRB,0.78409E+03_JPRB,0.58887E+03_JPRB,0.86678E+03_JPRB,0.11452E+04_JPRB /)  
KB(:, 4,43, 9) = (/ &
 & 0.10344E+04_JPRB,0.78410E+03_JPRB,0.58806E+03_JPRB,0.86567E+03_JPRB,0.11437E+04_JPRB /)  
KB(:, 5,43, 9) = (/ &
 & 0.10343E+04_JPRB,0.78406E+03_JPRB,0.58704E+03_JPRB,0.86435E+03_JPRB,0.11420E+04_JPRB /)  
KB(:, 1,44, 9) = (/ &
 & 0.10344E+04_JPRB,0.78409E+03_JPRB,0.58998E+03_JPRB,0.86862E+03_JPRB,0.11476E+04_JPRB /)  
KB(:, 2,44, 9) = (/ &
 & 0.10343E+04_JPRB,0.78407E+03_JPRB,0.58962E+03_JPRB,0.86796E+03_JPRB,0.11467E+04_JPRB /)  
KB(:, 3,44, 9) = (/ &
 & 0.10343E+04_JPRB,0.78406E+03_JPRB,0.58910E+03_JPRB,0.86711E+03_JPRB,0.11456E+04_JPRB /)  
KB(:, 4,44, 9) = (/ &
 & 0.10343E+04_JPRB,0.78403E+03_JPRB,0.58835E+03_JPRB,0.86607E+03_JPRB,0.11442E+04_JPRB /)  
KB(:, 5,44, 9) = (/ &
 & 0.10343E+04_JPRB,0.78403E+03_JPRB,0.58738E+03_JPRB,0.86483E+03_JPRB,0.11426E+04_JPRB /)  
KB(:, 1,45, 9) = (/ &
 & 0.10343E+04_JPRB,0.78404E+03_JPRB,0.59009E+03_JPRB,0.86881E+03_JPRB,0.11478E+04_JPRB /)  
KB(:, 2,45, 9) = (/ &
 & 0.10343E+04_JPRB,0.78405E+03_JPRB,0.58975E+03_JPRB,0.86821E+03_JPRB,0.11471E+04_JPRB /)  
KB(:, 3,45, 9) = (/ &
 & 0.10343E+04_JPRB,0.78404E+03_JPRB,0.58930E+03_JPRB,0.86741E+03_JPRB,0.11460E+04_JPRB /)  
KB(:, 4,45, 9) = (/ &
 & 0.10342E+04_JPRB,0.78400E+03_JPRB,0.58862E+03_JPRB,0.86644E+03_JPRB,0.11447E+04_JPRB /)  
KB(:, 5,45, 9) = (/ &
 & 0.10343E+04_JPRB,0.78402E+03_JPRB,0.58769E+03_JPRB,0.86520E+03_JPRB,0.11432E+04_JPRB /)  
KB(:, 1,46, 9) = (/ &
 & 0.10343E+04_JPRB,0.78403E+03_JPRB,0.59019E+03_JPRB,0.86899E+03_JPRB,0.11481E+04_JPRB /)  
KB(:, 2,46, 9) = (/ &
 & 0.10343E+04_JPRB,0.78403E+03_JPRB,0.58989E+03_JPRB,0.86845E+03_JPRB,0.11474E+04_JPRB /)  
KB(:, 3,46, 9) = (/ &
 & 0.10343E+04_JPRB,0.78403E+03_JPRB,0.58947E+03_JPRB,0.86773E+03_JPRB,0.11464E+04_JPRB /)  
KB(:, 4,46, 9) = (/ &
 & 0.10342E+04_JPRB,0.78401E+03_JPRB,0.58890E+03_JPRB,0.86681E+03_JPRB,0.11452E+04_JPRB /)  
KB(:, 5,46, 9) = (/ &
 & 0.10343E+04_JPRB,0.78405E+03_JPRB,0.58808E+03_JPRB,0.86568E+03_JPRB,0.11438E+04_JPRB /)  
KB(:, 1,47, 9) = (/ &
 & 0.10343E+04_JPRB,0.78401E+03_JPRB,0.59032E+03_JPRB,0.86917E+03_JPRB,0.11483E+04_JPRB /)  
KB(:, 2,47, 9) = (/ &
 & 0.10342E+04_JPRB,0.78398E+03_JPRB,0.59001E+03_JPRB,0.86868E+03_JPRB,0.11477E+04_JPRB /)  
KB(:, 3,47, 9) = (/ &
 & 0.10342E+04_JPRB,0.78398E+03_JPRB,0.58967E+03_JPRB,0.86807E+03_JPRB,0.11468E+04_JPRB /)  
KB(:, 4,47, 9) = (/ &
 & 0.10343E+04_JPRB,0.78397E+03_JPRB,0.58916E+03_JPRB,0.86720E+03_JPRB,0.11457E+04_JPRB /)  
KB(:, 5,47, 9) = (/ &
 & 0.10342E+04_JPRB,0.78399E+03_JPRB,0.58844E+03_JPRB,0.86618E+03_JPRB,0.11444E+04_JPRB /)  
KB(:, 1,48, 9) = (/ &
 & 0.10342E+04_JPRB,0.78399E+03_JPRB,0.59046E+03_JPRB,0.86932E+03_JPRB,0.11485E+04_JPRB /)  
KB(:, 2,48, 9) = (/ &
 & 0.10343E+04_JPRB,0.78398E+03_JPRB,0.59013E+03_JPRB,0.86890E+03_JPRB,0.11480E+04_JPRB /)  
KB(:, 3,48, 9) = (/ &
 & 0.10342E+04_JPRB,0.78402E+03_JPRB,0.58982E+03_JPRB,0.86829E+03_JPRB,0.11472E+04_JPRB /)  
KB(:, 4,48, 9) = (/ &
 & 0.10342E+04_JPRB,0.78396E+03_JPRB,0.58938E+03_JPRB,0.86756E+03_JPRB,0.11462E+04_JPRB /)  
KB(:, 5,48, 9) = (/ &
 & 0.10342E+04_JPRB,0.78400E+03_JPRB,0.58875E+03_JPRB,0.86661E+03_JPRB,0.11449E+04_JPRB /)  
KB(:, 1,49, 9) = (/ &
 & 0.10343E+04_JPRB,0.78402E+03_JPRB,0.59060E+03_JPRB,0.86945E+03_JPRB,0.11486E+04_JPRB /)  
KB(:, 2,49, 9) = (/ &
 & 0.10342E+04_JPRB,0.78398E+03_JPRB,0.59025E+03_JPRB,0.86908E+03_JPRB,0.11482E+04_JPRB /)  
KB(:, 3,49, 9) = (/ &
 & 0.10342E+04_JPRB,0.78399E+03_JPRB,0.58995E+03_JPRB,0.86856E+03_JPRB,0.11475E+04_JPRB /)  
KB(:, 4,49, 9) = (/ &
 & 0.10342E+04_JPRB,0.78399E+03_JPRB,0.58958E+03_JPRB,0.86790E+03_JPRB,0.11466E+04_JPRB /)  
KB(:, 5,49, 9) = (/ &
 & 0.10342E+04_JPRB,0.78398E+03_JPRB,0.58903E+03_JPRB,0.86700E+03_JPRB,0.11455E+04_JPRB /)  
KB(:, 1,50, 9) = (/ &
 & 0.10343E+04_JPRB,0.78395E+03_JPRB,0.59074E+03_JPRB,0.86956E+03_JPRB,0.11487E+04_JPRB /)  
KB(:, 2,50, 9) = (/ &
 & 0.10342E+04_JPRB,0.78399E+03_JPRB,0.59038E+03_JPRB,0.86924E+03_JPRB,0.11483E+04_JPRB /)  
KB(:, 3,50, 9) = (/ &
 & 0.10342E+04_JPRB,0.78394E+03_JPRB,0.59006E+03_JPRB,0.86878E+03_JPRB,0.11478E+04_JPRB /)  
KB(:, 4,50, 9) = (/ &
 & 0.10342E+04_JPRB,0.78399E+03_JPRB,0.58974E+03_JPRB,0.86817E+03_JPRB,0.11470E+04_JPRB /)  
KB(:, 5,50, 9) = (/ &
 & 0.10342E+04_JPRB,0.78395E+03_JPRB,0.58927E+03_JPRB,0.86736E+03_JPRB,0.11460E+04_JPRB /)  
KB(:, 1,51, 9) = (/ &
 & 0.10342E+04_JPRB,0.78399E+03_JPRB,0.59088E+03_JPRB,0.86965E+03_JPRB,0.11488E+04_JPRB /)  
KB(:, 2,51, 9) = (/ &
 & 0.10342E+04_JPRB,0.78393E+03_JPRB,0.59051E+03_JPRB,0.86937E+03_JPRB,0.11485E+04_JPRB /)  
KB(:, 3,51, 9) = (/ &
 & 0.10342E+04_JPRB,0.78400E+03_JPRB,0.59018E+03_JPRB,0.86897E+03_JPRB,0.11480E+04_JPRB /)  
KB(:, 4,51, 9) = (/ &
 & 0.10342E+04_JPRB,0.78396E+03_JPRB,0.58987E+03_JPRB,0.86840E+03_JPRB,0.11473E+04_JPRB /)  
KB(:, 5,51, 9) = (/ &
 & 0.10342E+04_JPRB,0.78396E+03_JPRB,0.58946E+03_JPRB,0.86768E+03_JPRB,0.11464E+04_JPRB /)  
KB(:, 1,52, 9) = (/ &
 & 0.10342E+04_JPRB,0.78395E+03_JPRB,0.59100E+03_JPRB,0.86971E+03_JPRB,0.11490E+04_JPRB /)  
KB(:, 2,52, 9) = (/ &
 & 0.10342E+04_JPRB,0.78394E+03_JPRB,0.59064E+03_JPRB,0.86949E+03_JPRB,0.11486E+04_JPRB /)  
KB(:, 3,52, 9) = (/ &
 & 0.10342E+04_JPRB,0.78395E+03_JPRB,0.59029E+03_JPRB,0.86915E+03_JPRB,0.11482E+04_JPRB /)  
KB(:, 4,52, 9) = (/ &
 & 0.10342E+04_JPRB,0.78394E+03_JPRB,0.58998E+03_JPRB,0.86864E+03_JPRB,0.11476E+04_JPRB /)  
KB(:, 5,52, 9) = (/ &
 & 0.10342E+04_JPRB,0.78395E+03_JPRB,0.58963E+03_JPRB,0.86796E+03_JPRB,0.11468E+04_JPRB /)  
KB(:, 1,53, 9) = (/ &
 & 0.10342E+04_JPRB,0.78397E+03_JPRB,0.59111E+03_JPRB,0.86975E+03_JPRB,0.11490E+04_JPRB /)  
KB(:, 2,53, 9) = (/ &
 & 0.10342E+04_JPRB,0.78394E+03_JPRB,0.59078E+03_JPRB,0.86960E+03_JPRB,0.11488E+04_JPRB /)  
KB(:, 3,53, 9) = (/ &
 & 0.10342E+04_JPRB,0.78396E+03_JPRB,0.59041E+03_JPRB,0.86926E+03_JPRB,0.11484E+04_JPRB /)  
KB(:, 4,53, 9) = (/ &
 & 0.10341E+04_JPRB,0.78393E+03_JPRB,0.59010E+03_JPRB,0.86884E+03_JPRB,0.11479E+04_JPRB /)  
KB(:, 5,53, 9) = (/ &
 & 0.10342E+04_JPRB,0.78395E+03_JPRB,0.58977E+03_JPRB,0.86822E+03_JPRB,0.11471E+04_JPRB /)  
KB(:, 1,54, 9) = (/ &
 & 0.10343E+04_JPRB,0.78394E+03_JPRB,0.59121E+03_JPRB,0.86979E+03_JPRB,0.11491E+04_JPRB /)  
KB(:, 2,54, 9) = (/ &
 & 0.10341E+04_JPRB,0.78399E+03_JPRB,0.59088E+03_JPRB,0.86966E+03_JPRB,0.11489E+04_JPRB /)  
KB(:, 3,54, 9) = (/ &
 & 0.10341E+04_JPRB,0.78394E+03_JPRB,0.59052E+03_JPRB,0.86939E+03_JPRB,0.11485E+04_JPRB /)  
KB(:, 4,54, 9) = (/ &
 & 0.10341E+04_JPRB,0.78394E+03_JPRB,0.59020E+03_JPRB,0.86900E+03_JPRB,0.11481E+04_JPRB /)  
KB(:, 5,54, 9) = (/ &
 & 0.10342E+04_JPRB,0.78395E+03_JPRB,0.58987E+03_JPRB,0.86845E+03_JPRB,0.11474E+04_JPRB /)  
KB(:, 1,55, 9) = (/ &
 & 0.10342E+04_JPRB,0.78396E+03_JPRB,0.59130E+03_JPRB,0.86983E+03_JPRB,0.11491E+04_JPRB /)  
KB(:, 2,55, 9) = (/ &
 & 0.10341E+04_JPRB,0.78393E+03_JPRB,0.59100E+03_JPRB,0.86971E+03_JPRB,0.11490E+04_JPRB /)  
KB(:, 3,55, 9) = (/ &
 & 0.10342E+04_JPRB,0.78393E+03_JPRB,0.59065E+03_JPRB,0.86949E+03_JPRB,0.11486E+04_JPRB /)  
KB(:, 4,55, 9) = (/ &
 & 0.10342E+04_JPRB,0.78395E+03_JPRB,0.59029E+03_JPRB,0.86914E+03_JPRB,0.11483E+04_JPRB /)  
KB(:, 5,55, 9) = (/ &
 & 0.10341E+04_JPRB,0.78393E+03_JPRB,0.59000E+03_JPRB,0.86864E+03_JPRB,0.11477E+04_JPRB /)  
KB(:, 1,56, 9) = (/ &
 & 0.10342E+04_JPRB,0.78393E+03_JPRB,0.59137E+03_JPRB,0.86987E+03_JPRB,0.11492E+04_JPRB /)  
KB(:, 2,56, 9) = (/ &
 & 0.10342E+04_JPRB,0.78395E+03_JPRB,0.59111E+03_JPRB,0.86975E+03_JPRB,0.11490E+04_JPRB /)  
KB(:, 3,56, 9) = (/ &
 & 0.10342E+04_JPRB,0.78392E+03_JPRB,0.59077E+03_JPRB,0.86958E+03_JPRB,0.11488E+04_JPRB /)  
KB(:, 4,56, 9) = (/ &
 & 0.10342E+04_JPRB,0.78393E+03_JPRB,0.59040E+03_JPRB,0.86926E+03_JPRB,0.11484E+04_JPRB /)  
KB(:, 5,56, 9) = (/ &
 & 0.10341E+04_JPRB,0.78393E+03_JPRB,0.59009E+03_JPRB,0.86883E+03_JPRB,0.11479E+04_JPRB /)  
KB(:, 1,57, 9) = (/ &
 & 0.10342E+04_JPRB,0.78396E+03_JPRB,0.59143E+03_JPRB,0.86993E+03_JPRB,0.11492E+04_JPRB /)  
KB(:, 2,57, 9) = (/ &
 & 0.10342E+04_JPRB,0.78392E+03_JPRB,0.59122E+03_JPRB,0.86979E+03_JPRB,0.11491E+04_JPRB /)  
KB(:, 3,57, 9) = (/ &
 & 0.10342E+04_JPRB,0.78392E+03_JPRB,0.59089E+03_JPRB,0.86966E+03_JPRB,0.11489E+04_JPRB /)  
KB(:, 4,57, 9) = (/ &
 & 0.10341E+04_JPRB,0.78395E+03_JPRB,0.59052E+03_JPRB,0.86938E+03_JPRB,0.11485E+04_JPRB /)  
KB(:, 5,57, 9) = (/ &
 & 0.10341E+04_JPRB,0.78393E+03_JPRB,0.59018E+03_JPRB,0.86897E+03_JPRB,0.11481E+04_JPRB /)  
KB(:, 1,58, 9) = (/ &
 & 0.10341E+04_JPRB,0.78395E+03_JPRB,0.59147E+03_JPRB,0.86996E+03_JPRB,0.11493E+04_JPRB /)  
KB(:, 2,58, 9) = (/ &
 & 0.10341E+04_JPRB,0.78397E+03_JPRB,0.59129E+03_JPRB,0.86982E+03_JPRB,0.11491E+04_JPRB /)  
KB(:, 3,58, 9) = (/ &
 & 0.10341E+04_JPRB,0.78393E+03_JPRB,0.59099E+03_JPRB,0.86970E+03_JPRB,0.11489E+04_JPRB /)  
KB(:, 4,58, 9) = (/ &
 & 0.10342E+04_JPRB,0.78397E+03_JPRB,0.59063E+03_JPRB,0.86948E+03_JPRB,0.11486E+04_JPRB /)  
KB(:, 5,58, 9) = (/ &
 & 0.10342E+04_JPRB,0.78390E+03_JPRB,0.59028E+03_JPRB,0.86913E+03_JPRB,0.11482E+04_JPRB /)  
KB(:, 1,59, 9) = (/ &
 & 0.10342E+04_JPRB,0.78393E+03_JPRB,0.59148E+03_JPRB,0.86998E+03_JPRB,0.11494E+04_JPRB /)  
KB(:, 2,59, 9) = (/ &
 & 0.10342E+04_JPRB,0.78396E+03_JPRB,0.59132E+03_JPRB,0.86982E+03_JPRB,0.11492E+04_JPRB /)  
KB(:, 3,59, 9) = (/ &
 & 0.10342E+04_JPRB,0.78393E+03_JPRB,0.59103E+03_JPRB,0.86972E+03_JPRB,0.11490E+04_JPRB /)  
KB(:, 4,59, 9) = (/ &
 & 0.10341E+04_JPRB,0.78394E+03_JPRB,0.59067E+03_JPRB,0.86951E+03_JPRB,0.11487E+04_JPRB /)  
KB(:, 5,59, 9) = (/ &
 & 0.10341E+04_JPRB,0.78397E+03_JPRB,0.59032E+03_JPRB,0.86918E+03_JPRB,0.11483E+04_JPRB /)  
KB(:, 1,13,10) = (/ &
 & 0.11544E+04_JPRB,0.87486E+03_JPRB,0.59975E+03_JPRB,0.88029E+03_JPRB,0.11631E+04_JPRB /)  
KB(:, 2,13,10) = (/ &
 & 0.11458E+04_JPRB,0.86752E+03_JPRB,0.59921E+03_JPRB,0.87889E+03_JPRB,0.11611E+04_JPRB /)  
KB(:, 3,13,10) = (/ &
 & 0.11380E+04_JPRB,0.86177E+03_JPRB,0.59836E+03_JPRB,0.87789E+03_JPRB,0.11592E+04_JPRB /)  
KB(:, 4,13,10) = (/ &
 & 0.11310E+04_JPRB,0.85697E+03_JPRB,0.59745E+03_JPRB,0.87697E+03_JPRB,0.11577E+04_JPRB /)  
KB(:, 5,13,10) = (/ &
 & 0.11259E+04_JPRB,0.85279E+03_JPRB,0.59663E+03_JPRB,0.87606E+03_JPRB,0.11564E+04_JPRB /)  
KB(:, 1,14,10) = (/ &
 & 0.11329E+04_JPRB,0.85757E+03_JPRB,0.59935E+03_JPRB,0.88000E+03_JPRB,0.11630E+04_JPRB /)  
KB(:, 2,14,10) = (/ &
 & 0.11257E+04_JPRB,0.85228E+03_JPRB,0.59878E+03_JPRB,0.87841E+03_JPRB,0.11609E+04_JPRB /)  
KB(:, 3,14,10) = (/ &
 & 0.11201E+04_JPRB,0.84731E+03_JPRB,0.59797E+03_JPRB,0.87766E+03_JPRB,0.11591E+04_JPRB /)  
KB(:, 4,14,10) = (/ &
 & 0.11140E+04_JPRB,0.84389E+03_JPRB,0.59731E+03_JPRB,0.87707E+03_JPRB,0.11577E+04_JPRB /)  
KB(:, 5,14,10) = (/ &
 & 0.11094E+04_JPRB,0.84001E+03_JPRB,0.59642E+03_JPRB,0.87571E+03_JPRB,0.11561E+04_JPRB /)  
KB(:, 1,15,10) = (/ &
 & 0.11142E+04_JPRB,0.84370E+03_JPRB,0.59900E+03_JPRB,0.87973E+03_JPRB,0.11627E+04_JPRB /)  
KB(:, 2,15,10) = (/ &
 & 0.11097E+04_JPRB,0.84029E+03_JPRB,0.59841E+03_JPRB,0.87827E+03_JPRB,0.11607E+04_JPRB /)  
KB(:, 3,15,10) = (/ &
 & 0.11039E+04_JPRB,0.83570E+03_JPRB,0.59763E+03_JPRB,0.87745E+03_JPRB,0.11587E+04_JPRB /)  
KB(:, 4,15,10) = (/ &
 & 0.10995E+04_JPRB,0.83295E+03_JPRB,0.59685E+03_JPRB,0.87664E+03_JPRB,0.11574E+04_JPRB /)  
KB(:, 5,15,10) = (/ &
 & 0.10956E+04_JPRB,0.82966E+03_JPRB,0.59611E+03_JPRB,0.87548E+03_JPRB,0.11555E+04_JPRB /)  
KB(:, 1,16,10) = (/ &
 & 0.11006E+04_JPRB,0.83290E+03_JPRB,0.59871E+03_JPRB,0.87947E+03_JPRB,0.11625E+04_JPRB /)  
KB(:, 2,16,10) = (/ &
 & 0.10967E+04_JPRB,0.82960E+03_JPRB,0.59809E+03_JPRB,0.87696E+03_JPRB,0.11605E+04_JPRB /)  
KB(:, 3,16,10) = (/ &
 & 0.10908E+04_JPRB,0.82627E+03_JPRB,0.59735E+03_JPRB,0.87716E+03_JPRB,0.11587E+04_JPRB /)  
KB(:, 4,16,10) = (/ &
 & 0.10878E+04_JPRB,0.82496E+03_JPRB,0.59665E+03_JPRB,0.87645E+03_JPRB,0.11573E+04_JPRB /)  
KB(:, 5,16,10) = (/ &
 & 0.10846E+04_JPRB,0.82140E+03_JPRB,0.59584E+03_JPRB,0.87537E+03_JPRB,0.11556E+04_JPRB /)  
KB(:, 1,17,10) = (/ &
 & 0.10872E+04_JPRB,0.82399E+03_JPRB,0.59847E+03_JPRB,0.87912E+03_JPRB,0.11623E+04_JPRB /)  
KB(:, 2,17,10) = (/ &
 & 0.10836E+04_JPRB,0.82137E+03_JPRB,0.59782E+03_JPRB,0.87785E+03_JPRB,0.11604E+04_JPRB /)  
KB(:, 3,17,10) = (/ &
 & 0.10806E+04_JPRB,0.81903E+03_JPRB,0.59710E+03_JPRB,0.87700E+03_JPRB,0.11586E+04_JPRB /)  
KB(:, 4,17,10) = (/ &
 & 0.10781E+04_JPRB,0.81649E+03_JPRB,0.59641E+03_JPRB,0.87627E+03_JPRB,0.11571E+04_JPRB /)  
KB(:, 5,17,10) = (/ &
 & 0.10750E+04_JPRB,0.81461E+03_JPRB,0.59560E+03_JPRB,0.87517E+03_JPRB,0.11554E+04_JPRB /)  
KB(:, 1,18,10) = (/ &
 & 0.10783E+04_JPRB,0.81627E+03_JPRB,0.59826E+03_JPRB,0.87902E+03_JPRB,0.11620E+04_JPRB /)  
KB(:, 2,18,10) = (/ &
 & 0.10752E+04_JPRB,0.81450E+03_JPRB,0.59759E+03_JPRB,0.87778E+03_JPRB,0.11602E+04_JPRB /)  
KB(:, 3,18,10) = (/ &
 & 0.10718E+04_JPRB,0.81284E+03_JPRB,0.59689E+03_JPRB,0.87707E+03_JPRB,0.11584E+04_JPRB /)  
KB(:, 4,18,10) = (/ &
 & 0.10695E+04_JPRB,0.81051E+03_JPRB,0.59620E+03_JPRB,0.87578E+03_JPRB,0.11570E+04_JPRB /)  
KB(:, 5,18,10) = (/ &
 & 0.10675E+04_JPRB,0.80859E+03_JPRB,0.59539E+03_JPRB,0.87498E+03_JPRB,0.11554E+04_JPRB /)  
KB(:, 1,19,10) = (/ &
 & 0.10693E+04_JPRB,0.81014E+03_JPRB,0.59808E+03_JPRB,0.87871E+03_JPRB,0.11618E+04_JPRB /)  
KB(:, 2,19,10) = (/ &
 & 0.10674E+04_JPRB,0.80961E+03_JPRB,0.59739E+03_JPRB,0.87763E+03_JPRB,0.11601E+04_JPRB /)  
KB(:, 3,19,10) = (/ &
 & 0.10651E+04_JPRB,0.80782E+03_JPRB,0.59664E+03_JPRB,0.87683E+03_JPRB,0.11582E+04_JPRB /)  
KB(:, 4,19,10) = (/ &
 & 0.10639E+04_JPRB,0.80562E+03_JPRB,0.59610E+03_JPRB,0.87595E+03_JPRB,0.11569E+04_JPRB /)  
KB(:, 5,19,10) = (/ &
 & 0.10620E+04_JPRB,0.80440E+03_JPRB,0.59520E+03_JPRB,0.87481E+03_JPRB,0.11551E+04_JPRB /)  
KB(:, 1,20,10) = (/ &
 & 0.10633E+04_JPRB,0.80580E+03_JPRB,0.59791E+03_JPRB,0.87862E+03_JPRB,0.11616E+04_JPRB /)  
KB(:, 2,20,10) = (/ &
 & 0.10619E+04_JPRB,0.80442E+03_JPRB,0.59720E+03_JPRB,0.87747E+03_JPRB,0.11598E+04_JPRB /)  
KB(:, 3,20,10) = (/ &
 & 0.10607E+04_JPRB,0.80344E+03_JPRB,0.59654E+03_JPRB,0.87680E+03_JPRB,0.11581E+04_JPRB /)  
KB(:, 4,20,10) = (/ &
 & 0.10584E+04_JPRB,0.80182E+03_JPRB,0.59585E+03_JPRB,0.87568E+03_JPRB,0.11568E+04_JPRB /)  
KB(:, 5,20,10) = (/ &
 & 0.10568E+04_JPRB,0.80142E+03_JPRB,0.59502E+03_JPRB,0.87461E+03_JPRB,0.11549E+04_JPRB /)  
KB(:, 1,21,10) = (/ &
 & 0.10577E+04_JPRB,0.80247E+03_JPRB,0.59775E+03_JPRB,0.87831E+03_JPRB,0.11614E+04_JPRB /)  
KB(:, 2,21,10) = (/ &
 & 0.10572E+04_JPRB,0.80108E+03_JPRB,0.59703E+03_JPRB,0.87733E+03_JPRB,0.11595E+04_JPRB /)  
KB(:, 3,21,10) = (/ &
 & 0.10551E+04_JPRB,0.79955E+03_JPRB,0.59639E+03_JPRB,0.87689E+03_JPRB,0.11579E+04_JPRB /)  
KB(:, 4,21,10) = (/ &
 & 0.10548E+04_JPRB,0.79914E+03_JPRB,0.59569E+03_JPRB,0.87563E+03_JPRB,0.11565E+04_JPRB /)  
KB(:, 5,21,10) = (/ &
 & 0.10533E+04_JPRB,0.79794E+03_JPRB,0.59484E+03_JPRB,0.87454E+03_JPRB,0.11546E+04_JPRB /)  
KB(:, 1,22,10) = (/ &
 & 0.10544E+04_JPRB,0.79901E+03_JPRB,0.59755E+03_JPRB,0.87816E+03_JPRB,0.11610E+04_JPRB /)  
KB(:, 2,22,10) = (/ &
 & 0.10524E+04_JPRB,0.79865E+03_JPRB,0.59692E+03_JPRB,0.87715E+03_JPRB,0.11592E+04_JPRB /)  
KB(:, 3,22,10) = (/ &
 & 0.10518E+04_JPRB,0.79733E+03_JPRB,0.59621E+03_JPRB,0.87638E+03_JPRB,0.11576E+04_JPRB /)  
KB(:, 4,22,10) = (/ &
 & 0.10503E+04_JPRB,0.79602E+03_JPRB,0.59549E+03_JPRB,0.87540E+03_JPRB,0.11562E+04_JPRB /)  
KB(:, 5,22,10) = (/ &
 & 0.10497E+04_JPRB,0.79577E+03_JPRB,0.59455E+03_JPRB,0.87415E+03_JPRB,0.11542E+04_JPRB /)  
KB(:, 1,23,10) = (/ &
 & 0.10504E+04_JPRB,0.79618E+03_JPRB,0.59736E+03_JPRB,0.87790E+03_JPRB,0.11608E+04_JPRB /)  
KB(:, 2,23,10) = (/ &
 & 0.10488E+04_JPRB,0.79542E+03_JPRB,0.59652E+03_JPRB,0.87687E+03_JPRB,0.11588E+04_JPRB /)  
KB(:, 3,23,10) = (/ &
 & 0.10489E+04_JPRB,0.79466E+03_JPRB,0.59603E+03_JPRB,0.87619E+03_JPRB,0.11574E+04_JPRB /)  
KB(:, 4,23,10) = (/ &
 & 0.10477E+04_JPRB,0.79399E+03_JPRB,0.59528E+03_JPRB,0.87505E+03_JPRB,0.11559E+04_JPRB /)  
KB(:, 5,23,10) = (/ &
 & 0.10468E+04_JPRB,0.79357E+03_JPRB,0.59440E+03_JPRB,0.87388E+03_JPRB,0.11537E+04_JPRB /)  
KB(:, 1,24,10) = (/ &
 & 0.10475E+04_JPRB,0.79355E+03_JPRB,0.59716E+03_JPRB,0.87766E+03_JPRB,0.11603E+04_JPRB /)  
KB(:, 2,24,10) = (/ &
 & 0.10471E+04_JPRB,0.79325E+03_JPRB,0.59650E+03_JPRB,0.87681E+03_JPRB,0.11585E+04_JPRB /)  
KB(:, 3,24,10) = (/ &
 & 0.10463E+04_JPRB,0.79243E+03_JPRB,0.59586E+03_JPRB,0.87587E+03_JPRB,0.11571E+04_JPRB /)  
KB(:, 4,24,10) = (/ &
 & 0.10454E+04_JPRB,0.79206E+03_JPRB,0.59508E+03_JPRB,0.87468E+03_JPRB,0.11555E+04_JPRB /)  
KB(:, 5,24,10) = (/ &
 & 0.10455E+04_JPRB,0.79146E+03_JPRB,0.59426E+03_JPRB,0.87360E+03_JPRB,0.11532E+04_JPRB /)  
KB(:, 1,25,10) = (/ &
 & 0.10443E+04_JPRB,0.79222E+03_JPRB,0.59698E+03_JPRB,0.87742E+03_JPRB,0.11598E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART26',1,ZHOOK_HANDLE)
END SUBROUTINE PART26


SUBROUTINE PART27

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART27',0,ZHOOK_HANDLE)


KB(:, 2,25,10) = (/ &
 & 0.10446E+04_JPRB,0.79165E+03_JPRB,0.59633E+03_JPRB,0.87696E+03_JPRB,0.11582E+04_JPRB /)  
KB(:, 3,25,10) = (/ &
 & 0.10440E+04_JPRB,0.79123E+03_JPRB,0.59567E+03_JPRB,0.87565E+03_JPRB,0.11568E+04_JPRB /)  
KB(:, 4,25,10) = (/ &
 & 0.10433E+04_JPRB,0.79106E+03_JPRB,0.59487E+03_JPRB,0.87451E+03_JPRB,0.11551E+04_JPRB /)  
KB(:, 5,25,10) = (/ &
 & 0.10423E+04_JPRB,0.79063E+03_JPRB,0.59375E+03_JPRB,0.87329E+03_JPRB,0.11525E+04_JPRB /)  
KB(:, 1,26,10) = (/ &
 & 0.10431E+04_JPRB,0.79112E+03_JPRB,0.59671E+03_JPRB,0.87720E+03_JPRB,0.11595E+04_JPRB /)  
KB(:, 2,26,10) = (/ &
 & 0.10430E+04_JPRB,0.79016E+03_JPRB,0.59608E+03_JPRB,0.87633E+03_JPRB,0.11579E+04_JPRB /)  
KB(:, 3,26,10) = (/ &
 & 0.10422E+04_JPRB,0.78992E+03_JPRB,0.59547E+03_JPRB,0.87551E+03_JPRB,0.11565E+04_JPRB /)  
KB(:, 4,26,10) = (/ &
 & 0.10418E+04_JPRB,0.78943E+03_JPRB,0.59456E+03_JPRB,0.87419E+03_JPRB,0.11545E+04_JPRB /)  
KB(:, 5,26,10) = (/ &
 & 0.10417E+04_JPRB,0.78966E+03_JPRB,0.59375E+03_JPRB,0.87285E+03_JPRB,0.11523E+04_JPRB /)  
KB(:, 1,27,10) = (/ &
 & 0.10421E+04_JPRB,0.78970E+03_JPRB,0.59653E+03_JPRB,0.87700E+03_JPRB,0.11589E+04_JPRB /)  
KB(:, 2,27,10) = (/ &
 & 0.10419E+04_JPRB,0.78911E+03_JPRB,0.59591E+03_JPRB,0.87623E+03_JPRB,0.11575E+04_JPRB /)  
KB(:, 3,27,10) = (/ &
 & 0.10414E+04_JPRB,0.78914E+03_JPRB,0.59527E+03_JPRB,0.87524E+03_JPRB,0.11555E+04_JPRB /)  
KB(:, 4,27,10) = (/ &
 & 0.10412E+04_JPRB,0.78891E+03_JPRB,0.59440E+03_JPRB,0.87398E+03_JPRB,0.11540E+04_JPRB /)  
KB(:, 5,27,10) = (/ &
 & 0.10400E+04_JPRB,0.78850E+03_JPRB,0.59354E+03_JPRB,0.87262E+03_JPRB,0.11516E+04_JPRB /)  
KB(:, 1,28,10) = (/ &
 & 0.10402E+04_JPRB,0.78860E+03_JPRB,0.59644E+03_JPRB,0.87682E+03_JPRB,0.11586E+04_JPRB /)  
KB(:, 2,28,10) = (/ &
 & 0.10405E+04_JPRB,0.78788E+03_JPRB,0.59574E+03_JPRB,0.87579E+03_JPRB,0.11571E+04_JPRB /)  
KB(:, 3,28,10) = (/ &
 & 0.10403E+04_JPRB,0.78855E+03_JPRB,0.59498E+03_JPRB,0.87473E+03_JPRB,0.11552E+04_JPRB /)  
KB(:, 4,28,10) = (/ &
 & 0.10397E+04_JPRB,0.78826E+03_JPRB,0.59417E+03_JPRB,0.87377E+03_JPRB,0.11534E+04_JPRB /)  
KB(:, 5,28,10) = (/ &
 & 0.10396E+04_JPRB,0.78810E+03_JPRB,0.59333E+03_JPRB,0.87227E+03_JPRB,0.11511E+04_JPRB /)  
KB(:, 1,29,10) = (/ &
 & 0.10391E+04_JPRB,0.78797E+03_JPRB,0.59612E+03_JPRB,0.87685E+03_JPRB,0.11584E+04_JPRB /)  
KB(:, 2,29,10) = (/ &
 & 0.10393E+04_JPRB,0.78808E+03_JPRB,0.59562E+03_JPRB,0.87577E+03_JPRB,0.11569E+04_JPRB /)  
KB(:, 3,29,10) = (/ &
 & 0.10401E+04_JPRB,0.78791E+03_JPRB,0.59476E+03_JPRB,0.87463E+03_JPRB,0.11550E+04_JPRB /)  
KB(:, 4,29,10) = (/ &
 & 0.10388E+04_JPRB,0.78727E+03_JPRB,0.59387E+03_JPRB,0.87332E+03_JPRB,0.11526E+04_JPRB /)  
KB(:, 5,29,10) = (/ &
 & 0.10383E+04_JPRB,0.78753E+03_JPRB,0.59306E+03_JPRB,0.87189E+03_JPRB,0.11504E+04_JPRB /)  
KB(:, 1,30,10) = (/ &
 & 0.10398E+04_JPRB,0.78748E+03_JPRB,0.59603E+03_JPRB,0.87643E+03_JPRB,0.11579E+04_JPRB /)  
KB(:, 2,30,10) = (/ &
 & 0.10387E+04_JPRB,0.78733E+03_JPRB,0.59550E+03_JPRB,0.87550E+03_JPRB,0.11567E+04_JPRB /)  
KB(:, 3,30,10) = (/ &
 & 0.10384E+04_JPRB,0.78700E+03_JPRB,0.59460E+03_JPRB,0.87431E+03_JPRB,0.11543E+04_JPRB /)  
KB(:, 4,30,10) = (/ &
 & 0.10381E+04_JPRB,0.78738E+03_JPRB,0.59372E+03_JPRB,0.87275E+03_JPRB,0.11522E+04_JPRB /)  
KB(:, 5,30,10) = (/ &
 & 0.10382E+04_JPRB,0.78707E+03_JPRB,0.59292E+03_JPRB,0.87137E+03_JPRB,0.11500E+04_JPRB /)  
KB(:, 1,31,10) = (/ &
 & 0.10388E+04_JPRB,0.78740E+03_JPRB,0.59593E+03_JPRB,0.87621E+03_JPRB,0.11575E+04_JPRB /)  
KB(:, 2,31,10) = (/ &
 & 0.10385E+04_JPRB,0.78757E+03_JPRB,0.59522E+03_JPRB,0.87522E+03_JPRB,0.11561E+04_JPRB /)  
KB(:, 3,31,10) = (/ &
 & 0.10386E+04_JPRB,0.78718E+03_JPRB,0.59436E+03_JPRB,0.87397E+03_JPRB,0.11540E+04_JPRB /)  
KB(:, 4,31,10) = (/ &
 & 0.10377E+04_JPRB,0.78650E+03_JPRB,0.59350E+03_JPRB,0.87250E+03_JPRB,0.11516E+04_JPRB /)  
KB(:, 5,31,10) = (/ &
 & 0.10376E+04_JPRB,0.78651E+03_JPRB,0.59269E+03_JPRB,0.87108E+03_JPRB,0.11495E+04_JPRB /)  
KB(:, 1,32,10) = (/ &
 & 0.10383E+04_JPRB,0.78682E+03_JPRB,0.59576E+03_JPRB,0.87597E+03_JPRB,0.11572E+04_JPRB /)  
KB(:, 2,32,10) = (/ &
 & 0.10383E+04_JPRB,0.78712E+03_JPRB,0.59500E+03_JPRB,0.87480E+03_JPRB,0.11556E+04_JPRB /)  
KB(:, 3,32,10) = (/ &
 & 0.10381E+04_JPRB,0.78606E+03_JPRB,0.59405E+03_JPRB,0.87362E+03_JPRB,0.11534E+04_JPRB /)  
KB(:, 4,32,10) = (/ &
 & 0.10372E+04_JPRB,0.78628E+03_JPRB,0.59329E+03_JPRB,0.87223E+03_JPRB,0.11510E+04_JPRB /)  
KB(:, 5,32,10) = (/ &
 & 0.10377E+04_JPRB,0.78690E+03_JPRB,0.59245E+03_JPRB,0.87068E+03_JPRB,0.11490E+04_JPRB /)  
KB(:, 1,33,10) = (/ &
 & 0.10380E+04_JPRB,0.78593E+03_JPRB,0.59549E+03_JPRB,0.87572E+03_JPRB,0.11567E+04_JPRB /)  
KB(:, 2,33,10) = (/ &
 & 0.10375E+04_JPRB,0.78654E+03_JPRB,0.59477E+03_JPRB,0.87458E+03_JPRB,0.11551E+04_JPRB /)  
KB(:, 3,33,10) = (/ &
 & 0.10374E+04_JPRB,0.78686E+03_JPRB,0.59389E+03_JPRB,0.87337E+03_JPRB,0.11527E+04_JPRB /)  
KB(:, 4,33,10) = (/ &
 & 0.10366E+04_JPRB,0.78593E+03_JPRB,0.59308E+03_JPRB,0.87194E+03_JPRB,0.11506E+04_JPRB /)  
KB(:, 5,33,10) = (/ &
 & 0.10369E+04_JPRB,0.78626E+03_JPRB,0.59219E+03_JPRB,0.87038E+03_JPRB,0.11486E+04_JPRB /)  
KB(:, 1,34,10) = (/ &
 & 0.10373E+04_JPRB,0.78657E+03_JPRB,0.59539E+03_JPRB,0.87559E+03_JPRB,0.11565E+04_JPRB /)  
KB(:, 2,34,10) = (/ &
 & 0.10370E+04_JPRB,0.78641E+03_JPRB,0.59464E+03_JPRB,0.87429E+03_JPRB,0.11546E+04_JPRB /)  
KB(:, 3,34,10) = (/ &
 & 0.10370E+04_JPRB,0.78587E+03_JPRB,0.59369E+03_JPRB,0.87295E+03_JPRB,0.11522E+04_JPRB /)  
KB(:, 4,34,10) = (/ &
 & 0.10371E+04_JPRB,0.78562E+03_JPRB,0.59289E+03_JPRB,0.87146E+03_JPRB,0.11500E+04_JPRB /)  
KB(:, 5,34,10) = (/ &
 & 0.10372E+04_JPRB,0.78597E+03_JPRB,0.59202E+03_JPRB,0.86991E+03_JPRB,0.11482E+04_JPRB /)  
KB(:, 1,35,10) = (/ &
 & 0.10364E+04_JPRB,0.78559E+03_JPRB,0.59529E+03_JPRB,0.87523E+03_JPRB,0.11563E+04_JPRB /)  
KB(:, 2,35,10) = (/ &
 & 0.10362E+04_JPRB,0.78545E+03_JPRB,0.59445E+03_JPRB,0.87400E+03_JPRB,0.11543E+04_JPRB /)  
KB(:, 3,35,10) = (/ &
 & 0.10372E+04_JPRB,0.78599E+03_JPRB,0.59365E+03_JPRB,0.87265E+03_JPRB,0.11519E+04_JPRB /)  
KB(:, 4,35,10) = (/ &
 & 0.10370E+04_JPRB,0.78527E+03_JPRB,0.59278E+03_JPRB,0.87136E+03_JPRB,0.11496E+04_JPRB /)  
KB(:, 5,35,10) = (/ &
 & 0.10363E+04_JPRB,0.78582E+03_JPRB,0.59179E+03_JPRB,0.86905E+03_JPRB,0.11477E+04_JPRB /)  
KB(:, 1,36,10) = (/ &
 & 0.10368E+04_JPRB,0.78515E+03_JPRB,0.59520E+03_JPRB,0.87532E+03_JPRB,0.11563E+04_JPRB /)  
KB(:, 2,36,10) = (/ &
 & 0.10358E+04_JPRB,0.78589E+03_JPRB,0.59443E+03_JPRB,0.87419E+03_JPRB,0.11542E+04_JPRB /)  
KB(:, 3,36,10) = (/ &
 & 0.10361E+04_JPRB,0.78556E+03_JPRB,0.59355E+03_JPRB,0.87273E+03_JPRB,0.11517E+04_JPRB /)  
KB(:, 4,36,10) = (/ &
 & 0.10361E+04_JPRB,0.78543E+03_JPRB,0.59275E+03_JPRB,0.87122E+03_JPRB,0.11497E+04_JPRB /)  
KB(:, 5,36,10) = (/ &
 & 0.10368E+04_JPRB,0.78570E+03_JPRB,0.59176E+03_JPRB,0.86999E+03_JPRB,0.11477E+04_JPRB /)  
KB(:, 1,37,10) = (/ &
 & 0.10363E+04_JPRB,0.78591E+03_JPRB,0.59537E+03_JPRB,0.87546E+03_JPRB,0.11565E+04_JPRB /)  
KB(:, 2,37,10) = (/ &
 & 0.10360E+04_JPRB,0.78548E+03_JPRB,0.59454E+03_JPRB,0.87425E+03_JPRB,0.11545E+04_JPRB /)  
KB(:, 3,37,10) = (/ &
 & 0.10362E+04_JPRB,0.78546E+03_JPRB,0.59366E+03_JPRB,0.87291E+03_JPRB,0.11521E+04_JPRB /)  
KB(:, 4,37,10) = (/ &
 & 0.10364E+04_JPRB,0.78543E+03_JPRB,0.59286E+03_JPRB,0.87142E+03_JPRB,0.11500E+04_JPRB /)  
KB(:, 5,37,10) = (/ &
 & 0.10360E+04_JPRB,0.78560E+03_JPRB,0.59177E+03_JPRB,0.86987E+03_JPRB,0.11482E+04_JPRB /)  
KB(:, 1,38,10) = (/ &
 & 0.10362E+04_JPRB,0.78542E+03_JPRB,0.59547E+03_JPRB,0.87560E+03_JPRB,0.11567E+04_JPRB /)  
KB(:, 2,38,10) = (/ &
 & 0.10357E+04_JPRB,0.78588E+03_JPRB,0.59466E+03_JPRB,0.87433E+03_JPRB,0.11549E+04_JPRB /)  
KB(:, 3,38,10) = (/ &
 & 0.10370E+04_JPRB,0.78605E+03_JPRB,0.59385E+03_JPRB,0.87310E+03_JPRB,0.11524E+04_JPRB /)  
KB(:, 4,38,10) = (/ &
 & 0.10362E+04_JPRB,0.78574E+03_JPRB,0.59297E+03_JPRB,0.87186E+03_JPRB,0.11501E+04_JPRB /)  
KB(:, 5,38,10) = (/ &
 & 0.10364E+04_JPRB,0.78533E+03_JPRB,0.59199E+03_JPRB,0.87009E+03_JPRB,0.11482E+04_JPRB /)  
KB(:, 1,39,10) = (/ &
 & 0.10359E+04_JPRB,0.78514E+03_JPRB,0.59557E+03_JPRB,0.87574E+03_JPRB,0.11567E+04_JPRB /)  
KB(:, 2,39,10) = (/ &
 & 0.10371E+04_JPRB,0.78541E+03_JPRB,0.59478E+03_JPRB,0.87461E+03_JPRB,0.11552E+04_JPRB /)  
KB(:, 3,39,10) = (/ &
 & 0.10366E+04_JPRB,0.78569E+03_JPRB,0.59382E+03_JPRB,0.87329E+03_JPRB,0.11528E+04_JPRB /)  
KB(:, 4,39,10) = (/ &
 & 0.10359E+04_JPRB,0.78528E+03_JPRB,0.59308E+03_JPRB,0.87198E+03_JPRB,0.11506E+04_JPRB /)  
KB(:, 5,39,10) = (/ &
 & 0.10356E+04_JPRB,0.78487E+03_JPRB,0.59220E+03_JPRB,0.87042E+03_JPRB,0.11486E+04_JPRB /)  
KB(:, 1,40,10) = (/ &
 & 0.10357E+04_JPRB,0.78518E+03_JPRB,0.59566E+03_JPRB,0.87586E+03_JPRB,0.11569E+04_JPRB /)  
KB(:, 2,40,10) = (/ &
 & 0.10357E+04_JPRB,0.78506E+03_JPRB,0.59498E+03_JPRB,0.87480E+03_JPRB,0.11555E+04_JPRB /)  
KB(:, 3,40,10) = (/ &
 & 0.10366E+04_JPRB,0.78504E+03_JPRB,0.59396E+03_JPRB,0.87362E+03_JPRB,0.11534E+04_JPRB /)  
KB(:, 4,40,10) = (/ &
 & 0.10363E+04_JPRB,0.78503E+03_JPRB,0.59319E+03_JPRB,0.87212E+03_JPRB,0.11511E+04_JPRB /)  
KB(:, 5,40,10) = (/ &
 & 0.10363E+04_JPRB,0.78540E+03_JPRB,0.59243E+03_JPRB,0.87078E+03_JPRB,0.11490E+04_JPRB /)  
KB(:, 1,41,10) = (/ &
 & 0.10363E+04_JPRB,0.78503E+03_JPRB,0.59590E+03_JPRB,0.87608E+03_JPRB,0.11576E+04_JPRB /)  
KB(:, 2,41,10) = (/ &
 & 0.10356E+04_JPRB,0.78491E+03_JPRB,0.59519E+03_JPRB,0.87520E+03_JPRB,0.11561E+04_JPRB /)  
KB(:, 3,41,10) = (/ &
 & 0.10364E+04_JPRB,0.78558E+03_JPRB,0.59433E+03_JPRB,0.87384E+03_JPRB,0.11540E+04_JPRB /)  
KB(:, 4,41,10) = (/ &
 & 0.10357E+04_JPRB,0.78518E+03_JPRB,0.59354E+03_JPRB,0.87259E+03_JPRB,0.11516E+04_JPRB /)  
KB(:, 5,41,10) = (/ &
 & 0.10360E+04_JPRB,0.78526E+03_JPRB,0.59259E+03_JPRB,0.87107E+03_JPRB,0.11495E+04_JPRB /)  
KB(:, 1,42,10) = (/ &
 & 0.10360E+04_JPRB,0.78488E+03_JPRB,0.59605E+03_JPRB,0.87553E+03_JPRB,0.11576E+04_JPRB /)  
KB(:, 2,42,10) = (/ &
 & 0.10363E+04_JPRB,0.78507E+03_JPRB,0.59538E+03_JPRB,0.87537E+03_JPRB,0.11565E+04_JPRB /)  
KB(:, 3,42,10) = (/ &
 & 0.10362E+04_JPRB,0.78535E+03_JPRB,0.59456E+03_JPRB,0.87429E+03_JPRB,0.11545E+04_JPRB /)  
KB(:, 4,42,10) = (/ &
 & 0.10361E+04_JPRB,0.78514E+03_JPRB,0.59368E+03_JPRB,0.87295E+03_JPRB,0.11522E+04_JPRB /)  
KB(:, 5,42,10) = (/ &
 & 0.10360E+04_JPRB,0.78523E+03_JPRB,0.59281E+03_JPRB,0.87146E+03_JPRB,0.11502E+04_JPRB /)  
KB(:, 1,43,10) = (/ &
 & 0.10359E+04_JPRB,0.78504E+03_JPRB,0.59624E+03_JPRB,0.87675E+03_JPRB,0.11584E+04_JPRB /)  
KB(:, 2,43,10) = (/ &
 & 0.10355E+04_JPRB,0.78552E+03_JPRB,0.59568E+03_JPRB,0.87580E+03_JPRB,0.11570E+04_JPRB /)  
KB(:, 3,43,10) = (/ &
 & 0.10354E+04_JPRB,0.78512E+03_JPRB,0.59483E+03_JPRB,0.87469E+03_JPRB,0.11553E+04_JPRB /)  
KB(:, 4,43,10) = (/ &
 & 0.10354E+04_JPRB,0.78569E+03_JPRB,0.59395E+03_JPRB,0.87316E+03_JPRB,0.11531E+04_JPRB /)  
KB(:, 5,43,10) = (/ &
 & 0.10359E+04_JPRB,0.78598E+03_JPRB,0.59313E+03_JPRB,0.87186E+03_JPRB,0.11507E+04_JPRB /)  
KB(:, 1,44,10) = (/ &
 & 0.10359E+04_JPRB,0.78521E+03_JPRB,0.59645E+03_JPRB,0.87700E+03_JPRB,0.11590E+04_JPRB /)  
KB(:, 2,44,10) = (/ &
 & 0.10361E+04_JPRB,0.78510E+03_JPRB,0.59583E+03_JPRB,0.87611E+03_JPRB,0.11574E+04_JPRB /)  
KB(:, 3,44,10) = (/ &
 & 0.10368E+04_JPRB,0.78519E+03_JPRB,0.59511E+03_JPRB,0.87509E+03_JPRB,0.11561E+04_JPRB /)  
KB(:, 4,44,10) = (/ &
 & 0.10360E+04_JPRB,0.78508E+03_JPRB,0.59424E+03_JPRB,0.87372E+03_JPRB,0.11538E+04_JPRB /)  
KB(:, 5,44,10) = (/ &
 & 0.10356E+04_JPRB,0.78537E+03_JPRB,0.59339E+03_JPRB,0.87213E+03_JPRB,0.11514E+04_JPRB /)  
KB(:, 1,45,10) = (/ &
 & 0.10357E+04_JPRB,0.78557E+03_JPRB,0.59666E+03_JPRB,0.87715E+03_JPRB,0.11597E+04_JPRB /)  
KB(:, 2,45,10) = (/ &
 & 0.10356E+04_JPRB,0.78527E+03_JPRB,0.59604E+03_JPRB,0.87639E+03_JPRB,0.11579E+04_JPRB /)  
KB(:, 3,45,10) = (/ &
 & 0.10360E+04_JPRB,0.78546E+03_JPRB,0.59537E+03_JPRB,0.87547E+03_JPRB,0.11565E+04_JPRB /)  
KB(:, 4,45,10) = (/ &
 & 0.10361E+04_JPRB,0.78506E+03_JPRB,0.59454E+03_JPRB,0.87427E+03_JPRB,0.11544E+04_JPRB /)  
KB(:, 5,45,10) = (/ &
 & 0.10353E+04_JPRB,0.78535E+03_JPRB,0.59366E+03_JPRB,0.87293E+03_JPRB,0.11520E+04_JPRB /)  
KB(:, 1,46,10) = (/ &
 & 0.10358E+04_JPRB,0.78506E+03_JPRB,0.59691E+03_JPRB,0.87749E+03_JPRB,0.11602E+04_JPRB /)  
KB(:, 2,46,10) = (/ &
 & 0.10353E+04_JPRB,0.78486E+03_JPRB,0.59626E+03_JPRB,0.87678E+03_JPRB,0.11584E+04_JPRB /)  
KB(:, 3,46,10) = (/ &
 & 0.10353E+04_JPRB,0.78495E+03_JPRB,0.59563E+03_JPRB,0.87572E+03_JPRB,0.11570E+04_JPRB /)  
KB(:, 4,46,10) = (/ &
 & 0.10363E+04_JPRB,0.78534E+03_JPRB,0.59478E+03_JPRB,0.87473E+03_JPRB,0.11554E+04_JPRB /)  
KB(:, 5,46,10) = (/ &
 & 0.10355E+04_JPRB,0.78455E+03_JPRB,0.59398E+03_JPRB,0.87342E+03_JPRB,0.11530E+04_JPRB /)  
KB(:, 1,47,10) = (/ &
 & 0.10357E+04_JPRB,0.78544E+03_JPRB,0.59719E+03_JPRB,0.87795E+03_JPRB,0.11609E+04_JPRB /)  
KB(:, 2,47,10) = (/ &
 & 0.10355E+04_JPRB,0.78533E+03_JPRB,0.59651E+03_JPRB,0.87696E+03_JPRB,0.11589E+04_JPRB /)  
KB(:, 3,47,10) = (/ &
 & 0.10358E+04_JPRB,0.78543E+03_JPRB,0.59590E+03_JPRB,0.87576E+03_JPRB,0.11576E+04_JPRB /)  
KB(:, 4,47,10) = (/ &
 & 0.10351E+04_JPRB,0.78562E+03_JPRB,0.59519E+03_JPRB,0.87521E+03_JPRB,0.11561E+04_JPRB /)  
KB(:, 5,47,10) = (/ &
 & 0.10359E+04_JPRB,0.78571E+03_JPRB,0.59433E+03_JPRB,0.87385E+03_JPRB,0.11540E+04_JPRB /)  
KB(:, 1,48,10) = (/ &
 & 0.10363E+04_JPRB,0.78513E+03_JPRB,0.59744E+03_JPRB,0.87846E+03_JPRB,0.11618E+04_JPRB /)  
KB(:, 2,48,10) = (/ &
 & 0.10360E+04_JPRB,0.78532E+03_JPRB,0.59677E+03_JPRB,0.87730E+03_JPRB,0.11598E+04_JPRB /)  
KB(:, 3,48,10) = (/ &
 & 0.10365E+04_JPRB,0.78483E+03_JPRB,0.59614E+03_JPRB,0.87707E+03_JPRB,0.11581E+04_JPRB /)  
KB(:, 4,48,10) = (/ &
 & 0.10355E+04_JPRB,0.78521E+03_JPRB,0.59549E+03_JPRB,0.87564E+03_JPRB,0.11567E+04_JPRB /)  
KB(:, 5,48,10) = (/ &
 & 0.10355E+04_JPRB,0.78531E+03_JPRB,0.59469E+03_JPRB,0.87448E+03_JPRB,0.11550E+04_JPRB /)  
KB(:, 1,49,10) = (/ &
 & 0.10351E+04_JPRB,0.78492E+03_JPRB,0.59768E+03_JPRB,0.87902E+03_JPRB,0.11625E+04_JPRB /)  
KB(:, 2,49,10) = (/ &
 & 0.10355E+04_JPRB,0.78541E+03_JPRB,0.59705E+03_JPRB,0.87772E+03_JPRB,0.11606E+04_JPRB /)  
KB(:, 3,49,10) = (/ &
 & 0.10352E+04_JPRB,0.78472E+03_JPRB,0.59639E+03_JPRB,0.87682E+03_JPRB,0.11587E+04_JPRB /)  
KB(:, 4,49,10) = (/ &
 & 0.10356E+04_JPRB,0.78511E+03_JPRB,0.59577E+03_JPRB,0.87591E+03_JPRB,0.11574E+04_JPRB /)  
KB(:, 5,49,10) = (/ &
 & 0.10352E+04_JPRB,0.78501E+03_JPRB,0.59510E+03_JPRB,0.87498E+03_JPRB,0.11558E+04_JPRB /)  
KB(:, 1,50,10) = (/ &
 & 0.10361E+04_JPRB,0.78540E+03_JPRB,0.59770E+03_JPRB,0.87956E+03_JPRB,0.11633E+04_JPRB /)  
KB(:, 2,50,10) = (/ &
 & 0.10357E+04_JPRB,0.78530E+03_JPRB,0.59731E+03_JPRB,0.87817E+03_JPRB,0.11612E+04_JPRB /)  
KB(:, 3,50,10) = (/ &
 & 0.10365E+04_JPRB,0.78510E+03_JPRB,0.59662E+03_JPRB,0.87710E+03_JPRB,0.11596E+04_JPRB /)  
KB(:, 4,50,10) = (/ &
 & 0.10365E+04_JPRB,0.78510E+03_JPRB,0.59601E+03_JPRB,0.87645E+03_JPRB,0.11578E+04_JPRB /)  
KB(:, 5,50,10) = (/ &
 & 0.10352E+04_JPRB,0.78588E+03_JPRB,0.59525E+03_JPRB,0.87541E+03_JPRB,0.11564E+04_JPRB /)  
KB(:, 1,51,10) = (/ &
 & 0.10356E+04_JPRB,0.78490E+03_JPRB,0.59781E+03_JPRB,0.88010E+03_JPRB,0.11639E+04_JPRB /)  
KB(:, 2,51,10) = (/ &
 & 0.10356E+04_JPRB,0.78539E+03_JPRB,0.59751E+03_JPRB,0.87866E+03_JPRB,0.11620E+04_JPRB /)  
KB(:, 3,51,10) = (/ &
 & 0.10359E+04_JPRB,0.78461E+03_JPRB,0.59687E+03_JPRB,0.87744E+03_JPRB,0.11601E+04_JPRB /)  
KB(:, 4,51,10) = (/ &
 & 0.10352E+04_JPRB,0.78519E+03_JPRB,0.59623E+03_JPRB,0.87674E+03_JPRB,0.11583E+04_JPRB /)  
KB(:, 5,51,10) = (/ &
 & 0.10356E+04_JPRB,0.78470E+03_JPRB,0.59552E+03_JPRB,0.87578E+03_JPRB,0.11569E+04_JPRB /)  
KB(:, 1,52,10) = (/ &
 & 0.10352E+04_JPRB,0.78509E+03_JPRB,0.59800E+03_JPRB,0.88094E+03_JPRB,0.11643E+04_JPRB /)  
KB(:, 2,52,10) = (/ &
 & 0.10355E+04_JPRB,0.78528E+03_JPRB,0.59763E+03_JPRB,0.87918E+03_JPRB,0.11627E+04_JPRB /)  
KB(:, 3,52,10) = (/ &
 & 0.10361E+04_JPRB,0.78479E+03_JPRB,0.59712E+03_JPRB,0.87762E+03_JPRB,0.11608E+04_JPRB /)  
KB(:, 4,52,10) = (/ &
 & 0.10358E+04_JPRB,0.78528E+03_JPRB,0.59645E+03_JPRB,0.87678E+03_JPRB,0.11589E+04_JPRB /)  
KB(:, 5,52,10) = (/ &
 & 0.10355E+04_JPRB,0.78528E+03_JPRB,0.59584E+03_JPRB,0.87612E+03_JPRB,0.11573E+04_JPRB /)  
KB(:, 1,53,10) = (/ &
 & 0.10357E+04_JPRB,0.78528E+03_JPRB,0.59832E+03_JPRB,0.88148E+03_JPRB,0.11650E+04_JPRB /)  
KB(:, 2,53,10) = (/ &
 & 0.10357E+04_JPRB,0.78596E+03_JPRB,0.59772E+03_JPRB,0.87969E+03_JPRB,0.11634E+04_JPRB /)  
KB(:, 3,53,10) = (/ &
 & 0.10361E+04_JPRB,0.78547E+03_JPRB,0.59737E+03_JPRB,0.87830E+03_JPRB,0.11614E+04_JPRB /)  
KB(:, 4,53,10) = (/ &
 & 0.10362E+04_JPRB,0.78537E+03_JPRB,0.59668E+03_JPRB,0.87707E+03_JPRB,0.11596E+04_JPRB /)  
KB(:, 5,53,10) = (/ &
 & 0.10356E+04_JPRB,0.78498E+03_JPRB,0.59606E+03_JPRB,0.87642E+03_JPRB,0.11578E+04_JPRB /)  
KB(:, 1,54,10) = (/ &
 & 0.10351E+04_JPRB,0.78567E+03_JPRB,0.59851E+03_JPRB,0.88199E+03_JPRB,0.11656E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART27',1,ZHOOK_HANDLE)
END SUBROUTINE PART27


SUBROUTINE PART28

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART28',0,ZHOOK_HANDLE)


KB(:, 2,54,10) = (/ &
 & 0.10366E+04_JPRB,0.78518E+03_JPRB,0.59776E+03_JPRB,0.88021E+03_JPRB,0.11638E+04_JPRB /)  
KB(:, 3,54,10) = (/ &
 & 0.10364E+04_JPRB,0.78478E+03_JPRB,0.59753E+03_JPRB,0.87875E+03_JPRB,0.11621E+04_JPRB /)  
KB(:, 4,54,10) = (/ &
 & 0.10356E+04_JPRB,0.78498E+03_JPRB,0.59692E+03_JPRB,0.87751E+03_JPRB,0.11602E+04_JPRB /)  
KB(:, 5,54,10) = (/ &
 & 0.10362E+04_JPRB,0.78527E+03_JPRB,0.59627E+03_JPRB,0.87657E+03_JPRB,0.11584E+04_JPRB /)  
KB(:, 1,55,10) = (/ &
 & 0.10355E+04_JPRB,0.78488E+03_JPRB,0.59876E+03_JPRB,0.88250E+03_JPRB,0.11663E+04_JPRB /)  
KB(:, 2,55,10) = (/ &
 & 0.10362E+04_JPRB,0.78527E+03_JPRB,0.59801E+03_JPRB,0.88087E+03_JPRB,0.11643E+04_JPRB /)  
KB(:, 3,55,10) = (/ &
 & 0.10356E+04_JPRB,0.78507E+03_JPRB,0.59764E+03_JPRB,0.87920E+03_JPRB,0.11628E+04_JPRB /)  
KB(:, 4,55,10) = (/ &
 & 0.10353E+04_JPRB,0.78488E+03_JPRB,0.59714E+03_JPRB,0.87787E+03_JPRB,0.11606E+04_JPRB /)  
KB(:, 5,55,10) = (/ &
 & 0.10356E+04_JPRB,0.78488E+03_JPRB,0.59639E+03_JPRB,0.87691E+03_JPRB,0.11585E+04_JPRB /)  
KB(:, 1,56,10) = (/ &
 & 0.10353E+04_JPRB,0.78537E+03_JPRB,0.59904E+03_JPRB,0.88318E+03_JPRB,0.11672E+04_JPRB /)  
KB(:, 2,56,10) = (/ &
 & 0.10354E+04_JPRB,0.78497E+03_JPRB,0.59830E+03_JPRB,0.88144E+03_JPRB,0.11649E+04_JPRB /)  
KB(:, 3,56,10) = (/ &
 & 0.10361E+04_JPRB,0.78536E+03_JPRB,0.59771E+03_JPRB,0.87966E+03_JPRB,0.11634E+04_JPRB /)  
KB(:, 4,56,10) = (/ &
 & 0.10357E+04_JPRB,0.78497E+03_JPRB,0.59736E+03_JPRB,0.87826E+03_JPRB,0.11615E+04_JPRB /)  
KB(:, 5,56,10) = (/ &
 & 0.10353E+04_JPRB,0.78478E+03_JPRB,0.59667E+03_JPRB,0.87705E+03_JPRB,0.11595E+04_JPRB /)  
KB(:, 1,57,10) = (/ &
 & 0.10358E+04_JPRB,0.78458E+03_JPRB,0.59927E+03_JPRB,0.88350E+03_JPRB,0.11679E+04_JPRB /)  
KB(:, 2,57,10) = (/ &
 & 0.10352E+04_JPRB,0.78536E+03_JPRB,0.59840E+03_JPRB,0.88193E+03_JPRB,0.11656E+04_JPRB /)  
KB(:, 3,57,10) = (/ &
 & 0.10352E+04_JPRB,0.78526E+03_JPRB,0.59782E+03_JPRB,0.88003E+03_JPRB,0.11638E+04_JPRB /)  
KB(:, 4,57,10) = (/ &
 & 0.10358E+04_JPRB,0.78497E+03_JPRB,0.59751E+03_JPRB,0.87869E+03_JPRB,0.11622E+04_JPRB /)  
KB(:, 5,57,10) = (/ &
 & 0.10360E+04_JPRB,0.78497E+03_JPRB,0.59689E+03_JPRB,0.87746E+03_JPRB,0.11601E+04_JPRB /)  
KB(:, 1,58,10) = (/ &
 & 0.10358E+04_JPRB,0.78468E+03_JPRB,0.59969E+03_JPRB,0.88402E+03_JPRB,0.11685E+04_JPRB /)  
KB(:, 2,58,10) = (/ &
 & 0.10357E+04_JPRB,0.78458E+03_JPRB,0.59873E+03_JPRB,0.88241E+03_JPRB,0.11662E+04_JPRB /)  
KB(:, 3,58,10) = (/ &
 & 0.10358E+04_JPRB,0.78526E+03_JPRB,0.59797E+03_JPRB,0.88085E+03_JPRB,0.11642E+04_JPRB /)  
KB(:, 4,58,10) = (/ &
 & 0.10356E+04_JPRB,0.78487E+03_JPRB,0.59762E+03_JPRB,0.87912E+03_JPRB,0.11626E+04_JPRB /)  
KB(:, 5,58,10) = (/ &
 & 0.10357E+04_JPRB,0.78565E+03_JPRB,0.59710E+03_JPRB,0.87769E+03_JPRB,0.11608E+04_JPRB /)  
KB(:, 1,59,10) = (/ &
 & 0.10360E+04_JPRB,0.78507E+03_JPRB,0.59979E+03_JPRB,0.88416E+03_JPRB,0.11687E+04_JPRB /)  
KB(:, 2,59,10) = (/ &
 & 0.10357E+04_JPRB,0.78477E+03_JPRB,0.59879E+03_JPRB,0.88260E+03_JPRB,0.11665E+04_JPRB /)  
KB(:, 3,59,10) = (/ &
 & 0.10350E+04_JPRB,0.78526E+03_JPRB,0.59804E+03_JPRB,0.88100E+03_JPRB,0.11644E+04_JPRB /)  
KB(:, 4,59,10) = (/ &
 & 0.10357E+04_JPRB,0.78467E+03_JPRB,0.59773E+03_JPRB,0.87930E+03_JPRB,0.11629E+04_JPRB /)  
KB(:, 5,59,10) = (/ &
 & 0.10358E+04_JPRB,0.78457E+03_JPRB,0.59718E+03_JPRB,0.87783E+03_JPRB,0.11609E+04_JPRB /)  
KB(:, 1,13,11) = (/ &
 & 0.11563E+04_JPRB,0.87491E+03_JPRB,0.60253E+03_JPRB,0.88362E+03_JPRB,0.11664E+04_JPRB /)  
KB(:, 2,13,11) = (/ &
 & 0.11454E+04_JPRB,0.86861E+03_JPRB,0.60211E+03_JPRB,0.88300E+03_JPRB,0.11639E+04_JPRB /)  
KB(:, 3,13,11) = (/ &
 & 0.11392E+04_JPRB,0.86181E+03_JPRB,0.60140E+03_JPRB,0.88181E+03_JPRB,0.11620E+04_JPRB /)  
KB(:, 4,13,11) = (/ &
 & 0.11315E+04_JPRB,0.85680E+03_JPRB,0.60042E+03_JPRB,0.88057E+03_JPRB,0.11602E+04_JPRB /)  
KB(:, 5,13,11) = (/ &
 & 0.11273E+04_JPRB,0.85330E+03_JPRB,0.59929E+03_JPRB,0.87908E+03_JPRB,0.11581E+04_JPRB /)  
KB(:, 1,14,11) = (/ &
 & 0.11333E+04_JPRB,0.85776E+03_JPRB,0.60215E+03_JPRB,0.88338E+03_JPRB,0.11660E+04_JPRB /)  
KB(:, 2,14,11) = (/ &
 & 0.11256E+04_JPRB,0.85211E+03_JPRB,0.60176E+03_JPRB,0.88258E+03_JPRB,0.11637E+04_JPRB /)  
KB(:, 3,14,11) = (/ &
 & 0.11185E+04_JPRB,0.84809E+03_JPRB,0.60101E+03_JPRB,0.88154E+03_JPRB,0.11618E+04_JPRB /)  
KB(:, 4,14,11) = (/ &
 & 0.11137E+04_JPRB,0.84328E+03_JPRB,0.59992E+03_JPRB,0.87989E+03_JPRB,0.11599E+04_JPRB /)  
KB(:, 5,14,11) = (/ &
 & 0.11092E+04_JPRB,0.83997E+03_JPRB,0.59898E+03_JPRB,0.87879E+03_JPRB,0.11581E+04_JPRB /)  
KB(:, 1,15,11) = (/ &
 & 0.11149E+04_JPRB,0.84435E+03_JPRB,0.60192E+03_JPRB,0.88317E+03_JPRB,0.11660E+04_JPRB /)  
KB(:, 2,15,11) = (/ &
 & 0.11071E+04_JPRB,0.83899E+03_JPRB,0.60145E+03_JPRB,0.88233E+03_JPRB,0.11635E+04_JPRB /)  
KB(:, 3,15,11) = (/ &
 & 0.11058E+04_JPRB,0.83612E+03_JPRB,0.60066E+03_JPRB,0.88128E+03_JPRB,0.11617E+04_JPRB /)  
KB(:, 4,15,11) = (/ &
 & 0.10996E+04_JPRB,0.83410E+03_JPRB,0.59965E+03_JPRB,0.88002E+03_JPRB,0.11599E+04_JPRB /)  
KB(:, 5,15,11) = (/ &
 & 0.10957E+04_JPRB,0.83022E+03_JPRB,0.59863E+03_JPRB,0.87850E+03_JPRB,0.11578E+04_JPRB /)  
KB(:, 1,16,11) = (/ &
 & 0.10993E+04_JPRB,0.83361E+03_JPRB,0.60157E+03_JPRB,0.88298E+03_JPRB,0.11657E+04_JPRB /)  
KB(:, 2,16,11) = (/ &
 & 0.10933E+04_JPRB,0.82961E+03_JPRB,0.60127E+03_JPRB,0.88210E+03_JPRB,0.11633E+04_JPRB /)  
KB(:, 3,16,11) = (/ &
 & 0.10924E+04_JPRB,0.82745E+03_JPRB,0.60035E+03_JPRB,0.88104E+03_JPRB,0.11615E+04_JPRB /)  
KB(:, 4,16,11) = (/ &
 & 0.10885E+04_JPRB,0.82319E+03_JPRB,0.59934E+03_JPRB,0.87977E+03_JPRB,0.11597E+04_JPRB /)  
KB(:, 5,16,11) = (/ &
 & 0.10838E+04_JPRB,0.82062E+03_JPRB,0.59823E+03_JPRB,0.87823E+03_JPRB,0.11577E+04_JPRB /)  
KB(:, 1,17,11) = (/ &
 & 0.10881E+04_JPRB,0.82385E+03_JPRB,0.60135E+03_JPRB,0.88282E+03_JPRB,0.11656E+04_JPRB /)  
KB(:, 2,17,11) = (/ &
 & 0.10840E+04_JPRB,0.82201E+03_JPRB,0.60094E+03_JPRB,0.88190E+03_JPRB,0.11631E+04_JPRB /)  
KB(:, 3,17,11) = (/ &
 & 0.10809E+04_JPRB,0.81908E+03_JPRB,0.60007E+03_JPRB,0.88083E+03_JPRB,0.11613E+04_JPRB /)  
KB(:, 4,17,11) = (/ &
 & 0.10772E+04_JPRB,0.81792E+03_JPRB,0.59907E+03_JPRB,0.87953E+03_JPRB,0.11595E+04_JPRB /)  
KB(:, 5,17,11) = (/ &
 & 0.10760E+04_JPRB,0.81580E+03_JPRB,0.59806E+03_JPRB,0.87798E+03_JPRB,0.11575E+04_JPRB /)  
KB(:, 1,18,11) = (/ &
 & 0.10780E+04_JPRB,0.81679E+03_JPRB,0.60116E+03_JPRB,0.88267E+03_JPRB,0.11653E+04_JPRB /)  
KB(:, 2,18,11) = (/ &
 & 0.10749E+04_JPRB,0.81512E+03_JPRB,0.60072E+03_JPRB,0.88171E+03_JPRB,0.11629E+04_JPRB /)  
KB(:, 3,18,11) = (/ &
 & 0.10728E+04_JPRB,0.81180E+03_JPRB,0.59983E+03_JPRB,0.88050E+03_JPRB,0.11611E+04_JPRB /)  
KB(:, 4,18,11) = (/ &
 & 0.10707E+04_JPRB,0.81081E+03_JPRB,0.59883E+03_JPRB,0.87944E+03_JPRB,0.11593E+04_JPRB /)  
KB(:, 5,18,11) = (/ &
 & 0.10678E+04_JPRB,0.80905E+03_JPRB,0.59782E+03_JPRB,0.87775E+03_JPRB,0.11574E+04_JPRB /)  
KB(:, 1,19,11) = (/ &
 & 0.10696E+04_JPRB,0.81122E+03_JPRB,0.60101E+03_JPRB,0.88252E+03_JPRB,0.11649E+04_JPRB /)  
KB(:, 2,19,11) = (/ &
 & 0.10692E+04_JPRB,0.80792E+03_JPRB,0.60053E+03_JPRB,0.88155E+03_JPRB,0.11625E+04_JPRB /)  
KB(:, 3,19,11) = (/ &
 & 0.10653E+04_JPRB,0.80791E+03_JPRB,0.59962E+03_JPRB,0.88058E+03_JPRB,0.11609E+04_JPRB /)  
KB(:, 4,19,11) = (/ &
 & 0.10635E+04_JPRB,0.80651E+03_JPRB,0.59853E+03_JPRB,0.87910E+03_JPRB,0.11591E+04_JPRB /)  
KB(:, 5,19,11) = (/ &
 & 0.10626E+04_JPRB,0.80552E+03_JPRB,0.59761E+03_JPRB,0.87753E+03_JPRB,0.11572E+04_JPRB /)  
KB(:, 1,20,11) = (/ &
 & 0.10638E+04_JPRB,0.80613E+03_JPRB,0.60096E+03_JPRB,0.88236E+03_JPRB,0.11646E+04_JPRB /)  
KB(:, 2,20,11) = (/ &
 & 0.10623E+04_JPRB,0.80416E+03_JPRB,0.60035E+03_JPRB,0.88137E+03_JPRB,0.11625E+04_JPRB /)  
KB(:, 3,20,11) = (/ &
 & 0.10590E+04_JPRB,0.80264E+03_JPRB,0.59950E+03_JPRB,0.88013E+03_JPRB,0.11607E+04_JPRB /)  
KB(:, 4,20,11) = (/ &
 & 0.10603E+04_JPRB,0.80308E+03_JPRB,0.59841E+03_JPRB,0.87915E+03_JPRB,0.11587E+04_JPRB /)  
KB(:, 5,20,11) = (/ &
 & 0.10573E+04_JPRB,0.80101E+03_JPRB,0.59740E+03_JPRB,0.87729E+03_JPRB,0.11568E+04_JPRB /)  
KB(:, 1,21,11) = (/ &
 & 0.10580E+04_JPRB,0.80255E+03_JPRB,0.60075E+03_JPRB,0.88233E+03_JPRB,0.11643E+04_JPRB /)  
KB(:, 2,21,11) = (/ &
 & 0.10580E+04_JPRB,0.80172E+03_JPRB,0.60017E+03_JPRB,0.88121E+03_JPRB,0.11623E+04_JPRB /)  
KB(:, 3,21,11) = (/ &
 & 0.10551E+04_JPRB,0.80129E+03_JPRB,0.59922E+03_JPRB,0.87954E+03_JPRB,0.11605E+04_JPRB /)  
KB(:, 4,21,11) = (/ &
 & 0.10544E+04_JPRB,0.79894E+03_JPRB,0.59822E+03_JPRB,0.87866E+03_JPRB,0.11586E+04_JPRB /)  
KB(:, 5,21,11) = (/ &
 & 0.10531E+04_JPRB,0.79850E+03_JPRB,0.59721E+03_JPRB,0.87693E+03_JPRB,0.11568E+04_JPRB /)  
KB(:, 1,22,11) = (/ &
 & 0.10535E+04_JPRB,0.79809E+03_JPRB,0.60064E+03_JPRB,0.88198E+03_JPRB,0.11639E+04_JPRB /)  
KB(:, 2,22,11) = (/ &
 & 0.10534E+04_JPRB,0.79679E+03_JPRB,0.59986E+03_JPRB,0.88098E+03_JPRB,0.11619E+04_JPRB /)  
KB(:, 3,22,11) = (/ &
 & 0.10517E+04_JPRB,0.79764E+03_JPRB,0.59897E+03_JPRB,0.87993E+03_JPRB,0.11602E+04_JPRB /)  
KB(:, 4,22,11) = (/ &
 & 0.10510E+04_JPRB,0.79739E+03_JPRB,0.59797E+03_JPRB,0.87835E+03_JPRB,0.11582E+04_JPRB /)  
KB(:, 5,22,11) = (/ &
 & 0.10492E+04_JPRB,0.79579E+03_JPRB,0.59697E+03_JPRB,0.87672E+03_JPRB,0.11565E+04_JPRB /)  
KB(:, 1,23,11) = (/ &
 & 0.10516E+04_JPRB,0.79606E+03_JPRB,0.60095E+03_JPRB,0.88176E+03_JPRB,0.11633E+04_JPRB /)  
KB(:, 2,23,11) = (/ &
 & 0.10497E+04_JPRB,0.79542E+03_JPRB,0.59972E+03_JPRB,0.88074E+03_JPRB,0.11616E+04_JPRB /)  
KB(:, 3,23,11) = (/ &
 & 0.10482E+04_JPRB,0.79453E+03_JPRB,0.59873E+03_JPRB,0.87952E+03_JPRB,0.11598E+04_JPRB /)  
KB(:, 4,23,11) = (/ &
 & 0.10486E+04_JPRB,0.79431E+03_JPRB,0.59782E+03_JPRB,0.87802E+03_JPRB,0.11579E+04_JPRB /)  
KB(:, 5,23,11) = (/ &
 & 0.10473E+04_JPRB,0.79522E+03_JPRB,0.59672E+03_JPRB,0.87637E+03_JPRB,0.11562E+04_JPRB /)  
KB(:, 1,24,11) = (/ &
 & 0.10467E+04_JPRB,0.79476E+03_JPRB,0.60034E+03_JPRB,0.88154E+03_JPRB,0.11630E+04_JPRB /)  
KB(:, 2,24,11) = (/ &
 & 0.10461E+04_JPRB,0.79357E+03_JPRB,0.59948E+03_JPRB,0.88049E+03_JPRB,0.11613E+04_JPRB /)  
KB(:, 3,24,11) = (/ &
 & 0.10460E+04_JPRB,0.79280E+03_JPRB,0.59849E+03_JPRB,0.87921E+03_JPRB,0.11596E+04_JPRB /)  
KB(:, 4,24,11) = (/ &
 & 0.10457E+04_JPRB,0.79222E+03_JPRB,0.59749E+03_JPRB,0.87768E+03_JPRB,0.11575E+04_JPRB /)  
KB(:, 5,24,11) = (/ &
 & 0.10450E+04_JPRB,0.79193E+03_JPRB,0.59639E+03_JPRB,0.87600E+03_JPRB,0.11558E+04_JPRB /)  
KB(:, 1,25,11) = (/ &
 & 0.10463E+04_JPRB,0.79209E+03_JPRB,0.60015E+03_JPRB,0.88131E+03_JPRB,0.11626E+04_JPRB /)  
KB(:, 2,25,11) = (/ &
 & 0.10455E+04_JPRB,0.79185E+03_JPRB,0.59924E+03_JPRB,0.87983E+03_JPRB,0.11609E+04_JPRB /)  
KB(:, 3,25,11) = (/ &
 & 0.10450E+04_JPRB,0.79214E+03_JPRB,0.59824E+03_JPRB,0.87889E+03_JPRB,0.11590E+04_JPRB /)  
KB(:, 4,25,11) = (/ &
 & 0.10445E+04_JPRB,0.79118E+03_JPRB,0.59725E+03_JPRB,0.87732E+03_JPRB,0.11571E+04_JPRB /)  
KB(:, 5,25,11) = (/ &
 & 0.10428E+04_JPRB,0.79168E+03_JPRB,0.59624E+03_JPRB,0.87561E+03_JPRB,0.11555E+04_JPRB /)  
KB(:, 1,26,11) = (/ &
 & 0.10437E+04_JPRB,0.79093E+03_JPRB,0.59993E+03_JPRB,0.88106E+03_JPRB,0.11624E+04_JPRB /)  
KB(:, 2,26,11) = (/ &
 & 0.10430E+04_JPRB,0.79091E+03_JPRB,0.59898E+03_JPRB,0.87993E+03_JPRB,0.11605E+04_JPRB /)  
KB(:, 3,26,11) = (/ &
 & 0.10430E+04_JPRB,0.79069E+03_JPRB,0.59808E+03_JPRB,0.87852E+03_JPRB,0.11586E+04_JPRB /)  
KB(:, 4,26,11) = (/ &
 & 0.10425E+04_JPRB,0.79087E+03_JPRB,0.59699E+03_JPRB,0.87692E+03_JPRB,0.11569E+04_JPRB /)  
KB(:, 5,26,11) = (/ &
 & 0.10414E+04_JPRB,0.78954E+03_JPRB,0.59598E+03_JPRB,0.87517E+03_JPRB,0.11547E+04_JPRB /)  
KB(:, 1,27,11) = (/ &
 & 0.10423E+04_JPRB,0.79028E+03_JPRB,0.59970E+03_JPRB,0.88080E+03_JPRB,0.11616E+04_JPRB /)  
KB(:, 2,27,11) = (/ &
 & 0.10415E+04_JPRB,0.78939E+03_JPRB,0.59872E+03_JPRB,0.87961E+03_JPRB,0.11600E+04_JPRB /)  
KB(:, 3,27,11) = (/ &
 & 0.10419E+04_JPRB,0.78972E+03_JPRB,0.59773E+03_JPRB,0.87814E+03_JPRB,0.11581E+04_JPRB /)  
KB(:, 4,27,11) = (/ &
 & 0.10405E+04_JPRB,0.78901E+03_JPRB,0.59673E+03_JPRB,0.87651E+03_JPRB,0.11564E+04_JPRB /)  
KB(:, 5,27,11) = (/ &
 & 0.10410E+04_JPRB,0.78880E+03_JPRB,0.59572E+03_JPRB,0.87471E+03_JPRB,0.11546E+04_JPRB /)  
KB(:, 1,28,11) = (/ &
 & 0.10411E+04_JPRB,0.78831E+03_JPRB,0.59945E+03_JPRB,0.88052E+03_JPRB,0.11614E+04_JPRB /)  
KB(:, 2,28,11) = (/ &
 & 0.10402E+04_JPRB,0.78866E+03_JPRB,0.59846E+03_JPRB,0.87954E+03_JPRB,0.11596E+04_JPRB /)  
KB(:, 3,28,11) = (/ &
 & 0.10401E+04_JPRB,0.78798E+03_JPRB,0.59747E+03_JPRB,0.87776E+03_JPRB,0.11577E+04_JPRB /)  
KB(:, 4,28,11) = (/ &
 & 0.10407E+04_JPRB,0.78779E+03_JPRB,0.59647E+03_JPRB,0.87596E+03_JPRB,0.11560E+04_JPRB /)  
KB(:, 5,28,11) = (/ &
 & 0.10407E+04_JPRB,0.78751E+03_JPRB,0.59548E+03_JPRB,0.87425E+03_JPRB,0.11542E+04_JPRB /)  
KB(:, 1,29,11) = (/ &
 & 0.10408E+04_JPRB,0.78876E+03_JPRB,0.59920E+03_JPRB,0.87983E+03_JPRB,0.11608E+04_JPRB /)  
KB(:, 2,29,11) = (/ &
 & 0.10408E+04_JPRB,0.78834E+03_JPRB,0.59820E+03_JPRB,0.87891E+03_JPRB,0.11591E+04_JPRB /)  
KB(:, 3,29,11) = (/ &
 & 0.10387E+04_JPRB,0.78864E+03_JPRB,0.59721E+03_JPRB,0.87735E+03_JPRB,0.11572E+04_JPRB /)  
KB(:, 4,29,11) = (/ &
 & 0.10384E+04_JPRB,0.78778E+03_JPRB,0.59621E+03_JPRB,0.87578E+03_JPRB,0.11555E+04_JPRB /)  
KB(:, 5,29,11) = (/ &
 & 0.10412E+04_JPRB,0.78824E+03_JPRB,0.59524E+03_JPRB,0.87368E+03_JPRB,0.11538E+04_JPRB /)  
KB(:, 1,30,11) = (/ &
 & 0.10383E+04_JPRB,0.78758E+03_JPRB,0.59894E+03_JPRB,0.87992E+03_JPRB,0.11605E+04_JPRB /)  
KB(:, 2,30,11) = (/ &
 & 0.10390E+04_JPRB,0.78755E+03_JPRB,0.59785E+03_JPRB,0.87840E+03_JPRB,0.11584E+04_JPRB /)  
KB(:, 3,30,11) = (/ &
 & 0.10391E+04_JPRB,0.78813E+03_JPRB,0.59695E+03_JPRB,0.87693E+03_JPRB,0.11568E+04_JPRB /)  
KB(:, 4,30,11) = (/ &
 & 0.10384E+04_JPRB,0.78683E+03_JPRB,0.59594E+03_JPRB,0.87519E+03_JPRB,0.11551E+04_JPRB /)  
KB(:, 5,30,11) = (/ &
 & 0.10388E+04_JPRB,0.78660E+03_JPRB,0.59501E+03_JPRB,0.87341E+03_JPRB,0.11534E+04_JPRB /)  
KB(:, 1,31,11) = (/ &
 & 0.10376E+04_JPRB,0.78640E+03_JPRB,0.59867E+03_JPRB,0.87959E+03_JPRB,0.11601E+04_JPRB /)  
KB(:, 2,31,11) = (/ &
 & 0.10381E+04_JPRB,0.78687E+03_JPRB,0.59768E+03_JPRB,0.87813E+03_JPRB,0.11581E+04_JPRB /)  
KB(:, 3,31,11) = (/ &
 & 0.10369E+04_JPRB,0.78736E+03_JPRB,0.59668E+03_JPRB,0.87650E+03_JPRB,0.11564E+04_JPRB /)  
KB(:, 4,31,11) = (/ &
 & 0.10380E+04_JPRB,0.78738E+03_JPRB,0.59577E+03_JPRB,0.87483E+03_JPRB,0.11546E+04_JPRB /)  
KB(:, 5,31,11) = (/ &
 & 0.10391E+04_JPRB,0.78671E+03_JPRB,0.59479E+03_JPRB,0.87299E+03_JPRB,0.11532E+04_JPRB /)  
KB(:, 1,32,11) = (/ &
 & 0.10371E+04_JPRB,0.78531E+03_JPRB,0.59840E+03_JPRB,0.87936E+03_JPRB,0.11596E+04_JPRB /)  
KB(:, 2,32,11) = (/ &
 & 0.10383E+04_JPRB,0.78734E+03_JPRB,0.59742E+03_JPRB,0.87771E+03_JPRB,0.11576E+04_JPRB /)  
KB(:, 3,32,11) = (/ &
 & 0.10363E+04_JPRB,0.78691E+03_JPRB,0.59641E+03_JPRB,0.87605E+03_JPRB,0.11559E+04_JPRB /)  
KB(:, 4,32,11) = (/ &
 & 0.10373E+04_JPRB,0.78648E+03_JPRB,0.59543E+03_JPRB,0.87420E+03_JPRB,0.11542E+04_JPRB /)  
KB(:, 5,32,11) = (/ &
 & 0.10376E+04_JPRB,0.78617E+03_JPRB,0.59455E+03_JPRB,0.87256E+03_JPRB,0.11529E+04_JPRB /)  
KB(:, 1,33,11) = (/ &
 & 0.10366E+04_JPRB,0.78725E+03_JPRB,0.59814E+03_JPRB,0.87885E+03_JPRB,0.11591E+04_JPRB /)  
KB(:, 2,33,11) = (/ &
 & 0.10366E+04_JPRB,0.78694E+03_JPRB,0.59715E+03_JPRB,0.87729E+03_JPRB,0.11572E+04_JPRB /)  
KB(:, 3,33,11) = (/ &
 & 0.10365E+04_JPRB,0.78534E+03_JPRB,0.59614E+03_JPRB,0.87545E+03_JPRB,0.11555E+04_JPRB /)  
KB(:, 4,33,11) = (/ &
 & 0.10377E+04_JPRB,0.78705E+03_JPRB,0.59518E+03_JPRB,0.87362E+03_JPRB,0.11536E+04_JPRB /)  
KB(:, 5,33,11) = (/ &
 & 0.10381E+04_JPRB,0.78546E+03_JPRB,0.59428E+03_JPRB,0.87201E+03_JPRB,0.11526E+04_JPRB /)  
KB(:, 1,34,11) = (/ &
 & 0.10370E+04_JPRB,0.78547E+03_JPRB,0.59791E+03_JPRB,0.87837E+03_JPRB,0.11586E+04_JPRB /)  
KB(:, 2,34,11) = (/ &
 & 0.10369E+04_JPRB,0.78635E+03_JPRB,0.59683E+03_JPRB,0.87691E+03_JPRB,0.11568E+04_JPRB /)  
KB(:, 3,34,11) = (/ &
 & 0.10373E+04_JPRB,0.78607E+03_JPRB,0.59591E+03_JPRB,0.87516E+03_JPRB,0.11551E+04_JPRB /)  
KB(:, 4,34,11) = (/ &
 & 0.10371E+04_JPRB,0.78696E+03_JPRB,0.59498E+03_JPRB,0.87338E+03_JPRB,0.11534E+04_JPRB /)  
KB(:, 5,34,11) = (/ &
 & 0.10366E+04_JPRB,0.78538E+03_JPRB,0.59374E+03_JPRB,0.87179E+03_JPRB,0.11524E+04_JPRB /)  
KB(:, 1,35,11) = (/ &
 & 0.10371E+04_JPRB,0.78681E+03_JPRB,0.59778E+03_JPRB,0.87830E+03_JPRB,0.11583E+04_JPRB /)  
KB(:, 2,35,11) = (/ &
 & 0.10367E+04_JPRB,0.78665E+03_JPRB,0.59678E+03_JPRB,0.87669E+03_JPRB,0.11566E+04_JPRB /)  
KB(:, 3,35,11) = (/ &
 & 0.10363E+04_JPRB,0.78613E+03_JPRB,0.59569E+03_JPRB,0.87491E+03_JPRB,0.11549E+04_JPRB /)  
KB(:, 4,35,11) = (/ &
 & 0.10364E+04_JPRB,0.78668E+03_JPRB,0.59487E+03_JPRB,0.87304E+03_JPRB,0.11533E+04_JPRB /)  
KB(:, 5,35,11) = (/ &
 & 0.10370E+04_JPRB,0.78641E+03_JPRB,0.59363E+03_JPRB,0.87159E+03_JPRB,0.11523E+04_JPRB /)  
KB(:, 1,36,11) = (/ &
 & 0.10366E+04_JPRB,0.78595E+03_JPRB,0.59775E+03_JPRB,0.87827E+03_JPRB,0.11583E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART28',1,ZHOOK_HANDLE)
END SUBROUTINE PART28


SUBROUTINE PART29

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART29',0,ZHOOK_HANDLE)


KB(:, 2,36,11) = (/ &
 & 0.10367E+04_JPRB,0.78568E+03_JPRB,0.59676E+03_JPRB,0.87652E+03_JPRB,0.11565E+04_JPRB /)  
KB(:, 3,36,11) = (/ &
 & 0.10363E+04_JPRB,0.78600E+03_JPRB,0.59575E+03_JPRB,0.87487E+03_JPRB,0.11548E+04_JPRB /)  
KB(:, 4,36,11) = (/ &
 & 0.10370E+04_JPRB,0.78596E+03_JPRB,0.59503E+03_JPRB,0.87314E+03_JPRB,0.11533E+04_JPRB /)  
KB(:, 5,36,11) = (/ &
 & 0.10356E+04_JPRB,0.78546E+03_JPRB,0.59359E+03_JPRB,0.87116E+03_JPRB,0.11523E+04_JPRB /)  
KB(:, 1,37,11) = (/ &
 & 0.10367E+04_JPRB,0.78524E+03_JPRB,0.59788E+03_JPRB,0.87847E+03_JPRB,0.11586E+04_JPRB /)  
KB(:, 2,37,11) = (/ &
 & 0.10373E+04_JPRB,0.78580E+03_JPRB,0.59689E+03_JPRB,0.87687E+03_JPRB,0.11567E+04_JPRB /)  
KB(:, 3,37,11) = (/ &
 & 0.10369E+04_JPRB,0.78554E+03_JPRB,0.59588E+03_JPRB,0.87512E+03_JPRB,0.11550E+04_JPRB /)  
KB(:, 4,37,11) = (/ &
 & 0.10372E+04_JPRB,0.78551E+03_JPRB,0.59495E+03_JPRB,0.87335E+03_JPRB,0.11534E+04_JPRB /)  
KB(:, 5,37,11) = (/ &
 & 0.10364E+04_JPRB,0.78631E+03_JPRB,0.59378E+03_JPRB,0.87175E+03_JPRB,0.11524E+04_JPRB /)  
KB(:, 1,38,11) = (/ &
 & 0.10372E+04_JPRB,0.78574E+03_JPRB,0.59801E+03_JPRB,0.87867E+03_JPRB,0.11588E+04_JPRB /)  
KB(:, 2,38,11) = (/ &
 & 0.10364E+04_JPRB,0.78476E+03_JPRB,0.59702E+03_JPRB,0.87710E+03_JPRB,0.11570E+04_JPRB /)  
KB(:, 3,38,11) = (/ &
 & 0.10351E+04_JPRB,0.78521E+03_JPRB,0.59593E+03_JPRB,0.87537E+03_JPRB,0.11553E+04_JPRB /)  
KB(:, 4,38,11) = (/ &
 & 0.10362E+04_JPRB,0.78507E+03_JPRB,0.59507E+03_JPRB,0.87344E+03_JPRB,0.11536E+04_JPRB /)  
KB(:, 5,38,11) = (/ &
 & 0.10371E+04_JPRB,0.78635E+03_JPRB,0.59400E+03_JPRB,0.87197E+03_JPRB,0.11525E+04_JPRB /)  
KB(:, 1,39,11) = (/ &
 & 0.10359E+04_JPRB,0.78601E+03_JPRB,0.59815E+03_JPRB,0.87888E+03_JPRB,0.11591E+04_JPRB /)  
KB(:, 2,39,11) = (/ &
 & 0.10375E+04_JPRB,0.78669E+03_JPRB,0.59716E+03_JPRB,0.87732E+03_JPRB,0.11572E+04_JPRB /)  
KB(:, 3,39,11) = (/ &
 & 0.10350E+04_JPRB,0.78597E+03_JPRB,0.59615E+03_JPRB,0.87562E+03_JPRB,0.11555E+04_JPRB /)  
KB(:, 4,39,11) = (/ &
 & 0.10366E+04_JPRB,0.78524E+03_JPRB,0.59519E+03_JPRB,0.87365E+03_JPRB,0.11538E+04_JPRB /)  
KB(:, 5,39,11) = (/ &
 & 0.10373E+04_JPRB,0.78605E+03_JPRB,0.59422E+03_JPRB,0.87205E+03_JPRB,0.11526E+04_JPRB /)  
KB(:, 1,40,11) = (/ &
 & 0.10361E+04_JPRB,0.78559E+03_JPRB,0.59838E+03_JPRB,0.87949E+03_JPRB,0.11596E+04_JPRB /)  
KB(:, 2,40,11) = (/ &
 & 0.10364E+04_JPRB,0.78533E+03_JPRB,0.59740E+03_JPRB,0.87771E+03_JPRB,0.11576E+04_JPRB /)  
KB(:, 3,40,11) = (/ &
 & 0.10357E+04_JPRB,0.78567E+03_JPRB,0.59640E+03_JPRB,0.87605E+03_JPRB,0.11559E+04_JPRB /)  
KB(:, 4,40,11) = (/ &
 & 0.10354E+04_JPRB,0.78518E+03_JPRB,0.59541E+03_JPRB,0.87434E+03_JPRB,0.11542E+04_JPRB /)  
KB(:, 5,40,11) = (/ &
 & 0.10361E+04_JPRB,0.78553E+03_JPRB,0.59453E+03_JPRB,0.87244E+03_JPRB,0.11529E+04_JPRB /)  
KB(:, 1,41,11) = (/ &
 & 0.10352E+04_JPRB,0.78554E+03_JPRB,0.59863E+03_JPRB,0.87958E+03_JPRB,0.11601E+04_JPRB /)  
KB(:, 2,41,11) = (/ &
 & 0.10361E+04_JPRB,0.78611E+03_JPRB,0.59765E+03_JPRB,0.87811E+03_JPRB,0.11581E+04_JPRB /)  
KB(:, 3,41,11) = (/ &
 & 0.10357E+04_JPRB,0.78586E+03_JPRB,0.59665E+03_JPRB,0.87648E+03_JPRB,0.11564E+04_JPRB /)  
KB(:, 4,41,11) = (/ &
 & 0.10369E+04_JPRB,0.78632E+03_JPRB,0.59556E+03_JPRB,0.87469E+03_JPRB,0.11547E+04_JPRB /)  
KB(:, 5,41,11) = (/ &
 & 0.10372E+04_JPRB,0.78631E+03_JPRB,0.59476E+03_JPRB,0.87298E+03_JPRB,0.11532E+04_JPRB /)  
KB(:, 1,42,11) = (/ &
 & 0.10352E+04_JPRB,0.78620E+03_JPRB,0.59889E+03_JPRB,0.87990E+03_JPRB,0.11605E+04_JPRB /)  
KB(:, 2,42,11) = (/ &
 & 0.10362E+04_JPRB,0.78666E+03_JPRB,0.59790E+03_JPRB,0.87851E+03_JPRB,0.11586E+04_JPRB /)  
KB(:, 3,42,11) = (/ &
 & 0.10358E+04_JPRB,0.78476E+03_JPRB,0.59691E+03_JPRB,0.87691E+03_JPRB,0.11568E+04_JPRB /)  
KB(:, 4,42,11) = (/ &
 & 0.10367E+04_JPRB,0.78534E+03_JPRB,0.59590E+03_JPRB,0.87517E+03_JPRB,0.11551E+04_JPRB /)  
KB(:, 5,42,11) = (/ &
 & 0.10374E+04_JPRB,0.78497E+03_JPRB,0.59497E+03_JPRB,0.87339E+03_JPRB,0.11533E+04_JPRB /)  
KB(:, 1,43,11) = (/ &
 & 0.10357E+04_JPRB,0.78569E+03_JPRB,0.59919E+03_JPRB,0.88014E+03_JPRB,0.11611E+04_JPRB /)  
KB(:, 2,43,11) = (/ &
 & 0.10384E+04_JPRB,0.78603E+03_JPRB,0.59811E+03_JPRB,0.87910E+03_JPRB,0.11592E+04_JPRB /)  
KB(:, 3,43,11) = (/ &
 & 0.10376E+04_JPRB,0.78685E+03_JPRB,0.59731E+03_JPRB,0.87742E+03_JPRB,0.11573E+04_JPRB /)  
KB(:, 4,43,11) = (/ &
 & 0.10368E+04_JPRB,0.78484E+03_JPRB,0.59612E+03_JPRB,0.87573E+03_JPRB,0.11555E+04_JPRB /)  
KB(:, 5,43,11) = (/ &
 & 0.10371E+04_JPRB,0.78612E+03_JPRB,0.59525E+03_JPRB,0.87389E+03_JPRB,0.11539E+04_JPRB /)  
KB(:, 1,44,11) = (/ &
 & 0.10362E+04_JPRB,0.78531E+03_JPRB,0.59952E+03_JPRB,0.88052E+03_JPRB,0.11615E+04_JPRB /)  
KB(:, 2,44,11) = (/ &
 & 0.10357E+04_JPRB,0.78506E+03_JPRB,0.59854E+03_JPRB,0.87945E+03_JPRB,0.11599E+04_JPRB /)  
KB(:, 3,44,11) = (/ &
 & 0.10347E+04_JPRB,0.78494E+03_JPRB,0.59755E+03_JPRB,0.87796E+03_JPRB,0.11576E+04_JPRB /)  
KB(:, 4,44,11) = (/ &
 & 0.10360E+04_JPRB,0.78599E+03_JPRB,0.59655E+03_JPRB,0.87632E+03_JPRB,0.11562E+04_JPRB /)  
KB(:, 5,44,11) = (/ &
 & 0.10364E+04_JPRB,0.78610E+03_JPRB,0.59556E+03_JPRB,0.87451E+03_JPRB,0.11545E+04_JPRB /)  
KB(:, 1,45,11) = (/ &
 & 0.10355E+04_JPRB,0.78552E+03_JPRB,0.59982E+03_JPRB,0.88100E+03_JPRB,0.11621E+04_JPRB /)  
KB(:, 2,45,11) = (/ &
 & 0.10357E+04_JPRB,0.78527E+03_JPRB,0.59887E+03_JPRB,0.87975E+03_JPRB,0.11605E+04_JPRB /)  
KB(:, 3,45,11) = (/ &
 & 0.10358E+04_JPRB,0.78432E+03_JPRB,0.59788E+03_JPRB,0.87848E+03_JPRB,0.11586E+04_JPRB /)  
KB(:, 4,45,11) = (/ &
 & 0.10358E+04_JPRB,0.78597E+03_JPRB,0.59689E+03_JPRB,0.87689E+03_JPRB,0.11568E+04_JPRB /)  
KB(:, 5,45,11) = (/ &
 & 0.10353E+04_JPRB,0.78525E+03_JPRB,0.59589E+03_JPRB,0.87514E+03_JPRB,0.11551E+04_JPRB /)  
KB(:, 1,46,11) = (/ &
 & 0.10358E+04_JPRB,0.78503E+03_JPRB,0.60010E+03_JPRB,0.88136E+03_JPRB,0.11629E+04_JPRB /)  
KB(:, 2,46,11) = (/ &
 & 0.10366E+04_JPRB,0.78667E+03_JPRB,0.59923E+03_JPRB,0.88004E+03_JPRB,0.11611E+04_JPRB /)  
KB(:, 3,46,11) = (/ &
 & 0.10372E+04_JPRB,0.78560E+03_JPRB,0.59824E+03_JPRB,0.87915E+03_JPRB,0.11593E+04_JPRB /)  
KB(:, 4,46,11) = (/ &
 & 0.10348E+04_JPRB,0.78513E+03_JPRB,0.59725E+03_JPRB,0.87748E+03_JPRB,0.11574E+04_JPRB /)  
KB(:, 5,46,11) = (/ &
 & 0.10372E+04_JPRB,0.78595E+03_JPRB,0.59625E+03_JPRB,0.87592E+03_JPRB,0.11557E+04_JPRB /)  
KB(:, 1,47,11) = (/ &
 & 0.10352E+04_JPRB,0.78466E+03_JPRB,0.60059E+03_JPRB,0.88175E+03_JPRB,0.11637E+04_JPRB /)  
KB(:, 2,47,11) = (/ &
 & 0.10362E+04_JPRB,0.78477E+03_JPRB,0.59970E+03_JPRB,0.88075E+03_JPRB,0.11618E+04_JPRB /)  
KB(:, 3,47,11) = (/ &
 & 0.10362E+04_JPRB,0.78559E+03_JPRB,0.59863E+03_JPRB,0.87958E+03_JPRB,0.11601E+04_JPRB /)  
KB(:, 4,47,11) = (/ &
 & 0.10356E+04_JPRB,0.78476E+03_JPRB,0.59765E+03_JPRB,0.87812E+03_JPRB,0.11581E+04_JPRB /)  
KB(:, 5,47,11) = (/ &
 & 0.10361E+04_JPRB,0.78428E+03_JPRB,0.59665E+03_JPRB,0.87649E+03_JPRB,0.11564E+04_JPRB /)  
KB(:, 1,48,11) = (/ &
 & 0.10354E+04_JPRB,0.78500E+03_JPRB,0.60042E+03_JPRB,0.88214E+03_JPRB,0.11645E+04_JPRB /)  
KB(:, 2,48,11) = (/ &
 & 0.10348E+04_JPRB,0.78582E+03_JPRB,0.59995E+03_JPRB,0.88117E+03_JPRB,0.11625E+04_JPRB /)  
KB(:, 3,48,11) = (/ &
 & 0.10353E+04_JPRB,0.78569E+03_JPRB,0.59903E+03_JPRB,0.87942E+03_JPRB,0.11608E+04_JPRB /)  
KB(:, 4,48,11) = (/ &
 & 0.10359E+04_JPRB,0.78569E+03_JPRB,0.59804E+03_JPRB,0.87873E+03_JPRB,0.11589E+04_JPRB /)  
KB(:, 5,48,11) = (/ &
 & 0.10354E+04_JPRB,0.78509E+03_JPRB,0.59705E+03_JPRB,0.87716E+03_JPRB,0.11570E+04_JPRB /)  
KB(:, 1,49,11) = (/ &
 & 0.10362E+04_JPRB,0.78463E+03_JPRB,0.60042E+03_JPRB,0.88242E+03_JPRB,0.11657E+04_JPRB /)  
KB(:, 2,49,11) = (/ &
 & 0.10367E+04_JPRB,0.78580E+03_JPRB,0.60023E+03_JPRB,0.88156E+03_JPRB,0.11633E+04_JPRB /)  
KB(:, 3,49,11) = (/ &
 & 0.10373E+04_JPRB,0.78533E+03_JPRB,0.59942E+03_JPRB,0.88054E+03_JPRB,0.11615E+04_JPRB /)  
KB(:, 4,49,11) = (/ &
 & 0.10373E+04_JPRB,0.78462E+03_JPRB,0.59844E+03_JPRB,0.87918E+03_JPRB,0.11595E+04_JPRB /)  
KB(:, 5,49,11) = (/ &
 & 0.10370E+04_JPRB,0.78532E+03_JPRB,0.59736E+03_JPRB,0.87781E+03_JPRB,0.11578E+04_JPRB /)  
KB(:, 1,50,11) = (/ &
 & 0.10356E+04_JPRB,0.78474E+03_JPRB,0.60056E+03_JPRB,0.88267E+03_JPRB,0.11666E+04_JPRB /)  
KB(:, 2,50,11) = (/ &
 & 0.10370E+04_JPRB,0.78497E+03_JPRB,0.60046E+03_JPRB,0.88192E+03_JPRB,0.11642E+04_JPRB /)  
KB(:, 3,50,11) = (/ &
 & 0.10348E+04_JPRB,0.78508E+03_JPRB,0.59977E+03_JPRB,0.88094E+03_JPRB,0.11634E+04_JPRB /)  
KB(:, 4,50,11) = (/ &
 & 0.10352E+04_JPRB,0.78473E+03_JPRB,0.59881E+03_JPRB,0.87954E+03_JPRB,0.11604E+04_JPRB /)  
KB(:, 5,50,11) = (/ &
 & 0.10360E+04_JPRB,0.78437E+03_JPRB,0.59782E+03_JPRB,0.87840E+03_JPRB,0.11585E+04_JPRB /)  
KB(:, 1,51,11) = (/ &
 & 0.10365E+04_JPRB,0.78532E+03_JPRB,0.60054E+03_JPRB,0.88306E+03_JPRB,0.11674E+04_JPRB /)  
KB(:, 2,51,11) = (/ &
 & 0.10360E+04_JPRB,0.78555E+03_JPRB,0.60046E+03_JPRB,0.88226E+03_JPRB,0.11651E+04_JPRB /)  
KB(:, 3,51,11) = (/ &
 & 0.10359E+04_JPRB,0.78508E+03_JPRB,0.60006E+03_JPRB,0.88131E+03_JPRB,0.11628E+04_JPRB /)  
KB(:, 4,51,11) = (/ &
 & 0.10359E+04_JPRB,0.78554E+03_JPRB,0.59917E+03_JPRB,0.88011E+03_JPRB,0.11610E+04_JPRB /)  
KB(:, 5,51,11) = (/ &
 & 0.10363E+04_JPRB,0.78507E+03_JPRB,0.59818E+03_JPRB,0.87894E+03_JPRB,0.11592E+04_JPRB /)  
KB(:, 1,52,11) = (/ &
 & 0.10357E+04_JPRB,0.78531E+03_JPRB,0.60048E+03_JPRB,0.88333E+03_JPRB,0.11687E+04_JPRB /)  
KB(:, 2,52,11) = (/ &
 & 0.10368E+04_JPRB,0.78554E+03_JPRB,0.60053E+03_JPRB,0.88249E+03_JPRB,0.11660E+04_JPRB /)  
KB(:, 3,52,11) = (/ &
 & 0.10362E+04_JPRB,0.78601E+03_JPRB,0.60037E+03_JPRB,0.88166E+03_JPRB,0.11635E+04_JPRB /)  
KB(:, 4,52,11) = (/ &
 & 0.10354E+04_JPRB,0.78507E+03_JPRB,0.59952E+03_JPRB,0.88066E+03_JPRB,0.11617E+04_JPRB /)  
KB(:, 5,52,11) = (/ &
 & 0.10363E+04_JPRB,0.78565E+03_JPRB,0.59854E+03_JPRB,0.87959E+03_JPRB,0.11599E+04_JPRB /)  
KB(:, 1,53,11) = (/ &
 & 0.10366E+04_JPRB,0.78460E+03_JPRB,0.60030E+03_JPRB,0.88415E+03_JPRB,0.11699E+04_JPRB /)  
KB(:, 2,53,11) = (/ &
 & 0.10366E+04_JPRB,0.78400E+03_JPRB,0.60056E+03_JPRB,0.88262E+03_JPRB,0.11668E+04_JPRB /)  
KB(:, 3,53,11) = (/ &
 & 0.10358E+04_JPRB,0.78459E+03_JPRB,0.60039E+03_JPRB,0.88202E+03_JPRB,0.11644E+04_JPRB /)  
KB(:, 4,53,11) = (/ &
 & 0.10348E+04_JPRB,0.78471E+03_JPRB,0.59985E+03_JPRB,0.88104E+03_JPRB,0.11623E+04_JPRB /)  
KB(:, 5,53,11) = (/ &
 & 0.10366E+04_JPRB,0.78577E+03_JPRB,0.59891E+03_JPRB,0.87992E+03_JPRB,0.11606E+04_JPRB /)  
KB(:, 1,54,11) = (/ &
 & 0.10355E+04_JPRB,0.78471E+03_JPRB,0.60033E+03_JPRB,0.88501E+03_JPRB,0.11708E+04_JPRB /)  
KB(:, 2,54,11) = (/ &
 & 0.10360E+04_JPRB,0.78494E+03_JPRB,0.60053E+03_JPRB,0.88313E+03_JPRB,0.11678E+04_JPRB /)  
KB(:, 3,54,11) = (/ &
 & 0.10360E+04_JPRB,0.78671E+03_JPRB,0.60047E+03_JPRB,0.88230E+03_JPRB,0.11652E+04_JPRB /)  
KB(:, 4,54,11) = (/ &
 & 0.10355E+04_JPRB,0.78588E+03_JPRB,0.60010E+03_JPRB,0.88137E+03_JPRB,0.11629E+04_JPRB /)  
KB(:, 5,54,11) = (/ &
 & 0.10357E+04_JPRB,0.78517E+03_JPRB,0.59924E+03_JPRB,0.88032E+03_JPRB,0.11612E+04_JPRB /)  
KB(:, 1,55,11) = (/ &
 & 0.10357E+04_JPRB,0.78506E+03_JPRB,0.60035E+03_JPRB,0.88567E+03_JPRB,0.11714E+04_JPRB /)  
KB(:, 2,55,11) = (/ &
 & 0.10357E+04_JPRB,0.78518E+03_JPRB,0.60047E+03_JPRB,0.88349E+03_JPRB,0.11688E+04_JPRB /)  
KB(:, 3,55,11) = (/ &
 & 0.10361E+04_JPRB,0.78517E+03_JPRB,0.60053E+03_JPRB,0.88250E+03_JPRB,0.11660E+04_JPRB /)  
KB(:, 4,55,11) = (/ &
 & 0.10357E+04_JPRB,0.78529E+03_JPRB,0.60029E+03_JPRB,0.88168E+03_JPRB,0.11636E+04_JPRB /)  
KB(:, 5,55,11) = (/ &
 & 0.10360E+04_JPRB,0.78529E+03_JPRB,0.59954E+03_JPRB,0.88068E+03_JPRB,0.11617E+04_JPRB /)  
KB(:, 1,56,11) = (/ &
 & 0.10361E+04_JPRB,0.78494E+03_JPRB,0.60049E+03_JPRB,0.88607E+03_JPRB,0.11718E+04_JPRB /)  
KB(:, 2,56,11) = (/ &
 & 0.10360E+04_JPRB,0.78482E+03_JPRB,0.60030E+03_JPRB,0.88410E+03_JPRB,0.11698E+04_JPRB /)  
KB(:, 3,56,11) = (/ &
 & 0.10354E+04_JPRB,0.78493E+03_JPRB,0.60056E+03_JPRB,0.88273E+03_JPRB,0.11667E+04_JPRB /)  
KB(:, 4,56,11) = (/ &
 & 0.10357E+04_JPRB,0.78552E+03_JPRB,0.60038E+03_JPRB,0.88199E+03_JPRB,0.11645E+04_JPRB /)  
KB(:, 5,56,11) = (/ &
 & 0.10357E+04_JPRB,0.78517E+03_JPRB,0.59983E+03_JPRB,0.88101E+03_JPRB,0.11624E+04_JPRB /)  
KB(:, 1,57,11) = (/ &
 & 0.10357E+04_JPRB,0.78588E+03_JPRB,0.60099E+03_JPRB,0.88686E+03_JPRB,0.11725E+04_JPRB /)  
KB(:, 2,57,11) = (/ &
 & 0.10366E+04_JPRB,0.78458E+03_JPRB,0.60033E+03_JPRB,0.88491E+03_JPRB,0.11707E+04_JPRB /)  
KB(:, 3,57,11) = (/ &
 & 0.10366E+04_JPRB,0.78481E+03_JPRB,0.60053E+03_JPRB,0.88335E+03_JPRB,0.11676E+04_JPRB /)  
KB(:, 4,57,11) = (/ &
 & 0.10358E+04_JPRB,0.78611E+03_JPRB,0.60046E+03_JPRB,0.88227E+03_JPRB,0.11650E+04_JPRB /)  
KB(:, 5,57,11) = (/ &
 & 0.10355E+04_JPRB,0.78599E+03_JPRB,0.60008E+03_JPRB,0.88133E+03_JPRB,0.11630E+04_JPRB /)  
KB(:, 1,58,11) = (/ &
 & 0.10363E+04_JPRB,0.78576E+03_JPRB,0.60143E+03_JPRB,0.88764E+03_JPRB,0.11733E+04_JPRB /)  
KB(:, 2,58,11) = (/ &
 & 0.10354E+04_JPRB,0.78611E+03_JPRB,0.60042E+03_JPRB,0.88557E+03_JPRB,0.11713E+04_JPRB /)  
KB(:, 3,58,11) = (/ &
 & 0.10363E+04_JPRB,0.78576E+03_JPRB,0.60048E+03_JPRB,0.88329E+03_JPRB,0.11686E+04_JPRB /)  
KB(:, 4,58,11) = (/ &
 & 0.10364E+04_JPRB,0.78505E+03_JPRB,0.60052E+03_JPRB,0.88247E+03_JPRB,0.11659E+04_JPRB /)  
KB(:, 5,58,11) = (/ &
 & 0.10357E+04_JPRB,0.78552E+03_JPRB,0.60026E+03_JPRB,0.88163E+03_JPRB,0.11633E+04_JPRB /)  
KB(:, 1,59,11) = (/ &
 & 0.10354E+04_JPRB,0.78634E+03_JPRB,0.60176E+03_JPRB,0.88797E+03_JPRB,0.11736E+04_JPRB /)  
KB(:, 2,59,11) = (/ &
 & 0.10350E+04_JPRB,0.78505E+03_JPRB,0.60038E+03_JPRB,0.88577E+03_JPRB,0.11715E+04_JPRB /)  
KB(:, 3,59,11) = (/ &
 & 0.10360E+04_JPRB,0.78469E+03_JPRB,0.60046E+03_JPRB,0.88358E+03_JPRB,0.11703E+04_JPRB /)  
KB(:, 4,59,11) = (/ &
 & 0.10357E+04_JPRB,0.78493E+03_JPRB,0.60045E+03_JPRB,0.88254E+03_JPRB,0.11662E+04_JPRB /)  
KB(:, 5,59,11) = (/ &
 & 0.10366E+04_JPRB,0.78516E+03_JPRB,0.60041E+03_JPRB,0.88174E+03_JPRB,0.11637E+04_JPRB /)  
KB(:, 1,13,12) = (/ &
 & 0.11535E+04_JPRB,0.87955E+03_JPRB,0.60434E+03_JPRB,0.88744E+03_JPRB,0.11710E+04_JPRB /)  
KB(:, 2,13,12) = (/ &
 & 0.11485E+04_JPRB,0.86886E+03_JPRB,0.60369E+03_JPRB,0.88598E+03_JPRB,0.11697E+04_JPRB /)  
KB(:, 3,13,12) = (/ &
 & 0.11395E+04_JPRB,0.86441E+03_JPRB,0.60332E+03_JPRB,0.88477E+03_JPRB,0.11680E+04_JPRB /)  
KB(:, 4,13,12) = (/ &
 & 0.11350E+04_JPRB,0.86216E+03_JPRB,0.60276E+03_JPRB,0.88294E+03_JPRB,0.11659E+04_JPRB /)  
KB(:, 5,13,12) = (/ &
 & 0.11237E+04_JPRB,0.85514E+03_JPRB,0.60186E+03_JPRB,0.88131E+03_JPRB,0.11640E+04_JPRB /)  
KB(:, 1,14,12) = (/ &
 & 0.11312E+04_JPRB,0.85960E+03_JPRB,0.60391E+03_JPRB,0.88683E+03_JPRB,0.11708E+04_JPRB /)  
KB(:, 2,14,12) = (/ &
 & 0.11248E+04_JPRB,0.85192E+03_JPRB,0.60329E+03_JPRB,0.88591E+03_JPRB,0.11696E+04_JPRB /)  
KB(:, 3,14,12) = (/ &
 & 0.11210E+04_JPRB,0.84824E+03_JPRB,0.60297E+03_JPRB,0.88444E+03_JPRB,0.11678E+04_JPRB /)  
KB(:, 4,14,12) = (/ &
 & 0.11139E+04_JPRB,0.84322E+03_JPRB,0.60241E+03_JPRB,0.88264E+03_JPRB,0.11657E+04_JPRB /)  
KB(:, 5,14,12) = (/ &
 & 0.11123E+04_JPRB,0.84158E+03_JPRB,0.60150E+03_JPRB,0.88104E+03_JPRB,0.11639E+04_JPRB /)  
KB(:, 1,15,12) = (/ &
 & 0.11159E+04_JPRB,0.84414E+03_JPRB,0.60344E+03_JPRB,0.88657E+03_JPRB,0.11715E+04_JPRB /)  
KB(:, 2,15,12) = (/ &
 & 0.11106E+04_JPRB,0.84043E+03_JPRB,0.60296E+03_JPRB,0.88568E+03_JPRB,0.11695E+04_JPRB /)  
KB(:, 3,15,12) = (/ &
 & 0.11018E+04_JPRB,0.83588E+03_JPRB,0.60268E+03_JPRB,0.88413E+03_JPRB,0.11676E+04_JPRB /)  
KB(:, 4,15,12) = (/ &
 & 0.10976E+04_JPRB,0.83213E+03_JPRB,0.60210E+03_JPRB,0.88235E+03_JPRB,0.11655E+04_JPRB /)  
KB(:, 5,15,12) = (/ &
 & 0.10965E+04_JPRB,0.83273E+03_JPRB,0.60128E+03_JPRB,0.88077E+03_JPRB,0.11639E+04_JPRB /)  
KB(:, 1,16,12) = (/ &
 & 0.11003E+04_JPRB,0.83414E+03_JPRB,0.60325E+03_JPRB,0.88634E+03_JPRB,0.11705E+04_JPRB /)  
KB(:, 2,16,12) = (/ &
 & 0.10991E+04_JPRB,0.82921E+03_JPRB,0.60259E+03_JPRB,0.88546E+03_JPRB,0.11694E+04_JPRB /)  
KB(:, 3,16,12) = (/ &
 & 0.10955E+04_JPRB,0.82665E+03_JPRB,0.60243E+03_JPRB,0.88384E+03_JPRB,0.11674E+04_JPRB /)  
KB(:, 4,16,12) = (/ &
 & 0.10851E+04_JPRB,0.82401E+03_JPRB,0.60183E+03_JPRB,0.88207E+03_JPRB,0.11653E+04_JPRB /)  
KB(:, 5,16,12) = (/ &
 & 0.10849E+04_JPRB,0.82356E+03_JPRB,0.60085E+03_JPRB,0.88053E+03_JPRB,0.11635E+04_JPRB /)  
KB(:, 1,17,12) = (/ &
 & 0.10876E+04_JPRB,0.82527E+03_JPRB,0.60299E+03_JPRB,0.88614E+03_JPRB,0.11702E+04_JPRB /)  
KB(:, 2,17,12) = (/ &
 & 0.10859E+04_JPRB,0.82135E+03_JPRB,0.60250E+03_JPRB,0.88526E+03_JPRB,0.11692E+04_JPRB /)  
KB(:, 3,17,12) = (/ &
 & 0.10841E+04_JPRB,0.81891E+03_JPRB,0.60222E+03_JPRB,0.88356E+03_JPRB,0.11671E+04_JPRB /)  
KB(:, 4,17,12) = (/ &
 & 0.10784E+04_JPRB,0.81708E+03_JPRB,0.60159E+03_JPRB,0.88183E+03_JPRB,0.11651E+04_JPRB /)  
KB(:, 5,17,12) = (/ &
 & 0.10763E+04_JPRB,0.81350E+03_JPRB,0.60170E+03_JPRB,0.88030E+03_JPRB,0.11634E+04_JPRB /)  
KB(:, 1,18,12) = (/ &
 & 0.10781E+04_JPRB,0.81748E+03_JPRB,0.60276E+03_JPRB,0.88597E+03_JPRB,0.11700E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART29',1,ZHOOK_HANDLE)
END SUBROUTINE PART29


SUBROUTINE PART30

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART30',0,ZHOOK_HANDLE)


KB(:, 2,18,12) = (/ &
 & 0.10771E+04_JPRB,0.81396E+03_JPRB,0.60232E+03_JPRB,0.88573E+03_JPRB,0.11691E+04_JPRB /)  
KB(:, 3,18,12) = (/ &
 & 0.10718E+04_JPRB,0.81415E+03_JPRB,0.60204E+03_JPRB,0.88331E+03_JPRB,0.11669E+04_JPRB /)  
KB(:, 4,18,12) = (/ &
 & 0.10689E+04_JPRB,0.81027E+03_JPRB,0.60137E+03_JPRB,0.88144E+03_JPRB,0.11649E+04_JPRB /)  
KB(:, 5,18,12) = (/ &
 & 0.10691E+04_JPRB,0.80937E+03_JPRB,0.60029E+03_JPRB,0.88009E+03_JPRB,0.11632E+04_JPRB /)  
KB(:, 1,19,12) = (/ &
 & 0.10732E+04_JPRB,0.81093E+03_JPRB,0.60257E+03_JPRB,0.88582E+03_JPRB,0.11702E+04_JPRB /)  
KB(:, 2,19,12) = (/ &
 & 0.10665E+04_JPRB,0.81093E+03_JPRB,0.60218E+03_JPRB,0.88486E+03_JPRB,0.11689E+04_JPRB /)  
KB(:, 3,19,12) = (/ &
 & 0.10668E+04_JPRB,0.80596E+03_JPRB,0.60188E+03_JPRB,0.88291E+03_JPRB,0.11667E+04_JPRB /)  
KB(:, 4,19,12) = (/ &
 & 0.10625E+04_JPRB,0.80871E+03_JPRB,0.60129E+03_JPRB,0.88139E+03_JPRB,0.11647E+04_JPRB /)  
KB(:, 5,19,12) = (/ &
 & 0.10641E+04_JPRB,0.80549E+03_JPRB,0.60005E+03_JPRB,0.87990E+03_JPRB,0.11631E+04_JPRB /)  
KB(:, 1,20,12) = (/ &
 & 0.10655E+04_JPRB,0.80608E+03_JPRB,0.60228E+03_JPRB,0.88568E+03_JPRB,0.11700E+04_JPRB /)  
KB(:, 2,20,12) = (/ &
 & 0.10621E+04_JPRB,0.80582E+03_JPRB,0.60205E+03_JPRB,0.88462E+03_JPRB,0.11686E+04_JPRB /)  
KB(:, 3,20,12) = (/ &
 & 0.10596E+04_JPRB,0.80439E+03_JPRB,0.60161E+03_JPRB,0.88282E+03_JPRB,0.11664E+04_JPRB /)  
KB(:, 4,20,12) = (/ &
 & 0.10569E+04_JPRB,0.80052E+03_JPRB,0.60133E+03_JPRB,0.88084E+03_JPRB,0.11645E+04_JPRB /)  
KB(:, 5,20,12) = (/ &
 & 0.10576E+04_JPRB,0.80029E+03_JPRB,0.59980E+03_JPRB,0.87969E+03_JPRB,0.11629E+04_JPRB /)  
KB(:, 1,21,12) = (/ &
 & 0.10601E+04_JPRB,0.80047E+03_JPRB,0.60235E+03_JPRB,0.88539E+03_JPRB,0.11699E+04_JPRB /)  
KB(:, 2,21,12) = (/ &
 & 0.10553E+04_JPRB,0.80126E+03_JPRB,0.60195E+03_JPRB,0.88437E+03_JPRB,0.11684E+04_JPRB /)  
KB(:, 3,21,12) = (/ &
 & 0.10581E+04_JPRB,0.79916E+03_JPRB,0.60159E+03_JPRB,0.88257E+03_JPRB,0.11662E+04_JPRB /)  
KB(:, 4,21,12) = (/ &
 & 0.10523E+04_JPRB,0.79871E+03_JPRB,0.60090E+03_JPRB,0.88096E+03_JPRB,0.11643E+04_JPRB /)  
KB(:, 5,21,12) = (/ &
 & 0.10536E+04_JPRB,0.79852E+03_JPRB,0.59957E+03_JPRB,0.87950E+03_JPRB,0.11627E+04_JPRB /)  
KB(:, 1,22,12) = (/ &
 & 0.10543E+04_JPRB,0.79995E+03_JPRB,0.60207E+03_JPRB,0.88538E+03_JPRB,0.11697E+04_JPRB /)  
KB(:, 2,22,12) = (/ &
 & 0.10531E+04_JPRB,0.79794E+03_JPRB,0.60195E+03_JPRB,0.88401E+03_JPRB,0.11680E+04_JPRB /)  
KB(:, 3,22,12) = (/ &
 & 0.10510E+04_JPRB,0.79590E+03_JPRB,0.60141E+03_JPRB,0.88205E+03_JPRB,0.11658E+04_JPRB /)  
KB(:, 4,22,12) = (/ &
 & 0.10516E+04_JPRB,0.79518E+03_JPRB,0.60121E+03_JPRB,0.88065E+03_JPRB,0.11640E+04_JPRB /)  
KB(:, 5,22,12) = (/ &
 & 0.10507E+04_JPRB,0.79514E+03_JPRB,0.59925E+03_JPRB,0.87922E+03_JPRB,0.11625E+04_JPRB /)  
KB(:, 1,23,12) = (/ &
 & 0.10496E+04_JPRB,0.79686E+03_JPRB,0.60138E+03_JPRB,0.88518E+03_JPRB,0.11695E+04_JPRB /)  
KB(:, 2,23,12) = (/ &
 & 0.10500E+04_JPRB,0.79504E+03_JPRB,0.60174E+03_JPRB,0.88363E+03_JPRB,0.11675E+04_JPRB /)  
KB(:, 3,23,12) = (/ &
 & 0.10497E+04_JPRB,0.79559E+03_JPRB,0.60122E+03_JPRB,0.88187E+03_JPRB,0.11654E+04_JPRB /)  
KB(:, 4,23,12) = (/ &
 & 0.10478E+04_JPRB,0.79456E+03_JPRB,0.60013E+03_JPRB,0.88034E+03_JPRB,0.11637E+04_JPRB /)  
KB(:, 5,23,12) = (/ &
 & 0.10481E+04_JPRB,0.79269E+03_JPRB,0.59893E+03_JPRB,0.87894E+03_JPRB,0.11623E+04_JPRB /)  
KB(:, 1,24,12) = (/ &
 & 0.10504E+04_JPRB,0.79322E+03_JPRB,0.60186E+03_JPRB,0.88494E+03_JPRB,0.11692E+04_JPRB /)  
KB(:, 2,24,12) = (/ &
 & 0.10474E+04_JPRB,0.79292E+03_JPRB,0.60174E+03_JPRB,0.88325E+03_JPRB,0.11671E+04_JPRB /)  
KB(:, 3,24,12) = (/ &
 & 0.10457E+04_JPRB,0.79315E+03_JPRB,0.60103E+03_JPRB,0.88153E+03_JPRB,0.11648E+04_JPRB /)  
KB(:, 4,24,12) = (/ &
 & 0.10462E+04_JPRB,0.79329E+03_JPRB,0.59996E+03_JPRB,0.88003E+03_JPRB,0.11633E+04_JPRB /)  
KB(:, 5,24,12) = (/ &
 & 0.10477E+04_JPRB,0.79348E+03_JPRB,0.59860E+03_JPRB,0.87867E+03_JPRB,0.11620E+04_JPRB /)  
KB(:, 1,25,12) = (/ &
 & 0.10437E+04_JPRB,0.79315E+03_JPRB,0.60179E+03_JPRB,0.88497E+03_JPRB,0.11688E+04_JPRB /)  
KB(:, 2,25,12) = (/ &
 & 0.10446E+04_JPRB,0.79177E+03_JPRB,0.60151E+03_JPRB,0.88285E+03_JPRB,0.11666E+04_JPRB /)  
KB(:, 3,25,12) = (/ &
 & 0.10443E+04_JPRB,0.79105E+03_JPRB,0.60081E+03_JPRB,0.88119E+03_JPRB,0.11647E+04_JPRB /)  
KB(:, 4,25,12) = (/ &
 & 0.10440E+04_JPRB,0.79204E+03_JPRB,0.59965E+03_JPRB,0.87971E+03_JPRB,0.11630E+04_JPRB /)  
KB(:, 5,25,12) = (/ &
 & 0.10441E+04_JPRB,0.79141E+03_JPRB,0.59825E+03_JPRB,0.87840E+03_JPRB,0.11618E+04_JPRB /)  
KB(:, 1,26,12) = (/ &
 & 0.10444E+04_JPRB,0.79040E+03_JPRB,0.60171E+03_JPRB,0.88422E+03_JPRB,0.11681E+04_JPRB /)  
KB(:, 2,26,12) = (/ &
 & 0.10415E+04_JPRB,0.78987E+03_JPRB,0.60136E+03_JPRB,0.88243E+03_JPRB,0.11661E+04_JPRB /)  
KB(:, 3,26,12) = (/ &
 & 0.10417E+04_JPRB,0.79014E+03_JPRB,0.60043E+03_JPRB,0.88082E+03_JPRB,0.11642E+04_JPRB /)  
KB(:, 4,26,12) = (/ &
 & 0.10442E+04_JPRB,0.78985E+03_JPRB,0.59932E+03_JPRB,0.87937E+03_JPRB,0.11625E+04_JPRB /)  
KB(:, 5,26,12) = (/ &
 & 0.10421E+04_JPRB,0.79004E+03_JPRB,0.59787E+03_JPRB,0.87814E+03_JPRB,0.11615E+04_JPRB /)  
KB(:, 1,27,12) = (/ &
 & 0.10431E+04_JPRB,0.78868E+03_JPRB,0.60163E+03_JPRB,0.88378E+03_JPRB,0.11678E+04_JPRB /)  
KB(:, 2,27,12) = (/ &
 & 0.10423E+04_JPRB,0.79138E+03_JPRB,0.60118E+03_JPRB,0.88201E+03_JPRB,0.11657E+04_JPRB /)  
KB(:, 3,27,12) = (/ &
 & 0.10404E+04_JPRB,0.78916E+03_JPRB,0.60037E+03_JPRB,0.88046E+03_JPRB,0.11638E+04_JPRB /)  
KB(:, 4,27,12) = (/ &
 & 0.10405E+04_JPRB,0.78893E+03_JPRB,0.59897E+03_JPRB,0.87905E+03_JPRB,0.11624E+04_JPRB /)  
KB(:, 5,27,12) = (/ &
 & 0.10396E+04_JPRB,0.78917E+03_JPRB,0.59748E+03_JPRB,0.87790E+03_JPRB,0.11613E+04_JPRB /)  
KB(:, 1,28,12) = (/ &
 & 0.10409E+04_JPRB,0.79152E+03_JPRB,0.60155E+03_JPRB,0.88334E+03_JPRB,0.11673E+04_JPRB /)  
KB(:, 2,28,12) = (/ &
 & 0.10439E+04_JPRB,0.78963E+03_JPRB,0.60099E+03_JPRB,0.88127E+03_JPRB,0.11652E+04_JPRB /)  
KB(:, 3,28,12) = (/ &
 & 0.10423E+04_JPRB,0.78823E+03_JPRB,0.60006E+03_JPRB,0.88010E+03_JPRB,0.11635E+04_JPRB /)  
KB(:, 4,28,12) = (/ &
 & 0.10442E+04_JPRB,0.78834E+03_JPRB,0.59861E+03_JPRB,0.87873E+03_JPRB,0.11621E+04_JPRB /)  
KB(:, 5,28,12) = (/ &
 & 0.10392E+04_JPRB,0.79042E+03_JPRB,0.59708E+03_JPRB,0.87768E+03_JPRB,0.11610E+04_JPRB /)  
KB(:, 1,29,12) = (/ &
 & 0.10405E+04_JPRB,0.79019E+03_JPRB,0.60167E+03_JPRB,0.88289E+03_JPRB,0.11667E+04_JPRB /)  
KB(:, 2,29,12) = (/ &
 & 0.10432E+04_JPRB,0.78865E+03_JPRB,0.60111E+03_JPRB,0.88122E+03_JPRB,0.11647E+04_JPRB /)  
KB(:, 3,29,12) = (/ &
 & 0.10406E+04_JPRB,0.78834E+03_JPRB,0.59962E+03_JPRB,0.87974E+03_JPRB,0.11631E+04_JPRB /)  
KB(:, 4,29,12) = (/ &
 & 0.10397E+04_JPRB,0.78909E+03_JPRB,0.59824E+03_JPRB,0.87826E+03_JPRB,0.11618E+04_JPRB /)  
KB(:, 5,29,12) = (/ &
 & 0.10387E+04_JPRB,0.78925E+03_JPRB,0.59665E+03_JPRB,0.87746E+03_JPRB,0.11608E+04_JPRB /)  
KB(:, 1,30,12) = (/ &
 & 0.10411E+04_JPRB,0.78840E+03_JPRB,0.60130E+03_JPRB,0.88244E+03_JPRB,0.11662E+04_JPRB /)  
KB(:, 2,30,12) = (/ &
 & 0.10395E+04_JPRB,0.79020E+03_JPRB,0.60051E+03_JPRB,0.88083E+03_JPRB,0.11643E+04_JPRB /)  
KB(:, 3,30,12) = (/ &
 & 0.10384E+04_JPRB,0.78543E+03_JPRB,0.59928E+03_JPRB,0.87938E+03_JPRB,0.11627E+04_JPRB /)  
KB(:, 4,30,12) = (/ &
 & 0.10394E+04_JPRB,0.78756E+03_JPRB,0.59785E+03_JPRB,0.87814E+03_JPRB,0.11615E+04_JPRB /)  
KB(:, 5,30,12) = (/ &
 & 0.10383E+04_JPRB,0.78820E+03_JPRB,0.59620E+03_JPRB,0.87743E+03_JPRB,0.11605E+04_JPRB /)  
KB(:, 1,31,12) = (/ &
 & 0.10385E+04_JPRB,0.78703E+03_JPRB,0.60113E+03_JPRB,0.88199E+03_JPRB,0.11657E+04_JPRB /)  
KB(:, 2,31,12) = (/ &
 & 0.10401E+04_JPRB,0.79050E+03_JPRB,0.60021E+03_JPRB,0.88045E+03_JPRB,0.11639E+04_JPRB /)  
KB(:, 3,31,12) = (/ &
 & 0.10412E+04_JPRB,0.78681E+03_JPRB,0.59892E+03_JPRB,0.87903E+03_JPRB,0.11624E+04_JPRB /)  
KB(:, 4,31,12) = (/ &
 & 0.10385E+04_JPRB,0.78582E+03_JPRB,0.59732E+03_JPRB,0.87772E+03_JPRB,0.11613E+04_JPRB /)  
KB(:, 5,31,12) = (/ &
 & 0.10372E+04_JPRB,0.78947E+03_JPRB,0.59573E+03_JPRB,0.87705E+03_JPRB,0.11602E+04_JPRB /)  
KB(:, 1,32,12) = (/ &
 & 0.10378E+04_JPRB,0.78710E+03_JPRB,0.60105E+03_JPRB,0.88140E+03_JPRB,0.11652E+04_JPRB /)  
KB(:, 2,32,12) = (/ &
 & 0.10375E+04_JPRB,0.78506E+03_JPRB,0.59989E+03_JPRB,0.88006E+03_JPRB,0.11634E+04_JPRB /)  
KB(:, 3,32,12) = (/ &
 & 0.10409E+04_JPRB,0.78648E+03_JPRB,0.59855E+03_JPRB,0.87869E+03_JPRB,0.11621E+04_JPRB /)  
KB(:, 4,32,12) = (/ &
 & 0.10389E+04_JPRB,0.78640E+03_JPRB,0.59701E+03_JPRB,0.87765E+03_JPRB,0.11610E+04_JPRB /)  
KB(:, 5,32,12) = (/ &
 & 0.10378E+04_JPRB,0.78589E+03_JPRB,0.59527E+03_JPRB,0.87675E+03_JPRB,0.11598E+04_JPRB /)  
KB(:, 1,33,12) = (/ &
 & 0.10380E+04_JPRB,0.78620E+03_JPRB,0.60093E+03_JPRB,0.88116E+03_JPRB,0.11647E+04_JPRB /)  
KB(:, 2,33,12) = (/ &
 & 0.10383E+04_JPRB,0.78582E+03_JPRB,0.59966E+03_JPRB,0.87968E+03_JPRB,0.11631E+04_JPRB /)  
KB(:, 3,33,12) = (/ &
 & 0.10388E+04_JPRB,0.78740E+03_JPRB,0.59816E+03_JPRB,0.87838E+03_JPRB,0.11618E+04_JPRB /)  
KB(:, 4,33,12) = (/ &
 & 0.10367E+04_JPRB,0.78734E+03_JPRB,0.59657E+03_JPRB,0.87743E+03_JPRB,0.11608E+04_JPRB /)  
KB(:, 5,33,12) = (/ &
 & 0.10382E+04_JPRB,0.78803E+03_JPRB,0.59484E+03_JPRB,0.87630E+03_JPRB,0.11592E+04_JPRB /)  
KB(:, 1,34,12) = (/ &
 & 0.10390E+04_JPRB,0.78774E+03_JPRB,0.60058E+03_JPRB,0.88098E+03_JPRB,0.11643E+04_JPRB /)  
KB(:, 2,34,12) = (/ &
 & 0.10374E+04_JPRB,0.78664E+03_JPRB,0.59936E+03_JPRB,0.87936E+03_JPRB,0.11627E+04_JPRB /)  
KB(:, 3,34,12) = (/ &
 & 0.10352E+04_JPRB,0.78733E+03_JPRB,0.59781E+03_JPRB,0.87813E+03_JPRB,0.11615E+04_JPRB /)  
KB(:, 4,34,12) = (/ &
 & 0.10386E+04_JPRB,0.78609E+03_JPRB,0.59617E+03_JPRB,0.87742E+03_JPRB,0.11605E+04_JPRB /)  
KB(:, 5,34,12) = (/ &
 & 0.10400E+04_JPRB,0.78709E+03_JPRB,0.59476E+03_JPRB,0.87581E+03_JPRB,0.11592E+04_JPRB /)  
KB(:, 1,35,12) = (/ &
 & 0.10374E+04_JPRB,0.78486E+03_JPRB,0.60032E+03_JPRB,0.88061E+03_JPRB,0.11641E+04_JPRB /)  
KB(:, 2,35,12) = (/ &
 & 0.10385E+04_JPRB,0.78482E+03_JPRB,0.59906E+03_JPRB,0.87918E+03_JPRB,0.11626E+04_JPRB /)  
KB(:, 3,35,12) = (/ &
 & 0.10371E+04_JPRB,0.78627E+03_JPRB,0.59760E+03_JPRB,0.87799E+03_JPRB,0.11614E+04_JPRB /)  
KB(:, 4,35,12) = (/ &
 & 0.10378E+04_JPRB,0.78697E+03_JPRB,0.59593E+03_JPRB,0.87715E+03_JPRB,0.11604E+04_JPRB /)  
KB(:, 5,35,12) = (/ &
 & 0.10370E+04_JPRB,0.78545E+03_JPRB,0.59500E+03_JPRB,0.87549E+03_JPRB,0.11592E+04_JPRB /)  
KB(:, 1,36,12) = (/ &
 & 0.10362E+04_JPRB,0.78845E+03_JPRB,0.60029E+03_JPRB,0.88058E+03_JPRB,0.11640E+04_JPRB /)  
KB(:, 2,36,12) = (/ &
 & 0.10379E+04_JPRB,0.78676E+03_JPRB,0.59903E+03_JPRB,0.87915E+03_JPRB,0.11625E+04_JPRB /)  
KB(:, 3,36,12) = (/ &
 & 0.10369E+04_JPRB,0.78598E+03_JPRB,0.59768E+03_JPRB,0.87797E+03_JPRB,0.11614E+04_JPRB /)  
KB(:, 4,36,12) = (/ &
 & 0.10369E+04_JPRB,0.78595E+03_JPRB,0.59566E+03_JPRB,0.87713E+03_JPRB,0.11604E+04_JPRB /)  
KB(:, 5,36,12) = (/ &
 & 0.10368E+04_JPRB,0.78548E+03_JPRB,0.59464E+03_JPRB,0.87594E+03_JPRB,0.11600E+04_JPRB /)  
KB(:, 1,37,12) = (/ &
 & 0.10374E+04_JPRB,0.78579E+03_JPRB,0.60055E+03_JPRB,0.88077E+03_JPRB,0.11642E+04_JPRB /)  
KB(:, 2,37,12) = (/ &
 & 0.10362E+04_JPRB,0.78844E+03_JPRB,0.59921E+03_JPRB,0.87933E+03_JPRB,0.11627E+04_JPRB /)  
KB(:, 3,37,12) = (/ &
 & 0.10360E+04_JPRB,0.78603E+03_JPRB,0.59777E+03_JPRB,0.87810E+03_JPRB,0.11615E+04_JPRB /)  
KB(:, 4,37,12) = (/ &
 & 0.10367E+04_JPRB,0.78734E+03_JPRB,0.59623E+03_JPRB,0.87723E+03_JPRB,0.11605E+04_JPRB /)  
KB(:, 5,37,12) = (/ &
 & 0.10361E+04_JPRB,0.78702E+03_JPRB,0.59474E+03_JPRB,0.87592E+03_JPRB,0.11587E+04_JPRB /)  
KB(:, 1,38,12) = (/ &
 & 0.10367E+04_JPRB,0.78778E+03_JPRB,0.60058E+03_JPRB,0.88098E+03_JPRB,0.11645E+04_JPRB /)  
KB(:, 2,38,12) = (/ &
 & 0.10387E+04_JPRB,0.78865E+03_JPRB,0.59939E+03_JPRB,0.87952E+03_JPRB,0.11629E+04_JPRB /)  
KB(:, 3,38,12) = (/ &
 & 0.10363E+04_JPRB,0.78758E+03_JPRB,0.59820E+03_JPRB,0.87825E+03_JPRB,0.11617E+04_JPRB /)  
KB(:, 4,38,12) = (/ &
 & 0.10372E+04_JPRB,0.78786E+03_JPRB,0.59636E+03_JPRB,0.87717E+03_JPRB,0.11609E+04_JPRB /)  
KB(:, 5,38,12) = (/ &
 & 0.10362E+04_JPRB,0.78470E+03_JPRB,0.59485E+03_JPRB,0.87657E+03_JPRB,0.11589E+04_JPRB /)  
KB(:, 1,39,12) = (/ &
 & 0.10374E+04_JPRB,0.78680E+03_JPRB,0.60094E+03_JPRB,0.88119E+03_JPRB,0.11647E+04_JPRB /)  
KB(:, 2,39,12) = (/ &
 & 0.10352E+04_JPRB,0.78618E+03_JPRB,0.60014E+03_JPRB,0.87971E+03_JPRB,0.11631E+04_JPRB /)  
KB(:, 3,39,12) = (/ &
 & 0.10401E+04_JPRB,0.78497E+03_JPRB,0.59818E+03_JPRB,0.87840E+03_JPRB,0.11618E+04_JPRB /)  
KB(:, 4,39,12) = (/ &
 & 0.10369E+04_JPRB,0.78868E+03_JPRB,0.59660E+03_JPRB,0.87744E+03_JPRB,0.11608E+04_JPRB /)  
KB(:, 5,39,12) = (/ &
 & 0.10353E+04_JPRB,0.78494E+03_JPRB,0.59497E+03_JPRB,0.87635E+03_JPRB,0.11593E+04_JPRB /)  
KB(:, 1,40,12) = (/ &
 & 0.10385E+04_JPRB,0.78584E+03_JPRB,0.60091E+03_JPRB,0.88123E+03_JPRB,0.11652E+04_JPRB /)  
KB(:, 2,40,12) = (/ &
 & 0.10387E+04_JPRB,0.78568E+03_JPRB,0.59987E+03_JPRB,0.88006E+03_JPRB,0.11635E+04_JPRB /)  
KB(:, 3,40,12) = (/ &
 & 0.10371E+04_JPRB,0.78626E+03_JPRB,0.59853E+03_JPRB,0.87869E+03_JPRB,0.11621E+04_JPRB /)  
KB(:, 4,40,12) = (/ &
 & 0.10386E+04_JPRB,0.78684E+03_JPRB,0.59700E+03_JPRB,0.87748E+03_JPRB,0.11610E+04_JPRB /)  
KB(:, 5,40,12) = (/ &
 & 0.10362E+04_JPRB,0.78503E+03_JPRB,0.59526E+03_JPRB,0.87692E+03_JPRB,0.11598E+04_JPRB /)  
KB(:, 1,41,12) = (/ &
 & 0.10384E+04_JPRB,0.78504E+03_JPRB,0.60109E+03_JPRB,0.88198E+03_JPRB,0.11657E+04_JPRB /)  
KB(:, 2,41,12) = (/ &
 & 0.10360E+04_JPRB,0.78533E+03_JPRB,0.60017E+03_JPRB,0.88043E+03_JPRB,0.11639E+04_JPRB /)  
KB(:, 3,41,12) = (/ &
 & 0.10374E+04_JPRB,0.78412E+03_JPRB,0.59889E+03_JPRB,0.87902E+03_JPRB,0.11624E+04_JPRB /)  
KB(:, 4,41,12) = (/ &
 & 0.10350E+04_JPRB,0.78545E+03_JPRB,0.59741E+03_JPRB,0.87788E+03_JPRB,0.11613E+04_JPRB /)  
KB(:, 5,41,12) = (/ &
 & 0.10385E+04_JPRB,0.78529E+03_JPRB,0.59570E+03_JPRB,0.87704E+03_JPRB,0.11607E+04_JPRB /)  
KB(:, 1,42,12) = (/ &
 & 0.10370E+04_JPRB,0.78560E+03_JPRB,0.60125E+03_JPRB,0.88242E+03_JPRB,0.11662E+04_JPRB /)  
KB(:, 2,42,12) = (/ &
 & 0.10383E+04_JPRB,0.78469E+03_JPRB,0.60057E+03_JPRB,0.88081E+03_JPRB,0.11643E+04_JPRB /)  
KB(:, 3,42,12) = (/ &
 & 0.10368E+04_JPRB,0.78617E+03_JPRB,0.59924E+03_JPRB,0.87937E+03_JPRB,0.11627E+04_JPRB /)  
KB(:, 4,42,12) = (/ &
 & 0.10362E+04_JPRB,0.78586E+03_JPRB,0.59780E+03_JPRB,0.87813E+03_JPRB,0.11615E+04_JPRB /)  
KB(:, 5,42,12) = (/ &
 & 0.10350E+04_JPRB,0.78958E+03_JPRB,0.59616E+03_JPRB,0.87725E+03_JPRB,0.11605E+04_JPRB /)  
KB(:, 1,43,12) = (/ &
 & 0.10375E+04_JPRB,0.78586E+03_JPRB,0.60140E+03_JPRB,0.88280E+03_JPRB,0.11669E+04_JPRB /)  
KB(:, 2,43,12) = (/ &
 & 0.10344E+04_JPRB,0.78615E+03_JPRB,0.60088E+03_JPRB,0.88112E+03_JPRB,0.11651E+04_JPRB /)  
KB(:, 3,43,12) = (/ &
 & 0.10344E+04_JPRB,0.78345E+03_JPRB,0.59953E+03_JPRB,0.87980E+03_JPRB,0.11632E+04_JPRB /)  
KB(:, 4,43,12) = (/ &
 & 0.10347E+04_JPRB,0.78777E+03_JPRB,0.59827E+03_JPRB,0.87847E+03_JPRB,0.11619E+04_JPRB /)  
KB(:, 5,43,12) = (/ &
 & 0.10355E+04_JPRB,0.78627E+03_JPRB,0.59681E+03_JPRB,0.87766E+03_JPRB,0.11609E+04_JPRB /)  
KB(:, 1,44,12) = (/ &
 & 0.10355E+04_JPRB,0.78449E+03_JPRB,0.60162E+03_JPRB,0.88358E+03_JPRB,0.11676E+04_JPRB /)  
KB(:, 2,44,12) = (/ &
 & 0.10359E+04_JPRB,0.78627E+03_JPRB,0.60103E+03_JPRB,0.88182E+03_JPRB,0.11655E+04_JPRB /)  
KB(:, 3,44,12) = (/ &
 & 0.10377E+04_JPRB,0.78715E+03_JPRB,0.60005E+03_JPRB,0.88029E+03_JPRB,0.11637E+04_JPRB /)  
KB(:, 4,44,12) = (/ &
 & 0.10378E+04_JPRB,0.78625E+03_JPRB,0.59875E+03_JPRB,0.87890E+03_JPRB,0.11623E+04_JPRB /)  
KB(:, 5,44,12) = (/ &
 & 0.10374E+04_JPRB,0.78401E+03_JPRB,0.59725E+03_JPRB,0.87779E+03_JPRB,0.11612E+04_JPRB /)  
KB(:, 1,45,12) = (/ &
 & 0.10390E+04_JPRB,0.78655E+03_JPRB,0.60158E+03_JPRB,0.88419E+03_JPRB,0.11684E+04_JPRB /)  
KB(:, 2,45,12) = (/ &
 & 0.10396E+04_JPRB,0.78684E+03_JPRB,0.60124E+03_JPRB,0.88239E+03_JPRB,0.11662E+04_JPRB /)  
KB(:, 3,45,12) = (/ &
 & 0.10355E+04_JPRB,0.78758E+03_JPRB,0.60044E+03_JPRB,0.88079E+03_JPRB,0.11643E+04_JPRB /)  
KB(:, 4,45,12) = (/ &
 & 0.10368E+04_JPRB,0.78548E+03_JPRB,0.59922E+03_JPRB,0.87935E+03_JPRB,0.11627E+04_JPRB /)  
KB(:, 5,45,12) = (/ &
 & 0.10360E+04_JPRB,0.78578E+03_JPRB,0.59778E+03_JPRB,0.87811E+03_JPRB,0.11615E+04_JPRB /)  
KB(:, 1,46,12) = (/ &
 & 0.10390E+04_JPRB,0.78534E+03_JPRB,0.60165E+03_JPRB,0.88476E+03_JPRB,0.11691E+04_JPRB /)  
KB(:, 2,46,12) = (/ &
 & 0.10368E+04_JPRB,0.78339E+03_JPRB,0.60141E+03_JPRB,0.88303E+03_JPRB,0.11669E+04_JPRB /)  
KB(:, 3,46,12) = (/ &
 & 0.10364E+04_JPRB,0.78696E+03_JPRB,0.60079E+03_JPRB,0.88117E+03_JPRB,0.11649E+04_JPRB /)  
KB(:, 4,46,12) = (/ &
 & 0.10407E+04_JPRB,0.78666E+03_JPRB,0.59968E+03_JPRB,0.87985E+03_JPRB,0.11632E+04_JPRB /)  
KB(:, 5,46,12) = (/ &
 & 0.10344E+04_JPRB,0.78501E+03_JPRB,0.59832E+03_JPRB,0.87835E+03_JPRB,0.11619E+04_JPRB /)  
KB(:, 1,47,12) = (/ &
 & 0.10372E+04_JPRB,0.78547E+03_JPRB,0.60140E+03_JPRB,0.88518E+03_JPRB,0.11696E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART30',1,ZHOOK_HANDLE)
END SUBROUTINE PART30


SUBROUTINE PART31

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART31',0,ZHOOK_HANDLE)


KB(:, 2,47,12) = (/ &
 & 0.10368E+04_JPRB,0.78740E+03_JPRB,0.60142E+03_JPRB,0.88376E+03_JPRB,0.11678E+04_JPRB /)  
KB(:, 3,47,12) = (/ &
 & 0.10360E+04_JPRB,0.78411E+03_JPRB,0.60109E+03_JPRB,0.88198E+03_JPRB,0.11657E+04_JPRB /)  
KB(:, 4,47,12) = (/ &
 & 0.10358E+04_JPRB,0.78709E+03_JPRB,0.60017E+03_JPRB,0.88044E+03_JPRB,0.11639E+04_JPRB /)  
KB(:, 5,47,12) = (/ &
 & 0.10354E+04_JPRB,0.78664E+03_JPRB,0.59889E+03_JPRB,0.87902E+03_JPRB,0.11624E+04_JPRB /)  
KB(:, 1,48,12) = (/ &
 & 0.10362E+04_JPRB,0.78680E+03_JPRB,0.60195E+03_JPRB,0.88548E+03_JPRB,0.11701E+04_JPRB /)  
KB(:, 2,48,12) = (/ &
 & 0.10362E+04_JPRB,0.78545E+03_JPRB,0.60161E+03_JPRB,0.88447E+03_JPRB,0.11687E+04_JPRB /)  
KB(:, 3,48,12) = (/ &
 & 0.10378E+04_JPRB,0.78604E+03_JPRB,0.60144E+03_JPRB,0.88268E+03_JPRB,0.11665E+04_JPRB /)  
KB(:, 4,48,12) = (/ &
 & 0.10382E+04_JPRB,0.78544E+03_JPRB,0.60061E+03_JPRB,0.88104E+03_JPRB,0.11646E+04_JPRB /)  
KB(:, 5,48,12) = (/ &
 & 0.10364E+04_JPRB,0.78424E+03_JPRB,0.59943E+03_JPRB,0.87957E+03_JPRB,0.11630E+04_JPRB /)  
KB(:, 1,49,12) = (/ &
 & 0.10370E+04_JPRB,0.78693E+03_JPRB,0.60225E+03_JPRB,0.88600E+03_JPRB,0.11705E+04_JPRB /)  
KB(:, 2,49,12) = (/ &
 & 0.10356E+04_JPRB,0.78469E+03_JPRB,0.60169E+03_JPRB,0.88499E+03_JPRB,0.11694E+04_JPRB /)  
KB(:, 3,49,12) = (/ &
 & 0.10350E+04_JPRB,0.78588E+03_JPRB,0.60148E+03_JPRB,0.88340E+03_JPRB,0.11674E+04_JPRB /)  
KB(:, 4,49,12) = (/ &
 & 0.10352E+04_JPRB,0.78677E+03_JPRB,0.60095E+03_JPRB,0.88166E+03_JPRB,0.11653E+04_JPRB /)  
KB(:, 5,49,12) = (/ &
 & 0.10356E+04_JPRB,0.78647E+03_JPRB,0.59993E+03_JPRB,0.88015E+03_JPRB,0.11636E+04_JPRB /)  
KB(:, 1,50,12) = (/ &
 & 0.10356E+04_JPRB,0.78558E+03_JPRB,0.60226E+03_JPRB,0.88620E+03_JPRB,0.11712E+04_JPRB /)  
KB(:, 2,50,12) = (/ &
 & 0.10346E+04_JPRB,0.78796E+03_JPRB,0.60171E+03_JPRB,0.88533E+03_JPRB,0.11698E+04_JPRB /)  
KB(:, 3,50,12) = (/ &
 & 0.10366E+04_JPRB,0.78751E+03_JPRB,0.60168E+03_JPRB,0.88408E+03_JPRB,0.11667E+04_JPRB /)  
KB(:, 4,50,12) = (/ &
 & 0.10366E+04_JPRB,0.78646E+03_JPRB,0.60132E+03_JPRB,0.88229E+03_JPRB,0.11661E+04_JPRB /)  
KB(:, 5,50,12) = (/ &
 & 0.10393E+04_JPRB,0.78616E+03_JPRB,0.60083E+03_JPRB,0.88070E+03_JPRB,0.11642E+04_JPRB /)  
KB(:, 1,51,12) = (/ &
 & 0.10356E+04_JPRB,0.78468E+03_JPRB,0.60241E+03_JPRB,0.88644E+03_JPRB,0.11719E+04_JPRB /)  
KB(:, 2,51,12) = (/ &
 & 0.10368E+04_JPRB,0.78423E+03_JPRB,0.60203E+03_JPRB,0.88559E+03_JPRB,0.11702E+04_JPRB /)  
KB(:, 3,51,12) = (/ &
 & 0.10356E+04_JPRB,0.78586E+03_JPRB,0.60163E+03_JPRB,0.88469E+03_JPRB,0.11690E+04_JPRB /)  
KB(:, 4,51,12) = (/ &
 & 0.10358E+04_JPRB,0.78601E+03_JPRB,0.60139E+03_JPRB,0.88294E+03_JPRB,0.11668E+04_JPRB /)  
KB(:, 5,51,12) = (/ &
 & 0.10379E+04_JPRB,0.78646E+03_JPRB,0.60074E+03_JPRB,0.88126E+03_JPRB,0.11648E+04_JPRB /)  
KB(:, 1,52,12) = (/ &
 & 0.10383E+04_JPRB,0.78512E+03_JPRB,0.60257E+03_JPRB,0.88672E+03_JPRB,0.11727E+04_JPRB /)  
KB(:, 2,52,12) = (/ &
 & 0.10350E+04_JPRB,0.78646E+03_JPRB,0.60217E+03_JPRB,0.88594E+03_JPRB,0.11707E+04_JPRB /)  
KB(:, 3,52,12) = (/ &
 & 0.10358E+04_JPRB,0.78466E+03_JPRB,0.60160E+03_JPRB,0.88510E+03_JPRB,0.11695E+04_JPRB /)  
KB(:, 4,52,12) = (/ &
 & 0.10356E+04_JPRB,0.78511E+03_JPRB,0.60151E+03_JPRB,0.88359E+03_JPRB,0.11676E+04_JPRB /)  
KB(:, 5,52,12) = (/ &
 & 0.10365E+04_JPRB,0.78541E+03_JPRB,0.60103E+03_JPRB,0.88167E+03_JPRB,0.11655E+04_JPRB /)  
KB(:, 1,53,12) = (/ &
 & 0.10352E+04_JPRB,0.78496E+03_JPRB,0.60273E+03_JPRB,0.88710E+03_JPRB,0.11735E+04_JPRB /)  
KB(:, 2,53,12) = (/ &
 & 0.10359E+04_JPRB,0.78600E+03_JPRB,0.60229E+03_JPRB,0.88628E+03_JPRB,0.11714E+04_JPRB /)  
KB(:, 3,53,12) = (/ &
 & 0.10369E+04_JPRB,0.78526E+03_JPRB,0.60188E+03_JPRB,0.88540E+03_JPRB,0.11699E+04_JPRB /)  
KB(:, 4,53,12) = (/ &
 & 0.10383E+04_JPRB,0.78660E+03_JPRB,0.60159E+03_JPRB,0.88425E+03_JPRB,0.11685E+04_JPRB /)  
KB(:, 5,53,12) = (/ &
 & 0.10373E+04_JPRB,0.78555E+03_JPRB,0.60126E+03_JPRB,0.88246E+03_JPRB,0.11663E+04_JPRB /)  
KB(:, 1,54,12) = (/ &
 & 0.10367E+04_JPRB,0.78451E+03_JPRB,0.60297E+03_JPRB,0.88752E+03_JPRB,0.11746E+04_JPRB /)  
KB(:, 2,54,12) = (/ &
 & 0.10355E+04_JPRB,0.78600E+03_JPRB,0.60244E+03_JPRB,0.88648E+03_JPRB,0.11721E+04_JPRB /)  
KB(:, 3,54,12) = (/ &
 & 0.10348E+04_JPRB,0.78301E+03_JPRB,0.60206E+03_JPRB,0.88564E+03_JPRB,0.11703E+04_JPRB /)  
KB(:, 4,54,12) = (/ &
 & 0.10395E+04_JPRB,0.78629E+03_JPRB,0.60165E+03_JPRB,0.88477E+03_JPRB,0.11691E+04_JPRB /)  
KB(:, 5,54,12) = (/ &
 & 0.10361E+04_JPRB,0.78420E+03_JPRB,0.60141E+03_JPRB,0.88305E+03_JPRB,0.11670E+04_JPRB /)  
KB(:, 1,55,12) = (/ &
 & 0.10361E+04_JPRB,0.78555E+03_JPRB,0.60296E+03_JPRB,0.88822E+03_JPRB,0.11760E+04_JPRB /)  
KB(:, 2,55,12) = (/ &
 & 0.10355E+04_JPRB,0.78495E+03_JPRB,0.60258E+03_JPRB,0.88674E+03_JPRB,0.11727E+04_JPRB /)  
KB(:, 3,55,12) = (/ &
 & 0.10349E+04_JPRB,0.78525E+03_JPRB,0.60217E+03_JPRB,0.88596E+03_JPRB,0.11709E+04_JPRB /)  
KB(:, 4,55,12) = (/ &
 & 0.10361E+04_JPRB,0.78465E+03_JPRB,0.60184E+03_JPRB,0.88512E+03_JPRB,0.11696E+04_JPRB /)  
KB(:, 5,55,12) = (/ &
 & 0.10363E+04_JPRB,0.78599E+03_JPRB,0.60163E+03_JPRB,0.88363E+03_JPRB,0.11677E+04_JPRB /)  
KB(:, 1,56,12) = (/ &
 & 0.10361E+04_JPRB,0.78599E+03_JPRB,0.60309E+03_JPRB,0.88918E+03_JPRB,0.11774E+04_JPRB /)  
KB(:, 2,56,12) = (/ &
 & 0.10391E+04_JPRB,0.78674E+03_JPRB,0.60272E+03_JPRB,0.88707E+03_JPRB,0.11734E+04_JPRB /)  
KB(:, 3,56,12) = (/ &
 & 0.10363E+04_JPRB,0.78584E+03_JPRB,0.60228E+03_JPRB,0.88626E+03_JPRB,0.11716E+04_JPRB /)  
KB(:, 4,56,12) = (/ &
 & 0.10369E+04_JPRB,0.78509E+03_JPRB,0.60186E+03_JPRB,0.88538E+03_JPRB,0.11695E+04_JPRB /)  
KB(:, 5,56,12) = (/ &
 & 0.10363E+04_JPRB,0.78554E+03_JPRB,0.60158E+03_JPRB,0.88421E+03_JPRB,0.11682E+04_JPRB /)  
KB(:, 1,57,12) = (/ &
 & 0.10381E+04_JPRB,0.78509E+03_JPRB,0.60327E+03_JPRB,0.89026E+03_JPRB,0.11789E+04_JPRB /)  
KB(:, 2,57,12) = (/ &
 & 0.10344E+04_JPRB,0.78852E+03_JPRB,0.60284E+03_JPRB,0.88747E+03_JPRB,0.11744E+04_JPRB /)  
KB(:, 3,57,12) = (/ &
 & 0.10369E+04_JPRB,0.78509E+03_JPRB,0.60242E+03_JPRB,0.88612E+03_JPRB,0.11720E+04_JPRB /)  
KB(:, 4,57,12) = (/ &
 & 0.10393E+04_JPRB,0.78330E+03_JPRB,0.60216E+03_JPRB,0.88561E+03_JPRB,0.11703E+04_JPRB /)  
KB(:, 5,57,12) = (/ &
 & 0.10365E+04_JPRB,0.78494E+03_JPRB,0.60164E+03_JPRB,0.88472E+03_JPRB,0.11688E+04_JPRB /)  
KB(:, 1,58,12) = (/ &
 & 0.10353E+04_JPRB,0.78509E+03_JPRB,0.60357E+03_JPRB,0.89125E+03_JPRB,0.11802E+04_JPRB /)  
KB(:, 2,58,12) = (/ &
 & 0.10371E+04_JPRB,0.78524E+03_JPRB,0.60283E+03_JPRB,0.88807E+03_JPRB,0.11757E+04_JPRB /)  
KB(:, 3,58,12) = (/ &
 & 0.10365E+04_JPRB,0.78718E+03_JPRB,0.60278E+03_JPRB,0.88669E+03_JPRB,0.11726E+04_JPRB /)  
KB(:, 4,58,12) = (/ &
 & 0.10349E+04_JPRB,0.78673E+03_JPRB,0.60216E+03_JPRB,0.88590E+03_JPRB,0.11708E+04_JPRB /)  
KB(:, 5,58,12) = (/ &
 & 0.10365E+04_JPRB,0.78389E+03_JPRB,0.60170E+03_JPRB,0.88506E+03_JPRB,0.11695E+04_JPRB /)  
KB(:, 1,59,12) = (/ &
 & 0.10365E+04_JPRB,0.78390E+03_JPRB,0.60373E+03_JPRB,0.89165E+03_JPRB,0.11808E+04_JPRB /)  
KB(:, 2,59,12) = (/ &
 & 0.10369E+04_JPRB,0.78479E+03_JPRB,0.60298E+03_JPRB,0.88840E+03_JPRB,0.11763E+04_JPRB /)  
KB(:, 3,59,12) = (/ &
 & 0.10357E+04_JPRB,0.78703E+03_JPRB,0.60261E+03_JPRB,0.88680E+03_JPRB,0.11713E+04_JPRB /)  
KB(:, 4,59,12) = (/ &
 & 0.10363E+04_JPRB,0.78509E+03_JPRB,0.60219E+03_JPRB,0.88602E+03_JPRB,0.11708E+04_JPRB /)  
KB(:, 5,59,12) = (/ &
 & 0.10365E+04_JPRB,0.78479E+03_JPRB,0.60174E+03_JPRB,0.88517E+03_JPRB,0.11696E+04_JPRB /)  
KB(:, 1,13,13) = (/ &
 & 0.11661E+04_JPRB,0.87073E+03_JPRB,0.60556E+03_JPRB,0.88929E+03_JPRB,0.11761E+04_JPRB /)  
KB(:, 2,13,13) = (/ &
 & 0.11527E+04_JPRB,0.87014E+03_JPRB,0.60489E+03_JPRB,0.88914E+03_JPRB,0.11754E+04_JPRB /)  
KB(:, 3,13,13) = (/ &
 & 0.11423E+04_JPRB,0.85968E+03_JPRB,0.60419E+03_JPRB,0.88867E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 4,13,13) = (/ &
 & 0.11371E+04_JPRB,0.85890E+03_JPRB,0.60344E+03_JPRB,0.88820E+03_JPRB,0.11742E+04_JPRB /)  
KB(:, 5,13,13) = (/ &
 & 0.11390E+04_JPRB,0.85008E+03_JPRB,0.60234E+03_JPRB,0.88705E+03_JPRB,0.11727E+04_JPRB /)  
KB(:, 1,14,13) = (/ &
 & 0.11362E+04_JPRB,0.85805E+03_JPRB,0.60511E+03_JPRB,0.88957E+03_JPRB,0.11761E+04_JPRB /)  
KB(:, 2,14,13) = (/ &
 & 0.11276E+04_JPRB,0.85398E+03_JPRB,0.60448E+03_JPRB,0.88893E+03_JPRB,0.11753E+04_JPRB /)  
KB(:, 3,14,13) = (/ &
 & 0.11208E+04_JPRB,0.84888E+03_JPRB,0.60397E+03_JPRB,0.88854E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 4,14,13) = (/ &
 & 0.11194E+04_JPRB,0.85006E+03_JPRB,0.60305E+03_JPRB,0.88823E+03_JPRB,0.11740E+04_JPRB /)  
KB(:, 5,14,13) = (/ &
 & 0.11083E+04_JPRB,0.84212E+03_JPRB,0.60191E+03_JPRB,0.88682E+03_JPRB,0.11725E+04_JPRB /)  
KB(:, 1,15,13) = (/ &
 & 0.11142E+04_JPRB,0.84766E+03_JPRB,0.60488E+03_JPRB,0.88941E+03_JPRB,0.11748E+04_JPRB /)  
KB(:, 2,15,13) = (/ &
 & 0.11176E+04_JPRB,0.84112E+03_JPRB,0.60414E+03_JPRB,0.88873E+03_JPRB,0.11752E+04_JPRB /)  
KB(:, 3,15,13) = (/ &
 & 0.11051E+04_JPRB,0.84191E+03_JPRB,0.60348E+03_JPRB,0.88843E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 4,15,13) = (/ &
 & 0.11036E+04_JPRB,0.83753E+03_JPRB,0.60270E+03_JPRB,0.88781E+03_JPRB,0.11739E+04_JPRB /)  
KB(:, 5,15,13) = (/ &
 & 0.10935E+04_JPRB,0.82883E+03_JPRB,0.60139E+03_JPRB,0.88658E+03_JPRB,0.11723E+04_JPRB /)  
KB(:, 1,16,13) = (/ &
 & 0.11074E+04_JPRB,0.83456E+03_JPRB,0.60440E+03_JPRB,0.88927E+03_JPRB,0.11760E+04_JPRB /)  
KB(:, 2,16,13) = (/ &
 & 0.11018E+04_JPRB,0.83298E+03_JPRB,0.60385E+03_JPRB,0.88856E+03_JPRB,0.11751E+04_JPRB /)  
KB(:, 3,16,13) = (/ &
 & 0.10859E+04_JPRB,0.83101E+03_JPRB,0.60319E+03_JPRB,0.88832E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 4,16,13) = (/ &
 & 0.10925E+04_JPRB,0.82836E+03_JPRB,0.60254E+03_JPRB,0.88762E+03_JPRB,0.11738E+04_JPRB /)  
KB(:, 5,16,13) = (/ &
 & 0.10900E+04_JPRB,0.82283E+03_JPRB,0.60124E+03_JPRB,0.88636E+03_JPRB,0.11721E+04_JPRB /)  
KB(:, 1,17,13) = (/ &
 & 0.10953E+04_JPRB,0.82596E+03_JPRB,0.60413E+03_JPRB,0.88915E+03_JPRB,0.11759E+04_JPRB /)  
KB(:, 2,17,13) = (/ &
 & 0.10864E+04_JPRB,0.82504E+03_JPRB,0.60360E+03_JPRB,0.88842E+03_JPRB,0.11750E+04_JPRB /)  
KB(:, 3,17,13) = (/ &
 & 0.10812E+04_JPRB,0.81898E+03_JPRB,0.60295E+03_JPRB,0.88822E+03_JPRB,0.11746E+04_JPRB /)  
KB(:, 4,17,13) = (/ &
 & 0.10806E+04_JPRB,0.81706E+03_JPRB,0.60242E+03_JPRB,0.88745E+03_JPRB,0.11736E+04_JPRB /)  
KB(:, 5,17,13) = (/ &
 & 0.10764E+04_JPRB,0.81771E+03_JPRB,0.59943E+03_JPRB,0.88638E+03_JPRB,0.11722E+04_JPRB /)  
KB(:, 1,18,13) = (/ &
 & 0.10787E+04_JPRB,0.82265E+03_JPRB,0.60390E+03_JPRB,0.88903E+03_JPRB,0.11759E+04_JPRB /)  
KB(:, 2,18,13) = (/ &
 & 0.10743E+04_JPRB,0.81466E+03_JPRB,0.60339E+03_JPRB,0.88738E+03_JPRB,0.11749E+04_JPRB /)  
KB(:, 3,18,13) = (/ &
 & 0.10792E+04_JPRB,0.81648E+03_JPRB,0.60273E+03_JPRB,0.88812E+03_JPRB,0.11749E+04_JPRB /)  
KB(:, 4,18,13) = (/ &
 & 0.10724E+04_JPRB,0.81516E+03_JPRB,0.60185E+03_JPRB,0.88728E+03_JPRB,0.11735E+04_JPRB /)  
KB(:, 5,18,13) = (/ &
 & 0.10737E+04_JPRB,0.81301E+03_JPRB,0.60092E+03_JPRB,0.88618E+03_JPRB,0.11717E+04_JPRB /)  
KB(:, 1,19,13) = (/ &
 & 0.10778E+04_JPRB,0.81646E+03_JPRB,0.60388E+03_JPRB,0.88893E+03_JPRB,0.11758E+04_JPRB /)  
KB(:, 2,19,13) = (/ &
 & 0.10709E+04_JPRB,0.81021E+03_JPRB,0.60321E+03_JPRB,0.88822E+03_JPRB,0.11748E+04_JPRB /)  
KB(:, 3,19,13) = (/ &
 & 0.10651E+04_JPRB,0.80945E+03_JPRB,0.60254E+03_JPRB,0.88803E+03_JPRB,0.11745E+04_JPRB /)  
KB(:, 4,19,13) = (/ &
 & 0.10677E+04_JPRB,0.80743E+03_JPRB,0.60147E+03_JPRB,0.88735E+03_JPRB,0.11733E+04_JPRB /)  
KB(:, 5,19,13) = (/ &
 & 0.10575E+04_JPRB,0.80245E+03_JPRB,0.60072E+03_JPRB,0.88575E+03_JPRB,0.11721E+04_JPRB /)  
KB(:, 1,20,13) = (/ &
 & 0.10622E+04_JPRB,0.81096E+03_JPRB,0.60356E+03_JPRB,0.88881E+03_JPRB,0.11757E+04_JPRB /)  
KB(:, 2,20,13) = (/ &
 & 0.10607E+04_JPRB,0.80739E+03_JPRB,0.60305E+03_JPRB,0.88816E+03_JPRB,0.11748E+04_JPRB /)  
KB(:, 3,20,13) = (/ &
 & 0.10623E+04_JPRB,0.80381E+03_JPRB,0.60252E+03_JPRB,0.88792E+03_JPRB,0.11744E+04_JPRB /)  
KB(:, 4,20,13) = (/ &
 & 0.10570E+04_JPRB,0.80456E+03_JPRB,0.60093E+03_JPRB,0.88695E+03_JPRB,0.11731E+04_JPRB /)  
KB(:, 5,20,13) = (/ &
 & 0.10628E+04_JPRB,0.80481E+03_JPRB,0.60051E+03_JPRB,0.88554E+03_JPRB,0.11713E+04_JPRB /)  
KB(:, 1,21,13) = (/ &
 & 0.10564E+04_JPRB,0.80721E+03_JPRB,0.60326E+03_JPRB,0.88869E+03_JPRB,0.11756E+04_JPRB /)  
KB(:, 2,21,13) = (/ &
 & 0.10630E+04_JPRB,0.79813E+03_JPRB,0.60290E+03_JPRB,0.88813E+03_JPRB,0.11748E+04_JPRB /)  
KB(:, 3,21,13) = (/ &
 & 0.10553E+04_JPRB,0.80228E+03_JPRB,0.60219E+03_JPRB,0.88781E+03_JPRB,0.11743E+04_JPRB /)  
KB(:, 4,21,13) = (/ &
 & 0.10544E+04_JPRB,0.79888E+03_JPRB,0.60136E+03_JPRB,0.88677E+03_JPRB,0.11729E+04_JPRB /)  
KB(:, 5,21,13) = (/ &
 & 0.10596E+04_JPRB,0.81049E+03_JPRB,0.60032E+03_JPRB,0.88532E+03_JPRB,0.11710E+04_JPRB /)  
KB(:, 1,22,13) = (/ &
 & 0.10550E+04_JPRB,0.80310E+03_JPRB,0.60326E+03_JPRB,0.88850E+03_JPRB,0.11754E+04_JPRB /)  
KB(:, 2,22,13) = (/ &
 & 0.10516E+04_JPRB,0.80380E+03_JPRB,0.60256E+03_JPRB,0.88810E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 3,22,13) = (/ &
 & 0.10562E+04_JPRB,0.80152E+03_JPRB,0.60229E+03_JPRB,0.88764E+03_JPRB,0.11741E+04_JPRB /)  
KB(:, 4,22,13) = (/ &
 & 0.10509E+04_JPRB,0.80224E+03_JPRB,0.60002E+03_JPRB,0.88651E+03_JPRB,0.11726E+04_JPRB /)  
KB(:, 5,22,13) = (/ &
 & 0.10563E+04_JPRB,0.79871E+03_JPRB,0.59990E+03_JPRB,0.88500E+03_JPRB,0.11706E+04_JPRB /)  
KB(:, 1,23,13) = (/ &
 & 0.10567E+04_JPRB,0.79860E+03_JPRB,0.60326E+03_JPRB,0.88832E+03_JPRB,0.11752E+04_JPRB /)  
KB(:, 2,23,13) = (/ &
 & 0.10532E+04_JPRB,0.79557E+03_JPRB,0.60254E+03_JPRB,0.88806E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 3,23,13) = (/ &
 & 0.10534E+04_JPRB,0.79512E+03_JPRB,0.60237E+03_JPRB,0.88744E+03_JPRB,0.11739E+04_JPRB /)  
KB(:, 4,23,13) = (/ &
 & 0.10472E+04_JPRB,0.79721E+03_JPRB,0.60072E+03_JPRB,0.88622E+03_JPRB,0.11723E+04_JPRB /)  
KB(:, 5,23,13) = (/ &
 & 0.10509E+04_JPRB,0.79423E+03_JPRB,0.59964E+03_JPRB,0.88466E+03_JPRB,0.11702E+04_JPRB /)  
KB(:, 1,24,13) = (/ &
 & 0.10549E+04_JPRB,0.79502E+03_JPRB,0.60296E+03_JPRB,0.88817E+03_JPRB,0.11750E+04_JPRB /)  
KB(:, 2,24,13) = (/ &
 & 0.10498E+04_JPRB,0.80428E+03_JPRB,0.60221E+03_JPRB,0.88799E+03_JPRB,0.11746E+04_JPRB /)  
KB(:, 3,24,13) = (/ &
 & 0.10553E+04_JPRB,0.79369E+03_JPRB,0.60149E+03_JPRB,0.88721E+03_JPRB,0.11736E+04_JPRB /)  
KB(:, 4,24,13) = (/ &
 & 0.10517E+04_JPRB,0.79240E+03_JPRB,0.60048E+03_JPRB,0.88592E+03_JPRB,0.11719E+04_JPRB /)  
KB(:, 5,24,13) = (/ &
 & 0.10493E+04_JPRB,0.79281E+03_JPRB,0.59936E+03_JPRB,0.88429E+03_JPRB,0.11697E+04_JPRB /)  
KB(:, 1,25,13) = (/ &
 & 0.10472E+04_JPRB,0.79884E+03_JPRB,0.60281E+03_JPRB,0.88760E+03_JPRB,0.11748E+04_JPRB /)  
KB(:, 2,25,13) = (/ &
 & 0.10433E+04_JPRB,0.79261E+03_JPRB,0.60217E+03_JPRB,0.88787E+03_JPRB,0.11745E+04_JPRB /)  
KB(:, 3,25,13) = (/ &
 & 0.10495E+04_JPRB,0.79568E+03_JPRB,0.60138E+03_JPRB,0.88696E+03_JPRB,0.11733E+04_JPRB /)  
KB(:, 4,25,13) = (/ &
 & 0.10412E+04_JPRB,0.79264E+03_JPRB,0.60023E+03_JPRB,0.88559E+03_JPRB,0.11715E+04_JPRB /)  
KB(:, 5,25,13) = (/ &
 & 0.10432E+04_JPRB,0.79682E+03_JPRB,0.59908E+03_JPRB,0.88390E+03_JPRB,0.11692E+04_JPRB /)  
KB(:, 1,26,13) = (/ &
 & 0.10426E+04_JPRB,0.79538E+03_JPRB,0.60266E+03_JPRB,0.88804E+03_JPRB,0.11748E+04_JPRB /)  
KB(:, 2,26,13) = (/ &
 & 0.10459E+04_JPRB,0.79909E+03_JPRB,0.60196E+03_JPRB,0.88771E+03_JPRB,0.11743E+04_JPRB /)  
KB(:, 3,26,13) = (/ &
 & 0.10455E+04_JPRB,0.79078E+03_JPRB,0.60113E+03_JPRB,0.88666E+03_JPRB,0.11729E+04_JPRB /)  
KB(:, 4,26,13) = (/ &
 & 0.10380E+04_JPRB,0.79069E+03_JPRB,0.60011E+03_JPRB,0.88521E+03_JPRB,0.11710E+04_JPRB /)  
KB(:, 5,26,13) = (/ &
 & 0.10428E+04_JPRB,0.79124E+03_JPRB,0.59892E+03_JPRB,0.88345E+03_JPRB,0.11686E+04_JPRB /)  
KB(:, 1,27,13) = (/ &
 & 0.10409E+04_JPRB,0.79057E+03_JPRB,0.60249E+03_JPRB,0.88802E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 2,27,13) = (/ &
 & 0.10432E+04_JPRB,0.78863E+03_JPRB,0.60172E+03_JPRB,0.88750E+03_JPRB,0.11740E+04_JPRB /)  
KB(:, 3,27,13) = (/ &
 & 0.10404E+04_JPRB,0.79041E+03_JPRB,0.60057E+03_JPRB,0.88634E+03_JPRB,0.11728E+04_JPRB /)  
KB(:, 4,27,13) = (/ &
 & 0.10425E+04_JPRB,0.78854E+03_JPRB,0.59967E+03_JPRB,0.88481E+03_JPRB,0.11704E+04_JPRB /)  
KB(:, 5,27,13) = (/ &
 & 0.10492E+04_JPRB,0.78874E+03_JPRB,0.59843E+03_JPRB,0.88297E+03_JPRB,0.11680E+04_JPRB /)  
KB(:, 1,28,13) = (/ &
 & 0.10434E+04_JPRB,0.79273E+03_JPRB,0.60231E+03_JPRB,0.88820E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 2,28,13) = (/ &
 & 0.10472E+04_JPRB,0.78799E+03_JPRB,0.60162E+03_JPRB,0.88726E+03_JPRB,0.11737E+04_JPRB /)  
KB(:, 3,28,13) = (/ &
 & 0.10366E+04_JPRB,0.79125E+03_JPRB,0.60032E+03_JPRB,0.88600E+03_JPRB,0.11720E+04_JPRB /)  
KB(:, 4,28,13) = (/ &
 & 0.10345E+04_JPRB,0.78841E+03_JPRB,0.59938E+03_JPRB,0.88440E+03_JPRB,0.11699E+04_JPRB /)  
KB(:, 5,28,13) = (/ &
 & 0.10534E+04_JPRB,0.78866E+03_JPRB,0.59808E+03_JPRB,0.88245E+03_JPRB,0.11673E+04_JPRB /)  
KB(:, 1,29,13) = (/ &
 & 0.10524E+04_JPRB,0.78934E+03_JPRB,0.60181E+03_JPRB,0.88786E+03_JPRB,0.11745E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART31',1,ZHOOK_HANDLE)
END SUBROUTINE PART31


SUBROUTINE PART32

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART32',0,ZHOOK_HANDLE)


KB(:, 2,29,13) = (/ &
 & 0.10481E+04_JPRB,0.78588E+03_JPRB,0.60321E+03_JPRB,0.88698E+03_JPRB,0.11734E+04_JPRB /)  
KB(:, 3,29,13) = (/ &
 & 0.10466E+04_JPRB,0.79266E+03_JPRB,0.60021E+03_JPRB,0.88562E+03_JPRB,0.11715E+04_JPRB /)  
KB(:, 4,29,13) = (/ &
 & 0.10466E+04_JPRB,0.79965E+03_JPRB,0.59906E+03_JPRB,0.88395E+03_JPRB,0.11693E+04_JPRB /)  
KB(:, 5,29,13) = (/ &
 & 0.10459E+04_JPRB,0.78993E+03_JPRB,0.59799E+03_JPRB,0.88185E+03_JPRB,0.11668E+04_JPRB /)  
KB(:, 1,30,13) = (/ &
 & 0.10360E+04_JPRB,0.78916E+03_JPRB,0.60191E+03_JPRB,0.88770E+03_JPRB,0.11743E+04_JPRB /)  
KB(:, 2,30,13) = (/ &
 & 0.10409E+04_JPRB,0.78411E+03_JPRB,0.60093E+03_JPRB,0.88667E+03_JPRB,0.11729E+04_JPRB /)  
KB(:, 3,30,13) = (/ &
 & 0.10391E+04_JPRB,0.79193E+03_JPRB,0.59993E+03_JPRB,0.88546E+03_JPRB,0.11710E+04_JPRB /)  
KB(:, 4,30,13) = (/ &
 & 0.10409E+04_JPRB,0.78876E+03_JPRB,0.59874E+03_JPRB,0.88348E+03_JPRB,0.11687E+04_JPRB /)  
KB(:, 5,30,13) = (/ &
 & 0.10396E+04_JPRB,0.78722E+03_JPRB,0.59722E+03_JPRB,0.88117E+03_JPRB,0.11665E+04_JPRB /)  
KB(:, 1,31,13) = (/ &
 & 0.10394E+04_JPRB,0.79419E+03_JPRB,0.60167E+03_JPRB,0.88749E+03_JPRB,0.11740E+04_JPRB /)  
KB(:, 2,31,13) = (/ &
 & 0.10363E+04_JPRB,0.79203E+03_JPRB,0.60068E+03_JPRB,0.88633E+03_JPRB,0.11725E+04_JPRB /)  
KB(:, 3,31,13) = (/ &
 & 0.10437E+04_JPRB,0.78663E+03_JPRB,0.59963E+03_JPRB,0.88481E+03_JPRB,0.11705E+04_JPRB /)  
KB(:, 4,31,13) = (/ &
 & 0.10406E+04_JPRB,0.79000E+03_JPRB,0.59839E+03_JPRB,0.88297E+03_JPRB,0.11680E+04_JPRB /)  
KB(:, 5,31,13) = (/ &
 & 0.10413E+04_JPRB,0.79093E+03_JPRB,0.59674E+03_JPRB,0.88044E+03_JPRB,0.11650E+04_JPRB /)  
KB(:, 1,32,13) = (/ &
 & 0.10440E+04_JPRB,0.79014E+03_JPRB,0.60327E+03_JPRB,0.88723E+03_JPRB,0.11737E+04_JPRB /)  
KB(:, 2,32,13) = (/ &
 & 0.10391E+04_JPRB,0.79106E+03_JPRB,0.60042E+03_JPRB,0.88596E+03_JPRB,0.11720E+04_JPRB /)  
KB(:, 3,32,13) = (/ &
 & 0.10467E+04_JPRB,0.78955E+03_JPRB,0.59932E+03_JPRB,0.88436E+03_JPRB,0.11699E+04_JPRB /)  
KB(:, 4,32,13) = (/ &
 & 0.10407E+04_JPRB,0.79722E+03_JPRB,0.59818E+03_JPRB,0.88241E+03_JPRB,0.11673E+04_JPRB /)  
KB(:, 5,32,13) = (/ &
 & 0.10382E+04_JPRB,0.78961E+03_JPRB,0.59626E+03_JPRB,0.87980E+03_JPRB,0.11639E+04_JPRB /)  
KB(:, 1,33,13) = (/ &
 & 0.10522E+04_JPRB,0.78494E+03_JPRB,0.60081E+03_JPRB,0.88693E+03_JPRB,0.11733E+04_JPRB /)  
KB(:, 2,33,13) = (/ &
 & 0.10373E+04_JPRB,0.79220E+03_JPRB,0.59999E+03_JPRB,0.88557E+03_JPRB,0.11715E+04_JPRB /)  
KB(:, 3,33,13) = (/ &
 & 0.10359E+04_JPRB,0.78622E+03_JPRB,0.59900E+03_JPRB,0.88389E+03_JPRB,0.11695E+04_JPRB /)  
KB(:, 4,33,13) = (/ &
 & 0.10377E+04_JPRB,0.78474E+03_JPRB,0.59760E+03_JPRB,0.88177E+03_JPRB,0.11667E+04_JPRB /)  
KB(:, 5,33,13) = (/ &
 & 0.10406E+04_JPRB,0.78876E+03_JPRB,0.59580E+03_JPRB,0.87933E+03_JPRB,0.11633E+04_JPRB /)  
KB(:, 1,34,13) = (/ &
 & 0.10360E+04_JPRB,0.79366E+03_JPRB,0.60074E+03_JPRB,0.88666E+03_JPRB,0.11729E+04_JPRB /)  
KB(:, 2,34,13) = (/ &
 & 0.10445E+04_JPRB,0.78362E+03_JPRB,0.59974E+03_JPRB,0.88521E+03_JPRB,0.11710E+04_JPRB /)  
KB(:, 3,34,13) = (/ &
 & 0.10445E+04_JPRB,0.78784E+03_JPRB,0.59871E+03_JPRB,0.88346E+03_JPRB,0.11687E+04_JPRB /)  
KB(:, 4,34,13) = (/ &
 & 0.10420E+04_JPRB,0.78840E+03_JPRB,0.59718E+03_JPRB,0.88091E+03_JPRB,0.11665E+04_JPRB /)  
KB(:, 5,34,13) = (/ &
 & 0.10384E+04_JPRB,0.79182E+03_JPRB,0.59540E+03_JPRB,0.87927E+03_JPRB,0.11620E+04_JPRB /)  
KB(:, 1,35,13) = (/ &
 & 0.10422E+04_JPRB,0.79326E+03_JPRB,0.60077E+03_JPRB,0.88648E+03_JPRB,0.11727E+04_JPRB /)  
KB(:, 2,35,13) = (/ &
 & 0.10360E+04_JPRB,0.79158E+03_JPRB,0.59975E+03_JPRB,0.88500E+03_JPRB,0.11707E+04_JPRB /)  
KB(:, 3,35,13) = (/ &
 & 0.10370E+04_JPRB,0.78869E+03_JPRB,0.59854E+03_JPRB,0.88320E+03_JPRB,0.11683E+04_JPRB /)  
KB(:, 4,35,13) = (/ &
 & 0.10364E+04_JPRB,0.79354E+03_JPRB,0.59694E+03_JPRB,0.88077E+03_JPRB,0.11651E+04_JPRB /)  
KB(:, 5,35,13) = (/ &
 & 0.10369E+04_JPRB,0.78943E+03_JPRB,0.59473E+03_JPRB,0.87892E+03_JPRB,0.11616E+04_JPRB /)  
KB(:, 1,36,13) = (/ &
 & 0.10401E+04_JPRB,0.78191E+03_JPRB,0.60075E+03_JPRB,0.88645E+03_JPRB,0.11727E+04_JPRB /)  
KB(:, 2,36,13) = (/ &
 & 0.10371E+04_JPRB,0.78614E+03_JPRB,0.59972E+03_JPRB,0.88519E+03_JPRB,0.11707E+04_JPRB /)  
KB(:, 3,36,13) = (/ &
 & 0.10392E+04_JPRB,0.78550E+03_JPRB,0.59835E+03_JPRB,0.88339E+03_JPRB,0.11683E+04_JPRB /)  
KB(:, 4,36,13) = (/ &
 & 0.10378E+04_JPRB,0.78649E+03_JPRB,0.59690E+03_JPRB,0.88071E+03_JPRB,0.11650E+04_JPRB /)  
KB(:, 5,36,13) = (/ &
 & 0.10389E+04_JPRB,0.79012E+03_JPRB,0.59516E+03_JPRB,0.87821E+03_JPRB,0.11604E+04_JPRB /)  
KB(:, 1,37,13) = (/ &
 & 0.10397E+04_JPRB,0.78790E+03_JPRB,0.60071E+03_JPRB,0.88662E+03_JPRB,0.11729E+04_JPRB /)  
KB(:, 2,37,13) = (/ &
 & 0.10413E+04_JPRB,0.78135E+03_JPRB,0.59986E+03_JPRB,0.88540E+03_JPRB,0.11710E+04_JPRB /)  
KB(:, 3,37,13) = (/ &
 & 0.10434E+04_JPRB,0.78885E+03_JPRB,0.59867E+03_JPRB,0.88341E+03_JPRB,0.11686E+04_JPRB /)  
KB(:, 4,37,13) = (/ &
 & 0.10382E+04_JPRB,0.79636E+03_JPRB,0.59698E+03_JPRB,0.88108E+03_JPRB,0.11655E+04_JPRB /)  
KB(:, 5,37,13) = (/ &
 & 0.10369E+04_JPRB,0.78656E+03_JPRB,0.59536E+03_JPRB,0.87879E+03_JPRB,0.11626E+04_JPRB /)  
KB(:, 1,38,13) = (/ &
 & 0.10433E+04_JPRB,0.78475E+03_JPRB,0.60099E+03_JPRB,0.88680E+03_JPRB,0.11731E+04_JPRB /)  
KB(:, 2,38,13) = (/ &
 & 0.10422E+04_JPRB,0.78187E+03_JPRB,0.60001E+03_JPRB,0.88539E+03_JPRB,0.11713E+04_JPRB /)  
KB(:, 3,38,13) = (/ &
 & 0.10376E+04_JPRB,0.78470E+03_JPRB,0.59854E+03_JPRB,0.88368E+03_JPRB,0.11690E+04_JPRB /)  
KB(:, 4,38,13) = (/ &
 & 0.10379E+04_JPRB,0.78467E+03_JPRB,0.59739E+03_JPRB,0.88147E+03_JPRB,0.11660E+04_JPRB /)  
KB(:, 5,38,13) = (/ &
 & 0.10346E+04_JPRB,0.79279E+03_JPRB,0.59559E+03_JPRB,0.87849E+03_JPRB,0.11631E+04_JPRB /)  
KB(:, 1,39,13) = (/ &
 & 0.10564E+04_JPRB,0.79016E+03_JPRB,0.60113E+03_JPRB,0.88696E+03_JPRB,0.11734E+04_JPRB /)  
KB(:, 2,39,13) = (/ &
 & 0.10405E+04_JPRB,0.78139E+03_JPRB,0.59938E+03_JPRB,0.88561E+03_JPRB,0.11715E+04_JPRB /)  
KB(:, 3,39,13) = (/ &
 & 0.10386E+04_JPRB,0.79256E+03_JPRB,0.59902E+03_JPRB,0.88393E+03_JPRB,0.11693E+04_JPRB /)  
KB(:, 4,39,13) = (/ &
 & 0.10351E+04_JPRB,0.78501E+03_JPRB,0.59779E+03_JPRB,0.88184E+03_JPRB,0.11668E+04_JPRB /)  
KB(:, 5,39,13) = (/ &
 & 0.10353E+04_JPRB,0.78561E+03_JPRB,0.59583E+03_JPRB,0.87937E+03_JPRB,0.11634E+04_JPRB /)  
KB(:, 1,40,13) = (/ &
 & 0.10351E+04_JPRB,0.78501E+03_JPRB,0.60325E+03_JPRB,0.88723E+03_JPRB,0.11737E+04_JPRB /)  
KB(:, 2,40,13) = (/ &
 & 0.10332E+04_JPRB,0.78519E+03_JPRB,0.60040E+03_JPRB,0.88596E+03_JPRB,0.11720E+04_JPRB /)  
KB(:, 3,40,13) = (/ &
 & 0.10393E+04_JPRB,0.78843E+03_JPRB,0.59931E+03_JPRB,0.88436E+03_JPRB,0.11699E+04_JPRB /)  
KB(:, 4,40,13) = (/ &
 & 0.10339E+04_JPRB,0.78821E+03_JPRB,0.59801E+03_JPRB,0.88242E+03_JPRB,0.11676E+04_JPRB /)  
KB(:, 5,40,13) = (/ &
 & 0.10476E+04_JPRB,0.78616E+03_JPRB,0.59626E+03_JPRB,0.87958E+03_JPRB,0.11639E+04_JPRB /)  
KB(:, 1,41,13) = (/ &
 & 0.10420E+04_JPRB,0.78658E+03_JPRB,0.60226E+03_JPRB,0.88748E+03_JPRB,0.11740E+04_JPRB /)  
KB(:, 2,41,13) = (/ &
 & 0.10471E+04_JPRB,0.78433E+03_JPRB,0.60065E+03_JPRB,0.88632E+03_JPRB,0.11725E+04_JPRB /)  
KB(:, 3,41,13) = (/ &
 & 0.10385E+04_JPRB,0.78777E+03_JPRB,0.59960E+03_JPRB,0.88480E+03_JPRB,0.11705E+04_JPRB /)  
KB(:, 4,41,13) = (/ &
 & 0.10374E+04_JPRB,0.79305E+03_JPRB,0.59837E+03_JPRB,0.88319E+03_JPRB,0.11680E+04_JPRB /)  
KB(:, 5,41,13) = (/ &
 & 0.10341E+04_JPRB,0.79121E+03_JPRB,0.59671E+03_JPRB,0.88067E+03_JPRB,0.11641E+04_JPRB /)  
KB(:, 1,42,13) = (/ &
 & 0.10427E+04_JPRB,0.78654E+03_JPRB,0.60202E+03_JPRB,0.88768E+03_JPRB,0.11743E+04_JPRB /)  
KB(:, 2,42,13) = (/ &
 & 0.10376E+04_JPRB,0.78774E+03_JPRB,0.60073E+03_JPRB,0.88666E+03_JPRB,0.11730E+04_JPRB /)  
KB(:, 3,42,13) = (/ &
 & 0.10387E+04_JPRB,0.78631E+03_JPRB,0.59989E+03_JPRB,0.88522E+03_JPRB,0.11710E+04_JPRB /)  
KB(:, 4,42,13) = (/ &
 & 0.10432E+04_JPRB,0.79240E+03_JPRB,0.59870E+03_JPRB,0.88347E+03_JPRB,0.11690E+04_JPRB /)  
KB(:, 5,42,13) = (/ &
 & 0.10408E+04_JPRB,0.78283E+03_JPRB,0.59718E+03_JPRB,0.88116E+03_JPRB,0.11677E+04_JPRB /)  
KB(:, 1,43,13) = (/ &
 & 0.10384E+04_JPRB,0.78732E+03_JPRB,0.60211E+03_JPRB,0.88787E+03_JPRB,0.11746E+04_JPRB /)  
KB(:, 2,43,13) = (/ &
 & 0.10392E+04_JPRB,0.79483E+03_JPRB,0.60103E+03_JPRB,0.88703E+03_JPRB,0.11735E+04_JPRB /)  
KB(:, 3,43,13) = (/ &
 & 0.10435E+04_JPRB,0.79279E+03_JPRB,0.60022E+03_JPRB,0.88570E+03_JPRB,0.11717E+04_JPRB /)  
KB(:, 4,43,13) = (/ &
 & 0.10453E+04_JPRB,0.78261E+03_JPRB,0.59909E+03_JPRB,0.88405E+03_JPRB,0.11698E+04_JPRB /)  
KB(:, 5,43,13) = (/ &
 & 0.10349E+04_JPRB,0.78239E+03_JPRB,0.59773E+03_JPRB,0.88200E+03_JPRB,0.11670E+04_JPRB /)  
KB(:, 1,44,13) = (/ &
 & 0.10376E+04_JPRB,0.78973E+03_JPRB,0.60218E+03_JPRB,0.88797E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 2,44,13) = (/ &
 & 0.10357E+04_JPRB,0.79073E+03_JPRB,0.60154E+03_JPRB,0.88738E+03_JPRB,0.11742E+04_JPRB /)  
KB(:, 3,44,13) = (/ &
 & 0.10381E+04_JPRB,0.78584E+03_JPRB,0.60056E+03_JPRB,0.88619E+03_JPRB,0.11723E+04_JPRB /)  
KB(:, 4,44,13) = (/ &
 & 0.10410E+04_JPRB,0.78726E+03_JPRB,0.59965E+03_JPRB,0.88464E+03_JPRB,0.11703E+04_JPRB /)  
KB(:, 5,44,13) = (/ &
 & 0.10370E+04_JPRB,0.78461E+03_JPRB,0.59824E+03_JPRB,0.88299E+03_JPRB,0.11677E+04_JPRB /)  
KB(:, 1,45,13) = (/ &
 & 0.10383E+04_JPRB,0.78177E+03_JPRB,0.60254E+03_JPRB,0.88799E+03_JPRB,0.11748E+04_JPRB /)  
KB(:, 2,45,13) = (/ &
 & 0.10337E+04_JPRB,0.78400E+03_JPRB,0.60200E+03_JPRB,0.88790E+03_JPRB,0.11743E+04_JPRB /)  
KB(:, 3,45,13) = (/ &
 & 0.10407E+04_JPRB,0.78928E+03_JPRB,0.60087E+03_JPRB,0.88664E+03_JPRB,0.11732E+04_JPRB /)  
KB(:, 4,45,13) = (/ &
 & 0.10410E+04_JPRB,0.79578E+03_JPRB,0.59987E+03_JPRB,0.88519E+03_JPRB,0.11713E+04_JPRB /)  
KB(:, 5,45,13) = (/ &
 & 0.10369E+04_JPRB,0.78337E+03_JPRB,0.59884E+03_JPRB,0.88344E+03_JPRB,0.11687E+04_JPRB /)  
KB(:, 1,46,13) = (/ &
 & 0.10415E+04_JPRB,0.79090E+03_JPRB,0.60272E+03_JPRB,0.88805E+03_JPRB,0.11749E+04_JPRB /)  
KB(:, 2,46,13) = (/ &
 & 0.10332E+04_JPRB,0.79374E+03_JPRB,0.60213E+03_JPRB,0.88788E+03_JPRB,0.11746E+04_JPRB /)  
KB(:, 3,46,13) = (/ &
 & 0.10495E+04_JPRB,0.78743E+03_JPRB,0.60122E+03_JPRB,0.88707E+03_JPRB,0.11738E+04_JPRB /)  
KB(:, 4,46,13) = (/ &
 & 0.10359E+04_JPRB,0.78275E+03_JPRB,0.60025E+03_JPRB,0.88575E+03_JPRB,0.11717E+04_JPRB /)  
KB(:, 5,46,13) = (/ &
 & 0.10407E+04_JPRB,0.79210E+03_JPRB,0.59913E+03_JPRB,0.88411E+03_JPRB,0.11695E+04_JPRB /)  
KB(:, 1,47,13) = (/ &
 & 0.10396E+04_JPRB,0.78478E+03_JPRB,0.60291E+03_JPRB,0.88833E+03_JPRB,0.11753E+04_JPRB /)  
KB(:, 2,47,13) = (/ &
 & 0.10391E+04_JPRB,0.78254E+03_JPRB,0.60239E+03_JPRB,0.88798E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 3,47,13) = (/ &
 & 0.10358E+04_JPRB,0.79087E+03_JPRB,0.60194E+03_JPRB,0.88748E+03_JPRB,0.11740E+04_JPRB /)  
KB(:, 4,47,13) = (/ &
 & 0.10382E+04_JPRB,0.78212E+03_JPRB,0.60065E+03_JPRB,0.88632E+03_JPRB,0.11725E+04_JPRB /)  
KB(:, 5,47,13) = (/ &
 & 0.10417E+04_JPRB,0.78639E+03_JPRB,0.59976E+03_JPRB,0.88480E+03_JPRB,0.11705E+04_JPRB /)  
KB(:, 1,48,13) = (/ &
 & 0.10401E+04_JPRB,0.78456E+03_JPRB,0.60307E+03_JPRB,0.88865E+03_JPRB,0.11757E+04_JPRB /)  
KB(:, 2,48,13) = (/ &
 & 0.10385E+04_JPRB,0.78639E+03_JPRB,0.60262E+03_JPRB,0.88799E+03_JPRB,0.11748E+04_JPRB /)  
KB(:, 3,48,13) = (/ &
 & 0.10377E+04_JPRB,0.78374E+03_JPRB,0.60183E+03_JPRB,0.88778E+03_JPRB,0.11745E+04_JPRB /)  
KB(:, 4,48,13) = (/ &
 & 0.10347E+04_JPRB,0.78455E+03_JPRB,0.60102E+03_JPRB,0.88707E+03_JPRB,0.11732E+04_JPRB /)  
KB(:, 5,48,13) = (/ &
 & 0.10420E+04_JPRB,0.79085E+03_JPRB,0.60005E+03_JPRB,0.88545E+03_JPRB,0.11713E+04_JPRB /)  
KB(:, 1,49,13) = (/ &
 & 0.10372E+04_JPRB,0.78740E+03_JPRB,0.60317E+03_JPRB,0.88862E+03_JPRB,0.11760E+04_JPRB /)  
KB(:, 2,49,13) = (/ &
 & 0.10417E+04_JPRB,0.78862E+03_JPRB,0.60282E+03_JPRB,0.88818E+03_JPRB,0.11751E+04_JPRB /)  
KB(:, 3,49,13) = (/ &
 & 0.10345E+04_JPRB,0.78780E+03_JPRB,0.60227E+03_JPRB,0.88818E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 4,49,13) = (/ &
 & 0.10406E+04_JPRB,0.78617E+03_JPRB,0.60221E+03_JPRB,0.88729E+03_JPRB,0.11738E+04_JPRB /)  
KB(:, 5,49,13) = (/ &
 & 0.10382E+04_JPRB,0.79023E+03_JPRB,0.60061E+03_JPRB,0.88605E+03_JPRB,0.11721E+04_JPRB /)  
KB(:, 1,50,13) = (/ &
 & 0.10347E+04_JPRB,0.79207E+03_JPRB,0.60367E+03_JPRB,0.88900E+03_JPRB,0.11761E+04_JPRB /)  
KB(:, 2,50,13) = (/ &
 & 0.10350E+04_JPRB,0.78739E+03_JPRB,0.60298E+03_JPRB,0.88872E+03_JPRB,0.11755E+04_JPRB /)  
KB(:, 3,50,13) = (/ &
 & 0.10353E+04_JPRB,0.78433E+03_JPRB,0.60234E+03_JPRB,0.88799E+03_JPRB,0.11744E+04_JPRB /)  
KB(:, 4,50,13) = (/ &
 & 0.10489E+04_JPRB,0.79267E+03_JPRB,0.60164E+03_JPRB,0.88763E+03_JPRB,0.11743E+04_JPRB /)  
KB(:, 5,50,13) = (/ &
 & 0.10406E+04_JPRB,0.78514E+03_JPRB,0.60019E+03_JPRB,0.88656E+03_JPRB,0.11728E+04_JPRB /)  
KB(:, 1,51,13) = (/ &
 & 0.10345E+04_JPRB,0.78799E+03_JPRB,0.60398E+03_JPRB,0.88932E+03_JPRB,0.11765E+04_JPRB /)  
KB(:, 2,51,13) = (/ &
 & 0.10401E+04_JPRB,0.78697E+03_JPRB,0.60314E+03_JPRB,0.88874E+03_JPRB,0.11758E+04_JPRB /)  
KB(:, 3,51,13) = (/ &
 & 0.10366E+04_JPRB,0.78656E+03_JPRB,0.60285E+03_JPRB,0.88803E+03_JPRB,0.11749E+04_JPRB /)  
KB(:, 4,51,13) = (/ &
 & 0.10374E+04_JPRB,0.78473E+03_JPRB,0.60240E+03_JPRB,0.88809E+03_JPRB,0.11746E+04_JPRB /)  
KB(:, 5,51,13) = (/ &
 & 0.10390E+04_JPRB,0.78920E+03_JPRB,0.60116E+03_JPRB,0.88701E+03_JPRB,0.11734E+04_JPRB /)  
KB(:, 1,52,13) = (/ &
 & 0.10369E+04_JPRB,0.78758E+03_JPRB,0.60425E+03_JPRB,0.88974E+03_JPRB,0.11770E+04_JPRB /)  
KB(:, 2,52,13) = (/ &
 & 0.10369E+04_JPRB,0.78229E+03_JPRB,0.60357E+03_JPRB,0.88889E+03_JPRB,0.11760E+04_JPRB /)  
KB(:, 3,52,13) = (/ &
 & 0.10371E+04_JPRB,0.78737E+03_JPRB,0.60287E+03_JPRB,0.88826E+03_JPRB,0.11752E+04_JPRB /)  
KB(:, 4,52,13) = (/ &
 & 0.10414E+04_JPRB,0.78574E+03_JPRB,0.60234E+03_JPRB,0.88797E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 5,52,13) = (/ &
 & 0.10377E+04_JPRB,0.78696E+03_JPRB,0.60170E+03_JPRB,0.88739E+03_JPRB,0.11739E+04_JPRB /)  
KB(:, 1,53,13) = (/ &
 & 0.10446E+04_JPRB,0.78533E+03_JPRB,0.60451E+03_JPRB,0.89022E+03_JPRB,0.11778E+04_JPRB /)  
KB(:, 2,53,13) = (/ &
 & 0.10366E+04_JPRB,0.78675E+03_JPRB,0.60391E+03_JPRB,0.88907E+03_JPRB,0.11762E+04_JPRB /)  
KB(:, 3,53,13) = (/ &
 & 0.10339E+04_JPRB,0.78472E+03_JPRB,0.60302E+03_JPRB,0.88857E+03_JPRB,0.11756E+04_JPRB /)  
KB(:, 4,53,13) = (/ &
 & 0.10347E+04_JPRB,0.78858E+03_JPRB,0.60271E+03_JPRB,0.88799E+03_JPRB,0.11748E+04_JPRB /)  
KB(:, 5,53,13) = (/ &
 & 0.10414E+04_JPRB,0.78370E+03_JPRB,0.60188E+03_JPRB,0.88770E+03_JPRB,0.11743E+04_JPRB /)  
KB(:, 1,54,13) = (/ &
 & 0.10366E+04_JPRB,0.78980E+03_JPRB,0.60463E+03_JPRB,0.89072E+03_JPRB,0.11788E+04_JPRB /)  
KB(:, 2,54,13) = (/ &
 & 0.10376E+04_JPRB,0.78289E+03_JPRB,0.60402E+03_JPRB,0.88939E+03_JPRB,0.11765E+04_JPRB /)  
KB(:, 3,54,13) = (/ &
 & 0.10387E+04_JPRB,0.78695E+03_JPRB,0.60318E+03_JPRB,0.88877E+03_JPRB,0.11759E+04_JPRB /)  
KB(:, 4,54,13) = (/ &
 & 0.10435E+04_JPRB,0.78370E+03_JPRB,0.60273E+03_JPRB,0.88806E+03_JPRB,0.11749E+04_JPRB /)  
KB(:, 5,54,13) = (/ &
 & 0.10492E+04_JPRB,0.79000E+03_JPRB,0.60214E+03_JPRB,0.88789E+03_JPRB,0.11746E+04_JPRB /)  
KB(:, 1,55,13) = (/ &
 & 0.10395E+04_JPRB,0.78654E+03_JPRB,0.60524E+03_JPRB,0.89136E+03_JPRB,0.11799E+04_JPRB /)  
KB(:, 2,55,13) = (/ &
 & 0.10379E+04_JPRB,0.78553E+03_JPRB,0.60426E+03_JPRB,0.88977E+03_JPRB,0.11770E+04_JPRB /)  
KB(:, 3,55,13) = (/ &
 & 0.10376E+04_JPRB,0.78959E+03_JPRB,0.60343E+03_JPRB,0.88890E+03_JPRB,0.11757E+04_JPRB /)  
KB(:, 4,55,13) = (/ &
 & 0.10360E+04_JPRB,0.78634E+03_JPRB,0.60272E+03_JPRB,0.88828E+03_JPRB,0.11752E+04_JPRB /)  
KB(:, 5,55,13) = (/ &
 & 0.10355E+04_JPRB,0.78796E+03_JPRB,0.60219E+03_JPRB,0.88821E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 1,56,13) = (/ &
 & 0.10500E+04_JPRB,0.78471E+03_JPRB,0.60540E+03_JPRB,0.89210E+03_JPRB,0.11812E+04_JPRB /)  
KB(:, 2,56,13) = (/ &
 & 0.10441E+04_JPRB,0.78735E+03_JPRB,0.60449E+03_JPRB,0.89019E+03_JPRB,0.11777E+04_JPRB /)  
KB(:, 3,56,13) = (/ &
 & 0.10382E+04_JPRB,0.78755E+03_JPRB,0.60374E+03_JPRB,0.88905E+03_JPRB,0.11759E+04_JPRB /)  
KB(:, 4,56,13) = (/ &
 & 0.10470E+04_JPRB,0.78715E+03_JPRB,0.60301E+03_JPRB,0.88855E+03_JPRB,0.11756E+04_JPRB /)  
KB(:, 5,56,13) = (/ &
 & 0.10358E+04_JPRB,0.78674E+03_JPRB,0.60270E+03_JPRB,0.88799E+03_JPRB,0.11748E+04_JPRB /)  
KB(:, 1,57,13) = (/ &
 & 0.10339E+04_JPRB,0.78715E+03_JPRB,0.60588E+03_JPRB,0.89295E+03_JPRB,0.11828E+04_JPRB /)  
KB(:, 2,57,13) = (/ &
 & 0.10441E+04_JPRB,0.78267E+03_JPRB,0.60475E+03_JPRB,0.89065E+03_JPRB,0.11787E+04_JPRB /)  
KB(:, 3,57,13) = (/ &
 & 0.10435E+04_JPRB,0.78938E+03_JPRB,0.60399E+03_JPRB,0.88934E+03_JPRB,0.11765E+04_JPRB /)  
KB(:, 4,57,13) = (/ &
 & 0.10392E+04_JPRB,0.79203E+03_JPRB,0.60300E+03_JPRB,0.88875E+03_JPRB,0.11758E+04_JPRB /)  
KB(:, 5,57,13) = (/ &
 & 0.10360E+04_JPRB,0.78491E+03_JPRB,0.60271E+03_JPRB,0.88827E+03_JPRB,0.11749E+04_JPRB /)  
KB(:, 1,58,13) = (/ &
 & 0.10392E+04_JPRB,0.78430E+03_JPRB,0.60601E+03_JPRB,0.89398E+03_JPRB,0.11847E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART32',1,ZHOOK_HANDLE)
END SUBROUTINE PART32


SUBROUTINE PART33

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART33',0,ZHOOK_HANDLE)


KB(:, 2,58,13) = (/ &
 & 0.10363E+04_JPRB,0.78694E+03_JPRB,0.60503E+03_JPRB,0.89124E+03_JPRB,0.11797E+04_JPRB /)  
KB(:, 3,58,13) = (/ &
 & 0.10360E+04_JPRB,0.78084E+03_JPRB,0.60391E+03_JPRB,0.88970E+03_JPRB,0.11769E+04_JPRB /)  
KB(:, 4,58,13) = (/ &
 & 0.10459E+04_JPRB,0.78267E+03_JPRB,0.60338E+03_JPRB,0.88888E+03_JPRB,0.11757E+04_JPRB /)  
KB(:, 5,58,13) = (/ &
 & 0.10368E+04_JPRB,0.79101E+03_JPRB,0.60285E+03_JPRB,0.88823E+03_JPRB,0.11752E+04_JPRB /)  
KB(:, 1,59,13) = (/ &
 & 0.10403E+04_JPRB,0.78613E+03_JPRB,0.60612E+03_JPRB,0.89444E+03_JPRB,0.11849E+04_JPRB /)  
KB(:, 2,59,13) = (/ &
 & 0.10349E+04_JPRB,0.78531E+03_JPRB,0.60514E+03_JPRB,0.89150E+03_JPRB,0.11802E+04_JPRB /)  
KB(:, 3,59,13) = (/ &
 & 0.10360E+04_JPRB,0.78470E+03_JPRB,0.60447E+03_JPRB,0.88985E+03_JPRB,0.11771E+04_JPRB /)  
KB(:, 4,59,13) = (/ &
 & 0.10411E+04_JPRB,0.78531E+03_JPRB,0.60349E+03_JPRB,0.88892E+03_JPRB,0.11761E+04_JPRB /)  
KB(:, 5,59,13) = (/ &
 & 0.10355E+04_JPRB,0.78795E+03_JPRB,0.60275E+03_JPRB,0.88833E+03_JPRB,0.11753E+04_JPRB /)  
KB(:, 1,13,14) = (/ &
 & 0.12194E+04_JPRB,0.91192E+03_JPRB,0.60649E+03_JPRB,0.89289E+03_JPRB,0.11803E+04_JPRB /)  
KB(:, 2,13,14) = (/ &
 & 0.11340E+04_JPRB,0.93388E+03_JPRB,0.60565E+03_JPRB,0.89163E+03_JPRB,0.11786E+04_JPRB /)  
KB(:, 3,13,14) = (/ &
 & 0.11287E+04_JPRB,0.93154E+03_JPRB,0.60510E+03_JPRB,0.89077E+03_JPRB,0.11775E+04_JPRB /)  
KB(:, 4,13,14) = (/ &
 & 0.11571E+04_JPRB,0.89198E+03_JPRB,0.60383E+03_JPRB,0.88977E+03_JPRB,0.11762E+04_JPRB /)  
KB(:, 5,13,14) = (/ &
 & 0.11232E+04_JPRB,0.85932E+03_JPRB,0.60280E+03_JPRB,0.88865E+03_JPRB,0.11748E+04_JPRB /)  
KB(:, 1,14,14) = (/ &
 & 0.11313E+04_JPRB,0.85574E+03_JPRB,0.60604E+03_JPRB,0.89259E+03_JPRB,0.11800E+04_JPRB /)  
KB(:, 2,14,14) = (/ &
 & 0.11392E+04_JPRB,0.85278E+03_JPRB,0.60523E+03_JPRB,0.89143E+03_JPRB,0.11785E+04_JPRB /)  
KB(:, 3,14,14) = (/ &
 & 0.11402E+04_JPRB,0.86846E+03_JPRB,0.60420E+03_JPRB,0.89055E+03_JPRB,0.11774E+04_JPRB /)  
KB(:, 4,14,14) = (/ &
 & 0.11058E+04_JPRB,0.85128E+03_JPRB,0.60339E+03_JPRB,0.88920E+03_JPRB,0.11761E+04_JPRB /)  
KB(:, 5,14,14) = (/ &
 & 0.11286E+04_JPRB,0.84325E+03_JPRB,0.60241E+03_JPRB,0.88842E+03_JPRB,0.11746E+04_JPRB /)  
KB(:, 1,15,14) = (/ &
 & 0.11349E+04_JPRB,0.84417E+03_JPRB,0.60541E+03_JPRB,0.89231E+03_JPRB,0.11798E+04_JPRB /)  
KB(:, 2,15,14) = (/ &
 & 0.11015E+04_JPRB,0.88045E+03_JPRB,0.60487E+03_JPRB,0.89125E+03_JPRB,0.11784E+04_JPRB /)  
KB(:, 3,15,14) = (/ &
 & 0.11261E+04_JPRB,0.83776E+03_JPRB,0.60408E+03_JPRB,0.89034E+03_JPRB,0.11772E+04_JPRB /)  
KB(:, 4,15,14) = (/ &
 & 0.10962E+04_JPRB,0.86597E+03_JPRB,0.60302E+03_JPRB,0.88937E+03_JPRB,0.11760E+04_JPRB /)  
KB(:, 5,15,14) = (/ &
 & 0.10995E+04_JPRB,0.86095E+03_JPRB,0.60207E+03_JPRB,0.88855E+03_JPRB,0.11740E+04_JPRB /)  
KB(:, 1,16,14) = (/ &
 & 0.11556E+04_JPRB,0.89943E+03_JPRB,0.60533E+03_JPRB,0.89241E+03_JPRB,0.11796E+04_JPRB /)  
KB(:, 2,16,14) = (/ &
 & 0.10928E+04_JPRB,0.87845E+03_JPRB,0.60456E+03_JPRB,0.89108E+03_JPRB,0.11783E+04_JPRB /)  
KB(:, 3,16,14) = (/ &
 & 0.11526E+04_JPRB,0.84568E+03_JPRB,0.60375E+03_JPRB,0.89014E+03_JPRB,0.11771E+04_JPRB /)  
KB(:, 4,16,14) = (/ &
 & 0.11224E+04_JPRB,0.82958E+03_JPRB,0.60245E+03_JPRB,0.88919E+03_JPRB,0.11758E+04_JPRB /)  
KB(:, 5,16,14) = (/ &
 & 0.11104E+04_JPRB,0.83492E+03_JPRB,0.60177E+03_JPRB,0.88796E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 1,17,14) = (/ &
 & 0.11093E+04_JPRB,0.86391E+03_JPRB,0.60505E+03_JPRB,0.89183E+03_JPRB,0.11794E+04_JPRB /)  
KB(:, 2,17,14) = (/ &
 & 0.10879E+04_JPRB,0.83992E+03_JPRB,0.60455E+03_JPRB,0.89093E+03_JPRB,0.11782E+04_JPRB /)  
KB(:, 3,17,14) = (/ &
 & 0.11180E+04_JPRB,0.83675E+03_JPRB,0.60345E+03_JPRB,0.88997E+03_JPRB,0.11769E+04_JPRB /)  
KB(:, 4,17,14) = (/ &
 & 0.11203E+04_JPRB,0.81299E+03_JPRB,0.60195E+03_JPRB,0.88902E+03_JPRB,0.11757E+04_JPRB /)  
KB(:, 5,17,14) = (/ &
 & 0.10902E+04_JPRB,0.84755E+03_JPRB,0.60151E+03_JPRB,0.88739E+03_JPRB,0.11736E+04_JPRB /)  
KB(:, 1,18,14) = (/ &
 & 0.10889E+04_JPRB,0.82171E+03_JPRB,0.60482E+03_JPRB,0.89199E+03_JPRB,0.11792E+04_JPRB /)  
KB(:, 2,18,14) = (/ &
 & 0.10836E+04_JPRB,0.85518E+03_JPRB,0.60408E+03_JPRB,0.89079E+03_JPRB,0.11781E+04_JPRB /)  
KB(:, 3,18,14) = (/ &
 & 0.10919E+04_JPRB,0.82437E+03_JPRB,0.60318E+03_JPRB,0.88981E+03_JPRB,0.11763E+04_JPRB /)  
KB(:, 4,18,14) = (/ &
 & 0.11143E+04_JPRB,0.86811E+03_JPRB,0.60223E+03_JPRB,0.88886E+03_JPRB,0.11755E+04_JPRB /)  
KB(:, 5,18,14) = (/ &
 & 0.10618E+04_JPRB,0.80694E+03_JPRB,0.60104E+03_JPRB,0.88718E+03_JPRB,0.11738E+04_JPRB /)  
KB(:, 1,19,14) = (/ &
 & 0.10700E+04_JPRB,0.81179E+03_JPRB,0.60437E+03_JPRB,0.89145E+03_JPRB,0.11790E+04_JPRB /)  
KB(:, 2,19,14) = (/ &
 & 0.11096E+04_JPRB,0.84185E+03_JPRB,0.60389E+03_JPRB,0.89066E+03_JPRB,0.11785E+04_JPRB /)  
KB(:, 3,19,14) = (/ &
 & 0.10919E+04_JPRB,0.82575E+03_JPRB,0.60295E+03_JPRB,0.89004E+03_JPRB,0.11767E+04_JPRB /)  
KB(:, 4,19,14) = (/ &
 & 0.10874E+04_JPRB,0.81974E+03_JPRB,0.60205E+03_JPRB,0.88835E+03_JPRB,0.11754E+04_JPRB /)  
KB(:, 5,19,14) = (/ &
 & 0.11077E+04_JPRB,0.86723E+03_JPRB,0.60084E+03_JPRB,0.88734E+03_JPRB,0.11727E+04_JPRB /)  
KB(:, 1,20,14) = (/ &
 & 0.10813E+04_JPRB,0.82037E+03_JPRB,0.60443E+03_JPRB,0.89128E+03_JPRB,0.11789E+04_JPRB /)  
KB(:, 2,20,14) = (/ &
 & 0.10944E+04_JPRB,0.83718E+03_JPRB,0.60369E+03_JPRB,0.89052E+03_JPRB,0.11778E+04_JPRB /)  
KB(:, 3,20,14) = (/ &
 & 0.10922E+04_JPRB,0.81527E+03_JPRB,0.60248E+03_JPRB,0.88953E+03_JPRB,0.11765E+04_JPRB /)  
KB(:, 4,20,14) = (/ &
 & 0.10962E+04_JPRB,0.82815E+03_JPRB,0.60188E+03_JPRB,0.88854E+03_JPRB,0.11752E+04_JPRB /)  
KB(:, 5,20,14) = (/ &
 & 0.10768E+04_JPRB,0.81150E+03_JPRB,0.60064E+03_JPRB,0.88711E+03_JPRB,0.11734E+04_JPRB /)  
KB(:, 1,21,14) = (/ &
 & 0.10919E+04_JPRB,0.79941E+03_JPRB,0.60426E+03_JPRB,0.89114E+03_JPRB,0.11787E+04_JPRB /)  
KB(:, 2,21,14) = (/ &
 & 0.10481E+04_JPRB,0.83111E+03_JPRB,0.60351E+03_JPRB,0.89037E+03_JPRB,0.11777E+04_JPRB /)  
KB(:, 3,21,14) = (/ &
 & 0.10716E+04_JPRB,0.81475E+03_JPRB,0.60253E+03_JPRB,0.88975E+03_JPRB,0.11764E+04_JPRB /)  
KB(:, 4,21,14) = (/ &
 & 0.11197E+04_JPRB,0.80344E+03_JPRB,0.60123E+03_JPRB,0.88837E+03_JPRB,0.11750E+04_JPRB /)  
KB(:, 5,21,14) = (/ &
 & 0.10436E+04_JPRB,0.80977E+03_JPRB,0.60045E+03_JPRB,0.88688E+03_JPRB,0.11731E+04_JPRB /)  
KB(:, 1,22,14) = (/ &
 & 0.11028E+04_JPRB,0.82019E+03_JPRB,0.60406E+03_JPRB,0.89099E+03_JPRB,0.11785E+04_JPRB /)  
KB(:, 2,22,14) = (/ &
 & 0.10664E+04_JPRB,0.84127E+03_JPRB,0.60327E+03_JPRB,0.89089E+03_JPRB,0.11775E+04_JPRB /)  
KB(:, 3,22,14) = (/ &
 & 0.10764E+04_JPRB,0.83101E+03_JPRB,0.60182E+03_JPRB,0.88920E+03_JPRB,0.11762E+04_JPRB /)  
KB(:, 4,22,14) = (/ &
 & 0.10955E+04_JPRB,0.82928E+03_JPRB,0.60175E+03_JPRB,0.88811E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 5,22,14) = (/ &
 & 0.10429E+04_JPRB,0.82150E+03_JPRB,0.60042E+03_JPRB,0.88653E+03_JPRB,0.11726E+04_JPRB /)  
KB(:, 1,23,14) = (/ &
 & 0.10449E+04_JPRB,0.79677E+03_JPRB,0.60363E+03_JPRB,0.89084E+03_JPRB,0.11784E+04_JPRB /)  
KB(:, 2,23,14) = (/ &
 & 0.10443E+04_JPRB,0.81477E+03_JPRB,0.60352E+03_JPRB,0.88994E+03_JPRB,0.11772E+04_JPRB /)  
KB(:, 3,23,14) = (/ &
 & 0.10490E+04_JPRB,0.84026E+03_JPRB,0.60112E+03_JPRB,0.88900E+03_JPRB,0.11759E+04_JPRB /)  
KB(:, 4,23,14) = (/ &
 & 0.10652E+04_JPRB,0.80737E+03_JPRB,0.60128E+03_JPRB,0.88783E+03_JPRB,0.11744E+04_JPRB /)  
KB(:, 5,23,14) = (/ &
 & 0.10777E+04_JPRB,0.80975E+03_JPRB,0.60014E+03_JPRB,0.88615E+03_JPRB,0.11722E+04_JPRB /)  
KB(:, 1,24,14) = (/ &
 & 0.10587E+04_JPRB,0.83370E+03_JPRB,0.60369E+03_JPRB,0.89067E+03_JPRB,0.11782E+04_JPRB /)  
KB(:, 2,24,14) = (/ &
 & 0.10413E+04_JPRB,0.79049E+03_JPRB,0.60278E+03_JPRB,0.88972E+03_JPRB,0.11769E+04_JPRB /)  
KB(:, 3,24,14) = (/ &
 & 0.10508E+04_JPRB,0.83928E+03_JPRB,0.60192E+03_JPRB,0.88879E+03_JPRB,0.11757E+04_JPRB /)  
KB(:, 4,24,14) = (/ &
 & 0.10667E+04_JPRB,0.80304E+03_JPRB,0.60105E+03_JPRB,0.88752E+03_JPRB,0.11740E+04_JPRB /)  
KB(:, 5,24,14) = (/ &
 & 0.10776E+04_JPRB,0.78685E+03_JPRB,0.59985E+03_JPRB,0.88574E+03_JPRB,0.11716E+04_JPRB /)  
KB(:, 1,25,14) = (/ &
 & 0.10559E+04_JPRB,0.78648E+03_JPRB,0.60348E+03_JPRB,0.89048E+03_JPRB,0.11779E+04_JPRB /)  
KB(:, 2,25,14) = (/ &
 & 0.10600E+04_JPRB,0.81980E+03_JPRB,0.60253E+03_JPRB,0.88951E+03_JPRB,0.11766E+04_JPRB /)  
KB(:, 3,25,14) = (/ &
 & 0.10484E+04_JPRB,0.79331E+03_JPRB,0.60149E+03_JPRB,0.88854E+03_JPRB,0.11754E+04_JPRB /)  
KB(:, 4,25,14) = (/ &
 & 0.11000E+04_JPRB,0.80548E+03_JPRB,0.60080E+03_JPRB,0.88717E+03_JPRB,0.11735E+04_JPRB /)  
KB(:, 5,25,14) = (/ &
 & 0.11165E+04_JPRB,0.79968E+03_JPRB,0.59952E+03_JPRB,0.88528E+03_JPRB,0.11711E+04_JPRB /)  
KB(:, 1,26,14) = (/ &
 & 0.10604E+04_JPRB,0.79570E+03_JPRB,0.60325E+03_JPRB,0.89026E+03_JPRB,0.11777E+04_JPRB /)  
KB(:, 2,26,14) = (/ &
 & 0.10870E+04_JPRB,0.78311E+03_JPRB,0.60230E+03_JPRB,0.88929E+03_JPRB,0.11764E+04_JPRB /)  
KB(:, 3,26,14) = (/ &
 & 0.10476E+04_JPRB,0.79338E+03_JPRB,0.60128E+03_JPRB,0.88826E+03_JPRB,0.11750E+04_JPRB /)  
KB(:, 4,26,14) = (/ &
 & 0.10459E+04_JPRB,0.80175E+03_JPRB,0.60027E+03_JPRB,0.88677E+03_JPRB,0.11730E+04_JPRB /)  
KB(:, 5,26,14) = (/ &
 & 0.10485E+04_JPRB,0.81112E+03_JPRB,0.59892E+03_JPRB,0.88476E+03_JPRB,0.11704E+04_JPRB /)  
KB(:, 1,27,14) = (/ &
 & 0.10458E+04_JPRB,0.79457E+03_JPRB,0.60301E+03_JPRB,0.89001E+03_JPRB,0.11773E+04_JPRB /)  
KB(:, 2,27,14) = (/ &
 & 0.10576E+04_JPRB,0.79170E+03_JPRB,0.60208E+03_JPRB,0.88906E+03_JPRB,0.11761E+04_JPRB /)  
KB(:, 3,27,14) = (/ &
 & 0.10632E+04_JPRB,0.79464E+03_JPRB,0.60130E+03_JPRB,0.88794E+03_JPRB,0.11741E+04_JPRB /)  
KB(:, 4,27,14) = (/ &
 & 0.10506E+04_JPRB,0.80916E+03_JPRB,0.60021E+03_JPRB,0.88633E+03_JPRB,0.11725E+04_JPRB /)  
KB(:, 5,27,14) = (/ &
 & 0.10406E+04_JPRB,0.79035E+03_JPRB,0.59878E+03_JPRB,0.88422E+03_JPRB,0.11697E+04_JPRB /)  
KB(:, 1,28,14) = (/ &
 & 0.10390E+04_JPRB,0.79142E+03_JPRB,0.60274E+03_JPRB,0.88940E+03_JPRB,0.11770E+04_JPRB /)  
KB(:, 2,28,14) = (/ &
 & 0.10793E+04_JPRB,0.84664E+03_JPRB,0.60165E+03_JPRB,0.88883E+03_JPRB,0.11758E+04_JPRB /)  
KB(:, 3,28,14) = (/ &
 & 0.10389E+04_JPRB,0.81244E+03_JPRB,0.60106E+03_JPRB,0.88760E+03_JPRB,0.11741E+04_JPRB /)  
KB(:, 4,28,14) = (/ &
 & 0.10910E+04_JPRB,0.82250E+03_JPRB,0.59988E+03_JPRB,0.88586E+03_JPRB,0.11718E+04_JPRB /)  
KB(:, 5,28,14) = (/ &
 & 0.10984E+04_JPRB,0.79766E+03_JPRB,0.59863E+03_JPRB,0.88510E+03_JPRB,0.11689E+04_JPRB /)  
KB(:, 1,29,14) = (/ &
 & 0.10453E+04_JPRB,0.79421E+03_JPRB,0.60249E+03_JPRB,0.88988E+03_JPRB,0.11767E+04_JPRB /)  
KB(:, 2,29,14) = (/ &
 & 0.10759E+04_JPRB,0.85231E+03_JPRB,0.59780E+03_JPRB,0.88856E+03_JPRB,0.11754E+04_JPRB /)  
KB(:, 3,29,14) = (/ &
 & 0.10355E+04_JPRB,0.83260E+03_JPRB,0.60079E+03_JPRB,0.88721E+03_JPRB,0.11736E+04_JPRB /)  
KB(:, 4,29,14) = (/ &
 & 0.10260E+04_JPRB,0.78313E+03_JPRB,0.59953E+03_JPRB,0.88535E+03_JPRB,0.11712E+04_JPRB /)  
KB(:, 5,29,14) = (/ &
 & 0.10495E+04_JPRB,0.79101E+03_JPRB,0.59751E+03_JPRB,0.88309E+03_JPRB,0.11682E+04_JPRB /)  
KB(:, 1,30,14) = (/ &
 & 0.10479E+04_JPRB,0.78753E+03_JPRB,0.60225E+03_JPRB,0.88928E+03_JPRB,0.11764E+04_JPRB /)  
KB(:, 2,30,14) = (/ &
 & 0.10451E+04_JPRB,0.80563E+03_JPRB,0.60150E+03_JPRB,0.88827E+03_JPRB,0.11750E+04_JPRB /)  
KB(:, 3,30,14) = (/ &
 & 0.10758E+04_JPRB,0.79525E+03_JPRB,0.60050E+03_JPRB,0.88643E+03_JPRB,0.11731E+04_JPRB /)  
KB(:, 4,30,14) = (/ &
 & 0.10781E+04_JPRB,0.79929E+03_JPRB,0.59916E+03_JPRB,0.88480E+03_JPRB,0.11705E+04_JPRB /)  
KB(:, 5,30,14) = (/ &
 & 0.10459E+04_JPRB,0.81358E+03_JPRB,0.59790E+03_JPRB,0.88220E+03_JPRB,0.11665E+04_JPRB /)  
KB(:, 1,31,14) = (/ &
 & 0.10607E+04_JPRB,0.80146E+03_JPRB,0.60204E+03_JPRB,0.88905E+03_JPRB,0.11761E+04_JPRB /)  
KB(:, 2,31,14) = (/ &
 & 0.10395E+04_JPRB,0.78822E+03_JPRB,0.60127E+03_JPRB,0.88793E+03_JPRB,0.11746E+04_JPRB /)  
KB(:, 3,31,14) = (/ &
 & 0.10321E+04_JPRB,0.80923E+03_JPRB,0.60018E+03_JPRB,0.88632E+03_JPRB,0.11725E+04_JPRB /)  
KB(:, 4,31,14) = (/ &
 & 0.11042E+04_JPRB,0.80049E+03_JPRB,0.59875E+03_JPRB,0.88457E+03_JPRB,0.11697E+04_JPRB /)  
KB(:, 5,31,14) = (/ &
 & 0.10581E+04_JPRB,0.80105E+03_JPRB,0.59750E+03_JPRB,0.88200E+03_JPRB,0.11672E+04_JPRB /)  
KB(:, 1,32,14) = (/ &
 & 0.10889E+04_JPRB,0.84488E+03_JPRB,0.59867E+03_JPRB,0.88880E+03_JPRB,0.11757E+04_JPRB /)  
KB(:, 2,32,14) = (/ &
 & 0.10428E+04_JPRB,0.79586E+03_JPRB,0.60101E+03_JPRB,0.88756E+03_JPRB,0.11741E+04_JPRB /)  
KB(:, 3,32,14) = (/ &
 & 0.10671E+04_JPRB,0.82487E+03_JPRB,0.59984E+03_JPRB,0.88582E+03_JPRB,0.11718E+04_JPRB /)  
KB(:, 4,32,14) = (/ &
 & 0.10426E+04_JPRB,0.83726E+03_JPRB,0.59809E+03_JPRB,0.88469E+03_JPRB,0.11694E+04_JPRB /)  
KB(:, 5,32,14) = (/ &
 & 0.10522E+04_JPRB,0.80937E+03_JPRB,0.59684E+03_JPRB,0.88175E+03_JPRB,0.11659E+04_JPRB /)  
KB(:, 1,33,14) = (/ &
 & 0.10391E+04_JPRB,0.79980E+03_JPRB,0.60166E+03_JPRB,0.88852E+03_JPRB,0.11754E+04_JPRB /)  
KB(:, 2,33,14) = (/ &
 & 0.10719E+04_JPRB,0.78917E+03_JPRB,0.60073E+03_JPRB,0.88751E+03_JPRB,0.11736E+04_JPRB /)  
KB(:, 3,33,14) = (/ &
 & 0.10389E+04_JPRB,0.82235E+03_JPRB,0.59947E+03_JPRB,0.88564E+03_JPRB,0.11706E+04_JPRB /)  
KB(:, 4,33,14) = (/ &
 & 0.10819E+04_JPRB,0.81877E+03_JPRB,0.59794E+03_JPRB,0.88337E+03_JPRB,0.11676E+04_JPRB /)  
KB(:, 5,33,14) = (/ &
 & 0.10266E+04_JPRB,0.78772E+03_JPRB,0.59642E+03_JPRB,0.88112E+03_JPRB,0.11651E+04_JPRB /)  
KB(:, 1,34,14) = (/ &
 & 0.10675E+04_JPRB,0.78932E+03_JPRB,0.60147E+03_JPRB,0.88789E+03_JPRB,0.11750E+04_JPRB /)  
KB(:, 2,34,14) = (/ &
 & 0.10375E+04_JPRB,0.79310E+03_JPRB,0.60047E+03_JPRB,0.88677E+03_JPRB,0.11731E+04_JPRB /)  
KB(:, 3,34,14) = (/ &
 & 0.10378E+04_JPRB,0.82372E+03_JPRB,0.59913E+03_JPRB,0.88478E+03_JPRB,0.11704E+04_JPRB /)  
KB(:, 4,34,14) = (/ &
 & 0.10677E+04_JPRB,0.78757E+03_JPRB,0.59836E+03_JPRB,0.88254E+03_JPRB,0.11660E+04_JPRB /)  
KB(:, 5,34,14) = (/ &
 & 0.10419E+04_JPRB,0.77666E+03_JPRB,0.59604E+03_JPRB,0.87984E+03_JPRB,0.11644E+04_JPRB /)  
KB(:, 1,35,14) = (/ &
 & 0.10613E+04_JPRB,0.80031E+03_JPRB,0.60136E+03_JPRB,0.88808E+03_JPRB,0.11748E+04_JPRB /)  
KB(:, 2,35,14) = (/ &
 & 0.11118E+04_JPRB,0.80250E+03_JPRB,0.60031E+03_JPRB,0.88654E+03_JPRB,0.11732E+04_JPRB /)  
KB(:, 3,35,14) = (/ &
 & 0.10759E+04_JPRB,0.83185E+03_JPRB,0.59892E+03_JPRB,0.88448E+03_JPRB,0.11701E+04_JPRB /)  
KB(:, 4,35,14) = (/ &
 & 0.11049E+04_JPRB,0.77622E+03_JPRB,0.59743E+03_JPRB,0.88477E+03_JPRB,0.11680E+04_JPRB /)  
KB(:, 5,35,14) = (/ &
 & 0.10459E+04_JPRB,0.78322E+03_JPRB,0.59581E+03_JPRB,0.87986E+03_JPRB,0.11634E+04_JPRB /)  
KB(:, 1,36,14) = (/ &
 & 0.10396E+04_JPRB,0.79026E+03_JPRB,0.60134E+03_JPRB,0.88805E+03_JPRB,0.11748E+04_JPRB /)  
KB(:, 2,36,14) = (/ &
 & 0.10471E+04_JPRB,0.80778E+03_JPRB,0.60028E+03_JPRB,0.88614E+03_JPRB,0.11727E+04_JPRB /)  
KB(:, 3,36,14) = (/ &
 & 0.10450E+04_JPRB,0.79912E+03_JPRB,0.59889E+03_JPRB,0.88407E+03_JPRB,0.11700E+04_JPRB /)  
KB(:, 4,36,14) = (/ &
 & 0.10626E+04_JPRB,0.80803E+03_JPRB,0.59740E+03_JPRB,0.88257E+03_JPRB,0.11756E+04_JPRB /)  
KB(:, 5,36,14) = (/ &
 & 0.10609E+04_JPRB,0.81056E+03_JPRB,0.59577E+03_JPRB,0.87981E+03_JPRB,0.11634E+04_JPRB /)  
KB(:, 1,37,14) = (/ &
 & 0.10479E+04_JPRB,0.79014E+03_JPRB,0.60145E+03_JPRB,0.88822E+03_JPRB,0.11750E+04_JPRB /)  
KB(:, 2,37,14) = (/ &
 & 0.10744E+04_JPRB,0.81437E+03_JPRB,0.60044E+03_JPRB,0.88637E+03_JPRB,0.11730E+04_JPRB /)  
KB(:, 3,37,14) = (/ &
 & 0.10335E+04_JPRB,0.79550E+03_JPRB,0.59909E+03_JPRB,0.88473E+03_JPRB,0.11704E+04_JPRB /)  
KB(:, 4,37,14) = (/ &
 & 0.10410E+04_JPRB,0.77504E+03_JPRB,0.59808E+03_JPRB,0.88321E+03_JPRB,0.11674E+04_JPRB /)  
KB(:, 5,37,14) = (/ &
 & 0.10557E+04_JPRB,0.79226E+03_JPRB,0.59599E+03_JPRB,0.88014E+03_JPRB,0.11643E+04_JPRB /)  
KB(:, 1,38,14) = (/ &
 & 0.10418E+04_JPRB,0.80249E+03_JPRB,0.60156E+03_JPRB,0.88838E+03_JPRB,0.11752E+04_JPRB /)  
KB(:, 2,38,14) = (/ &
 & 0.10220E+04_JPRB,0.82577E+03_JPRB,0.60060E+03_JPRB,0.88697E+03_JPRB,0.11733E+04_JPRB /)  
KB(:, 3,38,14) = (/ &
 & 0.10502E+04_JPRB,0.80915E+03_JPRB,0.59929E+03_JPRB,0.88503E+03_JPRB,0.11708E+04_JPRB /)  
KB(:, 4,38,14) = (/ &
 & 0.10497E+04_JPRB,0.81774E+03_JPRB,0.59826E+03_JPRB,0.88277E+03_JPRB,0.11673E+04_JPRB /)  
KB(:, 5,38,14) = (/ &
 & 0.10771E+04_JPRB,0.81134E+03_JPRB,0.59623E+03_JPRB,0.88049E+03_JPRB,0.11648E+04_JPRB /)  
KB(:, 1,39,14) = (/ &
 & 0.10165E+04_JPRB,0.77782E+03_JPRB,0.60118E+03_JPRB,0.88854E+03_JPRB,0.11754E+04_JPRB /)  
KB(:, 2,39,14) = (/ &
 & 0.10531E+04_JPRB,0.80302E+03_JPRB,0.60075E+03_JPRB,0.88719E+03_JPRB,0.11736E+04_JPRB /)  
KB(:, 3,39,14) = (/ &
 & 0.10758E+04_JPRB,0.78257E+03_JPRB,0.59949E+03_JPRB,0.88533E+03_JPRB,0.11712E+04_JPRB /)  
KB(:, 4,39,14) = (/ &
 & 0.10568E+04_JPRB,0.79852E+03_JPRB,0.59772E+03_JPRB,0.88307E+03_JPRB,0.11677E+04_JPRB /)  
KB(:, 5,39,14) = (/ &
 & 0.11120E+04_JPRB,0.79275E+03_JPRB,0.59645E+03_JPRB,0.88083E+03_JPRB,0.11652E+04_JPRB /)  
KB(:, 1,40,14) = (/ &
 & 0.10416E+04_JPRB,0.79660E+03_JPRB,0.59890E+03_JPRB,0.88879E+03_JPRB,0.11758E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART33',1,ZHOOK_HANDLE)
END SUBROUTINE PART33


SUBROUTINE PART34

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART34',0,ZHOOK_HANDLE)


KB(:, 2,40,14) = (/ &
 & 0.10391E+04_JPRB,0.79051E+03_JPRB,0.60100E+03_JPRB,0.88756E+03_JPRB,0.11741E+04_JPRB /)  
KB(:, 3,40,14) = (/ &
 & 0.10420E+04_JPRB,0.78155E+03_JPRB,0.59983E+03_JPRB,0.88583E+03_JPRB,0.11718E+04_JPRB /)  
KB(:, 4,40,14) = (/ &
 & 0.10496E+04_JPRB,0.79527E+03_JPRB,0.59833E+03_JPRB,0.88434E+03_JPRB,0.11689E+04_JPRB /)  
KB(:, 5,40,14) = (/ &
 & 0.10264E+04_JPRB,0.78919E+03_JPRB,0.59684E+03_JPRB,0.88140E+03_JPRB,0.11660E+04_JPRB /)  
KB(:, 1,41,14) = (/ &
 & 0.10689E+04_JPRB,0.80516E+03_JPRB,0.60103E+03_JPRB,0.88904E+03_JPRB,0.11761E+04_JPRB /)  
KB(:, 2,41,14) = (/ &
 & 0.10416E+04_JPRB,0.82239E+03_JPRB,0.60124E+03_JPRB,0.88792E+03_JPRB,0.11746E+04_JPRB /)  
KB(:, 3,41,14) = (/ &
 & 0.10563E+04_JPRB,0.81535E+03_JPRB,0.60016E+03_JPRB,0.88632E+03_JPRB,0.11725E+04_JPRB /)  
KB(:, 4,41,14) = (/ &
 & 0.10676E+04_JPRB,0.82044E+03_JPRB,0.59873E+03_JPRB,0.88421E+03_JPRB,0.11697E+04_JPRB /)  
KB(:, 5,41,14) = (/ &
 & 0.10596E+04_JPRB,0.78372E+03_JPRB,0.59724E+03_JPRB,0.88164E+03_JPRB,0.11672E+04_JPRB /)  
KB(:, 1,42,14) = (/ &
 & 0.10655E+04_JPRB,0.80320E+03_JPRB,0.60196E+03_JPRB,0.88927E+03_JPRB,0.11764E+04_JPRB /)  
KB(:, 2,42,14) = (/ &
 & 0.10714E+04_JPRB,0.78435E+03_JPRB,0.60147E+03_JPRB,0.88825E+03_JPRB,0.11750E+04_JPRB /)  
KB(:, 3,42,14) = (/ &
 & 0.10516E+04_JPRB,0.79392E+03_JPRB,0.60071E+03_JPRB,0.88678E+03_JPRB,0.11731E+04_JPRB /)  
KB(:, 4,42,14) = (/ &
 & 0.10516E+04_JPRB,0.77763E+03_JPRB,0.59913E+03_JPRB,0.88479E+03_JPRB,0.11700E+04_JPRB /)  
KB(:, 5,42,14) = (/ &
 & 0.10486E+04_JPRB,0.79390E+03_JPRB,0.59811E+03_JPRB,0.88255E+03_JPRB,0.11641E+04_JPRB /)  
KB(:, 1,43,14) = (/ &
 & 0.10979E+04_JPRB,0.83796E+03_JPRB,0.60248E+03_JPRB,0.88955E+03_JPRB,0.11768E+04_JPRB /)  
KB(:, 2,43,14) = (/ &
 & 0.11147E+04_JPRB,0.76548E+03_JPRB,0.60171E+03_JPRB,0.88861E+03_JPRB,0.11750E+04_JPRB /)  
KB(:, 3,43,14) = (/ &
 & 0.10326E+04_JPRB,0.79357E+03_JPRB,0.60081E+03_JPRB,0.88729E+03_JPRB,0.11738E+04_JPRB /)  
KB(:, 4,43,14) = (/ &
 & 0.10439E+04_JPRB,0.86155E+03_JPRB,0.59958E+03_JPRB,0.88546E+03_JPRB,0.11709E+04_JPRB /)  
KB(:, 5,43,14) = (/ &
 & 0.10945E+04_JPRB,0.81749E+03_JPRB,0.59781E+03_JPRB,0.88321E+03_JPRB,0.11679E+04_JPRB /)  
KB(:, 1,44,14) = (/ &
 & 0.10684E+04_JPRB,0.83027E+03_JPRB,0.60306E+03_JPRB,0.88988E+03_JPRB,0.11772E+04_JPRB /)  
KB(:, 2,44,14) = (/ &
 & 0.10549E+04_JPRB,0.78589E+03_JPRB,0.60194E+03_JPRB,0.88895E+03_JPRB,0.11755E+04_JPRB /)  
KB(:, 3,44,14) = (/ &
 & 0.10654E+04_JPRB,0.79705E+03_JPRB,0.60140E+03_JPRB,0.88779E+03_JPRB,0.11744E+04_JPRB /)  
KB(:, 4,44,14) = (/ &
 & 0.10595E+04_JPRB,0.79130E+03_JPRB,0.59979E+03_JPRB,0.88614E+03_JPRB,0.11722E+04_JPRB /)  
KB(:, 5,44,14) = (/ &
 & 0.10477E+04_JPRB,0.80597E+03_JPRB,0.59858E+03_JPRB,0.88363E+03_JPRB,0.11704E+04_JPRB /)  
KB(:, 1,45,14) = (/ &
 & 0.10873E+04_JPRB,0.79417E+03_JPRB,0.60313E+03_JPRB,0.89023E+03_JPRB,0.11777E+04_JPRB /)  
KB(:, 2,45,14) = (/ &
 & 0.10616E+04_JPRB,0.78299E+03_JPRB,0.60195E+03_JPRB,0.88889E+03_JPRB,0.11764E+04_JPRB /)  
KB(:, 3,45,14) = (/ &
 & 0.10452E+04_JPRB,0.80979E+03_JPRB,0.60145E+03_JPRB,0.88823E+03_JPRB,0.11745E+04_JPRB /)  
KB(:, 4,45,14) = (/ &
 & 0.10957E+04_JPRB,0.80372E+03_JPRB,0.60045E+03_JPRB,0.88675E+03_JPRB,0.11726E+04_JPRB /)  
KB(:, 5,45,14) = (/ &
 & 0.10725E+04_JPRB,0.79223E+03_JPRB,0.59886E+03_JPRB,0.88476E+03_JPRB,0.11704E+04_JPRB /)  
KB(:, 1,46,14) = (/ &
 & 0.10477E+04_JPRB,0.79958E+03_JPRB,0.60344E+03_JPRB,0.89054E+03_JPRB,0.11781E+04_JPRB /)  
KB(:, 2,46,14) = (/ &
 & 0.10873E+04_JPRB,0.80021E+03_JPRB,0.60251E+03_JPRB,0.88958E+03_JPRB,0.11768E+04_JPRB /)  
KB(:, 3,46,14) = (/ &
 & 0.10228E+04_JPRB,0.78903E+03_JPRB,0.60173E+03_JPRB,0.88864E+03_JPRB,0.11751E+04_JPRB /)  
KB(:, 4,46,14) = (/ &
 & 0.10295E+04_JPRB,0.83052E+03_JPRB,0.60085E+03_JPRB,0.88734E+03_JPRB,0.11738E+04_JPRB /)  
KB(:, 5,46,14) = (/ &
 & 0.10527E+04_JPRB,0.80434E+03_JPRB,0.59963E+03_JPRB,0.88553E+03_JPRB,0.11714E+04_JPRB /)  
KB(:, 1,47,14) = (/ &
 & 0.10317E+04_JPRB,0.78934E+03_JPRB,0.60373E+03_JPRB,0.89119E+03_JPRB,0.11785E+04_JPRB /)  
KB(:, 2,47,14) = (/ &
 & 0.10325E+04_JPRB,0.79125E+03_JPRB,0.60291E+03_JPRB,0.88999E+03_JPRB,0.11778E+04_JPRB /)  
KB(:, 3,47,14) = (/ &
 & 0.10417E+04_JPRB,0.79891E+03_JPRB,0.60152E+03_JPRB,0.88904E+03_JPRB,0.11761E+04_JPRB /)  
KB(:, 4,47,14) = (/ &
 & 0.10561E+04_JPRB,0.78901E+03_JPRB,0.60124E+03_JPRB,0.88793E+03_JPRB,0.11746E+04_JPRB /)  
KB(:, 5,47,14) = (/ &
 & 0.10468E+04_JPRB,0.79347E+03_JPRB,0.59991E+03_JPRB,0.88632E+03_JPRB,0.11725E+04_JPRB /)  
KB(:, 1,48,14) = (/ &
 & 0.10540E+04_JPRB,0.78901E+03_JPRB,0.60401E+03_JPRB,0.89113E+03_JPRB,0.11789E+04_JPRB /)  
KB(:, 2,48,14) = (/ &
 & 0.10320E+04_JPRB,0.80975E+03_JPRB,0.60327E+03_JPRB,0.89037E+03_JPRB,0.11779E+04_JPRB /)  
KB(:, 3,48,14) = (/ &
 & 0.10535E+04_JPRB,0.79283E+03_JPRB,0.60233E+03_JPRB,0.88940E+03_JPRB,0.11766E+04_JPRB /)  
KB(:, 4,48,14) = (/ &
 & 0.10485E+04_JPRB,0.81102E+03_JPRB,0.60158E+03_JPRB,0.88807E+03_JPRB,0.11753E+04_JPRB /)  
KB(:, 5,48,14) = (/ &
 & 0.10337E+04_JPRB,0.82793E+03_JPRB,0.60064E+03_JPRB,0.88703E+03_JPRB,0.11734E+04_JPRB /)  
KB(:, 1,49,14) = (/ &
 & 0.10304E+04_JPRB,0.83177E+03_JPRB,0.60454E+03_JPRB,0.89164E+03_JPRB,0.11796E+04_JPRB /)  
KB(:, 2,49,14) = (/ &
 & 0.10417E+04_JPRB,0.78580E+03_JPRB,0.60359E+03_JPRB,0.89069E+03_JPRB,0.11783E+04_JPRB /)  
KB(:, 3,49,14) = (/ &
 & 0.10725E+04_JPRB,0.82186E+03_JPRB,0.60271E+03_JPRB,0.88942E+03_JPRB,0.11771E+04_JPRB /)  
KB(:, 4,49,14) = (/ &
 & 0.10362E+04_JPRB,0.80207E+03_JPRB,0.60065E+03_JPRB,0.88885E+03_JPRB,0.11758E+04_JPRB /)  
KB(:, 5,49,14) = (/ &
 & 0.10383E+04_JPRB,0.79856E+03_JPRB,0.60081E+03_JPRB,0.88765E+03_JPRB,0.11743E+04_JPRB /)  
KB(:, 1,50,14) = (/ &
 & 0.10581E+04_JPRB,0.78356E+03_JPRB,0.60457E+03_JPRB,0.89226E+03_JPRB,0.11805E+04_JPRB /)  
KB(:, 2,50,14) = (/ &
 & 0.10447E+04_JPRB,0.80207E+03_JPRB,0.60385E+03_JPRB,0.89058E+03_JPRB,0.11786E+04_JPRB /)  
KB(:, 3,50,14) = (/ &
 & 0.10788E+04_JPRB,0.82154E+03_JPRB,0.60308E+03_JPRB,0.89017E+03_JPRB,0.11776E+04_JPRB /)  
KB(:, 4,50,14) = (/ &
 & 0.10695E+04_JPRB,0.79696E+03_JPRB,0.60214E+03_JPRB,0.88920E+03_JPRB,0.11763E+04_JPRB /)  
KB(:, 5,50,14) = (/ &
 & 0.10859E+04_JPRB,0.79983E+03_JPRB,0.60140E+03_JPRB,0.88816E+03_JPRB,0.11749E+04_JPRB /)  
KB(:, 1,51,14) = (/ &
 & 0.10459E+04_JPRB,0.79632E+03_JPRB,0.60498E+03_JPRB,0.89284E+03_JPRB,0.11812E+04_JPRB /)  
KB(:, 2,51,14) = (/ &
 & 0.10371E+04_JPRB,0.78419E+03_JPRB,0.60411E+03_JPRB,0.89166E+03_JPRB,0.11796E+04_JPRB /)  
KB(:, 3,51,14) = (/ &
 & 0.10657E+04_JPRB,0.82185E+03_JPRB,0.60315E+03_JPRB,0.89049E+03_JPRB,0.11780E+04_JPRB /)  
KB(:, 4,51,14) = (/ &
 & 0.10396E+04_JPRB,0.78418E+03_JPRB,0.60197E+03_JPRB,0.88917E+03_JPRB,0.11768E+04_JPRB /)  
KB(:, 5,51,14) = (/ &
 & 0.10354E+04_JPRB,0.78290E+03_JPRB,0.60169E+03_JPRB,0.88859E+03_JPRB,0.11755E+04_JPRB /)  
KB(:, 1,52,14) = (/ &
 & 0.10434E+04_JPRB,0.78546E+03_JPRB,0.60574E+03_JPRB,0.89370E+03_JPRB,0.11824E+04_JPRB /)  
KB(:, 2,52,14) = (/ &
 & 0.10665E+04_JPRB,0.78610E+03_JPRB,0.60413E+03_JPRB,0.89180E+03_JPRB,0.11798E+04_JPRB /)  
KB(:, 3,52,14) = (/ &
 & 0.10821E+04_JPRB,0.78641E+03_JPRB,0.60367E+03_JPRB,0.89113E+03_JPRB,0.11784E+04_JPRB /)  
KB(:, 4,52,14) = (/ &
 & 0.10514E+04_JPRB,0.79279E+03_JPRB,0.60282E+03_JPRB,0.88989E+03_JPRB,0.11772E+04_JPRB /)  
KB(:, 5,52,14) = (/ &
 & 0.10408E+04_JPRB,0.77939E+03_JPRB,0.60170E+03_JPRB,0.88895E+03_JPRB,0.11760E+04_JPRB /)  
KB(:, 1,53,14) = (/ &
 & 0.10497E+04_JPRB,0.80875E+03_JPRB,0.60601E+03_JPRB,0.89382E+03_JPRB,0.11825E+04_JPRB /)  
KB(:, 2,53,14) = (/ &
 & 0.10514E+04_JPRB,0.81226E+03_JPRB,0.60441E+03_JPRB,0.89243E+03_JPRB,0.11807E+04_JPRB /)  
KB(:, 3,53,14) = (/ &
 & 0.11137E+04_JPRB,0.80237E+03_JPRB,0.60392E+03_JPRB,0.89101E+03_JPRB,0.11787E+04_JPRB /)  
KB(:, 4,53,14) = (/ &
 & 0.10661E+04_JPRB,0.79885E+03_JPRB,0.60292E+03_JPRB,0.89026E+03_JPRB,0.11777E+04_JPRB /)  
KB(:, 5,53,14) = (/ &
 & 0.10324E+04_JPRB,0.82343E+03_JPRB,0.60222E+03_JPRB,0.88929E+03_JPRB,0.11764E+04_JPRB /)  
KB(:, 1,54,14) = (/ &
 & 0.10594E+04_JPRB,0.86492E+03_JPRB,0.60646E+03_JPRB,0.89428E+03_JPRB,0.11831E+04_JPRB /)  
KB(:, 2,54,14) = (/ &
 & 0.10303E+04_JPRB,0.85949E+03_JPRB,0.60506E+03_JPRB,0.89294E+03_JPRB,0.11813E+04_JPRB /)  
KB(:, 3,54,14) = (/ &
 & 0.10905E+04_JPRB,0.84800E+03_JPRB,0.60416E+03_JPRB,0.89138E+03_JPRB,0.11793E+04_JPRB /)  
KB(:, 4,54,14) = (/ &
 & 0.10438E+04_JPRB,0.78736E+03_JPRB,0.60344E+03_JPRB,0.89055E+03_JPRB,0.11781E+04_JPRB /)  
KB(:, 5,54,14) = (/ &
 & 0.10324E+04_JPRB,0.83619E+03_JPRB,0.60252E+03_JPRB,0.88959E+03_JPRB,0.11768E+04_JPRB /)  
KB(:, 1,55,14) = (/ &
 & 0.10463E+04_JPRB,0.78385E+03_JPRB,0.60663E+03_JPRB,0.89475E+03_JPRB,0.11838E+04_JPRB /)  
KB(:, 2,55,14) = (/ &
 & 0.10543E+04_JPRB,0.79119E+03_JPRB,0.60552E+03_JPRB,0.89337E+03_JPRB,0.11824E+04_JPRB /)  
KB(:, 3,55,14) = (/ &
 & 0.10391E+04_JPRB,0.80395E+03_JPRB,0.60439E+03_JPRB,0.89183E+03_JPRB,0.11799E+04_JPRB /)  
KB(:, 4,55,14) = (/ &
 & 0.10421E+04_JPRB,0.79916E+03_JPRB,0.60368E+03_JPRB,0.89078E+03_JPRB,0.11784E+04_JPRB /)  
KB(:, 5,55,14) = (/ &
 & 0.10909E+04_JPRB,0.78448E+03_JPRB,0.60284E+03_JPRB,0.88955E+03_JPRB,0.11777E+04_JPRB /)  
KB(:, 1,56,14) = (/ &
 & 0.10143E+04_JPRB,0.81481E+03_JPRB,0.60727E+03_JPRB,0.89531E+03_JPRB,0.11848E+04_JPRB /)  
KB(:, 2,56,14) = (/ &
 & 0.10240E+04_JPRB,0.81034E+03_JPRB,0.60598E+03_JPRB,0.89378E+03_JPRB,0.11825E+04_JPRB /)  
KB(:, 3,56,14) = (/ &
 & 0.10324E+04_JPRB,0.78927E+03_JPRB,0.60463E+03_JPRB,0.89238E+03_JPRB,0.11806E+04_JPRB /)  
KB(:, 4,56,14) = (/ &
 & 0.10273E+04_JPRB,0.78959E+03_JPRB,0.60390E+03_JPRB,0.89099E+03_JPRB,0.11787E+04_JPRB /)  
KB(:, 5,56,14) = (/ &
 & 0.10404E+04_JPRB,0.80937E+03_JPRB,0.60290E+03_JPRB,0.89024E+03_JPRB,0.11777E+04_JPRB /)  
KB(:, 1,57,14) = (/ &
 & 0.10408E+04_JPRB,0.79150E+03_JPRB,0.60742E+03_JPRB,0.89593E+03_JPRB,0.11860E+04_JPRB /)  
KB(:, 2,57,14) = (/ &
 & 0.10640E+04_JPRB,0.82150E+03_JPRB,0.60641E+03_JPRB,0.89422E+03_JPRB,0.11831E+04_JPRB /)  
KB(:, 3,57,14) = (/ &
 & 0.10551E+04_JPRB,0.79661E+03_JPRB,0.60501E+03_JPRB,0.89288E+03_JPRB,0.11813E+04_JPRB /)  
KB(:, 4,57,14) = (/ &
 & 0.10817E+04_JPRB,0.79118E+03_JPRB,0.60413E+03_JPRB,0.89133E+03_JPRB,0.11792E+04_JPRB /)  
KB(:, 5,57,14) = (/ &
 & 0.10370E+04_JPRB,0.79629E+03_JPRB,0.60341E+03_JPRB,0.89015E+03_JPRB,0.11781E+04_JPRB /)  
KB(:, 1,58,14) = (/ &
 & 0.10442E+04_JPRB,0.84033E+03_JPRB,0.60809E+03_JPRB,0.89672E+03_JPRB,0.11869E+04_JPRB /)  
KB(:, 2,58,14) = (/ &
 & 0.10934E+04_JPRB,0.79820E+03_JPRB,0.60680E+03_JPRB,0.89466E+03_JPRB,0.11837E+04_JPRB /)  
KB(:, 3,58,14) = (/ &
 & 0.10657E+04_JPRB,0.80043E+03_JPRB,0.60544E+03_JPRB,0.89329E+03_JPRB,0.11818E+04_JPRB /)  
KB(:, 4,58,14) = (/ &
 & 0.10223E+04_JPRB,0.78480E+03_JPRB,0.60435E+03_JPRB,0.89175E+03_JPRB,0.11798E+04_JPRB /)  
KB(:, 5,58,14) = (/ &
 & 0.10438E+04_JPRB,0.81735E+03_JPRB,0.60364E+03_JPRB,0.89074E+03_JPRB,0.11789E+04_JPRB /)  
KB(:, 1,59,14) = (/ &
 & 0.10513E+04_JPRB,0.80331E+03_JPRB,0.60826E+03_JPRB,0.89709E+03_JPRB,0.11883E+04_JPRB /)  
KB(:, 2,59,14) = (/ &
 & 0.10429E+04_JPRB,0.81799E+03_JPRB,0.60696E+03_JPRB,0.89486E+03_JPRB,0.11840E+04_JPRB /)  
KB(:, 3,59,14) = (/ &
 & 0.10400E+04_JPRB,0.80905E+03_JPRB,0.60537E+03_JPRB,0.89345E+03_JPRB,0.11830E+04_JPRB /)  
KB(:, 4,59,14) = (/ &
 & 0.10488E+04_JPRB,0.79628E+03_JPRB,0.60443E+03_JPRB,0.89194E+03_JPRB,0.11800E+04_JPRB /)  
KB(:, 5,59,14) = (/ &
 & 0.10795E+04_JPRB,0.78415E+03_JPRB,0.60372E+03_JPRB,0.89082E+03_JPRB,0.11785E+04_JPRB /)  
KB(:, 1,13,15) = (/ &
 & 0.98934E+03_JPRB,0.75572E+03_JPRB,0.60810E+03_JPRB,0.89364E+03_JPRB,0.11812E+04_JPRB /)  
KB(:, 2,13,15) = (/ &
 & 0.12809E+04_JPRB,0.72091E+03_JPRB,0.60670E+03_JPRB,0.89251E+03_JPRB,0.11797E+04_JPRB /)  
KB(:, 3,13,15) = (/ &
 & 0.11704E+04_JPRB,0.77844E+03_JPRB,0.60529E+03_JPRB,0.89171E+03_JPRB,0.11787E+04_JPRB /)  
KB(:, 4,13,15) = (/ &
 & 0.11159E+04_JPRB,0.83495E+03_JPRB,0.60430E+03_JPRB,0.89110E+03_JPRB,0.11779E+04_JPRB /)  
KB(:, 5,13,15) = (/ &
 & 0.11939E+04_JPRB,0.93553E+03_JPRB,0.60355E+03_JPRB,0.89003E+03_JPRB,0.11765E+04_JPRB /)  
KB(:, 1,14,15) = (/ &
 & 0.11963E+04_JPRB,0.95315E+03_JPRB,0.60753E+03_JPRB,0.89338E+03_JPRB,0.11810E+04_JPRB /)  
KB(:, 2,14,15) = (/ &
 & 0.11729E+04_JPRB,0.92141E+03_JPRB,0.60616E+03_JPRB,0.89229E+03_JPRB,0.11796E+04_JPRB /)  
KB(:, 3,14,15) = (/ &
 & 0.11471E+04_JPRB,0.85602E+03_JPRB,0.60478E+03_JPRB,0.89154E+03_JPRB,0.11786E+04_JPRB /)  
KB(:, 4,14,15) = (/ &
 & 0.11824E+04_JPRB,0.88196E+03_JPRB,0.60401E+03_JPRB,0.89091E+03_JPRB,0.11778E+04_JPRB /)  
KB(:, 5,14,15) = (/ &
 & 0.11271E+04_JPRB,0.87462E+03_JPRB,0.60324E+03_JPRB,0.89075E+03_JPRB,0.11763E+04_JPRB /)  
KB(:, 1,15,15) = (/ &
 & 0.10604E+04_JPRB,0.90519E+03_JPRB,0.60703E+03_JPRB,0.89409E+03_JPRB,0.11809E+04_JPRB /)  
KB(:, 2,15,15) = (/ &
 & 0.11577E+04_JPRB,0.75557E+03_JPRB,0.60568E+03_JPRB,0.89209E+03_JPRB,0.11795E+04_JPRB /)  
KB(:, 3,15,15) = (/ &
 & 0.11406E+04_JPRB,0.81803E+03_JPRB,0.60438E+03_JPRB,0.89138E+03_JPRB,0.11785E+04_JPRB /)  
KB(:, 4,15,15) = (/ &
 & 0.11847E+04_JPRB,0.71960E+03_JPRB,0.60376E+03_JPRB,0.89073E+03_JPRB,0.11790E+04_JPRB /)  
KB(:, 5,15,15) = (/ &
 & 0.11179E+04_JPRB,0.81112E+03_JPRB,0.60296E+03_JPRB,0.88859E+03_JPRB,0.11787E+04_JPRB /)  
KB(:, 1,16,15) = (/ &
 & 0.10356E+04_JPRB,0.71983E+03_JPRB,0.60659E+03_JPRB,0.89194E+03_JPRB,0.11820E+04_JPRB /)  
KB(:, 2,16,15) = (/ &
 & 0.11364E+04_JPRB,0.76870E+03_JPRB,0.60526E+03_JPRB,0.89190E+03_JPRB,0.11794E+04_JPRB /)  
KB(:, 3,16,15) = (/ &
 & 0.96034E+03_JPRB,0.83277E+03_JPRB,0.60407E+03_JPRB,0.89124E+03_JPRB,0.11785E+04_JPRB /)  
KB(:, 4,16,15) = (/ &
 & 0.10077E+04_JPRB,0.87988E+03_JPRB,0.60354E+03_JPRB,0.89055E+03_JPRB,0.11776E+04_JPRB /)  
KB(:, 5,16,15) = (/ &
 & 0.10422E+04_JPRB,0.83397E+03_JPRB,0.60335E+03_JPRB,0.88931E+03_JPRB,0.11759E+04_JPRB /)  
KB(:, 1,17,15) = (/ &
 & 0.10091E+04_JPRB,0.77782E+03_JPRB,0.60621E+03_JPRB,0.89269E+03_JPRB,0.11805E+04_JPRB /)  
KB(:, 2,17,15) = (/ &
 & 0.11716E+04_JPRB,0.80971E+03_JPRB,0.60425E+03_JPRB,0.89175E+03_JPRB,0.11793E+04_JPRB /)  
KB(:, 3,17,15) = (/ &
 & 0.10550E+04_JPRB,0.78786E+03_JPRB,0.60385E+03_JPRB,0.89112E+03_JPRB,0.11784E+04_JPRB /)  
KB(:, 4,17,15) = (/ &
 & 0.99990E+03_JPRB,0.88096E+03_JPRB,0.60335E+03_JPRB,0.89039E+03_JPRB,0.11774E+04_JPRB /)  
KB(:, 5,17,15) = (/ &
 & 0.11263E+04_JPRB,0.73127E+03_JPRB,0.60311E+03_JPRB,0.88908E+03_JPRB,0.11770E+04_JPRB /)  
KB(:, 1,18,15) = (/ &
 & 0.11151E+04_JPRB,0.85991E+03_JPRB,0.60588E+03_JPRB,0.89155E+03_JPRB,0.11804E+04_JPRB /)  
KB(:, 2,18,15) = (/ &
 & 0.10413E+04_JPRB,0.70815E+03_JPRB,0.60458E+03_JPRB,0.89161E+03_JPRB,0.11791E+04_JPRB /)  
KB(:, 3,18,15) = (/ &
 & 0.11058E+04_JPRB,0.82037E+03_JPRB,0.60370E+03_JPRB,0.89101E+03_JPRB,0.11783E+04_JPRB /)  
KB(:, 4,18,15) = (/ &
 & 0.10134E+04_JPRB,0.64109E+03_JPRB,0.60383E+03_JPRB,0.89024E+03_JPRB,0.11786E+04_JPRB /)  
KB(:, 5,18,15) = (/ &
 & 0.11497E+04_JPRB,0.88170E+03_JPRB,0.60224E+03_JPRB,0.88981E+03_JPRB,0.11767E+04_JPRB /)  
KB(:, 1,19,15) = (/ &
 & 0.10261E+04_JPRB,0.82130E+03_JPRB,0.60625E+03_JPRB,0.89236E+03_JPRB,0.11802E+04_JPRB /)  
KB(:, 2,19,15) = (/ &
 & 0.10077E+04_JPRB,0.78017E+03_JPRB,0.60431E+03_JPRB,0.89148E+03_JPRB,0.11778E+04_JPRB /)  
KB(:, 3,19,15) = (/ &
 & 0.10505E+04_JPRB,0.75163E+03_JPRB,0.60422E+03_JPRB,0.88995E+03_JPRB,0.11782E+04_JPRB /)  
KB(:, 4,19,15) = (/ &
 & 0.10498E+04_JPRB,0.84163E+03_JPRB,0.60302E+03_JPRB,0.89009E+03_JPRB,0.11772E+04_JPRB /)  
KB(:, 5,19,15) = (/ &
 & 0.94853E+03_JPRB,0.71012E+03_JPRB,0.60269E+03_JPRB,0.88958E+03_JPRB,0.11765E+04_JPRB /)  
KB(:, 1,20,15) = (/ &
 & 0.11198E+04_JPRB,0.83291E+03_JPRB,0.60532E+03_JPRB,0.89221E+03_JPRB,0.11814E+04_JPRB /)  
KB(:, 2,20,15) = (/ &
 & 0.10146E+04_JPRB,0.70988E+03_JPRB,0.60473E+03_JPRB,0.89136E+03_JPRB,0.11789E+04_JPRB /)  
KB(:, 3,20,15) = (/ &
 & 0.98440E+03_JPRB,0.83872E+03_JPRB,0.60345E+03_JPRB,0.89080E+03_JPRB,0.11781E+04_JPRB /)  
KB(:, 4,20,15) = (/ &
 & 0.10595E+04_JPRB,0.75621E+03_JPRB,0.60286E+03_JPRB,0.88992E+03_JPRB,0.11770E+04_JPRB /)  
KB(:, 5,20,15) = (/ &
 & 0.10274E+04_JPRB,0.81836E+03_JPRB,0.60247E+03_JPRB,0.88836E+03_JPRB,0.11749E+04_JPRB /)  
KB(:, 1,21,15) = (/ &
 & 0.10788E+04_JPRB,0.78645E+03_JPRB,0.60506E+03_JPRB,0.89207E+03_JPRB,0.11799E+04_JPRB /)  
KB(:, 2,21,15) = (/ &
 & 0.10852E+04_JPRB,0.74295E+03_JPRB,0.60386E+03_JPRB,0.89125E+03_JPRB,0.11788E+04_JPRB /)  
KB(:, 3,21,15) = (/ &
 & 0.10428E+04_JPRB,0.82396E+03_JPRB,0.60333E+03_JPRB,0.88973E+03_JPRB,0.11780E+04_JPRB /)  
KB(:, 4,21,15) = (/ &
 & 0.10018E+04_JPRB,0.87387E+03_JPRB,0.60336E+03_JPRB,0.89071E+03_JPRB,0.11768E+04_JPRB /)  
KB(:, 5,21,15) = (/ &
 & 0.11155E+04_JPRB,0.79293E+03_JPRB,0.60225E+03_JPRB,0.88809E+03_JPRB,0.11746E+04_JPRB /)  
KB(:, 1,22,15) = (/ &
 & 0.10301E+04_JPRB,0.79445E+03_JPRB,0.60539E+03_JPRB,0.89186E+03_JPRB,0.11797E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART34',1,ZHOOK_HANDLE)
END SUBROUTINE PART34


SUBROUTINE PART35

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART35',0,ZHOOK_HANDLE)


KB(:, 2,22,15) = (/ &
 & 0.11174E+04_JPRB,0.68851E+03_JPRB,0.60364E+03_JPRB,0.88919E+03_JPRB,0.11787E+04_JPRB /)  
KB(:, 3,22,15) = (/ &
 & 0.10845E+04_JPRB,0.72821E+03_JPRB,0.60320E+03_JPRB,0.89053E+03_JPRB,0.11779E+04_JPRB /)  
KB(:, 4,22,15) = (/ &
 & 0.94182E+03_JPRB,0.74129E+03_JPRB,0.60185E+03_JPRB,0.88948E+03_JPRB,0.11777E+04_JPRB /)  
KB(:, 5,22,15) = (/ &
 & 0.11256E+04_JPRB,0.74069E+03_JPRB,0.60323E+03_JPRB,0.88766E+03_JPRB,0.11740E+04_JPRB /)  
KB(:, 1,23,15) = (/ &
 & 0.11218E+04_JPRB,0.85968E+03_JPRB,0.60443E+03_JPRB,0.89167E+03_JPRB,0.11795E+04_JPRB /)  
KB(:, 2,23,15) = (/ &
 & 0.10449E+04_JPRB,0.80739E+03_JPRB,0.60218E+03_JPRB,0.89100E+03_JPRB,0.11785E+04_JPRB /)  
KB(:, 3,23,15) = (/ &
 & 0.11277E+04_JPRB,0.69098E+03_JPRB,0.60306E+03_JPRB,0.89036E+03_JPRB,0.11777E+04_JPRB /)  
KB(:, 4,23,15) = (/ &
 & 0.10580E+04_JPRB,0.81384E+03_JPRB,0.60228E+03_JPRB,0.88919E+03_JPRB,0.11761E+04_JPRB /)  
KB(:, 5,23,15) = (/ &
 & 0.10279E+04_JPRB,0.82530E+03_JPRB,0.60094E+03_JPRB,0.88718E+03_JPRB,0.11734E+04_JPRB /)  
KB(:, 1,24,15) = (/ &
 & 0.10227E+04_JPRB,0.68179E+03_JPRB,0.60412E+03_JPRB,0.89149E+03_JPRB,0.11792E+04_JPRB /)  
KB(:, 2,24,15) = (/ &
 & 0.11518E+04_JPRB,0.80624E+03_JPRB,0.60338E+03_JPRB,0.89088E+03_JPRB,0.11784E+04_JPRB /)  
KB(:, 3,24,15) = (/ &
 & 0.10788E+04_JPRB,0.70820E+03_JPRB,0.60290E+03_JPRB,0.89016E+03_JPRB,0.11787E+04_JPRB /)  
KB(:, 4,24,15) = (/ &
 & 0.10466E+04_JPRB,0.82233E+03_JPRB,0.60268E+03_JPRB,0.88884E+03_JPRB,0.11757E+04_JPRB /)  
KB(:, 5,24,15) = (/ &
 & 0.10066E+04_JPRB,0.82618E+03_JPRB,0.60057E+03_JPRB,0.88665E+03_JPRB,0.11740E+04_JPRB /)  
KB(:, 1,25,15) = (/ &
 & 0.10780E+04_JPRB,0.80937E+03_JPRB,0.60386E+03_JPRB,0.89131E+03_JPRB,0.11790E+04_JPRB /)  
KB(:, 2,25,15) = (/ &
 & 0.10199E+04_JPRB,0.81059E+03_JPRB,0.60327E+03_JPRB,0.89075E+03_JPRB,0.11782E+04_JPRB /)  
KB(:, 3,25,15) = (/ &
 & 0.11207E+04_JPRB,0.80162E+03_JPRB,0.60338E+03_JPRB,0.88992E+03_JPRB,0.11771E+04_JPRB /)  
KB(:, 4,25,15) = (/ &
 & 0.97495E+03_JPRB,0.78589E+03_JPRB,0.60305E+03_JPRB,0.88845E+03_JPRB,0.11751E+04_JPRB /)  
KB(:, 5,25,15) = (/ &
 & 0.95428E+03_JPRB,0.80945E+03_JPRB,0.60015E+03_JPRB,0.88605E+03_JPRB,0.11720E+04_JPRB /)  
KB(:, 1,26,15) = (/ &
 & 0.10862E+04_JPRB,0.78235E+03_JPRB,0.60361E+03_JPRB,0.89115E+03_JPRB,0.11801E+04_JPRB /)  
KB(:, 2,26,15) = (/ &
 & 0.91581E+03_JPRB,0.82546E+03_JPRB,0.60381E+03_JPRB,0.89059E+03_JPRB,0.11780E+04_JPRB /)  
KB(:, 3,26,15) = (/ &
 & 0.10920E+04_JPRB,0.84813E+03_JPRB,0.60253E+03_JPRB,0.88964E+03_JPRB,0.11767E+04_JPRB /)  
KB(:, 4,26,15) = (/ &
 & 0.11174E+04_JPRB,0.83078E+03_JPRB,0.60207E+03_JPRB,0.88892E+03_JPRB,0.11745E+04_JPRB /)  
KB(:, 5,26,15) = (/ &
 & 0.11159E+04_JPRB,0.75128E+03_JPRB,0.59967E+03_JPRB,0.88536E+03_JPRB,0.11723E+04_JPRB /)  
KB(:, 1,27,15) = (/ &
 & 0.10835E+04_JPRB,0.80424E+03_JPRB,0.60343E+03_JPRB,0.89101E+03_JPRB,0.11786E+04_JPRB /)  
KB(:, 2,27,15) = (/ &
 & 0.10910E+04_JPRB,0.86525E+03_JPRB,0.60302E+03_JPRB,0.89041E+03_JPRB,0.11778E+04_JPRB /)  
KB(:, 3,27,15) = (/ &
 & 0.10210E+04_JPRB,0.77642E+03_JPRB,0.60231E+03_JPRB,0.89027E+03_JPRB,0.11763E+04_JPRB /)  
KB(:, 4,27,15) = (/ &
 & 0.10645E+04_JPRB,0.80598E+03_JPRB,0.60105E+03_JPRB,0.88742E+03_JPRB,0.11751E+04_JPRB /)  
KB(:, 5,27,15) = (/ &
 & 0.10451E+04_JPRB,0.82023E+03_JPRB,0.59981E+03_JPRB,0.88559E+03_JPRB,0.11701E+04_JPRB /)  
KB(:, 1,28,15) = (/ &
 & 0.10856E+04_JPRB,0.83991E+03_JPRB,0.60332E+03_JPRB,0.89088E+03_JPRB,0.11784E+04_JPRB /)  
KB(:, 2,28,15) = (/ &
 & 0.93268E+03_JPRB,0.70779E+03_JPRB,0.60288E+03_JPRB,0.89019E+03_JPRB,0.11788E+04_JPRB /)  
KB(:, 3,28,15) = (/ &
 & 0.11243E+04_JPRB,0.76544E+03_JPRB,0.60205E+03_JPRB,0.88894E+03_JPRB,0.11758E+04_JPRB /)  
KB(:, 4,28,15) = (/ &
 & 0.10096E+04_JPRB,0.72189E+03_JPRB,0.60064E+03_JPRB,0.88682E+03_JPRB,0.11730E+04_JPRB /)  
KB(:, 5,28,15) = (/ &
 & 0.88490E+03_JPRB,0.83821E+03_JPRB,0.59801E+03_JPRB,0.88198E+03_JPRB,0.11692E+04_JPRB /)  
KB(:, 1,29,15) = (/ &
 & 0.10218E+04_JPRB,0.78897E+03_JPRB,0.60322E+03_JPRB,0.88978E+03_JPRB,0.11783E+04_JPRB /)  
KB(:, 2,29,15) = (/ &
 & 0.97223E+03_JPRB,0.70803E+03_JPRB,0.60270E+03_JPRB,0.88994E+03_JPRB,0.11772E+04_JPRB /)  
KB(:, 3,29,15) = (/ &
 & 0.10729E+04_JPRB,0.71638E+03_JPRB,0.60175E+03_JPRB,0.88850E+03_JPRB,0.11752E+04_JPRB /)  
KB(:, 4,29,15) = (/ &
 & 0.10369E+04_JPRB,0.79357E+03_JPRB,0.60017E+03_JPRB,0.88614E+03_JPRB,0.11734E+04_JPRB /)  
KB(:, 5,29,15) = (/ &
 & 0.10748E+04_JPRB,0.83591E+03_JPRB,0.59814E+03_JPRB,0.88321E+03_JPRB,0.11671E+04_JPRB /)  
KB(:, 1,30,15) = (/ &
 & 0.10681E+04_JPRB,0.78838E+03_JPRB,0.60311E+03_JPRB,0.89058E+03_JPRB,0.11780E+04_JPRB /)  
KB(:, 2,30,15) = (/ &
 & 0.10690E+04_JPRB,0.81372E+03_JPRB,0.60250E+03_JPRB,0.88965E+03_JPRB,0.11768E+04_JPRB /)  
KB(:, 3,30,15) = (/ &
 & 0.10330E+04_JPRB,0.79065E+03_JPRB,0.60271E+03_JPRB,0.88800E+03_JPRB,0.11759E+04_JPRB /)  
KB(:, 4,30,15) = (/ &
 & 0.99812E+03_JPRB,0.80751E+03_JPRB,0.60032E+03_JPRB,0.88541E+03_JPRB,0.11712E+04_JPRB /)  
KB(:, 5,30,15) = (/ &
 & 0.10394E+04_JPRB,0.71741E+03_JPRB,0.59705E+03_JPRB,0.88643E+03_JPRB,0.11676E+04_JPRB /)  
KB(:, 1,31,15) = (/ &
 & 0.10025E+04_JPRB,0.73187E+03_JPRB,0.60298E+03_JPRB,0.89039E+03_JPRB,0.11778E+04_JPRB /)  
KB(:, 2,31,15) = (/ &
 & 0.11099E+04_JPRB,0.74280E+03_JPRB,0.60227E+03_JPRB,0.88930E+03_JPRB,0.11763E+04_JPRB /)  
KB(:, 3,31,15) = (/ &
 & 0.10884E+04_JPRB,0.79617E+03_JPRB,0.60102E+03_JPRB,0.88838E+03_JPRB,0.11738E+04_JPRB /)  
KB(:, 4,31,15) = (/ &
 & 0.90245E+03_JPRB,0.76637E+03_JPRB,0.59915E+03_JPRB,0.88368E+03_JPRB,0.11701E+04_JPRB /)  
KB(:, 5,31,15) = (/ &
 & 0.10031E+04_JPRB,0.78751E+03_JPRB,0.59673E+03_JPRB,0.89640E+03_JPRB,0.11644E+04_JPRB /)  
KB(:, 1,32,15) = (/ &
 & 0.87663E+03_JPRB,0.68400E+03_JPRB,0.60283E+03_JPRB,0.89016E+03_JPRB,0.11775E+04_JPRB /)  
KB(:, 2,32,15) = (/ &
 & 0.10467E+04_JPRB,0.83071E+03_JPRB,0.60330E+03_JPRB,0.88890E+03_JPRB,0.11758E+04_JPRB /)  
KB(:, 3,32,15) = (/ &
 & 0.97045E+03_JPRB,0.72881E+03_JPRB,0.60123E+03_JPRB,0.88677E+03_JPRB,0.11730E+04_JPRB /)  
KB(:, 4,32,15) = (/ &
 & 0.11080E+04_JPRB,0.69141E+03_JPRB,0.59860E+03_JPRB,0.88193E+03_JPRB,0.11679E+04_JPRB /)  
KB(:, 5,32,15) = (/ &
 & 0.10206E+04_JPRB,0.73037E+03_JPRB,0.59837E+03_JPRB,0.88358E+03_JPRB,0.11726E+04_JPRB /)  
KB(:, 1,33,15) = (/ &
 & 0.10520E+04_JPRB,0.78807E+03_JPRB,0.60265E+03_JPRB,0.89086E+03_JPRB,0.11771E+04_JPRB /)  
KB(:, 2,33,15) = (/ &
 & 0.98139E+03_JPRB,0.81175E+03_JPRB,0.60169E+03_JPRB,0.88843E+03_JPRB,0.11752E+04_JPRB /)  
KB(:, 3,33,15) = (/ &
 & 0.11223E+04_JPRB,0.75994E+03_JPRB,0.60074E+03_JPRB,0.88510E+03_JPRB,0.11720E+04_JPRB /)  
KB(:, 4,33,15) = (/ &
 & 0.10271E+04_JPRB,0.75564E+03_JPRB,0.59806E+03_JPRB,0.88218E+03_JPRB,0.11708E+04_JPRB /)  
KB(:, 5,33,15) = (/ &
 & 0.10438E+04_JPRB,0.78527E+03_JPRB,0.59677E+03_JPRB,0.88217E+03_JPRB,0.11682E+04_JPRB /)  
KB(:, 1,34,15) = (/ &
 & 0.10293E+04_JPRB,0.82175E+03_JPRB,0.60313E+03_JPRB,0.88963E+03_JPRB,0.11768E+04_JPRB /)  
KB(:, 2,34,15) = (/ &
 & 0.11086E+04_JPRB,0.80472E+03_JPRB,0.60138E+03_JPRB,0.88797E+03_JPRB,0.11746E+04_JPRB /)  
KB(:, 3,34,15) = (/ &
 & 0.10235E+04_JPRB,0.72497E+03_JPRB,0.60029E+03_JPRB,0.88634E+03_JPRB,0.11724E+04_JPRB /)  
KB(:, 4,34,15) = (/ &
 & 0.10022E+04_JPRB,0.79360E+03_JPRB,0.59703E+03_JPRB,0.88927E+03_JPRB,0.11777E+04_JPRB /)  
KB(:, 5,34,15) = (/ &
 & 0.11107E+04_JPRB,0.84019E+03_JPRB,0.59650E+03_JPRB,0.88082E+03_JPRB,0.11651E+04_JPRB /)  
KB(:, 1,35,15) = (/ &
 & 0.10782E+04_JPRB,0.81052E+03_JPRB,0.60236E+03_JPRB,0.89138E+03_JPRB,0.11766E+04_JPRB /)  
KB(:, 2,35,15) = (/ &
 & 0.89922E+03_JPRB,0.74859E+03_JPRB,0.60119E+03_JPRB,0.88769E+03_JPRB,0.11729E+04_JPRB /)  
KB(:, 3,35,15) = (/ &
 & 0.10088E+04_JPRB,0.71209E+03_JPRB,0.59938E+03_JPRB,0.88499E+03_JPRB,0.11706E+04_JPRB /)  
KB(:, 4,35,15) = (/ &
 & 0.96175E+03_JPRB,0.77055E+03_JPRB,0.60072E+03_JPRB,0.87852E+03_JPRB,0.11710E+04_JPRB /)  
KB(:, 5,35,15) = (/ &
 & 0.10310E+04_JPRB,0.84426E+03_JPRB,0.59635E+03_JPRB,0.88059E+03_JPRB,0.11648E+04_JPRB /)  
KB(:, 1,36,15) = (/ &
 & 0.10188E+04_JPRB,0.85190E+03_JPRB,0.60234E+03_JPRB,0.88943E+03_JPRB,0.11765E+04_JPRB /)  
KB(:, 2,36,15) = (/ &
 & 0.10154E+04_JPRB,0.76964E+03_JPRB,0.60245E+03_JPRB,0.88859E+03_JPRB,0.11741E+04_JPRB /)  
KB(:, 3,36,15) = (/ &
 & 0.10902E+04_JPRB,0.77130E+03_JPRB,0.59998E+03_JPRB,0.88588E+03_JPRB,0.11705E+04_JPRB /)  
KB(:, 4,36,15) = (/ &
 & 0.98172E+03_JPRB,0.79246E+03_JPRB,0.59876E+03_JPRB,0.89371E+03_JPRB,0.11495E+04_JPRB /)  
KB(:, 5,36,15) = (/ &
 & 0.10409E+04_JPRB,0.75260E+03_JPRB,0.59632E+03_JPRB,0.88055E+03_JPRB,0.11660E+04_JPRB /)  
KB(:, 1,37,15) = (/ &
 & 0.10398E+04_JPRB,0.81024E+03_JPRB,0.60310E+03_JPRB,0.88960E+03_JPRB,0.11767E+04_JPRB /)  
KB(:, 2,37,15) = (/ &
 & 0.94253E+03_JPRB,0.72207E+03_JPRB,0.60199E+03_JPRB,0.88792E+03_JPRB,0.11745E+04_JPRB /)  
KB(:, 3,37,15) = (/ &
 & 0.11326E+04_JPRB,0.78984E+03_JPRB,0.60024E+03_JPRB,0.88532E+03_JPRB,0.11710E+04_JPRB /)  
KB(:, 4,37,15) = (/ &
 & 0.10789E+04_JPRB,0.84320E+03_JPRB,0.59634E+03_JPRB,0.88350E+03_JPRB,0.11688E+04_JPRB /)  
KB(:, 5,37,15) = (/ &
 & 0.10084E+04_JPRB,0.82623E+03_JPRB,0.59647E+03_JPRB,0.88078E+03_JPRB,0.11651E+04_JPRB /)  
KB(:, 1,38,15) = (/ &
 & 0.99835E+03_JPRB,0.77031E+03_JPRB,0.60321E+03_JPRB,0.88977E+03_JPRB,0.11782E+04_JPRB /)  
KB(:, 2,38,15) = (/ &
 & 0.11135E+04_JPRB,0.73046E+03_JPRB,0.60283E+03_JPRB,0.88917E+03_JPRB,0.11749E+04_JPRB /)  
KB(:, 3,38,15) = (/ &
 & 0.10419E+04_JPRB,0.72620E+03_JPRB,0.59987E+03_JPRB,0.88669E+03_JPRB,0.11716E+04_JPRB /)  
KB(:, 4,38,15) = (/ &
 & 0.10631E+04_JPRB,0.75245E+03_JPRB,0.59721E+03_JPRB,0.88572E+03_JPRB,0.11692E+04_JPRB /)  
KB(:, 5,38,15) = (/ &
 & 0.10228E+04_JPRB,0.73209E+03_JPRB,0.59792E+03_JPRB,0.88102E+03_JPRB,0.11654E+04_JPRB /)  
KB(:, 1,39,15) = (/ &
 & 0.10910E+04_JPRB,0.86853E+03_JPRB,0.60266E+03_JPRB,0.88992E+03_JPRB,0.11772E+04_JPRB /)  
KB(:, 2,39,15) = (/ &
 & 0.10519E+04_JPRB,0.73802E+03_JPRB,0.60236E+03_JPRB,0.88944E+03_JPRB,0.11753E+04_JPRB /)  
KB(:, 3,39,15) = (/ &
 & 0.90206E+03_JPRB,0.82442E+03_JPRB,0.60079E+03_JPRB,0.88708E+03_JPRB,0.11721E+04_JPRB /)  
KB(:, 4,39,15) = (/ &
 & 0.10954E+04_JPRB,0.83033E+03_JPRB,0.59811E+03_JPRB,0.88319E+03_JPRB,0.11696E+04_JPRB /)  
KB(:, 5,39,15) = (/ &
 & 0.92773E+03_JPRB,0.79134E+03_JPRB,0.59808E+03_JPRB,0.88316E+03_JPRB,0.11657E+04_JPRB /)  
KB(:, 1,40,15) = (/ &
 & 0.10887E+04_JPRB,0.78119E+03_JPRB,0.60281E+03_JPRB,0.89016E+03_JPRB,0.11775E+04_JPRB /)  
KB(:, 2,40,15) = (/ &
 & 0.10361E+04_JPRB,0.78964E+03_JPRB,0.60199E+03_JPRB,0.88890E+03_JPRB,0.11758E+04_JPRB /)  
KB(:, 3,40,15) = (/ &
 & 0.10674E+04_JPRB,0.81250E+03_JPRB,0.60058E+03_JPRB,0.88678E+03_JPRB,0.11730E+04_JPRB /)  
KB(:, 4,40,15) = (/ &
 & 0.11076E+04_JPRB,0.76250E+03_JPRB,0.59989E+03_JPRB,0.88480E+03_JPRB,0.11679E+04_JPRB /)  
KB(:, 5,40,15) = (/ &
 & 0.11154E+04_JPRB,0.83280E+03_JPRB,0.59900E+03_JPRB,0.88168E+03_JPRB,0.11814E+04_JPRB /)  
KB(:, 1,41,15) = (/ &
 & 0.10350E+04_JPRB,0.79893E+03_JPRB,0.60296E+03_JPRB,0.89038E+03_JPRB,0.11778E+04_JPRB /)  
KB(:, 2,41,15) = (/ &
 & 0.10104E+04_JPRB,0.69640E+03_JPRB,0.60225E+03_JPRB,0.88929E+03_JPRB,0.11763E+04_JPRB /)  
KB(:, 3,41,15) = (/ &
 & 0.10193E+04_JPRB,0.78110E+03_JPRB,0.60100E+03_JPRB,0.88741E+03_JPRB,0.11751E+04_JPRB /)  
KB(:, 4,41,15) = (/ &
 & 0.10785E+04_JPRB,0.73450E+03_JPRB,0.59977E+03_JPRB,0.88368E+03_JPRB,0.11701E+04_JPRB /)  
KB(:, 5,41,15) = (/ &
 & 0.96003E+03_JPRB,0.80480E+03_JPRB,0.59865E+03_JPRB,0.90400E+03_JPRB,0.11833E+04_JPRB /)  
KB(:, 1,42,15) = (/ &
 & 0.97569E+03_JPRB,0.77685E+03_JPRB,0.60307E+03_JPRB,0.89056E+03_JPRB,0.11793E+04_JPRB /)  
KB(:, 2,42,15) = (/ &
 & 0.98796E+03_JPRB,0.83953E+03_JPRB,0.60247E+03_JPRB,0.88963E+03_JPRB,0.11768E+04_JPRB /)  
KB(:, 3,42,15) = (/ &
 & 0.10852E+04_JPRB,0.82427E+03_JPRB,0.60332E+03_JPRB,0.88798E+03_JPRB,0.11746E+04_JPRB /)  
KB(:, 4,42,15) = (/ &
 & 0.10360E+04_JPRB,0.83188E+03_JPRB,0.59965E+03_JPRB,0.88636E+03_JPRB,0.11712E+04_JPRB /)  
KB(:, 5,42,15) = (/ &
 & 0.10125E+04_JPRB,0.74885E+03_JPRB,0.59702E+03_JPRB,0.88356E+03_JPRB,0.11676E+04_JPRB /)  
KB(:, 1,43,15) = (/ &
 & 0.91082E+03_JPRB,0.72514E+03_JPRB,0.60320E+03_JPRB,0.89075E+03_JPRB,0.11796E+04_JPRB /)  
KB(:, 2,43,15) = (/ &
 & 0.82029E+03_JPRB,0.80137E+03_JPRB,0.60335E+03_JPRB,0.88998E+03_JPRB,0.11773E+04_JPRB /)  
KB(:, 3,43,15) = (/ &
 & 0.11298E+04_JPRB,0.78950E+03_JPRB,0.60243E+03_JPRB,0.88859E+03_JPRB,0.11754E+04_JPRB /)  
KB(:, 4,43,15) = (/ &
 & 0.10717E+04_JPRB,0.65904E+03_JPRB,0.60090E+03_JPRB,0.88726E+03_JPRB,0.11724E+04_JPRB /)  
KB(:, 5,43,15) = (/ &
 & 0.89290E+03_JPRB,0.78779E+03_JPRB,0.59823E+03_JPRB,0.88240E+03_JPRB,0.11774E+04_JPRB /)  
KB(:, 1,44,15) = (/ &
 & 0.10292E+04_JPRB,0.72935E+03_JPRB,0.60266E+03_JPRB,0.89093E+03_JPRB,0.11785E+04_JPRB /)  
KB(:, 2,44,15) = (/ &
 & 0.10616E+04_JPRB,0.76323E+03_JPRB,0.60355E+03_JPRB,0.89030E+03_JPRB,0.11790E+04_JPRB /)  
KB(:, 3,44,15) = (/ &
 & 0.10058E+04_JPRB,0.82082E+03_JPRB,0.60215E+03_JPRB,0.88915E+03_JPRB,0.11762E+04_JPRB /)  
KB(:, 4,44,15) = (/ &
 & 0.96216E+03_JPRB,0.76914E+03_JPRB,0.60084E+03_JPRB,0.88814E+03_JPRB,0.11735E+04_JPRB /)  
KB(:, 5,44,15) = (/ &
 & 0.10069E+04_JPRB,0.76998E+03_JPRB,0.59893E+03_JPRB,0.88624E+03_JPRB,0.11672E+04_JPRB /)  
KB(:, 1,45,15) = (/ &
 & 0.92082E+03_JPRB,0.79879E+03_JPRB,0.60350E+03_JPRB,0.89110E+03_JPRB,0.11788E+04_JPRB /)  
KB(:, 2,45,15) = (/ &
 & 0.96551E+03_JPRB,0.79963E+03_JPRB,0.60307E+03_JPRB,0.89055E+03_JPRB,0.11780E+04_JPRB /)  
KB(:, 3,45,15) = (/ &
 & 0.10337E+04_JPRB,0.76320E+03_JPRB,0.60246E+03_JPRB,0.88962E+03_JPRB,0.11768E+04_JPRB /)  
KB(:, 4,45,15) = (/ &
 & 0.97219E+03_JPRB,0.72677E+03_JPRB,0.60201E+03_JPRB,0.88795E+03_JPRB,0.11746E+04_JPRB /)  
KB(:, 5,45,15) = (/ &
 & 0.10146E+04_JPRB,0.80892E+03_JPRB,0.59962E+03_JPRB,0.88632E+03_JPRB,0.11711E+04_JPRB /)  
KB(:, 1,46,15) = (/ &
 & 0.10772E+04_JPRB,0.81655E+03_JPRB,0.60383E+03_JPRB,0.89135E+03_JPRB,0.11792E+04_JPRB /)  
KB(:, 2,46,15) = (/ &
 & 0.98671E+03_JPRB,0.73523E+03_JPRB,0.60321E+03_JPRB,0.89077E+03_JPRB,0.11796E+04_JPRB /)  
KB(:, 3,46,15) = (/ &
 & 0.10348E+04_JPRB,0.84026E+03_JPRB,0.60272E+03_JPRB,0.89002E+03_JPRB,0.11773E+04_JPRB /)  
KB(:, 4,46,15) = (/ &
 & 0.11018E+04_JPRB,0.66661E+03_JPRB,0.60312E+03_JPRB,0.88865E+03_JPRB,0.11755E+04_JPRB /)  
KB(:, 5,46,15) = (/ &
 & 0.10012E+04_JPRB,0.71404E+03_JPRB,0.60161E+03_JPRB,0.88639E+03_JPRB,0.11725E+04_JPRB /)  
KB(:, 1,47,15) = (/ &
 & 0.10560E+04_JPRB,0.78520E+03_JPRB,0.60429E+03_JPRB,0.89072E+03_JPRB,0.11796E+04_JPRB /)  
KB(:, 2,47,15) = (/ &
 & 0.10627E+04_JPRB,0.82754E+03_JPRB,0.60335E+03_JPRB,0.89097E+03_JPRB,0.11773E+04_JPRB /)  
KB(:, 3,47,15) = (/ &
 & 0.10705E+04_JPRB,0.76570E+03_JPRB,0.60295E+03_JPRB,0.89038E+03_JPRB,0.11791E+04_JPRB /)  
KB(:, 4,47,15) = (/ &
 & 0.11051E+04_JPRB,0.83346E+03_JPRB,0.60225E+03_JPRB,0.89026E+03_JPRB,0.11789E+04_JPRB /)  
KB(:, 5,47,15) = (/ &
 & 0.10627E+04_JPRB,0.79957E+03_JPRB,0.60100E+03_JPRB,0.88742E+03_JPRB,0.11738E+04_JPRB /)  
KB(:, 1,48,15) = (/ &
 & 0.10526E+04_JPRB,0.83431E+03_JPRB,0.60478E+03_JPRB,0.89205E+03_JPRB,0.11801E+04_JPRB /)  
KB(:, 2,48,15) = (/ &
 & 0.11375E+04_JPRB,0.74537E+03_JPRB,0.60363E+03_JPRB,0.89121E+03_JPRB,0.11790E+04_JPRB /)  
KB(:, 3,48,15) = (/ &
 & 0.10571E+04_JPRB,0.77077E+03_JPRB,0.60313E+03_JPRB,0.89066E+03_JPRB,0.11782E+04_JPRB /)  
KB(:, 4,48,15) = (/ &
 & 0.10694E+04_JPRB,0.73604E+03_JPRB,0.60258E+03_JPRB,0.88981E+03_JPRB,0.11770E+04_JPRB /)  
KB(:, 5,48,15) = (/ &
 & 0.11062E+04_JPRB,0.66828E+03_JPRB,0.60158E+03_JPRB,0.88925E+03_JPRB,0.11750E+04_JPRB /)  
KB(:, 1,49,15) = (/ &
 & 0.10727E+04_JPRB,0.73859E+03_JPRB,0.60462E+03_JPRB,0.89249E+03_JPRB,0.11807E+04_JPRB /)  
KB(:, 2,49,15) = (/ &
 & 0.11006E+04_JPRB,0.84446E+03_JPRB,0.60404E+03_JPRB,0.89152E+03_JPRB,0.11794E+04_JPRB /)  
KB(:, 3,49,15) = (/ &
 & 0.96096E+03_JPRB,0.73858E+03_JPRB,0.60393E+03_JPRB,0.89088E+03_JPRB,0.11785E+04_JPRB /)  
KB(:, 4,49,15) = (/ &
 & 0.11140E+04_JPRB,0.80464E+03_JPRB,0.60285E+03_JPRB,0.89021E+03_JPRB,0.11776E+04_JPRB /)  
KB(:, 5,49,15) = (/ &
 & 0.10928E+04_JPRB,0.75297E+03_JPRB,0.60205E+03_JPRB,0.88996E+03_JPRB,0.11760E+04_JPRB /)  
KB(:, 1,50,15) = (/ &
 & 0.10626E+04_JPRB,0.84953E+03_JPRB,0.60572E+03_JPRB,0.89295E+03_JPRB,0.11814E+04_JPRB /)  
KB(:, 2,50,15) = (/ &
 & 0.11017E+04_JPRB,0.71824E+03_JPRB,0.60451E+03_JPRB,0.89185E+03_JPRB,0.11811E+04_JPRB /)  
KB(:, 3,50,15) = (/ &
 & 0.10336E+04_JPRB,0.71570E+03_JPRB,0.60345E+03_JPRB,0.89107E+03_JPRB,0.11800E+04_JPRB /)  
KB(:, 4,50,15) = (/ &
 & 0.95200E+03_JPRB,0.76482E+03_JPRB,0.60304E+03_JPRB,0.89051E+03_JPRB,0.11793E+04_JPRB /)  
KB(:, 5,50,15) = (/ &
 & 0.96988E+03_JPRB,0.83512E+03_JPRB,0.60306E+03_JPRB,0.88954E+03_JPRB,0.11767E+04_JPRB /)  
KB(:, 1,51,15) = (/ &
 & 0.11017E+04_JPRB,0.77329E+03_JPRB,0.60615E+03_JPRB,0.89371E+03_JPRB,0.11825E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART35',1,ZHOOK_HANDLE)
END SUBROUTINE PART35


SUBROUTINE PART36

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART36',0,ZHOOK_HANDLE)


KB(:, 2,51,15) = (/ &
 & 0.10950E+04_JPRB,0.81479E+03_JPRB,0.60496E+03_JPRB,0.89123E+03_JPRB,0.11790E+04_JPRB /)  
KB(:, 3,51,15) = (/ &
 & 0.99893E+03_JPRB,0.69452E+03_JPRB,0.60377E+03_JPRB,0.89131E+03_JPRB,0.11791E+04_JPRB /)  
KB(:, 4,51,15) = (/ &
 & 0.10704E+04_JPRB,0.82834E+03_JPRB,0.60319E+03_JPRB,0.89074E+03_JPRB,0.11783E+04_JPRB /)  
KB(:, 5,51,15) = (/ &
 & 0.10391E+04_JPRB,0.80716E+03_JPRB,0.60333E+03_JPRB,0.89092E+03_JPRB,0.11772E+04_JPRB /)  
KB(:, 1,52,15) = (/ &
 & 0.10358E+04_JPRB,0.83681E+03_JPRB,0.60593E+03_JPRB,0.89390E+03_JPRB,0.11828E+04_JPRB /)  
KB(:, 2,52,15) = (/ &
 & 0.95423E+03_JPRB,0.78599E+03_JPRB,0.60540E+03_JPRB,0.89262E+03_JPRB,0.11809E+04_JPRB /)  
KB(:, 3,52,15) = (/ &
 & 0.98439E+03_JPRB,0.83257E+03_JPRB,0.60417E+03_JPRB,0.89064E+03_JPRB,0.11795E+04_JPRB /)  
KB(:, 4,52,15) = (/ &
 & 0.10548E+04_JPRB,0.77074E+03_JPRB,0.60331E+03_JPRB,0.89093E+03_JPRB,0.11786E+04_JPRB /)  
KB(:, 5,52,15) = (/ &
 & 0.10358E+04_JPRB,0.81478E+03_JPRB,0.60291E+03_JPRB,0.89030E+03_JPRB,0.11777E+04_JPRB /)  
KB(:, 1,53,15) = (/ &
 & 0.96204E+03_JPRB,0.74448E+03_JPRB,0.60716E+03_JPRB,0.89629E+03_JPRB,0.11860E+04_JPRB /)  
KB(:, 2,53,15) = (/ &
 & 0.10872E+04_JPRB,0.75126E+03_JPRB,0.60583E+03_JPRB,0.89310E+03_JPRB,0.11816E+04_JPRB /)  
KB(:, 3,53,15) = (/ &
 & 0.90617E+03_JPRB,0.75210E+03_JPRB,0.60463E+03_JPRB,0.89194E+03_JPRB,0.11800E+04_JPRB /)  
KB(:, 4,53,15) = (/ &
 & 0.97991E+03_JPRB,0.76565E+03_JPRB,0.60352E+03_JPRB,0.89113E+03_JPRB,0.11788E+04_JPRB /)  
KB(:, 5,53,15) = (/ &
 & 0.10425E+04_JPRB,0.76988E+03_JPRB,0.60308E+03_JPRB,0.89058E+03_JPRB,0.11793E+04_JPRB /)  
KB(:, 1,54,15) = (/ &
 & 0.10112E+04_JPRB,0.55645E+03_JPRB,0.60785E+03_JPRB,0.89766E+03_JPRB,0.11878E+04_JPRB /)  
KB(:, 2,54,15) = (/ &
 & 0.10637E+04_JPRB,0.66232E+03_JPRB,0.60623E+03_JPRB,0.89389E+03_JPRB,0.11827E+04_JPRB /)  
KB(:, 3,54,15) = (/ &
 & 0.88717E+03_JPRB,0.63014E+03_JPRB,0.60503E+03_JPRB,0.89226E+03_JPRB,0.11804E+04_JPRB /)  
KB(:, 4,54,15) = (/ &
 & 0.10369E+04_JPRB,0.84103E+03_JPRB,0.60384E+03_JPRB,0.89232E+03_JPRB,0.11792E+04_JPRB /)  
KB(:, 5,54,15) = (/ &
 & 0.10000E+04_JPRB,0.70043E+03_JPRB,0.60321E+03_JPRB,0.89174E+03_JPRB,0.11783E+04_JPRB /)  
KB(:, 1,55,15) = (/ &
 & 0.10615E+04_JPRB,0.77920E+03_JPRB,0.60858E+03_JPRB,0.89903E+03_JPRB,0.11896E+04_JPRB /)  
KB(:, 2,55,15) = (/ &
 & 0.10425E+04_JPRB,0.78513E+03_JPRB,0.60661E+03_JPRB,0.89494E+03_JPRB,0.11829E+04_JPRB /)  
KB(:, 3,55,15) = (/ &
 & 0.10916E+04_JPRB,0.73854E+03_JPRB,0.60542E+03_JPRB,0.89361E+03_JPRB,0.11809E+04_JPRB /)  
KB(:, 4,55,15) = (/ &
 & 0.10715E+04_JPRB,0.78936E+03_JPRB,0.60420E+03_JPRB,0.89162E+03_JPRB,0.11795E+04_JPRB /)  
KB(:, 5,55,15) = (/ &
 & 0.96091E+03_JPRB,0.82578E+03_JPRB,0.60397E+03_JPRB,0.89094E+03_JPRB,0.11773E+04_JPRB /)  
KB(:, 1,56,15) = (/ &
 & 0.10458E+04_JPRB,0.77242E+03_JPRB,0.60942E+03_JPRB,0.90044E+03_JPRB,0.11915E+04_JPRB /)  
KB(:, 2,56,15) = (/ &
 & 0.11062E+04_JPRB,0.77581E+03_JPRB,0.60712E+03_JPRB,0.89619E+03_JPRB,0.11859E+04_JPRB /)  
KB(:, 3,56,15) = (/ &
 & 0.10883E+04_JPRB,0.80121E+03_JPRB,0.60580E+03_JPRB,0.89306E+03_JPRB,0.11815E+04_JPRB /)  
KB(:, 4,56,15) = (/ &
 & 0.10726E+04_JPRB,0.82069E+03_JPRB,0.60459E+03_JPRB,0.89192E+03_JPRB,0.11799E+04_JPRB /)  
KB(:, 5,56,15) = (/ &
 & 0.11263E+04_JPRB,0.78597E+03_JPRB,0.60416E+03_JPRB,0.89111E+03_JPRB,0.11788E+04_JPRB /)  
KB(:, 1,57,15) = (/ &
 & 0.11095E+04_JPRB,0.76988E+03_JPRB,0.61034E+03_JPRB,0.90190E+03_JPRB,0.11935E+04_JPRB /)  
KB(:, 2,57,15) = (/ &
 & 0.97543E+03_JPRB,0.72583E+03_JPRB,0.60777E+03_JPRB,0.89749E+03_JPRB,0.11876E+04_JPRB /)  
KB(:, 3,57,15) = (/ &
 & 0.98548E+03_JPRB,0.78597E+03_JPRB,0.60618E+03_JPRB,0.89378E+03_JPRB,0.11826E+04_JPRB /)  
KB(:, 4,57,15) = (/ &
 & 0.98213E+03_JPRB,0.81053E+03_JPRB,0.60499E+03_JPRB,0.89222E+03_JPRB,0.11804E+04_JPRB /)  
KB(:, 5,57,15) = (/ &
 & 0.10760E+04_JPRB,0.81137E+03_JPRB,0.60380E+03_JPRB,0.89133E+03_JPRB,0.11791E+04_JPRB /)  
KB(:, 1,58,15) = (/ &
 & 0.10034E+04_JPRB,0.71059E+03_JPRB,0.61128E+03_JPRB,0.90333E+03_JPRB,0.11954E+04_JPRB /)  
KB(:, 2,58,15) = (/ &
 & 0.97431E+03_JPRB,0.80290E+03_JPRB,0.60845E+03_JPRB,0.89878E+03_JPRB,0.11893E+04_JPRB /)  
KB(:, 3,58,15) = (/ &
 & 0.95308E+03_JPRB,0.77157E+03_JPRB,0.60654E+03_JPRB,0.89474E+03_JPRB,0.11839E+04_JPRB /)  
KB(:, 4,58,15) = (/ &
 & 0.10737E+04_JPRB,0.87404E+03_JPRB,0.60535E+03_JPRB,0.89257E+03_JPRB,0.11808E+04_JPRB /)  
KB(:, 5,58,15) = (/ &
 & 0.10626E+04_JPRB,0.67671E+03_JPRB,0.60413E+03_JPRB,0.89157E+03_JPRB,0.11782E+04_JPRB /)  
KB(:, 1,59,15) = (/ &
 & 0.98325E+03_JPRB,0.78258E+03_JPRB,0.61167E+03_JPRB,0.90392E+03_JPRB,0.11962E+04_JPRB /)  
KB(:, 2,59,15) = (/ &
 & 0.10481E+04_JPRB,0.74785E+03_JPRB,0.60874E+03_JPRB,0.89931E+03_JPRB,0.11900E+04_JPRB /)  
KB(:, 3,59,15) = (/ &
 & 0.11151E+04_JPRB,0.73006E+03_JPRB,0.60669E+03_JPRB,0.89518E+03_JPRB,0.11820E+04_JPRB /)  
KB(:, 4,59,15) = (/ &
 & 0.10425E+04_JPRB,0.79358E+03_JPRB,0.60550E+03_JPRB,0.89369E+03_JPRB,0.11810E+04_JPRB /)  
KB(:, 5,59,15) = (/ &
 & 0.97877E+03_JPRB,0.79866E+03_JPRB,0.60428E+03_JPRB,0.89168E+03_JPRB,0.11796E+04_JPRB /)  
KB(:, 1,13,16) = (/ &
 & 0.75523E+03_JPRB,0.86786E+03_JPRB,0.60838E+03_JPRB,0.89385E+03_JPRB,0.11815E+04_JPRB /)  
KB(:, 2,13,16) = (/ &
 & 0.10580E+03_JPRB,0.52074E+03_JPRB,0.60685E+03_JPRB,0.89272E+03_JPRB,0.11800E+04_JPRB /)  
KB(:, 3,13,16) = (/ &
 & 0.88450E+03_JPRB,0.99478E+02_JPRB,0.60069E+03_JPRB,0.89217E+03_JPRB,0.11793E+04_JPRB /)  
KB(:, 4,13,16) = (/ &
 & 0.47883E+03_JPRB,0.85714E+02_JPRB,0.60445E+03_JPRB,0.89133E+03_JPRB,0.11782E+04_JPRB /)  
KB(:, 5,13,16) = (/ &
 & 0.30313E+03_JPRB,0.39357E+02_JPRB,0.60363E+03_JPRB,0.89015E+03_JPRB,0.11767E+04_JPRB /)  
KB(:, 1,14,16) = (/ &
 & 0.59250E+03_JPRB,0.12538E+03_JPRB,0.60779E+03_JPRB,0.89359E+03_JPRB,0.11813E+04_JPRB /)  
KB(:, 2,14,16) = (/ &
 & 0.45021E+03_JPRB,0.30819E+03_JPRB,0.60630E+03_JPRB,0.89255E+03_JPRB,0.11799E+04_JPRB /)  
KB(:, 3,14,16) = (/ &
 & 0.38746E+03_JPRB,0.31955E+03_JPRB,0.60482E+03_JPRB,0.89198E+03_JPRB,0.11792E+04_JPRB /)  
KB(:, 4,14,16) = (/ &
 & 0.59123E+03_JPRB,0.24014E+03_JPRB,0.60415E+03_JPRB,0.89112E+03_JPRB,0.11781E+04_JPRB /)  
KB(:, 5,14,16) = (/ &
 & 0.47780E+03_JPRB,0.41362E+03_JPRB,0.60332E+03_JPRB,0.88306E+03_JPRB,0.11765E+04_JPRB /)  
KB(:, 1,15,16) = (/ &
 & 0.10202E+04_JPRB,0.29221E+03_JPRB,0.60727E+03_JPRB,0.88647E+03_JPRB,0.11812E+04_JPRB /)  
KB(:, 2,15,16) = (/ &
 & 0.55435E+03_JPRB,0.58788E+03_JPRB,0.60581E+03_JPRB,0.89239E+03_JPRB,0.11799E+04_JPRB /)  
KB(:, 3,15,16) = (/ &
 & 0.31413E+03_JPRB,0.75889E+03_JPRB,0.60450E+03_JPRB,0.89181E+03_JPRB,0.11791E+04_JPRB /)  
KB(:, 4,15,16) = (/ &
 & 0.41436E+03_JPRB,0.80717E+03_JPRB,0.60389E+03_JPRB,0.89092E+03_JPRB,0.11689E+04_JPRB /)  
KB(:, 5,15,16) = (/ &
 & 0.84269E+03_JPRB,0.27451E+03_JPRB,0.60303E+03_JPRB,0.88966E+03_JPRB,0.11582E+04_JPRB /)  
KB(:, 1,16,16) = (/ &
 & 0.19456E+03_JPRB,0.24351E+03_JPRB,0.60682E+03_JPRB,0.89311E+03_JPRB,0.11719E+04_JPRB /)  
KB(:, 2,16,16) = (/ &
 & 0.43800E+03_JPRB,0.21696E+03_JPRB,0.60538E+03_JPRB,0.89225E+03_JPRB,0.11798E+04_JPRB /)  
KB(:, 3,16,16) = (/ &
 & 0.73851E+03_JPRB,0.22888E+03_JPRB,0.60428E+03_JPRB,0.89164E+03_JPRB,0.11790E+04_JPRB /)  
KB(:, 4,16,16) = (/ &
 & 0.83650E+03_JPRB,0.13309E+03_JPRB,0.60366E+03_JPRB,0.89073E+03_JPRB,0.11778E+04_JPRB /)  
KB(:, 5,16,16) = (/ &
 & 0.65895E+03_JPRB,0.36022E+03_JPRB,0.59813E+03_JPRB,0.88942E+03_JPRB,0.11670E+04_JPRB /)  
KB(:, 1,17,16) = (/ &
 & 0.97890E+03_JPRB,0.27257E+03_JPRB,0.60643E+03_JPRB,0.89290E+03_JPRB,0.11808E+04_JPRB /)  
KB(:, 2,17,16) = (/ &
 & 0.21678E+03_JPRB,0.36639E+03_JPRB,0.60501E+03_JPRB,0.89213E+03_JPRB,0.11797E+04_JPRB /)  
KB(:, 3,17,16) = (/ &
 & 0.36576E+03_JPRB,0.64243E+03_JPRB,0.60409E+03_JPRB,0.89150E+03_JPRB,0.11789E+04_JPRB /)  
KB(:, 4,17,16) = (/ &
 & 0.71301E+03_JPRB,0.32666E+03_JPRB,0.60345E+03_JPRB,0.89056E+03_JPRB,0.11777E+04_JPRB /)  
KB(:, 5,17,16) = (/ &
 & 0.30605E+03_JPRB,0.68315E+03_JPRB,0.59789E+03_JPRB,0.88918E+03_JPRB,0.11668E+04_JPRB /)  
KB(:, 1,18,16) = (/ &
 & 0.52238E+03_JPRB,0.17591E+03_JPRB,0.60609E+03_JPRB,0.89271E+03_JPRB,0.11807E+04_JPRB /)  
KB(:, 2,18,16) = (/ &
 & 0.10253E+04_JPRB,0.75807E+03_JPRB,0.60468E+03_JPRB,0.89202E+03_JPRB,0.11797E+04_JPRB /)  
KB(:, 3,18,16) = (/ &
 & 0.23095E+03_JPRB,0.31874E+03_JPRB,0.60392E+03_JPRB,0.89136E+03_JPRB,0.11788E+04_JPRB /)  
KB(:, 4,18,16) = (/ &
 & 0.55144E+03_JPRB,0.80452E+03_JPRB,0.59863E+03_JPRB,0.89039E+03_JPRB,0.11685E+04_JPRB /)  
KB(:, 5,18,16) = (/ &
 & 0.36145E+03_JPRB,0.21165E+03_JPRB,0.60231E+03_JPRB,0.88211E+03_JPRB,0.11666E+04_JPRB /)  
KB(:, 1,19,16) = (/ &
 & 0.10124E+04_JPRB,0.51143E+03_JPRB,0.60113E+03_JPRB,0.89253E+03_JPRB,0.11805E+04_JPRB /)  
KB(:, 2,19,16) = (/ &
 & 0.54199E+03_JPRB,0.26758E+03_JPRB,0.60439E+03_JPRB,0.89192E+03_JPRB,0.11796E+04_JPRB /)  
KB(:, 3,19,16) = (/ &
 & 0.61467E+03_JPRB,0.78253E+03_JPRB,0.59913E+03_JPRB,0.89123E+03_JPRB,0.11787E+04_JPRB /)  
KB(:, 4,19,16) = (/ &
 & 0.58906E+03_JPRB,0.74398E+02_JPRB,0.60311E+03_JPRB,0.89023E+03_JPRB,0.11774E+04_JPRB /)  
KB(:, 5,19,16) = (/ &
 & 0.98025E+03_JPRB,0.28476E+03_JPRB,0.59747E+03_JPRB,0.88189E+03_JPRB,0.11663E+04_JPRB /)  
KB(:, 1,20,16) = (/ &
 & 0.25361E+03_JPRB,0.16739E+03_JPRB,0.60550E+03_JPRB,0.89234E+03_JPRB,0.11712E+04_JPRB /)  
KB(:, 2,20,16) = (/ &
 & 0.70227E+03_JPRB,0.71784E+03_JPRB,0.59948E+03_JPRB,0.89182E+03_JPRB,0.11795E+04_JPRB /)  
KB(:, 3,20,16) = (/ &
 & 0.89681E+03_JPRB,0.24714E+03_JPRB,0.60364E+03_JPRB,0.89109E+03_JPRB,0.11786E+04_JPRB /)  
KB(:, 4,20,16) = (/ &
 & 0.30123E+03_JPRB,0.54911E+03_JPRB,0.60295E+03_JPRB,0.89006E+03_JPRB,0.11772E+04_JPRB /)  
KB(:, 5,20,16) = (/ &
 & 0.68301E+03_JPRB,0.36973E+03_JPRB,0.59725E+03_JPRB,0.88846E+03_JPRB,0.11750E+04_JPRB /)  
KB(:, 1,21,16) = (/ &
 & 0.25236E+03_JPRB,0.80202E+03_JPRB,0.60523E+03_JPRB,0.89218E+03_JPRB,0.11801E+04_JPRB /)  
KB(:, 2,21,16) = (/ &
 & 0.77221E+03_JPRB,0.62834E+03_JPRB,0.60401E+03_JPRB,0.89171E+03_JPRB,0.11794E+04_JPRB /)  
KB(:, 3,21,16) = (/ &
 & 0.70626E+03_JPRB,0.20918E+03_JPRB,0.60351E+03_JPRB,0.89096E+03_JPRB,0.11784E+04_JPRB /)  
KB(:, 4,21,16) = (/ &
 & 0.16217E+03_JPRB,0.14134E+03_JPRB,0.59816E+03_JPRB,0.88303E+03_JPRB,0.11770E+04_JPRB /)  
KB(:, 5,21,16) = (/ &
 & 0.51843E+03_JPRB,0.20259E+03_JPRB,0.59703E+03_JPRB,0.88818E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 1,22,16) = (/ &
 & 0.21890E+03_JPRB,0.24577E+03_JPRB,0.60023E+03_JPRB,0.89209E+03_JPRB,0.11799E+04_JPRB /)  
KB(:, 2,22,16) = (/ &
 & 0.30771E+03_JPRB,0.55233E+03_JPRB,0.60388E+03_JPRB,0.89157E+03_JPRB,0.11793E+04_JPRB /)  
KB(:, 3,22,16) = (/ &
 & 0.17796E+03_JPRB,0.48432E+03_JPRB,0.60334E+03_JPRB,0.89076E+03_JPRB,0.11782E+04_JPRB /)  
KB(:, 4,22,16) = (/ &
 & 0.88899E+03_JPRB,0.36751E+03_JPRB,0.60258E+03_JPRB,0.88960E+03_JPRB,0.11676E+04_JPRB /)  
KB(:, 5,22,16) = (/ &
 & 0.37953E+03_JPRB,0.56918E+03_JPRB,0.58746E+03_JPRB,0.88775E+03_JPRB,0.11742E+04_JPRB /)  
KB(:, 1,23,16) = (/ &
 & 0.42018E+03_JPRB,0.21434E+03_JPRB,0.60456E+03_JPRB,0.89198E+03_JPRB,0.11798E+04_JPRB /)  
KB(:, 2,23,16) = (/ &
 & 0.10252E+04_JPRB,0.32427E+03_JPRB,0.60375E+03_JPRB,0.89142E+03_JPRB,0.11791E+04_JPRB /)  
KB(:, 3,23,16) = (/ &
 & 0.25811E+03_JPRB,0.61743E+03_JPRB,0.60318E+03_JPRB,0.89055E+03_JPRB,0.11779E+04_JPRB /)  
KB(:, 4,23,16) = (/ &
 & 0.60449E+03_JPRB,0.28100E+03_JPRB,0.60235E+03_JPRB,0.88930E+03_JPRB,0.11762E+04_JPRB /)  
KB(:, 5,23,16) = (/ &
 & 0.43495E+03_JPRB,0.18925E+03_JPRB,0.60100E+03_JPRB,0.88727E+03_JPRB,0.11735E+04_JPRB /)  
KB(:, 1,24,16) = (/ &
 & 0.68497E+03_JPRB,0.77568E+03_JPRB,0.60423E+03_JPRB,0.89188E+03_JPRB,0.11797E+04_JPRB /)  
KB(:, 2,24,16) = (/ &
 & 0.27378E+03_JPRB,0.43332E+03_JPRB,0.60362E+03_JPRB,0.89125E+03_JPRB,0.11789E+04_JPRB /)  
KB(:, 3,24,16) = (/ &
 & 0.44258E+03_JPRB,0.48182E+03_JPRB,0.60301E+03_JPRB,0.89032E+03_JPRB,0.11686E+04_JPRB /)  
KB(:, 4,24,16) = (/ &
 & 0.38603E+03_JPRB,0.34135E+03_JPRB,0.59747E+03_JPRB,0.88895E+03_JPRB,0.11758E+04_JPRB /)  
KB(:, 5,24,16) = (/ &
 & 0.39386E+03_JPRB,0.54222E+03_JPRB,0.60062E+03_JPRB,0.88674E+03_JPRB,0.11638E+04_JPRB /)  
KB(:, 1,25,16) = (/ &
 & 0.55482E+03_JPRB,0.53022E+03_JPRB,0.60394E+03_JPRB,0.89175E+03_JPRB,0.11796E+04_JPRB /)  
KB(:, 2,25,16) = (/ &
 & 0.90002E+03_JPRB,0.91361E+02_JPRB,0.60348E+03_JPRB,0.89107E+03_JPRB,0.11787E+04_JPRB /)  
KB(:, 3,25,16) = (/ &
 & 0.17670E+03_JPRB,0.51744E+03_JPRB,0.59819E+03_JPRB,0.89007E+03_JPRB,0.11773E+04_JPRB /)  
KB(:, 4,25,16) = (/ &
 & 0.44153E+03_JPRB,0.41376E+03_JPRB,0.59256E+03_JPRB,0.88854E+03_JPRB,0.11753E+04_JPRB /)  
KB(:, 5,25,16) = (/ &
 & 0.24073E+03_JPRB,0.21288E+03_JPRB,0.60020E+03_JPRB,0.88614E+03_JPRB,0.11721E+04_JPRB /)  
KB(:, 1,26,16) = (/ &
 & 0.37725E+03_JPRB,0.61445E+03_JPRB,0.60383E+03_JPRB,0.89161E+03_JPRB,0.11703E+04_JPRB /)  
KB(:, 2,26,16) = (/ &
 & 0.10269E+04_JPRB,0.42565E+03_JPRB,0.59868E+03_JPRB,0.89085E+03_JPRB,0.11784E+04_JPRB /)  
KB(:, 3,26,16) = (/ &
 & 0.49719E+03_JPRB,0.26744E+03_JPRB,0.60261E+03_JPRB,0.88977E+03_JPRB,0.11769E+04_JPRB /)  
KB(:, 4,26,16) = (/ &
 & 0.41684E+03_JPRB,0.19443E+03_JPRB,0.59685E+03_JPRB,0.88123E+03_JPRB,0.11746E+04_JPRB /)  
KB(:, 5,26,16) = (/ &
 & 0.32855E+03_JPRB,0.57095E+03_JPRB,0.59973E+03_JPRB,0.88545E+03_JPRB,0.11622E+04_JPRB /)  
KB(:, 1,27,16) = (/ &
 & 0.60914E+03_JPRB,0.57105E+03_JPRB,0.60371E+03_JPRB,0.89145E+03_JPRB,0.11792E+04_JPRB /)  
KB(:, 2,27,16) = (/ &
 & 0.26439E+03_JPRB,0.15182E+03_JPRB,0.60316E+03_JPRB,0.89062E+03_JPRB,0.11781E+04_JPRB /)  
KB(:, 3,27,16) = (/ &
 & 0.73685E+03_JPRB,0.69813E+03_JPRB,0.60238E+03_JPRB,0.88259E+03_JPRB,0.11765E+04_JPRB /)  
KB(:, 4,27,16) = (/ &
 & 0.64054E+03_JPRB,0.28524E+03_JPRB,0.60110E+03_JPRB,0.88751E+03_JPRB,0.11649E+04_JPRB /)  
KB(:, 5,27,16) = (/ &
 & 0.75244E+03_JPRB,0.50359E+03_JPRB,0.59461E+03_JPRB,0.87791E+03_JPRB,0.11702E+04_JPRB /)  
KB(:, 1,28,16) = (/ &
 & 0.64046E+03_JPRB,0.15170E+03_JPRB,0.60358E+03_JPRB,0.89127E+03_JPRB,0.11790E+04_JPRB /)  
KB(:, 2,28,16) = (/ &
 & 0.70429E+03_JPRB,0.23052E+03_JPRB,0.60299E+03_JPRB,0.89037E+03_JPRB,0.11687E+04_JPRB /)  
KB(:, 3,28,16) = (/ &
 & 0.44006E+03_JPRB,0.41240E+03_JPRB,0.60212E+03_JPRB,0.88904E+03_JPRB,0.11760E+04_JPRB /)  
KB(:, 4,28,16) = (/ &
 & 0.22398E+03_JPRB,0.59419E+03_JPRB,0.60069E+03_JPRB,0.88691E+03_JPRB,0.11731E+04_JPRB /)  
KB(:, 5,28,16) = (/ &
 & 0.55183E+03_JPRB,0.13336E+03_JPRB,0.59871E+03_JPRB,0.87038E+03_JPRB,0.11692E+04_JPRB /)  
KB(:, 1,29,16) = (/ &
 & 0.59987E+03_JPRB,0.49106E+03_JPRB,0.60344E+03_JPRB,0.89107E+03_JPRB,0.11787E+04_JPRB /)  
KB(:, 2,29,16) = (/ &
 & 0.34384E+03_JPRB,0.96976E+02_JPRB,0.60280E+03_JPRB,0.89009E+03_JPRB,0.11774E+04_JPRB /)  
KB(:, 3,29,16) = (/ &
 & 0.54363E+03_JPRB,0.20603E+03_JPRB,0.60181E+03_JPRB,0.88860E+03_JPRB,0.11754E+04_JPRB /)  
KB(:, 4,29,16) = (/ &
 & 0.10391E+04_JPRB,0.38775E+03_JPRB,0.60023E+03_JPRB,0.88623E+03_JPRB,0.11632E+04_JPRB /)  
KB(:, 5,29,16) = (/ &
 & 0.22377E+03_JPRB,0.17567E+03_JPRB,0.59820E+03_JPRB,0.88324E+03_JPRB,0.11684E+04_JPRB /)  
KB(:, 1,30,16) = (/ &
 & 0.63138E+03_JPRB,0.68455E+03_JPRB,0.60329E+03_JPRB,0.89085E+03_JPRB,0.11784E+04_JPRB /)  
KB(:, 2,30,16) = (/ &
 & 0.58332E+03_JPRB,0.21199E+03_JPRB,0.60259E+03_JPRB,0.88978E+03_JPRB,0.11770E+04_JPRB /)  
KB(:, 3,30,16) = (/ &
 & 0.33555E+03_JPRB,0.46024E+03_JPRB,0.59221E+03_JPRB,0.88809E+03_JPRB,0.11657E+04_JPRB /)  
KB(:, 4,30,16) = (/ &
 & 0.44733E+03_JPRB,0.32696E+03_JPRB,0.59512E+03_JPRB,0.88550E+03_JPRB,0.11713E+04_JPRB /)  
KB(:, 5,30,16) = (/ &
 & 0.79071E+03_JPRB,0.72043E+03_JPRB,0.59773E+03_JPRB,0.85548E+03_JPRB,0.11586E+04_JPRB /)  
KB(:, 1,31,16) = (/ &
 & 0.81471E+03_JPRB,0.68414E+03_JPRB,0.60312E+03_JPRB,0.89060E+03_JPRB,0.11781E+04_JPRB /)  
KB(:, 2,31,16) = (/ &
 & 0.44722E+03_JPRB,0.73246E+03_JPRB,0.60235E+03_JPRB,0.88942E+03_JPRB,0.11765E+04_JPRB /)  
KB(:, 3,31,16) = (/ &
 & 0.48709E+03_JPRB,0.24210E+03_JPRB,0.60108E+03_JPRB,0.88068E+03_JPRB,0.11739E+04_JPRB /)  
KB(:, 4,31,16) = (/ &
 & 0.63873E+03_JPRB,0.56888E+03_JPRB,0.59920E+03_JPRB,0.88472E+03_JPRB,0.11702E+04_JPRB /)  
KB(:, 5,31,16) = (/ &
 & 0.72647E+03_JPRB,0.26020E+03_JPRB,0.59739E+03_JPRB,0.78035E+03_JPRB,0.11669E+04_JPRB /)  
KB(:, 1,32,16) = (/ &
 & 0.10219E+04_JPRB,0.29652E+03_JPRB,0.60294E+03_JPRB,0.89034E+03_JPRB,0.11777E+04_JPRB /)  
KB(:, 2,32,16) = (/ &
 & 0.75833E+03_JPRB,0.13311E+03_JPRB,0.59281E+03_JPRB,0.88900E+03_JPRB,0.11759E+04_JPRB /)  
KB(:, 3,32,16) = (/ &
 & 0.54275E+03_JPRB,0.31460E+03_JPRB,0.59602E+03_JPRB,0.88686E+03_JPRB,0.11731E+04_JPRB /)  
KB(:, 4,32,16) = (/ &
 & 0.28731E+03_JPRB,0.15124E+03_JPRB,0.59865E+03_JPRB,0.87712E+03_JPRB,0.11692E+04_JPRB /)  
KB(:, 5,32,16) = (/ &
 & 0.79004E+03_JPRB,0.63514E+03_JPRB,0.58791E+03_JPRB,0.86135E+03_JPRB,0.11214E+04_JPRB /)  
KB(:, 1,33,16) = (/ &
 & 0.42295E+03_JPRB,0.52022E+03_JPRB,0.60275E+03_JPRB,0.88319E+03_JPRB,0.11773E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART36',1,ZHOOK_HANDLE)
END SUBROUTINE PART36


SUBROUTINE PART37

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART37',0,ZHOOK_HANDLE)


KB(:, 2,33,16) = (/ &
 & 0.72614E+03_JPRB,0.33266E+03_JPRB,0.60175E+03_JPRB,0.88169E+03_JPRB,0.11753E+04_JPRB /)  
KB(:, 3,33,16) = (/ &
 & 0.36703E+03_JPRB,0.22982E+03_JPRB,0.59554E+03_JPRB,0.88614E+03_JPRB,0.11721E+04_JPRB /)  
KB(:, 4,33,16) = (/ &
 & 0.23137E+03_JPRB,0.32656E+03_JPRB,0.59813E+03_JPRB,0.88315E+03_JPRB,0.11503E+04_JPRB /)  
KB(:, 5,33,16) = (/ &
 & 0.98125E+03_JPRB,0.60471E+03_JPRB,0.59681E+03_JPRB,0.86770E+03_JPRB,0.11478E+04_JPRB /)  
KB(:, 1,34,16) = (/ &
 & 0.44676E+03_JPRB,0.16327E+03_JPRB,0.59792E+03_JPRB,0.88976E+03_JPRB,0.11770E+04_JPRB /)  
KB(:, 2,34,16) = (/ &
 & 0.27122E+03_JPRB,0.52002E+03_JPRB,0.60144E+03_JPRB,0.88807E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 3,34,16) = (/ &
 & 0.89338E+03_JPRB,0.37487E+03_JPRB,0.59509E+03_JPRB,0.87866E+03_JPRB,0.11622E+04_JPRB /)  
KB(:, 4,34,16) = (/ &
 & 0.43071E+03_JPRB,0.56832E+03_JPRB,0.58850E+03_JPRB,0.83509E+03_JPRB,0.10958E+04_JPRB /)  
KB(:, 5,34,16) = (/ &
 & 0.20737E+03_JPRB,0.35064E+03_JPRB,0.59655E+03_JPRB,0.88088E+03_JPRB,0.11652E+04_JPRB /)  
KB(:, 1,35,16) = (/ &
 & 0.79758E+02_JPRB,0.10278E+03_JPRB,0.60244E+03_JPRB,0.87589E+03_JPRB,0.11767E+04_JPRB /)  
KB(:, 2,35,16) = (/ &
 & 0.52637E+03_JPRB,0.56826E+03_JPRB,0.60124E+03_JPRB,0.88778E+03_JPRB,0.11743E+04_JPRB /)  
KB(:, 3,35,16) = (/ &
 & 0.43064E+03_JPRB,0.29620E+03_JPRB,0.59943E+03_JPRB,0.88508E+03_JPRB,0.11707E+04_JPRB /)  
KB(:, 4,35,16) = (/ &
 & 0.21531E+03_JPRB,0.74954E+03_JPRB,0.57453E+03_JPRB,0.86197E+03_JPRB,0.11223E+04_JPRB /)  
KB(:, 5,35,16) = (/ &
 & 0.85323E+03_JPRB,0.27200E+03_JPRB,0.59640E+03_JPRB,0.88066E+03_JPRB,0.11649E+04_JPRB /)  
KB(:, 1,36,16) = (/ &
 & 0.99678E+03_JPRB,0.21760E+03_JPRB,0.60242E+03_JPRB,0.88955E+03_JPRB,0.11767E+04_JPRB /)  
KB(:, 2,36,16) = (/ &
 & 0.90902E+03_JPRB,0.40496E+03_JPRB,0.59196E+03_JPRB,0.88090E+03_JPRB,0.11742E+04_JPRB /)  
KB(:, 3,36,16) = (/ &
 & 0.38273E+03_JPRB,0.60439E+03_JPRB,0.59478E+03_JPRB,0.87820E+03_JPRB,0.11706E+04_JPRB /)  
KB(:, 4,36,16) = (/ &
 & 0.84516E+03_JPRB,0.25383E+03_JPRB,0.58829E+03_JPRB,0.79406E+03_JPRB,0.11312E+04_JPRB /)  
KB(:, 5,36,16) = (/ &
 & 0.45445E+03_JPRB,0.41700E+03_JPRB,0.59637E+03_JPRB,0.88062E+03_JPRB,0.11559E+04_JPRB /)  
KB(:, 1,37,16) = (/ &
 & 0.62987E+03_JPRB,0.44723E+03_JPRB,0.59790E+03_JPRB,0.88973E+03_JPRB,0.11769E+04_JPRB /)  
KB(:, 2,37,16) = (/ &
 & 0.80524E+03_JPRB,0.68894E+03_JPRB,0.59677E+03_JPRB,0.88802E+03_JPRB,0.11746E+04_JPRB /)  
KB(:, 3,37,16) = (/ &
 & 0.18337E+03_JPRB,0.45323E+03_JPRB,0.59504E+03_JPRB,0.88541E+03_JPRB,0.11712E+04_JPRB /)  
KB(:, 4,37,16) = (/ &
 & 0.50224E+03_JPRB,0.16920E+03_JPRB,0.59765E+03_JPRB,0.86220E+03_JPRB,0.11586E+04_JPRB /)  
KB(:, 5,37,16) = (/ &
 & 0.85299E+03_JPRB,0.22358E+03_JPRB,0.59652E+03_JPRB,0.88084E+03_JPRB,0.11652E+04_JPRB /)  
KB(:, 1,38,16) = (/ &
 & 0.91678E+03_JPRB,0.47738E+03_JPRB,0.59801E+03_JPRB,0.88990E+03_JPRB,0.11681E+04_JPRB /)  
KB(:, 2,38,16) = (/ &
 & 0.47033E+03_JPRB,0.39881E+03_JPRB,0.59234E+03_JPRB,0.88147E+03_JPRB,0.11750E+04_JPRB /)  
KB(:, 3,38,16) = (/ &
 & 0.69352E+03_JPRB,0.66467E+03_JPRB,0.59993E+03_JPRB,0.87901E+03_JPRB,0.11717E+04_JPRB /)  
KB(:, 4,38,16) = (/ &
 & 0.48625E+03_JPRB,0.32628E+03_JPRB,0.59330E+03_JPRB,0.86251E+03_JPRB,0.11590E+04_JPRB /)  
KB(:, 5,38,16) = (/ &
 & 0.31087E+03_JPRB,0.44108E+03_JPRB,0.58749E+03_JPRB,0.88107E+03_JPRB,0.11655E+04_JPRB /)  
KB(:, 1,39,16) = (/ &
 & 0.35870E+03_JPRB,0.11480E+03_JPRB,0.60275E+03_JPRB,0.89007E+03_JPRB,0.11774E+04_JPRB /)  
KB(:, 2,39,16) = (/ &
 & 0.37464E+03_JPRB,0.78547E+03_JPRB,0.59714E+03_JPRB,0.88174E+03_JPRB,0.11754E+04_JPRB /)  
KB(:, 3,39,16) = (/ &
 & 0.10123E+04_JPRB,0.30814E+03_JPRB,0.59558E+03_JPRB,0.87940E+03_JPRB,0.11722E+04_JPRB /)  
KB(:, 4,39,16) = (/ &
 & 0.17535E+03_JPRB,0.96668E+02_JPRB,0.59817E+03_JPRB,0.88323E+03_JPRB,0.11594E+04_JPRB /)  
KB(:, 5,39,16) = (/ &
 & 0.36664E+03_JPRB,0.56187E+03_JPRB,0.58764E+03_JPRB,0.86774E+03_JPRB,0.11658E+04_JPRB /)  
KB(:, 1,40,16) = (/ &
 & 0.48620E+03_JPRB,0.57396E+03_JPRB,0.60293E+03_JPRB,0.89033E+03_JPRB,0.11777E+04_JPRB /)  
KB(:, 2,40,16) = (/ &
 & 0.94847E+03_JPRB,0.62832E+03_JPRB,0.60206E+03_JPRB,0.88901E+03_JPRB,0.11760E+04_JPRB /)  
KB(:, 3,40,16) = (/ &
 & 0.54197E+03_JPRB,0.51352E+03_JPRB,0.60063E+03_JPRB,0.88687E+03_JPRB,0.11731E+04_JPRB /)  
KB(:, 4,40,16) = (/ &
 & 0.21519E+03_JPRB,0.61017E+03_JPRB,0.58944E+03_JPRB,0.86354E+03_JPRB,0.11692E+04_JPRB /)  
KB(:, 5,40,16) = (/ &
 & 0.27098E+03_JPRB,0.33831E+03_JPRB,0.58331E+03_JPRB,0.88170E+03_JPRB,0.10587E+04_JPRB /)  
KB(:, 1,41,16) = (/ &
 & 0.14346E+03_JPRB,0.26582E+03_JPRB,0.60309E+03_JPRB,0.89059E+03_JPRB,0.11781E+04_JPRB /)  
KB(:, 2,41,16) = (/ &
 & 0.76510E+03_JPRB,0.70682E+03_JPRB,0.60232E+03_JPRB,0.88941E+03_JPRB,0.11765E+04_JPRB /)  
KB(:, 3,41,16) = (/ &
 & 0.62163E+03_JPRB,0.16311E+03_JPRB,0.60105E+03_JPRB,0.88750E+03_JPRB,0.11649E+04_JPRB /)  
KB(:, 4,41,16) = (/ &
 & 0.87665E+02_JPRB,0.19331E+03_JPRB,0.59457E+03_JPRB,0.88472E+03_JPRB,0.11703E+04_JPRB /)  
KB(:, 5,41,16) = (/ &
 & 0.10041E+04_JPRB,0.44098E+03_JPRB,0.58818E+03_JPRB,0.72606E+03_JPRB,0.10412E+04_JPRB /)  
KB(:, 1,42,16) = (/ &
 & 0.66944E+03_JPRB,0.41079E+03_JPRB,0.60325E+03_JPRB,0.89083E+03_JPRB,0.11693E+04_JPRB /)  
KB(:, 2,42,16) = (/ &
 & 0.51801E+03_JPRB,0.25976E+03_JPRB,0.60255E+03_JPRB,0.88976E+03_JPRB,0.11770E+04_JPRB /)  
KB(:, 3,42,16) = (/ &
 & 0.23111E+03_JPRB,0.27788E+03_JPRB,0.58293E+03_JPRB,0.88808E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 4,42,16) = (/ &
 & 0.44627E+03_JPRB,0.35036E+03_JPRB,0.59971E+03_JPRB,0.87868E+03_JPRB,0.11713E+04_JPRB /)  
KB(:, 5,42,16) = (/ &
 & 0.75706E+03_JPRB,0.77924E+03_JPRB,0.59310E+03_JPRB,0.87584E+03_JPRB,0.11676E+04_JPRB /)  
KB(:, 1,43,16) = (/ &
 & 0.60566E+03_JPRB,0.10873E+03_JPRB,0.60342E+03_JPRB,0.89110E+03_JPRB,0.11697E+04_JPRB /)  
KB(:, 2,43,16) = (/ &
 & 0.92441E+03_JPRB,0.64634E+03_JPRB,0.59816E+03_JPRB,0.89014E+03_JPRB,0.11775E+04_JPRB /)  
KB(:, 3,43,16) = (/ &
 & 0.18329E+03_JPRB,0.35035E+03_JPRB,0.59722E+03_JPRB,0.88869E+03_JPRB,0.11755E+04_JPRB /)  
KB(:, 4,43,16) = (/ &
 & 0.34266E+03_JPRB,0.17517E+03_JPRB,0.59569E+03_JPRB,0.87957E+03_JPRB,0.11725E+04_JPRB /)  
KB(:, 5,43,16) = (/ &
 & 0.92438E+03_JPRB,0.90606E+02_JPRB,0.59829E+03_JPRB,0.88341E+03_JPRB,0.11057E+04_JPRB /)  
KB(:, 1,44,16) = (/ &
 & 0.38251E+03_JPRB,0.19934E+03_JPRB,0.60359E+03_JPRB,0.89135E+03_JPRB,0.11791E+04_JPRB /)  
KB(:, 2,44,16) = (/ &
 & 0.48609E+03_JPRB,0.71881E+03_JPRB,0.59839E+03_JPRB,0.89050E+03_JPRB,0.11689E+04_JPRB /)  
KB(:, 3,44,16) = (/ &
 & 0.54984E+03_JPRB,0.19933E+03_JPRB,0.59759E+03_JPRB,0.88926E+03_JPRB,0.11763E+04_JPRB /)  
KB(:, 4,44,16) = (/ &
 & 0.85264E+03_JPRB,0.64027E+03_JPRB,0.60090E+03_JPRB,0.88045E+03_JPRB,0.11736E+04_JPRB /)  
KB(:, 5,44,16) = (/ &
 & 0.88451E+03_JPRB,0.49530E+03_JPRB,0.59898E+03_JPRB,0.87082E+03_JPRB,0.11699E+04_JPRB /)  
KB(:, 1,45,16) = (/ &
 & 0.66936E+03_JPRB,0.51946E+03_JPRB,0.60373E+03_JPRB,0.89157E+03_JPRB,0.11794E+04_JPRB /)  
KB(:, 2,45,16) = (/ &
 & 0.95622E+03_JPRB,0.66442E+03_JPRB,0.60324E+03_JPRB,0.89082E+03_JPRB,0.11784E+04_JPRB /)  
KB(:, 3,45,16) = (/ &
 & 0.70122E+03_JPRB,0.25973E+03_JPRB,0.60254E+03_JPRB,0.88974E+03_JPRB,0.11769E+04_JPRB /)  
KB(:, 4,45,16) = (/ &
 & 0.13546E+03_JPRB,0.47717E+03_JPRB,0.59679E+03_JPRB,0.88805E+03_JPRB,0.11747E+04_JPRB /)  
KB(:, 5,45,16) = (/ &
 & 0.44623E+03_JPRB,0.47716E+03_JPRB,0.59968E+03_JPRB,0.87864E+03_JPRB,0.11712E+04_JPRB /)  
KB(:, 1,46,16) = (/ &
 & 0.16734E+03_JPRB,0.11476E+03_JPRB,0.60389E+03_JPRB,0.89176E+03_JPRB,0.11797E+04_JPRB /)  
KB(:, 2,46,16) = (/ &
 & 0.41435E+03_JPRB,0.59796E+03_JPRB,0.60344E+03_JPRB,0.89112E+03_JPRB,0.11697E+04_JPRB /)  
KB(:, 3,46,16) = (/ &
 & 0.78886E+03_JPRB,0.13892E+03_JPRB,0.60282E+03_JPRB,0.89018E+03_JPRB,0.11775E+04_JPRB /)  
KB(:, 4,46,16) = (/ &
 & 0.48606E+03_JPRB,0.76103E+03_JPRB,0.59263E+03_JPRB,0.88876E+03_JPRB,0.11756E+04_JPRB /)  
KB(:, 5,46,16) = (/ &
 & 0.77291E+03_JPRB,0.68855E+03_JPRB,0.59113E+03_JPRB,0.88648E+03_JPRB,0.11726E+04_JPRB /)  
KB(:, 1,47,16) = (/ &
 & 0.80479E+03_JPRB,0.70064E+03_JPRB,0.60443E+03_JPRB,0.89194E+03_JPRB,0.11799E+04_JPRB /)  
KB(:, 2,47,16) = (/ &
 & 0.74901E+03_JPRB,0.35032E+03_JPRB,0.60363E+03_JPRB,0.89142E+03_JPRB,0.11792E+04_JPRB /)  
KB(:, 3,47,16) = (/ &
 & 0.62948E+03_JPRB,0.48923E+03_JPRB,0.60309E+03_JPRB,0.89059E+03_JPRB,0.11690E+04_JPRB /)  
KB(:, 4,47,16) = (/ &
 & 0.87648E+02_JPRB,0.36239E+03_JPRB,0.60232E+03_JPRB,0.88257E+03_JPRB,0.11584E+04_JPRB /)  
KB(:, 5,47,16) = (/ &
 & 0.44621E+03_JPRB,0.42279E+03_JPRB,0.60106E+03_JPRB,0.88751E+03_JPRB,0.11740E+04_JPRB /)  
KB(:, 1,48,16) = (/ &
 & 0.39044E+03_JPRB,0.31407E+03_JPRB,0.60497E+03_JPRB,0.89220E+03_JPRB,0.11803E+04_JPRB /)  
KB(:, 2,48,16) = (/ &
 & 0.28685E+03_JPRB,0.50131E+03_JPRB,0.60379E+03_JPRB,0.89166E+03_JPRB,0.11795E+04_JPRB /)  
KB(:, 3,48,16) = (/ &
 & 0.38246E+03_JPRB,0.70665E+03_JPRB,0.60333E+03_JPRB,0.89096E+03_JPRB,0.11786E+04_JPRB /)  
KB(:, 4,48,16) = (/ &
 & 0.47011E+03_JPRB,0.61002E+03_JPRB,0.60267E+03_JPRB,0.88995E+03_JPRB,0.11772E+04_JPRB /)  
KB(:, 5,48,16) = (/ &
 & 0.36652E+03_JPRB,0.63417E+03_JPRB,0.60164E+03_JPRB,0.88155E+03_JPRB,0.11751E+04_JPRB /)  
KB(:, 1,49,16) = (/ &
 & 0.76492E+03_JPRB,0.96636E+02_JPRB,0.60550E+03_JPRB,0.89270E+03_JPRB,0.11810E+04_JPRB /)  
KB(:, 2,49,16) = (/ &
 & 0.23107E+03_JPRB,0.19931E+03_JPRB,0.60416E+03_JPRB,0.89186E+03_JPRB,0.11798E+04_JPRB /)  
KB(:, 3,49,16) = (/ &
 & 0.86850E+03_JPRB,0.30199E+03_JPRB,0.59890E+03_JPRB,0.89128E+03_JPRB,0.11790E+04_JPRB /)  
KB(:, 4,49,16) = (/ &
 & 0.27091E+03_JPRB,0.22951E+03_JPRB,0.60296E+03_JPRB,0.89040E+03_JPRB,0.11778E+04_JPRB /)  
KB(:, 5,49,16) = (/ &
 & 0.45416E+03_JPRB,0.53149E+03_JPRB,0.60212E+03_JPRB,0.88227E+03_JPRB,0.11761E+04_JPRB /)  
KB(:, 1,50,16) = (/ &
 & 0.39042E+03_JPRB,0.12079E+03_JPRB,0.60601E+03_JPRB,0.89316E+03_JPRB,0.11816E+04_JPRB /)  
KB(:, 2,50,16) = (/ &
 & 0.38245E+03_JPRB,0.73080E+03_JPRB,0.60467E+03_JPRB,0.89201E+03_JPRB,0.11709E+04_JPRB /)  
KB(:, 3,50,16) = (/ &
 & 0.19919E+03_JPRB,0.50733E+03_JPRB,0.60370E+03_JPRB,0.89153E+03_JPRB,0.11703E+04_JPRB /)  
KB(:, 4,50,16) = (/ &
 & 0.52587E+03_JPRB,0.41673E+03_JPRB,0.60320E+03_JPRB,0.89076E+03_JPRB,0.11693E+04_JPRB /)  
KB(:, 5,50,16) = (/ &
 & 0.25497E+03_JPRB,0.90594E+02_JPRB,0.59785E+03_JPRB,0.88966E+03_JPRB,0.11768E+04_JPRB /)  
KB(:, 1,51,16) = (/ &
 & 0.35058E+03_JPRB,0.56772E+03_JPRB,0.60650E+03_JPRB,0.89405E+03_JPRB,0.11830E+04_JPRB /)  
KB(:, 2,51,16) = (/ &
 & 0.39839E+03_JPRB,0.52545E+03_JPRB,0.60516E+03_JPRB,0.89238E+03_JPRB,0.11806E+04_JPRB /)  
KB(:, 3,51,16) = (/ &
 & 0.69319E+03_JPRB,0.65831E+03_JPRB,0.60384E+03_JPRB,0.89174E+03_JPRB,0.11796E+04_JPRB /)  
KB(:, 4,51,16) = (/ &
 & 0.66132E+03_JPRB,0.42881E+03_JPRB,0.60341E+03_JPRB,0.89108E+03_JPRB,0.11788E+04_JPRB /)  
KB(:, 5,51,16) = (/ &
 & 0.80473E+03_JPRB,0.49524E+03_JPRB,0.59814E+03_JPRB,0.88327E+03_JPRB,0.11775E+04_JPRB /)  
KB(:, 1,52,16) = (/ &
 & 0.75693E+03_JPRB,0.32010E+03_JPRB,0.60698E+03_JPRB,0.89551E+03_JPRB,0.11849E+04_JPRB /)  
KB(:, 2,52,16) = (/ &
 & 0.98002E+03_JPRB,0.74890E+03_JPRB,0.60565E+03_JPRB,0.89283E+03_JPRB,0.11812E+04_JPRB /)  
KB(:, 3,52,16) = (/ &
 & 0.42228E+03_JPRB,0.32613E+03_JPRB,0.60430E+03_JPRB,0.89190E+03_JPRB,0.11799E+04_JPRB /)  
KB(:, 4,52,16) = (/ &
 & 0.43025E+03_JPRB,0.70662E+03_JPRB,0.60359E+03_JPRB,0.89136E+03_JPRB,0.11791E+04_JPRB /)  
KB(:, 5,52,16) = (/ &
 & 0.81269E+03_JPRB,0.56167E+03_JPRB,0.60303E+03_JPRB,0.89051E+03_JPRB,0.11780E+04_JPRB /)  
KB(:, 1,53,16) = (/ &
 & 0.98002E+03_JPRB,0.61603E+03_JPRB,0.60747E+03_JPRB,0.89705E+03_JPRB,0.11870E+04_JPRB /)  
KB(:, 2,53,16) = (/ &
 & 0.28683E+03_JPRB,0.42277E+03_JPRB,0.60613E+03_JPRB,0.89328E+03_JPRB,0.11818E+04_JPRB /)  
KB(:, 3,53,16) = (/ &
 & 0.45415E+03_JPRB,0.68246E+03_JPRB,0.60479E+03_JPRB,0.89204E+03_JPRB,0.11801E+04_JPRB /)  
KB(:, 4,53,16) = (/ &
 & 0.78879E+03_JPRB,0.48920E+03_JPRB,0.60374E+03_JPRB,0.89159E+03_JPRB,0.11794E+04_JPRB /)  
KB(:, 5,53,16) = (/ &
 & 0.76488E+03_JPRB,0.14495E+03_JPRB,0.60326E+03_JPRB,0.89085E+03_JPRB,0.11694E+04_JPRB /)  
KB(:, 1,54,16) = (/ &
 & 0.67724E+03_JPRB,0.76701E+03_JPRB,0.60808E+03_JPRB,0.89852E+03_JPRB,0.11890E+04_JPRB /)  
KB(:, 2,54,16) = (/ &
 & 0.81269E+03_JPRB,0.24762E+03_JPRB,0.60658E+03_JPRB,0.89430E+03_JPRB,0.11833E+04_JPRB /)  
KB(:, 3,54,16) = (/ &
 & 0.94813E+03_JPRB,0.63414E+03_JPRB,0.60524E+03_JPRB,0.89246E+03_JPRB,0.11807E+04_JPRB /)  
KB(:, 4,54,16) = (/ &
 & 0.49398E+03_JPRB,0.28989E+03_JPRB,0.60390E+03_JPRB,0.88491E+03_JPRB,0.11797E+04_JPRB /)  
KB(:, 5,54,16) = (/ &
 & 0.89236E+03_JPRB,0.27781E+03_JPRB,0.60344E+03_JPRB,0.88428E+03_JPRB,0.11788E+04_JPRB /)  
KB(:, 1,55,16) = (/ &
 & 0.52586E+03_JPRB,0.77305E+03_JPRB,0.60906E+03_JPRB,0.89999E+03_JPRB,0.11909E+04_JPRB /)  
KB(:, 2,55,16) = (/ &
 & 0.54179E+03_JPRB,0.64018E+03_JPRB,0.60701E+03_JPRB,0.89560E+03_JPRB,0.11851E+04_JPRB /)  
KB(:, 3,55,16) = (/ &
 & 0.50992E+03_JPRB,0.60394E+03_JPRB,0.60567E+03_JPRB,0.88598E+03_JPRB,0.11812E+04_JPRB /)  
KB(:, 4,55,16) = (/ &
 & 0.63740E+03_JPRB,0.44088E+03_JPRB,0.60433E+03_JPRB,0.89191E+03_JPRB,0.11799E+04_JPRB /)  
KB(:, 5,55,16) = (/ &
 & 0.49398E+03_JPRB,0.37444E+03_JPRB,0.59895E+03_JPRB,0.89137E+03_JPRB,0.11791E+04_JPRB /)  
KB(:, 1,56,16) = (/ &
 & 0.90829E+03_JPRB,0.27177E+03_JPRB,0.61007E+03_JPRB,0.90151E+03_JPRB,0.11929E+04_JPRB /)  
KB(:, 2,56,16) = (/ &
 & 0.35854E+03_JPRB,0.24158E+03_JPRB,0.60744E+03_JPRB,0.89694E+03_JPRB,0.11869E+04_JPRB /)  
KB(:, 3,56,16) = (/ &
 & 0.59756E+03_JPRB,0.47107E+03_JPRB,0.60610E+03_JPRB,0.89325E+03_JPRB,0.11817E+04_JPRB /)  
KB(:, 4,56,16) = (/ &
 & 0.52585E+03_JPRB,0.35632E+03_JPRB,0.60476E+03_JPRB,0.89203E+03_JPRB,0.11801E+04_JPRB /)  
KB(:, 5,56,16) = (/ &
 & 0.27886E+03_JPRB,0.24761E+03_JPRB,0.59909E+03_JPRB,0.89157E+03_JPRB,0.11794E+04_JPRB /)  
KB(:, 1,57,16) = (/ &
 & 0.34260E+03_JPRB,0.66433E+03_JPRB,0.61112E+03_JPRB,0.90308E+03_JPRB,0.11950E+04_JPRB /)  
KB(:, 2,57,16) = (/ &
 & 0.66130E+03_JPRB,0.45295E+03_JPRB,0.60796E+03_JPRB,0.89834E+03_JPRB,0.11887E+04_JPRB /)  
KB(:, 3,57,16) = (/ &
 & 0.69317E+03_JPRB,0.42880E+03_JPRB,0.60653E+03_JPRB,0.89415E+03_JPRB,0.11831E+04_JPRB /)  
KB(:, 4,57,16) = (/ &
 & 0.27089E+03_JPRB,0.28385E+03_JPRB,0.60519E+03_JPRB,0.89241E+03_JPRB,0.11806E+04_JPRB /)  
KB(:, 5,57,16) = (/ &
 & 0.66926E+03_JPRB,0.34424E+03_JPRB,0.60385E+03_JPRB,0.89175E+03_JPRB,0.11797E+04_JPRB /)  
KB(:, 1,58,16) = (/ &
 & 0.96406E+03_JPRB,0.25365E+03_JPRB,0.61214E+03_JPRB,0.90462E+03_JPRB,0.11971E+04_JPRB /)  
KB(:, 2,58,16) = (/ &
 & 0.31073E+03_JPRB,0.28385E+03_JPRB,0.60888E+03_JPRB,0.89972E+03_JPRB,0.11906E+04_JPRB /)  
KB(:, 3,58,16) = (/ &
 & 0.96405E+03_JPRB,0.57374E+03_JPRB,0.60693E+03_JPRB,0.89536E+03_JPRB,0.11848E+04_JPRB /)  
KB(:, 4,58,16) = (/ &
 & 0.69316E+03_JPRB,0.13891E+03_JPRB,0.60560E+03_JPRB,0.89278E+03_JPRB,0.11811E+04_JPRB /)  
KB(:, 5,58,16) = (/ &
 & 0.59755E+03_JPRB,0.75492E+03_JPRB,0.60426E+03_JPRB,0.89189E+03_JPRB,0.11798E+04_JPRB /)  
KB(:, 1,59,16) = (/ &
 & 0.92422E+03_JPRB,0.39860E+03_JPRB,0.61256E+03_JPRB,0.90525E+03_JPRB,0.11979E+04_JPRB /)  
KB(:, 2,59,16) = (/ &
 & 0.78877E+03_JPRB,0.42275E+03_JPRB,0.60926E+03_JPRB,0.90029E+03_JPRB,0.11913E+04_JPRB /)  
KB(:, 3,59,16) = (/ &
 & 0.35853E+03_JPRB,0.65225E+03_JPRB,0.60710E+03_JPRB,0.89586E+03_JPRB,0.11854E+04_JPRB /)  
KB(:, 4,59,16) = (/ &
 & 0.54975E+03_JPRB,0.50730E+03_JPRB,0.60576E+03_JPRB,0.88606E+03_JPRB,0.11813E+04_JPRB /)  
KB(:, 5,59,16) = (/ &
 & 0.52585E+03_JPRB,0.62205E+03_JPRB,0.60442E+03_JPRB,0.89194E+03_JPRB,0.11799E+04_JPRB /)  

IF (LHOOK) CALL DR_HOOK('SRTM_KGB28:PART37',1,ZHOOK_HANDLE)
END SUBROUTINE PART37


END SUBROUTINE SRTM_KGB28
