MODULE YOERRTO2

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!     -----------------------------------------------------------------
!*    ** *YOERRTO2* - RRTM ORIGINAL COEFFICIENTS FOR INTERVAL 2
!     BAND 2:  250-500 cm-1 (low - H2O; high - H2O)
!     -----------------------------------------------------------------

INTEGER(KIND=JPIM), PARAMETER :: NO2  = 16

!     The ith set of reference fractions are from the ith reference
!     pressure level.
REAL(KIND=JPRB) :: FRACREFAO(NO2,13), FRACREFBO(NO2)
REAL(KIND=JPRB) :: KAO(5,13,NO2)
REAL(KIND=JPRB) :: KBO(5,13:59,NO2)
REAL(KIND=JPRB) :: SELFREFO(10,NO2) , FORREFO(NO2)

!     -----------------------------------------------------------------
!        * E.C.M.W.F. PHYSICS PACKAGE ** RRTM LW RADIATION **

!     J.-J. MORCRETTE       E.C.M.W.F.      98/07/14

!  NAME     TYPE     PURPOSE
!  ----   : ----   : ---------------------------------------------------
!FRACREFAO: REAL    
!FRACREFBO: REAL
! KAO     : REAL     
! KBO     : REAL     
! SELFREFO: REAL
! FORREFO : REAL  
!     -----------------------------------------------------------------
!$OMP THREADPRIVATE(forrefo,fracrefao,fracrefbo,kao,kbo,selfrefo)
END MODULE YOERRTO2
