
! $Id: transp_mod.f90 6048 2026-01-22 18:13:45Z fhourdin $
!$gpum horizontal klon
MODULE transp_mod

  PRIVATE

  PUBLIC transp

  CONTAINS

SUBROUTINE transp(paprs, tsol, t, q, ql, qs, u, v, geom, & 
                  utran_e, vtran_e, utran_q, vtran_q, utran_w, vtran_w)

  USE dimphy
  USE yomcst_mod_h
IMPLICIT NONE
  ! ======================================================================
  ! Auteur(s): Z.X.Li (LMD/CNRS)
  ! Date: le 25 avril 1994
  ! Objet: Calculer le transport de l'energie et de la vapeur d'eau
  ! ======================================================================



  !--inputs
  REAL, INTENT(IN)  :: paprs(klon, klev+1), tsol(klon), geom(klon, klev)
  REAL, INTENT(IN)  :: t(klon, klev), q(klon, klev), ql(klon, klev), qs(klon, klev)
  REAL, INTENT(IN)  :: u(klon, klev), v(klon, klev)
  !--outputs
  REAL, INTENT(OUT) :: utran_e(klon), vtran_e(klon) !--lateral flux of dry static energy (J m-1 s-1)
  REAL, INTENT(OUT) :: utran_q(klon), vtran_q(klon) !--lateral flux of water vapour (kg m-1 s-1)
  REAL, INTENT(OUT) :: utran_w(klon), vtran_w(klon) !--lateral flux of total water (kg m-1 s-1)
  !--local variables
  INTEGER i, l
  REAL e, dm
  ! ------------------------------------------------------------------

  !--initialisations
  utran_e(:) = 0.0
  utran_q(:) = 0.0
  vtran_e(:) = 0.0
  vtran_q(:) = 0.0
  utran_w(:) = 0.0
  vtran_w(:) = 0.0

  !--vertical integration of diagnostics
  DO l = 1, klev
    DO i = 1, klon
      dm= (paprs(i,l)-paprs(i,l+1))/RG  !--mass of layer kg m-2
      !--moist static energy
!      e = rcpd*t(i, l) + rlvtt*q(i, l) + geom(i, l)
      !--dry static energy
      e = rcpd*t(i, l) + geom(i, l)
      utran_e(i) = utran_e(i) + u(i, l)*e*dm
      vtran_e(i) = vtran_e(i) + v(i, l)*e*dm
      !--water vapour
      utran_q(i) = utran_q(i) + u(i, l)*q(i,l)*dm 
      vtran_q(i) = vtran_q(i) + v(i, l)*q(i,l)*dm
      !--total water
      utran_w(i) = utran_w(i) + u(i, l)*(q(i,l)+ql(i,l)+qs(i,l))*dm 
      vtran_w(i) = vtran_w(i) + v(i, l)*(q(i,l)+ql(i,l)+qs(i,l))*dm
    ENDDO
  ENDDO

  RETURN
END SUBROUTINE transp

END MODULE transp_mod
