!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif
!pgi$r opt=0 
SUBROUTINE RRTM_KGB8

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 8:  1080-1180 cm-1 (low (i.e.>~300mb) - H2O; high - O3)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOERRTO8 , ONLY : KAO     ,KBO       ,SELFREFO ,FRACREFAO ,&
 & FRACREFBO, CFC12O  ,CFC22ADJO ,ABSCO2AO ,ABSCO2BO  ,&
 & ABSN2OAO , ABSN2OBO  
USE YOERRTA8 , ONLY : H2OREF  ,N2OREF    ,O3REF

!     ------------------------------------------------------------------

IMPLICIT NONE
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('RRTM_KGB8',0,ZHOOK_HANDLE)

CALL PART1
CALL PART2
CALL PART3
CALL PART4
CALL PART5
CALL PART6
CALL PART7
CALL PART8

IF (LHOOK) CALL DR_HOOK('RRTM_KGB8',1,ZHOOK_HANDLE)

!     -----------------------------------------------------------------

CONTAINS


SUBROUTINE PART1

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB8:PART1',0,ZHOOK_HANDLE)


FRACREFAO( :) = (/&
 !     From P = 1053.6 mb.
 & 0.15309700_JPRB,0.15450300_JPRB,0.14458799_JPRB,0.13098200_JPRB,&
 & 0.11817900_JPRB,0.09953490_JPRB,0.08132080_JPRB,0.06139960_JPRB,&
 & 0.04132010_JPRB,0.00446788_JPRB,0.00372533_JPRB,0.00294053_JPRB,&
 & 0.00211371_JPRB,0.00128122_JPRB,0.00048050_JPRB,0.00006759_JPRB/)  

FRACREFBO( :) = (/&
 !     From P = 28.9 mb.
 & 0.14105400_JPRB,0.14728899_JPRB,0.14264800_JPRB,0.13331699_JPRB,&
 & 0.12034100_JPRB,0.10467000_JPRB,0.08574980_JPRB,0.06469390_JPRB,&
 & 0.04394640_JPRB,0.00481284_JPRB,0.00397375_JPRB,0.00315006_JPRB,&
 & 0.00228636_JPRB,0.00144606_JPRB,0.00054604_JPRB,0.00007697_JPRB/)  

CFC12O( :) = (/&
 & 85.4027_JPRB, 89.4696_JPRB, 74.0959_JPRB, 67.7480_JPRB,&
 & 61.2444_JPRB, 59.9073_JPRB, 60.8296_JPRB, 63.0998_JPRB,&
 & 59.6110_JPRB, 64.0735_JPRB, 57.2622_JPRB, 58.9721_JPRB,&
 & 43.5505_JPRB, 26.1192_JPRB, 32.7023_JPRB, 32.8667_JPRB/)  

!     Original CFC22 is multiplied by 1.485 to account for the 780-850 cm-1 
!     and 1290-1335 cm-1 bands.
CFC22ADJO( :) = (/&
 & 135.335_JPRB, 89.6642_JPRB, 76.2375_JPRB, 65.9748_JPRB,&
 & 63.1164_JPRB, 60.2935_JPRB, 64.0299_JPRB, 75.4264_JPRB,&
 & 51.3018_JPRB, 7.07911_JPRB, 5.86928_JPRB, 0.398693_JPRB,&
 & 2.82885_JPRB, 9.12751_JPRB, 6.28271_JPRB, 0.0_JPRB/)  

ABSCO2AO( :) = (/&
 & 1.11233E-05_JPRB, 3.92400E-05_JPRB, 6.62059E-05_JPRB, 8.51687E-05_JPRB,&
 & 7.79035E-05_JPRB, 1.34058E-04_JPRB, 2.82553E-04_JPRB, 5.41741E-04_JPRB,&
 & 1.47029E-05_JPRB, 2.34982E-05_JPRB, 6.91094E-08_JPRB, 8.48917E-08_JPRB,&
 & 6.58783E-08_JPRB, 4.64849E-08_JPRB, 3.62742E-08_JPRB, 3.62742E-08_JPRB/)  

ABSCO2BO( :) = (/&
 & 4.10977E-09_JPRB, 5.65200E-08_JPRB, 1.70800E-07_JPRB, 4.16840E-07_JPRB,&
 & 9.53684E-07_JPRB, 2.36468E-06_JPRB, 7.29502E-06_JPRB, 4.93883E-05_JPRB, &
 & 5.10440E-04_JPRB, 9.75248E-04_JPRB, 1.36495E-03_JPRB, 2.40451E-03_JPRB,&
 & 4.50277E-03_JPRB, 2.24486E-02_JPRB, 4.06756E-02_JPRB, 2.17447E-10_JPRB/)  

ABSN2OAO( :) = (/&
 & 1.28527E-02_JPRB,5.28651E-02_JPRB,1.01668E-01_JPRB,1.57224E-01_JPRB,&
 & 2.76947E-01_JPRB,4.93048E-01_JPRB,6.71387E-01_JPRB,3.48809E-01_JPRB,&
 & 4.19840E-01_JPRB,3.13558E-01_JPRB,2.44432E-01_JPRB,2.05108E-01_JPRB,&
 & 1.21423E-01_JPRB,1.22158E-01_JPRB,1.49702E-01_JPRB,1.47799E-01_JPRB/)  

ABSN2OBO( : ) = (/&
 & 3.15864E-03_JPRB,4.87347E-03_JPRB,8.63235E-03_JPRB,2.16053E-02_JPRB,&
 & 3.63699E-02_JPRB,7.89149E-02_JPRB,3.53807E-01_JPRB,1.27140E-00_JPRB,&
 & 2.31464E-00_JPRB,7.75834E-02_JPRB,5.15063E-02_JPRB,4.07059E-02_JPRB,&
 & 5.91947E-02_JPRB,5.83546E-02_JPRB,3.12716E-01_JPRB,1.47456E-01_JPRB/)  

H2OREF( : ) = (/&
 & 1.87599E-02_JPRB,1.22233E-02_JPRB,5.89086E-03_JPRB,2.76753E-03_JPRB,1.40651E-03_JPRB, &
 & 7.59698E-04_JPRB,3.88758E-04_JPRB,1.65422E-04_JPRB,3.71895E-05_JPRB,7.47648E-06_JPRB, &
 & 4.30818E-06_JPRB,3.33194E-06_JPRB,3.20393E-06_JPRB,3.16186E-06_JPRB,3.25235E-06_JPRB, &
 & 3.42258E-06_JPRB,3.62884E-06_JPRB,3.91482E-06_JPRB,4.14875E-06_JPRB,4.30810E-06_JPRB,&
 & 4.44204E-06_JPRB,4.57783E-06_JPRB,4.70865E-06_JPRB,4.79432E-06_JPRB,4.86971E-06_JPRB, &
 & 4.92603E-06_JPRB,4.96688E-06_JPRB,4.99628E-06_JPRB,5.05266E-06_JPRB,5.12658E-06_JPRB, &
 & 5.25028E-06_JPRB,5.35708E-06_JPRB,5.45085E-06_JPRB,5.48304E-06_JPRB,5.50000E-06_JPRB, &
 & 5.50000E-06_JPRB,5.45359E-06_JPRB,5.40468E-06_JPRB,5.35576E-06_JPRB,5.25327E-06_JPRB,&
 & 5.14362E-06_JPRB,5.03396E-06_JPRB,4.87662E-06_JPRB,4.69787E-06_JPRB,4.51911E-06_JPRB, &
 & 4.33600E-06_JPRB,4.14416E-06_JPRB,3.95232E-06_JPRB,3.76048E-06_JPRB,3.57217E-06_JPRB, &
 & 3.38549E-06_JPRB,3.19881E-06_JPRB,3.01212E-06_JPRB,2.82621E-06_JPRB,2.64068E-06_JPRB, &
 & 2.45515E-06_JPRB,2.26962E-06_JPRB,2.08659E-06_JPRB,1.93029E-06_JPRB/)  

N2OREF( : ) = (/&
 & 3.20000E-07_JPRB,3.20000E-07_JPRB,3.20000E-07_JPRB,3.20000E-07_JPRB,3.20000E-07_JPRB,&
 & 3.19652E-07_JPRB,3.15324E-07_JPRB,3.03830E-07_JPRB,2.94221E-07_JPRB,2.84953E-07_JPRB,&
 & 2.76714E-07_JPRB,2.64709E-07_JPRB,2.42847E-07_JPRB,2.09547E-07_JPRB,1.71945E-07_JPRB,&
 & 1.37491E-07_JPRB,1.13319E-07_JPRB,1.00354E-07_JPRB,9.12812E-08_JPRB,8.54633E-08_JPRB,&
 & 8.03631E-08_JPRB,7.33718E-08_JPRB,6.59754E-08_JPRB,5.60386E-08_JPRB,4.70901E-08_JPRB,&
 & 3.99774E-08_JPRB,3.29786E-08_JPRB,2.60642E-08_JPRB,2.10663E-08_JPRB,1.65918E-08_JPRB,&
 & 1.30167E-08_JPRB,1.00900E-08_JPRB,7.62490E-09_JPRB,6.11592E-09_JPRB,4.66725E-09_JPRB,&
 & 3.28574E-09_JPRB,2.84838E-09_JPRB,2.46198E-09_JPRB,2.07557E-09_JPRB,1.85507E-09_JPRB,&
 & 1.65675E-09_JPRB,1.45843E-09_JPRB,1.31948E-09_JPRB,1.20716E-09_JPRB,1.09485E-09_JPRB,&
 & 9.97803E-10_JPRB,9.31260E-10_JPRB,8.64721E-10_JPRB,7.98181E-10_JPRB,7.51380E-10_JPRB,&
 & 7.13670E-10_JPRB,6.75960E-10_JPRB,6.38250E-10_JPRB,6.09811E-10_JPRB,5.85998E-10_JPRB,&
 & 5.62185E-10_JPRB,5.38371E-10_JPRB,5.15183E-10_JPRB,4.98660E-10_JPRB/)  

O3REF( : ) = (/&
 & 3.01700E-08_JPRB,3.47254E-08_JPRB,4.24769E-08_JPRB,5.27592E-08_JPRB,6.69439E-08_JPRB,&
 & 8.71295E-08_JPRB,1.13911E-07_JPRB,1.56771E-07_JPRB,2.17878E-07_JPRB,3.24430E-07_JPRB,&
 & 4.65942E-07_JPRB,5.68057E-07_JPRB,6.96065E-07_JPRB,1.11863E-06_JPRB,1.76175E-06_JPRB,&
 & 2.32689E-06_JPRB,2.95769E-06_JPRB,3.65930E-06_JPRB,4.59503E-06_JPRB,5.31891E-06_JPRB,&
 & 5.96179E-06_JPRB,6.51133E-06_JPRB,7.06350E-06_JPRB,7.69169E-06_JPRB,8.25771E-06_JPRB,&
 & 8.70824E-06_JPRB,8.83245E-06_JPRB,8.71486E-06_JPRB,8.09434E-06_JPRB,7.33071E-06_JPRB,&
 & 6.31014E-06_JPRB,5.36717E-06_JPRB,4.48289E-06_JPRB,3.83913E-06_JPRB,3.28270E-06_JPRB,&
 & 2.82351E-06_JPRB,2.49061E-06_JPRB,2.16453E-06_JPRB,1.83845E-06_JPRB,1.66182E-06_JPRB,&
 & 1.50517E-06_JPRB,1.34852E-06_JPRB,1.19718E-06_JPRB,1.04822E-06_JPRB,8.99264E-07_JPRB,&
 & 7.63432E-07_JPRB,6.53806E-07_JPRB,5.44186E-07_JPRB,4.34564E-07_JPRB,3.64210E-07_JPRB,&
 & 3.11938E-07_JPRB,2.59667E-07_JPRB,2.07395E-07_JPRB,1.91456E-07_JPRB,1.93639E-07_JPRB,&
 & 1.95821E-07_JPRB,1.98004E-07_JPRB,2.06442E-07_JPRB,2.81546E-07_JPRB/)  

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the corresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
!     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
!     index, JP, runs from 1 to 13 and refers to the corresponding 
!     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
!     The third index, IG, goes from 1 to 16, and tells us which 
!     g-interval the absorption coefficients are for.
!     The array KA contains absorption coef5s at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the cooresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The second index, JP, runs from 1 to 13 and refers
!     to the corresponding pressure level in PREF (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The third index, IG, goes from 1 to 16,
!     and tells us which "g-channel" the absorption coefficients are for.

KAO( :, 1, 1) = (/&
 & 2.1306E-05_JPRB,2.1950E-05_JPRB,2.2884E-05_JPRB,2.6732E-05_JPRB,3.2377E-05_JPRB/)  
KAO( :, 2, 1) = (/&
 & 1.6906E-05_JPRB,1.6458E-05_JPRB,1.8409E-05_JPRB,2.2144E-05_JPRB,2.7164E-05_JPRB/)  
KAO( :, 3, 1) = (/&
 & 1.2302E-05_JPRB,1.3298E-05_JPRB,1.6211E-05_JPRB,2.0006E-05_JPRB,2.4357E-05_JPRB/)  
KAO( :, 4, 1) = (/&
 & 1.0886E-05_JPRB,1.3249E-05_JPRB,1.6382E-05_JPRB,2.0127E-05_JPRB,2.4322E-05_JPRB/)  
KAO( :, 5, 1) = (/&
 & 1.3888E-05_JPRB,1.6517E-05_JPRB,1.9596E-05_JPRB,2.3121E-05_JPRB,2.7167E-05_JPRB/)  
KAO( :, 6, 1) = (/&
 & 2.0087E-05_JPRB,2.2948E-05_JPRB,2.6312E-05_JPRB,3.0073E-05_JPRB,3.4185E-05_JPRB/)  
KAO( :, 7, 1) = (/&
 & 3.4572E-05_JPRB,3.7732E-05_JPRB,4.1567E-05_JPRB,4.5943E-05_JPRB,5.0800E-05_JPRB/)  
KAO( :, 1, 2) = (/&
 & 2.9087E-05_JPRB,2.7497E-05_JPRB,3.3334E-05_JPRB,4.2723E-05_JPRB,5.3596E-05_JPRB/)  
KAO( :, 2, 2) = (/&
 & 1.9679E-05_JPRB,2.2356E-05_JPRB,2.8322E-05_JPRB,3.6379E-05_JPRB,4.5664E-05_JPRB/)  
KAO( :, 3, 2) = (/&
 & 1.6538E-05_JPRB,2.0860E-05_JPRB,2.6606E-05_JPRB,3.3787E-05_JPRB,4.2303E-05_JPRB/)  
KAO( :, 4, 2) = (/&
 & 1.8682E-05_JPRB,2.3553E-05_JPRB,2.9503E-05_JPRB,3.6225E-05_JPRB,4.3839E-05_JPRB/)  
KAO( :, 5, 2) = (/&
 & 2.4894E-05_JPRB,3.0126E-05_JPRB,3.6642E-05_JPRB,4.4225E-05_JPRB,5.2245E-05_JPRB/)  
KAO( :, 6, 2) = (/&
 & 3.8317E-05_JPRB,4.4010E-05_JPRB,5.1169E-05_JPRB,5.9798E-05_JPRB,6.8990E-05_JPRB/)  
KAO( :, 7, 2) = (/&
 & 6.8186E-05_JPRB,7.5558E-05_JPRB,8.3877E-05_JPRB,9.3681E-05_JPRB,1.0480E-04_JPRB/)  
KAO( :, 1, 3) = (/&
 & 3.2064E-05_JPRB,3.8954E-05_JPRB,5.4094E-05_JPRB,6.8453E-05_JPRB,8.4647E-05_JPRB/)  
KAO( :, 2, 3) = (/&
 & 2.6037E-05_JPRB,3.4049E-05_JPRB,4.5537E-05_JPRB,5.7651E-05_JPRB,7.1488E-05_JPRB/)  
KAO( :, 3, 3) = (/&
 & 2.4129E-05_JPRB,3.2489E-05_JPRB,4.2214E-05_JPRB,5.3481E-05_JPRB,6.6486E-05_JPRB/)  
KAO( :, 4, 3) = (/&
 & 2.8484E-05_JPRB,3.6015E-05_JPRB,4.5013E-05_JPRB,5.6076E-05_JPRB,6.9168E-05_JPRB/)  
KAO( :, 5, 3) = (/&
 & 3.7982E-05_JPRB,4.5941E-05_JPRB,5.5480E-05_JPRB,6.6761E-05_JPRB,8.0178E-05_JPRB/)  
KAO( :, 6, 3) = (/&
 & 5.8486E-05_JPRB,6.7090E-05_JPRB,7.7118E-05_JPRB,8.8876E-05_JPRB,1.0336E-04_JPRB/)  
KAO( :, 7, 3) = (/&
 & 1.0488E-04_JPRB,1.1540E-04_JPRB,1.2822E-04_JPRB,1.4297E-04_JPRB,1.5988E-04_JPRB/)  
KAO( :, 1, 4) = (/&
 & 4.3432E-05_JPRB,6.9197E-05_JPRB,8.9433E-05_JPRB,1.1259E-04_JPRB,1.3904E-04_JPRB/)  
KAO( :, 2, 4) = (/&
 & 4.1381E-05_JPRB,5.9002E-05_JPRB,7.4659E-05_JPRB,9.2971E-05_JPRB,1.1449E-04_JPRB/)  
KAO( :, 3, 4) = (/&
 & 4.1382E-05_JPRB,5.3805E-05_JPRB,6.7661E-05_JPRB,8.4186E-05_JPRB,1.0415E-04_JPRB/)  
KAO( :, 4, 4) = (/&
 & 4.4469E-05_JPRB,5.5300E-05_JPRB,6.8920E-05_JPRB,8.5387E-05_JPRB,1.0542E-04_JPRB/)  
KAO( :, 5, 4) = (/&
 & 5.7483E-05_JPRB,6.8364E-05_JPRB,8.1508E-05_JPRB,9.7560E-05_JPRB,1.1744E-04_JPRB/)  
KAO( :, 6, 4) = (/&
 & 8.5034E-05_JPRB,9.7144E-05_JPRB,1.1137E-04_JPRB,1.2836E-04_JPRB,1.4879E-04_JPRB/)  
KAO( :, 7, 4) = (/&
 & 1.4995E-04_JPRB,1.6384E-04_JPRB,1.8060E-04_JPRB,2.0120E-04_JPRB,2.2497E-04_JPRB/)  
KAO( :, 1, 5) = (/&
 & 8.9308E-05_JPRB,1.2026E-04_JPRB,1.5456E-04_JPRB,1.9463E-04_JPRB,2.4183E-04_JPRB/)  
KAO( :, 2, 5) = (/&
 & 7.5125E-05_JPRB,9.9141E-05_JPRB,1.2691E-04_JPRB,1.6010E-04_JPRB,1.9928E-04_JPRB/)  
KAO( :, 3, 5) = (/&
 & 7.0124E-05_JPRB,8.9385E-05_JPRB,1.1201E-04_JPRB,1.3854E-04_JPRB,1.6993E-04_JPRB/)  
KAO( :, 4, 5) = (/&
 & 7.3552E-05_JPRB,9.0337E-05_JPRB,1.1055E-04_JPRB,1.3609E-04_JPRB,1.6764E-04_JPRB/)  
KAO( :, 5, 5) = (/&
 & 8.7943E-05_JPRB,1.0388E-04_JPRB,1.2401E-04_JPRB,1.4993E-04_JPRB,1.8142E-04_JPRB/)  
KAO( :, 6, 5) = (/&
 & 1.2136E-04_JPRB,1.3842E-04_JPRB,1.6040E-04_JPRB,1.8635E-04_JPRB,2.1779E-04_JPRB/)  
KAO( :, 7, 5) = (/&
 & 2.0763E-04_JPRB,2.2758E-04_JPRB,2.5254E-04_JPRB,2.8218E-04_JPRB,3.1966E-04_JPRB/)  
KAO( :, 1, 6) = (/&
 & 1.6837E-04_JPRB,2.2104E-04_JPRB,2.8135E-04_JPRB,3.5251E-04_JPRB,4.3572E-04_JPRB/)  
KAO( :, 2, 6) = (/&
 & 1.3574E-04_JPRB,1.7723E-04_JPRB,2.2754E-04_JPRB,2.8744E-04_JPRB,3.5879E-04_JPRB/)  
KAO( :, 3, 6) = (/&
 & 1.2293E-04_JPRB,1.5476E-04_JPRB,1.9352E-04_JPRB,2.4145E-04_JPRB,2.9987E-04_JPRB/)  
KAO( :, 4, 6) = (/&
 & 1.2596E-04_JPRB,1.5619E-04_JPRB,1.9248E-04_JPRB,2.3477E-04_JPRB,2.8394E-04_JPRB/)  
KAO( :, 5, 6) = (/&
 & 1.4080E-04_JPRB,1.6980E-04_JPRB,2.0518E-04_JPRB,2.4743E-04_JPRB,2.9907E-04_JPRB/)  
KAO( :, 6, 6) = (/&
 & 1.8164E-04_JPRB,2.0870E-04_JPRB,2.4256E-04_JPRB,2.8705E-04_JPRB,3.4263E-04_JPRB/)  
KAO( :, 7, 6) = (/&
 & 2.9186E-04_JPRB,3.2585E-04_JPRB,3.6846E-04_JPRB,4.2036E-04_JPRB,4.8155E-04_JPRB/)  
KAO( :, 1, 7) = (/&
 & 3.8706E-04_JPRB,4.9892E-04_JPRB,6.2866E-04_JPRB,7.7583E-04_JPRB,9.4184E-04_JPRB/)  
KAO( :, 2, 7) = (/&
 & 2.9924E-04_JPRB,3.8940E-04_JPRB,4.9426E-04_JPRB,6.1428E-04_JPRB,7.5278E-04_JPRB/)  
KAO( :, 3, 7) = (/&
 & 2.3352E-04_JPRB,3.0489E-04_JPRB,3.9204E-04_JPRB,4.9500E-04_JPRB,6.1630E-04_JPRB/)  
KAO( :, 4, 7) = (/&
 & 2.3587E-04_JPRB,2.9262E-04_JPRB,3.5911E-04_JPRB,4.3910E-04_JPRB,5.3846E-04_JPRB/)  
KAO( :, 5, 7) = (/&
 & 2.6327E-04_JPRB,3.2005E-04_JPRB,3.8792E-04_JPRB,4.6619E-04_JPRB,5.5730E-04_JPRB/)  
KAO( :, 6, 7) = (/&
 & 3.1398E-04_JPRB,3.7118E-04_JPRB,4.4079E-04_JPRB,5.2291E-04_JPRB,6.1919E-04_JPRB/)  
KAO( :, 7, 7) = (/&
 & 4.6137E-04_JPRB,5.1993E-04_JPRB,5.9097E-04_JPRB,6.8096E-04_JPRB,7.9254E-04_JPRB/)  
KAO( :, 1, 8) = (/&
 & 1.1958E-03_JPRB,1.5395E-03_JPRB,1.9263E-03_JPRB,2.3597E-03_JPRB,2.8416E-03_JPRB/)  
KAO( :, 2, 8) = (/&
 & 9.2007E-04_JPRB,1.1952E-03_JPRB,1.5105E-03_JPRB,1.8694E-03_JPRB,2.2724E-03_JPRB/)  
KAO( :, 3, 8) = (/&
 & 6.7202E-04_JPRB,8.8335E-04_JPRB,1.1326E-03_JPRB,1.4229E-03_JPRB,1.7568E-03_JPRB/)  
KAO( :, 4, 8) = (/&
 & 5.3231E-04_JPRB,6.9102E-04_JPRB,8.9625E-04_JPRB,1.1508E-03_JPRB,1.4534E-03_JPRB/)  
KAO( :, 5, 8) = (/&
 & 5.8927E-04_JPRB,7.1310E-04_JPRB,8.6254E-04_JPRB,1.0581E-03_JPRB,1.3073E-03_JPRB/)  
KAO( :, 6, 8) = (/&
 & 7.1594E-04_JPRB,8.4919E-04_JPRB,1.0061E-03_JPRB,1.1903E-03_JPRB,1.4091E-03_JPRB/)  
KAO( :, 7, 8) = (/&
 & 9.6332E-04_JPRB,1.1098E-03_JPRB,1.2830E-03_JPRB,1.4872E-03_JPRB,1.7311E-03_JPRB/)  
KAO( :, 1, 9) = (/&
 & 4.1727E-03_JPRB,5.4973E-03_JPRB,7.0377E-03_JPRB,8.7943E-03_JPRB,1.0731E-02_JPRB/)  
KAO( :, 2, 9) = (/&
 & 3.6273E-03_JPRB,4.8260E-03_JPRB,6.2243E-03_JPRB,7.8057E-03_JPRB,9.5531E-03_JPRB/)  
KAO( :, 3, 9) = (/&
 & 2.9023E-03_JPRB,3.9253E-03_JPRB,5.1247E-03_JPRB,6.4834E-03_JPRB,7.9956E-03_JPRB/)  
KAO( :, 4, 9) = (/&
 & 2.2487E-03_JPRB,3.0840E-03_JPRB,4.0791E-03_JPRB,5.2274E-03_JPRB,6.5148E-03_JPRB/)  
KAO( :, 5, 9) = (/&
 & 1.7798E-03_JPRB,2.4327E-03_JPRB,3.2625E-03_JPRB,4.2482E-03_JPRB,5.3864E-03_JPRB/)  
KAO( :, 6, 9) = (/&
 & 1.8001E-03_JPRB,2.2379E-03_JPRB,2.8537E-03_JPRB,3.6632E-03_JPRB,4.6821E-03_JPRB/)  
KAO( :, 7, 9) = (/&
 & 2.5147E-03_JPRB,2.9224E-03_JPRB,3.4442E-03_JPRB,4.0760E-03_JPRB,4.9201E-03_JPRB/)  
KAO( :, 1,10) = (/&
 & 8.6270E-03_JPRB,1.1144E-02_JPRB,1.4435E-02_JPRB,1.8416E-02_JPRB,2.3138E-02_JPRB/)  
KAO( :, 2,10) = (/&
 & 8.0326E-03_JPRB,1.0542E-02_JPRB,1.3830E-02_JPRB,1.7772E-02_JPRB,2.2459E-02_JPRB/)  
KAO( :, 3,10) = (/&
 & 6.9631E-03_JPRB,9.2657E-03_JPRB,1.2368E-02_JPRB,1.6195E-02_JPRB,2.0590E-02_JPRB/)  
KAO( :, 4,10) = (/&
 & 5.6928E-03_JPRB,7.8298E-03_JPRB,1.0719E-02_JPRB,1.4129E-02_JPRB,1.8068E-02_JPRB/)  
KAO( :, 5,10) = (/&
 & 4.6297E-03_JPRB,6.4732E-03_JPRB,8.9852E-03_JPRB,1.2076E-02_JPRB,1.5694E-02_JPRB/)  
KAO( :, 6,10) = (/&
 & 3.6660E-03_JPRB,5.2377E-03_JPRB,7.3525E-03_JPRB,9.9709E-03_JPRB,1.3092E-02_JPRB/)  
KAO( :, 7,10) = (/&
 & 4.5886E-03_JPRB,5.1723E-03_JPRB,6.2981E-03_JPRB,8.7864E-03_JPRB,1.2005E-02_JPRB/)  
KAO( :, 1,11) = (/&
 & 1.1588E-02_JPRB,1.5525E-02_JPRB,1.9979E-02_JPRB,2.5226E-02_JPRB,3.1634E-02_JPRB/)  
KAO( :, 2,11) = (/&
 & 1.0684E-02_JPRB,1.4204E-02_JPRB,1.8270E-02_JPRB,2.3355E-02_JPRB,2.9653E-02_JPRB/)  
KAO( :, 3,11) = (/&
 & 9.3411E-03_JPRB,1.2473E-02_JPRB,1.6164E-02_JPRB,2.0880E-02_JPRB,2.6874E-02_JPRB/)  
KAO( :, 4,11) = (/&
 & 7.9944E-03_JPRB,1.0851E-02_JPRB,1.4275E-02_JPRB,1.8869E-02_JPRB,2.4580E-02_JPRB/)  
KAO( :, 5,11) = (/&
 & 6.6337E-03_JPRB,9.2604E-03_JPRB,1.2443E-02_JPRB,1.6670E-02_JPRB,2.2008E-02_JPRB/)  
KAO( :, 6,11) = (/&
 & 5.3432E-03_JPRB,7.6067E-03_JPRB,1.0484E-02_JPRB,1.4403E-02_JPRB,1.9210E-02_JPRB/)  
KAO( :, 7,11) = (/&
 & 5.2399E-03_JPRB,6.3294E-03_JPRB,8.7446E-03_JPRB,1.2290E-02_JPRB,1.7005E-02_JPRB/)  
KAO( :, 1,12) = (/&
 & 1.8590E-02_JPRB,2.3597E-02_JPRB,2.9609E-02_JPRB,3.6637E-02_JPRB,4.4785E-02_JPRB/)  
KAO( :, 2,12) = (/&
 & 1.5975E-02_JPRB,2.1048E-02_JPRB,2.7310E-02_JPRB,3.4824E-02_JPRB,4.3138E-02_JPRB/)  
KAO( :, 3,12) = (/&
 & 1.3265E-02_JPRB,1.8239E-02_JPRB,2.4452E-02_JPRB,3.1517E-02_JPRB,3.9669E-02_JPRB/)  
KAO( :, 4,12) = (/&
 & 1.1138E-02_JPRB,1.5596E-02_JPRB,2.1071E-02_JPRB,2.7401E-02_JPRB,3.4980E-02_JPRB/)  
KAO( :, 5,12) = (/&
 & 9.5074E-03_JPRB,1.3466E-02_JPRB,1.8276E-02_JPRB,2.3939E-02_JPRB,3.0805E-02_JPRB/)  
KAO( :, 6,12) = (/&
 & 7.9557E-03_JPRB,1.1512E-02_JPRB,1.5826E-02_JPRB,2.0932E-02_JPRB,2.7410E-02_JPRB/)  
KAO( :, 7,12) = (/&
 & 6.5226E-03_JPRB,9.6301E-03_JPRB,1.3559E-02_JPRB,1.8314E-02_JPRB,2.4403E-02_JPRB/)  
KAO( :, 1,13) = (/&
 & 3.3867E-02_JPRB,4.3721E-02_JPRB,5.4904E-02_JPRB,6.6992E-02_JPRB,7.9770E-02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB8:PART1',1,ZHOOK_HANDLE)
END SUBROUTINE PART1


SUBROUTINE PART2

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB8:PART2',0,ZHOOK_HANDLE)


KAO( :, 2,13) = (/&
 & 3.1901E-02_JPRB,4.1423E-02_JPRB,5.1954E-02_JPRB,6.3307E-02_JPRB,7.6026E-02_JPRB/)  
KAO( :, 3,13) = (/&
 & 2.7060E-02_JPRB,3.5456E-02_JPRB,4.4891E-02_JPRB,5.5833E-02_JPRB,6.8298E-02_JPRB/)  
KAO( :, 4,13) = (/&
 & 2.1596E-02_JPRB,2.8962E-02_JPRB,3.7686E-02_JPRB,4.8052E-02_JPRB,6.0217E-02_JPRB/)  
KAO( :, 5,13) = (/&
 & 1.6874E-02_JPRB,2.3280E-02_JPRB,3.1365E-02_JPRB,4.1278E-02_JPRB,5.3126E-02_JPRB/)  
KAO( :, 6,13) = (/&
 & 1.3063E-02_JPRB,1.8582E-02_JPRB,2.5843E-02_JPRB,3.5011E-02_JPRB,4.6230E-02_JPRB/)  
KAO( :, 7,13) = (/&
 & 1.0425E-02_JPRB,1.5209E-02_JPRB,2.1684E-02_JPRB,3.0071E-02_JPRB,4.0394E-02_JPRB/)  
KAO( :, 1,14) = (/&
 & 6.7724E-02_JPRB,8.4655E-02_JPRB,1.0308E-01_JPRB,1.2311E-01_JPRB,1.4477E-01_JPRB/)  
KAO( :, 2,14) = (/&
 & 6.5011E-02_JPRB,8.2552E-02_JPRB,1.0230E-01_JPRB,1.2414E-01_JPRB,1.4787E-01_JPRB/)  
KAO( :, 3,14) = (/&
 & 5.8480E-02_JPRB,7.6209E-02_JPRB,9.6519E-02_JPRB,1.1921E-01_JPRB,1.4411E-01_JPRB/)  
KAO( :, 4,14) = (/&
 & 5.0538E-02_JPRB,6.7706E-02_JPRB,8.7706E-02_JPRB,1.1039E-01_JPRB,1.3557E-01_JPRB/)  
KAO( :, 5,14) = (/&
 & 4.2513E-02_JPRB,5.8604E-02_JPRB,7.7718E-02_JPRB,9.9786E-02_JPRB,1.2457E-01_JPRB/)  
KAO( :, 6,14) = (/&
 & 3.4330E-02_JPRB,4.8876E-02_JPRB,6.6577E-02_JPRB,8.7405E-02_JPRB,1.1118E-01_JPRB/)  
KAO( :, 7,14) = (/&
 & 2.6895E-02_JPRB,3.9673E-02_JPRB,5.5652E-02_JPRB,7.4888E-02_JPRB,9.7567E-02_JPRB/)  
KAO( :, 1,15) = (/&
 & 1.0185E-01_JPRB,1.3012E-01_JPRB,1.6176E-01_JPRB,1.9624E-01_JPRB,2.3332E-01_JPRB/)  
KAO( :, 2,15) = (/&
 & 1.1155E-01_JPRB,1.4413E-01_JPRB,1.8079E-01_JPRB,2.2100E-01_JPRB,2.6440E-01_JPRB/)  
KAO( :, 3,15) = (/&
 & 1.1383E-01_JPRB,1.4981E-01_JPRB,1.9079E-01_JPRB,2.3617E-01_JPRB,2.8542E-01_JPRB/)  
KAO( :, 4,15) = (/&
 & 1.1063E-01_JPRB,1.4879E-01_JPRB,1.9288E-01_JPRB,2.4229E-01_JPRB,2.9650E-01_JPRB/)  
KAO( :, 5,15) = (/&
 & 1.0438E-01_JPRB,1.4376E-01_JPRB,1.8985E-01_JPRB,2.4227E-01_JPRB,3.0021E-01_JPRB/)  
KAO( :, 6,15) = (/&
 & 9.4497E-02_JPRB,1.3374E-01_JPRB,1.8056E-01_JPRB,2.3453E-01_JPRB,2.9486E-01_JPRB/)  
KAO( :, 7,15) = (/&
 & 8.2957E-02_JPRB,1.2094E-01_JPRB,1.6723E-01_JPRB,2.2140E-01_JPRB,2.8274E-01_JPRB/)  
KAO( :, 1,16) = (/&
 & 1.0659E-01_JPRB,1.3667E-01_JPRB,1.7042E-01_JPRB,2.0748E-01_JPRB,2.4752E-01_JPRB/)  
KAO( :, 2,16) = (/&
 & 1.1936E-01_JPRB,1.5500E-01_JPRB,1.9536E-01_JPRB,2.4009E-01_JPRB,2.8872E-01_JPRB/)  
KAO( :, 3,16) = (/&
 & 1.2557E-01_JPRB,1.6646E-01_JPRB,2.1346E-01_JPRB,2.6622E-01_JPRB,3.2416E-01_JPRB/)  
KAO( :, 4,16) = (/&
 & 1.2678E-01_JPRB,1.7224E-01_JPRB,2.2548E-01_JPRB,2.8607E-01_JPRB,3.5364E-01_JPRB/)  
KAO( :, 5,16) = (/&
 & 1.2544E-01_JPRB,1.7513E-01_JPRB,2.3441E-01_JPRB,3.0312E-01_JPRB,3.8068E-01_JPRB/)  
KAO( :, 6,16) = (/&
 & 1.2054E-01_JPRB,1.7357E-01_JPRB,2.3849E-01_JPRB,3.1499E-01_JPRB,4.0276E-01_JPRB/)  
KAO( :, 7,16) = (/&
 & 1.1373E-01_JPRB,1.6957E-01_JPRB,2.3956E-01_JPRB,3.2393E-01_JPRB,4.2231E-01_JPRB/)  

!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.

KBO( :, 7, 1) = (/&
 & 1.5344E-01_JPRB,1.5367E-01_JPRB,1.5941E-01_JPRB,1.6925E-01_JPRB,1.8219E-01_JPRB/)  
KBO( :, 8, 1) = (/&
 & 8.8789E-02_JPRB,9.2028E-02_JPRB,9.6207E-02_JPRB,1.0152E-01_JPRB,1.0774E-01_JPRB/)  
KBO( :, 9, 1) = (/&
 & 6.1726E-02_JPRB,6.3618E-02_JPRB,6.5404E-02_JPRB,6.7402E-02_JPRB,6.9517E-02_JPRB/)  
KBO( :,10, 1) = (/&
 & 4.5887E-02_JPRB,4.6735E-02_JPRB,4.7381E-02_JPRB,4.7984E-02_JPRB,4.8665E-02_JPRB/)  
KBO( :,11, 1) = (/&
 & 3.4925E-02_JPRB,3.5331E-02_JPRB,3.5614E-02_JPRB,3.5819E-02_JPRB,3.6029E-02_JPRB/)  
KBO( :,12, 1) = (/&
 & 2.7314E-02_JPRB,2.7563E-02_JPRB,2.7715E-02_JPRB,2.7787E-02_JPRB,2.7858E-02_JPRB/)  
KBO( :,13, 1) = (/&
 & 2.1065E-02_JPRB,2.1225E-02_JPRB,2.1307E-02_JPRB,2.1318E-02_JPRB,2.1310E-02_JPRB/)  
KBO( :,14, 1) = (/&
 & 1.4917E-02_JPRB,1.5002E-02_JPRB,1.5042E-02_JPRB,1.5027E-02_JPRB,1.4972E-02_JPRB/)  
KBO( :,15, 1) = (/&
 & 1.0550E-02_JPRB,1.0630E-02_JPRB,1.0661E-02_JPRB,1.0642E-02_JPRB,1.0580E-02_JPRB/)  
KBO( :,16, 1) = (/&
 & 7.8366E-03_JPRB,7.9085E-03_JPRB,7.9349E-03_JPRB,7.9229E-03_JPRB,7.8769E-03_JPRB/)  
KBO( :,17, 1) = (/&
 & 5.9572E-03_JPRB,6.0203E-03_JPRB,6.0443E-03_JPRB,6.0374E-03_JPRB,6.0008E-03_JPRB/)  
KBO( :,18, 1) = (/&
 & 4.6349E-03_JPRB,4.6854E-03_JPRB,4.7034E-03_JPRB,4.6981E-03_JPRB,4.6669E-03_JPRB/)  
KBO( :,19, 1) = (/&
 & 3.6293E-03_JPRB,3.6694E-03_JPRB,3.6836E-03_JPRB,3.6780E-03_JPRB,3.6512E-03_JPRB/)  
KBO( :,20, 1) = (/&
 & 2.8991E-03_JPRB,2.9305E-03_JPRB,2.9407E-03_JPRB,2.9341E-03_JPRB,2.9107E-03_JPRB/)  
KBO( :,21, 1) = (/&
 & 2.3312E-03_JPRB,2.3555E-03_JPRB,2.3622E-03_JPRB,2.3550E-03_JPRB,2.3344E-03_JPRB/)  
KBO( :,22, 1) = (/&
 & 1.8792E-03_JPRB,1.8968E-03_JPRB,1.9000E-03_JPRB,1.8924E-03_JPRB,1.8741E-03_JPRB/)  
KBO( :,23, 1) = (/&
 & 1.5156E-03_JPRB,1.5280E-03_JPRB,1.5291E-03_JPRB,1.5212E-03_JPRB,1.5056E-03_JPRB/)  
KBO( :,24, 1) = (/&
 & 1.2179E-03_JPRB,1.2265E-03_JPRB,1.2264E-03_JPRB,1.2189E-03_JPRB,1.2054E-03_JPRB/)  
KBO( :,25, 1) = (/&
 & 9.8120E-04_JPRB,9.8697E-04_JPRB,9.8592E-04_JPRB,9.7898E-04_JPRB,9.6753E-04_JPRB/)  
KBO( :,26, 1) = (/&
 & 7.9366E-04_JPRB,7.9724E-04_JPRB,7.9535E-04_JPRB,7.8897E-04_JPRB,7.7900E-04_JPRB/)  
KBO( :,27, 1) = (/&
 & 6.4346E-04_JPRB,6.4543E-04_JPRB,6.4311E-04_JPRB,6.3737E-04_JPRB,6.2874E-04_JPRB/)  
KBO( :,28, 1) = (/&
 & 5.2197E-04_JPRB,5.2286E-04_JPRB,5.2043E-04_JPRB,5.1528E-04_JPRB,5.0784E-04_JPRB/)  
KBO( :,29, 1) = (/&
 & 4.2576E-04_JPRB,4.2585E-04_JPRB,4.2341E-04_JPRB,4.1882E-04_JPRB,4.1242E-04_JPRB/)  
KBO( :,30, 1) = (/&
 & 3.4748E-04_JPRB,3.4709E-04_JPRB,3.4471E-04_JPRB,3.4067E-04_JPRB,3.3521E-04_JPRB/)  
KBO( :,31, 1) = (/&
 & 2.8441E-04_JPRB,2.8375E-04_JPRB,2.8150E-04_JPRB,2.7801E-04_JPRB,2.7335E-04_JPRB/)  
KBO( :,32, 1) = (/&
 & 2.3282E-04_JPRB,2.3200E-04_JPRB,2.2995E-04_JPRB,2.2696E-04_JPRB,2.2295E-04_JPRB/)  
KBO( :,33, 1) = (/&
 & 1.9062E-04_JPRB,1.8973E-04_JPRB,1.8792E-04_JPRB,1.8531E-04_JPRB,1.8184E-04_JPRB/)  
KBO( :,34, 1) = (/&
 & 1.5614E-04_JPRB,1.5526E-04_JPRB,1.5366E-04_JPRB,1.5137E-04_JPRB,1.4839E-04_JPRB/)  
KBO( :,35, 1) = (/&
 & 1.2772E-04_JPRB,1.2697E-04_JPRB,1.2561E-04_JPRB,1.2363E-04_JPRB,1.2119E-04_JPRB/)  
KBO( :,36, 1) = (/&
 & 1.0427E-04_JPRB,1.0367E-04_JPRB,1.0254E-04_JPRB,1.0093E-04_JPRB,9.8988E-05_JPRB/)  
KBO( :,37, 1) = (/&
 & 8.5618E-05_JPRB,8.5197E-05_JPRB,8.4329E-05_JPRB,8.3067E-05_JPRB,8.1529E-05_JPRB/)  
KBO( :,38, 1) = (/&
 & 7.0355E-05_JPRB,7.0067E-05_JPRB,6.9409E-05_JPRB,6.8426E-05_JPRB,6.7223E-05_JPRB/)  
KBO( :,39, 1) = (/&
 & 5.7837E-05_JPRB,5.7651E-05_JPRB,5.7166E-05_JPRB,5.6411E-05_JPRB,5.5474E-05_JPRB/)  
KBO( :,40, 1) = (/&
 & 4.7471E-05_JPRB,4.7392E-05_JPRB,4.7060E-05_JPRB,4.6496E-05_JPRB,4.5776E-05_JPRB/)  
KBO( :,41, 1) = (/&
 & 3.8945E-05_JPRB,3.8946E-05_JPRB,3.8735E-05_JPRB,3.8320E-05_JPRB,3.7771E-05_JPRB/)  
KBO( :,42, 1) = (/&
 & 3.1942E-05_JPRB,3.2000E-05_JPRB,3.1880E-05_JPRB,3.1585E-05_JPRB,3.1172E-05_JPRB/)  
KBO( :,43, 1) = (/&
 & 2.6212E-05_JPRB,2.6319E-05_JPRB,2.6272E-05_JPRB,2.6076E-05_JPRB,2.5773E-05_JPRB/)  
KBO( :,44, 1) = (/&
 & 2.1513E-05_JPRB,2.1656E-05_JPRB,2.1665E-05_JPRB,2.1549E-05_JPRB,2.1335E-05_JPRB/)  
KBO( :,45, 1) = (/&
 & 1.7662E-05_JPRB,1.7828E-05_JPRB,1.7877E-05_JPRB,1.7820E-05_JPRB,1.7676E-05_JPRB/)  
KBO( :,46, 1) = (/&
 & 1.4497E-05_JPRB,1.4675E-05_JPRB,1.4757E-05_JPRB,1.4745E-05_JPRB,1.4651E-05_JPRB/)  
KBO( :,47, 1) = (/&
 & 1.1877E-05_JPRB,1.2067E-05_JPRB,1.2171E-05_JPRB,1.2193E-05_JPRB,1.2145E-05_JPRB/)  
KBO( :,48, 1) = (/&
 & 9.7397E-06_JPRB,9.9314E-06_JPRB,1.0047E-05_JPRB,1.0098E-05_JPRB,1.0083E-05_JPRB/)  
KBO( :,49, 1) = (/&
 & 8.0031E-06_JPRB,8.1919E-06_JPRB,8.3161E-06_JPRB,8.3842E-06_JPRB,8.3974E-06_JPRB/)  
KBO( :,50, 1) = (/&
 & 6.5533E-06_JPRB,6.7351E-06_JPRB,6.8590E-06_JPRB,6.9358E-06_JPRB,6.9657E-06_JPRB/)  
KBO( :,51, 1) = (/&
 & 5.3534E-06_JPRB,5.5271E-06_JPRB,5.6449E-06_JPRB,5.7254E-06_JPRB,5.7657E-06_JPRB/)  
KBO( :,52, 1) = (/&
 & 4.3815E-06_JPRB,4.5440E-06_JPRB,4.6552E-06_JPRB,4.7359E-06_JPRB,4.7826E-06_JPRB/)  
KBO( :,53, 1) = (/&
 & 3.5983E-06_JPRB,3.7484E-06_JPRB,3.8526E-06_JPRB,3.9323E-06_JPRB,3.9834E-06_JPRB/)  
KBO( :,54, 1) = (/&
 & 2.9135E-06_JPRB,3.0488E-06_JPRB,3.1449E-06_JPRB,3.2176E-06_JPRB,3.2676E-06_JPRB/)  
KBO( :,55, 1) = (/&
 & 2.3344E-06_JPRB,2.4540E-06_JPRB,2.5433E-06_JPRB,2.6072E-06_JPRB,2.6532E-06_JPRB/)  
KBO( :,56, 1) = (/&
 & 1.8674E-06_JPRB,1.9725E-06_JPRB,2.0540E-06_JPRB,2.1112E-06_JPRB,2.1532E-06_JPRB/)  
KBO( :,57, 1) = (/&
 & 1.4909E-06_JPRB,1.5832E-06_JPRB,1.6559E-06_JPRB,1.7087E-06_JPRB,1.7463E-06_JPRB/)  
KBO( :,58, 1) = (/&
 & 1.1855E-06_JPRB,1.2659E-06_JPRB,1.3298E-06_JPRB,1.3781E-06_JPRB,1.4118E-06_JPRB/)  
KBO( :,59, 1) = (/&
 & 9.3006E-07_JPRB,9.9739E-07_JPRB,1.0501E-06_JPRB,1.0906E-06_JPRB,1.1193E-06_JPRB/)  
KBO( :, 7, 2) = (/&
 & 2.6778E-01_JPRB,2.8245E-01_JPRB,3.0362E-01_JPRB,3.3204E-01_JPRB,3.6642E-01_JPRB/)  
KBO( :, 8, 2) = (/&
 & 1.6981E-01_JPRB,1.8043E-01_JPRB,1.9307E-01_JPRB,2.0690E-01_JPRB,2.2313E-01_JPRB/)  
KBO( :, 9, 2) = (/&
 & 1.2053E-01_JPRB,1.2497E-01_JPRB,1.3056E-01_JPRB,1.3643E-01_JPRB,1.4282E-01_JPRB/)  
KBO( :,10, 2) = (/&
 & 8.7626E-02_JPRB,8.9514E-02_JPRB,9.1744E-02_JPRB,9.4317E-02_JPRB,9.6890E-02_JPRB/)  
KBO( :,11, 2) = (/&
 & 6.5833E-02_JPRB,6.6899E-02_JPRB,6.8102E-02_JPRB,6.9485E-02_JPRB,7.0886E-02_JPRB/)  
KBO( :,12, 2) = (/&
 & 5.1441E-02_JPRB,5.2186E-02_JPRB,5.3006E-02_JPRB,5.3843E-02_JPRB,5.4676E-02_JPRB/)  
KBO( :,13, 2) = (/&
 & 3.9685E-02_JPRB,4.0210E-02_JPRB,4.0730E-02_JPRB,4.1271E-02_JPRB,4.1791E-02_JPRB/)  
KBO( :,14, 2) = (/&
 & 2.8508E-02_JPRB,2.8827E-02_JPRB,2.9089E-02_JPRB,2.9311E-02_JPRB,2.9533E-02_JPRB/)  
KBO( :,15, 2) = (/&
 & 2.0989E-02_JPRB,2.1138E-02_JPRB,2.1243E-02_JPRB,2.1329E-02_JPRB,2.1410E-02_JPRB/)  
KBO( :,16, 2) = (/&
 & 1.6136E-02_JPRB,1.6221E-02_JPRB,1.6271E-02_JPRB,1.6299E-02_JPRB,1.6318E-02_JPRB/)  
KBO( :,17, 2) = (/&
 & 1.2642E-02_JPRB,1.2693E-02_JPRB,1.2714E-02_JPRB,1.2705E-02_JPRB,1.2688E-02_JPRB/)  
KBO( :,18, 2) = (/&
 & 1.0065E-02_JPRB,1.0094E-02_JPRB,1.0094E-02_JPRB,1.0071E-02_JPRB,1.0038E-02_JPRB/)  
KBO( :,19, 2) = (/&
 & 8.0455E-03_JPRB,8.0605E-03_JPRB,8.0482E-03_JPRB,8.0166E-03_JPRB,7.9752E-03_JPRB/)  
KBO( :,20, 2) = (/&
 & 6.5051E-03_JPRB,6.5116E-03_JPRB,6.4957E-03_JPRB,6.4648E-03_JPRB,6.4247E-03_JPRB/)  
KBO( :,21, 2) = (/&
 & 5.2778E-03_JPRB,5.2806E-03_JPRB,5.2632E-03_JPRB,5.2348E-03_JPRB,5.1970E-03_JPRB/)  
KBO( :,22, 2) = (/&
 & 4.2858E-03_JPRB,4.2841E-03_JPRB,4.2670E-03_JPRB,4.2400E-03_JPRB,4.2048E-03_JPRB/)  
KBO( :,23, 2) = (/&
 & 3.4793E-03_JPRB,3.4753E-03_JPRB,3.4584E-03_JPRB,3.4334E-03_JPRB,3.4014E-03_JPRB/)  
KBO( :,24, 2) = (/&
 & 2.8185E-03_JPRB,2.8125E-03_JPRB,2.7957E-03_JPRB,2.7728E-03_JPRB,2.7436E-03_JPRB/)  
KBO( :,25, 2) = (/&
 & 2.2861E-03_JPRB,2.2783E-03_JPRB,2.2629E-03_JPRB,2.2419E-03_JPRB,2.2158E-03_JPRB/)  
KBO( :,26, 2) = (/&
 & 1.8574E-03_JPRB,1.8493E-03_JPRB,1.8350E-03_JPRB,1.8161E-03_JPRB,1.7932E-03_JPRB/)  
KBO( :,27, 2) = (/&
 & 1.5109E-03_JPRB,1.5030E-03_JPRB,1.4902E-03_JPRB,1.4736E-03_JPRB,1.4543E-03_JPRB/)  
KBO( :,28, 2) = (/&
 & 1.2296E-03_JPRB,1.2220E-03_JPRB,1.2106E-03_JPRB,1.1965E-03_JPRB,1.1802E-03_JPRB/)  
KBO( :,29, 2) = (/&
 & 1.0041E-03_JPRB,9.9721E-04_JPRB,9.8729E-04_JPRB,9.7563E-04_JPRB,9.6203E-04_JPRB/)  
KBO( :,30, 2) = (/&
 & 8.2028E-04_JPRB,8.1422E-04_JPRB,8.0597E-04_JPRB,7.9622E-04_JPRB,7.8494E-04_JPRB/)  
KBO( :,31, 2) = (/&
 & 6.7162E-04_JPRB,6.6632E-04_JPRB,6.5964E-04_JPRB,6.5163E-04_JPRB,6.4255E-04_JPRB/)  
KBO( :,32, 2) = (/&
 & 5.5003E-04_JPRB,5.4568E-04_JPRB,5.4025E-04_JPRB,5.3369E-04_JPRB,5.2646E-04_JPRB/)  
KBO( :,33, 2) = (/&
 & 4.5068E-04_JPRB,4.4725E-04_JPRB,4.4286E-04_JPRB,4.3761E-04_JPRB,4.3173E-04_JPRB/)  
KBO( :,34, 2) = (/&
 & 3.6961E-04_JPRB,3.6684E-04_JPRB,3.6327E-04_JPRB,3.5906E-04_JPRB,3.5439E-04_JPRB/)  
KBO( :,35, 2) = (/&
 & 3.0315E-04_JPRB,3.0096E-04_JPRB,2.9817E-04_JPRB,2.9485E-04_JPRB,2.9125E-04_JPRB/)  
KBO( :,36, 2) = (/&
 & 2.4847E-04_JPRB,2.4681E-04_JPRB,2.4467E-04_JPRB,2.4215E-04_JPRB,2.3935E-04_JPRB/)  
KBO( :,37, 2) = (/&
 & 2.0443E-04_JPRB,2.0324E-04_JPRB,2.0165E-04_JPRB,1.9975E-04_JPRB,1.9759E-04_JPRB/)  
KBO( :,38, 2) = (/&
 & 1.6831E-04_JPRB,1.6749E-04_JPRB,1.6632E-04_JPRB,1.6492E-04_JPRB,1.6327E-04_JPRB/)  
KBO( :,39, 2) = (/&
 & 1.3865E-04_JPRB,1.3814E-04_JPRB,1.3731E-04_JPRB,1.3631E-04_JPRB,1.3505E-04_JPRB/)  
KBO( :,40, 2) = (/&
 & 1.1402E-04_JPRB,1.1372E-04_JPRB,1.1314E-04_JPRB,1.1240E-04_JPRB,1.1148E-04_JPRB/)  
KBO( :,41, 2) = (/&
 & 9.3740E-05_JPRB,9.3582E-05_JPRB,9.3200E-05_JPRB,9.2678E-05_JPRB,9.2002E-05_JPRB/)  
KBO( :,42, 2) = (/&
 & 7.7058E-05_JPRB,7.7015E-05_JPRB,7.6781E-05_JPRB,7.6427E-05_JPRB,7.5949E-05_JPRB/)  
KBO( :,43, 2) = (/&
 & 6.3364E-05_JPRB,6.3414E-05_JPRB,6.3300E-05_JPRB,6.3083E-05_JPRB,6.2768E-05_JPRB/)  
KBO( :,44, 2) = (/&
 & 5.2113E-05_JPRB,5.2236E-05_JPRB,5.2217E-05_JPRB,5.2105E-05_JPRB,5.1917E-05_JPRB/)  
KBO( :,45, 2) = (/&
 & 4.2872E-05_JPRB,4.3047E-05_JPRB,4.3096E-05_JPRB,4.3067E-05_JPRB,4.2976E-05_JPRB/)  
KBO( :,46, 2) = (/&
 & 3.5259E-05_JPRB,3.5470E-05_JPRB,3.5572E-05_JPRB,3.5602E-05_JPRB,3.5583E-05_JPRB/)  
KBO( :,47, 2) = (/&
 & 2.8960E-05_JPRB,2.9201E-05_JPRB,2.9340E-05_JPRB,2.9409E-05_JPRB,2.9443E-05_JPRB/)  
KBO( :,48, 2) = (/&
 & 2.3793E-05_JPRB,2.4061E-05_JPRB,2.4219E-05_JPRB,2.4324E-05_JPRB,2.4398E-05_JPRB/)  
KBO( :,49, 2) = (/&
 & 1.9573E-05_JPRB,1.9855E-05_JPRB,2.0037E-05_JPRB,2.0166E-05_JPRB,2.0269E-05_JPRB/)  
KBO( :,50, 2) = (/&
 & 1.6059E-05_JPRB,1.6336E-05_JPRB,1.6527E-05_JPRB,1.6662E-05_JPRB,1.6777E-05_JPRB/)  
KBO( :,51, 2) = (/&
 & 1.3152E-05_JPRB,1.3417E-05_JPRB,1.3609E-05_JPRB,1.3741E-05_JPRB,1.3858E-05_JPRB/)  
KBO( :,52, 2) = (/&
 & 1.0779E-05_JPRB,1.1030E-05_JPRB,1.1223E-05_JPRB,1.1354E-05_JPRB,1.1469E-05_JPRB/)  
KBO( :,53, 2) = (/&
 & 8.8506E-06_JPRB,9.0876E-06_JPRB,9.2783E-06_JPRB,9.4085E-06_JPRB,9.5236E-06_JPRB/)  
KBO( :,54, 2) = (/&
 & 7.2038E-06_JPRB,7.4123E-06_JPRB,7.5866E-06_JPRB,7.7062E-06_JPRB,7.8090E-06_JPRB/)  
KBO( :,55, 2) = (/&
 & 5.8272E-06_JPRB,6.0075E-06_JPRB,6.1562E-06_JPRB,6.2660E-06_JPRB,6.3502E-06_JPRB/)  
KBO( :,56, 2) = (/&
 & 4.7097E-06_JPRB,4.8664E-06_JPRB,4.9937E-06_JPRB,5.0923E-06_JPRB,5.1636E-06_JPRB/)  
KBO( :,57, 2) = (/&
 & 3.8029E-06_JPRB,3.9406E-06_JPRB,4.0499E-06_JPRB,4.1369E-06_JPRB,4.1983E-06_JPRB/)  
KBO( :,58, 2) = (/&
 & 3.0636E-06_JPRB,3.1845E-06_JPRB,3.2784E-06_JPRB,3.3529E-06_JPRB,3.4074E-06_JPRB/)  
KBO( :,59, 2) = (/&
 & 2.4518E-06_JPRB,2.5533E-06_JPRB,2.6281E-06_JPRB,2.6848E-06_JPRB,2.7259E-06_JPRB/)  
KBO( :, 7, 3) = (/&
 & 3.9261E-01_JPRB,4.1826E-01_JPRB,4.5486E-01_JPRB,5.0020E-01_JPRB,5.5441E-01_JPRB/)  
KBO( :, 8, 3) = (/&
 & 2.6302E-01_JPRB,2.7629E-01_JPRB,2.9316E-01_JPRB,3.1489E-01_JPRB,3.3903E-01_JPRB/)  
KBO( :, 9, 3) = (/&
 & 1.8742E-01_JPRB,1.9413E-01_JPRB,2.0162E-01_JPRB,2.1065E-01_JPRB,2.2099E-01_JPRB/)  
KBO( :,10, 3) = (/&
 & 1.3691E-01_JPRB,1.3995E-01_JPRB,1.4395E-01_JPRB,1.4843E-01_JPRB,1.5362E-01_JPRB/)  
KBO( :,11, 3) = (/&
 & 1.0382E-01_JPRB,1.0590E-01_JPRB,1.0849E-01_JPRB,1.1133E-01_JPRB,1.1437E-01_JPRB/)  
KBO( :,12, 3) = (/&
 & 8.2774E-02_JPRB,8.4314E-02_JPRB,8.6091E-02_JPRB,8.8097E-02_JPRB,9.0175E-02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB8:PART2',1,ZHOOK_HANDLE)
END SUBROUTINE PART2


SUBROUTINE PART3

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB8:PART3',0,ZHOOK_HANDLE)


KBO( :,13, 3) = (/&
 & 6.5297E-02_JPRB,6.6392E-02_JPRB,6.7652E-02_JPRB,6.8979E-02_JPRB,7.0293E-02_JPRB/)  
KBO( :,14, 3) = (/&
 & 4.8355E-02_JPRB,4.9038E-02_JPRB,4.9706E-02_JPRB,5.0319E-02_JPRB,5.0878E-02_JPRB/)  
KBO( :,15, 3) = (/&
 & 3.6518E-02_JPRB,3.6926E-02_JPRB,3.7222E-02_JPRB,3.7439E-02_JPRB,3.7640E-02_JPRB/)  
KBO( :,16, 3) = (/&
 & 2.8643E-02_JPRB,2.8895E-02_JPRB,2.9016E-02_JPRB,2.9088E-02_JPRB,2.9132E-02_JPRB/)  
KBO( :,17, 3) = (/&
 & 2.2761E-02_JPRB,2.2905E-02_JPRB,2.2941E-02_JPRB,2.2947E-02_JPRB,2.2921E-02_JPRB/)  
KBO( :,18, 3) = (/&
 & 1.8278E-02_JPRB,1.8355E-02_JPRB,1.8353E-02_JPRB,1.8324E-02_JPRB,1.8265E-02_JPRB/)  
KBO( :,19, 3) = (/&
 & 1.4700E-02_JPRB,1.4733E-02_JPRB,1.4709E-02_JPRB,1.4660E-02_JPRB,1.4585E-02_JPRB/)  
KBO( :,20, 3) = (/&
 & 1.1936E-02_JPRB,1.1946E-02_JPRB,1.1914E-02_JPRB,1.1862E-02_JPRB,1.1789E-02_JPRB/)  
KBO( :,21, 3) = (/&
 & 9.7139E-03_JPRB,9.7118E-03_JPRB,9.6809E-03_JPRB,9.6307E-03_JPRB,9.5648E-03_JPRB/)  
KBO( :,22, 3) = (/&
 & 7.9072E-03_JPRB,7.8970E-03_JPRB,7.8671E-03_JPRB,7.8212E-03_JPRB,7.7623E-03_JPRB/)  
KBO( :,23, 3) = (/&
 & 6.4329E-03_JPRB,6.4199E-03_JPRB,6.3920E-03_JPRB,6.3512E-03_JPRB,6.2995E-03_JPRB/)  
KBO( :,24, 3) = (/&
 & 5.2216E-03_JPRB,5.2078E-03_JPRB,5.1821E-03_JPRB,5.1436E-03_JPRB,5.0968E-03_JPRB/)  
KBO( :,25, 3) = (/&
 & 4.2420E-03_JPRB,4.2282E-03_JPRB,4.2046E-03_JPRB,4.1704E-03_JPRB,4.1288E-03_JPRB/)  
KBO( :,26, 3) = (/&
 & 3.4526E-03_JPRB,3.4398E-03_JPRB,3.4183E-03_JPRB,3.3878E-03_JPRB,3.3511E-03_JPRB/)  
KBO( :,27, 3) = (/&
 & 2.8139E-03_JPRB,2.8022E-03_JPRB,2.7830E-03_JPRB,2.7568E-03_JPRB,2.7244E-03_JPRB/)  
KBO( :,28, 3) = (/&
 & 2.2948E-03_JPRB,2.2838E-03_JPRB,2.2669E-03_JPRB,2.2441E-03_JPRB,2.2163E-03_JPRB/)  
KBO( :,29, 3) = (/&
 & 1.8779E-03_JPRB,1.8678E-03_JPRB,1.8537E-03_JPRB,1.8342E-03_JPRB,1.8116E-03_JPRB/)  
KBO( :,30, 3) = (/&
 & 1.5371E-03_JPRB,1.5290E-03_JPRB,1.5169E-03_JPRB,1.5009E-03_JPRB,1.4827E-03_JPRB/)  
KBO( :,31, 3) = (/&
 & 1.2613E-03_JPRB,1.2550E-03_JPRB,1.2450E-03_JPRB,1.2325E-03_JPRB,1.2181E-03_JPRB/)  
KBO( :,32, 3) = (/&
 & 1.0360E-03_JPRB,1.0308E-03_JPRB,1.0228E-03_JPRB,1.0131E-03_JPRB,1.0022E-03_JPRB/)  
KBO( :,33, 3) = (/&
 & 8.5168E-04_JPRB,8.4735E-04_JPRB,8.4147E-04_JPRB,8.3412E-04_JPRB,8.2675E-04_JPRB/)  
KBO( :,34, 3) = (/&
 & 7.0046E-04_JPRB,6.9716E-04_JPRB,6.9264E-04_JPRB,6.8755E-04_JPRB,6.8249E-04_JPRB/)  
KBO( :,35, 3) = (/&
 & 5.7604E-04_JPRB,5.7373E-04_JPRB,5.7061E-04_JPRB,5.6737E-04_JPRB,5.6396E-04_JPRB/)  
KBO( :,36, 3) = (/&
 & 4.7323E-04_JPRB,4.7186E-04_JPRB,4.7003E-04_JPRB,4.6804E-04_JPRB,4.6592E-04_JPRB/)  
KBO( :,37, 3) = (/&
 & 3.9007E-04_JPRB,3.8932E-04_JPRB,3.8831E-04_JPRB,3.8717E-04_JPRB,3.8593E-04_JPRB/)  
KBO( :,38, 3) = (/&
 & 3.2170E-04_JPRB,3.2146E-04_JPRB,3.2110E-04_JPRB,3.2061E-04_JPRB,3.2010E-04_JPRB/)  
KBO( :,39, 3) = (/&
 & 2.6546E-04_JPRB,2.6568E-04_JPRB,2.6585E-04_JPRB,2.6593E-04_JPRB,2.6594E-04_JPRB/)  
KBO( :,40, 3) = (/&
 & 2.1847E-04_JPRB,2.1891E-04_JPRB,2.1928E-04_JPRB,2.1962E-04_JPRB,2.1986E-04_JPRB/)  
KBO( :,41, 3) = (/&
 & 1.7969E-04_JPRB,1.8027E-04_JPRB,1.8078E-04_JPRB,1.8126E-04_JPRB,1.8165E-04_JPRB/)  
KBO( :,42, 3) = (/&
 & 1.4779E-04_JPRB,1.4846E-04_JPRB,1.4905E-04_JPRB,1.4963E-04_JPRB,1.5013E-04_JPRB/)  
KBO( :,43, 3) = (/&
 & 1.2154E-04_JPRB,1.2228E-04_JPRB,1.2292E-04_JPRB,1.2357E-04_JPRB,1.2415E-04_JPRB/)  
KBO( :,44, 3) = (/&
 & 9.9958E-05_JPRB,1.0073E-04_JPRB,1.0140E-04_JPRB,1.0208E-04_JPRB,1.0273E-04_JPRB/)  
KBO( :,45, 3) = (/&
 & 8.2216E-05_JPRB,8.3000E-05_JPRB,8.3698E-05_JPRB,8.4403E-05_JPRB,8.5080E-05_JPRB/)  
KBO( :,46, 3) = (/&
 & 6.7594E-05_JPRB,6.8376E-05_JPRB,6.9061E-05_JPRB,6.9778E-05_JPRB,7.0474E-05_JPRB/)  
KBO( :,47, 3) = (/&
 & 5.5485E-05_JPRB,5.6232E-05_JPRB,5.6898E-05_JPRB,5.7591E-05_JPRB,5.8280E-05_JPRB/)  
KBO( :,48, 3) = (/&
 & 4.5552E-05_JPRB,4.6275E-05_JPRB,4.6918E-05_JPRB,4.7596E-05_JPRB,4.8274E-05_JPRB/)  
KBO( :,49, 3) = (/&
 & 3.7438E-05_JPRB,3.8131E-05_JPRB,3.8767E-05_JPRB,3.9430E-05_JPRB,4.0094E-05_JPRB/)  
KBO( :,50, 3) = (/&
 & 3.0699E-05_JPRB,3.1333E-05_JPRB,3.1922E-05_JPRB,3.2530E-05_JPRB,3.3148E-05_JPRB/)  
KBO( :,51, 3) = (/&
 & 2.5129E-05_JPRB,2.5702E-05_JPRB,2.6235E-05_JPRB,2.6778E-05_JPRB,2.7340E-05_JPRB/)  
KBO( :,52, 3) = (/&
 & 2.0590E-05_JPRB,2.1102E-05_JPRB,2.1590E-05_JPRB,2.2079E-05_JPRB,2.2594E-05_JPRB/)  
KBO( :,53, 3) = (/&
 & 1.6895E-05_JPRB,1.7360E-05_JPRB,1.7806E-05_JPRB,1.8261E-05_JPRB,1.8734E-05_JPRB/)  
KBO( :,54, 3) = (/&
 & 1.3758E-05_JPRB,1.4159E-05_JPRB,1.4534E-05_JPRB,1.4917E-05_JPRB,1.5317E-05_JPRB/)  
KBO( :,55, 3) = (/&
 & 1.1148E-05_JPRB,1.1484E-05_JPRB,1.1790E-05_JPRB,1.2094E-05_JPRB,1.2411E-05_JPRB/)  
KBO( :,56, 3) = (/&
 & 9.0284E-06_JPRB,9.3136E-06_JPRB,9.5654E-06_JPRB,9.8098E-06_JPRB,1.0060E-05_JPRB/)  
KBO( :,57, 3) = (/&
 & 7.3060E-06_JPRB,7.5521E-06_JPRB,7.7610E-06_JPRB,7.9575E-06_JPRB,8.1567E-06_JPRB/)  
KBO( :,58, 3) = (/&
 & 5.9024E-06_JPRB,6.1146E-06_JPRB,6.2887E-06_JPRB,6.4473E-06_JPRB,6.6035E-06_JPRB/)  
KBO( :,59, 3) = (/&
 & 4.7480E-06_JPRB,4.9198E-06_JPRB,5.0575E-06_JPRB,5.1729E-06_JPRB,5.2807E-06_JPRB/)  
KBO( :, 7, 4) = (/&
 & 5.4576E-01_JPRB,5.8321E-01_JPRB,6.3352E-01_JPRB,6.9888E-01_JPRB,7.7662E-01_JPRB/)  
KBO( :, 8, 4) = (/&
 & 3.7193E-01_JPRB,3.9289E-01_JPRB,4.1999E-01_JPRB,4.5207E-01_JPRB,4.8994E-01_JPRB/)  
KBO( :, 9, 4) = (/&
 & 2.7031E-01_JPRB,2.8087E-01_JPRB,2.9426E-01_JPRB,3.0966E-01_JPRB,3.2729E-01_JPRB/)  
KBO( :,10, 4) = (/&
 & 2.0336E-01_JPRB,2.0948E-01_JPRB,2.1603E-01_JPRB,2.2414E-01_JPRB,2.3345E-01_JPRB/)  
KBO( :,11, 4) = (/&
 & 1.6168E-01_JPRB,1.6588E-01_JPRB,1.7020E-01_JPRB,1.7548E-01_JPRB,1.8161E-01_JPRB/)  
KBO( :,12, 4) = (/&
 & 1.3346E-01_JPRB,1.3660E-01_JPRB,1.3975E-01_JPRB,1.4344E-01_JPRB,1.4792E-01_JPRB/)  
KBO( :,13, 4) = (/&
 & 1.0849E-01_JPRB,1.1069E-01_JPRB,1.1290E-01_JPRB,1.1556E-01_JPRB,1.1871E-01_JPRB/)  
KBO( :,14, 4) = (/&
 & 8.2500E-02_JPRB,8.3981E-02_JPRB,8.5345E-02_JPRB,8.6853E-02_JPRB,8.8365E-02_JPRB/)  
KBO( :,15, 4) = (/&
 & 6.3556E-02_JPRB,6.4528E-02_JPRB,6.5387E-02_JPRB,6.6084E-02_JPRB,6.6650E-02_JPRB/)  
KBO( :,16, 4) = (/&
 & 5.0617E-02_JPRB,5.1215E-02_JPRB,5.1695E-02_JPRB,5.1994E-02_JPRB,5.2195E-02_JPRB/)  
KBO( :,17, 4) = (/&
 & 4.0691E-02_JPRB,4.1021E-02_JPRB,4.1248E-02_JPRB,4.1327E-02_JPRB,4.1343E-02_JPRB/)  
KBO( :,18, 4) = (/&
 & 3.2954E-02_JPRB,3.3129E-02_JPRB,3.3217E-02_JPRB,3.3185E-02_JPRB,3.3108E-02_JPRB/)  
KBO( :,19, 4) = (/&
 & 2.6680E-02_JPRB,2.6760E-02_JPRB,2.6758E-02_JPRB,2.6667E-02_JPRB,2.6543E-02_JPRB/)  
KBO( :,20, 4) = (/&
 & 2.1769E-02_JPRB,2.1800E-02_JPRB,2.1748E-02_JPRB,2.1639E-02_JPRB,2.1512E-02_JPRB/)  
KBO( :,21, 4) = (/&
 & 1.7784E-02_JPRB,1.7780E-02_JPRB,1.7709E-02_JPRB,1.7602E-02_JPRB,1.7488E-02_JPRB/)  
KBO( :,22, 4) = (/&
 & 1.4514E-02_JPRB,1.4488E-02_JPRB,1.4415E-02_JPRB,1.4319E-02_JPRB,1.4220E-02_JPRB/)  
KBO( :,23, 4) = (/&
 & 1.1835E-02_JPRB,1.1797E-02_JPRB,1.1728E-02_JPRB,1.1643E-02_JPRB,1.1560E-02_JPRB/)  
KBO( :,24, 4) = (/&
 & 9.6235E-03_JPRB,9.5815E-03_JPRB,9.5190E-03_JPRB,9.4465E-03_JPRB,9.3693E-03_JPRB/)  
KBO( :,25, 4) = (/&
 & 7.8292E-03_JPRB,7.7888E-03_JPRB,7.7341E-03_JPRB,7.6730E-03_JPRB,7.6029E-03_JPRB/)  
KBO( :,26, 4) = (/&
 & 6.3801E-03_JPRB,6.3415E-03_JPRB,6.2961E-03_JPRB,6.2428E-03_JPRB,6.1825E-03_JPRB/)  
KBO( :,27, 4) = (/&
 & 5.2042E-03_JPRB,5.1715E-03_JPRB,5.1336E-03_JPRB,5.0880E-03_JPRB,5.0387E-03_JPRB/)  
KBO( :,28, 4) = (/&
 & 4.2465E-03_JPRB,4.2207E-03_JPRB,4.1880E-03_JPRB,4.1504E-03_JPRB,4.1110E-03_JPRB/)  
KBO( :,29, 4) = (/&
 & 3.4782E-03_JPRB,3.4577E-03_JPRB,3.4306E-03_JPRB,3.4016E-03_JPRB,3.3709E-03_JPRB/)  
KBO( :,30, 4) = (/&
 & 2.8515E-03_JPRB,2.8346E-03_JPRB,2.8137E-03_JPRB,2.7917E-03_JPRB,2.7680E-03_JPRB/)  
KBO( :,31, 4) = (/&
 & 2.3437E-03_JPRB,2.3307E-03_JPRB,2.3161E-03_JPRB,2.3002E-03_JPRB,2.2834E-03_JPRB/)  
KBO( :,32, 4) = (/&
 & 1.9274E-03_JPRB,1.9187E-03_JPRB,1.9091E-03_JPRB,1.8985E-03_JPRB,1.8866E-03_JPRB/)  
KBO( :,33, 4) = (/&
 & 1.5869E-03_JPRB,1.5820E-03_JPRB,1.5765E-03_JPRB,1.5699E-03_JPRB,1.5624E-03_JPRB/)  
KBO( :,34, 4) = (/&
 & 1.3081E-03_JPRB,1.3058E-03_JPRB,1.3032E-03_JPRB,1.2991E-03_JPRB,1.2950E-03_JPRB/)  
KBO( :,35, 4) = (/&
 & 1.0781E-03_JPRB,1.0778E-03_JPRB,1.0771E-03_JPRB,1.0756E-03_JPRB,1.0740E-03_JPRB/)  
KBO( :,36, 4) = (/&
 & 8.8736E-04_JPRB,8.8844E-04_JPRB,8.8926E-04_JPRB,8.8965E-04_JPRB,8.8976E-04_JPRB/)  
KBO( :,37, 4) = (/&
 & 7.3290E-04_JPRB,7.3491E-04_JPRB,7.3643E-04_JPRB,7.3770E-04_JPRB,7.3879E-04_JPRB/)  
KBO( :,38, 4) = (/&
 & 6.0588E-04_JPRB,6.0833E-04_JPRB,6.1041E-04_JPRB,6.1235E-04_JPRB,6.1424E-04_JPRB/)  
KBO( :,39, 4) = (/&
 & 5.0124E-04_JPRB,5.0398E-04_JPRB,5.0659E-04_JPRB,5.0907E-04_JPRB,5.1177E-04_JPRB/)  
KBO( :,40, 4) = (/&
 & 4.1327E-04_JPRB,4.1591E-04_JPRB,4.1851E-04_JPRB,4.2084E-04_JPRB,4.2376E-04_JPRB/)  
KBO( :,41, 4) = (/&
 & 3.4050E-04_JPRB,3.4298E-04_JPRB,3.4548E-04_JPRB,3.4778E-04_JPRB,3.5064E-04_JPRB/)  
KBO( :,42, 4) = (/&
 & 2.8050E-04_JPRB,2.8288E-04_JPRB,2.8524E-04_JPRB,2.8747E-04_JPRB,2.9020E-04_JPRB/)  
KBO( :,43, 4) = (/&
 & 2.3103E-04_JPRB,2.3322E-04_JPRB,2.3547E-04_JPRB,2.3763E-04_JPRB,2.4024E-04_JPRB/)  
KBO( :,44, 4) = (/&
 & 1.9026E-04_JPRB,1.9231E-04_JPRB,1.9444E-04_JPRB,1.9652E-04_JPRB,1.9896E-04_JPRB/)  
KBO( :,45, 4) = (/&
 & 1.5671E-04_JPRB,1.5864E-04_JPRB,1.6066E-04_JPRB,1.6263E-04_JPRB,1.6494E-04_JPRB/)  
KBO( :,46, 4) = (/&
 & 1.2898E-04_JPRB,1.3080E-04_JPRB,1.3267E-04_JPRB,1.3454E-04_JPRB,1.3671E-04_JPRB/)  
KBO( :,47, 4) = (/&
 & 1.0596E-04_JPRB,1.0765E-04_JPRB,1.0934E-04_JPRB,1.1109E-04_JPRB,1.1307E-04_JPRB/)  
KBO( :,48, 4) = (/&
 & 8.7064E-05_JPRB,8.8650E-05_JPRB,9.0201E-05_JPRB,9.1849E-05_JPRB,9.3694E-05_JPRB/)  
KBO( :,49, 4) = (/&
 & 7.1599E-05_JPRB,7.3089E-05_JPRB,7.4546E-05_JPRB,7.6099E-05_JPRB,7.7859E-05_JPRB/)  
KBO( :,50, 4) = (/&
 & 5.8725E-05_JPRB,6.0074E-05_JPRB,6.1380E-05_JPRB,6.2781E-05_JPRB,6.4369E-05_JPRB/)  
KBO( :,51, 4) = (/&
 & 4.8093E-05_JPRB,4.9292E-05_JPRB,5.0434E-05_JPRB,5.1667E-05_JPRB,5.3063E-05_JPRB/)  
KBO( :,52, 4) = (/&
 & 3.9408E-05_JPRB,4.0473E-05_JPRB,4.1481E-05_JPRB,4.2577E-05_JPRB,4.3826E-05_JPRB/)  
KBO( :,53, 4) = (/&
 & 3.2348E-05_JPRB,3.3281E-05_JPRB,3.4179E-05_JPRB,3.5167E-05_JPRB,3.6311E-05_JPRB/)  
KBO( :,54, 4) = (/&
 & 2.6357E-05_JPRB,2.7153E-05_JPRB,2.7906E-05_JPRB,2.8713E-05_JPRB,2.9648E-05_JPRB/)  
KBO( :,55, 4) = (/&
 & 2.1368E-05_JPRB,2.2046E-05_JPRB,2.2660E-05_JPRB,2.3285E-05_JPRB,2.4007E-05_JPRB/)  
KBO( :,56, 4) = (/&
 & 1.7314E-05_JPRB,1.7894E-05_JPRB,1.8399E-05_JPRB,1.8894E-05_JPRB,1.9452E-05_JPRB/)  
KBO( :,57, 4) = (/&
 & 1.4020E-05_JPRB,1.4518E-05_JPRB,1.4939E-05_JPRB,1.5339E-05_JPRB,1.5769E-05_JPRB/)  
KBO( :,58, 4) = (/&
 & 1.1336E-05_JPRB,1.1762E-05_JPRB,1.2115E-05_JPRB,1.2440E-05_JPRB,1.2770E-05_JPRB/)  
KBO( :,59, 4) = (/&
 & 9.1282E-06_JPRB,9.4754E-06_JPRB,9.7573E-06_JPRB,1.0004E-05_JPRB,1.0238E-05_JPRB/)  
KBO( :, 7, 5) = (/&
 & 7.4219E-01_JPRB,8.0054E-01_JPRB,8.7888E-01_JPRB,9.7526E-01_JPRB,1.0998E+00_JPRB/)  
KBO( :, 8, 5) = (/&
 & 5.1152E-01_JPRB,5.4637E-01_JPRB,5.8683E-01_JPRB,6.3535E-01_JPRB,6.9455E-01_JPRB/)  
KBO( :, 9, 5) = (/&
 & 3.8181E-01_JPRB,4.0155E-01_JPRB,4.2314E-01_JPRB,4.4831E-01_JPRB,4.7715E-01_JPRB/)  
KBO( :,10, 5) = (/&
 & 2.9695E-01_JPRB,3.0876E-01_JPRB,3.2196E-01_JPRB,3.3553E-01_JPRB,3.5132E-01_JPRB/)  
KBO( :,11, 5) = (/&
 & 2.4682E-01_JPRB,2.5515E-01_JPRB,2.6470E-01_JPRB,2.7449E-01_JPRB,2.8523E-01_JPRB/)  
KBO( :,12, 5) = (/&
 & 2.1183E-01_JPRB,2.1854E-01_JPRB,2.2616E-01_JPRB,2.3413E-01_JPRB,2.4235E-01_JPRB/)  
KBO( :,13, 5) = (/&
 & 1.7800E-01_JPRB,1.8340E-01_JPRB,1.8940E-01_JPRB,1.9532E-01_JPRB,2.0154E-01_JPRB/)  
KBO( :,14, 5) = (/&
 & 1.4147E-01_JPRB,1.4449E-01_JPRB,1.4788E-01_JPRB,1.5168E-01_JPRB,1.5576E-01_JPRB/)  
KBO( :,15, 5) = (/&
 & 1.1315E-01_JPRB,1.1469E-01_JPRB,1.1645E-01_JPRB,1.1868E-01_JPRB,1.2103E-01_JPRB/)  
KBO( :,16, 5) = (/&
 & 9.2222E-02_JPRB,9.3160E-02_JPRB,9.4211E-02_JPRB,9.5476E-02_JPRB,9.6729E-02_JPRB/)  
KBO( :,17, 5) = (/&
 & 7.5459E-02_JPRB,7.6041E-02_JPRB,7.6622E-02_JPRB,7.7254E-02_JPRB,7.7877E-02_JPRB/)  
KBO( :,18, 5) = (/&
 & 6.1947E-02_JPRB,6.2293E-02_JPRB,6.2553E-02_JPRB,6.2869E-02_JPRB,6.3141E-02_JPRB/)  
KBO( :,19, 5) = (/&
 & 5.0722E-02_JPRB,5.0858E-02_JPRB,5.0935E-02_JPRB,5.1055E-02_JPRB,5.1101E-02_JPRB/)  
KBO( :,20, 5) = (/&
 & 4.1631E-02_JPRB,4.1679E-02_JPRB,4.1718E-02_JPRB,4.1739E-02_JPRB,4.1680E-02_JPRB/)  
KBO( :,21, 5) = (/&
 & 3.4144E-02_JPRB,3.4173E-02_JPRB,3.4180E-02_JPRB,3.4129E-02_JPRB,3.4026E-02_JPRB/)  
KBO( :,22, 5) = (/&
 & 2.7969E-02_JPRB,2.7982E-02_JPRB,2.7950E-02_JPRB,2.7863E-02_JPRB,2.7745E-02_JPRB/)  
KBO( :,23, 5) = (/&
 & 2.2887E-02_JPRB,2.2876E-02_JPRB,2.2812E-02_JPRB,2.2713E-02_JPRB,2.2601E-02_JPRB/)  
KBO( :,24, 5) = (/&
 & 1.8663E-02_JPRB,1.8630E-02_JPRB,1.8556E-02_JPRB,1.8459E-02_JPRB,1.8357E-02_JPRB/)  
KBO( :,25, 5) = (/&
 & 1.5218E-02_JPRB,1.5169E-02_JPRB,1.5100E-02_JPRB,1.5012E-02_JPRB,1.4924E-02_JPRB/)  
KBO( :,26, 5) = (/&
 & 1.2420E-02_JPRB,1.2369E-02_JPRB,1.2302E-02_JPRB,1.2232E-02_JPRB,1.2157E-02_JPRB/)  
KBO( :,27, 5) = (/&
 & 1.0146E-02_JPRB,1.0098E-02_JPRB,1.0044E-02_JPRB,9.9898E-03_JPRB,9.9236E-03_JPRB/)  
KBO( :,28, 5) = (/&
 & 8.2897E-03_JPRB,8.2510E-03_JPRB,8.2117E-03_JPRB,8.1680E-03_JPRB,8.1099E-03_JPRB/)  
KBO( :,29, 5) = (/&
 & 6.7978E-03_JPRB,6.7739E-03_JPRB,6.7481E-03_JPRB,6.7134E-03_JPRB,6.6680E-03_JPRB/)  
KBO( :,30, 5) = (/&
 & 5.5823E-03_JPRB,5.5718E-03_JPRB,5.5546E-03_JPRB,5.5280E-03_JPRB,5.4974E-03_JPRB/)  
KBO( :,31, 5) = (/&
 & 4.6027E-03_JPRB,4.6001E-03_JPRB,4.5893E-03_JPRB,4.5737E-03_JPRB,4.5580E-03_JPRB/)  
KBO( :,32, 5) = (/&
 & 3.8008E-03_JPRB,3.8015E-03_JPRB,3.7970E-03_JPRB,3.7914E-03_JPRB,3.7855E-03_JPRB/)  
KBO( :,33, 5) = (/&
 & 3.1425E-03_JPRB,3.1461E-03_JPRB,3.1482E-03_JPRB,3.1501E-03_JPRB,3.1526E-03_JPRB/)  
KBO( :,34, 5) = (/&
 & 2.5984E-03_JPRB,2.6053E-03_JPRB,2.6119E-03_JPRB,2.6195E-03_JPRB,2.6274E-03_JPRB/)  
KBO( :,35, 5) = (/&
 & 2.1483E-03_JPRB,2.1578E-03_JPRB,2.1676E-03_JPRB,2.1783E-03_JPRB,2.1903E-03_JPRB/)  
KBO( :,36, 5) = (/&
 & 1.7735E-03_JPRB,1.7841E-03_JPRB,1.7952E-03_JPRB,1.8076E-03_JPRB,1.8217E-03_JPRB/)  
KBO( :,37, 5) = (/&
 & 1.4673E-03_JPRB,1.4785E-03_JPRB,1.4908E-03_JPRB,1.5046E-03_JPRB,1.5197E-03_JPRB/)  
KBO( :,38, 5) = (/&
 & 1.2151E-03_JPRB,1.2270E-03_JPRB,1.2402E-03_JPRB,1.2548E-03_JPRB,1.2701E-03_JPRB/)  
KBO( :,39, 5) = (/&
 & 1.0074E-03_JPRB,1.0199E-03_JPRB,1.0337E-03_JPRB,1.0486E-03_JPRB,1.0638E-03_JPRB/)  
KBO( :,40, 5) = (/&
 & 8.3151E-04_JPRB,8.4359E-04_JPRB,8.5658E-04_JPRB,8.6983E-04_JPRB,8.8391E-04_JPRB/)  
KBO( :,41, 5) = (/&
 & 6.8588E-04_JPRB,6.9711E-04_JPRB,7.0893E-04_JPRB,7.2091E-04_JPRB,7.3364E-04_JPRB/)  
KBO( :,42, 5) = (/&
 & 5.6575E-04_JPRB,5.7610E-04_JPRB,5.8675E-04_JPRB,5.9741E-04_JPRB,6.0890E-04_JPRB/)  
KBO( :,43, 5) = (/&
 & 4.6640E-04_JPRB,4.7576E-04_JPRB,4.8530E-04_JPRB,4.9486E-04_JPRB,5.0526E-04_JPRB/)  
KBO( :,44, 5) = (/&
 & 3.8435E-04_JPRB,3.9291E-04_JPRB,4.0148E-04_JPRB,4.1002E-04_JPRB,4.1936E-04_JPRB/)  
KBO( :,45, 5) = (/&
 & 3.1688E-04_JPRB,3.2462E-04_JPRB,3.3225E-04_JPRB,3.3993E-04_JPRB,3.4837E-04_JPRB/)  
KBO( :,46, 5) = (/&
 & 2.6099E-04_JPRB,2.6793E-04_JPRB,2.7469E-04_JPRB,2.8156E-04_JPRB,2.8910E-04_JPRB/)  
KBO( :,47, 5) = (/&
 & 2.1440E-04_JPRB,2.2049E-04_JPRB,2.2645E-04_JPRB,2.3254E-04_JPRB,2.3931E-04_JPRB/)  
KBO( :,48, 5) = (/&
 & 1.7619E-04_JPRB,1.8156E-04_JPRB,1.8686E-04_JPRB,1.9234E-04_JPRB,1.9841E-04_JPRB/)  
KBO( :,49, 5) = (/&
 & 1.4500E-04_JPRB,1.4973E-04_JPRB,1.5449E-04_JPRB,1.5941E-04_JPRB,1.6496E-04_JPRB/)  
KBO( :,50, 5) = (/&
 & 1.1899E-04_JPRB,1.2306E-04_JPRB,1.2720E-04_JPRB,1.3150E-04_JPRB,1.3635E-04_JPRB/)  
KBO( :,51, 5) = (/&
 & 9.7485E-05_JPRB,1.0095E-04_JPRB,1.0448E-04_JPRB,1.0819E-04_JPRB,1.1236E-04_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB8:PART3',1,ZHOOK_HANDLE)
END SUBROUTINE PART3


SUBROUTINE PART4

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB8:PART4',0,ZHOOK_HANDLE)


KBO( :,52, 5) = (/&
 & 7.9898E-05_JPRB,8.2877E-05_JPRB,8.5912E-05_JPRB,8.9120E-05_JPRB,9.2744E-05_JPRB/)  
KBO( :,53, 5) = (/&
 & 6.5564E-05_JPRB,6.8161E-05_JPRB,7.0774E-05_JPRB,7.3596E-05_JPRB,7.6784E-05_JPRB/)  
KBO( :,54, 5) = (/&
 & 5.3382E-05_JPRB,5.5562E-05_JPRB,5.7697E-05_JPRB,6.0028E-05_JPRB,6.2619E-05_JPRB/)  
KBO( :,55, 5) = (/&
 & 4.3245E-05_JPRB,4.5036E-05_JPRB,4.6756E-05_JPRB,4.8597E-05_JPRB,5.0630E-05_JPRB/)  
KBO( :,56, 5) = (/&
 & 3.5030E-05_JPRB,3.6502E-05_JPRB,3.7905E-05_JPRB,3.9364E-05_JPRB,4.0960E-05_JPRB/)  
KBO( :,57, 5) = (/&
 & 2.8365E-05_JPRB,2.9581E-05_JPRB,3.0734E-05_JPRB,3.1886E-05_JPRB,3.3151E-05_JPRB/)  
KBO( :,58, 5) = (/&
 & 2.2943E-05_JPRB,2.3945E-05_JPRB,2.4891E-05_JPRB,2.5800E-05_JPRB,2.6793E-05_JPRB/)  
KBO( :,59, 5) = (/&
 & 1.8495E-05_JPRB,1.9293E-05_JPRB,2.0030E-05_JPRB,2.0717E-05_JPRB,2.1421E-05_JPRB/)  
KBO( :, 7, 6) = (/&
 & 1.0291E+00_JPRB,1.1356E+00_JPRB,1.2744E+00_JPRB,1.4468E+00_JPRB,1.6524E+00_JPRB/)  
KBO( :, 8, 6) = (/&
 & 6.9841E-01_JPRB,7.5208E-01_JPRB,8.2057E-01_JPRB,9.0373E-01_JPRB,9.9840E-01_JPRB/)  
KBO( :, 9, 6) = (/&
 & 5.3286E-01_JPRB,5.5966E-01_JPRB,5.9440E-01_JPRB,6.3558E-01_JPRB,6.8341E-01_JPRB/)  
KBO( :,10, 6) = (/&
 & 4.3919E-01_JPRB,4.5202E-01_JPRB,4.6857E-01_JPRB,4.9162E-01_JPRB,5.1919E-01_JPRB/)  
KBO( :,11, 6) = (/&
 & 3.8169E-01_JPRB,3.9111E-01_JPRB,4.0234E-01_JPRB,4.1718E-01_JPRB,4.3612E-01_JPRB/)  
KBO( :,12, 6) = (/&
 & 3.4191E-01_JPRB,3.5009E-01_JPRB,3.5940E-01_JPRB,3.7082E-01_JPRB,3.8567E-01_JPRB/)  
KBO( :,13, 6) = (/&
 & 3.0165E-01_JPRB,3.0862E-01_JPRB,3.1605E-01_JPRB,3.2574E-01_JPRB,3.3792E-01_JPRB/)  
KBO( :,14, 6) = (/&
 & 2.5298E-01_JPRB,2.5814E-01_JPRB,2.6338E-01_JPRB,2.6931E-01_JPRB,2.7664E-01_JPRB/)  
KBO( :,15, 6) = (/&
 & 2.1273E-01_JPRB,2.1655E-01_JPRB,2.1994E-01_JPRB,2.2320E-01_JPRB,2.2726E-01_JPRB/)  
KBO( :,16, 6) = (/&
 & 1.8046E-01_JPRB,1.8315E-01_JPRB,1.8531E-01_JPRB,1.8743E-01_JPRB,1.8993E-01_JPRB/)  
KBO( :,17, 6) = (/&
 & 1.5223E-01_JPRB,1.5398E-01_JPRB,1.5534E-01_JPRB,1.5661E-01_JPRB,1.5779E-01_JPRB/)  
KBO( :,18, 6) = (/&
 & 1.2778E-01_JPRB,1.2889E-01_JPRB,1.2966E-01_JPRB,1.3020E-01_JPRB,1.3052E-01_JPRB/)  
KBO( :,19, 6) = (/&
 & 1.0640E-01_JPRB,1.0703E-01_JPRB,1.0732E-01_JPRB,1.0728E-01_JPRB,1.0716E-01_JPRB/)  
KBO( :,20, 6) = (/&
 & 8.8470E-02_JPRB,8.8754E-02_JPRB,8.8701E-02_JPRB,8.8488E-02_JPRB,8.8284E-02_JPRB/)  
KBO( :,21, 6) = (/&
 & 7.3231E-02_JPRB,7.3261E-02_JPRB,7.3087E-02_JPRB,7.2888E-02_JPRB,7.2674E-02_JPRB/)  
KBO( :,22, 6) = (/&
 & 6.0317E-02_JPRB,6.0219E-02_JPRB,6.0056E-02_JPRB,5.9896E-02_JPRB,5.9688E-02_JPRB/)  
KBO( :,23, 6) = (/&
 & 4.9481E-02_JPRB,4.9377E-02_JPRB,4.9249E-02_JPRB,4.9098E-02_JPRB,4.8909E-02_JPRB/)  
KBO( :,24, 6) = (/&
 & 4.0434E-02_JPRB,4.0336E-02_JPRB,4.0225E-02_JPRB,4.0073E-02_JPRB,3.9896E-02_JPRB/)  
KBO( :,25, 6) = (/&
 & 3.3025E-02_JPRB,3.2945E-02_JPRB,3.2829E-02_JPRB,3.2695E-02_JPRB,3.2543E-02_JPRB/)  
KBO( :,26, 6) = (/&
 & 2.6990E-02_JPRB,2.6922E-02_JPRB,2.6821E-02_JPRB,2.6706E-02_JPRB,2.6588E-02_JPRB/)  
KBO( :,27, 6) = (/&
 & 2.2079E-02_JPRB,2.2020E-02_JPRB,2.1942E-02_JPRB,2.1852E-02_JPRB,2.1768E-02_JPRB/)  
KBO( :,28, 6) = (/&
 & 1.8069E-02_JPRB,1.8022E-02_JPRB,1.7962E-02_JPRB,1.7900E-02_JPRB,1.7838E-02_JPRB/)  
KBO( :,29, 6) = (/&
 & 1.4852E-02_JPRB,1.4820E-02_JPRB,1.4781E-02_JPRB,1.4749E-02_JPRB,1.4702E-02_JPRB/)  
KBO( :,30, 6) = (/&
 & 1.2224E-02_JPRB,1.2208E-02_JPRB,1.2195E-02_JPRB,1.2181E-02_JPRB,1.2148E-02_JPRB/)  
KBO( :,31, 6) = (/&
 & 1.0105E-02_JPRB,1.0111E-02_JPRB,1.0120E-02_JPRB,1.0118E-02_JPRB,1.0103E-02_JPRB/)  
KBO( :,32, 6) = (/&
 & 8.3725E-03_JPRB,8.4005E-03_JPRB,8.4201E-03_JPRB,8.4294E-03_JPRB,8.4380E-03_JPRB/)  
KBO( :,33, 6) = (/&
 & 6.9608E-03_JPRB,6.9985E-03_JPRB,7.0246E-03_JPRB,7.0506E-03_JPRB,7.0801E-03_JPRB/)  
KBO( :,34, 6) = (/&
 & 5.7896E-03_JPRB,5.8293E-03_JPRB,5.8636E-03_JPRB,5.9033E-03_JPRB,5.9423E-03_JPRB/)  
KBO( :,35, 6) = (/&
 & 4.8109E-03_JPRB,4.8516E-03_JPRB,4.8942E-03_JPRB,4.9402E-03_JPRB,4.9858E-03_JPRB/)  
KBO( :,36, 6) = (/&
 & 3.9871E-03_JPRB,4.0286E-03_JPRB,4.0750E-03_JPRB,4.1227E-03_JPRB,4.1698E-03_JPRB/)  
KBO( :,37, 6) = (/&
 & 3.3096E-03_JPRB,3.3515E-03_JPRB,3.3976E-03_JPRB,3.4442E-03_JPRB,3.4909E-03_JPRB/)  
KBO( :,38, 6) = (/&
 & 2.7496E-03_JPRB,2.7916E-03_JPRB,2.8359E-03_JPRB,2.8815E-03_JPRB,2.9281E-03_JPRB/)  
KBO( :,39, 6) = (/&
 & 2.2877E-03_JPRB,2.3291E-03_JPRB,2.3716E-03_JPRB,2.4163E-03_JPRB,2.4637E-03_JPRB/)  
KBO( :,40, 6) = (/&
 & 1.8936E-03_JPRB,1.9309E-03_JPRB,1.9696E-03_JPRB,2.0107E-03_JPRB,2.0549E-03_JPRB/)  
KBO( :,41, 6) = (/&
 & 1.5662E-03_JPRB,1.5994E-03_JPRB,1.6345E-03_JPRB,1.6724E-03_JPRB,1.7133E-03_JPRB/)  
KBO( :,42, 6) = (/&
 & 1.2955E-03_JPRB,1.3254E-03_JPRB,1.3573E-03_JPRB,1.3919E-03_JPRB,1.4291E-03_JPRB/)  
KBO( :,43, 6) = (/&
 & 1.0710E-03_JPRB,1.0978E-03_JPRB,1.1266E-03_JPRB,1.1585E-03_JPRB,1.1927E-03_JPRB/)  
KBO( :,44, 6) = (/&
 & 8.8505E-04_JPRB,9.0944E-04_JPRB,9.3598E-04_JPRB,9.6529E-04_JPRB,9.9625E-04_JPRB/)  
KBO( :,45, 6) = (/&
 & 7.3173E-04_JPRB,7.5385E-04_JPRB,7.7814E-04_JPRB,8.0503E-04_JPRB,8.3318E-04_JPRB/)  
KBO( :,46, 6) = (/&
 & 6.0428E-04_JPRB,6.2394E-04_JPRB,6.4629E-04_JPRB,6.7060E-04_JPRB,6.9612E-04_JPRB/)  
KBO( :,47, 6) = (/&
 & 4.9743E-04_JPRB,5.1490E-04_JPRB,5.3489E-04_JPRB,5.5664E-04_JPRB,5.7933E-04_JPRB/)  
KBO( :,48, 6) = (/&
 & 4.0957E-04_JPRB,4.2541E-04_JPRB,4.4342E-04_JPRB,4.6291E-04_JPRB,4.8300E-04_JPRB/)  
KBO( :,49, 6) = (/&
 & 3.3774E-04_JPRB,3.5226E-04_JPRB,3.6850E-04_JPRB,3.8591E-04_JPRB,4.0393E-04_JPRB/)  
KBO( :,50, 6) = (/&
 & 2.7754E-04_JPRB,2.9045E-04_JPRB,3.0466E-04_JPRB,3.1969E-04_JPRB,3.3544E-04_JPRB/)  
KBO( :,51, 6) = (/&
 & 2.2753E-04_JPRB,2.3884E-04_JPRB,2.5106E-04_JPRB,2.6388E-04_JPRB,2.7745E-04_JPRB/)  
KBO( :,52, 6) = (/&
 & 1.8669E-04_JPRB,1.9654E-04_JPRB,2.0712E-04_JPRB,2.1810E-04_JPRB,2.2988E-04_JPRB/)  
KBO( :,53, 6) = (/&
 & 1.5338E-04_JPRB,1.6202E-04_JPRB,1.7120E-04_JPRB,1.8071E-04_JPRB,1.9105E-04_JPRB/)  
KBO( :,54, 6) = (/&
 & 1.2486E-04_JPRB,1.3205E-04_JPRB,1.3971E-04_JPRB,1.4755E-04_JPRB,1.5604E-04_JPRB/)  
KBO( :,55, 6) = (/&
 & 1.0106E-04_JPRB,1.0690E-04_JPRB,1.1311E-04_JPRB,1.1943E-04_JPRB,1.2616E-04_JPRB/)  
KBO( :,56, 6) = (/&
 & 8.1771E-05_JPRB,8.6502E-05_JPRB,9.1586E-05_JPRB,9.6653E-05_JPRB,1.0202E-04_JPRB/)  
KBO( :,57, 6) = (/&
 & 6.6144E-05_JPRB,6.9933E-05_JPRB,7.4136E-05_JPRB,7.8259E-05_JPRB,8.2530E-05_JPRB/)  
KBO( :,58, 6) = (/&
 & 5.3465E-05_JPRB,5.6462E-05_JPRB,5.9920E-05_JPRB,6.3267E-05_JPRB,6.6666E-05_JPRB/)  
KBO( :,59, 6) = (/&
 & 4.3125E-05_JPRB,4.5368E-05_JPRB,4.8072E-05_JPRB,5.0671E-05_JPRB,5.3226E-05_JPRB/)  
KBO( :, 7, 7) = (/&
 & 1.6077E+00_JPRB,1.7981E+00_JPRB,2.0341E+00_JPRB,2.3365E+00_JPRB,2.7141E+00_JPRB/)  
KBO( :, 8, 7) = (/&
 & 1.0311E+00_JPRB,1.1132E+00_JPRB,1.2137E+00_JPRB,1.3415E+00_JPRB,1.5087E+00_JPRB/)  
KBO( :, 9, 7) = (/&
 & 7.6937E-01_JPRB,8.0602E-01_JPRB,8.5228E-01_JPRB,9.1262E-01_JPRB,9.8815E-01_JPRB/)  
KBO( :,10, 7) = (/&
 & 6.4929E-01_JPRB,6.6760E-01_JPRB,6.9118E-01_JPRB,7.1882E-01_JPRB,7.5540E-01_JPRB/)  
KBO( :,11, 7) = (/&
 & 5.9378E-01_JPRB,6.0842E-01_JPRB,6.2583E-01_JPRB,6.4567E-01_JPRB,6.6995E-01_JPRB/)  
KBO( :,12, 7) = (/&
 & 5.6066E-01_JPRB,5.7335E-01_JPRB,5.8800E-01_JPRB,6.0558E-01_JPRB,6.2619E-01_JPRB/)  
KBO( :,13, 7) = (/&
 & 5.2201E-01_JPRB,5.3299E-01_JPRB,5.4556E-01_JPRB,5.5961E-01_JPRB,5.7566E-01_JPRB/)  
KBO( :,14, 7) = (/&
 & 4.6501E-01_JPRB,4.7434E-01_JPRB,4.8336E-01_JPRB,4.9210E-01_JPRB,5.0157E-01_JPRB/)  
KBO( :,15, 7) = (/&
 & 4.1255E-01_JPRB,4.2030E-01_JPRB,4.2720E-01_JPRB,4.3352E-01_JPRB,4.3993E-01_JPRB/)  
KBO( :,16, 7) = (/&
 & 3.6768E-01_JPRB,3.7401E-01_JPRB,3.7974E-01_JPRB,3.8485E-01_JPRB,3.8978E-01_JPRB/)  
KBO( :,17, 7) = (/&
 & 3.2496E-01_JPRB,3.3013E-01_JPRB,3.3469E-01_JPRB,3.3855E-01_JPRB,3.4245E-01_JPRB/)  
KBO( :,18, 7) = (/&
 & 2.8473E-01_JPRB,2.8863E-01_JPRB,2.9200E-01_JPRB,2.9483E-01_JPRB,2.9767E-01_JPRB/)  
KBO( :,19, 7) = (/&
 & 2.4598E-01_JPRB,2.4883E-01_JPRB,2.5108E-01_JPRB,2.5281E-01_JPRB,2.5427E-01_JPRB/)  
KBO( :,20, 7) = (/&
 & 2.1080E-01_JPRB,2.1273E-01_JPRB,2.1404E-01_JPRB,2.1479E-01_JPRB,2.1513E-01_JPRB/)  
KBO( :,21, 7) = (/&
 & 1.7884E-01_JPRB,1.8005E-01_JPRB,1.8057E-01_JPRB,1.8053E-01_JPRB,1.8015E-01_JPRB/)  
KBO( :,22, 7) = (/&
 & 1.5046E-01_JPRB,1.5096E-01_JPRB,1.5087E-01_JPRB,1.5039E-01_JPRB,1.4970E-01_JPRB/)  
KBO( :,23, 7) = (/&
 & 1.2553E-01_JPRB,1.2553E-01_JPRB,1.2506E-01_JPRB,1.2444E-01_JPRB,1.2374E-01_JPRB/)  
KBO( :,24, 7) = (/&
 & 1.0391E-01_JPRB,1.0358E-01_JPRB,1.0303E-01_JPRB,1.0238E-01_JPRB,1.0167E-01_JPRB/)  
KBO( :,25, 7) = (/&
 & 8.5584E-02_JPRB,8.5157E-02_JPRB,8.4645E-02_JPRB,8.4056E-02_JPRB,8.3409E-02_JPRB/)  
KBO( :,26, 7) = (/&
 & 7.0315E-02_JPRB,6.9930E-02_JPRB,6.9473E-02_JPRB,6.8949E-02_JPRB,6.8424E-02_JPRB/)  
KBO( :,27, 7) = (/&
 & 5.7710E-02_JPRB,5.7391E-02_JPRB,5.7008E-02_JPRB,5.6586E-02_JPRB,5.6210E-02_JPRB/)  
KBO( :,28, 7) = (/&
 & 4.7344E-02_JPRB,4.7085E-02_JPRB,4.6768E-02_JPRB,4.6467E-02_JPRB,4.6249E-02_JPRB/)  
KBO( :,29, 7) = (/&
 & 3.8923E-02_JPRB,3.8733E-02_JPRB,3.8524E-02_JPRB,3.8372E-02_JPRB,3.8309E-02_JPRB/)  
KBO( :,30, 7) = (/&
 & 3.2033E-02_JPRB,3.1913E-02_JPRB,3.1817E-02_JPRB,3.1789E-02_JPRB,3.1818E-02_JPRB/)  
KBO( :,31, 7) = (/&
 & 2.6460E-02_JPRB,2.6427E-02_JPRB,2.6436E-02_JPRB,2.6518E-02_JPRB,2.6590E-02_JPRB/)  
KBO( :,32, 7) = (/&
 & 2.1922E-02_JPRB,2.1964E-02_JPRB,2.2067E-02_JPRB,2.2187E-02_JPRB,2.2275E-02_JPRB/)  
KBO( :,33, 7) = (/&
 & 1.8236E-02_JPRB,1.8348E-02_JPRB,1.8498E-02_JPRB,1.8631E-02_JPRB,1.8753E-02_JPRB/)  
KBO( :,34, 7) = (/&
 & 1.5224E-02_JPRB,1.5383E-02_JPRB,1.5538E-02_JPRB,1.5679E-02_JPRB,1.5835E-02_JPRB/)  
KBO( :,35, 7) = (/&
 & 1.2735E-02_JPRB,1.2900E-02_JPRB,1.3051E-02_JPRB,1.3209E-02_JPRB,1.3385E-02_JPRB/)  
KBO( :,36, 7) = (/&
 & 1.0628E-02_JPRB,1.0788E-02_JPRB,1.0937E-02_JPRB,1.1102E-02_JPRB,1.1287E-02_JPRB/)  
KBO( :,37, 7) = (/&
 & 8.9166E-03_JPRB,9.0712E-03_JPRB,9.2215E-03_JPRB,9.3908E-03_JPRB,9.5808E-03_JPRB/)  
KBO( :,38, 7) = (/&
 & 7.4940E-03_JPRB,7.6454E-03_JPRB,7.7999E-03_JPRB,7.9731E-03_JPRB,8.1630E-03_JPRB/)  
KBO( :,39, 7) = (/&
 & 6.3066E-03_JPRB,6.4579E-03_JPRB,6.6165E-03_JPRB,6.7948E-03_JPRB,6.9866E-03_JPRB/)  
KBO( :,40, 7) = (/&
 & 5.2690E-03_JPRB,5.4111E-03_JPRB,5.5610E-03_JPRB,5.7292E-03_JPRB,5.9108E-03_JPRB/)  
KBO( :,41, 7) = (/&
 & 4.3956E-03_JPRB,4.5258E-03_JPRB,4.6643E-03_JPRB,4.8199E-03_JPRB,4.9873E-03_JPRB/)  
KBO( :,42, 7) = (/&
 & 3.6658E-03_JPRB,3.7854E-03_JPRB,3.9129E-03_JPRB,4.0544E-03_JPRB,4.2074E-03_JPRB/)  
KBO( :,43, 7) = (/&
 & 3.0541E-03_JPRB,3.1620E-03_JPRB,3.2785E-03_JPRB,3.4070E-03_JPRB,3.5478E-03_JPRB/)  
KBO( :,44, 7) = (/&
 & 2.5426E-03_JPRB,2.6415E-03_JPRB,2.7479E-03_JPRB,2.8645E-03_JPRB,2.9935E-03_JPRB/)  
KBO( :,45, 7) = (/&
 & 2.1195E-03_JPRB,2.2094E-03_JPRB,2.3059E-03_JPRB,2.4121E-03_JPRB,2.5314E-03_JPRB/)  
KBO( :,46, 7) = (/&
 & 1.7648E-03_JPRB,1.8463E-03_JPRB,1.9334E-03_JPRB,2.0302E-03_JPRB,2.1404E-03_JPRB/)  
KBO( :,47, 7) = (/&
 & 1.4634E-03_JPRB,1.5361E-03_JPRB,1.6140E-03_JPRB,1.7015E-03_JPRB,1.8026E-03_JPRB/)  
KBO( :,48, 7) = (/&
 & 1.2139E-03_JPRB,1.2801E-03_JPRB,1.3517E-03_JPRB,1.4311E-03_JPRB,1.5246E-03_JPRB/)  
KBO( :,49, 7) = (/&
 & 1.0084E-03_JPRB,1.0696E-03_JPRB,1.1358E-03_JPRB,1.2100E-03_JPRB,1.2983E-03_JPRB/)  
KBO( :,50, 7) = (/&
 & 8.3348E-04_JPRB,8.8778E-04_JPRB,9.4722E-04_JPRB,1.0145E-03_JPRB,1.0957E-03_JPRB/)  
KBO( :,51, 7) = (/&
 & 6.8674E-04_JPRB,7.3388E-04_JPRB,7.8672E-04_JPRB,8.4662E-04_JPRB,9.1942E-04_JPRB/)  
KBO( :,52, 7) = (/&
 & 5.6565E-04_JPRB,6.0707E-04_JPRB,6.5426E-04_JPRB,7.0839E-04_JPRB,7.7411E-04_JPRB/)  
KBO( :,53, 7) = (/&
 & 4.6652E-04_JPRB,5.0305E-04_JPRB,5.4564E-04_JPRB,5.9512E-04_JPRB,6.5514E-04_JPRB/)  
KBO( :,54, 7) = (/&
 & 3.8020E-04_JPRB,4.1066E-04_JPRB,4.4674E-04_JPRB,4.8863E-04_JPRB,5.3927E-04_JPRB/)  
KBO( :,55, 7) = (/&
 & 3.0778E-04_JPRB,3.3217E-04_JPRB,3.6157E-04_JPRB,3.9555E-04_JPRB,4.3630E-04_JPRB/)  
KBO( :,56, 7) = (/&
 & 2.4903E-04_JPRB,2.6857E-04_JPRB,2.9236E-04_JPRB,3.2037E-04_JPRB,3.5294E-04_JPRB/)  
KBO( :,57, 7) = (/&
 & 2.0141E-04_JPRB,2.1696E-04_JPRB,2.3614E-04_JPRB,2.5898E-04_JPRB,2.8543E-04_JPRB/)  
KBO( :,58, 7) = (/&
 & 1.6266E-04_JPRB,1.7505E-04_JPRB,1.9031E-04_JPRB,2.0880E-04_JPRB,2.2991E-04_JPRB/)  
KBO( :,59, 7) = (/&
 & 1.3098E-04_JPRB,1.4063E-04_JPRB,1.5198E-04_JPRB,1.6574E-04_JPRB,1.8129E-04_JPRB/)  
KBO( :, 7, 8) = (/&
 & 3.3211E+00_JPRB,3.8117E+00_JPRB,4.3961E+00_JPRB,5.0891E+00_JPRB,5.9185E+00_JPRB/)  
KBO( :, 8, 8) = (/&
 & 1.8613E+00_JPRB,2.0568E+00_JPRB,2.2883E+00_JPRB,2.5535E+00_JPRB,2.8756E+00_JPRB/)  
KBO( :, 9, 8) = (/&
 & 1.2496E+00_JPRB,1.3135E+00_JPRB,1.3903E+00_JPRB,1.4889E+00_JPRB,1.6200E+00_JPRB/)  
KBO( :,10, 8) = (/&
 & 1.0270E+00_JPRB,1.0590E+00_JPRB,1.0952E+00_JPRB,1.1413E+00_JPRB,1.1993E+00_JPRB/)  
KBO( :,11, 8) = (/&
 & 9.5413E-01_JPRB,9.8150E-01_JPRB,1.0111E+00_JPRB,1.0458E+00_JPRB,1.0870E+00_JPRB/)  
KBO( :,12, 8) = (/&
 & 9.3205E-01_JPRB,9.5733E-01_JPRB,9.8351E-01_JPRB,1.0122E+00_JPRB,1.0457E+00_JPRB/)  
KBO( :,13, 8) = (/&
 & 9.0876E-01_JPRB,9.3132E-01_JPRB,9.5428E-01_JPRB,9.7851E-01_JPRB,1.0060E+00_JPRB/)  
KBO( :,14, 8) = (/&
 & 8.5246E-01_JPRB,8.7119E-01_JPRB,8.8993E-01_JPRB,9.0965E-01_JPRB,9.3087E-01_JPRB/)  
KBO( :,15, 8) = (/&
 & 8.0357E-01_JPRB,8.1893E-01_JPRB,8.3481E-01_JPRB,8.5136E-01_JPRB,8.6824E-01_JPRB/)  
KBO( :,16, 8) = (/&
 & 7.6497E-01_JPRB,7.7909E-01_JPRB,7.9306E-01_JPRB,8.0699E-01_JPRB,8.2094E-01_JPRB/)  
KBO( :,17, 8) = (/&
 & 7.2426E-01_JPRB,7.3747E-01_JPRB,7.4973E-01_JPRB,7.6144E-01_JPRB,7.7249E-01_JPRB/)  
KBO( :,18, 8) = (/&
 & 6.8011E-01_JPRB,6.9229E-01_JPRB,7.0291E-01_JPRB,7.1244E-01_JPRB,7.2174E-01_JPRB/)  
KBO( :,19, 8) = (/&
 & 6.2929E-01_JPRB,6.4006E-01_JPRB,6.4901E-01_JPRB,6.5727E-01_JPRB,6.6513E-01_JPRB/)  
KBO( :,20, 8) = (/&
 & 5.7567E-01_JPRB,5.8515E-01_JPRB,5.9318E-01_JPRB,6.0058E-01_JPRB,6.0766E-01_JPRB/)  
KBO( :,21, 8) = (/&
 & 5.1892E-01_JPRB,5.2717E-01_JPRB,5.3431E-01_JPRB,5.4099E-01_JPRB,5.4743E-01_JPRB/)  
KBO( :,22, 8) = (/&
 & 4.6089E-01_JPRB,4.6796E-01_JPRB,4.7423E-01_JPRB,4.8007E-01_JPRB,4.8563E-01_JPRB/)  
KBO( :,23, 8) = (/&
 & 4.0358E-01_JPRB,4.0957E-01_JPRB,4.1496E-01_JPRB,4.1964E-01_JPRB,4.2400E-01_JPRB/)  
KBO( :,24, 8) = (/&
 & 3.4857E-01_JPRB,3.5354E-01_JPRB,3.5772E-01_JPRB,3.6116E-01_JPRB,3.6425E-01_JPRB/)  
KBO( :,25, 8) = (/&
 & 2.9819E-01_JPRB,3.0212E-01_JPRB,3.0511E-01_JPRB,3.0743E-01_JPRB,3.0973E-01_JPRB/)  
KBO( :,26, 8) = (/&
 & 2.5341E-01_JPRB,2.5614E-01_JPRB,2.5815E-01_JPRB,2.5994E-01_JPRB,2.6173E-01_JPRB/)  
KBO( :,27, 8) = (/&
 & 2.1391E-01_JPRB,2.1577E-01_JPRB,2.1730E-01_JPRB,2.1901E-01_JPRB,2.2050E-01_JPRB/)  
KBO( :,28, 8) = (/&
 & 1.7949E-01_JPRB,1.8088E-01_JPRB,1.8241E-01_JPRB,1.8396E-01_JPRB,1.8539E-01_JPRB/)  
KBO( :,29, 8) = (/&
 & 1.5049E-01_JPRB,1.5188E-01_JPRB,1.5349E-01_JPRB,1.5504E-01_JPRB,1.5657E-01_JPRB/)  
KBO( :,30, 8) = (/&
 & 1.2605E-01_JPRB,1.2767E-01_JPRB,1.2921E-01_JPRB,1.3083E-01_JPRB,1.3263E-01_JPRB/)  
KBO( :,31, 8) = (/&
 & 1.0607E-01_JPRB,1.0765E-01_JPRB,1.0930E-01_JPRB,1.1112E-01_JPRB,1.1342E-01_JPRB/)  
KBO( :,32, 8) = (/&
 & 8.9368E-02_JPRB,9.1008E-02_JPRB,9.2774E-02_JPRB,9.4981E-02_JPRB,9.7872E-02_JPRB/)  
KBO( :,33, 8) = (/&
 & 7.5524E-02_JPRB,7.7232E-02_JPRB,7.9299E-02_JPRB,8.2001E-02_JPRB,8.5510E-02_JPRB/)  
KBO( :,34, 8) = (/&
 & 6.3951E-02_JPRB,6.5799E-02_JPRB,6.8200E-02_JPRB,7.1324E-02_JPRB,7.5176E-02_JPRB/)  
KBO( :,35, 8) = (/&
 & 5.4154E-02_JPRB,5.6182E-02_JPRB,5.8823E-02_JPRB,6.2186E-02_JPRB,6.6087E-02_JPRB/)  
KBO( :,36, 8) = (/&
 & 4.5779E-02_JPRB,4.7854E-02_JPRB,5.0601E-02_JPRB,5.3968E-02_JPRB,5.7802E-02_JPRB/)  
KBO( :,37, 8) = (/&
 & 3.8721E-02_JPRB,4.0789E-02_JPRB,4.3532E-02_JPRB,4.6821E-02_JPRB,5.0588E-02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB8:PART4',1,ZHOOK_HANDLE)
END SUBROUTINE PART4


SUBROUTINE PART5

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB8:PART5',0,ZHOOK_HANDLE)


KBO( :,38, 8) = (/&
 & 3.2891E-02_JPRB,3.4951E-02_JPRB,3.7677E-02_JPRB,4.0901E-02_JPRB,4.4641E-02_JPRB/)  
KBO( :,39, 8) = (/&
 & 2.8118E-02_JPRB,3.0183E-02_JPRB,3.2884E-02_JPRB,3.6081E-02_JPRB,3.9837E-02_JPRB/)  
KBO( :,40, 8) = (/&
 & 2.3847E-02_JPRB,2.5787E-02_JPRB,2.8347E-02_JPRB,3.1459E-02_JPRB,3.5061E-02_JPRB/)  
KBO( :,41, 8) = (/&
 & 2.0268E-02_JPRB,2.2079E-02_JPRB,2.4495E-02_JPRB,2.7477E-02_JPRB,3.0979E-02_JPRB/)  
KBO( :,42, 8) = (/&
 & 1.7304E-02_JPRB,1.9004E-02_JPRB,2.1294E-02_JPRB,2.4161E-02_JPRB,2.7579E-02_JPRB/)  
KBO( :,43, 8) = (/&
 & 1.4797E-02_JPRB,1.6382E-02_JPRB,1.8537E-02_JPRB,2.1286E-02_JPRB,2.4610E-02_JPRB/)  
KBO( :,44, 8) = (/&
 & 1.2690E-02_JPRB,1.4182E-02_JPRB,1.6231E-02_JPRB,1.8878E-02_JPRB,2.2106E-02_JPRB/)  
KBO( :,45, 8) = (/&
 & 1.0930E-02_JPRB,1.2370E-02_JPRB,1.4353E-02_JPRB,1.6936E-02_JPRB,2.0100E-02_JPRB/)  
KBO( :,46, 8) = (/&
 & 9.3910E-03_JPRB,1.0819E-02_JPRB,1.2738E-02_JPRB,1.5273E-02_JPRB,1.8465E-02_JPRB/)  
KBO( :,47, 8) = (/&
 & 7.9861E-03_JPRB,9.3365E-03_JPRB,1.1203E-02_JPRB,1.3684E-02_JPRB,1.6817E-02_JPRB/)  
KBO( :,48, 8) = (/&
 & 6.8013E-03_JPRB,8.0839E-03_JPRB,9.9438E-03_JPRB,1.2411E-02_JPRB,1.5563E-02_JPRB/)  
KBO( :,49, 8) = (/&
 & 5.8190E-03_JPRB,7.0513E-03_JPRB,8.8856E-03_JPRB,1.1416E-02_JPRB,1.4708E-02_JPRB/)  
KBO( :,50, 8) = (/&
 & 4.9304E-03_JPRB,6.0739E-03_JPRB,7.8186E-03_JPRB,1.0316E-02_JPRB,1.3667E-02_JPRB/)  
KBO( :,51, 8) = (/&
 & 4.1610E-03_JPRB,5.1921E-03_JPRB,6.8130E-03_JPRB,9.2232E-03_JPRB,1.2553E-02_JPRB/)  
KBO( :,52, 8) = (/&
 & 3.5138E-03_JPRB,4.4587E-03_JPRB,5.9783E-03_JPRB,8.3075E-03_JPRB,1.1637E-02_JPRB/)  
KBO( :,53, 8) = (/&
 & 2.9769E-03_JPRB,3.8545E-03_JPRB,5.3084E-03_JPRB,7.5851E-03_JPRB,1.0949E-02_JPRB/)  
KBO( :,54, 8) = (/&
 & 2.4427E-03_JPRB,3.1932E-03_JPRB,4.4660E-03_JPRB,6.5058E-03_JPRB,9.6124E-03_JPRB/)  
KBO( :,55, 8) = (/&
 & 1.9622E-03_JPRB,2.5690E-03_JPRB,3.6206E-03_JPRB,5.3411E-03_JPRB,8.0479E-03_JPRB/)  
KBO( :,56, 8) = (/&
 & 1.5709E-03_JPRB,2.0592E-03_JPRB,2.9210E-03_JPRB,4.3945E-03_JPRB,6.6922E-03_JPRB/)  
KBO( :,57, 8) = (/&
 & 1.2535E-03_JPRB,1.6436E-03_JPRB,2.3438E-03_JPRB,3.5705E-03_JPRB,5.5260E-03_JPRB/)  
KBO( :,58, 8) = (/&
 & 9.9517E-04_JPRB,1.3029E-03_JPRB,1.8612E-03_JPRB,2.8649E-03_JPRB,4.4948E-03_JPRB/)  
KBO( :,59, 8) = (/&
 & 7.8554E-04_JPRB,1.0228E-03_JPRB,1.4402E-03_JPRB,2.2044E-03_JPRB,3.4577E-03_JPRB/)  
KBO( :, 7, 9) = (/&
 & 8.6167E+00_JPRB,9.9993E+00_JPRB,1.1774E+01_JPRB,1.3928E+01_JPRB,1.6806E+01_JPRB/)  
KBO( :, 8, 9) = (/&
 & 4.6456E+00_JPRB,5.1596E+00_JPRB,5.8731E+00_JPRB,6.7813E+00_JPRB,7.8273E+00_JPRB/)  
KBO( :, 9, 9) = (/&
 & 2.8817E+00_JPRB,2.9866E+00_JPRB,3.1829E+00_JPRB,3.4539E+00_JPRB,3.7883E+00_JPRB/)  
KBO( :,10, 9) = (/&
 & 2.1848E+00_JPRB,2.2145E+00_JPRB,2.2894E+00_JPRB,2.3929E+00_JPRB,2.5188E+00_JPRB/)  
KBO( :,11, 9) = (/&
 & 1.8617E+00_JPRB,1.8904E+00_JPRB,1.9482E+00_JPRB,2.0265E+00_JPRB,2.1151E+00_JPRB/)  
KBO( :,12, 9) = (/&
 & 1.7740E+00_JPRB,1.8058E+00_JPRB,1.8594E+00_JPRB,1.9279E+00_JPRB,2.0057E+00_JPRB/)  
KBO( :,13, 9) = (/&
 & 1.7170E+00_JPRB,1.7519E+00_JPRB,1.8033E+00_JPRB,1.8660E+00_JPRB,1.9366E+00_JPRB/)  
KBO( :,14, 9) = (/&
 & 1.6290E+00_JPRB,1.6661E+00_JPRB,1.7138E+00_JPRB,1.7672E+00_JPRB,1.8242E+00_JPRB/)  
KBO( :,15, 9) = (/&
 & 1.6136E+00_JPRB,1.6519E+00_JPRB,1.6950E+00_JPRB,1.7410E+00_JPRB,1.7875E+00_JPRB/)  
KBO( :,16, 9) = (/&
 & 1.6442E+00_JPRB,1.6834E+00_JPRB,1.7244E+00_JPRB,1.7672E+00_JPRB,1.8100E+00_JPRB/)  
KBO( :,17, 9) = (/&
 & 1.6931E+00_JPRB,1.7318E+00_JPRB,1.7716E+00_JPRB,1.8124E+00_JPRB,1.8535E+00_JPRB/)  
KBO( :,18, 9) = (/&
 & 1.7458E+00_JPRB,1.7837E+00_JPRB,1.8217E+00_JPRB,1.8608E+00_JPRB,1.8986E+00_JPRB/)  
KBO( :,19, 9) = (/&
 & 1.7845E+00_JPRB,1.8215E+00_JPRB,1.8581E+00_JPRB,1.8942E+00_JPRB,1.9287E+00_JPRB/)  
KBO( :,20, 9) = (/&
 & 1.8060E+00_JPRB,1.8426E+00_JPRB,1.8782E+00_JPRB,1.9127E+00_JPRB,1.9453E+00_JPRB/)  
KBO( :,21, 9) = (/&
 & 1.8043E+00_JPRB,1.8411E+00_JPRB,1.8774E+00_JPRB,1.9117E+00_JPRB,1.9436E+00_JPRB/)  
KBO( :,22, 9) = (/&
 & 1.7831E+00_JPRB,1.8215E+00_JPRB,1.8592E+00_JPRB,1.8938E+00_JPRB,1.9262E+00_JPRB/)  
KBO( :,23, 9) = (/&
 & 1.7432E+00_JPRB,1.7837E+00_JPRB,1.8229E+00_JPRB,1.8594E+00_JPRB,1.8938E+00_JPRB/)  
KBO( :,24, 9) = (/&
 & 1.6875E+00_JPRB,1.7308E+00_JPRB,1.7727E+00_JPRB,1.8123E+00_JPRB,1.8497E+00_JPRB/)  
KBO( :,25, 9) = (/&
 & 1.6225E+00_JPRB,1.6694E+00_JPRB,1.7148E+00_JPRB,1.7578E+00_JPRB,1.7985E+00_JPRB/)  
KBO( :,26, 9) = (/&
 & 1.5531E+00_JPRB,1.6049E+00_JPRB,1.6541E+00_JPRB,1.7008E+00_JPRB,1.7454E+00_JPRB/)  
KBO( :,27, 9) = (/&
 & 1.4838E+00_JPRB,1.5403E+00_JPRB,1.5937E+00_JPRB,1.6447E+00_JPRB,1.6935E+00_JPRB/)  
KBO( :,28, 9) = (/&
 & 1.4175E+00_JPRB,1.4786E+00_JPRB,1.5364E+00_JPRB,1.5921E+00_JPRB,1.6457E+00_JPRB/)  
KBO( :,29, 9) = (/&
 & 1.3581E+00_JPRB,1.4237E+00_JPRB,1.4868E+00_JPRB,1.5478E+00_JPRB,1.6068E+00_JPRB/)  
KBO( :,30, 9) = (/&
 & 1.3065E+00_JPRB,1.3770E+00_JPRB,1.4457E+00_JPRB,1.5119E+00_JPRB,1.5768E+00_JPRB/)  
KBO( :,31, 9) = (/&
 & 1.2654E+00_JPRB,1.3417E+00_JPRB,1.4156E+00_JPRB,1.4877E+00_JPRB,1.5592E+00_JPRB/)  
KBO( :,32, 9) = (/&
 & 1.2347E+00_JPRB,1.3163E+00_JPRB,1.3958E+00_JPRB,1.4744E+00_JPRB,1.5534E+00_JPRB/)  
KBO( :,33, 9) = (/&
 & 1.2142E+00_JPRB,1.3012E+00_JPRB,1.3868E+00_JPRB,1.4727E+00_JPRB,1.5601E+00_JPRB/)  
KBO( :,34, 9) = (/&
 & 1.1993E+00_JPRB,1.2916E+00_JPRB,1.3831E+00_JPRB,1.4762E+00_JPRB,1.5688E+00_JPRB/)  
KBO( :,35, 9) = (/&
 & 1.1833E+00_JPRB,1.2807E+00_JPRB,1.3785E+00_JPRB,1.4785E+00_JPRB,1.5752E+00_JPRB/)  
KBO( :,36, 9) = (/&
 & 1.1625E+00_JPRB,1.2651E+00_JPRB,1.3689E+00_JPRB,1.4743E+00_JPRB,1.5754E+00_JPRB/)  
KBO( :,37, 9) = (/&
 & 1.1303E+00_JPRB,1.2371E+00_JPRB,1.3460E+00_JPRB,1.4555E+00_JPRB,1.5610E+00_JPRB/)  
KBO( :,38, 9) = (/&
 & 1.1009E+00_JPRB,1.2122E+00_JPRB,1.3263E+00_JPRB,1.4399E+00_JPRB,1.5500E+00_JPRB/)  
KBO( :,39, 9) = (/&
 & 1.0754E+00_JPRB,1.1914E+00_JPRB,1.3110E+00_JPRB,1.4289E+00_JPRB,1.5440E+00_JPRB/)  
KBO( :,40, 9) = (/&
 & 1.0372E+00_JPRB,1.1560E+00_JPRB,1.2790E+00_JPRB,1.4000E+00_JPRB,1.5190E+00_JPRB/)  
KBO( :,41, 9) = (/&
 & 9.9871E-01_JPRB,1.1200E+00_JPRB,1.2460E+00_JPRB,1.3704E+00_JPRB,1.4926E+00_JPRB/)  
KBO( :,42, 9) = (/&
 & 9.6171E-01_JPRB,1.0854E+00_JPRB,1.2142E+00_JPRB,1.3421E+00_JPRB,1.4677E+00_JPRB/)  
KBO( :,43, 9) = (/&
 & 9.1903E-01_JPRB,1.0445E+00_JPRB,1.1757E+00_JPRB,1.3075E+00_JPRB,1.4366E+00_JPRB/)  
KBO( :,44, 9) = (/&
 & 8.7442E-01_JPRB,1.0015E+00_JPRB,1.1348E+00_JPRB,1.2703E+00_JPRB,1.4033E+00_JPRB/)  
KBO( :,45, 9) = (/&
 & 8.3107E-01_JPRB,9.5973E-01_JPRB,1.0952E+00_JPRB,1.2344E+00_JPRB,1.3716E+00_JPRB/)  
KBO( :,46, 9) = (/&
 & 7.8543E-01_JPRB,9.1559E-01_JPRB,1.0528E+00_JPRB,1.1955E+00_JPRB,1.3366E+00_JPRB/)  
KBO( :,47, 9) = (/&
 & 7.3439E-01_JPRB,8.6539E-01_JPRB,1.0031E+00_JPRB,1.1485E+00_JPRB,1.2936E+00_JPRB/)  
KBO( :,48, 9) = (/&
 & 6.8465E-01_JPRB,8.1643E-01_JPRB,9.5503E-01_JPRB,1.1032E+00_JPRB,1.2524E+00_JPRB/)  
KBO( :,49, 9) = (/&
 & 6.3687E-01_JPRB,7.6933E-01_JPRB,9.0975E-01_JPRB,1.0608E+00_JPRB,1.2144E+00_JPRB/)  
KBO( :,50, 9) = (/&
 & 5.9153E-01_JPRB,7.2348E-01_JPRB,8.6434E-01_JPRB,1.0167E+00_JPRB,1.1731E+00_JPRB/)  
KBO( :,51, 9) = (/&
 & 5.4771E-01_JPRB,6.7868E-01_JPRB,8.1882E-01_JPRB,9.7145E-01_JPRB,1.1300E+00_JPRB/)  
KBO( :,52, 9) = (/&
 & 5.0614E-01_JPRB,6.3574E-01_JPRB,7.7544E-01_JPRB,9.2863E-01_JPRB,1.0894E+00_JPRB/)  
KBO( :,53, 9) = (/&
 & 4.6783E-01_JPRB,5.9578E-01_JPRB,7.3527E-01_JPRB,8.8939E-01_JPRB,1.0528E+00_JPRB/)  
KBO( :,54, 9) = (/&
 & 4.2858E-01_JPRB,5.5309E-01_JPRB,6.8975E-01_JPRB,8.4016E-01_JPRB,1.0034E+00_JPRB/)  
KBO( :,55, 9) = (/&
 & 3.8876E-01_JPRB,5.0900E-01_JPRB,6.4137E-01_JPRB,7.8611E-01_JPRB,9.4586E-01_JPRB/)  
KBO( :,56, 9) = (/&
 & 3.5092E-01_JPRB,4.6656E-01_JPRB,5.9498E-01_JPRB,7.3470E-01_JPRB,8.8954E-01_JPRB/)  
KBO( :,57, 9) = (/&
 & 3.1483E-01_JPRB,4.2575E-01_JPRB,5.4997E-01_JPRB,6.8552E-01_JPRB,8.3410E-01_JPRB/)  
KBO( :,58, 9) = (/&
 & 2.8132E-01_JPRB,3.8740E-01_JPRB,5.0731E-01_JPRB,6.3876E-01_JPRB,7.8141E-01_JPRB/)  
KBO( :,59, 9) = (/&
 & 2.6003E-01_JPRB,3.6342E-01_JPRB,4.7940E-01_JPRB,6.0625E-01_JPRB,7.4174E-01_JPRB/)  
KBO( :, 7,10) = (/&
 & 1.5697E+01_JPRB,1.7679E+01_JPRB,2.1528E+01_JPRB,3.0021E+01_JPRB,4.1007E+01_JPRB/)  
KBO( :, 8,10) = (/&
 & 9.2952E+00_JPRB,1.0046E+01_JPRB,1.1296E+01_JPRB,1.2956E+01_JPRB,1.5022E+01_JPRB/)  
KBO( :, 9,10) = (/&
 & 6.0955E+00_JPRB,6.1520E+00_JPRB,6.4442E+00_JPRB,6.9113E+00_JPRB,7.6410E+00_JPRB/)  
KBO( :,10,10) = (/&
 & 4.2479E+00_JPRB,4.2558E+00_JPRB,4.3823E+00_JPRB,4.5849E+00_JPRB,4.8443E+00_JPRB/)  
KBO( :,11,10) = (/&
 & 3.5882E+00_JPRB,3.5777E+00_JPRB,3.6465E+00_JPRB,3.7844E+00_JPRB,3.9918E+00_JPRB/)  
KBO( :,12,10) = (/&
 & 3.3077E+00_JPRB,3.3279E+00_JPRB,3.4118E+00_JPRB,3.5356E+00_JPRB,3.6964E+00_JPRB/)  
KBO( :,13,10) = (/&
 & 3.1132E+00_JPRB,3.1610E+00_JPRB,3.2411E+00_JPRB,3.3566E+00_JPRB,3.4933E+00_JPRB/)  
KBO( :,14,10) = (/&
 & 2.6876E+00_JPRB,2.7279E+00_JPRB,2.7858E+00_JPRB,2.8724E+00_JPRB,2.9756E+00_JPRB/)  
KBO( :,15,10) = (/&
 & 2.5898E+00_JPRB,2.6527E+00_JPRB,2.7165E+00_JPRB,2.7974E+00_JPRB,2.8915E+00_JPRB/)  
KBO( :,16,10) = (/&
 & 2.7402E+00_JPRB,2.8161E+00_JPRB,2.8979E+00_JPRB,2.9945E+00_JPRB,3.0907E+00_JPRB/)  
KBO( :,17,10) = (/&
 & 2.9795E+00_JPRB,3.0670E+00_JPRB,3.1571E+00_JPRB,3.2540E+00_JPRB,3.3473E+00_JPRB/)  
KBO( :,18,10) = (/&
 & 3.2307E+00_JPRB,3.3198E+00_JPRB,3.4108E+00_JPRB,3.5052E+00_JPRB,3.6016E+00_JPRB/)  
KBO( :,19,10) = (/&
 & 3.4826E+00_JPRB,3.5697E+00_JPRB,3.6620E+00_JPRB,3.7547E+00_JPRB,3.8494E+00_JPRB/)  
KBO( :,20,10) = (/&
 & 3.7406E+00_JPRB,3.8282E+00_JPRB,3.9146E+00_JPRB,4.0064E+00_JPRB,4.0952E+00_JPRB/)  
KBO( :,21,10) = (/&
 & 4.0052E+00_JPRB,4.0906E+00_JPRB,4.1674E+00_JPRB,4.2500E+00_JPRB,4.3292E+00_JPRB/)  
KBO( :,22,10) = (/&
 & 4.2533E+00_JPRB,4.3366E+00_JPRB,4.4069E+00_JPRB,4.4888E+00_JPRB,4.5601E+00_JPRB/)  
KBO( :,23,10) = (/&
 & 4.4651E+00_JPRB,4.5450E+00_JPRB,4.6244E+00_JPRB,4.7038E+00_JPRB,4.7723E+00_JPRB/)  
KBO( :,24,10) = (/&
 & 4.6357E+00_JPRB,4.7250E+00_JPRB,4.8121E+00_JPRB,4.8897E+00_JPRB,4.9609E+00_JPRB/)  
KBO( :,25,10) = (/&
 & 4.7760E+00_JPRB,4.8704E+00_JPRB,4.9689E+00_JPRB,5.0528E+00_JPRB,5.1275E+00_JPRB/)  
KBO( :,26,10) = (/&
 & 4.8874E+00_JPRB,4.9911E+00_JPRB,5.1002E+00_JPRB,5.1918E+00_JPRB,5.2692E+00_JPRB/)  
KBO( :,27,10) = (/&
 & 4.9748E+00_JPRB,5.0953E+00_JPRB,5.2124E+00_JPRB,5.3083E+00_JPRB,5.3926E+00_JPRB/)  
KBO( :,28,10) = (/&
 & 5.0502E+00_JPRB,5.1884E+00_JPRB,5.3119E+00_JPRB,5.4148E+00_JPRB,5.5003E+00_JPRB/)  
KBO( :,29,10) = (/&
 & 5.1279E+00_JPRB,5.2762E+00_JPRB,5.4025E+00_JPRB,5.5131E+00_JPRB,5.6036E+00_JPRB/)  
KBO( :,30,10) = (/&
 & 5.2044E+00_JPRB,5.3581E+00_JPRB,5.4889E+00_JPRB,5.6058E+00_JPRB,5.6994E+00_JPRB/)  
KBO( :,31,10) = (/&
 & 5.2832E+00_JPRB,5.4378E+00_JPRB,5.5764E+00_JPRB,5.6975E+00_JPRB,5.7881E+00_JPRB/)  
KBO( :,32,10) = (/&
 & 5.3589E+00_JPRB,5.5221E+00_JPRB,5.6642E+00_JPRB,5.7794E+00_JPRB,5.8684E+00_JPRB/)  
KBO( :,33,10) = (/&
 & 5.4422E+00_JPRB,5.6051E+00_JPRB,5.7472E+00_JPRB,5.8589E+00_JPRB,5.9492E+00_JPRB/)  
KBO( :,34,10) = (/&
 & 5.5143E+00_JPRB,5.6758E+00_JPRB,5.8184E+00_JPRB,5.9324E+00_JPRB,6.0581E+00_JPRB/)  
KBO( :,35,10) = (/&
 & 5.5663E+00_JPRB,5.7307E+00_JPRB,5.8759E+00_JPRB,6.0007E+00_JPRB,6.1676E+00_JPRB/)  
KBO( :,36,10) = (/&
 & 5.5957E+00_JPRB,5.7658E+00_JPRB,5.9172E+00_JPRB,6.0677E+00_JPRB,6.2475E+00_JPRB/)  
KBO( :,37,10) = (/&
 & 5.5911E+00_JPRB,5.7698E+00_JPRB,5.9275E+00_JPRB,6.1033E+00_JPRB,6.2899E+00_JPRB/)  
KBO( :,38,10) = (/&
 & 5.5847E+00_JPRB,5.7702E+00_JPRB,5.9359E+00_JPRB,6.1377E+00_JPRB,6.3291E+00_JPRB/)  
KBO( :,39,10) = (/&
 & 5.5785E+00_JPRB,5.7701E+00_JPRB,5.9474E+00_JPRB,6.1752E+00_JPRB,6.3726E+00_JPRB/)  
KBO( :,40,10) = (/&
 & 5.5411E+00_JPRB,5.7435E+00_JPRB,5.9235E+00_JPRB,6.1610E+00_JPRB,6.3723E+00_JPRB/)  
KBO( :,41,10) = (/&
 & 5.4950E+00_JPRB,5.7121E+00_JPRB,5.8935E+00_JPRB,6.1377E+00_JPRB,6.3632E+00_JPRB/)  
KBO( :,42,10) = (/&
 & 5.4435E+00_JPRB,5.6770E+00_JPRB,5.8638E+00_JPRB,6.1135E+00_JPRB,6.3531E+00_JPRB/)  
KBO( :,43,10) = (/&
 & 5.3711E+00_JPRB,5.6253E+00_JPRB,5.8214E+00_JPRB,6.0734E+00_JPRB,6.3283E+00_JPRB/)  
KBO( :,44,10) = (/&
 & 5.2841E+00_JPRB,5.5611E+00_JPRB,5.7743E+00_JPRB,6.0249E+00_JPRB,6.2949E+00_JPRB/)  
KBO( :,45,10) = (/&
 & 5.1898E+00_JPRB,5.4904E+00_JPRB,5.7247E+00_JPRB,5.9791E+00_JPRB,6.2621E+00_JPRB/)  
KBO( :,46,10) = (/&
 & 5.0867E+00_JPRB,5.4031E+00_JPRB,5.6642E+00_JPRB,5.9247E+00_JPRB,6.2201E+00_JPRB/)  
KBO( :,47,10) = (/&
 & 4.9588E+00_JPRB,5.2939E+00_JPRB,5.5834E+00_JPRB,5.8490E+00_JPRB,6.1549E+00_JPRB/)  
KBO( :,48,10) = (/&
 & 4.8216E+00_JPRB,5.1792E+00_JPRB,5.4914E+00_JPRB,5.7730E+00_JPRB,6.0921E+00_JPRB/)  
KBO( :,49,10) = (/&
 & 4.6738E+00_JPRB,5.0604E+00_JPRB,5.3912E+00_JPRB,5.6961E+00_JPRB,6.0396E+00_JPRB/)  
KBO( :,50,10) = (/&
 & 4.5187E+00_JPRB,4.9359E+00_JPRB,5.2845E+00_JPRB,5.6050E+00_JPRB,5.9698E+00_JPRB/)  
KBO( :,51,10) = (/&
 & 4.3577E+00_JPRB,4.8020E+00_JPRB,5.1743E+00_JPRB,5.5057E+00_JPRB,5.8886E+00_JPRB/)  
KBO( :,52,10) = (/&
 & 4.1875E+00_JPRB,4.6601E+00_JPRB,5.0599E+00_JPRB,5.4039E+00_JPRB,5.8085E+00_JPRB/)  
KBO( :,53,10) = (/&
 & 4.0066E+00_JPRB,4.5088E+00_JPRB,4.9396E+00_JPRB,5.3035E+00_JPRB,5.7324E+00_JPRB/)  
KBO( :,54,10) = (/&
 & 3.8264E+00_JPRB,4.3529E+00_JPRB,4.8099E+00_JPRB,5.1931E+00_JPRB,5.6043E+00_JPRB/)  
KBO( :,55,10) = (/&
 & 3.6414E+00_JPRB,4.1888E+00_JPRB,4.6681E+00_JPRB,5.0739E+00_JPRB,5.4467E+00_JPRB/)  
KBO( :,56,10) = (/&
 & 3.4467E+00_JPRB,4.0187E+00_JPRB,4.5175E+00_JPRB,4.9476E+00_JPRB,5.3119E+00_JPRB/)  
KBO( :,57,10) = (/&
 & 3.2449E+00_JPRB,3.8431E+00_JPRB,4.3635E+00_JPRB,4.8167E+00_JPRB,5.1973E+00_JPRB/)  
KBO( :,58,10) = (/&
 & 3.0504E+00_JPRB,3.6676E+00_JPRB,4.2101E+00_JPRB,4.6788E+00_JPRB,5.0833E+00_JPRB/)  
KBO( :,59,10) = (/&
 & 2.9706E+00_JPRB,3.5768E+00_JPRB,4.1308E+00_JPRB,4.6019E+00_JPRB,5.0071E+00_JPRB/)  
KBO( :, 7,11) = (/&
 & 1.7920E+01_JPRB,2.1641E+01_JPRB,2.9884E+01_JPRB,4.1982E+01_JPRB,5.8086E+01_JPRB/)  
KBO( :, 8,11) = (/&
 & 1.1126E+01_JPRB,1.2099E+01_JPRB,1.3449E+01_JPRB,1.5213E+01_JPRB,1.8753E+01_JPRB/)  
KBO( :, 9,11) = (/&
 & 7.7621E+00_JPRB,7.7863E+00_JPRB,8.0891E+00_JPRB,8.6591E+00_JPRB,9.4525E+00_JPRB/)  
KBO( :,10,11) = (/&
 & 5.3764E+00_JPRB,5.3165E+00_JPRB,5.3549E+00_JPRB,5.6476E+00_JPRB,6.0580E+00_JPRB/)  
KBO( :,11,11) = (/&
 & 4.4238E+00_JPRB,4.4268E+00_JPRB,4.4710E+00_JPRB,4.6447E+00_JPRB,4.9156E+00_JPRB/)  
KBO( :,12,11) = (/&
 & 4.1742E+00_JPRB,4.1694E+00_JPRB,4.2134E+00_JPRB,4.3731E+00_JPRB,4.5989E+00_JPRB/)  
KBO( :,13,11) = (/&
 & 3.8539E+00_JPRB,3.8850E+00_JPRB,3.9664E+00_JPRB,4.1051E+00_JPRB,4.2861E+00_JPRB/)  
KBO( :,14,11) = (/&
 & 3.3455E+00_JPRB,3.3983E+00_JPRB,3.4591E+00_JPRB,3.5679E+00_JPRB,3.6998E+00_JPRB/)  
KBO( :,15,11) = (/&
 & 3.0374E+00_JPRB,3.0982E+00_JPRB,3.1712E+00_JPRB,3.2728E+00_JPRB,3.3905E+00_JPRB/)  
KBO( :,16,11) = (/&
 & 3.2400E+00_JPRB,3.3230E+00_JPRB,3.4115E+00_JPRB,3.5107E+00_JPRB,3.6327E+00_JPRB/)  
KBO( :,17,11) = (/&
 & 3.5796E+00_JPRB,3.6714E+00_JPRB,3.7619E+00_JPRB,3.8672E+00_JPRB,3.9895E+00_JPRB/)  
KBO( :,18,11) = (/&
 & 3.9339E+00_JPRB,4.0372E+00_JPRB,4.1451E+00_JPRB,4.2637E+00_JPRB,4.3878E+00_JPRB/)  
KBO( :,19,11) = (/&
 & 4.3003E+00_JPRB,4.4193E+00_JPRB,4.5347E+00_JPRB,4.6623E+00_JPRB,4.7825E+00_JPRB/)  
KBO( :,20,11) = (/&
 & 4.6837E+00_JPRB,4.8067E+00_JPRB,4.9249E+00_JPRB,5.0479E+00_JPRB,5.1713E+00_JPRB/)  
KBO( :,21,11) = (/&
 & 5.0626E+00_JPRB,5.1843E+00_JPRB,5.2993E+00_JPRB,5.4194E+00_JPRB,5.5447E+00_JPRB/)  
KBO( :,22,11) = (/&
 & 5.4464E+00_JPRB,5.5600E+00_JPRB,5.6663E+00_JPRB,5.7827E+00_JPRB,5.9026E+00_JPRB/)  
KBO( :,23,11) = (/&
 & 5.8230E+00_JPRB,5.9290E+00_JPRB,6.0201E+00_JPRB,6.1295E+00_JPRB,6.2404E+00_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB8:PART5',1,ZHOOK_HANDLE)
END SUBROUTINE PART5


SUBROUTINE PART6

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB8:PART6',0,ZHOOK_HANDLE)


KBO( :,24,11) = (/&
 & 6.1873E+00_JPRB,6.2763E+00_JPRB,6.3564E+00_JPRB,6.4571E+00_JPRB,6.5535E+00_JPRB/)  
KBO( :,25,11) = (/&
 & 6.5161E+00_JPRB,6.5971E+00_JPRB,6.6674E+00_JPRB,6.7623E+00_JPRB,6.8469E+00_JPRB/)  
KBO( :,26,11) = (/&
 & 6.8093E+00_JPRB,6.8834E+00_JPRB,6.9596E+00_JPRB,7.0463E+00_JPRB,7.1184E+00_JPRB/)  
KBO( :,27,11) = (/&
 & 7.0690E+00_JPRB,7.1424E+00_JPRB,7.2255E+00_JPRB,7.3026E+00_JPRB,7.3674E+00_JPRB/)  
KBO( :,28,11) = (/&
 & 7.2957E+00_JPRB,7.3779E+00_JPRB,7.4665E+00_JPRB,7.5315E+00_JPRB,7.5874E+00_JPRB/)  
KBO( :,29,11) = (/&
 & 7.4992E+00_JPRB,7.5961E+00_JPRB,7.6823E+00_JPRB,7.7381E+00_JPRB,7.7862E+00_JPRB/)  
KBO( :,30,11) = (/&
 & 7.6816E+00_JPRB,7.7926E+00_JPRB,7.8689E+00_JPRB,7.9230E+00_JPRB,7.9632E+00_JPRB/)  
KBO( :,31,11) = (/&
 & 7.8556E+00_JPRB,7.9647E+00_JPRB,8.0377E+00_JPRB,8.0903E+00_JPRB,8.1303E+00_JPRB/)  
KBO( :,32,11) = (/&
 & 8.0202E+00_JPRB,8.1171E+00_JPRB,8.1880E+00_JPRB,8.2406E+00_JPRB,8.2756E+00_JPRB/)  
KBO( :,33,11) = (/&
 & 8.1619E+00_JPRB,8.2627E+00_JPRB,8.3314E+00_JPRB,8.3764E+00_JPRB,8.4039E+00_JPRB/)  
KBO( :,34,11) = (/&
 & 8.2897E+00_JPRB,8.3916E+00_JPRB,8.4495E+00_JPRB,8.4834E+00_JPRB,8.5104E+00_JPRB/)  
KBO( :,35,11) = (/&
 & 8.3973E+00_JPRB,8.4969E+00_JPRB,8.5504E+00_JPRB,8.5788E+00_JPRB,8.6250E+00_JPRB/)  
KBO( :,36,11) = (/&
 & 8.4783E+00_JPRB,8.5783E+00_JPRB,8.6329E+00_JPRB,8.6663E+00_JPRB,8.7603E+00_JPRB/)  
KBO( :,37,11) = (/&
 & 8.5262E+00_JPRB,8.6348E+00_JPRB,8.6984E+00_JPRB,8.7369E+00_JPRB,8.8563E+00_JPRB/)  
KBO( :,38,11) = (/&
 & 8.5648E+00_JPRB,8.6833E+00_JPRB,8.7565E+00_JPRB,8.8061E+00_JPRB,8.9518E+00_JPRB/)  
KBO( :,39,11) = (/&
 & 8.5959E+00_JPRB,8.7278E+00_JPRB,8.8134E+00_JPRB,8.8823E+00_JPRB,9.0526E+00_JPRB/)  
KBO( :,40,11) = (/&
 & 8.5957E+00_JPRB,8.7419E+00_JPRB,8.8442E+00_JPRB,8.9192E+00_JPRB,9.0935E+00_JPRB/)  
KBO( :,41,11) = (/&
 & 8.5854E+00_JPRB,8.7451E+00_JPRB,8.8638E+00_JPRB,8.9464E+00_JPRB,9.1244E+00_JPRB/)  
KBO( :,42,11) = (/&
 & 8.5691E+00_JPRB,8.7426E+00_JPRB,8.8772E+00_JPRB,8.9702E+00_JPRB,9.1549E+00_JPRB/)  
KBO( :,43,11) = (/&
 & 8.5353E+00_JPRB,8.7238E+00_JPRB,8.8789E+00_JPRB,8.9815E+00_JPRB,9.1732E+00_JPRB/)  
KBO( :,44,11) = (/&
 & 8.4888E+00_JPRB,8.6962E+00_JPRB,8.8660E+00_JPRB,8.9836E+00_JPRB,9.1847E+00_JPRB/)  
KBO( :,45,11) = (/&
 & 8.4356E+00_JPRB,8.6623E+00_JPRB,8.8484E+00_JPRB,8.9837E+00_JPRB,9.1994E+00_JPRB/)  
KBO( :,46,11) = (/&
 & 8.3622E+00_JPRB,8.6149E+00_JPRB,8.8200E+00_JPRB,8.9745E+00_JPRB,9.2060E+00_JPRB/)  
KBO( :,47,11) = (/&
 & 8.2619E+00_JPRB,8.5445E+00_JPRB,8.7739E+00_JPRB,8.9475E+00_JPRB,9.1875E+00_JPRB/)  
KBO( :,48,11) = (/&
 & 8.1513E+00_JPRB,8.4680E+00_JPRB,8.7219E+00_JPRB,8.9176E+00_JPRB,9.1678E+00_JPRB/)  
KBO( :,49,11) = (/&
 & 8.0316E+00_JPRB,8.3787E+00_JPRB,8.6678E+00_JPRB,8.8862E+00_JPRB,9.1522E+00_JPRB/)  
KBO( :,50,11) = (/&
 & 7.8984E+00_JPRB,8.2757E+00_JPRB,8.5998E+00_JPRB,8.8430E+00_JPRB,9.1103E+00_JPRB/)  
KBO( :,51,11) = (/&
 & 7.7437E+00_JPRB,8.1650E+00_JPRB,8.5164E+00_JPRB,8.7904E+00_JPRB,9.0499E+00_JPRB/)  
KBO( :,52,11) = (/&
 & 7.5822E+00_JPRB,8.0442E+00_JPRB,8.4217E+00_JPRB,8.7308E+00_JPRB,8.9942E+00_JPRB/)  
KBO( :,53,11) = (/&
 & 7.4003E+00_JPRB,7.9114E+00_JPRB,8.3203E+00_JPRB,8.6646E+00_JPRB,8.9454E+00_JPRB/)  
KBO( :,54,11) = (/&
 & 7.2039E+00_JPRB,7.7594E+00_JPRB,8.2013E+00_JPRB,8.5703E+00_JPRB,8.8555E+00_JPRB/)  
KBO( :,55,11) = (/&
 & 6.9900E+00_JPRB,7.5960E+00_JPRB,8.0681E+00_JPRB,8.4581E+00_JPRB,8.7673E+00_JPRB/)  
KBO( :,56,11) = (/&
 & 6.7720E+00_JPRB,7.4183E+00_JPRB,7.9272E+00_JPRB,8.3307E+00_JPRB,8.6758E+00_JPRB/)  
KBO( :,57,11) = (/&
 & 6.5509E+00_JPRB,7.2181E+00_JPRB,7.7728E+00_JPRB,8.2049E+00_JPRB,8.5685E+00_JPRB/)  
KBO( :,58,11) = (/&
 & 6.3303E+00_JPRB,7.0170E+00_JPRB,7.6150E+00_JPRB,8.0806E+00_JPRB,8.4555E+00_JPRB/)  
KBO( :,59,11) = (/&
 & 6.2363E+00_JPRB,6.9228E+00_JPRB,7.5131E+00_JPRB,7.9939E+00_JPRB,8.3670E+00_JPRB/)  
KBO( :, 7,12) = (/&
 & 2.2304E+01_JPRB,3.2911E+01_JPRB,4.6319E+01_JPRB,6.2557E+01_JPRB,8.3356E+01_JPRB/)  
KBO( :, 8,12) = (/&
 & 1.3203E+01_JPRB,1.4115E+01_JPRB,1.5516E+01_JPRB,1.9088E+01_JPRB,2.6621E+01_JPRB/)  
KBO( :, 9,12) = (/&
 & 9.6210E+00_JPRB,9.7022E+00_JPRB,9.9693E+00_JPRB,1.0635E+01_JPRB,1.1509E+01_JPRB/)  
KBO( :,10,12) = (/&
 & 6.9200E+00_JPRB,6.8772E+00_JPRB,6.8479E+00_JPRB,7.1633E+00_JPRB,7.6773E+00_JPRB/)  
KBO( :,11,12) = (/&
 & 5.3676E+00_JPRB,5.4048E+00_JPRB,5.4687E+00_JPRB,5.6602E+00_JPRB,5.9583E+00_JPRB/)  
KBO( :,12,12) = (/&
 & 5.2136E+00_JPRB,5.2336E+00_JPRB,5.2831E+00_JPRB,5.4582E+00_JPRB,5.7388E+00_JPRB/)  
KBO( :,13,12) = (/&
 & 4.8924E+00_JPRB,4.9073E+00_JPRB,4.9522E+00_JPRB,5.1280E+00_JPRB,5.3932E+00_JPRB/)  
KBO( :,14,12) = (/&
 & 4.0853E+00_JPRB,4.1772E+00_JPRB,4.2731E+00_JPRB,4.4007E+00_JPRB,4.5816E+00_JPRB/)  
KBO( :,15,12) = (/&
 & 3.8900E+00_JPRB,3.9892E+00_JPRB,4.0771E+00_JPRB,4.2126E+00_JPRB,4.4082E+00_JPRB/)  
KBO( :,16,12) = (/&
 & 4.1327E+00_JPRB,4.2242E+00_JPRB,4.3125E+00_JPRB,4.4391E+00_JPRB,4.6138E+00_JPRB/)  
KBO( :,17,12) = (/&
 & 4.4414E+00_JPRB,4.5415E+00_JPRB,4.6376E+00_JPRB,4.7581E+00_JPRB,4.9174E+00_JPRB/)  
KBO( :,18,12) = (/&
 & 4.8741E+00_JPRB,4.9856E+00_JPRB,5.0865E+00_JPRB,5.2000E+00_JPRB,5.3496E+00_JPRB/)  
KBO( :,19,12) = (/&
 & 5.3942E+00_JPRB,5.5159E+00_JPRB,5.6209E+00_JPRB,5.7303E+00_JPRB,5.8792E+00_JPRB/)  
KBO( :,20,12) = (/&
 & 5.9449E+00_JPRB,6.0804E+00_JPRB,6.1977E+00_JPRB,6.3136E+00_JPRB,6.4625E+00_JPRB/)  
KBO( :,21,12) = (/&
 & 6.5083E+00_JPRB,6.6571E+00_JPRB,6.7844E+00_JPRB,6.9105E+00_JPRB,7.0578E+00_JPRB/)  
KBO( :,22,12) = (/&
 & 7.0948E+00_JPRB,7.2430E+00_JPRB,7.3777E+00_JPRB,7.5057E+00_JPRB,7.6548E+00_JPRB/)  
KBO( :,23,12) = (/&
 & 7.6728E+00_JPRB,7.8216E+00_JPRB,7.9521E+00_JPRB,8.0848E+00_JPRB,8.2305E+00_JPRB/)  
KBO( :,24,12) = (/&
 & 8.2357E+00_JPRB,8.3751E+00_JPRB,8.4992E+00_JPRB,8.6326E+00_JPRB,8.7728E+00_JPRB/)  
KBO( :,25,12) = (/&
 & 8.7737E+00_JPRB,8.9042E+00_JPRB,9.0205E+00_JPRB,9.1429E+00_JPRB,9.2764E+00_JPRB/)  
KBO( :,26,12) = (/&
 & 9.2933E+00_JPRB,9.4039E+00_JPRB,9.4975E+00_JPRB,9.6155E+00_JPRB,9.7364E+00_JPRB/)  
KBO( :,27,12) = (/&
 & 9.7761E+00_JPRB,9.8603E+00_JPRB,9.9374E+00_JPRB,1.0052E+01_JPRB,1.0156E+01_JPRB/)  
KBO( :,28,12) = (/&
 & 1.0209E+01_JPRB,1.0271E+01_JPRB,1.0341E+01_JPRB,1.0444E+01_JPRB,1.0534E+01_JPRB/)  
KBO( :,29,12) = (/&
 & 1.0592E+01_JPRB,1.0638E+01_JPRB,1.0711E+01_JPRB,1.0795E+01_JPRB,1.0874E+01_JPRB/)  
KBO( :,30,12) = (/&
 & 1.0926E+01_JPRB,1.0968E+01_JPRB,1.1042E+01_JPRB,1.1108E+01_JPRB,1.1175E+01_JPRB/)  
KBO( :,31,12) = (/&
 & 1.1210E+01_JPRB,1.1270E+01_JPRB,1.1330E+01_JPRB,1.1391E+01_JPRB,1.1455E+01_JPRB/)  
KBO( :,32,12) = (/&
 & 1.1473E+01_JPRB,1.1530E+01_JPRB,1.1583E+01_JPRB,1.1643E+01_JPRB,1.1703E+01_JPRB/)  
KBO( :,33,12) = (/&
 & 1.1714E+01_JPRB,1.1754E+01_JPRB,1.1808E+01_JPRB,1.1874E+01_JPRB,1.1936E+01_JPRB/)  
KBO( :,34,12) = (/&
 & 1.1910E+01_JPRB,1.1948E+01_JPRB,1.2008E+01_JPRB,1.2077E+01_JPRB,1.2125E+01_JPRB/)  
KBO( :,35,12) = (/&
 & 1.2080E+01_JPRB,1.2122E+01_JPRB,1.2185E+01_JPRB,1.2249E+01_JPRB,1.2289E+01_JPRB/)  
KBO( :,36,12) = (/&
 & 1.2230E+01_JPRB,1.2275E+01_JPRB,1.2329E+01_JPRB,1.2385E+01_JPRB,1.2434E+01_JPRB/)  
KBO( :,37,12) = (/&
 & 1.2355E+01_JPRB,1.2395E+01_JPRB,1.2440E+01_JPRB,1.2491E+01_JPRB,1.2554E+01_JPRB/)  
KBO( :,38,12) = (/&
 & 1.2468E+01_JPRB,1.2508E+01_JPRB,1.2543E+01_JPRB,1.2592E+01_JPRB,1.2683E+01_JPRB/)  
KBO( :,39,12) = (/&
 & 1.2575E+01_JPRB,1.2612E+01_JPRB,1.2642E+01_JPRB,1.2692E+01_JPRB,1.2838E+01_JPRB/)  
KBO( :,40,12) = (/&
 & 1.2650E+01_JPRB,1.2686E+01_JPRB,1.2711E+01_JPRB,1.2759E+01_JPRB,1.2904E+01_JPRB/)  
KBO( :,41,12) = (/&
 & 1.2712E+01_JPRB,1.2745E+01_JPRB,1.2773E+01_JPRB,1.2817E+01_JPRB,1.2955E+01_JPRB/)  
KBO( :,42,12) = (/&
 & 1.2767E+01_JPRB,1.2799E+01_JPRB,1.2828E+01_JPRB,1.2873E+01_JPRB,1.3007E+01_JPRB/)  
KBO( :,43,12) = (/&
 & 1.2813E+01_JPRB,1.2848E+01_JPRB,1.2879E+01_JPRB,1.2924E+01_JPRB,1.3044E+01_JPRB/)  
KBO( :,44,12) = (/&
 & 1.2854E+01_JPRB,1.2894E+01_JPRB,1.2928E+01_JPRB,1.2974E+01_JPRB,1.3081E+01_JPRB/)  
KBO( :,45,12) = (/&
 & 1.2883E+01_JPRB,1.2938E+01_JPRB,1.2974E+01_JPRB,1.3025E+01_JPRB,1.3125E+01_JPRB/)  
KBO( :,46,12) = (/&
 & 1.2900E+01_JPRB,1.2975E+01_JPRB,1.3019E+01_JPRB,1.3074E+01_JPRB,1.3167E+01_JPRB/)  
KBO( :,47,12) = (/&
 & 1.2899E+01_JPRB,1.3003E+01_JPRB,1.3052E+01_JPRB,1.3111E+01_JPRB,1.3185E+01_JPRB/)  
KBO( :,48,12) = (/&
 & 1.2888E+01_JPRB,1.3016E+01_JPRB,1.3084E+01_JPRB,1.3147E+01_JPRB,1.3217E+01_JPRB/)  
KBO( :,49,12) = (/&
 & 1.2858E+01_JPRB,1.3028E+01_JPRB,1.3122E+01_JPRB,1.3196E+01_JPRB,1.3269E+01_JPRB/)  
KBO( :,50,12) = (/&
 & 1.2801E+01_JPRB,1.3021E+01_JPRB,1.3135E+01_JPRB,1.3222E+01_JPRB,1.3293E+01_JPRB/)  
KBO( :,51,12) = (/&
 & 1.2720E+01_JPRB,1.2990E+01_JPRB,1.3139E+01_JPRB,1.3235E+01_JPRB,1.3314E+01_JPRB/)  
KBO( :,52,12) = (/&
 & 1.2625E+01_JPRB,1.2948E+01_JPRB,1.3140E+01_JPRB,1.3259E+01_JPRB,1.3347E+01_JPRB/)  
KBO( :,53,12) = (/&
 & 1.2524E+01_JPRB,1.2897E+01_JPRB,1.3137E+01_JPRB,1.3283E+01_JPRB,1.3383E+01_JPRB/)  
KBO( :,54,12) = (/&
 & 1.2387E+01_JPRB,1.2811E+01_JPRB,1.3084E+01_JPRB,1.3257E+01_JPRB,1.3377E+01_JPRB/)  
KBO( :,55,12) = (/&
 & 1.2253E+01_JPRB,1.2679E+01_JPRB,1.3005E+01_JPRB,1.3202E+01_JPRB,1.3339E+01_JPRB/)  
KBO( :,56,12) = (/&
 & 1.2121E+01_JPRB,1.2542E+01_JPRB,1.2916E+01_JPRB,1.3156E+01_JPRB,1.3289E+01_JPRB/)  
KBO( :,57,12) = (/&
 & 1.1979E+01_JPRB,1.2408E+01_JPRB,1.2809E+01_JPRB,1.3086E+01_JPRB,1.3246E+01_JPRB/)  
KBO( :,58,12) = (/&
 & 1.1823E+01_JPRB,1.2282E+01_JPRB,1.2681E+01_JPRB,1.3001E+01_JPRB,1.3194E+01_JPRB/)  
KBO( :,59,12) = (/&
 & 1.1755E+01_JPRB,1.2232E+01_JPRB,1.2597E+01_JPRB,1.2896E+01_JPRB,1.3110E+01_JPRB/)  
KBO( :, 7,13) = (/&
 & 3.5643E+01_JPRB,5.1949E+01_JPRB,7.4063E+01_JPRB,1.0270E+02_JPRB,1.3794E+02_JPRB/)  
KBO( :, 8,13) = (/&
 & 1.5141E+01_JPRB,1.6031E+01_JPRB,1.9997E+01_JPRB,2.8469E+01_JPRB,4.0147E+01_JPRB/)  
KBO( :, 9,13) = (/&
 & 1.1387E+01_JPRB,1.1580E+01_JPRB,1.1786E+01_JPRB,1.2550E+01_JPRB,1.3679E+01_JPRB/)  
KBO( :,10,13) = (/&
 & 8.4794E+00_JPRB,8.5268E+00_JPRB,8.5378E+00_JPRB,8.7582E+00_JPRB,9.4039E+00_JPRB/)  
KBO( :,11,13) = (/&
 & 6.6590E+00_JPRB,6.6857E+00_JPRB,6.6700E+00_JPRB,6.8819E+00_JPRB,7.3175E+00_JPRB/)  
KBO( :,12,13) = (/&
 & 6.2717E+00_JPRB,6.3757E+00_JPRB,6.4443E+00_JPRB,6.6558E+00_JPRB,6.9844E+00_JPRB/)  
KBO( :,13,13) = (/&
 & 6.0914E+00_JPRB,6.1740E+00_JPRB,6.2405E+00_JPRB,6.4377E+00_JPRB,6.7503E+00_JPRB/)  
KBO( :,14,13) = (/&
 & 4.9794E+00_JPRB,5.0536E+00_JPRB,5.1492E+00_JPRB,5.3795E+00_JPRB,5.7518E+00_JPRB/)  
KBO( :,15,13) = (/&
 & 5.1843E+00_JPRB,5.3190E+00_JPRB,5.4758E+00_JPRB,5.6793E+00_JPRB,6.0175E+00_JPRB/)  
KBO( :,16,13) = (/&
 & 5.7049E+00_JPRB,5.8741E+00_JPRB,6.0283E+00_JPRB,6.2146E+00_JPRB,6.5273E+00_JPRB/)  
KBO( :,17,13) = (/&
 & 6.2538E+00_JPRB,6.4179E+00_JPRB,6.5692E+00_JPRB,6.7387E+00_JPRB,7.0279E+00_JPRB/)  
KBO( :,18,13) = (/&
 & 6.7525E+00_JPRB,6.9110E+00_JPRB,7.0637E+00_JPRB,7.2266E+00_JPRB,7.4943E+00_JPRB/)  
KBO( :,19,13) = (/&
 & 7.2519E+00_JPRB,7.4118E+00_JPRB,7.5663E+00_JPRB,7.7263E+00_JPRB,7.9629E+00_JPRB/)  
KBO( :,20,13) = (/&
 & 7.8324E+00_JPRB,7.9965E+00_JPRB,8.1590E+00_JPRB,8.3205E+00_JPRB,8.5444E+00_JPRB/)  
KBO( :,21,13) = (/&
 & 8.5287E+00_JPRB,8.6915E+00_JPRB,8.8554E+00_JPRB,9.0146E+00_JPRB,9.2285E+00_JPRB/)  
KBO( :,22,13) = (/&
 & 9.3469E+00_JPRB,9.5083E+00_JPRB,9.6626E+00_JPRB,9.8140E+00_JPRB,1.0022E+01_JPRB/)  
KBO( :,23,13) = (/&
 & 1.0237E+01_JPRB,1.0396E+01_JPRB,1.0540E+01_JPRB,1.0676E+01_JPRB,1.0870E+01_JPRB/)  
KBO( :,24,13) = (/&
 & 1.1146E+01_JPRB,1.1303E+01_JPRB,1.1436E+01_JPRB,1.1550E+01_JPRB,1.1722E+01_JPRB/)  
KBO( :,25,13) = (/&
 & 1.2050E+01_JPRB,1.2190E+01_JPRB,1.2298E+01_JPRB,1.2397E+01_JPRB,1.2546E+01_JPRB/)  
KBO( :,26,13) = (/&
 & 1.2909E+01_JPRB,1.3024E+01_JPRB,1.3107E+01_JPRB,1.3185E+01_JPRB,1.3314E+01_JPRB/)  
KBO( :,27,13) = (/&
 & 1.3701E+01_JPRB,1.3792E+01_JPRB,1.3849E+01_JPRB,1.3913E+01_JPRB,1.4022E+01_JPRB/)  
KBO( :,28,13) = (/&
 & 1.4427E+01_JPRB,1.4484E+01_JPRB,1.4511E+01_JPRB,1.4572E+01_JPRB,1.4654E+01_JPRB/)  
KBO( :,29,13) = (/&
 & 1.5072E+01_JPRB,1.5093E+01_JPRB,1.5109E+01_JPRB,1.5170E+01_JPRB,1.5215E+01_JPRB/)  
KBO( :,30,13) = (/&
 & 1.5628E+01_JPRB,1.5619E+01_JPRB,1.5649E+01_JPRB,1.5693E+01_JPRB,1.5715E+01_JPRB/)  
KBO( :,31,13) = (/&
 & 1.6105E+01_JPRB,1.6099E+01_JPRB,1.6147E+01_JPRB,1.6155E+01_JPRB,1.6164E+01_JPRB/)  
KBO( :,32,13) = (/&
 & 1.6511E+01_JPRB,1.6547E+01_JPRB,1.6576E+01_JPRB,1.6572E+01_JPRB,1.6565E+01_JPRB/)  
KBO( :,33,13) = (/&
 & 1.6897E+01_JPRB,1.6951E+01_JPRB,1.6956E+01_JPRB,1.6944E+01_JPRB,1.6929E+01_JPRB/)  
KBO( :,34,13) = (/&
 & 1.7252E+01_JPRB,1.7277E+01_JPRB,1.7273E+01_JPRB,1.7259E+01_JPRB,1.7247E+01_JPRB/)  
KBO( :,35,13) = (/&
 & 1.7555E+01_JPRB,1.7563E+01_JPRB,1.7552E+01_JPRB,1.7549E+01_JPRB,1.7549E+01_JPRB/)  
KBO( :,36,13) = (/&
 & 1.7803E+01_JPRB,1.7812E+01_JPRB,1.7811E+01_JPRB,1.7814E+01_JPRB,1.7805E+01_JPRB/)  
KBO( :,37,13) = (/&
 & 1.8013E+01_JPRB,1.8025E+01_JPRB,1.8034E+01_JPRB,1.8035E+01_JPRB,1.8022E+01_JPRB/)  
KBO( :,38,13) = (/&
 & 1.8201E+01_JPRB,1.8222E+01_JPRB,1.8247E+01_JPRB,1.8244E+01_JPRB,1.8226E+01_JPRB/)  
KBO( :,39,13) = (/&
 & 1.8383E+01_JPRB,1.8417E+01_JPRB,1.8445E+01_JPRB,1.8444E+01_JPRB,1.8423E+01_JPRB/)  
KBO( :,40,13) = (/&
 & 1.8521E+01_JPRB,1.8556E+01_JPRB,1.8589E+01_JPRB,1.8588E+01_JPRB,1.8570E+01_JPRB/)  
KBO( :,41,13) = (/&
 & 1.8644E+01_JPRB,1.8681E+01_JPRB,1.8714E+01_JPRB,1.8712E+01_JPRB,1.8700E+01_JPRB/)  
KBO( :,42,13) = (/&
 & 1.8752E+01_JPRB,1.8798E+01_JPRB,1.8834E+01_JPRB,1.8832E+01_JPRB,1.8827E+01_JPRB/)  
KBO( :,43,13) = (/&
 & 1.8844E+01_JPRB,1.8901E+01_JPRB,1.8939E+01_JPRB,1.8943E+01_JPRB,1.8946E+01_JPRB/)  
KBO( :,44,13) = (/&
 & 1.8930E+01_JPRB,1.8996E+01_JPRB,1.9046E+01_JPRB,1.9057E+01_JPRB,1.9063E+01_JPRB/)  
KBO( :,45,13) = (/&
 & 1.9023E+01_JPRB,1.9089E+01_JPRB,1.9147E+01_JPRB,1.9171E+01_JPRB,1.9190E+01_JPRB/)  
KBO( :,46,13) = (/&
 & 1.9108E+01_JPRB,1.9173E+01_JPRB,1.9241E+01_JPRB,1.9282E+01_JPRB,1.9317E+01_JPRB/)  
KBO( :,47,13) = (/&
 & 1.9179E+01_JPRB,1.9235E+01_JPRB,1.9323E+01_JPRB,1.9378E+01_JPRB,1.9424E+01_JPRB/)  
KBO( :,48,13) = (/&
 & 1.9259E+01_JPRB,1.9311E+01_JPRB,1.9403E+01_JPRB,1.9481E+01_JPRB,1.9542E+01_JPRB/)  
KBO( :,49,13) = (/&
 & 1.9353E+01_JPRB,1.9401E+01_JPRB,1.9487E+01_JPRB,1.9582E+01_JPRB,1.9677E+01_JPRB/)  
KBO( :,50,13) = (/&
 & 1.9435E+01_JPRB,1.9470E+01_JPRB,1.9546E+01_JPRB,1.9648E+01_JPRB,1.9775E+01_JPRB/)  
KBO( :,51,13) = (/&
 & 1.9528E+01_JPRB,1.9522E+01_JPRB,1.9589E+01_JPRB,1.9698E+01_JPRB,1.9835E+01_JPRB/)  
KBO( :,52,13) = (/&
 & 1.9619E+01_JPRB,1.9589E+01_JPRB,1.9648E+01_JPRB,1.9751E+01_JPRB,1.9897E+01_JPRB/)  
KBO( :,53,13) = (/&
 & 1.9714E+01_JPRB,1.9664E+01_JPRB,1.9723E+01_JPRB,1.9814E+01_JPRB,1.9980E+01_JPRB/)  
KBO( :,54,13) = (/&
 & 1.9804E+01_JPRB,1.9687E+01_JPRB,1.9738E+01_JPRB,1.9817E+01_JPRB,1.9959E+01_JPRB/)  
KBO( :,55,13) = (/&
 & 1.9891E+01_JPRB,1.9703E+01_JPRB,1.9714E+01_JPRB,1.9787E+01_JPRB,1.9905E+01_JPRB/)  
KBO( :,56,13) = (/&
 & 1.9968E+01_JPRB,1.9742E+01_JPRB,1.9687E+01_JPRB,1.9751E+01_JPRB,1.9853E+01_JPRB/)  
KBO( :,57,13) = (/&
 & 2.0032E+01_JPRB,1.9814E+01_JPRB,1.9687E+01_JPRB,1.9714E+01_JPRB,1.9803E+01_JPRB/)  
KBO( :,58,13) = (/&
 & 2.0080E+01_JPRB,1.9895E+01_JPRB,1.9702E+01_JPRB,1.9670E+01_JPRB,1.9752E+01_JPRB/)  
KBO( :,59,13) = (/&
 & 2.0098E+01_JPRB,1.9929E+01_JPRB,1.9672E+01_JPRB,1.9573E+01_JPRB,1.9576E+01_JPRB/)  
KBO( :, 7,14) = (/&
 & 9.1966E+01_JPRB,1.3562E+02_JPRB,1.9017E+02_JPRB,2.5592E+02_JPRB,3.3333E+02_JPRB/)  
KBO( :, 8,14) = (/&
 & 2.2693E+01_JPRB,3.3411E+01_JPRB,4.8518E+01_JPRB,6.7308E+01_JPRB,8.9702E+01_JPRB/)  
KBO( :, 9,14) = (/&
 & 1.2882E+01_JPRB,1.3153E+01_JPRB,1.3364E+01_JPRB,1.4883E+01_JPRB,2.1107E+01_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB8:PART6',1,ZHOOK_HANDLE)
END SUBROUTINE PART6


SUBROUTINE PART7

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB8:PART7',0,ZHOOK_HANDLE)


KBO( :,10,14) = (/&
 & 9.8362E+00_JPRB,9.9117E+00_JPRB,9.9648E+00_JPRB,1.0153E+01_JPRB,1.0885E+01_JPRB/)  
KBO( :,11,14) = (/&
 & 7.9433E+00_JPRB,7.9973E+00_JPRB,8.0475E+00_JPRB,8.2315E+00_JPRB,8.7834E+00_JPRB/)  
KBO( :,12,14) = (/&
 & 7.3895E+00_JPRB,7.4583E+00_JPRB,7.5219E+00_JPRB,7.7292E+00_JPRB,8.2231E+00_JPRB/)  
KBO( :,13,14) = (/&
 & 7.1435E+00_JPRB,7.2885E+00_JPRB,7.3950E+00_JPRB,7.6192E+00_JPRB,8.1085E+00_JPRB/)  
KBO( :,14,14) = (/&
 & 6.9992E+00_JPRB,7.1773E+00_JPRB,7.3399E+00_JPRB,7.5909E+00_JPRB,8.2289E+00_JPRB/)  
KBO( :,15,14) = (/&
 & 7.9125E+00_JPRB,8.1063E+00_JPRB,8.2644E+00_JPRB,8.4250E+00_JPRB,8.8258E+00_JPRB/)  
KBO( :,16,14) = (/&
 & 8.8516E+00_JPRB,9.0393E+00_JPRB,9.2237E+00_JPRB,9.3959E+00_JPRB,9.6957E+00_JPRB/)  
KBO( :,17,14) = (/&
 & 9.8145E+00_JPRB,1.0045E+01_JPRB,1.0264E+01_JPRB,1.0472E+01_JPRB,1.0729E+01_JPRB/)  
KBO( :,18,14) = (/&
 & 1.0863E+01_JPRB,1.1143E+01_JPRB,1.1400E+01_JPRB,1.1634E+01_JPRB,1.1884E+01_JPRB/)  
KBO( :,19,14) = (/&
 & 1.1987E+01_JPRB,1.2302E+01_JPRB,1.2594E+01_JPRB,1.2857E+01_JPRB,1.3115E+01_JPRB/)  
KBO( :,20,14) = (/&
 & 1.3163E+01_JPRB,1.3504E+01_JPRB,1.3819E+01_JPRB,1.4119E+01_JPRB,1.4393E+01_JPRB/)  
KBO( :,21,14) = (/&
 & 1.4360E+01_JPRB,1.4728E+01_JPRB,1.5076E+01_JPRB,1.5394E+01_JPRB,1.5681E+01_JPRB/)  
KBO( :,22,14) = (/&
 & 1.5564E+01_JPRB,1.5972E+01_JPRB,1.6343E+01_JPRB,1.6667E+01_JPRB,1.6964E+01_JPRB/)  
KBO( :,23,14) = (/&
 & 1.6820E+01_JPRB,1.7233E+01_JPRB,1.7594E+01_JPRB,1.7909E+01_JPRB,1.8214E+01_JPRB/)  
KBO( :,24,14) = (/&
 & 1.8109E+01_JPRB,1.8494E+01_JPRB,1.8826E+01_JPRB,1.9111E+01_JPRB,1.9401E+01_JPRB/)  
KBO( :,25,14) = (/&
 & 1.9392E+01_JPRB,1.9724E+01_JPRB,2.0018E+01_JPRB,2.0268E+01_JPRB,2.0538E+01_JPRB/)  
KBO( :,26,14) = (/&
 & 2.0628E+01_JPRB,2.0920E+01_JPRB,2.1173E+01_JPRB,2.1372E+01_JPRB,2.1625E+01_JPRB/)  
KBO( :,27,14) = (/&
 & 2.1805E+01_JPRB,2.2040E+01_JPRB,2.2243E+01_JPRB,2.2391E+01_JPRB,2.2631E+01_JPRB/)  
KBO( :,28,14) = (/&
 & 2.2897E+01_JPRB,2.3059E+01_JPRB,2.3185E+01_JPRB,2.3305E+01_JPRB,2.3583E+01_JPRB/)  
KBO( :,29,14) = (/&
 & 2.3866E+01_JPRB,2.3956E+01_JPRB,2.4031E+01_JPRB,2.4181E+01_JPRB,2.4577E+01_JPRB/)  
KBO( :,30,14) = (/&
 & 2.4714E+01_JPRB,2.4744E+01_JPRB,2.4786E+01_JPRB,2.5037E+01_JPRB,2.5553E+01_JPRB/)  
KBO( :,31,14) = (/&
 & 2.5442E+01_JPRB,2.5420E+01_JPRB,2.5528E+01_JPRB,2.5980E+01_JPRB,2.6575E+01_JPRB/)  
KBO( :,32,14) = (/&
 & 2.6060E+01_JPRB,2.6042E+01_JPRB,2.6355E+01_JPRB,2.6934E+01_JPRB,2.7574E+01_JPRB/)  
KBO( :,33,14) = (/&
 & 2.6582E+01_JPRB,2.6720E+01_JPRB,2.7257E+01_JPRB,2.7902E+01_JPRB,2.8582E+01_JPRB/)  
KBO( :,34,14) = (/&
 & 2.7091E+01_JPRB,2.7462E+01_JPRB,2.8092E+01_JPRB,2.8769E+01_JPRB,2.9492E+01_JPRB/)  
KBO( :,35,14) = (/&
 & 2.7632E+01_JPRB,2.8159E+01_JPRB,2.8835E+01_JPRB,2.9549E+01_JPRB,3.0321E+01_JPRB/)  
KBO( :,36,14) = (/&
 & 2.8159E+01_JPRB,2.8745E+01_JPRB,2.9458E+01_JPRB,3.0219E+01_JPRB,3.1043E+01_JPRB/)  
KBO( :,37,14) = (/&
 & 2.8540E+01_JPRB,2.9146E+01_JPRB,2.9877E+01_JPRB,3.0672E+01_JPRB,3.1544E+01_JPRB/)  
KBO( :,38,14) = (/&
 & 2.8901E+01_JPRB,2.9532E+01_JPRB,3.0283E+01_JPRB,3.1140E+01_JPRB,3.2071E+01_JPRB/)  
KBO( :,39,14) = (/&
 & 2.9260E+01_JPRB,2.9925E+01_JPRB,3.0734E+01_JPRB,3.1664E+01_JPRB,3.2694E+01_JPRB/)  
KBO( :,40,14) = (/&
 & 2.9430E+01_JPRB,3.0093E+01_JPRB,3.0912E+01_JPRB,3.1873E+01_JPRB,3.2935E+01_JPRB/)  
KBO( :,41,14) = (/&
 & 2.9569E+01_JPRB,3.0227E+01_JPRB,3.1048E+01_JPRB,3.2034E+01_JPRB,3.3124E+01_JPRB/)  
KBO( :,42,14) = (/&
 & 2.9715E+01_JPRB,3.0354E+01_JPRB,3.1194E+01_JPRB,3.2201E+01_JPRB,3.3328E+01_JPRB/)  
KBO( :,43,14) = (/&
 & 2.9833E+01_JPRB,3.0439E+01_JPRB,3.1280E+01_JPRB,3.2309E+01_JPRB,3.3467E+01_JPRB/)  
KBO( :,44,14) = (/&
 & 2.9941E+01_JPRB,3.0510E+01_JPRB,3.1343E+01_JPRB,3.2396E+01_JPRB,3.3596E+01_JPRB/)  
KBO( :,45,14) = (/&
 & 3.0066E+01_JPRB,3.0604E+01_JPRB,3.1448E+01_JPRB,3.2529E+01_JPRB,3.3774E+01_JPRB/)  
KBO( :,46,14) = (/&
 & 3.0186E+01_JPRB,3.0696E+01_JPRB,3.1535E+01_JPRB,3.2640E+01_JPRB,3.3926E+01_JPRB/)  
KBO( :,47,14) = (/&
 & 3.0293E+01_JPRB,3.0717E+01_JPRB,3.1531E+01_JPRB,3.2630E+01_JPRB,3.3950E+01_JPRB/)  
KBO( :,48,14) = (/&
 & 3.0429E+01_JPRB,3.0794E+01_JPRB,3.1577E+01_JPRB,3.2679E+01_JPRB,3.4060E+01_JPRB/)  
KBO( :,49,14) = (/&
 & 3.0616E+01_JPRB,3.0920E+01_JPRB,3.1697E+01_JPRB,3.2833E+01_JPRB,3.4261E+01_JPRB/)  
KBO( :,50,14) = (/&
 & 3.0818E+01_JPRB,3.0958E+01_JPRB,3.1730E+01_JPRB,3.2862E+01_JPRB,3.4287E+01_JPRB/)  
KBO( :,51,14) = (/&
 & 3.1037E+01_JPRB,3.0997E+01_JPRB,3.1705E+01_JPRB,3.2813E+01_JPRB,3.4237E+01_JPRB/)  
KBO( :,52,14) = (/&
 & 3.1309E+01_JPRB,3.1076E+01_JPRB,3.1722E+01_JPRB,3.2817E+01_JPRB,3.4252E+01_JPRB/)  
KBO( :,53,14) = (/&
 & 3.1610E+01_JPRB,3.1224E+01_JPRB,3.1798E+01_JPRB,3.2922E+01_JPRB,3.4372E+01_JPRB/)  
KBO( :,54,14) = (/&
 & 3.1900E+01_JPRB,3.1278E+01_JPRB,3.1648E+01_JPRB,3.2670E+01_JPRB,3.4089E+01_JPRB/)  
KBO( :,55,14) = (/&
 & 3.2210E+01_JPRB,3.1399E+01_JPRB,3.1421E+01_JPRB,3.2230E+01_JPRB,3.3508E+01_JPRB/)  
KBO( :,56,14) = (/&
 & 3.2550E+01_JPRB,3.1633E+01_JPRB,3.1312E+01_JPRB,3.1877E+01_JPRB,3.2983E+01_JPRB/)  
KBO( :,57,14) = (/&
 & 3.2910E+01_JPRB,3.1902E+01_JPRB,3.1284E+01_JPRB,3.1616E+01_JPRB,3.2534E+01_JPRB/)  
KBO( :,58,14) = (/&
 & 3.3271E+01_JPRB,3.2188E+01_JPRB,3.1382E+01_JPRB,3.1393E+01_JPRB,3.2095E+01_JPRB/)  
KBO( :,59,14) = (/&
 & 3.3433E+01_JPRB,3.2317E+01_JPRB,3.1456E+01_JPRB,3.1063E+01_JPRB,3.1513E+01_JPRB/)  
KBO( :, 7,15) = (/&
 & 2.8363E+02_JPRB,4.1355E+02_JPRB,5.7180E+02_JPRB,7.5690E+02_JPRB,9.6654E+02_JPRB/)  
KBO( :, 8,15) = (/&
 & 7.4865E+01_JPRB,1.1268E+02_JPRB,1.5979E+02_JPRB,2.1605E+02_JPRB,2.8202E+02_JPRB/)  
KBO( :, 9,15) = (/&
 & 1.4273E+01_JPRB,1.7483E+01_JPRB,2.3317E+01_JPRB,3.2081E+01_JPRB,4.4022E+01_JPRB/)  
KBO( :,10,15) = (/&
 & 1.0822E+01_JPRB,1.0897E+01_JPRB,1.0977E+01_JPRB,1.1194E+01_JPRB,1.5009E+01_JPRB/)  
KBO( :,11,15) = (/&
 & 8.8651E+00_JPRB,8.9560E+00_JPRB,9.0304E+00_JPRB,9.2295E+00_JPRB,1.2083E+01_JPRB/)  
KBO( :,12,15) = (/&
 & 8.4071E+00_JPRB,8.4990E+00_JPRB,8.5668E+00_JPRB,8.7783E+00_JPRB,1.1395E+01_JPRB/)  
KBO( :,13,15) = (/&
 & 7.8874E+00_JPRB,8.0981E+00_JPRB,8.3286E+00_JPRB,8.6740E+00_JPRB,1.0797E+01_JPRB/)  
KBO( :,14,15) = (/&
 & 9.0700E+00_JPRB,9.4397E+00_JPRB,9.7504E+00_JPRB,1.0023E+01_JPRB,1.0663E+01_JPRB/)  
KBO( :,15,15) = (/&
 & 1.0836E+01_JPRB,1.1231E+01_JPRB,1.1580E+01_JPRB,1.1881E+01_JPRB,1.2185E+01_JPRB/)  
KBO( :,16,15) = (/&
 & 1.2867E+01_JPRB,1.3302E+01_JPRB,1.3683E+01_JPRB,1.4016E+01_JPRB,1.4292E+01_JPRB/)  
KBO( :,17,15) = (/&
 & 1.5179E+01_JPRB,1.5649E+01_JPRB,1.6067E+01_JPRB,1.6423E+01_JPRB,1.6719E+01_JPRB/)  
KBO( :,18,15) = (/&
 & 1.7779E+01_JPRB,1.8278E+01_JPRB,1.8717E+01_JPRB,1.9093E+01_JPRB,1.9383E+01_JPRB/)  
KBO( :,19,15) = (/&
 & 2.0642E+01_JPRB,2.1170E+01_JPRB,2.1612E+01_JPRB,2.1976E+01_JPRB,2.2234E+01_JPRB/)  
KBO( :,20,15) = (/&
 & 2.3750E+01_JPRB,2.4283E+01_JPRB,2.4723E+01_JPRB,2.5032E+01_JPRB,2.5262E+01_JPRB/)  
KBO( :,21,15) = (/&
 & 2.7026E+01_JPRB,2.7553E+01_JPRB,2.7924E+01_JPRB,2.8192E+01_JPRB,2.8376E+01_JPRB/)  
KBO( :,22,15) = (/&
 & 3.0466E+01_JPRB,3.0907E+01_JPRB,3.1208E+01_JPRB,3.1413E+01_JPRB,3.1533E+01_JPRB/)  
KBO( :,23,15) = (/&
 & 3.3884E+01_JPRB,3.4236E+01_JPRB,3.4483E+01_JPRB,3.4605E+01_JPRB,3.4634E+01_JPRB/)  
KBO( :,24,15) = (/&
 & 3.7294E+01_JPRB,3.7565E+01_JPRB,3.7709E+01_JPRB,3.7756E+01_JPRB,3.7674E+01_JPRB/)  
KBO( :,25,15) = (/&
 & 4.0647E+01_JPRB,4.0822E+01_JPRB,4.0862E+01_JPRB,4.0770E+01_JPRB,4.0545E+01_JPRB/)  
KBO( :,26,15) = (/&
 & 4.3918E+01_JPRB,4.3923E+01_JPRB,4.3794E+01_JPRB,4.3551E+01_JPRB,4.3172E+01_JPRB/)  
KBO( :,27,15) = (/&
 & 4.6948E+01_JPRB,4.6779E+01_JPRB,4.6473E+01_JPRB,4.6062E+01_JPRB,4.5548E+01_JPRB/)  
KBO( :,28,15) = (/&
 & 4.9671E+01_JPRB,4.9327E+01_JPRB,4.8876E+01_JPRB,4.8297E+01_JPRB,4.7637E+01_JPRB/)  
KBO( :,29,15) = (/&
 & 5.2077E+01_JPRB,5.1573E+01_JPRB,5.0947E+01_JPRB,5.0200E+01_JPRB,4.9391E+01_JPRB/)  
KBO( :,30,15) = (/&
 & 5.4175E+01_JPRB,5.3476E+01_JPRB,5.2686E+01_JPRB,5.1783E+01_JPRB,5.0979E+01_JPRB/)  
KBO( :,31,15) = (/&
 & 5.5918E+01_JPRB,5.5055E+01_JPRB,5.4106E+01_JPRB,5.3112E+01_JPRB,5.2750E+01_JPRB/)  
KBO( :,32,15) = (/&
 & 5.7323E+01_JPRB,5.6310E+01_JPRB,5.5227E+01_JPRB,5.4570E+01_JPRB,5.5133E+01_JPRB/)  
KBO( :,33,15) = (/&
 & 5.8423E+01_JPRB,5.7290E+01_JPRB,5.6381E+01_JPRB,5.6660E+01_JPRB,5.8115E+01_JPRB/)  
KBO( :,34,15) = (/&
 & 5.9305E+01_JPRB,5.8151E+01_JPRB,5.7902E+01_JPRB,5.9181E+01_JPRB,6.1024E+01_JPRB/)  
KBO( :,35,15) = (/&
 & 6.0090E+01_JPRB,5.9220E+01_JPRB,5.9907E+01_JPRB,6.1721E+01_JPRB,6.3818E+01_JPRB/)  
KBO( :,36,15) = (/&
 & 6.0898E+01_JPRB,6.0514E+01_JPRB,6.1931E+01_JPRB,6.4064E+01_JPRB,6.6503E+01_JPRB/)  
KBO( :,37,15) = (/&
 & 6.1807E+01_JPRB,6.1684E+01_JPRB,6.3418E+01_JPRB,6.5762E+01_JPRB,6.8620E+01_JPRB/)  
KBO( :,38,15) = (/&
 & 6.2675E+01_JPRB,6.2924E+01_JPRB,6.5022E+01_JPRB,6.7556E+01_JPRB,7.1076E+01_JPRB/)  
KBO( :,39,15) = (/&
 & 6.3549E+01_JPRB,6.4372E+01_JPRB,6.6780E+01_JPRB,6.9607E+01_JPRB,7.4223E+01_JPRB/)  
KBO( :,40,15) = (/&
 & 6.4290E+01_JPRB,6.5073E+01_JPRB,6.7567E+01_JPRB,7.0533E+01_JPRB,7.5366E+01_JPRB/)  
KBO( :,41,15) = (/&
 & 6.4963E+01_JPRB,6.5642E+01_JPRB,6.8216E+01_JPRB,7.1296E+01_JPRB,7.6285E+01_JPRB/)  
KBO( :,42,15) = (/&
 & 6.5588E+01_JPRB,6.6218E+01_JPRB,6.8898E+01_JPRB,7.2126E+01_JPRB,7.7367E+01_JPRB/)  
KBO( :,43,15) = (/&
 & 6.6237E+01_JPRB,6.6662E+01_JPRB,6.9435E+01_JPRB,7.2789E+01_JPRB,7.8130E+01_JPRB/)  
KBO( :,44,15) = (/&
 & 6.6904E+01_JPRB,6.7116E+01_JPRB,6.9940E+01_JPRB,7.3441E+01_JPRB,7.8892E+01_JPRB/)  
KBO( :,45,15) = (/&
 & 6.7540E+01_JPRB,6.7647E+01_JPRB,7.0523E+01_JPRB,7.4251E+01_JPRB,7.9999E+01_JPRB/)  
KBO( :,46,15) = (/&
 & 6.8229E+01_JPRB,6.8156E+01_JPRB,7.1033E+01_JPRB,7.4993E+01_JPRB,8.1031E+01_JPRB/)  
KBO( :,47,15) = (/&
 & 6.8961E+01_JPRB,6.8535E+01_JPRB,7.1211E+01_JPRB,7.5329E+01_JPRB,8.1268E+01_JPRB/)  
KBO( :,48,15) = (/&
 & 6.9704E+01_JPRB,6.8995E+01_JPRB,7.1616E+01_JPRB,7.5892E+01_JPRB,8.1953E+01_JPRB/)  
KBO( :,49,15) = (/&
 & 7.0407E+01_JPRB,6.9549E+01_JPRB,7.2228E+01_JPRB,7.6829E+01_JPRB,8.3431E+01_JPRB/)  
KBO( :,50,15) = (/&
 & 7.1019E+01_JPRB,6.9986E+01_JPRB,7.2345E+01_JPRB,7.7143E+01_JPRB,8.3800E+01_JPRB/)  
KBO( :,51,15) = (/&
 & 7.1592E+01_JPRB,7.0396E+01_JPRB,7.2261E+01_JPRB,7.7126E+01_JPRB,8.3618E+01_JPRB/)  
KBO( :,52,15) = (/&
 & 7.2111E+01_JPRB,7.0874E+01_JPRB,7.2332E+01_JPRB,7.7310E+01_JPRB,8.3944E+01_JPRB/)  
KBO( :,53,15) = (/&
 & 7.2640E+01_JPRB,7.1374E+01_JPRB,7.2614E+01_JPRB,7.7805E+01_JPRB,8.4912E+01_JPRB/)  
KBO( :,54,15) = (/&
 & 7.3148E+01_JPRB,7.1814E+01_JPRB,7.2024E+01_JPRB,7.6722E+01_JPRB,8.3248E+01_JPRB/)  
KBO( :,55,15) = (/&
 & 7.3606E+01_JPRB,7.2253E+01_JPRB,7.1500E+01_JPRB,7.4839E+01_JPRB,8.0825E+01_JPRB/)  
KBO( :,56,15) = (/&
 & 7.4051E+01_JPRB,7.2698E+01_JPRB,7.1487E+01_JPRB,7.3230E+01_JPRB,7.8699E+01_JPRB/)  
KBO( :,57,15) = (/&
 & 7.4472E+01_JPRB,7.3171E+01_JPRB,7.1839E+01_JPRB,7.2012E+01_JPRB,7.6638E+01_JPRB/)  
KBO( :,58,15) = (/&
 & 7.4894E+01_JPRB,7.3601E+01_JPRB,7.2242E+01_JPRB,7.1442E+01_JPRB,7.4559E+01_JPRB/)  
KBO( :,59,15) = (/&
 & 7.5080E+01_JPRB,7.3786E+01_JPRB,7.2416E+01_JPRB,7.1080E+01_JPRB,7.1531E+01_JPRB/)  
KBO( :, 7,16) = (/&
 & 3.8856E+02_JPRB,5.7915E+02_JPRB,8.1817E+02_JPRB,1.1061E+03_JPRB,1.4420E+03_JPRB/)  
KBO( :, 8,16) = (/&
 & 1.1173E+02_JPRB,1.7284E+02_JPRB,2.5169E+02_JPRB,3.4886E+02_JPRB,4.6421E+02_JPRB/)  
KBO( :, 9,16) = (/&
 & 1.6570E+01_JPRB,2.6651E+01_JPRB,4.0077E+01_JPRB,5.7028E+01_JPRB,7.7570E+01_JPRB/)  
KBO( :,10,16) = (/&
 & 1.1513E+01_JPRB,1.1599E+01_JPRB,1.1623E+01_JPRB,1.2273E+01_JPRB,2.0793E+01_JPRB/)  
KBO( :,11,16) = (/&
 & 9.4745E+00_JPRB,9.5365E+00_JPRB,9.5728E+00_JPRB,1.0446E+01_JPRB,1.7579E+01_JPRB/)  
KBO( :,12,16) = (/&
 & 9.0416E+00_JPRB,9.1073E+00_JPRB,9.1539E+00_JPRB,1.0349E+01_JPRB,1.7350E+01_JPRB/)  
KBO( :,13,16) = (/&
 & 8.4084E+00_JPRB,8.5999E+00_JPRB,8.8332E+00_JPRB,1.0153E+01_JPRB,1.6939E+01_JPRB/)  
KBO( :,14,16) = (/&
 & 1.0079E+01_JPRB,1.0411E+01_JPRB,1.0702E+01_JPRB,1.0966E+01_JPRB,1.3320E+01_JPRB/)  
KBO( :,15,16) = (/&
 & 1.2199E+01_JPRB,1.2610E+01_JPRB,1.2964E+01_JPRB,1.3286E+01_JPRB,1.3632E+01_JPRB/)  
KBO( :,16,16) = (/&
 & 1.4758E+01_JPRB,1.5257E+01_JPRB,1.5682E+01_JPRB,1.6062E+01_JPRB,1.6458E+01_JPRB/)  
KBO( :,17,16) = (/&
 & 1.7830E+01_JPRB,1.8419E+01_JPRB,1.8910E+01_JPRB,1.9353E+01_JPRB,1.9779E+01_JPRB/)  
KBO( :,18,16) = (/&
 & 2.1465E+01_JPRB,2.2139E+01_JPRB,2.2704E+01_JPRB,2.3183E+01_JPRB,2.3616E+01_JPRB/)  
KBO( :,19,16) = (/&
 & 2.5737E+01_JPRB,2.6464E+01_JPRB,2.7066E+01_JPRB,2.7553E+01_JPRB,2.7959E+01_JPRB/)  
KBO( :,20,16) = (/&
 & 3.0665E+01_JPRB,3.1418E+01_JPRB,3.2018E+01_JPRB,3.2468E+01_JPRB,3.2800E+01_JPRB/)  
KBO( :,21,16) = (/&
 & 3.6239E+01_JPRB,3.6953E+01_JPRB,3.7470E+01_JPRB,3.7836E+01_JPRB,3.8047E+01_JPRB/)  
KBO( :,22,16) = (/&
 & 4.2431E+01_JPRB,4.3003E+01_JPRB,4.3369E+01_JPRB,4.3556E+01_JPRB,4.3562E+01_JPRB/)  
KBO( :,23,16) = (/&
 & 4.9017E+01_JPRB,4.9364E+01_JPRB,4.9493E+01_JPRB,4.9449E+01_JPRB,4.9166E+01_JPRB/)  
KBO( :,24,16) = (/&
 & 5.5807E+01_JPRB,5.5827E+01_JPRB,5.5659E+01_JPRB,5.5279E+01_JPRB,5.4693E+01_JPRB/)  
KBO( :,25,16) = (/&
 & 6.2605E+01_JPRB,6.2250E+01_JPRB,6.1658E+01_JPRB,6.0879E+01_JPRB,5.9925E+01_JPRB/)  
KBO( :,26,16) = (/&
 & 6.9126E+01_JPRB,6.8329E+01_JPRB,6.7305E+01_JPRB,6.6047E+01_JPRB,6.4706E+01_JPRB/)  
KBO( :,27,16) = (/&
 & 7.5229E+01_JPRB,7.3889E+01_JPRB,7.2393E+01_JPRB,7.0704E+01_JPRB,6.8940E+01_JPRB/)  
KBO( :,28,16) = (/&
 & 8.0701E+01_JPRB,7.8841E+01_JPRB,7.6868E+01_JPRB,7.4764E+01_JPRB,7.2600E+01_JPRB/)  
KBO( :,29,16) = (/&
 & 8.5434E+01_JPRB,8.3106E+01_JPRB,8.0668E+01_JPRB,7.8169E+01_JPRB,7.5668E+01_JPRB/)  
KBO( :,30,16) = (/&
 & 8.9445E+01_JPRB,8.6639E+01_JPRB,8.3811E+01_JPRB,8.0953E+01_JPRB,7.8147E+01_JPRB/)  
KBO( :,31,16) = (/&
 & 9.2661E+01_JPRB,8.9490E+01_JPRB,8.6283E+01_JPRB,8.3138E+01_JPRB,8.0087E+01_JPRB/)  
KBO( :,32,16) = (/&
 & 9.5180E+01_JPRB,9.1672E+01_JPRB,8.8175E+01_JPRB,8.4788E+01_JPRB,8.1658E+01_JPRB/)  
KBO( :,33,16) = (/&
 & 9.7060E+01_JPRB,9.3296E+01_JPRB,8.9535E+01_JPRB,8.5975E+01_JPRB,8.6733E+01_JPRB/)  
KBO( :,34,16) = (/&
 & 9.8535E+01_JPRB,9.4543E+01_JPRB,9.0580E+01_JPRB,8.8544E+01_JPRB,9.8376E+01_JPRB/)  
KBO( :,35,16) = (/&
 & 9.9986E+01_JPRB,9.5782E+01_JPRB,9.1765E+01_JPRB,9.5678E+01_JPRB,1.1682E+02_JPRB/)  
KBO( :,36,16) = (/&
 & 1.0154E+02_JPRB,9.7161E+01_JPRB,9.4575E+01_JPRB,1.0592E+02_JPRB,1.3789E+02_JPRB/)  
KBO( :,37,16) = (/&
 & 1.0353E+02_JPRB,9.8977E+01_JPRB,9.7885E+01_JPRB,1.1385E+02_JPRB,1.5187E+02_JPRB/)  
KBO( :,38,16) = (/&
 & 1.0537E+02_JPRB,1.0066E+02_JPRB,1.0193E+02_JPRB,1.2434E+02_JPRB,1.6894E+02_JPRB/)  
KBO( :,39,16) = (/&
 & 1.0709E+02_JPRB,1.0226E+02_JPRB,1.0840E+02_JPRB,1.3970E+02_JPRB,1.9203E+02_JPRB/)  
KBO( :,40,16) = (/&
 & 1.0920E+02_JPRB,1.0414E+02_JPRB,1.1026E+02_JPRB,1.4309E+02_JPRB,1.9842E+02_JPRB/)  
KBO( :,41,16) = (/&
 & 1.1129E+02_JPRB,1.0602E+02_JPRB,1.1150E+02_JPRB,1.4497E+02_JPRB,2.0309E+02_JPRB/)  
KBO( :,42,16) = (/&
 & 1.1332E+02_JPRB,1.0786E+02_JPRB,1.1308E+02_JPRB,1.4794E+02_JPRB,2.0952E+02_JPRB/)  
KBO( :,43,16) = (/&
 & 1.1559E+02_JPRB,1.1003E+02_JPRB,1.1380E+02_JPRB,1.4865E+02_JPRB,2.1325E+02_JPRB/)  
KBO( :,44,16) = (/&
 & 1.1806E+02_JPRB,1.1228E+02_JPRB,1.1464E+02_JPRB,1.4922E+02_JPRB,2.1715E+02_JPRB/)  
KBO( :,45,16) = (/&
 & 1.2053E+02_JPRB,1.1454E+02_JPRB,1.1628E+02_JPRB,1.5180E+02_JPRB,2.2438E+02_JPRB/)  
KBO( :,46,16) = (/&
 & 1.2309E+02_JPRB,1.1696E+02_JPRB,1.1783E+02_JPRB,1.5362E+02_JPRB,2.3111E+02_JPRB/)  
KBO( :,47,16) = (/&
 & 1.2599E+02_JPRB,1.1969E+02_JPRB,1.1823E+02_JPRB,1.5084E+02_JPRB,2.3026E+02_JPRB/)  
KBO( :,48,16) = (/&
 & 1.2892E+02_JPRB,1.2242E+02_JPRB,1.1952E+02_JPRB,1.5067E+02_JPRB,2.3396E+02_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB8:PART7',1,ZHOOK_HANDLE)
END SUBROUTINE PART7


SUBROUTINE PART8

REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('RRTM_KGB8:PART8',0,ZHOOK_HANDLE)


KBO( :,49,16) = (/&
 & 1.3193E+02_JPRB,1.2519E+02_JPRB,1.2177E+02_JPRB,1.5425E+02_JPRB,2.4535E+02_JPRB/)  
KBO( :,50,16) = (/&
 & 1.3498E+02_JPRB,1.2786E+02_JPRB,1.2310E+02_JPRB,1.5233E+02_JPRB,2.4573E+02_JPRB/)  
KBO( :,51,16) = (/&
 & 1.3812E+02_JPRB,1.3051E+02_JPRB,1.2450E+02_JPRB,1.4796E+02_JPRB,2.3986E+02_JPRB/)  
KBO( :,52,16) = (/&
 & 1.4129E+02_JPRB,1.3328E+02_JPRB,1.2643E+02_JPRB,1.4628E+02_JPRB,2.3868E+02_JPRB/)  
KBO( :,53,16) = (/&
 & 1.4456E+02_JPRB,1.3621E+02_JPRB,1.2885E+02_JPRB,1.4756E+02_JPRB,2.4494E+02_JPRB/)  
KBO( :,54,16) = (/&
 & 1.4765E+02_JPRB,1.3898E+02_JPRB,1.3126E+02_JPRB,1.3886E+02_JPRB,2.1886E+02_JPRB/)  
KBO( :,55,16) = (/&
 & 1.5067E+02_JPRB,1.4175E+02_JPRB,1.3370E+02_JPRB,1.3097E+02_JPRB,1.8055E+02_JPRB/)  
KBO( :,56,16) = (/&
 & 1.5379E+02_JPRB,1.4459E+02_JPRB,1.3623E+02_JPRB,1.2922E+02_JPRB,1.5393E+02_JPRB/)  
KBO( :,57,16) = (/&
 & 1.5705E+02_JPRB,1.4750E+02_JPRB,1.3886E+02_JPRB,1.3117E+02_JPRB,1.3814E+02_JPRB/)  
KBO( :,58,16) = (/&
 & 1.6030E+02_JPRB,1.5034E+02_JPRB,1.4144E+02_JPRB,1.3342E+02_JPRB,1.3000E+02_JPRB/)  
KBO( :,59,16) = (/&
 & 1.6165E+02_JPRB,1.5155E+02_JPRB,1.4250E+02_JPRB,1.3439E+02_JPRB,1.2723E+02_JPRB/)  

!       SELFREFO is the array for the self-continuum.

SELFREFO( :, 1) = (/&
 & 3.15710E-02_JPRB, 2.74495E-02_JPRB, 2.38660E-02_JPRB, 2.07504E-02_JPRB, 1.80415E-02_JPRB,&
 & 1.56862E-02_JPRB, 1.36384E-02_JPRB, 1.18580E-02_JPRB, 1.03099E-02_JPRB, 8.96400E-03_JPRB/)  
SELFREFO( :, 2) = (/&
 & 3.10782E-02_JPRB, 2.71526E-02_JPRB, 2.37228E-02_JPRB, 2.07262E-02_JPRB, 1.81082E-02_JPRB,&
 & 1.58209E-02_JPRB, 1.38224E-02_JPRB, 1.20765E-02_JPRB, 1.05510E-02_JPRB, 9.21827E-03_JPRB/)  
SELFREFO( :, 3) = (/&
 & 3.08052E-02_JPRB, 2.68989E-02_JPRB, 2.34880E-02_JPRB, 2.05096E-02_JPRB, 1.79089E-02_JPRB,&
 & 1.56380E-02_JPRB, 1.36550E-02_JPRB, 1.19235E-02_JPRB, 1.04116E-02_JPRB, 9.09133E-03_JPRB/)  
SELFREFO( :, 4) = (/&
 & 3.02590E-02_JPRB, 2.64547E-02_JPRB, 2.31287E-02_JPRB, 2.02209E-02_JPRB, 1.76786E-02_JPRB,&
 & 1.54560E-02_JPRB, 1.35128E-02_JPRB, 1.18139E-02_JPRB, 1.03286E-02_JPRB, 9.03003E-03_JPRB/)  
SELFREFO( :, 5) = (/&
 & 2.98458E-02_JPRB, 2.61601E-02_JPRB, 2.29295E-02_JPRB, 2.00978E-02_JPRB, 1.76159E-02_JPRB,&
 & 1.54404E-02_JPRB, 1.35336E-02_JPRB, 1.18623E-02_JPRB, 1.03974E-02_JPRB, 9.11337E-03_JPRB/)  
SELFREFO( :, 6) = (/&
 & 2.95965E-02_JPRB, 2.59395E-02_JPRB, 2.27343E-02_JPRB, 1.99252E-02_JPRB, 1.74632E-02_JPRB,&
 & 1.53054E-02_JPRB, 1.34142E-02_JPRB, 1.17567E-02_JPRB, 1.03040E-02_JPRB, 9.03083E-03_JPRB/)  
SELFREFO( :, 7) = (/&
 & 2.97590E-02_JPRB, 2.60522E-02_JPRB, 2.28071E-02_JPRB, 1.99662E-02_JPRB, 1.74792E-02_JPRB,&
 & 1.53020E-02_JPRB, 1.33959E-02_JPRB, 1.17273E-02_JPRB, 1.02665E-02_JPRB, 8.98772E-03_JPRB/)  
SELFREFO( :, 8) = (/&
 & 2.96582E-02_JPRB, 2.59789E-02_JPRB, 2.27560E-02_JPRB, 1.99330E-02_JPRB, 1.74602E-02_JPRB,&
 & 1.52941E-02_JPRB, 1.33968E-02_JPRB, 1.17348E-02_JPRB, 1.02790E-02_JPRB, 9.00382E-03_JPRB/)  
SELFREFO( :, 9) = (/&
 & 2.97945E-02_JPRB, 2.60711E-02_JPRB, 2.28129E-02_JPRB, 1.99620E-02_JPRB, 1.74673E-02_JPRB,&
 & 1.52844E-02_JPRB, 1.33743E-02_JPRB, 1.17029E-02_JPRB, 1.02404E-02_JPRB, 8.96062E-03_JPRB/)  
SELFREFO( :,10) = (/&
 & 2.97731E-02_JPRB, 2.60436E-02_JPRB, 2.27813E-02_JPRB, 1.99276E-02_JPRB, 1.74314E-02_JPRB,&
 & 1.52478E-02_JPRB, 1.33378E-02_JPRB, 1.16671E-02_JPRB, 1.02056E-02_JPRB, 8.92719E-03_JPRB/)  
SELFREFO( :,11) = (/&
 & 2.94084E-02_JPRB, 2.57680E-02_JPRB, 2.25782E-02_JPRB, 1.97832E-02_JPRB, 1.73343E-02_JPRB,&
 & 1.51885E-02_JPRB, 1.33083E-02_JPRB, 1.16609E-02_JPRB, 1.02174E-02_JPRB, 8.95261E-03_JPRB/)  
SELFREFO( :,12) = (/&
 & 2.97023E-02_JPRB, 2.60117E-02_JPRB, 2.27796E-02_JPRB, 1.99491E-02_JPRB, 1.74703E-02_JPRB,&
 & 1.52996E-02_JPRB, 1.33985E-02_JPRB, 1.17337E-02_JPRB, 1.02757E-02_JPRB, 8.99890E-03_JPRB/)  
SELFREFO( :,13) = (/&
 & 2.96542E-02_JPRB, 2.59249E-02_JPRB, 2.26645E-02_JPRB, 1.98142E-02_JPRB, 1.73223E-02_JPRB,&
 & 1.51438E-02_JPRB, 1.32393E-02_JPRB, 1.15743E-02_JPRB, 1.01187E-02_JPRB, 8.84612E-03_JPRB/)  
SELFREFO( :,14) = (/&
 & 2.89971E-02_JPRB, 2.53964E-02_JPRB, 2.22429E-02_JPRB, 1.94809E-02_JPRB, 1.70619E-02_JPRB,&
 & 1.49433E-02_JPRB, 1.30877E-02_JPRB, 1.14626E-02_JPRB, 1.00392E-02_JPRB, 8.79262E-03_JPRB/)  
SELFREFO( :,15) = (/&
 & 2.80866E-02_JPRB, 2.46970E-02_JPRB, 2.17166E-02_JPRB, 1.90958E-02_JPRB, 1.67913E-02_JPRB,&
 & 1.47649E-02_JPRB, 1.29830E-02_JPRB, 1.14162E-02_JPRB, 1.00385E-02_JPRB, 8.82704E-03_JPRB/)  
SELFREFO( :,16) = (/&
 & 2.80866E-02_JPRB, 2.46970E-02_JPRB, 2.17166E-02_JPRB, 1.90958E-02_JPRB, 1.67913E-02_JPRB,&
 & 1.47649E-02_JPRB, 1.29830E-02_JPRB, 1.14162E-02_JPRB, 1.00385E-02_JPRB, 8.82704E-03_JPRB/)  

IF (LHOOK) CALL DR_HOOK('RRTM_KGB8:PART8',1,ZHOOK_HANDLE)
END SUBROUTINE PART8



END SUBROUTINE RRTM_KGB8
