MODULE YOEAERD

USE PARKIND1  ,ONLY : JPIM     ,JPRB

IMPLICIT NONE

SAVE

!     ------------------------------------------------------------------
!*     *YOEAERD* SPECTRAL DISTRIBUTION OF AEROSOLS
!     ------------------------------------------------------------------

REAL(KIND=JPRB),ALLOCATABLE:: CVDAES(:)
REAL(KIND=JPRB),ALLOCATABLE:: CVDAEL(:)
REAL(KIND=JPRB),ALLOCATABLE:: CVDAEU(:)
REAL(KIND=JPRB),ALLOCATABLE:: CVDAED(:)

REAL(KIND=JPRB) :: RAESC(66)
REAL(KIND=JPRB) :: RAESS(55)
REAL(KIND=JPRB) :: RAELC(66)
REAL(KIND=JPRB) :: RAELS(55)
REAL(KIND=JPRB) :: RAEUC(66)
REAL(KIND=JPRB) :: RAEUS(55)
REAL(KIND=JPRB) :: RAEDC(66)
REAL(KIND=JPRB) :: RAEDS(55)

REAL(KIND=JPRB) :: RCAEOPS
REAL(KIND=JPRB) :: RCAEOPL
REAL(KIND=JPRB) :: RCAEOPU
REAL(KIND=JPRB) :: RCAEOPD
REAL(KIND=JPRB) :: RCTRBGA
REAL(KIND=JPRB) :: RCVOBGA
REAL(KIND=JPRB) :: RCSTBGA
REAL(KIND=JPRB) :: RCTRPT
REAL(KIND=JPRB) :: RCAEADK(3)
REAL(KIND=JPRB) :: RCAEADM
REAL(KIND=JPRB) :: RCAEROS

!*     *YOEAERD* SPECTRAL DISTRIBUTION OF AEROSOLS.
!                     (TRIANGULAR *T10* TRUNCATION FOR AEROSOLS).

!     R.G AND M.J        E.C.M.W.F.     29/11/82.
!     J.-J. MORCRETTE    E.C.M.W.F.     92/09/24  Adaptation to IFS

!      NAME     TYPE      PURPOSE
!      ----     ----      -------

!     *CAES_*   REAL      *REFERS TO *SEA AEROSOLS.
!     *CAEL_*   REAL      *REFERS TO *LAND AEROSOLS.
!     *CAEU_*   REAL      *REFERS TO *URBAN AEROSOLS.
!     *CAED_*   REAL      *REFERS TO *DESERT AEROSOLS.
!     *C___C*   REAL      *REFERS TO *COS COMPONENT.
!     *C___S*   REAL      *REFERS TO *SIN COMPONENT.
!     *CAEOP_*  REAL      *CONSTANTS USED FOR AEROSOL COMPUTATIONS.
!     *C___S*   REAL      *REFERS TO *SEA AEROSOLS.
!     *C___L*   REAL      *REFERS TO *LAND AEROSOLS.
!     *C___U*   REAL      *REFERS TO *URBAN AEROSOLS.
!     *C___D*   REAL      *REFERS TO *DESERT AEROSOLS.
!     *C__BGA*  REAL      *CONSTANTS USED FOR AEROSOL COMPUTATIONS.
!     *CVDAE_*  REAL      *CONSTANTS USED FOR AEROSOL COMPUTATIONS.(NFLEVG+1)
!     *RCTRPT*   REAL      *CONSTANTS USED FOR AEROSOL COMPUTATIONS.
!     *RCAEADK*  REAL      *CONSTANTS USED FOR AEROSOL COMPUTATIONS.
!     *RCAEADM*  REAL      *CONSTANTS USED FOR AEROSOL COMPUTATIONS.
!     *RCAEROS*  REAL      *BACKGROUND VALUE IN ABSENCE OF AEROSOLS.

!     ------------------------------------------------------------------

!$OMP THREADPRIVATE(raedc,raeds,raelc,raels,raesc,raess,raeuc,raeus)
!$OMP THREADPRIVATE(rcaeadk,rcaeadm,rcaeopd,rcaeopl,rcaeops,rcaeopu)
!$OMP THREADPRIVATE(rcaeros,rcstbga,rctrbga,rctrpt,rcvobga)

!$OMP THREADPRIVATE(cvdaed,cvdael,cvdaes,cvdaeu)

END MODULE YOEAERD
