!OCL SCALAR
#ifdef RS6K
@PROCESS NOOPTIMIZE
#endif 
SUBROUTINE SRTM_KGB20

!     Originally by J.Delamere, Atmospheric & Environmental Research.
!     Revision: 2.4
!     BAND 20:  5150-6150 cm-1 (low - H2O; high - H2O)
!     Reformatted for F90 by JJMorcrette, ECMWF

!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOESRTA20, ONLY : KA, KB, SELFREF, FORREF, SFLUXREF, RAYL, ABSCH4 &
 & , LAYREFFR  

!     ------------------------------------------------------------------

IMPLICIT NONE

! KURUCZ
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK('SRTM_KGB20',0,ZHOOK_HANDLE)
SFLUXREF = (/ &
 & 9.34081_JPRB , 8.93720_JPRB    , 8.19346_JPRB    , 7.39196_JPRB    , &
 & 6.12127_JPRB , 5.23956_JPRB    , 4.24941_JPRB    , 3.20013_JPRB    , &
 & 2.16047_JPRB , 0.234509_JPRB   , 0.194593_JPRB   , 0.151512_JPRB   , &
 & 0.110315_JPRB, 7.09959E-02_JPRB, 2.70573E-02_JPRB, 3.36042E-03_JPRB /)  
  
ABSCH4 = (/   &
 & 1.01381E-03_JPRB,6.33692E-03_JPRB,1.94185E-02_JPRB,4.83210E-02_JPRB, &
 & 2.36574E-03_JPRB,6.61973E-04_JPRB,5.64552E-04_JPRB,2.83183E-04_JPRB, &
 & 7.43623E-05_JPRB,8.90159E-07_JPRB,6.98728E-07_JPRB,6.51832E-08_JPRB, &
 & 2.96619E-08_JPRB,         0._JPRB,         0._JPRB,         0._JPRB /)  

!     Rayleigh extinction coefficient at v = 5670 cm-1.
RAYL = 4.12E-09_JPRB

LAYREFFR = 3

!     ------------------------------------------------------------------

!     The array KA contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KA(:, 1, 1) = (/ &
 & 0.78383E-06_JPRB,0.86220E-06_JPRB,0.95359E-06_JPRB,0.10590E-05_JPRB,0.11782E-05_JPRB /)  
KA(:, 2, 1) = (/ &
 & 0.65040E-06_JPRB,0.72510E-06_JPRB,0.81318E-06_JPRB,0.90059E-06_JPRB,0.99786E-06_JPRB /)  
KA(:, 3, 1) = (/ &
 & 0.58072E-06_JPRB,0.65888E-06_JPRB,0.74265E-06_JPRB,0.81854E-06_JPRB,0.90645E-06_JPRB /)  
KA(:, 4, 1) = (/ &
 & 0.53601E-06_JPRB,0.60765E-06_JPRB,0.68088E-06_JPRB,0.75741E-06_JPRB,0.83801E-06_JPRB /)  
KA(:, 5, 1) = (/ &
 & 0.50142E-06_JPRB,0.56951E-06_JPRB,0.64028E-06_JPRB,0.71944E-06_JPRB,0.79813E-06_JPRB /)  
KA(:, 6, 1) = (/ &
 & 0.47164E-06_JPRB,0.54008E-06_JPRB,0.61040E-06_JPRB,0.68006E-06_JPRB,0.75034E-06_JPRB /)  
KA(:, 7, 1) = (/ &
 & 0.49337E-06_JPRB,0.56178E-06_JPRB,0.62215E-06_JPRB,0.69127E-06_JPRB,0.76060E-06_JPRB /)  
KA(:, 8, 1) = (/ &
 & 0.61581E-06_JPRB,0.70117E-06_JPRB,0.78942E-06_JPRB,0.87145E-06_JPRB,0.94647E-06_JPRB /)  
KA(:, 9, 1) = (/ &
 & 0.14154E-05_JPRB,0.15754E-05_JPRB,0.17261E-05_JPRB,0.18739E-05_JPRB,0.19774E-05_JPRB /)  
KA(:,10, 1) = (/ &
 & 0.34186E-05_JPRB,0.37012E-05_JPRB,0.39602E-05_JPRB,0.42235E-05_JPRB,0.44256E-05_JPRB /)  
KA(:,11, 1) = (/ &
 & 0.38574E-05_JPRB,0.42080E-05_JPRB,0.44701E-05_JPRB,0.47454E-05_JPRB,0.50002E-05_JPRB /)  
KA(:,12, 1) = (/ &
 & 0.35794E-05_JPRB,0.38686E-05_JPRB,0.41443E-05_JPRB,0.43939E-05_JPRB,0.46500E-05_JPRB /)  
KA(:,13, 1) = (/ &
 & 0.29586E-05_JPRB,0.31938E-05_JPRB,0.34167E-05_JPRB,0.36253E-05_JPRB,0.38250E-05_JPRB /)  
KA(:, 1, 2) = (/ &
 & 0.57098E-05_JPRB,0.64630E-05_JPRB,0.73117E-05_JPRB,0.82436E-05_JPRB,0.91947E-05_JPRB /)  
KA(:, 2, 2) = (/ &
 & 0.46384E-05_JPRB,0.53125E-05_JPRB,0.60301E-05_JPRB,0.68028E-05_JPRB,0.75824E-05_JPRB /)  
KA(:, 3, 2) = (/ &
 & 0.40657E-05_JPRB,0.46486E-05_JPRB,0.52459E-05_JPRB,0.58955E-05_JPRB,0.65546E-05_JPRB /)  
KA(:, 4, 2) = (/ &
 & 0.38895E-05_JPRB,0.44258E-05_JPRB,0.49759E-05_JPRB,0.55663E-05_JPRB,0.61702E-05_JPRB /)  
KA(:, 5, 2) = (/ &
 & 0.38971E-05_JPRB,0.44359E-05_JPRB,0.49933E-05_JPRB,0.55523E-05_JPRB,0.61234E-05_JPRB /)  
KA(:, 6, 2) = (/ &
 & 0.39532E-05_JPRB,0.44644E-05_JPRB,0.49734E-05_JPRB,0.54875E-05_JPRB,0.60102E-05_JPRB /)  
KA(:, 7, 2) = (/ &
 & 0.41068E-05_JPRB,0.45832E-05_JPRB,0.50698E-05_JPRB,0.55521E-05_JPRB,0.60175E-05_JPRB /)  
KA(:, 8, 2) = (/ &
 & 0.47922E-05_JPRB,0.52156E-05_JPRB,0.56817E-05_JPRB,0.61576E-05_JPRB,0.66313E-05_JPRB /)  
KA(:, 9, 2) = (/ &
 & 0.83199E-05_JPRB,0.88317E-05_JPRB,0.93688E-05_JPRB,0.99754E-05_JPRB,0.10620E-04_JPRB /)  
KA(:,10, 2) = (/ &
 & 0.16836E-04_JPRB,0.18526E-04_JPRB,0.19887E-04_JPRB,0.21168E-04_JPRB,0.22104E-04_JPRB /)  
KA(:,11, 2) = (/ &
 & 0.18882E-04_JPRB,0.21005E-04_JPRB,0.22896E-04_JPRB,0.24777E-04_JPRB,0.26115E-04_JPRB /)  
KA(:,12, 2) = (/ &
 & 0.17744E-04_JPRB,0.19780E-04_JPRB,0.21600E-04_JPRB,0.23523E-04_JPRB,0.25128E-04_JPRB /)  
KA(:,13, 2) = (/ &
 & 0.14736E-04_JPRB,0.16356E-04_JPRB,0.17955E-04_JPRB,0.19533E-04_JPRB,0.20861E-04_JPRB /)  
KA(:, 1, 3) = (/ &
 & 0.41776E-04_JPRB,0.48150E-04_JPRB,0.55097E-04_JPRB,0.62661E-04_JPRB,0.70920E-04_JPRB /)  
KA(:, 2, 3) = (/ &
 & 0.33909E-04_JPRB,0.39176E-04_JPRB,0.44622E-04_JPRB,0.50754E-04_JPRB,0.57336E-04_JPRB /)  
KA(:, 3, 3) = (/ &
 & 0.27438E-04_JPRB,0.31473E-04_JPRB,0.36122E-04_JPRB,0.41134E-04_JPRB,0.46456E-04_JPRB /)  
KA(:, 4, 3) = (/ &
 & 0.23222E-04_JPRB,0.26535E-04_JPRB,0.30141E-04_JPRB,0.34099E-04_JPRB,0.38416E-04_JPRB /)  
KA(:, 5, 3) = (/ &
 & 0.21114E-04_JPRB,0.23888E-04_JPRB,0.26883E-04_JPRB,0.30340E-04_JPRB,0.33785E-04_JPRB /)  
KA(:, 6, 3) = (/ &
 & 0.20750E-04_JPRB,0.22926E-04_JPRB,0.25536E-04_JPRB,0.28492E-04_JPRB,0.31676E-04_JPRB /)  
KA(:, 7, 3) = (/ &
 & 0.21584E-04_JPRB,0.24112E-04_JPRB,0.26872E-04_JPRB,0.29794E-04_JPRB,0.32940E-04_JPRB /)  
KA(:, 8, 3) = (/ &
 & 0.24194E-04_JPRB,0.26981E-04_JPRB,0.30137E-04_JPRB,0.33546E-04_JPRB,0.37182E-04_JPRB /)  
KA(:, 9, 3) = (/ &
 & 0.37461E-04_JPRB,0.42158E-04_JPRB,0.46718E-04_JPRB,0.51048E-04_JPRB,0.55154E-04_JPRB /)  
KA(:,10, 3) = (/ &
 & 0.72391E-04_JPRB,0.77164E-04_JPRB,0.84016E-04_JPRB,0.89658E-04_JPRB,0.95511E-04_JPRB /)  
KA(:,11, 3) = (/ &
 & 0.91736E-04_JPRB,0.99107E-04_JPRB,0.10463E-03_JPRB,0.10952E-03_JPRB,0.11549E-03_JPRB /)  
KA(:,12, 3) = (/ &
 & 0.91200E-04_JPRB,0.98812E-04_JPRB,0.10432E-03_JPRB,0.10893E-03_JPRB,0.11349E-03_JPRB /)  
KA(:,13, 3) = (/ &
 & 0.76217E-04_JPRB,0.82702E-04_JPRB,0.87500E-04_JPRB,0.91349E-04_JPRB,0.95349E-04_JPRB /)  
KA(:, 1, 4) = (/ &
 & 0.71705E-03_JPRB,0.82743E-03_JPRB,0.94700E-03_JPRB,0.10670E-02_JPRB,0.11902E-02_JPRB /)  
KA(:, 2, 4) = (/ &
 & 0.57909E-03_JPRB,0.67096E-03_JPRB,0.76724E-03_JPRB,0.86582E-03_JPRB,0.97167E-03_JPRB /)  
KA(:, 3, 4) = (/ &
 & 0.44771E-03_JPRB,0.51997E-03_JPRB,0.59861E-03_JPRB,0.67967E-03_JPRB,0.76676E-03_JPRB /)  
KA(:, 4, 4) = (/ &
 & 0.34085E-03_JPRB,0.39833E-03_JPRB,0.46226E-03_JPRB,0.52889E-03_JPRB,0.60008E-03_JPRB /)  
KA(:, 5, 4) = (/ &
 & 0.26678E-03_JPRB,0.31234E-03_JPRB,0.36341E-03_JPRB,0.41663E-03_JPRB,0.47418E-03_JPRB /)  
KA(:, 6, 4) = (/ &
 & 0.20903E-03_JPRB,0.24718E-03_JPRB,0.28922E-03_JPRB,0.33353E-03_JPRB,0.38176E-03_JPRB /)  
KA(:, 7, 4) = (/ &
 & 0.17173E-03_JPRB,0.20330E-03_JPRB,0.23711E-03_JPRB,0.27401E-03_JPRB,0.31445E-03_JPRB /)  
KA(:, 8, 4) = (/ &
 & 0.16722E-03_JPRB,0.19396E-03_JPRB,0.22307E-03_JPRB,0.25347E-03_JPRB,0.28561E-03_JPRB /)  
KA(:, 9, 4) = (/ &
 & 0.25043E-03_JPRB,0.28824E-03_JPRB,0.32547E-03_JPRB,0.36193E-03_JPRB,0.39806E-03_JPRB /)  
KA(:,10, 4) = (/ &
 & 0.43323E-03_JPRB,0.48667E-03_JPRB,0.53462E-03_JPRB,0.57879E-03_JPRB,0.62040E-03_JPRB /)  
KA(:,11, 4) = (/ &
 & 0.47719E-03_JPRB,0.52271E-03_JPRB,0.56402E-03_JPRB,0.60388E-03_JPRB,0.63520E-03_JPRB /)  
KA(:,12, 4) = (/ &
 & 0.45061E-03_JPRB,0.49014E-03_JPRB,0.52391E-03_JPRB,0.55276E-03_JPRB,0.57760E-03_JPRB /)  
KA(:,13, 4) = (/ &
 & 0.37664E-03_JPRB,0.40952E-03_JPRB,0.43690E-03_JPRB,0.46055E-03_JPRB,0.48018E-03_JPRB /)  
KA(:, 1, 5) = (/ &
 & 0.66466E-02_JPRB,0.68686E-02_JPRB,0.70897E-02_JPRB,0.73019E-02_JPRB,0.74914E-02_JPRB /)  
KA(:, 2, 5) = (/ &
 & 0.54023E-02_JPRB,0.56010E-02_JPRB,0.58008E-02_JPRB,0.59987E-02_JPRB,0.61685E-02_JPRB /)  
KA(:, 3, 5) = (/ &
 & 0.43218E-02_JPRB,0.45127E-02_JPRB,0.46848E-02_JPRB,0.48647E-02_JPRB,0.50267E-02_JPRB /)  
KA(:, 4, 5) = (/ &
 & 0.34639E-02_JPRB,0.36473E-02_JPRB,0.37951E-02_JPRB,0.39570E-02_JPRB,0.41049E-02_JPRB /)  
KA(:, 5, 5) = (/ &
 & 0.27745E-02_JPRB,0.29370E-02_JPRB,0.30754E-02_JPRB,0.32148E-02_JPRB,0.33492E-02_JPRB /)  
KA(:, 6, 5) = (/ &
 & 0.22020E-02_JPRB,0.23520E-02_JPRB,0.24836E-02_JPRB,0.25965E-02_JPRB,0.27119E-02_JPRB /)  
KA(:, 7, 5) = (/ &
 & 0.17624E-02_JPRB,0.18963E-02_JPRB,0.20161E-02_JPRB,0.21153E-02_JPRB,0.22116E-02_JPRB /)  
KA(:, 8, 5) = (/ &
 & 0.14169E-02_JPRB,0.15332E-02_JPRB,0.16350E-02_JPRB,0.17231E-02_JPRB,0.18121E-02_JPRB /)  
KA(:, 9, 5) = (/ &
 & 0.13030E-02_JPRB,0.13904E-02_JPRB,0.14690E-02_JPRB,0.15500E-02_JPRB,0.16275E-02_JPRB /)  
KA(:,10, 5) = (/ &
 & 0.17155E-02_JPRB,0.18169E-02_JPRB,0.18943E-02_JPRB,0.19620E-02_JPRB,0.20215E-02_JPRB /)  
KA(:,11, 5) = (/ &
 & 0.17156E-02_JPRB,0.17808E-02_JPRB,0.18419E-02_JPRB,0.18925E-02_JPRB,0.19313E-02_JPRB /)  
KA(:,12, 5) = (/ &
 & 0.15269E-02_JPRB,0.15811E-02_JPRB,0.16283E-02_JPRB,0.16686E-02_JPRB,0.17061E-02_JPRB /)  
KA(:,13, 5) = (/ &
 & 0.12768E-02_JPRB,0.13207E-02_JPRB,0.13555E-02_JPRB,0.13924E-02_JPRB,0.14234E-02_JPRB /)  
KA(:, 1, 6) = (/ &
 & 0.19191E-01_JPRB,0.19463E-01_JPRB,0.19692E-01_JPRB,0.19900E-01_JPRB,0.20112E-01_JPRB /)  
KA(:, 2, 6) = (/ &
 & 0.15967E-01_JPRB,0.16219E-01_JPRB,0.16426E-01_JPRB,0.16613E-01_JPRB,0.16805E-01_JPRB /)  
KA(:, 3, 6) = (/ &
 & 0.13186E-01_JPRB,0.13411E-01_JPRB,0.13614E-01_JPRB,0.13785E-01_JPRB,0.13944E-01_JPRB /)  
KA(:, 4, 6) = (/ &
 & 0.10935E-01_JPRB,0.11131E-01_JPRB,0.11318E-01_JPRB,0.11475E-01_JPRB,0.11620E-01_JPRB /)  
KA(:, 5, 6) = (/ &
 & 0.90541E-02_JPRB,0.92344E-02_JPRB,0.94035E-02_JPRB,0.95537E-02_JPRB,0.96862E-02_JPRB /)  
KA(:, 6, 6) = (/ &
 & 0.74724E-02_JPRB,0.76320E-02_JPRB,0.77794E-02_JPRB,0.79294E-02_JPRB,0.80528E-02_JPRB /)  
KA(:, 7, 6) = (/ &
 & 0.61183E-02_JPRB,0.62644E-02_JPRB,0.63961E-02_JPRB,0.65303E-02_JPRB,0.66478E-02_JPRB /)  
KA(:, 8, 6) = (/ &
 & 0.50638E-02_JPRB,0.51984E-02_JPRB,0.53222E-02_JPRB,0.54412E-02_JPRB,0.55465E-02_JPRB /)  
KA(:, 9, 6) = (/ &
 & 0.42870E-02_JPRB,0.44009E-02_JPRB,0.45109E-02_JPRB,0.45976E-02_JPRB,0.46796E-02_JPRB /)  
KA(:,10, 6) = (/ &
 & 0.45239E-02_JPRB,0.46073E-02_JPRB,0.46968E-02_JPRB,0.47979E-02_JPRB,0.48956E-02_JPRB /)  
KA(:,11, 6) = (/ &
 & 0.44089E-02_JPRB,0.45006E-02_JPRB,0.45881E-02_JPRB,0.46721E-02_JPRB,0.48015E-02_JPRB /)  
KA(:,12, 6) = (/ &
 & 0.39598E-02_JPRB,0.40290E-02_JPRB,0.41108E-02_JPRB,0.41899E-02_JPRB,0.42672E-02_JPRB /)  
KA(:,13, 6) = (/ &
 & 0.33425E-02_JPRB,0.34148E-02_JPRB,0.34808E-02_JPRB,0.35405E-02_JPRB,0.35983E-02_JPRB /)  
KA(:, 1, 7) = (/ &
 & 0.50165E-01_JPRB,0.50343E-01_JPRB,0.50452E-01_JPRB,0.50424E-01_JPRB,0.50329E-01_JPRB /)  
KA(:, 2, 7) = (/ &
 & 0.42723E-01_JPRB,0.42880E-01_JPRB,0.42939E-01_JPRB,0.42910E-01_JPRB,0.42861E-01_JPRB /)  
KA(:, 3, 7) = (/ &
 & 0.36117E-01_JPRB,0.36255E-01_JPRB,0.36301E-01_JPRB,0.36294E-01_JPRB,0.36288E-01_JPRB /)  
KA(:, 4, 7) = (/ &
 & 0.30585E-01_JPRB,0.30720E-01_JPRB,0.30787E-01_JPRB,0.30816E-01_JPRB,0.30842E-01_JPRB /)  
KA(:, 5, 7) = (/ &
 & 0.25879E-01_JPRB,0.26029E-01_JPRB,0.26116E-01_JPRB,0.26179E-01_JPRB,0.26225E-01_JPRB /)  
KA(:, 6, 7) = (/ &
 & 0.21822E-01_JPRB,0.21978E-01_JPRB,0.22094E-01_JPRB,0.22178E-01_JPRB,0.22244E-01_JPRB /)  
KA(:, 7, 7) = (/ &
 & 0.18304E-01_JPRB,0.18476E-01_JPRB,0.18606E-01_JPRB,0.18705E-01_JPRB,0.18780E-01_JPRB /)  
KA(:, 8, 7) = (/ &
 & 0.15224E-01_JPRB,0.15394E-01_JPRB,0.15519E-01_JPRB,0.15619E-01_JPRB,0.15690E-01_JPRB /)  
KA(:, 9, 7) = (/ &
 & 0.12835E-01_JPRB,0.13029E-01_JPRB,0.13169E-01_JPRB,0.13281E-01_JPRB,0.13369E-01_JPRB /)  
KA(:,10, 7) = (/ &
 & 0.11632E-01_JPRB,0.11714E-01_JPRB,0.11760E-01_JPRB,0.11776E-01_JPRB,0.11806E-01_JPRB /)  
KA(:,11, 7) = (/ &
 & 0.11170E-01_JPRB,0.11252E-01_JPRB,0.11288E-01_JPRB,0.11357E-01_JPRB,0.11397E-01_JPRB /)  
KA(:,12, 7) = (/ &
 & 0.10404E-01_JPRB,0.10533E-01_JPRB,0.10705E-01_JPRB,0.10833E-01_JPRB,0.10947E-01_JPRB /)  
KA(:,13, 7) = (/ &
 & 0.91041E-02_JPRB,0.92674E-02_JPRB,0.94068E-02_JPRB,0.95412E-02_JPRB,0.96769E-02_JPRB /)  
KA(:, 1, 8) = (/ &
 & 0.14527E+00_JPRB,0.14483E+00_JPRB,0.14432E+00_JPRB,0.14389E+00_JPRB,0.14349E+00_JPRB /)  
KA(:, 2, 8) = (/ &
 & 0.12739E+00_JPRB,0.12702E+00_JPRB,0.12661E+00_JPRB,0.12624E+00_JPRB,0.12584E+00_JPRB /)  
KA(:, 3, 8) = (/ &
 & 0.11091E+00_JPRB,0.11058E+00_JPRB,0.11024E+00_JPRB,0.10990E+00_JPRB,0.10953E+00_JPRB /)  
KA(:, 4, 8) = (/ &
 & 0.96590E-01_JPRB,0.96335E-01_JPRB,0.96105E-01_JPRB,0.95818E-01_JPRB,0.95530E-01_JPRB /)  
KA(:, 5, 8) = (/ &
 & 0.83799E-01_JPRB,0.83708E-01_JPRB,0.83572E-01_JPRB,0.83347E-01_JPRB,0.83126E-01_JPRB /)  
KA(:, 6, 8) = (/ &
 & 0.72369E-01_JPRB,0.72388E-01_JPRB,0.72289E-01_JPRB,0.72143E-01_JPRB,0.71981E-01_JPRB /)  
KA(:, 7, 8) = (/ &
 & 0.62158E-01_JPRB,0.62247E-01_JPRB,0.62185E-01_JPRB,0.62111E-01_JPRB,0.62007E-01_JPRB /)  
KA(:, 8, 8) = (/ &
 & 0.52998E-01_JPRB,0.53142E-01_JPRB,0.53162E-01_JPRB,0.53154E-01_JPRB,0.53101E-01_JPRB /)  
KA(:, 9, 8) = (/ &
 & 0.44776E-01_JPRB,0.44873E-01_JPRB,0.44920E-01_JPRB,0.44946E-01_JPRB,0.44885E-01_JPRB /)  
KA(:,10, 8) = (/ &
 & 0.38237E-01_JPRB,0.38514E-01_JPRB,0.38716E-01_JPRB,0.38877E-01_JPRB,0.38966E-01_JPRB /)  
KA(:,11, 8) = (/ &
 & 0.33511E-01_JPRB,0.33721E-01_JPRB,0.33843E-01_JPRB,0.33840E-01_JPRB,0.33839E-01_JPRB /)  
KA(:,12, 8) = (/ &
 & 0.29704E-01_JPRB,0.29825E-01_JPRB,0.29808E-01_JPRB,0.29787E-01_JPRB,0.29794E-01_JPRB /)  
KA(:,13, 8) = (/ &
 & 0.25973E-01_JPRB,0.26004E-01_JPRB,0.26032E-01_JPRB,0.26023E-01_JPRB,0.26107E-01_JPRB /)  
KA(:, 1, 9) = (/ &
 & 0.56699E+00_JPRB,0.56615E+00_JPRB,0.56479E+00_JPRB,0.56318E+00_JPRB,0.56135E+00_JPRB /)  
KA(:, 2, 9) = (/ &
 & 0.53130E+00_JPRB,0.53096E+00_JPRB,0.53038E+00_JPRB,0.52953E+00_JPRB,0.52828E+00_JPRB /)  
KA(:, 3, 9) = (/ &
 & 0.48947E+00_JPRB,0.48989E+00_JPRB,0.48991E+00_JPRB,0.48970E+00_JPRB,0.48916E+00_JPRB /)  
KA(:, 4, 9) = (/ &
 & 0.44646E+00_JPRB,0.44756E+00_JPRB,0.44841E+00_JPRB,0.44893E+00_JPRB,0.44859E+00_JPRB /)  
KA(:, 5, 9) = (/ &
 & 0.40428E+00_JPRB,0.40594E+00_JPRB,0.40746E+00_JPRB,0.40811E+00_JPRB,0.40825E+00_JPRB /)  
KA(:, 6, 9) = (/ &
 & 0.36305E+00_JPRB,0.36545E+00_JPRB,0.36730E+00_JPRB,0.36814E+00_JPRB,0.36854E+00_JPRB /)  
KA(:, 7, 9) = (/ &
 & 0.32383E+00_JPRB,0.32659E+00_JPRB,0.32849E+00_JPRB,0.32954E+00_JPRB,0.33028E+00_JPRB /)  
KA(:, 8, 9) = (/ &
 & 0.28691E+00_JPRB,0.28966E+00_JPRB,0.29156E+00_JPRB,0.29286E+00_JPRB,0.29379E+00_JPRB /)  
KA(:, 9, 9) = (/ &
 & 0.25109E+00_JPRB,0.25404E+00_JPRB,0.25607E+00_JPRB,0.25752E+00_JPRB,0.25870E+00_JPRB /)  
KA(:,10, 9) = (/ &
 & 0.21600E+00_JPRB,0.21860E+00_JPRB,0.22047E+00_JPRB,0.22164E+00_JPRB,0.22251E+00_JPRB /)  
KA(:,11, 9) = (/ &
 & 0.19149E+00_JPRB,0.19387E+00_JPRB,0.19567E+00_JPRB,0.19725E+00_JPRB,0.19809E+00_JPRB /)  
KA(:,12, 9) = (/ &
 & 0.16914E+00_JPRB,0.17134E+00_JPRB,0.17303E+00_JPRB,0.17407E+00_JPRB,0.17494E+00_JPRB /)  
KA(:,13, 9) = (/ &
 & 0.14841E+00_JPRB,0.15027E+00_JPRB,0.15244E+00_JPRB,0.15403E+00_JPRB,0.15523E+00_JPRB /)  
KA(:, 1,10) = (/ &
 & 0.14885E+01_JPRB,0.14756E+01_JPRB,0.14663E+01_JPRB,0.14567E+01_JPRB,0.14479E+01_JPRB /)  
KA(:, 2,10) = (/ &
 & 0.14911E+01_JPRB,0.14850E+01_JPRB,0.14762E+01_JPRB,0.14677E+01_JPRB,0.14597E+01_JPRB /)  
KA(:, 3,10) = (/ &
 & 0.14749E+01_JPRB,0.14716E+01_JPRB,0.14663E+01_JPRB,0.14579E+01_JPRB,0.14502E+01_JPRB /)  
KA(:, 4,10) = (/ &
 & 0.14314E+01_JPRB,0.14303E+01_JPRB,0.14232E+01_JPRB,0.14150E+01_JPRB,0.14115E+01_JPRB /)  
KA(:, 5,10) = (/ &
 & 0.13616E+01_JPRB,0.13604E+01_JPRB,0.13539E+01_JPRB,0.13506E+01_JPRB,0.13501E+01_JPRB /)  
KA(:, 6,10) = (/ &
 & 0.12710E+01_JPRB,0.12700E+01_JPRB,0.12670E+01_JPRB,0.12702E+01_JPRB,0.12745E+01_JPRB /)  
KA(:, 7,10) = (/ &
 & 0.11674E+01_JPRB,0.11690E+01_JPRB,0.11727E+01_JPRB,0.11812E+01_JPRB,0.11854E+01_JPRB /)  
KA(:, 8,10) = (/ &
 & 0.10584E+01_JPRB,0.10652E+01_JPRB,0.10757E+01_JPRB,0.10857E+01_JPRB,0.10906E+01_JPRB /)  
KA(:, 9,10) = (/ &
 & 0.95450E+00_JPRB,0.96414E+00_JPRB,0.97673E+00_JPRB,0.98621E+00_JPRB,0.99187E+00_JPRB /)  
KA(:,10,10) = (/ &
 & 0.83626E+00_JPRB,0.84690E+00_JPRB,0.85901E+00_JPRB,0.86824E+00_JPRB,0.87535E+00_JPRB /)  
KA(:,11,10) = (/ &
 & 0.73738E+00_JPRB,0.74729E+00_JPRB,0.75610E+00_JPRB,0.75994E+00_JPRB,0.76481E+00_JPRB /)  
KA(:,12,10) = (/ &
 & 0.66891E+00_JPRB,0.67622E+00_JPRB,0.68092E+00_JPRB,0.68498E+00_JPRB,0.68877E+00_JPRB /)  
KA(:,13,10) = (/ &
 & 0.58616E+00_JPRB,0.59614E+00_JPRB,0.59749E+00_JPRB,0.60310E+00_JPRB,0.60445E+00_JPRB /)  
KA(:, 1,11) = (/ &
 & 0.20080E+01_JPRB,0.19998E+01_JPRB,0.19844E+01_JPRB,0.19679E+01_JPRB,0.19504E+01_JPRB /)  
KA(:, 2,11) = (/ &
 & 0.20896E+01_JPRB,0.20752E+01_JPRB,0.20596E+01_JPRB,0.20445E+01_JPRB,0.20293E+01_JPRB /)  
KA(:, 3,11) = (/ &
 & 0.21262E+01_JPRB,0.21143E+01_JPRB,0.21043E+01_JPRB,0.20968E+01_JPRB,0.20862E+01_JPRB /)  
KA(:, 4,11) = (/ &
 & 0.21310E+01_JPRB,0.21263E+01_JPRB,0.21243E+01_JPRB,0.21203E+01_JPRB,0.21144E+01_JPRB /)  
KA(:, 5,11) = (/ &
 & 0.21041E+01_JPRB,0.21063E+01_JPRB,0.21071E+01_JPRB,0.21077E+01_JPRB,0.21021E+01_JPRB /)  
KA(:, 6,11) = (/ &
 & 0.20447E+01_JPRB,0.20491E+01_JPRB,0.20534E+01_JPRB,0.20532E+01_JPRB,0.20477E+01_JPRB /)  
KA(:, 7,11) = (/ &
 & 0.19487E+01_JPRB,0.19563E+01_JPRB,0.19608E+01_JPRB,0.19593E+01_JPRB,0.19591E+01_JPRB /)  
KA(:, 8,11) = (/ &
 & 0.18239E+01_JPRB,0.18317E+01_JPRB,0.18359E+01_JPRB,0.18391E+01_JPRB,0.18451E+01_JPRB /)  
KA(:, 9,11) = (/ &
 & 0.16772E+01_JPRB,0.16879E+01_JPRB,0.16955E+01_JPRB,0.17047E+01_JPRB,0.17179E+01_JPRB /)  
KA(:,10,11) = (/ &
 & 0.15007E+01_JPRB,0.15184E+01_JPRB,0.15343E+01_JPRB,0.15540E+01_JPRB,0.15756E+01_JPRB /)  
KA(:,11,11) = (/ &
 & 0.13041E+01_JPRB,0.13245E+01_JPRB,0.13445E+01_JPRB,0.13685E+01_JPRB,0.13888E+01_JPRB /)  
KA(:,12,11) = (/ &
 & 0.11590E+01_JPRB,0.11749E+01_JPRB,0.11906E+01_JPRB,0.12046E+01_JPRB,0.12212E+01_JPRB /)  
KA(:,13,11) = (/ &
 & 0.10681E+01_JPRB,0.10905E+01_JPRB,0.11017E+01_JPRB,0.10997E+01_JPRB,0.11116E+01_JPRB /)  
KA(:, 1,12) = (/ &
 & 0.26762E+01_JPRB,0.26701E+01_JPRB,0.26710E+01_JPRB,0.26742E+01_JPRB,0.26733E+01_JPRB /)  
KA(:, 2,12) = (/ &
 & 0.28804E+01_JPRB,0.28775E+01_JPRB,0.28798E+01_JPRB,0.28773E+01_JPRB,0.28700E+01_JPRB /)  
KA(:, 3,12) = (/ &
 & 0.30825E+01_JPRB,0.30790E+01_JPRB,0.30757E+01_JPRB,0.30631E+01_JPRB,0.30471E+01_JPRB /)  
KA(:, 4,12) = (/ &
 & 0.32355E+01_JPRB,0.32278E+01_JPRB,0.32144E+01_JPRB,0.31959E+01_JPRB,0.31753E+01_JPRB /)  
KA(:, 5,12) = (/ &
 & 0.33271E+01_JPRB,0.33191E+01_JPRB,0.33073E+01_JPRB,0.32879E+01_JPRB,0.32714E+01_JPRB /)  
KA(:, 6,12) = (/ &
 & 0.33604E+01_JPRB,0.33571E+01_JPRB,0.33478E+01_JPRB,0.33355E+01_JPRB,0.33272E+01_JPRB /)  
KA(:, 7,12) = (/ &
 & 0.33406E+01_JPRB,0.33436E+01_JPRB,0.33436E+01_JPRB,0.33435E+01_JPRB,0.33409E+01_JPRB /)  
KA(:, 8,12) = (/ &
 & 0.32648E+01_JPRB,0.32808E+01_JPRB,0.32919E+01_JPRB,0.32976E+01_JPRB,0.32999E+01_JPRB /)  
KA(:, 9,12) = (/ &
 & 0.31373E+01_JPRB,0.31630E+01_JPRB,0.31816E+01_JPRB,0.31936E+01_JPRB,0.31991E+01_JPRB /)  
KA(:,10,12) = (/ &
 & 0.29678E+01_JPRB,0.29982E+01_JPRB,0.30244E+01_JPRB,0.30412E+01_JPRB,0.30500E+01_JPRB /)  
KA(:,11,12) = (/ &
 & 0.27380E+01_JPRB,0.27731E+01_JPRB,0.28013E+01_JPRB,0.28227E+01_JPRB,0.28455E+01_JPRB /)  
KA(:,12,12) = (/ &
 & 0.24616E+01_JPRB,0.24905E+01_JPRB,0.25348E+01_JPRB,0.25805E+01_JPRB,0.26155E+01_JPRB /)  
KA(:,13,12) = (/ &
 & 0.22251E+01_JPRB,0.22562E+01_JPRB,0.22966E+01_JPRB,0.23312E+01_JPRB,0.23811E+01_JPRB /)  
KA(:, 1,13) = (/ &
 & 0.38031E+01_JPRB,0.37992E+01_JPRB,0.37926E+01_JPRB,0.37822E+01_JPRB,0.37755E+01_JPRB /)  
KA(:, 2,13) = (/ &
 & 0.41542E+01_JPRB,0.41473E+01_JPRB,0.41391E+01_JPRB,0.41329E+01_JPRB,0.41296E+01_JPRB /)  
KA(:, 3,13) = (/ &
 & 0.44998E+01_JPRB,0.44963E+01_JPRB,0.44896E+01_JPRB,0.44914E+01_JPRB,0.44937E+01_JPRB /)  
KA(:, 4,13) = (/ &
 & 0.48464E+01_JPRB,0.48445E+01_JPRB,0.48485E+01_JPRB,0.48565E+01_JPRB,0.48598E+01_JPRB /)  
KA(:, 5,13) = (/ &
 & 0.52074E+01_JPRB,0.52112E+01_JPRB,0.52168E+01_JPRB,0.52231E+01_JPRB,0.52210E+01_JPRB /)  
KA(:, 6,13) = (/ &
 & 0.55492E+01_JPRB,0.55575E+01_JPRB,0.55655E+01_JPRB,0.55693E+01_JPRB,0.55642E+01_JPRB /)  
KA(:, 7,13) = (/ &
 & 0.58380E+01_JPRB,0.58479E+01_JPRB,0.58509E+01_JPRB,0.58482E+01_JPRB,0.58453E+01_JPRB /)  
KA(:, 8,13) = (/ &
 & 0.60377E+01_JPRB,0.60538E+01_JPRB,0.60594E+01_JPRB,0.60647E+01_JPRB,0.60640E+01_JPRB /)  
KA(:, 9,13) = (/ &
 & 0.61268E+01_JPRB,0.61532E+01_JPRB,0.61730E+01_JPRB,0.61888E+01_JPRB,0.61993E+01_JPRB /)  
KA(:,10,13) = (/ &
 & 0.61216E+01_JPRB,0.61612E+01_JPRB,0.61936E+01_JPRB,0.62230E+01_JPRB,0.62454E+01_JPRB /)  
KA(:,11,13) = (/ &
 & 0.60409E+01_JPRB,0.60960E+01_JPRB,0.61462E+01_JPRB,0.61882E+01_JPRB,0.62219E+01_JPRB /)  
KA(:,12,13) = (/ &
 & 0.58645E+01_JPRB,0.59597E+01_JPRB,0.60234E+01_JPRB,0.60826E+01_JPRB,0.61390E+01_JPRB /)  
KA(:,13,13) = (/ &
 & 0.56001E+01_JPRB,0.57009E+01_JPRB,0.58017E+01_JPRB,0.59181E+01_JPRB,0.59860E+01_JPRB /)  
KA(:, 1,14) = (/ &
 & 0.53647E+01_JPRB,0.53127E+01_JPRB,0.52736E+01_JPRB,0.52471E+01_JPRB,0.52264E+01_JPRB /)  
KA(:, 2,14) = (/ &
 & 0.62359E+01_JPRB,0.61753E+01_JPRB,0.61253E+01_JPRB,0.60847E+01_JPRB,0.60573E+01_JPRB /)  
KA(:, 3,14) = (/ &
 & 0.72065E+01_JPRB,0.71249E+01_JPRB,0.70556E+01_JPRB,0.69965E+01_JPRB,0.69559E+01_JPRB /)  
KA(:, 4,14) = (/ &
 & 0.81631E+01_JPRB,0.80714E+01_JPRB,0.79828E+01_JPRB,0.79081E+01_JPRB,0.78545E+01_JPRB /)  
KA(:, 5,14) = (/ &
 & 0.90691E+01_JPRB,0.89602E+01_JPRB,0.88621E+01_JPRB,0.87858E+01_JPRB,0.87314E+01_JPRB /)  
KA(:, 6,14) = (/ &
 & 0.99707E+01_JPRB,0.98474E+01_JPRB,0.97395E+01_JPRB,0.96541E+01_JPRB,0.95904E+01_JPRB /)  
KA(:, 7,14) = (/ &
 & 0.10852E+02_JPRB,0.10724E+02_JPRB,0.10620E+02_JPRB,0.10536E+02_JPRB,0.10469E+02_JPRB /)  
KA(:, 8,14) = (/ &
 & 0.11716E+02_JPRB,0.11588E+02_JPRB,0.11487E+02_JPRB,0.11403E+02_JPRB,0.11337E+02_JPRB /)  
KA(:, 9,14) = (/ &
 & 0.12572E+02_JPRB,0.12448E+02_JPRB,0.12341E+02_JPRB,0.12260E+02_JPRB,0.12188E+02_JPRB /)  
KA(:,10,14) = (/ &
 & 0.13374E+02_JPRB,0.13256E+02_JPRB,0.13159E+02_JPRB,0.13080E+02_JPRB,0.13010E+02_JPRB /)  
KA(:,11,14) = (/ &
 & 0.14046E+02_JPRB,0.13957E+02_JPRB,0.13888E+02_JPRB,0.13824E+02_JPRB,0.13769E+02_JPRB /)  
KA(:,12,14) = (/ &
 & 0.14644E+02_JPRB,0.14592E+02_JPRB,0.14548E+02_JPRB,0.14504E+02_JPRB,0.14461E+02_JPRB /)  
KA(:,13,14) = (/ &
 & 0.15144E+02_JPRB,0.15129E+02_JPRB,0.15111E+02_JPRB,0.15095E+02_JPRB,0.15074E+02_JPRB /)  
KA(:, 1,15) = (/ &
 & 0.72019E+01_JPRB,0.71097E+01_JPRB,0.70236E+01_JPRB,0.69449E+01_JPRB,0.68844E+01_JPRB /)  
KA(:, 2,15) = (/ &
 & 0.87604E+01_JPRB,0.86468E+01_JPRB,0.85349E+01_JPRB,0.84375E+01_JPRB,0.83491E+01_JPRB /)  
KA(:, 3,15) = (/ &
 & 0.10615E+02_JPRB,0.10469E+02_JPRB,0.10333E+02_JPRB,0.10214E+02_JPRB,0.10099E+02_JPRB /)  
KA(:, 4,15) = (/ &
 & 0.12669E+02_JPRB,0.12473E+02_JPRB,0.12305E+02_JPRB,0.12161E+02_JPRB,0.12026E+02_JPRB /)  
KA(:, 5,15) = (/ &
 & 0.14978E+02_JPRB,0.14741E+02_JPRB,0.14530E+02_JPRB,0.14329E+02_JPRB,0.14143E+02_JPRB /)  
KA(:, 6,15) = (/ &
 & 0.17562E+02_JPRB,0.17282E+02_JPRB,0.17031E+02_JPRB,0.16791E+02_JPRB,0.16552E+02_JPRB /)  
KA(:, 7,15) = (/ &
 & 0.20480E+02_JPRB,0.20136E+02_JPRB,0.19827E+02_JPRB,0.19524E+02_JPRB,0.19223E+02_JPRB /)  
KA(:, 8,15) = (/ &
 & 0.23734E+02_JPRB,0.23307E+02_JPRB,0.22908E+02_JPRB,0.22521E+02_JPRB,0.22160E+02_JPRB /)  
KA(:, 9,15) = (/ &
 & 0.27249E+02_JPRB,0.26733E+02_JPRB,0.26255E+02_JPRB,0.25787E+02_JPRB,0.25354E+02_JPRB /)  
KA(:,10,15) = (/ &
 & 0.30889E+02_JPRB,0.30311E+02_JPRB,0.29740E+02_JPRB,0.29192E+02_JPRB,0.28690E+02_JPRB /)  
KA(:,11,15) = (/ &
 & 0.34366E+02_JPRB,0.33687E+02_JPRB,0.33035E+02_JPRB,0.32430E+02_JPRB,0.31843E+02_JPRB /)  
KA(:,12,15) = (/ &
 & 0.37839E+02_JPRB,0.37085E+02_JPRB,0.36360E+02_JPRB,0.35655E+02_JPRB,0.34957E+02_JPRB /)  
KA(:,13,15) = (/ &
 & 0.41323E+02_JPRB,0.40503E+02_JPRB,0.39673E+02_JPRB,0.38847E+02_JPRB,0.38049E+02_JPRB /)  
KA(:, 1,16) = (/ &
 & 0.82631E+01_JPRB,0.81761E+01_JPRB,0.80809E+01_JPRB,0.79778E+01_JPRB,0.79010E+01_JPRB /)  
KA(:, 2,16) = (/ &
 & 0.10258E+02_JPRB,0.10128E+02_JPRB,0.10005E+02_JPRB,0.98803E+01_JPRB,0.97700E+01_JPRB /)  
KA(:, 3,16) = (/ &
 & 0.12786E+02_JPRB,0.12614E+02_JPRB,0.12441E+02_JPRB,0.12267E+02_JPRB,0.12120E+02_JPRB /)  
KA(:, 4,16) = (/ &
 & 0.15843E+02_JPRB,0.15549E+02_JPRB,0.15326E+02_JPRB,0.15095E+02_JPRB,0.14871E+02_JPRB /)  
KA(:, 5,16) = (/ &
 & 0.19543E+02_JPRB,0.19089E+02_JPRB,0.18733E+02_JPRB,0.18430E+02_JPRB,0.18134E+02_JPRB /)  
KA(:, 6,16) = (/ &
 & 0.24038E+02_JPRB,0.23415E+02_JPRB,0.22893E+02_JPRB,0.22427E+02_JPRB,0.22005E+02_JPRB /)  
KA(:, 7,16) = (/ &
 & 0.29445E+02_JPRB,0.28630E+02_JPRB,0.27921E+02_JPRB,0.27268E+02_JPRB,0.26654E+02_JPRB /)  
KA(:, 8,16) = (/ &
 & 0.35889E+02_JPRB,0.34849E+02_JPRB,0.33913E+02_JPRB,0.33036E+02_JPRB,0.32194E+02_JPRB /)  
KA(:, 9,16) = (/ &
 & 0.43512E+02_JPRB,0.42175E+02_JPRB,0.40956E+02_JPRB,0.39809E+02_JPRB,0.38685E+02_JPRB /)  
KA(:,10,16) = (/ &
 & 0.52253E+02_JPRB,0.50582E+02_JPRB,0.49011E+02_JPRB,0.47508E+02_JPRB,0.46037E+02_JPRB /)  
KA(:,11,16) = (/ &
 & 0.61290E+02_JPRB,0.59240E+02_JPRB,0.57269E+02_JPRB,0.55343E+02_JPRB,0.53572E+02_JPRB /)  
KA(:,12,16) = (/ &
 & 0.71193E+02_JPRB,0.68607E+02_JPRB,0.66135E+02_JPRB,0.63828E+02_JPRB,0.61720E+02_JPRB /)  
KA(:,13,16) = (/ &
 & 0.81988E+02_JPRB,0.78665E+02_JPRB,0.75707E+02_JPRB,0.72932E+02_JPRB,0.70347E+02_JPRB /)  
  
!     -----------------------------------------------------------------
!     The array KB contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

KB(:,13, 1) = (/ &
 & 0.29597E-05_JPRB,0.31929E-05_JPRB,0.34159E-05_JPRB,0.36256E-05_JPRB,0.38264E-05_JPRB /)  
KB(:,14, 1) = (/ &
 & 0.24233E-05_JPRB,0.26151E-05_JPRB,0.27866E-05_JPRB,0.29502E-05_JPRB,0.31170E-05_JPRB /)  
KB(:,15, 1) = (/ &
 & 0.19206E-05_JPRB,0.20789E-05_JPRB,0.22099E-05_JPRB,0.23383E-05_JPRB,0.24505E-05_JPRB /)  
KB(:,16, 1) = (/ &
 & 0.14933E-05_JPRB,0.16071E-05_JPRB,0.17039E-05_JPRB,0.17994E-05_JPRB,0.18816E-05_JPRB /)  
KB(:,17, 1) = (/ &
 & 0.11429E-05_JPRB,0.12144E-05_JPRB,0.12895E-05_JPRB,0.13503E-05_JPRB,0.14174E-05_JPRB /)  
KB(:,18, 1) = (/ &
 & 0.84134E-06_JPRB,0.89264E-06_JPRB,0.94260E-06_JPRB,0.99003E-06_JPRB,0.10391E-05_JPRB /)  
KB(:,19, 1) = (/ &
 & 0.60683E-06_JPRB,0.64142E-06_JPRB,0.68018E-06_JPRB,0.72042E-06_JPRB,0.75479E-06_JPRB /)  
KB(:,20, 1) = (/ &
 & 0.45809E-06_JPRB,0.48813E-06_JPRB,0.51934E-06_JPRB,0.54823E-06_JPRB,0.57261E-06_JPRB /)  
KB(:,21, 1) = (/ &
 & 0.35219E-06_JPRB,0.37835E-06_JPRB,0.40322E-06_JPRB,0.42772E-06_JPRB,0.44736E-06_JPRB /)  
KB(:,22, 1) = (/ &
 & 0.27419E-06_JPRB,0.29542E-06_JPRB,0.31617E-06_JPRB,0.33398E-06_JPRB,0.34932E-06_JPRB /)  
KB(:,23, 1) = (/ &
 & 0.21385E-06_JPRB,0.23127E-06_JPRB,0.24670E-06_JPRB,0.25951E-06_JPRB,0.26952E-06_JPRB /)  
KB(:,24, 1) = (/ &
 & 0.16767E-06_JPRB,0.18179E-06_JPRB,0.19282E-06_JPRB,0.20136E-06_JPRB,0.21113E-06_JPRB /)  
KB(:,25, 1) = (/ &
 & 0.13361E-06_JPRB,0.14301E-06_JPRB,0.14980E-06_JPRB,0.15778E-06_JPRB,0.16615E-06_JPRB /)  
KB(:,26, 1) = (/ &
 & 0.10615E-06_JPRB,0.11218E-06_JPRB,0.11889E-06_JPRB,0.12574E-06_JPRB,0.13111E-06_JPRB /)  
KB(:,27, 1) = (/ &
 & 0.83660E-07_JPRB,0.89296E-07_JPRB,0.95019E-07_JPRB,0.10007E-06_JPRB,0.10397E-06_JPRB /)  
KB(:,28, 1) = (/ &
 & 0.66667E-07_JPRB,0.71217E-07_JPRB,0.75615E-07_JPRB,0.79237E-07_JPRB,0.82239E-07_JPRB /)  
KB(:,29, 1) = (/ &
 & 0.52776E-07_JPRB,0.56086E-07_JPRB,0.59828E-07_JPRB,0.62513E-07_JPRB,0.64218E-07_JPRB /)  
KB(:,30, 1) = (/ &
 & 0.41429E-07_JPRB,0.44370E-07_JPRB,0.46731E-07_JPRB,0.48553E-07_JPRB,0.50143E-07_JPRB /)  
KB(:,31, 1) = (/ &
 & 0.32437E-07_JPRB,0.34523E-07_JPRB,0.36208E-07_JPRB,0.37500E-07_JPRB,0.38571E-07_JPRB /)  
KB(:,32, 1) = (/ &
 & 0.25237E-07_JPRB,0.26730E-07_JPRB,0.27868E-07_JPRB,0.28829E-07_JPRB,0.29943E-07_JPRB /)  
KB(:,33, 1) = (/ &
 & 0.19545E-07_JPRB,0.20614E-07_JPRB,0.21467E-07_JPRB,0.22280E-07_JPRB,0.23141E-07_JPRB /)  
KB(:,34, 1) = (/ &
 & 0.15146E-07_JPRB,0.15869E-07_JPRB,0.16509E-07_JPRB,0.17179E-07_JPRB,0.17980E-07_JPRB /)  
KB(:,35, 1) = (/ &
 & 0.11482E-07_JPRB,0.12039E-07_JPRB,0.12547E-07_JPRB,0.13255E-07_JPRB,0.13874E-07_JPRB /)  
KB(:,36, 1) = (/ &
 & 0.86172E-08_JPRB,0.90023E-08_JPRB,0.95607E-08_JPRB,0.10106E-07_JPRB,0.10595E-07_JPRB /)  
KB(:,37, 1) = (/ &
 & 0.67411E-08_JPRB,0.70781E-08_JPRB,0.75553E-08_JPRB,0.79739E-08_JPRB,0.84011E-08_JPRB /)  
KB(:,38, 1) = (/ &
 & 0.52604E-08_JPRB,0.55743E-08_JPRB,0.59410E-08_JPRB,0.63031E-08_JPRB,0.66516E-08_JPRB /)  
KB(:,39, 1) = (/ &
 & 0.41129E-08_JPRB,0.43854E-08_JPRB,0.46851E-08_JPRB,0.49771E-08_JPRB,0.52463E-08_JPRB /)  
KB(:,40, 1) = (/ &
 & 0.33089E-08_JPRB,0.35289E-08_JPRB,0.37702E-08_JPRB,0.40125E-08_JPRB,0.42415E-08_JPRB /)  
KB(:,41, 1) = (/ &
 & 0.26794E-08_JPRB,0.28488E-08_JPRB,0.30428E-08_JPRB,0.32437E-08_JPRB,0.34420E-08_JPRB /)  
KB(:,42, 1) = (/ &
 & 0.21670E-08_JPRB,0.23030E-08_JPRB,0.24589E-08_JPRB,0.26252E-08_JPRB,0.27867E-08_JPRB /)  
KB(:,43, 1) = (/ &
 & 0.17699E-08_JPRB,0.18853E-08_JPRB,0.20001E-08_JPRB,0.21330E-08_JPRB,0.22657E-08_JPRB /)  
KB(:,44, 1) = (/ &
 & 0.14446E-08_JPRB,0.15471E-08_JPRB,0.16397E-08_JPRB,0.17423E-08_JPRB,0.18526E-08_JPRB /)  
KB(:,45, 1) = (/ &
 & 0.11734E-08_JPRB,0.12754E-08_JPRB,0.13542E-08_JPRB,0.14242E-08_JPRB,0.15193E-08_JPRB /)  
KB(:,46, 1) = (/ &
 & 0.95743E-09_JPRB,0.10470E-08_JPRB,0.11183E-08_JPRB,0.11726E-08_JPRB,0.12389E-08_JPRB /)  
KB(:,47, 1) = (/ &
 & 0.77345E-09_JPRB,0.85197E-09_JPRB,0.92184E-09_JPRB,0.97368E-09_JPRB,0.10149E-08_JPRB /)  
KB(:,48, 1) = (/ &
 & 0.62500E-09_JPRB,0.69288E-09_JPRB,0.75548E-09_JPRB,0.80446E-09_JPRB,0.84428E-09_JPRB /)  
KB(:,49, 1) = (/ &
 & 0.50095E-09_JPRB,0.55967E-09_JPRB,0.61904E-09_JPRB,0.66441E-09_JPRB,0.70339E-09_JPRB /)  
KB(:,50, 1) = (/ &
 & 0.40806E-09_JPRB,0.45712E-09_JPRB,0.50530E-09_JPRB,0.54974E-09_JPRB,0.58246E-09_JPRB /)  
KB(:,51, 1) = (/ &
 & 0.33102E-09_JPRB,0.37130E-09_JPRB,0.41121E-09_JPRB,0.45024E-09_JPRB,0.48436E-09_JPRB /)  
KB(:,52, 1) = (/ &
 & 0.26906E-09_JPRB,0.30739E-09_JPRB,0.33845E-09_JPRB,0.36884E-09_JPRB,0.40024E-09_JPRB /)  
KB(:,53, 1) = (/ &
 & 0.22202E-09_JPRB,0.25108E-09_JPRB,0.27937E-09_JPRB,0.30592E-09_JPRB,0.33012E-09_JPRB /)  
KB(:,54, 1) = (/ &
 & 0.18662E-09_JPRB,0.20761E-09_JPRB,0.23072E-09_JPRB,0.25342E-09_JPRB,0.27445E-09_JPRB /)  
KB(:,55, 1) = (/ &
 & 0.15741E-09_JPRB,0.17147E-09_JPRB,0.19146E-09_JPRB,0.21029E-09_JPRB,0.22857E-09_JPRB /)  
KB(:,56, 1) = (/ &
 & 0.13151E-09_JPRB,0.14637E-09_JPRB,0.15977E-09_JPRB,0.17547E-09_JPRB,0.18974E-09_JPRB /)  
KB(:,57, 1) = (/ &
 & 0.10874E-09_JPRB,0.12447E-09_JPRB,0.13634E-09_JPRB,0.14752E-09_JPRB,0.16022E-09_JPRB /)  
KB(:,58, 1) = (/ &
 & 0.90206E-10_JPRB,0.10484E-09_JPRB,0.11617E-09_JPRB,0.12545E-09_JPRB,0.13474E-09_JPRB /)  
KB(:,59, 1) = (/ &
 & 0.76759E-10_JPRB,0.88866E-10_JPRB,0.99340E-10_JPRB,0.10706E-09_JPRB,0.11444E-09_JPRB /)  
KB(:,13, 2) = (/ &
 & 0.14727E-04_JPRB,0.16357E-04_JPRB,0.17961E-04_JPRB,0.19530E-04_JPRB,0.20852E-04_JPRB /)  
KB(:,14, 2) = (/ &
 & 0.12148E-04_JPRB,0.13478E-04_JPRB,0.14818E-04_JPRB,0.16049E-04_JPRB,0.17100E-04_JPRB /)  
KB(:,15, 2) = (/ &
 & 0.96902E-05_JPRB,0.10787E-04_JPRB,0.11835E-04_JPRB,0.12770E-04_JPRB,0.13515E-04_JPRB /)  
KB(:,16, 2) = (/ &
 & 0.76235E-05_JPRB,0.84575E-05_JPRB,0.92217E-05_JPRB,0.98526E-05_JPRB,0.10449E-04_JPRB /)  
KB(:,17, 2) = (/ &
 & 0.58049E-05_JPRB,0.64239E-05_JPRB,0.69733E-05_JPRB,0.74131E-05_JPRB,0.78082E-05_JPRB /)  
KB(:,18, 2) = (/ &
 & 0.43204E-05_JPRB,0.47510E-05_JPRB,0.51165E-05_JPRB,0.54579E-05_JPRB,0.57434E-05_JPRB /)  
KB(:,19, 2) = (/ &
 & 0.32211E-05_JPRB,0.35327E-05_JPRB,0.38175E-05_JPRB,0.40535E-05_JPRB,0.42245E-05_JPRB /)  
KB(:,20, 2) = (/ &
 & 0.25265E-05_JPRB,0.27652E-05_JPRB,0.29644E-05_JPRB,0.31331E-05_JPRB,0.32730E-05_JPRB /)  
KB(:,21, 2) = (/ &
 & 0.19921E-05_JPRB,0.21749E-05_JPRB,0.23343E-05_JPRB,0.24377E-05_JPRB,0.25458E-05_JPRB /)  
KB(:,22, 2) = (/ &
 & 0.15859E-05_JPRB,0.17259E-05_JPRB,0.18236E-05_JPRB,0.19124E-05_JPRB,0.19942E-05_JPRB /)  
KB(:,23, 2) = (/ &
 & 0.12591E-05_JPRB,0.13565E-05_JPRB,0.14309E-05_JPRB,0.15032E-05_JPRB,0.15642E-05_JPRB /)  
KB(:,24, 2) = (/ &
 & 0.10012E-05_JPRB,0.10701E-05_JPRB,0.11246E-05_JPRB,0.11819E-05_JPRB,0.12279E-05_JPRB /)  
KB(:,25, 2) = (/ &
 & 0.78985E-06_JPRB,0.84074E-06_JPRB,0.89029E-06_JPRB,0.93145E-06_JPRB,0.97085E-06_JPRB /)  
KB(:,26, 2) = (/ &
 & 0.62996E-06_JPRB,0.66847E-06_JPRB,0.70637E-06_JPRB,0.73513E-06_JPRB,0.77135E-06_JPRB /)  
KB(:,27, 2) = (/ &
 & 0.50283E-06_JPRB,0.53111E-06_JPRB,0.55653E-06_JPRB,0.58306E-06_JPRB,0.61799E-06_JPRB /)  
KB(:,28, 2) = (/ &
 & 0.39962E-06_JPRB,0.42320E-06_JPRB,0.44265E-06_JPRB,0.46715E-06_JPRB,0.49516E-06_JPRB /)  
KB(:,29, 2) = (/ &
 & 0.31810E-06_JPRB,0.33597E-06_JPRB,0.35191E-06_JPRB,0.37448E-06_JPRB,0.39768E-06_JPRB /)  
KB(:,30, 2) = (/ &
 & 0.25242E-06_JPRB,0.26447E-06_JPRB,0.28109E-06_JPRB,0.30089E-06_JPRB,0.31543E-06_JPRB /)  
KB(:,31, 2) = (/ &
 & 0.19837E-06_JPRB,0.20954E-06_JPRB,0.22442E-06_JPRB,0.23762E-06_JPRB,0.25183E-06_JPRB /)  
KB(:,32, 2) = (/ &
 & 0.15599E-06_JPRB,0.16701E-06_JPRB,0.17789E-06_JPRB,0.18880E-06_JPRB,0.20030E-06_JPRB /)  
KB(:,33, 2) = (/ &
 & 0.12307E-06_JPRB,0.13211E-06_JPRB,0.14046E-06_JPRB,0.15111E-06_JPRB,0.15988E-06_JPRB /)  
KB(:,34, 2) = (/ &
 & 0.98429E-07_JPRB,0.10498E-06_JPRB,0.11326E-06_JPRB,0.12074E-06_JPRB,0.12779E-06_JPRB /)  
KB(:,35, 2) = (/ &
 & 0.77743E-07_JPRB,0.83951E-07_JPRB,0.90473E-07_JPRB,0.96277E-07_JPRB,0.10204E-06_JPRB /)  
KB(:,36, 2) = (/ &
 & 0.61220E-07_JPRB,0.66399E-07_JPRB,0.71102E-07_JPRB,0.75946E-07_JPRB,0.80803E-07_JPRB /)  
KB(:,37, 2) = (/ &
 & 0.48819E-07_JPRB,0.52962E-07_JPRB,0.56669E-07_JPRB,0.60817E-07_JPRB,0.64709E-07_JPRB /)  
KB(:,38, 2) = (/ &
 & 0.38871E-07_JPRB,0.42226E-07_JPRB,0.45376E-07_JPRB,0.48641E-07_JPRB,0.51855E-07_JPRB /)  
KB(:,39, 2) = (/ &
 & 0.30869E-07_JPRB,0.33485E-07_JPRB,0.36233E-07_JPRB,0.38868E-07_JPRB,0.41523E-07_JPRB /)  
KB(:,40, 2) = (/ &
 & 0.24798E-07_JPRB,0.26983E-07_JPRB,0.29180E-07_JPRB,0.31437E-07_JPRB,0.33600E-07_JPRB /)  
KB(:,41, 2) = (/ &
 & 0.19951E-07_JPRB,0.21784E-07_JPRB,0.23518E-07_JPRB,0.25460E-07_JPRB,0.27219E-07_JPRB /)  
KB(:,42, 2) = (/ &
 & 0.16098E-07_JPRB,0.17542E-07_JPRB,0.18979E-07_JPRB,0.20547E-07_JPRB,0.22016E-07_JPRB /)  
KB(:,43, 2) = (/ &
 & 0.13020E-07_JPRB,0.14144E-07_JPRB,0.15414E-07_JPRB,0.16610E-07_JPRB,0.17870E-07_JPRB /)  
KB(:,44, 2) = (/ &
 & 0.10548E-07_JPRB,0.11500E-07_JPRB,0.12492E-07_JPRB,0.13520E-07_JPRB,0.14524E-07_JPRB /)  
KB(:,45, 2) = (/ &
 & 0.85602E-08_JPRB,0.93245E-08_JPRB,0.10096E-07_JPRB,0.10978E-07_JPRB,0.11819E-07_JPRB /)  
KB(:,46, 2) = (/ &
 & 0.69149E-08_JPRB,0.75653E-08_JPRB,0.82154E-08_JPRB,0.88822E-08_JPRB,0.96002E-08_JPRB /)  
KB(:,47, 2) = (/ &
 & 0.55708E-08_JPRB,0.61164E-08_JPRB,0.66678E-08_JPRB,0.71922E-08_JPRB,0.77633E-08_JPRB /)  
KB(:,48, 2) = (/ &
 & 0.44804E-08_JPRB,0.49312E-08_JPRB,0.53967E-08_JPRB,0.58662E-08_JPRB,0.62780E-08_JPRB /)  
KB(:,49, 2) = (/ &
 & 0.36467E-08_JPRB,0.39866E-08_JPRB,0.43628E-08_JPRB,0.47589E-08_JPRB,0.51208E-08_JPRB /)  
KB(:,50, 2) = (/ &
 & 0.29524E-08_JPRB,0.32540E-08_JPRB,0.35471E-08_JPRB,0.38638E-08_JPRB,0.41887E-08_JPRB /)  
KB(:,51, 2) = (/ &
 & 0.23887E-08_JPRB,0.26526E-08_JPRB,0.28959E-08_JPRB,0.31504E-08_JPRB,0.34112E-08_JPRB /)  
KB(:,52, 2) = (/ &
 & 0.19321E-08_JPRB,0.21648E-08_JPRB,0.23625E-08_JPRB,0.25839E-08_JPRB,0.28173E-08_JPRB /)  
KB(:,53, 2) = (/ &
 & 0.15684E-08_JPRB,0.17725E-08_JPRB,0.19476E-08_JPRB,0.21240E-08_JPRB,0.23118E-08_JPRB /)  
KB(:,54, 2) = (/ &
 & 0.12799E-08_JPRB,0.14467E-08_JPRB,0.16073E-08_JPRB,0.17494E-08_JPRB,0.19160E-08_JPRB /)  
KB(:,55, 2) = (/ &
 & 0.10442E-08_JPRB,0.11911E-08_JPRB,0.13216E-08_JPRB,0.14537E-08_JPRB,0.15771E-08_JPRB /)  
KB(:,56, 2) = (/ &
 & 0.85741E-09_JPRB,0.97937E-09_JPRB,0.10936E-08_JPRB,0.12056E-08_JPRB,0.13167E-08_JPRB /)  
KB(:,57, 2) = (/ &
 & 0.70358E-09_JPRB,0.80334E-09_JPRB,0.90824E-09_JPRB,0.10056E-08_JPRB,0.11010E-08_JPRB /)  
KB(:,58, 2) = (/ &
 & 0.57428E-09_JPRB,0.66441E-09_JPRB,0.75420E-09_JPRB,0.83627E-09_JPRB,0.92485E-09_JPRB /)  
KB(:,59, 2) = (/ &
 & 0.47922E-09_JPRB,0.55592E-09_JPRB,0.63499E-09_JPRB,0.70731E-09_JPRB,0.78678E-09_JPRB /)  
KB(:,13, 3) = (/ &
 & 0.76201E-04_JPRB,0.82699E-04_JPRB,0.87499E-04_JPRB,0.91352E-04_JPRB,0.95348E-04_JPRB /)  
KB(:,14, 3) = (/ &
 & 0.62821E-04_JPRB,0.67861E-04_JPRB,0.71868E-04_JPRB,0.75108E-04_JPRB,0.78557E-04_JPRB /)  
KB(:,15, 3) = (/ &
 & 0.49775E-04_JPRB,0.53367E-04_JPRB,0.56639E-04_JPRB,0.59001E-04_JPRB,0.62303E-04_JPRB /)  
KB(:,16, 3) = (/ &
 & 0.38005E-04_JPRB,0.40883E-04_JPRB,0.43269E-04_JPRB,0.45403E-04_JPRB,0.48139E-04_JPRB /)  
KB(:,17, 3) = (/ &
 & 0.28550E-04_JPRB,0.30750E-04_JPRB,0.32331E-04_JPRB,0.34489E-04_JPRB,0.36687E-04_JPRB /)  
KB(:,18, 3) = (/ &
 & 0.20976E-04_JPRB,0.22322E-04_JPRB,0.23743E-04_JPRB,0.25554E-04_JPRB,0.27223E-04_JPRB /)  
KB(:,19, 3) = (/ &
 & 0.15389E-04_JPRB,0.16422E-04_JPRB,0.17792E-04_JPRB,0.19127E-04_JPRB,0.20295E-04_JPRB /)  
KB(:,20, 3) = (/ &
 & 0.11883E-04_JPRB,0.12816E-04_JPRB,0.13962E-04_JPRB,0.14872E-04_JPRB,0.15725E-04_JPRB /)  
KB(:,21, 3) = (/ &
 & 0.92948E-05_JPRB,0.10187E-04_JPRB,0.10986E-04_JPRB,0.11713E-04_JPRB,0.12426E-04_JPRB /)  
KB(:,22, 3) = (/ &
 & 0.73969E-05_JPRB,0.80840E-05_JPRB,0.87263E-05_JPRB,0.93856E-05_JPRB,0.99533E-05_JPRB /)  
KB(:,23, 3) = (/ &
 & 0.58961E-05_JPRB,0.64591E-05_JPRB,0.69648E-05_JPRB,0.74494E-05_JPRB,0.79385E-05_JPRB /)  
KB(:,24, 3) = (/ &
 & 0.47445E-05_JPRB,0.51742E-05_JPRB,0.56036E-05_JPRB,0.59758E-05_JPRB,0.63724E-05_JPRB /)  
KB(:,25, 3) = (/ &
 & 0.38442E-05_JPRB,0.41791E-05_JPRB,0.44837E-05_JPRB,0.48078E-05_JPRB,0.51294E-05_JPRB /)  
KB(:,26, 3) = (/ &
 & 0.31335E-05_JPRB,0.33923E-05_JPRB,0.36400E-05_JPRB,0.38961E-05_JPRB,0.41487E-05_JPRB /)  
KB(:,27, 3) = (/ &
 & 0.25499E-05_JPRB,0.27432E-05_JPRB,0.29560E-05_JPRB,0.31545E-05_JPRB,0.33433E-05_JPRB /)  
KB(:,28, 3) = (/ &
 & 0.20635E-05_JPRB,0.22231E-05_JPRB,0.23897E-05_JPRB,0.25516E-05_JPRB,0.26938E-05_JPRB /)  
KB(:,29, 3) = (/ &
 & 0.16635E-05_JPRB,0.18024E-05_JPRB,0.19279E-05_JPRB,0.20498E-05_JPRB,0.21627E-05_JPRB /)  
KB(:,30, 3) = (/ &
 & 0.13359E-05_JPRB,0.14474E-05_JPRB,0.15470E-05_JPRB,0.16346E-05_JPRB,0.17457E-05_JPRB /)  
KB(:,31, 3) = (/ &
 & 0.10697E-05_JPRB,0.11477E-05_JPRB,0.12254E-05_JPRB,0.13097E-05_JPRB,0.13914E-05_JPRB /)  
KB(:,32, 3) = (/ &
 & 0.84958E-06_JPRB,0.91464E-06_JPRB,0.98189E-06_JPRB,0.10489E-05_JPRB,0.11150E-05_JPRB /)  
KB(:,33, 3) = (/ &
 & 0.68178E-06_JPRB,0.73356E-06_JPRB,0.78905E-06_JPRB,0.84226E-06_JPRB,0.89476E-06_JPRB /)  
KB(:,34, 3) = (/ &
 & 0.54737E-06_JPRB,0.58995E-06_JPRB,0.63374E-06_JPRB,0.67732E-06_JPRB,0.72182E-06_JPRB /)  
KB(:,35, 3) = (/ &
 & 0.43680E-06_JPRB,0.47086E-06_JPRB,0.50771E-06_JPRB,0.54209E-06_JPRB,0.57687E-06_JPRB /)  
KB(:,36, 3) = (/ &
 & 0.34612E-06_JPRB,0.37466E-06_JPRB,0.40370E-06_JPRB,0.43073E-06_JPRB,0.45979E-06_JPRB /)  
KB(:,37, 3) = (/ &
 & 0.27725E-06_JPRB,0.30048E-06_JPRB,0.32451E-06_JPRB,0.34638E-06_JPRB,0.37105E-06_JPRB /)  
KB(:,38, 3) = (/ &
 & 0.22228E-06_JPRB,0.24114E-06_JPRB,0.26049E-06_JPRB,0.27871E-06_JPRB,0.29935E-06_JPRB /)  
KB(:,39, 3) = (/ &
 & 0.17797E-06_JPRB,0.19317E-06_JPRB,0.20878E-06_JPRB,0.22411E-06_JPRB,0.24102E-06_JPRB /)  
KB(:,40, 3) = (/ &
 & 0.14346E-06_JPRB,0.15601E-06_JPRB,0.16913E-06_JPRB,0.18197E-06_JPRB,0.19566E-06_JPRB /)  
KB(:,41, 3) = (/ &
 & 0.11559E-06_JPRB,0.12615E-06_JPRB,0.13697E-06_JPRB,0.14785E-06_JPRB,0.15874E-06_JPRB /)  
KB(:,42, 3) = (/ &
 & 0.93358E-07_JPRB,0.10214E-06_JPRB,0.11089E-06_JPRB,0.11998E-06_JPRB,0.12904E-06_JPRB /)  
KB(:,43, 3) = (/ &
 & 0.75599E-07_JPRB,0.82690E-07_JPRB,0.89808E-07_JPRB,0.97524E-07_JPRB,0.10511E-06_JPRB /)  
KB(:,44, 3) = (/ &
 & 0.61285E-07_JPRB,0.66786E-07_JPRB,0.72937E-07_JPRB,0.79087E-07_JPRB,0.85525E-07_JPRB /)  
KB(:,45, 3) = (/ &
 & 0.49725E-07_JPRB,0.54294E-07_JPRB,0.59263E-07_JPRB,0.64213E-07_JPRB,0.69583E-07_JPRB /)  
KB(:,46, 3) = (/ &
 & 0.40336E-07_JPRB,0.44186E-07_JPRB,0.48034E-07_JPRB,0.52184E-07_JPRB,0.56534E-07_JPRB /)  
KB(:,47, 3) = (/ &
 & 0.32904E-07_JPRB,0.35633E-07_JPRB,0.38959E-07_JPRB,0.42402E-07_JPRB,0.45883E-07_JPRB /)  
KB(:,48, 3) = (/ &
 & 0.26725E-07_JPRB,0.29104E-07_JPRB,0.31693E-07_JPRB,0.34312E-07_JPRB,0.37304E-07_JPRB /)  
KB(:,49, 3) = (/ &
 & 0.21751E-07_JPRB,0.23849E-07_JPRB,0.25803E-07_JPRB,0.28024E-07_JPRB,0.30356E-07_JPRB /)  
KB(:,50, 3) = (/ &
 & 0.17587E-07_JPRB,0.19609E-07_JPRB,0.21216E-07_JPRB,0.23022E-07_JPRB,0.24942E-07_JPRB /)  
KB(:,51, 3) = (/ &
 & 0.14376E-07_JPRB,0.15990E-07_JPRB,0.17493E-07_JPRB,0.18872E-07_JPRB,0.20463E-07_JPRB /)  
KB(:,52, 3) = (/ &
 & 0.11811E-07_JPRB,0.13106E-07_JPRB,0.14489E-07_JPRB,0.15615E-07_JPRB,0.16832E-07_JPRB /)  
KB(:,53, 3) = (/ &
 & 0.96001E-08_JPRB,0.10788E-07_JPRB,0.11921E-07_JPRB,0.12985E-07_JPRB,0.13904E-07_JPRB /)  
KB(:,54, 3) = (/ &
 & 0.78243E-08_JPRB,0.89178E-08_JPRB,0.98430E-08_JPRB,0.10840E-07_JPRB,0.11619E-07_JPRB /)  
KB(:,55, 3) = (/ &
 & 0.63638E-08_JPRB,0.73678E-08_JPRB,0.82214E-08_JPRB,0.89997E-08_JPRB,0.97565E-08_JPRB /)  
KB(:,56, 3) = (/ &
 & 0.51753E-08_JPRB,0.60497E-08_JPRB,0.68419E-08_JPRB,0.74560E-08_JPRB,0.82362E-08_JPRB /)  
KB(:,57, 3) = (/ &
 & 0.42164E-08_JPRB,0.49916E-08_JPRB,0.57066E-08_JPRB,0.63308E-08_JPRB,0.68950E-08_JPRB /)  
KB(:,58, 3) = (/ &
 & 0.34618E-08_JPRB,0.41424E-08_JPRB,0.48054E-08_JPRB,0.53757E-08_JPRB,0.58095E-08_JPRB /)  
KB(:,59, 3) = (/ &
 & 0.29083E-08_JPRB,0.35291E-08_JPRB,0.40932E-08_JPRB,0.46285E-08_JPRB,0.49865E-08_JPRB /)  
KB(:,13, 4) = (/ &
 & 0.37674E-03_JPRB,0.40953E-03_JPRB,0.43690E-03_JPRB,0.46059E-03_JPRB,0.48007E-03_JPRB /)  
KB(:,14, 4) = (/ &
 & 0.31202E-03_JPRB,0.33906E-03_JPRB,0.36066E-03_JPRB,0.38003E-03_JPRB,0.39627E-03_JPRB /)  
KB(:,15, 4) = (/ &
 & 0.25135E-03_JPRB,0.27271E-03_JPRB,0.29069E-03_JPRB,0.30661E-03_JPRB,0.32005E-03_JPRB /)  
KB(:,16, 4) = (/ &
 & 0.19797E-03_JPRB,0.21527E-03_JPRB,0.22955E-03_JPRB,0.24328E-03_JPRB,0.25456E-03_JPRB /)  
KB(:,17, 4) = (/ &
 & 0.15354E-03_JPRB,0.16679E-03_JPRB,0.17933E-03_JPRB,0.19101E-03_JPRB,0.20041E-03_JPRB /)  
KB(:,18, 4) = (/ &
 & 0.11742E-03_JPRB,0.12797E-03_JPRB,0.13923E-03_JPRB,0.14836E-03_JPRB,0.15654E-03_JPRB /)  
KB(:,19, 4) = (/ &
 & 0.90519E-04_JPRB,0.99386E-04_JPRB,0.10819E-03_JPRB,0.11601E-03_JPRB,0.12319E-03_JPRB /)  
KB(:,20, 4) = (/ &
 & 0.72579E-04_JPRB,0.79910E-04_JPRB,0.87075E-04_JPRB,0.93728E-04_JPRB,0.99656E-04_JPRB /)  
KB(:,21, 4) = (/ &
 & 0.58866E-04_JPRB,0.64805E-04_JPRB,0.70705E-04_JPRB,0.76153E-04_JPRB,0.80996E-04_JPRB /)  
KB(:,22, 4) = (/ &
 & 0.48157E-04_JPRB,0.52883E-04_JPRB,0.57740E-04_JPRB,0.62130E-04_JPRB,0.66100E-04_JPRB /)  
KB(:,23, 4) = (/ &
 & 0.39337E-04_JPRB,0.43289E-04_JPRB,0.47275E-04_JPRB,0.50906E-04_JPRB,0.54161E-04_JPRB /)  
KB(:,24, 4) = (/ &
 & 0.32289E-04_JPRB,0.35577E-04_JPRB,0.38808E-04_JPRB,0.41814E-04_JPRB,0.44433E-04_JPRB /)  
KB(:,25, 4) = (/ &
 & 0.26615E-04_JPRB,0.29301E-04_JPRB,0.31984E-04_JPRB,0.34396E-04_JPRB,0.36509E-04_JPRB /)  
KB(:,26, 4) = (/ &
 & 0.22060E-04_JPRB,0.24270E-04_JPRB,0.26460E-04_JPRB,0.28450E-04_JPRB,0.30203E-04_JPRB /)  
KB(:,27, 4) = (/ &
 & 0.18344E-04_JPRB,0.20177E-04_JPRB,0.21948E-04_JPRB,0.23595E-04_JPRB,0.25001E-04_JPRB /)  
KB(:,28, 4) = (/ &
 & 0.15256E-04_JPRB,0.16787E-04_JPRB,0.18242E-04_JPRB,0.19561E-04_JPRB,0.20696E-04_JPRB /)  
KB(:,29, 4) = (/ &
 & 0.12679E-04_JPRB,0.13952E-04_JPRB,0.15170E-04_JPRB,0.16211E-04_JPRB,0.17163E-04_JPRB /)  
KB(:,30, 4) = (/ &
 & 0.10550E-04_JPRB,0.11605E-04_JPRB,0.12579E-04_JPRB,0.13451E-04_JPRB,0.14210E-04_JPRB /)  
KB(:,31, 4) = (/ &
 & 0.87512E-05_JPRB,0.96322E-05_JPRB,0.10433E-04_JPRB,0.11133E-04_JPRB,0.11762E-04_JPRB /)  
KB(:,32, 4) = (/ &
 & 0.73001E-05_JPRB,0.80203E-05_JPRB,0.86745E-05_JPRB,0.92292E-05_JPRB,0.97295E-05_JPRB /)  
KB(:,33, 4) = (/ &
 & 0.60958E-05_JPRB,0.66862E-05_JPRB,0.72006E-05_JPRB,0.76359E-05_JPRB,0.80576E-05_JPRB /)  
KB(:,34, 4) = (/ &
 & 0.50855E-05_JPRB,0.55671E-05_JPRB,0.59670E-05_JPRB,0.63392E-05_JPRB,0.66869E-05_JPRB /)  
KB(:,35, 4) = (/ &
 & 0.42033E-05_JPRB,0.45905E-05_JPRB,0.49250E-05_JPRB,0.52384E-05_JPRB,0.55369E-05_JPRB /)  
KB(:,36, 4) = (/ &
 & 0.34384E-05_JPRB,0.37618E-05_JPRB,0.40430E-05_JPRB,0.43060E-05_JPRB,0.45577E-05_JPRB /)  
KB(:,37, 4) = (/ &
 & 0.28039E-05_JPRB,0.30749E-05_JPRB,0.33135E-05_JPRB,0.35344E-05_JPRB,0.37458E-05_JPRB /)  
KB(:,38, 4) = (/ &
 & 0.22842E-05_JPRB,0.25104E-05_JPRB,0.27126E-05_JPRB,0.28966E-05_JPRB,0.30768E-05_JPRB /)  
KB(:,39, 4) = (/ &
 & 0.18585E-05_JPRB,0.20510E-05_JPRB,0.22194E-05_JPRB,0.23731E-05_JPRB,0.25249E-05_JPRB /)  
KB(:,40, 4) = (/ &
 & 0.15041E-05_JPRB,0.16676E-05_JPRB,0.18097E-05_JPRB,0.19402E-05_JPRB,0.20681E-05_JPRB /)  
KB(:,41, 4) = (/ &
 & 0.12154E-05_JPRB,0.13541E-05_JPRB,0.14749E-05_JPRB,0.15852E-05_JPRB,0.16934E-05_JPRB /)  
KB(:,42, 4) = (/ &
 & 0.98033E-06_JPRB,0.10975E-05_JPRB,0.12011E-05_JPRB,0.12945E-05_JPRB,0.13859E-05_JPRB /)  
KB(:,43, 4) = (/ &
 & 0.78724E-06_JPRB,0.88625E-06_JPRB,0.97486E-06_JPRB,0.10554E-05_JPRB,0.11307E-05_JPRB /)  
KB(:,44, 4) = (/ &
 & 0.63059E-06_JPRB,0.71382E-06_JPRB,0.78948E-06_JPRB,0.85755E-06_JPRB,0.92044E-06_JPRB /)  
KB(:,45, 4) = (/ &
 & 0.50426E-06_JPRB,0.57391E-06_JPRB,0.63808E-06_JPRB,0.69718E-06_JPRB,0.74972E-06_JPRB /)  
KB(:,46, 4) = (/ &
 & 0.40133E-06_JPRB,0.45858E-06_JPRB,0.51414E-06_JPRB,0.56400E-06_JPRB,0.60964E-06_JPRB /)  
KB(:,47, 4) = (/ &
 & 0.31580E-06_JPRB,0.36440E-06_JPRB,0.41120E-06_JPRB,0.45433E-06_JPRB,0.49348E-06_JPRB /)  
KB(:,48, 4) = (/ &
 & 0.24847E-06_JPRB,0.28907E-06_JPRB,0.32879E-06_JPRB,0.36537E-06_JPRB,0.39903E-06_JPRB /)  
KB(:,49, 4) = (/ &
 & 0.19530E-06_JPRB,0.22858E-06_JPRB,0.26247E-06_JPRB,0.29331E-06_JPRB,0.32217E-06_JPRB /)  
KB(:,50, 4) = (/ &
 & 0.15364E-06_JPRB,0.18113E-06_JPRB,0.20911E-06_JPRB,0.23589E-06_JPRB,0.25994E-06_JPRB /)  
KB(:,51, 4) = (/ &
 & 0.12072E-06_JPRB,0.14413E-06_JPRB,0.16656E-06_JPRB,0.18952E-06_JPRB,0.20983E-06_JPRB /)  
KB(:,52, 4) = (/ &
 & 0.94925E-07_JPRB,0.11397E-06_JPRB,0.13255E-06_JPRB,0.15193E-06_JPRB,0.16960E-06_JPRB /)  
KB(:,53, 4) = (/ &
 & 0.74473E-07_JPRB,0.90197E-07_JPRB,0.10574E-06_JPRB,0.12153E-06_JPRB,0.13661E-06_JPRB /)  
KB(:,54, 4) = (/ &
 & 0.59009E-07_JPRB,0.71594E-07_JPRB,0.84781E-07_JPRB,0.97758E-07_JPRB,0.11018E-06_JPRB /)  
KB(:,55, 4) = (/ &
 & 0.47008E-07_JPRB,0.56997E-07_JPRB,0.67838E-07_JPRB,0.78753E-07_JPRB,0.89116E-07_JPRB /)  
KB(:,56, 4) = (/ &
 & 0.37415E-07_JPRB,0.45642E-07_JPRB,0.54420E-07_JPRB,0.63466E-07_JPRB,0.71910E-07_JPRB /)  
KB(:,57, 4) = (/ &
 & 0.29896E-07_JPRB,0.36635E-07_JPRB,0.43697E-07_JPRB,0.51036E-07_JPRB,0.58267E-07_JPRB /)  
KB(:,58, 4) = (/ &
 & 0.23946E-07_JPRB,0.29523E-07_JPRB,0.35316E-07_JPRB,0.41183E-07_JPRB,0.47391E-07_JPRB /)  
KB(:,59, 4) = (/ &
 & 0.19881E-07_JPRB,0.24642E-07_JPRB,0.29390E-07_JPRB,0.34099E-07_JPRB,0.39234E-07_JPRB /)  
KB(:,13, 5) = (/ &
 & 0.12771E-02_JPRB,0.13202E-02_JPRB,0.13557E-02_JPRB,0.13927E-02_JPRB,0.14233E-02_JPRB /)  
KB(:,14, 5) = (/ &
 & 0.10608E-02_JPRB,0.10951E-02_JPRB,0.11249E-02_JPRB,0.11549E-02_JPRB,0.11788E-02_JPRB /)  
KB(:,15, 5) = (/ &
 & 0.86750E-03_JPRB,0.89679E-03_JPRB,0.91986E-03_JPRB,0.94399E-03_JPRB,0.96405E-03_JPRB /)  
KB(:,16, 5) = (/ &
 & 0.70073E-03_JPRB,0.72504E-03_JPRB,0.74630E-03_JPRB,0.76495E-03_JPRB,0.78165E-03_JPRB /)  
KB(:,17, 5) = (/ &
 & 0.56280E-03_JPRB,0.58321E-03_JPRB,0.60153E-03_JPRB,0.61544E-03_JPRB,0.62885E-03_JPRB /)  
KB(:,18, 5) = (/ &
 & 0.44940E-03_JPRB,0.46598E-03_JPRB,0.47887E-03_JPRB,0.49058E-03_JPRB,0.50223E-03_JPRB /)  
KB(:,19, 5) = (/ &
 & 0.35753E-03_JPRB,0.37064E-03_JPRB,0.38290E-03_JPRB,0.39390E-03_JPRB,0.40387E-03_JPRB /)  
KB(:,20, 5) = (/ &
 & 0.29013E-03_JPRB,0.30099E-03_JPRB,0.31179E-03_JPRB,0.32117E-03_JPRB,0.33011E-03_JPRB /)  
KB(:,21, 5) = (/ &
 & 0.23657E-03_JPRB,0.24602E-03_JPRB,0.25504E-03_JPRB,0.26340E-03_JPRB,0.27145E-03_JPRB /)  
KB(:,22, 5) = (/ &
 & 0.19423E-03_JPRB,0.20224E-03_JPRB,0.20987E-03_JPRB,0.21711E-03_JPRB,0.22439E-03_JPRB /)  
KB(:,23, 5) = (/ &
 & 0.15963E-03_JPRB,0.16643E-03_JPRB,0.17308E-03_JPRB,0.17949E-03_JPRB,0.18580E-03_JPRB /)  
KB(:,24, 5) = (/ &
 & 0.13166E-03_JPRB,0.13745E-03_JPRB,0.14332E-03_JPRB,0.14871E-03_JPRB,0.15428E-03_JPRB /)  
KB(:,25, 5) = (/ &
 & 0.10885E-03_JPRB,0.11394E-03_JPRB,0.11896E-03_JPRB,0.12371E-03_JPRB,0.12846E-03_JPRB /)  
KB(:,26, 5) = (/ &
 & 0.90403E-04_JPRB,0.94914E-04_JPRB,0.99157E-04_JPRB,0.10310E-03_JPRB,0.10729E-03_JPRB /)  
KB(:,27, 5) = (/ &
 & 0.75265E-04_JPRB,0.79166E-04_JPRB,0.82648E-04_JPRB,0.86209E-04_JPRB,0.89882E-04_JPRB /)  
KB(:,28, 5) = (/ &
 & 0.62870E-04_JPRB,0.66050E-04_JPRB,0.69111E-04_JPRB,0.72289E-04_JPRB,0.75451E-04_JPRB /)  
KB(:,29, 5) = (/ &
 & 0.52465E-04_JPRB,0.55192E-04_JPRB,0.57887E-04_JPRB,0.60660E-04_JPRB,0.63367E-04_JPRB /)  
KB(:,30, 5) = (/ &
 & 0.43887E-04_JPRB,0.46191E-04_JPRB,0.48588E-04_JPRB,0.50910E-04_JPRB,0.53278E-04_JPRB /)  
KB(:,31, 5) = (/ &
 & 0.36760E-04_JPRB,0.38766E-04_JPRB,0.40783E-04_JPRB,0.42783E-04_JPRB,0.44780E-04_JPRB /)  
KB(:,32, 5) = (/ &
 & 0.30831E-04_JPRB,0.32561E-04_JPRB,0.34267E-04_JPRB,0.36000E-04_JPRB,0.37594E-04_JPRB /)  
KB(:,33, 5) = (/ &
 & 0.25908E-04_JPRB,0.27389E-04_JPRB,0.28832E-04_JPRB,0.30290E-04_JPRB,0.31581E-04_JPRB /)  
KB(:,34, 5) = (/ &
 & 0.21776E-04_JPRB,0.23026E-04_JPRB,0.24266E-04_JPRB,0.25444E-04_JPRB,0.26510E-04_JPRB /)  
KB(:,35, 5) = (/ &
 & 0.18233E-04_JPRB,0.19280E-04_JPRB,0.20324E-04_JPRB,0.21266E-04_JPRB,0.22141E-04_JPRB /)  
KB(:,36, 5) = (/ &
 & 0.15160E-04_JPRB,0.16042E-04_JPRB,0.16918E-04_JPRB,0.17686E-04_JPRB,0.18406E-04_JPRB /)  
KB(:,37, 5) = (/ &
 & 0.12538E-04_JPRB,0.13285E-04_JPRB,0.14015E-04_JPRB,0.14657E-04_JPRB,0.15269E-04_JPRB /)  
KB(:,38, 5) = (/ &
 & 0.10357E-04_JPRB,0.10990E-04_JPRB,0.11595E-04_JPRB,0.12148E-04_JPRB,0.12651E-04_JPRB /)  
KB(:,39, 5) = (/ &
 & 0.85566E-05_JPRB,0.90856E-05_JPRB,0.95986E-05_JPRB,0.10057E-04_JPRB,0.10478E-04_JPRB /)  
KB(:,40, 5) = (/ &
 & 0.70390E-05_JPRB,0.74826E-05_JPRB,0.79200E-05_JPRB,0.83061E-05_JPRB,0.86634E-05_JPRB /)  
KB(:,41, 5) = (/ &
 & 0.57827E-05_JPRB,0.61572E-05_JPRB,0.65269E-05_JPRB,0.68528E-05_JPRB,0.71595E-05_JPRB /)  
KB(:,42, 5) = (/ &
 & 0.47477E-05_JPRB,0.50656E-05_JPRB,0.53705E-05_JPRB,0.56486E-05_JPRB,0.59100E-05_JPRB /)  
KB(:,43, 5) = (/ &
 & 0.38802E-05_JPRB,0.41533E-05_JPRB,0.44089E-05_JPRB,0.46515E-05_JPRB,0.48719E-05_JPRB /)  
KB(:,44, 5) = (/ &
 & 0.31658E-05_JPRB,0.33971E-05_JPRB,0.36177E-05_JPRB,0.38205E-05_JPRB,0.40089E-05_JPRB /)  
KB(:,45, 5) = (/ &
 & 0.25796E-05_JPRB,0.27740E-05_JPRB,0.29635E-05_JPRB,0.31336E-05_JPRB,0.32986E-05_JPRB /)  
KB(:,46, 5) = (/ &
 & 0.20945E-05_JPRB,0.22636E-05_JPRB,0.24214E-05_JPRB,0.25698E-05_JPRB,0.27077E-05_JPRB /)  
KB(:,47, 5) = (/ &
 & 0.16931E-05_JPRB,0.18383E-05_JPRB,0.19729E-05_JPRB,0.20996E-05_JPRB,0.22172E-05_JPRB /)  
KB(:,48, 5) = (/ &
 & 0.13650E-05_JPRB,0.14889E-05_JPRB,0.16043E-05_JPRB,0.17139E-05_JPRB,0.18136E-05_JPRB /)  
KB(:,49, 5) = (/ &
 & 0.10981E-05_JPRB,0.12042E-05_JPRB,0.13028E-05_JPRB,0.13963E-05_JPRB,0.14824E-05_JPRB /)  
KB(:,50, 5) = (/ &
 & 0.88407E-06_JPRB,0.97370E-06_JPRB,0.10589E-05_JPRB,0.11383E-05_JPRB,0.12124E-05_JPRB /)  
KB(:,51, 5) = (/ &
 & 0.71150E-06_JPRB,0.78682E-06_JPRB,0.86048E-06_JPRB,0.92711E-06_JPRB,0.99128E-06_JPRB /)  
KB(:,52, 5) = (/ &
 & 0.57140E-06_JPRB,0.63513E-06_JPRB,0.69790E-06_JPRB,0.75466E-06_JPRB,0.80946E-06_JPRB /)  
KB(:,53, 5) = (/ &
 & 0.45871E-06_JPRB,0.51183E-06_JPRB,0.56494E-06_JPRB,0.61376E-06_JPRB,0.66022E-06_JPRB /)  
KB(:,54, 5) = (/ &
 & 0.36889E-06_JPRB,0.41319E-06_JPRB,0.45759E-06_JPRB,0.49973E-06_JPRB,0.53933E-06_JPRB /)  
KB(:,55, 5) = (/ &
 & 0.29683E-06_JPRB,0.33396E-06_JPRB,0.37110E-06_JPRB,0.40671E-06_JPRB,0.44026E-06_JPRB /)  
KB(:,56, 5) = (/ &
 & 0.23828E-06_JPRB,0.26973E-06_JPRB,0.30048E-06_JPRB,0.33099E-06_JPRB,0.35949E-06_JPRB /)  
KB(:,57, 5) = (/ &
 & 0.19083E-06_JPRB,0.21782E-06_JPRB,0.24350E-06_JPRB,0.26883E-06_JPRB,0.29309E-06_JPRB /)  
KB(:,58, 5) = (/ &
 & 0.15334E-06_JPRB,0.17592E-06_JPRB,0.19753E-06_JPRB,0.21869E-06_JPRB,0.23903E-06_JPRB /)  
KB(:,59, 5) = (/ &
 & 0.12635E-06_JPRB,0.14504E-06_JPRB,0.16321E-06_JPRB,0.18074E-06_JPRB,0.19759E-06_JPRB /)  
KB(:,13, 6) = (/ &
 & 0.33433E-02_JPRB,0.34159E-02_JPRB,0.34798E-02_JPRB,0.35397E-02_JPRB,0.35995E-02_JPRB /)  
KB(:,14, 6) = (/ &
 & 0.28039E-02_JPRB,0.28589E-02_JPRB,0.29090E-02_JPRB,0.29595E-02_JPRB,0.30108E-02_JPRB /)  
KB(:,15, 6) = (/ &
 & 0.23135E-02_JPRB,0.23579E-02_JPRB,0.24012E-02_JPRB,0.24470E-02_JPRB,0.24900E-02_JPRB /)  
KB(:,16, 6) = (/ &
 & 0.18925E-02_JPRB,0.19281E-02_JPRB,0.19671E-02_JPRB,0.20090E-02_JPRB,0.20445E-02_JPRB /)  
KB(:,17, 6) = (/ &
 & 0.15365E-02_JPRB,0.15703E-02_JPRB,0.16039E-02_JPRB,0.16424E-02_JPRB,0.16760E-02_JPRB /)  
KB(:,18, 6) = (/ &
 & 0.12424E-02_JPRB,0.12746E-02_JPRB,0.13067E-02_JPRB,0.13397E-02_JPRB,0.13687E-02_JPRB /)  
KB(:,19, 6) = (/ &
 & 0.10113E-02_JPRB,0.10417E-02_JPRB,0.10664E-02_JPRB,0.10958E-02_JPRB,0.11231E-02_JPRB /)  
KB(:,20, 6) = (/ &
 & 0.83375E-03_JPRB,0.85863E-03_JPRB,0.88098E-03_JPRB,0.90680E-03_JPRB,0.93093E-03_JPRB /)  
KB(:,21, 6) = (/ &
 & 0.68849E-03_JPRB,0.71056E-03_JPRB,0.73161E-03_JPRB,0.75402E-03_JPRB,0.77432E-03_JPRB /)  
KB(:,22, 6) = (/ &
 & 0.57076E-03_JPRB,0.59001E-03_JPRB,0.60925E-03_JPRB,0.62816E-03_JPRB,0.64531E-03_JPRB /)  
KB(:,23, 6) = (/ &
 & 0.47462E-03_JPRB,0.49138E-03_JPRB,0.50818E-03_JPRB,0.52421E-03_JPRB,0.53930E-03_JPRB /)  
KB(:,24, 6) = (/ &
 & 0.39552E-03_JPRB,0.41011E-03_JPRB,0.42460E-03_JPRB,0.43865E-03_JPRB,0.45206E-03_JPRB /)  
KB(:,25, 6) = (/ &
 & 0.33041E-03_JPRB,0.34317E-03_JPRB,0.35573E-03_JPRB,0.36800E-03_JPRB,0.38005E-03_JPRB /)  
KB(:,26, 6) = (/ &
 & 0.27699E-03_JPRB,0.28806E-03_JPRB,0.29892E-03_JPRB,0.30983E-03_JPRB,0.32038E-03_JPRB /)  
KB(:,27, 6) = (/ &
 & 0.23253E-03_JPRB,0.24229E-03_JPRB,0.25208E-03_JPRB,0.26144E-03_JPRB,0.27039E-03_JPRB /)  
KB(:,28, 6) = (/ &
 & 0.19573E-03_JPRB,0.20442E-03_JPRB,0.21276E-03_JPRB,0.22087E-03_JPRB,0.22869E-03_JPRB /)  
KB(:,29, 6) = (/ &
 & 0.16528E-03_JPRB,0.17271E-03_JPRB,0.17974E-03_JPRB,0.18681E-03_JPRB,0.19373E-03_JPRB /)  
KB(:,30, 6) = (/ &
 & 0.13949E-03_JPRB,0.14599E-03_JPRB,0.15214E-03_JPRB,0.15834E-03_JPRB,0.16448E-03_JPRB /)  
KB(:,31, 6) = (/ &
 & 0.11793E-03_JPRB,0.12345E-03_JPRB,0.12891E-03_JPRB,0.13432E-03_JPRB,0.13975E-03_JPRB /)  
KB(:,32, 6) = (/ &
 & 0.99845E-04_JPRB,0.10464E-03_JPRB,0.10941E-03_JPRB,0.11425E-03_JPRB,0.11896E-03_JPRB /)  
KB(:,33, 6) = (/ &
 & 0.84723E-04_JPRB,0.88808E-04_JPRB,0.93054E-04_JPRB,0.97257E-04_JPRB,0.10144E-03_JPRB /)  
KB(:,34, 6) = (/ &
 & 0.71857E-04_JPRB,0.75478E-04_JPRB,0.79245E-04_JPRB,0.82878E-04_JPRB,0.86527E-04_JPRB /)  
KB(:,35, 6) = (/ &
 & 0.60741E-04_JPRB,0.63987E-04_JPRB,0.67190E-04_JPRB,0.70445E-04_JPRB,0.73634E-04_JPRB /)  
KB(:,36, 6) = (/ &
 & 0.51094E-04_JPRB,0.53953E-04_JPRB,0.56787E-04_JPRB,0.59644E-04_JPRB,0.62421E-04_JPRB /)  
KB(:,37, 6) = (/ &
 & 0.42809E-04_JPRB,0.45324E-04_JPRB,0.47805E-04_JPRB,0.50314E-04_JPRB,0.52797E-04_JPRB /)  
KB(:,38, 6) = (/ &
 & 0.35862E-04_JPRB,0.38082E-04_JPRB,0.40249E-04_JPRB,0.42459E-04_JPRB,0.44691E-04_JPRB /)  
KB(:,39, 6) = (/ &
 & 0.30047E-04_JPRB,0.31970E-04_JPRB,0.33877E-04_JPRB,0.35841E-04_JPRB,0.37792E-04_JPRB /)  
KB(:,40, 6) = (/ &
 & 0.25051E-04_JPRB,0.26734E-04_JPRB,0.28429E-04_JPRB,0.30177E-04_JPRB,0.31859E-04_JPRB /)  
KB(:,41, 6) = (/ &
 & 0.20858E-04_JPRB,0.22337E-04_JPRB,0.23837E-04_JPRB,0.25348E-04_JPRB,0.26845E-04_JPRB /)  
KB(:,42, 6) = (/ &
 & 0.17358E-04_JPRB,0.18653E-04_JPRB,0.19947E-04_JPRB,0.21279E-04_JPRB,0.22614E-04_JPRB /)  
KB(:,43, 6) = (/ &
 & 0.14382E-04_JPRB,0.15507E-04_JPRB,0.16637E-04_JPRB,0.17808E-04_JPRB,0.18975E-04_JPRB /)  
KB(:,44, 6) = (/ &
 & 0.11875E-04_JPRB,0.12851E-04_JPRB,0.13847E-04_JPRB,0.14865E-04_JPRB,0.15886E-04_JPRB /)  
KB(:,45, 6) = (/ &
 & 0.97824E-05_JPRB,0.10641E-04_JPRB,0.11497E-04_JPRB,0.12386E-04_JPRB,0.13288E-04_JPRB /)  
KB(:,46, 6) = (/ &
 & 0.80305E-05_JPRB,0.87712E-05_JPRB,0.95170E-05_JPRB,0.10282E-04_JPRB,0.11073E-04_JPRB /)  
KB(:,47, 6) = (/ &
 & 0.65554E-05_JPRB,0.71881E-05_JPRB,0.78331E-05_JPRB,0.85022E-05_JPRB,0.91799E-05_JPRB /)  
KB(:,48, 6) = (/ &
 & 0.53399E-05_JPRB,0.58818E-05_JPRB,0.64364E-05_JPRB,0.70093E-05_JPRB,0.75992E-05_JPRB /)  
KB(:,49, 6) = (/ &
 & 0.43396E-05_JPRB,0.47990E-05_JPRB,0.52727E-05_JPRB,0.57633E-05_JPRB,0.62785E-05_JPRB /)  
KB(:,50, 6) = (/ &
 & 0.35272E-05_JPRB,0.39139E-05_JPRB,0.43230E-05_JPRB,0.47423E-05_JPRB,0.51819E-05_JPRB /)  
KB(:,51, 6) = (/ &
 & 0.28624E-05_JPRB,0.31913E-05_JPRB,0.35379E-05_JPRB,0.38979E-05_JPRB,0.42744E-05_JPRB /)  
KB(:,52, 6) = (/ &
 & 0.23189E-05_JPRB,0.25961E-05_JPRB,0.28907E-05_JPRB,0.31976E-05_JPRB,0.35200E-05_JPRB /)  
KB(:,53, 6) = (/ &
 & 0.18736E-05_JPRB,0.21072E-05_JPRB,0.23576E-05_JPRB,0.26179E-05_JPRB,0.28943E-05_JPRB /)  
KB(:,54, 6) = (/ &
 & 0.15155E-05_JPRB,0.17135E-05_JPRB,0.19245E-05_JPRB,0.21451E-05_JPRB,0.23808E-05_JPRB /)  
KB(:,55, 6) = (/ &
 & 0.12250E-05_JPRB,0.13923E-05_JPRB,0.15714E-05_JPRB,0.17578E-05_JPRB,0.19597E-05_JPRB /)  
KB(:,56, 6) = (/ &
 & 0.99012E-06_JPRB,0.11296E-05_JPRB,0.12801E-05_JPRB,0.14395E-05_JPRB,0.16107E-05_JPRB /)  
KB(:,57, 6) = (/ &
 & 0.79875E-06_JPRB,0.91418E-06_JPRB,0.10408E-05_JPRB,0.11777E-05_JPRB,0.13212E-05_JPRB /)  
KB(:,58, 6) = (/ &
 & 0.64474E-06_JPRB,0.74109E-06_JPRB,0.84664E-06_JPRB,0.96328E-06_JPRB,0.10849E-05_JPRB /)  
KB(:,59, 6) = (/ &
 & 0.53296E-06_JPRB,0.61427E-06_JPRB,0.70385E-06_JPRB,0.80375E-06_JPRB,0.90863E-06_JPRB /)  
KB(:,13, 7) = (/ &
 & 0.91063E-02_JPRB,0.92681E-02_JPRB,0.94045E-02_JPRB,0.95388E-02_JPRB,0.96735E-02_JPRB /)  
KB(:,14, 7) = (/ &
 & 0.78483E-02_JPRB,0.79806E-02_JPRB,0.81238E-02_JPRB,0.82528E-02_JPRB,0.83603E-02_JPRB /)  
KB(:,15, 7) = (/ &
 & 0.66269E-02_JPRB,0.67445E-02_JPRB,0.68845E-02_JPRB,0.69911E-02_JPRB,0.70854E-02_JPRB /)  
KB(:,16, 7) = (/ &
 & 0.55183E-02_JPRB,0.56414E-02_JPRB,0.57574E-02_JPRB,0.58487E-02_JPRB,0.59407E-02_JPRB /)  
KB(:,17, 7) = (/ &
 & 0.45693E-02_JPRB,0.46780E-02_JPRB,0.47743E-02_JPRB,0.48625E-02_JPRB,0.49467E-02_JPRB /)  
KB(:,18, 7) = (/ &
 & 0.37611E-02_JPRB,0.38535E-02_JPRB,0.39408E-02_JPRB,0.40234E-02_JPRB,0.41007E-02_JPRB /)  
KB(:,19, 7) = (/ &
 & 0.30991E-02_JPRB,0.31809E-02_JPRB,0.32647E-02_JPRB,0.33388E-02_JPRB,0.34042E-02_JPRB /)  
KB(:,20, 7) = (/ &
 & 0.25858E-02_JPRB,0.26585E-02_JPRB,0.27347E-02_JPRB,0.27990E-02_JPRB,0.28579E-02_JPRB /)  
KB(:,21, 7) = (/ &
 & 0.21672E-02_JPRB,0.22326E-02_JPRB,0.22973E-02_JPRB,0.23547E-02_JPRB,0.24058E-02_JPRB /)  
KB(:,22, 7) = (/ &
 & 0.18211E-02_JPRB,0.18809E-02_JPRB,0.19364E-02_JPRB,0.19859E-02_JPRB,0.20352E-02_JPRB /)  
KB(:,23, 7) = (/ &
 & 0.15314E-02_JPRB,0.15844E-02_JPRB,0.16332E-02_JPRB,0.16760E-02_JPRB,0.17243E-02_JPRB /)  
KB(:,24, 7) = (/ &
 & 0.12924E-02_JPRB,0.13385E-02_JPRB,0.13793E-02_JPRB,0.14209E-02_JPRB,0.14659E-02_JPRB /)  
KB(:,25, 7) = (/ &
 & 0.10926E-02_JPRB,0.11322E-02_JPRB,0.11689E-02_JPRB,0.12081E-02_JPRB,0.12493E-02_JPRB /)  
KB(:,26, 7) = (/ &
 & 0.92756E-03_JPRB,0.96136E-03_JPRB,0.99601E-03_JPRB,0.10324E-02_JPRB,0.10695E-02_JPRB /)  
KB(:,27, 7) = (/ &
 & 0.78832E-03_JPRB,0.81893E-03_JPRB,0.85137E-03_JPRB,0.88465E-03_JPRB,0.91885E-03_JPRB /)  
KB(:,28, 7) = (/ &
 & 0.67097E-03_JPRB,0.69979E-03_JPRB,0.72985E-03_JPRB,0.76038E-03_JPRB,0.79213E-03_JPRB /)  
KB(:,29, 7) = (/ &
 & 0.57231E-03_JPRB,0.59934E-03_JPRB,0.62727E-03_JPRB,0.65471E-03_JPRB,0.68389E-03_JPRB /)  
KB(:,30, 7) = (/ &
 & 0.48996E-03_JPRB,0.51441E-03_JPRB,0.53945E-03_JPRB,0.56564E-03_JPRB,0.59164E-03_JPRB /)  
KB(:,31, 7) = (/ &
 & 0.41998E-03_JPRB,0.44237E-03_JPRB,0.46551E-03_JPRB,0.48924E-03_JPRB,0.51322E-03_JPRB /)  
KB(:,32, 7) = (/ &
 & 0.36133E-03_JPRB,0.38168E-03_JPRB,0.40297E-03_JPRB,0.42441E-03_JPRB,0.44722E-03_JPRB /)  
KB(:,33, 7) = (/ &
 & 0.31153E-03_JPRB,0.33055E-03_JPRB,0.34980E-03_JPRB,0.36972E-03_JPRB,0.39086E-03_JPRB /)  
KB(:,34, 7) = (/ &
 & 0.26941E-03_JPRB,0.28657E-03_JPRB,0.30436E-03_JPRB,0.32295E-03_JPRB,0.34256E-03_JPRB /)  
KB(:,35, 7) = (/ &
 & 0.23210E-03_JPRB,0.24782E-03_JPRB,0.26411E-03_JPRB,0.28121E-03_JPRB,0.29930E-03_JPRB /)  
KB(:,36, 7) = (/ &
 & 0.19904E-03_JPRB,0.21311E-03_JPRB,0.22797E-03_JPRB,0.24380E-03_JPRB,0.26030E-03_JPRB /)  
KB(:,37, 7) = (/ &
 & 0.17000E-03_JPRB,0.18300E-03_JPRB,0.19666E-03_JPRB,0.21128E-03_JPRB,0.22641E-03_JPRB /)  
KB(:,38, 7) = (/ &
 & 0.14528E-03_JPRB,0.15704E-03_JPRB,0.16975E-03_JPRB,0.18320E-03_JPRB,0.19735E-03_JPRB /)  
KB(:,39, 7) = (/ &
 & 0.12414E-03_JPRB,0.13496E-03_JPRB,0.14654E-03_JPRB,0.15899E-03_JPRB,0.17211E-03_JPRB /)  
KB(:,40, 7) = (/ &
 & 0.10567E-03_JPRB,0.11547E-03_JPRB,0.12618E-03_JPRB,0.13765E-03_JPRB,0.14994E-03_JPRB /)  
KB(:,41, 7) = (/ &
 & 0.89774E-04_JPRB,0.98751E-04_JPRB,0.10852E-03_JPRB,0.11918E-03_JPRB,0.13057E-03_JPRB /)  
KB(:,42, 7) = (/ &
 & 0.76232E-04_JPRB,0.84383E-04_JPRB,0.93336E-04_JPRB,0.10314E-03_JPRB,0.11381E-03_JPRB /)  
KB(:,43, 7) = (/ &
 & 0.64370E-04_JPRB,0.71684E-04_JPRB,0.79797E-04_JPRB,0.88850E-04_JPRB,0.98733E-04_JPRB /)  
KB(:,44, 7) = (/ &
 & 0.54125E-04_JPRB,0.60680E-04_JPRB,0.68042E-04_JPRB,0.76313E-04_JPRB,0.85432E-04_JPRB /)  
KB(:,45, 7) = (/ &
 & 0.45374E-04_JPRB,0.51280E-04_JPRB,0.57932E-04_JPRB,0.65429E-04_JPRB,0.73852E-04_JPRB /)  
KB(:,46, 7) = (/ &
 & 0.37861E-04_JPRB,0.43078E-04_JPRB,0.49016E-04_JPRB,0.55844E-04_JPRB,0.63538E-04_JPRB /)  
KB(:,47, 7) = (/ &
 & 0.31342E-04_JPRB,0.35879E-04_JPRB,0.41175E-04_JPRB,0.47252E-04_JPRB,0.54286E-04_JPRB /)  
KB(:,48, 7) = (/ &
 & 0.25821E-04_JPRB,0.29777E-04_JPRB,0.34458E-04_JPRB,0.39880E-04_JPRB,0.46218E-04_JPRB /)  
KB(:,49, 7) = (/ &
 & 0.21180E-04_JPRB,0.24617E-04_JPRB,0.28719E-04_JPRB,0.33507E-04_JPRB,0.39184E-04_JPRB /)  
KB(:,50, 7) = (/ &
 & 0.17377E-04_JPRB,0.20345E-04_JPRB,0.23916E-04_JPRB,0.28177E-04_JPRB,0.33237E-04_JPRB /)  
KB(:,51, 7) = (/ &
 & 0.14223E-04_JPRB,0.16790E-04_JPRB,0.19868E-04_JPRB,0.23656E-04_JPRB,0.28163E-04_JPRB /)  
KB(:,52, 7) = (/ &
 & 0.11593E-04_JPRB,0.13788E-04_JPRB,0.16479E-04_JPRB,0.19773E-04_JPRB,0.23765E-04_JPRB /)  
KB(:,53, 7) = (/ &
 & 0.94141E-05_JPRB,0.11279E-04_JPRB,0.13591E-04_JPRB,0.16447E-04_JPRB,0.19969E-04_JPRB /)  
KB(:,54, 7) = (/ &
 & 0.76622E-05_JPRB,0.92417E-05_JPRB,0.11233E-04_JPRB,0.13709E-04_JPRB,0.16819E-04_JPRB /)  
KB(:,55, 7) = (/ &
 & 0.62315E-05_JPRB,0.75671E-05_JPRB,0.92699E-05_JPRB,0.11429E-04_JPRB,0.14186E-04_JPRB /)  
KB(:,56, 7) = (/ &
 & 0.50473E-05_JPRB,0.61766E-05_JPRB,0.76316E-05_JPRB,0.94979E-05_JPRB,0.11890E-04_JPRB /)  
KB(:,57, 7) = (/ &
 & 0.40773E-05_JPRB,0.50242E-05_JPRB,0.62540E-05_JPRB,0.78594E-05_JPRB,0.99378E-05_JPRB /)  
KB(:,58, 7) = (/ &
 & 0.32937E-05_JPRB,0.40862E-05_JPRB,0.51228E-05_JPRB,0.64992E-05_JPRB,0.83112E-05_JPRB /)  
KB(:,59, 7) = (/ &
 & 0.27593E-05_JPRB,0.34505E-05_JPRB,0.43716E-05_JPRB,0.56035E-05_JPRB,0.72609E-05_JPRB /)  
KB(:,13, 8) = (/ &
 & 0.25990E-01_JPRB,0.25997E-01_JPRB,0.26024E-01_JPRB,0.26038E-01_JPRB,0.26132E-01_JPRB /)  
KB(:,14, 8) = (/ &
 & 0.22648E-01_JPRB,0.22731E-01_JPRB,0.22803E-01_JPRB,0.22861E-01_JPRB,0.23020E-01_JPRB /)  
KB(:,15, 8) = (/ &
 & 0.19641E-01_JPRB,0.19812E-01_JPRB,0.19880E-01_JPRB,0.19998E-01_JPRB,0.20141E-01_JPRB /)  
KB(:,16, 8) = (/ &
 & 0.16909E-01_JPRB,0.17030E-01_JPRB,0.17148E-01_JPRB,0.17296E-01_JPRB,0.17502E-01_JPRB /)  
KB(:,17, 8) = (/ &
 & 0.14365E-01_JPRB,0.14504E-01_JPRB,0.14643E-01_JPRB,0.14808E-01_JPRB,0.14996E-01_JPRB /)  
KB(:,18, 8) = (/ &
 & 0.12072E-01_JPRB,0.12207E-01_JPRB,0.12346E-01_JPRB,0.12513E-01_JPRB,0.12742E-01_JPRB /)  
KB(:,19, 8) = (/ &
 & 0.10135E-01_JPRB,0.10263E-01_JPRB,0.10402E-01_JPRB,0.10602E-01_JPRB,0.10794E-01_JPRB /)  
KB(:,20, 8) = (/ &
 & 0.86508E-02_JPRB,0.87951E-02_JPRB,0.89765E-02_JPRB,0.91530E-02_JPRB,0.93447E-02_JPRB /)  
KB(:,21, 8) = (/ &
 & 0.74228E-02_JPRB,0.75964E-02_JPRB,0.77805E-02_JPRB,0.79441E-02_JPRB,0.81266E-02_JPRB /)  
KB(:,22, 8) = (/ &
 & 0.63949E-02_JPRB,0.65920E-02_JPRB,0.67584E-02_JPRB,0.69298E-02_JPRB,0.70968E-02_JPRB /)  
KB(:,23, 8) = (/ &
 & 0.55389E-02_JPRB,0.57165E-02_JPRB,0.58834E-02_JPRB,0.60490E-02_JPRB,0.62163E-02_JPRB /)  
KB(:,24, 8) = (/ &
 & 0.47980E-02_JPRB,0.49696E-02_JPRB,0.51333E-02_JPRB,0.53055E-02_JPRB,0.54695E-02_JPRB /)  
KB(:,25, 8) = (/ &
 & 0.41676E-02_JPRB,0.43357E-02_JPRB,0.44999E-02_JPRB,0.46749E-02_JPRB,0.48179E-02_JPRB /)  
KB(:,26, 8) = (/ &
 & 0.36391E-02_JPRB,0.38079E-02_JPRB,0.39834E-02_JPRB,0.41374E-02_JPRB,0.42754E-02_JPRB /)  
KB(:,27, 8) = (/ &
 & 0.31917E-02_JPRB,0.33580E-02_JPRB,0.35237E-02_JPRB,0.36737E-02_JPRB,0.37982E-02_JPRB /)  
KB(:,28, 8) = (/ &
 & 0.28096E-02_JPRB,0.29709E-02_JPRB,0.31242E-02_JPRB,0.32613E-02_JPRB,0.33829E-02_JPRB /)  
KB(:,29, 8) = (/ &
 & 0.24786E-02_JPRB,0.26272E-02_JPRB,0.27706E-02_JPRB,0.28986E-02_JPRB,0.30130E-02_JPRB /)  
KB(:,30, 8) = (/ &
 & 0.21907E-02_JPRB,0.23282E-02_JPRB,0.24574E-02_JPRB,0.25778E-02_JPRB,0.26806E-02_JPRB /)  
KB(:,31, 8) = (/ &
 & 0.19346E-02_JPRB,0.20569E-02_JPRB,0.21757E-02_JPRB,0.22805E-02_JPRB,0.23742E-02_JPRB /)  
KB(:,32, 8) = (/ &
 & 0.17101E-02_JPRB,0.18247E-02_JPRB,0.19308E-02_JPRB,0.20256E-02_JPRB,0.21176E-02_JPRB /)  
KB(:,33, 8) = (/ &
 & 0.15171E-02_JPRB,0.16168E-02_JPRB,0.17121E-02_JPRB,0.18035E-02_JPRB,0.18911E-02_JPRB /)  
KB(:,34, 8) = (/ &
 & 0.13466E-02_JPRB,0.14390E-02_JPRB,0.15246E-02_JPRB,0.16083E-02_JPRB,0.16921E-02_JPRB /)  
KB(:,35, 8) = (/ &
 & 0.11871E-02_JPRB,0.12698E-02_JPRB,0.13534E-02_JPRB,0.14320E-02_JPRB,0.15071E-02_JPRB /)  
KB(:,36, 8) = (/ &
 & 0.10388E-02_JPRB,0.11179E-02_JPRB,0.11934E-02_JPRB,0.12647E-02_JPRB,0.13391E-02_JPRB /)  
KB(:,37, 8) = (/ &
 & 0.92233E-03_JPRB,0.99854E-03_JPRB,0.10722E-02_JPRB,0.11426E-02_JPRB,0.12118E-02_JPRB /)  
KB(:,38, 8) = (/ &
 & 0.81843E-03_JPRB,0.89236E-03_JPRB,0.96605E-03_JPRB,0.10340E-02_JPRB,0.11003E-02_JPRB /)  
KB(:,39, 8) = (/ &
 & 0.72738E-03_JPRB,0.79777E-03_JPRB,0.86997E-03_JPRB,0.93496E-03_JPRB,0.99852E-03_JPRB /)  
KB(:,40, 8) = (/ &
 & 0.65149E-03_JPRB,0.72098E-03_JPRB,0.79235E-03_JPRB,0.86116E-03_JPRB,0.92474E-03_JPRB /)  
KB(:,41, 8) = (/ &
 & 0.58318E-03_JPRB,0.65154E-03_JPRB,0.72160E-03_JPRB,0.79400E-03_JPRB,0.85973E-03_JPRB /)  
KB(:,42, 8) = (/ &
 & 0.52127E-03_JPRB,0.58770E-03_JPRB,0.65781E-03_JPRB,0.73110E-03_JPRB,0.80165E-03_JPRB /)  
KB(:,43, 8) = (/ &
 & 0.46404E-03_JPRB,0.52960E-03_JPRB,0.59886E-03_JPRB,0.67366E-03_JPRB,0.74727E-03_JPRB /)  
KB(:,44, 8) = (/ &
 & 0.41229E-03_JPRB,0.47609E-03_JPRB,0.54424E-03_JPRB,0.61918E-03_JPRB,0.69366E-03_JPRB /)  
KB(:,45, 8) = (/ &
 & 0.36534E-03_JPRB,0.42624E-03_JPRB,0.49374E-03_JPRB,0.56668E-03_JPRB,0.64364E-03_JPRB /)  
KB(:,46, 8) = (/ &
 & 0.32134E-03_JPRB,0.37987E-03_JPRB,0.44597E-03_JPRB,0.51669E-03_JPRB,0.59469E-03_JPRB /)  
KB(:,47, 8) = (/ &
 & 0.27855E-03_JPRB,0.33531E-03_JPRB,0.39855E-03_JPRB,0.46832E-03_JPRB,0.54562E-03_JPRB /)  
KB(:,48, 8) = (/ &
 & 0.24094E-03_JPRB,0.29440E-03_JPRB,0.35477E-03_JPRB,0.42284E-03_JPRB,0.49767E-03_JPRB /)  
KB(:,49, 8) = (/ &
 & 0.20710E-03_JPRB,0.25712E-03_JPRB,0.31425E-03_JPRB,0.38098E-03_JPRB,0.45465E-03_JPRB /)  
KB(:,50, 8) = (/ &
 & 0.17757E-03_JPRB,0.22422E-03_JPRB,0.27906E-03_JPRB,0.34231E-03_JPRB,0.41419E-03_JPRB /)  
KB(:,51, 8) = (/ &
 & 0.15198E-03_JPRB,0.19538E-03_JPRB,0.24758E-03_JPRB,0.30796E-03_JPRB,0.37765E-03_JPRB /)  
KB(:,52, 8) = (/ &
 & 0.12943E-03_JPRB,0.16907E-03_JPRB,0.21812E-03_JPRB,0.27585E-03_JPRB,0.34284E-03_JPRB /)  
KB(:,53, 8) = (/ &
 & 0.10946E-03_JPRB,0.14560E-03_JPRB,0.19103E-03_JPRB,0.24633E-03_JPRB,0.31049E-03_JPRB /)  
KB(:,54, 8) = (/ &
 & 0.92950E-04_JPRB,0.12599E-03_JPRB,0.16848E-03_JPRB,0.22109E-03_JPRB,0.28266E-03_JPRB /)  
KB(:,55, 8) = (/ &
 & 0.78722E-04_JPRB,0.10883E-03_JPRB,0.14831E-03_JPRB,0.19790E-03_JPRB,0.25770E-03_JPRB /)  
KB(:,56, 8) = (/ &
 & 0.66323E-04_JPRB,0.93651E-04_JPRB,0.12983E-03_JPRB,0.17638E-03_JPRB,0.23393E-03_JPRB /)  
KB(:,57, 8) = (/ &
 & 0.55644E-04_JPRB,0.80085E-04_JPRB,0.11349E-03_JPRB,0.15741E-03_JPRB,0.21274E-03_JPRB /)  
KB(:,58, 8) = (/ &
 & 0.46537E-04_JPRB,0.68442E-04_JPRB,0.99190E-04_JPRB,0.14045E-03_JPRB,0.19327E-03_JPRB /)  
KB(:,59, 8) = (/ &
 & 0.41558E-04_JPRB,0.62503E-04_JPRB,0.92377E-04_JPRB,0.13258E-03_JPRB,0.18528E-03_JPRB /)  
KB(:,13, 9) = (/ &
 & 0.14836E+00_JPRB,0.15039E+00_JPRB,0.15239E+00_JPRB,0.15389E+00_JPRB,0.15517E+00_JPRB /)  
KB(:,14, 9) = (/ &
 & 0.12935E+00_JPRB,0.13183E+00_JPRB,0.13366E+00_JPRB,0.13551E+00_JPRB,0.13674E+00_JPRB /)  
KB(:,15, 9) = (/ &
 & 0.11269E+00_JPRB,0.11456E+00_JPRB,0.11672E+00_JPRB,0.11824E+00_JPRB,0.11951E+00_JPRB /)  
KB(:,16, 9) = (/ &
 & 0.97577E-01_JPRB,0.99647E-01_JPRB,0.10140E+00_JPRB,0.10272E+00_JPRB,0.10390E+00_JPRB /)  
KB(:,17, 9) = (/ &
 & 0.84601E-01_JPRB,0.86370E-01_JPRB,0.87860E-01_JPRB,0.89144E-01_JPRB,0.90341E-01_JPRB /)  
KB(:,18, 9) = (/ &
 & 0.72851E-01_JPRB,0.74498E-01_JPRB,0.75924E-01_JPRB,0.77220E-01_JPRB,0.78434E-01_JPRB /)  
KB(:,19, 9) = (/ &
 & 0.62688E-01_JPRB,0.64121E-01_JPRB,0.65574E-01_JPRB,0.66965E-01_JPRB,0.68243E-01_JPRB /)  
KB(:,20, 9) = (/ &
 & 0.54382E-01_JPRB,0.55704E-01_JPRB,0.57013E-01_JPRB,0.58303E-01_JPRB,0.59763E-01_JPRB /)  
KB(:,21, 9) = (/ &
 & 0.47190E-01_JPRB,0.48469E-01_JPRB,0.49752E-01_JPRB,0.51138E-01_JPRB,0.52452E-01_JPRB /)  
KB(:,22, 9) = (/ &
 & 0.41104E-01_JPRB,0.42378E-01_JPRB,0.43684E-01_JPRB,0.45035E-01_JPRB,0.46495E-01_JPRB /)  
KB(:,23, 9) = (/ &
 & 0.35910E-01_JPRB,0.37220E-01_JPRB,0.38484E-01_JPRB,0.39789E-01_JPRB,0.41443E-01_JPRB /)  
KB(:,24, 9) = (/ &
 & 0.31558E-01_JPRB,0.32836E-01_JPRB,0.34085E-01_JPRB,0.35462E-01_JPRB,0.37160E-01_JPRB /)  
KB(:,25, 9) = (/ &
 & 0.27861E-01_JPRB,0.29090E-01_JPRB,0.30363E-01_JPRB,0.31857E-01_JPRB,0.33566E-01_JPRB /)  
KB(:,26, 9) = (/ &
 & 0.24743E-01_JPRB,0.26003E-01_JPRB,0.27311E-01_JPRB,0.28788E-01_JPRB,0.30553E-01_JPRB /)  
KB(:,27, 9) = (/ &
 & 0.22141E-01_JPRB,0.23397E-01_JPRB,0.24754E-01_JPRB,0.26282E-01_JPRB,0.28040E-01_JPRB /)  
KB(:,28, 9) = (/ &
 & 0.19941E-01_JPRB,0.21165E-01_JPRB,0.22565E-01_JPRB,0.24131E-01_JPRB,0.25980E-01_JPRB /)  
KB(:,29, 9) = (/ &
 & 0.18046E-01_JPRB,0.19353E-01_JPRB,0.20736E-01_JPRB,0.22375E-01_JPRB,0.24248E-01_JPRB /)  
KB(:,30, 9) = (/ &
 & 0.16429E-01_JPRB,0.17775E-01_JPRB,0.19238E-01_JPRB,0.20907E-01_JPRB,0.22847E-01_JPRB /)  
KB(:,31, 9) = (/ &
 & 0.15094E-01_JPRB,0.16450E-01_JPRB,0.17992E-01_JPRB,0.19741E-01_JPRB,0.21608E-01_JPRB /)  
KB(:,32, 9) = (/ &
 & 0.13975E-01_JPRB,0.15315E-01_JPRB,0.16950E-01_JPRB,0.18741E-01_JPRB,0.20564E-01_JPRB /)  
KB(:,33, 9) = (/ &
 & 0.13026E-01_JPRB,0.14475E-01_JPRB,0.16113E-01_JPRB,0.17903E-01_JPRB,0.19794E-01_JPRB /)  
KB(:,34, 9) = (/ &
 & 0.12248E-01_JPRB,0.13747E-01_JPRB,0.15391E-01_JPRB,0.17142E-01_JPRB,0.19155E-01_JPRB /)  
KB(:,35, 9) = (/ &
 & 0.11491E-01_JPRB,0.12979E-01_JPRB,0.14611E-01_JPRB,0.16423E-01_JPRB,0.18475E-01_JPRB /)  
KB(:,36, 9) = (/ &
 & 0.10695E-01_JPRB,0.12142E-01_JPRB,0.13822E-01_JPRB,0.15678E-01_JPRB,0.17729E-01_JPRB /)  
KB(:,37, 9) = (/ &
 & 0.98761E-02_JPRB,0.11300E-01_JPRB,0.13000E-01_JPRB,0.14808E-01_JPRB,0.16848E-01_JPRB /)  
KB(:,38, 9) = (/ &
 & 0.91358E-02_JPRB,0.10538E-01_JPRB,0.12200E-01_JPRB,0.13999E-01_JPRB,0.16082E-01_JPRB /)  
KB(:,39, 9) = (/ &
 & 0.84558E-02_JPRB,0.98580E-02_JPRB,0.11508E-01_JPRB,0.13321E-01_JPRB,0.15372E-01_JPRB /)  
KB(:,40, 9) = (/ &
 & 0.78020E-02_JPRB,0.91740E-02_JPRB,0.10778E-01_JPRB,0.12588E-01_JPRB,0.14594E-01_JPRB /)  
KB(:,41, 9) = (/ &
 & 0.72028E-02_JPRB,0.85294E-02_JPRB,0.10093E-01_JPRB,0.11887E-01_JPRB,0.13872E-01_JPRB /)  
KB(:,42, 9) = (/ &
 & 0.66335E-02_JPRB,0.79299E-02_JPRB,0.94524E-02_JPRB,0.11233E-01_JPRB,0.13162E-01_JPRB /)  
KB(:,43, 9) = (/ &
 & 0.60936E-02_JPRB,0.73819E-02_JPRB,0.88361E-02_JPRB,0.10555E-01_JPRB,0.12456E-01_JPRB /)  
KB(:,44, 9) = (/ &
 & 0.55851E-02_JPRB,0.68018E-02_JPRB,0.82487E-02_JPRB,0.98836E-02_JPRB,0.11744E-01_JPRB /)  
KB(:,45, 9) = (/ &
 & 0.51361E-02_JPRB,0.62783E-02_JPRB,0.76910E-02_JPRB,0.92631E-02_JPRB,0.11096E-01_JPRB /)  
KB(:,46, 9) = (/ &
 & 0.46789E-02_JPRB,0.57877E-02_JPRB,0.71257E-02_JPRB,0.86688E-02_JPRB,0.10399E-01_JPRB /)  
KB(:,47, 9) = (/ &
 & 0.42434E-02_JPRB,0.53043E-02_JPRB,0.65448E-02_JPRB,0.80300E-02_JPRB,0.97286E-02_JPRB /)  
KB(:,48, 9) = (/ &
 & 0.38917E-02_JPRB,0.48269E-02_JPRB,0.60283E-02_JPRB,0.74378E-02_JPRB,0.90783E-02_JPRB /)  
KB(:,49, 9) = (/ &
 & 0.35823E-02_JPRB,0.43988E-02_JPRB,0.55409E-02_JPRB,0.68845E-02_JPRB,0.84495E-02_JPRB /)  
KB(:,50, 9) = (/ &
 & 0.33116E-02_JPRB,0.40852E-02_JPRB,0.51044E-02_JPRB,0.63885E-02_JPRB,0.78773E-02_JPRB /)  
KB(:,51, 9) = (/ &
 & 0.30752E-02_JPRB,0.38103E-02_JPRB,0.47346E-02_JPRB,0.59580E-02_JPRB,0.73779E-02_JPRB /)  
KB(:,52, 9) = (/ &
 & 0.28626E-02_JPRB,0.35553E-02_JPRB,0.44430E-02_JPRB,0.55409E-02_JPRB,0.69343E-02_JPRB /)  
KB(:,53, 9) = (/ &
 & 0.26485E-02_JPRB,0.33392E-02_JPRB,0.41695E-02_JPRB,0.51739E-02_JPRB,0.64753E-02_JPRB /)  
KB(:,54, 9) = (/ &
 & 0.24736E-02_JPRB,0.31489E-02_JPRB,0.39367E-02_JPRB,0.48954E-02_JPRB,0.61401E-02_JPRB /)  
KB(:,55, 9) = (/ &
 & 0.23362E-02_JPRB,0.29819E-02_JPRB,0.37593E-02_JPRB,0.46985E-02_JPRB,0.58363E-02_JPRB /)  
KB(:,56, 9) = (/ &
 & 0.22243E-02_JPRB,0.28447E-02_JPRB,0.35827E-02_JPRB,0.44762E-02_JPRB,0.55720E-02_JPRB /)  
KB(:,57, 9) = (/ &
 & 0.21389E-02_JPRB,0.27081E-02_JPRB,0.34315E-02_JPRB,0.43182E-02_JPRB,0.53898E-02_JPRB /)  
KB(:,58, 9) = (/ &
 & 0.20428E-02_JPRB,0.25997E-02_JPRB,0.33047E-02_JPRB,0.41726E-02_JPRB,0.52071E-02_JPRB /)  
KB(:,59, 9) = (/ &
 & 0.20538E-02_JPRB,0.26323E-02_JPRB,0.33247E-02_JPRB,0.41770E-02_JPRB,0.52496E-02_JPRB /)  
KB(:,13,10) = (/ &
 & 0.58637E+00_JPRB,0.59481E+00_JPRB,0.59811E+00_JPRB,0.60451E+00_JPRB,0.60418E+00_JPRB /)  
KB(:,14,10) = (/ &
 & 0.53191E+00_JPRB,0.53363E+00_JPRB,0.53861E+00_JPRB,0.53976E+00_JPRB,0.53933E+00_JPRB /)  
KB(:,15,10) = (/ &
 & 0.47845E+00_JPRB,0.48447E+00_JPRB,0.48498E+00_JPRB,0.48691E+00_JPRB,0.48935E+00_JPRB /)  
KB(:,16,10) = (/ &
 & 0.42695E+00_JPRB,0.43265E+00_JPRB,0.43442E+00_JPRB,0.43949E+00_JPRB,0.44244E+00_JPRB /)  
KB(:,17,10) = (/ &
 & 0.37796E+00_JPRB,0.38437E+00_JPRB,0.38958E+00_JPRB,0.39367E+00_JPRB,0.39802E+00_JPRB /)  
KB(:,18,10) = (/ &
 & 0.33399E+00_JPRB,0.33971E+00_JPRB,0.34517E+00_JPRB,0.35032E+00_JPRB,0.35265E+00_JPRB /)  
KB(:,19,10) = (/ &
 & 0.29538E+00_JPRB,0.30247E+00_JPRB,0.30713E+00_JPRB,0.30943E+00_JPRB,0.31544E+00_JPRB /)  
KB(:,20,10) = (/ &
 & 0.26154E+00_JPRB,0.26955E+00_JPRB,0.27264E+00_JPRB,0.27778E+00_JPRB,0.28167E+00_JPRB /)  
KB(:,21,10) = (/ &
 & 0.23200E+00_JPRB,0.23896E+00_JPRB,0.24468E+00_JPRB,0.24838E+00_JPRB,0.25453E+00_JPRB /)  
KB(:,22,10) = (/ &
 & 0.20714E+00_JPRB,0.21368E+00_JPRB,0.21959E+00_JPRB,0.22402E+00_JPRB,0.22934E+00_JPRB /)  
KB(:,23,10) = (/ &
 & 0.18514E+00_JPRB,0.19070E+00_JPRB,0.19771E+00_JPRB,0.20426E+00_JPRB,0.20794E+00_JPRB /)  
KB(:,24,10) = (/ &
 & 0.16629E+00_JPRB,0.17247E+00_JPRB,0.17943E+00_JPRB,0.18543E+00_JPRB,0.19044E+00_JPRB /)  
KB(:,25,10) = (/ &
 & 0.15103E+00_JPRB,0.15758E+00_JPRB,0.16440E+00_JPRB,0.16947E+00_JPRB,0.17504E+00_JPRB /)  
KB(:,26,10) = (/ &
 & 0.13782E+00_JPRB,0.14448E+00_JPRB,0.15050E+00_JPRB,0.15723E+00_JPRB,0.16403E+00_JPRB /)  
KB(:,27,10) = (/ &
 & 0.12675E+00_JPRB,0.13284E+00_JPRB,0.13902E+00_JPRB,0.14547E+00_JPRB,0.15299E+00_JPRB /)  
KB(:,28,10) = (/ &
 & 0.11700E+00_JPRB,0.12400E+00_JPRB,0.13029E+00_JPRB,0.13779E+00_JPRB,0.14535E+00_JPRB /)  
KB(:,29,10) = (/ &
 & 0.10975E+00_JPRB,0.11580E+00_JPRB,0.12300E+00_JPRB,0.13106E+00_JPRB,0.13981E+00_JPRB /)  
KB(:,30,10) = (/ &
 & 0.10326E+00_JPRB,0.10877E+00_JPRB,0.11694E+00_JPRB,0.12523E+00_JPRB,0.13409E+00_JPRB /)  
KB(:,31,10) = (/ &
 & 0.97072E-01_JPRB,0.10392E+00_JPRB,0.11191E+00_JPRB,0.12092E+00_JPRB,0.13156E+00_JPRB /)  
KB(:,32,10) = (/ &
 & 0.92483E-01_JPRB,0.10003E+00_JPRB,0.10847E+00_JPRB,0.11777E+00_JPRB,0.12978E+00_JPRB /)  
KB(:,33,10) = (/ &
 & 0.89436E-01_JPRB,0.96549E-01_JPRB,0.10550E+00_JPRB,0.11582E+00_JPRB,0.12938E+00_JPRB /)  
KB(:,34,10) = (/ &
 & 0.86605E-01_JPRB,0.93852E-01_JPRB,0.10437E+00_JPRB,0.11565E+00_JPRB,0.13025E+00_JPRB /)  
KB(:,35,10) = (/ &
 & 0.83755E-01_JPRB,0.92443E-01_JPRB,0.10318E+00_JPRB,0.11569E+00_JPRB,0.13035E+00_JPRB /)  
KB(:,36,10) = (/ &
 & 0.80159E-01_JPRB,0.90106E-01_JPRB,0.10185E+00_JPRB,0.11331E+00_JPRB,0.13105E+00_JPRB /)  
KB(:,37,10) = (/ &
 & 0.76863E-01_JPRB,0.86981E-01_JPRB,0.98816E-01_JPRB,0.11094E+00_JPRB,0.12837E+00_JPRB /)  
KB(:,38,10) = (/ &
 & 0.73911E-01_JPRB,0.84640E-01_JPRB,0.95988E-01_JPRB,0.10951E+00_JPRB,0.12524E+00_JPRB /)  
KB(:,39,10) = (/ &
 & 0.71484E-01_JPRB,0.82465E-01_JPRB,0.93807E-01_JPRB,0.10732E+00_JPRB,0.12288E+00_JPRB /)  
KB(:,40,10) = (/ &
 & 0.68367E-01_JPRB,0.78553E-01_JPRB,0.90288E-01_JPRB,0.10290E+00_JPRB,0.11884E+00_JPRB /)  
KB(:,41,10) = (/ &
 & 0.65972E-01_JPRB,0.75367E-01_JPRB,0.87331E-01_JPRB,0.98979E-01_JPRB,0.11479E+00_JPRB /)  
KB(:,42,10) = (/ &
 & 0.63899E-01_JPRB,0.72995E-01_JPRB,0.84392E-01_JPRB,0.96170E-01_JPRB,0.11066E+00_JPRB /)  
KB(:,43,10) = (/ &
 & 0.61601E-01_JPRB,0.69361E-01_JPRB,0.80265E-01_JPRB,0.92296E-01_JPRB,0.10575E+00_JPRB /)  
KB(:,44,10) = (/ &
 & 0.58053E-01_JPRB,0.67236E-01_JPRB,0.77057E-01_JPRB,0.88848E-01_JPRB,0.10118E+00_JPRB /)  
KB(:,45,10) = (/ &
 & 0.55041E-01_JPRB,0.64788E-01_JPRB,0.73479E-01_JPRB,0.85189E-01_JPRB,0.97294E-01_JPRB /)  
KB(:,46,10) = (/ &
 & 0.51538E-01_JPRB,0.61359E-01_JPRB,0.70493E-01_JPRB,0.81342E-01_JPRB,0.93711E-01_JPRB /)  
KB(:,47,10) = (/ &
 & 0.48229E-01_JPRB,0.57754E-01_JPRB,0.67703E-01_JPRB,0.77712E-01_JPRB,0.88779E-01_JPRB /)  
KB(:,48,10) = (/ &
 & 0.44328E-01_JPRB,0.53953E-01_JPRB,0.64327E-01_JPRB,0.74186E-01_JPRB,0.85354E-01_JPRB /)  
KB(:,49,10) = (/ &
 & 0.40181E-01_JPRB,0.50939E-01_JPRB,0.60544E-01_JPRB,0.71079E-01_JPRB,0.81883E-01_JPRB /)  
KB(:,50,10) = (/ &
 & 0.36327E-01_JPRB,0.47243E-01_JPRB,0.57625E-01_JPRB,0.67925E-01_JPRB,0.78806E-01_JPRB /)  
KB(:,51,10) = (/ &
 & 0.33026E-01_JPRB,0.43278E-01_JPRB,0.54464E-01_JPRB,0.64411E-01_JPRB,0.75916E-01_JPRB /)  
KB(:,52,10) = (/ &
 & 0.29600E-01_JPRB,0.39888E-01_JPRB,0.50913E-01_JPRB,0.61457E-01_JPRB,0.72719E-01_JPRB /)  
KB(:,53,10) = (/ &
 & 0.26994E-01_JPRB,0.36264E-01_JPRB,0.46926E-01_JPRB,0.58631E-01_JPRB,0.68972E-01_JPRB /)  
KB(:,54,10) = (/ &
 & 0.24928E-01_JPRB,0.33245E-01_JPRB,0.43870E-01_JPRB,0.55481E-01_JPRB,0.66121E-01_JPRB /)  
KB(:,55,10) = (/ &
 & 0.23329E-01_JPRB,0.30647E-01_JPRB,0.40729E-01_JPRB,0.52051E-01_JPRB,0.63960E-01_JPRB /)  
KB(:,56,10) = (/ &
 & 0.21581E-01_JPRB,0.28578E-01_JPRB,0.37651E-01_JPRB,0.48828E-01_JPRB,0.60673E-01_JPRB /)  
KB(:,57,10) = (/ &
 & 0.20121E-01_JPRB,0.27060E-01_JPRB,0.35152E-01_JPRB,0.45854E-01_JPRB,0.57152E-01_JPRB /)  
KB(:,58,10) = (/ &
 & 0.18692E-01_JPRB,0.25639E-01_JPRB,0.32995E-01_JPRB,0.42657E-01_JPRB,0.54655E-01_JPRB /)  
KB(:,59,10) = (/ &
 & 0.18277E-01_JPRB,0.25273E-01_JPRB,0.32791E-01_JPRB,0.42508E-01_JPRB,0.53680E-01_JPRB /)  
KB(:,13,11) = (/ &
 & 0.10693E+01_JPRB,0.10902E+01_JPRB,0.11032E+01_JPRB,0.10991E+01_JPRB,0.11118E+01_JPRB /)  
KB(:,14,11) = (/ &
 & 0.95953E+00_JPRB,0.97384E+00_JPRB,0.98577E+00_JPRB,0.99728E+00_JPRB,0.10070E+01_JPRB /)  
KB(:,15,11) = (/ &
 & 0.85940E+00_JPRB,0.86781E+00_JPRB,0.87766E+00_JPRB,0.88834E+00_JPRB,0.89855E+00_JPRB /)  
KB(:,16,11) = (/ &
 & 0.76187E+00_JPRB,0.76651E+00_JPRB,0.78116E+00_JPRB,0.79605E+00_JPRB,0.80429E+00_JPRB /)  
KB(:,17,11) = (/ &
 & 0.67627E+00_JPRB,0.68377E+00_JPRB,0.69734E+00_JPRB,0.70867E+00_JPRB,0.71758E+00_JPRB /)  
KB(:,18,11) = (/ &
 & 0.60442E+00_JPRB,0.61462E+00_JPRB,0.62319E+00_JPRB,0.63477E+00_JPRB,0.64696E+00_JPRB /)  
KB(:,19,11) = (/ &
 & 0.54250E+00_JPRB,0.55180E+00_JPRB,0.56132E+00_JPRB,0.57649E+00_JPRB,0.58604E+00_JPRB /)  
KB(:,20,11) = (/ &
 & 0.49000E+00_JPRB,0.49922E+00_JPRB,0.51229E+00_JPRB,0.52536E+00_JPRB,0.53903E+00_JPRB /)  
KB(:,21,11) = (/ &
 & 0.44362E+00_JPRB,0.45018E+00_JPRB,0.46523E+00_JPRB,0.48212E+00_JPRB,0.49590E+00_JPRB /)  
KB(:,22,11) = (/ &
 & 0.40390E+00_JPRB,0.41136E+00_JPRB,0.42554E+00_JPRB,0.44299E+00_JPRB,0.45956E+00_JPRB /)  
KB(:,23,11) = (/ &
 & 0.36600E+00_JPRB,0.37646E+00_JPRB,0.39144E+00_JPRB,0.40936E+00_JPRB,0.42622E+00_JPRB /)  
KB(:,24,11) = (/ &
 & 0.33488E+00_JPRB,0.34802E+00_JPRB,0.36259E+00_JPRB,0.38089E+00_JPRB,0.39832E+00_JPRB /)  
KB(:,25,11) = (/ &
 & 0.30569E+00_JPRB,0.32099E+00_JPRB,0.33730E+00_JPRB,0.35716E+00_JPRB,0.37447E+00_JPRB /)  
KB(:,26,11) = (/ &
 & 0.28345E+00_JPRB,0.29933E+00_JPRB,0.31861E+00_JPRB,0.33716E+00_JPRB,0.35400E+00_JPRB /)  
KB(:,27,11) = (/ &
 & 0.26524E+00_JPRB,0.28116E+00_JPRB,0.30310E+00_JPRB,0.32398E+00_JPRB,0.34341E+00_JPRB /)  
KB(:,28,11) = (/ &
 & 0.25036E+00_JPRB,0.26748E+00_JPRB,0.29040E+00_JPRB,0.31038E+00_JPRB,0.33527E+00_JPRB /)  
KB(:,29,11) = (/ &
 & 0.23678E+00_JPRB,0.25759E+00_JPRB,0.27958E+00_JPRB,0.30373E+00_JPRB,0.33097E+00_JPRB /)  
KB(:,30,11) = (/ &
 & 0.22835E+00_JPRB,0.25043E+00_JPRB,0.27298E+00_JPRB,0.30247E+00_JPRB,0.33069E+00_JPRB /)  
KB(:,31,11) = (/ &
 & 0.22381E+00_JPRB,0.24448E+00_JPRB,0.27386E+00_JPRB,0.30198E+00_JPRB,0.33135E+00_JPRB /)  
KB(:,32,11) = (/ &
 & 0.21945E+00_JPRB,0.24581E+00_JPRB,0.27557E+00_JPRB,0.30488E+00_JPRB,0.33817E+00_JPRB /)  
KB(:,33,11) = (/ &
 & 0.22020E+00_JPRB,0.24997E+00_JPRB,0.27933E+00_JPRB,0.31199E+00_JPRB,0.34537E+00_JPRB /)  
KB(:,34,11) = (/ &
 & 0.22328E+00_JPRB,0.25315E+00_JPRB,0.28560E+00_JPRB,0.31999E+00_JPRB,0.35204E+00_JPRB /)  
KB(:,35,11) = (/ &
 & 0.22463E+00_JPRB,0.25599E+00_JPRB,0.29016E+00_JPRB,0.32472E+00_JPRB,0.35705E+00_JPRB /)  
KB(:,36,11) = (/ &
 & 0.22454E+00_JPRB,0.25719E+00_JPRB,0.29064E+00_JPRB,0.32676E+00_JPRB,0.35643E+00_JPRB /)  
KB(:,37,11) = (/ &
 & 0.21917E+00_JPRB,0.25146E+00_JPRB,0.28533E+00_JPRB,0.32018E+00_JPRB,0.35207E+00_JPRB /)  
KB(:,38,11) = (/ &
 & 0.21431E+00_JPRB,0.24593E+00_JPRB,0.28070E+00_JPRB,0.31440E+00_JPRB,0.34740E+00_JPRB /)  
KB(:,39,11) = (/ &
 & 0.20995E+00_JPRB,0.24107E+00_JPRB,0.27540E+00_JPRB,0.30795E+00_JPRB,0.34247E+00_JPRB /)  
KB(:,40,11) = (/ &
 & 0.20148E+00_JPRB,0.23319E+00_JPRB,0.26577E+00_JPRB,0.30086E+00_JPRB,0.33366E+00_JPRB /)  
KB(:,41,11) = (/ &
 & 0.19132E+00_JPRB,0.22478E+00_JPRB,0.25632E+00_JPRB,0.29251E+00_JPRB,0.32436E+00_JPRB /)  
KB(:,42,11) = (/ &
 & 0.18231E+00_JPRB,0.21584E+00_JPRB,0.24724E+00_JPRB,0.28164E+00_JPRB,0.31641E+00_JPRB /)  
KB(:,43,11) = (/ &
 & 0.17273E+00_JPRB,0.20475E+00_JPRB,0.23702E+00_JPRB,0.26984E+00_JPRB,0.30535E+00_JPRB /)  
KB(:,44,11) = (/ &
 & 0.16365E+00_JPRB,0.19313E+00_JPRB,0.22566E+00_JPRB,0.25812E+00_JPRB,0.29340E+00_JPRB /)  
KB(:,45,11) = (/ &
 & 0.15471E+00_JPRB,0.18278E+00_JPRB,0.21464E+00_JPRB,0.24686E+00_JPRB,0.28060E+00_JPRB /)  
KB(:,46,11) = (/ &
 & 0.14477E+00_JPRB,0.17256E+00_JPRB,0.20328E+00_JPRB,0.23515E+00_JPRB,0.26753E+00_JPRB /)  
KB(:,47,11) = (/ &
 & 0.13513E+00_JPRB,0.16209E+00_JPRB,0.19092E+00_JPRB,0.22162E+00_JPRB,0.25481E+00_JPRB /)  
KB(:,48,11) = (/ &
 & 0.12632E+00_JPRB,0.15056E+00_JPRB,0.17900E+00_JPRB,0.20905E+00_JPRB,0.24085E+00_JPRB /)  
KB(:,49,11) = (/ &
 & 0.11846E+00_JPRB,0.14059E+00_JPRB,0.16812E+00_JPRB,0.19759E+00_JPRB,0.22701E+00_JPRB /)  
KB(:,50,11) = (/ &
 & 0.11278E+00_JPRB,0.13341E+00_JPRB,0.15756E+00_JPRB,0.18662E+00_JPRB,0.21629E+00_JPRB /)  
KB(:,51,11) = (/ &
 & 0.10711E+00_JPRB,0.12752E+00_JPRB,0.14951E+00_JPRB,0.17651E+00_JPRB,0.20555E+00_JPRB /)  
KB(:,52,11) = (/ &
 & 0.10062E+00_JPRB,0.12140E+00_JPRB,0.14273E+00_JPRB,0.16677E+00_JPRB,0.19594E+00_JPRB /)  
KB(:,53,11) = (/ &
 & 0.93686E-01_JPRB,0.11587E+00_JPRB,0.13705E+00_JPRB,0.15900E+00_JPRB,0.18673E+00_JPRB /)  
KB(:,54,11) = (/ &
 & 0.88183E-01_JPRB,0.10986E+00_JPRB,0.13159E+00_JPRB,0.15362E+00_JPRB,0.17808E+00_JPRB /)  
KB(:,55,11) = (/ &
 & 0.81924E-01_JPRB,0.10428E+00_JPRB,0.12662E+00_JPRB,0.14862E+00_JPRB,0.17143E+00_JPRB /)  
KB(:,56,11) = (/ &
 & 0.75991E-01_JPRB,0.98633E-01_JPRB,0.12219E+00_JPRB,0.14408E+00_JPRB,0.16698E+00_JPRB /)  
KB(:,57,11) = (/ &
 & 0.69399E-01_JPRB,0.92760E-01_JPRB,0.11664E+00_JPRB,0.14040E+00_JPRB,0.16308E+00_JPRB /)  
KB(:,58,11) = (/ &
 & 0.64018E-01_JPRB,0.88343E-01_JPRB,0.11169E+00_JPRB,0.13686E+00_JPRB,0.15969E+00_JPRB /)  
KB(:,59,11) = (/ &
 & 0.63145E-01_JPRB,0.86273E-01_JPRB,0.11143E+00_JPRB,0.13565E+00_JPRB,0.16187E+00_JPRB /)  
KB(:,13,12) = (/ &
 & 0.22241E+01_JPRB,0.22556E+01_JPRB,0.22932E+01_JPRB,0.23316E+01_JPRB,0.23817E+01_JPRB /)  
KB(:,14,12) = (/ &
 & 0.20015E+01_JPRB,0.20535E+01_JPRB,0.20976E+01_JPRB,0.21411E+01_JPRB,0.21895E+01_JPRB /)  
KB(:,15,12) = (/ &
 & 0.18111E+01_JPRB,0.18671E+01_JPRB,0.19196E+01_JPRB,0.19734E+01_JPRB,0.20226E+01_JPRB /)  
KB(:,16,12) = (/ &
 & 0.16513E+01_JPRB,0.17114E+01_JPRB,0.17632E+01_JPRB,0.18132E+01_JPRB,0.18623E+01_JPRB /)  
KB(:,17,12) = (/ &
 & 0.15041E+01_JPRB,0.15648E+01_JPRB,0.16197E+01_JPRB,0.16720E+01_JPRB,0.17169E+01_JPRB /)  
KB(:,18,12) = (/ &
 & 0.13731E+01_JPRB,0.14345E+01_JPRB,0.14937E+01_JPRB,0.15386E+01_JPRB,0.16052E+01_JPRB /)  
KB(:,19,12) = (/ &
 & 0.12478E+01_JPRB,0.13115E+01_JPRB,0.13641E+01_JPRB,0.14279E+01_JPRB,0.14977E+01_JPRB /)  
KB(:,20,12) = (/ &
 & 0.11298E+01_JPRB,0.11910E+01_JPRB,0.12495E+01_JPRB,0.13186E+01_JPRB,0.13914E+01_JPRB /)  
KB(:,21,12) = (/ &
 & 0.10266E+01_JPRB,0.10915E+01_JPRB,0.11508E+01_JPRB,0.12227E+01_JPRB,0.13004E+01_JPRB /)  
KB(:,22,12) = (/ &
 & 0.93959E+00_JPRB,0.10027E+01_JPRB,0.10735E+01_JPRB,0.11507E+01_JPRB,0.12312E+01_JPRB /)  
KB(:,23,12) = (/ &
 & 0.87016E+00_JPRB,0.93486E+00_JPRB,0.10125E+01_JPRB,0.10930E+01_JPRB,0.11794E+01_JPRB /)  
KB(:,24,12) = (/ &
 & 0.81213E+00_JPRB,0.88017E+00_JPRB,0.96483E+00_JPRB,0.10508E+01_JPRB,0.11396E+01_JPRB /)  
KB(:,25,12) = (/ &
 & 0.77134E+00_JPRB,0.84295E+00_JPRB,0.93081E+00_JPRB,0.10201E+01_JPRB,0.11152E+01_JPRB /)  
KB(:,26,12) = (/ &
 & 0.73832E+00_JPRB,0.81743E+00_JPRB,0.90746E+00_JPRB,0.10024E+01_JPRB,0.11020E+01_JPRB /)  
KB(:,27,12) = (/ &
 & 0.71831E+00_JPRB,0.80328E+00_JPRB,0.89505E+00_JPRB,0.99247E+00_JPRB,0.10943E+01_JPRB /)  
KB(:,28,12) = (/ &
 & 0.70848E+00_JPRB,0.79592E+00_JPRB,0.89143E+00_JPRB,0.99432E+00_JPRB,0.10940E+01_JPRB /)  
KB(:,29,12) = (/ &
 & 0.70725E+00_JPRB,0.79781E+00_JPRB,0.89906E+00_JPRB,0.10007E+01_JPRB,0.11009E+01_JPRB /)  
KB(:,30,12) = (/ &
 & 0.71125E+00_JPRB,0.80824E+00_JPRB,0.91144E+00_JPRB,0.10109E+01_JPRB,0.11144E+01_JPRB /)  
KB(:,31,12) = (/ &
 & 0.72057E+00_JPRB,0.82548E+00_JPRB,0.92423E+00_JPRB,0.10285E+01_JPRB,0.11338E+01_JPRB /)  
KB(:,32,12) = (/ &
 & 0.73855E+00_JPRB,0.84223E+00_JPRB,0.94322E+00_JPRB,0.10495E+01_JPRB,0.11523E+01_JPRB /)  
KB(:,33,12) = (/ &
 & 0.75860E+00_JPRB,0.86137E+00_JPRB,0.96653E+00_JPRB,0.10709E+01_JPRB,0.11736E+01_JPRB /)  
KB(:,34,12) = (/ &
 & 0.77584E+00_JPRB,0.88104E+00_JPRB,0.98358E+00_JPRB,0.10881E+01_JPRB,0.11928E+01_JPRB /)  
KB(:,35,12) = (/ &
 & 0.78526E+00_JPRB,0.88915E+00_JPRB,0.99181E+00_JPRB,0.10955E+01_JPRB,0.12024E+01_JPRB /)  
KB(:,36,12) = (/ &
 & 0.78420E+00_JPRB,0.88679E+00_JPRB,0.98962E+00_JPRB,0.10938E+01_JPRB,0.12013E+01_JPRB /)  
KB(:,37,12) = (/ &
 & 0.76619E+00_JPRB,0.86975E+00_JPRB,0.97162E+00_JPRB,0.10774E+01_JPRB,0.11823E+01_JPRB /)  
KB(:,38,12) = (/ &
 & 0.74778E+00_JPRB,0.85168E+00_JPRB,0.95355E+00_JPRB,0.10588E+01_JPRB,0.11642E+01_JPRB /)  
KB(:,39,12) = (/ &
 & 0.73003E+00_JPRB,0.83397E+00_JPRB,0.93638E+00_JPRB,0.10427E+01_JPRB,0.11461E+01_JPRB /)  
KB(:,40,12) = (/ &
 & 0.70694E+00_JPRB,0.80603E+00_JPRB,0.90951E+00_JPRB,0.10129E+01_JPRB,0.11179E+01_JPRB /)  
KB(:,41,12) = (/ &
 & 0.68380E+00_JPRB,0.77629E+00_JPRB,0.88021E+00_JPRB,0.98263E+00_JPRB,0.10876E+01_JPRB /)  
KB(:,42,12) = (/ &
 & 0.66231E+00_JPRB,0.74849E+00_JPRB,0.85130E+00_JPRB,0.95458E+00_JPRB,0.10576E+01_JPRB /)  
KB(:,43,12) = (/ &
 & 0.63688E+00_JPRB,0.72048E+00_JPRB,0.81634E+00_JPRB,0.92017E+00_JPRB,0.10227E+01_JPRB /)  
KB(:,44,12) = (/ &
 & 0.60858E+00_JPRB,0.69178E+00_JPRB,0.77940E+00_JPRB,0.88149E+00_JPRB,0.98460E+00_JPRB /)  
KB(:,45,12) = (/ &
 & 0.58153E+00_JPRB,0.66520E+00_JPRB,0.74925E+00_JPRB,0.84319E+00_JPRB,0.94694E+00_JPRB /)  
KB(:,46,12) = (/ &
 & 0.55197E+00_JPRB,0.63412E+00_JPRB,0.71872E+00_JPRB,0.80664E+00_JPRB,0.90684E+00_JPRB /)  
KB(:,47,12) = (/ &
 & 0.51844E+00_JPRB,0.60273E+00_JPRB,0.68769E+00_JPRB,0.77076E+00_JPRB,0.86117E+00_JPRB /)  
KB(:,48,12) = (/ &
 & 0.48120E+00_JPRB,0.57148E+00_JPRB,0.65491E+00_JPRB,0.74197E+00_JPRB,0.82485E+00_JPRB /)  
KB(:,49,12) = (/ &
 & 0.44584E+00_JPRB,0.53846E+00_JPRB,0.62079E+00_JPRB,0.70603E+00_JPRB,0.79220E+00_JPRB /)  
KB(:,50,12) = (/ &
 & 0.41289E+00_JPRB,0.50133E+00_JPRB,0.59314E+00_JPRB,0.67773E+00_JPRB,0.76297E+00_JPRB /)  
KB(:,51,12) = (/ &
 & 0.38263E+00_JPRB,0.46808E+00_JPRB,0.55994E+00_JPRB,0.64654E+00_JPRB,0.73545E+00_JPRB /)  
KB(:,52,12) = (/ &
 & 0.35216E+00_JPRB,0.43713E+00_JPRB,0.52781E+00_JPRB,0.61897E+00_JPRB,0.70212E+00_JPRB /)  
KB(:,53,12) = (/ &
 & 0.33102E+00_JPRB,0.40477E+00_JPRB,0.49059E+00_JPRB,0.58472E+00_JPRB,0.67270E+00_JPRB /)  
KB(:,54,12) = (/ &
 & 0.31146E+00_JPRB,0.37834E+00_JPRB,0.46271E+00_JPRB,0.55353E+00_JPRB,0.64596E+00_JPRB /)  
KB(:,55,12) = (/ &
 & 0.29087E+00_JPRB,0.35982E+00_JPRB,0.43598E+00_JPRB,0.52416E+00_JPRB,0.61765E+00_JPRB /)  
KB(:,56,12) = (/ &
 & 0.27304E+00_JPRB,0.34098E+00_JPRB,0.41224E+00_JPRB,0.49775E+00_JPRB,0.58771E+00_JPRB /)  
KB(:,57,12) = (/ &
 & 0.25824E+00_JPRB,0.32066E+00_JPRB,0.39085E+00_JPRB,0.46641E+00_JPRB,0.55829E+00_JPRB /)  
KB(:,58,12) = (/ &
 & 0.24548E+00_JPRB,0.30081E+00_JPRB,0.37338E+00_JPRB,0.44708E+00_JPRB,0.53062E+00_JPRB /)  
KB(:,59,12) = (/ &
 & 0.24212E+00_JPRB,0.29858E+00_JPRB,0.36550E+00_JPRB,0.44064E+00_JPRB,0.51789E+00_JPRB /)  
KB(:,13,13) = (/ &
 & 0.55998E+01_JPRB,0.57039E+01_JPRB,0.58049E+01_JPRB,0.59180E+01_JPRB,0.59854E+01_JPRB /)  
KB(:,14,13) = (/ &
 & 0.53275E+01_JPRB,0.54387E+01_JPRB,0.55543E+01_JPRB,0.56621E+01_JPRB,0.57635E+01_JPRB /)  
KB(:,15,13) = (/ &
 & 0.50203E+01_JPRB,0.51578E+01_JPRB,0.52898E+01_JPRB,0.54130E+01_JPRB,0.55373E+01_JPRB /)  
KB(:,16,13) = (/ &
 & 0.47246E+01_JPRB,0.48786E+01_JPRB,0.50266E+01_JPRB,0.51689E+01_JPRB,0.53242E+01_JPRB /)  
KB(:,17,13) = (/ &
 & 0.44403E+01_JPRB,0.46027E+01_JPRB,0.47680E+01_JPRB,0.49455E+01_JPRB,0.51299E+01_JPRB /)  
KB(:,18,13) = (/ &
 & 0.41648E+01_JPRB,0.43473E+01_JPRB,0.45415E+01_JPRB,0.47508E+01_JPRB,0.49298E+01_JPRB /)  
KB(:,19,13) = (/ &
 & 0.39134E+01_JPRB,0.41196E+01_JPRB,0.43493E+01_JPRB,0.45520E+01_JPRB,0.47522E+01_JPRB /)  
KB(:,20,13) = (/ &
 & 0.36873E+01_JPRB,0.39195E+01_JPRB,0.41603E+01_JPRB,0.43826E+01_JPRB,0.46005E+01_JPRB /)  
KB(:,21,13) = (/ &
 & 0.34974E+01_JPRB,0.37507E+01_JPRB,0.40010E+01_JPRB,0.42413E+01_JPRB,0.44759E+01_JPRB /)  
KB(:,22,13) = (/ &
 & 0.33605E+01_JPRB,0.36305E+01_JPRB,0.38873E+01_JPRB,0.41404E+01_JPRB,0.43929E+01_JPRB /)  
KB(:,23,13) = (/ &
 & 0.32571E+01_JPRB,0.35388E+01_JPRB,0.38042E+01_JPRB,0.40702E+01_JPRB,0.43353E+01_JPRB /)  
KB(:,24,13) = (/ &
 & 0.31836E+01_JPRB,0.34721E+01_JPRB,0.37495E+01_JPRB,0.40277E+01_JPRB,0.43044E+01_JPRB /)  
KB(:,25,13) = (/ &
 & 0.31346E+01_JPRB,0.34329E+01_JPRB,0.37222E+01_JPRB,0.40107E+01_JPRB,0.42953E+01_JPRB /)  
KB(:,26,13) = (/ &
 & 0.31155E+01_JPRB,0.34221E+01_JPRB,0.37222E+01_JPRB,0.40178E+01_JPRB,0.43079E+01_JPRB /)  
KB(:,27,13) = (/ &
 & 0.31157E+01_JPRB,0.34328E+01_JPRB,0.37392E+01_JPRB,0.40396E+01_JPRB,0.43346E+01_JPRB /)  
KB(:,28,13) = (/ &
 & 0.31335E+01_JPRB,0.34580E+01_JPRB,0.37695E+01_JPRB,0.40734E+01_JPRB,0.43720E+01_JPRB /)  
KB(:,29,13) = (/ &
 & 0.31697E+01_JPRB,0.34978E+01_JPRB,0.38120E+01_JPRB,0.41186E+01_JPRB,0.44189E+01_JPRB /)  
KB(:,30,13) = (/ &
 & 0.32194E+01_JPRB,0.35475E+01_JPRB,0.38638E+01_JPRB,0.41720E+01_JPRB,0.44722E+01_JPRB /)  
KB(:,31,13) = (/ &
 & 0.32811E+01_JPRB,0.36069E+01_JPRB,0.39241E+01_JPRB,0.42325E+01_JPRB,0.45314E+01_JPRB /)  
KB(:,32,13) = (/ &
 & 0.33484E+01_JPRB,0.36727E+01_JPRB,0.39897E+01_JPRB,0.42974E+01_JPRB,0.45949E+01_JPRB /)  
KB(:,33,13) = (/ &
 & 0.34186E+01_JPRB,0.37430E+01_JPRB,0.40586E+01_JPRB,0.43658E+01_JPRB,0.46602E+01_JPRB /)  
KB(:,34,13) = (/ &
 & 0.34801E+01_JPRB,0.38048E+01_JPRB,0.41197E+01_JPRB,0.44255E+01_JPRB,0.47156E+01_JPRB /)  
KB(:,35,13) = (/ &
 & 0.35126E+01_JPRB,0.38375E+01_JPRB,0.41525E+01_JPRB,0.44577E+01_JPRB,0.47454E+01_JPRB /)  
KB(:,36,13) = (/ &
 & 0.35115E+01_JPRB,0.38370E+01_JPRB,0.41529E+01_JPRB,0.44584E+01_JPRB,0.47449E+01_JPRB /)  
KB(:,37,13) = (/ &
 & 0.34620E+01_JPRB,0.37892E+01_JPRB,0.41066E+01_JPRB,0.44144E+01_JPRB,0.47052E+01_JPRB /)  
KB(:,38,13) = (/ &
 & 0.34108E+01_JPRB,0.37391E+01_JPRB,0.40587E+01_JPRB,0.43685E+01_JPRB,0.46624E+01_JPRB /)  
KB(:,39,13) = (/ &
 & 0.33603E+01_JPRB,0.36896E+01_JPRB,0.40114E+01_JPRB,0.43229E+01_JPRB,0.46208E+01_JPRB /)  
KB(:,40,13) = (/ &
 & 0.32696E+01_JPRB,0.36068E+01_JPRB,0.39317E+01_JPRB,0.42460E+01_JPRB,0.45479E+01_JPRB /)  
KB(:,41,13) = (/ &
 & 0.31746E+01_JPRB,0.35197E+01_JPRB,0.38475E+01_JPRB,0.41644E+01_JPRB,0.44716E+01_JPRB /)  
KB(:,42,13) = (/ &
 & 0.30768E+01_JPRB,0.34312E+01_JPRB,0.37630E+01_JPRB,0.40826E+01_JPRB,0.43924E+01_JPRB /)  
KB(:,43,13) = (/ &
 & 0.29558E+01_JPRB,0.33178E+01_JPRB,0.36587E+01_JPRB,0.39822E+01_JPRB,0.42959E+01_JPRB /)  
KB(:,44,13) = (/ &
 & 0.28280E+01_JPRB,0.31906E+01_JPRB,0.35435E+01_JPRB,0.38727E+01_JPRB,0.41899E+01_JPRB /)  
KB(:,45,13) = (/ &
 & 0.26988E+01_JPRB,0.30597E+01_JPRB,0.34201E+01_JPRB,0.37628E+01_JPRB,0.40831E+01_JPRB /)  
KB(:,46,13) = (/ &
 & 0.25661E+01_JPRB,0.29262E+01_JPRB,0.32865E+01_JPRB,0.36383E+01_JPRB,0.39682E+01_JPRB /)  
KB(:,47,13) = (/ &
 & 0.24176E+01_JPRB,0.27716E+01_JPRB,0.31308E+01_JPRB,0.34925E+01_JPRB,0.38381E+01_JPRB /)  
KB(:,48,13) = (/ &
 & 0.22754E+01_JPRB,0.26218E+01_JPRB,0.29793E+01_JPRB,0.33363E+01_JPRB,0.36948E+01_JPRB /)  
KB(:,49,13) = (/ &
 & 0.21329E+01_JPRB,0.24724E+01_JPRB,0.28302E+01_JPRB,0.31874E+01_JPRB,0.35454E+01_JPRB /)  
KB(:,50,13) = (/ &
 & 0.20005E+01_JPRB,0.23398E+01_JPRB,0.26856E+01_JPRB,0.30422E+01_JPRB,0.34002E+01_JPRB /)  
KB(:,51,13) = (/ &
 & 0.18713E+01_JPRB,0.22087E+01_JPRB,0.25515E+01_JPRB,0.29067E+01_JPRB,0.32588E+01_JPRB /)  
KB(:,52,13) = (/ &
 & 0.17459E+01_JPRB,0.20772E+01_JPRB,0.24169E+01_JPRB,0.27666E+01_JPRB,0.31241E+01_JPRB /)  
KB(:,53,13) = (/ &
 & 0.16095E+01_JPRB,0.19502E+01_JPRB,0.22895E+01_JPRB,0.26325E+01_JPRB,0.29855E+01_JPRB /)  
KB(:,54,13) = (/ &
 & 0.15066E+01_JPRB,0.18320E+01_JPRB,0.21659E+01_JPRB,0.25081E+01_JPRB,0.28569E+01_JPRB /)  
KB(:,55,13) = (/ &
 & 0.14318E+01_JPRB,0.17117E+01_JPRB,0.20491E+01_JPRB,0.23896E+01_JPRB,0.27343E+01_JPRB /)  
KB(:,56,13) = (/ &
 & 0.13449E+01_JPRB,0.16235E+01_JPRB,0.19309E+01_JPRB,0.22682E+01_JPRB,0.26139E+01_JPRB /)  
KB(:,57,13) = (/ &
 & 0.12667E+01_JPRB,0.15514E+01_JPRB,0.18274E+01_JPRB,0.21528E+01_JPRB,0.24919E+01_JPRB /)  
KB(:,58,13) = (/ &
 & 0.11763E+01_JPRB,0.14696E+01_JPRB,0.17445E+01_JPRB,0.20345E+01_JPRB,0.23757E+01_JPRB /)  
KB(:,59,13) = (/ &
 & 0.11472E+01_JPRB,0.14428E+01_JPRB,0.17312E+01_JPRB,0.20031E+01_JPRB,0.23234E+01_JPRB /)  
KB(:,13,14) = (/ &
 & 0.15147E+02_JPRB,0.15130E+02_JPRB,0.15113E+02_JPRB,0.15099E+02_JPRB,0.15078E+02_JPRB /)  
KB(:,14,14) = (/ &
 & 0.15510E+02_JPRB,0.15546E+02_JPRB,0.15567E+02_JPRB,0.15587E+02_JPRB,0.15585E+02_JPRB /)  
KB(:,15,14) = (/ &
 & 0.15739E+02_JPRB,0.15841E+02_JPRB,0.15930E+02_JPRB,0.15986E+02_JPRB,0.16004E+02_JPRB /)  
KB(:,16,14) = (/ &
 & 0.15858E+02_JPRB,0.16042E+02_JPRB,0.16196E+02_JPRB,0.16295E+02_JPRB,0.16347E+02_JPRB /)  
KB(:,17,14) = (/ &
 & 0.15892E+02_JPRB,0.16168E+02_JPRB,0.16375E+02_JPRB,0.16519E+02_JPRB,0.16620E+02_JPRB /)  
KB(:,18,14) = (/ &
 & 0.15890E+02_JPRB,0.16233E+02_JPRB,0.16495E+02_JPRB,0.16687E+02_JPRB,0.16843E+02_JPRB /)  
KB(:,19,14) = (/ &
 & 0.15860E+02_JPRB,0.16260E+02_JPRB,0.16572E+02_JPRB,0.16822E+02_JPRB,0.17016E+02_JPRB /)  
KB(:,20,14) = (/ &
 & 0.15821E+02_JPRB,0.16274E+02_JPRB,0.16642E+02_JPRB,0.16937E+02_JPRB,0.17165E+02_JPRB /)  
KB(:,21,14) = (/ &
 & 0.15778E+02_JPRB,0.16284E+02_JPRB,0.16705E+02_JPRB,0.17036E+02_JPRB,0.17293E+02_JPRB /)  
KB(:,22,14) = (/ &
 & 0.15777E+02_JPRB,0.16337E+02_JPRB,0.16794E+02_JPRB,0.17151E+02_JPRB,0.17417E+02_JPRB /)  
KB(:,23,14) = (/ &
 & 0.15815E+02_JPRB,0.16408E+02_JPRB,0.16883E+02_JPRB,0.17258E+02_JPRB,0.17537E+02_JPRB /)  
KB(:,24,14) = (/ &
 & 0.15884E+02_JPRB,0.16493E+02_JPRB,0.16982E+02_JPRB,0.17365E+02_JPRB,0.17648E+02_JPRB /)  
KB(:,25,14) = (/ &
 & 0.15973E+02_JPRB,0.16594E+02_JPRB,0.17087E+02_JPRB,0.17470E+02_JPRB,0.17753E+02_JPRB /)  
KB(:,26,14) = (/ &
 & 0.16098E+02_JPRB,0.16711E+02_JPRB,0.17198E+02_JPRB,0.17574E+02_JPRB,0.17853E+02_JPRB /)  
KB(:,27,14) = (/ &
 & 0.16232E+02_JPRB,0.16836E+02_JPRB,0.17310E+02_JPRB,0.17676E+02_JPRB,0.17946E+02_JPRB /)  
KB(:,28,14) = (/ &
 & 0.16376E+02_JPRB,0.16966E+02_JPRB,0.17425E+02_JPRB,0.17775E+02_JPRB,0.18032E+02_JPRB /)  
KB(:,29,14) = (/ &
 & 0.16527E+02_JPRB,0.17096E+02_JPRB,0.17538E+02_JPRB,0.17871E+02_JPRB,0.18111E+02_JPRB /)  
KB(:,30,14) = (/ &
 & 0.16681E+02_JPRB,0.17223E+02_JPRB,0.17646E+02_JPRB,0.17959E+02_JPRB,0.18183E+02_JPRB /)  
KB(:,31,14) = (/ &
 & 0.16832E+02_JPRB,0.17348E+02_JPRB,0.17747E+02_JPRB,0.18041E+02_JPRB,0.18247E+02_JPRB /)  
KB(:,32,14) = (/ &
 & 0.16982E+02_JPRB,0.17470E+02_JPRB,0.17844E+02_JPRB,0.18116E+02_JPRB,0.18304E+02_JPRB /)  
KB(:,33,14) = (/ &
 & 0.17125E+02_JPRB,0.17586E+02_JPRB,0.17935E+02_JPRB,0.18187E+02_JPRB,0.18356E+02_JPRB /)  
KB(:,34,14) = (/ &
 & 0.17243E+02_JPRB,0.17681E+02_JPRB,0.18009E+02_JPRB,0.18243E+02_JPRB,0.18396E+02_JPRB /)  
KB(:,35,14) = (/ &
 & 0.17308E+02_JPRB,0.17736E+02_JPRB,0.18053E+02_JPRB,0.18277E+02_JPRB,0.18422E+02_JPRB /)  
KB(:,36,14) = (/ &
 & 0.17321E+02_JPRB,0.17747E+02_JPRB,0.18064E+02_JPRB,0.18289E+02_JPRB,0.18431E+02_JPRB /)  
KB(:,37,14) = (/ &
 & 0.17259E+02_JPRB,0.17701E+02_JPRB,0.18033E+02_JPRB,0.18270E+02_JPRB,0.18425E+02_JPRB /)  
KB(:,38,14) = (/ &
 & 0.17190E+02_JPRB,0.17649E+02_JPRB,0.17997E+02_JPRB,0.18247E+02_JPRB,0.18415E+02_JPRB /)  
KB(:,39,14) = (/ &
 & 0.17116E+02_JPRB,0.17594E+02_JPRB,0.17957E+02_JPRB,0.18221E+02_JPRB,0.18401E+02_JPRB /)  
KB(:,40,14) = (/ &
 & 0.16981E+02_JPRB,0.17491E+02_JPRB,0.17882E+02_JPRB,0.18168E+02_JPRB,0.18367E+02_JPRB /)  
KB(:,41,14) = (/ &
 & 0.16829E+02_JPRB,0.17375E+02_JPRB,0.17795E+02_JPRB,0.18107E+02_JPRB,0.18328E+02_JPRB /)  
KB(:,42,14) = (/ &
 & 0.16667E+02_JPRB,0.17250E+02_JPRB,0.17700E+02_JPRB,0.18038E+02_JPRB,0.18281E+02_JPRB /)  
KB(:,43,14) = (/ &
 & 0.16452E+02_JPRB,0.17082E+02_JPRB,0.17573E+02_JPRB,0.17944E+02_JPRB,0.18214E+02_JPRB /)  
KB(:,44,14) = (/ &
 & 0.16203E+02_JPRB,0.16887E+02_JPRB,0.17421E+02_JPRB,0.17833E+02_JPRB,0.18135E+02_JPRB /)  
KB(:,45,14) = (/ &
 & 0.15935E+02_JPRB,0.16673E+02_JPRB,0.17257E+02_JPRB,0.17708E+02_JPRB,0.18046E+02_JPRB /)  
KB(:,46,14) = (/ &
 & 0.15628E+02_JPRB,0.16427E+02_JPRB,0.17064E+02_JPRB,0.17560E+02_JPRB,0.17936E+02_JPRB /)  
KB(:,47,14) = (/ &
 & 0.15258E+02_JPRB,0.16126E+02_JPRB,0.16827E+02_JPRB,0.17377E+02_JPRB,0.17799E+02_JPRB /)  
KB(:,48,14) = (/ &
 & 0.14864E+02_JPRB,0.15798E+02_JPRB,0.16564E+02_JPRB,0.17174E+02_JPRB,0.17643E+02_JPRB /)  
KB(:,49,14) = (/ &
 & 0.14439E+02_JPRB,0.15441E+02_JPRB,0.16276E+02_JPRB,0.16946E+02_JPRB,0.17469E+02_JPRB /)  
KB(:,50,14) = (/ &
 & 0.14012E+02_JPRB,0.15084E+02_JPRB,0.15980E+02_JPRB,0.16711E+02_JPRB,0.17289E+02_JPRB /)  
KB(:,51,14) = (/ &
 & 0.13576E+02_JPRB,0.14715E+02_JPRB,0.15671E+02_JPRB,0.16463E+02_JPRB,0.17096E+02_JPRB /)  
KB(:,52,14) = (/ &
 & 0.13120E+02_JPRB,0.14320E+02_JPRB,0.15341E+02_JPRB,0.16194E+02_JPRB,0.16882E+02_JPRB /)  
KB(:,53,14) = (/ &
 & 0.12642E+02_JPRB,0.13899E+02_JPRB,0.14988E+02_JPRB,0.15902E+02_JPRB,0.16649E+02_JPRB /)  
KB(:,54,14) = (/ &
 & 0.12147E+02_JPRB,0.13496E+02_JPRB,0.14645E+02_JPRB,0.15614E+02_JPRB,0.16418E+02_JPRB /)  
KB(:,55,14) = (/ &
 & 0.11626E+02_JPRB,0.13090E+02_JPRB,0.14295E+02_JPRB,0.15320E+02_JPRB,0.16178E+02_JPRB /)  
KB(:,56,14) = (/ &
 & 0.11110E+02_JPRB,0.12619E+02_JPRB,0.13926E+02_JPRB,0.15012E+02_JPRB,0.15922E+02_JPRB /)  
KB(:,57,14) = (/ &
 & 0.10565E+02_JPRB,0.12110E+02_JPRB,0.13518E+02_JPRB,0.14685E+02_JPRB,0.15649E+02_JPRB /)  
KB(:,58,14) = (/ &
 & 0.10061E+02_JPRB,0.11633E+02_JPRB,0.13084E+02_JPRB,0.14356E+02_JPRB,0.15374E+02_JPRB /)  
KB(:,59,14) = (/ &
 & 0.98377E+01_JPRB,0.11416E+02_JPRB,0.12868E+02_JPRB,0.14184E+02_JPRB,0.15259E+02_JPRB /)  
KB(:,13,15) = (/ &
 & 0.41304E+02_JPRB,0.40483E+02_JPRB,0.39654E+02_JPRB,0.38829E+02_JPRB,0.38029E+02_JPRB /)  
KB(:,14,15) = (/ &
 & 0.44686E+02_JPRB,0.43762E+02_JPRB,0.42836E+02_JPRB,0.41888E+02_JPRB,0.41004E+02_JPRB /)  
KB(:,15,15) = (/ &
 & 0.48004E+02_JPRB,0.46942E+02_JPRB,0.45864E+02_JPRB,0.44813E+02_JPRB,0.43844E+02_JPRB /)  
KB(:,16,15) = (/ &
 & 0.51150E+02_JPRB,0.49938E+02_JPRB,0.48734E+02_JPRB,0.47591E+02_JPRB,0.46512E+02_JPRB /)  
KB(:,17,15) = (/ &
 & 0.54100E+02_JPRB,0.52729E+02_JPRB,0.51435E+02_JPRB,0.50180E+02_JPRB,0.48962E+02_JPRB /)  
KB(:,18,15) = (/ &
 & 0.56777E+02_JPRB,0.55306E+02_JPRB,0.53894E+02_JPRB,0.52525E+02_JPRB,0.51164E+02_JPRB /)  
KB(:,19,15) = (/ &
 & 0.59186E+02_JPRB,0.57635E+02_JPRB,0.56100E+02_JPRB,0.54603E+02_JPRB,0.53129E+02_JPRB /)  
KB(:,20,15) = (/ &
 & 0.61293E+02_JPRB,0.59648E+02_JPRB,0.58005E+02_JPRB,0.56388E+02_JPRB,0.54798E+02_JPRB /)  
KB(:,21,15) = (/ &
 & 0.63124E+02_JPRB,0.61368E+02_JPRB,0.59613E+02_JPRB,0.57895E+02_JPRB,0.56204E+02_JPRB /)  
KB(:,22,15) = (/ &
 & 0.64562E+02_JPRB,0.62695E+02_JPRB,0.60841E+02_JPRB,0.59040E+02_JPRB,0.57268E+02_JPRB /)  
KB(:,23,15) = (/ &
 & 0.65690E+02_JPRB,0.63742E+02_JPRB,0.61820E+02_JPRB,0.59937E+02_JPRB,0.58087E+02_JPRB /)  
KB(:,24,15) = (/ &
 & 0.66548E+02_JPRB,0.64535E+02_JPRB,0.62550E+02_JPRB,0.60597E+02_JPRB,0.58690E+02_JPRB /)  
KB(:,25,15) = (/ &
 & 0.67194E+02_JPRB,0.65115E+02_JPRB,0.63062E+02_JPRB,0.61050E+02_JPRB,0.59091E+02_JPRB /)  
KB(:,26,15) = (/ &
 & 0.67597E+02_JPRB,0.65466E+02_JPRB,0.63369E+02_JPRB,0.61312E+02_JPRB,0.59309E+02_JPRB /)  
KB(:,27,15) = (/ &
 & 0.67831E+02_JPRB,0.65647E+02_JPRB,0.63518E+02_JPRB,0.61430E+02_JPRB,0.59393E+02_JPRB /)  
KB(:,28,15) = (/ &
 & 0.67908E+02_JPRB,0.65687E+02_JPRB,0.63527E+02_JPRB,0.61427E+02_JPRB,0.59357E+02_JPRB /)  
KB(:,29,15) = (/ &
 & 0.67845E+02_JPRB,0.65603E+02_JPRB,0.63419E+02_JPRB,0.61304E+02_JPRB,0.59222E+02_JPRB /)  
KB(:,30,15) = (/ &
 & 0.67682E+02_JPRB,0.65422E+02_JPRB,0.63225E+02_JPRB,0.61094E+02_JPRB,0.59010E+02_JPRB /)  
KB(:,31,15) = (/ &
 & 0.67415E+02_JPRB,0.65154E+02_JPRB,0.62953E+02_JPRB,0.60816E+02_JPRB,0.58721E+02_JPRB /)  
KB(:,32,15) = (/ &
 & 0.67084E+02_JPRB,0.64817E+02_JPRB,0.62622E+02_JPRB,0.60477E+02_JPRB,0.58393E+02_JPRB /)  
KB(:,33,15) = (/ &
 & 0.66692E+02_JPRB,0.64428E+02_JPRB,0.62242E+02_JPRB,0.60092E+02_JPRB,0.58024E+02_JPRB /)  
KB(:,34,15) = (/ &
 & 0.66346E+02_JPRB,0.64077E+02_JPRB,0.61890E+02_JPRB,0.59745E+02_JPRB,0.57700E+02_JPRB /)  
KB(:,35,15) = (/ &
 & 0.66188E+02_JPRB,0.63920E+02_JPRB,0.61727E+02_JPRB,0.59582E+02_JPRB,0.57542E+02_JPRB /)  
KB(:,36,15) = (/ &
 & 0.66248E+02_JPRB,0.63978E+02_JPRB,0.61782E+02_JPRB,0.59625E+02_JPRB,0.57587E+02_JPRB /)  
KB(:,37,15) = (/ &
 & 0.66642E+02_JPRB,0.64358E+02_JPRB,0.62144E+02_JPRB,0.59978E+02_JPRB,0.57911E+02_JPRB /)  
KB(:,38,15) = (/ &
 & 0.67048E+02_JPRB,0.64747E+02_JPRB,0.62516E+02_JPRB,0.60340E+02_JPRB,0.58249E+02_JPRB /)  
KB(:,39,15) = (/ &
 & 0.67435E+02_JPRB,0.65122E+02_JPRB,0.62879E+02_JPRB,0.60689E+02_JPRB,0.58578E+02_JPRB /)  
KB(:,40,15) = (/ &
 & 0.68061E+02_JPRB,0.65724E+02_JPRB,0.63462E+02_JPRB,0.61257E+02_JPRB,0.59113E+02_JPRB /)  
KB(:,41,15) = (/ &
 & 0.68702E+02_JPRB,0.66354E+02_JPRB,0.64067E+02_JPRB,0.61847E+02_JPRB,0.59682E+02_JPRB /)  
KB(:,42,15) = (/ &
 & 0.69355E+02_JPRB,0.66983E+02_JPRB,0.64678E+02_JPRB,0.62437E+02_JPRB,0.60259E+02_JPRB /)  
KB(:,43,15) = (/ &
 & 0.70142E+02_JPRB,0.67744E+02_JPRB,0.65416E+02_JPRB,0.63159E+02_JPRB,0.60959E+02_JPRB /)  
KB(:,44,15) = (/ &
 & 0.70991E+02_JPRB,0.68567E+02_JPRB,0.66218E+02_JPRB,0.63930E+02_JPRB,0.61713E+02_JPRB /)  
KB(:,45,15) = (/ &
 & 0.71837E+02_JPRB,0.69401E+02_JPRB,0.67026E+02_JPRB,0.64713E+02_JPRB,0.62473E+02_JPRB /)  
KB(:,46,15) = (/ &
 & 0.72733E+02_JPRB,0.70287E+02_JPRB,0.67885E+02_JPRB,0.65552E+02_JPRB,0.63292E+02_JPRB /)  
KB(:,47,15) = (/ &
 & 0.73741E+02_JPRB,0.71285E+02_JPRB,0.68859E+02_JPRB,0.66493E+02_JPRB,0.64198E+02_JPRB /)  
KB(:,48,15) = (/ &
 & 0.74725E+02_JPRB,0.72283E+02_JPRB,0.69840E+02_JPRB,0.67442E+02_JPRB,0.65125E+02_JPRB /)  
KB(:,49,15) = (/ &
 & 0.75665E+02_JPRB,0.73280E+02_JPRB,0.70828E+02_JPRB,0.68404E+02_JPRB,0.66060E+02_JPRB /)  
KB(:,50,15) = (/ &
 & 0.76534E+02_JPRB,0.74218E+02_JPRB,0.71764E+02_JPRB,0.69323E+02_JPRB,0.66942E+02_JPRB /)  
KB(:,51,15) = (/ &
 & 0.77333E+02_JPRB,0.75093E+02_JPRB,0.72664E+02_JPRB,0.70214E+02_JPRB,0.67806E+02_JPRB /)  
KB(:,52,15) = (/ &
 & 0.78102E+02_JPRB,0.75935E+02_JPRB,0.73563E+02_JPRB,0.71111E+02_JPRB,0.68683E+02_JPRB /)  
KB(:,53,15) = (/ &
 & 0.78815E+02_JPRB,0.76761E+02_JPRB,0.74462E+02_JPRB,0.72010E+02_JPRB,0.69568E+02_JPRB /)  
KB(:,54,15) = (/ &
 & 0.79431E+02_JPRB,0.77488E+02_JPRB,0.75258E+02_JPRB,0.72840E+02_JPRB,0.70386E+02_JPRB /)  
KB(:,55,15) = (/ &
 & 0.79987E+02_JPRB,0.78156E+02_JPRB,0.75999E+02_JPRB,0.73628E+02_JPRB,0.71177E+02_JPRB /)  
KB(:,56,15) = (/ &
 & 0.80478E+02_JPRB,0.78776E+02_JPRB,0.76714E+02_JPRB,0.74415E+02_JPRB,0.71963E+02_JPRB /)  
KB(:,57,15) = (/ &
 & 0.80898E+02_JPRB,0.79365E+02_JPRB,0.77410E+02_JPRB,0.75181E+02_JPRB,0.72750E+02_JPRB /)  
KB(:,58,15) = (/ &
 & 0.81210E+02_JPRB,0.79894E+02_JPRB,0.78053E+02_JPRB,0.75880E+02_JPRB,0.73498E+02_JPRB /)  
KB(:,59,15) = (/ &
 & 0.81312E+02_JPRB,0.80086E+02_JPRB,0.78299E+02_JPRB,0.76156E+02_JPRB,0.73801E+02_JPRB /)  
KB(:,13,16) = (/ &
 & 0.81866E+02_JPRB,0.78569E+02_JPRB,0.75624E+02_JPRB,0.72854E+02_JPRB,0.70288E+02_JPRB /)  
KB(:,14,16) = (/ &
 & 0.93095E+02_JPRB,0.88986E+02_JPRB,0.85351E+02_JPRB,0.82051E+02_JPRB,0.78936E+02_JPRB /)  
KB(:,15,16) = (/ &
 & 0.10470E+03_JPRB,0.99738E+02_JPRB,0.95227E+02_JPRB,0.91249E+02_JPRB,0.87478E+02_JPRB /)  
KB(:,16,16) = (/ &
 & 0.11635E+03_JPRB,0.11037E+03_JPRB,0.10495E+03_JPRB,0.10011E+03_JPRB,0.95646E+02_JPRB /)  
KB(:,17,16) = (/ &
 & 0.12769E+03_JPRB,0.12074E+03_JPRB,0.11431E+03_JPRB,0.10856E+03_JPRB,0.10332E+03_JPRB /)  
KB(:,18,16) = (/ &
 & 0.13851E+03_JPRB,0.13038E+03_JPRB,0.12299E+03_JPRB,0.11635E+03_JPRB,0.11033E+03_JPRB /)  
KB(:,19,16) = (/ &
 & 0.14848E+03_JPRB,0.13912E+03_JPRB,0.13084E+03_JPRB,0.12336E+03_JPRB,0.11656E+03_JPRB /)  
KB(:,20,16) = (/ &
 & 0.15718E+03_JPRB,0.14679E+03_JPRB,0.13761E+03_JPRB,0.12934E+03_JPRB,0.12188E+03_JPRB /)  
KB(:,21,16) = (/ &
 & 0.16462E+03_JPRB,0.15341E+03_JPRB,0.14345E+03_JPRB,0.13443E+03_JPRB,0.12636E+03_JPRB /)  
KB(:,22,16) = (/ &
 & 0.17012E+03_JPRB,0.15822E+03_JPRB,0.14760E+03_JPRB,0.13801E+03_JPRB,0.12950E+03_JPRB /)  
KB(:,23,16) = (/ &
 & 0.17437E+03_JPRB,0.16184E+03_JPRB,0.15069E+03_JPRB,0.14069E+03_JPRB,0.13184E+03_JPRB /)  
KB(:,24,16) = (/ &
 & 0.17733E+03_JPRB,0.16436E+03_JPRB,0.15282E+03_JPRB,0.14251E+03_JPRB,0.13340E+03_JPRB /)  
KB(:,25,16) = (/ &
 & 0.17910E+03_JPRB,0.16583E+03_JPRB,0.15401E+03_JPRB,0.14354E+03_JPRB,0.13426E+03_JPRB /)  
KB(:,26,16) = (/ &
 & 0.17968E+03_JPRB,0.16627E+03_JPRB,0.15433E+03_JPRB,0.14378E+03_JPRB,0.13445E+03_JPRB /)  
KB(:,27,16) = (/ &
 & 0.17946E+03_JPRB,0.16602E+03_JPRB,0.15406E+03_JPRB,0.14351E+03_JPRB,0.13417E+03_JPRB /)  
KB(:,28,16) = (/ &
 & 0.17860E+03_JPRB,0.16522E+03_JPRB,0.15334E+03_JPRB,0.14282E+03_JPRB,0.13355E+03_JPRB /)  
KB(:,29,16) = (/ &
 & 0.17717E+03_JPRB,0.16389E+03_JPRB,0.15216E+03_JPRB,0.14174E+03_JPRB,0.13260E+03_JPRB /)  
KB(:,30,16) = (/ &
 & 0.17533E+03_JPRB,0.16225E+03_JPRB,0.15066E+03_JPRB,0.14043E+03_JPRB,0.13143E+03_JPRB /)  
KB(:,31,16) = (/ &
 & 0.17313E+03_JPRB,0.16029E+03_JPRB,0.14890E+03_JPRB,0.13886E+03_JPRB,0.13004E+03_JPRB /)  
KB(:,32,16) = (/ &
 & 0.17069E+03_JPRB,0.15811E+03_JPRB,0.14694E+03_JPRB,0.13716E+03_JPRB,0.12847E+03_JPRB /)  
KB(:,33,16) = (/ &
 & 0.16804E+03_JPRB,0.15577E+03_JPRB,0.14487E+03_JPRB,0.13533E+03_JPRB,0.12682E+03_JPRB /)  
KB(:,34,16) = (/ &
 & 0.16580E+03_JPRB,0.15376E+03_JPRB,0.14309E+03_JPRB,0.13376E+03_JPRB,0.12539E+03_JPRB /)  
KB(:,35,16) = (/ &
 & 0.16467E+03_JPRB,0.15275E+03_JPRB,0.14221E+03_JPRB,0.13298E+03_JPRB,0.12468E+03_JPRB /)  
KB(:,36,16) = (/ &
 & 0.16486E+03_JPRB,0.15289E+03_JPRB,0.14233E+03_JPRB,0.13308E+03_JPRB,0.12477E+03_JPRB /)  
KB(:,37,16) = (/ &
 & 0.16688E+03_JPRB,0.15469E+03_JPRB,0.14392E+03_JPRB,0.13446E+03_JPRB,0.12602E+03_JPRB /)  
KB(:,38,16) = (/ &
 & 0.16902E+03_JPRB,0.15657E+03_JPRB,0.14555E+03_JPRB,0.13592E+03_JPRB,0.12732E+03_JPRB /)  
KB(:,39,16) = (/ &
 & 0.17110E+03_JPRB,0.15844E+03_JPRB,0.14718E+03_JPRB,0.13734E+03_JPRB,0.12861E+03_JPRB /)  
KB(:,40,16) = (/ &
 & 0.17468E+03_JPRB,0.16155E+03_JPRB,0.14992E+03_JPRB,0.13976E+03_JPRB,0.13077E+03_JPRB /)  
KB(:,41,16) = (/ &
 & 0.17848E+03_JPRB,0.16489E+03_JPRB,0.15289E+03_JPRB,0.14236E+03_JPRB,0.13307E+03_JPRB /)  
KB(:,42,16) = (/ &
 & 0.18237E+03_JPRB,0.16833E+03_JPRB,0.15592E+03_JPRB,0.14501E+03_JPRB,0.13541E+03_JPRB /)  
KB(:,43,16) = (/ &
 & 0.18726E+03_JPRB,0.17263E+03_JPRB,0.15975E+03_JPRB,0.14834E+03_JPRB,0.13835E+03_JPRB /)  
KB(:,44,16) = (/ &
 & 0.19275E+03_JPRB,0.17748E+03_JPRB,0.16403E+03_JPRB,0.15210E+03_JPRB,0.14166E+03_JPRB /)  
KB(:,45,16) = (/ &
 & 0.19851E+03_JPRB,0.18250E+03_JPRB,0.16844E+03_JPRB,0.15602E+03_JPRB,0.14507E+03_JPRB /)  
KB(:,46,16) = (/ &
 & 0.20490E+03_JPRB,0.18806E+03_JPRB,0.17333E+03_JPRB,0.16038E+03_JPRB,0.14888E+03_JPRB /)  
KB(:,47,16) = (/ &
 & 0.21238E+03_JPRB,0.19462E+03_JPRB,0.17910E+03_JPRB,0.16545E+03_JPRB,0.15337E+03_JPRB /)  
KB(:,48,16) = (/ &
 & 0.22029E+03_JPRB,0.20156E+03_JPRB,0.18514E+03_JPRB,0.17074E+03_JPRB,0.15806E+03_JPRB /)  
KB(:,49,16) = (/ &
 & 0.22889E+03_JPRB,0.20882E+03_JPRB,0.19150E+03_JPRB,0.17637E+03_JPRB,0.16304E+03_JPRB /)  
KB(:,50,16) = (/ &
 & 0.23745E+03_JPRB,0.21596E+03_JPRB,0.19782E+03_JPRB,0.18187E+03_JPRB,0.16787E+03_JPRB /)  
KB(:,51,16) = (/ &
 & 0.24629E+03_JPRB,0.22340E+03_JPRB,0.20422E+03_JPRB,0.18747E+03_JPRB,0.17280E+03_JPRB /)  
KB(:,52,16) = (/ &
 & 0.25553E+03_JPRB,0.23136E+03_JPRB,0.21090E+03_JPRB,0.19335E+03_JPRB,0.17798E+03_JPRB /)  
KB(:,53,16) = (/ &
 & 0.26553E+03_JPRB,0.23980E+03_JPRB,0.21793E+03_JPRB,0.19951E+03_JPRB,0.18336E+03_JPRB /)  
KB(:,54,16) = (/ &
 & 0.27524E+03_JPRB,0.24799E+03_JPRB,0.22485E+03_JPRB,0.20544E+03_JPRB,0.18854E+03_JPRB /)  
KB(:,55,16) = (/ &
 & 0.28502E+03_JPRB,0.25615E+03_JPRB,0.23188E+03_JPRB,0.21133E+03_JPRB,0.19372E+03_JPRB /)  
KB(:,56,16) = (/ &
 & 0.29529E+03_JPRB,0.26491E+03_JPRB,0.23927E+03_JPRB,0.21749E+03_JPRB,0.19913E+03_JPRB /)  
KB(:,57,16) = (/ &
 & 0.30624E+03_JPRB,0.27413E+03_JPRB,0.24703E+03_JPRB,0.22404E+03_JPRB,0.20478E+03_JPRB /)  
KB(:,58,16) = (/ &
 & 0.31727E+03_JPRB,0.28329E+03_JPRB,0.25471E+03_JPRB,0.23065E+03_JPRB,0.21031E+03_JPRB /)  
KB(:,59,16) = (/ &
 & 0.32188E+03_JPRB,0.28710E+03_JPRB,0.25796E+03_JPRB,0.23341E+03_JPRB,0.21261E+03_JPRB /)  

!     -----------------------------------------------------------------

FORREF(:, 1) = (/ 0.214504E-06_JPRB, 0.460418E-06_JPRB, 0.357608E-05_JPRB, 0.192037E-05_JPRB /)
FORREF(:, 2) = (/ 0.142576E-05_JPRB, 0.364463E-05_JPRB, 0.117033E-04_JPRB, 0.112085E-04_JPRB /)
FORREF(:, 3) = (/ 0.101536E-04_JPRB, 0.124096E-04_JPRB, 0.509190E-04_JPRB, 0.565282E-04_JPRB /)
FORREF(:, 4) = (/ 0.143394E-03_JPRB, 0.154700E-03_JPRB, 0.466498E-03_JPRB, 0.918829E-03_JPRB /)
FORREF(:, 5) = (/ 0.251631E-02_JPRB, 0.241729E-02_JPRB, 0.240057E-02_JPRB, 0.350408E-02_JPRB /)
FORREF(:, 6) = (/ 0.410309E-02_JPRB, 0.416851E-02_JPRB, 0.390925E-02_JPRB, 0.383694E-02_JPRB /)
FORREF(:, 7) = (/ 0.445387E-02_JPRB, 0.448657E-02_JPRB, 0.432310E-02_JPRB, 0.370739E-02_JPRB /)
FORREF(:, 8) = (/ 0.458150E-02_JPRB, 0.460014E-02_JPRB, 0.450245E-02_JPRB, 0.336718E-02_JPRB /)
FORREF(:, 9) = (/ 0.465423E-02_JPRB, 0.465595E-02_JPRB, 0.467006E-02_JPRB, 0.368061E-02_JPRB /)
FORREF(:,10) = (/ 0.493955E-02_JPRB, 0.490181E-02_JPRB, 0.481941E-02_JPRB, 0.367577E-02_JPRB /)
FORREF(:,11) = (/ 0.511876E-02_JPRB, 0.490981E-02_JPRB, 0.493303E-02_JPRB, 0.357423E-02_JPRB /)
FORREF(:,12) = (/ 0.509845E-02_JPRB, 0.511556E-02_JPRB, 0.504031E-02_JPRB, 0.355915E-02_JPRB /)
FORREF(:,13) = (/ 0.523822E-02_JPRB, 0.530473E-02_JPRB, 0.523811E-02_JPRB, 0.414259E-02_JPRB /)
FORREF(:,14) = (/ 0.551133E-02_JPRB, 0.535831E-02_JPRB, 0.546702E-02_JPRB, 0.473875E-02_JPRB /)
FORREF(:,15) = (/ 0.609781E-02_JPRB, 0.589859E-02_JPRB, 0.561187E-02_JPRB, 0.528981E-02_JPRB /)
FORREF(:,16) = (/ 0.644958E-02_JPRB, 0.631718E-02_JPRB, 0.625201E-02_JPRB, 0.600448E-02_JPRB /)

!     -----------------------------------------------------------------
!     The array SELFREF contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

SELFREF(:, 1) = (/ &
 & 0.217058E-03_JPRB, 0.176391E-03_JPRB, 0.143342E-03_JPRB, 0.116486E-03_JPRB, 0.946614E-04_JPRB, &
 & 0.769257E-04_JPRB, 0.625131E-04_JPRB, 0.508007E-04_JPRB, 0.412828E-04_JPRB, 0.335481E-04_JPRB /)  
SELFREF(:, 2) = (/ &
 & 0.598055E-03_JPRB, 0.484805E-03_JPRB, 0.393000E-03_JPRB, 0.318580E-03_JPRB, 0.258252E-03_JPRB, &
 & 0.209348E-03_JPRB, 0.169705E-03_JPRB, 0.137569E-03_JPRB, 0.111518E-03_JPRB, 0.904008E-04_JPRB /)  
SELFREF(:, 3) = (/ &
 & 0.102691E-02_JPRB, 0.930281E-03_JPRB, 0.842740E-03_JPRB, 0.763437E-03_JPRB, 0.691596E-03_JPRB, &
 & 0.626516E-03_JPRB, 0.567560E-03_JPRB, 0.514152E-03_JPRB, 0.465769E-03_JPRB, 0.421940E-03_JPRB /)  
SELFREF(:, 4) = (/ &
 & 0.388569E-02_JPRB, 0.365098E-02_JPRB, 0.343045E-02_JPRB, 0.322324E-02_JPRB, 0.302854E-02_JPRB, &
 & 0.284561E-02_JPRB, 0.267372E-02_JPRB, 0.251222E-02_JPRB, 0.236047E-02_JPRB, 0.221789E-02_JPRB /)  
SELFREF(:, 5) = (/ &
 & 0.349845E-01_JPRB, 0.326678E-01_JPRB, 0.305045E-01_JPRB, 0.284845E-01_JPRB, 0.265982E-01_JPRB, &
 & 0.248369E-01_JPRB, 0.231921E-01_JPRB, 0.216563E-01_JPRB, 0.202222E-01_JPRB, 0.188831E-01_JPRB /)  
SELFREF(:, 6) = (/ &
 & 0.613705E-01_JPRB, 0.562676E-01_JPRB, 0.515890E-01_JPRB, 0.472994E-01_JPRB, 0.433665E-01_JPRB, &
 & 0.397606E-01_JPRB, 0.364545E-01_JPRB, 0.334233E-01_JPRB, 0.306442E-01_JPRB, 0.280961E-01_JPRB /)  
SELFREF(:, 7) = (/ &
 & 0.656981E-01_JPRB, 0.602660E-01_JPRB, 0.552830E-01_JPRB, 0.507120E-01_JPRB, 0.465190E-01_JPRB, &
 & 0.426726E-01_JPRB, 0.391443E-01_JPRB, 0.359077E-01_JPRB, 0.329387E-01_JPRB, 0.302153E-01_JPRB /)  
SELFREF(:, 8) = (/ &
 & 0.671782E-01_JPRB, 0.616461E-01_JPRB, 0.565695E-01_JPRB, 0.519110E-01_JPRB, 0.476361E-01_JPRB, &
 & 0.437132E-01_JPRB, 0.401134E-01_JPRB, 0.368100E-01_JPRB, 0.337787E-01_JPRB, 0.309970E-01_JPRB /)  
SELFREF(:, 9) = (/ &
 & 0.675902E-01_JPRB, 0.620888E-01_JPRB, 0.570351E-01_JPRB, 0.523928E-01_JPRB, 0.481284E-01_JPRB, &
 & 0.442110E-01_JPRB, 0.406125E-01_JPRB, 0.373069E-01_JPRB, 0.342703E-01_JPRB, 0.314809E-01_JPRB /)  
SELFREF(:,10) = (/ &
 & 0.708308E-01_JPRB, 0.651419E-01_JPRB, 0.599099E-01_JPRB, 0.550981E-01_JPRB, 0.506728E-01_JPRB, &
 & 0.466030E-01_JPRB, 0.428600E-01_JPRB, 0.394176E-01_JPRB, 0.362517E-01_JPRB, 0.333401E-01_JPRB /)  
SELFREF(:,11) = (/ &
 & 0.698445E-01_JPRB, 0.646584E-01_JPRB, 0.598573E-01_JPRB, 0.554128E-01_JPRB, 0.512982E-01_JPRB, &
 & 0.474892E-01_JPRB, 0.439630E-01_JPRB, 0.406986E-01_JPRB, 0.376766E-01_JPRB, 0.348791E-01_JPRB /)  
SELFREF(:,12) = (/ &
 & 0.743921E-01_JPRB, 0.682057E-01_JPRB, 0.625337E-01_JPRB, 0.573334E-01_JPRB, 0.525655E-01_JPRB, &
 & 0.481942E-01_JPRB, 0.441863E-01_JPRB, 0.405118E-01_JPRB, 0.371428E-01_JPRB, 0.340540E-01_JPRB /)  
SELFREF(:,13) = (/ &
 & 0.775758E-01_JPRB, 0.709818E-01_JPRB, 0.649484E-01_JPRB, 0.594277E-01_JPRB, 0.543764E-01_JPRB, &
 & 0.497544E-01_JPRB, 0.455253E-01_JPRB, 0.416556E-01_JPRB, 0.381149E-01_JPRB, 0.348751E-01_JPRB /)  
SELFREF(:,14) = (/ &
 & 0.776545E-01_JPRB, 0.714761E-01_JPRB, 0.657894E-01_JPRB, 0.605550E-01_JPRB, 0.557372E-01_JPRB, &
 & 0.513026E-01_JPRB, 0.472209E-01_JPRB, 0.434639E-01_JPRB, 0.400058E-01_JPRB, 0.368229E-01_JPRB /)  
SELFREF(:,15) = (/ &
 & 0.855675E-01_JPRB, 0.787337E-01_JPRB, 0.724456E-01_JPRB, 0.666598E-01_JPRB, 0.613360E-01_JPRB, &
 & 0.564374E-01_JPRB, 0.519301E-01_JPRB, 0.477827E-01_JPRB, 0.439666E-01_JPRB, 0.404552E-01_JPRB /)  
SELFREF(:,16) = (/ &
 & 0.934781E-01_JPRB, 0.855190E-01_JPRB, 0.782376E-01_JPRB, 0.715761E-01_JPRB, 0.654819E-01_JPRB, &
 & 0.599065E-01_JPRB, 0.548058E-01_JPRB, 0.501394E-01_JPRB, 0.458704E-01_JPRB, 0.419648E-01_JPRB /)  
     
!     -----------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('SRTM_KGB20',1,ZHOOK_HANDLE)
END SUBROUTINE SRTM_KGB20

